// third_party/blink/public/mojom/payments/payment_handler_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  AddressErrors as payments_mojom_AddressErrors,
  AddressErrorsSpec as payments_mojom_AddressErrorsSpec,
  PaymentAddress as payments_mojom_PaymentAddress,
  PaymentAddressSpec as payments_mojom_PaymentAddressSpec,
  PaymentCurrencyAmount as payments_mojom_PaymentCurrencyAmount,
  PaymentCurrencyAmountSpec as payments_mojom_PaymentCurrencyAmountSpec
} from '../../../../../components/payments/mojom/payment_request_data.mojom.m.js';

import {
  PaymentShippingOption as payments_mojom_PaymentShippingOption,
  PaymentShippingOptionSpec as payments_mojom_PaymentShippingOptionSpec
} from './payment_request.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PaymentHandlerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'payments.mojom.PaymentHandlerHost', scope);
  }
}

/** @interface */
export class PaymentHandlerHostInterface {
  
  /**
   * @param { !PaymentHandlerMethodData } methodData
   * @return {!Promise<{
        responseData: !PaymentRequestDetailsUpdate,
   *  }>}
   */

  changePaymentMethod(methodData) {}
  
  /**
   * @param { !string } shippingOptionId
   * @return {!Promise<{
        responseData: !PaymentRequestDetailsUpdate,
   *  }>}
   */

  changeShippingOption(shippingOptionId) {}
  
  /**
   * @param { !payments_mojom_PaymentAddress } shippingAddress
   * @return {!Promise<{
        responseData: !PaymentRequestDetailsUpdate,
   *  }>}
   */

  changeShippingAddress(shippingAddress) {}
}

/**
 * @implements { PaymentHandlerHostInterface }
 */
export class PaymentHandlerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PaymentHandlerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PaymentHandlerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PaymentHandlerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PaymentHandlerMethodData } methodData
   * @return {!Promise<{
        responseData: !PaymentRequestDetailsUpdate,
   *  }>}
   */

  changePaymentMethod(
      methodData) {
    return this.proxy.sendMessage(
        0,
        PaymentHandlerHost_ChangePaymentMethod_ParamsSpec.$,
        PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec.$,
        [
          methodData
        ],
        false);
  }

  
  /**
   * @param { !string } shippingOptionId
   * @return {!Promise<{
        responseData: !PaymentRequestDetailsUpdate,
   *  }>}
   */

  changeShippingOption(
      shippingOptionId) {
    return this.proxy.sendMessage(
        1,
        PaymentHandlerHost_ChangeShippingOption_ParamsSpec.$,
        PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec.$,
        [
          shippingOptionId
        ],
        false);
  }

  
  /**
   * @param { !payments_mojom_PaymentAddress } shippingAddress
   * @return {!Promise<{
        responseData: !PaymentRequestDetailsUpdate,
   *  }>}
   */

  changeShippingAddress(
      shippingAddress) {
    return this.proxy.sendMessage(
        2,
        PaymentHandlerHost_ChangeShippingAddress_ParamsSpec.$,
        PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec.$,
        [
          shippingAddress
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PaymentHandlerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PaymentHandlerHostReceiver {
  /**
   * @param {!PaymentHandlerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PaymentHandlerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PaymentHandlerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentHandlerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PaymentHandlerHost_ChangePaymentMethod_ParamsSpec.$,
        PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec.$,
        impl.changePaymentMethod.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PaymentHandlerHost_ChangeShippingOption_ParamsSpec.$,
        PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec.$,
        impl.changeShippingOption.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PaymentHandlerHost_ChangeShippingAddress_ParamsSpec.$,
        PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec.$,
        impl.changeShippingAddress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PaymentHandlerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.PaymentHandlerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PaymentHandlerHostRemote}
   */
  static getRemote() {
    let remote = new PaymentHandlerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PaymentHandlerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PaymentHandlerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PaymentHandlerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PaymentHandlerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.changePaymentMethod =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PaymentHandlerHost_ChangePaymentMethod_ParamsSpec.$,
        PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec.$,
        this.changePaymentMethod.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.changeShippingOption =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PaymentHandlerHost_ChangeShippingOption_ParamsSpec.$,
        PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec.$,
        this.changeShippingOption.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.changeShippingAddress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PaymentHandlerHost_ChangeShippingAddress_ParamsSpec.$,
        PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec.$,
        this.changeShippingAddress.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerMethodDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerModifierSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentRequestDetailsUpdateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerHost_ChangePaymentMethod_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerHost_ChangeShippingOption_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerHost_ChangeShippingAddress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PaymentHandlerMethodDataSpec.$,
    'PaymentHandlerMethodData',
    [
      mojo.internal.StructField(
        'methodName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringifiedData', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentHandlerMethodData {
  constructor() {
    /** @type { !string } */
    this.methodName;
    /** @type { (string|undefined) } */
    this.stringifiedData;
  }
}



mojo.internal.Struct(
    PaymentHandlerModifierSpec.$,
    'PaymentHandlerModifier',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        payments_mojom_PaymentCurrencyAmountSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'methodData', 8,
        0,
        PaymentHandlerMethodDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PaymentHandlerModifier {
  constructor() {
    /** @type { (payments_mojom_PaymentCurrencyAmount|undefined) } */
    this.total;
    /** @type { !PaymentHandlerMethodData } */
    this.methodData;
  }
}



mojo.internal.Struct(
    PaymentRequestDetailsUpdateSpec.$,
    'PaymentRequestDetailsUpdate',
    [
      mojo.internal.StructField(
        'total', 0,
        0,
        payments_mojom_PaymentCurrencyAmountSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingOptions', 8,
        0,
        mojo.internal.Array(payments_mojom_PaymentShippingOptionSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifiers', 16,
        0,
        mojo.internal.Array(PaymentHandlerModifierSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 24,
        0,
        mojo.internal.String,
        "",
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringifiedPaymentMethodErrors', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shippingAddressErrors', 40,
        0,
        payments_mojom_AddressErrorsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class PaymentRequestDetailsUpdate {
  constructor() {
    /** @type { (payments_mojom_PaymentCurrencyAmount|undefined) } */
    this.total;
    /** @type { (Array<!payments_mojom_PaymentShippingOption>|undefined) } */
    this.shippingOptions;
    /** @type { (Array<!PaymentHandlerModifier>|undefined) } */
    this.modifiers;
    /** @type { !string } */
    this.error;
    /** @type { (string|undefined) } */
    this.stringifiedPaymentMethodErrors;
    /** @type { (payments_mojom_AddressErrors|undefined) } */
    this.shippingAddressErrors;
  }
}



mojo.internal.Struct(
    PaymentHandlerHost_ChangePaymentMethod_ParamsSpec.$,
    'PaymentHandlerHost_ChangePaymentMethod_Params',
    [
      mojo.internal.StructField(
        'methodData', 0,
        0,
        PaymentHandlerMethodDataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerHost_ChangePaymentMethod_Params {
  constructor() {
    /** @type { !PaymentHandlerMethodData } */
    this.methodData;
  }
}



mojo.internal.Struct(
    PaymentHandlerHost_ChangePaymentMethod_ResponseParamsSpec.$,
    'PaymentHandlerHost_ChangePaymentMethod_ResponseParams',
    [
      mojo.internal.StructField(
        'responseData', 0,
        0,
        PaymentRequestDetailsUpdateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerHost_ChangePaymentMethod_ResponseParams {
  constructor() {
    /** @type { !PaymentRequestDetailsUpdate } */
    this.responseData;
  }
}



mojo.internal.Struct(
    PaymentHandlerHost_ChangeShippingOption_ParamsSpec.$,
    'PaymentHandlerHost_ChangeShippingOption_Params',
    [
      mojo.internal.StructField(
        'shippingOptionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerHost_ChangeShippingOption_Params {
  constructor() {
    /** @type { !string } */
    this.shippingOptionId;
  }
}



mojo.internal.Struct(
    PaymentHandlerHost_ChangeShippingOption_ResponseParamsSpec.$,
    'PaymentHandlerHost_ChangeShippingOption_ResponseParams',
    [
      mojo.internal.StructField(
        'responseData', 0,
        0,
        PaymentRequestDetailsUpdateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerHost_ChangeShippingOption_ResponseParams {
  constructor() {
    /** @type { !PaymentRequestDetailsUpdate } */
    this.responseData;
  }
}



mojo.internal.Struct(
    PaymentHandlerHost_ChangeShippingAddress_ParamsSpec.$,
    'PaymentHandlerHost_ChangeShippingAddress_Params',
    [
      mojo.internal.StructField(
        'shippingAddress', 0,
        0,
        payments_mojom_PaymentAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerHost_ChangeShippingAddress_Params {
  constructor() {
    /** @type { !payments_mojom_PaymentAddress } */
    this.shippingAddress;
  }
}



mojo.internal.Struct(
    PaymentHandlerHost_ChangeShippingAddress_ResponseParamsSpec.$,
    'PaymentHandlerHost_ChangeShippingAddress_ResponseParams',
    [
      mojo.internal.StructField(
        'responseData', 0,
        0,
        PaymentRequestDetailsUpdateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PaymentHandlerHost_ChangeShippingAddress_ResponseParams {
  constructor() {
    /** @type { !PaymentRequestDetailsUpdate } */
    this.responseData;
  }
}

