// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');




/**
 * @const { !number }
 * @export
 */
blink.mojom.SPEED_LIMIT_MAX = 100;


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.DeviceThermalStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.DeviceThermalState = {
  
  kUnknown: 0,
  kNominal: 1,
  kFair: 2,
  kSerious: 3,
  kCritical: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PeerConnectionManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PeerConnectionManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PeerConnectionManagerInterface }
 */
blink.mojom.PeerConnectionManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PeerConnectionManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PeerConnectionManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PeerConnectionManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onSuspend() {
    this.proxy.sendMessage(
        0,
        blink.mojom.PeerConnectionManager_OnSuspend_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DeviceThermalState } thermalState
   */

  onThermalStateChange(
      thermalState) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PeerConnectionManager_OnThermalStateChange_ParamsSpec.$,
        null,
        [
          thermalState
        ],
        false);
  }

  
  /**
   * @param { !number } peerConnectionLocalId
   * @param { !number } outputPeriodMs
   */

  startEventLog(
      peerConnectionLocalId,
      outputPeriodMs) {
    this.proxy.sendMessage(
        2,
        blink.mojom.PeerConnectionManager_StartEventLog_ParamsSpec.$,
        null,
        [
          peerConnectionLocalId,
          outputPeriodMs
        ],
        false);
  }

  
  /**
   * @param { !number } peerConnectionLocalId
   */

  stopEventLog(
      peerConnectionLocalId) {
    this.proxy.sendMessage(
        3,
        blink.mojom.PeerConnectionManager_StopEventLog_ParamsSpec.$,
        null,
        [
          peerConnectionLocalId
        ],
        false);
  }

  
  /**
   * @param { !number } peerConnectionLocalId
   */

  startDataChannelLog(
      peerConnectionLocalId) {
    this.proxy.sendMessage(
        4,
        blink.mojom.PeerConnectionManager_StartDataChannelLog_ParamsSpec.$,
        null,
        [
          peerConnectionLocalId
        ],
        false);
  }

  
  /**
   * @param { !number } peerConnectionLocalId
   */

  stopDataChannelLog(
      peerConnectionLocalId) {
    this.proxy.sendMessage(
        5,
        blink.mojom.PeerConnectionManager_StopDataChannelLog_ParamsSpec.$,
        null,
        [
          peerConnectionLocalId
        ],
        false);
  }

  
  /**
   */

  getStandardStats() {
    this.proxy.sendMessage(
        6,
        blink.mojom.PeerConnectionManager_GetStandardStats_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  getCurrentState() {
    this.proxy.sendMessage(
        7,
        blink.mojom.PeerConnectionManager_GetCurrentState_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PeerConnectionManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PeerConnectionManagerReceiver = class {
  /**
   * @param {!blink.mojom.PeerConnectionManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PeerConnectionManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PeerConnectionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PeerConnectionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PeerConnectionManager_OnSuspend_ParamsSpec.$,
        null,
        impl.onSuspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PeerConnectionManager_OnThermalStateChange_ParamsSpec.$,
        null,
        impl.onThermalStateChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PeerConnectionManager_StartEventLog_ParamsSpec.$,
        null,
        impl.startEventLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PeerConnectionManager_StopEventLog_ParamsSpec.$,
        null,
        impl.stopEventLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PeerConnectionManager_StartDataChannelLog_ParamsSpec.$,
        null,
        impl.startDataChannelLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PeerConnectionManager_StopDataChannelLog_ParamsSpec.$,
        null,
        impl.stopDataChannelLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PeerConnectionManager_GetStandardStats_ParamsSpec.$,
        null,
        impl.getStandardStats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PeerConnectionManager_GetCurrentState_ParamsSpec.$,
        null,
        impl.getCurrentState.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PeerConnectionManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PeerConnectionManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PeerConnectionManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PeerConnectionManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PeerConnectionManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PeerConnectionManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PeerConnectionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PeerConnectionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSuspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PeerConnectionManager_OnSuspend_ParamsSpec.$,
        null,
        this.onSuspend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onThermalStateChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PeerConnectionManager_OnThermalStateChange_ParamsSpec.$,
        null,
        this.onThermalStateChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startEventLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PeerConnectionManager_StartEventLog_ParamsSpec.$,
        null,
        this.startEventLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopEventLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PeerConnectionManager_StopEventLog_ParamsSpec.$,
        null,
        this.stopEventLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startDataChannelLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PeerConnectionManager_StartDataChannelLog_ParamsSpec.$,
        null,
        this.startDataChannelLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopDataChannelLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PeerConnectionManager_StopDataChannelLog_ParamsSpec.$,
        null,
        this.stopDataChannelLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStandardStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PeerConnectionManager_GetStandardStats_ParamsSpec.$,
        null,
        this.getStandardStats.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCurrentState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PeerConnectionManager_GetCurrentState_ParamsSpec.$,
        null,
        this.getCurrentState.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PeerConnectionTrackerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PeerConnectionTrackerHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PeerConnectionTrackerHostInterface }
 */
blink.mojom.PeerConnectionTrackerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PeerConnectionTrackerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PeerConnectionTrackerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PeerConnectionTrackerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.PeerConnectionInfo } info
   */

  addPeerConnection(
      info) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   */

  removePeerConnection(
      lid) {
    this.proxy.sendMessage(
        1,
        blink.mojom.PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec.$,
        null,
        [
          lid
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !string } type
   * @param { !string } value
   */

  updatePeerConnection(
      lid,
      type,
      value) {
    this.proxy.sendMessage(
        2,
        blink.mojom.PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec.$,
        null,
        [
          lid,
          type,
          value
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !string } sessionId
   */

  onPeerConnectionSessionIdSet(
      lid,
      sessionId) {
    this.proxy.sendMessage(
        3,
        blink.mojom.PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec.$,
        null,
        [
          lid,
          sessionId
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !boolean } audio
   * @param { !boolean } video
   * @param { !string } audioConstraints
   * @param { !string } videoConstraints
   */

  getUserMedia(
      requestId,
      audio,
      video,
      audioConstraints,
      videoConstraints) {
    this.proxy.sendMessage(
        4,
        blink.mojom.PeerConnectionTrackerHost_GetUserMedia_ParamsSpec.$,
        null,
        [
          requestId,
          audio,
          video,
          audioConstraints,
          videoConstraints
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } streamId
   * @param { !string } audioTrackInfo
   * @param { !string } videoTrackInfo
   */

  getUserMediaSuccess(
      requestId,
      streamId,
      audioTrackInfo,
      videoTrackInfo) {
    this.proxy.sendMessage(
        5,
        blink.mojom.PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec.$,
        null,
        [
          requestId,
          streamId,
          audioTrackInfo,
          videoTrackInfo
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } error
   * @param { !string } errorMessage
   */

  getUserMediaFailure(
      requestId,
      error,
      errorMessage) {
    this.proxy.sendMessage(
        6,
        blink.mojom.PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec.$,
        null,
        [
          requestId,
          error,
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !boolean } audio
   * @param { !boolean } video
   * @param { !string } audioConstraints
   * @param { !string } videoConstraints
   */

  getDisplayMedia(
      requestId,
      audio,
      video,
      audioConstraints,
      videoConstraints) {
    this.proxy.sendMessage(
        7,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec.$,
        null,
        [
          requestId,
          audio,
          video,
          audioConstraints,
          videoConstraints
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } streamId
   * @param { !string } audioTrackInfo
   * @param { !string } videoTrackInfo
   */

  getDisplayMediaSuccess(
      requestId,
      streamId,
      audioTrackInfo,
      videoTrackInfo) {
    this.proxy.sendMessage(
        8,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec.$,
        null,
        [
          requestId,
          streamId,
          audioTrackInfo,
          videoTrackInfo
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } error
   * @param { !string } errorMessage
   */

  getDisplayMediaFailure(
      requestId,
      error,
      errorMessage) {
    this.proxy.sendMessage(
        9,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec.$,
        null,
        [
          requestId,
          error,
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !Array<!number> } output
   */

  webRtcEventLogWrite(
      lid,
      output) {
    this.proxy.sendMessage(
        10,
        blink.mojom.PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec.$,
        null,
        [
          lid,
          output
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !Array<!number> } output
   */

  webRtcDataChannelLogWrite(
      lid,
      output) {
    this.proxy.sendMessage(
        11,
        blink.mojom.PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec.$,
        null,
        [
          lid,
          output
        ],
        false);
  }

  
  /**
   * @param { !number } lid
   * @param { !mojoBase.mojom.ListValue } value
   */

  addStandardStats(
      lid,
      value) {
    this.proxy.sendMessage(
        12,
        blink.mojom.PeerConnectionTrackerHost_AddStandardStats_ParamsSpec.$,
        null,
        [
          lid,
          value
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PeerConnectionTrackerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PeerConnectionTrackerHostReceiver = class {
  /**
   * @param {!blink.mojom.PeerConnectionTrackerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PeerConnectionTrackerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PeerConnectionTrackerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PeerConnectionTrackerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec.$,
        null,
        impl.addPeerConnection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec.$,
        null,
        impl.removePeerConnection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec.$,
        null,
        impl.updatePeerConnection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec.$,
        null,
        impl.onPeerConnectionSessionIdSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PeerConnectionTrackerHost_GetUserMedia_ParamsSpec.$,
        null,
        impl.getUserMedia.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec.$,
        null,
        impl.getUserMediaSuccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec.$,
        null,
        impl.getUserMediaFailure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec.$,
        null,
        impl.getDisplayMedia.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec.$,
        null,
        impl.getDisplayMediaSuccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec.$,
        null,
        impl.getDisplayMediaFailure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec.$,
        null,
        impl.webRtcEventLogWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec.$,
        null,
        impl.webRtcDataChannelLogWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.PeerConnectionTrackerHost_AddStandardStats_ParamsSpec.$,
        null,
        impl.addStandardStats.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PeerConnectionTrackerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PeerConnectionTrackerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PeerConnectionTrackerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PeerConnectionTrackerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PeerConnectionTrackerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PeerConnectionTrackerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PeerConnectionTrackerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PeerConnectionTrackerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPeerConnection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec.$,
        null,
        this.addPeerConnection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removePeerConnection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec.$,
        null,
        this.removePeerConnection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updatePeerConnection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec.$,
        null,
        this.updatePeerConnection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPeerConnectionSessionIdSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec.$,
        null,
        this.onPeerConnectionSessionIdSet.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUserMedia =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.PeerConnectionTrackerHost_GetUserMedia_ParamsSpec.$,
        null,
        this.getUserMedia.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUserMediaSuccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec.$,
        null,
        this.getUserMediaSuccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUserMediaFailure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec.$,
        null,
        this.getUserMediaFailure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDisplayMedia =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec.$,
        null,
        this.getDisplayMedia.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDisplayMediaSuccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec.$,
        null,
        this.getDisplayMediaSuccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDisplayMediaFailure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec.$,
        null,
        this.getDisplayMediaFailure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.webRtcEventLogWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec.$,
        null,
        this.webRtcEventLogWrite.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.webRtcDataChannelLogWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec.$,
        null,
        this.webRtcDataChannelLogWrite.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addStandardStats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.PeerConnectionTrackerHost_AddStandardStats_ParamsSpec.$,
        null,
        this.addStandardStats.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionManager_OnSuspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionManager_OnThermalStateChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionManager_StartEventLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionManager_StopEventLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionManager_StartDataChannelLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionManager_StopDataChannelLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionManager_GetStandardStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionManager_GetCurrentState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_GetUserMedia_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PeerConnectionTrackerHost_AddStandardStats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.PeerConnectionInfoSpec.$,
    'PeerConnectionInfo',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rtcConfiguration', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PeerConnectionInfo = class {
  constructor() {
    /** @export { !number } */
    this.lid;
    /** @export { !string } */
    this.rtcConfiguration;
    /** @export { (string|undefined) } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionManager_OnSuspend_ParamsSpec.$,
    'PeerConnectionManager_OnSuspend_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.PeerConnectionManager_OnSuspend_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionManager_OnThermalStateChange_ParamsSpec.$,
    'PeerConnectionManager_OnThermalStateChange_Params',
    [
      mojo.internal.StructField(
        'thermalState', 0,
        0,
        blink.mojom.DeviceThermalStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PeerConnectionManager_OnThermalStateChange_Params = class {
  constructor() {
    /** @export { !blink.mojom.DeviceThermalState } */
    this.thermalState;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionManager_StartEventLog_ParamsSpec.$,
    'PeerConnectionManager_StartEventLog_Params',
    [
      mojo.internal.StructField(
        'peerConnectionLocalId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputPeriodMs', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PeerConnectionManager_StartEventLog_Params = class {
  constructor() {
    /** @export { !number } */
    this.peerConnectionLocalId;
    /** @export { !number } */
    this.outputPeriodMs;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionManager_StopEventLog_ParamsSpec.$,
    'PeerConnectionManager_StopEventLog_Params',
    [
      mojo.internal.StructField(
        'peerConnectionLocalId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PeerConnectionManager_StopEventLog_Params = class {
  constructor() {
    /** @export { !number } */
    this.peerConnectionLocalId;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionManager_StartDataChannelLog_ParamsSpec.$,
    'PeerConnectionManager_StartDataChannelLog_Params',
    [
      mojo.internal.StructField(
        'peerConnectionLocalId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PeerConnectionManager_StartDataChannelLog_Params = class {
  constructor() {
    /** @export { !number } */
    this.peerConnectionLocalId;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionManager_StopDataChannelLog_ParamsSpec.$,
    'PeerConnectionManager_StopDataChannelLog_Params',
    [
      mojo.internal.StructField(
        'peerConnectionLocalId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PeerConnectionManager_StopDataChannelLog_Params = class {
  constructor() {
    /** @export { !number } */
    this.peerConnectionLocalId;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionManager_GetStandardStats_ParamsSpec.$,
    'PeerConnectionManager_GetStandardStats_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.PeerConnectionManager_GetStandardStats_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionManager_GetCurrentState_ParamsSpec.$,
    'PeerConnectionManager_GetCurrentState_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.PeerConnectionManager_GetCurrentState_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_AddPeerConnection_ParamsSpec.$,
    'PeerConnectionTrackerHost_AddPeerConnection_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        blink.mojom.PeerConnectionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_AddPeerConnection_Params = class {
  constructor() {
    /** @export { !blink.mojom.PeerConnectionInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_RemovePeerConnection_ParamsSpec.$,
    'PeerConnectionTrackerHost_RemovePeerConnection_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_RemovePeerConnection_Params = class {
  constructor() {
    /** @export { !number } */
    this.lid;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_UpdatePeerConnection_ParamsSpec.$,
    'PeerConnectionTrackerHost_UpdatePeerConnection_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_UpdatePeerConnection_Params = class {
  constructor() {
    /** @export { !number } */
    this.lid;
    /** @export { !string } */
    this.type;
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsSpec.$,
    'PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params = class {
  constructor() {
    /** @export { !number } */
    this.lid;
    /** @export { !string } */
    this.sessionId;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_GetUserMedia_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetUserMedia_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audio', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'video', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioConstraints', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoConstraints', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_GetUserMedia_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !boolean } */
    this.audio;
    /** @export { !boolean } */
    this.video;
    /** @export { !string } */
    this.audioConstraints;
    /** @export { !string } */
    this.videoConstraints;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetUserMediaSuccess_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioTrackInfo', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoTrackInfo', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_GetUserMediaSuccess_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !string } */
    this.streamId;
    /** @export { !string } */
    this.audioTrackInfo;
    /** @export { !string } */
    this.videoTrackInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_GetUserMediaFailure_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetUserMediaFailure_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_GetUserMediaFailure_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !string } */
    this.error;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_GetDisplayMedia_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetDisplayMedia_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audio', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'video', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioConstraints', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoConstraints', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_GetDisplayMedia_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !boolean } */
    this.audio;
    /** @export { !boolean } */
    this.video;
    /** @export { !string } */
    this.audioConstraints;
    /** @export { !string } */
    this.videoConstraints;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'streamId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioTrackInfo', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'videoTrackInfo', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !string } */
    this.streamId;
    /** @export { !string } */
    this.audioTrackInfo;
    /** @export { !string } */
    this.videoTrackInfo;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsSpec.$,
    'PeerConnectionTrackerHost_GetDisplayMediaFailure_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_GetDisplayMediaFailure_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !string } */
    this.error;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsSpec.$,
    'PeerConnectionTrackerHost_WebRtcEventLogWrite_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'output', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_WebRtcEventLogWrite_Params = class {
  constructor() {
    /** @export { !number } */
    this.lid;
    /** @export { !Array<!number> } */
    this.output;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsSpec.$,
    'PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'output', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params = class {
  constructor() {
    /** @export { !number } */
    this.lid;
    /** @export { !Array<!number> } */
    this.output;
  }
};



mojo.internal.Struct(
    blink.mojom.PeerConnectionTrackerHost_AddStandardStats_ParamsSpec.$,
    'PeerConnectionTrackerHost_AddStandardStats_Params',
    [
      mojo.internal.StructField(
        'lid', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojoBase.mojom.ListValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.PeerConnectionTrackerHost_AddStandardStats_Params = class {
  constructor() {
    /** @export { !number } */
    this.lid;
    /** @export { !mojoBase.mojom.ListValue } */
    this.value;
  }
};

