// third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var content_settings$ =
      mojo.internal.exposeNamespace('contentSettings.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/content_settings/core/common/content_settings.mojom', '../../../../../components/content_settings/core/common/content_settings.mojom.js');
  }
  var webrtc_ip_handling_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_policy.mojom', 'webrtc_ip_handling_policy.mojom.js');
  }



  function WebRtcIpHandlingUrlEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebRtcIpHandlingUrlEntry.prototype.initDefaults_ = function() {
    this.urlPattern = null;
    this.handling = 0;
  };
  WebRtcIpHandlingUrlEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebRtcIpHandlingUrlEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebRtcIpHandlingUrlEntry.urlPattern
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, content_settings$.ContentSettingsPattern, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebRtcIpHandlingUrlEntry.handling
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, webrtc_ip_handling_policy$.WebRtcIpHandlingPolicy);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebRtcIpHandlingUrlEntry.encodedSize = codec.kStructHeaderSize + 16;

  WebRtcIpHandlingUrlEntry.decode = function(decoder) {
    var packed;
    var val = new WebRtcIpHandlingUrlEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.urlPattern =
        decoder.decodeStructPointer(content_settings$.ContentSettingsPattern);
    val.handling =
        decoder.decodeStruct(new codec.Enum(webrtc_ip_handling_policy$.WebRtcIpHandlingPolicy));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebRtcIpHandlingUrlEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebRtcIpHandlingUrlEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(content_settings$.ContentSettingsPattern, val.urlPattern);
    encoder.encodeStruct(codec.Int32, val.handling);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.WebRtcIpHandlingUrlEntry = WebRtcIpHandlingUrlEntry;
})();