// third_party/blink/public/mojom/persistent_renderer_prefs.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/persistent_renderer_prefs.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function PersistentRendererPrefsService_SetViewSourceLineWrapping_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PersistentRendererPrefsService_SetViewSourceLineWrapping_Params.prototype.initDefaults_ = function() {
    this.value = false;
  };
  PersistentRendererPrefsService_SetViewSourceLineWrapping_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PersistentRendererPrefsService_SetViewSourceLineWrapping_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PersistentRendererPrefsService_SetViewSourceLineWrapping_Params.encodedSize = codec.kStructHeaderSize + 8;

  PersistentRendererPrefsService_SetViewSourceLineWrapping_Params.decode = function(decoder) {
    var packed;
    var val = new PersistentRendererPrefsService_SetViewSourceLineWrapping_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PersistentRendererPrefsService_SetViewSourceLineWrapping_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PersistentRendererPrefsService_SetViewSourceLineWrapping_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kPersistentRendererPrefsService_SetViewSourceLineWrapping_Name = 0;

  function PersistentRendererPrefsServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PersistentRendererPrefsService,
                                                   handleOrPtrInfo);
  }

  function PersistentRendererPrefsServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PersistentRendererPrefsService, associatedInterfacePtrInfo);
  }

  PersistentRendererPrefsServiceAssociatedPtr.prototype =
      Object.create(PersistentRendererPrefsServicePtr.prototype);
  PersistentRendererPrefsServiceAssociatedPtr.prototype.constructor =
      PersistentRendererPrefsServiceAssociatedPtr;

  function PersistentRendererPrefsServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  PersistentRendererPrefsServicePtr.prototype.setViewSourceLineWrapping = function() {
    return PersistentRendererPrefsServiceProxy.prototype.setViewSourceLineWrapping
        .apply(this.ptr.getProxy(), arguments);
  };

  PersistentRendererPrefsServiceProxy.prototype.setViewSourceLineWrapping = function(value) {
    var params_ = new PersistentRendererPrefsService_SetViewSourceLineWrapping_Params();
    params_.value = value;
    var builder = new codec.MessageV0Builder(
        kPersistentRendererPrefsService_SetViewSourceLineWrapping_Name,
        codec.align(PersistentRendererPrefsService_SetViewSourceLineWrapping_Params.encodedSize));
    builder.encodeStruct(PersistentRendererPrefsService_SetViewSourceLineWrapping_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PersistentRendererPrefsServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  PersistentRendererPrefsServiceStub.prototype.setViewSourceLineWrapping = function(value) {
    return this.delegate_ && this.delegate_.setViewSourceLineWrapping && this.delegate_.setViewSourceLineWrapping(value);
  }

  PersistentRendererPrefsServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPersistentRendererPrefsService_SetViewSourceLineWrapping_Name:
      var params = reader.decodeStruct(PersistentRendererPrefsService_SetViewSourceLineWrapping_Params);
      this.setViewSourceLineWrapping(params.value);
      return true;
    default:
      return false;
    }
  };

  PersistentRendererPrefsServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePersistentRendererPrefsServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPersistentRendererPrefsService_SetViewSourceLineWrapping_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PersistentRendererPrefsService_SetViewSourceLineWrapping_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePersistentRendererPrefsServiceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PersistentRendererPrefsService = {
    name: 'blink.mojom.PersistentRendererPrefsService',
    kVersion: 0,
    ptrClass: PersistentRendererPrefsServicePtr,
    proxyClass: PersistentRendererPrefsServiceProxy,
    stubClass: PersistentRendererPrefsServiceStub,
    validateRequest: validatePersistentRendererPrefsServiceRequest,
    validateResponse: null,
  };
  PersistentRendererPrefsServiceStub.prototype.validator = validatePersistentRendererPrefsServiceRequest;
  PersistentRendererPrefsServiceProxy.prototype.validator = null;
  exports.PersistentRendererPrefsService = PersistentRendererPrefsService;
  exports.PersistentRendererPrefsServicePtr = PersistentRendererPrefsServicePtr;
  exports.PersistentRendererPrefsServiceAssociatedPtr = PersistentRendererPrefsServiceAssociatedPtr;
})();