// third_party/blink/public/mojom/push_messaging/push_messaging.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  PushGetRegistrationStatus as blink_mojom_PushGetRegistrationStatus,
  PushGetRegistrationStatusSpec as blink_mojom_PushGetRegistrationStatusSpec,
  PushRegistrationStatus as blink_mojom_PushRegistrationStatus,
  PushRegistrationStatusSpec as blink_mojom_PushRegistrationStatusSpec
} from './push_messaging_status.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PushErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PushErrorType = {
  
  ABORT: 0,
  NETWORK: 1,
  NONE: 2,
  NOT_ALLOWED: 3,
  NOT_FOUND: 4,
  NOT_SUPPORTED: 5,
  INVALID_STATE: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PushMessagingPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PushMessaging', scope);
  }
}

/** @interface */
export class PushMessagingInterface {
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !PushSubscriptionOptions } options
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink_mojom_PushRegistrationStatus,
        subscription: ?PushSubscription,
   *  }>}
   */

  subscribe(serviceWorkerRegistrationId, options, userGesture) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        errorType: !PushErrorType,
        didUnsubscribe: !boolean,
        errorMessage: ?string,
   *  }>}
   */

  unsubscribe(serviceWorkerRegistrationId) {}
  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        status: !blink_mojom_PushGetRegistrationStatus,
        subscription: ?PushSubscription,
   *  }>}
   */

  getSubscription(serviceWorkerRegistrationId) {}
}

/**
 * @implements { PushMessagingInterface }
 */
export class PushMessagingRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PushMessagingPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PushMessagingPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PushMessagingPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !PushSubscriptionOptions } options
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink_mojom_PushRegistrationStatus,
        subscription: ?PushSubscription,
   *  }>}
   */

  subscribe(
      serviceWorkerRegistrationId,
      options,
      userGesture) {
    return this.proxy.sendMessage(
        0,
        PushMessaging_Subscribe_ParamsSpec.$,
        PushMessaging_Subscribe_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          options,
          userGesture
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        errorType: !PushErrorType,
        didUnsubscribe: !boolean,
        errorMessage: ?string,
   *  }>}
   */

  unsubscribe(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        1,
        PushMessaging_Unsubscribe_ParamsSpec.$,
        PushMessaging_Unsubscribe_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        status: !blink_mojom_PushGetRegistrationStatus,
        subscription: ?PushSubscription,
   *  }>}
   */

  getSubscription(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        2,
        PushMessaging_GetSubscription_ParamsSpec.$,
        PushMessaging_GetSubscription_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PushMessaging
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PushMessagingReceiver {
  /**
   * @param {!PushMessagingInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PushMessagingRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PushMessagingRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PushMessagingRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PushMessaging_Subscribe_ParamsSpec.$,
        PushMessaging_Subscribe_ResponseParamsSpec.$,
        impl.subscribe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PushMessaging_Unsubscribe_ParamsSpec.$,
        PushMessaging_Unsubscribe_ResponseParamsSpec.$,
        impl.unsubscribe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PushMessaging_GetSubscription_ParamsSpec.$,
        PushMessaging_GetSubscription_ResponseParamsSpec.$,
        impl.getSubscription.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PushMessaging {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PushMessaging";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PushMessagingRemote}
   */
  static getRemote() {
    let remote = new PushMessagingRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PushMessaging
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PushMessagingCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PushMessagingRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PushMessagingRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.subscribe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PushMessaging_Subscribe_ParamsSpec.$,
        PushMessaging_Subscribe_ResponseParamsSpec.$,
        this.subscribe.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unsubscribe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PushMessaging_Unsubscribe_ParamsSpec.$,
        PushMessaging_Unsubscribe_ResponseParamsSpec.$,
        this.unsubscribe.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSubscription =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PushMessaging_GetSubscription_ParamsSpec.$,
        PushMessaging_GetSubscription_ResponseParamsSpec.$,
        this.getSubscription.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PushSubscriptionOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PushSubscriptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PushMessaging_Subscribe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PushMessaging_Subscribe_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PushMessaging_Unsubscribe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PushMessaging_Unsubscribe_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PushMessaging_GetSubscription_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PushMessaging_GetSubscription_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PushSubscriptionOptionsSpec.$,
    'PushSubscriptionOptions',
    [
      mojo.internal.StructField(
        'userVisibleOnly', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'applicationServerKey', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PushSubscriptionOptions {
  constructor() {
    /** @type { !boolean } */
    this.userVisibleOnly;
    /** @type { !Array<!number> } */
    this.applicationServerKey;
  }
}



mojo.internal.Struct(
    PushSubscriptionSpec.$,
    'PushSubscription',
    [
      mojo.internal.StructField(
        'endpoint', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expirationTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        PushSubscriptionOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'p256dh', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auth', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class PushSubscription {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.endpoint;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.expirationTime;
    /** @type { !PushSubscriptionOptions } */
    this.options;
    /** @type { !Array<!number> } */
    this.p256dh;
    /** @type { !Array<!number> } */
    this.auth;
  }
}



mojo.internal.Struct(
    PushMessaging_Subscribe_ParamsSpec.$,
    'PushMessaging_Subscribe_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        PushSubscriptionOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userGesture', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PushMessaging_Subscribe_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @type { !PushSubscriptionOptions } */
    this.options;
    /** @type { !boolean } */
    this.userGesture;
  }
}



mojo.internal.Struct(
    PushMessaging_Subscribe_ResponseParamsSpec.$,
    'PushMessaging_Subscribe_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PushRegistrationStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subscription', 8,
        0,
        PushSubscriptionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PushMessaging_Subscribe_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PushRegistrationStatus } */
    this.status;
    /** @type { (PushSubscription|undefined) } */
    this.subscription;
  }
}



mojo.internal.Struct(
    PushMessaging_Unsubscribe_ParamsSpec.$,
    'PushMessaging_Unsubscribe_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PushMessaging_Unsubscribe_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    PushMessaging_Unsubscribe_ResponseParamsSpec.$,
    'PushMessaging_Unsubscribe_ResponseParams',
    [
      mojo.internal.StructField(
        'errorType', 0,
        0,
        PushErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'didUnsubscribe', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PushMessaging_Unsubscribe_ResponseParams {
  constructor() {
    /** @type { !PushErrorType } */
    this.errorType;
    /** @type { !boolean } */
    this.didUnsubscribe;
    /** @type { (string|undefined) } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    PushMessaging_GetSubscription_ParamsSpec.$,
    'PushMessaging_GetSubscription_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PushMessaging_GetSubscription_Params {
  constructor() {
    /** @type { !bigint } */
    this.serviceWorkerRegistrationId;
  }
}



mojo.internal.Struct(
    PushMessaging_GetSubscription_ResponseParamsSpec.$,
    'PushMessaging_GetSubscription_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PushGetRegistrationStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'subscription', 8,
        0,
        PushSubscriptionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PushMessaging_GetSubscription_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PushGetRegistrationStatus } */
    this.status;
    /** @type { (PushSubscription|undefined) } */
    this.subscription;
  }
}

