// third_party/blink/public/mojom/quota/quota_manager_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/quota/quota_manager_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var quota_types$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/quota/quota_types.mojom', 'quota_types.mojom.js');
  }



  function QuotaManagerHost_QueryStorageUsageAndQuota_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  QuotaManagerHost_QueryStorageUsageAndQuota_Params.prototype.initDefaults_ = function() {
  };
  QuotaManagerHost_QueryStorageUsageAndQuota_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  QuotaManagerHost_QueryStorageUsageAndQuota_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  QuotaManagerHost_QueryStorageUsageAndQuota_Params.encodedSize = codec.kStructHeaderSize + 0;

  QuotaManagerHost_QueryStorageUsageAndQuota_Params.decode = function(decoder) {
    var packed;
    var val = new QuotaManagerHost_QueryStorageUsageAndQuota_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  QuotaManagerHost_QueryStorageUsageAndQuota_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(QuotaManagerHost_QueryStorageUsageAndQuota_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.prototype.initDefaults_ = function() {
    this.error = 0;
    this.currentUsage = 0;
    this.currentQuota = 0;
    this.usageBreakdown = null;
  };
  QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, quota_types$.QuotaStatusCode);
    if (err !== validator.validationError.NONE)
        return err;




    // validate QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.usageBreakdown
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, quota_types$.UsageBreakdown, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(new codec.Enum(quota_types$.QuotaStatusCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.currentUsage =
        decoder.decodeStruct(codec.Int64);
    val.currentQuota =
        decoder.decodeStruct(codec.Int64);
    val.usageBreakdown =
        decoder.decodeStructPointer(quota_types$.UsageBreakdown);
    return val;
  };

  QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int64, val.currentUsage);
    encoder.encodeStruct(codec.Int64, val.currentQuota);
    encoder.encodeStructPointer(quota_types$.UsageBreakdown, val.usageBreakdown);
  };
  var kQuotaManagerHost_QueryStorageUsageAndQuota_Name = 0;

  function QuotaManagerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(QuotaManagerHost,
                                                   handleOrPtrInfo);
  }

  function QuotaManagerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        QuotaManagerHost, associatedInterfacePtrInfo);
  }

  QuotaManagerHostAssociatedPtr.prototype =
      Object.create(QuotaManagerHostPtr.prototype);
  QuotaManagerHostAssociatedPtr.prototype.constructor =
      QuotaManagerHostAssociatedPtr;

  function QuotaManagerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  QuotaManagerHostPtr.prototype.queryStorageUsageAndQuota = function() {
    return QuotaManagerHostProxy.prototype.queryStorageUsageAndQuota
        .apply(this.ptr.getProxy(), arguments);
  };

  QuotaManagerHostProxy.prototype.queryStorageUsageAndQuota = function() {
    var params_ = new QuotaManagerHost_QueryStorageUsageAndQuota_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kQuotaManagerHost_QueryStorageUsageAndQuota_Name,
          codec.align(QuotaManagerHost_QueryStorageUsageAndQuota_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(QuotaManagerHost_QueryStorageUsageAndQuota_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function QuotaManagerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  QuotaManagerHostStub.prototype.queryStorageUsageAndQuota = function() {
    return this.delegate_ && this.delegate_.queryStorageUsageAndQuota && this.delegate_.queryStorageUsageAndQuota();
  }

  QuotaManagerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  QuotaManagerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kQuotaManagerHost_QueryStorageUsageAndQuota_Name:
      var params = reader.decodeStruct(QuotaManagerHost_QueryStorageUsageAndQuota_Params);
      this.queryStorageUsageAndQuota().then(function(response) {
        var responseParams =
            new QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams();
        responseParams.error = response.error;
        responseParams.currentUsage = response.currentUsage;
        responseParams.currentQuota = response.currentQuota;
        responseParams.usageBreakdown = response.usageBreakdown;
        var builder = new codec.MessageV1Builder(
            kQuotaManagerHost_QueryStorageUsageAndQuota_Name,
            codec.align(QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateQuotaManagerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kQuotaManagerHost_QueryStorageUsageAndQuota_Name:
        if (message.expectsResponse())
          paramsClass = QuotaManagerHost_QueryStorageUsageAndQuota_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateQuotaManagerHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kQuotaManagerHost_QueryStorageUsageAndQuota_Name:
        if (message.isResponse())
          paramsClass = QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var QuotaManagerHost = {
    name: 'blink.mojom.QuotaManagerHost',
    kVersion: 0,
    ptrClass: QuotaManagerHostPtr,
    proxyClass: QuotaManagerHostProxy,
    stubClass: QuotaManagerHostStub,
    validateRequest: validateQuotaManagerHostRequest,
    validateResponse: validateQuotaManagerHostResponse,
  };
  QuotaManagerHostStub.prototype.validator = validateQuotaManagerHostRequest;
  QuotaManagerHostProxy.prototype.validator = validateQuotaManagerHostResponse;
  exports.QuotaManagerHost = QuotaManagerHost;
  exports.QuotaManagerHostPtr = QuotaManagerHostPtr;
  exports.QuotaManagerHostAssociatedPtr = QuotaManagerHostAssociatedPtr;
})();