// third_party/blink/public/mojom/sensor/web_sensor_provider.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/sensor/web_sensor_provider.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var sensor$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/sensor.mojom', '../../../../../services/device/public/mojom/sensor.mojom.js');
  }
  var sensor_provider$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/sensor_provider.mojom', '../../../../../services/device/public/mojom/sensor_provider.mojom.js');
  }



  function WebSensorProvider_GetSensor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSensorProvider_GetSensor_Params.prototype.initDefaults_ = function() {
    this.type = 0;
  };
  WebSensorProvider_GetSensor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSensorProvider_GetSensor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSensorProvider_GetSensor_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, sensor$.SensorType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSensorProvider_GetSensor_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebSensorProvider_GetSensor_Params.decode = function(decoder) {
    var packed;
    var val = new WebSensorProvider_GetSensor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(sensor$.SensorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebSensorProvider_GetSensor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSensorProvider_GetSensor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function WebSensorProvider_GetSensor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebSensorProvider_GetSensor_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.initParams = null;
  };
  WebSensorProvider_GetSensor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebSensorProvider_GetSensor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSensorProvider_GetSensor_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, sensor_provider$.SensorCreationResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebSensorProvider_GetSensor_ResponseParams.initParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, sensor_provider$.SensorInitParams, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebSensorProvider_GetSensor_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  WebSensorProvider_GetSensor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new WebSensorProvider_GetSensor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(sensor_provider$.SensorCreationResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.initParams =
        decoder.decodeStructPointer(sensor_provider$.SensorInitParams);
    return val;
  };

  WebSensorProvider_GetSensor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebSensorProvider_GetSensor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(sensor_provider$.SensorInitParams, val.initParams);
  };
  var kWebSensorProvider_GetSensor_Name = 0;

  function WebSensorProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebSensorProvider,
                                                   handleOrPtrInfo);
  }

  function WebSensorProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebSensorProvider, associatedInterfacePtrInfo);
  }

  WebSensorProviderAssociatedPtr.prototype =
      Object.create(WebSensorProviderPtr.prototype);
  WebSensorProviderAssociatedPtr.prototype.constructor =
      WebSensorProviderAssociatedPtr;

  function WebSensorProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebSensorProviderPtr.prototype.getSensor = function() {
    return WebSensorProviderProxy.prototype.getSensor
        .apply(this.ptr.getProxy(), arguments);
  };

  WebSensorProviderProxy.prototype.getSensor = function(type) {
    var params_ = new WebSensorProvider_GetSensor_Params();
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kWebSensorProvider_GetSensor_Name,
          codec.align(WebSensorProvider_GetSensor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(WebSensorProvider_GetSensor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(WebSensorProvider_GetSensor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function WebSensorProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  WebSensorProviderStub.prototype.getSensor = function(type) {
    return this.delegate_ && this.delegate_.getSensor && this.delegate_.getSensor(type);
  }

  WebSensorProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  WebSensorProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebSensorProvider_GetSensor_Name:
      var params = reader.decodeStruct(WebSensorProvider_GetSensor_Params);
      this.getSensor(params.type).then(function(response) {
        var responseParams =
            new WebSensorProvider_GetSensor_ResponseParams();
        responseParams.result = response.result;
        responseParams.initParams = response.initParams;
        var builder = new codec.MessageV1Builder(
            kWebSensorProvider_GetSensor_Name,
            codec.align(WebSensorProvider_GetSensor_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(WebSensorProvider_GetSensor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateWebSensorProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebSensorProvider_GetSensor_Name:
        if (message.expectsResponse())
          paramsClass = WebSensorProvider_GetSensor_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebSensorProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kWebSensorProvider_GetSensor_Name:
        if (message.isResponse())
          paramsClass = WebSensorProvider_GetSensor_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var WebSensorProvider = {
    name: 'blink.mojom.WebSensorProvider',
    kVersion: 0,
    ptrClass: WebSensorProviderPtr,
    proxyClass: WebSensorProviderProxy,
    stubClass: WebSensorProviderStub,
    validateRequest: validateWebSensorProviderRequest,
    validateResponse: validateWebSensorProviderResponse,
  };
  WebSensorProviderStub.prototype.validator = validateWebSensorProviderRequest;
  WebSensorProviderProxy.prototype.validator = validateWebSensorProviderResponse;
  exports.WebSensorProvider = WebSensorProvider;
  exports.WebSensorProviderPtr = WebSensorProviderPtr;
  exports.WebSensorProviderAssociatedPtr = WebSensorProviderAssociatedPtr;
})();