// third_party/blink/public/mojom/service_worker/embedded_worker.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/service_worker/embedded_worker.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var url_loader_factory$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader_factory.mojom', '../../../../../services/network/public/mojom/url_loader_factory.mojom.js');
  }
  var interface_provider$ =
      mojo.internal.exposeNamespace('serviceManager.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/service_manager/public/mojom/interface_provider.mojom', '../../../../../services/service_manager/public/mojom/interface_provider.mojom.js');
  }
  var console_message$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/devtools/console_message.mojom', '../devtools/console_message.mojom.js');
  }
  var devtools_agent$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/devtools/devtools_agent.mojom', '../devtools/devtools_agent.mojom.js');
  }
  var policy_container$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/policy_container.mojom', '../frame/policy_container.mojom.js');
  }
  var reporting_observer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/reporting_observer.mojom', '../frame/reporting_observer.mojom.js');
  }
  var noise_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom', '../fingerprinting_protection/noise_token.mojom.js');
  }
  var fetch_client_settings_object$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom', '../loader/fetch_client_settings_object.mojom.js');
  }
  var url_loader_factory_bundle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom', '../loader/url_loader_factory_bundle.mojom.js');
  }
  var renderer_preference_watcher$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/renderer_preference_watcher.mojom', '../renderer_preference_watcher.mojom.js');
  }
  var renderer_preferences$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/renderer_preferences.mojom', '../renderer_preferences.mojom.js');
  }
  var script_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/script/script_type.mojom', '../script/script_type.mojom.js');
  }
  var canvas_interventions$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom', '../fingerprinting_protection/canvas_interventions.mojom.js');
  }
  var controller_service_worker$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/controller_service_worker.mojom', 'controller_service_worker.mojom.js');
  }
  var service_worker$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker.mojom', 'service_worker.mojom.js');
  }
  var service_worker_event_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom', 'service_worker_event_status.mojom.js');
  }
  var service_worker_fetch_handler_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom', 'service_worker_fetch_handler_type.mojom.js');
  }
  var service_worker_installed_scripts_manager$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom', 'service_worker_installed_scripts_manager.mojom.js');
  }
  var service_worker_provider$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_provider.mojom', 'service_worker_provider.mojom.js');
  }
  var service_worker_registration$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/service_worker/service_worker_registration.mojom', 'service_worker_registration.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var web_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom', '../use_counter/metrics/web_feature.mojom.js');
  }
  var user_agent_metadata$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom', '../user_agent/user_agent_metadata.mojom.js');
  }
  var subresource_loader_updater$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/subresource_loader_updater.mojom', '../worker/subresource_loader_updater.mojom.js');
  }
  var worker_content_settings_proxy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/worker_content_settings_proxy.mojom', '../worker/worker_content_settings_proxy.mojom.js');
  }
  var worker_main_script_load_params$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom', '../worker/worker_main_script_load_params.mojom.js');
  }
  var storage_key$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/storage_key/storage_key.mojom', '../storage_key/storage_key.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function EmbeddedWorkerStartParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerStartParams.prototype.initDefaults_ = function() {
    this.serviceWorkerVersionId = 0;
    this.scope = null;
    this.scriptUrl = null;
    this.scriptType = 0;
    this.serviceWorkerRouteId = 0;
    this.outsideFetchClientSettingsObject = null;
    this.userAgent = null;
    this.uaMetadata = null;
    this.devtoolsWorkerToken = null;
    this.scriptUrlToSkipThrottling = null;
    this.waitForDebugger = false;
    this.isInstalled = false;
    this.serviceWorkerReceiver = new bindings.InterfaceRequest();
    this.rendererPreferences = null;
    this.forcedEnabledRuntimeFeatures = null;
    this.interfaceProvider = new bindings.InterfaceRequest();
    this.controllerReceiver = new bindings.InterfaceRequest();
    this.installedScriptsInfo = null;
    this.instanceHost = new associatedBindings.AssociatedInterfacePtrInfo();
    this.providerInfo = null;
    this.contentSettingsProxy = new worker_content_settings_proxy$.WorkerContentSettingsProxyPtr();
    this.preferenceWatcherReceiver = new bindings.InterfaceRequest();
    this.subresourceLoaderUpdater = new bindings.InterfaceRequest();
    this.subresourceLoaderFactories = null;
    this.serviceWorkerToken = null;
    this.ukmSourceId = 0;
    this.mainScriptLoadParams = null;
    this.policyContainer = null;
    this.storageKey = null;
    this.corsExemptHeaderList = null;
    this.coepReportingObserver = new bindings.InterfaceRequest();
    this.dipReportingObserver = new bindings.InterfaceRequest();
    this.canvasNoiseToken = null;
    this.canvasNoiseTokenObserver = new bindings.InterfaceRequest();
  };
  EmbeddedWorkerStartParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerStartParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 232}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EmbeddedWorkerStartParams.scope
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.scriptUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.scriptType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, script_type$.ScriptType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.outsideFetchClientSettingsObject
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, fetch_client_settings_object$.FetchClientSettingsObject, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.userAgent
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.uaMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, user_agent_metadata$.UserAgentMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EmbeddedWorkerStartParams.devtoolsWorkerToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.scriptUrlToSkipThrottling
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate EmbeddedWorkerStartParams.rendererPreferences
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, renderer_preferences$.RendererPreferences, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.forcedEnabledRuntimeFeatures
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 88, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.serviceWorkerReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 76, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.interfaceProvider
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 96, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.controllerReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 100, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.installedScriptsInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, service_worker_installed_scripts_manager$.ServiceWorkerInstalledScriptsInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.instanceHost
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 112, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.providerInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, service_worker_provider$.ServiceWorkerProviderInfoForStartWorker, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.contentSettingsProxy
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 128, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.preferenceWatcherReceiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 136, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.subresourceLoaderFactories
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, url_loader_factory_bundle$.URLLoaderFactoryBundle, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.subresourceLoaderUpdater
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 140, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.serviceWorkerToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 152, tokens$.ServiceWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EmbeddedWorkerStartParams.mainScriptLoadParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 168, worker_main_script_load_params$.WorkerMainScriptLoadParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.policyContainer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 176, policy_container$.PolicyContainer, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.storageKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 184, storage_key$.StorageKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.corsExemptHeaderList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 192, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.coepReportingObserver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 200, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.dipReportingObserver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 204, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.canvasNoiseToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 208, noise_token$.NoiseToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartParams.canvasNoiseTokenObserver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 216, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerStartParams.encodedSize = codec.kStructHeaderSize + 224;

  EmbeddedWorkerStartParams.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerStartParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceWorkerVersionId =
        decoder.decodeStruct(codec.Int64);
    val.scope =
        decoder.decodeStructPointer(url$.Url);
    val.scriptUrl =
        decoder.decodeStructPointer(url$.Url);
    val.scriptType =
        decoder.decodeStruct(new codec.Enum(script_type$.ScriptType));
    val.serviceWorkerRouteId =
        decoder.decodeStruct(codec.Int32);
    val.outsideFetchClientSettingsObject =
        decoder.decodeStructPointer(fetch_client_settings_object$.FetchClientSettingsObject);
    val.userAgent =
        decoder.decodeStruct(codec.String);
    val.uaMetadata =
        decoder.decodeStructPointer(user_agent_metadata$.UserAgentMetadata);
    val.devtoolsWorkerToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.scriptUrlToSkipThrottling =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.waitForDebugger = (packed >> 0) & 1 ? true : false;
    val.isInstalled = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.serviceWorkerReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.rendererPreferences =
        decoder.decodeStructPointer(renderer_preferences$.RendererPreferences);
    val.forcedEnabledRuntimeFeatures =
        decoder.decodeArrayPointer(codec.String);
    val.interfaceProvider =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.controllerReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.installedScriptsInfo =
        decoder.decodeStructPointer(service_worker_installed_scripts_manager$.ServiceWorkerInstalledScriptsInfo);
    val.instanceHost =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.providerInfo =
        decoder.decodeStructPointer(service_worker_provider$.ServiceWorkerProviderInfoForStartWorker);
    val.contentSettingsProxy =
        decoder.decodeStruct(new codec.Interface(worker_content_settings_proxy$.WorkerContentSettingsProxyPtr));
    val.preferenceWatcherReceiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.subresourceLoaderUpdater =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.subresourceLoaderFactories =
        decoder.decodeStructPointer(url_loader_factory_bundle$.URLLoaderFactoryBundle);
    val.serviceWorkerToken =
        decoder.decodeStructPointer(tokens$.ServiceWorkerToken);
    val.ukmSourceId =
        decoder.decodeStruct(codec.Int64);
    val.mainScriptLoadParams =
        decoder.decodeStructPointer(worker_main_script_load_params$.WorkerMainScriptLoadParams);
    val.policyContainer =
        decoder.decodeStructPointer(policy_container$.PolicyContainer);
    val.storageKey =
        decoder.decodeStructPointer(storage_key$.StorageKey);
    val.corsExemptHeaderList =
        decoder.decodeArrayPointer(codec.String);
    val.coepReportingObserver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.dipReportingObserver =
        decoder.decodeStruct(codec.NullableInterfaceRequest);
    val.canvasNoiseToken =
        decoder.decodeStructPointer(noise_token$.NoiseToken);
    val.canvasNoiseTokenObserver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EmbeddedWorkerStartParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerStartParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerVersionId);
    encoder.encodeStructPointer(url$.Url, val.scope);
    encoder.encodeStructPointer(url$.Url, val.scriptUrl);
    encoder.encodeStruct(codec.Int32, val.scriptType);
    encoder.encodeStruct(codec.Int32, val.serviceWorkerRouteId);
    encoder.encodeStructPointer(fetch_client_settings_object$.FetchClientSettingsObject, val.outsideFetchClientSettingsObject);
    encoder.encodeStruct(codec.String, val.userAgent);
    encoder.encodeStructPointer(user_agent_metadata$.UserAgentMetadata, val.uaMetadata);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolsWorkerToken);
    encoder.encodeStructPointer(url$.Url, val.scriptUrlToSkipThrottling);
    packed = 0;
    packed |= (val.waitForDebugger & 1) << 0
    packed |= (val.isInstalled & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.InterfaceRequest, val.serviceWorkerReceiver);
    encoder.encodeStructPointer(renderer_preferences$.RendererPreferences, val.rendererPreferences);
    encoder.encodeArrayPointer(codec.String, val.forcedEnabledRuntimeFeatures);
    encoder.encodeStruct(codec.InterfaceRequest, val.interfaceProvider);
    encoder.encodeStruct(codec.InterfaceRequest, val.controllerReceiver);
    encoder.encodeStructPointer(service_worker_installed_scripts_manager$.ServiceWorkerInstalledScriptsInfo, val.installedScriptsInfo);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.instanceHost);
    encoder.encodeStructPointer(service_worker_provider$.ServiceWorkerProviderInfoForStartWorker, val.providerInfo);
    encoder.encodeStruct(new codec.Interface(worker_content_settings_proxy$.WorkerContentSettingsProxyPtr), val.contentSettingsProxy);
    encoder.encodeStruct(codec.InterfaceRequest, val.preferenceWatcherReceiver);
    encoder.encodeStruct(codec.InterfaceRequest, val.subresourceLoaderUpdater);
    encoder.encodeStructPointer(url_loader_factory_bundle$.URLLoaderFactoryBundle, val.subresourceLoaderFactories);
    encoder.encodeStructPointer(tokens$.ServiceWorkerToken, val.serviceWorkerToken);
    encoder.encodeStruct(codec.Int64, val.ukmSourceId);
    encoder.encodeStructPointer(worker_main_script_load_params$.WorkerMainScriptLoadParams, val.mainScriptLoadParams);
    encoder.encodeStructPointer(policy_container$.PolicyContainer, val.policyContainer);
    encoder.encodeStructPointer(storage_key$.StorageKey, val.storageKey);
    encoder.encodeArrayPointer(codec.String, val.corsExemptHeaderList);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.coepReportingObserver);
    encoder.encodeStruct(codec.NullableInterfaceRequest, val.dipReportingObserver);
    encoder.encodeStructPointer(noise_token$.NoiseToken, val.canvasNoiseToken);
    encoder.encodeStruct(codec.InterfaceRequest, val.canvasNoiseTokenObserver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EmbeddedWorkerStartTiming(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerStartTiming.prototype.initDefaults_ = function() {
    this.startWorkerReceivedTime = null;
    this.scriptEvaluationStartTime = null;
    this.scriptEvaluationEndTime = null;
  };
  EmbeddedWorkerStartTiming.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerStartTiming.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartTiming.startWorkerReceivedTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartTiming.scriptEvaluationStartTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerStartTiming.scriptEvaluationEndTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerStartTiming.encodedSize = codec.kStructHeaderSize + 24;

  EmbeddedWorkerStartTiming.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerStartTiming();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startWorkerReceivedTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.scriptEvaluationStartTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.scriptEvaluationEndTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  EmbeddedWorkerStartTiming.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerStartTiming.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.startWorkerReceivedTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.scriptEvaluationStartTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.scriptEvaluationEndTime);
  };
  function EmbeddedWorkerInstanceClient_StartWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceClient_StartWorker_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  EmbeddedWorkerInstanceClient_StartWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceClient_StartWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceClient_StartWorker_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, EmbeddedWorkerStartParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceClient_StartWorker_Params.encodedSize = codec.kStructHeaderSize + 8;

  EmbeddedWorkerInstanceClient_StartWorker_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceClient_StartWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(EmbeddedWorkerStartParams);
    return val;
  };

  EmbeddedWorkerInstanceClient_StartWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceClient_StartWorker_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(EmbeddedWorkerStartParams, val.params);
  };
  function EmbeddedWorkerInstanceClient_StopWorker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceClient_StopWorker_Params.prototype.initDefaults_ = function() {
  };
  EmbeddedWorkerInstanceClient_StopWorker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceClient_StopWorker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceClient_StopWorker_Params.encodedSize = codec.kStructHeaderSize + 0;

  EmbeddedWorkerInstanceClient_StopWorker_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceClient_StopWorker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EmbeddedWorkerInstanceClient_StopWorker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceClient_StopWorker_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EmbeddedWorkerInstanceHost_RequestTermination_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_RequestTermination_Params.prototype.initDefaults_ = function() {
  };
  EmbeddedWorkerInstanceHost_RequestTermination_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_RequestTermination_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_RequestTermination_Params.encodedSize = codec.kStructHeaderSize + 0;

  EmbeddedWorkerInstanceHost_RequestTermination_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_RequestTermination_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EmbeddedWorkerInstanceHost_RequestTermination_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_RequestTermination_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams.prototype.initDefaults_ = function() {
    this.willBeTerminated = false;
  };
  EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.willBeTerminated = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.willBeTerminated & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EmbeddedWorkerInstanceHost_CountFeature_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_CountFeature_Params.prototype.initDefaults_ = function() {
    this.feature = 0;
  };
  EmbeddedWorkerInstanceHost_CountFeature_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_CountFeature_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_CountFeature_Params.feature
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, web_feature$.WebFeature);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_CountFeature_Params.encodedSize = codec.kStructHeaderSize + 8;

  EmbeddedWorkerInstanceHost_CountFeature_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_CountFeature_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.feature =
        decoder.decodeStruct(new codec.Enum(web_feature$.WebFeature));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EmbeddedWorkerInstanceHost_CountFeature_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_CountFeature_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.feature);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EmbeddedWorkerInstanceHost_OnReadyForInspection_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.prototype.initDefaults_ = function() {
    this.agent = new devtools_agent$.DevToolsAgentPtr();
    this.agentHost = new bindings.InterfaceRequest();
  };
  EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.agent
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.agentHost
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.encodedSize = codec.kStructHeaderSize + 16;

  EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_OnReadyForInspection_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.agent =
        decoder.decodeStruct(new codec.Interface(devtools_agent$.DevToolsAgentPtr));
    val.agentHost =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(devtools_agent$.DevToolsAgentPtr), val.agent);
    encoder.encodeStruct(codec.InterfaceRequest, val.agentHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EmbeddedWorkerInstanceHost_OnScriptLoaded_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_OnScriptLoaded_Params.prototype.initDefaults_ = function() {
  };
  EmbeddedWorkerInstanceHost_OnScriptLoaded_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_OnScriptLoaded_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_OnScriptLoaded_Params.encodedSize = codec.kStructHeaderSize + 0;

  EmbeddedWorkerInstanceHost_OnScriptLoaded_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_OnScriptLoaded_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EmbeddedWorkerInstanceHost_OnScriptLoaded_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_OnScriptLoaded_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params.prototype.initDefaults_ = function() {
  };
  EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params.encodedSize = codec.kStructHeaderSize + 0;

  EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EmbeddedWorkerInstanceHost_OnStarted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_OnStarted_Params.prototype.initDefaults_ = function() {
    this.status = 0;
    this.fetchHandlerType = 0;
    this.hasHidEventHandlers = false;
    this.hasUsbEventHandlers = false;
    this.threadId = 0;
    this.startTiming = null;
  };
  EmbeddedWorkerInstanceHost_OnStarted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_OnStarted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_OnStarted_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, service_worker_event_status$.ServiceWorkerStartStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_OnStarted_Params.fetchHandlerType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, service_worker_fetch_handler_type$.ServiceWorkerFetchHandlerType);
    if (err !== validator.validationError.NONE)
        return err;





    // validate EmbeddedWorkerInstanceHost_OnStarted_Params.startTiming
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, EmbeddedWorkerStartTiming, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_OnStarted_Params.encodedSize = codec.kStructHeaderSize + 24;

  EmbeddedWorkerInstanceHost_OnStarted_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_OnStarted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(service_worker_event_status$.ServiceWorkerStartStatus));
    val.fetchHandlerType =
        decoder.decodeStruct(new codec.Enum(service_worker_fetch_handler_type$.ServiceWorkerFetchHandlerType));
    packed = decoder.readUint8();
    val.hasHidEventHandlers = (packed >> 0) & 1 ? true : false;
    val.hasUsbEventHandlers = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.threadId =
        decoder.decodeStruct(codec.Int32);
    val.startTiming =
        decoder.decodeStructPointer(EmbeddedWorkerStartTiming);
    return val;
  };

  EmbeddedWorkerInstanceHost_OnStarted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_OnStarted_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.encodeStruct(codec.Int32, val.fetchHandlerType);
    packed = 0;
    packed |= (val.hasHidEventHandlers & 1) << 0
    packed |= (val.hasUsbEventHandlers & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.threadId);
    encoder.encodeStructPointer(EmbeddedWorkerStartTiming, val.startTiming);
  };
  function EmbeddedWorkerInstanceHost_OnReportException_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_OnReportException_Params.prototype.initDefaults_ = function() {
    this.errorMessage = null;
    this.lineNumber = 0;
    this.columnNumber = 0;
    this.sourceUrl = null;
  };
  EmbeddedWorkerInstanceHost_OnReportException_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_OnReportException_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_OnReportException_Params.errorMessage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate EmbeddedWorkerInstanceHost_OnReportException_Params.sourceUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_OnReportException_Params.encodedSize = codec.kStructHeaderSize + 24;

  EmbeddedWorkerInstanceHost_OnReportException_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_OnReportException_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorMessage =
        decoder.decodeStructPointer(string16$.String16);
    val.lineNumber =
        decoder.decodeStruct(codec.Int32);
    val.columnNumber =
        decoder.decodeStruct(codec.Int32);
    val.sourceUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  EmbeddedWorkerInstanceHost_OnReportException_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_OnReportException_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.errorMessage);
    encoder.encodeStruct(codec.Int32, val.lineNumber);
    encoder.encodeStruct(codec.Int32, val.columnNumber);
    encoder.encodeStructPointer(url$.Url, val.sourceUrl);
  };
  function EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.prototype.initDefaults_ = function() {
    this.source = 0;
    this.messageLevel = 0;
    this.message = null;
    this.lineNumber = 0;
    this.sourceUrl = null;
  };
  EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, console_message$.ConsoleMessageSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.messageLevel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, console_message$.ConsoleMessageLevel);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.sourceUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.encodedSize = codec.kStructHeaderSize + 32;

  EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.source =
        decoder.decodeStruct(new codec.Enum(console_message$.ConsoleMessageSource));
    val.messageLevel =
        decoder.decodeStruct(new codec.Enum(console_message$.ConsoleMessageLevel));
    val.message =
        decoder.decodeStructPointer(string16$.String16);
    val.lineNumber =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sourceUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.encodeStruct(codec.Int32, val.messageLevel);
    encoder.encodeStructPointer(string16$.String16, val.message);
    encoder.encodeStruct(codec.Int32, val.lineNumber);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.sourceUrl);
  };
  function EmbeddedWorkerInstanceHost_OnStopped_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmbeddedWorkerInstanceHost_OnStopped_Params.prototype.initDefaults_ = function() {
  };
  EmbeddedWorkerInstanceHost_OnStopped_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmbeddedWorkerInstanceHost_OnStopped_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmbeddedWorkerInstanceHost_OnStopped_Params.encodedSize = codec.kStructHeaderSize + 0;

  EmbeddedWorkerInstanceHost_OnStopped_Params.decode = function(decoder) {
    var packed;
    var val = new EmbeddedWorkerInstanceHost_OnStopped_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EmbeddedWorkerInstanceHost_OnStopped_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmbeddedWorkerInstanceHost_OnStopped_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kEmbeddedWorkerInstanceClient_StartWorker_Name = 0;
  var kEmbeddedWorkerInstanceClient_StopWorker_Name = 1;

  function EmbeddedWorkerInstanceClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EmbeddedWorkerInstanceClient,
                                                   handleOrPtrInfo);
  }

  function EmbeddedWorkerInstanceClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EmbeddedWorkerInstanceClient, associatedInterfacePtrInfo);
  }

  EmbeddedWorkerInstanceClientAssociatedPtr.prototype =
      Object.create(EmbeddedWorkerInstanceClientPtr.prototype);
  EmbeddedWorkerInstanceClientAssociatedPtr.prototype.constructor =
      EmbeddedWorkerInstanceClientAssociatedPtr;

  function EmbeddedWorkerInstanceClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  EmbeddedWorkerInstanceClientPtr.prototype.startWorker = function() {
    return EmbeddedWorkerInstanceClientProxy.prototype.startWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceClientProxy.prototype.startWorker = function(params) {
    var params_ = new EmbeddedWorkerInstanceClient_StartWorker_Params();
    params_.params = params;
    var builder = new codec.MessageV2Builder(
        kEmbeddedWorkerInstanceClient_StartWorker_Name,
        codec.align(EmbeddedWorkerInstanceClient_StartWorker_Params.encodedSize));
    builder.setPayload(EmbeddedWorkerInstanceClient_StartWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EmbeddedWorkerInstanceClientPtr.prototype.stopWorker = function() {
    return EmbeddedWorkerInstanceClientProxy.prototype.stopWorker
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceClientProxy.prototype.stopWorker = function() {
    var params_ = new EmbeddedWorkerInstanceClient_StopWorker_Params();
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceClient_StopWorker_Name,
        codec.align(EmbeddedWorkerInstanceClient_StopWorker_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceClient_StopWorker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function EmbeddedWorkerInstanceClientStub(delegate) {
    this.delegate_ = delegate;
  }
  EmbeddedWorkerInstanceClientStub.prototype.startWorker = function(params) {
    return this.delegate_ && this.delegate_.startWorker && this.delegate_.startWorker(params);
  }
  EmbeddedWorkerInstanceClientStub.prototype.stopWorker = function() {
    return this.delegate_ && this.delegate_.stopWorker && this.delegate_.stopWorker();
  }

  EmbeddedWorkerInstanceClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEmbeddedWorkerInstanceClient_StartWorker_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceClient_StartWorker_Params);
      this.startWorker(params.params);
      return true;
    case kEmbeddedWorkerInstanceClient_StopWorker_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceClient_StopWorker_Params);
      this.stopWorker();
      return true;
    default:
      return false;
    }
  };

  EmbeddedWorkerInstanceClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateEmbeddedWorkerInstanceClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEmbeddedWorkerInstanceClient_StartWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceClient_StartWorker_Params;
      break;
      case kEmbeddedWorkerInstanceClient_StopWorker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceClient_StopWorker_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEmbeddedWorkerInstanceClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var EmbeddedWorkerInstanceClient = {
    name: 'blink.mojom.EmbeddedWorkerInstanceClient',
    kVersion: 0,
    ptrClass: EmbeddedWorkerInstanceClientPtr,
    proxyClass: EmbeddedWorkerInstanceClientProxy,
    stubClass: EmbeddedWorkerInstanceClientStub,
    validateRequest: validateEmbeddedWorkerInstanceClientRequest,
    validateResponse: null,
  };
  EmbeddedWorkerInstanceClientStub.prototype.validator = validateEmbeddedWorkerInstanceClientRequest;
  EmbeddedWorkerInstanceClientProxy.prototype.validator = null;
  var kEmbeddedWorkerInstanceHost_RequestTermination_Name = 0;
  var kEmbeddedWorkerInstanceHost_CountFeature_Name = 1;
  var kEmbeddedWorkerInstanceHost_OnReadyForInspection_Name = 2;
  var kEmbeddedWorkerInstanceHost_OnScriptLoaded_Name = 3;
  var kEmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Name = 4;
  var kEmbeddedWorkerInstanceHost_OnStarted_Name = 5;
  var kEmbeddedWorkerInstanceHost_OnReportException_Name = 6;
  var kEmbeddedWorkerInstanceHost_OnReportConsoleMessage_Name = 7;
  var kEmbeddedWorkerInstanceHost_OnStopped_Name = 8;

  function EmbeddedWorkerInstanceHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EmbeddedWorkerInstanceHost,
                                                   handleOrPtrInfo);
  }

  function EmbeddedWorkerInstanceHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EmbeddedWorkerInstanceHost, associatedInterfacePtrInfo);
  }

  EmbeddedWorkerInstanceHostAssociatedPtr.prototype =
      Object.create(EmbeddedWorkerInstanceHostPtr.prototype);
  EmbeddedWorkerInstanceHostAssociatedPtr.prototype.constructor =
      EmbeddedWorkerInstanceHostAssociatedPtr;

  function EmbeddedWorkerInstanceHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  EmbeddedWorkerInstanceHostPtr.prototype.requestTermination = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.requestTermination
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.requestTermination = function() {
    var params_ = new EmbeddedWorkerInstanceHost_RequestTermination_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kEmbeddedWorkerInstanceHost_RequestTermination_Name,
          codec.align(EmbeddedWorkerInstanceHost_RequestTermination_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(EmbeddedWorkerInstanceHost_RequestTermination_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  EmbeddedWorkerInstanceHostPtr.prototype.countFeature = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.countFeature
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.countFeature = function(feature) {
    var params_ = new EmbeddedWorkerInstanceHost_CountFeature_Params();
    params_.feature = feature;
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceHost_CountFeature_Name,
        codec.align(EmbeddedWorkerInstanceHost_CountFeature_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceHost_CountFeature_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EmbeddedWorkerInstanceHostPtr.prototype.onReadyForInspection = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.onReadyForInspection
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.onReadyForInspection = function(agent, agentHost) {
    var params_ = new EmbeddedWorkerInstanceHost_OnReadyForInspection_Params();
    params_.agent = agent;
    params_.agentHost = agentHost;
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceHost_OnReadyForInspection_Name,
        codec.align(EmbeddedWorkerInstanceHost_OnReadyForInspection_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceHost_OnReadyForInspection_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EmbeddedWorkerInstanceHostPtr.prototype.onScriptLoaded = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.onScriptLoaded
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.onScriptLoaded = function() {
    var params_ = new EmbeddedWorkerInstanceHost_OnScriptLoaded_Params();
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceHost_OnScriptLoaded_Name,
        codec.align(EmbeddedWorkerInstanceHost_OnScriptLoaded_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceHost_OnScriptLoaded_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EmbeddedWorkerInstanceHostPtr.prototype.onScriptEvaluationStart = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.onScriptEvaluationStart
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.onScriptEvaluationStart = function() {
    var params_ = new EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params();
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Name,
        codec.align(EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EmbeddedWorkerInstanceHostPtr.prototype.onStarted = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.onStarted
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.onStarted = function(status, fetchHandlerType, hasHidEventHandlers, hasUsbEventHandlers, threadId, startTiming) {
    var params_ = new EmbeddedWorkerInstanceHost_OnStarted_Params();
    params_.status = status;
    params_.fetchHandlerType = fetchHandlerType;
    params_.hasHidEventHandlers = hasHidEventHandlers;
    params_.hasUsbEventHandlers = hasUsbEventHandlers;
    params_.threadId = threadId;
    params_.startTiming = startTiming;
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceHost_OnStarted_Name,
        codec.align(EmbeddedWorkerInstanceHost_OnStarted_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceHost_OnStarted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EmbeddedWorkerInstanceHostPtr.prototype.onReportException = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.onReportException
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.onReportException = function(errorMessage, lineNumber, columnNumber, sourceUrl) {
    var params_ = new EmbeddedWorkerInstanceHost_OnReportException_Params();
    params_.errorMessage = errorMessage;
    params_.lineNumber = lineNumber;
    params_.columnNumber = columnNumber;
    params_.sourceUrl = sourceUrl;
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceHost_OnReportException_Name,
        codec.align(EmbeddedWorkerInstanceHost_OnReportException_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceHost_OnReportException_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EmbeddedWorkerInstanceHostPtr.prototype.onReportConsoleMessage = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.onReportConsoleMessage
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.onReportConsoleMessage = function(source, messageLevel, message, lineNumber, sourceUrl) {
    var params_ = new EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params();
    params_.source = source;
    params_.messageLevel = messageLevel;
    params_.message = message;
    params_.lineNumber = lineNumber;
    params_.sourceUrl = sourceUrl;
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceHost_OnReportConsoleMessage_Name,
        codec.align(EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EmbeddedWorkerInstanceHostPtr.prototype.onStopped = function() {
    return EmbeddedWorkerInstanceHostProxy.prototype.onStopped
        .apply(this.ptr.getProxy(), arguments);
  };

  EmbeddedWorkerInstanceHostProxy.prototype.onStopped = function() {
    var params_ = new EmbeddedWorkerInstanceHost_OnStopped_Params();
    var builder = new codec.MessageV0Builder(
        kEmbeddedWorkerInstanceHost_OnStopped_Name,
        codec.align(EmbeddedWorkerInstanceHost_OnStopped_Params.encodedSize));
    builder.encodeStruct(EmbeddedWorkerInstanceHost_OnStopped_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function EmbeddedWorkerInstanceHostStub(delegate) {
    this.delegate_ = delegate;
  }
  EmbeddedWorkerInstanceHostStub.prototype.requestTermination = function() {
    return this.delegate_ && this.delegate_.requestTermination && this.delegate_.requestTermination();
  }
  EmbeddedWorkerInstanceHostStub.prototype.countFeature = function(feature) {
    return this.delegate_ && this.delegate_.countFeature && this.delegate_.countFeature(feature);
  }
  EmbeddedWorkerInstanceHostStub.prototype.onReadyForInspection = function(agent, agentHost) {
    return this.delegate_ && this.delegate_.onReadyForInspection && this.delegate_.onReadyForInspection(agent, agentHost);
  }
  EmbeddedWorkerInstanceHostStub.prototype.onScriptLoaded = function() {
    return this.delegate_ && this.delegate_.onScriptLoaded && this.delegate_.onScriptLoaded();
  }
  EmbeddedWorkerInstanceHostStub.prototype.onScriptEvaluationStart = function() {
    return this.delegate_ && this.delegate_.onScriptEvaluationStart && this.delegate_.onScriptEvaluationStart();
  }
  EmbeddedWorkerInstanceHostStub.prototype.onStarted = function(status, fetchHandlerType, hasHidEventHandlers, hasUsbEventHandlers, threadId, startTiming) {
    return this.delegate_ && this.delegate_.onStarted && this.delegate_.onStarted(status, fetchHandlerType, hasHidEventHandlers, hasUsbEventHandlers, threadId, startTiming);
  }
  EmbeddedWorkerInstanceHostStub.prototype.onReportException = function(errorMessage, lineNumber, columnNumber, sourceUrl) {
    return this.delegate_ && this.delegate_.onReportException && this.delegate_.onReportException(errorMessage, lineNumber, columnNumber, sourceUrl);
  }
  EmbeddedWorkerInstanceHostStub.prototype.onReportConsoleMessage = function(source, messageLevel, message, lineNumber, sourceUrl) {
    return this.delegate_ && this.delegate_.onReportConsoleMessage && this.delegate_.onReportConsoleMessage(source, messageLevel, message, lineNumber, sourceUrl);
  }
  EmbeddedWorkerInstanceHostStub.prototype.onStopped = function() {
    return this.delegate_ && this.delegate_.onStopped && this.delegate_.onStopped();
  }

  EmbeddedWorkerInstanceHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEmbeddedWorkerInstanceHost_CountFeature_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_CountFeature_Params);
      this.countFeature(params.feature);
      return true;
    case kEmbeddedWorkerInstanceHost_OnReadyForInspection_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_OnReadyForInspection_Params);
      this.onReadyForInspection(params.agent, params.agentHost);
      return true;
    case kEmbeddedWorkerInstanceHost_OnScriptLoaded_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_OnScriptLoaded_Params);
      this.onScriptLoaded();
      return true;
    case kEmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params);
      this.onScriptEvaluationStart();
      return true;
    case kEmbeddedWorkerInstanceHost_OnStarted_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_OnStarted_Params);
      this.onStarted(params.status, params.fetchHandlerType, params.hasHidEventHandlers, params.hasUsbEventHandlers, params.threadId, params.startTiming);
      return true;
    case kEmbeddedWorkerInstanceHost_OnReportException_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_OnReportException_Params);
      this.onReportException(params.errorMessage, params.lineNumber, params.columnNumber, params.sourceUrl);
      return true;
    case kEmbeddedWorkerInstanceHost_OnReportConsoleMessage_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params);
      this.onReportConsoleMessage(params.source, params.messageLevel, params.message, params.lineNumber, params.sourceUrl);
      return true;
    case kEmbeddedWorkerInstanceHost_OnStopped_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_OnStopped_Params);
      this.onStopped();
      return true;
    default:
      return false;
    }
  };

  EmbeddedWorkerInstanceHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEmbeddedWorkerInstanceHost_RequestTermination_Name:
      var params = reader.decodeStruct(EmbeddedWorkerInstanceHost_RequestTermination_Params);
      this.requestTermination().then(function(response) {
        var responseParams =
            new EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams();
        responseParams.willBeTerminated = response.willBeTerminated;
        var builder = new codec.MessageV1Builder(
            kEmbeddedWorkerInstanceHost_RequestTermination_Name,
            codec.align(EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateEmbeddedWorkerInstanceHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEmbeddedWorkerInstanceHost_RequestTermination_Name:
        if (message.expectsResponse())
          paramsClass = EmbeddedWorkerInstanceHost_RequestTermination_Params;
      break;
      case kEmbeddedWorkerInstanceHost_CountFeature_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_CountFeature_Params;
      break;
      case kEmbeddedWorkerInstanceHost_OnReadyForInspection_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_OnReadyForInspection_Params;
      break;
      case kEmbeddedWorkerInstanceHost_OnScriptLoaded_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_OnScriptLoaded_Params;
      break;
      case kEmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_OnScriptEvaluationStart_Params;
      break;
      case kEmbeddedWorkerInstanceHost_OnStarted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_OnStarted_Params;
      break;
      case kEmbeddedWorkerInstanceHost_OnReportException_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_OnReportException_Params;
      break;
      case kEmbeddedWorkerInstanceHost_OnReportConsoleMessage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_OnReportConsoleMessage_Params;
      break;
      case kEmbeddedWorkerInstanceHost_OnStopped_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_OnStopped_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEmbeddedWorkerInstanceHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kEmbeddedWorkerInstanceHost_RequestTermination_Name:
        if (message.isResponse())
          paramsClass = EmbeddedWorkerInstanceHost_RequestTermination_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var EmbeddedWorkerInstanceHost = {
    name: 'blink.mojom.EmbeddedWorkerInstanceHost',
    kVersion: 0,
    ptrClass: EmbeddedWorkerInstanceHostPtr,
    proxyClass: EmbeddedWorkerInstanceHostProxy,
    stubClass: EmbeddedWorkerInstanceHostStub,
    validateRequest: validateEmbeddedWorkerInstanceHostRequest,
    validateResponse: validateEmbeddedWorkerInstanceHostResponse,
  };
  EmbeddedWorkerInstanceHostStub.prototype.validator = validateEmbeddedWorkerInstanceHostRequest;
  EmbeddedWorkerInstanceHostProxy.prototype.validator = validateEmbeddedWorkerInstanceHostResponse;
  exports.EmbeddedWorkerStartParams = EmbeddedWorkerStartParams;
  exports.EmbeddedWorkerStartTiming = EmbeddedWorkerStartTiming;
  exports.EmbeddedWorkerInstanceClient = EmbeddedWorkerInstanceClient;
  exports.EmbeddedWorkerInstanceClientPtr = EmbeddedWorkerInstanceClientPtr;
  exports.EmbeddedWorkerInstanceClientAssociatedPtr = EmbeddedWorkerInstanceClientAssociatedPtr;
  exports.EmbeddedWorkerInstanceHost = EmbeddedWorkerInstanceHost;
  exports.EmbeddedWorkerInstanceHostPtr = EmbeddedWorkerInstanceHostPtr;
  exports.EmbeddedWorkerInstanceHostAssociatedPtr = EmbeddedWorkerInstanceHostAssociatedPtr;
})();