// third_party/blink/public/mojom/service_worker/service_worker_object.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerObjectHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerObjectHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ServiceWorkerObjectHostInterface }
 */
blink.mojom.ServiceWorkerObjectHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerObjectHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerObjectHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerObjectHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.TransferableMessage } message
   */

  postMessageToServiceWorker(
      message) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  terminateForTesting() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec.$,
        blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerObjectHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerObjectHostReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerObjectHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerObjectHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerObjectHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerObjectHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec.$,
        null,
        impl.postMessageToServiceWorker.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec.$,
        blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec.$,
        impl.terminateForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerObjectHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerObjectHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerObjectHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerObjectHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerObjectHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerObjectHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerObjectHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerObjectHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.postMessageToServiceWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec.$,
        null,
        this.postMessageToServiceWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.terminateForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec.$,
        blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec.$,
        this.terminateForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ServiceWorkerObjectPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ServiceWorkerObject.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.ServiceWorkerObjectInterface }
 */
blink.mojom.ServiceWorkerObjectRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ServiceWorkerObjectPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ServiceWorkerObjectPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ServiceWorkerObjectPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.ServiceWorkerState } state
   */

  stateChanged(
      state) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ServiceWorkerObject_StateChanged_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ServiceWorkerObject
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ServiceWorkerObjectReceiver = class {
  /**
   * @param {!blink.mojom.ServiceWorkerObjectInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ServiceWorkerObjectRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ServiceWorkerObjectRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerObjectRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerObject_StateChanged_ParamsSpec.$,
        null,
        impl.stateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ServiceWorkerObject = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ServiceWorkerObject";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ServiceWorkerObjectRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ServiceWorkerObjectRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ServiceWorkerObject
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ServiceWorkerObjectCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ServiceWorkerObjectRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ServiceWorkerObjectRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ServiceWorkerObject_StateChanged_ParamsSpec.$,
        null,
        this.stateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerObjectInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ServiceWorkerObject_StateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ServiceWorkerObjectInfoSpec.$,
    'ServiceWorkerObjectInfo',
    [
      mojo.internal.StructField(
        'versionId', 0,
        0,
        mojo.internal.Int64,
        blink.mojom.INVALID_SERVICE_WORKER_VERSION_ID,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'state', 8,
        0,
        blink.mojom.ServiceWorkerStateSpec.$,
        blink.mojom.ServiceWorkerState.kParsed,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hostRemote', 24,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.ServiceWorkerObjectHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 12,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.ServiceWorkerObjectPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.ServiceWorkerObjectInfo = class {
  constructor() {
    /** @export { !bigint } */
    this.versionId;
    /** @export { !blink.mojom.ServiceWorkerState } */
    this.state;
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Object } */
    this.hostRemote;
    /** @export { !Object } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerObjectHost_PostMessageToServiceWorker_ParamsSpec.$,
    'ServiceWorkerObjectHost_PostMessageToServiceWorker_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        blink.mojom.TransferableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.ServiceWorkerObjectHost_PostMessageToServiceWorker_Params = class {
  constructor() {
    /** @export { !blink.mojom.TransferableMessage } */
    this.message;
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ParamsSpec.$,
    'ServiceWorkerObjectHost_TerminateForTesting_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ResponseParamsSpec.$,
    'ServiceWorkerObjectHost_TerminateForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.ServiceWorkerObjectHost_TerminateForTesting_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.ServiceWorkerObject_StateChanged_ParamsSpec.$,
    'ServiceWorkerObject_StateChanged_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.ServiceWorkerStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.ServiceWorkerObject_StateChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.ServiceWorkerState } */
    this.state;
  }
};

