// third_party/blink/public/mojom/shared_storage/shared_storage.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SharedStorageGetStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SharedStorageGetStatus = {
  
  kSuccess: 0,
  kNotFound: 1,
  kError: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SharedStorageWorkletCreationMethodSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SharedStorageWorkletCreationMethod = {
  
  kAddModule: 0,
  kCreateWorklet: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SharedStorageDataOriginTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SharedStorageDataOriginType = {
  
  kContextOrigin: 0,
  kScriptOrigin: 1,
  kCustomOrigin: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedStorageWorkletHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedStorageWorkletHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedStorageWorkletHostInterface }
 */
blink.mojom.SharedStorageWorkletHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedStorageWorkletHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedStorageWorkletHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedStorageWorkletHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } name
   * @param { !Array<!blink.mojom.SharedStorageUrlWithMetadata> } urlsWithMetadata
   * @param { !blink.mojom.CloneableMessage } serializedData
   * @param { !boolean } keepAliveAfterOperation
   * @param { !blink.mojom.PrivateAggregationConfig } privateAggregationConfig
   * @param { !boolean } resolveToConfig
   * @param { !mojoBase.mojom.String16 } savedQueryName
   * @param { !mojoBase.mojom.TimeTicks } startTime
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        config: ?blink.mojom.FencedFrameConfig,
   *  }>}
   */

  selectURL(
      name,
      urlsWithMetadata,
      serializedData,
      keepAliveAfterOperation,
      privateAggregationConfig,
      resolveToConfig,
      savedQueryName,
      startTime) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.SharedStorageWorkletHost_SelectURL_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletHost_SelectURL_ResponseParamsSpec.$,
        [
          name,
          urlsWithMetadata,
          serializedData,
          keepAliveAfterOperation,
          privateAggregationConfig,
          resolveToConfig,
          savedQueryName,
          startTime
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !blink.mojom.CloneableMessage } serializedData
   * @param { !boolean } keepAliveAfterOperation
   * @param { !blink.mojom.PrivateAggregationConfig } privateAggregationConfig
   * @param { !mojoBase.mojom.TimeTicks } startTime
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  run(
      name,
      serializedData,
      keepAliveAfterOperation,
      privateAggregationConfig,
      startTime) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.SharedStorageWorkletHost_Run_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletHost_Run_ResponseParamsSpec.$,
        [
          name,
          serializedData,
          keepAliveAfterOperation,
          privateAggregationConfig,
          startTime
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedStorageWorkletHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedStorageWorkletHostReceiver = class {
  /**
   * @param {!blink.mojom.SharedStorageWorkletHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedStorageWorkletHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedStorageWorkletHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageWorkletHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageWorkletHost_SelectURL_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletHost_SelectURL_ResponseParamsSpec.$,
        impl.selectURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedStorageWorkletHost_Run_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletHost_Run_ResponseParamsSpec.$,
        impl.run.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedStorageWorkletHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageWorkletHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedStorageWorkletHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedStorageWorkletHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedStorageWorkletHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedStorageWorkletHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedStorageWorkletHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageWorkletHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageWorkletHost_SelectURL_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletHost_SelectURL_ResponseParamsSpec.$,
        this.selectURL.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.run =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedStorageWorkletHost_Run_ParamsSpec.$,
        blink.mojom.SharedStorageWorkletHost_Run_ResponseParamsSpec.$,
        this.run.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedStorageDocumentServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedStorageDocumentService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedStorageDocumentServiceInterface }
 */
blink.mojom.SharedStorageDocumentServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedStorageDocumentServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedStorageDocumentServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedStorageDocumentServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } scriptSourceUrl
   * @param { !url.mojom.Origin } dataOrigin
   * @param { !blink.mojom.SharedStorageDataOriginType } dataOriginType
   * @param { !network.mojom.CredentialsMode } credentialsMode
   * @param { !blink.mojom.SharedStorageWorkletCreationMethod } creationMethod
   * @param { !Array<!blink.mojom.OriginTrialFeature> } originTrialFeatures
   * @param { !Object } workletHost
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  createWorklet(
      scriptSourceUrl,
      dataOrigin,
      dataOriginType,
      credentialsMode,
      creationMethod,
      originTrialFeatures,
      workletHost) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.SharedStorageDocumentService_CreateWorklet_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec.$,
        [
          scriptSourceUrl,
          dataOrigin,
          dataOriginType,
          credentialsMode,
          creationMethod,
          originTrialFeatures,
          workletHost
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SharedStorageKeyArgument } key
   * @return {!Promise<{
        status: !blink.mojom.SharedStorageGetStatus,
        errorMessage: !string,
        value: !mojoBase.mojom.String16,
   *  }>}
   */

  sharedStorageGet(
      key) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.SharedStorageDocumentService_SharedStorageGet_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SharedStorageModifierMethodWithOptions } methodWithOptions
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageUpdate(
      methodWithOptions) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec.$,
        [
          methodWithOptions
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network.mojom.LockName } withLock
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageBatchUpdate(
      methodsWithOptions,
      withLock) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        [
          methodsWithOptions,
          withLock
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedStorageDocumentService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedStorageDocumentServiceReceiver = class {
  /**
   * @param {!blink.mojom.SharedStorageDocumentServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedStorageDocumentServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedStorageDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageDocumentService_CreateWorklet_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec.$,
        impl.createWorklet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedStorageDocumentService_SharedStorageGet_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec.$,
        impl.sharedStorageGet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec.$,
        impl.sharedStorageUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        impl.sharedStorageBatchUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedStorageDocumentService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageDocumentService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedStorageDocumentServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedStorageDocumentServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedStorageDocumentService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedStorageDocumentServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedStorageDocumentServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedStorageDocumentServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWorklet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedStorageDocumentService_CreateWorklet_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec.$,
        this.createWorklet.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageGet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedStorageDocumentService_SharedStorageGet_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec.$,
        this.sharedStorageGet.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec.$,
        this.sharedStorageUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageBatchUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec.$,
        blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        this.sharedStorageBatchUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageUrlWithMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PrivateAggregationConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletHost_SelectURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletHost_SelectURL_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletHost_Run_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageWorkletHost_Run_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageDocumentService_CreateWorklet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageDocumentService_SharedStorageGet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SharedStorageUrlWithMetadataSpec.$,
    'SharedStorageUrlWithMetadata',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportingMetadata', 8,
        0,
        mojo.internal.Map(mojo.internal.String, url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageUrlWithMetadata = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Object<!string, !url.mojom.Url> } */
    this.reportingMetadata;
  }
};



mojo.internal.Struct(
    blink.mojom.PrivateAggregationConfigSpec.$,
    'PrivateAggregationConfig',
    [
      mojo.internal.StructField(
        'aggregationCoordinatorOrigin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contextId', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filteringIdMaxBytes', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'max_contributions_$flag', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "max_contributions_$value",
          originalFieldName: "maxContributions",
        }
      ),
      mojo.internal.StructField(
        'max_contributions_$value', 22,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "maxContributions",
        }
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.PrivateAggregationConfig = class {
  constructor() {
    /** @export { (url.mojom.Origin|undefined) } */
    this.aggregationCoordinatorOrigin;
    /** @export { (string|undefined) } */
    this.contextId;
    /** @export { !number } */
    this.filteringIdMaxBytes;
    /** @export { (number|undefined) } */
    this.maxContributions;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletHost_SelectURL_ParamsSpec.$,
    'SharedStorageWorkletHost_SelectURL_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlsWithMetadata', 8,
        0,
        mojo.internal.Array(blink.mojom.SharedStorageUrlWithMetadataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serializedData', 16,
        0,
        blink.mojom.CloneableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keepAliveAfterOperation', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'privateAggregationConfig', 32,
        0,
        blink.mojom.PrivateAggregationConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resolveToConfig', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'savedQueryName', 40,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startTime', 48,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
blink.mojom.SharedStorageWorkletHost_SelectURL_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !Array<!blink.mojom.SharedStorageUrlWithMetadata> } */
    this.urlsWithMetadata;
    /** @export { !blink.mojom.CloneableMessage } */
    this.serializedData;
    /** @export { !boolean } */
    this.keepAliveAfterOperation;
    /** @export { !blink.mojom.PrivateAggregationConfig } */
    this.privateAggregationConfig;
    /** @export { !boolean } */
    this.resolveToConfig;
    /** @export { !mojoBase.mojom.String16 } */
    this.savedQueryName;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.startTime;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletHost_SelectURL_ResponseParamsSpec.$,
    'SharedStorageWorkletHost_SelectURL_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'config', 16,
        0,
        blink.mojom.FencedFrameConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.SharedStorageWorkletHost_SelectURL_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
    /** @export { (blink.mojom.FencedFrameConfig|undefined) } */
    this.config;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletHost_Run_ParamsSpec.$,
    'SharedStorageWorkletHost_Run_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serializedData', 8,
        0,
        blink.mojom.CloneableMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keepAliveAfterOperation', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'privateAggregationConfig', 24,
        0,
        blink.mojom.PrivateAggregationConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startTime', 32,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.SharedStorageWorkletHost_Run_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !blink.mojom.CloneableMessage } */
    this.serializedData;
    /** @export { !boolean } */
    this.keepAliveAfterOperation;
    /** @export { !blink.mojom.PrivateAggregationConfig } */
    this.privateAggregationConfig;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.startTime;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageWorkletHost_Run_ResponseParamsSpec.$,
    'SharedStorageWorkletHost_Run_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageWorkletHost_Run_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageDocumentService_CreateWorklet_ParamsSpec.$,
    'SharedStorageDocumentService_CreateWorklet_Params',
    [
      mojo.internal.StructField(
        'scriptSourceUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataOrigin', 8,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataOriginType', 16,
        0,
        blink.mojom.SharedStorageDataOriginTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credentialsMode', 20,
        0,
        network.mojom.CredentialsModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'creationMethod', 24,
        0,
        blink.mojom.SharedStorageWorkletCreationMethodSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originTrialFeatures', 32,
        0,
        mojo.internal.Array(blink.mojom.OriginTrialFeatureSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'workletHost', 28,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.SharedStorageWorkletHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
blink.mojom.SharedStorageDocumentService_CreateWorklet_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.scriptSourceUrl;
    /** @export { !url.mojom.Origin } */
    this.dataOrigin;
    /** @export { !blink.mojom.SharedStorageDataOriginType } */
    this.dataOriginType;
    /** @export { !network.mojom.CredentialsMode } */
    this.credentialsMode;
    /** @export { !blink.mojom.SharedStorageWorkletCreationMethod } */
    this.creationMethod;
    /** @export { !Array<!blink.mojom.OriginTrialFeature> } */
    this.originTrialFeatures;
    /** @export { !Object } */
    this.workletHost;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageDocumentService_CreateWorklet_ResponseParamsSpec.$,
    'SharedStorageDocumentService_CreateWorklet_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageDocumentService_CreateWorklet_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageDocumentService_SharedStorageGet_ParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageGet_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        network.mojom.SharedStorageKeyArgumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageDocumentService_SharedStorageGet_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedStorageKeyArgument } */
    this.key;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageDocumentService_SharedStorageGet_ResponseParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageGet_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.SharedStorageGetStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.SharedStorageDocumentService_SharedStorageGet_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.SharedStorageGetStatus } */
    this.status;
    /** @export { !string } */
    this.errorMessage;
    /** @export { !mojoBase.mojom.String16 } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageUpdate_Params',
    [
      mojo.internal.StructField(
        'methodWithOptions', 0,
        0,
        network.mojom.SharedStorageModifierMethodWithOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedStorageModifierMethodWithOptions } */
    this.methodWithOptions;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ResponseParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageUpdate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageDocumentService_SharedStorageUpdate_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageBatchUpdate_Params',
    [
      mojo.internal.StructField(
        'methodsWithOptions', 0,
        0,
        network.mojom.SharedStorageBatchUpdateMethodsArgumentSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'withLock', 8,
        0,
        network.mojom.LockNameSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_Params = class {
  constructor() {
    /** @export { !network.mojom.SharedStorageBatchUpdateMethodsArgument } */
    this.methodsWithOptions;
    /** @export { (network.mojom.LockName|undefined) } */
    this.withLock;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParamsSpec.$,
    'SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedStorageDocumentService_SharedStorageBatchUpdate_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.errorMessage;
  }
};

