// third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  LockName as network_mojom_LockName,
  LockNameSpec as network_mojom_LockNameSpec,
  SharedStorageBatchUpdateMethodsArgument as network_mojom_SharedStorageBatchUpdateMethodsArgument,
  SharedStorageBatchUpdateMethodsArgumentSpec as network_mojom_SharedStorageBatchUpdateMethodsArgumentSpec,
  SharedStorageKeyArgument as network_mojom_SharedStorageKeyArgument,
  SharedStorageKeyArgumentSpec as network_mojom_SharedStorageKeyArgumentSpec,
  SharedStorageModifierMethodWithOptions as network_mojom_SharedStorageModifierMethodWithOptions,
  SharedStorageModifierMethodWithOptionsSpec as network_mojom_SharedStorageModifierMethodWithOptionsSpec
} from '../../../../../services/network/public/mojom/shared_storage.mojom.m.js';

import {
  URLLoaderFactoryRemote as network_mojom_URLLoaderFactoryRemote,
  URLLoaderFactoryPendingReceiver as network_mojom_URLLoaderFactoryPendingReceiver
} from '../../../../../services/network/public/mojom/url_loader_factory.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  ConsoleMessageLevel as blink_mojom_ConsoleMessageLevel,
  ConsoleMessageLevelSpec as blink_mojom_ConsoleMessageLevelSpec
} from '../devtools/console_message.mojom.m.js';

import {
  StorageInterestGroup as blink_mojom_StorageInterestGroup,
  StorageInterestGroupSpec as blink_mojom_StorageInterestGroupSpec
} from '../interest_group/interest_group_types.mojom.m.js';

import {
  CloneableMessage as blink_mojom_CloneableMessage,
  CloneableMessageSpec as blink_mojom_CloneableMessageSpec
} from '../messaging/cloneable_message.mojom.m.js';

import {
  PrivateAggregationHostRemote as blink_mojom_PrivateAggregationHostRemote,
  PrivateAggregationHostPendingReceiver as blink_mojom_PrivateAggregationHostPendingReceiver
} from '../private_aggregation/private_aggregation_host.mojom.m.js';

import {
  WebFeature as blink_mojom_WebFeature,
  WebFeatureSpec as blink_mojom_WebFeatureSpec
} from '../use_counter/metrics/web_feature.mojom.m.js';

import {
  SharedStorageGetStatus as blink_mojom_SharedStorageGetStatus,
  SharedStorageGetStatusSpec as blink_mojom_SharedStorageGetStatusSpec
} from './shared_storage.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedStorageEntriesListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedStorageEntriesListener', scope);
  }
}

/** @interface */
export class SharedStorageEntriesListenerInterface {
  
  /**
   * @param { !boolean } success
   * @param { !string } errorMessage
   * @param { !Array<!SharedStorageKeyAndOrValue> } entries
   * @param { !boolean } hasMoreEntries
   * @param { !number } totalQueuedToSend
   */

  didReadEntries(success, errorMessage, entries, hasMoreEntries, totalQueuedToSend) {}
}

/**
 * @implements { SharedStorageEntriesListenerInterface }
 */
export class SharedStorageEntriesListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedStorageEntriesListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedStorageEntriesListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedStorageEntriesListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } success
   * @param { !string } errorMessage
   * @param { !Array<!SharedStorageKeyAndOrValue> } entries
   * @param { !boolean } hasMoreEntries
   * @param { !number } totalQueuedToSend
   */

  didReadEntries(
      success,
      errorMessage,
      entries,
      hasMoreEntries,
      totalQueuedToSend) {
    this.proxy.sendMessage(
        0,
        SharedStorageEntriesListener_DidReadEntries_ParamsSpec.$,
        null,
        [
          success,
          errorMessage,
          entries,
          hasMoreEntries,
          totalQueuedToSend
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedStorageEntriesListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedStorageEntriesListenerReceiver {
  /**
   * @param {!SharedStorageEntriesListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedStorageEntriesListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedStorageEntriesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageEntriesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedStorageEntriesListener_DidReadEntries_ParamsSpec.$,
        null,
        impl.didReadEntries.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedStorageEntriesListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageEntriesListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedStorageEntriesListenerRemote}
   */
  static getRemote() {
    let remote = new SharedStorageEntriesListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedStorageEntriesListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedStorageEntriesListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedStorageEntriesListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageEntriesListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didReadEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedStorageEntriesListener_DidReadEntries_ParamsSpec.$,
        null,
        this.didReadEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedStorageWorkletServiceClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedStorageWorkletServiceClient', scope);
  }
}

/** @interface */
export class SharedStorageWorkletServiceClientInterface {
  
  /**
   * @param { !network_mojom_SharedStorageModifierMethodWithOptions } methodWithOptions
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageUpdate(methodWithOptions) {}
  
  /**
   * @param { !network_mojom_SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network_mojom_LockName } withLock
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageBatchUpdate(methodsWithOptions, withLock) {}
  
  /**
   * @param { !network_mojom_SharedStorageKeyArgument } key
   * @return {!Promise<{
        status: !blink_mojom_SharedStorageGetStatus,
        errorMessage: !string,
        value: !mojoBase_mojom_String16,
   *  }>}
   */

  sharedStorageGet(key) {}
  
  /**
   * @param { !SharedStorageEntriesListenerRemote } listener
   */

  sharedStorageKeys(listener) {}
  
  /**
   * @param { !SharedStorageEntriesListenerRemote } listener
   * @param { !boolean } valuesOnly
   */

  sharedStorageEntries(listener, valuesOnly) {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        length: !number,
   *  }>}
   */

  sharedStorageLength() {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        bits: !number,
   *  }>}
   */

  sharedStorageRemainingBudget() {}
  
  /**
   * @return {!Promise<{
        result: !GetInterestGroupsResult,
   *  }>}
   */

  getInterestGroups() {}
  
  /**
   * @param { !blink_mojom_ConsoleMessageLevel } logLevel
   * @param { !string } message
   */

  didAddMessageToConsole(logLevel, message) {}
  
  /**
   * @param { !Array<!blink_mojom_WebFeature> } features
   */

  recordUseCounters(features) {}
}

/**
 * @implements { SharedStorageWorkletServiceClientInterface }
 */
export class SharedStorageWorkletServiceClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedStorageWorkletServiceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedStorageWorkletServiceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedStorageWorkletServiceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_SharedStorageModifierMethodWithOptions } methodWithOptions
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageUpdate(
      methodWithOptions) {
    return this.proxy.sendMessage(
        0,
        SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec.$,
        [
          methodWithOptions
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_SharedStorageBatchUpdateMethodsArgument } methodsWithOptions
   * @param { ?network_mojom_LockName } withLock
   * @return {!Promise<{
        errorMessage: !string,
   *  }>}
   */

  sharedStorageBatchUpdate(
      methodsWithOptions,
      withLock) {
    return this.proxy.sendMessage(
        1,
        SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        [
          methodsWithOptions,
          withLock
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_SharedStorageKeyArgument } key
   * @return {!Promise<{
        status: !blink_mojom_SharedStorageGetStatus,
        errorMessage: !string,
        value: !mojoBase_mojom_String16,
   *  }>}
   */

  sharedStorageGet(
      key) {
    return this.proxy.sendMessage(
        2,
        SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { !SharedStorageEntriesListenerRemote } listener
   */

  sharedStorageKeys(
      listener) {
    this.proxy.sendMessage(
        3,
        SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }

  
  /**
   * @param { !SharedStorageEntriesListenerRemote } listener
   * @param { !boolean } valuesOnly
   */

  sharedStorageEntries(
      listener,
      valuesOnly) {
    this.proxy.sendMessage(
        4,
        SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec.$,
        null,
        [
          listener,
          valuesOnly
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        length: !number,
   *  }>}
   */

  sharedStorageLength() {
    return this.proxy.sendMessage(
        5,
        SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        bits: !number,
   *  }>}
   */

  sharedStorageRemainingBudget() {
    return this.proxy.sendMessage(
        6,
        SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !GetInterestGroupsResult,
   *  }>}
   */

  getInterestGroups() {
    return this.proxy.sendMessage(
        7,
        SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec.$,
        SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_ConsoleMessageLevel } logLevel
   * @param { !string } message
   */

  didAddMessageToConsole(
      logLevel,
      message) {
    this.proxy.sendMessage(
        8,
        SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec.$,
        null,
        [
          logLevel,
          message
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink_mojom_WebFeature> } features
   */

  recordUseCounters(
      features) {
    this.proxy.sendMessage(
        9,
        SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec.$,
        null,
        [
          features
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedStorageWorkletServiceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedStorageWorkletServiceClientReceiver {
  /**
   * @param {!SharedStorageWorkletServiceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedStorageWorkletServiceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedStorageWorkletServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageWorkletServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec.$,
        impl.sharedStorageUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        impl.sharedStorageBatchUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec.$,
        impl.sharedStorageGet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec.$,
        null,
        impl.sharedStorageKeys.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec.$,
        null,
        impl.sharedStorageEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec.$,
        impl.sharedStorageLength.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec.$,
        impl.sharedStorageRemainingBudget.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec.$,
        SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec.$,
        impl.getInterestGroups.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec.$,
        null,
        impl.didAddMessageToConsole.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec.$,
        null,
        impl.recordUseCounters.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedStorageWorkletServiceClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageWorkletServiceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedStorageWorkletServiceClientRemote}
   */
  static getRemote() {
    let remote = new SharedStorageWorkletServiceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedStorageWorkletServiceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedStorageWorkletServiceClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedStorageWorkletServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageWorkletServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec.$,
        this.sharedStorageUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageBatchUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec.$,
        this.sharedStorageBatchUpdate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageGet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec.$,
        this.sharedStorageGet.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageKeys =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec.$,
        null,
        this.sharedStorageKeys.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec.$,
        null,
        this.sharedStorageEntries.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageLength =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec.$,
        this.sharedStorageLength.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sharedStorageRemainingBudget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec.$,
        SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec.$,
        this.sharedStorageRemainingBudget.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInterestGroups =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec.$,
        SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec.$,
        this.getInterestGroups.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didAddMessageToConsole =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec.$,
        null,
        this.didAddMessageToConsole.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recordUseCounters =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec.$,
        null,
        this.recordUseCounters.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedStorageWorkletServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedStorageWorkletService', scope);
  }
}

/** @interface */
export class SharedStorageWorkletServiceInterface {
  
  /**
   * @param { !Object } client
   * @param { !SharedStorageWorkletPermissionsPolicyState } permissionsPolicyState
   * @param { ?mojoBase_mojom_String16 } embedderContext
   */

  initialize(client, permissionsPolicyState, embedderContext) {}
  
  /**
   * @param { !network_mojom_URLLoaderFactoryRemote } urlLoaderFactory
   * @param { !url_mojom_Url } scriptSourceUrl
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  addModule(urlLoaderFactory, scriptSourceUrl) {}
  
  /**
   * @param { !string } name
   * @param { !Array<!url_mojom_Url> } urls
   * @param { !blink_mojom_CloneableMessage } serializedData
   * @param { ?PrivateAggregationOperationDetails } paOperationDetails
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        index: !number,
   *  }>}
   */

  runURLSelectionOperation(name, urls, serializedData, paOperationDetails) {}
  
  /**
   * @param { !string } name
   * @param { !blink_mojom_CloneableMessage } serializedData
   * @param { ?PrivateAggregationOperationDetails } paOperationDetails
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  runOperation(name, serializedData, paOperationDetails) {}
}

/**
 * @implements { SharedStorageWorkletServiceInterface }
 */
export class SharedStorageWorkletServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedStorageWorkletServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedStorageWorkletServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedStorageWorkletServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @param { !SharedStorageWorkletPermissionsPolicyState } permissionsPolicyState
   * @param { ?mojoBase_mojom_String16 } embedderContext
   */

  initialize(
      client,
      permissionsPolicyState,
      embedderContext) {
    this.proxy.sendMessage(
        0,
        SharedStorageWorkletService_Initialize_ParamsSpec.$,
        null,
        [
          client,
          permissionsPolicyState,
          embedderContext
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_URLLoaderFactoryRemote } urlLoaderFactory
   * @param { !url_mojom_Url } scriptSourceUrl
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  addModule(
      urlLoaderFactory,
      scriptSourceUrl) {
    return this.proxy.sendMessage(
        1,
        SharedStorageWorkletService_AddModule_ParamsSpec.$,
        SharedStorageWorkletService_AddModule_ResponseParamsSpec.$,
        [
          urlLoaderFactory,
          scriptSourceUrl
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !Array<!url_mojom_Url> } urls
   * @param { !blink_mojom_CloneableMessage } serializedData
   * @param { ?PrivateAggregationOperationDetails } paOperationDetails
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
        index: !number,
   *  }>}
   */

  runURLSelectionOperation(
      name,
      urls,
      serializedData,
      paOperationDetails) {
    return this.proxy.sendMessage(
        2,
        SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec.$,
        SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec.$,
        [
          name,
          urls,
          serializedData,
          paOperationDetails
        ],
        false);
  }

  
  /**
   * @param { !string } name
   * @param { !blink_mojom_CloneableMessage } serializedData
   * @param { ?PrivateAggregationOperationDetails } paOperationDetails
   * @return {!Promise<{
        success: !boolean,
        errorMessage: !string,
   *  }>}
   */

  runOperation(
      name,
      serializedData,
      paOperationDetails) {
    return this.proxy.sendMessage(
        3,
        SharedStorageWorkletService_RunOperation_ParamsSpec.$,
        SharedStorageWorkletService_RunOperation_ResponseParamsSpec.$,
        [
          name,
          serializedData,
          paOperationDetails
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedStorageWorkletService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedStorageWorkletServiceReceiver {
  /**
   * @param {!SharedStorageWorkletServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedStorageWorkletServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedStorageWorkletServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageWorkletServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedStorageWorkletService_Initialize_ParamsSpec.$,
        null,
        impl.initialize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SharedStorageWorkletService_AddModule_ParamsSpec.$,
        SharedStorageWorkletService_AddModule_ResponseParamsSpec.$,
        impl.addModule.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec.$,
        SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec.$,
        impl.runURLSelectionOperation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SharedStorageWorkletService_RunOperation_ParamsSpec.$,
        SharedStorageWorkletService_RunOperation_ResponseParamsSpec.$,
        impl.runOperation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedStorageWorkletService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedStorageWorkletService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedStorageWorkletServiceRemote}
   */
  static getRemote() {
    let remote = new SharedStorageWorkletServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedStorageWorkletService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedStorageWorkletServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedStorageWorkletServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedStorageWorkletServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedStorageWorkletService_Initialize_ParamsSpec.$,
        null,
        this.initialize.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addModule =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SharedStorageWorkletService_AddModule_ParamsSpec.$,
        SharedStorageWorkletService_AddModule_ResponseParamsSpec.$,
        this.addModule.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runURLSelectionOperation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec.$,
        SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec.$,
        this.runURLSelectionOperation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runOperation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SharedStorageWorkletService_RunOperation_ParamsSpec.$,
        SharedStorageWorkletService_RunOperation_ResponseParamsSpec.$,
        this.runOperation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletPermissionsPolicyStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageKeyAndOrValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PrivateAggregationOperationDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageEntriesListener_DidReadEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletService_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletService_AddModule_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletService_AddModule_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletService_RunOperation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedStorageWorkletService_RunOperation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const GetInterestGroupsResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SharedStorageWorkletPermissionsPolicyStateSpec.$,
    'SharedStorageWorkletPermissionsPolicyState',
    [
      mojo.internal.StructField(
        'privateAggregationAllowed', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'joinAdInterestGroupAllowed', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'runAdAuctionAllowed', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageWorkletPermissionsPolicyState {
  constructor() {
    /** @type { !boolean } */
    this.privateAggregationAllowed;
    /** @type { !boolean } */
    this.joinAdInterestGroupAllowed;
    /** @type { !boolean } */
    this.runAdAuctionAllowed;
  }
}



mojo.internal.Struct(
    SharedStorageKeyAndOrValueSpec.$,
    'SharedStorageKeyAndOrValue',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageKeyAndOrValue {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.key;
    /** @type { !mojoBase_mojom_String16 } */
    this.value;
  }
}



mojo.internal.Struct(
    PrivateAggregationOperationDetailsSpec.$,
    'PrivateAggregationOperationDetails',
    [
      mojo.internal.StructField(
        'paHost', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_PrivateAggregationHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filteringIdMaxBytes', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PrivateAggregationOperationDetails {
  constructor() {
    /** @type { !blink_mojom_PrivateAggregationHostRemote } */
    this.paHost;
    /** @type { !number } */
    this.filteringIdMaxBytes;
  }
}



mojo.internal.Struct(
    SharedStorageEntriesListener_DidReadEntries_ParamsSpec.$,
    'SharedStorageEntriesListener_DidReadEntries_Params',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entries', 16,
        0,
        mojo.internal.Array(SharedStorageKeyAndOrValueSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasMoreEntries', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'totalQueuedToSend', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedStorageEntriesListener_DidReadEntries_Params {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
    /** @type { !Array<!SharedStorageKeyAndOrValue> } */
    this.entries;
    /** @type { !boolean } */
    this.hasMoreEntries;
    /** @type { !number } */
    this.totalQueuedToSend;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageUpdate_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageUpdate_Params',
    [
      mojo.internal.StructField(
        'methodWithOptions', 0,
        0,
        network_mojom_SharedStorageModifierMethodWithOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageUpdate_Params {
  constructor() {
    /** @type { !network_mojom_SharedStorageModifierMethodWithOptions } */
    this.methodWithOptions;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageUpdate_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params',
    [
      mojo.internal.StructField(
        'methodsWithOptions', 0,
        0,
        network_mojom_SharedStorageBatchUpdateMethodsArgumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'withLock', 8,
        0,
        network_mojom_LockNameSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_Params {
  constructor() {
    /** @type { !network_mojom_SharedStorageBatchUpdateMethodsArgument } */
    this.methodsWithOptions;
    /** @type { (network_mojom_LockName|undefined) } */
    this.withLock;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageBatchUpdate_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageGet_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageGet_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        network_mojom_SharedStorageKeyArgumentSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageGet_Params {
  constructor() {
    /** @type { !network_mojom_SharedStorageKeyArgument } */
    this.key;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_SharedStorageGetStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageGet_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_SharedStorageGetStatus } */
    this.status;
    /** @type { !string } */
    this.errorMessage;
    /** @type { !mojoBase_mojom_String16 } */
    this.value;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageKeys_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageKeys_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(SharedStorageEntriesListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageKeys_Params {
  constructor() {
    /** @type { !SharedStorageEntriesListenerRemote } */
    this.listener;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageEntries_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageEntries_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceProxy(SharedStorageEntriesListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'valuesOnly', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageEntries_Params {
  constructor() {
    /** @type { !SharedStorageEntriesListenerRemote } */
    this.listener;
    /** @type { !boolean } */
    this.valuesOnly;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageLength_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageLength_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageLength_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageLength_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
    /** @type { !number } */
    this.length;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bits', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_SharedStorageRemainingBudget_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
    /** @type { !number } */
    this.bits;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_GetInterestGroups_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_GetInterestGroups_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_GetInterestGroups_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParamsSpec.$,
    'SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        GetInterestGroupsResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_GetInterestGroups_ResponseParams {
  constructor() {
    /** @type { !GetInterestGroupsResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_DidAddMessageToConsole_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params',
    [
      mojo.internal.StructField(
        'logLevel', 0,
        0,
        blink_mojom_ConsoleMessageLevelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_DidAddMessageToConsole_Params {
  constructor() {
    /** @type { !blink_mojom_ConsoleMessageLevel } */
    this.logLevel;
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletServiceClient_RecordUseCounters_ParamsSpec.$,
    'SharedStorageWorkletServiceClient_RecordUseCounters_Params',
    [
      mojo.internal.StructField(
        'features', 0,
        0,
        mojo.internal.Array(blink_mojom_WebFeatureSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedStorageWorkletServiceClient_RecordUseCounters_Params {
  constructor() {
    /** @type { !Array<!blink_mojom_WebFeature> } */
    this.features;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletService_Initialize_ParamsSpec.$,
    'SharedStorageWorkletService_Initialize_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(SharedStorageWorkletServiceClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'permissionsPolicyState', 8,
        0,
        SharedStorageWorkletPermissionsPolicyStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'embedderContext', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedStorageWorkletService_Initialize_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
    /** @type { !SharedStorageWorkletPermissionsPolicyState } */
    this.permissionsPolicyState;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.embedderContext;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletService_AddModule_ParamsSpec.$,
    'SharedStorageWorkletService_AddModule_Params',
    [
      mojo.internal.StructField(
        'urlLoaderFactory', 0,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scriptSourceUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletService_AddModule_Params {
  constructor() {
    /** @type { !network_mojom_URLLoaderFactoryRemote } */
    this.urlLoaderFactory;
    /** @type { !url_mojom_Url } */
    this.scriptSourceUrl;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletService_AddModule_ResponseParamsSpec.$,
    'SharedStorageWorkletService_AddModule_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletService_AddModule_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletService_RunURLSelectionOperation_ParamsSpec.$,
    'SharedStorageWorkletService_RunURLSelectionOperation_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urls', 8,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serializedData', 16,
        0,
        blink_mojom_CloneableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paOperationDetails', 24,
        0,
        PrivateAggregationOperationDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class SharedStorageWorkletService_RunURLSelectionOperation_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !Array<!url_mojom_Url> } */
    this.urls;
    /** @type { !blink_mojom_CloneableMessage } */
    this.serializedData;
    /** @type { (PrivateAggregationOperationDetails|undefined) } */
    this.paOperationDetails;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletService_RunURLSelectionOperation_ResponseParamsSpec.$,
    'SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'index', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletService_RunURLSelectionOperation_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
    /** @type { !number } */
    this.index;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletService_RunOperation_ParamsSpec.$,
    'SharedStorageWorkletService_RunOperation_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serializedData', 8,
        0,
        blink_mojom_CloneableMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'paOperationDetails', 16,
        0,
        PrivateAggregationOperationDetailsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SharedStorageWorkletService_RunOperation_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !blink_mojom_CloneableMessage } */
    this.serializedData;
    /** @type { (PrivateAggregationOperationDetails|undefined) } */
    this.paOperationDetails;
  }
}



mojo.internal.Struct(
    SharedStorageWorkletService_RunOperation_ResponseParamsSpec.$,
    'SharedStorageWorkletService_RunOperation_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SharedStorageWorkletService_RunOperation_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !string } */
    this.errorMessage;
  }
}

mojo.internal.Union(
    GetInterestGroupsResultSpec.$, 'GetInterestGroupsResult',
    {
      'errorMessage': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'groups': {
        'ordinal': 1,
        'type': mojo.internal.Array(blink_mojom_StorageInterestGroupSpec.$, false),
      },
    });

/**
 * @typedef { {
 *   errorMessage: (!string|undefined),
 *   groups: (!Array<!blink_mojom_StorageInterestGroup>|undefined),
 * } }
 */
export const GetInterestGroupsResult = {};
