// third_party/blink/public/mojom/storage_access/storage_access_handle.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.BlobURLStore');
goog.require('blink.mojom.BroadcastChannelProvider');
goog.require('blink.mojom.CacheStorage');
goog.require('blink.mojom.FileSystemAccessDirectoryHandle');
goog.require('blink.mojom.IDBFactory');
goog.require('blink.mojom.LockManager');
goog.require('blink.mojom.SharedWorkerConnector');
goog.require('mojoBase.mojom.ByteCount');
goog.require('blink.mojom.FileSystemAccessError');






goog.provide('blink.mojom.StorageAccessHandle');
goog.provide('blink.mojom.StorageAccessHandleReceiver');
goog.provide('blink.mojom.StorageAccessHandleCallbackRouter');
goog.provide('blink.mojom.StorageAccessHandleInterface');
goog.provide('blink.mojom.StorageAccessHandleRemote');
goog.provide('blink.mojom.StorageAccessHandlePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.StorageAccessHandlePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.StorageAccessHandle.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.StorageAccessHandleInterface = class {
  
  /**
   * @param { !blink.mojom.IDBFactoryPendingReceiver } receiver
   */

  bindIndexedDB(receiver) {}
  
  /**
   * @param { !blink.mojom.LockManagerPendingReceiver } receiver
   */

  bindLocks(receiver) {}
  
  /**
   * @param { !blink.mojom.CacheStoragePendingReceiver } receiver
   */

  bindCaches(receiver) {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory() {}
  
  /**
   * @return {!Promise<{
        currentUsage: !mojoBase.mojom.ByteCount,
        currentQuota: !mojoBase.mojom.ByteCount,
        success: !boolean,
   *  }>}
   */

  estimate() {}
  
  /**
   * @param { !Object } receiver
   */

  bindBlobStorage(receiver) {}
  
  /**
   * @param { !Object } receiver
   */

  bindBroadcastChannel(receiver) {}
  
  /**
   * @param { !blink.mojom.SharedWorkerConnectorPendingReceiver } receiver
   */

  bindSharedWorker(receiver) {}
};

/**
 * @export
 * @implements { blink.mojom.StorageAccessHandleInterface }
 */
blink.mojom.StorageAccessHandleRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.StorageAccessHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.StorageAccessHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.StorageAccessHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.IDBFactoryPendingReceiver } receiver
   */

  bindIndexedDB(
      receiver) {
    this.proxy.sendMessage(
        0,
        blink.mojom.StorageAccessHandle_BindIndexedDB_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.LockManagerPendingReceiver } receiver
   */

  bindLocks(
      receiver) {
    this.proxy.sendMessage(
        1,
        blink.mojom.StorageAccessHandle_BindLocks_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.CacheStoragePendingReceiver } receiver
   */

  bindCaches(
      receiver) {
    this.proxy.sendMessage(
        2,
        blink.mojom.StorageAccessHandle_BindCaches_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getDirectory() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.StorageAccessHandle_GetDirectory_ParamsSpec.$,
        blink.mojom.StorageAccessHandle_GetDirectory_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        currentUsage: !mojoBase.mojom.ByteCount,
        currentQuota: !mojoBase.mojom.ByteCount,
        success: !boolean,
   *  }>}
   */

  estimate() {
    return this.proxy.sendMessage(
        4,
        blink.mojom.StorageAccessHandle_Estimate_ParamsSpec.$,
        blink.mojom.StorageAccessHandle_Estimate_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } receiver
   */

  bindBlobStorage(
      receiver) {
    this.proxy.sendMessage(
        5,
        blink.mojom.StorageAccessHandle_BindBlobStorage_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !Object } receiver
   */

  bindBroadcastChannel(
      receiver) {
    this.proxy.sendMessage(
        6,
        blink.mojom.StorageAccessHandle_BindBroadcastChannel_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.SharedWorkerConnectorPendingReceiver } receiver
   */

  bindSharedWorker(
      receiver) {
    this.proxy.sendMessage(
        7,
        blink.mojom.StorageAccessHandle_BindSharedWorker_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the StorageAccessHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.StorageAccessHandleReceiver = class {
  /**
   * @param {!blink.mojom.StorageAccessHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.StorageAccessHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.StorageAccessHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.StorageAccessHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.StorageAccessHandle_BindIndexedDB_ParamsSpec.$,
        null,
        impl.bindIndexedDB.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.StorageAccessHandle_BindLocks_ParamsSpec.$,
        null,
        impl.bindLocks.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.StorageAccessHandle_BindCaches_ParamsSpec.$,
        null,
        impl.bindCaches.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.StorageAccessHandle_GetDirectory_ParamsSpec.$,
        blink.mojom.StorageAccessHandle_GetDirectory_ResponseParamsSpec.$,
        impl.getDirectory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.StorageAccessHandle_Estimate_ParamsSpec.$,
        blink.mojom.StorageAccessHandle_Estimate_ResponseParamsSpec.$,
        impl.estimate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.StorageAccessHandle_BindBlobStorage_ParamsSpec.$,
        null,
        impl.bindBlobStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.StorageAccessHandle_BindBroadcastChannel_ParamsSpec.$,
        null,
        impl.bindBroadcastChannel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.StorageAccessHandle_BindSharedWorker_ParamsSpec.$,
        null,
        impl.bindSharedWorker.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.StorageAccessHandle = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.StorageAccessHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.StorageAccessHandleRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.StorageAccessHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the StorageAccessHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.StorageAccessHandleCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.StorageAccessHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.StorageAccessHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindIndexedDB =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.StorageAccessHandle_BindIndexedDB_ParamsSpec.$,
        null,
        this.bindIndexedDB.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindLocks =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.StorageAccessHandle_BindLocks_ParamsSpec.$,
        null,
        this.bindLocks.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindCaches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.StorageAccessHandle_BindCaches_ParamsSpec.$,
        null,
        this.bindCaches.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.StorageAccessHandle_GetDirectory_ParamsSpec.$,
        blink.mojom.StorageAccessHandle_GetDirectory_ResponseParamsSpec.$,
        this.getDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.estimate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.StorageAccessHandle_Estimate_ParamsSpec.$,
        blink.mojom.StorageAccessHandle_Estimate_ResponseParamsSpec.$,
        this.estimate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindBlobStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.StorageAccessHandle_BindBlobStorage_ParamsSpec.$,
        null,
        this.bindBlobStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindBroadcastChannel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.StorageAccessHandle_BindBroadcastChannel_ParamsSpec.$,
        null,
        this.bindBroadcastChannel.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSharedWorker =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.StorageAccessHandle_BindSharedWorker_ParamsSpec.$,
        null,
        this.bindSharedWorker.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.StorageAccessHandle_BindIndexedDB_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_BindIndexedDB_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_BindLocks_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_BindLocks_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_BindCaches_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_BindCaches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_GetDirectory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_GetDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_GetDirectory_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_GetDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_Estimate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_Estimate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_Estimate_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_Estimate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_BindBlobStorage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_BindBlobStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_BindBroadcastChannel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_BindBroadcastChannel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAccessHandle_BindSharedWorker_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAccessHandle_BindSharedWorker_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_BindIndexedDB_ParamsSpec.$,
    'StorageAccessHandle_BindIndexedDB_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.IDBFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageAccessHandle_BindIndexedDB_Params');

/** @record */
blink.mojom.StorageAccessHandle_BindIndexedDB_Params = class {
  constructor() {
    /** @export { !blink.mojom.IDBFactoryPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_BindLocks_ParamsSpec.$,
    'StorageAccessHandle_BindLocks_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.LockManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageAccessHandle_BindLocks_Params');

/** @record */
blink.mojom.StorageAccessHandle_BindLocks_Params = class {
  constructor() {
    /** @export { !blink.mojom.LockManagerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_BindCaches_ParamsSpec.$,
    'StorageAccessHandle_BindCaches_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.CacheStoragePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageAccessHandle_BindCaches_Params');

/** @record */
blink.mojom.StorageAccessHandle_BindCaches_Params = class {
  constructor() {
    /** @export { !blink.mojom.CacheStoragePendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_GetDirectory_ParamsSpec.$,
    'StorageAccessHandle_GetDirectory_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.StorageAccessHandle_GetDirectory_Params');

/** @record */
blink.mojom.StorageAccessHandle_GetDirectory_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_GetDirectory_ResponseParamsSpec.$,
    'StorageAccessHandle_GetDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDirectoryHandleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.StorageAccessHandle_GetDirectory_ResponseParams');

/** @record */
blink.mojom.StorageAccessHandle_GetDirectory_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_Estimate_ParamsSpec.$,
    'StorageAccessHandle_Estimate_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.StorageAccessHandle_Estimate_Params');

/** @record */
blink.mojom.StorageAccessHandle_Estimate_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_Estimate_ResponseParamsSpec.$,
    'StorageAccessHandle_Estimate_ResponseParams',
    [
      mojo.internal.StructField(
        'currentUsage', 0,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentQuota', 8,
        0,
        mojoBase.mojom.ByteCountSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.StorageAccessHandle_Estimate_ResponseParams');

/** @record */
blink.mojom.StorageAccessHandle_Estimate_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.ByteCount } */
    this.currentUsage;
    /** @export { !mojoBase.mojom.ByteCount } */
    this.currentQuota;
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_BindBlobStorage_ParamsSpec.$,
    'StorageAccessHandle_BindBlobStorage_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.BlobURLStorePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageAccessHandle_BindBlobStorage_Params');

/** @record */
blink.mojom.StorageAccessHandle_BindBlobStorage_Params = class {
  constructor() {
    /** @export { !Object } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_BindBroadcastChannel_ParamsSpec.$,
    'StorageAccessHandle_BindBroadcastChannel_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.BroadcastChannelProviderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageAccessHandle_BindBroadcastChannel_Params');

/** @record */
blink.mojom.StorageAccessHandle_BindBroadcastChannel_Params = class {
  constructor() {
    /** @export { !Object } */
    this.receiver;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAccessHandle_BindSharedWorker_ParamsSpec.$,
    'StorageAccessHandle_BindSharedWorker_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.SharedWorkerConnectorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageAccessHandle_BindSharedWorker_Params');

/** @record */
blink.mojom.StorageAccessHandle_BindSharedWorker_Params = class {
  constructor() {
    /** @export { !blink.mojom.SharedWorkerConnectorPendingReceiver } */
    this.receiver;
  }
};

