// third_party/blink/public/mojom/wake_lock/wake_lock.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.WakeLockReason');
goog.require('device.mojom.WakeLockType');
goog.require('device.mojom.WakeLock');






goog.provide('blink.mojom.WakeLockService');
goog.provide('blink.mojom.WakeLockServiceReceiver');
goog.provide('blink.mojom.WakeLockServiceCallbackRouter');
goog.provide('blink.mojom.WakeLockServiceInterface');
goog.provide('blink.mojom.WakeLockServiceRemote');
goog.provide('blink.mojom.WakeLockServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WakeLockServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WakeLockService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.WakeLockServiceInterface = class {
  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @param { !device.mojom.WakeLockReason } reason
   * @param { !string } description
   * @param { !device.mojom.WakeLockPendingReceiver } wakeLock
   */

  getWakeLock(type, reason, description, wakeLock) {}
};

/**
 * @export
 * @implements { blink.mojom.WakeLockServiceInterface }
 */
blink.mojom.WakeLockServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WakeLockServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WakeLockServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WakeLockServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @param { !device.mojom.WakeLockReason } reason
   * @param { !string } description
   * @param { !device.mojom.WakeLockPendingReceiver } wakeLock
   */

  getWakeLock(
      type,
      reason,
      description,
      wakeLock) {
    this.proxy.sendMessage(
        0,
        blink.mojom.WakeLockService_GetWakeLock_ParamsSpec.$,
        null,
        [
          type,
          reason,
          description,
          wakeLock
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WakeLockService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WakeLockServiceReceiver = class {
  /**
   * @param {!blink.mojom.WakeLockServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WakeLockServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WakeLockServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WakeLockServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WakeLockService_GetWakeLock_ParamsSpec.$,
        null,
        impl.getWakeLock.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WakeLockService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WakeLockService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WakeLockServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WakeLockServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WakeLockService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WakeLockServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WakeLockServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WakeLockServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWakeLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WakeLockService_GetWakeLock_ParamsSpec.$,
        null,
        this.getWakeLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.WakeLockService_GetWakeLock_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WakeLockService_GetWakeLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.WakeLockService_GetWakeLock_ParamsSpec.$,
    'WakeLockService_GetWakeLock_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.WakeLockTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        device.mojom.WakeLockReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wakeLock', 16,
        0,
        mojo.internal.InterfaceRequest(device.mojom.WakeLockPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.WakeLockService_GetWakeLock_Params');

/** @record */
blink.mojom.WakeLockService_GetWakeLock_Params = class {
  constructor() {
    /** @export { !device.mojom.WakeLockType } */
    this.type;
    /** @export { !device.mojom.WakeLockReason } */
    this.reason;
    /** @export { !string } */
    this.description;
    /** @export { !device.mojom.WakeLockPendingReceiver } */
    this.wakeLock;
  }
};

