// third_party/blink/public/mojom/webauthn/authenticator.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/webauthn/authenticator.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var payment_request_data$ =
      mojo.internal.exposeNamespace('payments.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/payments/mojom/payment_request_data.mojom', '../../../../../components/payments/mojom/payment_request_data.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var credential_manager$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom', '../credentialmanagement/credential_manager.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var PUBLIC_KEY_CREDENTIAL_DESCRIPTOR_LIST_MAX_SIZE = 64;
  var AuthenticatorStatus = {};
  AuthenticatorStatus.SUCCESS = 0;
  AuthenticatorStatus.PENDING_REQUEST = 1;
  AuthenticatorStatus.NOT_ALLOWED_ERROR = 2;
  AuthenticatorStatus.INVALID_DOMAIN = 3;
  AuthenticatorStatus.CREDENTIAL_EXCLUDED = 4;
  AuthenticatorStatus.NOT_IMPLEMENTED = 5;
  AuthenticatorStatus.NOT_FOCUSED = 6;
  AuthenticatorStatus.RESIDENT_CREDENTIALS_UNSUPPORTED = 7;
  AuthenticatorStatus.USER_VERIFICATION_UNSUPPORTED = 8;
  AuthenticatorStatus.ALGORITHM_UNSUPPORTED = 9;
  AuthenticatorStatus.EMPTY_ALLOW_CREDENTIALS = 10;
  AuthenticatorStatus.ANDROID_NOT_SUPPORTED_ERROR = 11;
  AuthenticatorStatus.PROTECTION_POLICY_INCONSISTENT = 12;
  AuthenticatorStatus.ABORT_ERROR = 13;
  AuthenticatorStatus.OPAQUE_DOMAIN = 14;
  AuthenticatorStatus.INVALID_PROTOCOL = 15;
  AuthenticatorStatus.BAD_RELYING_PARTY_ID = 16;
  AuthenticatorStatus.BAD_RELYING_PARTY_ID_ATTEMPTED_FETCH = 17;
  AuthenticatorStatus.BAD_RELYING_PARTY_ID_WRONG_CONTENT_TYPE = 18;
  AuthenticatorStatus.BAD_RELYING_PARTY_ID_JSON_PARSE_ERROR = 19;
  AuthenticatorStatus.BAD_RELYING_PARTY_ID_NO_JSON_MATCH = 20;
  AuthenticatorStatus.BAD_RELYING_PARTY_ID_NO_JSON_MATCH_HIT_LIMITS = 21;
  AuthenticatorStatus.CANNOT_READ_AND_WRITE_LARGE_BLOB = 22;
  AuthenticatorStatus.INVALID_ALLOW_CREDENTIALS_FOR_LARGE_BLOB = 23;
  AuthenticatorStatus.FAILED_TO_SAVE_CREDENTIAL_ID_FOR_PAYMENT_EXTENSION = 24;
  AuthenticatorStatus.REMOTE_DESKTOP_CLIENT_OVERRIDE_NOT_AUTHORIZED = 25;
  AuthenticatorStatus.DEVICE_PUBLIC_KEY_ATTESTATION_REJECTED = 26;
  AuthenticatorStatus.CERTIFICATE_ERROR = 27;
  AuthenticatorStatus.ERROR_WITH_DOM_EXCEPTION_DETAILS = 28;
  AuthenticatorStatus.IMMEDIATE_NOT_FOUND = 29;
  AuthenticatorStatus.UNKNOWN_ERROR = 30;
  AuthenticatorStatus.MIN_VALUE = 0;
  AuthenticatorStatus.MAX_VALUE = 30;

  AuthenticatorStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
      return true;
    }
    return false;
  };

  AuthenticatorStatus.toKnownEnumValue = function(value) {
    return value;
  };

  AuthenticatorStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AuthenticatorTransport = {};
  AuthenticatorTransport.USB = 0;
  AuthenticatorTransport.NFC = 1;
  AuthenticatorTransport.BLE = 2;
  AuthenticatorTransport.HYBRID = 3;
  AuthenticatorTransport.INTERNAL = 4;
  AuthenticatorTransport.MIN_VALUE = 0;
  AuthenticatorTransport.MAX_VALUE = 4;

  AuthenticatorTransport.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  AuthenticatorTransport.toKnownEnumValue = function(value) {
    return value;
  };

  AuthenticatorTransport.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Hint = {};
  Hint.SECURITY_KEY = 0;
  Hint.CLIENT_DEVICE = 1;
  Hint.HYBRID = 2;
  Hint.MIN_VALUE = 0;
  Hint.MAX_VALUE = 2;

  Hint.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  Hint.toKnownEnumValue = function(value) {
    return value;
  };

  Hint.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var UserVerificationRequirement = {};
  UserVerificationRequirement.REQUIRED = 0;
  UserVerificationRequirement.PREFERRED = 1;
  UserVerificationRequirement.DISCOURAGED = 2;
  UserVerificationRequirement.MIN_VALUE = 0;
  UserVerificationRequirement.MAX_VALUE = 2;

  UserVerificationRequirement.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  UserVerificationRequirement.toKnownEnumValue = function(value) {
    return value;
  };

  UserVerificationRequirement.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var Mediation = {};
  Mediation.MODAL = 0;
  Mediation.CONDITIONAL = 1;
  Mediation.IMMEDIATE = 2;
  Mediation.MIN_VALUE = 0;
  Mediation.MAX_VALUE = 2;

  Mediation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  Mediation.toKnownEnumValue = function(value) {
    return value;
  };

  Mediation.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ResidentKeyRequirement = {};
  ResidentKeyRequirement.DISCOURAGED = 0;
  ResidentKeyRequirement.PREFERRED = 1;
  ResidentKeyRequirement.REQUIRED = 2;
  ResidentKeyRequirement.MIN_VALUE = 0;
  ResidentKeyRequirement.MAX_VALUE = 2;

  ResidentKeyRequirement.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ResidentKeyRequirement.toKnownEnumValue = function(value) {
    return value;
  };

  ResidentKeyRequirement.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AuthenticatorAttachment = {};
  AuthenticatorAttachment.NO_PREFERENCE = 0;
  AuthenticatorAttachment.PLATFORM = 1;
  AuthenticatorAttachment.CROSS_PLATFORM = 2;
  AuthenticatorAttachment.MIN_VALUE = 0;
  AuthenticatorAttachment.MAX_VALUE = 2;

  AuthenticatorAttachment.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AuthenticatorAttachment.toKnownEnumValue = function(value) {
    return value;
  };

  AuthenticatorAttachment.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ProtectionPolicy = {};
  ProtectionPolicy.UNSPECIFIED = 0;
  ProtectionPolicy.NONE = 1;
  ProtectionPolicy.UV_OR_CRED_ID_REQUIRED = 2;
  ProtectionPolicy.UV_REQUIRED = 3;
  ProtectionPolicy.MIN_VALUE = 0;
  ProtectionPolicy.MAX_VALUE = 3;

  ProtectionPolicy.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  ProtectionPolicy.toKnownEnumValue = function(value) {
    return value;
  };

  ProtectionPolicy.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var LargeBlobSupport = {};
  LargeBlobSupport.NOT_REQUESTED = 0;
  LargeBlobSupport.REQUIRED = 1;
  LargeBlobSupport.PREFERRED = 2;
  LargeBlobSupport.MIN_VALUE = 0;
  LargeBlobSupport.MAX_VALUE = 2;

  LargeBlobSupport.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  LargeBlobSupport.toKnownEnumValue = function(value) {
    return value;
  };

  LargeBlobSupport.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AttestationConveyancePreference = {};
  AttestationConveyancePreference.NONE = 0;
  AttestationConveyancePreference.INDIRECT = 1;
  AttestationConveyancePreference.DIRECT = 2;
  AttestationConveyancePreference.ENTERPRISE = 3;
  AttestationConveyancePreference.MIN_VALUE = 0;
  AttestationConveyancePreference.MAX_VALUE = 3;

  AttestationConveyancePreference.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AttestationConveyancePreference.toKnownEnumValue = function(value) {
    return value;
  };

  AttestationConveyancePreference.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PublicKeyCredentialType = {};
  PublicKeyCredentialType.PUBLIC_KEY = 0;
  PublicKeyCredentialType.MIN_VALUE = 0;
  PublicKeyCredentialType.MAX_VALUE = 0;

  PublicKeyCredentialType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  PublicKeyCredentialType.toKnownEnumValue = function(value) {
    return value;
  };

  PublicKeyCredentialType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CommonCredentialInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CommonCredentialInfo.prototype.initDefaults_ = function() {
    this.id = null;
    this.rawId = null;
    this.clientDataJson = null;
    this.authenticatorData = null;
  };
  CommonCredentialInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CommonCredentialInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonCredentialInfo.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonCredentialInfo.rawId
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonCredentialInfo.clientDataJson
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonCredentialInfo.authenticatorData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CommonCredentialInfo.encodedSize = codec.kStructHeaderSize + 32;

  CommonCredentialInfo.decode = function(decoder) {
    var packed;
    var val = new CommonCredentialInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    val.rawId =
        decoder.decodeArrayPointer(codec.Uint8);
    val.clientDataJson =
        decoder.decodeArrayPointer(codec.Uint8);
    val.authenticatorData =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CommonCredentialInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CommonCredentialInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeArrayPointer(codec.Uint8, val.rawId);
    encoder.encodeArrayPointer(codec.Uint8, val.clientDataJson);
    encoder.encodeArrayPointer(codec.Uint8, val.authenticatorData);
  };
  function SupplementalPubKeysResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SupplementalPubKeysResponse.prototype.initDefaults_ = function() {
    this.signatures = null;
  };
  SupplementalPubKeysResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SupplementalPubKeysResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SupplementalPubKeysResponse.signatures
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SupplementalPubKeysResponse.encodedSize = codec.kStructHeaderSize + 8;

  SupplementalPubKeysResponse.decode = function(decoder) {
    var packed;
    var val = new SupplementalPubKeysResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.signatures =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    return val;
  };

  SupplementalPubKeysResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SupplementalPubKeysResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.signatures);
  };
  function AuthenticationExtensionsPaymentResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuthenticationExtensionsPaymentResponse.prototype.initDefaults_ = function() {
    this.browserBoundSignature = null;
  };
  AuthenticationExtensionsPaymentResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuthenticationExtensionsPaymentResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticationExtensionsPaymentResponse.browserBoundSignature
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuthenticationExtensionsPaymentResponse.encodedSize = codec.kStructHeaderSize + 8;

  AuthenticationExtensionsPaymentResponse.decode = function(decoder) {
    var packed;
    var val = new AuthenticationExtensionsPaymentResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.browserBoundSignature =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  AuthenticationExtensionsPaymentResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuthenticationExtensionsPaymentResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.browserBoundSignature);
  };
  function MakeCredentialAuthenticatorResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MakeCredentialAuthenticatorResponse.prototype.initDefaults_ = function() {
    this.info = null;
    this.authenticatorAttachment = 0;
    this.echoHmacCreateSecret = false;
    this.hmacCreateSecret = false;
    this.echoPrf = false;
    this.prf = false;
    this.echoCredBlob = false;
    this.credBlob = false;
    this.echoCredProps = false;
    this.hasCredPropsRk = false;
    this.credPropsRk = false;
    this.echoLargeBlob = false;
    this.supportsLargeBlob = false;
    this.attestationObject = null;
    this.transports = null;
    this.prfResults = null;
    this.publicKeyDer = null;
    this.publicKeyAlgo = 0;
    this.supplementalPubKeys = null;
    this.payment = null;
  };
  MakeCredentialAuthenticatorResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MakeCredentialAuthenticatorResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MakeCredentialAuthenticatorResponse.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CommonCredentialInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MakeCredentialAuthenticatorResponse.authenticatorAttachment
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AuthenticatorAttachment);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MakeCredentialAuthenticatorResponse.attestationObject
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MakeCredentialAuthenticatorResponse.transports
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 4, new codec.Enum(AuthenticatorTransport), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;






    // validate MakeCredentialAuthenticatorResponse.prfResults
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, PRFValues, true);
    if (err !== validator.validationError.NONE)
        return err;




    // validate MakeCredentialAuthenticatorResponse.publicKeyDer
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;








    // validate MakeCredentialAuthenticatorResponse.supplementalPubKeys
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, SupplementalPubKeysResponse, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MakeCredentialAuthenticatorResponse.payment
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, AuthenticationExtensionsPaymentResponse, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MakeCredentialAuthenticatorResponse.encodedSize = codec.kStructHeaderSize + 72;

  MakeCredentialAuthenticatorResponse.decode = function(decoder) {
    var packed;
    var val = new MakeCredentialAuthenticatorResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(CommonCredentialInfo);
    val.authenticatorAttachment =
        decoder.decodeStruct(new codec.Enum(AuthenticatorAttachment));
    packed = decoder.readUint8();
    val.echoHmacCreateSecret = (packed >> 0) & 1 ? true : false;
    val.hmacCreateSecret = (packed >> 1) & 1 ? true : false;
    val.echoPrf = (packed >> 2) & 1 ? true : false;
    val.prf = (packed >> 3) & 1 ? true : false;
    val.echoCredBlob = (packed >> 4) & 1 ? true : false;
    val.credBlob = (packed >> 5) & 1 ? true : false;
    val.echoCredProps = (packed >> 6) & 1 ? true : false;
    val.hasCredPropsRk = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.credPropsRk = (packed >> 0) & 1 ? true : false;
    val.echoLargeBlob = (packed >> 1) & 1 ? true : false;
    val.supportsLargeBlob = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    val.attestationObject =
        decoder.decodeArrayPointer(codec.Uint8);
    val.transports =
        decoder.decodeArrayPointer(new codec.Enum(AuthenticatorTransport));
    val.prfResults =
        decoder.decodeStructPointer(PRFValues);
    val.publicKeyDer =
        decoder.decodeArrayPointer(codec.Uint8);
    val.publicKeyAlgo =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.supplementalPubKeys =
        decoder.decodeStructPointer(SupplementalPubKeysResponse);
    val.payment =
        decoder.decodeStructPointer(AuthenticationExtensionsPaymentResponse);
    return val;
  };

  MakeCredentialAuthenticatorResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MakeCredentialAuthenticatorResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CommonCredentialInfo, val.info);
    encoder.encodeStruct(codec.Int32, val.authenticatorAttachment);
    packed = 0;
    packed |= (val.echoHmacCreateSecret & 1) << 0
    packed |= (val.hmacCreateSecret & 1) << 1
    packed |= (val.echoPrf & 1) << 2
    packed |= (val.prf & 1) << 3
    packed |= (val.echoCredBlob & 1) << 4
    packed |= (val.credBlob & 1) << 5
    packed |= (val.echoCredProps & 1) << 6
    packed |= (val.hasCredPropsRk & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.credPropsRk & 1) << 0
    packed |= (val.echoLargeBlob & 1) << 1
    packed |= (val.supportsLargeBlob & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.attestationObject);
    encoder.encodeArrayPointer(new codec.Enum(AuthenticatorTransport), val.transports);
    encoder.encodeStructPointer(PRFValues, val.prfResults);
    encoder.encodeArrayPointer(codec.Uint8, val.publicKeyDer);
    encoder.encodeStruct(codec.Int32, val.publicKeyAlgo);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SupplementalPubKeysResponse, val.supplementalPubKeys);
    encoder.encodeStructPointer(AuthenticationExtensionsPaymentResponse, val.payment);
  };
  function GetAssertionAuthenticatorResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GetAssertionAuthenticatorResponse.prototype.initDefaults_ = function() {
    this.info = null;
    this.authenticatorAttachment = 0;
    this.signature = null;
    this.userHandle = null;
    this.extensions = null;
  };
  GetAssertionAuthenticatorResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GetAssertionAuthenticatorResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetAssertionAuthenticatorResponse.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CommonCredentialInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetAssertionAuthenticatorResponse.authenticatorAttachment
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AuthenticatorAttachment);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetAssertionAuthenticatorResponse.signature
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetAssertionAuthenticatorResponse.userHandle
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetAssertionAuthenticatorResponse.extensions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, AuthenticationExtensionsClientOutputs, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GetAssertionAuthenticatorResponse.encodedSize = codec.kStructHeaderSize + 40;

  GetAssertionAuthenticatorResponse.decode = function(decoder) {
    var packed;
    var val = new GetAssertionAuthenticatorResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(CommonCredentialInfo);
    val.authenticatorAttachment =
        decoder.decodeStruct(new codec.Enum(AuthenticatorAttachment));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.signature =
        decoder.decodeArrayPointer(codec.Uint8);
    val.userHandle =
        decoder.decodeArrayPointer(codec.Uint8);
    val.extensions =
        decoder.decodeStructPointer(AuthenticationExtensionsClientOutputs);
    return val;
  };

  GetAssertionAuthenticatorResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GetAssertionAuthenticatorResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CommonCredentialInfo, val.info);
    encoder.encodeStruct(codec.Int32, val.authenticatorAttachment);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.signature);
    encoder.encodeArrayPointer(codec.Uint8, val.userHandle);
    encoder.encodeStructPointer(AuthenticationExtensionsClientOutputs, val.extensions);
  };
  function AuthenticationExtensionsClientOutputs(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuthenticationExtensionsClientOutputs.prototype.initDefaults_ = function() {
    this.echoAppidExtension = false;
    this.appidExtension = false;
    this.echoPrf = false;
    this.prfNotEvaluated = false;
    this.echoLargeBlob = false;
    this.echoLargeBlobWritten = false;
    this.largeBlobWritten = false;
    this.prfResults = null;
    this.largeBlob = null;
    this.getCredBlob = null;
    this.supplementalPubKeys = null;
    this.payment = null;
  };
  AuthenticationExtensionsClientOutputs.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuthenticationExtensionsClientOutputs.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate AuthenticationExtensionsClientOutputs.prfResults
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, PRFValues, true);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AuthenticationExtensionsClientOutputs.largeBlob
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AuthenticationExtensionsClientOutputs.getCredBlob
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticationExtensionsClientOutputs.supplementalPubKeys
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, SupplementalPubKeysResponse, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticationExtensionsClientOutputs.payment
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, AuthenticationExtensionsPaymentResponse, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuthenticationExtensionsClientOutputs.encodedSize = codec.kStructHeaderSize + 48;

  AuthenticationExtensionsClientOutputs.decode = function(decoder) {
    var packed;
    var val = new AuthenticationExtensionsClientOutputs();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.echoAppidExtension = (packed >> 0) & 1 ? true : false;
    val.appidExtension = (packed >> 1) & 1 ? true : false;
    val.echoPrf = (packed >> 2) & 1 ? true : false;
    val.prfNotEvaluated = (packed >> 3) & 1 ? true : false;
    val.echoLargeBlob = (packed >> 4) & 1 ? true : false;
    val.echoLargeBlobWritten = (packed >> 5) & 1 ? true : false;
    val.largeBlobWritten = (packed >> 6) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.prfResults =
        decoder.decodeStructPointer(PRFValues);
    val.largeBlob =
        decoder.decodeArrayPointer(codec.Uint8);
    val.getCredBlob =
        decoder.decodeArrayPointer(codec.Uint8);
    val.supplementalPubKeys =
        decoder.decodeStructPointer(SupplementalPubKeysResponse);
    val.payment =
        decoder.decodeStructPointer(AuthenticationExtensionsPaymentResponse);
    return val;
  };

  AuthenticationExtensionsClientOutputs.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuthenticationExtensionsClientOutputs.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.echoAppidExtension & 1) << 0
    packed |= (val.appidExtension & 1) << 1
    packed |= (val.echoPrf & 1) << 2
    packed |= (val.prfNotEvaluated & 1) << 3
    packed |= (val.echoLargeBlob & 1) << 4
    packed |= (val.echoLargeBlobWritten & 1) << 5
    packed |= (val.largeBlobWritten & 1) << 6
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(PRFValues, val.prfResults);
    encoder.encodeArrayPointer(codec.Uint8, val.largeBlob);
    encoder.encodeArrayPointer(codec.Uint8, val.getCredBlob);
    encoder.encodeStructPointer(SupplementalPubKeysResponse, val.supplementalPubKeys);
    encoder.encodeStructPointer(AuthenticationExtensionsPaymentResponse, val.payment);
  };
  function PublicKeyCredentialRpEntity(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PublicKeyCredentialRpEntity.prototype.initDefaults_ = function() {
    this.id = null;
    this.name = null;
  };
  PublicKeyCredentialRpEntity.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PublicKeyCredentialRpEntity.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRpEntity.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRpEntity.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PublicKeyCredentialRpEntity.encodedSize = codec.kStructHeaderSize + 16;

  PublicKeyCredentialRpEntity.decode = function(decoder) {
    var packed;
    var val = new PublicKeyCredentialRpEntity();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    val.name =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PublicKeyCredentialRpEntity.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PublicKeyCredentialRpEntity.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.String, val.name);
  };
  function PublicKeyCredentialUserEntity(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PublicKeyCredentialUserEntity.prototype.initDefaults_ = function() {
    this.id = null;
    this.name = null;
    this.displayName = null;
  };
  PublicKeyCredentialUserEntity.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PublicKeyCredentialUserEntity.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialUserEntity.id
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialUserEntity.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialUserEntity.displayName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PublicKeyCredentialUserEntity.encodedSize = codec.kStructHeaderSize + 24;

  PublicKeyCredentialUserEntity.decode = function(decoder) {
    var packed;
    var val = new PublicKeyCredentialUserEntity();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeArrayPointer(codec.Uint8);
    val.name =
        decoder.decodeStruct(codec.String);
    val.displayName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PublicKeyCredentialUserEntity.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PublicKeyCredentialUserEntity.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.id);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.displayName);
  };
  function PublicKeyCredentialParameters(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PublicKeyCredentialParameters.prototype.initDefaults_ = function() {
    this.type = 0;
    this.algorithmIdentifier = 0;
  };
  PublicKeyCredentialParameters.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PublicKeyCredentialParameters.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialParameters.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PublicKeyCredentialType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PublicKeyCredentialParameters.encodedSize = codec.kStructHeaderSize + 8;

  PublicKeyCredentialParameters.decode = function(decoder) {
    var packed;
    var val = new PublicKeyCredentialParameters();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(PublicKeyCredentialType));
    val.algorithmIdentifier =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  PublicKeyCredentialParameters.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PublicKeyCredentialParameters.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.algorithmIdentifier);
  };
  function CableAuthentication(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CableAuthentication.prototype.initDefaults_ = function() {
    this.version = 0;
    this.clientEid = null;
    this.authenticatorEid = null;
    this.sessionPreKey = null;
    this.serverLinkData = null;
    this.experiments = null;
  };
  CableAuthentication.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CableAuthentication.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CableAuthentication.clientEid
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, true, [16], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CableAuthentication.authenticatorEid
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, true, [16], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CableAuthentication.sessionPreKey
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 1, codec.Uint8, true, [32], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CableAuthentication.serverLinkData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CableAuthentication.experiments
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CableAuthentication.encodedSize = codec.kStructHeaderSize + 48;

  CableAuthentication.decode = function(decoder) {
    var packed;
    var val = new CableAuthentication();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.version =
        decoder.decodeStruct(codec.Uint8);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.clientEid =
        decoder.decodeArrayPointer(codec.Uint8);
    val.authenticatorEid =
        decoder.decodeArrayPointer(codec.Uint8);
    val.sessionPreKey =
        decoder.decodeArrayPointer(codec.Uint8);
    val.serverLinkData =
        decoder.decodeArrayPointer(codec.Uint8);
    val.experiments =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  CableAuthentication.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CableAuthentication.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint8, val.version);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.clientEid);
    encoder.encodeArrayPointer(codec.Uint8, val.authenticatorEid);
    encoder.encodeArrayPointer(codec.Uint8, val.sessionPreKey);
    encoder.encodeArrayPointer(codec.Uint8, val.serverLinkData);
    encoder.encodeArrayPointer(codec.Uint8, val.experiments);
  };
  function PRFValues(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PRFValues.prototype.initDefaults_ = function() {
    this.id = null;
    this.first = null;
    this.second = null;
  };
  PRFValues.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PRFValues.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PRFValues.id
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PRFValues.first
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PRFValues.second
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PRFValues.encodedSize = codec.kStructHeaderSize + 24;

  PRFValues.decode = function(decoder) {
    var packed;
    var val = new PRFValues();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeArrayPointer(codec.Uint8);
    val.first =
        decoder.decodeArrayPointer(codec.Uint8);
    val.second =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  PRFValues.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PRFValues.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.id);
    encoder.encodeArrayPointer(codec.Uint8, val.first);
    encoder.encodeArrayPointer(codec.Uint8, val.second);
  };
  function PaymentOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PaymentOptions.prototype.initDefaults_ = function() {
    this.total = null;
    this.instrument = null;
    this.payeeName = null;
    this.payeeOrigin = null;
    this.paymentEntitiesLogos = null;
    this.browserBoundPublicKey = null;
  };
  PaymentOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PaymentOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentOptions.total
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, payment_request_data$.PaymentCurrencyAmount, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentOptions.instrument
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, PaymentCredentialInstrument, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentOptions.payeeName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentOptions.payeeOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentOptions.paymentEntitiesLogos
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(ShownPaymentEntityLogo), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentOptions.browserBoundPublicKey
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PaymentOptions.encodedSize = codec.kStructHeaderSize + 48;

  PaymentOptions.decode = function(decoder) {
    var packed;
    var val = new PaymentOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.total =
        decoder.decodeStructPointer(payment_request_data$.PaymentCurrencyAmount);
    val.instrument =
        decoder.decodeStructPointer(PaymentCredentialInstrument);
    val.payeeName =
        decoder.decodeStruct(codec.String);
    val.payeeOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.paymentEntitiesLogos =
        decoder.decodeArrayPointer(new codec.PointerTo(ShownPaymentEntityLogo));
    val.browserBoundPublicKey =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  PaymentOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PaymentOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(payment_request_data$.PaymentCurrencyAmount, val.total);
    encoder.encodeStructPointer(PaymentCredentialInstrument, val.instrument);
    encoder.encodeStruct(codec.String, val.payeeName);
    encoder.encodeStructPointer(origin$.Origin, val.payeeOrigin);
    encoder.encodeArrayPointer(new codec.PointerTo(ShownPaymentEntityLogo), val.paymentEntitiesLogos);
    encoder.encodeArrayPointer(codec.Uint8, val.browserBoundPublicKey);
  };
  function PaymentCredentialInstrument(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PaymentCredentialInstrument.prototype.initDefaults_ = function() {
    this.displayName = null;
    this.icon = null;
    this.iconMustBeShown = false;
    this.details = null;
  };
  PaymentCredentialInstrument.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PaymentCredentialInstrument.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentCredentialInstrument.displayName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaymentCredentialInstrument.icon
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PaymentCredentialInstrument.details
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PaymentCredentialInstrument.encodedSize = codec.kStructHeaderSize + 32;

  PaymentCredentialInstrument.decode = function(decoder) {
    var packed;
    var val = new PaymentCredentialInstrument();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.displayName =
        decoder.decodeStruct(codec.String);
    val.icon =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.iconMustBeShown = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.details =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PaymentCredentialInstrument.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PaymentCredentialInstrument.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.displayName);
    encoder.encodeStructPointer(url$.Url, val.icon);
    packed = 0;
    packed |= (val.iconMustBeShown & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.details);
  };
  function ShownPaymentEntityLogo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ShownPaymentEntityLogo.prototype.initDefaults_ = function() {
    this.url = null;
    this.label = null;
  };
  ShownPaymentEntityLogo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ShownPaymentEntityLogo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ShownPaymentEntityLogo.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ShownPaymentEntityLogo.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ShownPaymentEntityLogo.encodedSize = codec.kStructHeaderSize + 16;

  ShownPaymentEntityLogo.decode = function(decoder) {
    var packed;
    var val = new ShownPaymentEntityLogo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.label =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ShownPaymentEntityLogo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ShownPaymentEntityLogo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.label);
  };
  function RemoteDesktopClientOverride(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteDesktopClientOverride.prototype.initDefaults_ = function() {
    this.origin = null;
    this.sameOriginWithAncestors = false;
  };
  RemoteDesktopClientOverride.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteDesktopClientOverride.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteDesktopClientOverride.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteDesktopClientOverride.encodedSize = codec.kStructHeaderSize + 16;

  RemoteDesktopClientOverride.decode = function(decoder) {
    var packed;
    var val = new RemoteDesktopClientOverride();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    packed = decoder.readUint8();
    val.sameOriginWithAncestors = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteDesktopClientOverride.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteDesktopClientOverride.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    packed = 0;
    packed |= (val.sameOriginWithAncestors & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SupplementalPubKeysRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SupplementalPubKeysRequest.prototype.initDefaults_ = function() {
    this.deviceScopeRequested = false;
    this.providerScopeRequested = false;
    this.attestation = 0;
    this.attestationFormats = null;
  };
  SupplementalPubKeysRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SupplementalPubKeysRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate SupplementalPubKeysRequest.attestation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, AttestationConveyancePreference);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SupplementalPubKeysRequest.attestationFormats
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SupplementalPubKeysRequest.encodedSize = codec.kStructHeaderSize + 16;

  SupplementalPubKeysRequest.decode = function(decoder) {
    var packed;
    var val = new SupplementalPubKeysRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.deviceScopeRequested = (packed >> 0) & 1 ? true : false;
    val.providerScopeRequested = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.attestation =
        decoder.decodeStruct(new codec.Enum(AttestationConveyancePreference));
    val.attestationFormats =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  SupplementalPubKeysRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SupplementalPubKeysRequest.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.deviceScopeRequested & 1) << 0
    packed |= (val.providerScopeRequested & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.attestation);
    encoder.encodeArrayPointer(codec.String, val.attestationFormats);
  };
  function PublicKeyCredentialRequestOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PublicKeyCredentialRequestOptions.prototype.initDefaults_ = function() {
    this.challenge = null;
    this.challengeUrl = null;
    this.timeout = null;
    this.relyingPartyId = null;
    this.allowCredentials = null;
    this.hints = null;
    this.userVerification = 0;
    this.extensions = null;
  };
  PublicKeyCredentialRequestOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PublicKeyCredentialRequestOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRequestOptions.challenge
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRequestOptions.challengeUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRequestOptions.timeout
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRequestOptions.relyingPartyId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRequestOptions.allowCredentials
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(PublicKeyCredentialDescriptor), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRequestOptions.hints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 4, new codec.Enum(Hint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRequestOptions.userVerification
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, UserVerificationRequirement);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialRequestOptions.extensions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, AuthenticationExtensionsClientInputs, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PublicKeyCredentialRequestOptions.encodedSize = codec.kStructHeaderSize + 64;

  PublicKeyCredentialRequestOptions.decode = function(decoder) {
    var packed;
    var val = new PublicKeyCredentialRequestOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.challenge =
        decoder.decodeArrayPointer(codec.Uint8);
    val.challengeUrl =
        decoder.decodeStructPointer(url$.Url);
    val.timeout =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.relyingPartyId =
        decoder.decodeStruct(codec.String);
    val.allowCredentials =
        decoder.decodeArrayPointer(new codec.PointerTo(PublicKeyCredentialDescriptor));
    val.hints =
        decoder.decodeArrayPointer(new codec.Enum(Hint));
    val.userVerification =
        decoder.decodeStruct(new codec.Enum(UserVerificationRequirement));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.extensions =
        decoder.decodeStructPointer(AuthenticationExtensionsClientInputs);
    return val;
  };

  PublicKeyCredentialRequestOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PublicKeyCredentialRequestOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.challenge);
    encoder.encodeStructPointer(url$.Url, val.challengeUrl);
    encoder.encodeStructPointer(time$.TimeDelta, val.timeout);
    encoder.encodeStruct(codec.String, val.relyingPartyId);
    encoder.encodeArrayPointer(new codec.PointerTo(PublicKeyCredentialDescriptor), val.allowCredentials);
    encoder.encodeArrayPointer(new codec.Enum(Hint), val.hints);
    encoder.encodeStruct(codec.Int32, val.userVerification);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(AuthenticationExtensionsClientInputs, val.extensions);
  };
  function AuthenticationExtensionsClientInputs(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuthenticationExtensionsClientInputs.prototype.initDefaults_ = function() {
    this.appid = null;
    this.cableAuthenticationData = null;
    this.prf = false;
    this.largeBlobRead = false;
    this.getCredBlob = false;
    this.prfInputs = null;
    this.largeBlobWrite = null;
    this.remoteDesktopClientOverride = null;
    this.supplementalPubKeys = null;
    this.paymentBrowserBoundKeyParameters = null;
  };
  AuthenticationExtensionsClientInputs.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuthenticationExtensionsClientInputs.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticationExtensionsClientInputs.appid
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticationExtensionsClientInputs.cableAuthenticationData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(CableAuthentication), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AuthenticationExtensionsClientInputs.prfInputs
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(PRFValues), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AuthenticationExtensionsClientInputs.largeBlobWrite
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AuthenticationExtensionsClientInputs.remoteDesktopClientOverride
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, RemoteDesktopClientOverride, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticationExtensionsClientInputs.supplementalPubKeys
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, SupplementalPubKeysRequest, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticationExtensionsClientInputs.paymentBrowserBoundKeyParameters
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(PublicKeyCredentialParameters), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuthenticationExtensionsClientInputs.encodedSize = codec.kStructHeaderSize + 64;

  AuthenticationExtensionsClientInputs.decode = function(decoder) {
    var packed;
    var val = new AuthenticationExtensionsClientInputs();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.appid =
        decoder.decodeStruct(codec.String);
    val.cableAuthenticationData =
        decoder.decodeArrayPointer(new codec.PointerTo(CableAuthentication));
    packed = decoder.readUint8();
    val.prf = (packed >> 0) & 1 ? true : false;
    val.largeBlobRead = (packed >> 1) & 1 ? true : false;
    val.getCredBlob = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.prfInputs =
        decoder.decodeArrayPointer(new codec.PointerTo(PRFValues));
    val.largeBlobWrite =
        decoder.decodeArrayPointer(codec.Uint8);
    val.remoteDesktopClientOverride =
        decoder.decodeStructPointer(RemoteDesktopClientOverride);
    val.supplementalPubKeys =
        decoder.decodeStructPointer(SupplementalPubKeysRequest);
    val.paymentBrowserBoundKeyParameters =
        decoder.decodeArrayPointer(new codec.PointerTo(PublicKeyCredentialParameters));
    return val;
  };

  AuthenticationExtensionsClientInputs.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuthenticationExtensionsClientInputs.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.appid);
    encoder.encodeArrayPointer(new codec.PointerTo(CableAuthentication), val.cableAuthenticationData);
    packed = 0;
    packed |= (val.prf & 1) << 0
    packed |= (val.largeBlobRead & 1) << 1
    packed |= (val.getCredBlob & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(PRFValues), val.prfInputs);
    encoder.encodeArrayPointer(codec.Uint8, val.largeBlobWrite);
    encoder.encodeStructPointer(RemoteDesktopClientOverride, val.remoteDesktopClientOverride);
    encoder.encodeStructPointer(SupplementalPubKeysRequest, val.supplementalPubKeys);
    encoder.encodeArrayPointer(new codec.PointerTo(PublicKeyCredentialParameters), val.paymentBrowserBoundKeyParameters);
  };
  function GetCredentialOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GetCredentialOptions.prototype.initDefaults_ = function() {
    this.mediation = 0;
    this.password = false;
    this.publicKey = null;
  };
  GetCredentialOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GetCredentialOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetCredentialOptions.mediation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, Mediation);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetCredentialOptions.publicKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, PublicKeyCredentialRequestOptions, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GetCredentialOptions.encodedSize = codec.kStructHeaderSize + 16;

  GetCredentialOptions.decode = function(decoder) {
    var packed;
    var val = new GetCredentialOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mediation =
        decoder.decodeStruct(new codec.Enum(Mediation));
    packed = decoder.readUint8();
    val.password = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.publicKey =
        decoder.decodeStructPointer(PublicKeyCredentialRequestOptions);
    return val;
  };

  GetCredentialOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GetCredentialOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mediation);
    packed = 0;
    packed |= (val.password & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(PublicKeyCredentialRequestOptions, val.publicKey);
  };
  function AuthenticatorSelectionCriteria(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuthenticatorSelectionCriteria.prototype.initDefaults_ = function() {
    this.authenticatorAttachment = 0;
    this.residentKey = 0;
    this.userVerification = 0;
  };
  AuthenticatorSelectionCriteria.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuthenticatorSelectionCriteria.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticatorSelectionCriteria.authenticatorAttachment
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AuthenticatorAttachment);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticatorSelectionCriteria.residentKey
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ResidentKeyRequirement);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuthenticatorSelectionCriteria.userVerification
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, UserVerificationRequirement);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuthenticatorSelectionCriteria.encodedSize = codec.kStructHeaderSize + 16;

  AuthenticatorSelectionCriteria.decode = function(decoder) {
    var packed;
    var val = new AuthenticatorSelectionCriteria();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.authenticatorAttachment =
        decoder.decodeStruct(new codec.Enum(AuthenticatorAttachment));
    val.residentKey =
        decoder.decodeStruct(new codec.Enum(ResidentKeyRequirement));
    val.userVerification =
        decoder.decodeStruct(new codec.Enum(UserVerificationRequirement));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AuthenticatorSelectionCriteria.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuthenticatorSelectionCriteria.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.authenticatorAttachment);
    encoder.encodeStruct(codec.Int32, val.residentKey);
    encoder.encodeStruct(codec.Int32, val.userVerification);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PublicKeyCredentialCreationOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PublicKeyCredentialCreationOptions.prototype.initDefaults_ = function() {
    this.relyingParty = null;
    this.user = null;
    this.challenge = null;
    this.publicKeyParameters = null;
    this.timeout = null;
    this.excludeCredentials = null;
    this.authenticatorSelection = null;
    this.hints = null;
    this.attestation = 0;
    this.hmacCreateSecret = false;
    this.prfEnable = false;
    this.enforceProtectionPolicy = false;
    this.credProps = false;
    this.isPaymentCredentialCreation = false;
    this.minPinLengthRequested = false;
    this.isConditional = false;
    this.prfInput = null;
    this.protectionPolicy = 0;
    this.largeBlobEnable = 0;
    this.appidExclude = null;
    this.credBlob = null;
    this.remoteDesktopClientOverride = null;
    this.supplementalPubKeys = null;
    this.paymentBrowserBoundKeyParameters = null;
    this.attestationFormats = null;
  };
  PublicKeyCredentialCreationOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PublicKeyCredentialCreationOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 144}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.relyingParty
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PublicKeyCredentialRpEntity, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.user
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, PublicKeyCredentialUserEntity, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.challenge
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.publicKeyParameters
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(PublicKeyCredentialParameters), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.timeout
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.excludeCredentials
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(PublicKeyCredentialDescriptor), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.authenticatorSelection
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, AuthenticatorSelectionCriteria, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.hints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 4, new codec.Enum(Hint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.attestation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 64, AttestationConveyancePreference);
    if (err !== validator.validationError.NONE)
        return err;




    // validate PublicKeyCredentialCreationOptions.prfInput
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, PRFValues, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.protectionPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 80, ProtectionPolicy);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PublicKeyCredentialCreationOptions.appidExclude
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 88, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate PublicKeyCredentialCreationOptions.largeBlobEnable
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 84, LargeBlobSupport);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PublicKeyCredentialCreationOptions.credBlob
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 96, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PublicKeyCredentialCreationOptions.remoteDesktopClientOverride
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, RemoteDesktopClientOverride, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.supplementalPubKeys
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, SupplementalPubKeysRequest, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.paymentBrowserBoundKeyParameters
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 120, 8, new codec.PointerTo(PublicKeyCredentialParameters), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialCreationOptions.attestationFormats
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 128, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PublicKeyCredentialCreationOptions.encodedSize = codec.kStructHeaderSize + 136;

  PublicKeyCredentialCreationOptions.decode = function(decoder) {
    var packed;
    var val = new PublicKeyCredentialCreationOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.relyingParty =
        decoder.decodeStructPointer(PublicKeyCredentialRpEntity);
    val.user =
        decoder.decodeStructPointer(PublicKeyCredentialUserEntity);
    val.challenge =
        decoder.decodeArrayPointer(codec.Uint8);
    val.publicKeyParameters =
        decoder.decodeArrayPointer(new codec.PointerTo(PublicKeyCredentialParameters));
    val.timeout =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.excludeCredentials =
        decoder.decodeArrayPointer(new codec.PointerTo(PublicKeyCredentialDescriptor));
    val.authenticatorSelection =
        decoder.decodeStructPointer(AuthenticatorSelectionCriteria);
    val.hints =
        decoder.decodeArrayPointer(new codec.Enum(Hint));
    val.attestation =
        decoder.decodeStruct(new codec.Enum(AttestationConveyancePreference));
    packed = decoder.readUint8();
    val.hmacCreateSecret = (packed >> 0) & 1 ? true : false;
    val.prfEnable = (packed >> 1) & 1 ? true : false;
    val.enforceProtectionPolicy = (packed >> 2) & 1 ? true : false;
    val.credProps = (packed >> 3) & 1 ? true : false;
    val.isPaymentCredentialCreation = (packed >> 4) & 1 ? true : false;
    val.minPinLengthRequested = (packed >> 5) & 1 ? true : false;
    val.isConditional = (packed >> 6) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.prfInput =
        decoder.decodeStructPointer(PRFValues);
    val.protectionPolicy =
        decoder.decodeStruct(new codec.Enum(ProtectionPolicy));
    val.largeBlobEnable =
        decoder.decodeStruct(new codec.Enum(LargeBlobSupport));
    val.appidExclude =
        decoder.decodeStruct(codec.String);
    val.credBlob =
        decoder.decodeArrayPointer(codec.Uint8);
    val.remoteDesktopClientOverride =
        decoder.decodeStructPointer(RemoteDesktopClientOverride);
    val.supplementalPubKeys =
        decoder.decodeStructPointer(SupplementalPubKeysRequest);
    val.paymentBrowserBoundKeyParameters =
        decoder.decodeArrayPointer(new codec.PointerTo(PublicKeyCredentialParameters));
    val.attestationFormats =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  PublicKeyCredentialCreationOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PublicKeyCredentialCreationOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PublicKeyCredentialRpEntity, val.relyingParty);
    encoder.encodeStructPointer(PublicKeyCredentialUserEntity, val.user);
    encoder.encodeArrayPointer(codec.Uint8, val.challenge);
    encoder.encodeArrayPointer(new codec.PointerTo(PublicKeyCredentialParameters), val.publicKeyParameters);
    encoder.encodeStructPointer(time$.TimeDelta, val.timeout);
    encoder.encodeArrayPointer(new codec.PointerTo(PublicKeyCredentialDescriptor), val.excludeCredentials);
    encoder.encodeStructPointer(AuthenticatorSelectionCriteria, val.authenticatorSelection);
    encoder.encodeArrayPointer(new codec.Enum(Hint), val.hints);
    encoder.encodeStruct(codec.Int32, val.attestation);
    packed = 0;
    packed |= (val.hmacCreateSecret & 1) << 0
    packed |= (val.prfEnable & 1) << 1
    packed |= (val.enforceProtectionPolicy & 1) << 2
    packed |= (val.credProps & 1) << 3
    packed |= (val.isPaymentCredentialCreation & 1) << 4
    packed |= (val.minPinLengthRequested & 1) << 5
    packed |= (val.isConditional & 1) << 6
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(PRFValues, val.prfInput);
    encoder.encodeStruct(codec.Int32, val.protectionPolicy);
    encoder.encodeStruct(codec.Int32, val.largeBlobEnable);
    encoder.encodeStruct(codec.String, val.appidExclude);
    encoder.encodeArrayPointer(codec.Uint8, val.credBlob);
    encoder.encodeStructPointer(RemoteDesktopClientOverride, val.remoteDesktopClientOverride);
    encoder.encodeStructPointer(SupplementalPubKeysRequest, val.supplementalPubKeys);
    encoder.encodeArrayPointer(new codec.PointerTo(PublicKeyCredentialParameters), val.paymentBrowserBoundKeyParameters);
    encoder.encodeArrayPointer(codec.String, val.attestationFormats);
  };
  function PublicKeyCredentialDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PublicKeyCredentialDescriptor.prototype.initDefaults_ = function() {
    this.type = 0;
    this.id = null;
    this.transports = null;
  };
  PublicKeyCredentialDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PublicKeyCredentialDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialDescriptor.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PublicKeyCredentialType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialDescriptor.id
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialDescriptor.transports
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, new codec.Enum(AuthenticatorTransport), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PublicKeyCredentialDescriptor.encodedSize = codec.kStructHeaderSize + 24;

  PublicKeyCredentialDescriptor.decode = function(decoder) {
    var packed;
    var val = new PublicKeyCredentialDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(PublicKeyCredentialType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.id =
        decoder.decodeArrayPointer(codec.Uint8);
    val.transports =
        decoder.decodeArrayPointer(new codec.Enum(AuthenticatorTransport));
    return val;
  };

  PublicKeyCredentialDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PublicKeyCredentialDescriptor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.id);
    encoder.encodeArrayPointer(new codec.Enum(AuthenticatorTransport), val.transports);
  };
  function WebAuthnDOMExceptionDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebAuthnDOMExceptionDetails.prototype.initDefaults_ = function() {
    this.name = null;
    this.message = null;
  };
  WebAuthnDOMExceptionDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebAuthnDOMExceptionDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebAuthnDOMExceptionDetails.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebAuthnDOMExceptionDetails.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebAuthnDOMExceptionDetails.encodedSize = codec.kStructHeaderSize + 16;

  WebAuthnDOMExceptionDetails.decode = function(decoder) {
    var packed;
    var val = new WebAuthnDOMExceptionDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  WebAuthnDOMExceptionDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebAuthnDOMExceptionDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.message);
  };
  function PublicKeyCredentialReportOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PublicKeyCredentialReportOptions.prototype.initDefaults_ = function() {
    this.relyingPartyId = null;
    this.unknownCredentialId = null;
    this.allAcceptedCredentials = null;
    this.currentUserDetails = null;
  };
  PublicKeyCredentialReportOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PublicKeyCredentialReportOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialReportOptions.relyingPartyId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialReportOptions.unknownCredentialId
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialReportOptions.allAcceptedCredentials
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, AllAcceptedCredentialsOptions, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PublicKeyCredentialReportOptions.currentUserDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, CurrentUserDetailsOptions, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PublicKeyCredentialReportOptions.encodedSize = codec.kStructHeaderSize + 32;

  PublicKeyCredentialReportOptions.decode = function(decoder) {
    var packed;
    var val = new PublicKeyCredentialReportOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.relyingPartyId =
        decoder.decodeStruct(codec.String);
    val.unknownCredentialId =
        decoder.decodeArrayPointer(codec.Uint8);
    val.allAcceptedCredentials =
        decoder.decodeStructPointer(AllAcceptedCredentialsOptions);
    val.currentUserDetails =
        decoder.decodeStructPointer(CurrentUserDetailsOptions);
    return val;
  };

  PublicKeyCredentialReportOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PublicKeyCredentialReportOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.relyingPartyId);
    encoder.encodeArrayPointer(codec.Uint8, val.unknownCredentialId);
    encoder.encodeStructPointer(AllAcceptedCredentialsOptions, val.allAcceptedCredentials);
    encoder.encodeStructPointer(CurrentUserDetailsOptions, val.currentUserDetails);
  };
  function AllAcceptedCredentialsOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AllAcceptedCredentialsOptions.prototype.initDefaults_ = function() {
    this.userId = null;
    this.allAcceptedCredentialsIds = null;
  };
  AllAcceptedCredentialsOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AllAcceptedCredentialsOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AllAcceptedCredentialsOptions.userId
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AllAcceptedCredentialsOptions.allAcceptedCredentialsIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.ArrayOf(codec.Uint8), false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AllAcceptedCredentialsOptions.encodedSize = codec.kStructHeaderSize + 16;

  AllAcceptedCredentialsOptions.decode = function(decoder) {
    var packed;
    var val = new AllAcceptedCredentialsOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.userId =
        decoder.decodeArrayPointer(codec.Uint8);
    val.allAcceptedCredentialsIds =
        decoder.decodeArrayPointer(new codec.ArrayOf(codec.Uint8));
    return val;
  };

  AllAcceptedCredentialsOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AllAcceptedCredentialsOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.userId);
    encoder.encodeArrayPointer(new codec.ArrayOf(codec.Uint8), val.allAcceptedCredentialsIds);
  };
  function CurrentUserDetailsOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CurrentUserDetailsOptions.prototype.initDefaults_ = function() {
    this.userId = null;
    this.name = null;
    this.displayName = null;
  };
  CurrentUserDetailsOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CurrentUserDetailsOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CurrentUserDetailsOptions.userId
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CurrentUserDetailsOptions.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CurrentUserDetailsOptions.displayName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CurrentUserDetailsOptions.encodedSize = codec.kStructHeaderSize + 24;

  CurrentUserDetailsOptions.decode = function(decoder) {
    var packed;
    var val = new CurrentUserDetailsOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.userId =
        decoder.decodeArrayPointer(codec.Uint8);
    val.name =
        decoder.decodeStruct(codec.String);
    val.displayName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CurrentUserDetailsOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CurrentUserDetailsOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.userId);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.displayName);
  };
  function WebAuthnClientCapability(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebAuthnClientCapability.prototype.initDefaults_ = function() {
    this.name = null;
    this.supported = false;
  };
  WebAuthnClientCapability.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebAuthnClientCapability.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebAuthnClientCapability.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebAuthnClientCapability.encodedSize = codec.kStructHeaderSize + 16;

  WebAuthnClientCapability.decode = function(decoder) {
    var packed;
    var val = new WebAuthnClientCapability();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.supported = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebAuthnClientCapability.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebAuthnClientCapability.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    packed = 0;
    packed |= (val.supported & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GetAssertionResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GetAssertionResponse.prototype.initDefaults_ = function() {
    this.status = 0;
    this.credential = null;
    this.domExceptionDetails = null;
  };
  GetAssertionResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GetAssertionResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetAssertionResponse.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AuthenticatorStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetAssertionResponse.credential
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, GetAssertionAuthenticatorResponse, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GetAssertionResponse.domExceptionDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, WebAuthnDOMExceptionDetails, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GetAssertionResponse.encodedSize = codec.kStructHeaderSize + 24;

  GetAssertionResponse.decode = function(decoder) {
    var packed;
    var val = new GetAssertionResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(AuthenticatorStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.credential =
        decoder.decodeStructPointer(GetAssertionAuthenticatorResponse);
    val.domExceptionDetails =
        decoder.decodeStructPointer(WebAuthnDOMExceptionDetails);
    return val;
  };

  GetAssertionResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GetAssertionResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(GetAssertionAuthenticatorResponse, val.credential);
    encoder.encodeStructPointer(WebAuthnDOMExceptionDetails, val.domExceptionDetails);
  };
  function Authenticator_MakeCredential_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_MakeCredential_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  Authenticator_MakeCredential_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_MakeCredential_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_MakeCredential_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PublicKeyCredentialCreationOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_MakeCredential_Params.encodedSize = codec.kStructHeaderSize + 8;

  Authenticator_MakeCredential_Params.decode = function(decoder) {
    var packed;
    var val = new Authenticator_MakeCredential_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(PublicKeyCredentialCreationOptions);
    return val;
  };

  Authenticator_MakeCredential_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_MakeCredential_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PublicKeyCredentialCreationOptions, val.options);
  };
  function Authenticator_MakeCredential_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_MakeCredential_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.credential = null;
    this.domExceptionDetails = null;
  };
  Authenticator_MakeCredential_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_MakeCredential_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_MakeCredential_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AuthenticatorStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_MakeCredential_ResponseParams.credential
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, MakeCredentialAuthenticatorResponse, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_MakeCredential_ResponseParams.domExceptionDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, WebAuthnDOMExceptionDetails, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_MakeCredential_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  Authenticator_MakeCredential_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Authenticator_MakeCredential_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(AuthenticatorStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.credential =
        decoder.decodeStructPointer(MakeCredentialAuthenticatorResponse);
    val.domExceptionDetails =
        decoder.decodeStructPointer(WebAuthnDOMExceptionDetails);
    return val;
  };

  Authenticator_MakeCredential_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_MakeCredential_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(MakeCredentialAuthenticatorResponse, val.credential);
    encoder.encodeStructPointer(WebAuthnDOMExceptionDetails, val.domExceptionDetails);
  };
  function Authenticator_GetCredential_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_GetCredential_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  Authenticator_GetCredential_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_GetCredential_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_GetCredential_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, GetCredentialOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_GetCredential_Params.encodedSize = codec.kStructHeaderSize + 8;

  Authenticator_GetCredential_Params.decode = function(decoder) {
    var packed;
    var val = new Authenticator_GetCredential_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(GetCredentialOptions);
    return val;
  };

  Authenticator_GetCredential_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_GetCredential_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(GetCredentialOptions, val.options);
  };
  function Authenticator_GetCredential_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_GetCredential_ResponseParams.prototype.initDefaults_ = function() {
    this.response = null;
  };
  Authenticator_GetCredential_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_GetCredential_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_GetCredential_ResponseParams.response
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, GetCredentialResponse, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_GetCredential_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  Authenticator_GetCredential_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Authenticator_GetCredential_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStruct(GetCredentialResponse);
    return val;
  };

  Authenticator_GetCredential_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_GetCredential_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(GetCredentialResponse, val.response);
  };
  function Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params.prototype.initDefaults_ = function() {
  };
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params.encodedSize = codec.kStructHeaderSize + 0;

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams.prototype.initDefaults_ = function() {
    this.available = false;
  };
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.available = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.available & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Authenticator_IsConditionalMediationAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_IsConditionalMediationAvailable_Params.prototype.initDefaults_ = function() {
  };
  Authenticator_IsConditionalMediationAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_IsConditionalMediationAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_IsConditionalMediationAvailable_Params.encodedSize = codec.kStructHeaderSize + 0;

  Authenticator_IsConditionalMediationAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new Authenticator_IsConditionalMediationAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Authenticator_IsConditionalMediationAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_IsConditionalMediationAvailable_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function Authenticator_IsConditionalMediationAvailable_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_IsConditionalMediationAvailable_ResponseParams.prototype.initDefaults_ = function() {
    this.available = false;
  };
  Authenticator_IsConditionalMediationAvailable_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_IsConditionalMediationAvailable_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  Authenticator_IsConditionalMediationAvailable_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Authenticator_IsConditionalMediationAvailable_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Authenticator_IsConditionalMediationAvailable_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.available = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Authenticator_IsConditionalMediationAvailable_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_IsConditionalMediationAvailable_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.available & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Authenticator_Report_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_Report_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  Authenticator_Report_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_Report_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_Report_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PublicKeyCredentialReportOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_Report_Params.encodedSize = codec.kStructHeaderSize + 8;

  Authenticator_Report_Params.decode = function(decoder) {
    var packed;
    var val = new Authenticator_Report_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(PublicKeyCredentialReportOptions);
    return val;
  };

  Authenticator_Report_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_Report_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PublicKeyCredentialReportOptions, val.options);
  };
  function Authenticator_Report_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_Report_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.domExceptionDetails = null;
  };
  Authenticator_Report_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_Report_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_Report_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AuthenticatorStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_Report_ResponseParams.domExceptionDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, WebAuthnDOMExceptionDetails, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_Report_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  Authenticator_Report_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Authenticator_Report_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(AuthenticatorStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.domExceptionDetails =
        decoder.decodeStructPointer(WebAuthnDOMExceptionDetails);
    return val;
  };

  Authenticator_Report_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_Report_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(WebAuthnDOMExceptionDetails, val.domExceptionDetails);
  };
  function Authenticator_GetClientCapabilities_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_GetClientCapabilities_Params.prototype.initDefaults_ = function() {
  };
  Authenticator_GetClientCapabilities_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_GetClientCapabilities_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_GetClientCapabilities_Params.encodedSize = codec.kStructHeaderSize + 0;

  Authenticator_GetClientCapabilities_Params.decode = function(decoder) {
    var packed;
    var val = new Authenticator_GetClientCapabilities_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Authenticator_GetClientCapabilities_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_GetClientCapabilities_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function Authenticator_GetClientCapabilities_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_GetClientCapabilities_ResponseParams.prototype.initDefaults_ = function() {
    this.capabilities = null;
  };
  Authenticator_GetClientCapabilities_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_GetClientCapabilities_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Authenticator_GetClientCapabilities_ResponseParams.capabilities
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(WebAuthnClientCapability), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_GetClientCapabilities_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  Authenticator_GetClientCapabilities_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new Authenticator_GetClientCapabilities_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.capabilities =
        decoder.decodeArrayPointer(new codec.PointerTo(WebAuthnClientCapability));
    return val;
  };

  Authenticator_GetClientCapabilities_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_GetClientCapabilities_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(WebAuthnClientCapability), val.capabilities);
  };
  function Authenticator_Cancel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Authenticator_Cancel_Params.prototype.initDefaults_ = function() {
  };
  Authenticator_Cancel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Authenticator_Cancel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Authenticator_Cancel_Params.encodedSize = codec.kStructHeaderSize + 0;

  Authenticator_Cancel_Params.decode = function(decoder) {
    var packed;
    var val = new Authenticator_Cancel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  Authenticator_Cancel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Authenticator_Cancel_Params.encodedSize);
    encoder.writeUint32(0);
  };

  function GetCredentialResponse(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  GetCredentialResponse.Tags = {
    getAssertionResponse: 0,
    passwordResponse: 1,
  };

  GetCredentialResponse.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  GetCredentialResponse.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "getAssertionResponse",
        "passwordResponse",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a GetCredentialResponse member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(GetCredentialResponse.prototype, "getAssertionResponse", {
    get: function() {
      if (this.$tag != GetCredentialResponse.Tags.getAssertionResponse) {
        throw new ReferenceError(
            "GetCredentialResponse.getAssertionResponse is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GetCredentialResponse.Tags.getAssertionResponse;
      this.$data = value;
    }
  });
  Object.defineProperty(GetCredentialResponse.prototype, "passwordResponse", {
    get: function() {
      if (this.$tag != GetCredentialResponse.Tags.passwordResponse) {
        throw new ReferenceError(
            "GetCredentialResponse.passwordResponse is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GetCredentialResponse.Tags.passwordResponse;
      this.$data = value;
    }
  });


    GetCredentialResponse.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case GetCredentialResponse.Tags.getAssertionResponse:
          encoder.encodeStructPointer(GetAssertionResponse, val.getAssertionResponse);
          break;
        case GetCredentialResponse.Tags.passwordResponse:
          encoder.encodeStructPointer(credential_manager$.CredentialInfo, val.passwordResponse);
          break;
      }
      encoder.align();
    };


    GetCredentialResponse.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new GetCredentialResponse();
      var tag = decoder.readUint32();
      switch (tag) {
        case GetCredentialResponse.Tags.getAssertionResponse:
          result.getAssertionResponse = decoder.decodeStructPointer(GetAssertionResponse);
          break;
        case GetCredentialResponse.Tags.passwordResponse:
          result.passwordResponse = decoder.decodeStructPointer(credential_manager$.CredentialInfo);
          break;
      }
      decoder.align();

      return result;
    };


    GetCredentialResponse.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case GetCredentialResponse.Tags.getAssertionResponse:
          

    // validate GetCredentialResponse.getAssertionResponse
    err = messageValidator.validateStructPointer(data_offset, GetAssertionResponse, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case GetCredentialResponse.Tags.passwordResponse:
          

    // validate GetCredentialResponse.passwordResponse
    err = messageValidator.validateStructPointer(data_offset, credential_manager$.CredentialInfo, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  GetCredentialResponse.encodedSize = 16;
  var kAuthenticator_MakeCredential_Name = 0;
  var kAuthenticator_GetCredential_Name = 1;
  var kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name = 2;
  var kAuthenticator_IsConditionalMediationAvailable_Name = 3;
  var kAuthenticator_Report_Name = 4;
  var kAuthenticator_GetClientCapabilities_Name = 5;
  var kAuthenticator_Cancel_Name = 6;

  function AuthenticatorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(Authenticator,
                                                   handleOrPtrInfo);
  }

  function AuthenticatorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        Authenticator, associatedInterfacePtrInfo);
  }

  AuthenticatorAssociatedPtr.prototype =
      Object.create(AuthenticatorPtr.prototype);
  AuthenticatorAssociatedPtr.prototype.constructor =
      AuthenticatorAssociatedPtr;

  function AuthenticatorProxy(receiver) {
    this.receiver_ = receiver;
  }
  AuthenticatorPtr.prototype.makeCredential = function() {
    return AuthenticatorProxy.prototype.makeCredential
        .apply(this.ptr.getProxy(), arguments);
  };

  AuthenticatorProxy.prototype.makeCredential = function(options) {
    var params_ = new Authenticator_MakeCredential_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAuthenticator_MakeCredential_Name,
          codec.align(Authenticator_MakeCredential_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Authenticator_MakeCredential_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Authenticator_MakeCredential_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AuthenticatorPtr.prototype.getCredential = function() {
    return AuthenticatorProxy.prototype.getCredential
        .apply(this.ptr.getProxy(), arguments);
  };

  AuthenticatorProxy.prototype.getCredential = function(options) {
    var params_ = new Authenticator_GetCredential_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAuthenticator_GetCredential_Name,
          codec.align(Authenticator_GetCredential_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Authenticator_GetCredential_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Authenticator_GetCredential_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AuthenticatorPtr.prototype.isUserVerifyingPlatformAuthenticatorAvailable = function() {
    return AuthenticatorProxy.prototype.isUserVerifyingPlatformAuthenticatorAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  AuthenticatorProxy.prototype.isUserVerifyingPlatformAuthenticatorAvailable = function() {
    var params_ = new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name,
          codec.align(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AuthenticatorPtr.prototype.isConditionalMediationAvailable = function() {
    return AuthenticatorProxy.prototype.isConditionalMediationAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  AuthenticatorProxy.prototype.isConditionalMediationAvailable = function() {
    var params_ = new Authenticator_IsConditionalMediationAvailable_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAuthenticator_IsConditionalMediationAvailable_Name,
          codec.align(Authenticator_IsConditionalMediationAvailable_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Authenticator_IsConditionalMediationAvailable_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Authenticator_IsConditionalMediationAvailable_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AuthenticatorPtr.prototype.report = function() {
    return AuthenticatorProxy.prototype.report
        .apply(this.ptr.getProxy(), arguments);
  };

  AuthenticatorProxy.prototype.report = function(options) {
    var params_ = new Authenticator_Report_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAuthenticator_Report_Name,
          codec.align(Authenticator_Report_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Authenticator_Report_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Authenticator_Report_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AuthenticatorPtr.prototype.getClientCapabilities = function() {
    return AuthenticatorProxy.prototype.getClientCapabilities
        .apply(this.ptr.getProxy(), arguments);
  };

  AuthenticatorProxy.prototype.getClientCapabilities = function() {
    var params_ = new Authenticator_GetClientCapabilities_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAuthenticator_GetClientCapabilities_Name,
          codec.align(Authenticator_GetClientCapabilities_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(Authenticator_GetClientCapabilities_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(Authenticator_GetClientCapabilities_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AuthenticatorPtr.prototype.cancel = function() {
    return AuthenticatorProxy.prototype.cancel
        .apply(this.ptr.getProxy(), arguments);
  };

  AuthenticatorProxy.prototype.cancel = function() {
    var params_ = new Authenticator_Cancel_Params();
    var builder = new codec.MessageV0Builder(
        kAuthenticator_Cancel_Name,
        codec.align(Authenticator_Cancel_Params.encodedSize));
    builder.encodeStruct(Authenticator_Cancel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AuthenticatorStub(delegate) {
    this.delegate_ = delegate;
  }
  AuthenticatorStub.prototype.makeCredential = function(options) {
    return this.delegate_ && this.delegate_.makeCredential && this.delegate_.makeCredential(options);
  }
  AuthenticatorStub.prototype.getCredential = function(options) {
    return this.delegate_ && this.delegate_.getCredential && this.delegate_.getCredential(options);
  }
  AuthenticatorStub.prototype.isUserVerifyingPlatformAuthenticatorAvailable = function() {
    return this.delegate_ && this.delegate_.isUserVerifyingPlatformAuthenticatorAvailable && this.delegate_.isUserVerifyingPlatformAuthenticatorAvailable();
  }
  AuthenticatorStub.prototype.isConditionalMediationAvailable = function() {
    return this.delegate_ && this.delegate_.isConditionalMediationAvailable && this.delegate_.isConditionalMediationAvailable();
  }
  AuthenticatorStub.prototype.report = function(options) {
    return this.delegate_ && this.delegate_.report && this.delegate_.report(options);
  }
  AuthenticatorStub.prototype.getClientCapabilities = function() {
    return this.delegate_ && this.delegate_.getClientCapabilities && this.delegate_.getClientCapabilities();
  }
  AuthenticatorStub.prototype.cancel = function() {
    return this.delegate_ && this.delegate_.cancel && this.delegate_.cancel();
  }

  AuthenticatorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAuthenticator_Cancel_Name:
      var params = reader.decodeStruct(Authenticator_Cancel_Params);
      this.cancel();
      return true;
    default:
      return false;
    }
  };

  AuthenticatorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAuthenticator_MakeCredential_Name:
      var params = reader.decodeStruct(Authenticator_MakeCredential_Params);
      this.makeCredential(params.options).then(function(response) {
        var responseParams =
            new Authenticator_MakeCredential_ResponseParams();
        responseParams.status = response.status;
        responseParams.credential = response.credential;
        responseParams.domExceptionDetails = response.domExceptionDetails;
        var builder = new codec.MessageV1Builder(
            kAuthenticator_MakeCredential_Name,
            codec.align(Authenticator_MakeCredential_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Authenticator_MakeCredential_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAuthenticator_GetCredential_Name:
      var params = reader.decodeStruct(Authenticator_GetCredential_Params);
      this.getCredential(params.options).then(function(response) {
        var responseParams =
            new Authenticator_GetCredential_ResponseParams();
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kAuthenticator_GetCredential_Name,
            codec.align(Authenticator_GetCredential_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Authenticator_GetCredential_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name:
      var params = reader.decodeStruct(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params);
      this.isUserVerifyingPlatformAuthenticatorAvailable().then(function(response) {
        var responseParams =
            new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams();
        responseParams.available = response.available;
        var builder = new codec.MessageV1Builder(
            kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name,
            codec.align(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAuthenticator_IsConditionalMediationAvailable_Name:
      var params = reader.decodeStruct(Authenticator_IsConditionalMediationAvailable_Params);
      this.isConditionalMediationAvailable().then(function(response) {
        var responseParams =
            new Authenticator_IsConditionalMediationAvailable_ResponseParams();
        responseParams.available = response.available;
        var builder = new codec.MessageV1Builder(
            kAuthenticator_IsConditionalMediationAvailable_Name,
            codec.align(Authenticator_IsConditionalMediationAvailable_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Authenticator_IsConditionalMediationAvailable_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAuthenticator_Report_Name:
      var params = reader.decodeStruct(Authenticator_Report_Params);
      this.report(params.options).then(function(response) {
        var responseParams =
            new Authenticator_Report_ResponseParams();
        responseParams.status = response.status;
        responseParams.domExceptionDetails = response.domExceptionDetails;
        var builder = new codec.MessageV1Builder(
            kAuthenticator_Report_Name,
            codec.align(Authenticator_Report_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Authenticator_Report_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAuthenticator_GetClientCapabilities_Name:
      var params = reader.decodeStruct(Authenticator_GetClientCapabilities_Params);
      this.getClientCapabilities().then(function(response) {
        var responseParams =
            new Authenticator_GetClientCapabilities_ResponseParams();
        responseParams.capabilities = response.capabilities;
        var builder = new codec.MessageV1Builder(
            kAuthenticator_GetClientCapabilities_Name,
            codec.align(Authenticator_GetClientCapabilities_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(Authenticator_GetClientCapabilities_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAuthenticatorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAuthenticator_MakeCredential_Name:
        if (message.expectsResponse())
          paramsClass = Authenticator_MakeCredential_Params;
      break;
      case kAuthenticator_GetCredential_Name:
        if (message.expectsResponse())
          paramsClass = Authenticator_GetCredential_Params;
      break;
      case kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name:
        if (message.expectsResponse())
          paramsClass = Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params;
      break;
      case kAuthenticator_IsConditionalMediationAvailable_Name:
        if (message.expectsResponse())
          paramsClass = Authenticator_IsConditionalMediationAvailable_Params;
      break;
      case kAuthenticator_Report_Name:
        if (message.expectsResponse())
          paramsClass = Authenticator_Report_Params;
      break;
      case kAuthenticator_GetClientCapabilities_Name:
        if (message.expectsResponse())
          paramsClass = Authenticator_GetClientCapabilities_Params;
      break;
      case kAuthenticator_Cancel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = Authenticator_Cancel_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAuthenticatorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAuthenticator_MakeCredential_Name:
        if (message.isResponse())
          paramsClass = Authenticator_MakeCredential_ResponseParams;
        break;
      case kAuthenticator_GetCredential_Name:
        if (message.isResponse())
          paramsClass = Authenticator_GetCredential_ResponseParams;
        break;
      case kAuthenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Name:
        if (message.isResponse())
          paramsClass = Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams;
        break;
      case kAuthenticator_IsConditionalMediationAvailable_Name:
        if (message.isResponse())
          paramsClass = Authenticator_IsConditionalMediationAvailable_ResponseParams;
        break;
      case kAuthenticator_Report_Name:
        if (message.isResponse())
          paramsClass = Authenticator_Report_ResponseParams;
        break;
      case kAuthenticator_GetClientCapabilities_Name:
        if (message.isResponse())
          paramsClass = Authenticator_GetClientCapabilities_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var Authenticator = {
    name: 'blink.mojom.Authenticator',
    kVersion: 0,
    ptrClass: AuthenticatorPtr,
    proxyClass: AuthenticatorProxy,
    stubClass: AuthenticatorStub,
    validateRequest: validateAuthenticatorRequest,
    validateResponse: validateAuthenticatorResponse,
  };
  AuthenticatorStub.prototype.validator = validateAuthenticatorRequest;
  AuthenticatorProxy.prototype.validator = validateAuthenticatorResponse;
  exports.PUBLIC_KEY_CREDENTIAL_DESCRIPTOR_LIST_MAX_SIZE = PUBLIC_KEY_CREDENTIAL_DESCRIPTOR_LIST_MAX_SIZE;
  exports.AuthenticatorStatus = AuthenticatorStatus;
  exports.AuthenticatorTransport = AuthenticatorTransport;
  exports.Hint = Hint;
  exports.UserVerificationRequirement = UserVerificationRequirement;
  exports.Mediation = Mediation;
  exports.ResidentKeyRequirement = ResidentKeyRequirement;
  exports.AuthenticatorAttachment = AuthenticatorAttachment;
  exports.ProtectionPolicy = ProtectionPolicy;
  exports.LargeBlobSupport = LargeBlobSupport;
  exports.AttestationConveyancePreference = AttestationConveyancePreference;
  exports.PublicKeyCredentialType = PublicKeyCredentialType;
  exports.CommonCredentialInfo = CommonCredentialInfo;
  exports.SupplementalPubKeysResponse = SupplementalPubKeysResponse;
  exports.AuthenticationExtensionsPaymentResponse = AuthenticationExtensionsPaymentResponse;
  exports.MakeCredentialAuthenticatorResponse = MakeCredentialAuthenticatorResponse;
  exports.GetAssertionAuthenticatorResponse = GetAssertionAuthenticatorResponse;
  exports.AuthenticationExtensionsClientOutputs = AuthenticationExtensionsClientOutputs;
  exports.PublicKeyCredentialRpEntity = PublicKeyCredentialRpEntity;
  exports.PublicKeyCredentialUserEntity = PublicKeyCredentialUserEntity;
  exports.PublicKeyCredentialParameters = PublicKeyCredentialParameters;
  exports.CableAuthentication = CableAuthentication;
  exports.PRFValues = PRFValues;
  exports.PaymentOptions = PaymentOptions;
  exports.PaymentCredentialInstrument = PaymentCredentialInstrument;
  exports.ShownPaymentEntityLogo = ShownPaymentEntityLogo;
  exports.RemoteDesktopClientOverride = RemoteDesktopClientOverride;
  exports.SupplementalPubKeysRequest = SupplementalPubKeysRequest;
  exports.PublicKeyCredentialRequestOptions = PublicKeyCredentialRequestOptions;
  exports.AuthenticationExtensionsClientInputs = AuthenticationExtensionsClientInputs;
  exports.GetCredentialOptions = GetCredentialOptions;
  exports.AuthenticatorSelectionCriteria = AuthenticatorSelectionCriteria;
  exports.PublicKeyCredentialCreationOptions = PublicKeyCredentialCreationOptions;
  exports.PublicKeyCredentialDescriptor = PublicKeyCredentialDescriptor;
  exports.WebAuthnDOMExceptionDetails = WebAuthnDOMExceptionDetails;
  exports.PublicKeyCredentialReportOptions = PublicKeyCredentialReportOptions;
  exports.AllAcceptedCredentialsOptions = AllAcceptedCredentialsOptions;
  exports.CurrentUserDetailsOptions = CurrentUserDetailsOptions;
  exports.WebAuthnClientCapability = WebAuthnClientCapability;
  exports.GetAssertionResponse = GetAssertionResponse;
  exports.GetCredentialResponse = GetCredentialResponse;
  exports.Authenticator = Authenticator;
  exports.AuthenticatorPtr = AuthenticatorPtr;
  exports.AuthenticatorAssociatedPtr = AuthenticatorAssociatedPtr;
})();