// third_party/blink/public/mojom/widget/device_emulation_params.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ScreenOrientation as display_mojom_ScreenOrientation,
  ScreenOrientationSpec as display_mojom_ScreenOrientationSpec
} from '../../../../../ui/display/mojom/screen_orientation.mojom.m.js';

import {
  Point as gfx_mojom_Point,
  PointSpec as gfx_mojom_PointSpec,
  PointF as gfx_mojom_PointF,
  PointFSpec as gfx_mojom_PointFSpec,
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  DevicePostureType as blink_mojom_DevicePostureType,
  DevicePostureTypeSpec as blink_mojom_DevicePostureTypeSpec
} from '../device_posture/device_posture_provider.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EmulatedScreenTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EmulatedScreenType = {
  
  kDesktop: 0,
  kMobile: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceEmulationParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DeviceEmulationParamsSpec.$,
    'DeviceEmulationParams',
    [
      mojo.internal.StructField(
        'screenType', 0,
        0,
        EmulatedScreenTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'screenSize', 8,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewPosition', 16,
        0,
        gfx_mojom_PointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewSize', 24,
        0,
        gfx_mojom_SizeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceScaleFactor', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scale', 32,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewportOffset', 40,
        0,
        gfx_mojom_PointFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewportScale', 36,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'screenOrientationType', 48,
        0,
        display_mojom_ScreenOrientationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'screenOrientationAngle', 52,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewportSegments', 56,
        0,
        mojo.internal.Array(gfx_mojom_RectSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devicePosture', 64,
        0,
        blink_mojom_DevicePostureTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class DeviceEmulationParams {
  constructor() {
    /** @type { !EmulatedScreenType } */
    this.screenType;
    /** @type { !gfx_mojom_Size } */
    this.screenSize;
    /** @type { (gfx_mojom_Point|undefined) } */
    this.viewPosition;
    /** @type { !gfx_mojom_Size } */
    this.viewSize;
    /** @type { !number } */
    this.deviceScaleFactor;
    /** @type { !number } */
    this.scale;
    /** @type { !gfx_mojom_PointF } */
    this.viewportOffset;
    /** @type { !number } */
    this.viewportScale;
    /** @type { !display_mojom_ScreenOrientation } */
    this.screenOrientationType;
    /** @type { !number } */
    this.screenOrientationAngle;
    /** @type { !Array<!gfx_mojom_Rect> } */
    this.viewportSegments;
    /** @type { !blink_mojom_DevicePostureType } */
    this.devicePosture;
  }
}

