// third_party/blink/public/mojom/worker/dedicated_worker_host_factory.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');




/**
 * @const { !string }
 * @export
 */
blink.mojom.NAVIGATION_DEDICATED_WORKER_SPEC = "navigation:dedicated_worker";





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DedicatedWorkerHostFactoryClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DedicatedWorkerHostFactoryClientInterface }
 */
blink.mojom.DedicatedWorkerHostFactoryClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DedicatedWorkerHostFactoryClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DedicatedWorkerHostFactoryClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DedicatedWorkerHostFactoryClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.BrowserInterfaceBrokerRemote } browserInterfaceBroker
   * @param { !blink.mojom.DedicatedWorkerHostRemote } host
   * @param { !url.mojom.Origin } origin
   */

  onWorkerHostCreated(
      browserInterfaceBroker,
      host,
      origin) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec.$,
        null,
        [
          browserInterfaceBroker,
          host,
          origin
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.ServiceWorkerContainerInfoForClient } serviceWorkerContainerInfo
   * @param { !blink.mojom.WorkerMainScriptLoadParams } mainScriptLoadParams
   * @param { !blink.mojom.URLLoaderFactoryBundle } subresourceLoaderFactories
   * @param { !blink.mojom.SubresourceLoaderUpdaterPendingReceiver } subresourceLoaderUpdater
   * @param { ?blink.mojom.ControllerServiceWorkerInfo } controllerInfo
   * @param { !blink.mojom.BackForwardCacheControllerHostRemote } backForwardCacheControllerHost
   * @param { ?blink.mojom.ReportingObserverPendingReceiver } coepReportingObserverReceiver
   * @param { ?blink.mojom.ReportingObserverPendingReceiver } dipReportingObserverReceiver
   */

  onScriptLoadStarted(
      serviceWorkerContainerInfo,
      mainScriptLoadParams,
      subresourceLoaderFactories,
      subresourceLoaderUpdater,
      controllerInfo,
      backForwardCacheControllerHost,
      coepReportingObserverReceiver,
      dipReportingObserverReceiver) {
    this.proxy.sendMessage(
        1,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec.$,
        null,
        [
          serviceWorkerContainerInfo,
          mainScriptLoadParams,
          subresourceLoaderFactories,
          subresourceLoaderUpdater,
          controllerInfo,
          backForwardCacheControllerHost,
          coepReportingObserverReceiver,
          dipReportingObserverReceiver
        ],
        false);
  }

  
  /**
   */

  onScriptLoadStartFailed() {
    this.proxy.sendMessage(
        2,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DedicatedWorkerHostFactoryClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryClientReceiver = class {
  /**
   * @param {!blink.mojom.DedicatedWorkerHostFactoryClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DedicatedWorkerHostFactoryClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DedicatedWorkerHostFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DedicatedWorkerHostFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec.$,
        null,
        impl.onWorkerHostCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec.$,
        null,
        impl.onScriptLoadStarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec.$,
        null,
        impl.onScriptLoadStartFailed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DedicatedWorkerHostFactoryClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DedicatedWorkerHostFactoryClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DedicatedWorkerHostFactoryClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DedicatedWorkerHostFactoryClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DedicatedWorkerHostFactoryClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DedicatedWorkerHostFactoryClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DedicatedWorkerHostFactoryClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWorkerHostCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec.$,
        null,
        this.onWorkerHostCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoadStarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec.$,
        null,
        this.onScriptLoadStarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoadStartFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec.$,
        null,
        this.onScriptLoadStartFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DedicatedWorkerHostFactory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DedicatedWorkerHostFactoryInterface }
 */
blink.mojom.DedicatedWorkerHostFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DedicatedWorkerHostFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DedicatedWorkerHostFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DedicatedWorkerHostFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DedicatedWorkerToken } token
   * @param { !url.mojom.Url } scriptUrl
   * @param { !network.mojom.CredentialsMode } credentialsMode
   * @param { !blink.mojom.FetchClientSettingsObject } outsideFetchClientSettingsObject
   * @param { ?blink.mojom.BlobURLTokenRemote } blobUrlToken
   * @param { !blink.mojom.DedicatedWorkerHostFactoryClientRemote } client
   * @param { !network.mojom.StorageAccessApiStatus } storageAccessApiStatus
   */

  createWorkerHostAndStartScriptLoad(
      token,
      scriptUrl,
      credentialsMode,
      outsideFetchClientSettingsObject,
      blobUrlToken,
      client,
      storageAccessApiStatus) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec.$,
        null,
        [
          token,
          scriptUrl,
          credentialsMode,
          outsideFetchClientSettingsObject,
          blobUrlToken,
          client,
          storageAccessApiStatus
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DedicatedWorkerHostFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryReceiver = class {
  /**
   * @param {!blink.mojom.DedicatedWorkerHostFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DedicatedWorkerHostFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DedicatedWorkerHostFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DedicatedWorkerHostFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec.$,
        null,
        impl.createWorkerHostAndStartScriptLoad.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DedicatedWorkerHostFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DedicatedWorkerHostFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DedicatedWorkerHostFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DedicatedWorkerHostFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DedicatedWorkerHostFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DedicatedWorkerHostFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DedicatedWorkerHostFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createWorkerHostAndStartScriptLoad =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec.$,
        null,
        this.createWorkerHostAndStartScriptLoad.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_ParamsSpec.$,
    'DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params',
    [
      mojo.internal.StructField(
        'browserInterfaceBroker', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BrowserInterfaceBrokerRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.DedicatedWorkerHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'origin', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.DedicatedWorkerHostFactoryClient_OnWorkerHostCreated_Params = class {
  constructor() {
    /** @export { !blink.mojom.BrowserInterfaceBrokerRemote } */
    this.browserInterfaceBroker;
    /** @export { !blink.mojom.DedicatedWorkerHostRemote } */
    this.host;
    /** @export { !url.mojom.Origin } */
    this.origin;
  }
};



mojo.internal.Struct(
    blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_ParamsSpec.$,
    'DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerContainerInfo', 0,
        0,
        blink.mojom.ServiceWorkerContainerInfoForClientSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mainScriptLoadParams', 8,
        0,
        blink.mojom.WorkerMainScriptLoadParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subresourceLoaderFactories', 16,
        0,
        blink.mojom.URLLoaderFactoryBundleSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subresourceLoaderUpdater', 24,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.SubresourceLoaderUpdaterPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'controllerInfo', 32,
        0,
        blink.mojom.ControllerServiceWorkerInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'backForwardCacheControllerHost', 40,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BackForwardCacheControllerHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'coepReportingObserverReceiver', 28,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ReportingObserverPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dipReportingObserverReceiver', 48,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.ReportingObserverPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStarted_Params = class {
  constructor() {
    /** @export { (blink.mojom.ServiceWorkerContainerInfoForClient|undefined) } */
    this.serviceWorkerContainerInfo;
    /** @export { !blink.mojom.WorkerMainScriptLoadParams } */
    this.mainScriptLoadParams;
    /** @export { !blink.mojom.URLLoaderFactoryBundle } */
    this.subresourceLoaderFactories;
    /** @export { !blink.mojom.SubresourceLoaderUpdaterPendingReceiver } */
    this.subresourceLoaderUpdater;
    /** @export { (blink.mojom.ControllerServiceWorkerInfo|undefined) } */
    this.controllerInfo;
    /** @export { !blink.mojom.BackForwardCacheControllerHostRemote } */
    this.backForwardCacheControllerHost;
    /** @export { (blink.mojom.ReportingObserverPendingReceiver|undefined) } */
    this.coepReportingObserverReceiver;
    /** @export { (blink.mojom.ReportingObserverPendingReceiver|undefined) } */
    this.dipReportingObserverReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_ParamsSpec.$,
    'DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.DedicatedWorkerHostFactoryClient_OnScriptLoadStartFailed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_ParamsSpec.$,
    'DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink.mojom.DedicatedWorkerTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scriptUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'credentialsMode', 16,
        0,
        network.mojom.CredentialsModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outsideFetchClientSettingsObject', 24,
        0,
        blink.mojom.FetchClientSettingsObjectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blobUrlToken', 32,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.BlobURLTokenRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 40,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.DedicatedWorkerHostFactoryClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'storageAccessApiStatus', 20,
        0,
        network.mojom.StorageAccessApiStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.DedicatedWorkerHostFactory_CreateWorkerHostAndStartScriptLoad_Params = class {
  constructor() {
    /** @export { !blink.mojom.DedicatedWorkerToken } */
    this.token;
    /** @export { !url.mojom.Url } */
    this.scriptUrl;
    /** @export { !network.mojom.CredentialsMode } */
    this.credentialsMode;
    /** @export { !blink.mojom.FetchClientSettingsObject } */
    this.outsideFetchClientSettingsObject;
    /** @export { (blink.mojom.BlobURLTokenRemote|undefined) } */
    this.blobUrlToken;
    /** @export { !blink.mojom.DedicatedWorkerHostFactoryClientRemote } */
    this.client;
    /** @export { !network.mojom.StorageAccessApiStatus } */
    this.storageAccessApiStatus;
  }
};

