// third_party/blink/public/mojom/worker/shared_worker_client.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SharedWorkerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SharedWorkerClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.SharedWorkerClientInterface }
 */
blink.mojom.SharedWorkerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SharedWorkerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SharedWorkerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SharedWorkerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.SharedWorkerCreationContextType } creationContextType
   */

  onCreated(
      creationContextType) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SharedWorkerClient_OnCreated_ParamsSpec.$,
        null,
        [
          creationContextType
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.WebFeature> } featuresUsed
   */

  onConnected(
      featuresUsed) {
    this.proxy.sendMessage(
        1,
        blink.mojom.SharedWorkerClient_OnConnected_ParamsSpec.$,
        null,
        [
          featuresUsed
        ],
        false);
  }

  
  /**
   * @param { !string } errorMessage
   */

  onScriptLoadFailed(
      errorMessage) {
    this.proxy.sendMessage(
        2,
        blink.mojom.SharedWorkerClient_OnScriptLoadFailed_ParamsSpec.$,
        null,
        [
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.SharedWorkerExceptionDetails } details
   */

  onReportException(
      details) {
    this.proxy.sendMessage(
        3,
        blink.mojom.SharedWorkerClient_OnReportException_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.WebFeature } feature
   */

  onFeatureUsed(
      feature) {
    this.proxy.sendMessage(
        4,
        blink.mojom.SharedWorkerClient_OnFeatureUsed_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SharedWorkerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SharedWorkerClientReceiver = class {
  /**
   * @param {!blink.mojom.SharedWorkerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SharedWorkerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SharedWorkerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorkerClient_OnCreated_ParamsSpec.$,
        null,
        impl.onCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedWorkerClient_OnConnected_ParamsSpec.$,
        null,
        impl.onConnected.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedWorkerClient_OnScriptLoadFailed_ParamsSpec.$,
        null,
        impl.onScriptLoadFailed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedWorkerClient_OnReportException_ParamsSpec.$,
        null,
        impl.onReportException.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SharedWorkerClient_OnFeatureUsed_ParamsSpec.$,
        null,
        impl.onFeatureUsed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SharedWorkerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorkerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SharedWorkerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SharedWorkerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SharedWorkerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SharedWorkerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SharedWorkerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SharedWorkerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SharedWorkerClient_OnCreated_ParamsSpec.$,
        null,
        this.onCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnected =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SharedWorkerClient_OnConnected_ParamsSpec.$,
        null,
        this.onConnected.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoadFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SharedWorkerClient_OnScriptLoadFailed_ParamsSpec.$,
        null,
        this.onScriptLoadFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportException =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SharedWorkerClient_OnReportException_ParamsSpec.$,
        null,
        this.onReportException.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFeatureUsed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SharedWorkerClient_OnFeatureUsed_ParamsSpec.$,
        null,
        this.onFeatureUsed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerClient_OnCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerClient_OnConnected_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerClient_OnScriptLoadFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerClient_OnReportException_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SharedWorkerClient_OnFeatureUsed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SharedWorkerClient_OnCreated_ParamsSpec.$,
    'SharedWorkerClient_OnCreated_Params',
    [
      mojo.internal.StructField(
        'creationContextType', 0,
        0,
        blink.mojom.SharedWorkerCreationContextTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerClient_OnCreated_Params = class {
  constructor() {
    /** @export { !blink.mojom.SharedWorkerCreationContextType } */
    this.creationContextType;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerClient_OnConnected_ParamsSpec.$,
    'SharedWorkerClient_OnConnected_Params',
    [
      mojo.internal.StructField(
        'featuresUsed', 0,
        0,
        mojo.internal.Array(blink.mojom.WebFeatureSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerClient_OnConnected_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.WebFeature> } */
    this.featuresUsed;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerClient_OnScriptLoadFailed_ParamsSpec.$,
    'SharedWorkerClient_OnScriptLoadFailed_Params',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerClient_OnScriptLoadFailed_Params = class {
  constructor() {
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerClient_OnReportException_ParamsSpec.$,
    'SharedWorkerClient_OnReportException_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        blink.mojom.SharedWorkerExceptionDetailsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerClient_OnReportException_Params = class {
  constructor() {
    /** @export { !blink.mojom.SharedWorkerExceptionDetails } */
    this.details;
  }
};



mojo.internal.Struct(
    blink.mojom.SharedWorkerClient_OnFeatureUsed_ParamsSpec.$,
    'SharedWorkerClient_OnFeatureUsed_Params',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink.mojom.WebFeatureSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.SharedWorkerClient_OnFeatureUsed_Params = class {
  constructor() {
    /** @export { !blink.mojom.WebFeature } */
    this.feature;
  }
};

