// third_party/blink/public/mojom/worker/shared_worker_client.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  WebFeature as blink_mojom_WebFeature,
  WebFeatureSpec as blink_mojom_WebFeatureSpec
} from '../use_counter/metrics/web_feature.mojom.m.js';

import {
  SharedWorkerCreationContextType as blink_mojom_SharedWorkerCreationContextType,
  SharedWorkerCreationContextTypeSpec as blink_mojom_SharedWorkerCreationContextTypeSpec
} from './shared_worker_creation_context_type.mojom.m.js';

import {
  SharedWorkerExceptionDetails as blink_mojom_SharedWorkerExceptionDetails,
  SharedWorkerExceptionDetailsSpec as blink_mojom_SharedWorkerExceptionDetailsSpec
} from './shared_worker_exception_details.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SharedWorkerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.SharedWorkerClient', scope);
  }
}

/** @interface */
export class SharedWorkerClientInterface {
  
  /**
   * @param { !blink_mojom_SharedWorkerCreationContextType } creationContextType
   */

  onCreated(creationContextType) {}
  
  /**
   * @param { !Array<!blink_mojom_WebFeature> } featuresUsed
   */

  onConnected(featuresUsed) {}
  
  /**
   * @param { !string } errorMessage
   */

  onScriptLoadFailed(errorMessage) {}
  
  /**
   * @param { !blink_mojom_SharedWorkerExceptionDetails } details
   */

  onReportException(details) {}
  
  /**
   * @param { !blink_mojom_WebFeature } feature
   */

  onFeatureUsed(feature) {}
}

/**
 * @implements { SharedWorkerClientInterface }
 */
export class SharedWorkerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SharedWorkerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SharedWorkerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SharedWorkerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_SharedWorkerCreationContextType } creationContextType
   */

  onCreated(
      creationContextType) {
    this.proxy.sendMessage(
        0,
        SharedWorkerClient_OnCreated_ParamsSpec.$,
        null,
        [
          creationContextType
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink_mojom_WebFeature> } featuresUsed
   */

  onConnected(
      featuresUsed) {
    this.proxy.sendMessage(
        1,
        SharedWorkerClient_OnConnected_ParamsSpec.$,
        null,
        [
          featuresUsed
        ],
        false);
  }

  
  /**
   * @param { !string } errorMessage
   */

  onScriptLoadFailed(
      errorMessage) {
    this.proxy.sendMessage(
        2,
        SharedWorkerClient_OnScriptLoadFailed_ParamsSpec.$,
        null,
        [
          errorMessage
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_SharedWorkerExceptionDetails } details
   */

  onReportException(
      details) {
    this.proxy.sendMessage(
        3,
        SharedWorkerClient_OnReportException_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_WebFeature } feature
   */

  onFeatureUsed(
      feature) {
    this.proxy.sendMessage(
        4,
        SharedWorkerClient_OnFeatureUsed_ParamsSpec.$,
        null,
        [
          feature
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SharedWorkerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SharedWorkerClientReceiver {
  /**
   * @param {!SharedWorkerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SharedWorkerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SharedWorkerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedWorkerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SharedWorkerClient_OnCreated_ParamsSpec.$,
        null,
        impl.onCreated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SharedWorkerClient_OnConnected_ParamsSpec.$,
        null,
        impl.onConnected.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SharedWorkerClient_OnScriptLoadFailed_ParamsSpec.$,
        null,
        impl.onScriptLoadFailed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SharedWorkerClient_OnReportException_ParamsSpec.$,
        null,
        impl.onReportException.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SharedWorkerClient_OnFeatureUsed_ParamsSpec.$,
        null,
        impl.onFeatureUsed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SharedWorkerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SharedWorkerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SharedWorkerClientRemote}
   */
  static getRemote() {
    let remote = new SharedWorkerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SharedWorkerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SharedWorkerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SharedWorkerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SharedWorkerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCreated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SharedWorkerClient_OnCreated_ParamsSpec.$,
        null,
        this.onCreated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnected =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SharedWorkerClient_OnConnected_ParamsSpec.$,
        null,
        this.onConnected.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScriptLoadFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SharedWorkerClient_OnScriptLoadFailed_ParamsSpec.$,
        null,
        this.onScriptLoadFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReportException =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SharedWorkerClient_OnReportException_ParamsSpec.$,
        null,
        this.onReportException.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFeatureUsed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SharedWorkerClient_OnFeatureUsed_ParamsSpec.$,
        null,
        this.onFeatureUsed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorkerClient_OnCreated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorkerClient_OnConnected_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorkerClient_OnScriptLoadFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorkerClient_OnReportException_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SharedWorkerClient_OnFeatureUsed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SharedWorkerClient_OnCreated_ParamsSpec.$,
    'SharedWorkerClient_OnCreated_Params',
    [
      mojo.internal.StructField(
        'creationContextType', 0,
        0,
        blink_mojom_SharedWorkerCreationContextTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedWorkerClient_OnCreated_Params {
  constructor() {
    /** @type { !blink_mojom_SharedWorkerCreationContextType } */
    this.creationContextType;
  }
}



mojo.internal.Struct(
    SharedWorkerClient_OnConnected_ParamsSpec.$,
    'SharedWorkerClient_OnConnected_Params',
    [
      mojo.internal.StructField(
        'featuresUsed', 0,
        0,
        mojo.internal.Array(blink_mojom_WebFeatureSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedWorkerClient_OnConnected_Params {
  constructor() {
    /** @type { !Array<!blink_mojom_WebFeature> } */
    this.featuresUsed;
  }
}



mojo.internal.Struct(
    SharedWorkerClient_OnScriptLoadFailed_ParamsSpec.$,
    'SharedWorkerClient_OnScriptLoadFailed_Params',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedWorkerClient_OnScriptLoadFailed_Params {
  constructor() {
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    SharedWorkerClient_OnReportException_ParamsSpec.$,
    'SharedWorkerClient_OnReportException_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        blink_mojom_SharedWorkerExceptionDetailsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedWorkerClient_OnReportException_Params {
  constructor() {
    /** @type { !blink_mojom_SharedWorkerExceptionDetails } */
    this.details;
  }
}



mojo.internal.Struct(
    SharedWorkerClient_OnFeatureUsed_ParamsSpec.$,
    'SharedWorkerClient_OnFeatureUsed_Params',
    [
      mojo.internal.StructField(
        'feature', 0,
        0,
        blink_mojom_WebFeatureSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SharedWorkerClient_OnFeatureUsed_Params {
  constructor() {
    /** @type { !blink_mojom_WebFeature } */
    this.feature;
  }
}

