// gen/third_party/devtools-frontend/src/front_end/entrypoints/formatter_worker/formatter_worker-entrypoint.prebundle.js
import * as Platform from "./../../core/platform/platform.js";
import * as FormatterWorker from "./formatter_worker.js";

// gen/third_party/devtools-frontend/src/front_end/entrypoints/formatter_worker/FormatterActions.js
var FormatterActions = /* @__PURE__ */ ((FormatterActions2) => {
  FormatterActions2["FORMAT"] = "format";
  FormatterActions2["PARSE_CSS"] = "parseCSS";
  FormatterActions2["JAVASCRIPT_SUBSTITUTE"] = "javaScriptSubstitute";
  FormatterActions2["JAVASCRIPT_SCOPE_TREE"] = "javaScriptScopeTree";
  return FormatterActions2;
})(FormatterActions || {});

// gen/third_party/devtools-frontend/src/front_end/entrypoints/formatter_worker/formatter_worker-entrypoint.prebundle.js
self.onmessage = function(event) {
  const method = event.data.method;
  const params = event.data.params;
  if (!method) {
    return;
  }
  switch (method) {
    case FormatterActions.FORMAT:
      self.postMessage(FormatterWorker.FormatterWorker.format(params.mimeType, params.content, params.indentString));
      break;
    case FormatterActions.PARSE_CSS:
      FormatterWorker.CSSRuleParser.parseCSS(params.content, self.postMessage);
      break;
    case FormatterActions.JAVASCRIPT_SUBSTITUTE: {
      self.postMessage(FormatterWorker.Substitute.substituteExpression(params.content, params.mapping));
      break;
    }
    case FormatterActions.JAVASCRIPT_SCOPE_TREE: {
      self.postMessage(FormatterWorker.ScopeParser.parseScopes(params.content, params.sourceType)?.export());
      break;
    }
    default:
      Platform.assertNever(method, `Unsupport method name: ${method}`);
  }
};
self.postMessage("workerReady");
//# sourceMappingURL=formatter_worker-entrypoint.js.map
