"use strict";
import * as Platform from "../../core/platform/platform.js";
import * as FormatterWorker from "./formatter_worker.js";
import { FormatterActions } from "./FormatterActions.js";
self.onmessage = function(event) {
  const method = event.data.method;
  const params = event.data.params;
  if (!method) {
    return;
  }
  switch (method) {
    case FormatterActions.FORMAT:
      self.postMessage(FormatterWorker.FormatterWorker.format(params.mimeType, params.content, params.indentString));
      break;
    case FormatterActions.PARSE_CSS:
      FormatterWorker.CSSRuleParser.parseCSS(params.content, self.postMessage);
      break;
    case FormatterActions.JAVASCRIPT_SUBSTITUTE: {
      self.postMessage(FormatterWorker.Substitute.substituteExpression(params.content, params.mapping));
      break;
    }
    case FormatterActions.JAVASCRIPT_SCOPE_TREE: {
      self.postMessage(FormatterWorker.ScopeParser.parseScopes(params.content, params.sourceType)?.export());
      break;
    }
    default:
      Platform.assertNever(method, `Unsupport method name: ${method}`);
  }
};
self.postMessage("workerReady");
//# sourceMappingURL=formatter_worker-entrypoint.prebundle.js.map
