var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/Converter.js
var require_Converter = __commonJS({
  "gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/Converter.js"() {
    "use strict";
  }
});

// gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/converters.prebundle.js
var Converter = __toESM(require_Converter());

// gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/ExtensionConverter.js
var ExtensionConverter_exports = {};
__export(ExtensionConverter_exports, {
  EXTENSION_PREFIX: () => EXTENSION_PREFIX,
  ExtensionConverter: () => ExtensionConverter
});
import * as PuppeteerReplay from "./../../../third_party/puppeteer-replay/puppeteer-replay.js";
var EXTENSION_PREFIX = "extension_";
var ExtensionConverter = class {
  #idx;
  #extension;
  constructor(idx, extension) {
    this.#idx = idx;
    this.#extension = extension;
  }
  getId() {
    return EXTENSION_PREFIX + this.#idx;
  }
  getFormatName() {
    return this.#extension.getName();
  }
  getMediaType() {
    return this.#extension.getMediaType();
  }
  getFilename(flow) {
    const fileExtension = this.#mediaTypeToExtension(
      this.#extension.getMediaType()
    );
    return `${flow.title}${fileExtension}`;
  }
  async stringify(flow) {
    const text = await this.#extension.stringify(flow);
    const sourceMap = PuppeteerReplay.parseSourceMap(text);
    return [PuppeteerReplay.stripSourceMap(text), sourceMap];
  }
  async stringifyStep(step) {
    return await this.#extension.stringifyStep(step);
  }
  #mediaTypeToExtension(mediaType) {
    switch (mediaType) {
      case "application/json":
        return ".json";
      case "application/javascript":
      case "text/javascript":
        return ".js";
      case "application/typescript":
      case "text/typescript":
        return ".ts";
      default:
        return "";
    }
  }
};

// gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/JSONConverter.js
var JSONConverter_exports = {};
__export(JSONConverter_exports, {
  JSONConverter: () => JSONConverter
});
import * as PuppeteerReplay2 from "./../../../third_party/puppeteer-replay/puppeteer-replay.js";
import * as Models from "./../models/models.js";
var JSONConverter = class {
  #indent;
  constructor(indent) {
    this.#indent = indent;
  }
  getId() {
    return Models.ConverterIds.ConverterIds.JSON;
  }
  getFormatName() {
    return "JSON";
  }
  getFilename(flow) {
    return `${flow.title}.json`;
  }
  async stringify(flow) {
    const text = await PuppeteerReplay2.stringify(flow, {
      extension: new PuppeteerReplay2.JSONStringifyExtension(),
      indentation: this.#indent
    });
    const sourceMap = PuppeteerReplay2.parseSourceMap(text);
    return [PuppeteerReplay2.stripSourceMap(text), sourceMap];
  }
  async stringifyStep(step) {
    return await PuppeteerReplay2.stringifyStep(step, {
      extension: new PuppeteerReplay2.JSONStringifyExtension(),
      indentation: this.#indent
    });
  }
  getMediaType() {
    return "application/json";
  }
};

// gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/LighthouseConverter.js
var LighthouseConverter_exports = {};
__export(LighthouseConverter_exports, {
  LighthouseConverter: () => LighthouseConverter
});
import * as PuppeteerReplay3 from "./../../../third_party/puppeteer-replay/puppeteer-replay.js";
import * as Models2 from "./../models/models.js";
var LighthouseConverter = class {
  #indent;
  constructor(indent) {
    this.#indent = indent;
  }
  getId() {
    return Models2.ConverterIds.ConverterIds.LIGHTHOUSE;
  }
  getFormatName() {
    return "Puppeteer (including Lighthouse analysis)";
  }
  getFilename(flow) {
    return `${flow.title}.js`;
  }
  async stringify(flow) {
    const text = await PuppeteerReplay3.stringify(flow, {
      extension: new PuppeteerReplay3.LighthouseStringifyExtension(),
      indentation: this.#indent
    });
    const sourceMap = PuppeteerReplay3.parseSourceMap(text);
    return [PuppeteerReplay3.stripSourceMap(text), sourceMap];
  }
  async stringifyStep(step) {
    return await PuppeteerReplay3.stringifyStep(step, {
      indentation: this.#indent
    });
  }
  getMediaType() {
    return "text/javascript";
  }
};

// gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/PuppeteerConverter.js
var PuppeteerConverter_exports = {};
__export(PuppeteerConverter_exports, {
  PuppeteerConverter: () => PuppeteerConverter
});
import * as PuppeteerReplay4 from "./../../../third_party/puppeteer-replay/puppeteer-replay.js";
import * as Models3 from "./../models/models.js";
var PuppeteerConverter = class {
  #indent;
  #extension;
  constructor(indent) {
    this.#indent = indent;
    this.#extension = this.createExtension();
  }
  getId() {
    return Models3.ConverterIds.ConverterIds.PUPPETEER;
  }
  createExtension() {
    return new PuppeteerReplay4.PuppeteerStringifyExtension();
  }
  getFormatName() {
    return "Puppeteer";
  }
  getFilename(flow) {
    return `${flow.title}.js`;
  }
  async stringify(flow) {
    const text = await PuppeteerReplay4.stringify(flow, {
      indentation: this.#indent,
      extension: this.#extension
    });
    const sourceMap = PuppeteerReplay4.parseSourceMap(text);
    return [PuppeteerReplay4.stripSourceMap(text), sourceMap];
  }
  async stringifyStep(step) {
    return await PuppeteerReplay4.stringifyStep(step, {
      indentation: this.#indent,
      extension: this.#extension
    });
  }
  getMediaType() {
    return "text/javascript";
  }
};

// gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/PuppeteerFirefoxConverter.js
var PuppeteerFirefoxConverter_exports = {};
__export(PuppeteerFirefoxConverter_exports, {
  PuppeteerFirefoxConverter: () => PuppeteerFirefoxConverter
});
import * as PuppeteerReplay5 from "./../../../third_party/puppeteer-replay/puppeteer-replay.js";
import * as Models4 from "./../models/models.js";
var PuppeteerFirefoxConverter = class extends PuppeteerConverter {
  getId() {
    return Models4.ConverterIds.ConverterIds.PUPPETEER_FIREFOX;
  }
  createExtension() {
    return new PuppeteerReplay5.PuppeteerStringifyExtension("firefox");
  }
  getFormatName() {
    return "Puppeteer (for Firefox)";
  }
};

// gen/third_party/devtools-frontend/src/front_end/panels/recorder/converters/PuppeteerReplayConverter.js
var PuppeteerReplayConverter_exports = {};
__export(PuppeteerReplayConverter_exports, {
  PuppeteerReplayConverter: () => PuppeteerReplayConverter
});
import * as PuppeteerReplay6 from "./../../../third_party/puppeteer-replay/puppeteer-replay.js";
import * as Models5 from "./../models/models.js";
var PuppeteerReplayConverter = class {
  #indent;
  constructor(indent) {
    this.#indent = indent;
  }
  getId() {
    return Models5.ConverterIds.ConverterIds.REPLAY;
  }
  getFormatName() {
    return "@puppeteer/replay";
  }
  getFilename(flow) {
    return `${flow.title}.js`;
  }
  async stringify(flow) {
    const text = await PuppeteerReplay6.stringify(flow, {
      extension: new PuppeteerReplay6.PuppeteerReplayStringifyExtension(),
      indentation: this.#indent
    });
    const sourceMap = PuppeteerReplay6.parseSourceMap(text);
    return [PuppeteerReplay6.stripSourceMap(text), sourceMap];
  }
  async stringifyStep(step) {
    return await PuppeteerReplay6.stringifyStep(step, {
      extension: new PuppeteerReplay6.PuppeteerReplayStringifyExtension()
    });
  }
  getMediaType() {
    return "text/javascript";
  }
};
export {
  Converter,
  ExtensionConverter_exports as ExtensionConverter,
  JSONConverter_exports as JSONConverter,
  LighthouseConverter_exports as LighthouseConverter,
  PuppeteerConverter_exports as PuppeteerConverter,
  PuppeteerFirefoxConverter_exports as PuppeteerFirefoxConverter,
  PuppeteerReplayConverter_exports as PuppeteerReplayConverter
};
//# sourceMappingURL=converters.js.map
