"use strict";
import { html, nothing, render } from "../../lit/lit.js";
import reportStyles from "./report.css.js";
import reportKeyStyles from "./reportKey.css.js";
import reportSectionStyles from "./reportSection.css.js";
import reportSectionDividerStyles from "./reportSectionDivider.css.js";
import reportSectionHeaderStyles from "./reportSectionHeader.css.js";
import reportValueStyles from "./reportValue.css.js";
export class Report extends HTMLElement {
  #shadow = this.attachShadow({ mode: "open" });
  #reportTitle = "";
  set data({ reportTitle }) {
    this.#reportTitle = reportTitle;
    this.#render();
  }
  connectedCallback() {
    this.#render();
  }
  #render() {
    render(html`
      <style>${reportStyles}</style>
      ${this.#reportTitle ? html`<div class="report-title">${this.#reportTitle}</div>` : nothing}
      <div class="content">
        <slot></slot>
      </div>
    `, this.#shadow, { host: this });
  }
}
export class ReportSection extends HTMLElement {
  #shadow = this.attachShadow({ mode: "open" });
  connectedCallback() {
    this.#render();
  }
  #render() {
    render(html`
      <style>${reportSectionStyles}</style>
      <div class="section">
        <slot></slot>
      </div>
    `, this.#shadow, { host: this });
  }
}
export class ReportSectionHeader extends HTMLElement {
  #shadow = this.attachShadow({ mode: "open" });
  connectedCallback() {
    this.#render();
  }
  #render() {
    render(html`
      <style>${reportSectionHeaderStyles}</style>
      <div class="section-header">
        <slot></slot>
      </div>
    `, this.#shadow, { host: this });
  }
}
export class ReportSectionDivider extends HTMLElement {
  #shadow = this.attachShadow({ mode: "open" });
  connectedCallback() {
    this.#render();
  }
  #render() {
    render(html`
      <style>${reportSectionDividerStyles}</style>
      <div class="section-divider">
      </div>
    `, this.#shadow, { host: this });
  }
}
export class ReportKey extends HTMLElement {
  #shadow = this.attachShadow({ mode: "open" });
  connectedCallback() {
    this.#render();
  }
  #render() {
    render(html`
      <style>${reportKeyStyles}</style>
      <div class="key"><slot></slot></div>
    `, this.#shadow, { host: this });
  }
}
export class ReportValue extends HTMLElement {
  #shadow = this.attachShadow({ mode: "open" });
  connectedCallback() {
    this.#render();
  }
  #render() {
    render(html`
      <style>${reportValueStyles}</style>
      <div class="value"><slot></slot></div>
    `, this.#shadow, { host: this });
  }
}
customElements.define("devtools-report", Report);
customElements.define("devtools-report-section", ReportSection);
customElements.define("devtools-report-section-header", ReportSectionHeader);
customElements.define("devtools-report-key", ReportKey);
customElements.define("devtools-report-value", ReportValue);
customElements.define("devtools-report-divider", ReportSectionDivider);
//# sourceMappingURL=ReportView.js.map
