var __defProp = Object.defineProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};

// gen/third_party/devtools-frontend/src/front_end/ui/components/suggestion_input/SuggestionInput.js
var SuggestionInput_exports = {};
__export(SuggestionInput_exports, {
  SuggestionInput: () => SuggestionInput
});
import * as CodeHighlighter from "./../code_highlighter/code_highlighter.js";

// gen/third_party/devtools-frontend/src/front_end/ui/components/code_highlighter/codeHighlighter.css.js
var codeHighlighter_css_default = `.token-variable{color:var(--sys-color-token-variable)}.token-property{color:var(--sys-color-token-property)}.token-type{color:var(--sys-color-token-type)}.token-variable-special{color:var(--sys-color-token-variable-special)}.token-definition{color:var(--sys-color-token-definition)}.token-builtin{color:var(--sys-color-token-builtin)}.token-number{color:var(--sys-color-token-number)}.token-string{color:var(--sys-color-token-string)}.token-string-special{color:var(--sys-color-token-string-special)}.token-atom{color:var(--sys-color-token-atom)}.token-keyword{color:var(--sys-color-token-keyword)}.token-comment{color:var(--sys-color-token-comment)}.token-meta{color:var(--sys-color-token-meta)}.token-invalid{color:var(--sys-color-error)}.token-tag{color:var(--sys-color-token-tag)}.token-attribute{color:var(--sys-color-token-attribute)}.token-attribute-value{color:var(--sys-color-token-attribute-value)}.token-inserted{color:var(--sys-color-token-inserted)}.token-deleted{color:var(--sys-color-token-deleted)}.token-heading{color:var(--sys-color-token-variable-special);font-weight:bold}.token-link{color:var(--sys-color-token-variable-special);text-decoration:underline}.token-strikethrough{text-decoration:line-through}.token-strong{font-weight:bold}.token-emphasis{font-style:italic}
/*# sourceURL=${import.meta.resolve("./codeHighlighter.css")} */`;

// gen/third_party/devtools-frontend/src/front_end/ui/components/suggestion_input/SuggestionInput.js
import * as Lit from "./../../lit/lit.js";
import * as VisualLogging from "./../../visual_logging/visual_logging.js";

// gen/third_party/devtools-frontend/src/front_end/ui/components/suggestion_input/suggestionInput.css.js
var suggestionInput_css_default = `*{box-sizing:border-box;font-size:inherit;margin:0;padding:0}:host{position:relative}devtools-editable-content{background:transparent;border:none;color:var(--override-color-recorder-input,var(--sys-color-on-surface));cursor:text;display:inline-block;line-height:18px;min-height:18px;min-width:0.5em;outline:none;overflow-wrap:anywhere}devtools-editable-content:hover,
devtools-editable-content:focus{box-shadow:0 0 0 1px var(--sys-color-divider);border-radius:2px}devtools-editable-content[placeholder]:empty::before{content:attr(placeholder);color:var(--sys-color-on-surface);opacity:50%}devtools-editable-content[placeholder]:empty:focus::before{content:""}devtools-suggestion-box{position:absolute;display:none}devtools-editable-content:focus ~ devtools-suggestion-box{display:block}.suggestions{background-color:var(--sys-color-cdt-base-container);box-shadow:var(--drop-shadow);min-height:1em;min-width:150px;overflow:hidden auto;position:relative;z-index:100;max-height:350px}.suggestions > li{padding:1px;border:1px solid transparent;white-space:nowrap;font-family:var(--source-code-font-family);font-size:var(--source-code-font-size);color:var(--sys-color-on-surface)}.suggestions > li:hover{background-color:var(--sys-color-state-hover-on-subtle)}.suggestions > li.selected{background-color:var(--sys-color-primary);color:var(--sys-color-cdt-base-container)}.strikethrough{text-decoration:line-through}
/*# sourceURL=${import.meta.resolve("./suggestionInput.css")} */`;

// gen/third_party/devtools-frontend/src/front_end/ui/components/suggestion_input/SuggestionInput.js
var __defProp2 = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value2) => key in obj ? __defProp2(obj, key, { enumerable: true, configurable: true, writable: true, value: value2 }) : obj[key] = value2;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp2(target, key, result);
  return result;
};
var __publicField = (obj, key, value2) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value2);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value2) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value2);
var __privateSet = (obj, member, value2, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value2) : member.set(obj, value2), value2);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var _mimeType;
var _EditableContent_instances;
var highlight_fn;
var _suggestions;
var _handleKeyDownEvent;
var _SuggestionBox_instances;
var moveCursor_fn;
var dispatchSuggestEvent_fn;
var _cachedEditableContent;
var _SuggestionInput_instances;
var editableContent_get;
var _handleBlurEvent;
var _handleFocusEvent;
var _handleKeyDownEvent2;
var _handleInputEvent;
var _handleSuggestionInitEvent;
var _handleSuggestEvent;
var mod = (a, n) => {
  return (a % n + n) % n;
};
function assert(predicate, message = "Assertion failed!") {
  if (!predicate) {
    throw new Error(message);
  }
}
var { html, Decorators, Directives, LitElement } = Lit;
var { customElement, property, state } = Decorators;
var { classMap } = Directives;
var jsonPropertyOptions = {
  hasChanged(value2, oldValue) {
    return JSON.stringify(value2) !== JSON.stringify(oldValue);
  },
  attribute: false
};
var EditableContent = class extends HTMLElement {
  constructor() {
    super();
    __privateAdd(this, _EditableContent_instances);
    __privateAdd(this, _mimeType, "");
    this.contentEditable = "true";
    this.tabIndex = 0;
    this.addEventListener("focus", () => {
      this.innerHTML = this.innerText;
    });
    this.addEventListener("blur", __privateMethod(this, _EditableContent_instances, highlight_fn).bind(this));
  }
  static get observedAttributes() {
    return ["disabled", "placeholder"];
  }
  set disabled(disabled) {
    this.contentEditable = String(!disabled);
  }
  get disabled() {
    return this.contentEditable !== "true";
  }
  set value(value2) {
    this.innerText = value2;
    __privateMethod(this, _EditableContent_instances, highlight_fn).call(this);
  }
  get value() {
    return this.innerText;
  }
  set mimeType(type) {
    __privateSet(this, _mimeType, type);
    __privateMethod(this, _EditableContent_instances, highlight_fn).call(this);
  }
  get mimeType() {
    return __privateGet(this, _mimeType);
  }
  attributeChangedCallback(name, _, value2) {
    switch (name) {
      case "disabled":
        this.disabled = value2 !== null;
        break;
    }
  }
};
_mimeType = /* @__PURE__ */ new WeakMap();
_EditableContent_instances = /* @__PURE__ */ new WeakSet();
highlight_fn = function() {
  if (__privateGet(this, _mimeType)) {
    void CodeHighlighter.CodeHighlighter.highlightNode(this, __privateGet(this, _mimeType));
  }
};
EditableContent = __decorateClass([
  customElement("devtools-editable-content")
], EditableContent);
var SuggestEvent = class _SuggestEvent extends Event {
  static eventName = "suggest";
  constructor(suggestion) {
    super(_SuggestEvent.eventName);
    this.suggestion = suggestion;
  }
};
var SuggestionInitEvent = class _SuggestionInitEvent extends Event {
  static eventName = "suggestioninit";
  listeners;
  constructor(listeners) {
    super(_SuggestionInitEvent.eventName);
    this.listeners = listeners;
  }
};
var defaultSuggestionFilter = (option, query) => option.toLowerCase().startsWith(query.toLowerCase());
var SuggestionBox = class extends LitElement {
  constructor() {
    super();
    __privateAdd(this, _SuggestionBox_instances);
    __privateAdd(this, _suggestions, []);
    __privateAdd(this, _handleKeyDownEvent, (event) => {
      assert(event instanceof KeyboardEvent, "Bound to the wrong event.");
      if (__privateGet(this, _suggestions).length > 0) {
        switch (event.key) {
          case "ArrowDown":
            event.stopPropagation();
            event.preventDefault();
            __privateMethod(this, _SuggestionBox_instances, moveCursor_fn).call(this, 1);
            break;
          case "ArrowUp":
            event.stopPropagation();
            event.preventDefault();
            __privateMethod(this, _SuggestionBox_instances, moveCursor_fn).call(this, -1);
            break;
        }
      }
      switch (event.key) {
        case "Enter":
          if (__privateGet(this, _suggestions)[this.cursor]) {
            __privateMethod(this, _SuggestionBox_instances, dispatchSuggestEvent_fn).call(this, __privateGet(this, _suggestions)[this.cursor]);
          }
          event.preventDefault();
          break;
      }
    });
    this.options = [];
    this.expression = "";
    this.cursor = 0;
  }
  connectedCallback() {
    super.connectedCallback();
    this.dispatchEvent(
      new SuggestionInitEvent([["keydown", __privateGet(this, _handleKeyDownEvent)]])
    );
  }
  willUpdate(changedProperties) {
    if (changedProperties.has("options")) {
      this.options = Object.freeze([...this.options].sort());
    }
    if (changedProperties.has("expression") || changedProperties.has("options")) {
      this.cursor = 0;
      __privateSet(this, _suggestions, this.options.filter(
        (option) => (this.suggestionFilter || defaultSuggestionFilter)(option, this.expression)
      ));
    }
  }
  render() {
    if (__privateGet(this, _suggestions).length === 0) {
      return;
    }
    return html`<style>${suggestionInput_css_default}</style><ul class="suggestions">
      ${__privateGet(this, _suggestions).map((suggestion, index) => {
      return html`<li
          class=${classMap({
        selected: index === this.cursor
      })}
          @mousedown=${__privateMethod(this, _SuggestionBox_instances, dispatchSuggestEvent_fn).bind(this, suggestion)}
          jslog=${VisualLogging.item("suggestion").track({
        click: true
      })}
        >
          ${suggestion}
        </li>`;
    })}
    </ul>`;
  }
};
_suggestions = /* @__PURE__ */ new WeakMap();
_handleKeyDownEvent = /* @__PURE__ */ new WeakMap();
_SuggestionBox_instances = /* @__PURE__ */ new WeakSet();
moveCursor_fn = function(delta) {
  this.cursor = mod(this.cursor + delta, __privateGet(this, _suggestions).length);
};
dispatchSuggestEvent_fn = function(suggestion) {
  this.dispatchEvent(new SuggestEvent(suggestion));
};
__decorateClass([
  property(jsonPropertyOptions)
], SuggestionBox.prototype, "options", 2);
__decorateClass([
  property()
], SuggestionBox.prototype, "expression", 2);
__decorateClass([
  property()
], SuggestionBox.prototype, "suggestionFilter", 2);
__decorateClass([
  state()
], SuggestionBox.prototype, "cursor", 2);
SuggestionBox = __decorateClass([
  customElement("devtools-suggestion-box")
], SuggestionBox);
var SuggestionInput = class extends LitElement {
  constructor() {
    super();
    __privateAdd(this, _SuggestionInput_instances);
    __privateAdd(this, _cachedEditableContent);
    __privateAdd(this, _handleBlurEvent, () => {
      window.getSelection()?.removeAllRanges();
      this.value = __privateGet(this, _SuggestionInput_instances, editableContent_get).value;
      this.expression = __privateGet(this, _SuggestionInput_instances, editableContent_get).value;
    });
    __privateAdd(this, _handleFocusEvent, (event) => {
      assert(event.target instanceof Node);
      const range = document.createRange();
      range.selectNodeContents(event.target);
      const selection = window.getSelection();
      selection.removeAllRanges();
      selection.addRange(range);
    });
    __privateAdd(this, _handleKeyDownEvent2, (event) => {
      if (event.key === "Enter") {
        event.preventDefault();
      }
    });
    __privateAdd(this, _handleInputEvent, (event) => {
      this.expression = event.target.value;
    });
    __privateAdd(this, _handleSuggestionInitEvent, (event) => {
      for (const [name, listener] of event.listeners) {
        this.addEventListener(name, listener);
      }
    });
    __privateAdd(this, _handleSuggestEvent, (event) => {
      __privateGet(this, _SuggestionInput_instances, editableContent_get).value = event.suggestion;
      setTimeout(this.blur.bind(this), 0);
    });
    this.options = [];
    this.expression = "";
    this.placeholder = "";
    this.value = "";
    this.disabled = false;
    this.strikethrough = true;
    this.mimeType = "";
    this.autocomplete = true;
    this.addEventListener("blur", __privateGet(this, _handleBlurEvent));
    let jslog = VisualLogging.value().track({ keydown: "ArrowUp|ArrowDown|Enter", change: true, click: true });
    if (this.jslogContext) {
      jslog = jslog.context(this.jslogContext);
    }
    this.setAttribute("jslog", jslog.toString());
  }
  willUpdate(properties) {
    if (properties.has("value")) {
      this.expression = this.value;
    }
  }
  render() {
    return html`<style>${suggestionInput_css_default}</style>
      <style>${codeHighlighter_css_default}</style>
      <devtools-editable-content
        ?disabled=${this.disabled}
        class=${classMap({
      strikethrough: !this.strikethrough
    })}
        .enterKeyHint=${"done"}
        .value=${this.value}
        .mimeType=${this.mimeType}
        @focus=${__privateGet(this, _handleFocusEvent)}
        @input=${__privateGet(this, _handleInputEvent)}
        @keydown=${__privateGet(this, _handleKeyDownEvent2)}
        autocapitalize="off"
        inputmode="text"
        placeholder=${this.placeholder}
        spellcheck="false"
      ></devtools-editable-content>
      <devtools-suggestion-box
        @suggestioninit=${__privateGet(this, _handleSuggestionInitEvent)}
        @suggest=${__privateGet(this, _handleSuggestEvent)}
        .options=${this.options}
        .suggestionFilter=${this.suggestionFilter}
        .expression=${this.autocomplete ? this.expression : ""}
      ></devtools-suggestion-box>`;
  }
};
_cachedEditableContent = /* @__PURE__ */ new WeakMap();
_SuggestionInput_instances = /* @__PURE__ */ new WeakSet();
editableContent_get = function() {
  if (__privateGet(this, _cachedEditableContent)) {
    return __privateGet(this, _cachedEditableContent);
  }
  const node = this.renderRoot.querySelector("devtools-editable-content");
  if (!node) {
    throw new Error("Attempted to query node before rendering.");
  }
  __privateSet(this, _cachedEditableContent, node);
  return node;
};
_handleBlurEvent = /* @__PURE__ */ new WeakMap();
_handleFocusEvent = /* @__PURE__ */ new WeakMap();
_handleKeyDownEvent2 = /* @__PURE__ */ new WeakMap();
_handleInputEvent = /* @__PURE__ */ new WeakMap();
_handleSuggestionInitEvent = /* @__PURE__ */ new WeakMap();
_handleSuggestEvent = /* @__PURE__ */ new WeakMap();
__publicField(SuggestionInput, "shadowRootOptions", {
  ...LitElement.shadowRootOptions,
  delegatesFocus: true
});
__decorateClass([
  property(jsonPropertyOptions)
], SuggestionInput.prototype, "options", 2);
__decorateClass([
  property({ type: Boolean })
], SuggestionInput.prototype, "autocomplete", 2);
__decorateClass([
  property()
], SuggestionInput.prototype, "suggestionFilter", 2);
__decorateClass([
  state()
], SuggestionInput.prototype, "expression", 2);
__decorateClass([
  property()
], SuggestionInput.prototype, "placeholder", 2);
__decorateClass([
  property()
], SuggestionInput.prototype, "value", 2);
__decorateClass([
  property({ type: Boolean })
], SuggestionInput.prototype, "disabled", 2);
__decorateClass([
  property({ type: Boolean })
], SuggestionInput.prototype, "strikethrough", 2);
__decorateClass([
  property()
], SuggestionInput.prototype, "mimeType", 2);
__decorateClass([
  property()
], SuggestionInput.prototype, "jslogContext", 2);
SuggestionInput = __decorateClass([
  customElement("devtools-suggestion-input")
], SuggestionInput);
export {
  SuggestionInput_exports as SuggestionInput
};
//# sourceMappingURL=suggestion_input.js.map
