// ui/accessibility/mojom/ax_relative_bounds.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/accessibility/mojom/ax_relative_bounds.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ax.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../gfx/geometry/mojom/geometry.mojom.js');
  }
  var transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/transform.mojom', '../../gfx/mojom/transform.mojom.js');
  }



  function AXRelativeBounds(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AXRelativeBounds.prototype.initDefaults_ = function() {
    this.offsetContainerId = 0;
    this.bounds = null;
    this.transform = null;
  };
  AXRelativeBounds.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AXRelativeBounds.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AXRelativeBounds.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AXRelativeBounds.transform
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, transform$.Transform, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AXRelativeBounds.encodedSize = codec.kStructHeaderSize + 24;

  AXRelativeBounds.decode = function(decoder) {
    var packed;
    var val = new AXRelativeBounds();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.offsetContainerId =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.bounds =
        decoder.decodeStructPointer(geometry$.RectF);
    val.transform =
        decoder.decodeStructPointer(transform$.Transform);
    return val;
  };

  AXRelativeBounds.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AXRelativeBounds.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.offsetContainerId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.RectF, val.bounds);
    encoder.encodeStructPointer(transform$.Transform, val.transform);
  };
  exports.AXRelativeBounds = AXRelativeBounds;
})();