// ui/display/mojom/display_snapshot.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/display/mojom/display_snapshot.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('display.mojom');
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var skcolorspace_primaries$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolorspace_primaries.mojom', '../../../skia/public/mojom/skcolorspace_primaries.mojom.js');
  }
  var display_constants$ =
      mojo.internal.exposeNamespace('display.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/display/mojom/display_constants.mojom', 'display_constants.mojom.js');
  }
  var display_mode$ =
      mojo.internal.exposeNamespace('display.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/display/mojom/display_mode.mojom', 'display_mode.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../gfx/geometry/mojom/geometry.mojom.js');
  }
  var color_space$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/color_space.mojom', '../../gfx/mojom/color_space.mojom.js');
  }
  var hdr_static_metadata$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/hdr_static_metadata.mojom', '../../gfx/mojom/hdr_static_metadata.mojom.js');
  }



  function DisplaySnapshotColorInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DisplaySnapshotColorInfo.prototype.initDefaults_ = function() {
    this.colorSpace = null;
    this.edidPrimaries = null;
    this.edidGamma = 0;
    this.supportsColorTemperatureAdjustment = false;
    this.hdrStaticMetadata = null;
    this.bitsPerChannel = 0;
  };
  DisplaySnapshotColorInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DisplaySnapshotColorInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshotColorInfo.colorSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, color_space$.ColorSpace, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshotColorInfo.edidPrimaries
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, skcolorspace_primaries$.SkColorSpacePrimaries, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DisplaySnapshotColorInfo.hdrStaticMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, hdr_static_metadata$.HDRStaticMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  DisplaySnapshotColorInfo.encodedSize = codec.kStructHeaderSize + 40;

  DisplaySnapshotColorInfo.decode = function(decoder) {
    var packed;
    var val = new DisplaySnapshotColorInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.colorSpace =
        decoder.decodeStructPointer(color_space$.ColorSpace);
    val.edidPrimaries =
        decoder.decodeStructPointer(skcolorspace_primaries$.SkColorSpacePrimaries);
    val.edidGamma =
        decoder.decodeStruct(codec.Float);
    packed = decoder.readUint8();
    val.supportsColorTemperatureAdjustment = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.hdrStaticMetadata =
        decoder.decodeStructPointer(hdr_static_metadata$.HDRStaticMetadata);
    val.bitsPerChannel =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DisplaySnapshotColorInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DisplaySnapshotColorInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(color_space$.ColorSpace, val.colorSpace);
    encoder.encodeStructPointer(skcolorspace_primaries$.SkColorSpacePrimaries, val.edidPrimaries);
    encoder.encodeStruct(codec.Float, val.edidGamma);
    packed = 0;
    packed |= (val.supportsColorTemperatureAdjustment & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(hdr_static_metadata$.HDRStaticMetadata, val.hdrStaticMetadata);
    encoder.encodeStruct(codec.Uint32, val.bitsPerChannel);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DisplaySnapshot(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DisplaySnapshot.prototype.initDefaults_ = function() {
    this.displayId = 0;
    this.portDisplayId = 0;
    this.edidDisplayId = 0;
    this.connectorIndex = 0;
    this.isAspectPreservingScaling = false;
    this.hasOverscan = false;
    this.hasContentProtectionKey = false;
    this.hasCurrentMode = false;
    this.hasNativeMode = false;
    this.type = 0;
    this.origin = null;
    this.physicalSize = null;
    this.baseConnectorId = 0;
    this.pathTopology = null;
    this.privacyScreenState = 0;
    this.panelOrientation = 0;
    this.colorInfo = null;
    this.displayName = null;
    this.sysPath = null;
    this.modes = null;
    this.edid = null;
    this.currentModeIndex = 0;
    this.nativeModeIndex = 0;
    this.productCode = 0;
    this.yearOfManufacture = 0;
    this.variableRefreshRateState = 0;
    this.maximumCursorSize = null;
  };
  DisplaySnapshot.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DisplaySnapshot.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 160}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate DisplaySnapshot.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Point, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshot.physicalSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshot.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, display_constants$.DisplayConnectionType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DisplaySnapshot.pathTopology
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, codec.Uint64, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate DisplaySnapshot.privacyScreenState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 64, display_constants$.PrivacyScreenState);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DisplaySnapshot.colorInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, DisplaySnapshotColorInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshot.displayName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 80, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshot.sysPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshot.modes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 96, 8, new codec.PointerTo(display_mode$.DisplayMode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshot.panelOrientation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 68, display_constants$.PanelOrientation);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshot.edid
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 104, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;








    // validate DisplaySnapshot.maximumCursorSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplaySnapshot.variableRefreshRateState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 140, display_constants$.VariableRefreshRateState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DisplaySnapshot.encodedSize = codec.kStructHeaderSize + 152;

  DisplaySnapshot.decode = function(decoder) {
    var packed;
    var val = new DisplaySnapshot();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.displayId =
        decoder.decodeStruct(codec.Int64);
    val.portDisplayId =
        decoder.decodeStruct(codec.Int64);
    val.edidDisplayId =
        decoder.decodeStruct(codec.Int64);
    val.connectorIndex =
        decoder.decodeStruct(codec.Uint16);
    packed = decoder.readUint8();
    val.isAspectPreservingScaling = (packed >> 0) & 1 ? true : false;
    val.hasOverscan = (packed >> 1) & 1 ? true : false;
    val.hasContentProtectionKey = (packed >> 2) & 1 ? true : false;
    val.hasCurrentMode = (packed >> 3) & 1 ? true : false;
    val.hasNativeMode = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    val.type =
        decoder.decodeStruct(new codec.Enum(display_constants$.DisplayConnectionType));
    val.origin =
        decoder.decodeStructPointer(geometry$.Point);
    val.physicalSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.baseConnectorId =
        decoder.decodeStruct(codec.Uint64);
    val.pathTopology =
        decoder.decodeArrayPointer(codec.Uint64);
    val.privacyScreenState =
        decoder.decodeStruct(new codec.Enum(display_constants$.PrivacyScreenState));
    val.panelOrientation =
        decoder.decodeStruct(new codec.Enum(display_constants$.PanelOrientation));
    val.colorInfo =
        decoder.decodeStructPointer(DisplaySnapshotColorInfo);
    val.displayName =
        decoder.decodeStruct(codec.String);
    val.sysPath =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.modes =
        decoder.decodeArrayPointer(new codec.PointerTo(display_mode$.DisplayMode));
    val.edid =
        decoder.decodeArrayPointer(codec.Uint8);
    val.currentModeIndex =
        decoder.decodeStruct(codec.Uint64);
    val.nativeModeIndex =
        decoder.decodeStruct(codec.Uint64);
    val.productCode =
        decoder.decodeStruct(codec.Int64);
    val.yearOfManufacture =
        decoder.decodeStruct(codec.Int32);
    val.variableRefreshRateState =
        decoder.decodeStruct(new codec.Enum(display_constants$.VariableRefreshRateState));
    val.maximumCursorSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  DisplaySnapshot.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DisplaySnapshot.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.displayId);
    encoder.encodeStruct(codec.Int64, val.portDisplayId);
    encoder.encodeStruct(codec.Int64, val.edidDisplayId);
    encoder.encodeStruct(codec.Uint16, val.connectorIndex);
    packed = 0;
    packed |= (val.isAspectPreservingScaling & 1) << 0
    packed |= (val.hasOverscan & 1) << 1
    packed |= (val.hasContentProtectionKey & 1) << 2
    packed |= (val.hasCurrentMode & 1) << 3
    packed |= (val.hasNativeMode & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStructPointer(geometry$.Point, val.origin);
    encoder.encodeStructPointer(geometry$.Size, val.physicalSize);
    encoder.encodeStruct(codec.Uint64, val.baseConnectorId);
    encoder.encodeArrayPointer(codec.Uint64, val.pathTopology);
    encoder.encodeStruct(codec.Int32, val.privacyScreenState);
    encoder.encodeStruct(codec.Int32, val.panelOrientation);
    encoder.encodeStructPointer(DisplaySnapshotColorInfo, val.colorInfo);
    encoder.encodeStruct(codec.String, val.displayName);
    encoder.encodeStructPointer(file_path$.FilePath, val.sysPath);
    encoder.encodeArrayPointer(new codec.PointerTo(display_mode$.DisplayMode), val.modes);
    encoder.encodeArrayPointer(codec.Uint8, val.edid);
    encoder.encodeStruct(codec.Uint64, val.currentModeIndex);
    encoder.encodeStruct(codec.Uint64, val.nativeModeIndex);
    encoder.encodeStruct(codec.Int64, val.productCode);
    encoder.encodeStruct(codec.Int32, val.yearOfManufacture);
    encoder.encodeStruct(codec.Int32, val.variableRefreshRateState);
    encoder.encodeStructPointer(geometry$.Size, val.maximumCursorSize);
  };
  exports.DisplaySnapshotColorInfo = DisplaySnapshotColorInfo;
  exports.DisplaySnapshot = DisplaySnapshot;
})();