// ui/events/mojom/event_latency_metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/events/mojom/event_latency_metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ui.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }



  function EventLatencyMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EventLatencyMetadata.prototype.initDefaults_ = function() {
    this.arrivedInBrowserMainTimestamp = null;
    this.scrollsBlockingTouchDispatchedToRenderer = null;
    this.dispatchedToRenderer = null;
  };
  EventLatencyMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EventLatencyMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventLatencyMetadata.arrivedInBrowserMainTimestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventLatencyMetadata.scrollsBlockingTouchDispatchedToRenderer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EventLatencyMetadata.dispatchedToRenderer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EventLatencyMetadata.encodedSize = codec.kStructHeaderSize + 24;

  EventLatencyMetadata.decode = function(decoder) {
    var packed;
    var val = new EventLatencyMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.arrivedInBrowserMainTimestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.scrollsBlockingTouchDispatchedToRenderer =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.dispatchedToRenderer =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  EventLatencyMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EventLatencyMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.arrivedInBrowserMainTimestamp);
    encoder.encodeStructPointer(time$.TimeTicks, val.scrollsBlockingTouchDispatchedToRenderer);
    encoder.encodeStructPointer(time$.TimeTicks, val.dispatchedToRenderer);
  };
  exports.EventLatencyMetadata = EventLatencyMetadata;
})();