// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./segmented_button.js";import"./segmented_button_option.js";import{I18nMixinLit}from"//resources/cr_elements/i18n_mixin_lit.js";import{assert}from"//resources/js/assert.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{CustomizeColorSchemeModeBrowserProxy}from"./browser_proxy.js";import{getCss}from"./customize_color_scheme_mode.css.js";import{getHtml}from"./customize_color_scheme_mode.html.js";import{ColorSchemeMode}from"./customize_color_scheme_mode.mojom-webui.js";export const colorSchemeModeOptions=[{id:"lightMode",value:ColorSchemeMode.kLight},{id:"darkMode",value:ColorSchemeMode.kDark},{id:"systemMode",value:ColorSchemeMode.kSystem}];const CustomizeColorSchemeModeElementBase=I18nMixinLit(CrLitElement);export class CustomizeColorSchemeModeElement extends CustomizeColorSchemeModeElementBase{static get is(){return"customize-color-scheme-mode"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{currentMode_:{type:Object,state:true},colorSchemeModeOptions_:{type:Array,state:true}}}#currentMode__accessor_storage=colorSchemeModeOptions[0];get currentMode_(){return this.#currentMode__accessor_storage}set currentMode_(value){this.#currentMode__accessor_storage=value}#colorSchemeModeOptions__accessor_storage=colorSchemeModeOptions;get colorSchemeModeOptions_(){return this.#colorSchemeModeOptions__accessor_storage}set colorSchemeModeOptions_(value){this.#colorSchemeModeOptions__accessor_storage=value}handler_=CustomizeColorSchemeModeBrowserProxy.getInstance().handler;callbackRouter_=CustomizeColorSchemeModeBrowserProxy.getInstance().callbackRouter;setColorSchemeModeListenerId_=null;connectedCallback(){super.connectedCallback();this.setColorSchemeModeListenerId_=this.callbackRouter_.setColorSchemeMode.addListener((colorSchemeMode=>{const currentMode=colorSchemeModeOptions.find((mode=>colorSchemeMode===mode.value));assert(!!currentMode);this.currentMode_=currentMode}));this.handler_.initializeColorSchemeMode()}disconnectedCallback(){assert(this.setColorSchemeModeListenerId_);this.callbackRouter_.removeListener(this.setColorSchemeModeListenerId_);this.setColorSchemeModeListenerId_=null;super.disconnectedCallback()}onSelectedChanged_(e){if(!!this.currentMode_&&e.detail.value===this.currentMode_.id){return}const selected=colorSchemeModeOptions.find((option=>option.id===e.detail.value));this.handler_.setColorSchemeMode(selected?selected.value:ColorSchemeMode.kSystem)}}customElements.define(CustomizeColorSchemeModeElement.is,CustomizeColorSchemeModeElement);