// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";export const CrSelectableMixin=superClass=>{class CrSelectableMixin extends superClass{static get properties(){return{attrForSelected:{type:String},selected:{type:String,notify:true},selectedAttribute:{type:String},selectable:{type:String}}}#attrForSelected_accessor_storage=null;get attrForSelected(){return this.#attrForSelected_accessor_storage}set attrForSelected(value){this.#attrForSelected_accessor_storage=value}#selectable_accessor_storage;get selectable(){return this.#selectable_accessor_storage}set selectable(value){this.#selectable_accessor_storage=value}#selected_accessor_storage;get selected(){return this.#selected_accessor_storage}set selected(value){this.#selected_accessor_storage=value}#selectedAttribute_accessor_storage=null;get selectedAttribute(){return this.#selectedAttribute_accessor_storage}set selectedAttribute(value){this.#selectedAttribute_accessor_storage=value}selectOnClick=true;items_=[];selectedItem_=null;firstUpdated(changedProperties){super.firstUpdated(changedProperties);if(this.selectOnClick){this.addEventListener("click",(e=>this.onClick_(e)))}this.observeItems()}observeItems(){this.getSlot().addEventListener("slotchange",(()=>this.itemsChanged()))}connectedCallback(){super.connectedCallback();this.updateItems_()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("attrForSelected")){if(this.selectedItem_){assert(this.attrForSelected);const value=this.selectedItem_.getAttribute(this.attrForSelected);assert(value!==null);this.selected=value}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("selected")){this.updateSelectedItem_()}}select(value){this.selected=value}selectPrevious(){const length=this.items_.length;let index=length-1;if(this.selected!==undefined){index=(this.valueToIndex_(this.selected)-1+length)%length}this.selected=this.indexToValue_(index)}selectNext(){const index=this.selected===undefined?0:(this.valueToIndex_(this.selected)+1)%this.items_.length;this.selected=this.indexToValue_(index)}getItemsForTest(){return this.items_}getSlot(){const slot=this.shadowRoot.querySelector("slot");assert(slot);return slot}queryItems(){const selectable=this.selectable===undefined?"*":this.selectable;return Array.from(this.querySelectorAll(`:scope > ${selectable}`))}queryMatchingItem(selector){const selectable=this.selectable||"*";return this.querySelector(`:scope > :is(${selectable})${selector}`)}updateItems_(){this.items_=this.queryItems();this.items_.forEach(((item,index)=>item.setAttribute("data-selection-index",index.toString())))}get selectedItem(){return this.selectedItem_}updateSelectedItem_(){if(!this.items_){return}const item=this.selected==null?null:this.items_[this.valueToIndex_(this.selected)];if(!!item&&this.selectedItem_!==item){this.setItemSelected_(this.selectedItem_,false);this.setItemSelected_(item,true)}else if(!item){this.setItemSelected_(this.selectedItem_,false)}}setItemSelected_(item,isSelected){if(!item){return}item.classList.toggle("selected",isSelected);if(this.selectedAttribute){item.toggleAttribute(this.selectedAttribute,isSelected)}this.selectedItem_=isSelected?item:null;this.fire("iron-"+(isSelected?"select":"deselect"),{item:item})}valueToIndex_(value){if(!this.attrForSelected){return Number(value)}const match=this.queryMatchingItem(`[${this.attrForSelected}="${value}"]`);return match?Number(match.dataset["selectionIndex"]):-1}indexToValue_(index){if(!this.attrForSelected){return index}const item=this.items_[index];if(!item){return index}return item.getAttribute(this.attrForSelected)||index}itemsChanged(){this.updateItems_();this.updateSelectedItem_();this.fire("iron-items-changed")}onClick_(e){let element=e.target;while(element&&element!==this){const idx=this.items_.indexOf(element);if(idx>=0){const value=this.indexToValue_(idx);assert(value!==null);this.fire("iron-activate",{item:element,selected:value});this.select(value);return}element=element.parentNode}}}return CrSelectableMixin};