// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_icon_button/cr_icon_button.js';
import '//resources/cr_elements/icons.html.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { FileUploadStatus } from './composebox_query.mojom-webui.js';
import { getCss } from './file_thumbnail.css.js';
import { getHtml } from './file_thumbnail.html.js';
export class ComposeboxFileThumbnailElement extends CrLitElement {
    static get is() {
        return 'ntp-composebox-file-thumbnail';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            file: { type: Object },
        };
    }
    #file_accessor_storage = {
        name: '',
        type: '',
        objectUrl: null,
        uuid: '',
        status: FileUploadStatus.kNotUploaded,
        url: null,
        file: null,
        tabId: null,
    };
    get file() { return this.#file_accessor_storage; }
    set file(value) { this.#file_accessor_storage = value; }
    deleteFile_() {
        // TODO(crbug.com/422559977): Send call to handler to delete file from
        // cache.
        this.fire('delete-file', { uuid: this.file.uuid });
    }
    get deleteFileButtonTitle() {
        return loadTimeData.getStringF('composeboxDeleteFileTitle', this.file.name);
    }
}
customElements.define(ComposeboxFileThumbnailElement.is, ComposeboxFileThumbnailElement);
