// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A helper object used by the cr-theme-color-picker
 * component to interact with the browser.
 */
import { ThemeColorPickerClientCallbackRouter, ThemeColorPickerHandlerFactory, ThemeColorPickerHandlerRemote } from './theme_color_picker.mojom-webui.js';
let instance = null;
export class ThemeColorPickerBrowserProxy {
    handler;
    callbackRouter;
    constructor(handler, callbackRouter) {
        this.handler = handler;
        this.callbackRouter = callbackRouter;
    }
    static getInstance() {
        if (!instance) {
            const handler = new ThemeColorPickerHandlerRemote();
            const callbackRouter = new ThemeColorPickerClientCallbackRouter();
            ThemeColorPickerHandlerFactory.getRemote().createThemeColorPickerHandler(handler.$.bindNewPipeAndPassReceiver(), callbackRouter.$.bindNewPipeAndPassRemote());
            instance = new ThemeColorPickerBrowserProxy(handler, callbackRouter);
        }
        return instance;
    }
    static setInstance(handler, callbackRouter) {
        instance = new ThemeColorPickerBrowserProxy(handler, callbackRouter);
    }
}
