// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_COMMON_UNGUESSABLE_TOKEN_MOJOM_SHARED_INTERNAL_H_
#define MOJO_COMMON_UNGUESSABLE_TOKEN_MOJOM_SHARED_INTERNAL_H_

#include <stdint.h>

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/cpp/bindings/lib/native_struct_data.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace mojo {
namespace common {
namespace mojom {
namespace internal {
class UnguessableToken_Data;

#pragma pack(push, 1)
class  UnguessableToken_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(UnguessableToken_Data));
      new (data()) UnguessableToken_Data();
    }

    bool is_null() const { return !buffer_; }
    UnguessableToken_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<UnguessableToken_Data>(index_);
    }
    UnguessableToken_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t high;
  uint64_t low;

 private:
  UnguessableToken_Data();
  ~UnguessableToken_Data() = delete;
};
static_assert(sizeof(UnguessableToken_Data) == 24,
              "Bad sizeof(UnguessableToken_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace common
}  // namespace mojo

#endif  // MOJO_COMMON_UNGUESSABLE_TOKEN_MOJOM_SHARED_INTERNAL_H_