// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_CONNECTOR_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_CONNECTOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/service_manager/public/interfaces/connector.mojom-shared.h"
#include "services/service_manager/public/interfaces/constants.mojom.h"
#include "services/service_manager/public/interfaces/interface_provider.mojom.h"
#include <string>
#include <vector>
#include "services/service_manager/public/cpp/identity.h"
#include "services/service_manager/public/interfaces/interfaces_export.h"


namespace service_manager {
namespace mojom {
class PIDReceiver;
using PIDReceiverPtr = mojo::InterfacePtr<PIDReceiver>;
using PIDReceiverPtrInfo = mojo::InterfacePtrInfo<PIDReceiver>;
using ThreadSafePIDReceiverPtr =
    mojo::ThreadSafeInterfacePtr<PIDReceiver>;
using PIDReceiverRequest = mojo::InterfaceRequest<PIDReceiver>;
using PIDReceiverAssociatedPtr =
    mojo::AssociatedInterfacePtr<PIDReceiver>;
using ThreadSafePIDReceiverAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<PIDReceiver>;
using PIDReceiverAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<PIDReceiver>;
using PIDReceiverAssociatedRequest =
    mojo::AssociatedInterfaceRequest<PIDReceiver>;

class Connector;
using ConnectorPtr = mojo::InterfacePtr<Connector>;
using ConnectorPtrInfo = mojo::InterfacePtrInfo<Connector>;
using ThreadSafeConnectorPtr =
    mojo::ThreadSafeInterfacePtr<Connector>;
using ConnectorRequest = mojo::InterfaceRequest<Connector>;
using ConnectorAssociatedPtr =
    mojo::AssociatedInterfacePtr<Connector>;
using ThreadSafeConnectorAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<Connector>;
using ConnectorAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<Connector>;
using ConnectorAssociatedRequest =
    mojo::AssociatedInterfaceRequest<Connector>;

class Identity;
using IdentityPtr = mojo::InlinedStructPtr<Identity>;


class PIDReceiverProxy;

template <typename ImplRefTraits>
class PIDReceiverStub;

class PIDReceiverRequestValidator;

class SERVICE_MANAGER_MOJOM_EXPORT PIDReceiver
    : public PIDReceiverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = PIDReceiverProxy;

  template <typename ImplRefTraits>
  using Stub_ = PIDReceiverStub<ImplRefTraits>;

  using RequestValidator_ = PIDReceiverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetPIDMinVersion = 0,
  };
  virtual ~PIDReceiver() {}

  virtual void SetPID(uint32_t pid) = 0;
};
class SERVICE_MANAGER_MOJOM_EXPORT PIDReceiverInterceptorForTesting : public PIDReceiver {
  virtual PIDReceiver* GetForwardingInterface() = 0;
  void SetPID(uint32_t pid);
};

class ConnectorProxy;

template <typename ImplRefTraits>
class ConnectorStub;

class ConnectorRequestValidator;
class ConnectorResponseValidator;

class SERVICE_MANAGER_MOJOM_EXPORT Connector
    : public ConnectorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = ConnectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = ConnectorStub<ImplRefTraits>;

  using RequestValidator_ = ConnectorRequestValidator;
  using ResponseValidator_ = ConnectorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindInterfaceMinVersion = 0,
    kStartServiceMinVersion = 0,
    kStartServiceWithProcessMinVersion = 0,
    kCloneMinVersion = 0,
    kFilterInterfacesMinVersion = 0,
  };
  virtual ~Connector() {}


  using BindInterfaceCallback = base::OnceCallback<void(ConnectResult, const ::service_manager::Identity&)>;
  virtual void BindInterface(const ::service_manager::Identity& target, const std::string& interface_name, mojo::ScopedMessagePipeHandle interface_pipe, BindInterfaceCallback callback) = 0;


  using StartServiceCallback = base::OnceCallback<void(ConnectResult, const ::service_manager::Identity&)>;
  virtual void StartService(const ::service_manager::Identity& target, StartServiceCallback callback) = 0;


  using StartServiceWithProcessCallback = base::OnceCallback<void(ConnectResult, const ::service_manager::Identity&)>;
  virtual void StartServiceWithProcess(const ::service_manager::Identity& target, mojo::ScopedMessagePipeHandle service, PIDReceiverRequest pid_receiver_request, StartServiceWithProcessCallback callback) = 0;

  virtual void Clone(ConnectorRequest request) = 0;

  virtual void FilterInterfaces(const std::string& spec, const ::service_manager::Identity& source, ::service_manager::mojom::InterfaceProviderRequest source_request, ::service_manager::mojom::InterfaceProviderPtr target) = 0;
};
class SERVICE_MANAGER_MOJOM_EXPORT ConnectorInterceptorForTesting : public Connector {
  virtual Connector* GetForwardingInterface() = 0;
  void BindInterface(const ::service_manager::Identity& target, const std::string& interface_name, mojo::ScopedMessagePipeHandle interface_pipe, BindInterfaceCallback callback);
  void StartService(const ::service_manager::Identity& target, StartServiceCallback callback);
  void StartServiceWithProcess(const ::service_manager::Identity& target, mojo::ScopedMessagePipeHandle service, PIDReceiverRequest pid_receiver_request, StartServiceWithProcessCallback callback);
  void Clone(ConnectorRequest request);
  void FilterInterfaces(const std::string& spec, const ::service_manager::Identity& source, ::service_manager::mojom::InterfaceProviderRequest source_request, ::service_manager::mojom::InterfaceProviderPtr target);
};

class SERVICE_MANAGER_MOJOM_EXPORT PIDReceiverProxy
    : public PIDReceiver {
 public:
  explicit PIDReceiverProxy(mojo::MessageReceiverWithResponder* receiver);
  void SetPID(uint32_t pid) override;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};

class SERVICE_MANAGER_MOJOM_EXPORT ConnectorProxy
    : public Connector {
 public:
  explicit ConnectorProxy(mojo::MessageReceiverWithResponder* receiver);
  void BindInterface(const ::service_manager::Identity& target, const std::string& interface_name, mojo::ScopedMessagePipeHandle interface_pipe, BindInterfaceCallback callback) override;
  void StartService(const ::service_manager::Identity& target, StartServiceCallback callback) override;
  void StartServiceWithProcess(const ::service_manager::Identity& target, mojo::ScopedMessagePipeHandle service, PIDReceiverRequest pid_receiver_request, StartServiceWithProcessCallback callback) override;
  void Clone(ConnectorRequest request) override;
  void FilterInterfaces(const std::string& spec, const ::service_manager::Identity& source, ::service_manager::mojom::InterfaceProviderRequest source_request, ::service_manager::mojom::InterfaceProviderPtr target) override;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class SERVICE_MANAGER_MOJOM_EXPORT PIDReceiverStubDispatch {
 public:
  static bool Accept(PIDReceiver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PIDReceiver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PIDReceiver>>
class PIDReceiverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PIDReceiverStub() {}
  ~PIDReceiverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PIDReceiverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PIDReceiverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ConnectorStubDispatch {
 public:
  static bool Accept(Connector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Connector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Connector>>
class ConnectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ConnectorStub() {}
  ~ConnectorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConnectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConnectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class SERVICE_MANAGER_MOJOM_EXPORT PIDReceiverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class SERVICE_MANAGER_MOJOM_EXPORT ConnectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class SERVICE_MANAGER_MOJOM_EXPORT ConnectorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};


class SERVICE_MANAGER_MOJOM_EXPORT Identity {
 public:
  using DataView = IdentityDataView;
  using Data_ = internal::Identity_Data;

  template <typename... Args>
  static IdentityPtr New(Args&&... args) {
    return IdentityPtr(
        base::in_place,
        std::forward<Args>(args)...);
  }

  template <typename U>
  static IdentityPtr From(const U& u) {
    return mojo::TypeConverter<IdentityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Identity>::Convert(*this);
  }


  Identity();

  Identity(
      const std::string& name,
      const std::string& user_id,
      const std::string& instance);

  ~Identity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdentityPtr>
  IdentityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, Identity>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::StructSerializeImpl<
        Identity::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::StructSerializeAsMessageImpl<
        Identity::DataView>(input);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::StructDeserializeImpl<Identity::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return Identity::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::StructDeserializeImpl<Identity::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  std::string name;
  std::string user_id;
  std::string instance;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};




template <typename StructPtrType>
IdentityPtr Identity::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(user_id),
      mojo::Clone(instance)
  );
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, Identity>::value>::type*>
bool Identity::Equals(const T& other) const {
  if (!mojo::Equals(this->name, other.name))
    return false;
  if (!mojo::Equals(this->user_id, other.user_id))
    return false;
  if (!mojo::Equals(this->instance, other.instance))
    return false;
  return true;
}


}  // namespace mojom
}  // namespace service_manager

namespace mojo {


template <>
struct SERVICE_MANAGER_MOJOM_EXPORT StructTraits<::service_manager::mojom::Identity::DataView,
                                         ::service_manager::mojom::IdentityPtr> {
  static bool IsNull(const ::service_manager::mojom::IdentityPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::IdentityPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::Identity::name)& name(
      const ::service_manager::mojom::IdentityPtr& input) {
    return input->name;
  }

  static const decltype(::service_manager::mojom::Identity::user_id)& user_id(
      const ::service_manager::mojom::IdentityPtr& input) {
    return input->user_id;
  }

  static const decltype(::service_manager::mojom::Identity::instance)& instance(
      const ::service_manager::mojom::IdentityPtr& input) {
    return input->instance;
  }

  static bool Read(::service_manager::mojom::Identity::DataView input, ::service_manager::mojom::IdentityPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_CONNECTOR_MOJOM_H_