// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/service_manager/public/interfaces/service.mojom-shared.h"
#include "services/service_manager/public/interfaces/connector.mojom.h"
#include "services/service_manager/public/interfaces/interface_provider.mojom.h"
#include "services/service_manager/public/interfaces/interface_provider_spec.mojom.h"
#include "services/service_manager/public/interfaces/service_control.mojom.h"
#include <string>
#include <vector>
#include "services/service_manager/public/cpp/bind_source_info.h"
#include "services/service_manager/public/interfaces/interfaces_export.h"


namespace service_manager {
namespace mojom {
class Service;
using ServicePtr = mojo::InterfacePtr<Service>;
using ServicePtrInfo = mojo::InterfacePtrInfo<Service>;
using ThreadSafeServicePtr =
    mojo::ThreadSafeInterfacePtr<Service>;
using ServiceRequest = mojo::InterfaceRequest<Service>;
using ServiceAssociatedPtr =
    mojo::AssociatedInterfacePtr<Service>;
using ThreadSafeServiceAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<Service>;
using ServiceAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<Service>;
using ServiceAssociatedRequest =
    mojo::AssociatedInterfaceRequest<Service>;

class BindSourceInfo;
using BindSourceInfoPtr = mojo::StructPtr<BindSourceInfo>;


class ServiceProxy;

template <typename ImplRefTraits>
class ServiceStub;

class ServiceRequestValidator;
class ServiceResponseValidator;

class SERVICE_MANAGER_MOJOM_EXPORT Service
    : public ServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = ServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceStub<ImplRefTraits>;

  using RequestValidator_ = ServiceRequestValidator;
  using ResponseValidator_ = ServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnStartMinVersion = 0,
    kOnBindInterfaceMinVersion = 0,
  };
  virtual ~Service() {}


  using OnStartCallback = base::OnceCallback<void(::service_manager::mojom::ConnectorRequest, ::service_manager::mojom::ServiceControlAssociatedRequest)>;
  virtual void OnStart(const ::service_manager::Identity& identity, OnStartCallback callback) = 0;


  using OnBindInterfaceCallback = base::OnceCallback<void()>;
  virtual void OnBindInterface(const ::service_manager::BindSourceInfo& source, const std::string& interface_name, mojo::ScopedMessagePipeHandle interface_pipe, OnBindInterfaceCallback callback) = 0;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceInterceptorForTesting : public Service {
  virtual Service* GetForwardingInterface() = 0;
  void OnStart(const ::service_manager::Identity& identity, OnStartCallback callback);
  void OnBindInterface(const ::service_manager::BindSourceInfo& source, const std::string& interface_name, mojo::ScopedMessagePipeHandle interface_pipe, OnBindInterfaceCallback callback);
};

class SERVICE_MANAGER_MOJOM_EXPORT ServiceProxy
    : public Service {
 public:
  explicit ServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  void OnStart(const ::service_manager::Identity& identity, OnStartCallback callback) override;
  void OnBindInterface(const ::service_manager::BindSourceInfo& source, const std::string& interface_name, mojo::ScopedMessagePipeHandle interface_pipe, OnBindInterfaceCallback callback) override;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceStubDispatch {
 public:
  static bool Accept(Service* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Service* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Service>>
class ServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceStub() {}
  ~ServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class SERVICE_MANAGER_MOJOM_EXPORT BindSourceInfo {
 public:
  using DataView = BindSourceInfoDataView;
  using Data_ = internal::BindSourceInfo_Data;

  template <typename... Args>
  static BindSourceInfoPtr New(Args&&... args) {
    return BindSourceInfoPtr(
        base::in_place,
        std::forward<Args>(args)...);
  }

  template <typename U>
  static BindSourceInfoPtr From(const U& u) {
    return mojo::TypeConverter<BindSourceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BindSourceInfo>::Convert(*this);
  }


  BindSourceInfo();

  BindSourceInfo(
      const ::service_manager::Identity& identity,
      const ::service_manager::CapabilitySet& required_capabilities);

  ~BindSourceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BindSourceInfoPtr>
  BindSourceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, BindSourceInfo>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::StructSerializeImpl<
        BindSourceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::StructSerializeAsMessageImpl<
        BindSourceInfo::DataView>(input);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::StructDeserializeImpl<BindSourceInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return BindSourceInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::StructDeserializeImpl<BindSourceInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  ::service_manager::Identity identity;
  ::service_manager::CapabilitySet required_capabilities;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

template <typename StructPtrType>
BindSourceInfoPtr BindSourceInfo::Clone() const {
  return New(
      mojo::Clone(identity),
      mojo::Clone(required_capabilities)
  );
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, BindSourceInfo>::value>::type*>
bool BindSourceInfo::Equals(const T& other) const {
  if (!mojo::Equals(this->identity, other.identity))
    return false;
  if (!mojo::Equals(this->required_capabilities, other.required_capabilities))
    return false;
  return true;
}


}  // namespace mojom
}  // namespace service_manager

namespace mojo {


template <>
struct SERVICE_MANAGER_MOJOM_EXPORT StructTraits<::service_manager::mojom::BindSourceInfo::DataView,
                                         ::service_manager::mojom::BindSourceInfoPtr> {
  static bool IsNull(const ::service_manager::mojom::BindSourceInfoPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::BindSourceInfoPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::BindSourceInfo::identity)& identity(
      const ::service_manager::mojom::BindSourceInfoPtr& input) {
    return input->identity;
  }

  static const decltype(::service_manager::mojom::BindSourceInfo::required_capabilities)& required_capabilities(
      const ::service_manager::mojom::BindSourceInfoPtr& input) {
    return input->required_capabilities;
  }

  static bool Read(::service_manager::mojom::BindSourceInfo::DataView input, ::service_manager::mojom::BindSourceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MOJOM_H_