// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_CONTROL_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_CONTROL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/service_manager/public/interfaces/service_control.mojom-shared.h"
#include <string>
#include <vector>
#include "services/service_manager/public/interfaces/interfaces_export.h"


namespace service_manager {
namespace mojom {
class ServiceControl;
using ServiceControlPtr = mojo::InterfacePtr<ServiceControl>;
using ServiceControlPtrInfo = mojo::InterfacePtrInfo<ServiceControl>;
using ThreadSafeServiceControlPtr =
    mojo::ThreadSafeInterfacePtr<ServiceControl>;
using ServiceControlRequest = mojo::InterfaceRequest<ServiceControl>;
using ServiceControlAssociatedPtr =
    mojo::AssociatedInterfacePtr<ServiceControl>;
using ThreadSafeServiceControlAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<ServiceControl>;
using ServiceControlAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<ServiceControl>;
using ServiceControlAssociatedRequest =
    mojo::AssociatedInterfaceRequest<ServiceControl>;


class ServiceControlProxy;

template <typename ImplRefTraits>
class ServiceControlStub;

class ServiceControlRequestValidator;

class SERVICE_MANAGER_MOJOM_EXPORT ServiceControl
    : public ServiceControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = ServiceControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceControlStub<ImplRefTraits>;

  using RequestValidator_ = ServiceControlRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestQuitMinVersion = 0,
  };
  virtual ~ServiceControl() {}

  virtual void RequestQuit() = 0;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceControlInterceptorForTesting : public ServiceControl {
  virtual ServiceControl* GetForwardingInterface() = 0;
  void RequestQuit();
};

class SERVICE_MANAGER_MOJOM_EXPORT ServiceControlProxy
    : public ServiceControl {
 public:
  explicit ServiceControlProxy(mojo::MessageReceiverWithResponder* receiver);
  void RequestQuit() override;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceControlStubDispatch {
 public:
  static bool Accept(ServiceControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceControl>>
class ServiceControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceControlStub() {}
  ~ServiceControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace service_manager

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_CONTROL_MOJOM_H_