// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MANAGER_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/service_manager/public/interfaces/service_manager.mojom-shared.h"
#include "services/service_manager/public/interfaces/connector.mojom.h"
#include <string>
#include <vector>
#include "services/service_manager/public/interfaces/interfaces_export.h"


namespace service_manager {
namespace mojom {
class ServiceManagerListener;
using ServiceManagerListenerPtr = mojo::InterfacePtr<ServiceManagerListener>;
using ServiceManagerListenerPtrInfo = mojo::InterfacePtrInfo<ServiceManagerListener>;
using ThreadSafeServiceManagerListenerPtr =
    mojo::ThreadSafeInterfacePtr<ServiceManagerListener>;
using ServiceManagerListenerRequest = mojo::InterfaceRequest<ServiceManagerListener>;
using ServiceManagerListenerAssociatedPtr =
    mojo::AssociatedInterfacePtr<ServiceManagerListener>;
using ThreadSafeServiceManagerListenerAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<ServiceManagerListener>;
using ServiceManagerListenerAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<ServiceManagerListener>;
using ServiceManagerListenerAssociatedRequest =
    mojo::AssociatedInterfaceRequest<ServiceManagerListener>;

class ServiceManager;
using ServiceManagerPtr = mojo::InterfacePtr<ServiceManager>;
using ServiceManagerPtrInfo = mojo::InterfacePtrInfo<ServiceManager>;
using ThreadSafeServiceManagerPtr =
    mojo::ThreadSafeInterfacePtr<ServiceManager>;
using ServiceManagerRequest = mojo::InterfaceRequest<ServiceManager>;
using ServiceManagerAssociatedPtr =
    mojo::AssociatedInterfacePtr<ServiceManager>;
using ThreadSafeServiceManagerAssociatedPtr =
    mojo::ThreadSafeAssociatedInterfacePtr<ServiceManager>;
using ServiceManagerAssociatedPtrInfo =
    mojo::AssociatedInterfacePtrInfo<ServiceManager>;
using ServiceManagerAssociatedRequest =
    mojo::AssociatedInterfaceRequest<ServiceManager>;

class RunningServiceInfo;
using RunningServiceInfoPtr = mojo::StructPtr<RunningServiceInfo>;


class ServiceManagerListenerProxy;

template <typename ImplRefTraits>
class ServiceManagerListenerStub;

class ServiceManagerListenerRequestValidator;

class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerListener
    : public ServiceManagerListenerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = ServiceManagerListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceManagerListenerStub<ImplRefTraits>;

  using RequestValidator_ = ServiceManagerListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnInitMinVersion = 0,
    kOnServiceCreatedMinVersion = 0,
    kOnServiceStartedMinVersion = 0,
    kOnServicePIDReceivedMinVersion = 0,
    kOnServiceFailedToStartMinVersion = 0,
    kOnServiceStoppedMinVersion = 0,
  };
  virtual ~ServiceManagerListener() {}

  virtual void OnInit(std::vector<RunningServiceInfoPtr> running_services) = 0;

  virtual void OnServiceCreated(RunningServiceInfoPtr service) = 0;

  virtual void OnServiceStarted(const ::service_manager::Identity& identity, uint32_t pid) = 0;

  virtual void OnServicePIDReceived(const ::service_manager::Identity& identity, uint32_t pid) = 0;

  virtual void OnServiceFailedToStart(const ::service_manager::Identity& identity) = 0;

  virtual void OnServiceStopped(const ::service_manager::Identity& identity) = 0;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerListenerInterceptorForTesting : public ServiceManagerListener {
  virtual ServiceManagerListener* GetForwardingInterface() = 0;
  void OnInit(std::vector<RunningServiceInfoPtr> running_services);
  void OnServiceCreated(RunningServiceInfoPtr service);
  void OnServiceStarted(const ::service_manager::Identity& identity, uint32_t pid);
  void OnServicePIDReceived(const ::service_manager::Identity& identity, uint32_t pid);
  void OnServiceFailedToStart(const ::service_manager::Identity& identity);
  void OnServiceStopped(const ::service_manager::Identity& identity);
};

class ServiceManagerProxy;

template <typename ImplRefTraits>
class ServiceManagerStub;

class ServiceManagerRequestValidator;

class SERVICE_MANAGER_MOJOM_EXPORT ServiceManager
    : public ServiceManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Proxy_ = ServiceManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceManagerStub<ImplRefTraits>;

  using RequestValidator_ = ServiceManagerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddListenerMinVersion = 0,
  };
  virtual ~ServiceManager() {}

  virtual void AddListener(ServiceManagerListenerPtr listener) = 0;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerInterceptorForTesting : public ServiceManager {
  virtual ServiceManager* GetForwardingInterface() = 0;
  void AddListener(ServiceManagerListenerPtr listener);
};

class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerListenerProxy
    : public ServiceManagerListener {
 public:
  explicit ServiceManagerListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  void OnInit(std::vector<RunningServiceInfoPtr> running_services) override;
  void OnServiceCreated(RunningServiceInfoPtr service) override;
  void OnServiceStarted(const ::service_manager::Identity& identity, uint32_t pid) override;
  void OnServicePIDReceived(const ::service_manager::Identity& identity, uint32_t pid) override;
  void OnServiceFailedToStart(const ::service_manager::Identity& identity) override;
  void OnServiceStopped(const ::service_manager::Identity& identity) override;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};

class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerProxy
    : public ServiceManager {
 public:
  explicit ServiceManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  void AddListener(ServiceManagerListenerPtr listener) override;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerListenerStubDispatch {
 public:
  static bool Accept(ServiceManagerListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceManagerListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceManagerListener>>
class ServiceManagerListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceManagerListenerStub() {}
  ~ServiceManagerListenerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceManagerListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceManagerListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerStubDispatch {
 public:
  static bool Accept(ServiceManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceManager>>
class ServiceManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceManagerStub() {}
  ~ServiceManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class SERVICE_MANAGER_MOJOM_EXPORT ServiceManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class SERVICE_MANAGER_MOJOM_EXPORT RunningServiceInfo {
 public:
  using DataView = RunningServiceInfoDataView;
  using Data_ = internal::RunningServiceInfo_Data;

  template <typename... Args>
  static RunningServiceInfoPtr New(Args&&... args) {
    return RunningServiceInfoPtr(
        base::in_place,
        std::forward<Args>(args)...);
  }

  template <typename U>
  static RunningServiceInfoPtr From(const U& u) {
    return mojo::TypeConverter<RunningServiceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunningServiceInfo>::Convert(*this);
  }


  RunningServiceInfo();

  RunningServiceInfo(
      uint32_t id,
      const ::service_manager::Identity& identity,
      uint32_t pid);

  ~RunningServiceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunningServiceInfoPtr>
  RunningServiceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RunningServiceInfo>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::StructSerializeImpl<
        RunningServiceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::StructSerializeAsMessageImpl<
        RunningServiceInfo::DataView>(input);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::StructDeserializeImpl<RunningServiceInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RunningServiceInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::StructDeserializeImpl<RunningServiceInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  uint32_t id;
  ::service_manager::Identity identity;
  uint32_t pid;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

template <typename StructPtrType>
RunningServiceInfoPtr RunningServiceInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(identity),
      mojo::Clone(pid)
  );
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RunningServiceInfo>::value>::type*>
bool RunningServiceInfo::Equals(const T& other) const {
  if (!mojo::Equals(this->id, other.id))
    return false;
  if (!mojo::Equals(this->identity, other.identity))
    return false;
  if (!mojo::Equals(this->pid, other.pid))
    return false;
  return true;
}


}  // namespace mojom
}  // namespace service_manager

namespace mojo {


template <>
struct SERVICE_MANAGER_MOJOM_EXPORT StructTraits<::service_manager::mojom::RunningServiceInfo::DataView,
                                         ::service_manager::mojom::RunningServiceInfoPtr> {
  static bool IsNull(const ::service_manager::mojom::RunningServiceInfoPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::RunningServiceInfoPtr* output) { output->reset(); }

  static decltype(::service_manager::mojom::RunningServiceInfo::id) id(
      const ::service_manager::mojom::RunningServiceInfoPtr& input) {
    return input->id;
  }

  static const decltype(::service_manager::mojom::RunningServiceInfo::identity)& identity(
      const ::service_manager::mojom::RunningServiceInfoPtr& input) {
    return input->identity;
  }

  static decltype(::service_manager::mojom::RunningServiceInfo::pid) pid(
      const ::service_manager::mojom::RunningServiceInfoPtr& input) {
    return input->pid;
  }

  static bool Read(::service_manager::mojom::RunningServiceInfo::DataView input, ::service_manager::mojom::RunningServiceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_SERVICE_MANAGER_MOJOM_H_