'use strict';class DOM{constructor(document){this._document=document;}
createElement(name,className,attrs){attrs=attrs||{};const element=this._document.createElement(name);if(className){element.className=className;}
Object.keys(attrs).forEach(key=>{const value=attrs[key];if(typeof value!=='undefined'){element.setAttribute(key,value);}});return element;}
cloneTemplate(selector,context){const template=context.querySelector(selector);if(!template){throw new Error(`Template not found: template${selector}`);}
return(this._document.importNode(template.content,true));}
createSpanFromMarkdown(text){const element=this.createElement('span');const parts=text.split(/\[(.*?)\]\((https?:\/\/.*?)\)/g);while(parts.length){const[preambleText,linkText,linkHref]=parts.splice(0,3);element.appendChild(this._document.createTextNode(preambleText));if(linkText&&linkHref){const a=this.createElement('a');a.rel='noopener';a.target='_blank';a.textContent=linkText;a.href=(new URL(linkHref)).href;element.appendChild(a);}}
return element;}
document(){return this._document;}}
if(typeof module!=='undefined'&&module.exports){module.exports=DOM;};'use strict';class DetailsRenderer{constructor(dom){this._dom=dom;}
render(details){switch(details.type){case'text':return this._renderText(details);case'block':return this._renderBlock(details);case'cards':return this._renderCards((details));case'list':return this._renderList(details);default:throw new Error(`Unknown type: ${details.type}`);}}
_renderText(text){const element=this._dom.createElement('div','lh-text');element.textContent=text.text;return element;}
_renderBlock(block){const element=this._dom.createElement('div','lh-block');const items=block.items||[];for(const item of items){element.appendChild(this.render(item));}
return element;}
_renderList(list){const element=this._dom.createElement('details','lh-details');if(list.header){const summary=this._dom.createElement('summary','lh-list__header');summary.textContent=list.header.text;element.appendChild(summary);}
const itemsElem=this._dom.createElement('div','lh-list__items');const items=list.items||[];for(const item of items){itemsElem.appendChild(this.render(item));}
element.appendChild(itemsElem);return element;}
_renderCards(details){const element=this._dom.createElement('details','lh-details');if(details.header){element.appendChild(this._dom.createElement('summary')).textContent=details.header.text;}
const cardsParent=this._dom.createElement('div','lh-scorecards');for(const item of details.items){const card=cardsParent.appendChild(this._dom.createElement('div','lh-scorecard',{title:item.snippet}));const titleEl=this._dom.createElement('div','lh-scorecard__title');const valueEl=this._dom.createElement('div','lh-scorecard__value');const targetEl=this._dom.createElement('div','lh-scorecard__target');card.appendChild(titleEl).textContent=item.title;card.appendChild(valueEl).textContent=item.value;if(item.target){card.appendChild(targetEl).textContent=`target: ${item.target}`;}}
element.appendChild(cardsParent);return element;}}
if(typeof module!=='undefined'&&module.exports){module.exports=DetailsRenderer;}
DetailsRenderer.DetailsJSON;DetailsRenderer.CardsDetailsJSON;;'use strict';const RATINGS={PASS:{label:'pass',minScore:75},AVERAGE:{label:'average',minScore:45},FAIL:{label:'fail'}};function calculateRating(score){let rating=RATINGS.FAIL.label;if(score>=RATINGS.PASS.minScore){rating=RATINGS.PASS.label;}else if(score>=RATINGS.AVERAGE.minScore){rating=RATINGS.AVERAGE.label;}
return rating;}
function formatNumber(number){return number.toLocaleString(undefined,{maximumFractionDigits:1});}
class ReportRenderer{constructor(dom,detailsRenderer){this._dom=dom;this._detailsRenderer=detailsRenderer;this._templateContext=this._dom.document();}
renderReport(report){try{return this._renderReport(report);}catch(e){return this._renderException(e);}}
_populateScore(element,score,scoringMode,title,description){const valueEl=element.querySelector('.lh-score__value');valueEl.textContent=formatNumber(score);valueEl.classList.add(`lh-score__value--${calculateRating(score)}`,`lh-score__value--${scoringMode}`);element.querySelector('.lh-score__title').textContent=title;element.querySelector('.lh-score__description').appendChild(this._dom.createSpanFromMarkdown(description));return(element);}
setTemplateContext(context){this._templateContext=context;}
_renderAuditScore(audit){const tmpl=this._dom.cloneTemplate('#tmpl-lh-audit-score',this._templateContext);const scoringMode=audit.result.scoringMode;const description=audit.result.helpText;let title=audit.result.description;if(audit.result.displayValue){title+=`:  ${audit.result.displayValue}`;}
if(audit.result.optimalValue){title+=` (target: ${audit.result.optimalValue})`;}
const header=tmpl.querySelector('.lh-score__header');header.open=audit.score<100;if(audit.result.details){header.appendChild(this._detailsRenderer.render(audit.result.details));}
return this._populateScore(tmpl,audit.score,scoringMode,title,description);}
_renderCategoryScore(category){const tmpl=this._dom.cloneTemplate('#tmpl-lh-category-score',this._templateContext);const score=Math.round(category.score);return this._populateScore(tmpl,score,'numeric',category.name,category.description);}
_renderException(e){const element=this._dom.createElement('div','lh-exception');element.textContent=String(e.stack);return element;}
_renderReport(report){const element=this._dom.createElement('div','lh-report');for(const category of report.reportCategories){element.appendChild(this._renderCategory(category));}
return element;}
_renderCategory(category){const element=this._dom.createElement('div','lh-category');element.appendChild(this._renderCategoryScore(category));const passedAudits=category.audits.filter(audit=>audit.score===100);const nonPassedAudits=category.audits.filter(audit=>!passedAudits.includes(audit));for(const audit of nonPassedAudits){element.appendChild(this._renderAudit(audit));}
if(!passedAudits.length)return element;const passedElem=this._dom.createElement('details','lh-passed-audits');const passedSummary=this._dom.createElement('summary','lh-passed-audits-summary');passedSummary.textContent=`View ${passedAudits.length} passed items`;passedElem.appendChild(passedSummary);for(const audit of passedAudits){passedElem.appendChild(this._renderAudit(audit));}
element.appendChild(passedElem);return element;}
_renderAudit(audit){const element=this._dom.createElement('div','lh-audit');element.appendChild(this._renderAuditScore(audit));return element;}}
if(typeof module!=='undefined'&&module.exports){module.exports=ReportRenderer;}
ReportRenderer.AuditJSON;ReportRenderer.CategoryJSON;ReportRenderer.ReportJSON;;Audits2.Audits2Panel=class extends UI.Panel{constructor(){super('audits2');this.setHideOnDetach();this.registerRequiredCSS('audits2/audits2Panel.css');this.registerRequiredCSS('audits2/lighthouse/report-styles.css');this._protocolService=new Audits2.ProtocolService();this._protocolService.registerStatusCallback(msg=>this._updateStatus(Common.UIString(msg)));this._settings=Audits2.Audits2Panel.Presets.map(preset=>{const setting=Common.settings.createSetting(preset.id,true);setting.setTitle(Common.UIString(preset.description));return setting;});var auditsViewElement=this.contentElement.createChild('div','hbox audits2-view');this._resultsView=this.contentElement.createChild('div','vbox results-view');this._createLauncherUI(auditsViewElement);}
_reset(){this.contentElement.classList.remove('show-results');this._resultsView.removeChildren();}
_createLauncherUI(auditsViewElement){auditsViewElement.createChild('div','audits2-logo');var uiElement=auditsViewElement.createChild('div');var headerElement=uiElement.createChild('header');headerElement.createChild('p').textContent=Common.UIString('Audits will analyze the page against modern development best practices and collect useful performance metrics and diagnostics. Select audits to collect:');uiElement.appendChild(headerElement);var auditSelectorForm=uiElement.createChild('form','audits2-form');this._settings.map(setting=>new UI.ToolbarSettingCheckbox(setting)).forEach(checkbox=>auditSelectorForm.appendChild(checkbox.element));this._startButton=UI.createTextButton(Common.UIString('Audit this page'),this._startButtonClicked.bind(this),'run-audit audit-btn');auditSelectorForm.appendChild(this._startButton);this._statusView=this._createStatusView(uiElement);}
_createStatusView(launcherUIElement){var statusView=launcherUIElement.createChild('div','audits2-status hbox hidden');statusView.createChild('span','icon');this._statusElement=createElement('p');statusView.appendChild(this._statusElement);this._updateStatus(Common.UIString('Loading...'));return statusView;}
_start(){this._inspectedURL=SDK.targetManager.mainTarget().inspectedURL();const categoryIDs=this._settings.map(setting=>{const preset=Audits2.Audits2Panel.Presets.find(preset=>preset.id===setting.name);return{configID:preset.configID,value:setting.get()};}).filter(agg=>!!agg.value).map(agg=>agg.configID);return Promise.resolve().then(_=>this._protocolService.attach()).then(_=>{this._auditRunning=true;this._updateButton();this._updateStatus(Common.UIString('Loading...'));}).then(_=>this._protocolService.startLighthouse(this._inspectedURL,categoryIDs)).then(lighthouseResult=>{this._finish(lighthouseResult);return this._stop();});}
_startButtonClicked(event){if(this._auditRunning){this._updateStatus(Common.UIString('Cancelling...'));this._stop();return;}
this._start();}
_updateButton(){this._startButton.textContent=this._auditRunning?Common.UIString('Cancel audit'):Common.UIString('Audit this page');this._startButton.classList.toggle('started',this._auditRunning);this._statusView.classList.toggle('hidden',!this._auditRunning);}
_updateStatus(statusMessage){this._statusElement.textContent=statusMessage;}
_stop(){return this._protocolService.detach().then(_=>{this._auditRunning=false;this._updateButton();var resourceTreeModel=SDK.targetManager.mainTarget().model(SDK.ResourceTreeModel);if(resourceTreeModel&&this._inspectedURL!==SDK.targetManager.mainTarget().inspectedURL())
resourceTreeModel.navigate(this._inspectedURL);});}
_finish(lighthouseResult){if(lighthouseResult===null){this._updateStatus(Common.UIString('Auditing failed.'));return;}
this._resultsView.removeChildren();var url=lighthouseResult.url;var timestamp=lighthouseResult.generatedTime;this._createResultsBar(this._resultsView,url,timestamp);this._renderReport(this._resultsView,lighthouseResult);this.contentElement.classList.add('show-results');}
_renderReport(resultsView,lighthouseResult){var reportContainer=resultsView.createChild('div','report-container');var dom=new DOM(document);var detailsRenderer=new DetailsRenderer(dom);var renderer=new ReportRenderer(dom,detailsRenderer);var templatesHTML=Runtime.cachedResources['audits2/lighthouse/templates.html'];var templatesDOM=new DOMParser().parseFromString(templatesHTML,'text/html');if(!templatesDOM)
return;renderer.setTemplateContext(templatesDOM);reportContainer.appendChild(renderer.renderReport(lighthouseResult));}
_createResultsBar(resultsView,url,timestamp){var elem=resultsView.createChild('div','results-bar hbox');elem.createChild('div','audits2-logo audits2-logo-small');var summaryElem=elem.createChild('div','audits2-summary');var reportFor=summaryElem.createChild('span');reportFor.createTextChild('Report for ');var urlElem=reportFor.createChild('b');urlElem.textContent=url;var timeElem=summaryElem.createChild('span');timeElem.textContent=`Generated at ${new Date(timestamp).toLocaleDateString()} ${new Date(timestamp).toLocaleTimeString()}`;var newAuditButton=UI.createTextButton(Common.UIString('New Audit'),this._reset.bind(this),'new-audit audit-btn');elem.appendChild(newAuditButton);}};Audits2.Audits2Panel.Preset;Audits2.Audits2Panel.Presets=[{id:'audits2_cat_pwa',configID:'pwa',description:'Progressive Web App'},{id:'audits2_cat_perf',configID:'performance',description:'Performance metrics and diagnostics'},{id:'audits2_cat_a11y',configID:'accessibility',description:'Accessibility'},{id:'audits2_cat_best_practices',configID:'best-practices',description:'Modern best practices'},];Audits2.ProtocolService=class extends Common.Object{constructor(){super();this._rawConnection=null;this._backend=null;this._backendPromise=null;this._status=null;}
attach(){return SDK.targetManager.interceptMainConnection(this._dispatchProtocolMessage.bind(this)).then(rawConnection=>{this._rawConnection=rawConnection;});}
startLighthouse(inspectedURL,categoryIDs){return this._send('start',{url:inspectedURL,categoryIDs});}
detach(){return Promise.resolve().then(()=>this._send('stop')).then(()=>this._backend.dispose()).then(()=>{delete this._backend;delete this._backendPromise;return this._rawConnection.disconnect();});}
registerStatusCallback(callback){this._status=callback;}
_dispatchProtocolMessage(message){this._send('dispatchProtocolMessage',{message:message});}
_initWorker(){this._backendPromise=Services.serviceManager.createAppService('audits2_worker','Audits2Service',false).then(backend=>{if(this._backend)
return;this._backend=backend;this._backend.on('statusUpdate',result=>this._status(result.message));this._backend.on('sendProtocolMessage',result=>this._rawConnection.sendMessage(result.message));});}
_send(method,params){if(!this._backendPromise)
this._initWorker();return this._backendPromise.then(_=>this._backend.send(method,params));}};;Runtime.cachedResources["audits2/audits2Panel.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.audits2-view {\n    max-width: 550px;\n    min-width: 334px;\n    align-self: center;\n    margin: 30px 20px;\n}\n\n.results-view {\n    display: none;\n    flex-wrap: nowrap;\n    justify-content: flex-start;\n    align-content: stretch;\n    align-items: stretch;\n}\n\n.show-results .audits2-view {\n    display: none;\n}\n\n.show-results .results-view {\n    display: flex;\n    flex: auto;\n}\n\n.results-bar {\n    flex: none;\n    align-self: auto;\n    border-bottom: 1px solid #cccccc;\n}\n\n.audits2-summary {\n    display: flex;\n    flex-direction: column;\n    flex-grow: 1;\n    padding: 6px;\n    line-height: 1.7;\n    align-self: center;\n}\n\n.audits2-summary span {\n    color: #b7b7b7;\n    display: block;\n    overflow: hidden;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n}\n\n.audits2-summary span b {\n    font-weight: normal;\n    color: #636382;\n}\n\n.audits2-summary span:first-child {\n    color: inherit;\n    font-size: 110%;\n}\n\n.audits2-logo {\n    width: 100px;\n    height: 110px;\n    flex-shrink: 0;\n    background-repeat: no-repeat;\n    background-size: contain;\n    margin-top: 10px;\n    background-image: -webkit-image-set(\n        url(Images/audits_logo.png) 1x,\n        url(Images/audits_logo_2x.png) 2x);\n}\n\n.audits2-logo-small {\n    background-image: -webkit-image-set(\n        url(Images/audits_logo_bw.png) 1x,\n        url(Images/audits_logo_bw_2x.png) 2x);\n    height: 41px;\n    width: 42px;\n    align-self: center;\n    margin: 0 0 0 20px;\n    flex-shrink: 0;\n}\n\n.report-container {\n    flex: 1 1 auto;\n    align-self: auto;\n    position: relative;\n    overflow: auto;\n}\n\n.audits2-form label {\n    display: flex;\n}\n\n.audits2-form label div {\n    display: inline;\n}\n\nbutton.audit-btn {\n    display: inline-block;\n    color: white;\n    text-shadow: none;\n    padding: 6px 10px;\n    background-color: #4285f4 !important;\n    background-image: unset !important;\n    font-size: 11px;\n    box-shadow: none !important;\n}\n\nbutton.audit-btn:hover {\n    background-color: hsla(217, 89%, 58%, 1) !important;\n    color: white !important;\n}\n\nbutton.run-audit {\n    margin-top: 12px;\n}\nbutton.run-audit.started {\n    background-color: #ffffff !important;\n    color: gray;\n}\n\nbutton.run-audit.started:hover {\n    background-color: #eee !important;\n    color: gray !important;\n}\n\nbutton.new-audit {\n    align-self: center;\n    margin-right: 20px;\n}\n\n.audits2-status .icon {\n    width: 16px;\n    height: 16px;\n    margin-top: 10px;\n    margin-right: 4px;\n    animation: spinner-animation 1200ms linear infinite;\n    transform-origin: 50% 50%;\n    padding: 1px;\n}\n\n.audits2-status .icon::before {\n    display: inline-block;\n    border: 1px solid #1565C0;\n    border-radius: 7px;\n    width: 14px;\n    height: 14px;\n    content: \"\";\n    position: absolute;\n    box-sizing: border-box;\n}\n\n.audits2-status .icon::after {\n    display: inline-block;\n    width: 6px;\n    height: 7px;\n    background: white;\n    position: absolute;\n    content: \"\";\n}\n\n@keyframes spinner-animation {\n    from { transform: rotate(0); }\n    to { transform: rotate(360deg); }\n\n/*# sourceURL=audits2/audits2Panel.css */";Runtime.cachedResources["audits2/lighthouse/report-styles.css"]="/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n :root {\n  --text-font-family: '.SFNSDisplay-Regular', 'Helvetica Neue', 'Lucida Grande', sans-serif;\n  --body-font-size: 13px;\n  --default-padding: 16px;\n\n  --secondary-text-color: #565656;\n  /*--accent-color: #3879d9;*/\n  --fail-color: #df332f;\n  --pass-color: #2b882f;\n  --average-color: #ef6c00; /* md orange 800 */\n  --warning-color: #757575; /* md grey 600 */\n\n  --report-border-color: #ebebeb;\n\n  --lh-score-highlight-bg: #fafafa;\n  --lh-score-icon-background-size: 17px;\n  --lh-score-margin: var(--default-padding);\n  --lh-audit-score-width: 35px;\n  --lh-category-score-width: 50px;\n}\n\n* {\n  box-sizing: border-box;\n}\n\nbody {\n  font-family: var(--text-font-family);\n  font-size: var(--body-font-size);\n  margin: 0;\n  line-height: var(--body-line-height);\n}\n\n[hidden] {\n  display: none !important;\n}\n\n.lh-details {\n  font-size: smaller;\n  margin-top: var(--default-padding);\n}\n\n.lh-details summary {\n  cursor: pointer;\n}\n\n.lh-details[open] summary {\n  margin-bottom: var(--default-padding);\n}\n\n/* List */\n.lh-list__items {\n  padding-left: var(--default-padding);\n}\n\n.lh-list__items > * {\n  border-bottom: 1px solid gray;\n  margin-bottom: 2px;\n}\n\n/* Card */\n.lh-scorecards {\n  display: flex;\n  flex-wrap: wrap;\n}\n.lh-scorecard {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex: 0 0 180px;\n  flex-direction: column;\n  padding: var(--default-padding);\n  padding-top: calc(32px + var(--default-padding));\n  border-radius: 3px;\n  margin-right: var(--default-padding);\n  position: relative;\n  line-height: inherit;\n  border: 1px solid #ebebeb;\n}\n.lh-scorecard__title {\n  background-color: #eee;\n  position: absolute;\n  top: 0;\n  right: 0;\n  left: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: calc(var(--default-padding) / 2);\n}\n.lh-scorecard__value {\n  font-size: 28px;\n}\n.lh-scorecard__target {\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n/* Score */\n\n.lh-score {\n  display: flex;\n  align-items: flex-start;\n}\n\n.lh-score__value {\n  flex: none;\n  padding: 5px;\n  margin-right: var(--lh-score-margin);\n  width: var(--lh-audit-score-width);\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  background: var(--warning-color);\n  color: #fff;\n  border-radius: 2px;\n  position: relative;\n}\n\n.lh-score__value::after {\n  content: '';\n  position: absolute;\n  left: 0;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  background-color: #000;\n  border-radius: inherit;\n}\n\n.lh-score__value--binary {\n  text-indent: -500px;\n}\n\n/* No icon for audits with number scores. */\n.lh-score__value:not(.lh-score__value--binary)::after {\n  content: none;\n}\n\n.lh-score__value--pass {\n  background: var(--pass-color);\n}\n\n.lh-score__value--pass::after {\n  background: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>pass</title><path d=\"M9.17 2.33L4.5 7 2.83 5.33 1.5 6.66l3 3 6-6z\" fill=\"white\" fill-rule=\"evenodd\"/></svg>') no-repeat 50% 50%;\n  background-size: var(--lh-score-icon-background-size);\n}\n\n.lh-score__value--average {\n  background: var(--average-color);\n}\n\n.lh-score__value--average::after {\n  background: none;\n  content: '!';\n  background-color: var(--average-color);\n  color: #fff;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  font-weight: 500;\n  font-size: 15px;\n}\n\n.lh-score__value--fail {\n  background: var(--fail-color);\n}\n\n.lh-score__value--fail::after {\n  background: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>fail</title><path d=\"M8.33 2.33l1.33 1.33-2.335 2.335L9.66 8.33 8.33 9.66 5.995 7.325 3.66 9.66 2.33 8.33l2.335-2.335L2.33 3.66l1.33-1.33 2.335 2.335z\" fill=\"white\"/></svg>') no-repeat 50% 50%;\n  background-size: var(--lh-score-icon-background-size);\n}\n\n.lh-score__title {\n  margin-bottom: calc(var(--default-padding) / 2);\n}\n\n.lh-score__description {\n  font-size: smaller;\n  color: var(--secondary-text-color);\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n.lh-score__header {\n  flex: 1;\n  margin-top: 2px;\n}\n\n.lh-score__header[open] .lh-score__arrow {\n  transform: rotateZ(90deg);\n}\n\n.lh-score__arrow {\n  background: url('data:image/svg+xml;utf8,<svg fill=\"black\" height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z\"/><path d=\"M0-.25h24v24H0z\" fill=\"none\"/></svg>') no-repeat 50% 50%;\n  background-size: contain;\n  background-color: transparent;\n  width: 24px;\n  height: 24px;\n  flex: none;\n  margin: 0 8px 0 8px;\n  transition: transform 150ms ease-in-out;\n}\n\n.lh-score__snippet {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  cursor: pointer;\n  /*outline: none;*/\n}\n\n.lh-score__snippet::-moz-list-bullet {\n  display: none;\n}\n\n.lh-score__snippet::-webkit-details-marker {\n  display: none;\n}\n\n/*.lh-score__snippet:focus .lh-score__title {\n  outline: rgb(59, 153, 252) auto 5px;\n}*/\n\n/* Audit */\n\n.lh-audit {\n  margin-top: var(--default-padding);\n}\n\n.lh-audit > .lh-score {\n  font-size: 16px;\n}\n\n/* Report */\n\n.lh-exception {\n  font-size: large;\n}\n\n.lh-report {\n  padding: var(--default-padding);\n}\n\n.lh-category {\n  padding: 24px 0;\n  border-top: 1px solid var(--report-border-color);\n}\n\n.lh-category:first-of-type {\n  border: none;\n  padding-top: 0;\n}\n\n.lh-category > .lh-audit,\n.lh-category > .lh-passed-audits > .lh-audit {\n  margin-left: calc(var(--lh-category-score-width) + var(--lh-score-margin));\n}\n\n.lh-category > .lh-score {\n  font-size: 20px;\n}\n\n.lh-category > .lh-score .lh-score__value {\n  width: var(--lh-category-score-width);\n}\n\n/* Category snippet shouldnt have pointer cursor. */\n.lh-category > .lh-score .lh-score__snippet {\n  cursor: initial;\n}\n\n.lh-category > .lh-score .lh-score__title {\n  font-size: 24px;\n  font-weight: 400;\n}\n\nsummary.lh-passed-audits-summary {\n  margin: 10px 5px;\n  font-size: 15px;\n}\n\nsummary.lh-passed-audits-summary::-webkit-details-marker {\n  background: rgb(66, 175, 69);\n  color: white;\n  position:relative;\n  content: '';\n  padding: 3px;\n}\n\n/*# sourceURL=report.styles.css */\n\n/*# sourceURL=audits2/lighthouse/report-styles.css */";Runtime.cachedResources["audits2/lighthouse/templates.html"]="<!-- Lighthouse category score -->\n<template id=\"tmpl-lh-category-score\">\n  <div class=\"lh-score\">\n    <div class=\"lh-score__value\"><!-- fill me --></div>\n    <div class=\"lh-score__header\">\n      <div class=\"lh-score__snippet\">\n        <span class=\"lh-score__title\"><!-- fill me --></span>\n      </div>\n      <div class=\"lh-score__description\"><!-- fill me --></div>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse audit score -->\n<template id=\"tmpl-lh-audit-score\">\n  <div class=\"lh-score\">\n    <div class=\"lh-score__value\"><!-- fill me --></div>\n    <details class=\"lh-score__header\">\n      <summary class=\"lh-score__snippet\">\n        <span class=\"lh-score__title\"><!-- fill me --></span>\n        <div class=\"lh-score__arrow\" title=\"See audits\"></div>\n      </summary>\n      <div class=\"lh-score__description\"><!-- fill me --></div>\n    </details>\n  </div>\n</template>\n\n/*# sourceURL=audits2/lighthouse/templates.html */";