ColorPicker.Spectrum=class extends UI.VBox{constructor(){function appendSwitcherIcon(parentElement){var icon=parentElement.createSVGChild('svg');icon.setAttribute('height',16);icon.setAttribute('width',16);var path=icon.createSVGChild('path');path.setAttribute('d','M5,6 L11,6 L8,2 Z M5,10 L11,10 L8,14 Z');return icon;}
super(true);this.registerRequiredCSS('color_picker/spectrum.css');this.contentElement.tabIndex=0;this.setDefaultFocusedElement(this.contentElement);this._colorElement=this.contentElement.createChild('div','spectrum-color');this._colorDragElement=this._colorElement.createChild('div','spectrum-sat fill').createChild('div','spectrum-val fill').createChild('div','spectrum-dragger');var contrastRatioSVG=this._colorElement.createSVGChild('svg','spectrum-contrast-container fill');this._contrastRatioLine=contrastRatioSVG.createSVGChild('path','spectrum-contrast-line');var toolbar=new UI.Toolbar('spectrum-eye-dropper',this.contentElement);this._colorPickerButton=new UI.ToolbarToggle(Common.UIString('Toggle color picker'),'largeicon-eyedropper');this._colorPickerButton.setToggled(true);this._colorPickerButton.addEventListener(UI.ToolbarButton.Events.Click,this._toggleColorPicker.bind(this,undefined));toolbar.appendToolbarItem(this._colorPickerButton);var swatchElement=this.contentElement.createChild('span','swatch');this._swatchInnerElement=swatchElement.createChild('span','swatch-inner');this._swatchOverlayElement=swatchElement.createChild('span','swatch-overlay');this._swatchOverlayElement.addEventListener('click',this._onCopyIconClick.bind(this));this._swatchOverlayElement.addEventListener('mouseout',this._onCopyIconMouseout.bind(this));this._swatchCopyIcon=UI.Icon.create('largeicon-copy','copy-color-icon');this._swatchCopyIcon.title=Common.UIString('Copy color to clipboard');this._swatchOverlayElement.appendChild(this._swatchCopyIcon);this._hueElement=this.contentElement.createChild('div','spectrum-hue');this._hueSlider=this._hueElement.createChild('div','spectrum-slider');this._alphaElement=this.contentElement.createChild('div','spectrum-alpha');this._alphaElementBackground=this._alphaElement.createChild('div','spectrum-alpha-background');this._alphaSlider=this._alphaElement.createChild('div','spectrum-slider');var displaySwitcher=this.contentElement.createChild('div','spectrum-display-switcher spectrum-switcher');appendSwitcherIcon(displaySwitcher);displaySwitcher.addEventListener('click',this._formatViewSwitch.bind(this));this._displayContainer=this.contentElement.createChild('div','spectrum-text source-code');this._textValues=[];for(var i=0;i<4;++i){var inputValue=this._displayContainer.createChild('input','spectrum-text-value');inputValue.maxLength=4;this._textValues.push(inputValue);inputValue.addEventListener('keydown',this._inputChanged.bind(this),false);inputValue.addEventListener('input',this._inputChanged.bind(this),false);inputValue.addEventListener('mousewheel',this._inputChanged.bind(this),false);}
this._textLabels=this._displayContainer.createChild('div','spectrum-text-label');this._hexContainer=this.contentElement.createChild('div','spectrum-text spectrum-text-hex source-code');this._hexValue=this._hexContainer.createChild('input','spectrum-text-value');this._hexValue.maxLength=7;this._hexValue.addEventListener('keydown',this._inputChanged.bind(this),false);this._hexValue.addEventListener('input',this._inputChanged.bind(this),false);this._hexValue.addEventListener('mousewheel',this._inputChanged.bind(this),false);var label=this._hexContainer.createChild('div','spectrum-text-label');label.textContent='HEX';UI.installDragHandle(this._hueElement,dragStart.bind(this,positionHue.bind(this)),positionHue.bind(this),null,'default');UI.installDragHandle(this._alphaElement,dragStart.bind(this,positionAlpha.bind(this)),positionAlpha.bind(this),null,'default');UI.installDragHandle(this._colorElement,dragStart.bind(this,positionColor.bind(this)),positionColor.bind(this),null,'default');this.element.classList.add('palettes-enabled');this._palettes=new Map();this._palettePanel=this.contentElement.createChild('div','palette-panel');this._palettePanelShowing=false;this._paletteContainer=this.contentElement.createChild('div','spectrum-palette');this._paletteContainer.addEventListener('contextmenu',this._showPaletteColorContextMenu.bind(this,-1));this._shadesContainer=this.contentElement.createChild('div','palette-color-shades hidden');UI.installDragHandle(this._paletteContainer,this._paletteDragStart.bind(this),this._paletteDrag.bind(this),this._paletteDragEnd.bind(this),'default');var paletteSwitcher=this.contentElement.createChild('div','spectrum-palette-switcher spectrum-switcher');appendSwitcherIcon(paletteSwitcher);paletteSwitcher.addEventListener('click',this._togglePalettePanel.bind(this,true));this._deleteIconToolbar=new UI.Toolbar('delete-color-toolbar');this._deleteButton=new UI.ToolbarButton('','largeicon-trash-bin');this._deleteIconToolbar.appendToolbarItem(this._deleteButton);var overlay=this.contentElement.createChild('div','spectrum-overlay fill');overlay.addEventListener('click',this._togglePalettePanel.bind(this,false));this._addColorToolbar=new UI.Toolbar('add-color-toolbar');var addColorButton=new UI.ToolbarButton(Common.UIString('Add to palette'),'largeicon-add');addColorButton.addEventListener(UI.ToolbarButton.Events.Click,this._addColorToCustomPalette,this);this._addColorToolbar.appendToolbarItem(addColorButton);this._colorPickedBound=this._colorPicked.bind(this);this._loadPalettes();new ColorPicker.Spectrum.PaletteGenerator(this._generatedPaletteLoaded.bind(this));function dragStart(callback,event){this._hueAlphaLeft=this._hueElement.totalOffsetLeft();this._colorOffset=this._colorElement.totalOffset();callback(event);return true;}
function positionHue(event){var hsva=this._hsv.slice();hsva[0]=Number.constrain(1-(event.x-this._hueAlphaLeft)/this._hueAlphaWidth,0,1);this._innerSetColor(hsva,'',undefined,ColorPicker.Spectrum._ChangeSource.Other);}
function positionAlpha(event){var newAlpha=Math.round((event.x-this._hueAlphaLeft)/this._hueAlphaWidth*100)/100;var hsva=this._hsv.slice();hsva[3]=Number.constrain(newAlpha,0,1);var colorFormat=undefined;if(hsva[3]!==1&&(this._colorFormat===Common.Color.Format.ShortHEX||this._colorFormat===Common.Color.Format.HEX||this._colorFormat===Common.Color.Format.Nickname))
colorFormat=Common.Color.Format.RGB;this._innerSetColor(hsva,'',colorFormat,ColorPicker.Spectrum._ChangeSource.Other);}
function positionColor(event){var hsva=this._hsv.slice();hsva[1]=Number.constrain((event.x-this._colorOffset.left)/this.dragWidth,0,1);hsva[2]=Number.constrain(1-(event.y-this._colorOffset.top)/this.dragHeight,0,1);this._innerSetColor(hsva,'',undefined,ColorPicker.Spectrum._ChangeSource.Other);}}
_onCopyIconClick(){this._swatchCopyIcon.setIconType('largeicon-checkmark');InspectorFrontendHost.copyText(this.colorString());}
_onCopyIconMouseout(){this._swatchCopyIcon.setIconType('largeicon-copy');}
_updatePalettePanel(){this._palettePanel.removeChildren();var title=this._palettePanel.createChild('div','palette-title');title.textContent=Common.UIString('Color Palettes');var toolbar=new UI.Toolbar('',this._palettePanel);var closeButton=new UI.ToolbarButton('Return to color picker','largeicon-delete');closeButton.addEventListener(UI.ToolbarButton.Events.Click,this._togglePalettePanel.bind(this,false));toolbar.appendToolbarItem(closeButton);for(var palette of this._palettes.values())
this._palettePanel.appendChild(this._createPreviewPaletteElement(palette));}
_togglePalettePanel(show){if(this._palettePanelShowing===show)
return;if(show)
this._updatePalettePanel();this._focus();this._palettePanelShowing=show;this.contentElement.classList.toggle('palette-panel-showing',show);}
_focus(){if(this.isShowing())
this.contentElement.focus();}
_createPaletteColor(colorText,animationDelay){var element=createElementWithClass('div','spectrum-palette-color');element.style.background=String.sprintf('linear-gradient(%s, %s), url(Images/checker.png)',colorText,colorText);if(animationDelay)
element.animate([{opacity:0},{opacity:1}],{duration:100,delay:animationDelay,fill:'backwards'});element.title=colorText;return element;}
_showPalette(palette,animate,event){this._resizeForSelectedPalette();this._paletteContainer.removeChildren();for(var i=0;i<palette.colors.length;i++){var animationDelay=animate?i*100/palette.colors.length:0;var colorElement=this._createPaletteColor(palette.colors[i],animationDelay);colorElement.addEventListener('mousedown',this._paletteColorSelected.bind(this,palette.colors[i],palette.matchUserFormat));if(palette.mutable){colorElement.__mutable=true;colorElement.__color=palette.colors[i];colorElement.addEventListener('contextmenu',this._showPaletteColorContextMenu.bind(this,i));}else if(palette===ColorPicker.Spectrum.MaterialPalette){colorElement.classList.add('has-material-shades');var shadow=colorElement.createChild('div','spectrum-palette-color spectrum-palette-color-shadow');shadow.style.background=palette.colors[i];shadow=colorElement.createChild('div','spectrum-palette-color spectrum-palette-color-shadow');shadow.style.background=palette.colors[i];colorElement.title=Common.UIString(palette.colors[i]+'. Long-click to show alternate shades.');new UI.LongClickController(colorElement,this._showLightnessShades.bind(this,colorElement,palette.colors[i]));}
this._paletteContainer.appendChild(colorElement);}
this._paletteContainerMutable=palette.mutable;if(palette.mutable){this._paletteContainer.appendChild(this._addColorToolbar.element);this._paletteContainer.appendChild(this._deleteIconToolbar.element);}else{this._addColorToolbar.element.remove();this._deleteIconToolbar.element.remove();}
this._togglePalettePanel(false);this._focus();}
_showLightnessShades(colorElement,colorText,event){function closeLightnessShades(element){this._shadesContainer.classList.add('hidden');element.classList.remove('spectrum-shades-shown');this._shadesContainer.ownerDocument.removeEventListener('mousedown',this._shadesCloseHandler,true);delete this._shadesCloseHandler;}
if(this._shadesCloseHandler)
this._shadesCloseHandler();this._shadesContainer.classList.remove('hidden');this._shadesContainer.removeChildren();this._shadesContainer.animate([{transform:'scaleY(0)',opacity:'0'},{transform:'scaleY(1)',opacity:'1'}],{duration:200,easing:'cubic-bezier(0.4, 0, 0.2, 1)'});this._shadesContainer.style.top=colorElement.offsetTop+colorElement.parentElement.offsetTop+'px';this._shadesContainer.style.left=colorElement.offsetLeft+'px';colorElement.classList.add('spectrum-shades-shown');var shades=ColorPicker.Spectrum.MaterialPaletteShades[colorText];for(var i=shades.length-1;i>=0;i--){var shadeElement=this._createPaletteColor(shades[i],i*200/shades.length+100);shadeElement.addEventListener('mousedown',this._paletteColorSelected.bind(this,shades[i],false));this._shadesContainer.appendChild(shadeElement);}
this._shadesContainer.focus();this._shadesCloseHandler=closeLightnessShades.bind(this,colorElement);this._shadesContainer.ownerDocument.addEventListener('mousedown',this._shadesCloseHandler,true);}
_slotIndexForEvent(e){var localX=e.pageX-this._paletteContainer.totalOffsetLeft();var localY=e.pageY-this._paletteContainer.totalOffsetTop();var col=Math.min(localX/ColorPicker.Spectrum._colorChipSize|0,ColorPicker.Spectrum._itemsPerPaletteRow-1);var row=(localY/ColorPicker.Spectrum._colorChipSize)|0;return Math.min(row*ColorPicker.Spectrum._itemsPerPaletteRow+col,this._customPaletteSetting.get().colors.length-1);}
_isDraggingToBin(e){return e.pageX>this._deleteIconToolbar.element.totalOffsetLeft();}
_paletteDragStart(e){var element=e.deepElementFromPoint();if(!element||!element.__mutable)
return false;var index=this._slotIndexForEvent(e);this._dragElement=element;this._dragHotSpotX=e.pageX-(index%ColorPicker.Spectrum._itemsPerPaletteRow)*ColorPicker.Spectrum._colorChipSize;this._dragHotSpotY=e.pageY-(index/ColorPicker.Spectrum._itemsPerPaletteRow|0)*ColorPicker.Spectrum._colorChipSize;return true;}
_paletteDrag(e){if(e.pageX<this._paletteContainer.totalOffsetLeft()||e.pageY<this._paletteContainer.totalOffsetTop())
return;var newIndex=this._slotIndexForEvent(e);var offsetX=e.pageX-(newIndex%ColorPicker.Spectrum._itemsPerPaletteRow)*ColorPicker.Spectrum._colorChipSize;var offsetY=e.pageY-(newIndex/ColorPicker.Spectrum._itemsPerPaletteRow|0)*ColorPicker.Spectrum._colorChipSize;var isDeleting=this._isDraggingToBin(e);this._deleteIconToolbar.element.classList.add('dragging');this._deleteIconToolbar.element.classList.toggle('delete-color-toolbar-active',isDeleting);var dragElementTransform='translateX('+(offsetX-this._dragHotSpotX)+'px) translateY('+(offsetY-this._dragHotSpotY)+'px)';this._dragElement.style.transform=isDeleting?dragElementTransform+' scale(0.8)':dragElementTransform;var children=Array.prototype.slice.call(this._paletteContainer.children);var index=children.indexOf(this._dragElement);var swatchOffsets=new Map();for(var swatch of children)
swatchOffsets.set(swatch,swatch.totalOffset());if(index!==newIndex)
this._paletteContainer.insertBefore(this._dragElement,children[newIndex>index?newIndex+1:newIndex]);for(var swatch of children){if(swatch===this._dragElement)
continue;var before=swatchOffsets.get(swatch);var after=swatch.totalOffset();if(before.left!==after.left||before.top!==after.top){swatch.animate([{transform:'translateX('+(before.left-after.left)+'px) translateY('+(before.top-after.top)+'px)'},{transform:'none'}],{duration:100,easing:'cubic-bezier(0, 0, 0.2, 1)'});}}}
_paletteDragEnd(e){if(this._isDraggingToBin(e))
this._dragElement.remove();this._dragElement.style.removeProperty('transform');var children=this._paletteContainer.children;var colors=[];for(var i=0;i<children.length;++i){if(children[i].__color)
colors.push(children[i].__color);}
var palette=this._customPaletteSetting.get();palette.colors=colors;this._customPaletteSetting.set(palette);this._showPalette(this._customPaletteSetting.get(),false);this._deleteIconToolbar.element.classList.remove('dragging');this._deleteIconToolbar.element.classList.remove('delete-color-toolbar-active');}
_loadPalettes(){this._palettes.set(ColorPicker.Spectrum.MaterialPalette.title,ColorPicker.Spectrum.MaterialPalette);var defaultCustomPalette={title:'Custom',colors:[],mutable:true};this._customPaletteSetting=Common.settings.createSetting('customColorPalette',defaultCustomPalette);this._palettes.set(this._customPaletteSetting.get().title,this._customPaletteSetting.get());this._selectedColorPalette=Common.settings.createSetting('selectedColorPalette',ColorPicker.Spectrum.GeneratedPaletteTitle);var palette=this._palettes.get(this._selectedColorPalette.get());if(palette)
this._showPalette(palette,true);}
_generatedPaletteLoaded(generatedPalette){if(generatedPalette.colors.length)
this._palettes.set(generatedPalette.title,generatedPalette);if(this._selectedColorPalette.get()!==generatedPalette.title){return;}else if(!generatedPalette.colors.length){this._paletteSelected(ColorPicker.Spectrum.MaterialPalette);return;}
this._showPalette(generatedPalette,true);}
_createPreviewPaletteElement(palette){var colorsPerPreviewRow=5;var previewElement=createElementWithClass('div','palette-preview');var titleElement=previewElement.createChild('div','palette-preview-title');titleElement.textContent=palette.title;for(var i=0;i<colorsPerPreviewRow&&i<palette.colors.length;i++)
previewElement.appendChild(this._createPaletteColor(palette.colors[i]));for(;i<colorsPerPreviewRow;i++)
previewElement.createChild('div','spectrum-palette-color empty-color');previewElement.addEventListener('click',this._paletteSelected.bind(this,palette));return previewElement;}
_paletteSelected(palette){this._selectedColorPalette.set(palette.title);this._showPalette(palette,true);}
_resizeForSelectedPalette(){var palette=this._palettes.get(this._selectedColorPalette.get());if(!palette)
return;var numColors=palette.colors.length;if(palette===this._customPaletteSetting.get())
numColors++;var rowsNeeded=Math.max(1,Math.ceil(numColors/ColorPicker.Spectrum._itemsPerPaletteRow));if(this._numPaletteRowsShown===rowsNeeded)
return;this._numPaletteRowsShown=rowsNeeded;var paletteColorHeight=12;var paletteMargin=12;var paletteTop=235;this.element.style.height=(paletteTop+paletteMargin+(paletteColorHeight+paletteMargin)*rowsNeeded)+'px';this.dispatchEventToListeners(ColorPicker.Spectrum.Events.SizeChanged);}
_paletteColorSelected(colorText,matchUserFormat){var color=Common.Color.parse(colorText);if(!color)
return;this._innerSetColor(color.hsva(),colorText,matchUserFormat?this._colorFormat:color.format(),ColorPicker.Spectrum._ChangeSource.Other);}
_addColorToCustomPalette(event){var palette=this._customPaletteSetting.get();palette.colors.push(this.colorString());this._customPaletteSetting.set(palette);this._showPalette(this._customPaletteSetting.get(),false);}
_showPaletteColorContextMenu(colorIndex,event){if(!this._paletteContainerMutable)
return;var contextMenu=new UI.ContextMenu(event);if(colorIndex!==-1){contextMenu.appendItem(Common.UIString('Remove color'),this._deletePaletteColors.bind(this,colorIndex,false));contextMenu.appendItem(Common.UIString('Remove all to the right'),this._deletePaletteColors.bind(this,colorIndex,true));}
contextMenu.appendItem(Common.UIString('Clear palette'),this._deletePaletteColors.bind(this,-1,true));contextMenu.show();}
_deletePaletteColors(colorIndex,toRight){var palette=this._customPaletteSetting.get();if(toRight)
palette.colors.splice(colorIndex+1,palette.colors.length-colorIndex-1);else
palette.colors.splice(colorIndex,1);this._customPaletteSetting.set(palette);this._showPalette(this._customPaletteSetting.get(),false);}
setColor(color,colorFormat){this._originalFormat=colorFormat;this._innerSetColor(color.hsva(),'',colorFormat,ColorPicker.Spectrum._ChangeSource.Model);}
_innerSetColor(hsva,colorString,colorFormat,changeSource){if(hsva!==undefined)
this._hsv=hsva;if(colorString!==undefined)
this._colorString=colorString;if(colorFormat!==undefined){console.assert(colorFormat!==Common.Color.Format.Original,'Spectrum\'s color format cannot be Original');if(colorFormat===Common.Color.Format.RGBA)
colorFormat=Common.Color.Format.RGB;else if(colorFormat===Common.Color.Format.HSLA)
colorFormat=Common.Color.Format.HSL;this._colorFormat=colorFormat;}
this._updateHelperLocations();this._updateUI();if(changeSource!==ColorPicker.Spectrum._ChangeSource.Input)
this._updateInput();if(changeSource!==ColorPicker.Spectrum._ChangeSource.Model)
this.dispatchEventToListeners(ColorPicker.Spectrum.Events.ColorChanged,this.colorString());}
setContrastColor(color){this._contrastColor=color;this._updateUI();}
_color(){return Common.Color.fromHSVA(this._hsv);}
colorString(){if(this._colorString)
return this._colorString;var cf=Common.Color.Format;var color=this._color();var colorString=color.asString(this._colorFormat);if(colorString)
return colorString;if(this._colorFormat===cf.Nickname||this._colorFormat===cf.ShortHEX){colorString=color.asString(cf.HEX);if(colorString)
return colorString;}
console.assert(color.hasAlpha());return this._colorFormat===cf.HSL?(color.asString(cf.HSLA)):(color.asString(cf.RGBA));}
_updateHelperLocations(){var h=this._hsv[0];var s=this._hsv[1];var v=this._hsv[2];var alpha=this._hsv[3];var dragX=s*this.dragWidth;var dragY=this.dragHeight-(v*this.dragHeight);dragX=Math.max(-this._colorDragElementHeight,Math.min(this.dragWidth-this._colorDragElementHeight,dragX-this._colorDragElementHeight));dragY=Math.max(-this._colorDragElementHeight,Math.min(this.dragHeight-this._colorDragElementHeight,dragY-this._colorDragElementHeight));this._colorDragElement.positionAt(dragX,dragY);var hueSlideX=(1-h)*this._hueAlphaWidth-this.slideHelperWidth;this._hueSlider.style.left=hueSlideX+'px';var alphaSlideX=alpha*this._hueAlphaWidth-this.slideHelperWidth;this._alphaSlider.style.left=alphaSlideX+'px';}
_updateInput(){var cf=Common.Color.Format;if(this._colorFormat===cf.HEX||this._colorFormat===cf.ShortHEX||this._colorFormat===cf.Nickname){this._hexContainer.hidden=false;this._displayContainer.hidden=true;if(this._colorFormat===cf.ShortHEX&&this._color().canBeShortHex())
this._hexValue.value=this._color().asString(cf.ShortHEX);else
this._hexValue.value=this._color().asString(cf.HEX);}else{this._hexContainer.hidden=true;this._displayContainer.hidden=false;var isRgb=this._colorFormat===cf.RGB;this._textLabels.textContent=isRgb?'RGBA':'HSLA';var colorValues=isRgb?this._color().canonicalRGBA():this._color().canonicalHSLA();for(var i=0;i<3;++i){this._textValues[i].value=colorValues[i];if(!isRgb&&(i===1||i===2))
this._textValues[i].value+='%';}
this._textValues[3].value=Math.round(colorValues[3]*100)/100;}}
_drawContrastRatioLine(requiredContrast){if(!this._contrastColor||!this.dragWidth||!this.dragHeight)
return;var width=this.dragWidth;var height=this.dragHeight;var dS=0.02;var epsilon=0.002;var H=0;var S=1;var V=2;var A=3;var fgRGBA=[];Common.Color.hsva2rgba(this._hsv,fgRGBA);var fgLuminance=Common.Color.luminance(fgRGBA);var bgRGBA=this._contrastColor.rgba();var bgLuminance=Common.Color.luminance(bgRGBA);var fgIsLighter=fgLuminance>bgLuminance;var desiredLuminance=Common.Color.desiredLuminance(bgLuminance,requiredContrast,fgIsLighter);var lastV=this._hsv[V];var currentSlope=0;var candidateHSVA=[this._hsv[H],0,0,this._hsv[A]];var pathBuilder=[];var candidateRGBA=[];Common.Color.hsva2rgba(candidateHSVA,candidateRGBA);var blendedRGBA=[];Common.Color.blendColors(candidateRGBA,bgRGBA,blendedRGBA);function approach(index,x,onAxis){while(0<=x&&x<=1){candidateHSVA[index]=x;Common.Color.hsva2rgba(candidateHSVA,candidateRGBA);Common.Color.blendColors(candidateRGBA,bgRGBA,blendedRGBA);var fgLuminance=Common.Color.luminance(blendedRGBA);var dLuminance=fgLuminance-desiredLuminance;if(Math.abs(dLuminance)<(onAxis?epsilon/10:epsilon))
return x;else
x+=(index===V?-dLuminance:dLuminance);}
return null;}
for(var s=0;s<1+dS;s+=dS){s=Math.min(1,s);candidateHSVA[S]=s;var v=lastV;v=lastV+currentSlope*dS;v=approach(V,v,s===0);if(v===null)
break;currentSlope=(v-lastV)/dS;pathBuilder.push(pathBuilder.length?'L':'M');pathBuilder.push(s*width);pathBuilder.push((1-v)*height);}
if(s<1+dS){s-=dS;candidateHSVA[V]=1;s=approach(S,s,true);if(s!==null)
pathBuilder=pathBuilder.concat(['L',s*width,-1]);}
this._contrastRatioLine.setAttribute('d',pathBuilder.join(' '));}
_updateUI(){var h=Common.Color.fromHSVA([this._hsv[0],1,1,1]);this._colorElement.style.backgroundColor=(h.asString(Common.Color.Format.RGB));if(Runtime.experiments.isEnabled('colorContrastRatio')){this._drawContrastRatioLine(4.5);}
this._swatchInnerElement.style.backgroundColor=(this._color().asString(Common.Color.Format.RGBA));this._swatchInnerElement.classList.toggle('swatch-inner-white',this._color().hsla()[2]>0.9);this._colorDragElement.style.backgroundColor=(this._color().asString(Common.Color.Format.RGBA));var noAlpha=Common.Color.fromHSVA(this._hsv.slice(0,3).concat(1));this._alphaElementBackground.style.backgroundImage=String.sprintf('linear-gradient(to right, rgba(0,0,0,0), %s)',noAlpha.asString(Common.Color.Format.RGB));}
_formatViewSwitch(){var cf=Common.Color.Format;var format=cf.RGB;if(this._colorFormat===cf.RGB)
format=cf.HSL;else if(this._colorFormat===cf.HSL&&!this._color().hasAlpha())
format=this._originalFormat===cf.ShortHEX?cf.ShortHEX:cf.HEX;this._innerSetColor(undefined,'',format,ColorPicker.Spectrum._ChangeSource.Other);}
_inputChanged(event){function elementValue(element){return element.value;}
var inputElement=(event.currentTarget);var newValue=UI.createReplacementString(inputElement.value,event);if(newValue){inputElement.value=newValue;inputElement.selectionStart=0;inputElement.selectionEnd=newValue.length;event.consume(true);}
const cf=Common.Color.Format;var colorString;if(this._colorFormat===cf.HEX||this._colorFormat===cf.ShortHEX){colorString=this._hexValue.value;}else{var format=this._colorFormat===cf.RGB?'rgba':'hsla';var values=this._textValues.map(elementValue).join(', ');colorString=String.sprintf('%s(%s)',format,values);}
var color=Common.Color.parse(colorString);if(!color)
return;var hsv=color.hsva();if(this._colorFormat===cf.HEX||this._colorFormat===cf.ShortHEX)
this._colorFormat=color.canBeShortHex()?cf.ShortHEX:cf.HEX;this._innerSetColor(hsv,colorString,undefined,ColorPicker.Spectrum._ChangeSource.Input);}
wasShown(){this._hueAlphaWidth=this._hueElement.offsetWidth;this.slideHelperWidth=this._hueSlider.offsetWidth/2;this.dragWidth=this._colorElement.offsetWidth;this.dragHeight=this._colorElement.offsetHeight;this._colorDragElementHeight=this._colorDragElement.offsetHeight/2;this._innerSetColor(undefined,undefined,undefined,ColorPicker.Spectrum._ChangeSource.Model);this._toggleColorPicker(true);}
willHide(){this._toggleColorPicker(false);}
_toggleColorPicker(enabled,event){if(enabled===undefined)
enabled=!this._colorPickerButton.toggled();this._colorPickerButton.setToggled(enabled);InspectorFrontendHost.setEyeDropperActive(enabled);if(enabled){InspectorFrontendHost.events.addEventListener(InspectorFrontendHostAPI.Events.EyeDropperPickedColor,this._colorPickedBound);}else{InspectorFrontendHost.events.removeEventListener(InspectorFrontendHostAPI.Events.EyeDropperPickedColor,this._colorPickedBound);}}
_colorPicked(event){var rgbColor=(event.data);var rgba=[rgbColor.r,rgbColor.g,rgbColor.b,(rgbColor.a/2.55|0)/100];var color=Common.Color.fromRGBA(rgba);this._innerSetColor(color.hsva(),'',undefined,ColorPicker.Spectrum._ChangeSource.Other);InspectorFrontendHost.bringToFront();}};ColorPicker.Spectrum._ChangeSource={Input:'Input',Model:'Model',Other:'Other'};ColorPicker.Spectrum.Events={ColorChanged:Symbol('ColorChanged'),SizeChanged:Symbol('SizeChanged')};ColorPicker.Spectrum._colorChipSize=24;ColorPicker.Spectrum._itemsPerPaletteRow=8;ColorPicker.Spectrum.Palette;ColorPicker.Spectrum.GeneratedPaletteTitle='Page colors';ColorPicker.Spectrum.PaletteGenerator=class{constructor(callback){this._callback=callback;this._frequencyMap=new Map();var stylesheetPromises=[];for(var cssModel of SDK.targetManager.models(SDK.CSSModel)){for(var stylesheet of cssModel.allStyleSheets())
stylesheetPromises.push(new Promise(this._processStylesheet.bind(this,stylesheet)));}
Promise.all(stylesheetPromises).catchException(null).then(this._finish.bind(this));}
_frequencyComparator(a,b){return this._frequencyMap.get(b)-this._frequencyMap.get(a);}
_finish(){function hueComparator(a,b){var hsva=paletteColors.get(a).hsva();var hsvb=paletteColors.get(b).hsva();if(hsvb[1]<0.12&&hsva[1]<0.12)
return hsvb[2]*hsvb[3]-hsva[2]*hsva[3];if(hsvb[1]<0.12)
return-1;if(hsva[1]<0.12)
return 1;if(hsvb[0]===hsva[0])
return hsvb[1]*hsvb[3]-hsva[1]*hsva[3];return(hsvb[0]+0.94)%1-(hsva[0]+0.94)%1;}
var colors=this._frequencyMap.keysArray();colors=colors.sort(this._frequencyComparator.bind(this));var paletteColors=new Map();var colorsPerRow=24;while(paletteColors.size<colorsPerRow&&colors.length){var colorText=colors.shift();var color=Common.Color.parse(colorText);if(!color||color.nickname()==='white'||color.nickname()==='black')
continue;paletteColors.set(colorText,color);}
this._callback({title:ColorPicker.Spectrum.GeneratedPaletteTitle,colors:paletteColors.keysArray().sort(hueComparator),mutable:false});}
_processStylesheet(stylesheet,resolve){function parseContent(text){text=text.toLowerCase();var regexResult=text.match(/((?:rgb|hsl)a?\([^)]+\)|#[0-9a-f]{6}|#[0-9a-f]{3})/g)||[];for(var c of regexResult){var frequency=this._frequencyMap.get(c)||0;this._frequencyMap.set(c,++frequency);}
resolve(null);}
stylesheet.requestContent().then(parseContent.bind(this));}};ColorPicker.Spectrum.MaterialPaletteShades={'#F44336':['#FFEBEE','#FFCDD2','#EF9A9A','#E57373','#EF5350','#F44336','#E53935','#D32F2F','#C62828','#B71C1C'],'#E91E63':['#FCE4EC','#F8BBD0','#F48FB1','#F06292','#EC407A','#E91E63','#D81B60','#C2185B','#AD1457','#880E4F'],'#9C27B0':['#F3E5F5','#E1BEE7','#CE93D8','#BA68C8','#AB47BC','#9C27B0','#8E24AA','#7B1FA2','#6A1B9A','#4A148C'],'#673AB7':['#EDE7F6','#D1C4E9','#B39DDB','#9575CD','#7E57C2','#673AB7','#5E35B1','#512DA8','#4527A0','#311B92'],'#3F51B5':['#E8EAF6','#C5CAE9','#9FA8DA','#7986CB','#5C6BC0','#3F51B5','#3949AB','#303F9F','#283593','#1A237E'],'#2196F3':['#E3F2FD','#BBDEFB','#90CAF9','#64B5F6','#42A5F5','#2196F3','#1E88E5','#1976D2','#1565C0','#0D47A1'],'#03A9F4':['#E1F5FE','#B3E5FC','#81D4FA','#4FC3F7','#29B6F6','#03A9F4','#039BE5','#0288D1','#0277BD','#01579B'],'#00BCD4':['#E0F7FA','#B2EBF2','#80DEEA','#4DD0E1','#26C6DA','#00BCD4','#00ACC1','#0097A7','#00838F','#006064'],'#009688':['#E0F2F1','#B2DFDB','#80CBC4','#4DB6AC','#26A69A','#009688','#00897B','#00796B','#00695C','#004D40'],'#4CAF50':['#E8F5E9','#C8E6C9','#A5D6A7','#81C784','#66BB6A','#4CAF50','#43A047','#388E3C','#2E7D32','#1B5E20'],'#8BC34A':['#F1F8E9','#DCEDC8','#C5E1A5','#AED581','#9CCC65','#8BC34A','#7CB342','#689F38','#558B2F','#33691E'],'#CDDC39':['#F9FBE7','#F0F4C3','#E6EE9C','#DCE775','#D4E157','#CDDC39','#C0CA33','#AFB42B','#9E9D24','#827717'],'#FFEB3B':['#FFFDE7','#FFF9C4','#FFF59D','#FFF176','#FFEE58','#FFEB3B','#FDD835','#FBC02D','#F9A825','#F57F17'],'#FFC107':['#FFF8E1','#FFECB3','#FFE082','#FFD54F','#FFCA28','#FFC107','#FFB300','#FFA000','#FF8F00','#FF6F00'],'#FF9800':['#FFF3E0','#FFE0B2','#FFCC80','#FFB74D','#FFA726','#FF9800','#FB8C00','#F57C00','#EF6C00','#E65100'],'#FF5722':['#FBE9E7','#FFCCBC','#FFAB91','#FF8A65','#FF7043','#FF5722','#F4511E','#E64A19','#D84315','#BF360C'],'#795548':['#EFEBE9','#D7CCC8','#BCAAA4','#A1887F','#8D6E63','#795548','#6D4C41','#5D4037','#4E342E','#3E2723'],'#9E9E9E':['#FAFAFA','#F5F5F5','#EEEEEE','#E0E0E0','#BDBDBD','#9E9E9E','#757575','#616161','#424242','#212121'],'#607D8B':['#ECEFF1','#CFD8DC','#B0BEC5','#90A4AE','#78909C','#607D8B','#546E7A','#455A64','#37474F','#263238']};ColorPicker.Spectrum.MaterialPalette={title:'Material',mutable:false,matchUserFormat:true,colors:Object.keys(ColorPicker.Spectrum.MaterialPaletteShades)};;Runtime.cachedResources["color_picker/spectrum.css"]="/* https://github.com/bgrins/spectrum */\n:host {\n    width: 232px;\n    height: 240px;\n    -webkit-user-select: none;\n    overflow: hidden;\n}\n\n:host-context(.palettes-enabled) {\n    height: 319px;\n}\n\n.spectrum-color {\n    position: relative;\n    width: 232px;\n    height: 124px;\n    border-radius: 2px 2px 0 0;\n    overflow: hidden;\n}\n\n.spectrum-display-value {\n    -webkit-user-select: text;\n    display: inline-block;\n    padding-left: 2px;\n}\n\n.spectrum-hue {\n    top: 140px;\n}\n\n.spectrum-alpha {\n    top: 159px;\n    background-image: url(Images/checker.png);\n    background-size: 12px 11px;\n}\n\n.spectrum-alpha-background {\n    height: 100%;\n    border-radius: 2px;\n}\n\n.spectrum-hue, .spectrum-alpha {\n    position: absolute;\n    right: 16px;\n    width: 130px;\n    height: 11px;\n    border-radius: 2px;\n}\n\n.spectrum-dragger,\n.spectrum-slider {\n    -webkit-user-select: none;\n}\n\n.spectrum-sat,\n.-theme-preserve {\n    background-image: linear-gradient(to right, white, rgba(204, 154, 129, 0));\n}\n\n.spectrum-val,\n.-theme-preserve {\n    background-image: linear-gradient(to top, black, rgba(204, 154, 129, 0));\n}\n\n.spectrum-hue {\n    background: linear-gradient(to left, #ff0000 0%, #ffff00 17%, #00ff00 33%, #00ffff 50%, #0000ff 67%, #ff00ff 83%, #ff0000 100%);\n}\n\n.spectrum-dragger {\n    border-radius: 12px;\n    height: 12px;\n    width: 12px;\n    border: 1px solid white;\n    cursor: pointer;\n    position: absolute;\n    top: 0;\n    left: 0;\n    background: black;\n    box-shadow: 0 0 2px 0px rgba(0, 0, 0, 0.24);\n}\n\n.spectrum-slider {\n    position: absolute;\n    top: -1px;\n    cursor: pointer;\n    width: 13px;\n    height: 13px;\n    border-radius: 13px;\n    background-color: rgb(248, 248, 248);\n    box-shadow: 0 1px 4px 0 rgba(0, 0, 0, 0.37);\n}\n\n.swatch {\n    width: 32px;\n    height: 32px;\n    margin: 0;\n    position: absolute;\n    top: 139px;\n    left: 44px;\n    background-image: url(Images/checker.png);\n    border-radius: 16px;\n}\n\n.swatch-inner,\n.swatch-overlay {\n    position: absolute;\n    width: 100%;\n    height: 100%;\n    display: inline-block;\n    border-radius: 16px;\n}\n\n.swatch-inner-white {\n    border: 1px solid #ddd;\n}\n\n.swatch-overlay {\n    cursor: pointer;\n    opacity: 0;\n    padding: 4px;\n}\n\n.swatch-overlay:hover {\n    background-color: rgba(0, 0, 0, .3);\n    opacity: 1;\n}\n\n.swatch-overlay:active {\n    background-color: rgba(0, 0, 0, .5);\n}\n\n.copy-color-icon {\n    background-color: white;\n}\n\n.spectrum-text {\n    position: absolute;\n    top: 184px;\n    left: 16px;\n}\n\n.spectrum-text-value {\n    display: inline-block;\n    width: 40px;\n    overflow: hidden;\n    text-align: center;\n    border: 1px solid #dadada;\n    border-radius: 2px;\n    margin-right: 6px;\n    line-height: 20px;\n    padding: 0;\n    color: #333;\n    white-space: nowrap;\n}\n\n.spectrum-text-label {\n    letter-spacing: 39.5px;\n    margin-top: 8px;\n    display: block;\n    color: #969696;\n    margin-left: 16px;\n    width: 174px;\n}\n\n.spectrum-text-hex > .spectrum-text-value {\n    width: 178px;\n}\n\n.spectrum-text-hex > .spectrum-text-label {\n    letter-spacing: normal;\n    margin-left: 0px;\n    text-align: center;\n}\n\n.spectrum-palette-value {\n    background-color: rgb(65, 75, 217);\n    border-radius: 2px;\n    margin-top: 12px;\n    margin-left: 12px;\n    width: 12px;\n    height: 12px;\n    display: inline-block;\n}\n\n.spectrum-switcher {\n    border-radius: 2px;\n    height: 20px;\n    width: 20px;\n    padding: 2px;\n}\n\n:host-context(.-theme-with-dark-background) .spectrum-switcher {\n    -webkit-filter: invert(60%);\n}\n\n.spectrum-display-switcher {\n    top: 196px;\n    position: absolute;\n    right: 10px;\n}\n\n.spectrum-switcher:hover {\n    background-color: #EEEEEE;\n}\n\n.spectrum-eye-dropper {\n    width: 32px;\n    height: 24px;\n    position: absolute;\n    left: 8px;\n    top: 141px;\n    cursor: pointer;\n}\n\n.spectrum-palette {\n    border-top: 1px solid #dadada;\n    position: absolute;\n    top: 235px;\n    width: 100%;\n    padding: 6px 24px 6px 6px;\n    display: flex;\n    flex-wrap: wrap;\n}\n\n.spectrum-palette-color {\n    width: 12px;\n    height: 12px;\n    flex: 0 0 12px;\n    border-radius: 2px;\n    margin: 6px;\n    cursor: pointer;\n    position: relative;\n    border: 1px solid rgba(0, 0, 0, 0.1);\n    background-position: -1px !important;\n}\n\n.spectrum-palette-color:hover:not(.spectrum-shades-shown) > .spectrum-palette-color-shadow {\n    opacity: 0.2;\n}\n\n.spectrum-palette-color:hover:not(.spectrum-shades-shown) > .spectrum-palette-color-shadow:first-child {\n    opacity: 0.6;\n    top: -3px;\n    left: 1px;\n}\n\n.spectrum-palette-color-shadow {\n    position: absolute;\n    opacity: 0;\n    margin: 0;\n    top: -5px;\n    left: 3px;\n}\n\n.palette-color-shades {\n    position: absolute;\n    background-color: white;\n    height: 228px;\n    width: 28px;\n    box-shadow: 0 4px 5px 0 rgba(0, 0, 0, 0.14), 0 1px 10px 0 rgba(0, 0, 0, 0.12), 0 2px 4px -1px rgba(0, 0, 0, 0.4);\n    z-index: 14;\n    border-radius: 2px;\n    transform-origin: 0px 228px;\n    margin-top: -208px;\n    margin-left: -8px;\n}\n\n.spectrum-palette > .spectrum-palette-color.spectrum-shades-shown {\n    z-index: 15;\n}\n\n.palette-color-shades > .spectrum-palette-color {\n    margin: 8px 0 0 0;\n    margin-left: 8px;\n    width: 12px;\n}\n\n.spectrum-palette > .spectrum-palette-color {\n    transition: transform 100ms cubic-bezier(0, 0, 0.2, 1);\n    will-change: transform;\n    z-index: 13;\n}\n\n.spectrum-palette > .spectrum-palette-color.empty-color {\n    border-color: transparent;\n}\n\n.spectrum-palette > .spectrum-palette-color:not(.empty-color):not(.has-material-shades):hover,\n.palette-color-shades > .spectrum-palette-color:not(.empty-color):hover {\n    transform: scale(1.15);\n}\n\n.add-color-toolbar {\n    margin-left: -3px;\n    margin-top: -1px;\n}\n\n.spectrum-palette-switcher {\n    right: 10px;\n    top: 235px;\n    margin-top: 9px;\n    position: absolute;\n}\n\n.palette-panel {\n    width: 100%;\n    height: 100%;\n    position: absolute;\n    top: 100%;\n    display: flex;\n    flex-direction: column;\n    background-color: white;\n    z-index: 14;\n    transition: transform 200ms cubic-bezier(0, 0, 0.2, 1), visibility 0s 200ms;\n    border-top: 1px solid #dadada;\n    visibility: hidden;\n}\n\n.palette-panel-showing > .palette-panel {\n    transform: translateY(calc(-100% + 117px));\n    transition-delay: 0s;\n    visibility: visible;\n}\n\n.palette-panel > div.toolbar {\n    position: absolute;\n    right: 6px;\n    top: 6px;\n}\n\n.palette-panel > div:not(.toolbar) {\n    flex: 0 0 38px;\n    border-bottom: 1px solid #dadada;\n    padding: 12px;\n    line-height: 14px;\n    color: #333;\n}\n\n.palette-panel > div.palette-title {\n    font-size: 14px;\n    line-height: 16px;\n    color: #333;\n    flex-basis: 40px;\n}\n\ndiv.palette-preview {\n    display: flex;\n    cursor: pointer;\n}\n\n.palette-preview-title {\n    flex: 0 0 84px;\n}\n\n.palette-preview > .spectrum-palette-color {\n    margin-top: 1px;\n}\n\n.palette-preview:hover {\n    background-color: #eee;\n}\n\n.spectrum-overlay {\n    z-index: 13;\n    visibility: hidden;\n    background-color: hsla(0, 0%, 0%, 0.5);\n    opacity: 0;\n    transition: opacity 100ms cubic-bezier(0, 0, 0.2, 1), visibility 0s 100ms;\n}\n\n.palette-panel-showing > .spectrum-overlay {\n    transition-delay: 0s;\n    visibility: visible;\n    opacity: 1;\n}\n\n.spectrum-contrast-container {\n    width: 100%;\n    height: 100%;\n}\n\n.spectrum-contrast-line {\n    fill: none;\n    stroke: white;\n    opacity: 0.7;\n    stroke-width: 1.5px;\n}\n\n.delete-color-toolbar {\n    position: absolute;\n    right: 0;\n    top: 0;\n    background-color: #EFEFEF;\n    visibility: hidden;\n    z-index: 3;\n    width: 36px;\n    display: flex;\n    align-items: center;\n    padding-left: 4px;\n    bottom: 2px;\n    border-bottom-right-radius: 2px;\n}\n\n@keyframes showDeleteToolbar {\n    from {\n        opacity: 0;\n    }\n    to {\n        opacity: 1;\n    }\n}\n\n.delete-color-toolbar.dragging {\n    visibility: visible;\n    animation: showDeleteToolbar 100ms 150ms cubic-bezier(0, 0, 0.2, 1) backwards;\n}\n\n.delete-color-toolbar-active {\n    background-color: #ddd;\n    color: white;\n}\n\n/*# sourceURL=color_picker/spectrum.css */";