ProductRegistry.BadgePool=class{constructor(forceShow){this._showTitles=false;this._badgeElements=new Map();if(!forceShow){this._setting=Common.settings.moduleSetting('product_registry.badges-visible');this._setting.addChangeListener(this._settingUpdated.bind(this));}}
setShowTitles(value){this._showTitles=value;}
badgeForFrame(frame){return this._badgeForFrameOrUrl(this._resolveUrl.bind(this,frame));}
badgeForURL(parsedUrl){return this._badgeForFrameOrUrl(()=>Promise.resolve(parsedUrl));}
reset(){this._badgeElements.clear();}
_badgeForFrameOrUrl(urlResolver){var element=createElementWithClass('span','hidden');var root=UI.createShadowRootWithCoreStyles(element,'product_registry/badge.css');var badgeElement=root.createChild('span');badgeElement.classList.toggle('hide-badge-title',!this._showTitles);badgeElement.addEventListener('mousedown',event=>event.consume());badgeElement.addEventListener('click',event=>{this._showPopup(badgeElement);event.consume();},false);this._badgeElements.set(badgeElement,urlResolver);this._renderBadge(badgeElement);return element;}
async _resolveUrl(frame){var registry=await ProductRegistry.instance();var parsedUrl=new Common.ParsedURL(frame.url);var entry=registry.entryForUrl(parsedUrl);if(!entry){frame.findCreationCallFrame(callFrame=>{if(!callFrame.url)
return false;parsedUrl=new Common.ParsedURL(callFrame.url);return!!registry.entryForUrl(parsedUrl);});}
return parsedUrl;}
async _renderBadge(badgeElement){if(badgeElement.children.length||!this._isVisible(badgeElement)){this._updateBadgeElementVisibility(badgeElement);return;}
var parsedUrl=await this._badgeElements.get(badgeElement)();var registry=await ProductRegistry.instance();var entryName=parsedUrl&&registry.nameForUrl(parsedUrl);if(!entryName)
return;var tokens=entryName.replace(/[a-z]*/g,'').split(' ');var label;if(tokens.length>1)
label=tokens[0][0]+tokens[1][0];else
label=entryName;var iconElement=badgeElement.createChild('span','product-registry-badge monospace');iconElement.setAttribute('data-initial',label.substring(0,2).toUpperCase());iconElement.title=entryName;iconElement.style.backgroundColor=ProductRegistry.BadgePool.colorForEntryName(entryName);badgeElement.createChild('span','product-registry-badge-title').textContent=entryName;this._updateBadgeElementVisibility(badgeElement);}
_settingUpdated(){for(var badgeElement of this._badgeElements.keys())
this._renderBadge(badgeElement);}
_isVisible(badgeElement){return!this._setting||this._setting.get();}
_updateBadgeElementVisibility(badgeElement){badgeElement.parentNodeOrShadowHost().parentNodeOrShadowHost().classList.toggle('hidden',!this._isVisible(badgeElement));}
async _showPopup(badgeElement){if(!this._badgeElements.has(badgeElement))
return;var registry=await ProductRegistry.instance();var parsedUrl=await this._badgeElements.get(badgeElement)();var entryName=registry.nameForUrl(parsedUrl);var element=createElement('div');var root=UI.createShadowRootWithCoreStyles(element,'product_registry/popup.css');var popupElement=root.createChild('div','product-registry-popup');var domainElement=popupElement.createChild('div','product-registry-domain');domainElement.textContent=parsedUrl.domain();var entryNameElement=popupElement.createChild('div','product-registry-name');entryNameElement.textContent=entryName;var reportLink='https://docs.google.com/forms/d/e/1FAIpQLSchz2FdcQ-rRllzl8BbhWaTRRY-12BpPjW6Hr9e1-BpCA083w/viewform'+'?entry_1425918171='+encodeURIComponent((parsedUrl.domain()+parsedUrl.path).substr(0,100));popupElement.appendChild(UI.createExternalLink(reportLink,'Report mismatch','product-registry-link'));var dialog=new UI.Dialog();dialog.setContentAnchorBox(badgeElement.boxInWindow());dialog.contentElement.appendChild(element);dialog.setSizeBehavior(UI.GlassPane.SizeBehavior.MeasureContent);dialog.setAnchorBehavior(UI.GlassPane.AnchorBehavior.PreferTop);dialog.addCloseButton();dialog.show((badgeElement.ownerDocument));}
static colorForEntryName(entryName){if(!ProductRegistry.BadgePool._colorGenerator){ProductRegistry.BadgePool._colorGenerator=new Common.Color.Generator({min:30,max:330},{min:50,max:80,count:3},80);}
return ProductRegistry.BadgePool._colorGenerator.colorForID(entryName);}};;ProductRegistry.instance=function(){var extension=self.runtime.extension(ProductRegistry.Registry);if(extension)
return extension.instance();return Promise.resolve(self.singleton(ProductRegistry.RegistryStub));};ProductRegistry.Registry=function(){};ProductRegistry.Registry.prototype={nameForUrl:function(parsedUrl){},entryForUrl:function(parsedUrl){},typeForUrl:function(parsedUrl){}};ProductRegistry.RegistryStub=class{nameForUrl(parsedUrl){return null;}
entryForUrl(parsedUrl){return null;}
typeForUrl(parsedUrl){return null;}};ProductRegistry.Registry.ProductEntry;;Runtime.cachedResources["product_registry/badge.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.product-registry-badge {\n  background-color: rgba(0, 0, 0, 0.2);\n  border-radius: 2px;\n  padding: 1px 2px;\n  white-space: pre;\n  cursor: pointer;\n}\n\n.product-registry-badge::before {\n  content: attr(data-initial);\n  color: #222;\n}\n\n.hide-badge-title .product-registry-badge-title {\n  display: none;\n}\n\n.product-registry-badge-title {\n  padding-left: 4px;\n}\n/*# sourceURL=product_registry/badge.css */";Runtime.cachedResources["product_registry/popup.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.product-registry-popup {\n    background-color: white;\n    padding: 15px 45px 15px 15px;\n    border-radius: 4px;\n    white-space: nowrap;\n    box-shadow: 0px 1px 2px 0px gray;\n}\n\n.product-registry-domain {\n    font-weight: bold;\n}\n\n.product-registry-name {\n    padding: 10px 0;\n}\n\n.product-registry-link {\n    display: block;\n}\n\ndiv[is=dt-close-button] {\n  position: absolute;\n  top: 5px;\n  right: 5px;\n}\n\n/*# sourceURL=product_registry/popup.css */";