require=function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f;}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e);},l,l.exports,e,t,n,r);}return n[o].exports;}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s;}({"../audits/accessibility/accesskeys":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Accesskeys extends AxeAudit{static get meta(){return{category:'Accessibility',name:'accesskeys',description:'`[accesskey]` values are unique.',helpText:'`accesskey` attributes allow the user to quickly activate or focus part '+'of the page.'+'Using the same `accesskey` more than once could lead to a confusing experience.',requiredArtifacts:['Accessibility']};}}
module.exports=Accesskeys;},{"./axe-audit":1}],"../audits/accessibility/aria-allowed-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAAllowedAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-allowed-attr',description:'`[aria-*]` attributes match their roles.',helpText:'Each ARIA `role` supports a specific subset of `aria-*` attributes. '+'Mismatching these invalidates the `aria-*` attributes. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/aria-allowed-attributes).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAAllowedAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-required-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIARequiredAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-required-attr',description:'`[role]`s have all required `[aria-*]` attributes.',helpText:'Some ARIA roles have required attributes that describe the state '+'of the element to screen readers. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/required-aria-attributes).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIARequiredAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-required-children":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRequiredChildren extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-required-children',description:'`[role]`s that require child `[role]`s contain them.',helpText:'Some ARIA parent roles require specific roles on their children to perform '+'their accessibility function.',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRequiredChildren;},{"./axe-audit":1}],"../audits/accessibility/aria-required-parent":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRequiredParent extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-required-parent',description:'`[role]`s are contained by their required parent element.',helpText:'Some ARIA roles require specific roles on their parent element to perform '+'their accessibility function.',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRequiredParent;},{"./axe-audit":1}],"../audits/accessibility/aria-roles":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRoles extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-roles',description:'`[role]` values are valid.',helpText:'ARIA roles require specific values to perform their accessibility function.',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRoles;},{"./axe-audit":1}],"../audits/accessibility/aria-valid-attr-value":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-valid-attr-value',description:'`[aria-*]` attributes have valid values.',helpText:'Assistive technologies, like screen readers, can\'t interpret ARIA '+'attributes with invalid values. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/valid-aria-values).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-valid-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'aria-valid-attr',description:'`[aria-*]` attributes are valid and not misspelled.',helpText:'Assistive technologies, like screen readers, can\'t interpret ARIA '+'attributes with invalid names. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/valid-aria-attributes).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":1}],"../audits/accessibility/audio-caption":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AudioCaption extends AxeAudit{static get meta(){return{category:'Accessibility',name:'audio-caption',description:'`<audio>` elements contain a `<track>` element with `[kind="captions"]`.',helpText:'Captions convey information such as identifying who is speaking, dialogue, and '+'non-speech information. This can help deaf or hearing impaired users access '+'meaningful content.',requiredArtifacts:['Accessibility']};}}
module.exports=AudioCaption;},{"./axe-audit":1}],"../audits/accessibility/button-name":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ButtonName extends AxeAudit{static get meta(){return{category:'Accessibility',name:'button-name',description:'Buttons have an accessible name.',helpText:'When a button doesn\'t have an accessible name, screen readers announce it as '+'"button", making it unusable for users who rely on screen readers. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/button-name).',requiredArtifacts:['Accessibility']};}}
module.exports=ButtonName;},{"./axe-audit":1}],"../audits/accessibility/bypass":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Bypass extends AxeAudit{static get meta(){return{category:'Accessibility',name:'bypass',description:'The page contains a heading, skip link, or landmark region.',helpText:'Adding ways to bypass repetitive content lets keyboard users navigate the page '+'more efficiently.',requiredArtifacts:['Accessibility']};}}
module.exports=Bypass;},{"./axe-audit":1}],"../audits/accessibility/color-contrast":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ColorContrast extends AxeAudit{static get meta(){return{category:'Accessibility',name:'color-contrast',description:'Background and foreground colors have a sufficient contrast ratio.',helpText:'Low-contrast text is difficult or impossible for many users to read. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/contrast-ratio).',requiredArtifacts:['Accessibility']};}}
module.exports=ColorContrast;},{"./axe-audit":1}],"../audits/accessibility/definition-list":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DefinitionList extends AxeAudit{static get meta(){return{category:'Accessibility',name:'definition-list',description:'`<dl>`\'s contain only properly-ordered `<dt>` and `<dd>` groups, `<script>` '+'or <template> elements.',helpText:'When definition lists are not properly marked up screen readers may produce '+'confusing or inaccurate output.',requiredArtifacts:['Accessibility']};}}
module.exports=DefinitionList;},{"./axe-audit":1}],"../audits/accessibility/dlitem":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DLItem extends AxeAudit{static get meta(){return{category:'Accessibility',name:'dlitem',description:'Definition list items are wrapped in `<dl>` elements.',helpText:'Definition list items (<dt> and/or <dd>) wrapped in parent <dl> elements enable '+'screen readers to properly announce content.',requiredArtifacts:['Accessibility']};}}
module.exports=DLItem;},{"./axe-audit":1}],"../audits/accessibility/document-title":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DocumentTitle extends AxeAudit{static get meta(){return{category:'Accessibility',name:'document-title',description:'Document has a `<title>` element.',helpText:'Screen reader users use page titles to get an overview of the contents of '+'the page.',requiredArtifacts:['Accessibility']};}}
module.exports=DocumentTitle;},{"./axe-audit":1}],"../audits/accessibility/duplicate-id":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DuplicateId extends AxeAudit{static get meta(){return{category:'Accessibility',name:'duplicate-id',description:'`[id]` attributes on the page are unique.',helpText:'Unique `id=""` attributes help ensure assistive technologies do not overlook '+'elements with the same id.',requiredArtifacts:['Accessibility']};}}
module.exports=DuplicateId;},{"./axe-audit":1}],"../audits/accessibility/frame-title":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class FrameTitle extends AxeAudit{static get meta(){return{category:'Accessibility',name:'frame-title',description:'`<frame>` or `<iframe>` elements have a title.',helpText:'Screen reader users rely on a frame title to describe the contents of the frame.',requiredArtifacts:['Accessibility']};}}
module.exports=FrameTitle;},{"./axe-audit":1}],"../audits/accessibility/html-has-lang":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class HTMLHasLang extends AxeAudit{static get meta(){return{category:'Accessibility',name:'html-has-lang',description:'`<html>` element has a `[lang]` attribute.',helpText:'The `lang` attribute is useful for multilingual screen reader users who may '+'prefer a language other than the default.',requiredArtifacts:['Accessibility']};}}
module.exports=HTMLHasLang;},{"./axe-audit":1}],"../audits/accessibility/html-lang-valid":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class HTMLLangValid extends AxeAudit{static get meta(){return{category:'Accessibility',name:'html-lang-valid',description:'`<html>` element has a valid value for its `[lang]` attribute.',helpText:'Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) '+'helps screen readers announce text properly.',requiredArtifacts:['Accessibility']};}}
module.exports=HTMLLangValid;},{"./axe-audit":1}],"../audits/accessibility/image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ImageAlt extends AxeAudit{static get meta(){return{category:'Accessibility',name:'image-alt',description:'Image elements have `[alt]` attributes.',helpText:'Informative elements should aim for short, descriptive alternate text. '+'Decorative elements can be ignored with an empty alt attribute.'+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/alt-attribute).',requiredArtifacts:['Accessibility']};}}
module.exports=ImageAlt;},{"./axe-audit":1}],"../audits/accessibility/input-image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class InputImageAlt extends AxeAudit{static get meta(){return{category:'Accessibility',name:'input-image-alt',description:'`<input type="image">` elements have `[alt]` text.',helpText:'When an image is being used as an `<input>` button, providing alternative text '+'can help screen reader users understand the purpose of the button.',requiredArtifacts:['Accessibility']};}}
module.exports=InputImageAlt;},{"./axe-audit":1}],"../audits/accessibility/label":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Label extends AxeAudit{static get meta(){return{category:'Accessibility',name:'label',description:'Form elements have associated labels.',helpText:'Labels ensure that form controls are announced properly by assistive '+'technologies, like screen readers. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/form-labels).',requiredArtifacts:['Accessibility']};}}
module.exports=Label;},{"./axe-audit":1}],"../audits/accessibility/layout-table":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class LayoutTable extends AxeAudit{static get meta(){return{category:'Accessibility',name:'layout-table',description:'Presentational `<table>` elements avoid using `<th>`, `<caption>` or the '+'`[summary]` attribute.',helpText:'The presence of `<th>`, `<caption>` or the `summary` attribute on a '+'presentational table may produce a confusing experince for a screen reader user as '+'these elements usually indicates a data table.',requiredArtifacts:['Accessibility']};}}
module.exports=LayoutTable;},{"./axe-audit":1}],"../audits/accessibility/link-name":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class LinkName extends AxeAudit{static get meta(){return{category:'Accessibility',name:'link-name',description:'Links have a discernable name.',helpText:'Link text (and alternate text for images, when used as links) that is '+'discernible, not duplicated, and focusable improves the navigating experience for '+'screen reader users.',requiredArtifacts:['Accessibility']};}}
module.exports=LinkName;},{"./axe-audit":1}],"../audits/accessibility/listitem":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ListItem extends AxeAudit{static get meta(){return{category:'Accessibility',name:'listitem',description:'List items (`<li>`) are contained within `<ul>` or `<ol>` parent elements.',helpText:'Screen readers require list items (`<li>`) to be contained within a '+'parent `<ul>` or `<ol>` to be announced properly',requiredArtifacts:['Accessibility']};}}
module.exports=ListItem;},{"./axe-audit":1}],"../audits/accessibility/list":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class List extends AxeAudit{static get meta(){return{category:'Accessibility',name:'list',description:'Lists contain only `<li>` elements and script supporting elements '+'(`<script>` and `<template>`).',helpText:'Screen readers have a specific way of announcing lists. Ensuring proper list '+'structure aides screen reader output.',requiredArtifacts:['Accessibility']};}}
module.exports=List;},{"./axe-audit":1}],"../audits/accessibility/meta-refresh":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class MetaRefresh extends AxeAudit{static get meta(){return{category:'Accessibility',name:'meta-refresh',description:'The document does not use `<meta http-equiv="refresh">`.',helpText:'Users do not expect a page to refresh automatically, and doing so will move '+'focus back to the top of the page. This may create a frustrating or '+'confusing experience',requiredArtifacts:['Accessibility']};}}
module.exports=MetaRefresh;},{"./axe-audit":1}],"../audits/accessibility/meta-viewport":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class MetaViewport extends AxeAudit{static get meta(){return{category:'Accessibility',name:'meta-viewport',description:'`[user-scalable="no"]` is not used in the `<meta name="viewport">` '+'element and the `[maximum-scale]` attribute is not less than 5.',helpText:'Disabling zooming is problematic for users with low vision who rely on screen '+'magnification to properly see the contents of a web page.',requiredArtifacts:['Accessibility']};}}
module.exports=MetaViewport;},{"./axe-audit":1}],"../audits/accessibility/object-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ObjectAlt extends AxeAudit{static get meta(){return{category:'Accessibility',name:'object-alt',description:'`<object>` elements have `[alt]` text.',helpText:'Screen readers cannot translate non-text content. Adding alt text to `<object>` '+'elements will help a screen reader convey the meaning to a user.',requiredArtifacts:['Accessibility']};}}
module.exports=ObjectAlt;},{"./axe-audit":1}],"../audits/accessibility/tabindex":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TabIndex extends AxeAudit{static get meta(){return{category:'Accessibility',name:'tabindex',description:'No element has a `[tabindex]` value greater than 0.',helpText:'A value greater than 0 implies an explicit navigation ordering. '+'Although technically valid, this often creates frustrating experiences '+'for users who rely on assistive technologies. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/tabindex).',requiredArtifacts:['Accessibility']};}}
module.exports=TabIndex;},{"./axe-audit":1}],"../audits/accessibility/td-headers-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TDHeadersAttr extends AxeAudit{static get meta(){return{category:'Accessibility',name:'td-headers-attr',description:'Cells in a `<table>` element that use the `[headers]` attribute only refer '+'to other cells of that same table.',helpText:'Screen readers have features to make navigating tables easier. Ensuring `<td>` '+'cells using the `[headers]` attribute only refer to other cells in the same table may '+'improve the experience for screen reader users.',requiredArtifacts:['Accessibility']};}}
module.exports=TDHeadersAttr;},{"./axe-audit":1}],"../audits/accessibility/th-has-data-cells":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class THHasDataCells extends AxeAudit{static get meta(){return{category:'Accessibility',name:'th-has-data-cells',description:'`<th>` elements and elements with `[role="columnheader"/"rowheader"]` have '+'data cells they describe.',helpText:'Screen readers have features to make navigating tables easier. Ensuring table '+'headers always refer to some set of cells may improve the experience for screen '+'reader users.',requiredArtifacts:['Accessibility']};}}
module.exports=THHasDataCells;},{"./axe-audit":1}],"../audits/accessibility/valid-lang":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ValidLang extends AxeAudit{static get meta(){return{category:'Accessibility',name:'valid-lang',description:'`[lang]` attributes have a valid value.',helpText:'Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) '+'on elements helps ensure that text is pronounced correctly by a screen reader.',requiredArtifacts:['Accessibility']};}}
module.exports=ValidLang;},{"./axe-audit":1}],"../audits/accessibility/video-caption":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class VideoCaption extends AxeAudit{static get meta(){return{category:'Accessibility',name:'video-caption',description:'`<video>` elements contain a `<track>` element with `[kind="captions"]`.',helpText:'When a video provides a caption it is easier for deaf and hearing impaired '+'users to access its information.',requiredArtifacts:['Accessibility']};}}
module.exports=VideoCaption;},{"./axe-audit":1}],"../audits/accessibility/video-description":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class VideoDescription extends AxeAudit{static get meta(){return{category:'Accessibility',name:'video-description',description:'`<video>` elements contain a `<track>` element with `[kind="description"]`.',helpText:'Audio descriptions provide relevant information for videos that dialogue '+'cannot, such as facial expressions and scenes.',requiredArtifacts:['Accessibility']};}}
module.exports=VideoDescription;},{"./axe-audit":1}],"../audits/byte-efficiency/offscreen-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const ALLOWABLE_OFFSCREEN_X=100;const ALLOWABLE_OFFSCREEN_Y=200;const IGNORE_THRESHOLD_IN_BYTES=2048;const IGNORE_THRESHOLD_IN_PERCENT=75;class OffscreenImages extends ByteEfficiencyAudit{static get meta(){return{category:'Images',name:'offscreen-images',description:'Offscreen images',informative:true,helpText:'Images that are not above the fold should be lazily loaded after the page is '+'interactive. Consider using the [IntersectionObserver](https://developers.google.com/web/updates/2016/04/intersectionobserver) API.',requiredArtifacts:['ImageUsage','ViewportDimensions','traces','devtoolsLogs']};}
static computeVisiblePixels(imageRect,viewportDimensions){const innerWidth=viewportDimensions.innerWidth;const innerHeight=viewportDimensions.innerHeight;const top=Math.max(imageRect.top,-1*ALLOWABLE_OFFSCREEN_Y);const right=Math.min(imageRect.right,innerWidth+ALLOWABLE_OFFSCREEN_X);const bottom=Math.min(imageRect.bottom,innerHeight+ALLOWABLE_OFFSCREEN_Y);const left=Math.max(imageRect.left,-1*ALLOWABLE_OFFSCREEN_X);return Math.max(right-left,0)*Math.max(bottom-top,0);}
static computeWaste(image,viewportDimensions){const url=URL.getURLDisplayName(image.src,{preserveQuery:true});const totalPixels=image.clientWidth*image.clientHeight;const visiblePixels=this.computeVisiblePixels(image.clientRect,viewportDimensions);const wastedRatio=totalPixels===0?1:1-visiblePixels/totalPixels;const totalBytes=image.networkRecord.resourceSize;const wastedBytes=Math.round(totalBytes*wastedRatio);if(!Number.isFinite(wastedRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,preview:{type:'thumbnail',url:image.networkRecord.url,mimeType:image.networkRecord.mimeType},requestStartTime:image.networkRecord.startTime,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts){const images=artifacts.ImageUsage;const viewportDimensions=artifacts.ViewportDimensions;const trace=artifacts.traces[ByteEfficiencyAudit.DEFAULT_PASS];let debugString;const resultsMap=images.reduce((results,image)=>{if(!image.networkRecord){return results;}
const processed=OffscreenImages.computeWaste(image,viewportDimensions);if(processed instanceof Error){debugString=processed.message;return results;}
const existing=results.get(processed.preview.url);if(!existing||existing.wastedBytes>processed.wastedBytes){results.set(processed.preview.url,processed);}
return results;},new Map());return artifacts.requestFirstInteractive(trace).then(firstInteractive=>{const ttiTimestamp=firstInteractive.timestamp/1000000;const results=Array.from(resultsMap.values()).filter(item=>{const isWasteful=item.wastedBytes>IGNORE_THRESHOLD_IN_BYTES&&item.wastedPercent>IGNORE_THRESHOLD_IN_PERCENT;const loadedEarly=item.requestStartTime<ttiTimestamp;return isWasteful&&loadedEarly;});const headings=[{key:'preview',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{debugString,results,headings};});}}
module.exports=OffscreenImages;},{"../../lib/url-shim":27,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/total-byte-weight":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const Formatter=require('../../report/formatter');const TracingProcessor=require('../../lib/traces/tracing-processor');const URL=require('../../lib/url-shim');const OPTIMAL_VALUE=1600*1024;const SCORING_POINT_OF_DIMINISHING_RETURNS=2500*1024;const SCORING_MEDIAN=4000*1024;class TotalByteWeight extends ByteEfficiencyAudit{static get meta(){return{category:'Network',name:'total-byte-weight',optimalValue:`< ${this.bytesToKbString(OPTIMAL_VALUE)}`,description:'Avoids enormous network payloads',helpText:'Network transfer size [costs users real dollars](https://whatdoesmysitecost.com/) '+'and is [highly correlated](http://httparchive.org/interesting.php#onLoad) with long load times. '+'Try to find ways to reduce the size of required files.',scoringMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['devtoolsLogs']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{return artifacts.requestNetworkThroughput(networkRecords).then(networkThroughput=>{let totalBytes=0;let results=[];networkRecords.forEach(record=>{if(record.scheme==='data'||!record.finished)return;const result={url:URL.getURLDisplayName(record.url),totalBytes:record.transferSize,totalKb:this.bytesToKbString(record.transferSize),totalMs:this.bytesToMsString(record.transferSize,networkThroughput)};totalBytes+=result.totalBytes;results.push(result);});results=results.sort((itemA,itemB)=>itemB.totalBytes-itemA.totalBytes).slice(0,10);const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);const score=100*distribution.computeComplementaryPercentile(totalBytes);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Total Size'},{key:'totalMs',itemType:'text',text:'Transfer Time'}];const v1TableHeadings=ByteEfficiencyAudit.makeV1TableHeadings(headings);const v2TableDetails=ByteEfficiencyAudit.makeV2TableDetails(headings,results);return{rawValue:totalBytes,optimalValue:this.meta.optimalValue,displayValue:`Total size was ${ByteEfficiencyAudit.bytesToKbString(totalBytes)}`,score:Math.round(Math.max(0,Math.min(score,100))),extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.TABLE,value:{results,tableHeadings:v1TableHeadings}},details:v2TableDetails};});});}}
module.exports=TotalByteWeight;},{"../../lib/traces/tracing-processor":26,"../../lib/url-shim":27,"../../report/formatter":29,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/unused-css-rules":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const PREVIEW_LENGTH=100;class UnusedCSSRules extends ByteEfficiencyAudit{static get meta(){return{category:'CSS',name:'unused-css-rules',description:'Unused CSS rules',informative:true,helpText:'Remove unused rules from stylesheets to reduce unnecessary '+'bytes consumed by network activity. '+'[Learn more](https://developers.google.com/speed/docs/insights/OptimizeCSSDelivery)',requiredArtifacts:['CSSUsage','Styles','URL','devtoolsLogs']};}
static indexStylesheetsById(styles,networkRecords){const indexedNetworkRecords=networkRecords.filter(record=>record._resourceType&&record._resourceType._name==='stylesheet').reduce((indexed,record)=>{indexed[record.url]=record;return indexed;},{});return styles.reduce((indexed,stylesheet)=>{indexed[stylesheet.header.styleSheetId]=Object.assign({used:[],unused:[],networkRecord:indexedNetworkRecords[stylesheet.header.sourceURL]},stylesheet);return indexed;},{});}
static countUnusedRules(rules,indexedStylesheets){let unused=0;rules.forEach(rule=>{const stylesheetInfo=indexedStylesheets[rule.styleSheetId];if(!stylesheetInfo||stylesheetInfo.isDuplicate){return;}
if(rule.used){stylesheetInfo.used.push(rule);}else{unused++;stylesheetInfo.unused.push(rule);}});return unused;}
static determineContentPreview(content){let preview=content.slice(0,PREVIEW_LENGTH*5).replace(/( {2,}|\t)+/g,'  ').replace(/\n\s+}/g,'\n}').trim();if(preview.length>PREVIEW_LENGTH){const firstRuleStart=preview.indexOf('{');const firstRuleEnd=preview.indexOf('}');if(firstRuleStart===-1||firstRuleEnd===-1||firstRuleStart>firstRuleEnd||firstRuleStart>PREVIEW_LENGTH){preview=preview.slice(0,PREVIEW_LENGTH)+'...';}else if(firstRuleEnd<PREVIEW_LENGTH){preview=preview.slice(0,firstRuleEnd+1)+' ...';}else{const lastSemicolonIndex=preview.slice(0,PREVIEW_LENGTH).lastIndexOf(';');preview=lastSemicolonIndex<firstRuleStart?preview.slice(0,PREVIEW_LENGTH)+'... } ...':preview.slice(0,lastSemicolonIndex+1)+' ... } ...';}}
return preview;}
static mapSheetToResult(stylesheetInfo,pageUrl){const numUsed=stylesheetInfo.used.length;const numUnused=stylesheetInfo.unused.length;if(numUsed===0&&numUnused===0||stylesheetInfo.isDuplicate){return null;}
let url=stylesheetInfo.header.sourceURL;if(!url||url===pageUrl){const contentPreview=UnusedCSSRules.determineContentPreview(stylesheetInfo.content);url='*inline*```'+contentPreview+'```';}else{url=URL.getURLDisplayName(url);}
const totalBytes=stylesheetInfo.networkRecord?stylesheetInfo.networkRecord.transferSize:Math.round(stylesheetInfo.content.length/3);const percentUnused=numUnused/(numUsed+numUnused);const wastedBytes=Math.round(percentUnused*totalBytes);return{url,numUnused,wastedBytes,wastedPercent:percentUnused*100,totalBytes};}
static audit_(artifacts){const styles=artifacts.Styles;const usage=artifacts.CSSUsage;const pageUrl=artifacts.URL.finalUrl;const devtoolsLogs=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const indexedSheets=UnusedCSSRules.indexStylesheetsById(styles,networkRecords);UnusedCSSRules.countUnusedRules(usage,indexedSheets);const results=Object.keys(indexedSheets).map(sheetId=>{return UnusedCSSRules.mapSheetToResult(indexedSheets[sheetId],pageUrl);}).filter(sheet=>sheet&&sheet.wastedBytes>1024);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'numUnused',itemType:'url',text:'Unused Rules'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{results,headings};});}}
module.exports=UnusedCSSRules;},{"../../lib/url-shim":27,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-optimized-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=4096;class UsesOptimizedImages extends ByteEfficiencyAudit{static get meta(){return{category:'Images',name:'uses-optimized-images',description:'Optimize images',informative:true,helpText:'Optimized images take less time to download and save cellular data. '+'The identified images could have smaller file sizes when compressed as JPEG (q=85). '+'[Learn more about image optimization](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/image-optimization).',requiredArtifacts:['OptimizedImages','devtoolsLogs']};}
static computeSavings(image,type){const bytes=image.originalSize-image[type+'Size'];const percent=100*bytes/image.originalSize;return{bytes,percent};}
static audit_(artifacts){const images=artifacts.OptimizedImages;const failedImages=[];const results=[];images.forEach(image=>{if(image.failed){failedImages.push(image);return;}else if(/(jpeg|bmp)/.test(image.mimeType)===false||image.originalSize<image.jpegSize+IGNORE_THRESHOLD_IN_BYTES){return;}
const url=URL.getURLDisplayName(image.url);const jpegSavings=UsesOptimizedImages.computeSavings(image,'jpeg');results.push({url,isCrossOrigin:!image.isSameOrigin,preview:{url:image.url,mimeType:image.mimeType,type:'thumbnail'},totalBytes:image.originalSize,wastedBytes:jpegSavings.bytes});});let debugString;if(failedImages.length){const urls=failedImages.map(image=>URL.getURLDisplayName(image.url));debugString=`Lighthouse was unable to decode some of your images: ${urls.join(', ')}`;}
const headings=[{key:'preview',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{debugString,results,headings};}}
module.exports=UsesOptimizedImages;},{"../../lib/url-shim":27,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-request-compression":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=1400;const IGNORE_THRESHOLD_IN_PERCENT=0.1;class ResponsesAreCompressed extends ByteEfficiencyAudit{static get meta(){return{category:'Performance',name:'uses-request-compression',informative:true,description:'Enable text compression',helpText:'Text-based responses should be served with compression (gzip, deflate or brotli)'+' to minimize total network bytes.'+' [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/optimize-encoding-and-transfer).',requiredArtifacts:['ResponseCompression','devtoolsLogs']};}
static audit_(artifacts){const uncompressedResponses=artifacts.ResponseCompression;const results=[];uncompressedResponses.forEach(record=>{const originalSize=record.resourceSize;const gzipSize=record.gzipSize;const gzipSavings=originalSize-gzipSize;if(1-gzipSize/originalSize<IGNORE_THRESHOLD_IN_PERCENT||gzipSavings<IGNORE_THRESHOLD_IN_BYTES)
{return;}
const url=URL.getURLDisplayName(record.url);const isDuplicate=results.find(res=>res.url===url&&res.totalBytes===record.resourceSize);if(isDuplicate){return;}
results.push({url,totalBytes:originalSize,wastedBytes:gzipSavings});});const headings=[{key:'url',itemType:'url',text:'Uncompressed resource URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'GZIP Savings'}];return{results,headings};}}
module.exports=ResponsesAreCompressed;},{"../../lib/url-shim":27,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-responsive-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=2048;const WASTEFUL_THRESHOLD_IN_BYTES=25*1024;class UsesResponsiveImages extends ByteEfficiencyAudit{static get meta(){return{category:'Images',name:'uses-responsive-images',description:'Properly size images',informative:true,helpText:'Serve images that are appropriately-sized to save cellular data '+'and improve load time. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/oversized-images).',requiredArtifacts:['ImageUsage','ViewportDimensions','devtoolsLogs']};}
static computeWaste(image,DPR){const url=URL.getURLDisplayName(image.src);const actualPixels=image.naturalWidth*image.naturalHeight;const usedPixels=image.clientWidth*image.clientHeight*Math.pow(DPR,2);const wastedRatio=1-usedPixels/actualPixels;const totalBytes=image.networkRecord.resourceSize;const wastedBytes=Math.round(totalBytes*wastedRatio);if(!Number.isFinite(wastedRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,preview:{type:'thumbnail',url:image.networkRecord.url,mimeType:image.networkRecord.mimeType},totalBytes,wastedBytes,wastedPercent:100*wastedRatio,isWasteful:wastedBytes>WASTEFUL_THRESHOLD_IN_BYTES};}
static audit_(artifacts){const images=artifacts.ImageUsage;const DPR=artifacts.ViewportDimensions.devicePixelRatio;let debugString;const resultsMap=new Map();images.forEach(image=>{if(!image.networkRecord||image.networkRecord.mimeType==='image/svg+xml'){return;}
const processed=UsesResponsiveImages.computeWaste(image,DPR);if(processed instanceof Error){debugString=processed.message;return;}
const existing=resultsMap.get(processed.preview.url);if(!existing||existing.wastedBytes>processed.wastedBytes){resultsMap.set(processed.preview.url,processed);}});const results=Array.from(resultsMap.values()).filter(item=>item.wastedBytes>IGNORE_THRESHOLD_IN_BYTES);const headings=[{key:'preview',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{debugString,results,headings};}}
module.exports=UsesResponsiveImages;},{"../../lib/url-shim":27,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-webp-images":[function(require,module,exports){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const OptimizedImages=require('./uses-optimized-images');const URL=require('../../lib/url-shim');const IGNORE_THRESHOLD_IN_BYTES=8192;class UsesWebPImages extends ByteEfficiencyAudit{static get meta(){return{category:'Images',name:'uses-webp-images',description:'Serve images as WebP',informative:true,helpText:'[WebP](https://developers.google.com/speed/webp/) images take less time to download and save cellular data. '+'[Learn more about image optimization](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/image-optimization).',requiredArtifacts:['OptimizedImages','devtoolsLogs']};}
static audit_(artifacts){const images=artifacts.OptimizedImages;const failedImages=[];const results=[];images.forEach(image=>{if(image.failed){failedImages.push(image);return;}else if(image.originalSize<image.webpSize+IGNORE_THRESHOLD_IN_BYTES){return;}
const url=URL.getURLDisplayName(image.url);const webpSavings=OptimizedImages.computeSavings(image,'webp');results.push({url,isCrossOrigin:!image.isSameOrigin,preview:{url:image.url,mimeType:image.mimeType,type:'thumbnail'},totalBytes:image.originalSize,wastedBytes:webpSavings.bytes});});let debugString;if(failedImages.length){const urls=failedImages.map(image=>URL.getURLDisplayName(image.url));debugString=`Lighthouse was unable to decode some of your images: ${urls.join(', ')}`;}
const headings=[{key:'preview',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Original'},{key:'potentialSavings',itemType:'text',text:'Potential Savings'}];return{debugString,results,headings};}}
module.exports=UsesWebPImages;},{"../../lib/url-shim":27,"./byte-efficiency-audit":3,"./uses-optimized-images":"../audits/byte-efficiency/uses-optimized-images"}],"../audits/cache-start-url":[function(require,module,exports){'use strict';const Audit=require('./audit');class CacheStartUrl extends Audit{static get meta(){return{category:'Manifest',name:'cache-start-url',description:'Cache contains start_url from manifest (alpha)',requiredArtifacts:['CacheContents','Manifest','URL']};}
static audit(artifacts){if(!artifacts.Manifest||!artifacts.Manifest.value){return{rawValue:false};}
const manifest=artifacts.Manifest.value;if(!(manifest.start_url&&manifest.start_url.value)){return{rawValue:false,debugString:'start_url not present in Manifest'};}
const startURL=manifest.start_url.value;const altStartURL=startURL.replace(/\?utm_([^=]*)=([^&]|$)*/,'').replace(/\?$/,'');const cacheContents=artifacts.CacheContents;const cacheHasStartUrl=cacheContents.find(req=>{return startURL===req||altStartURL===req;});return{rawValue:cacheHasStartUrl!==undefined};}}
module.exports=CacheStartUrl;},{"./audit":2}],"../audits/consistently-interactive":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util.js');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../report/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=1700;const SCORING_MEDIAN=10000;const REQUIRED_QUIET_WINDOW=5000;const ALLOWED_CONCURRENT_REQUESTS=2;const IGNORED_NETWORK_SCHEMES=['data','ws'];const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);class ConsistentlyInteractiveMetric extends Audit{static get meta(){return{category:'Performance',name:'consistently-interactive',description:'Consistently Interactive (beta)',helpText:'The point at which most network resources have finished loading and the '+'CPU is idle for a prolonged period.',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static _findNetworkQuietPeriods(networkRecords,traceOfTab){const traceEnd=traceOfTab.timestamps.traceEnd;const timeBoundaries=[];networkRecords.forEach(record=>{const scheme=record.parsedURL&&record.parsedURL.scheme;if(IGNORED_NETWORK_SCHEMES.includes(scheme)){return;}
timeBoundaries.push({time:record.startTime*1000,isStart:true});if(record.finished){timeBoundaries.push({time:record.endTime*1000,isStart:false});}});timeBoundaries.sort((a,b)=>a.time-b.time);let numInflightRequests=0;let quietPeriodStart=0;const quietPeriods=[];timeBoundaries.forEach(boundary=>{if(boundary.isStart){if(numInflightRequests===ALLOWED_CONCURRENT_REQUESTS){quietPeriods.push({start:quietPeriodStart,end:boundary.time});}
numInflightRequests++;}else{numInflightRequests--;if(numInflightRequests===ALLOWED_CONCURRENT_REQUESTS){quietPeriodStart=boundary.time;}}});if(numInflightRequests<=ALLOWED_CONCURRENT_REQUESTS){quietPeriods.push({start:quietPeriodStart,end:traceEnd});}
return quietPeriods;}
static _findCPUQuietPeriods(longTasks,traceOfTab){const navStartTsInMs=traceOfTab.timestamps.navigationStart;const traceEndTsInMs=traceOfTab.timestamps.traceEnd;if(longTasks.length===0){return[{start:0,end:traceEndTsInMs}];}
const quietPeriods=[];longTasks.forEach((task,index)=>{if(index===0){quietPeriods.push({start:0,end:task.start+navStartTsInMs});}
if(index===longTasks.length-1){quietPeriods.push({start:task.end+navStartTsInMs,end:traceEndTsInMs});}else{quietPeriods.push({start:task.end+navStartTsInMs,end:longTasks[index+1].start+navStartTsInMs});}});return quietPeriods;}
static findOverlappingQuietPeriods(longTasks,networkRecords,traceOfTab){const FMPTsInMs=traceOfTab.timestamps.firstMeaningfulPaint;const isLongEnoughQuietPeriod=period=>period.end>FMPTsInMs+REQUIRED_QUIET_WINDOW&&period.end-period.start>=REQUIRED_QUIET_WINDOW;const networkQuietPeriods=this._findNetworkQuietPeriods(networkRecords,traceOfTab).filter(isLongEnoughQuietPeriod);const cpuQuietPeriods=this._findCPUQuietPeriods(longTasks,traceOfTab).filter(isLongEnoughQuietPeriod);const cpuQueue=cpuQuietPeriods.slice();const networkQueue=networkQuietPeriods.slice();let cpuCandidate=cpuQueue.shift();let networkCandidate=networkQueue.shift();while(cpuCandidate&&networkCandidate){if(cpuCandidate.start>=networkCandidate.start){if(networkCandidate.end>=cpuCandidate.start+REQUIRED_QUIET_WINDOW){return{cpuQuietPeriod:cpuCandidate,networkQuietPeriod:networkCandidate,cpuQuietPeriods,networkQuietPeriods};}else{networkCandidate=networkQueue.shift();}}else{if(cpuCandidate.end>=networkCandidate.start+REQUIRED_QUIET_WINDOW){return{cpuQuietPeriod:cpuCandidate,networkQuietPeriod:networkCandidate,cpuQuietPeriods,networkQuietPeriods};}else{cpuCandidate=cpuQueue.shift();}}}
const culprit=cpuCandidate?'Network':'Main thread';throw new Error(`${culprit} activity continued through the end of the trace recording. `+'Consistently Interactive requires a minimum of 5 seconds of both main thread idle and '+'network idle.');}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const computedArtifacts=[artifacts.requestNetworkRecords(devtoolsLog),artifacts.requestTracingModel(trace),artifacts.requestTraceOfTab(trace)];return Promise.all(computedArtifacts).then(([networkRecords,traceModel,traceOfTab])=>{if(!traceOfTab.timestamps.firstMeaningfulPaint){throw new Error('No firstMeaningfulPaint found in trace.');}
if(!traceOfTab.timestamps.domContentLoaded){throw new Error('No domContentLoaded found in trace.');}
const longTasks=TracingProcessor.getMainThreadTopLevelEvents(traceModel,trace).filter(event=>event.duration>=50);const quietPeriodInfo=this.findOverlappingQuietPeriods(longTasks,networkRecords,traceOfTab);const cpuQuietPeriod=quietPeriodInfo.cpuQuietPeriod;const timestamp=Math.max(cpuQuietPeriod.start,traceOfTab.timestamps.firstMeaningfulPaint,traceOfTab.timestamps.domContentLoaded)*1000;const timeInMs=(timestamp-traceOfTab.timestamps.navigationStart*1000)/1000;const extendedInfo=Object.assign(quietPeriodInfo,{timestamp,timeInMs});let score=100*distribution.computeComplementaryPercentile(timeInMs);score=Math.min(100,score);score=Math.max(0,score);score=Math.round(score);return{score,rawValue:timeInMs,displayValue:Util.formatMilliseconds(timeInMs),optimalValue:this.meta.optimalValue,extendedInfo:{value:extendedInfo,formatter:Formatter.SUPPORTED_FORMATS.NULL}};});}}
module.exports=ConsistentlyInteractiveMetric;let TimePeriod;},{"../lib/traces/tracing-processor":26,"../report/formatter":29,"../report/v2/renderer/util.js":30,"./audit":2}],"../audits/content-width":[function(require,module,exports){'use strict';const Audit=require('./audit');class ContentWidth extends Audit{static get meta(){return{category:'Mobile Friendly',name:'content-width',description:'Content is sized correctly for the viewport',helpText:'If the width of your app\'s content doesn\'t match the width '+'of the viewport, your app might not be optimized for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/content-sized-correctly-for-viewport).',requiredArtifacts:['ViewportDimensions']};}
static audit(artifacts){const viewportWidth=artifacts.ViewportDimensions.innerWidth;const windowWidth=artifacts.ViewportDimensions.outerWidth;const widthsMatch=viewportWidth===windowWidth;return{rawValue:widthsMatch,debugString:this.createDebugString(widthsMatch,artifacts.ViewportDimensions)};}
static createDebugString(match,artifact){if(match){return'';}
return'The viewport size is '+artifact.innerWidth+'px, '+'whereas the window size is '+artifact.outerWidth+'px.';}}
module.exports=ContentWidth;},{"./audit":2}],"../audits/critical-request-chains":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../report/formatter');class CriticalRequestChains extends Audit{static get meta(){return{category:'Performance',name:'critical-request-chains',description:'Critical Request Chains',informative:true,optimalValue:0,helpText:'The Critical Request Chains below show you what resources are '+'required for first render of this page. Improve page load by reducing '+'the length of chains, reducing the download size of resources, or '+'deferring the download of unnecessary resources. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains).',requiredArtifacts:['devtoolsLogs']};}
static _traverse(tree,cb){function walk(node,depth,startTime,transferSize=0){const children=Object.keys(node);if(children.length===0){return;}
children.forEach(id=>{const child=node[id];if(!startTime){startTime=child.request.startTime;}
cb({depth,id,node:child,chainDuration:(child.request.endTime-startTime)*1000,chainTransferSize:transferSize+child.request.transferSize});walk(child.children,depth+1,startTime);},'');}
walk(tree,0);}
static _getLongestChain(tree){const longest={duration:0,length:0,transferSize:0};CriticalRequestChains._traverse(tree,opts=>{const duration=opts.chainDuration;if(duration>longest.duration){longest.duration=duration;longest.transferSize=opts.chainTransferSize;longest.length=opts.depth;}});longest.length++;return longest;}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{return artifacts.requestCriticalRequestChains(networkRecords).then(chains=>{let chainCount=0;function walk(node,depth){const children=Object.keys(node);if(children.length===0){chainCount++;}
children.forEach(id=>{const child=node[id];walk(child.children,depth+1);},'');}
const initialNavKey=Object.keys(chains)[0];const initialNavChildren=initialNavKey&&chains[initialNavKey].children;if(initialNavChildren&&Object.keys(initialNavChildren).length>0){walk(initialNavChildren,0);}
const longestChain=CriticalRequestChains._getLongestChain(chains);return{rawValue:chainCount<=this.meta.optimalValue,displayValue:chainCount,optimalValue:this.meta.optimalValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.CRITICAL_REQUEST_CHAINS,value:{chains,longestChain}},details:{type:'criticalrequestchain',header:{type:'text',text:'View critical network waterfall:'},chains,longestChain}};});});}}
module.exports=CriticalRequestChains;},{"../report/formatter":29,"./audit":2}],"../audits/deprecations":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../report/formatter');const URL=require('../lib/url-shim');class Deprecations extends Audit{static get meta(){return{category:'Deprecations',name:'deprecations',description:'Avoids deprecated APIs',helpText:'Deprecated APIs will eventually be removed from the browser. '+'[Learn more](https://www.chromestatus.com/features#deprecated).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const entries=artifacts.ChromeConsoleMessages;const deprecations=entries.filter(log=>log.entry.source==='deprecation').map(log=>{const label=log.entry.lineNumber?`line: ${log.entry.lineNumber}`:'line: ???';const url=log.entry.url||'Unable to determine URL';return Object.assign({label,url,code:log.entry.text},log.entry);});const deprecationsV2=entries.filter(log=>log.entry.source==='deprecation').map(log=>{const url=URL.isValid(log.entry.url)?URL.getURLDisplayName(log.entry.url):'';return{type:'code',text:log.entry.text,url,source:log.entry.source,lineNumber:log.entry.lineNumber};});const headings=[{key:'text',itemType:'code',text:'Deprecation / Warning'},{key:'url',itemType:'url',text:'URL'},{key:'lineNumber',itemType:'text',text:'Line'}];const details=Audit.makeV2TableDetails(headings,deprecationsV2);let displayValue='';if(deprecations.length>1){displayValue=`${deprecations.length} warnings found`;}else if(deprecations.length===1){displayValue=`${deprecations.length} warning found`;}
return{rawValue:deprecations.length===0,displayValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URL_LIST,value:deprecations},details};}}
module.exports=Deprecations;},{"../lib/url-shim":27,"../report/formatter":29,"./audit":2}],"../audits/dobetterweb/appcache-manifest":[function(require,module,exports){'use strict';const Audit=require('../audit');class AppCacheManifestAttr extends Audit{static get meta(){return{category:'Offline',name:'appcache-manifest',description:'Avoids Application Cache',helpText:'Application Cache has been [deprecated](https://html.spec.whatwg.org/multipage/browsers.html#offline) by [Service Workers](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API/Using_Service_Workers). Consider implementing an offline solution using the [Cache Storage API](https://developer.mozilla.org/en-US/docs/Web/API/Cache).',requiredArtifacts:['AppCacheManifest']};}
static audit(artifacts){const usingAppcache=artifacts.AppCacheManifest!==null;const debugString=usingAppcache?`Found <html manifest="${artifacts.AppCacheManifest}">.`:'';return{rawValue:!usingAppcache,debugString};}}
module.exports=AppCacheManifestAttr;},{"../audit":2}],"../audits/dobetterweb/dom-size":[function(require,module,exports){'use strict';const Audit=require('../audit');const TracingProcessor=require('../../lib/traces/tracing-processor');const Formatter=require('../../report/formatter');const MAX_DOM_NODES=1500;const MAX_DOM_TREE_WIDTH=60;const MAX_DOM_TREE_DEPTH=32;const SCORING_POINT_OF_DIMINISHING_RETURNS=2400;const SCORING_MEDIAN=3000;class DOMSize extends Audit{static get MAX_DOM_NODES(){return MAX_DOM_NODES;}
static get meta(){return{category:'Performance',name:'dom-size',description:'Avoids an excessive DOM size',optimalValue:`< ${DOMSize.MAX_DOM_NODES.toLocaleString()} nodes`,helpText:'Browser engineers recommend pages contain fewer than '+`~${DOMSize.MAX_DOM_NODES.toLocaleString()} DOM nodes. The sweet spot is a tree depth < `+`${MAX_DOM_TREE_DEPTH} elements and fewer than ${MAX_DOM_TREE_WIDTH} `+'children/parent element. A large DOM can increase memory, cause longer '+'[style calculations](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations), '+'and produce costly [layout reflows](https://developers.google.com/speed/articles/reflow). [Learn more](https://developers.google.com/web/fundamentals/performance/rendering/).',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['DOMStats']};}
static audit(artifacts){const stats=artifacts.DOMStats;const depthSnippet=stats.depth.pathToElement.reduce((str,curr,i)=>{return`${str}\n`+'  '.repeat(i)+`${curr} >`;},'').replace(/>$/g,'').trim();const widthSnippet='Element with most children:\n'+
stats.width.pathToElement[stats.width.pathToElement.length-1];const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);let score=100*distribution.computeComplementaryPercentile(stats.totalDOMNodes);score=Math.max(0,Math.min(100,score));const cards=[{title:'Total DOM Nodes',value:stats.totalDOMNodes.toLocaleString(),target:`< ${MAX_DOM_NODES.toLocaleString()} nodes`},{title:'DOM Depth',value:stats.depth.max.toLocaleString(),snippet:depthSnippet,target:`< ${MAX_DOM_TREE_DEPTH.toLocaleString()}`},{title:'Maximum Children',value:stats.width.max.toLocaleString(),snippet:widthSnippet,target:`< ${MAX_DOM_TREE_WIDTH.toLocaleString()} nodes`}];return{rawValue:stats.totalDOMNodes,optimalValue:this.meta.optimalValue,score:Math.round(score),displayValue:`${stats.totalDOMNodes.toLocaleString()} nodes`,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.CARDS,value:cards},details:{type:'cards',header:{type:'text',text:'View details'},items:cards}};}}
module.exports=DOMSize;},{"../../lib/traces/tracing-processor":26,"../../report/formatter":29,"../audit":2}],"../audits/dobetterweb/external-anchors-use-rel-noopener":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Formatter=require('../../report/formatter');class ExternalAnchorsUseRelNoopenerAudit extends Audit{static get meta(){return{category:'Performance',name:'external-anchors-use-rel-noopener',description:'Opens external anchors using `rel="noopener"`',helpText:'Open new tabs using `rel="noopener"` to improve performance and '+'prevent security vulnerabilities. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/noopener).',requiredArtifacts:['URL','AnchorsWithNoRelNoopener']};}
static audit(artifacts){let debugString;const pageHost=new URL(artifacts.URL.finalUrl).host;const failingAnchors=artifacts.AnchorsWithNoRelNoopener.filter(anchor=>{try{return anchor.href===''||new URL(anchor.href).host!==pageHost;}catch(err){debugString='Lighthouse was unable to determine the destination '+'of some anchor tags. If they are not used as hyperlinks, '+'consider removing the _blank target.';return true;}}).map(anchor=>{return{href:anchor.href||'Unknown',target:anchor.target||'',rel:anchor.rel||'',url:'<a'+(anchor.href?` href="${anchor.href}"`:'')+(anchor.target?` target="${anchor.target}"`:'')+(anchor.rel?` rel="${anchor.rel}"`:'')+'>'};});const headings=[{key:'href',itemType:'url',text:'URL'},{key:'target',itemType:'text',text:'Target'},{key:'rel',itemType:'text',text:'Rel'}];const details=Audit.makeV2TableDetails(headings,failingAnchors);return{rawValue:failingAnchors.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URL_LIST,value:failingAnchors},details,debugString};}}
module.exports=ExternalAnchorsUseRelNoopenerAudit;},{"../../lib/url-shim":27,"../../report/formatter":29,"../audit":2}],"../audits/dobetterweb/geolocation-on-start":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');const Formatter=require('../../report/formatter');class GeolocationOnStart extends ViolationAudit{static get meta(){return{category:'UX',name:'geolocation-on-start',description:'Avoids requesting the geolocation permission on page load',helpText:'Users are mistrustful of or confused by sites that request their '+'location without context. Consider tying the request to user gestures instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/geolocation-on-load).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/geolocation/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeV2TableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URL_LIST,value:results},details};}}
module.exports=GeolocationOnStart;},{"../../report/formatter":29,"../violation-audit":6}],"../audits/dobetterweb/link-blocking-first-paint":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const Formatter=require('../../report/formatter');const scoreForWastedMs=require('../byte-efficiency/byte-efficiency-audit').scoreForWastedMs;const LOAD_THRESHOLD_IN_MS=50;class LinkBlockingFirstPaintAudit extends Audit{static get meta(){return{category:'Performance',name:'link-blocking-first-paint',description:'Reduce render-blocking stylesheets',informative:true,helpText:'Link elements are blocking the first paint of your page. Consider '+'inlining critical links and deferring non-critical ones. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).',requiredArtifacts:['TagsBlockingFirstPaint','traces']};}
static computeAuditResultForTags(artifacts,tagFilter,endTimeMax=Infinity,loadDurationThreshold=0){const artifact=artifacts.TagsBlockingFirstPaint;const filtered=artifact.filter(item=>{return item.tag.tagName===tagFilter&&(item.endTime-item.startTime)*1000>=loadDurationThreshold&&item.endTime*1000<endTimeMax;});const startTime=filtered.length===0?0:filtered.reduce((t,item)=>Math.min(t,item.startTime),Number.MAX_VALUE);let endTime=0;const results=filtered.map(item=>{endTime=Math.max(item.endTime,endTime);return{url:URL.getURLDisplayName(item.tag.url),totalKb:`${Math.round(item.transferSize/1024)} KB`,totalMs:`${Math.round((item.endTime-startTime)*1000)}ms`};});const delayTime=Math.round((endTime-startTime)*1000);let displayValue='';if(results.length>1){displayValue=`${results.length} resources delayed first paint by ${delayTime}ms`;}else if(results.length===1){displayValue=`${results.length} resource delayed first paint by ${delayTime}ms`;}
const headings=[{key:'url',itemType:'url',text:'URL'},{key:'totalKb',itemType:'text',text:'Size (KB)'},{key:'totalMs',itemType:'text',text:'Delayed Paint By (ms)'}];const v1TableHeadings=Audit.makeV1TableHeadings(headings);const v2TableDetails=Audit.makeV2TableDetails(headings,results);return{displayValue,score:scoreForWastedMs(delayTime),rawValue:delayTime,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.TABLE,value:{wastedMs:delayTime,results,tableHeadings:v1TableHeadings}},details:v2TableDetails};}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(traceOfTab=>{const fcp=traceOfTab.timestamps.firstContentfulPaint;return this.computeAuditResultForTags(artifacts,'LINK',fcp,LOAD_THRESHOLD_IN_MS);});}}
module.exports=LinkBlockingFirstPaintAudit;},{"../../lib/url-shim":27,"../../report/formatter":29,"../audit":2,"../byte-efficiency/byte-efficiency-audit":3}],"../audits/dobetterweb/no-document-write":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');const Formatter=require('../../report/formatter');class NoDocWriteAudit extends ViolationAudit{static get meta(){return{category:'Performance',name:'no-document-write',description:'Avoids `document.write()`',helpText:'For users on slow connections, external scripts dynamically injected via '+'`document.write()` can delay page load by tens of seconds. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/document-write).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/document\.write/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeV2TableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URL_LIST,value:results},details};}}
module.exports=NoDocWriteAudit;},{"../../report/formatter":29,"../violation-audit":6}],"../audits/dobetterweb/no-mutation-events":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const EventHelpers=require('../../lib/event-helpers');const Formatter=require('../../report/formatter');class NoMutationEventsAudit extends Audit{static get MUTATION_EVENTS(){return['DOMAttrModified','DOMAttributeNameChanged','DOMCharacterDataModified','DOMElementNameChanged','DOMNodeInserted','DOMNodeInsertedIntoDocument','DOMNodeRemoved','DOMNodeRemovedFromDocument','DOMSubtreeModified'];}
static get meta(){return{category:'JavaScript',name:'no-mutation-events',description:'Avoids Mutation Events in its own scripts',helpText:'Mutation Events are deprecated and harm performance. Consider using Mutation '+'Observers instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/mutation-events).',requiredArtifacts:['URL','EventListeners']};}
static audit(artifacts){let debugString;const listeners=artifacts.EventListeners;const results=listeners.filter(loc=>{const isMutationEvent=this.MUTATION_EVENTS.includes(loc.type);let sameHost=URL.hostsMatch(artifacts.URL.finalUrl,loc.url);if(!URL.isValid(loc.url)&&isMutationEvent){sameHost=true;debugString=URL.INVALID_URL_DEBUG_STRING;}
return sameHost&&isMutationEvent;}).map(EventHelpers.addFormattedCodeSnippet);const groupedResults=EventHelpers.groupCodeSnippetsByLocation(results);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'type',itemType:'code',text:'Event'},{key:'line',itemType:'text',text:'Line'},{key:'col',itemType:'text',text:'Col'},{key:'pre',itemType:'code',text:'Snippet'}];const details=NoMutationEventsAudit.makeV2TableDetails(headings,groupedResults);return{rawValue:groupedResults.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.TABLE,value:{results:groupedResults,tableHeadings:{url:'URL',lineCol:'Line/Col',type:'Event',code:'Snippet'}}},details,debugString};}}
module.exports=NoMutationEventsAudit;},{"../../lib/event-helpers":19,"../../lib/url-shim":27,"../../report/formatter":29,"../audit":2}],"../audits/dobetterweb/no-old-flexbox":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const StyleHelpers=require('../../lib/styles-helpers');const Formatter=require('../../report/formatter');class NoOldFlexboxAudit extends Audit{static get meta(){return{category:'CSS',name:'no-old-flexbox',description:'Avoids old CSS flexbox',helpText:'The 2009 spec of Flexbox is deprecated and is 2.3x slower than the latest '+'spec. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/old-flexbox).',requiredArtifacts:['Styles','URL']};}
static audit(artifacts){const displayPropResults=StyleHelpers.filterStylesheetsByUsage(artifacts.Styles,'display',StyleHelpers.addVendorPrefixes(['box','flexbox']));const otherPropResults=StyleHelpers.filterStylesheetsByUsage(artifacts.Styles,StyleHelpers.addVendorPrefixes(['box-flex','box-orient','box-flex-group']));const sheetsUsingOldFlexbox=displayPropResults.concat(otherPropResults);const pageUrl=artifacts.URL.finalUrl;const urlList=[];sheetsUsingOldFlexbox.forEach(sheet=>{sheet.parsedContent.forEach(props=>{const formattedStyleRule=StyleHelpers.getFormattedStyleRule(sheet.content,props);let url=sheet.header.sourceURL;if(!URL.isValid(url)||url===pageUrl){url='inline';}else{url=URL.getURLDisplayName(url);}
urlList.push({url,location:formattedStyleRule.location,startLine:formattedStyleRule.startLine,pre:formattedStyleRule.styleRule});});});return{rawValue:sheetsUsingOldFlexbox.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.TABLE,value:{results:urlList,tableHeadings:{url:'URL',startLine:'Line in the stylesheet / <style>',location:'Column start/end',pre:'Snippet'}}}};}}
module.exports=NoOldFlexboxAudit;},{"../../lib/styles-helpers":24,"../../lib/url-shim":27,"../../report/formatter":29,"../audit":2}],"../audits/dobetterweb/no-websql":[function(require,module,exports){'use strict';const Audit=require('../audit');class NoWebSQLAudit extends Audit{static get meta(){return{category:'Offline',name:'no-websql',description:'Avoids WebSQL DB',helpText:'Web SQL is deprecated. Consider using IndexedDB instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/web-sql).',requiredArtifacts:['WebSQL']};}
static audit(artifacts){const db=artifacts.WebSQL;const debugString=db?`Found database "${db.name}", version: ${db.version}.`:'';return{rawValue:!db,debugString};}}
module.exports=NoWebSQLAudit;},{"../audit":2}],"../audits/dobetterweb/notification-on-start":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');const Formatter=require('../../report/formatter');class NotificationOnStart extends ViolationAudit{static get meta(){return{category:'UX',name:'notification-on-start',description:'Avoids requesting the notification permission on page load',helpText:'Users are mistrustful of or confused by sites that request to send '+'notifications without context. Consider tying the request to user gestures '+'instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/notifications-on-load).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/notification permission/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeV2TableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URL_LIST,value:results},details};}}
module.exports=NotificationOnStart;},{"../../report/formatter":29,"../violation-audit":6}],"../audits/dobetterweb/script-blocking-first-paint":[function(require,module,exports){'use strict';const Audit=require('../audit');const LinkBlockingFirstPaintAudit=require('./link-blocking-first-paint');class ScriptBlockingFirstPaint extends Audit{static get meta(){return{category:'Performance',name:'script-blocking-first-paint',description:'Reduce render-blocking scripts',informative:true,helpText:'Script elements are blocking the first paint of your page. Consider inlining '+'critical scripts and deferring non-critical ones. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).',requiredArtifacts:['TagsBlockingFirstPaint','traces']};}
static audit(artifacts){return LinkBlockingFirstPaintAudit.computeAuditResultForTags(artifacts,'SCRIPT');}}
module.exports=ScriptBlockingFirstPaint;},{"../audit":2,"./link-blocking-first-paint":"../audits/dobetterweb/link-blocking-first-paint"}],"../audits/dobetterweb/uses-http2":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Formatter=require('../../report/formatter');class UsesHTTP2Audit extends Audit{static get meta(){return{category:'Performance',name:'uses-http2',description:'Uses HTTP/2 for its own resources',helpText:'HTTP/2 offers many benefits over HTTP/1.1, including binary headers, '+'multiplexing, and server push. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http2).',requiredArtifacts:['URL','devtoolsLogs']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const finalHost=new URL(artifacts.URL.finalUrl).host;const resources=networkRecords.filter(record=>{const requestHost=new URL(record._url).host;const sameHost=requestHost===finalHost;const notH2=/HTTP\/[01][\.\d]?/i.test(record.protocol);return sameHost&&notH2;}).map(record=>{return{protocol:record.protocol,url:record.url};});let displayValue='';if(resources.length>1){displayValue=`${resources.length} requests were not handled over h2`;}else if(resources.length===1){displayValue=`${resources.length} request was not handled over h2`;}
const headings=[{key:'url',itemType:'url',text:'URL'},{key:'protocol',itemType:'text',text:'Protocol'}];const details=Audit.makeV2TableDetails(headings,resources);return{rawValue:resources.length===0,displayValue:displayValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.TABLE,value:{results:resources,tableHeadings:{url:'URL',protocol:'Protocol'}}},details};});}}
module.exports=UsesHTTP2Audit;},{"../../lib/url-shim":27,"../../report/formatter":29,"../audit":2}],"../audits/dobetterweb/uses-passive-event-listeners":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');const Formatter=require('../../report/formatter');class PassiveEventsAudit extends ViolationAudit{static get meta(){return{category:'JavaScript',name:'uses-passive-event-listeners',description:'Uses passive listeners to improve scrolling performance',helpText:'Consider marking your touch and wheel event listeners as `passive` '+'to improve your page\'s scroll performance. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/passive-event-listeners).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/passive event listener/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeV2TableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URL_LIST,value:results},details};}}
module.exports=PassiveEventsAudit;},{"../../report/formatter":29,"../violation-audit":6}],"../audits/estimated-input-latency":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util.js');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../report/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=50;const SCORING_MEDIAN=100;class EstimatedInputLatency extends Audit{static get meta(){return{category:'Performance',name:'estimated-input-latency',description:'Estimated Input Latency',optimalValue:`< ${SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString()} ms`,helpText:'The score above is an estimate of how long your app takes to respond to user '+'input, in milliseconds. There is a 90% probability that a user encounters this amount '+'of latency, or less. 10% of the time a user can expect additional latency. If your '+'score is higher than Lighthouse\'s target score, users may perceive your app as '+'laggy. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency).',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static calculate(tabTrace,model,trace){const startTime=tabTrace.timings.firstMeaningfulPaint;if(!startTime){throw new Error('No firstMeaningfulPaint event found in trace');}
const latencyPercentiles=TracingProcessor.getRiskToResponsiveness(model,trace,startTime);const ninetieth=latencyPercentiles.find(result=>result.percentile===0.9);const rawValue=parseFloat(ninetieth.time.toFixed(1));const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);const score=100*distribution.computeComplementaryPercentile(ninetieth.time);return{score:Math.round(score),optimalValue:this.meta.optimalValue,rawValue,displayValue:Util.formatMilliseconds(rawValue,1),extendedInfo:{value:latencyPercentiles,formatter:Formatter.SUPPORTED_FORMATS.NULL}};}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];const pending=[artifacts.requestTraceOfTab(trace),artifacts.requestTracingModel(trace)];return Promise.all(pending).then(([tabTrace,model])=>{return EstimatedInputLatency.calculate(tabTrace,model,trace);});}}
module.exports=EstimatedInputLatency;},{"../lib/traces/tracing-processor":26,"../report/formatter":29,"../report/v2/renderer/util.js":30,"./audit":2}],"../audits/first-interactive":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util.js');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../report/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=1700;const SCORING_MEDIAN=10000;const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);class FirstInteractiveMetric extends Audit{static get meta(){return{category:'Performance',name:'first-interactive',description:'First Interactive (beta)',helpText:'The first point at which necessary scripts of the page have loaded '+'and the CPU is idle enough to handle most user input.',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestFirstInteractive(trace).then(firstInteractive=>{let score=100*distribution.computeComplementaryPercentile(firstInteractive.timeInMs);score=Math.min(100,score);score=Math.max(0,score);score=Math.round(score);return{score,rawValue:firstInteractive.timeInMs,displayValue:Util.formatMilliseconds(firstInteractive.timeInMs),extendedInfo:{value:firstInteractive,formatter:Formatter.SUPPORTED_FORMATS.NULL}};});}}
module.exports=FirstInteractiveMetric;},{"../lib/traces/tracing-processor":26,"../report/formatter":29,"../report/v2/renderer/util.js":30,"./audit":2}],"../audits/first-meaningful-paint":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/v2/renderer/util.js');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../report/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=1600;const SCORING_MEDIAN=4000;class FirstMeaningfulPaint extends Audit{static get meta(){return{category:'Performance',name:'first-meaningful-paint',description:'First meaningful paint',optimalValue:`< ${SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString()} ms`,helpText:'First meaningful paint measures when the primary content of a page is visible. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint).',scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(tabTrace=>{if(!tabTrace.firstMeaningfulPaintEvt){throw new Error('No usable `firstMeaningfulPaint(Candidate)` events found in trace');}
if(!tabTrace.navigationStartEvt){throw new Error('No `navigationStart` event found in trace');}
const result=this.calculateScore(tabTrace);return{score:result.score,rawValue:parseFloat(result.duration),displayValue:Util.formatMilliseconds(result.duration),debugString:result.debugString,optimalValue:this.meta.optimalValue,extendedInfo:{value:result.extendedInfo,formatter:Formatter.SUPPORTED_FORMATS.NULL}};});}
static calculateScore(traceOfTab){const extendedInfo={timestamps:{navStart:traceOfTab.timestamps.navigationStart*1000,fCP:traceOfTab.timestamps.firstContentfulPaint*1000,fMP:traceOfTab.timestamps.firstMeaningfulPaint*1000,onLoad:traceOfTab.timestamps.onLoad*1000,endOfTrace:traceOfTab.timestamps.traceEnd*1000},timings:{navStart:0,fCP:traceOfTab.timings.firstContentfulPaint,fMP:traceOfTab.timings.firstMeaningfulPaint,onLoad:traceOfTab.timings.onLoad,endOfTrace:traceOfTab.timings.traceEnd}};Object.keys(extendedInfo.timings).forEach(key=>{const val=extendedInfo.timings[key];if(typeof val!=='number'||Number.isNaN(val)){extendedInfo.timings[key]=undefined;extendedInfo.timestamps[key]=undefined;}else{extendedInfo.timings[key]=parseFloat(extendedInfo.timings[key].toFixed(3));}});const firstMeaningfulPaint=traceOfTab.timings.firstMeaningfulPaint;const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);let score=100*distribution.computeComplementaryPercentile(firstMeaningfulPaint);score=Math.min(100,score);score=Math.max(0,score);return{duration:firstMeaningfulPaint.toFixed(1),score:Math.round(score),rawValue:firstMeaningfulPaint,extendedInfo};}}
module.exports=FirstMeaningfulPaint;},{"../lib/traces/tracing-processor":26,"../report/formatter":29,"../report/v2/renderer/util.js":30,"./audit":2}],"../audits/is-on-https":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../report/formatter');const URL=require('../lib/url-shim');const SECURE_SCHEMES=['data','https','wss','blob','chrome','chrome-extension'];const SECURE_DOMAINS=['localhost','127.0.0.1'];class HTTPS extends Audit{static get meta(){return{category:'Security',name:'is-on-https',description:'Uses HTTPS',helpText:'All sites should be protected with HTTPS, even ones that don\'t handle '+'sensitive data. HTTPS prevents intruders from tampering with or passively listening '+'in on the communications between your app and your users, and is a prerequisite for '+'HTTP/2 and many new web platform APIs. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/https).',requiredArtifacts:['devtoolsLogs']};}
static isSecureRecord(record){return SECURE_SCHEMES.includes(record.scheme)||SECURE_DOMAINS.includes(record.domain);}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const insecureRecords=networkRecords.filter(record=>!HTTPS.isSecureRecord(record)).map(record=>({url:URL.getURLDisplayName(record.url,{preserveHost:true})}));let displayValue='';if(insecureRecords.length>1){displayValue=`${insecureRecords.length} insecure requests found`;}else if(insecureRecords.length===1){displayValue=`${insecureRecords.length} insecure request found`;}
return{rawValue:insecureRecords.length===0,displayValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.URL_LIST,value:insecureRecords},details:{type:'list',header:{type:'text',text:'Insecure URLs:'},items:insecureRecords.map(record=>({type:'text',text:record.url}))}};});}}
module.exports=HTTPS;},{"../lib/url-shim":27,"../report/formatter":29,"./audit":2}],"../audits/load-fast-enough-for-pwa":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const Emulation=require('../lib/emulation');const Formatter=require('../report/formatter');const MAXIMUM_TTFI=10*1000;const WHITELISTED_STATUS_CODES=[307];class LoadFastEnough4Pwa extends Audit{static get meta(){return{category:'PWA',name:'load-fast-enough-for-pwa',description:'Page load is fast enough on 3G',helpText:'Satisfied if the Time To Interactive duration is shorter than 10 seconds, as defined by the [PWA Baseline Checklist](https://developers.google.com/web/progressive-web-apps/checklist). Network throttling is required (specifically: RTT latencies >= 150 RTT are expected).',requiredArtifacts:['traces','devtoolsLogs']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const firstRequestLatenciesByOrigin=new Map();networkRecords.forEach(record=>{const fromCache=record._fromDiskCache||record._fromMemoryCache;const origin=URL.getOrigin(record._url);if(!origin||!record._timing||fromCache||WHITELISTED_STATUS_CODES.includes(record.statusCode)||!record.finished){return;}
if(record._startTime<record._issueTime){return;}
const latency=record._timing.receiveHeadersEnd-record._timing.sendEnd;const latencyInfo={url:record._url,startTime:record._startTime,origin,latency};const existing=firstRequestLatenciesByOrigin.get(origin);if(!existing||latencyInfo.startTime<existing.startTime){firstRequestLatenciesByOrigin.set(origin,latencyInfo);}});let firstRequestLatencies=Array.from(firstRequestLatenciesByOrigin.values());const latency3gMin=Emulation.settings.TYPICAL_MOBILE_THROTTLING_METRICS.targetLatency-10;const areLatenciesAll3G=firstRequestLatencies.every(val=>val.latency>latency3gMin);firstRequestLatencies=firstRequestLatencies.map(item=>({url:item.url,latency:item.latency.toLocaleString(undefined,{maximumFractionDigits:2})}));const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestFirstInteractive(trace).then(firstInteractive=>{const timeToFirstInteractive=firstInteractive.timeInMs;const isFast=timeToFirstInteractive<MAXIMUM_TTFI;const extendedInfo={formatter:Formatter.SUPPORTED_FORMATS.NULL,value:{areLatenciesAll3G,firstRequestLatencies,isFast,timeToFirstInteractive}};const details=Audit.makeV2TableDetails([{key:'url',itemType:'url',text:'URL'},{key:'latency',itemType:'text',text:'Latency (ms)'}],firstRequestLatencies);if(!areLatenciesAll3G){return{rawValue:false,debugString:`First Interactive was found at ${timeToFirstInteractive.toLocaleString()}, however, the network request latencies were not sufficiently realistic, so the performance measurements cannot be trusted.`,extendedInfo,details};}
if(!isFast){return{rawValue:false,debugString:`Under 3G conditions, First Interactive was at ${timeToFirstInteractive.toLocaleString()}. More details in the "Performance" section.`,extendedInfo};}
return{rawValue:true,extendedInfo};});});}}
module.exports=LoadFastEnough4Pwa;},{"../lib/emulation":18,"../lib/url-shim":27,"../report/formatter":29,"./audit":2}],"../audits/manifest-short-name-length":[function(require,module,exports){'use strict';const Audit=require('./audit');class ManifestShortNameLength extends Audit{static get meta(){return{category:'Manifest',name:'manifest-short-name-length',description:'Manifest\'s `short_name` won\'t be truncated when displayed on homescreen',helpText:'Make your app\'s `short_name` less than 12 characters to '+'ensure that it\'s not truncated on homescreens. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/manifest-short_name-is-not-truncated).',requiredArtifacts:['Manifest']};}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure){failures.push(manifestValues.parseFailureReason);return;}
const themeColorCheck=manifestValues.allChecks.find(i=>i.id==='hasThemeColor');if(!themeColorCheck.passing){failures.push(themeColorCheck.failureText);}}
static audit(artifacts){return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{if(manifestValues.isParseFailure){return{rawValue:false};}
const hasShortName=manifestValues.allChecks.find(i=>i.id==='hasShortName').passing;if(!hasShortName){return{rawValue:false,debugString:'No short_name found in manifest.'};}
const isShortEnough=manifestValues.allChecks.find(i=>i.id==='shortNameLength').passing;return{rawValue:isShortEnough};});}}
module.exports=ManifestShortNameLength;},{"./audit":2}],"../audits/manual/pwa-cross-browser":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWACrossBrowser extends ManualAudit{static get meta(){return Object.assign({category:'PWA',name:'pwa-cross-browser',helpText:'To reach the most number of users, sites should work across '+'every major browser. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#site-works-cross-browser).',description:'Site works cross-browser'},super.meta);}}
module.exports=PWACrossBrowser;},{"./manual-audit":4}],"../audits/manual/pwa-each-page-has-url":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWAEachPageHasURL extends ManualAudit{static get meta(){return Object.assign({category:'PWA',name:'pwa-each-page-has-url',helpText:'Ensure individual pages are deep linkable via the URLs and that URLs are '+'unique for the purpose of shareability on social media. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#each-page-has-a-url).',description:'Each page has a URL'},super.meta);}}
module.exports=PWAEachPageHasURL;},{"./manual-audit":4}],"../audits/manual/pwa-page-transitions":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWAPageTransitions extends ManualAudit{static get meta(){return Object.assign({category:'PWA',name:'pwa-page-transitions',helpText:'Transitions should feel snappy as you tap around, even on a slow network, a key '+'to perceived performance. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#page-transitions-dont-feel-like-they-block-on-the-network).',description:'Page transitions don\'t feel like they block on the network'},super.meta);}}
module.exports=PWAPageTransitions;},{"./manual-audit":4}],"../audits/redirects-http":[function(require,module,exports){'use strict';const Audit=require('./audit');class RedirectsHTTP extends Audit{static get meta(){return{category:'Security',name:'redirects-http',description:'Redirects HTTP traffic to HTTPS',helpText:'If you\'ve already set up HTTPS, make sure that you redirect all HTTP traffic '+'to HTTPS. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-redirects-to-https).',requiredArtifacts:['HTTPRedirect']};}
static audit(artifacts){return{rawValue:artifacts.HTTPRedirect.value,debugString:artifacts.HTTPRedirect.debugString};}}
module.exports=RedirectsHTTP;},{"./audit":2}],"../audits/screenshot-thumbnails":[function(require,module,exports){'use strict';const Audit=require('./audit');const TTFI=require('./first-interactive');const TTCI=require('./consistently-interactive');const jpeg=require('jpeg-js');const NUMBER_OF_THUMBNAILS=10;const THUMBNAIL_WIDTH=60;class ScreenshotThumbnails extends Audit{static get meta(){return{category:'Images',name:'screenshot-thumbnails',informative:true,description:'Screenshot Thumbnails',helpText:'This is what the load of your site looked like.',requiredArtifacts:['traces']};}
static scaleImageToThumbnail(imageData){const scaledWidth=THUMBNAIL_WIDTH;const scaleFactor=imageData.width/scaledWidth;const scaledHeight=Math.floor(imageData.height/scaleFactor);const outPixels=new Uint8Array(scaledWidth*scaledHeight*4);for(let i=0;i<scaledWidth;i++){for(let j=0;j<scaledHeight;j++){const origX=Math.floor(i*scaleFactor);const origY=Math.floor(j*scaleFactor);const origPos=(origY*imageData.width+origX)*4;const outPos=(j*scaledWidth+i)*4;outPixels[outPos]=imageData.data[origPos];outPixels[outPos+1]=imageData.data[origPos+1];outPixels[outPos+2]=imageData.data[origPos+2];outPixels[outPos+3]=imageData.data[origPos+3];}}
return{width:scaledWidth,height:scaledHeight,data:outPixels};}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];const cachedThumbnails=new Map();return Promise.all([artifacts.requestSpeedline(trace),TTFI.audit(artifacts).catch(()=>({rawValue:0})),TTCI.audit(artifacts).catch(()=>({rawValue:0}))]).then(([speedline,ttfi,ttci])=>{const thumbnails=[];const analyzedFrames=speedline.frames.filter(frame=>!frame.isProgressInterpolated());const timelineEnd=Math.max(speedline.complete,ttfi.rawValue,ttci.rawValue);for(let i=1;i<=NUMBER_OF_THUMBNAILS;i++){const targetTimestamp=speedline.beginning+timelineEnd*i/NUMBER_OF_THUMBNAILS;let frameForTimestamp=null;if(i===NUMBER_OF_THUMBNAILS){frameForTimestamp=analyzedFrames[analyzedFrames.length-1];}else{analyzedFrames.forEach(frame=>{if(frame.getTimeStamp()<=targetTimestamp){frameForTimestamp=frame;}});}
const imageData=frameForTimestamp.getParsedImage();const thumbnailImageData=ScreenshotThumbnails.scaleImageToThumbnail(imageData);const base64Data=cachedThumbnails.get(frameForTimestamp)||jpeg.encode(thumbnailImageData,90).data.toString('base64');cachedThumbnails.set(frameForTimestamp,base64Data);thumbnails.push({timing:Math.round(targetTimestamp-speedline.beginning),timestamp:targetTimestamp*1000,data:base64Data});}
return{score:100,rawValue:thumbnails.length>0,details:{type:'filmstrip',scale:timelineEnd,items:thumbnails}};});}}
module.exports=ScreenshotThumbnails;},{"./audit":2,"./consistently-interactive":"../audits/consistently-interactive","./first-interactive":"../audits/first-interactive","jpeg-js":275}],"../audits/service-worker":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');class ServiceWorker extends Audit{static get meta(){return{category:'Offline',name:'service-worker',description:'Registers a Service Worker',helpText:'The service worker is the technology that enables your app to use many '+'Progressive Web App features, such as offline, add to homescreen, and push '+'notifications. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/registered-service-worker).',requiredArtifacts:['URL','ServiceWorker']};}
static audit(artifacts){const versions=artifacts.ServiceWorker.versions;const url=artifacts.URL.finalUrl;const origin=new URL(url).origin;const matchingSW=versions.filter(v=>v.status==='activated').find(v=>new URL(v.scriptURL).origin===origin);return{rawValue:!!matchingSW};}}
module.exports=ServiceWorker;},{"../lib/url-shim":27,"./audit":2}],"../audits/speed-index-metric":[function(require,module,exports){'use strict';const Audit=require('./audit');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../report/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=1250;const SCORING_MEDIAN=5500;class SpeedIndexMetric extends Audit{static get meta(){return{category:'Performance',name:'speed-index-metric',description:'Perceptual Speed Index',helpText:'Speed Index shows how quickly the contents of a page are visibly populated. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/speed-index).',optimalValue:`< ${SCORING_POINT_OF_DIMINISHING_RETURNS.toLocaleString()}`,scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static audit(artifacts){const trace=artifacts.traces[this.DEFAULT_PASS];return artifacts.requestSpeedline(trace).then(speedline=>{if(speedline.frames.length===0){throw new Error('Trace unable to find visual progress frames.');}
if(speedline.speedIndex===0){throw new Error('Error in Speedline calculating Speed Index (speedIndex of 0).');}
let visuallyReadyInMs=undefined;speedline.frames.forEach(frame=>{if(frame.getPerceptualProgress()>=85&&typeof visuallyReadyInMs==='undefined'){visuallyReadyInMs=frame.getTimeStamp()-speedline.beginning;}});const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);let score=100*distribution.computeComplementaryPercentile(speedline.perceptualSpeedIndex);score=Math.min(100,score);score=Math.max(0,score);const extendedInfo={timings:{firstVisualChange:speedline.first,visuallyReady:visuallyReadyInMs,visuallyComplete:speedline.complete,speedIndex:speedline.speedIndex,perceptualSpeedIndex:speedline.perceptualSpeedIndex},timestamps:{firstVisualChange:(speedline.first+speedline.beginning)*1000,visuallyReady:(visuallyReadyInMs+speedline.beginning)*1000,visuallyComplete:(speedline.complete+speedline.beginning)*1000,speedIndex:(speedline.speedIndex+speedline.beginning)*1000,perceptualSpeedIndex:(speedline.perceptualSpeedIndex+speedline.beginning)*1000},frames:speedline.frames.map(frame=>{return{timestamp:frame.getTimeStamp(),progress:frame.getPerceptualProgress()};})};return{score:Math.round(score),rawValue:Math.round(speedline.perceptualSpeedIndex),optimalValue:this.meta.optimalValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.SPEEDLINE,value:extendedInfo}};});}}
module.exports=SpeedIndexMetric;},{"../lib/traces/tracing-processor":26,"../report/formatter":29,"./audit":2}],"../audits/splash-screen":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');class SplashScreen extends MultiCheckAudit{static get meta(){return{category:'PWA',name:'splash-screen',description:'Configured for a custom splash screen',helpText:'A default splash screen will be constructed for your app, but satisfying these requirements guarantee a high-quality [splash screen](https://developers.google.com/web/updates/2015/10/splashscreen) that transitions the user from tapping the home screen icon to your app\'s first paint',requiredArtifacts:['Manifest']};}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure){failures.push(manifestValues.parseFailureReason);return;}
const splashScreenCheckIds=['hasName','hasBackgroundColor','hasThemeColor','hasIconsAtLeast512px'];manifestValues.allChecks.filter(item=>splashScreenCheckIds.includes(item.id)).forEach(item=>{if(!item.passing){failures.push(item.failureText);}});}
static audit_(artifacts){const failures=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{SplashScreen.assessManifest(manifestValues,failures);return{failures,manifestValues};});}}
module.exports=SplashScreen;},{"./multi-check-audit":5}],"../audits/themed-omnibox":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const validColor=require('../lib/web-inspector').Color.parse;class ThemedOmnibox extends MultiCheckAudit{static get meta(){return{category:'PWA',name:'themed-omnibox',description:'Address bar matches brand colors',helpText:'The browser address bar can be themed to match your site. A `theme-color` [meta tag](https://developers.google.com/web/updates/2014/11/Support-for-theme-color-in-Chrome-39-for-Android) will upgrade the address bar when a user browses the site, and the [manifest theme-color](https://developers.google.com/web/updates/2015/08/using-manifest-to-set-sitewide-theme-color) will apply the same theme site-wide once it\'s been added to homescreen.',requiredArtifacts:['Manifest','ThemeColor']};}
static assessMetaThemecolor(themeColorMeta,failures){if(themeColorMeta===null){failures.push('No `<meta name="theme-color">` tag found');}else if(!validColor(themeColorMeta)){failures.push('The theme-color meta tag did not contain a valid CSS color');}}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure){failures.push(manifestValues.parseFailureReason);return;}
const themeColorCheck=manifestValues.allChecks.find(i=>i.id==='hasThemeColor');if(!themeColorCheck.passing){failures.push(themeColorCheck.failureText);}}
static audit_(artifacts){const failures=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{ThemedOmnibox.assessManifest(manifestValues,failures);ThemedOmnibox.assessMetaThemecolor(artifacts.ThemeColor,failures);return{failures,manifestValues,themeColor:artifacts.ThemeColor};});}}
module.exports=ThemedOmnibox;},{"../lib/web-inspector":28,"./multi-check-audit":5}],"../audits/time-to-firstbyte":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../report/formatter');const URL=require('../lib/url-shim');const TTFB_THRESHOLD=200;const TTFB_THRESHOLD_BUFFER=15;class TTFBMetric extends Audit{static get meta(){return{category:'Performance',name:'time-to-firstbyte',description:'Time To First Byte (TTFB)',informative:true,helpText:'Time To First Byte identifies the time at which your server sends a response.'+'[Learn more](https://developers.google.com/web/tools/chrome-devtools/network-performance/issues).',requiredArtifacts:['networkRecords']};}
static caclulateTTFB(record){const timing=record._timing;return timing.receiveHeadersEnd-timing.sendEnd;}
static audit(artifacts){const networkRecords=artifacts.networkRecords[Audit.DEFAULT_PASS];const results=[];const walk=node=>{const children=Object.keys(node);children.forEach(id=>{const child=node[id];const networkRecord=networkRecords.find(record=>record._requestId===id);if(networkRecord){const ttfb=TTFBMetric.caclulateTTFB(networkRecord);results.push({url:URL.getURLDisplayName(networkRecord._url),ttfb:`${Math.round(ttfb).toLocaleString()} ms`,rawTTFB:ttfb});}
if(child.children){walk(child.children);}});};return artifacts.requestCriticalRequestChains(networkRecords).then(tree=>{walk(tree);const recordsOverBudget=results.filter(row=>row.rawTTFB>TTFB_THRESHOLD+TTFB_THRESHOLD_BUFFER);let displayValue;if(recordsOverBudget.length){displayValue=recordsOverBudget.length+` critical request(s) went over the ${TTFB_THRESHOLD} ms threshold`;}
return{rawValue:recordsOverBudget.length===0,displayValue,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.TABLE,value:{results,tableHeadings:{url:'Request URL',ttfb:'Time To First Byte'}}}};});}}
module.exports=TTFBMetric;},{"../lib/url-shim":27,"../report/formatter":29,"./audit":2}],"../audits/time-to-interactive":[function(require,module,exports){'use strict';const Audit=require('./audit');const TracingProcessor=require('../lib/traces/tracing-processor');const Formatter=require('../report/formatter');const SCORING_POINT_OF_DIMINISHING_RETURNS=1700;const SCORING_MEDIAN=5000;const SCORING_TARGET=5000;class TTIMetric extends Audit{static get meta(){return{category:'Performance',name:'time-to-interactive',description:'Time To Interactive (alpha)',helpText:'Time to Interactive identifies the time at which your app appears to be ready '+'enough to interact with. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/time-to-interactive).',optimalValue:`< ${SCORING_TARGET.toLocaleString()} ms`,scoringMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static _forwardWindowTTI(minTime,maxTime,data,windowSize=500){let startTime=minTime-50;let endTime;let currentLatency=Infinity;const percentiles=[0.9];const threshold=50;const foundLatencies=[];while(currentLatency>threshold){startTime+=50;endTime=startTime+windowSize;if(endTime>maxTime){return{currentLatency,foundLatencies};}
const latencies=TracingProcessor.getRiskToResponsiveness(data.model,data.trace,startTime,endTime,percentiles);const estLatency=latencies[0].time;foundLatencies.push({estLatency:estLatency,startTime:startTime.toFixed(1)});currentLatency=estLatency;}
return{timeInMs:startTime,currentLatency,foundLatencies};}
static findTTIAlpha(times,data){return TTIMetric._forwardWindowTTI(Math.max(times.fmpTiming,times.visuallyReadyTiming),times.traceEndTiming,data,500);}
static findTTIAlphaFMPOnly(times,data){return TTIMetric._forwardWindowTTI(times.fmpTiming,times.traceEndTiming,data,500);}
static findTTIAlphaFMPOnly5s(times,data){return TTIMetric._forwardWindowTTI(times.fmpTiming,times.traceEndTiming,data,5000);}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];let debugString;const pending=[artifacts.requestSpeedline(trace).catch(err=>{debugString=`Trace error: ${err.message}`;return null;}),artifacts.requestTraceOfTab(trace),artifacts.requestTracingModel(trace)];return Promise.all(pending).then(([speedline,tabTrace,model])=>{const fMPtsInMS=tabTrace.timestamps.firstMeaningfulPaint;const navStartTsInMS=tabTrace.timestamps.navigationStart;if(!fMPtsInMS){throw new Error('No firstMeaningfulPaint event found in trace');}
const onLoadTiming=tabTrace.timings.onLoad;const fmpTiming=tabTrace.timings.firstMeaningfulPaint;const traceEndTiming=tabTrace.timings.traceEnd;let visuallyReadyTiming=0;if(speedline&&speedline.frames){const eightyFivePctVC=speedline.frames.find(frame=>{return frame.getTimeStamp()>=fMPtsInMS&&frame.getProgress()>=85;});if(eightyFivePctVC){visuallyReadyTiming=eightyFivePctVC.getTimeStamp()-navStartTsInMS;}}
const times={fmpTiming,visuallyReadyTiming,traceEndTiming};const data={tabTrace,model,trace};const timeToInteractive=TTIMetric.findTTIAlpha(times,data);const timeToInteractiveB=TTIMetric.findTTIAlphaFMPOnly(times,data);const timeToInteractiveC=TTIMetric.findTTIAlphaFMPOnly5s(times,data);if(!timeToInteractive.timeInMs){throw new Error('Entire trace was found to be busy.');}
const distribution=TracingProcessor.getLogNormalDistribution(SCORING_MEDIAN,SCORING_POINT_OF_DIMINISHING_RETURNS);let score=100*distribution.computeComplementaryPercentile(timeToInteractive.timeInMs);score=Math.min(100,score);score=Math.max(0,score);score=Math.round(score);const extendedInfo={timings:{onLoad:onLoadTiming,fMP:parseFloat(fmpTiming.toFixed(3)),visuallyReady:parseFloat(visuallyReadyTiming.toFixed(3)),timeToInteractive:parseFloat(timeToInteractive.timeInMs.toFixed(3)),timeToInteractiveB:timeToInteractiveB.timeInMs,timeToInteractiveC:timeToInteractiveC.timeInMs,endOfTrace:traceEndTiming},timestamps:{onLoad:(onLoadTiming+navStartTsInMS)*1000,fMP:fMPtsInMS*1000,visuallyReady:(visuallyReadyTiming+navStartTsInMS)*1000,timeToInteractive:(timeToInteractive.timeInMs+navStartTsInMS)*1000,timeToInteractiveB:(timeToInteractiveB.timeInMs+navStartTsInMS)*1000,timeToInteractiveC:(timeToInteractiveC.timeInMs+navStartTsInMS)*1000,endOfTrace:(traceEndTiming+navStartTsInMS)*1000},latencies:{timeToInteractive:timeToInteractive.foundLatencies,timeToInteractiveB:timeToInteractiveB.foundLatencies,timeToInteractiveC:timeToInteractiveC.foundLatencies},expectedLatencyAtTTI:parseFloat(timeToInteractive.currentLatency.toFixed(3))};return{score,debugString,rawValue:parseFloat(timeToInteractive.timeInMs.toFixed(1)),displayValue:`${parseFloat(timeToInteractive.timeInMs.toFixed(1))}ms`,optimalValue:this.meta.optimalValue,extendedInfo:{value:extendedInfo,formatter:Formatter.SUPPORTED_FORMATS.NULL}};});}}
module.exports=TTIMetric;},{"../lib/traces/tracing-processor":26,"../report/formatter":29,"./audit":2}],"../audits/user-timings":[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../report/formatter');class UserTimings extends Audit{static get meta(){return{category:'Performance',name:'user-timings',description:'User Timing marks and measures',helpText:'Consider instrumenting your app with the User Timing API to create custom, '+'real-world measurements of key user experiences. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/user-timing).',requiredArtifacts:['traces'],informative:true};}
static filterTrace(tabTrace){const userTimings=[];const measuresStartTimes={};tabTrace.processEvents.filter(evt=>{if(!evt.cat.includes('blink.user_timing')){return false;}
return evt.name!=='requestStart'&&evt.name!=='navigationStart'&&evt.name!=='paintNonDefaultBackgroundColor'&&evt.args.frame===undefined;}).forEach(ut=>{if(ut.ph==='R'||ut.ph.toUpperCase()==='I'){userTimings.push({name:ut.name,isMark:true,args:ut.args,startTime:ut.ts});}else if(ut.ph.toLowerCase()==='b'){measuresStartTimes[ut.name]=ut.ts;}else if(ut.ph.toLowerCase()==='e'){userTimings.push({name:ut.name,isMark:false,args:ut.args,startTime:measuresStartTimes[ut.name],endTime:ut.ts});}});userTimings.forEach(ut=>{ut.startTime=(ut.startTime-tabTrace.navigationStartEvt.ts)/1000;if(!ut.isMark){ut.endTime=(ut.endTime-tabTrace.navigationStartEvt.ts)/1000;ut.duration=ut.endTime-ut.startTime;}});return userTimings;}
static get blacklistedPrefixes(){return['goog_'];}
static excludeBlacklisted(timing){return UserTimings.blacklistedPrefixes.every(prefix=>!timing.name.startsWith(prefix));}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(tabTrace=>{const userTimings=this.filterTrace(tabTrace).filter(UserTimings.excludeBlacklisted);const tableRows=userTimings.map(item=>{const time=item.isMark?item.startTime:item.duration;return{name:item.name,timingType:item.isMark?'Mark':'Measure',time:time.toLocaleString()+' ms',timeAsNumber:time};}).sort((itemA,itemB)=>{if(itemA.timingType===itemB.timingType){return itemA.timeAsNumber-itemB.timeAsNumber;}else if(itemA.timingType==='Measure'){return-1;}else{return 1;}});const headings=[{key:'name',itemType:'text',text:'Name'},{key:'timingType',itemType:'text',text:'Type'},{key:'time',itemType:'text',text:'Time'}];const details=Audit.makeV2TableDetails(headings,tableRows);return{rawValue:userTimings.length===0,displayValue:userTimings.length,extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.USER_TIMINGS,value:userTimings},details};});}}
module.exports=UserTimings;},{"../report/formatter":29,"./audit":2}],"../audits/viewport":[function(require,module,exports){'use strict';const Audit=require('./audit');const Parser=require('metaviewport-parser');class Viewport extends Audit{static get meta(){return{category:'Mobile Friendly',name:'viewport',description:'Has a `<meta name="viewport">` tag with `width` or `initial-scale`',helpText:'Add a viewport meta tag to optimize your app for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/has-viewport-meta-tag).',requiredArtifacts:['Viewport']};}
static audit(artifacts){if(artifacts.Viewport===null){return{debugString:'No viewport meta tag found',rawValue:false};}
let debugString='';const parsedProps=Parser.parseMetaViewPortContent(artifacts.Viewport);if(Object.keys(parsedProps.unknownProperties).length){debugString+=`Invalid properties found: ${JSON.stringify(parsedProps.unknownProperties)}. `;}
if(Object.keys(parsedProps.invalidValues).length){debugString+=`Invalid values found: ${JSON.stringify(parsedProps.invalidValues)}. `;}
debugString=debugString.trim();const viewportProps=parsedProps.validProperties;const hasMobileViewport=viewportProps.width||viewportProps['initial-scale'];return{rawValue:!!hasMobileViewport,debugString};}}
module.exports=Viewport;},{"./audit":2,"metaviewport-parser":278}],"../audits/webapp-install-banner":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const SWAudit=require('./service-worker');class WebappInstallBanner extends MultiCheckAudit{static get meta(){return{category:'PWA',name:'webapp-install-banner',description:'User can be prompted to Install the Web App',helpText:'While users can manually add your site to their homescreen, the [prompt (aka app install banner)](https://developers.google.com/web/fundamentals/engage-and-retain/app-install-banners/) will proactively prompt the user to install the app if the various requirements are met and the user has moderate engagement with your site.',requiredArtifacts:['URL','ServiceWorker','Manifest','StartUrl']};}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure){failures.push(manifestValues.parseFailureReason);return;}
const bannerCheckIds=['hasName','hasShortName','hasStartUrl','hasPWADisplayValue','hasIconsAtLeast192px'];manifestValues.allChecks.filter(item=>bannerCheckIds.includes(item.id)).forEach(item=>{if(!item.passing){failures.push(item.failureText);}});}
static assessServiceWorker(artifacts,failures){const hasServiceWorker=SWAudit.audit(artifacts).rawValue;if(!hasServiceWorker){failures.push('Site does not register a Service Worker');}}
static assessOfflineStartUrl(artifacts,failures){const hasOfflineStartUrl=artifacts.StartUrl===200;if(!hasOfflineStartUrl){failures.push('Manifest start_url is not cached by a Service Worker');}}
static audit_(artifacts){const failures=[];return artifacts.requestManifestValues(artifacts.Manifest).then(manifestValues=>{WebappInstallBanner.assessManifest(manifestValues,failures);WebappInstallBanner.assessServiceWorker(artifacts,failures);WebappInstallBanner.assessOfflineStartUrl(artifacts,failures);return{failures,manifestValues};});}}
module.exports=WebappInstallBanner;},{"./multi-check-audit":5,"./service-worker":"../audits/service-worker"}],"../audits/without-javascript":[function(require,module,exports){'use strict';const Audit=require('./audit');class WithoutJavaScript extends Audit{static get meta(){return{category:'JavaScript',name:'without-javascript',description:'Contains some content when JavaScript is not available',helpText:'Your app should display some content when JavaScript is disabled, even if it\'s '+'just a warning to the user that JavaScript is required to use the app. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/no-js).',requiredArtifacts:['HTMLWithoutJavaScript']};}
static audit(artifacts){const artifact=artifacts.HTMLWithoutJavaScript;if(artifact.value.trim()===''){return{rawValue:false,debugString:'The page body should render some content if its scripts are not available.'};}
return{rawValue:true};}}
module.exports=WithoutJavaScript;},{"./audit":2}],"../audits/works-offline":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');class WorksOffline extends Audit{static get meta(){return{category:'Offline',name:'works-offline',description:'Responds with a 200 when offline',helpText:'If you\'re building a Progressive Web App, consider using a service worker so '+'that your app can work offline. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-200-when-offline).',requiredArtifacts:['Offline','URL']};}
static audit(artifacts){let debugString;if(!URL.equalWithExcludedFragments(artifacts.URL.initialUrl,artifacts.URL.finalUrl)){debugString='WARNING: You may be failing this check because your test URL '+`(${artifacts.URL.initialUrl}) was redirected to "${artifacts.URL.finalUrl}". `+'Try testing the second URL directly.';}
return{rawValue:artifacts.Offline===200,debugString};}}
module.exports=WorksOffline;},{"../lib/url-shim":27,"./audit":2}],"./gather/computed/computed-artifact":[function(require,module,exports){'use strict';class ComputedArtifact{constructor(allComputedArtifacts){this._cache=new Map();this._allComputedArtifacts=allComputedArtifacts;}
compute_(artifact,allComputedArtifacts){throw new Error('compute_() not implemented for computed artifact '+this.name);}
request(artifact){if(this._cache.has(artifact)){return Promise.resolve(this._cache.get(artifact));}
const artifactPromise=Promise.resolve().then(_=>this.compute_(artifact,this._allComputedArtifacts));this._cache.set(artifact,artifactPromise);return artifactPromise;}}
module.exports=ComputedArtifact;},{}],"./gather/computed/critical-request-chains":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const WebInspector=require('../../lib/web-inspector');class CriticalRequestChains extends ComputedArtifact{get name(){return'CriticalRequestChains';}
isCritical(request){const resourceTypeCategory=request._resourceType&&request._resourceType._category;const nonCriticalResourceTypes=[WebInspector.resourceTypes.Image._category,WebInspector.resourceTypes.XHR._category];if(nonCriticalResourceTypes.includes(resourceTypeCategory)||request.mimeType&&request.mimeType.startsWith('image/')){return false;}
return['VeryHigh','High','Medium'].includes(request.priority());}
compute_(networkRecords){networkRecords=networkRecords.filter(req=>req.finished);const requestIdToRequests=new Map();for(const request of networkRecords){requestIdToRequests.set(request.requestId,request);}
const criticalRequests=networkRecords.filter(req=>this.isCritical(req));const flattenRequest=request=>{return{url:request._url,startTime:request.startTime,endTime:request.endTime,responseReceivedTime:request.responseReceivedTime,transferSize:request.transferSize};};const criticalRequestChains={};for(const request of criticalRequests){const ancestors=[];let ancestorRequest=request.initiatorRequest();let node=criticalRequestChains;while(ancestorRequest){const ancestorIsCritical=this.isCritical(ancestorRequest);if(!ancestorIsCritical||ancestors.includes(ancestorRequest.requestId)){ancestors.length=0;node=undefined;break;}
ancestors.push(ancestorRequest.requestId);ancestorRequest=ancestorRequest.initiatorRequest();}
let ancestor=ancestors.pop();while(ancestor){const parentRequest=requestIdToRequests.get(ancestor);const parentRequestId=parentRequest.requestId;if(!node[parentRequestId]){node[parentRequestId]={request:flattenRequest(parentRequest),children:{}};}
ancestor=ancestors.pop();node=node[parentRequestId].children;}
if(!node){continue;}
if(node[request.requestId]){continue;}
node[request.requestId]={request:flattenRequest(request),children:{}};}
return criticalRequestChains;}}
module.exports=CriticalRequestChains;},{"../../lib/web-inspector":28,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/first-interactive":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const TracingProcessor=require('../../lib/traces/tracing-processor');const LONG_TASK_THRESHOLD=50;const MAX_TASK_CLUSTER_DURATION=250;const MIN_TASK_CLUSTER_PADDING=1000;const MIN_TASK_CLUSTER_FMP_DISTANCE=5000;const MAX_QUIET_WINDOW_SIZE=5000;const TRACE_BUSY_MSG='The main thread was busy for the entire trace recording. '+'First Interactive requires the main thread to be idle for several seconds.';const EXPONENTIATION_COEFFICIENT=-Math.log(3-1)/15;class FirstInteractive extends ComputedArtifact{get name(){return'FirstInteractive';}
static getRequiredWindowSizeInMs(t){const tInSeconds=t/1000;const exponentiationComponent=Math.exp(EXPONENTIATION_COEFFICIENT*tInSeconds);return(4*exponentiationComponent+1)*1000;}
static getTaskClustersInWindow(tasks,startIndex,windowEnd){const clusters=[];let previousTaskEndTime=-Infinity;let currentCluster=null;const clusteringWindowEnd=windowEnd+MIN_TASK_CLUSTER_PADDING;const isInClusteringWindow=task=>task.start<clusteringWindowEnd;for(let i=startIndex;i<tasks.length;i++){if(!isInClusteringWindow(tasks[i])){break;}
const task=tasks[i];if(task.start-previousTaskEndTime>MIN_TASK_CLUSTER_PADDING){currentCluster=[];clusters.push(currentCluster);}
currentCluster.push(task);previousTaskEndTime=task.end;}
return clusters.map(tasks=>{const start=tasks[0].start;const end=tasks[tasks.length-1].end;const duration=end-start;return{start,end,duration};}).filter(cluster=>cluster.start<windowEnd);}
static findQuietWindow(FMP,traceEnd,longTasks){if(longTasks.length===0||longTasks[0].start>FMP+FirstInteractive.getRequiredWindowSizeInMs(0)){return FMP;}
const isTooCloseToFMP=cluster=>cluster.start<FMP+MIN_TASK_CLUSTER_FMP_DISTANCE;const isTooLong=cluster=>cluster.duration>MAX_TASK_CLUSTER_DURATION;const isBadCluster=cluster=>isTooCloseToFMP(cluster)||isTooLong(cluster);for(let i=0;i<longTasks.length;i++){const windowStart=longTasks[i].end;const windowSize=FirstInteractive.getRequiredWindowSizeInMs(windowStart-FMP);const windowEnd=windowStart+windowSize;if(windowEnd>traceEnd){throw new Error(TRACE_BUSY_MSG);}
if(i+1<longTasks.length&&longTasks[i+1].start-windowStart<=MIN_TASK_CLUSTER_PADDING){continue;}
const taskClusters=FirstInteractive.getTaskClustersInWindow(longTasks,i+1,windowEnd);const hasBadTaskClusters=taskClusters.some(isBadCluster);if(!hasBadTaskClusters){return windowStart;}}
throw new Error(TRACE_BUSY_MSG);}
computeWithArtifacts(trace,traceModel,traceOfTab){const navStart=traceOfTab.timestamps.navigationStart;const FMP=traceOfTab.timings.firstMeaningfulPaint;const DCL=traceOfTab.timings.domContentLoaded;const traceEnd=traceOfTab.timings.traceEnd;if(traceEnd-FMP<MAX_QUIET_WINDOW_SIZE){throw new Error('trace not at least 5 seconds longer than FMP');}
if(!FMP||!DCL){throw new Error(`No ${FMP?'domContentLoaded':'firstMeaningfulPaint'} event in trace`);}
const longTasksAfterFMP=TracingProcessor.getMainThreadTopLevelEvents(traceModel,trace,FMP).filter(evt=>evt.duration>=LONG_TASK_THRESHOLD);const firstInteractive=FirstInteractive.findQuietWindow(FMP,traceEnd,longTasksAfterFMP);const valueInMs=Math.max(firstInteractive,DCL);return{timeInMs:valueInMs,timestamp:(valueInMs+navStart)*1000};}
compute_(trace,artifacts){return Promise.all([artifacts.requestTracingModel(trace),artifacts.requestTraceOfTab(trace)]).then(([traceModel,traceOfTab])=>{return this.computeWithArtifacts(trace,traceModel,traceOfTab);});}}
module.exports=FirstInteractive;},{"../../lib/traces/tracing-processor":26,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/manifest-values":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const icons=require('../../lib/icons');const PWA_DISPLAY_VALUES=['minimal-ui','fullscreen','standalone'];const SUGGESTED_SHORTNAME_LENGTH=12;class ManifestValues extends ComputedArtifact{get name(){return'ManifestValues';}
static get validityIds(){return['hasManifest','hasParseableManifest'];}
static get manifestChecks(){return[{id:'hasStartUrl',failureText:'Manifest does not contain a `start_url`',validate:manifest=>!!manifest.value.start_url.value},{id:'hasIconsAtLeast192px',failureText:'Manifest does not have icons at least 192px',validate:manifest=>icons.doExist(manifest.value)&&icons.sizeAtLeast(192,manifest.value).length>0},{id:'hasIconsAtLeast512px',failureText:'Manifest does not have icons at least 512px',validate:manifest=>icons.doExist(manifest.value)&&icons.sizeAtLeast(512,manifest.value).length>0},{id:'hasPWADisplayValue',failureText:'Manifest\'s `display` value is not one of: '+PWA_DISPLAY_VALUES.join(' | '),validate:manifest=>PWA_DISPLAY_VALUES.includes(manifest.value.display.value)},{id:'hasBackgroundColor',failureText:'Manifest does not have `background_color`',validate:manifest=>!!manifest.value.background_color.value},{id:'hasThemeColor',failureText:'Manifest does not have `theme_color`',validate:manifest=>!!manifest.value.theme_color.value},{id:'hasShortName',failureText:'Manifest does not have `short_name`',validate:manifest=>!!manifest.value.short_name.value},{id:'shortNameLength',failureText:'Manifest `short_name` will be truncated when displayed on the homescreen',validate:manifest=>manifest.value.short_name.value&&manifest.value.short_name.value.length<=SUGGESTED_SHORTNAME_LENGTH},{id:'hasName',failureText:'Manifest does not have `name`',validate:manifest=>!!manifest.value.name.value}];}
compute_(manifest){let parseFailureReason;if(manifest===null){parseFailureReason='No manifest was fetched';}
if(manifest&&manifest.value===undefined){parseFailureReason='Manifest failed to parse as valid JSON';}
if(parseFailureReason){return{isParseFailure:true,parseFailureReason,allChecks:[]};}
const remainingChecks=ManifestValues.manifestChecks.map(item=>{item.passing=item.validate(manifest);return item;});return{isParseFailure:false,parseFailureReason,allChecks:remainingChecks};}}
module.exports=ManifestValues;},{"../../lib/icons":20,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/network-records":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkRecorder=require('../../lib/network-recorder');class NetworkRecords extends ComputedArtifact{get name(){return'NetworkRecords';}
compute_(devtoolsLog){return NetworkRecorder.recordsFromLogs(devtoolsLog);}}
module.exports=NetworkRecords;},{"../../lib/network-recorder":23,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/network-throughput":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class NetworkThroughput extends ComputedArtifact{get name(){return'NetworkThroughput';}
compute_(networkRecords){if(!networkRecords||!networkRecords.length){return 0;}
let totalBytes=0;const timeBoundaries=networkRecords.reduce((boundaries,record)=>{const scheme=record.parsedURL&&record.parsedURL.scheme;if(scheme==='data'||record.failed||!record.finished||record.statusCode>300||!record.transferSize){return boundaries;}
totalBytes+=record.transferSize;boundaries.push({time:record.responseReceivedTime,isStart:true});boundaries.push({time:record.endTime,isStart:false});return boundaries;},[]).sort((a,b)=>a.time-b.time);let inflight=0;let currentStart=0;let totalDuration=0;timeBoundaries.forEach(boundary=>{if(boundary.isStart){if(inflight===0){currentStart=boundary.time;}
inflight++;}else{inflight--;if(inflight===0){totalDuration+=boundary.time-currentStart;}}});return totalBytes/totalDuration;}}
module.exports=NetworkThroughput;},{"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/pushed-requests":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class PushedRequests extends ComputedArtifact{get name(){return'PushedRequests';}
compute_(records){const pushedRecords=records.filter(r=>r._timing&&!!r._timing.pushStart);return pushedRecords;}}
module.exports=PushedRequests;},{"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/screenshots":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const DevtoolsTimelineModel=require('../../lib/traces/devtools-timeline-model');class ScreenshotFilmstrip extends ComputedArtifact{get name(){return'Screenshots';}
fetchScreenshot(frame){return frame.imageDataPromise().then(data=>'data:image/jpg;base64,'+data);}
compute_(trace){const model=new DevtoolsTimelineModel(trace.traceEvents);const filmStripFrames=model.filmStripModel().frames();const frameFetches=filmStripFrames.map(frame=>this.fetchScreenshot(frame));return Promise.all(frameFetches).then(images=>{const result=filmStripFrames.map((frame,i)=>({timestamp:frame.timestamp,datauri:images[i]}));return result;});}}
module.exports=ScreenshotFilmstrip;},{"../../lib/traces/devtools-timeline-model":25,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/speedline":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const speedline=require('speedline');class Speedline extends ComputedArtifact{get name(){return'Speedline';}
compute_(trace,computedArtifacts){return computedArtifacts.requestTraceOfTab(trace).then(traceOfTab=>{const navStart=traceOfTab.timestamps.navigationStart*1000;return speedline(trace.traceEvents,{timeOrigin:navStart,fastMode:true});});}}
module.exports=Speedline;},{"./computed-artifact":"./gather/computed/computed-artifact","speedline":281}],"./gather/computed/trace-of-tab":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const log=require('../../lib/log');class TraceOfTab extends ComputedArtifact{get name(){return'TraceOfTab';}
compute_(trace){const keyEvents=trace.traceEvents.filter(e=>{return e.cat.includes('blink.user_timing')||e.cat.includes('loading')||e.cat.includes('devtools.timeline')||e.name==='TracingStartedInPage';}).sort((event0,event1)=>event0.ts-event1.ts);const startedInPageEvt=keyEvents.find(e=>e.name==='TracingStartedInPage');const frameEvents=keyEvents.filter(e=>e.args.frame===startedInPageEvt.args.data.page);const navigationStart=frameEvents.filter(e=>e.name==='navigationStart').pop();if(!navigationStart)throw new Error('navigationStart was not found in the trace');const firstPaint=frameEvents.find(e=>e.name==='firstPaint'&&e.ts>navigationStart.ts);const firstContentfulPaint=frameEvents.find(e=>e.name==='firstContentfulPaint'&&e.ts>navigationStart.ts);let firstMeaningfulPaint=frameEvents.find(e=>e.name==='firstMeaningfulPaint'&&e.ts>navigationStart.ts);if(!firstMeaningfulPaint){const fmpCand='firstMeaningfulPaintCandidate';log.verbose('trace-of-tab',`No firstMeaningfulPaint found, falling back to last ${fmpCand}`);const lastCandidate=frameEvents.filter(e=>e.name===fmpCand).pop();if(!lastCandidate){log.verbose('trace-of-tab','No `firstMeaningfulPaintCandidate` events found in trace');}
firstMeaningfulPaint=lastCandidate;}
const onLoad=frameEvents.find(e=>e.name==='loadEventEnd'&&e.ts>navigationStart.ts);const domContentLoaded=frameEvents.find(e=>e.name==='domContentLoadedEventEnd'&&e.ts>navigationStart.ts);const processEvents=trace.traceEvents.filter(e=>e.pid===startedInPageEvt.pid).sort((event0,event1)=>event0.ts-event1.ts);const traceEnd=trace.traceEvents.reduce((max,evt)=>{return max.ts>evt.ts?max:evt;});const metrics={navigationStart,firstPaint,firstContentfulPaint,firstMeaningfulPaint,traceEnd,onLoad,domContentLoaded};const timings={};const timestamps={};Object.keys(metrics).forEach(metric=>{timestamps[metric]=metrics[metric]&&metrics[metric].ts/1000;timings[metric]=timestamps[metric]-timestamps.navigationStart;});return{timings,timestamps,processEvents,startedInPageEvt:startedInPageEvt,navigationStartEvt:navigationStart,firstPaintEvt:firstPaint,firstContentfulPaintEvt:firstContentfulPaint,firstMeaningfulPaintEvt:firstMeaningfulPaint,onLoadEvt:onLoad};}}
module.exports=TraceOfTab;},{"../../lib/log":21,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gather/computed/tracing-model":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const TracingProcessor=require('../../lib/traces/tracing-processor');class TracingModel extends ComputedArtifact{get name(){return'TracingModel';}
compute_(trace){const tracingProcessor=new TracingProcessor();return tracingProcessor.init(trace);}}
module.exports=TracingModel;},{"../../lib/traces/tracing-processor":26,"./computed-artifact":"./gather/computed/computed-artifact"}],"./gatherers/accessibility":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const axeLibSource="/*! aXe v2.2.1\n * Copyright (c) 2017 Deque Systems, Inc.\n *\n * Your use of this Source Code Form is subject to the terms of the Mozilla Public\n * License, v. 2.0. If a copy of the MPL was not distributed with this\n * file, You can obtain one at http://mozilla.org/MPL/2.0/.\n *\n * This entire copyright notice must appear in every copy of this file you\n * distribute or in any file that contains substantial portions of this source\n * code.\n */\n!function a(window){function b(a){this.name=\"SupportError\",this.cause=a.cause,this.message=\"`\"+a.cause+\"` - feature unsupported in your environment.\",a.ruleId&&(this.ruleId=a.ruleId,this.message+=\" Skipping \"+this.ruleId+\" rule.\"),this.stack=(new Error).stack}function c(a){\"use strict\";var b;return a?(b=axe.utils.clone(a),b.commons=a.commons):b={},b.reporter=b.reporter||null,b.rules=b.rules||[],b.checks=b.checks||[],b.data=Object.assign({checks:{},rules:{}},b.data),b}function d(a,b,c){\"use strict\";var d,e;for(d=0,e=a.length;d<e;d++)b[c](a[d])}function e(a){this.brand=\"axe\",this.application=\"axeAPI\",this.tagExclude=[\"experimental\"],this.defaultConfig=a,this._init()}function f(a,b,c){var d=a.brand,e=a.application;return axe.constants.helpUrlBase+d+\"/\"+(c||axe.version.substring(0,axe.version.lastIndexOf(\".\")))+\"/\"+b+\"?application=\"+e}function g(a){\"use strict\";this.id=a.id,this.data=null,this.relatedNodes=[],this.result=null}function h(a){\"use strict\";return\"string\"==typeof a?new Function(\"return \"+a+\";\")():a}function i(a){a&&(this.id=a.id,this.configure(a))}function j(a,b){\"use strict\";if(!axe.utils.isHidden(b)){axe.utils.findBy(a,\"node\",b)||a.push({node:b,include:[],exclude:[]})}}function k(a,b,c){\"use strict\";a.frames=a.frames||[];var d,e,f=document.querySelectorAll(c.shift());a:for(var g=0,h=f.length;g<h;g++){e=f[g];for(var i=0,j=a.frames.length;i<j;i++)if(a.frames[i].node===e){a.frames[i][b].push(c);break a}d={node:e,include:[],exclude:[]},c&&d[b].push(c),a.frames.push(d)}}function l(a){\"use strict\";if(a&&\"object\"===(void 0===a?\"undefined\":Z(a))||a instanceof NodeList){if(a instanceof Node)return{include:[a],exclude:[]};if(a.hasOwnProperty(\"include\")||a.hasOwnProperty(\"exclude\"))return{include:a.include&&+a.include.length?a.include:[document],exclude:a.exclude||[]};if(a.length===+a.length)return{include:a,exclude:[]}}return\"string\"==typeof a?{include:[a],exclude:[]}:{include:[document],exclude:[]}}function m(a,b){\"use strict\";for(var c,d=[],e=0,f=a[b].length;e<f;e++){if(\"string\"==typeof(c=a[b][e])){d=d.concat(axe.utils.toArray(document.querySelectorAll(c)));break}!c||!c.length||c instanceof Node?d.push(c):c.length>1?k(a,b,c):d=d.concat(axe.utils.toArray(document.querySelectorAll(c[0])))}return d.filter(function(a){return a})}function n(a){\"use strict\";if(0===a.include.length){if(0===a.frames.length){var b=axe.utils.respondable.isInFrame()?\"frame\":\"page\";return new Error(\"No elements found for include in \"+b+\" Context\")}a.frames.forEach(function(a,b){if(0===a.include.length)return new Error(\"No elements found for include in Context of frame \"+b)})}}function o(a){\"use strict\";var b=this;this.frames=[],this.initiator=!a||\"boolean\"!=typeof a.initiator||a.initiator,this.page=!1,a=l(a),this.exclude=a.exclude,this.include=a.include,this.include=m(this,\"include\"),this.exclude=m(this,\"exclude\"),axe.utils.select(\"frame, iframe\",this).forEach(function(a){X(a,b)&&j(b.frames,a)}),1===this.include.length&&this.include[0]===document&&(this.page=!0);var c=n(this);if(c instanceof Error)throw c}function p(a){\"use strict\";this.id=a.id,this.result=axe.constants.NA,this.pageLevel=a.pageLevel,this.impact=null,this.nodes=[]}function q(a,b){\"use strict\";this._audit=b,this.id=a.id,this.selector=a.selector||\"*\",this.excludeHidden=\"boolean\"!=typeof a.excludeHidden||a.excludeHidden,this.enabled=\"boolean\"!=typeof a.enabled||a.enabled,this.pageLevel=\"boolean\"==typeof a.pageLevel&&a.pageLevel,this.any=a.any||[],this.all=a.all||[],this.none=a.none||[],this.tags=a.tags||[],a.matches&&(this.matches=h(a.matches))}function r(a){\"use strict\";return axe.utils.getAllChecks(a).map(function(b){var c=a._audit.checks[b.id||b];return c&&\"function\"==typeof c.after?c:null}).filter(Boolean)}function s(a,b){\"use strict\";var c=[];return a.forEach(function(a){axe.utils.getAllChecks(a).forEach(function(a){a.id===b&&c.push(a)})}),c}function t(a){\"use strict\";return a.filter(function(a){return!0!==a.filtered})}function u(a){\"use strict\";var b=[\"any\",\"all\",\"none\"],c=a.nodes.filter(function(a){var c=0;return b.forEach(function(b){a[b]=t(a[b]),c+=a[b].length}),c>0});return a.pageLevel&&c.length&&(c=[c.reduce(function(a,c){if(a)return b.forEach(function(b){a[b].push.apply(a[b],c[b])}),a})]),c}function v(a,b){\"use strict\";if(!axe._audit)throw new Error(\"No audit configured\");var c=axe.utils.queue(),d=[];Object.keys(axe.plugins).forEach(function(a){c.defer(function(b){var c=function(a){d.push(a),b()};try{axe.plugins[a].cleanup(b,c)}catch(a){c(a)}})}),axe.utils.toArray(document.querySelectorAll(\"frame, iframe\")).forEach(function(a){c.defer(function(b,c){return axe.utils.sendCommandToFrame(a,{command:\"cleanup-plugin\"},b,c)})}),c.then(function(c){0===d.length?a(c):b(d)}).catch(b)}function w(a){\"use strict\";var b;if(!(b=axe._audit))throw new Error(\"No audit configured\");a.reporter&&(\"function\"==typeof a.reporter||aa[a.reporter])&&(b.reporter=a.reporter),a.checks&&a.checks.forEach(function(a){b.addCheck(a)}),a.rules&&a.rules.forEach(function(a){b.addRule(a)}),void 0!==a.branding?b.setBranding(a.branding):b._constructHelpUrls(),a.tagExclude&&(b.tagExclude=a.tagExclude)}function x(a,b,c){\"use strict\";var d=c,e=function(a){a instanceof Error==!1&&(a=new Error(a)),c(a)},f=a&&a.context||{};f.include&&!f.include.length&&(f.include=[document]);var g=a&&a.options||{};switch(a.command){case\"rules\":return A(f,g,d,e);case\"cleanup-plugin\":return v(d,e);default:if(axe._audit&&axe._audit.commands&&axe._audit.commands[a.command])return axe._audit.commands[a.command](a,c)}}function y(a){\"use strict\";this._run=a.run,this._collect=a.collect,this._registry={},a.commands.forEach(function(a){axe._audit.registerCommand(a)})}function z(){\"use strict\";var a=axe._audit;if(!a)throw new Error(\"No audit configured\");a.resetRulesAndChecks()}function A(a,b,c,d){\"use strict\";try{a=new o(a)}catch(a){return d(a)}var e=axe.utils.queue(),f=axe._audit;b.performanceTimer&&axe.utils.performanceTimer.auditStart(),a.frames.length&&!1!==b.iframes&&e.defer(function(c,d){axe.utils.collectResultsFromFrames(a,b,\"rules\",null,c,d)}),e.defer(function(c,d){f.run(a,b,c,d)}),e.then(function(e){try{b.performanceTimer&&axe.utils.performanceTimer.auditEnd();var g=axe.utils.mergeResults(e.map(function(a){return{results:a}}));a.initiator&&(g=f.after(g,b),g.forEach(axe.utils.publishMetaData),g=g.map(axe.utils.finalizeRuleResult));try{c(g)}catch(a){axe.log(a)}}catch(a){d(a)}}).catch(d)}function B(a){\"use strict\";switch(!0){case\"string\"==typeof a:case Array.isArray(a):case Node&&a instanceof Node:case NodeList&&a instanceof NodeList:return!0;case\"object\"!==(void 0===a?\"undefined\":Z(a)):return!1;case void 0!==a.include:case void 0!==a.exclude:case\"number\"==typeof a.length:return!0;default:return!1}}function C(a,b,c){\"use strict\";var d=new TypeError(\"axe.run arguments are invalid\");if(!B(a)){if(void 0!==c)throw d;c=b,b=a,a=document}if(\"object\"!==(void 0===b?\"undefined\":Z(b))){if(void 0!==c)throw d;c=b,b={}}if(\"function\"!=typeof c&&void 0!==c)throw d;return{context:a,options:b,callback:c||ba}}function D(a,b){\"use strict\";[\"any\",\"all\",\"none\"].forEach(function(c){Array.isArray(a[c])&&a[c].filter(function(a){return Array.isArray(a.relatedNodes)}).forEach(function(a){a.relatedNodes=a.relatedNodes.map(function(a){var c={html:a.source};return b.elementRef&&!a.fromFrame&&(c.element=a.element),(!1!==b.selectors||a.fromFrame)&&(c.target=a.selector),b.xpath&&(c.xpath=a.xpath),c})})})}function E(a,b){return ea.reduce(function(c,d){return c[d]=(a[d]||[]).map(function(a){return b(a,d)}),c},{})}function F(a,b,c){var d=Object.assign({},b);d.nodes=(d[c]||[]).concat(),axe.constants.resultGroups.forEach(function(a){delete d[a]}),a[c].push(d)}function G(a,b,c){\"use strict\";var d=window.getComputedStyle(a,null),e=!1;return!!d&&(b.forEach(function(a){d.getPropertyValue(a.property)===a.value&&(e=!0)}),!!e||!(a.nodeName.toUpperCase()===c.toUpperCase()||!a.parentNode)&&G(a.parentNode,b,c))}function H(a,b){\"use strict\";return new Error(a+\": \"+axe.utils.getSelector(b))}function I(a,b,c,d,e,f){\"use strict\";var g=axe.utils.queue();a.frames.forEach(function(e){var f={options:b,command:c,parameter:d,context:{initiator:!1,page:a.page,include:e.include||[],exclude:e.exclude||[]}};g.defer(function(a,b){var c=e.node;axe.utils.sendCommandToFrame(c,f,function(b){if(b)return a({results:b,frameElement:c,frame:axe.utils.getSelector(c)});a(null)},b)})}),g.then(function(a){e(axe.utils.mergeResults(a))}).catch(f)}function J(a,b){\"use strict\";if(b=b||300,a.length>b){var c=a.indexOf(\">\");a=a.substring(0,c+1)}return a}function K(a){\"use strict\";var b=a.outerHTML;return b||\"function\"!=typeof XMLSerializer||(b=(new XMLSerializer).serializeToString(a)),J(b||\"\")}function L(a,b){\"use strict\";this._fromFrame=!!b,this.spec=b||{},this.source=void 0!==this.spec.source?this.spec.source:K(a),this._element=a}function M(a){\"use strict\";var b=1,c=a.nodeName.toUpperCase();for(a=a.previousElementSibling;a;)a.nodeName.toUpperCase()===c&&b++,a=a.previousElementSibling;return b}function N(a,b){\"use strict\";var c,d,e=a.parentNode.children;if(!e)return!1;var f=e.length;for(c=0;c<f;c++)if((d=e[c])!==a&&axe.utils.matchesSelector(d,b))return!0;return!1}function O(a,b){var c,d;if(!a)return[];if(!b&&9===a.nodeType)return b=[{str:\"html\"}];if(b=b||[],a.parentNode&&a.parentNode!==a&&(b=O(a.parentNode,b)),a.previousSibling){d=1,c=a.previousSibling;do{1===c.nodeType&&c.nodeName===a.nodeName&&d++,c=c.previousSibling}while(c);1===d&&(d=null)}else if(a.nextSibling){c=a.nextSibling;do{1===c.nodeType&&c.nodeName===a.nodeName?(d=1,c=null):(d=null,c=c.previousSibling)}while(c)}if(1===a.nodeType){var e={};e.str=a.nodeName.toLowerCase(),a.getAttribute&&a.getAttribute(\"id\")&&1===a.ownerDocument.querySelectorAll(\"#\"+axe.utils.escapeSelector(a.id)).length&&(e.id=a.getAttribute(\"id\")),d>1&&(e.count=d),b.push(e)}return b}function P(a){return a.reduce(function(a,b){return b.id?\"/\"+b.str+\"[@id='\"+b.id+\"']\":a+\"/\"+b.str+(b.count>0?\"[\"+b.count+\"]\":\"\")},\"\")}function Q(a){\"use strict\";if(fa&&fa.parentNode)return void 0===fa.styleSheet?fa.appendChild(document.createTextNode(a)):fa.styleSheet.cssText+=a,fa;if(a){var b=document.head||document.getElementsByTagName(\"head\")[0];return fa=document.createElement(\"style\"),fa.type=\"text/css\",void 0===fa.styleSheet?fa.appendChild(document.createTextNode(a)):fa.styleSheet.cssText=a,b.appendChild(fa),fa}}function R(a,b,c){\"use strict\";var d=axe.utils.getXpath(b),e={element:b,selector:c,xpath:d};a.forEach(function(a){a.node=axe.utils.DqElement.fromFrame(a.node,e);var b=axe.utils.getAllChecks(a);b.length&&b.forEach(function(a){a.relatedNodes=a.relatedNodes.map(function(a){return axe.utils.DqElement.fromFrame(a,e)})})})}function S(a,b){\"use strict\";for(var c,d,e=b[0].node,f=0,g=a.length;f<g;f++)if(d=a[f].node,(c=axe.utils.nodeSorter(d.element,e.element))>0||0===c&&e.selector.length<d.selector.length)return void a.splice.apply(a,[f,0].concat(b));a.push.apply(a,b)}function T(a){\"use strict\";return a&&a.results?Array.isArray(a.results)?a.results.length?a.results:null:[a.results]:null}function U(a,b){\"use strict\";return function(c){var d=a[c.id]||{},e=d.messages||{},f=Object.assign({},d);if(delete f.messages,void 0===c.result)if(\"object\"===Z(e.incomplete)){var g=c.data.missingData;g.forEach(function(a){var b;try{b=a.reason}catch(a){b=\"default\"}f.message=function(){return e.incomplete[b]}})}else f.message=e.incomplete;else f.message=c.result===b?e.pass:e.fail;axe.utils.extendMetaData(c,f)}}function V(a,b){\"use strict\";var c,d,e=axe._audit&&axe._audit.tagExclude?axe._audit.tagExclude:[];return b.include||b.exclude?(c=b.include||[],c=Array.isArray(c)?c:[c],d=b.exclude||[],d=Array.isArray(d)?d:[d],d=d.concat(e.filter(function(a){return-1===c.indexOf(a)}))):(c=Array.isArray(b)?b:[b],d=e.filter(function(a){return-1===c.indexOf(a)})),!!(c.some(function(b){return-1!==a.tags.indexOf(b)})||0===c.length&&!1!==a.enabled)&&d.every(function(b){return-1===a.tags.indexOf(b)})}function W(a){\"use strict\";return a.sort(function(a,b){return axe.utils.contains(a,b)?1:-1})[0]}function X(a,b){\"use strict\";var c=b.include&&W(b.include.filter(function(b){return axe.utils.contains(b,a)})),d=b.exclude&&W(b.exclude.filter(function(b){return axe.utils.contains(b,a)}));return!!(!d&&c||d&&axe.utils.contains(d,c))}function Y(a,b,c){\"use strict\";for(var d=0,e=b.length;d<e;d++)-1===a.indexOf(b[d])&&X(b[d],c)&&a.push(b[d])}var document=window.document,Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},axe=axe||{};axe.version=\"2.2.1\",\"function\"==typeof define&&define.amd&&define([],function(){\"use strict\";return axe}),\"object\"===(\"undefined\"==typeof module?\"undefined\":Z(module))&&module.exports&&\"function\"==typeof a.toString&&(axe.source=\"(\"+a.toString()+\")(this, this.document);\",module.exports=axe),\"function\"==typeof window.getComputedStyle&&(window.axe=axe);var commons;b.prototype=Object.create(Error.prototype),b.prototype.constructor=b;var utils=axe.utils={},$={},Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};e.prototype._init=function(){var a=c(this.defaultConfig);axe.commons=commons=a.commons,this.reporter=a.reporter,this.commands={},this.rules=[],this.checks={},d(a.rules,this,\"addRule\"),d(a.checks,this,\"addCheck\"),this.data={},this.data.checks=a.data&&a.data.checks||{},this.data.rules=a.data&&a.data.rules||{},this.data.failureSummaries=a.data&&a.data.failureSummaries||{},this._constructHelpUrls()},e.prototype.registerCommand=function(a){\"use strict\";this.commands[a.id]=a.callback},e.prototype.addRule=function(a){\"use strict\";a.metadata&&(this.data.rules[a.id]=a.metadata);var b=this.getRule(a.id);b?b.configure(a):this.rules.push(new q(a,this))},e.prototype.addCheck=function(a){\"use strict\";var b=a.metadata;\"object\"===(void 0===b?\"undefined\":Z(b))&&(this.data.checks[a.id]=b,\"object\"===Z(b.messages)&&Object.keys(b.messages).filter(function(a){return b.messages.hasOwnProperty(a)&&\"string\"==typeof b.messages[a]}).forEach(function(a){0===b.messages[a].indexOf(\"function\")&&(b.messages[a]=new Function(\"return \"+b.messages[a]+\";\")())})),this.checks[a.id]?this.checks[a.id].configure(a):this.checks[a.id]=new i(a)},e.prototype.run=function(a,b,c,d){\"use strict\";this.validateOptions(b);var e=axe.utils.queue();this.rules.forEach(function(c){if(axe.utils.ruleShouldRun(c,a,b)){if(b.performanceTimer){var d=\"mark_rule_end_\"+c.id,f=\"mark_rule_start_\"+c.id;axe.utils.performanceTimer.mark(f)}e.defer(function(e,g){c.run(a,b,function(a){b.performanceTimer&&(axe.utils.performanceTimer.mark(d),axe.utils.performanceTimer.measure(\"rule_\"+c.id,f,d)),e(a)},function(a){if(b.debug)g(a);else{var d=Object.assign(new p(c),{result:axe.constants.CANTTELL,description:\"An error occured while running this rule\",message:a.message,help:a.stack||a.message,error:a});e(d)}})})}}),e.then(function(a){c(a.filter(function(a){return!!a}))}).catch(d)},e.prototype.after=function(a,b){\"use strict\";var c=this.rules;return a.map(function(a){return axe.utils.findBy(c,\"id\",a.id).after(a,b)})},e.prototype.getRule=function(a){return this.rules.find(function(b){return b.id===a})},e.prototype.validateOptions=function(a){\"use strict\";var b=this;if(\"object\"===Z(a.runOnly)){var c=a.runOnly;if(\"rule\"===c.type&&Array.isArray(c.value))c.value.forEach(function(a){if(!b.getRule(a))throw new Error(\"unknown rule `\"+a+\"` in options.runOnly\")});else if(Array.isArray(c.value)&&c.value.length>0){var d=[].concat(c.value);if(b.rules.forEach(function(a){var b,c,e;if(d)for(c=0,e=a.tags.length;c<e;c++)-1!==(b=d.indexOf(a.tags[c]))&&d.splice(b,1)}),0!==d.length)throw new Error(\"could not find tags `\"+d.join(\"`, `\")+\"`\")}}return\"object\"===Z(a.rules)&&Object.keys(a.rules).forEach(function(a){if(!b.getRule(a))throw new Error(\"unknown rule `\"+a+\"` in options.rules\")}),a},e.prototype.setBranding=function(a){\"use strict\";var b={brand:this.brand,application:this.application};a&&a.hasOwnProperty(\"brand\")&&a.brand&&\"string\"==typeof a.brand&&(this.brand=a.brand),a&&a.hasOwnProperty(\"application\")&&a.application&&\"string\"==typeof a.application&&(this.application=a.application),this._constructHelpUrls(b)},e.prototype._constructHelpUrls=function(){var a=this,b=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,c=axe.version.substring(0,axe.version.lastIndexOf(\".\"));this.rules.forEach(function(d){a.data.rules[d.id]||(a.data.rules[d.id]={});var e=a.data.rules[d.id];(\"string\"!=typeof e.helpUrl||b&&e.helpUrl===f(b,d.id,c))&&(e.helpUrl=f(a,d.id,c))})},e.prototype.resetRulesAndChecks=function(){\"use strict\";this._init()},i.prototype.enabled=!0,i.prototype.run=function(a,b,c,d){\"use strict\";b=b||{};var e=b.hasOwnProperty(\"enabled\")?b.enabled:this.enabled,f=b.options||this.options;if(e){var h,i=new g(this),j=axe.utils.checkHelper(i,c,d);try{h=this.evaluate.call(j,a,f)}catch(a){return void d(a)}j.isAsync||(i.result=h,setTimeout(function(){c(i)},0))}else c(null)},i.prototype.configure=function(a){var b=this;[\"options\",\"enabled\"].filter(function(b){return a.hasOwnProperty(b)}).forEach(function(c){return b[c]=a[c]}),[\"evaluate\",\"after\"].filter(function(b){return a.hasOwnProperty(b)}).forEach(function(c){return b[c]=h(a[c])})};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};q.prototype.matches=function(){\"use strict\";return!0},q.prototype.gather=function(a){\"use strict\";var b=axe.utils.select(this.selector,a);return this.excludeHidden?b.filter(function(a){return!axe.utils.isHidden(a)}):b},q.prototype.runChecks=function(a,b,c,d,e){\"use strict\";var f=this,g=axe.utils.queue();this[a].forEach(function(a){var d=f._audit.checks[a.id||a],e=axe.utils.getCheckOption(d,f.id,c);g.defer(function(a,c){d.run(b,e,a,c)})}),g.then(function(b){b=b.filter(function(a){return a}),d({type:a,results:b})}).catch(e)},q.prototype.run=function(a,c,d,e){var f=this,g=axe.utils.queue(),h=new p(this),i=void 0;try{i=this.gather(a).filter(function(a){return f.matches(a)})}catch(a){return void e(new b({cause:a,ruleId:this.id}))}c.performanceTimer&&axe.log(\"gather (\",i.length,\"):\",axe.utils.performanceTimer.timeElapsed()+\"ms\"),i.forEach(function(a){g.defer(function(b,d){var e=axe.utils.queue();e.defer(function(b,d){f.runChecks(\"any\",a,c,b,d)}),e.defer(function(b,d){f.runChecks(\"all\",a,c,b,d)}),e.defer(function(b,d){f.runChecks(\"none\",a,c,b,d)}),e.then(function(c){if(c.length){var d=!1,e={};c.forEach(function(a){var b=a.results.filter(function(a){return a});e[a.type]=b,b.length&&(d=!0)}),d&&(e.node=new axe.utils.DqElement(a),h.nodes.push(e))}b()}).catch(function(a){return d(a)})})}),g.then(function(){return d(h)}).catch(function(a){return e(a)})},q.prototype.after=function(a,b){\"use strict\";var c=r(this),d=this.id;return c.forEach(function(c){var e=s(a.nodes,c.id),f=axe.utils.getCheckOption(c,d,b),g=c.after(e,f);e.forEach(function(a){-1===g.indexOf(a)&&(a.filtered=!0)})}),a.nodes=u(a),a},q.prototype.configure=function(a){\"use strict\";a.hasOwnProperty(\"selector\")&&(this.selector=a.selector),a.hasOwnProperty(\"excludeHidden\")&&(this.excludeHidden=\"boolean\"!=typeof a.excludeHidden||a.excludeHidden),a.hasOwnProperty(\"enabled\")&&(this.enabled=\"boolean\"!=typeof a.enabled||a.enabled),a.hasOwnProperty(\"pageLevel\")&&(this.pageLevel=\"boolean\"==typeof a.pageLevel&&a.pageLevel),a.hasOwnProperty(\"any\")&&(this.any=a.any),a.hasOwnProperty(\"all\")&&(this.all=a.all),a.hasOwnProperty(\"none\")&&(this.none=a.none),a.hasOwnProperty(\"tags\")&&(this.tags=a.tags),a.hasOwnProperty(\"matches\")&&(\"string\"==typeof a.matches?this.matches=new Function(\"return \"+a.matches+\";\")():this.matches=a.matches)},function(axe){var a=[{name:\"NA\",value:\"inapplicable\",priority:0,group:\"inapplicable\"},{name:\"PASS\",value:\"passed\",priority:1,group:\"passes\"},{name:\"CANTTELL\",value:\"cantTell\",priority:2,group:\"incomplete\"},{name:\"FAIL\",value:\"failed\",priority:3,group:\"violations\"}],b={helpUrlBase:\"https://dequeuniversity.com/rules/\",results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze([\"minor\",\"moderate\",\"serious\",\"critical\"])};a.forEach(function(a){var c=a.name,d=a.value,e=a.priority,f=a.group;b[c]=d,b[c+\"_PRIO\"]=e,b[c+\"_GROUP\"]=f,b.results[e]=d,b.resultGroups[e]=f,b.resultGroupMap[d]=f}),Object.freeze(b.results),Object.freeze(b.resultGroups),Object.freeze(b.resultGroupMap),Object.freeze(b),Object.defineProperty(axe,\"constants\",{value:b,enumerable:!0,configurable:!1,writable:!1})}(axe);var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.log=function(){\"use strict\";\"object\"===(\"undefined\"==typeof console?\"undefined\":Z(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.a11yCheck=function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={}),b&&\"object\"===(void 0===b?\"undefined\":Z(b))||(b={});var d=axe._audit;if(!d)throw new Error(\"No audit configured\");b.reporter=b.reporter||d.reporter||\"v2\",b.performanceTimer&&axe.utils.performanceTimer.start();var e=axe.getReporter(b.reporter);axe._runRules(a,b,function(a){var d=e(a,b,c);void 0!==d&&(b.performanceTimer&&axe.utils.performanceTimer.end(),c(d))},axe.log)},axe.cleanup=v,axe.configure=w,axe.getRules=function(a){\"use strict\";a=a||[];var b=a.length?axe._audit.rules.filter(function(b){return!!a.filter(function(a){return-1!==b.tags.indexOf(a)}).length}):axe._audit.rules,c=axe._audit.data.rules||{};return b.map(function(a){var b=c[a.id]||{};return{ruleId:a.id,description:b.description,help:b.help,helpUrl:b.helpUrl,tags:a.tags}})},axe._load=function(a){\"use strict\";axe.utils.respondable.subscribe(\"axe.ping\",function(a,b,c){c({axe:!0})}),axe.utils.respondable.subscribe(\"axe.start\",x),axe._audit=new e(a)};var axe=axe||{};axe.plugins={},y.prototype.run=function(){\"use strict\";return this._run.apply(this,arguments)},y.prototype.collect=function(){\"use strict\";return this._collect.apply(this,arguments)},y.prototype.cleanup=function(a){\"use strict\";var b=axe.utils.queue(),c=this;Object.keys(this._registry).forEach(function(a){b.defer(function(b){c._registry[a].cleanup(b)})}),b.then(function(){a()})},y.prototype.add=function(a){\"use strict\";this._registry[a.id]=a},axe.registerPlugin=function(a){\"use strict\";axe.plugins[a.id]=new y(a)};var _,aa={};axe.getReporter=function(a){\"use strict\";return\"string\"==typeof a&&aa[a]?aa[a]:\"function\"==typeof a?a:_},axe.addReporter=function(a,b,c){\"use strict\";aa[a]=b,c&&(_=b)},axe.reset=z,axe._runRules=A;var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},ba=function(){};axe.run=function(a,b,c){\"use strict\";if(!axe._audit)throw new Error(\"No audit configured\");var d=C(a,b,c);a=d.context,b=d.options,c=d.callback,b.reporter=b.reporter||axe._audit.reporter||\"v1\",b.performanceTimer&&axe.utils.performanceTimer.start();var e=void 0,f=ba,g=ba;return window.Promise&&c===ba&&(e=new Promise(function(a,b){f=b,g=a})),axe._runRules(a,b,function(a){var d=function(a){try{c(null,a)}catch(a){axe.log(a)}g(a)};b.performanceTimer&&axe.utils.performanceTimer.end();try{var e=axe.getReporter(b.reporter),h=e(a,b,d);void 0!==h&&d(h)}catch(a){c(a),f(a)}},function(a){c(a),f(a)}),e},$.failureSummary=function(a){\"use strict\";var b={};return b.none=a.none.concat(a.all),b.any=a.any,Object.keys(b).map(function(a){if(b[a].length){var c=axe._audit.data.failureSummaries[a];return c&&\"function\"==typeof c.failureMessage?c.failureMessage(b[a].map(function(a){return a.message||\"\"})):void 0}}).filter(function(a){return void 0!==a}).join(\"\\n\\n\")};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},ca=axe.constants.resultGroups;$.processAggregate=function(a,b){var c=axe.utils.aggregateResult(a);return c.timestamp=(new Date).toISOString(),c.url=window.location.href,ca.forEach(function(a){c[a]=(c[a]||[]).map(function(a){return a=Object.assign({},a),Array.isArray(a.nodes)&&a.nodes.length>0&&(a.nodes=a.nodes.map(function(a){return\"object\"===Z(a.node)&&(a.html=a.node.source,b.elementRef&&!a.node.fromFrame&&(a.element=a.node.element),(!1!==b.selectors||a.node.fromFrame)&&(a.target=a.node.selector),b.xpath&&(a.xpath=a.node.xpath)),delete a.result,delete a.node,D(a,b),a})),ca.forEach(function(b){return delete a[b]}),delete a.pageLevel,delete a.result,a})}),c},axe.addReporter(\"na\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=$.processAggregate(a,b);c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"no-passes\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=$.processAggregate(a,b);c({violations:d.violations,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"raw\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={}),c(a)}),axe.addReporter(\"v1\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=$.processAggregate(a,b);d.violations.forEach(function(a){return a.nodes.forEach(function(a){a.failureSummary=$.failureSummary(a)})}),c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"v2\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=$.processAggregate(a,b);c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})},!0),axe.utils.aggregate=function(a,b,c){b=b.slice(),c&&b.push(c);var d=b.map(function(b){return a.indexOf(b)}).sort();return a[d.pop()]};var da=[];da[axe.constants.PASS_PRIO]=!0,da[axe.constants.CANTTELL_PRIO]=null,da[axe.constants.FAIL_PRIO]=!1;var ea=[\"any\",\"all\",\"none\"];axe.utils.aggregateChecks=function(a){var b=Object.assign({},a);E(b,function(a,b){var c=da.indexOf(a.result);a.priority=-1!==c?c:axe.constants.CANTTELL_PRIO,\"none\"===b&&(a.priority=4-a.priority)});var c=E(b,function(a){return a.priority});b.priority=Math.max(c.all.reduce(function(a,b){return Math.max(a,b)},0),c.none.reduce(function(a,b){return Math.max(a,b)},0),c.any.reduce(function(a,b){return Math.min(a,b)},4)%4);var d=[];return ea.forEach(function(a){b[a]=b[a].filter(function(a){return a.priority===b.priority}),b[a].forEach(function(a){return d.push(a.impact)})}),b.priority===axe.constants.FAIL_PRIO?b.impact=axe.utils.aggregate(axe.constants.impact,d):b.impact=null,E(b,function(a){delete a.result,delete a.priority}),b.result=axe.constants.results[b.priority],delete b.priority,b},axe.utils.aggregateResult=function(a){var b={};return axe.constants.resultGroups.forEach(function(a){return b[a]=[]}),a.forEach(function(a){a.error?F(b,a,axe.constants.CANTTELL_GROUP):a.result===axe.constants.NA?F(b,a,axe.constants.NA_GROUP):axe.constants.resultGroups.forEach(function(c){Array.isArray(a[c])&&a[c].length>0&&F(b,a,c)})}),b},function(){axe.utils.aggregateRule=function(a){var b={};a=a.map(function(a){if(a.any&&a.all&&a.none)return axe.utils.aggregateChecks(a);if(Array.isArray(a.node))return axe.utils.finalizeRuleResult(a);throw new TypeError(\"Invalid Result type\")});var c=a.map(function(a){return a.result});b.result=axe.utils.aggregate(axe.constants.results,c,b.result),axe.constants.resultGroups.forEach(function(a){return b[a]=[]}),a.forEach(function(a){var c=axe.constants.resultGroupMap[a.result];b[c].push(a)});var d=axe.constants.FAIL_GROUP;if(b[d].length>0){var e=b[d].map(function(a){return a.impact});b.impact=axe.utils.aggregate(axe.constants.impact,e)||null}else b.impact=null;return b}}(),axe.utils.areStylesSet=G,axe.utils.checkHelper=function(a,b,c){\"use strict\";return{isAsync:!1,async:function(){return this.isAsync=!0,function(d){d instanceof Error==!1?(a.value=d,b(a)):c(d)}},data:function(b){a.data=b},relatedNodes:function(b){b=b instanceof Node?[b]:axe.utils.toArray(b),a.relatedNodes=b.map(function(a){return new axe.utils.DqElement(a)})}}};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.clone=function(a){\"use strict\";var b,c,d=a;if(null!==a&&\"object\"===(void 0===a?\"undefined\":Z(a)))if(Array.isArray(a))for(d=[],b=0,c=a.length;b<c;b++)d[b]=axe.utils.clone(a[b]);else{d={};for(b in a)d[b]=axe.utils.clone(a[b])}return d},axe.utils.sendCommandToFrame=function(a,b,c,d){\"use strict\";var e=a.contentWindow;if(!e)return axe.log(\"Frame does not have a content window\",a),void c(null);var f=setTimeout(function(){f=setTimeout(function(){var e=H(\"No response from frame\",a);b.debug?d(e):(axe.log(e),c(null))},0)},500);axe.utils.respondable(e,\"axe.ping\",null,void 0,function(){clearTimeout(f),f=setTimeout(function(){d(H(\"Axe in frame timed out\",a))},3e4),axe.utils.respondable(e,\"axe.start\",b,void 0,function(a){clearTimeout(f),a instanceof Error==!1?c(a):d(a)})})},axe.utils.collectResultsFromFrames=I,axe.utils.contains=function(a,b){\"use strict\";return\"function\"==typeof a.contains?a.contains(b):!!(16&a.compareDocumentPosition(b))},L.prototype={get selector(){return this.spec.selector||[axe.utils.getSelector(this.element)]},get xpath(){return this.spec.xpath||[axe.utils.getXpath(this.element)]},get element(){return this._element},get fromFrame(){return this._fromFrame},toJSON:function(){\"use strict\";return{selector:this.selector,source:this.source,xpath:this.xpath}}},L.fromFrame=function(a,b){return a.selector.unshift(b.selector),a.xpath.unshift(b.xpath),new axe.utils.DqElement(b.element,a)},axe.utils.DqElement=L,axe.utils.matchesSelector=function(){\"use strict\";function a(a){var b,c,d=a.Element.prototype,e=[\"matches\",\"matchesSelector\",\"mozMatchesSelector\",\"webkitMatchesSelector\",\"msMatchesSelector\"],f=e.length;for(b=0;b<f;b++)if(c=e[b],d[c])return c}var b;return function(c,d){return b&&c[b]||(b=a(c.ownerDocument.defaultView)),c[b](d)}}(),axe.utils.escapeSelector=function(a){\"use strict\";for(var b,c=String(a),d=c.length,e=-1,f=\"\",g=c.charCodeAt(0);++e<d;){if(0==(b=c.charCodeAt(e)))throw new Error(\"INVALID_CHARACTER_ERR\");b>=1&&b<=31||b>=127&&b<=159||0==e&&b>=48&&b<=57||1==e&&b>=48&&b<=57&&45==g?f+=\"\\\\\"+b.toString(16)+\" \":f+=(1!=e||45!=b||45!=g)&&(b>=128||45==b||95==b||b>=48&&b<=57||b>=65&&b<=90||b>=97&&b<=122)?c.charAt(e):\"\\\\\"+c.charAt(e)}return f},axe.utils.extendMetaData=function(a,b){Object.assign(a,b),Object.keys(b).filter(function(a){return\"function\"==typeof b[a]}).forEach(function(c){a[c]=null;try{a[c]=b[c](a)}catch(a){}})},axe.utils.finalizeRuleResult=function(a){return Object.assign(a,axe.utils.aggregateRule(a.nodes)),delete a.nodes,a};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.findBy=function(a,b,c){if(Array.isArray(a))return a.find(function(a){return\"object\"===(void 0===a?\"undefined\":Z(a))&&a[b]===c})},axe.utils.getAllChecks=function(a){\"use strict\";return[].concat(a.any||[]).concat(a.all||[]).concat(a.none||[])},axe.utils.getCheckOption=function(a,b,c){\"use strict\";var d=((c.rules&&c.rules[b]||{}).checks||{})[a.id],e=(c.checks||{})[a.id],f=a.enabled,g=a.options;return e&&(e.hasOwnProperty(\"enabled\")&&(f=e.enabled),\ne.hasOwnProperty(\"options\")&&(g=e.options)),d&&(d.hasOwnProperty(\"enabled\")&&(f=d.enabled),d.hasOwnProperty(\"options\")&&(g=d.options)),{enabled:f,options:g}},axe.utils.getSelector=function(a){\"use strict\";function b(a){return axe.utils.escapeSelector(a)}for(var c,d=[];a.parentNode;){if(c=\"\",a.id&&1===document.querySelectorAll(\"#\"+axe.utils.escapeSelector(a.id)).length){d.unshift(\"#\"+axe.utils.escapeSelector(a.id));break}if(a.className&&\"string\"==typeof a.className&&(\".\"===(c=\".\"+a.className.trim().split(/\\s+/).map(b).join(\".\"))||N(a,c))&&(c=\"\"),!c){if(\"html\"===(c=axe.utils.escapeSelector(a.nodeName).toLowerCase())||\"body\"===c){d.unshift(c);break}N(a,c)&&(c+=\":nth-of-type(\"+M(a)+\")\")}d.unshift(c),a=a.parentNode}return d.join(\" > \")},axe.utils.getXpath=function(a){return P(O(a))};var fa;axe.utils.injectStyle=Q,axe.utils.isHidden=function(a,b){\"use strict\";if(9===a.nodeType)return!1;var c=window.getComputedStyle(a,null);return!c||!a.parentNode||\"none\"===c.getPropertyValue(\"display\")||!b&&\"hidden\"===c.getPropertyValue(\"visibility\")||\"true\"===a.getAttribute(\"aria-hidden\")||axe.utils.isHidden(a.parentNode,!0)},axe.utils.mergeResults=function(a){\"use strict\";var b=[];return a.forEach(function(a){var c=T(a);c&&c.length&&c.forEach(function(c){c.nodes&&a.frame&&R(c.nodes,a.frameElement,a.frame);var d=axe.utils.findBy(b,\"id\",c.id);d?c.nodes.length&&S(d.nodes,c.nodes):b.push(c)})}),b},axe.utils.nodeSorter=function(a,b){\"use strict\";return a===b?0:4&a.compareDocumentPosition(b)?-1:1},utils.performanceTimer=function(){\"use strict\";function a(){if(window.performance&&window.performance)return window.performance.now()}var b=null,c=a();return{start:function(){this.mark(\"mark_axe_start\")},end:function(){this.mark(\"mark_axe_end\"),this.measure(\"axe\",\"mark_axe_start\",\"mark_axe_end\"),this.logMeasures(\"axe\")},auditStart:function(){this.mark(\"mark_audit_start\")},auditEnd:function(){this.mark(\"mark_audit_end\"),this.measure(\"audit_start_to_end\",\"mark_audit_start\",\"mark_audit_end\"),this.logMeasures()},mark:function(a){window.performance&&void 0!==window.performance.mark&&window.performance.mark(a)},measure:function(a,b,c){window.performance&&void 0!==window.performance.measure&&window.performance.measure(a,b,c)},logMeasures:function(a){function b(a){axe.log(\"Measure \"+a.name+\" took \"+a.duration+\"ms\")}if(window.performance&&void 0!==window.performance.getEntriesByType)for(var c=window.performance.getEntriesByType(\"measure\"),d=0;d<c.length;++d){var e=c[d];if(e.name===a)return void b(e);b(e)}},timeElapsed:function(){return a()-c},reset:function(){b||(b=a()),c=a()}}}(),\"function\"!=typeof Object.assign&&function(){Object.assign=function(a){\"use strict\";if(void 0===a||null===a)throw new TypeError(\"Cannot convert undefined or null to object\");for(var b=Object(a),c=1;c<arguments.length;c++){var d=arguments[c];if(void 0!==d&&null!==d)for(var e in d)d.hasOwnProperty(e)&&(b[e]=d[e])}return b}}(),Array.prototype.find||(Array.prototype.find=function(a){if(null===this)throw new TypeError(\"Array.prototype.find called on null or undefined\");if(\"function\"!=typeof a)throw new TypeError(\"predicate must be a function\");for(var b,c=Object(this),d=c.length>>>0,e=arguments[1],f=0;f<d;f++)if(b=c[f],a.call(e,b,f,c))return b}),axe.utils.pollyfillElementsFromPoint=function(){if(document.elementsFromPoint)return document.elementsFromPoint;if(document.msElementsFromPoint)return document.msElementsFromPoint;var a=function(){var a=document.createElement(\"x\");return a.style.cssText=\"pointer-events:auto\",\"auto\"===a.style.pointerEvents}(),b=a?\"pointer-events\":\"visibility\",c=a?\"none\":\"hidden\",d=document.createElement(\"style\");return d.innerHTML=a?\"* { pointer-events: all }\":\"* { visibility: visible }\",function(a,e){var f,g,h,i=[],j=[];for(document.head.appendChild(d);(f=document.elementFromPoint(a,e))&&-1===i.indexOf(f);)i.push(f),j.push({value:f.style.getPropertyValue(b),priority:f.style.getPropertyPriority(b)}),f.style.setProperty(b,c,\"important\");for(g=j.length;h=j[--g];)i[g].style.setProperty(b,h.value?h.value:\"\",h.priority);return document.head.removeChild(d),i}},\"function\"==typeof window.addEventListener&&(document.elementsFromPoint=axe.utils.pollyfillElementsFromPoint()),Array.prototype.includes||(Array.prototype.includes=function(a){\"use strict\";var b=Object(this),c=parseInt(b.length,10)||0;if(0===c)return!1;var d,e=parseInt(arguments[1],10)||0;e>=0?d=e:(d=c+e)<0&&(d=0);for(var f;d<c;){if(f=b[d],a===f||a!==a&&f!==f)return!0;d++}return!1}),Array.prototype.some||(Array.prototype.some=function(a){\"use strict\";if(null==this)throw new TypeError(\"Array.prototype.some called on null or undefined\");if(\"function\"!=typeof a)throw new TypeError;for(var b=Object(this),c=b.length>>>0,d=arguments.length>=2?arguments[1]:void 0,e=0;e<c;e++)if(e in b&&a.call(d,b[e],e,b))return!0;return!1}),Array.from||(Array.from=function(){var a=Object.prototype.toString,b=function(b){return\"function\"==typeof b||\"[object Function]\"===a.call(b)},c=function(a){var b=Number(a);return isNaN(b)?0:0!==b&&isFinite(b)?(b>0?1:-1)*Math.floor(Math.abs(b)):b},d=Math.pow(2,53)-1,e=function(a){var b=c(a);return Math.min(Math.max(b,0),d)};return function(a){var c=this,d=Object(a);if(null==a)throw new TypeError(\"Array.from requires an array-like object - not null or undefined\");var f,g=arguments.length>1?arguments[1]:void 0;if(void 0!==g){if(!b(g))throw new TypeError(\"Array.from: when provided, the second argument must be a function\");arguments.length>2&&(f=arguments[2])}for(var h,i=e(d.length),j=b(c)?Object(new c(i)):new Array(i),k=0;k<i;)h=d[k],j[k]=g?void 0===f?g(h,k):g.call(f,h,k):h,k+=1;return j.length=i,j}}());var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.publishMetaData=function(a){\"use strict\";var b=axe._audit.data.checks||{},c=axe._audit.data.rules||{},d=axe.utils.findBy(axe._audit.rules,\"id\",a.id)||{};a.tags=axe.utils.clone(d.tags||[]);var e=U(b,!0),f=U(b,!1);a.nodes.forEach(function(a){a.any.forEach(e),a.all.forEach(e),a.none.forEach(f)}),axe.utils.extendMetaData(a,axe.utils.clone(c[a.id]||{}))};var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};!function(){\"use strict\";function a(){}function b(a){if(\"function\"!=typeof a)throw new TypeError(\"Queue methods require functions as arguments\")}function c(){function c(b){return function(c){g[b]=c,(i-=1)||j===a||(k=!0,j(g))}}function d(b){return j=a,m(b),g}function e(){for(var a=g.length;h<a;h++){var b=g[h];try{b.call(null,c(h),d)}catch(a){d(a)}}}var f,g=[],h=0,i=0,j=a,k=!1,l=function(a){f=a,setTimeout(function(){void 0!==f&&null!==f&&axe.log(\"Uncaught error (of queue)\",f)},1)},m=l,n={defer:function(a){if(\"object\"===(void 0===a?\"undefined\":Z(a))&&a.then&&a.catch){var c=a;a=function(a,b){c.then(a).catch(b)}}if(b(a),void 0===f){if(k)throw new Error(\"Queue already completed\");return g.push(a),++i,e(),n}},then:function(c){if(b(c),j!==a)throw new Error(\"queue `then` already set\");return f||(j=c,i||(k=!0,j(g))),n},catch:function(a){if(b(a),m!==l)throw new Error(\"queue `catch` already set\");return f?(a(f),f=null):m=a,n},abort:d};return n}axe.utils.queue=c}();var Z=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};!function(a){\"use strict\";function b(){var a=\"axe\",b=\"\";return void 0!==axe&&axe._audit&&!axe._audit.application&&(a=axe._audit.application),void 0!==axe&&(b=axe.version),a+\".\"+b}function c(a){if(\"object\"===(void 0===a?\"undefined\":Z(a))&&\"string\"==typeof a.uuid&&!0===a._respondable){var c=b();return a._source===c||\"axe.x.y.z\"===a._source||\"axe.x.y.z\"===c}return!1}function d(a,c,d,e,f,g){var h;d instanceof Error&&(h={name:d.name,message:d.message,stack:d.stack},d=void 0);var i={uuid:e,topic:c,message:d,error:h,_respondable:!0,_source:b(),_keepalive:f};\"function\"==typeof g&&(j[e]=g),a.postMessage(JSON.stringify(i),\"*\")}function e(a,b,c,e,f){d(a,b,c,ga.v1(),e,f)}function f(a,b,c){return function(e,f,g){d(a,b,e,c,f,g)}}function g(a,b,c){var d=b.topic,e=k[d];if(e){var g=f(a,null,b.uuid);e(b.message,c,g)}}function h(a){var b=a.message||\"Unknown error occurred\",c=window[a.name]||Error;return a.stack&&(b+=\"\\n\"+a.stack.replace(a.message,\"\")),new c(b)}function i(a){var b;if(\"string\"==typeof a){try{b=JSON.parse(a)}catch(a){}if(c(b))return\"object\"===Z(b.error)?b.error=h(b.error):b.error=void 0,b}}var j={},k={};e.subscribe=function(a,b){k[a]=b},e.isInFrame=function(a){return a=a||window,!!a.frameElement},\"function\"==typeof window.addEventListener&&window.addEventListener(\"message\",function(a){var b=i(a.data);if(b){var c=b.uuid,e=b._keepalive,h=j[c];if(h){h(b.error||b.message,e,f(a.source,b.topic,c)),e||delete j[c]}if(!b.error)try{g(a.source,b,e)}catch(e){d(a.source,b.topic,e,c,!1)}}},!1),a.respondable=e}(utils),axe.utils.ruleShouldRun=function(a,b,c){\"use strict\";var d=c.runOnly||{},e=(c.rules||{})[a.id];return!(a.pageLevel&&!b.page)&&(\"rule\"===d.type?-1!==d.values.indexOf(a.id):e&&\"boolean\"==typeof e.enabled?e.enabled:\"tag\"===d.type&&d.values?V(a,d.values):V(a,[]))},axe.utils.select=function(a,b){\"use strict\";for(var c,d=[],e=0,f=b.include.length;e<f;e++)c=b.include[e],c.nodeType===c.ELEMENT_NODE&&axe.utils.matchesSelector(c,a)&&Y(d,[c],b),Y(d,c.querySelectorAll(a),b);return d.sort(axe.utils.nodeSorter)},axe.utils.toArray=function(a){\"use strict\";return Array.prototype.slice.call(a)};var ga;!function(a){function b(a,b,c){var d=b&&c||0,e=0;for(b=b||[],a.toLowerCase().replace(/[0-9a-f]{2}/g,function(a){e<16&&(b[d+e++]=l[a])});e<16;)b[d+e++]=0;return b}function c(a,b){var c=b||0,d=k;return d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]}function d(a,b,d){var e=b&&d||0,f=b||[];a=a||{};var g=null!=a.clockseq?a.clockseq:p,h=null!=a.msecs?a.msecs:(new Date).getTime(),i=null!=a.nsecs?a.nsecs:r+1,j=h-q+(i-r)/1e4;if(j<0&&null==a.clockseq&&(g=g+1&16383),(j<0||h>q)&&null==a.nsecs&&(i=0),i>=1e4)throw new Error(\"uuid.v1(): Can't create more than 10M uuids/sec\");q=h,r=i,p=g,h+=122192928e5;var k=(1e4*(268435455&h)+i)%4294967296;f[e++]=k>>>24&255,f[e++]=k>>>16&255,f[e++]=k>>>8&255,f[e++]=255&k;var l=h/4294967296*1e4&268435455;f[e++]=l>>>8&255,f[e++]=255&l,f[e++]=l>>>24&15|16,f[e++]=l>>>16&255,f[e++]=g>>>8|128,f[e++]=255&g;for(var m=a.node||o,n=0;n<6;n++)f[e+n]=m[n];return b||c(f)}function e(a,b,d){var e=b&&d||0;\"string\"==typeof a&&(b=\"binary\"==a?new j(16):null,a=null),a=a||{};var g=a.random||(a.rng||f)();if(g[6]=15&g[6]|64,g[8]=63&g[8]|128,b)for(var h=0;h<16;h++)b[e+h]=g[h];return b||c(g)}var f,g=a.crypto||a.msCrypto;if(!f&&g&&g.getRandomValues){var h=new Uint8Array(16);f=function(){return g.getRandomValues(h),h}}if(!f){var i=new Array(16);f=function(){for(var a,b=0;b<16;b++)0==(3&b)&&(a=4294967296*Math.random()),i[b]=a>>>((3&b)<<3)&255;return i}}for(var j=\"function\"==typeof a.Buffer?a.Buffer:Array,k=[],l={},m=0;m<256;m++)k[m]=(m+256).toString(16).substr(1),l[k[m]]=m;var n=f(),o=[1|n[0],n[1],n[2],n[3],n[4],n[5]],p=16383&(n[6]<<8|n[7]),q=0,r=0;ga=e,ga.v1=d,ga.v4=e,ga.parse=b,ga.unparse=c,ga.BufferClass=j}(window),axe._load({data:{rules:{accesskeys:{description:\"Ensures every accesskey attribute value is unique\",help:\"accesskey attribute value must be unique\"},\"area-alt\":{description:\"Ensures <area> elements of image maps have alternate text\",help:\"Active <area> elements must have alternate text\"},\"aria-allowed-attr\":{description:\"Ensures ARIA attributes are allowed for an element's role\",help:\"Elements must only use allowed ARIA attributes\"},\"aria-required-attr\":{description:\"Ensures elements with ARIA roles have all required ARIA attributes\",help:\"Required ARIA attributes must be provided\"},\"aria-required-children\":{description:\"Ensures elements with an ARIA role that require child roles contain them\",help:\"Certain ARIA roles must contain particular children\"},\"aria-required-parent\":{description:\"Ensures elements with an ARIA role that require parent roles are contained by them\",help:\"Certain ARIA roles must be contained by particular parents\"},\"aria-roles\":{description:\"Ensures all elements with a role attribute use a valid value\",help:\"ARIA roles used must conform to valid values\"},\"aria-valid-attr-value\":{description:\"Ensures all ARIA attributes have valid values\",help:\"ARIA attributes must conform to valid values\"},\"aria-valid-attr\":{description:\"Ensures attributes that begin with aria- are valid ARIA attributes\",help:\"ARIA attributes must conform to valid names\"},\"audio-caption\":{description:\"Ensures <audio> elements have captions\",help:\"<audio> elements must have a captions track\"},blink:{description:\"Ensures <blink> elements are not used\",help:\"<blink> elements are deprecated and must not be used\"},\"button-name\":{description:\"Ensures buttons have discernible text\",help:\"Buttons must have discernible text\"},bypass:{description:\"Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content\",help:\"Page must have means to bypass repeated blocks\"},checkboxgroup:{description:'Ensures related <input type=\"checkbox\"> elements have a group and that that group designation is consistent',help:\"Checkbox inputs with the same name attribute value must be part of a group\"},\"color-contrast\":{description:\"Ensures the contrast between foreground and background colors meets WCAG 2 AA contrast ratio thresholds\",help:\"Elements must have sufficient color contrast\"},\"definition-list\":{description:\"Ensures <dl> elements are structured correctly\",help:\"<dl> elements must only directly contain properly-ordered <dt> and <dd> groups, <script> or <template> elements\"},dlitem:{description:\"Ensures <dt> and <dd> elements are contained by a <dl>\",help:\"<dt> and <dd> elements must be contained by a <dl>\"},\"document-title\":{description:\"Ensures each HTML document contains a non-empty <title> element\",help:\"Documents must have <title> element to aid in navigation\"},\"duplicate-id\":{description:\"Ensures every id attribute value is unique\",help:\"id attribute value must be unique\"},\"empty-heading\":{description:\"Ensures headings have discernible text\",help:\"Headings must not be empty\"},\"frame-title-unique\":{description:\"Ensures <iframe> and <frame> elements contain a unique title attribute\",help:\"Frames must have a unique title attribute\"},\"frame-title\":{description:\"Ensures <iframe> and <frame> elements contain a non-empty title attribute\",help:\"Frames must have title attribute\"},\"heading-order\":{description:\"Ensures the order of headings is semantically correct\",help:\"Heading levels should only increase by one\"},\"href-no-hash\":{description:\"Ensures that href values are valid link references to promote only using anchors as links\",help:\"Anchors must only be used as links and must therefore have an href value that is a valid reference. Otherwise you should probably usa a button\"},\"html-has-lang\":{description:\"Ensures every HTML document has a lang attribute\",help:\"<html> element must have a lang attribute\"},\"html-lang-valid\":{description:\"Ensures the lang attribute of the <html> element has a valid value\",help:\"<html> element must have a valid value for the lang attribute\"},\"image-alt\":{description:\"Ensures <img> elements have alternate text or a role of none or presentation\",help:\"Images must have alternate text\"},\"image-redundant-alt\":{description:\"Ensure button and link text is not repeated as image alternative\",help:\"Text of buttons and links should not be repeated in the image alternative\"},\"input-image-alt\":{description:'Ensures <input type=\"image\"> elements have alternate text',help:\"Image buttons must have alternate text\"},\"label-title-only\":{description:\"Ensures that every form element is not solely labeled using the title or aria-describedby attributes\",help:\"Form elements should have a visible label\"},label:{description:\"Ensures every form element has a label\",help:\"Form elements must have labels\"},\"layout-table\":{description:\"Ensures presentational <table> elements do not use <th>, <caption> elements or the summary attribute\",help:\"Layout tables must not use data table elements\"},\"link-in-text-block\":{description:\"Links can be distinguished without relying on color\",help:\"Links must be distinguished from surrounding text in a way that does not rely on color\"},\"link-name\":{description:\"Ensures links have discernible text\",help:\"Links must have discernible text\"},list:{description:\"Ensures that lists are structured correctly\",help:\"<ul> and <ol> must only directly contain <li>, <script> or <template> elements\"},listitem:{description:\"Ensures <li> elements are used semantically\",help:\"<li> elements must be contained in a <ul> or <ol>\"},marquee:{description:\"Ensures <marquee> elements are not used\",help:\"<marquee> elements are deprecated and must not be used\"},\"meta-refresh\":{description:'Ensures <meta http-equiv=\"refresh\"> is not used',help:\"Timed refresh must not exist\"},\"meta-viewport-large\":{description:'Ensures <meta name=\"viewport\"> can scale a significant amount',help:\"Users should be able to zoom and scale the text up to 500%\"},\"meta-viewport\":{description:'Ensures <meta name=\"viewport\"> does not disable text scaling and zooming',help:\"Zooming and scaling must not be disabled\"},\"object-alt\":{description:\"Ensures <object> elements have alternate text\",help:\"<object> elements must have alternate text\"},\"p-as-heading\":{description:\"Ensure p elements are not used to style headings\",help:\"Bold, italic text and font-size are not used to style p elements as a heading\"},radiogroup:{description:'Ensures related <input type=\"radio\"> elements have a group and that the group designation is consistent',help:\"Radio inputs with the same name attribute value must be part of a group\"},region:{description:\"Ensures all content is contained within a landmark region\",help:\"Content should be contained in a landmark region\"},\"scope-attr-valid\":{description:\"Ensures the scope attribute is used correctly on tables\",help:\"scope attribute should be used correctly\"},\"server-side-image-map\":{description:\"Ensures that server-side image maps are not used\",help:\"Server-side image maps must not be used\"},\"skip-link\":{description:\"Ensures the first link on the page is a skip link\",help:\"The page should have a skip link as its first link\"},tabindex:{description:\"Ensures tabindex attribute values are not greater than 0\",help:\"Elements should not have tabindex greater than zero\"},\"table-duplicate-name\":{description:\"Ensure that tables do not have the same summary and caption\",help:\"The <caption> element should not contain the same text as the summary attribute\"},\"table-fake-caption\":{description:\"Ensure that tables with a caption use the <caption> element.\",help:\"Data or header cells should not be used to give caption to a data table.\"},\"td-has-header\":{description:\"Ensure that each non-empty data cell in a large table has one or more table headers\",help:\"All non-empty td element in table larger than 3 by 3 must have an associated table header\"},\"td-headers-attr\":{description:\"Ensure that each cell in a table using the headers refers to another cell in that table\",help:\"All cells in a table element that use the headers attribute must only refer to other cells of that same table\"},\"th-has-data-cells\":{description:\"Ensure that each table header in a data table refers to data cells\",help:\"All th element and elements with role=columnheader/rowheader must data cells which it describes\"},\"valid-lang\":{description:\"Ensures lang attributes have valid values\",help:\"lang attribute must have a valid value\"},\"video-caption\":{description:\"Ensures <video> elements have captions\",help:\"<video> elements must have captions\"},\"video-description\":{description:\"Ensures <video> elements have audio descriptions\",help:\"<video> elements must have an audio description track\"}},checks:{accesskeys:{impact:\"critical\",messages:{pass:function(a){return\"Accesskey attribute value is unique\"},fail:function(a){return\"Document has multiple elements with the same accesskey\"}}},\"non-empty-alt\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a non-empty alt attribute\"},fail:function(a){return\"Element has no alt attribute or the alt attribute is empty\"}}},\"non-empty-title\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a title attribute\"},fail:function(a){return\"Element has no title attribute or the title attribute is empty\"}}},\"aria-label\":{impact:\"critical\",messages:{pass:function(a){return\"aria-label attribute exists and is not empty\"},fail:function(a){return\"aria-label attribute does not exist or is empty\"}}},\"aria-labelledby\":{impact:\"critical\",messages:{pass:function(a){return\"aria-labelledby attribute exists and references elements that are visible to screen readers\"},fail:function(a){return\"aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty or not visible\"}}},\"aria-allowed-attr\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attributes are used correctly for the defined role\"},fail:function(a){var b=\"ARIA attribute\"+(a.data&&a.data.length>1?\"s are\":\" is\")+\" not allowed:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-attr\":{impact:\"critical\",messages:{pass:function(a){return\"All required ARIA attributes are present\"},fail:function(a){var b=\"Required ARIA attribute\"+(a.data&&a.data.length>1?\"s\":\"\")+\" not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-children\":{impact:\"critical\",messages:{pass:function(a){return\"Required ARIA children are present\"},fail:function(a){var b=\"Required ARIA \"+(a.data&&a.data.length>1?\"children\":\"child\")+\" role not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-parent\":{impact:\"critical\",messages:{pass:function(a){return\"Required ARIA parent role present\"},fail:function(a){var b=\"Required ARIA parent\"+(a.data&&a.data.length>1?\"s\":\"\")+\" role not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},invalidrole:{impact:\"critical\",messages:{pass:function(a){return\"ARIA role is valid\"},fail:function(a){return\"Role must be one of the valid ARIA roles\"}}},abstractrole:{impact:\"serious\",messages:{pass:function(a){return\"Abstract roles are not used\"},fail:function(a){return\"Abstract roles cannot be directly used\"}}},\"aria-valid-attr-value\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attribute values are valid\"},fail:function(a){var b=\"Invalid ARIA attribute value\"+(a.data&&a.data.length>1?\"s\":\"\")+\":\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-valid-attr\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attribute name\"+(a.data&&a.data.length>1?\"s\":\"\")+\" are valid\"},fail:function(a){var b=\"Invalid ARIA attribute name\"+(a.data&&a.data.length>1?\"s\":\"\")+\":\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},caption:{impact:\"critical\",messages:{pass:function(a){return\"The multimedia element has a captions track\"},fail:function(a){return\"The multimedia element does not have a captions track\"},incomplete:function(a){return\"A captions track for this element could not be found\"}}},\"is-on-screen\":{impact:\"minor\",messages:{pass:function(a){return\"Element is not visible\"},fail:function(a){return\"Element is visible\"}}},\"non-empty-if-present\":{impact:\"critical\",messages:{pass:function(a){var b=\"Element \";return a.data?b+=\"has a non-empty value attribute\":b+=\"does not have a value attribute\",b},fail:function(a){return\"Element has a value attribute and the value attribute is empty\"}}},\"non-empty-value\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a non-empty value attribute\"},fail:function(a){return\"Element has no value attribute or the value attribute is empty\"}}},\"button-has-visible-text\":{impact:\"critical\",messages:{pass:function(a){return\"Element has inner text that is visible to screen readers\"},fail:function(a){return\"Element does not have inner text that is visible to screen readers\"}}},\"role-presentation\":{impact:\"moderate\",messages:{pass:function(a){return'Element\\'s default semantics were overriden with role=\"presentation\"'},fail:function(a){return'Element\\'s default semantics were not overridden with role=\"presentation\"'}}},\"role-none\":{impact:\"moderate\",messages:{pass:function(a){return'Element\\'s default semantics were overriden with role=\"none\"'},fail:function(a){return'Element\\'s default semantics were not overridden with role=\"none\"'}}},\"focusable-no-name\":{impact:\"serious\",messages:{pass:function(a){return\"Element is not in tab order or has accessible text\"},fail:function(a){return\"Element is in tab order and does not have accessible text\"}}},\"internal-link-present\":{impact:\"critical\",messages:{pass:function(a){return\"Valid skip link found\"},fail:function(a){return\"No valid skip link found\"}}},\"header-present\":{impact:\"moderate\",messages:{pass:function(a){return\"Page has a header\"},fail:function(a){return\"Page does not have a header\"}}},landmark:{impact:\"serious\",messages:{pass:function(a){return\"Page has a landmark region\"},fail:function(a){return\"Page does not have a landmark region\"}}},\"group-labelledby\":{impact:\"critical\",messages:{pass:function(a){return'All elements with the name \"'+a.data.name+'\" reference the same element with aria-labelledby'},fail:function(a){return'All elements with the name \"'+a.data.name+'\" do not reference the same element with aria-labelledby'}}},fieldset:{impact:\"critical\",messages:{pass:function(a){return\"Element is contained in a fieldset\"},fail:function(a){var b=\"\",c=a.data&&a.data.failureCode;return b+=\"no-legend\"===c?\"Fieldset does not have a legend as its first child\":\"empty-legend\"===c?\"Legend does not have text that is visible to screen readers\":\"mixed-inputs\"===c?\"Fieldset contains unrelated inputs\":\"no-group-label\"===c?\"ARIA group does not have aria-label or aria-labelledby\":\"group-mixed-inputs\"===c?\"ARIA group contains unrelated inputs\":\"Element does not have a containing fieldset or ARIA group\"}}},\"color-contrast\":{impact:\"critical\",messages:{pass:function(a){return\"Element has sufficient color contrast of \"+a.data.contrastRatio},fail:function(a){return\"Element has insufficient color contrast of \"+a.data.contrastRatio+\" (foreground color: \"+a.data.fgColor+\", background color: \"+a.data.bgColor+\", font size: \"+a.data.fontSize+\", font weight: \"+a.data.fontWeight+\")\"},incomplete:{bgImage:\"Element's background color could not be determined due to a background image\",bgGradient:\"Element's background color could not be determined due to a background gradient\",imgNode:\"Element's background color could not be determined because element contains an image node\",bgOverlap:\"Element's background color could not be determined because it is overlapped by another element\",fgAlpha:\"Element's foreground color could not be determined because of alpha transparency\",default:\"Unable to determine contrast ratio\"}}},\"structured-dlitems\":{impact:\"serious\",messages:{pass:function(a){return\"When not empty, element has both <dt> and <dd> elements\"},fail:function(a){return\"When not empty, element does not have at least one <dt> element followed by at least one <dd> element\"}}},\"only-dlitems\":{impact:\"serious\",messages:{pass:function(a){return\"List element only has direct children that are allowed inside <dt> or <dd> elements\"},fail:function(a){return\"List element has direct children that are not allowed inside <dt> or <dd> elements\"}}},dlitem:{impact:\"serious\",messages:{pass:function(a){return\"Description list item has a <dl> parent element\"},fail:function(a){return\"Description list item does not have a <dl> parent element\"}}},\"doc-has-title\":{impact:\"moderate\",messages:{pass:function(a){return\"Document has a non-empty <title> element\"},fail:function(a){return\"Document does not have a non-empty <title> element\"}}},\"duplicate-id\":{impact:\"critical\",messages:{pass:function(a){return\"Document has no elements that share the same id attribute\"},fail:function(a){return\"Document has multiple elements with the same id attribute: \"+a.data}}},\"has-visible-text\":{impact:\"moderate\",messages:{pass:function(a){return\"Element has text that is visible to screen readers\"},fail:function(a){return\"Element does not have text that is visible to screen readers\"}}},\"unique-frame-title\":{impact:\"serious\",messages:{pass:function(a){return\"Element's title attribute is unique\"},fail:function(a){return\"Element's title attribute is not unique\"}}},\"heading-order\":{impact:\"minor\",messages:{pass:function(a){return\"Heading order valid\"},fail:function(a){return\"Heading order invalid\"}}},\"href-no-hash\":{impact:\"moderate\",messages:{pass:function(a){return\"Anchor does not have a href quals #\"},fail:function(a){return\"Anchor has a href quals #\"}}},\"has-lang\":{impact:\"serious\",messages:{pass:function(a){return\"The <html> element has a lang attribute\"},fail:function(a){return\"The <html> element does not have a lang attribute\"}}},\"valid-lang\":{impact:\"serious\",messages:{pass:function(a){return\"Value of lang attribute is included in the list of valid languages\"},fail:function(a){return\"Value of lang attribute not included in the list of valid languages\"}}},\"has-alt\":{impact:\"critical\",messages:{pass:function(a){return\"Element has an alt attribute\"},fail:function(a){return\"Element does not have an alt attribute\"}}},\"duplicate-img-label\":{impact:\"minor\",messages:{pass:function(a){return\"Element does not duplicate existing text in <img> alt text\"},fail:function(a){return\"Element contains <img> element with alt text that duplicates existing text\"}}},\"title-only\":{impact:\"serious\",messages:{pass:function(a){return\"Form element does not solely use title attribute for its label\"},fail:function(a){return\"Only title used to generate label for form element\"}}},\"implicit-label\":{impact:\"critical\",messages:{pass:function(a){return\"Form element has an implicit (wrapped) <label>\"},fail:function(a){return\"Form element does not have an implicit (wrapped) <label>\"}}},\"explicit-label\":{impact:\"critical\",messages:{pass:function(a){return\"Form element has an explicit <label>\"},fail:function(a){return\"Form element does not have an explicit <label>\"}}},\"help-same-as-label\":{impact:\"minor\",messages:{pass:function(a){return\"Help text (title or aria-describedby) does not duplicate label text\"},fail:function(a){return\"Help text (title or aria-describedby) text is the same as the label text\"}}},\"multiple-label\":{impact:\"serious\",messages:{pass:function(a){return\"Form element does not have multiple <label> elements\"},fail:function(a){return\"Form element has multiple <label> elements\"}}},\"has-th\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use <th> elements\"},fail:function(a){return\"Layout table uses <th> elements\"}}},\"has-caption\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use <caption> element\"},fail:function(a){return\"Layout table uses <caption> element\"}}},\"has-summary\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use summary attribute\"},fail:function(a){return\"Layout table uses summary attribute\"}}},\"link-in-text-block\":{impact:\"critical\",messages:{pass:function(a){return\"Links can be distinguished from surrounding text in a way that does not rely on color\"},fail:function(a){return\"Links can not be distinguished from surrounding text in a way that does not rely on color\"},incomplete:{bgContrast:\"Element's contrast ratio could not be determined. Check for a distinct hover/focus style\",\nbgImage:\"Element's contrast ratio could not be determined due to a background image\",bgGradient:\"Element's contrast ratio could not be determined due to a background gradient\",imgNode:\"Element's contrast ratio could not be determined because element contains an image node\",bgOverlap:\"Element's contrast ratio could not be determined because of element overlap\",default:\"Unable to determine contrast ratio\"}}},\"only-listitems\":{impact:\"serious\",messages:{pass:function(a){return\"List element only has direct children that are allowed inside <li> elements\"},fail:function(a){return\"List element has direct children that are not allowed inside <li> elements\"}}},listitem:{impact:\"critical\",messages:{pass:function(a){return'List item has a <ul>, <ol> or role=\"list\" parent element'},fail:function(a){return'List item does not have a <ul>, <ol> or role=\"list\" parent element'}}},\"meta-refresh\":{impact:\"critical\",messages:{pass:function(a){return\"<meta> tag does not immediately refresh the page\"},fail:function(a){return\"<meta> tag forces timed refresh of page\"}}},\"meta-viewport-large\":{impact:\"minor\",messages:{pass:function(a){return\"<meta> tag does not prevent significant zooming\"},fail:function(a){return\"<meta> tag limits zooming\"}}},\"meta-viewport\":{impact:\"critical\",messages:{pass:function(a){return\"<meta> tag does not disable zooming\"},fail:function(a){return\"<meta> tag disables zooming\"}}},\"p-as-heading\":{impact:\"critical\",messages:{pass:function(a){return\"<p> elements are not styled as headings\"},fail:function(a){return\"Heading elements should be used instead of styled p elements\"}}},region:{impact:\"moderate\",messages:{pass:function(a){return\"Content contained by ARIA landmark\"},fail:function(a){return\"Content not contained by an ARIA landmark\"}}},\"html5-scope\":{impact:\"serious\",messages:{pass:function(a){return\"Scope attribute is only used on table header elements (<th>)\"},fail:function(a){return\"In HTML 5, scope attributes may only be used on table header elements (<th>)\"}}},\"scope-value\":{impact:\"critical\",messages:{pass:function(a){return\"Scope attribute is used correctly\"},fail:function(a){return\"The value of the scope attribute may only be 'row' or 'col'\"}}},exists:{impact:\"minor\",messages:{pass:function(a){return\"Element does not exist\"},fail:function(a){return\"Element exists\"}}},\"skip-link\":{impact:\"critical\",messages:{pass:function(a){return\"Valid skip link found\"},fail:function(a){return\"No valid skip link found\"}}},tabindex:{impact:\"serious\",messages:{pass:function(a){return\"Element does not have a tabindex greater than 0\"},fail:function(a){return\"Element has a tabindex greater than 0\"}}},\"same-caption-summary\":{impact:\"moderate\",messages:{pass:function(a){return\"Content of summary attribute and <caption> are not duplicated\"},fail:function(a){return\"Content of summary attribute and <caption> element are identical\"}}},\"caption-faked\":{impact:\"critical\",messages:{pass:function(a){return\"The first row of a table is not used as a caption\"},fail:function(a){return\"The first row of the table should be a caption instead of a table cell\"}}},\"td-has-header\":{impact:\"critical\",messages:{pass:function(a){return\"All non-empty data cells have table headers\"},fail:function(a){return\"Some non-empty data cells do not have table headers\"}}},\"td-headers-attr\":{impact:\"serious\",messages:{pass:function(a){return\"The headers attribute is exclusively used to refer to other cells in the table\"},fail:function(a){return\"The headers attribute is not exclusively used to refer to other cells in the table\"}}},\"th-has-data-cells\":{impact:\"critical\",messages:{pass:function(a){return\"All table header cells refer to data cells\"},fail:function(a){return\"Not all table header cells refer to data cells\"},incomplete:function(a){return\"Table data cells are missing or empty\"}}},description:{impact:\"serious\",messages:{pass:function(a){return\"The multimedia element has an audio description track\"},fail:function(a){return\"The multimedia element does not have an audio description track\"},incomplete:function(a){return\"An audio description track for this element could not be found\"}}}},failureSummaries:{any:{failureMessage:function(a){var b=\"Fix any of the following:\",c=a;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\"\\n  \"+d.split(\"\\n\").join(\"\\n  \");return b}},none:{failureMessage:function(a){var b=\"Fix all of the following:\",c=a;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\"\\n  \"+d.split(\"\\n\").join(\"\\n  \");return b}}}},rules:[{id:\"accesskeys\",selector:\"[accesskey]\",excludeHidden:!1,tags:[\"wcag2a\",\"wcag211\",\"cat.keyboard\"],all:[],any:[],none:[\"accesskeys\"]},{id:\"area-alt\",selector:\"map area[href]\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-alt\",\"non-empty-title\",\"aria-label\",\"aria-labelledby\"],none:[]},{id:\"aria-allowed-attr\",matches:function(a){var b=a.getAttribute(\"role\");b||(b=axe.commons.aria.implicitRole(a));var c=axe.commons.aria.allowedAttr(b);if(b&&c){var d=/^aria-/;if(a.hasAttributes())for(var e=a.attributes,f=0,g=e.length;f<g;f++)if(d.test(e[f].name))return!0}return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag411\",\"wcag412\"],all:[],any:[\"aria-allowed-attr\"],none:[]},{id:\"aria-required-attr\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag411\",\"wcag412\"],all:[],any:[\"aria-required-attr\"],none:[]},{id:\"aria-required-children\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\"],all:[],any:[\"aria-required-children\"],none:[]},{id:\"aria-required-parent\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\"],all:[],any:[\"aria-required-parent\"],none:[]},{id:\"aria-roles\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\",\"wcag411\",\"wcag412\"],all:[],any:[],none:[\"invalidrole\",\"abstractrole\"]},{id:\"aria-valid-attr-value\",matches:function(a){var b=/^aria-/;if(a.hasAttributes())for(var c=a.attributes,d=0,e=c.length;d<e;d++)if(b.test(c[d].name))return!0;return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag131\",\"wcag411\",\"wcag412\"],all:[],any:[{options:[],id:\"aria-valid-attr-value\"}],none:[]},{id:\"aria-valid-attr\",matches:function(a){var b=/^aria-/;if(a.hasAttributes())for(var c=a.attributes,d=0,e=c.length;d<e;d++)if(b.test(c[d].name))return!0;return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag411\"],all:[],any:[{options:[],id:\"aria-valid-attr\"}],none:[]},{id:\"audio-caption\",selector:\"audio\",excludeHidden:!1,tags:[\"cat.time-and-media\",\"wcag2a\",\"wcag122\",\"section508\",\"section508.22.a\"],all:[],any:[],none:[\"caption\"]},{id:\"blink\",selector:\"blink\",excludeHidden:!1,tags:[\"cat.time-and-media\",\"wcag2a\",\"wcag222\",\"section508\",\"section508.22.j\"],all:[],any:[],none:[\"is-on-screen\"]},{id:\"button-name\",selector:'button, [role=\"button\"], input[type=\"button\"], input[type=\"submit\"], input[type=\"reset\"]',tags:[\"cat.name-role-value\",\"wcag2a\",\"wcag412\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-if-present\",\"non-empty-value\",\"button-has-visible-text\",\"aria-label\",\"aria-labelledby\",\"role-presentation\",\"role-none\"],none:[\"focusable-no-name\"]},{id:\"bypass\",selector:\"html\",pageLevel:!0,matches:function(a){return!!a.querySelector(\"a[href]\")},tags:[\"cat.keyboard\",\"wcag2a\",\"wcag241\",\"section508\",\"section508.22.o\"],all:[],any:[\"internal-link-present\",\"header-present\",\"landmark\"],none:[]},{id:\"checkboxgroup\",selector:\"input[type=checkbox][name]\",tags:[\"cat.forms\",\"best-practice\"],all:[],any:[\"group-labelledby\",\"fieldset\"],none:[]},{id:\"color-contrast\",matches:function(a){var b=a.nodeName.toUpperCase(),c=a.type,d=document;if(\"true\"===a.getAttribute(\"aria-disabled\")||axe.commons.dom.findUp(a,'[aria-disabled=\"true\"]'))return!1;if(\"INPUT\"===b)return-1===[\"hidden\",\"range\",\"color\",\"checkbox\",\"radio\",\"image\"].indexOf(c)&&!a.disabled;if(\"SELECT\"===b)return!!a.options.length&&!a.disabled;if(\"TEXTAREA\"===b)return!a.disabled;if(\"OPTION\"===b)return!1;if(\"BUTTON\"===b&&a.disabled||axe.commons.dom.findUp(a,\"button[disabled]\"))return!1;if(\"FIELDSET\"===b&&a.disabled||axe.commons.dom.findUp(a,\"fieldset[disabled]\"))return!1;var e=axe.commons.dom.findUp(a,\"label\");if(\"LABEL\"===b||e){var f=a;e&&(f=e);var g=f.htmlFor&&d.getElementById(f.htmlFor);if(g&&g.disabled)return!1;var g=a.querySelector('input:not([type=\"hidden\"]):not([type=\"image\"]):not([type=\"button\"]):not([type=\"submit\"]):not([type=\"reset\"]), select, textarea');if(g&&g.disabled)return!1}if(a.id){var g=d.querySelector(\"[aria-labelledby~=\"+axe.commons.utils.escapeSelector(a.id)+\"]\");if(g&&g.disabled)return!1}if(\"\"===axe.commons.text.visible(a,!1,!0))return!1;var h,i,j=document.createRange(),k=a.childNodes,l=k.length;for(i=0;i<l;i++)h=k[i],3===h.nodeType&&\"\"!==axe.commons.text.sanitize(h.nodeValue)&&j.selectNodeContents(h);var m=j.getClientRects();for(l=m.length,i=0;i<l;i++)if(axe.commons.dom.visuallyOverlaps(m[i],a))return!0;return!1},excludeHidden:!1,options:{noScroll:!1},tags:[\"cat.color\",\"wcag2aa\",\"wcag143\"],all:[],any:[\"color-contrast\"],none:[]},{id:\"definition-list\",selector:\"dl:not([role])\",tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"structured-dlitems\",\"only-dlitems\"]},{id:\"dlitem\",selector:\"dd:not([role]), dt:not([role])\",tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[\"dlitem\"],none:[]},{id:\"document-title\",selector:\"html\",matches:function(a){return a.ownerDocument.defaultView.self===a.ownerDocument.defaultView.top},tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag242\"],all:[],any:[\"doc-has-title\"],none:[]},{id:\"duplicate-id\",selector:\"[id]\",excludeHidden:!1,tags:[\"cat.parsing\",\"wcag2a\",\"wcag411\"],all:[],any:[\"duplicate-id\"],none:[]},{id:\"empty-heading\",selector:'h1, h2, h3, h4, h5, h6, [role=\"heading\"]',enabled:!0,tags:[\"cat.name-role-value\",\"best-practice\"],all:[],any:[\"has-visible-text\",\"role-presentation\",\"role-none\"],none:[]},{id:\"frame-title-unique\",selector:\"frame[title]:not([title='']), iframe[title]:not([title=''])\",matches:function(a){var b=a.getAttribute(\"title\");return!!(b?axe.commons.text.sanitize(b).trim():\"\")},tags:[\"cat.text-alternatives\",\"best-practice\"],all:[],any:[],none:[\"unique-frame-title\"]},{id:\"frame-title\",selector:\"frame, iframe\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag241\",\"section508\",\"section508.22.i\"],all:[],any:[\"aria-label\",\"aria-labelledby\",\"non-empty-title\",\"role-presentation\",\"role-none\"],none:[]},{id:\"heading-order\",selector:\"h1,h2,h3,h4,h5,h6,[role=heading]\",enabled:!1,tags:[\"cat.semantics\",\"best-practice\"],all:[],any:[\"heading-order\"],none:[]},{id:\"href-no-hash\",selector:\"a[href]\",enabled:!1,tags:[\"cat.semantics\",\"best-practice\"],all:[],any:[\"href-no-hash\"],none:[]},{id:\"html-has-lang\",selector:\"html\",tags:[\"cat.language\",\"wcag2a\",\"wcag311\"],all:[],any:[\"has-lang\"],none:[]},{id:\"html-lang-valid\",selector:\"html[lang]\",tags:[\"cat.language\",\"wcag2a\",\"wcag311\"],all:[],any:[],none:[{\noptions:[\"aa\",\"ab\",\"ae\",\"af\",\"ak\",\"am\",\"an\",\"ar\",\"as\",\"av\",\"ay\",\"az\",\"ba\",\"be\",\"bg\",\"bh\",\"bi\",\"bm\",\"bn\",\"bo\",\"br\",\"bs\",\"ca\",\"ce\",\"ch\",\"co\",\"cr\",\"cs\",\"cu\",\"cv\",\"cy\",\"da\",\"de\",\"dv\",\"dz\",\"ee\",\"el\",\"en\",\"eo\",\"es\",\"et\",\"eu\",\"fa\",\"ff\",\"fi\",\"fj\",\"fo\",\"fr\",\"fy\",\"ga\",\"gd\",\"gl\",\"gn\",\"gu\",\"gv\",\"ha\",\"he\",\"hi\",\"ho\",\"hr\",\"ht\",\"hu\",\"hy\",\"hz\",\"ia\",\"id\",\"ie\",\"ig\",\"ii\",\"ik\",\"in\",\"io\",\"is\",\"it\",\"iu\",\"iw\",\"ja\",\"ji\",\"jv\",\"jw\",\"ka\",\"kg\",\"ki\",\"kj\",\"kk\",\"kl\",\"km\",\"kn\",\"ko\",\"kr\",\"ks\",\"ku\",\"kv\",\"kw\",\"ky\",\"la\",\"lb\",\"lg\",\"li\",\"ln\",\"lo\",\"lt\",\"lu\",\"lv\",\"mg\",\"mh\",\"mi\",\"mk\",\"ml\",\"mn\",\"mo\",\"mr\",\"ms\",\"mt\",\"my\",\"na\",\"nb\",\"nd\",\"ne\",\"ng\",\"nl\",\"nn\",\"no\",\"nr\",\"nv\",\"ny\",\"oc\",\"oj\",\"om\",\"or\",\"os\",\"pa\",\"pi\",\"pl\",\"ps\",\"pt\",\"qu\",\"rm\",\"rn\",\"ro\",\"ru\",\"rw\",\"sa\",\"sc\",\"sd\",\"se\",\"sg\",\"sh\",\"si\",\"sk\",\"sl\",\"sm\",\"sn\",\"so\",\"sq\",\"sr\",\"ss\",\"st\",\"su\",\"sv\",\"sw\",\"ta\",\"te\",\"tg\",\"th\",\"ti\",\"tk\",\"tl\",\"tn\",\"to\",\"tr\",\"ts\",\"tt\",\"tw\",\"ty\",\"ug\",\"uk\",\"ur\",\"uz\",\"ve\",\"vi\",\"vo\",\"wa\",\"wo\",\"xh\",\"yi\",\"yo\",\"za\",\"zh\",\"zu\",\"aaa\",\"aab\",\"aac\",\"aad\",\"aae\",\"aaf\",\"aag\",\"aah\",\"aai\",\"aak\",\"aal\",\"aam\",\"aan\",\"aao\",\"aap\",\"aaq\",\"aas\",\"aat\",\"aau\",\"aav\",\"aaw\",\"aax\",\"aaz\",\"aba\",\"abb\",\"abc\",\"abd\",\"abe\",\"abf\",\"abg\",\"abh\",\"abi\",\"abj\",\"abl\",\"abm\",\"abn\",\"abo\",\"abp\",\"abq\",\"abr\",\"abs\",\"abt\",\"abu\",\"abv\",\"abw\",\"abx\",\"aby\",\"abz\",\"aca\",\"acb\",\"acd\",\"ace\",\"acf\",\"ach\",\"aci\",\"ack\",\"acl\",\"acm\",\"acn\",\"acp\",\"acq\",\"acr\",\"acs\",\"act\",\"acu\",\"acv\",\"acw\",\"acx\",\"acy\",\"acz\",\"ada\",\"adb\",\"add\",\"ade\",\"adf\",\"adg\",\"adh\",\"adi\",\"adj\",\"adl\",\"adn\",\"ado\",\"adp\",\"adq\",\"adr\",\"ads\",\"adt\",\"adu\",\"adw\",\"adx\",\"ady\",\"adz\",\"aea\",\"aeb\",\"aec\",\"aed\",\"aee\",\"aek\",\"ael\",\"aem\",\"aen\",\"aeq\",\"aer\",\"aes\",\"aeu\",\"aew\",\"aey\",\"aez\",\"afa\",\"afb\",\"afd\",\"afe\",\"afg\",\"afh\",\"afi\",\"afk\",\"afn\",\"afo\",\"afp\",\"afs\",\"aft\",\"afu\",\"afz\",\"aga\",\"agb\",\"agc\",\"agd\",\"age\",\"agf\",\"agg\",\"agh\",\"agi\",\"agj\",\"agk\",\"agl\",\"agm\",\"agn\",\"ago\",\"agp\",\"agq\",\"agr\",\"ags\",\"agt\",\"agu\",\"agv\",\"agw\",\"agx\",\"agy\",\"agz\",\"aha\",\"ahb\",\"ahg\",\"ahh\",\"ahi\",\"ahk\",\"ahl\",\"ahm\",\"ahn\",\"aho\",\"ahp\",\"ahr\",\"ahs\",\"aht\",\"aia\",\"aib\",\"aic\",\"aid\",\"aie\",\"aif\",\"aig\",\"aih\",\"aii\",\"aij\",\"aik\",\"ail\",\"aim\",\"ain\",\"aio\",\"aip\",\"aiq\",\"air\",\"ais\",\"ait\",\"aiw\",\"aix\",\"aiy\",\"aja\",\"ajg\",\"aji\",\"ajn\",\"ajp\",\"ajt\",\"aju\",\"ajw\",\"ajz\",\"akb\",\"akc\",\"akd\",\"ake\",\"akf\",\"akg\",\"akh\",\"aki\",\"akj\",\"akk\",\"akl\",\"akm\",\"ako\",\"akp\",\"akq\",\"akr\",\"aks\",\"akt\",\"aku\",\"akv\",\"akw\",\"akx\",\"aky\",\"akz\",\"ala\",\"alc\",\"ald\",\"ale\",\"alf\",\"alg\",\"alh\",\"ali\",\"alj\",\"alk\",\"all\",\"alm\",\"aln\",\"alo\",\"alp\",\"alq\",\"alr\",\"als\",\"alt\",\"alu\",\"alv\",\"alw\",\"alx\",\"aly\",\"alz\",\"ama\",\"amb\",\"amc\",\"ame\",\"amf\",\"amg\",\"ami\",\"amj\",\"amk\",\"aml\",\"amm\",\"amn\",\"amo\",\"amp\",\"amq\",\"amr\",\"ams\",\"amt\",\"amu\",\"amv\",\"amw\",\"amx\",\"amy\",\"amz\",\"ana\",\"anb\",\"anc\",\"and\",\"ane\",\"anf\",\"ang\",\"anh\",\"ani\",\"anj\",\"ank\",\"anl\",\"anm\",\"ann\",\"ano\",\"anp\",\"anq\",\"anr\",\"ans\",\"ant\",\"anu\",\"anv\",\"anw\",\"anx\",\"any\",\"anz\",\"aoa\",\"aob\",\"aoc\",\"aod\",\"aoe\",\"aof\",\"aog\",\"aoh\",\"aoi\",\"aoj\",\"aok\",\"aol\",\"aom\",\"aon\",\"aor\",\"aos\",\"aot\",\"aou\",\"aox\",\"aoz\",\"apa\",\"apb\",\"apc\",\"apd\",\"ape\",\"apf\",\"apg\",\"aph\",\"api\",\"apj\",\"apk\",\"apl\",\"apm\",\"apn\",\"apo\",\"app\",\"apq\",\"apr\",\"aps\",\"apt\",\"apu\",\"apv\",\"apw\",\"apx\",\"apy\",\"apz\",\"aqa\",\"aqc\",\"aqd\",\"aqg\",\"aql\",\"aqm\",\"aqn\",\"aqp\",\"aqr\",\"aqt\",\"aqz\",\"arb\",\"arc\",\"ard\",\"are\",\"arh\",\"ari\",\"arj\",\"ark\",\"arl\",\"arn\",\"aro\",\"arp\",\"arq\",\"arr\",\"ars\",\"art\",\"aru\",\"arv\",\"arw\",\"arx\",\"ary\",\"arz\",\"asa\",\"asb\",\"asc\",\"asd\",\"ase\",\"asf\",\"asg\",\"ash\",\"asi\",\"asj\",\"ask\",\"asl\",\"asn\",\"aso\",\"asp\",\"asq\",\"asr\",\"ass\",\"ast\",\"asu\",\"asv\",\"asw\",\"asx\",\"asy\",\"asz\",\"ata\",\"atb\",\"atc\",\"atd\",\"ate\",\"atg\",\"ath\",\"ati\",\"atj\",\"atk\",\"atl\",\"atm\",\"atn\",\"ato\",\"atp\",\"atq\",\"atr\",\"ats\",\"att\",\"atu\",\"atv\",\"atw\",\"atx\",\"aty\",\"atz\",\"aua\",\"aub\",\"auc\",\"aud\",\"aue\",\"auf\",\"aug\",\"auh\",\"aui\",\"auj\",\"auk\",\"aul\",\"aum\",\"aun\",\"auo\",\"aup\",\"auq\",\"aur\",\"aus\",\"aut\",\"auu\",\"auw\",\"aux\",\"auy\",\"auz\",\"avb\",\"avd\",\"avi\",\"avk\",\"avl\",\"avm\",\"avn\",\"avo\",\"avs\",\"avt\",\"avu\",\"avv\",\"awa\",\"awb\",\"awc\",\"awd\",\"awe\",\"awg\",\"awh\",\"awi\",\"awk\",\"awm\",\"awn\",\"awo\",\"awr\",\"aws\",\"awt\",\"awu\",\"awv\",\"aww\",\"awx\",\"awy\",\"axb\",\"axe\",\"axg\",\"axk\",\"axl\",\"axm\",\"axx\",\"aya\",\"ayb\",\"ayc\",\"ayd\",\"aye\",\"ayg\",\"ayh\",\"ayi\",\"ayk\",\"ayl\",\"ayn\",\"ayo\",\"ayp\",\"ayq\",\"ayr\",\"ays\",\"ayt\",\"ayu\",\"ayx\",\"ayy\",\"ayz\",\"aza\",\"azb\",\"azc\",\"azd\",\"azg\",\"azj\",\"azm\",\"azn\",\"azo\",\"azt\",\"azz\",\"baa\",\"bab\",\"bac\",\"bad\",\"bae\",\"baf\",\"bag\",\"bah\",\"bai\",\"baj\",\"bal\",\"ban\",\"bao\",\"bap\",\"bar\",\"bas\",\"bat\",\"bau\",\"bav\",\"baw\",\"bax\",\"bay\",\"baz\",\"bba\",\"bbb\",\"bbc\",\"bbd\",\"bbe\",\"bbf\",\"bbg\",\"bbh\",\"bbi\",\"bbj\",\"bbk\",\"bbl\",\"bbm\",\"bbn\",\"bbo\",\"bbp\",\"bbq\",\"bbr\",\"bbs\",\"bbt\",\"bbu\",\"bbv\",\"bbw\",\"bbx\",\"bby\",\"bbz\",\"bca\",\"bcb\",\"bcc\",\"bcd\",\"bce\",\"bcf\",\"bcg\",\"bch\",\"bci\",\"bcj\",\"bck\",\"bcl\",\"bcm\",\"bcn\",\"bco\",\"bcp\",\"bcq\",\"bcr\",\"bcs\",\"bct\",\"bcu\",\"bcv\",\"bcw\",\"bcy\",\"bcz\",\"bda\",\"bdb\",\"bdc\",\"bdd\",\"bde\",\"bdf\",\"bdg\",\"bdh\",\"bdi\",\"bdj\",\"bdk\",\"bdl\",\"bdm\",\"bdn\",\"bdo\",\"bdp\",\"bdq\",\"bdr\",\"bds\",\"bdt\",\"bdu\",\"bdv\",\"bdw\",\"bdx\",\"bdy\",\"bdz\",\"bea\",\"beb\",\"bec\",\"bed\",\"bee\",\"bef\",\"beg\",\"beh\",\"bei\",\"bej\",\"bek\",\"bem\",\"beo\",\"bep\",\"beq\",\"ber\",\"bes\",\"bet\",\"beu\",\"bev\",\"bew\",\"bex\",\"bey\",\"bez\",\"bfa\",\"bfb\",\"bfc\",\"bfd\",\"bfe\",\"bff\",\"bfg\",\"bfh\",\"bfi\",\"bfj\",\"bfk\",\"bfl\",\"bfm\",\"bfn\",\"bfo\",\"bfp\",\"bfq\",\"bfr\",\"bfs\",\"bft\",\"bfu\",\"bfw\",\"bfx\",\"bfy\",\"bfz\",\"bga\",\"bgb\",\"bgc\",\"bgd\",\"bge\",\"bgf\",\"bgg\",\"bgi\",\"bgj\",\"bgk\",\"bgl\",\"bgm\",\"bgn\",\"bgo\",\"bgp\",\"bgq\",\"bgr\",\"bgs\",\"bgt\",\"bgu\",\"bgv\",\"bgw\",\"bgx\",\"bgy\",\"bgz\",\"bha\",\"bhb\",\"bhc\",\"bhd\",\"bhe\",\"bhf\",\"bhg\",\"bhh\",\"bhi\",\"bhj\",\"bhk\",\"bhl\",\"bhm\",\"bhn\",\"bho\",\"bhp\",\"bhq\",\"bhr\",\"bhs\",\"bht\",\"bhu\",\"bhv\",\"bhw\",\"bhx\",\"bhy\",\"bhz\",\"bia\",\"bib\",\"bic\",\"bid\",\"bie\",\"bif\",\"big\",\"bij\",\"bik\",\"bil\",\"bim\",\"bin\",\"bio\",\"bip\",\"biq\",\"bir\",\"bit\",\"biu\",\"biv\",\"biw\",\"bix\",\"biy\",\"biz\",\"bja\",\"bjb\",\"bjc\",\"bjd\",\"bje\",\"bjf\",\"bjg\",\"bjh\",\"bji\",\"bjj\",\"bjk\",\"bjl\",\"bjm\",\"bjn\",\"bjo\",\"bjp\",\"bjq\",\"bjr\",\"bjs\",\"bjt\",\"bju\",\"bjv\",\"bjw\",\"bjx\",\"bjy\",\"bjz\",\"bka\",\"bkb\",\"bkc\",\"bkd\",\"bkf\",\"bkg\",\"bkh\",\"bki\",\"bkj\",\"bkk\",\"bkl\",\"bkm\",\"bkn\",\"bko\",\"bkp\",\"bkq\",\"bkr\",\"bks\",\"bkt\",\"bku\",\"bkv\",\"bkw\",\"bkx\",\"bky\",\"bkz\",\"bla\",\"blb\",\"blc\",\"bld\",\"ble\",\"blf\",\"blg\",\"blh\",\"bli\",\"blj\",\"blk\",\"bll\",\"blm\",\"bln\",\"blo\",\"blp\",\"blq\",\"blr\",\"bls\",\"blt\",\"blv\",\"blw\",\"blx\",\"bly\",\"blz\",\"bma\",\"bmb\",\"bmc\",\"bmd\",\"bme\",\"bmf\",\"bmg\",\"bmh\",\"bmi\",\"bmj\",\"bmk\",\"bml\",\"bmm\",\"bmn\",\"bmo\",\"bmp\",\"bmq\",\"bmr\",\"bms\",\"bmt\",\"bmu\",\"bmv\",\"bmw\",\"bmx\",\"bmy\",\"bmz\",\"bna\",\"bnb\",\"bnc\",\"bnd\",\"bne\",\"bnf\",\"bng\",\"bni\",\"bnj\",\"bnk\",\"bnl\",\"bnm\",\"bnn\",\"bno\",\"bnp\",\"bnq\",\"bnr\",\"bns\",\"bnt\",\"bnu\",\"bnv\",\"bnw\",\"bnx\",\"bny\",\"bnz\",\"boa\",\"bob\",\"boe\",\"bof\",\"bog\",\"boh\",\"boi\",\"boj\",\"bok\",\"bol\",\"bom\",\"bon\",\"boo\",\"bop\",\"boq\",\"bor\",\"bot\",\"bou\",\"bov\",\"bow\",\"box\",\"boy\",\"boz\",\"bpa\",\"bpb\",\"bpd\",\"bpg\",\"bph\",\"bpi\",\"bpj\",\"bpk\",\"bpl\",\"bpm\",\"bpn\",\"bpo\",\"bpp\",\"bpq\",\"bpr\",\"bps\",\"bpt\",\"bpu\",\"bpv\",\"bpw\",\"bpx\",\"bpy\",\"bpz\",\"bqa\",\"bqb\",\"bqc\",\"bqd\",\"bqf\",\"bqg\",\"bqh\",\"bqi\",\"bqj\",\"bqk\",\"bql\",\"bqm\",\"bqn\",\"bqo\",\"bqp\",\"bqq\",\"bqr\",\"bqs\",\"bqt\",\"bqu\",\"bqv\",\"bqw\",\"bqx\",\"bqy\",\"bqz\",\"bra\",\"brb\",\"brc\",\"brd\",\"brf\",\"brg\",\"brh\",\"bri\",\"brj\",\"brk\",\"brl\",\"brm\",\"brn\",\"bro\",\"brp\",\"brq\",\"brr\",\"brs\",\"brt\",\"bru\",\"brv\",\"brw\",\"brx\",\"bry\",\"brz\",\"bsa\",\"bsb\",\"bsc\",\"bse\",\"bsf\",\"bsg\",\"bsh\",\"bsi\",\"bsj\",\"bsk\",\"bsl\",\"bsm\",\"bsn\",\"bso\",\"bsp\",\"bsq\",\"bsr\",\"bss\",\"bst\",\"bsu\",\"bsv\",\"bsw\",\"bsx\",\"bsy\",\"bta\",\"btb\",\"btc\",\"btd\",\"bte\",\"btf\",\"btg\",\"bth\",\"bti\",\"btj\",\"btk\",\"btl\",\"btm\",\"btn\",\"bto\",\"btp\",\"btq\",\"btr\",\"bts\",\"btt\",\"btu\",\"btv\",\"btw\",\"btx\",\"bty\",\"btz\",\"bua\",\"bub\",\"buc\",\"bud\",\"bue\",\"buf\",\"bug\",\"buh\",\"bui\",\"buj\",\"buk\",\"bum\",\"bun\",\"buo\",\"bup\",\"buq\",\"bus\",\"but\",\"buu\",\"buv\",\"buw\",\"bux\",\"buy\",\"buz\",\"bva\",\"bvb\",\"bvc\",\"bvd\",\"bve\",\"bvf\",\"bvg\",\"bvh\",\"bvi\",\"bvj\",\"bvk\",\"bvl\",\"bvm\",\"bvn\",\"bvo\",\"bvp\",\"bvq\",\"bvr\",\"bvt\",\"bvu\",\"bvv\",\"bvw\",\"bvx\",\"bvy\",\"bvz\",\"bwa\",\"bwb\",\"bwc\",\"bwd\",\"bwe\",\"bwf\",\"bwg\",\"bwh\",\"bwi\",\"bwj\",\"bwk\",\"bwl\",\"bwm\",\"bwn\",\"bwo\",\"bwp\",\"bwq\",\"bwr\",\"bws\",\"bwt\",\"bwu\",\"bww\",\"bwx\",\"bwy\",\"bwz\",\"bxa\",\"bxb\",\"bxc\",\"bxd\",\"bxe\",\"bxf\",\"bxg\",\"bxh\",\"bxi\",\"bxj\",\"bxk\",\"bxl\",\"bxm\",\"bxn\",\"bxo\",\"bxp\",\"bxq\",\"bxr\",\"bxs\",\"bxu\",\"bxv\",\"bxw\",\"bxx\",\"bxz\",\"bya\",\"byb\",\"byc\",\"byd\",\"bye\",\"byf\",\"byg\",\"byh\",\"byi\",\"byj\",\"byk\",\"byl\",\"bym\",\"byn\",\"byo\",\"byp\",\"byq\",\"byr\",\"bys\",\"byt\",\"byv\",\"byw\",\"byx\",\"byy\",\"byz\",\"bza\",\"bzb\",\"bzc\",\"bzd\",\"bze\",\"bzf\",\"bzg\",\"bzh\",\"bzi\",\"bzj\",\"bzk\",\"bzl\",\"bzm\",\"bzn\",\"bzo\",\"bzp\",\"bzq\",\"bzr\",\"bzs\",\"bzt\",\"bzu\",\"bzv\",\"bzw\",\"bzx\",\"bzy\",\"bzz\",\"caa\",\"cab\",\"cac\",\"cad\",\"cae\",\"caf\",\"cag\",\"cah\",\"cai\",\"caj\",\"cak\",\"cal\",\"cam\",\"can\",\"cao\",\"cap\",\"caq\",\"car\",\"cas\",\"cau\",\"cav\",\"caw\",\"cax\",\"cay\",\"caz\",\"cba\",\"cbb\",\"cbc\",\"cbd\",\"cbe\",\"cbg\",\"cbh\",\"cbi\",\"cbj\",\"cbk\",\"cbl\",\"cbn\",\"cbo\",\"cbq\",\"cbr\",\"cbs\",\"cbt\",\"cbu\",\"cbv\",\"cbw\",\"cby\",\"cca\",\"ccc\",\"ccd\",\"cce\",\"ccg\",\"cch\",\"ccj\",\"ccl\",\"ccm\",\"ccn\",\"cco\",\"ccp\",\"ccq\",\"ccr\",\"ccs\",\"cda\",\"cdc\",\"cdd\",\"cde\",\"cdf\",\"cdg\",\"cdh\",\"cdi\",\"cdj\",\"cdm\",\"cdn\",\"cdo\",\"cdr\",\"cds\",\"cdy\",\"cdz\",\"cea\",\"ceb\",\"ceg\",\"cek\",\"cel\",\"cen\",\"cet\",\"cfa\",\"cfd\",\"cfg\",\"cfm\",\"cga\",\"cgc\",\"cgg\",\"cgk\",\"chb\",\"chc\",\"chd\",\"chf\",\"chg\",\"chh\",\"chj\",\"chk\",\"chl\",\"chm\",\"chn\",\"cho\",\"chp\",\"chq\",\"chr\",\"cht\",\"chw\",\"chx\",\"chy\",\"chz\",\"cia\",\"cib\",\"cic\",\"cid\",\"cie\",\"cih\",\"cik\",\"cim\",\"cin\",\"cip\",\"cir\",\"ciw\",\"ciy\",\"cja\",\"cje\",\"cjh\",\"cji\",\"cjk\",\"cjm\",\"cjn\",\"cjo\",\"cjp\",\"cjr\",\"cjs\",\"cjv\",\"cjy\",\"cka\",\"ckb\",\"ckh\",\"ckl\",\"ckn\",\"cko\",\"ckq\",\"ckr\",\"cks\",\"ckt\",\"cku\",\"ckv\",\"ckx\",\"cky\",\"ckz\",\"cla\",\"clc\",\"cld\",\"cle\",\"clh\",\"cli\",\"clj\",\"clk\",\"cll\",\"clm\",\"clo\",\"clt\",\"clu\",\"clw\",\"cly\",\"cma\",\"cmc\",\"cme\",\"cmg\",\"cmi\",\"cmk\",\"cml\",\"cmm\",\"cmn\",\"cmo\",\"cmr\",\"cms\",\"cmt\",\"cna\",\"cnb\",\"cnc\",\"cng\",\"cnh\",\"cni\",\"cnk\",\"cnl\",\"cno\",\"cns\",\"cnt\",\"cnu\",\"cnw\",\"cnx\",\"coa\",\"cob\",\"coc\",\"cod\",\"coe\",\"cof\",\"cog\",\"coh\",\"coj\",\"cok\",\"col\",\"com\",\"con\",\"coo\",\"cop\",\"coq\",\"cot\",\"cou\",\"cov\",\"cow\",\"cox\",\"coy\",\"coz\",\"cpa\",\"cpb\",\"cpc\",\"cpe\",\"cpf\",\"cpg\",\"cpi\",\"cpn\",\"cpo\",\"cpp\",\"cps\",\"cpu\",\"cpx\",\"cpy\",\"cqd\",\"cqu\",\"cra\",\"crb\",\"crc\",\"crd\",\"crf\",\"crg\",\"crh\",\"cri\",\"crj\",\"crk\",\"crl\",\"crm\",\"crn\",\"cro\",\"crp\",\"crq\",\"crr\",\"crs\",\"crt\",\"crv\",\"crw\",\"crx\",\"cry\",\"crz\",\"csa\",\"csb\",\"csc\",\"csd\",\"cse\",\"csf\",\"csg\",\"csh\",\"csi\",\"csj\",\"csk\",\"csl\",\"csm\",\"csn\",\"cso\",\"csq\",\"csr\",\"css\",\"cst\",\"csu\",\"csv\",\"csw\",\"csy\",\"csz\",\"cta\",\"ctc\",\"ctd\",\"cte\",\"ctg\",\"cth\",\"ctl\",\"ctm\",\"ctn\",\"cto\",\"ctp\",\"cts\",\"ctt\",\"ctu\",\"ctz\",\"cua\",\"cub\",\"cuc\",\"cug\",\"cuh\",\"cui\",\"cuj\",\"cuk\",\"cul\",\"cum\",\"cuo\",\"cup\",\"cuq\",\"cur\",\"cus\",\"cut\",\"cuu\",\"cuv\",\"cuw\",\"cux\",\"cvg\",\"cvn\",\"cwa\",\"cwb\",\"cwd\",\"cwe\",\"cwg\",\"cwt\",\"cya\",\"cyb\",\"cyo\",\"czh\",\"czk\",\"czn\",\"czo\",\"czt\",\"daa\",\"dac\",\"dad\",\"dae\",\"daf\",\"dag\",\"dah\",\"dai\",\"daj\",\"dak\",\"dal\",\"dam\",\"dao\",\"dap\",\"daq\",\"dar\",\"das\",\"dau\",\"dav\",\"daw\",\"dax\",\"day\",\"daz\",\"dba\",\"dbb\",\"dbd\",\"dbe\",\"dbf\",\"dbg\",\"dbi\",\"dbj\",\"dbl\",\"dbm\",\"dbn\",\"dbo\",\"dbp\",\"dbq\",\"dbr\",\"dbt\",\"dbu\",\"dbv\",\"dbw\",\"dby\",\"dcc\",\"dcr\",\"dda\",\"ddd\",\"dde\",\"ddg\",\"ddi\",\"ddj\",\"ddn\",\"ddo\",\"ddr\",\"dds\",\"ddw\",\"dec\",\"ded\",\"dee\",\"def\",\"deg\",\"deh\",\"dei\",\"dek\",\"del\",\"dem\",\"den\",\"dep\",\"deq\",\"der\",\"des\",\"dev\",\"dez\",\"dga\",\"dgb\",\"dgc\",\"dgd\",\"dge\",\"dgg\",\"dgh\",\"dgi\",\"dgk\",\"dgl\",\"dgn\",\"dgo\",\"dgr\",\"dgs\",\"dgt\",\"dgu\",\"dgw\",\"dgx\",\"dgz\",\"dha\",\"dhd\",\"dhg\",\"dhi\",\"dhl\",\"dhm\",\"dhn\",\"dho\",\"dhr\",\"dhs\",\"dhu\",\"dhv\",\"dhw\",\"dhx\",\"dia\",\"dib\",\"dic\",\"did\",\"dif\",\"dig\",\"dih\",\"dii\",\"dij\",\"dik\",\"dil\",\"dim\",\"din\",\"dio\",\"dip\",\"diq\",\"dir\",\"dis\",\"dit\",\"diu\",\"diw\",\"dix\",\"diy\",\"diz\",\"dja\",\"djb\",\"djc\",\"djd\",\"dje\",\"djf\",\"dji\",\"djj\",\"djk\",\"djl\",\"djm\",\"djn\",\"djo\",\"djr\",\"dju\",\"djw\",\"dka\",\"dkk\",\"dkl\",\"dkr\",\"dks\",\"dkx\",\"dlg\",\"dlk\",\"dlm\",\"dln\",\"dma\",\"dmb\",\"dmc\",\"dmd\",\"dme\",\"dmg\",\"dmk\",\"dml\",\"dmm\",\"dmn\",\"dmo\",\"dmr\",\"dms\",\"dmu\",\"dmv\",\"dmw\",\"dmx\",\"dmy\",\"dna\",\"dnd\",\"dne\",\"dng\",\"dni\",\"dnj\",\"dnk\",\"dnn\",\"dnr\",\"dnt\",\"dnu\",\"dnv\",\"dnw\",\"dny\",\"doa\",\"dob\",\"doc\",\"doe\",\"dof\",\"doh\",\"doi\",\"dok\",\"dol\",\"don\",\"doo\",\"dop\",\"doq\",\"dor\",\"dos\",\"dot\",\"dov\",\"dow\",\"dox\",\"doy\",\"doz\",\"dpp\",\"dra\",\"drb\",\"drc\",\"drd\",\"dre\",\"drg\",\"drh\",\"dri\",\"drl\",\"drn\",\"dro\",\"drq\",\"drr\",\"drs\",\"drt\",\"dru\",\"drw\",\"dry\",\"dsb\",\"dse\",\"dsh\",\"dsi\",\"dsl\",\"dsn\",\"dso\",\"dsq\",\"dta\",\"dtb\",\"dtd\",\"dth\",\"dti\",\"dtk\",\"dtm\",\"dtn\",\"dto\",\"dtp\",\"dtr\",\"dts\",\"dtt\",\"dtu\",\"dty\",\"dua\",\"dub\",\"duc\",\"dud\",\"due\",\"duf\",\"dug\",\"duh\",\"dui\",\"duj\",\"duk\",\"dul\",\"dum\",\"dun\",\"duo\",\"dup\",\"duq\",\"dur\",\"dus\",\"duu\",\"duv\",\"duw\",\"dux\",\"duy\",\"duz\",\"dva\",\"dwa\",\"dwl\",\"dwr\",\"dws\",\"dwu\",\"dww\",\"dwy\",\"dya\",\"dyb\",\"dyd\",\"dyg\",\"dyi\",\"dym\",\"dyn\",\"dyo\",\"dyu\",\"dyy\",\"dza\",\"dzd\",\"dze\",\"dzg\",\"dzl\",\"dzn\",\"eaa\",\"ebg\",\"ebk\",\"ebo\",\"ebr\",\"ebu\",\"ecr\",\"ecs\",\"ecy\",\"eee\",\"efa\",\"efe\",\"efi\",\"ega\",\"egl\",\"ego\",\"egx\",\"egy\",\"ehu\",\"eip\",\"eit\",\"eiv\",\"eja\",\"eka\",\"ekc\",\"eke\",\"ekg\",\"eki\",\"ekk\",\"ekl\",\"ekm\",\"eko\",\"ekp\",\"ekr\",\"eky\",\"ele\",\"elh\",\"eli\",\"elk\",\"elm\",\"elo\",\"elp\",\"elu\",\"elx\",\"ema\",\"emb\",\"eme\",\"emg\",\"emi\",\"emk\",\"emm\",\"emn\",\"emo\",\"emp\",\"ems\",\"emu\",\"emw\",\"emx\",\"emy\",\"ena\",\"enb\",\"enc\",\"end\",\"enf\",\"enh\",\"enl\",\"enm\",\"enn\",\"eno\",\"enq\",\"enr\",\"enu\",\"env\",\"enw\",\"enx\",\"eot\",\"epi\",\"era\",\"erg\",\"erh\",\"eri\",\"erk\",\"ero\",\"err\",\"ers\",\"ert\",\"erw\",\"ese\",\"esg\",\"esh\",\"esi\",\"esk\",\"esl\",\"esm\",\"esn\",\"eso\",\"esq\",\"ess\",\"esu\",\"esx\",\"esy\",\"etb\",\"etc\",\"eth\",\"etn\",\"eto\",\"etr\",\"ets\",\"ett\",\"etu\",\"etx\",\"etz\",\"euq\",\"eve\",\"evh\",\"evn\",\"ewo\",\"ext\",\"eya\",\"eyo\",\"eza\",\"eze\",\"faa\",\"fab\",\"fad\",\"faf\",\"fag\",\"fah\",\"fai\",\"faj\",\"fak\",\"fal\",\"fam\",\"fan\",\"fap\",\"far\",\"fat\",\"fau\",\"fax\",\"fay\",\"faz\",\"fbl\",\"fcs\",\"fer\",\"ffi\",\"ffm\",\"fgr\",\"fia\",\"fie\",\"fil\",\"fip\",\"fir\",\"fit\",\"fiu\",\"fiw\",\"fkk\",\"fkv\",\"fla\",\"flh\",\"fli\",\"fll\",\"fln\",\"flr\",\"fly\",\"fmp\",\"fmu\",\"fnb\",\"fng\",\"fni\",\"fod\",\"foi\",\"fom\",\"fon\",\"for\",\"fos\",\"fox\",\"fpe\",\"fqs\",\"frc\",\"frd\",\"frk\",\"frm\",\"fro\",\"frp\",\"frq\",\"frr\",\"frs\",\"frt\",\"fse\",\"fsl\",\"fss\",\"fub\",\"fuc\",\"fud\",\"fue\",\"fuf\",\"fuh\",\"fui\",\"fuj\",\"fum\",\"fun\",\"fuq\",\"fur\",\"fut\",\"fuu\",\"fuv\",\"fuy\",\"fvr\",\"fwa\",\"fwe\",\"gaa\",\"gab\",\"gac\",\"gad\",\"gae\",\"gaf\",\"gag\",\"gah\",\"gai\",\"gaj\",\"gak\",\"gal\",\"gam\",\"gan\",\"gao\",\"gap\",\"gaq\",\"gar\",\"gas\",\"gat\",\"gau\",\"gav\",\"gaw\",\"gax\",\"gay\",\"gaz\",\"gba\",\"gbb\",\"gbc\",\"gbd\",\"gbe\",\"gbf\",\"gbg\",\"gbh\",\"gbi\",\"gbj\",\"gbk\",\"gbl\",\"gbm\",\"gbn\",\"gbo\",\"gbp\",\"gbq\",\"gbr\",\"gbs\",\"gbu\",\"gbv\",\"gbw\",\"gbx\",\"gby\",\"gbz\",\"gcc\",\"gcd\",\"gce\",\"gcf\",\"gcl\",\"gcn\",\"gcr\",\"gct\",\"gda\",\"gdb\",\"gdc\",\"gdd\",\"gde\",\"gdf\",\"gdg\",\"gdh\",\"gdi\",\"gdj\",\"gdk\",\"gdl\",\"gdm\",\"gdn\",\"gdo\",\"gdq\",\"gdr\",\"gds\",\"gdt\",\"gdu\",\"gdx\",\"gea\",\"geb\",\"gec\",\"ged\",\"geg\",\"geh\",\"gei\",\"gej\",\"gek\",\"gel\",\"gem\",\"geq\",\"ges\",\"gev\",\"gew\",\"gex\",\"gey\",\"gez\",\"gfk\",\"gft\",\"gfx\",\"gga\",\"ggb\",\"ggd\",\"gge\",\"ggg\",\"ggk\",\"ggl\",\"ggn\",\"ggo\",\"ggr\",\"ggt\",\"ggu\",\"ggw\",\"gha\",\"ghc\",\"ghe\",\"ghh\",\"ghk\",\"ghl\",\"ghn\",\"gho\",\"ghr\",\"ghs\",\"ght\",\"gia\",\"gib\",\"gic\",\"gid\",\"gig\",\"gih\",\"gil\",\"gim\",\"gin\",\"gio\",\"gip\",\"giq\",\"gir\",\"gis\",\"git\",\"giu\",\"giw\",\"gix\",\"giy\",\"giz\",\"gji\",\"gjk\",\"gjm\",\"gjn\",\"gjr\",\"gju\",\"gka\",\"gke\",\"gkn\",\"gko\",\"gkp\",\"gku\",\"glc\",\"gld\",\"glh\",\"gli\",\"glj\",\"glk\",\"gll\",\"glo\",\"glr\",\"glu\",\"glw\",\"gly\",\"gma\",\"gmb\",\"gmd\",\"gme\",\"gmg\",\"gmh\",\"gml\",\"gmm\",\"gmn\",\"gmq\",\"gmu\",\"gmv\",\"gmw\",\"gmx\",\"gmy\",\"gmz\",\"gna\",\"gnb\",\"gnc\",\"gnd\",\"gne\",\"gng\",\"gnh\",\"gni\",\"gnk\",\"gnl\",\"gnm\",\"gnn\",\"gno\",\"gnq\",\"gnr\",\"gnt\",\"gnu\",\"gnw\",\"gnz\",\"goa\",\"gob\",\"goc\",\"god\",\"goe\",\"gof\",\"gog\",\"goh\",\"goi\",\"goj\",\"gok\",\"gol\",\"gom\",\"gon\",\"goo\",\"gop\",\"goq\",\"gor\",\"gos\",\"got\",\"gou\",\"gow\",\"gox\",\"goy\",\"goz\",\"gpa\",\"gpe\",\"gpn\",\"gqa\",\"gqi\",\"gqn\",\"gqr\",\"gqu\",\"gra\",\"grb\",\"grc\",\"grd\",\"grg\",\"grh\",\"gri\",\"grj\",\"grk\",\"grm\",\"gro\",\"grq\",\"grr\",\"grs\",\"grt\",\"gru\",\"grv\",\"grw\",\"grx\",\"gry\",\"grz\",\"gse\",\"gsg\",\"gsl\",\"gsm\",\"gsn\",\"gso\",\"gsp\",\"gss\",\"gsw\",\"gta\",\"gti\",\"gtu\",\"gua\",\"gub\",\"guc\",\"gud\",\"gue\",\"guf\",\"gug\",\"guh\",\"gui\",\"guk\",\"gul\",\"gum\",\"gun\",\"guo\",\"gup\",\"guq\",\"gur\",\"gus\",\"gut\",\"guu\",\"guv\",\"guw\",\"gux\",\"guz\",\"gva\",\"gvc\",\"gve\",\"gvf\",\"gvj\",\"gvl\",\"gvm\",\"gvn\",\"gvo\",\"gvp\",\"gvr\",\"gvs\",\"gvy\",\"gwa\",\"gwb\",\"gwc\",\"gwd\",\"gwe\",\"gwf\",\"gwg\",\"gwi\",\"gwj\",\"gwm\",\"gwn\",\"gwr\",\"gwt\",\"gwu\",\"gww\",\"gwx\",\"gxx\",\"gya\",\"gyb\",\"gyd\",\"gye\",\"gyf\",\"gyg\",\"gyi\",\"gyl\",\"gym\",\"gyn\",\"gyr\",\"gyy\",\"gza\",\"gzi\",\"gzn\",\"haa\",\"hab\",\"hac\",\"had\",\"hae\",\"haf\",\"hag\",\"hah\",\"hai\",\"haj\",\"hak\",\"hal\",\"ham\",\"han\",\"hao\",\"hap\",\"haq\",\"har\",\"has\",\"hav\",\"haw\",\"hax\",\"hay\",\"haz\",\"hba\",\"hbb\",\"hbn\",\"hbo\",\"hbu\",\"hca\",\"hch\",\"hdn\",\"hds\",\"hdy\",\"hea\",\"hed\",\"heg\",\"heh\",\"hei\",\"hem\",\"hgm\",\"hgw\",\"hhi\",\"hhr\",\"hhy\",\"hia\",\"hib\",\"hid\",\"hif\",\"hig\",\"hih\",\"hii\",\"hij\",\"hik\",\"hil\",\"him\",\"hio\",\"hir\",\"hit\",\"hiw\",\"hix\",\"hji\",\"hka\",\"hke\",\"hkk\",\"hks\",\"hla\",\"hlb\",\"hld\",\"hle\",\"hlt\",\"hlu\",\"hma\",\"hmb\",\"hmc\",\"hmd\",\"hme\",\"hmf\",\"hmg\",\"hmh\",\"hmi\",\"hmj\",\"hmk\",\"hml\",\"hmm\",\"hmn\",\"hmp\",\"hmq\",\"hmr\",\"hms\",\"hmt\",\"hmu\",\"hmv\",\"hmw\",\"hmx\",\"hmy\",\"hmz\",\"hna\",\"hnd\",\"hne\",\"hnh\",\"hni\",\"hnj\",\"hnn\",\"hno\",\"hns\",\"hnu\",\"hoa\",\"hob\",\"hoc\",\"hod\",\"hoe\",\"hoh\",\"hoi\",\"hoj\",\"hok\",\"hol\",\"hom\",\"hoo\",\"hop\",\"hor\",\"hos\",\"hot\",\"hov\",\"how\",\"hoy\",\"hoz\",\"hpo\",\"hps\",\"hra\",\"hrc\",\"hre\",\"hrk\",\"hrm\",\"hro\",\"hrp\",\"hrr\",\"hrt\",\"hru\",\"hrw\",\"hrx\",\"hrz\",\"hsb\",\"hsh\",\"hsl\",\"hsn\",\"hss\",\"hti\",\"hto\",\"hts\",\"htu\",\"htx\",\"hub\",\"huc\",\"hud\",\"hue\",\"huf\",\"hug\",\"huh\",\"hui\",\"huj\",\"huk\",\"hul\",\"hum\",\"huo\",\"hup\",\"huq\",\"hur\",\"hus\",\"hut\",\"huu\",\"huv\",\"huw\",\"hux\",\"huy\",\"huz\",\"hvc\",\"hve\",\"hvk\",\"hvn\",\"hvv\",\"hwa\",\"hwc\",\"hwo\",\"hya\",\"hyx\",\"iai\",\"ian\",\"iap\",\"iar\",\"iba\",\"ibb\",\"ibd\",\"ibe\",\"ibg\",\"ibi\",\"ibl\",\"ibm\",\"ibn\",\"ibr\",\"ibu\",\"iby\",\"ica\",\"ich\",\"icl\",\"icr\",\"ida\",\"idb\",\"idc\",\"idd\",\"ide\",\"idi\",\"idr\",\"ids\",\"idt\",\"idu\",\"ifa\",\"ifb\",\"ife\",\"iff\",\"ifk\",\"ifm\",\"ifu\",\"ify\",\"igb\",\"ige\",\"igg\",\"igl\",\"igm\",\"ign\",\"igo\",\"igs\",\"igw\",\"ihb\",\"ihi\",\"ihp\",\"ihw\",\"iin\",\"iir\",\"ijc\",\"ije\",\"ijj\",\"ijn\",\"ijo\",\"ijs\",\"ike\",\"iki\",\"ikk\",\"ikl\",\"iko\",\"ikp\",\"ikr\",\"iks\",\"ikt\",\"ikv\",\"ikw\",\"ikx\",\"ikz\",\"ila\",\"ilb\",\"ilg\",\"ili\",\"ilk\",\"ill\",\"ilm\",\"ilo\",\"ilp\",\"ils\",\"ilu\",\"ilv\",\"ilw\",\"ima\",\"ime\",\"imi\",\"iml\",\"imn\",\"imo\",\"imr\",\"ims\",\"imy\",\"inb\",\"inc\",\"ine\",\"ing\",\"inh\",\"inj\",\"inl\",\"inm\",\"inn\",\"ino\",\"inp\",\"ins\",\"int\",\"inz\",\"ior\",\"iou\",\"iow\",\"ipi\",\"ipo\",\"iqu\",\"iqw\",\"ira\",\"ire\",\"irh\",\"iri\",\"irk\",\"irn\",\"iro\",\"irr\",\"iru\",\"irx\",\"iry\",\"isa\",\"isc\",\"isd\",\"ise\",\"isg\",\"ish\",\"isi\",\"isk\",\"ism\",\"isn\",\"iso\",\"isr\",\"ist\",\"isu\",\"itb\",\"itc\",\"itd\",\"ite\",\"iti\",\"itk\",\"itl\",\"itm\",\"ito\",\"itr\",\"its\",\"itt\",\"itv\",\"itw\",\"itx\",\"ity\",\"itz\",\"ium\",\"ivb\",\"ivv\",\"iwk\",\"iwm\",\"iwo\",\"iws\",\"ixc\",\"ixl\",\"iya\",\"iyo\",\"iyx\",\"izh\",\"izi\",\"izr\",\"izz\",\"jaa\",\"jab\",\"jac\",\"jad\",\"jae\",\"jaf\",\"jah\",\"jaj\",\"jak\",\"jal\",\"jam\",\"jan\",\"jao\",\"jaq\",\"jar\",\"jas\",\"jat\",\"jau\",\"jax\",\"jay\",\"jaz\",\"jbe\",\"jbi\",\"jbj\",\"jbk\",\"jbn\",\"jbo\",\"jbr\",\"jbt\",\"jbu\",\"jbw\",\"jcs\",\"jct\",\"jda\",\"jdg\",\"jdt\",\"jeb\",\"jee\",\"jeg\",\"jeh\",\"jei\",\"jek\",\"jel\",\"jen\",\"jer\",\"jet\",\"jeu\",\"jgb\",\"jge\",\"jgk\",\"jgo\",\"jhi\",\"jhs\",\"jia\",\"jib\",\"jic\",\"jid\",\"jie\",\"jig\",\"jih\",\"jii\",\"jil\",\"jim\",\"jio\",\"jiq\",\"jit\",\"jiu\",\"jiv\",\"jiy\",\"jje\",\"jjr\",\"jka\",\"jkm\",\"jko\",\"jkp\",\"jkr\",\"jku\",\"jle\",\"jls\",\"jma\",\"jmb\",\"jmc\",\"jmd\",\"jmi\",\"jml\",\"jmn\",\"jmr\",\"jms\",\"jmw\",\"jmx\",\"jna\",\"jnd\",\"jng\",\"jni\",\"jnj\",\"jnl\",\"jns\",\"job\",\"jod\",\"jog\",\"jor\",\"jos\",\"jow\",\"jpa\",\"jpr\",\"jpx\",\"jqr\",\"jra\",\"jrb\",\"jrr\",\"jrt\",\"jru\",\"jsl\",\"jua\",\"jub\",\"juc\",\"jud\",\"juh\",\"jui\",\"juk\",\"jul\",\"jum\",\"jun\",\"juo\",\"jup\",\"jur\",\"jus\",\"jut\",\"juu\",\"juw\",\"juy\",\"jvd\",\"jvn\",\"jwi\",\"jya\",\"jye\",\"jyy\",\"kaa\",\"kab\",\"kac\",\"kad\",\"kae\",\"kaf\",\"kag\",\"kah\",\"kai\",\"kaj\",\"kak\",\"kam\",\"kao\",\"kap\",\"kaq\",\"kar\",\"kav\",\"kaw\",\"kax\",\"kay\",\"kba\",\"kbb\",\"kbc\",\"kbd\",\"kbe\",\"kbf\",\"kbg\",\"kbh\",\"kbi\",\"kbj\",\"kbk\",\"kbl\",\"kbm\",\"kbn\",\"kbo\",\"kbp\",\"kbq\",\"kbr\",\"kbs\",\"kbt\",\"kbu\",\"kbv\",\"kbw\",\"kbx\",\"kby\",\"kbz\",\"kca\",\"kcb\",\"kcc\",\"kcd\",\"kce\",\"kcf\",\"kcg\",\"kch\",\"kci\",\"kcj\",\"kck\",\"kcl\",\"kcm\",\"kcn\",\"kco\",\"kcp\",\"kcq\",\"kcr\",\"kcs\",\"kct\",\"kcu\",\"kcv\",\"kcw\",\"kcx\",\"kcy\",\"kcz\",\"kda\",\"kdc\",\"kdd\",\"kde\",\"kdf\",\"kdg\",\"kdh\",\"kdi\",\"kdj\",\"kdk\",\"kdl\",\"kdm\",\"kdn\",\"kdo\",\"kdp\",\"kdq\",\"kdr\",\"kdt\",\"kdu\",\"kdv\",\"kdw\",\"kdx\",\"kdy\",\"kdz\",\"kea\",\"keb\",\"kec\",\"ked\",\"kee\",\"kef\",\"keg\",\"keh\",\"kei\",\"kej\",\"kek\",\"kel\",\"kem\",\"ken\",\"keo\",\"kep\",\"keq\",\"ker\",\"kes\",\"ket\",\"keu\",\"kev\",\"kew\",\"kex\",\"key\",\"kez\",\"kfa\",\"kfb\",\"kfc\",\"kfd\",\"kfe\",\"kff\",\"kfg\",\"kfh\",\"kfi\",\"kfj\",\"kfk\",\"kfl\",\"kfm\",\"kfn\",\"kfo\",\"kfp\",\"kfq\",\"kfr\",\"kfs\",\"kft\",\"kfu\",\"kfv\",\"kfw\",\"kfx\",\"kfy\",\"kfz\",\"kga\",\"kgb\",\"kgc\",\"kgd\",\"kge\",\"kgf\",\"kgg\",\"kgh\",\"kgi\",\"kgj\",\"kgk\",\"kgl\",\"kgm\",\"kgn\",\"kgo\",\"kgp\",\"kgq\",\"kgr\",\"kgs\",\"kgt\",\"kgu\",\"kgv\",\"kgw\",\"kgx\",\"kgy\",\"kha\",\"khb\",\"khc\",\"khd\",\"khe\",\"khf\",\"khg\",\"khh\",\"khi\",\"khj\",\"khk\",\"khl\",\"khn\",\"kho\",\"khp\",\"khq\",\"khr\",\"khs\",\"kht\",\"khu\",\"khv\",\"khw\",\"khx\",\"khy\",\"khz\",\"kia\",\"kib\",\"kic\",\"kid\",\"kie\",\"kif\",\"kig\",\"kih\",\"kii\",\"kij\",\"kil\",\"kim\",\"kio\",\"kip\",\"kiq\",\"kis\",\"kit\",\"kiu\",\"kiv\",\"kiw\",\"kix\",\"kiy\",\"kiz\",\"kja\",\"kjb\",\"kjc\",\"kjd\",\"kje\",\"kjf\",\"kjg\",\"kjh\",\"kji\",\"kjj\",\"kjk\",\"kjl\",\"kjm\",\"kjn\",\"kjo\",\"kjp\",\"kjq\",\"kjr\",\"kjs\",\"kjt\",\"kju\",\"kjv\",\"kjx\",\"kjy\",\"kjz\",\"kka\",\"kkb\",\"kkc\",\"kkd\",\"kke\",\"kkf\",\"kkg\",\"kkh\",\"kki\",\"kkj\",\"kkk\",\"kkl\",\"kkm\",\"kkn\",\"kko\",\"kkp\",\"kkq\",\"kkr\",\"kks\",\"kkt\",\"kku\",\"kkv\",\"kkw\",\"kkx\",\"kky\",\"kkz\",\"kla\",\"klb\",\"klc\",\"kld\",\"kle\",\"klf\",\"klg\",\"klh\",\"kli\",\"klj\",\"klk\",\"kll\",\"klm\",\"kln\",\"klo\",\"klp\",\"klq\",\"klr\",\"kls\",\"klt\",\"klu\",\"klv\",\"klw\",\"klx\",\"kly\",\"klz\",\"kma\",\"kmb\",\"kmc\",\"kmd\",\"kme\",\"kmf\",\"kmg\",\"kmh\",\"kmi\",\"kmj\",\"kmk\",\"kml\",\"kmm\",\"kmn\",\"kmo\",\"kmp\",\"kmq\",\"kmr\",\"kms\",\"kmt\",\"kmu\",\"kmv\",\"kmw\",\"kmx\",\"kmy\",\"kmz\",\"kna\",\"knb\",\"knc\",\"knd\",\"kne\",\"knf\",\"kng\",\"kni\",\"knj\",\"knk\",\"knl\",\"knm\",\"knn\",\"kno\",\"knp\",\"knq\",\"knr\",\"kns\",\"knt\",\"knu\",\"knv\",\"knw\",\"knx\",\"kny\",\"knz\",\"koa\",\"koc\",\"kod\",\"koe\",\"kof\",\"kog\",\"koh\",\"koi\",\"koj\",\"kok\",\"kol\",\"koo\",\"kop\",\"koq\",\"kos\",\"kot\",\"kou\",\"kov\",\"kow\",\"kox\",\"koy\",\"koz\",\"kpa\",\"kpb\",\"kpc\",\"kpd\",\"kpe\",\"kpf\",\"kpg\",\"kph\",\"kpi\",\"kpj\",\"kpk\",\"kpl\",\"kpm\",\"kpn\",\"kpo\",\"kpp\",\"kpq\",\"kpr\",\"kps\",\"kpt\",\"kpu\",\"kpv\",\"kpw\",\"kpx\",\"kpy\",\"kpz\",\"kqa\",\"kqb\",\"kqc\",\"kqd\",\"kqe\",\"kqf\",\"kqg\",\"kqh\",\"kqi\",\"kqj\",\"kqk\",\"kql\",\"kqm\",\"kqn\",\"kqo\",\"kqp\",\"kqq\",\"kqr\",\"kqs\",\"kqt\",\"kqu\",\"kqv\",\"kqw\",\"kqx\",\"kqy\",\"kqz\",\"kra\",\"krb\",\"krc\",\"krd\",\"kre\",\"krf\",\"krh\",\"kri\",\"krj\",\"krk\",\"krl\",\"krm\",\"krn\",\"kro\",\"krp\",\"krr\",\"krs\",\"krt\",\"kru\",\"krv\",\"krw\",\"krx\",\"kry\",\"krz\",\"ksa\",\"ksb\",\"ksc\",\"ksd\",\"kse\",\"ksf\",\"ksg\",\"ksh\",\"ksi\",\"ksj\",\"ksk\",\"ksl\",\"ksm\",\"ksn\",\"kso\",\"ksp\",\"ksq\",\"ksr\",\"kss\",\"kst\",\"ksu\",\"ksv\",\"ksw\",\"ksx\",\"ksy\",\"ksz\",\"kta\",\"ktb\",\"ktc\",\"ktd\",\"kte\",\"ktf\",\"ktg\",\"kth\",\"kti\",\"ktj\",\"ktk\",\"ktl\",\"ktm\",\"ktn\",\"kto\",\"ktp\",\"ktq\",\"ktr\",\"kts\",\"ktt\",\"ktu\",\"ktv\",\"ktw\",\"ktx\",\"kty\",\"ktz\",\"kub\",\"kuc\",\"kud\",\"kue\",\"kuf\",\"kug\",\"kuh\",\"kui\",\"kuj\",\"kuk\",\"kul\",\"kum\",\"kun\",\"kuo\",\"kup\",\"kuq\",\"kus\",\"kut\",\"kuu\",\"kuv\",\"kuw\",\"kux\",\"kuy\",\"kuz\",\"kva\",\"kvb\",\"kvc\",\"kvd\",\"kve\",\"kvf\",\"kvg\",\"kvh\",\"kvi\",\"kvj\",\"kvk\",\"kvl\",\"kvm\",\"kvn\",\"kvo\",\"kvp\",\"kvq\",\"kvr\",\"kvs\",\"kvt\",\"kvu\",\"kvv\",\"kvw\",\"kvx\",\"kvy\",\"kvz\",\"kwa\",\"kwb\",\"kwc\",\"kwd\",\"kwe\",\"kwf\",\"kwg\",\"kwh\",\"kwi\",\"kwj\",\"kwk\",\"kwl\",\"kwm\",\"kwn\",\"kwo\",\"kwp\",\"kwq\",\"kwr\",\"kws\",\"kwt\",\"kwu\",\"kwv\",\"kww\",\"kwx\",\"kwy\",\"kwz\",\"kxa\",\"kxb\",\"kxc\",\"kxd\",\"kxe\",\"kxf\",\"kxh\",\"kxi\",\"kxj\",\"kxk\",\"kxl\",\"kxm\",\"kxn\",\"kxo\",\"kxp\",\"kxq\",\"kxr\",\"kxs\",\"kxt\",\"kxu\",\"kxv\",\"kxw\",\"kxx\",\"kxy\",\"kxz\",\"kya\",\"kyb\",\"kyc\",\"kyd\",\"kye\",\"kyf\",\"kyg\",\"kyh\",\"kyi\",\"kyj\",\"kyk\",\"kyl\",\"kym\",\"kyn\",\"kyo\",\"kyp\",\"kyq\",\"kyr\",\"kys\",\"kyt\",\"kyu\",\"kyv\",\"kyw\",\"kyx\",\"kyy\",\"kyz\",\"kza\",\"kzb\",\"kzc\",\"kzd\",\"kze\",\"kzf\",\"kzg\",\"kzh\",\"kzi\",\"kzj\",\"kzk\",\"kzl\",\"kzm\",\"kzn\",\"kzo\",\"kzp\",\"kzq\",\"kzr\",\"kzs\",\"kzt\",\"kzu\",\"kzv\",\"kzw\",\"kzx\",\"kzy\",\"kzz\",\"laa\",\"lab\",\"lac\",\"lad\",\"lae\",\"laf\",\"lag\",\"lah\",\"lai\",\"laj\",\"lak\",\"lal\",\"lam\",\"lan\",\"lap\",\"laq\",\"lar\",\"las\",\"lau\",\"law\",\"lax\",\"lay\",\"laz\",\"lba\",\"lbb\",\"lbc\",\"lbe\",\"lbf\",\"lbg\",\"lbi\",\"lbj\",\"lbk\",\"lbl\",\"lbm\",\"lbn\",\"lbo\",\"lbq\",\"lbr\",\"lbs\",\"lbt\",\"lbu\",\"lbv\",\"lbw\",\"lbx\",\"lby\",\"lbz\",\"lcc\",\"lcd\",\"lce\",\"lcf\",\"lch\",\"lcl\",\"lcm\",\"lcp\",\"lcq\",\"lcs\",\"lda\",\"ldb\",\"ldd\",\"ldg\",\"ldh\",\"ldi\",\"ldj\",\"ldk\",\"ldl\",\"ldm\",\"ldn\",\"ldo\",\"ldp\",\"ldq\",\"lea\",\"leb\",\"lec\",\"led\",\"lee\",\"lef\",\"leg\",\"leh\",\"lei\",\"lej\",\"lek\",\"lel\",\"lem\",\"len\",\"leo\",\"lep\",\"leq\",\"ler\",\"les\",\"let\",\"leu\",\"lev\",\"lew\",\"lex\",\"ley\",\"lez\",\"lfa\",\"lfn\",\"lga\",\"lgb\",\"lgg\",\"lgh\",\"lgi\",\"lgk\",\"lgl\",\"lgm\",\"lgn\",\"lgq\",\"lgr\",\"lgt\",\"lgu\",\"lgz\",\"lha\",\"lhh\",\"lhi\",\"lhl\",\"lhm\",\"lhn\",\"lhp\",\"lhs\",\"lht\",\"lhu\",\"lia\",\"lib\",\"lic\",\"lid\",\"lie\",\"lif\",\"lig\",\"lih\",\"lii\",\"lij\",\"lik\",\"lil\",\"lio\",\"lip\",\"liq\",\"lir\",\"lis\",\"liu\",\"liv\",\"liw\",\"lix\",\"liy\",\"liz\",\"lja\",\"lje\",\"lji\",\"ljl\",\"ljp\",\"ljw\",\"ljx\",\"lka\",\"lkb\",\"lkc\",\"lkd\",\"lke\",\"lkh\",\"lki\",\"lkj\",\"lkl\",\"lkm\",\"lkn\",\"lko\",\"lkr\",\"lks\",\"lkt\",\"lku\",\"lky\",\"lla\",\"llb\",\"llc\",\"lld\",\"lle\",\"llf\",\"llg\",\"llh\",\"lli\",\"llj\",\"llk\",\"lll\",\"llm\",\"lln\",\"llo\",\"llp\",\"llq\",\"lls\",\"llu\",\"llx\",\"lma\",\"lmb\",\"lmc\",\"lmd\",\"lme\",\"lmf\",\"lmg\",\"lmh\",\"lmi\",\"lmj\",\"lmk\",\"lml\",\"lmm\",\"lmn\",\"lmo\",\"lmp\",\"lmq\",\"lmr\",\"lmu\",\"lmv\",\"lmw\",\"lmx\",\"lmy\",\"lmz\",\"lna\",\"lnb\",\"lnd\",\"lng\",\"lnh\",\"lni\",\"lnj\",\"lnl\",\"lnm\",\"lnn\",\"lno\",\"lns\",\"lnu\",\"lnw\",\"lnz\",\"loa\",\"lob\",\"loc\",\"loe\",\"lof\",\"log\",\"loh\",\"loi\",\"loj\",\"lok\",\"lol\",\"lom\",\"lon\",\"loo\",\"lop\",\"loq\",\"lor\",\"los\",\"lot\",\"lou\",\"lov\",\"low\",\"lox\",\"loy\",\"loz\",\"lpa\",\"lpe\",\"lpn\",\"lpo\",\"lpx\",\"lra\",\"lrc\",\"lre\",\"lrg\",\"lri\",\"lrk\",\"lrl\",\"lrm\",\"lrn\",\"lro\",\"lrr\",\"lrt\",\"lrv\",\"lrz\",\"lsa\",\"lsd\",\"lse\",\"lsg\",\"lsh\",\"lsi\",\"lsl\",\"lsm\",\"lso\",\"lsp\",\"lsr\",\"lss\",\"lst\",\"lsy\",\"ltc\",\"ltg\",\"lti\",\"ltn\",\"lto\",\"lts\",\"ltu\",\"lua\",\"luc\",\"lud\",\"lue\",\"luf\",\"lui\",\"luj\",\"luk\",\"lul\",\"lum\",\"lun\",\"luo\",\"lup\",\"luq\",\"lur\",\"lus\",\"lut\",\"luu\",\"luv\",\"luw\",\"luy\",\"luz\",\"lva\",\"lvk\",\"lvs\",\"lvu\",\"lwa\",\"lwe\",\"lwg\",\"lwh\",\"lwl\",\"lwm\",\"lwo\",\"lwt\",\"lwu\",\"lww\",\"lya\",\"lyg\",\"lyn\",\"lzh\",\"lzl\",\"lzn\",\"lzz\",\"maa\",\"mab\",\"mad\",\"mae\",\"maf\",\"mag\",\"mai\",\"maj\",\"mak\",\"mam\",\"man\",\"map\",\"maq\",\"mas\",\"mat\",\"mau\",\"mav\",\"maw\",\"max\",\"maz\",\"mba\",\"mbb\",\"mbc\",\"mbd\",\"mbe\",\"mbf\",\"mbh\",\"mbi\",\"mbj\",\"mbk\",\"mbl\",\"mbm\",\"mbn\",\"mbo\",\"mbp\",\"mbq\",\"mbr\",\"mbs\",\"mbt\",\"mbu\",\"mbv\",\"mbw\",\"mbx\",\"mby\",\"mbz\",\"mca\",\"mcb\",\"mcc\",\"mcd\",\"mce\",\"mcf\",\"mcg\",\"mch\",\"mci\",\"mcj\",\"mck\",\"mcl\",\"mcm\",\"mcn\",\"mco\",\"mcp\",\"mcq\",\"mcr\",\"mcs\",\"mct\",\"mcu\",\"mcv\",\"mcw\",\"mcx\",\"mcy\",\"mcz\",\"mda\",\"mdb\",\"mdc\",\"mdd\",\"mde\",\"mdf\",\"mdg\",\"mdh\",\"mdi\",\"mdj\",\"mdk\",\"mdl\",\"mdm\",\"mdn\",\"mdp\",\"mdq\",\"mdr\",\"mds\",\"mdt\",\"mdu\",\"mdv\",\"mdw\",\"mdx\",\"mdy\",\"mdz\",\"mea\",\"meb\",\"mec\",\"med\",\"mee\",\"mef\",\"meg\",\"meh\",\"mei\",\"mej\",\"mek\",\"mel\",\"mem\",\"men\",\"meo\",\"mep\",\"meq\",\"mer\",\"mes\",\"met\",\"meu\",\"mev\",\"mew\",\"mey\",\"mez\",\"mfa\",\"mfb\",\"mfc\",\"mfd\",\"mfe\",\"mff\",\"mfg\",\"mfh\",\"mfi\",\"mfj\",\"mfk\",\"mfl\",\"mfm\",\"mfn\",\"mfo\",\"mfp\",\"mfq\",\"mfr\",\"mfs\",\"mft\",\"mfu\",\"mfv\",\"mfw\",\"mfx\",\"mfy\",\"mfz\",\"mga\",\"mgb\",\"mgc\",\"mgd\",\"mge\",\"mgf\",\"mgg\",\"mgh\",\"mgi\",\"mgj\",\"mgk\",\"mgl\",\"mgm\",\"mgn\",\"mgo\",\"mgp\",\"mgq\",\"mgr\",\"mgs\",\"mgt\",\"mgu\",\"mgv\",\"mgw\",\"mgx\",\"mgy\",\"mgz\",\"mha\",\"mhb\",\"mhc\",\"mhd\",\"mhe\",\"mhf\",\"mhg\",\"mhh\",\"mhi\",\"mhj\",\"mhk\",\"mhl\",\"mhm\",\"mhn\",\"mho\",\"mhp\",\"mhq\",\"mhr\",\"mhs\",\"mht\",\"mhu\",\"mhw\",\"mhx\",\"mhy\",\"mhz\",\"mia\",\"mib\",\"mic\",\"mid\",\"mie\",\"mif\",\"mig\",\"mih\",\"mii\",\"mij\",\"mik\",\"mil\",\"mim\",\"min\",\"mio\",\"mip\",\"miq\",\"mir\",\"mis\",\"mit\",\"miu\",\"miw\",\"mix\",\"miy\",\"miz\",\"mja\",\"mjb\",\"mjc\",\"mjd\",\"mje\",\"mjg\",\"mjh\",\"mji\",\"mjj\",\"mjk\",\"mjl\",\"mjm\",\"mjn\",\"mjo\",\"mjp\",\"mjq\",\"mjr\",\"mjs\",\"mjt\",\"mju\",\"mjv\",\"mjw\",\"mjx\",\"mjy\",\"mjz\",\"mka\",\"mkb\",\"mkc\",\"mke\",\"mkf\",\"mkg\",\"mkh\",\"mki\",\"mkj\",\"mkk\",\"mkl\",\"mkm\",\"mkn\",\"mko\",\"mkp\",\"mkq\",\"mkr\",\"mks\",\"mkt\",\"mku\",\"mkv\",\"mkw\",\"mkx\",\"mky\",\"mkz\",\"mla\",\"mlb\",\"mlc\",\"mld\",\"mle\",\"mlf\",\"mlh\",\"mli\",\"mlj\",\"mlk\",\"mll\",\"mlm\",\"mln\",\"mlo\",\"mlp\",\"mlq\",\"mlr\",\"mls\",\"mlu\",\"mlv\",\"mlw\",\"mlx\",\"mlz\",\"mma\",\"mmb\",\"mmc\",\"mmd\",\"mme\",\"mmf\",\"mmg\",\"mmh\",\"mmi\",\"mmj\",\"mmk\",\"mml\",\"mmm\",\"mmn\",\"mmo\",\"mmp\",\"mmq\",\"mmr\",\"mmt\",\"mmu\",\"mmv\",\"mmw\",\"mmx\",\"mmy\",\"mmz\",\"mna\",\"mnb\",\"mnc\",\"mnd\",\"mne\",\"mnf\",\"mng\",\"mnh\",\"mni\",\"mnj\",\"mnk\",\"mnl\",\"mnm\",\"mnn\",\"mno\",\"mnp\",\"mnq\",\"mnr\",\"mns\",\"mnt\",\"mnu\",\"mnv\",\"mnw\",\"mnx\",\"mny\",\"mnz\",\"moa\",\"moc\",\"mod\",\"moe\",\"mof\",\"mog\",\"moh\",\"moi\",\"moj\",\"mok\",\"mom\",\"moo\",\"mop\",\"moq\",\"mor\",\"mos\",\"mot\",\"mou\",\"mov\",\"mow\",\"mox\",\"moy\",\"moz\",\"mpa\",\"mpb\",\"mpc\",\"mpd\",\"mpe\",\"mpg\",\"mph\",\"mpi\",\"mpj\",\"mpk\",\"mpl\",\"mpm\",\"mpn\",\"mpo\",\"mpp\",\"mpq\",\"mpr\",\"mps\",\"mpt\",\"mpu\",\"mpv\",\"mpw\",\"mpx\",\"mpy\",\"mpz\",\"mqa\",\"mqb\",\"mqc\",\"mqe\",\"mqf\",\"mqg\",\"mqh\",\"mqi\",\"mqj\",\"mqk\",\"mql\",\"mqm\",\"mqn\",\"mqo\",\"mqp\",\"mqq\",\"mqr\",\"mqs\",\"mqt\",\"mqu\",\"mqv\",\"mqw\",\"mqx\",\"mqy\",\"mqz\",\"mra\",\"mrb\",\"mrc\",\"mrd\",\"mre\",\"mrf\",\"mrg\",\"mrh\",\"mrj\",\"mrk\",\"mrl\",\"mrm\",\"mrn\",\"mro\",\"mrp\",\"mrq\",\"mrr\",\"mrs\",\"mrt\",\"mru\",\"mrv\",\"mrw\",\"mrx\",\"mry\",\"mrz\",\"msb\",\"msc\",\"msd\",\"mse\",\"msf\",\"msg\",\"msh\",\"msi\",\"msj\",\"msk\",\"msl\",\"msm\",\"msn\",\"mso\",\"msp\",\"msq\",\"msr\",\"mss\",\"mst\",\"msu\",\"msv\",\"msw\",\"msx\",\"msy\",\"msz\",\"mta\",\"mtb\",\"mtc\",\"mtd\",\"mte\",\"mtf\",\"mtg\",\"mth\",\"mti\",\"mtj\",\"mtk\",\"mtl\",\"mtm\",\"mtn\",\"mto\",\"mtp\",\"mtq\",\"mtr\",\"mts\",\"mtt\",\"mtu\",\"mtv\",\"mtw\",\"mtx\",\"mty\",\"mua\",\"mub\",\"muc\",\"mud\",\"mue\",\"mug\",\"muh\",\"mui\",\"muj\",\"muk\",\"mul\",\"mum\",\"mun\",\"muo\",\"mup\",\"muq\",\"mur\",\"mus\",\"mut\",\"muu\",\"muv\",\"mux\",\"muy\",\"muz\",\"mva\",\"mvb\",\"mvd\",\"mve\",\"mvf\",\"mvg\",\"mvh\",\"mvi\",\"mvk\",\"mvl\",\"mvm\",\"mvn\",\"mvo\",\"mvp\",\"mvq\",\"mvr\",\"mvs\",\"mvt\",\"mvu\",\"mvv\",\"mvw\",\"mvx\",\"mvy\",\"mvz\",\"mwa\",\"mwb\",\"mwc\",\"mwd\",\"mwe\",\"mwf\",\"mwg\",\"mwh\",\"mwi\",\"mwj\",\"mwk\",\"mwl\",\"mwm\",\"mwn\",\"mwo\",\"mwp\",\"mwq\",\"mwr\",\"mws\",\"mwt\",\"mwu\",\"mwv\",\"mww\",\"mwx\",\"mwy\",\"mwz\",\"mxa\",\"mxb\",\"mxc\",\"mxd\",\"mxe\",\"mxf\",\"mxg\",\"mxh\",\"mxi\",\"mxj\",\"mxk\",\"mxl\",\"mxm\",\"mxn\",\"mxo\",\"mxp\",\"mxq\",\"mxr\",\"mxs\",\"mxt\",\"mxu\",\"mxv\",\"mxw\",\"mxx\",\"mxy\",\"mxz\",\"myb\",\"myc\",\"myd\",\"mye\",\"myf\",\"myg\",\"myh\",\"myi\",\"myj\",\"myk\",\"myl\",\"mym\",\"myn\",\"myo\",\"myp\",\"myq\",\"myr\",\"mys\",\"myt\",\"myu\",\"myv\",\"myw\",\"myx\",\"myy\",\"myz\",\"mza\",\"mzb\",\"mzc\",\"mzd\",\"mze\",\"mzg\",\"mzh\",\"mzi\",\"mzj\",\"mzk\",\"mzl\",\"mzm\",\"mzn\",\"mzo\",\"mzp\",\"mzq\",\"mzr\",\"mzs\",\"mzt\",\"mzu\",\"mzv\",\"mzw\",\"mzx\",\"mzy\",\"mzz\",\"naa\",\"nab\",\"nac\",\"nad\",\"nae\",\"naf\",\"nag\",\"nah\",\"nai\",\"naj\",\"nak\",\"nal\",\"nam\",\"nan\",\"nao\",\"nap\",\"naq\",\"nar\",\"nas\",\"nat\",\"naw\",\"nax\",\"nay\",\"naz\",\"nba\",\"nbb\",\"nbc\",\"nbd\",\"nbe\",\"nbf\",\"nbg\",\"nbh\",\"nbi\",\"nbj\",\"nbk\",\"nbm\",\"nbn\",\"nbo\",\"nbp\",\"nbq\",\"nbr\",\"nbs\",\"nbt\",\"nbu\",\"nbv\",\"nbw\",\"nbx\",\"nby\",\"nca\",\"ncb\",\"ncc\",\"ncd\",\"nce\",\"ncf\",\"ncg\",\"nch\",\"nci\",\"ncj\",\"nck\",\"ncl\",\"ncm\",\"ncn\",\"nco\",\"ncp\",\"ncr\",\"ncs\",\"nct\",\"ncu\",\"ncx\",\"ncz\",\"nda\",\"ndb\",\"ndc\",\"ndd\",\"ndf\",\"ndg\",\"ndh\",\"ndi\",\"ndj\",\"ndk\",\"ndl\",\"ndm\",\"ndn\",\"ndp\",\"ndq\",\"ndr\",\"nds\",\"ndt\",\"ndu\",\"ndv\",\"ndw\",\"ndx\",\"ndy\",\"ndz\",\"nea\",\"neb\",\"nec\",\"ned\",\"nee\",\"nef\",\"neg\",\"neh\",\"nei\",\"nej\",\"nek\",\"nem\",\"nen\",\"neo\",\"neq\",\"ner\",\"nes\",\"net\",\"neu\",\"nev\",\"new\",\"nex\",\"ney\",\"nez\",\"nfa\",\"nfd\",\"nfl\",\"nfr\",\"nfu\",\"nga\",\"ngb\",\"ngc\",\"ngd\",\"nge\",\"ngf\",\"ngg\",\"ngh\",\"ngi\",\"ngj\",\"ngk\",\"ngl\",\"ngm\",\"ngn\",\"ngo\",\"ngp\",\"ngq\",\"ngr\",\"ngs\",\"ngt\",\"ngu\",\"ngv\",\"ngw\",\"ngx\",\"ngy\",\"ngz\",\"nha\",\"nhb\",\"nhc\",\"nhd\",\"nhe\",\"nhf\",\"nhg\",\"nhh\",\"nhi\",\"nhk\",\"nhm\",\"nhn\",\"nho\",\"nhp\",\"nhq\",\"nhr\",\"nht\",\"nhu\",\"nhv\",\"nhw\",\"nhx\",\"nhy\",\"nhz\",\"nia\",\"nib\",\"nic\",\"nid\",\"nie\",\"nif\",\"nig\",\"nih\",\"nii\",\"nij\",\"nik\",\"nil\",\"nim\",\"nin\",\"nio\",\"niq\",\"nir\",\"nis\",\"nit\",\"niu\",\"niv\",\"niw\",\"nix\",\"niy\",\"niz\",\"nja\",\"njb\",\"njd\",\"njh\",\"nji\",\"njj\",\"njl\",\"njm\",\"njn\",\"njo\",\"njr\",\"njs\",\"njt\",\"nju\",\"njx\",\"njy\",\"njz\",\"nka\",\"nkb\",\"nkc\",\"nkd\",\"nke\",\"nkf\",\"nkg\",\"nkh\",\"nki\",\"nkj\",\"nkk\",\"nkm\",\"nkn\",\"nko\",\"nkp\",\"nkq\",\"nkr\",\"nks\",\"nkt\",\"nku\",\"nkv\",\"nkw\",\"nkx\",\"nkz\",\"nla\",\"nlc\",\"nle\",\"nlg\",\"nli\",\"nlj\",\"nlk\",\"nll\",\"nln\",\"nlo\",\"nlq\",\"nlr\",\"nlu\",\"nlv\",\"nlw\",\"nlx\",\"nly\",\"nlz\",\"nma\",\"nmb\",\"nmc\",\"nmd\",\"nme\",\"nmf\",\"nmg\",\"nmh\",\"nmi\",\"nmj\",\"nmk\",\"nml\",\"nmm\",\"nmn\",\"nmo\",\"nmp\",\"nmq\",\"nmr\",\"nms\",\"nmt\",\"nmu\",\"nmv\",\"nmw\",\"nmx\",\"nmy\",\"nmz\",\"nna\",\"nnb\",\"nnc\",\"nnd\",\"nne\",\"nnf\",\"nng\",\"nnh\",\"nni\",\"nnj\",\"nnk\",\"nnl\",\"nnm\",\"nnn\",\"nnp\",\"nnq\",\"nnr\",\"nns\",\"nnt\",\"nnu\",\"nnv\",\"nnw\",\"nnx\",\"nny\",\"nnz\",\"noa\",\"noc\",\"nod\",\"noe\",\"nof\",\"nog\",\"noh\",\"noi\",\"noj\",\"nok\",\"nol\",\"nom\",\"non\",\"noo\",\"nop\",\"noq\",\"nos\",\"not\",\"nou\",\"nov\",\"now\",\"noy\",\"noz\",\"npa\",\"npb\",\"npg\",\"nph\",\"npi\",\"npl\",\"npn\",\"npo\",\"nps\",\"npu\",\"npy\",\"nqg\",\"nqk\",\"nqm\",\"nqn\",\"nqo\",\"nqq\",\"nqy\",\"nra\",\"nrb\",\"nrc\",\"nre\",\"nrf\",\"nrg\",\"nri\",\"nrk\",\"nrl\",\"nrm\",\"nrn\",\"nrp\",\"nrr\",\"nrt\",\"nru\",\"nrx\",\"nrz\",\"nsa\",\"nsc\",\"nsd\",\"nse\",\"nsf\",\"nsg\",\"nsh\",\"nsi\",\"nsk\",\"nsl\",\"nsm\",\"nsn\",\"nso\",\"nsp\",\"nsq\",\"nsr\",\"nss\",\"nst\",\"nsu\",\"nsv\",\"nsw\",\"nsx\",\"nsy\",\"nsz\",\"ntd\",\"nte\",\"ntg\",\"nti\",\"ntj\",\"ntk\",\"ntm\",\"nto\",\"ntp\",\"ntr\",\"nts\",\"ntu\",\"ntw\",\"ntx\",\"nty\",\"ntz\",\"nua\",\"nub\",\"nuc\",\"nud\",\"nue\",\"nuf\",\"nug\",\"nuh\",\"nui\",\"nuj\",\"nuk\",\"nul\",\"num\",\"nun\",\"nuo\",\"nup\",\"nuq\",\"nur\",\"nus\",\"nut\",\"nuu\",\"nuv\",\"nuw\",\"nux\",\"nuy\",\"nuz\",\"nvh\",\"nvm\",\"nvo\",\"nwa\",\"nwb\",\"nwc\",\"nwe\",\"nwg\",\"nwi\",\"nwm\",\"nwo\",\"nwr\",\"nwx\",\"nwy\",\"nxa\",\"nxd\",\"nxe\",\"nxg\",\"nxi\",\"nxk\",\"nxl\",\"nxm\",\"nxn\",\"nxo\",\"nxq\",\"nxr\",\"nxu\",\"nxx\",\"nyb\",\"nyc\",\"nyd\",\"nye\",\"nyf\",\"nyg\",\"nyh\",\"nyi\",\"nyj\",\"nyk\",\"nyl\",\"nym\",\"nyn\",\"nyo\",\"nyp\",\"nyq\",\"nyr\",\"nys\",\"nyt\",\"nyu\",\"nyv\",\"nyw\",\"nyx\",\"nyy\",\"nza\",\"nzb\",\"nzi\",\"nzk\",\"nzm\",\"nzs\",\"nzu\",\"nzy\",\"nzz\",\"oaa\",\"oac\",\"oar\",\"oav\",\"obi\",\"obk\",\"obl\",\"obm\",\"obo\",\"obr\",\"obt\",\"obu\",\"oca\",\"och\",\"oco\",\"ocu\",\"oda\",\"odk\",\"odt\",\"odu\",\"ofo\",\"ofs\",\"ofu\",\"ogb\",\"ogc\",\"oge\",\"ogg\",\"ogo\",\"ogu\",\"oht\",\"ohu\",\"oia\",\"oin\",\"ojb\",\"ojc\",\"ojg\",\"ojp\",\"ojs\",\"ojv\",\"ojw\",\"oka\",\"okb\",\"okd\",\"oke\",\"okg\",\"okh\",\"oki\",\"okj\",\"okk\",\"okl\",\"okm\",\"okn\",\"oko\",\"okr\",\"oks\",\"oku\",\"okv\",\"okx\",\"ola\",\"old\",\"ole\",\"olk\",\"olm\",\"olo\",\"olr\",\"olt\",\"olu\",\"oma\",\"omb\",\"omc\",\"ome\",\"omg\",\"omi\",\"omk\",\"oml\",\"omn\",\"omo\",\"omp\",\"omq\",\"omr\",\"omt\",\"omu\",\"omv\",\"omw\",\"omx\",\"ona\",\"onb\",\"one\",\"ong\",\"oni\",\"onj\",\"onk\",\"onn\",\"ono\",\"onp\",\"onr\",\"ons\",\"ont\",\"onu\",\"onw\",\"onx\",\"ood\",\"oog\",\"oon\",\"oor\",\"oos\",\"opa\",\"opk\",\"opm\",\"opo\",\"opt\",\"opy\",\"ora\",\"orc\",\"ore\",\"org\",\"orh\",\"orn\",\"oro\",\"orr\",\"ors\",\"ort\",\"oru\",\"orv\",\"orw\",\"orx\",\"ory\",\"orz\",\"osa\",\"osc\",\"osi\",\"oso\",\"osp\",\"ost\",\"osu\",\"osx\",\"ota\",\"otb\",\"otd\",\"ote\",\"oti\",\"otk\",\"otl\",\"otm\",\"otn\",\"oto\",\"otq\",\"otr\",\"ots\",\"ott\",\"otu\",\"otw\",\"otx\",\"oty\",\"otz\",\"oua\",\"oub\",\"oue\",\"oui\",\"oum\",\"oun\",\"ovd\",\"owi\",\"owl\",\"oyb\",\"oyd\",\"oym\",\"oyy\",\"ozm\",\"paa\",\"pab\",\"pac\",\"pad\",\"pae\",\"paf\",\"pag\",\"pah\",\"pai\",\"pak\",\"pal\",\"pam\",\"pao\",\"pap\",\"paq\",\"par\",\"pas\",\"pat\",\"pau\",\"pav\",\"paw\",\"pax\",\"pay\",\"paz\",\"pbb\",\"pbc\",\"pbe\",\"pbf\",\"pbg\",\"pbh\",\"pbi\",\"pbl\",\"pbn\",\"pbo\",\"pbp\",\"pbr\",\"pbs\",\"pbt\",\"pbu\",\"pbv\",\"pby\",\"pbz\",\"pca\",\"pcb\",\"pcc\",\"pcd\",\"pce\",\"pcf\",\"pcg\",\"pch\",\"pci\",\"pcj\",\"pck\",\"pcl\",\"pcm\",\"pcn\",\"pcp\",\"pcr\",\"pcw\",\"pda\",\"pdc\",\"pdi\",\"pdn\",\"pdo\",\"pdt\",\"pdu\",\"pea\",\"peb\",\"ped\",\"pee\",\"pef\",\"peg\",\"peh\",\"pei\",\"pej\",\"pek\",\"pel\",\"pem\",\"peo\",\"pep\",\"peq\",\"pes\",\"pev\",\"pex\",\"pey\",\"pez\",\"pfa\",\"pfe\",\"pfl\",\"pga\",\"pgd\",\"pgg\",\"pgi\",\"pgk\",\"pgl\",\"pgn\",\"pgs\",\"pgu\",\"pgy\",\"pgz\",\"pha\",\"phd\",\"phg\",\"phh\",\"phi\",\"phk\",\"phl\",\"phm\",\"phn\",\"pho\",\"phq\",\"phr\",\"pht\",\"phu\",\"phv\",\"phw\",\"pia\",\"pib\",\"pic\",\"pid\",\"pie\",\"pif\",\"pig\",\"pih\",\"pii\",\"pij\",\"pil\",\"pim\",\"pin\",\"pio\",\"pip\",\"pir\",\"pis\",\"pit\",\"piu\",\"piv\",\"piw\",\"pix\",\"piy\",\"piz\",\"pjt\",\"pka\",\"pkb\",\"pkc\",\"pkg\",\"pkh\",\"pkn\",\"pko\",\"pkp\",\"pkr\",\"pks\",\"pkt\",\"pku\",\"pla\",\"plb\",\"plc\",\"pld\",\"ple\",\"plf\",\"plg\",\"plh\",\"plj\",\"plk\",\"pll\",\"pln\",\"plo\",\"plp\",\"plq\",\"plr\",\"pls\",\"plt\",\"plu\",\"plv\",\"plw\",\"ply\",\"plz\",\"pma\",\"pmb\",\"pmc\",\"pmd\",\"pme\",\"pmf\",\"pmh\",\"pmi\",\"pmj\",\"pmk\",\"pml\",\"pmm\",\"pmn\",\"pmo\",\"pmq\",\"pmr\",\"pms\",\"pmt\",\"pmu\",\"pmw\",\"pmx\",\"pmy\",\"pmz\",\"pna\",\"pnb\",\"pnc\",\"pne\",\"png\",\"pnh\",\"pni\",\"pnj\",\"pnk\",\"pnl\",\"pnm\",\"pnn\",\"pno\",\"pnp\",\"pnq\",\"pnr\",\"pns\",\"pnt\",\"pnu\",\"pnv\",\"pnw\",\"pnx\",\"pny\",\"pnz\",\"poc\",\"pod\",\"poe\",\"pof\",\"pog\",\"poh\",\"poi\",\"pok\",\"pom\",\"pon\",\"poo\",\"pop\",\"poq\",\"pos\",\"pot\",\"pov\",\"pow\",\"pox\",\"poy\",\"poz\",\"ppa\",\"ppe\",\"ppi\",\"ppk\",\"ppl\",\"ppm\",\"ppn\",\"ppo\",\"ppp\",\"ppq\",\"ppr\",\"pps\",\"ppt\",\"ppu\",\"pqa\",\"pqe\",\"pqm\",\"pqw\",\"pra\",\"prb\",\"prc\",\"prd\",\"pre\",\"prf\",\"prg\",\"prh\",\"pri\",\"prk\",\"prl\",\"prm\",\"prn\",\"pro\",\"prp\",\"prq\",\"prr\",\"prs\",\"prt\",\"pru\",\"prw\",\"prx\",\"pry\",\"prz\",\"psa\",\"psc\",\"psd\",\"pse\",\"psg\",\"psh\",\"psi\",\"psl\",\"psm\",\"psn\",\"pso\",\"psp\",\"psq\",\"psr\",\"pss\",\"pst\",\"psu\",\"psw\",\"psy\",\"pta\",\"pth\",\"pti\",\"ptn\",\"pto\",\"ptp\",\"ptq\",\"ptr\",\"ptt\",\"ptu\",\"ptv\",\"ptw\",\"pty\",\"pua\",\"pub\",\"puc\",\"pud\",\"pue\",\"puf\",\"pug\",\"pui\",\"puj\",\"puk\",\"pum\",\"puo\",\"pup\",\"puq\",\"pur\",\"put\",\"puu\",\"puw\",\"pux\",\"puy\",\"puz\",\"pwa\",\"pwb\",\"pwg\",\"pwi\",\"pwm\",\"pwn\",\"pwo\",\"pwr\",\"pww\",\"pxm\",\"pye\",\"pym\",\"pyn\",\"pys\",\"pyu\",\"pyx\",\"pyy\",\"pzn\",\"qaa..qtz\",\"qua\",\"qub\",\"quc\",\"qud\",\"quf\",\"qug\",\"quh\",\"qui\",\"quk\",\"qul\",\"qum\",\"qun\",\"qup\",\"quq\",\"qur\",\"qus\",\"quv\",\"quw\",\"qux\",\"quy\",\"quz\",\"qva\",\"qvc\",\"qve\",\"qvh\",\"qvi\",\"qvj\",\"qvl\",\"qvm\",\"qvn\",\"qvo\",\"qvp\",\"qvs\",\"qvw\",\"qvy\",\"qvz\",\"qwa\",\"qwc\",\"qwe\",\"qwh\",\"qwm\",\"qws\",\"qwt\",\"qxa\",\"qxc\",\"qxh\",\"qxl\",\"qxn\",\"qxo\",\"qxp\",\"qxq\",\"qxr\",\"qxs\",\"qxt\",\"qxu\",\"qxw\",\"qya\",\"qyp\",\"raa\",\"rab\",\"rac\",\"rad\",\"raf\",\"rag\",\"rah\",\"rai\",\"raj\",\"rak\",\"ral\",\"ram\",\"ran\",\"rao\",\"rap\",\"raq\",\"rar\",\"ras\",\"rat\",\"rau\",\"rav\",\"raw\",\"rax\",\"ray\",\"raz\",\"rbb\",\"rbk\",\"rbl\",\"rbp\",\"rcf\",\"rdb\",\"rea\",\"reb\",\"ree\",\"reg\",\"rei\",\"rej\",\"rel\",\"rem\",\"ren\",\"rer\",\"res\",\"ret\",\"rey\",\"rga\",\"rge\",\"rgk\",\"rgn\",\"rgr\",\"rgs\",\"rgu\",\"rhg\",\"rhp\",\"ria\",\"rie\",\"rif\",\"ril\",\"rim\",\"rin\",\"rir\",\"rit\",\"riu\",\"rjg\",\"rji\",\"rjs\",\"rka\",\"rkb\",\"rkh\",\"rki\",\"rkm\",\"rkt\",\"rkw\",\"rma\",\"rmb\",\"rmc\",\"rmd\",\"rme\",\"rmf\",\"rmg\",\"rmh\",\"rmi\",\"rmk\",\"rml\",\"rmm\",\"rmn\",\"rmo\",\"rmp\",\"rmq\",\"rmr\",\"rms\",\"rmt\",\"rmu\",\"rmv\",\"rmw\",\"rmx\",\"rmy\",\"rmz\",\"rna\",\"rnd\",\"rng\",\"rnl\",\"rnn\",\"rnp\",\"rnr\",\"rnw\",\"roa\",\"rob\",\"roc\",\"rod\",\"roe\",\"rof\",\"rog\",\"rol\",\"rom\",\"roo\",\"rop\",\"ror\",\"rou\",\"row\",\"rpn\",\"rpt\",\"rri\",\"rro\",\"rrt\",\"rsb\",\"rsi\",\"rsl\",\"rsm\",\"rtc\",\"rth\",\"rtm\",\"rts\",\"rtw\",\"rub\",\"ruc\",\"rue\",\"ruf\",\"rug\",\"ruh\",\"rui\",\"ruk\",\"ruo\",\"rup\",\"ruq\",\"rut\",\"ruu\",\"ruy\",\"ruz\",\"rwa\",\"rwk\",\"rwm\",\"rwo\",\"rwr\",\"rxd\",\"rxw\",\"ryn\",\"rys\",\"ryu\",\"rzh\",\"saa\",\"sab\",\"sac\",\"sad\",\"sae\",\"saf\",\"sah\",\"sai\",\"saj\",\"sak\",\"sal\",\"sam\",\"sao\",\"sap\",\"saq\",\"sar\",\"sas\",\"sat\",\"sau\",\"sav\",\"saw\",\"sax\",\"say\",\"saz\",\"sba\",\"sbb\",\"sbc\",\"sbd\",\"sbe\",\"sbf\",\"sbg\",\"sbh\",\"sbi\",\"sbj\",\"sbk\",\"sbl\",\"sbm\",\"sbn\",\"sbo\",\"sbp\",\"sbq\",\"sbr\",\"sbs\",\"sbt\",\"sbu\",\"sbv\",\"sbw\",\"sbx\",\"sby\",\"sbz\",\"sca\",\"scb\",\"sce\",\"scf\",\"scg\",\"sch\",\"sci\",\"sck\",\"scl\",\"scn\",\"sco\",\"scp\",\"scq\",\"scs\",\"scu\",\"scv\",\"scw\",\"scx\",\"sda\",\"sdb\",\"sdc\",\"sde\",\"sdf\",\"sdg\",\"sdh\",\"sdj\",\"sdk\",\"sdl\",\"sdm\",\"sdn\",\"sdo\",\"sdp\",\"sdr\",\"sds\",\"sdt\",\"sdu\",\"sdv\",\"sdx\",\"sdz\",\"sea\",\"seb\",\"sec\",\"sed\",\"see\",\"sef\",\"seg\",\"seh\",\"sei\",\"sej\",\"sek\",\"sel\",\"sem\",\"sen\",\"seo\",\"sep\",\"seq\",\"ser\",\"ses\",\"set\",\"seu\",\"sev\",\"sew\",\"sey\",\"sez\",\"sfb\",\"sfe\",\"sfm\",\"sfs\",\"sfw\",\"sga\",\"sgb\",\"sgc\",\"sgd\",\"sge\",\"sgg\",\"sgh\",\"sgi\",\"sgj\",\"sgk\",\"sgl\",\"sgm\",\"sgn\",\"sgo\",\"sgp\",\"sgr\",\"sgs\",\"sgt\",\"sgu\",\"sgw\",\"sgx\",\"sgy\",\"sgz\",\"sha\",\"shb\",\"shc\",\"shd\",\"she\",\"shg\",\"shh\",\"shi\",\"shj\",\"shk\",\"shl\",\"shm\",\"shn\",\"sho\",\"shp\",\"shq\",\"shr\",\"shs\",\"sht\",\"shu\",\"shv\",\"shw\",\"shx\",\"shy\",\"shz\",\"sia\",\"sib\",\"sid\",\"sie\",\"sif\",\"sig\",\"sih\",\"sii\",\"sij\",\"sik\",\"sil\",\"sim\",\"sio\",\"sip\",\"siq\",\"sir\",\"sis\",\"sit\",\"siu\",\"siv\",\"siw\",\"six\",\"siy\",\"siz\",\"sja\",\"sjb\",\"sjd\",\"sje\",\"sjg\",\"sjk\",\"sjl\",\"sjm\",\"sjn\",\"sjo\",\"sjp\",\"sjr\",\"sjs\",\"sjt\",\"sju\",\"sjw\",\"ska\",\"skb\",\"skc\",\"skd\",\"ske\",\"skf\",\"skg\",\"skh\",\"ski\",\"skj\",\"skk\",\"skm\",\"skn\",\"sko\",\"skp\",\"skq\",\"skr\",\"sks\",\"skt\",\"sku\",\"skv\",\"skw\",\"skx\",\"sky\",\"skz\",\"sla\",\"slc\",\"sld\",\"sle\",\"slf\",\"slg\",\"slh\",\"sli\",\"slj\",\"sll\",\"slm\",\"sln\",\"slp\",\"slq\",\"slr\",\"sls\",\"slt\",\"slu\",\"slw\",\"slx\",\"sly\",\"slz\",\"sma\",\"smb\",\"smc\",\"smd\",\"smf\",\"smg\",\"smh\",\"smi\",\"smj\",\"smk\",\"sml\",\"smm\",\"smn\",\"smp\",\"smq\",\"smr\",\"sms\",\"smt\",\"smu\",\"smv\",\"smw\",\"smx\",\"smy\",\"smz\",\"snb\",\"snc\",\"sne\",\"snf\",\"sng\",\"snh\",\"sni\",\"snj\",\"snk\",\"snl\",\"snm\",\"snn\",\"sno\",\"snp\",\"snq\",\"snr\",\"sns\",\"snu\",\"snv\",\"snw\",\"snx\",\"sny\",\"snz\",\"soa\",\"sob\",\"soc\",\"sod\",\"soe\",\"sog\",\"soh\",\"soi\",\"soj\",\"sok\",\"sol\",\"son\",\"soo\",\"sop\",\"soq\",\"sor\",\"sos\",\"sou\",\"sov\",\"sow\",\"sox\",\"soy\",\"soz\",\"spb\",\"spc\",\"spd\",\"spe\",\"spg\",\"spi\",\"spk\",\"spl\",\"spm\",\"spn\",\"spo\",\"spp\",\"spq\",\"spr\",\"sps\",\"spt\",\"spu\",\"spv\",\"spx\",\"spy\",\"sqa\",\"sqh\",\"sqj\",\"sqk\",\"sqm\",\"sqn\",\"sqo\",\"sqq\",\"sqr\",\"sqs\",\"sqt\",\"squ\",\"sra\",\"srb\",\"src\",\"sre\",\"srf\",\"srg\",\"srh\",\"sri\",\"srk\",\"srl\",\"srm\",\"srn\",\"sro\",\"srq\",\"srr\",\"srs\",\"srt\",\"sru\",\"srv\",\"srw\",\"srx\",\"sry\",\"srz\",\"ssa\",\"ssb\",\"ssc\",\"ssd\",\"sse\",\"ssf\",\"ssg\",\"ssh\",\"ssi\",\"ssj\",\"ssk\",\"ssl\",\"ssm\",\"ssn\",\"sso\",\"ssp\",\"ssq\",\"ssr\",\"sss\",\"sst\",\"ssu\",\"ssv\",\"ssx\",\"ssy\",\"ssz\",\"sta\",\"stb\",\"std\",\"ste\",\"stf\",\"stg\",\"sth\",\"sti\",\"stj\",\"stk\",\"stl\",\"stm\",\"stn\",\"sto\",\"stp\",\"stq\",\"str\",\"sts\",\"stt\",\"stu\",\"stv\",\"stw\",\"sty\",\"sua\",\"sub\",\"suc\",\"sue\",\"sug\",\"sui\",\"suj\",\"suk\",\"sul\",\"sum\",\"suq\",\"sur\",\"sus\",\"sut\",\"suv\",\"suw\",\"sux\",\"suy\",\"suz\",\"sva\",\"svb\",\"svc\",\"sve\",\"svk\",\"svm\",\"svr\",\"svs\",\"svx\",\"swb\",\"swc\",\"swf\",\"swg\",\"swh\",\"swi\",\"swj\",\"swk\",\"swl\",\"swm\",\"swn\",\"swo\",\"swp\",\"swq\",\"swr\",\"sws\",\"swt\",\"swu\",\"swv\",\"sww\",\"swx\",\"swy\",\"sxb\",\"sxc\",\"sxe\",\"sxg\",\"sxk\",\"sxl\",\"sxm\",\"sxn\",\"sxo\",\"sxr\",\"sxs\",\"sxu\",\"sxw\",\"sya\",\"syb\",\"syc\",\"syd\",\"syi\",\"syk\",\"syl\",\"sym\",\"syn\",\"syo\",\"syr\",\"sys\",\"syw\",\"syx\",\"syy\",\"sza\",\"szb\",\"szc\",\"szd\",\"sze\",\"szg\",\"szl\",\"szn\",\"szp\",\"szv\",\"szw\",\"taa\",\"tab\",\"tac\",\"tad\",\"tae\",\"taf\",\"tag\",\"tai\",\"taj\",\"tak\",\"tal\",\"tan\",\"tao\",\"tap\",\"taq\",\"tar\",\"tas\",\"tau\",\"tav\",\"taw\",\"tax\",\"tay\",\"taz\",\"tba\",\"tbb\",\"tbc\",\"tbd\",\"tbe\",\"tbf\",\"tbg\",\"tbh\",\"tbi\",\"tbj\",\"tbk\",\"tbl\",\"tbm\",\"tbn\",\"tbo\",\"tbp\",\"tbq\",\"tbr\",\"tbs\",\"tbt\",\"tbu\",\"tbv\",\"tbw\",\"tbx\",\"tby\",\"tbz\",\"tca\",\"tcb\",\"tcc\",\"tcd\",\"tce\",\"tcf\",\"tcg\",\"tch\",\"tci\",\"tck\",\"tcl\",\"tcm\",\"tcn\",\"tco\",\"tcp\",\"tcq\",\"tcs\",\"tct\",\"tcu\",\"tcw\",\"tcx\",\"tcy\",\"tcz\",\"tda\",\"tdb\",\"tdc\",\"tdd\",\"tde\",\"tdf\",\"tdg\",\"tdh\",\"tdi\",\"tdj\",\"tdk\",\"tdl\",\"tdm\",\"tdn\",\"tdo\",\"tdq\",\"tdr\",\"tds\",\"tdt\",\"tdu\",\"tdv\",\"tdx\",\"tdy\",\"tea\",\"teb\",\"tec\",\"ted\",\"tee\",\"tef\",\"teg\",\"teh\",\"tei\",\"tek\",\"tem\",\"ten\",\"teo\",\"tep\",\"teq\",\"ter\",\"tes\",\"tet\",\"teu\",\"tev\",\"tew\",\"tex\",\"tey\",\"tfi\",\"tfn\",\"tfo\",\"tfr\",\"tft\",\"tga\",\"tgb\",\"tgc\",\"tgd\",\"tge\",\"tgf\",\"tgg\",\"tgh\",\"tgi\",\"tgj\",\"tgn\",\"tgo\",\"tgp\",\"tgq\",\"tgr\",\"tgs\",\"tgt\",\"tgu\",\"tgv\",\"tgw\",\"tgx\",\"tgy\",\"tgz\",\"thc\",\"thd\",\"the\",\"thf\",\"thh\",\"thi\",\"thk\",\"thl\",\"thm\",\"thn\",\"thp\",\"thq\",\"thr\",\"ths\",\"tht\",\"thu\",\"thv\",\"thw\",\"thx\",\"thy\",\"thz\",\"tia\",\"tic\",\"tid\",\"tie\",\"tif\",\"tig\",\"tih\",\"tii\",\"tij\",\"tik\",\"til\",\"tim\",\"tin\",\"tio\",\"tip\",\"tiq\",\"tis\",\"tit\",\"tiu\",\"tiv\",\"tiw\",\"tix\",\"tiy\",\"tiz\",\"tja\",\"tjg\",\"tji\",\"tjl\",\"tjm\",\"tjn\",\"tjo\",\"tjs\",\"tju\",\"tjw\",\"tka\",\"tkb\",\"tkd\",\"tke\",\"tkf\",\"tkg\",\"tkk\",\"tkl\",\"tkm\",\"tkn\",\"tkp\",\"tkq\",\"tkr\",\"tks\",\"tkt\",\"tku\",\"tkv\",\"tkw\",\"tkx\",\"tkz\",\"tla\",\"tlb\",\"tlc\",\"tld\",\"tlf\",\"tlg\",\"tlh\",\"tli\",\"tlj\",\"tlk\",\"tll\",\"tlm\",\"tln\",\"tlo\",\"tlp\",\"tlq\",\"tlr\",\"tls\",\"tlt\",\"tlu\",\"tlv\",\"tlw\",\"tlx\",\"tly\",\"tma\",\"tmb\",\"tmc\",\"tmd\",\"tme\",\"tmf\",\"tmg\",\"tmh\",\"tmi\",\"tmj\",\"tmk\",\"tml\",\"tmm\",\"tmn\",\"tmo\",\"tmp\",\"tmq\",\"tmr\",\"tms\",\"tmt\",\"tmu\",\"tmv\",\"tmw\",\"tmy\",\"tmz\",\"tna\",\"tnb\",\"tnc\",\"tnd\",\"tne\",\"tnf\",\"tng\",\"tnh\",\"tni\",\"tnk\",\"tnl\",\"tnm\",\"tnn\",\"tno\",\"tnp\",\"tnq\",\"tnr\",\"tns\",\"tnt\",\"tnu\",\"tnv\",\"tnw\",\"tnx\",\"tny\",\"tnz\",\"tob\",\"toc\",\"tod\",\"toe\",\"tof\",\"tog\",\"toh\",\"toi\",\"toj\",\"tol\",\"tom\",\"too\",\"top\",\"toq\",\"tor\",\"tos\",\"tou\",\"tov\",\"tow\",\"tox\",\"toy\",\"toz\",\"tpa\",\"tpc\",\"tpe\",\"tpf\",\"tpg\",\"tpi\",\"tpj\",\"tpk\",\"tpl\",\"tpm\",\"tpn\",\"tpo\",\"tpp\",\"tpq\",\"tpr\",\"tpt\",\"tpu\",\"tpv\",\"tpw\",\"tpx\",\"tpy\",\"tpz\",\"tqb\",\"tql\",\"tqm\",\"tqn\",\"tqo\",\"tqp\",\"tqq\",\"tqr\",\"tqt\",\"tqu\",\"tqw\",\"tra\",\"trb\",\"trc\",\"trd\",\"tre\",\"trf\",\"trg\",\"trh\",\"tri\",\"trj\",\"trk\",\"trl\",\"trm\",\"trn\",\"tro\",\"trp\",\"trq\",\"trr\",\"trs\",\"trt\",\"tru\",\"trv\",\"trw\",\"trx\",\"try\",\"trz\",\"tsa\",\"tsb\",\"tsc\",\"tsd\",\"tse\",\"tsf\",\"tsg\",\"tsh\",\"tsi\",\"tsj\",\"tsk\",\"tsl\",\"tsm\",\"tsp\",\"tsq\",\"tsr\",\"tss\",\"tst\",\"tsu\",\"tsv\",\"tsw\",\"tsx\",\"tsy\",\"tsz\",\"tta\",\"ttb\",\"ttc\",\"ttd\",\"tte\",\"ttf\",\"ttg\",\"tth\",\"tti\",\"ttj\",\"ttk\",\"ttl\",\"ttm\",\"ttn\",\"tto\",\"ttp\",\"ttq\",\"ttr\",\"tts\",\"ttt\",\"ttu\",\"ttv\",\"ttw\",\"tty\",\"ttz\",\"tua\",\"tub\",\"tuc\",\"tud\",\"tue\",\"tuf\",\"tug\",\"tuh\",\"tui\",\"tuj\",\"tul\",\"tum\",\"tun\",\"tuo\",\"tup\",\"tuq\",\"tus\",\"tut\",\"tuu\",\"tuv\",\"tuw\",\"tux\",\"tuy\",\"tuz\",\"tva\",\"tvd\",\"tve\",\"tvk\",\"tvl\",\"tvm\",\"tvn\",\"tvo\",\"tvs\",\"tvt\",\"tvu\",\"tvw\",\"tvy\",\"twa\",\"twb\",\"twc\",\"twd\",\"twe\",\"twf\",\"twg\",\"twh\",\"twl\",\"twm\",\"twn\",\"two\",\"twp\",\"twq\",\"twr\",\"twt\",\"twu\",\"tww\",\"twx\",\"twy\",\"txa\",\"txb\",\"txc\",\"txe\",\"txg\",\"txh\",\"txi\",\"txj\",\"txm\",\"txn\",\"txo\",\"txq\",\"txr\",\"txs\",\"txt\",\"txu\",\"txx\",\"txy\",\"tya\",\"tye\",\"tyh\",\"tyi\",\"tyj\",\"tyl\",\"tyn\",\"typ\",\"tyr\",\"tys\",\"tyt\",\"tyu\",\"tyv\",\"tyx\",\"tyz\",\"tza\",\"tzh\",\"tzj\",\"tzl\",\"tzm\",\"tzn\",\"tzo\",\"tzx\",\"uam\",\"uan\",\"uar\",\"uba\",\"ubi\",\"ubl\",\"ubr\",\"ubu\",\"uby\",\"uda\",\"ude\",\"udg\",\"udi\",\"udj\",\"udl\",\"udm\",\"udu\",\"ues\",\"ufi\",\"uga\",\"ugb\",\"uge\",\"ugn\",\"ugo\",\"ugy\",\"uha\",\"uhn\",\"uis\",\"uiv\",\"uji\",\"uka\",\"ukg\",\"ukh\",\"ukl\",\"ukp\",\"ukq\",\"uks\",\"uku\",\"ukw\",\"uky\",\"ula\",\"ulb\",\"ulc\",\"ule\",\"ulf\",\"uli\",\"ulk\",\"ull\",\"ulm\",\"uln\",\"ulu\",\"ulw\",\"uma\",\"umb\",\"umc\",\"umd\",\"umg\",\"umi\",\"umm\",\"umn\",\"umo\",\"ump\",\"umr\",\"ums\",\"umu\",\"una\",\"und\",\"une\",\"ung\",\"unk\",\"unm\",\"unn\",\"unp\",\"unr\",\"unu\",\"unx\",\"unz\",\"uok\",\"upi\",\"upv\",\"ura\",\"urb\",\"urc\",\"ure\",\"urf\",\"urg\",\"urh\",\"uri\",\"urj\",\"urk\",\"url\",\"urm\",\"urn\",\"uro\",\"urp\",\"urr\",\"urt\",\"uru\",\"urv\",\"urw\",\"urx\",\"ury\",\"urz\",\"usa\",\"ush\",\"usi\",\"usk\",\"usp\",\"usu\",\"uta\",\"ute\",\"utp\",\"utr\",\"utu\",\"uum\",\"uun\",\"uur\",\"uuu\",\"uve\",\"uvh\",\"uvl\",\"uwa\",\"uya\",\"uzn\",\"uzs\",\"vaa\",\"vae\",\"vaf\",\"vag\",\"vah\",\"vai\",\"vaj\",\"val\",\"vam\",\"van\",\"vao\",\"vap\",\"var\",\"vas\",\"vau\",\"vav\",\"vay\",\"vbb\",\"vbk\",\"vec\",\"ved\",\"vel\",\"vem\",\"veo\",\"vep\",\"ver\",\"vgr\",\"vgt\",\"vic\",\"vid\",\"vif\",\"vig\",\"vil\",\"vin\",\"vis\",\"vit\",\"viv\",\"vka\",\"vki\",\"vkj\",\"vkk\",\"vkl\",\"vkm\",\"vko\",\"vkp\",\"vkt\",\"vku\",\"vlp\",\"vls\",\"vma\",\"vmb\",\"vmc\",\"vmd\",\"vme\",\"vmf\",\"vmg\",\"vmh\",\"vmi\",\"vmj\",\"vmk\",\"vml\",\"vmm\",\"vmp\",\"vmq\",\"vmr\",\"vms\",\"vmu\",\"vmv\",\"vmw\",\"vmx\",\"vmy\",\"vmz\",\"vnk\",\"vnm\",\"vnp\",\"vor\",\"vot\",\"vra\",\"vro\",\"vrs\",\"vrt\",\"vsi\",\"vsl\",\"vsv\",\"vto\",\"vum\",\"vun\",\"vut\",\"vwa\",\"waa\",\"wab\",\"wac\",\"wad\",\"wae\",\"waf\",\"wag\",\"wah\",\"wai\",\"waj\",\"wak\",\"wal\",\"wam\",\"wan\",\"wao\",\"wap\",\"waq\",\"war\",\"was\",\"wat\",\"wau\",\"wav\",\"waw\",\"wax\",\"way\",\"waz\",\"wba\",\"wbb\",\"wbe\",\"wbf\",\"wbh\",\"wbi\",\"wbj\",\"wbk\",\"wbl\",\"wbm\",\"wbp\",\"wbq\",\"wbr\",\"wbt\",\"wbv\",\"wbw\",\"wca\",\"wci\",\"wdd\",\"wdg\",\"wdj\",\"wdk\",\"wdu\",\"wdy\",\"wea\",\"wec\",\"wed\",\"weg\",\"weh\",\"wei\",\"wem\",\"wen\",\"weo\",\"wep\",\"wer\",\"wes\",\"wet\",\"weu\",\"wew\",\"wfg\",\"wga\",\"wgb\",\"wgg\",\"wgi\",\"wgo\",\"wgu\",\"wgw\",\"wgy\",\"wha\",\"whg\",\"whk\",\"whu\",\"wib\",\"wic\",\"wie\",\"wif\",\"wig\",\"wih\",\"wii\",\"wij\",\"wik\",\"wil\",\"wim\",\"win\",\"wir\",\"wit\",\"wiu\",\"wiv\",\"wiw\",\"wiy\",\"wja\",\"wji\",\"wka\",\"wkb\",\"wkd\",\"wkl\",\"wku\",\"wkw\",\"wky\",\"wla\",\"wlc\",\"wle\",\"wlg\",\"wli\",\"wlk\",\"wll\",\"wlm\",\"wlo\",\"wlr\",\"wls\",\"wlu\",\"wlv\",\"wlw\",\"wlx\",\"wly\",\"wma\",\"wmb\",\"wmc\",\"wmd\",\"wme\",\"wmh\",\"wmi\",\"wmm\",\"wmn\",\"wmo\",\"wms\",\"wmt\",\"wmw\",\"wmx\",\"wnb\",\"wnc\",\"wnd\",\"wne\",\"wng\",\"wni\",\"wnk\",\"wnm\",\"wnn\",\"wno\",\"wnp\",\"wnu\",\"wnw\",\"wny\",\"woa\",\"wob\",\"woc\",\"wod\",\"woe\",\"wof\",\"wog\",\"woi\",\"wok\",\"wom\",\"won\",\"woo\",\"wor\",\"wos\",\"wow\",\"woy\",\"wpc\",\"wra\",\"wrb\",\"wrd\",\"wrg\",\"wrh\",\"wri\",\"wrk\",\"wrl\",\"wrm\",\"wrn\",\"wro\",\"wrp\",\"wrr\",\"wrs\",\"wru\",\"wrv\",\"wrw\",\"wrx\",\"wry\",\"wrz\",\"wsa\",\"wsg\",\"wsi\",\"wsk\",\"wsr\",\"wss\",\"wsu\",\"wsv\",\"wtf\",\"wth\",\"wti\",\"wtk\",\"wtm\",\"wtw\",\"wua\",\"wub\",\"wud\",\"wuh\",\"wul\",\"wum\",\"wun\",\"wur\",\"wut\",\"wuu\",\"wuv\",\"wux\",\"wuy\",\"wwa\",\"wwb\",\"wwo\",\"wwr\",\"www\",\"wxa\",\"wxw\",\"wya\",\"wyb\",\"wyi\",\"wym\",\"wyr\",\"wyy\",\"xaa\",\"xab\",\"xac\",\"xad\",\"xae\",\"xag\",\"xai\",\"xaj\",\"xak\",\"xal\",\"xam\",\"xan\",\"xao\",\"xap\",\"xaq\",\"xar\",\"xas\",\"xat\",\"xau\",\"xav\",\"xaw\",\"xay\",\"xba\",\"xbb\",\"xbc\",\"xbd\",\"xbe\",\"xbg\",\"xbi\",\"xbj\",\"xbm\",\"xbn\",\"xbo\",\"xbp\",\"xbr\",\"xbw\",\"xbx\",\"xby\",\"xcb\",\"xcc\",\"xce\",\"xcg\",\"xch\",\"xcl\",\"xcm\",\"xcn\",\"xco\",\"xcr\",\"xct\",\"xcu\",\"xcv\",\"xcw\",\"xcy\",\"xda\",\"xdc\",\"xdk\",\"xdm\",\"xdy\",\"xeb\",\"xed\",\"xeg\",\"xel\",\"xem\",\"xep\",\"xer\",\"xes\",\"xet\",\"xeu\",\"xfa\",\"xga\",\"xgb\",\"xgd\",\"xgf\",\"xgg\",\"xgi\",\"xgl\",\"xgm\",\"xgn\",\"xgr\",\"xgu\",\"xgw\",\"xha\",\"xhc\",\"xhd\",\"xhe\",\"xhr\",\"xht\",\"xhu\",\"xhv\",\"xia\",\"xib\",\"xii\",\"xil\",\"xin\",\"xip\",\"xir\",\"xis\",\"xiv\",\"xiy\",\"xjb\",\"xjt\",\"xka\",\"xkb\",\"xkc\",\"xkd\",\"xke\",\"xkf\",\"xkg\",\"xkh\",\"xki\",\"xkj\",\"xkk\",\"xkl\",\"xkn\",\"xko\",\"xkp\",\"xkq\",\"xkr\",\"xks\",\"xkt\",\"xku\",\"xkv\",\"xkw\",\"xkx\",\"xky\",\"xkz\",\"xla\",\"xlb\",\"xlc\",\"xld\",\"xle\",\"xlg\",\"xli\",\"xln\",\"xlo\",\"xlp\",\"xls\",\"xlu\",\"xly\",\"xma\",\"xmb\",\"xmc\",\"xmd\",\"xme\",\"xmf\",\"xmg\",\"xmh\",\"xmj\",\"xmk\",\"xml\",\"xmm\",\"xmn\",\"xmo\",\"xmp\",\"xmq\",\"xmr\",\"xms\",\"xmt\",\"xmu\",\"xmv\",\"xmw\",\"xmx\",\"xmy\",\"xmz\",\"xna\",\"xnb\",\"xnd\",\"xng\",\"xnh\",\"xni\",\"xnk\",\"xnn\",\"xno\",\"xnr\",\"xns\",\"xnt\",\"xnu\",\"xny\",\"xnz\",\"xoc\",\"xod\",\"xog\",\"xoi\",\"xok\",\"xom\",\"xon\",\"xoo\",\"xop\",\"xor\",\"xow\",\"xpa\",\"xpc\",\"xpe\",\"xpg\",\"xpi\",\"xpj\",\"xpk\",\"xpm\",\"xpn\",\"xpo\",\"xpp\",\"xpq\",\"xpr\",\"xps\",\"xpt\",\"xpu\",\"xpy\",\"xqa\",\"xqt\",\"xra\",\"xrb\",\"xrd\",\"xre\",\"xrg\",\"xri\",\"xrm\",\"xrn\",\"xrq\",\"xrr\",\"xrt\",\"xru\",\"xrw\",\"xsa\",\"xsb\",\"xsc\",\"xsd\",\"xse\",\"xsh\",\"xsi\",\"xsj\",\"xsl\",\"xsm\",\"xsn\",\"xso\",\"xsp\",\"xsq\",\"xsr\",\"xss\",\"xsu\",\"xsv\",\"xsy\",\"xta\",\"xtb\",\"xtc\",\"xtd\",\"xte\",\"xtg\",\"xth\",\"xti\",\"xtj\",\"xtl\",\"xtm\",\"xtn\",\"xto\",\"xtp\",\"xtq\",\"xtr\",\"xts\",\"xtt\",\"xtu\",\"xtv\",\"xtw\",\"xty\",\"xtz\",\"xua\",\"xub\",\"xud\",\"xug\",\"xuj\",\"xul\",\"xum\",\"xun\",\"xuo\",\"xup\",\"xur\",\"xut\",\"xuu\",\"xve\",\"xvi\",\"xvn\",\"xvo\",\"xvs\",\"xwa\",\"xwc\",\"xwd\",\"xwe\",\"xwg\",\"xwj\",\"xwk\",\"xwl\",\"xwo\",\"xwr\",\"xwt\",\"xww\",\"xxb\",\"xxk\",\"xxm\",\"xxr\",\"xxt\",\"xya\",\"xyb\",\"xyj\",\"xyk\",\"xyl\",\"xyt\",\"xyy\",\"xzh\",\"xzm\",\"xzp\",\"yaa\",\"yab\",\"yac\",\"yad\",\"yae\",\"yaf\",\"yag\",\"yah\",\"yai\",\"yaj\",\"yak\",\"yal\",\"yam\",\"yan\",\"yao\",\"yap\",\"yaq\",\"yar\",\"yas\",\"yat\",\"yau\",\"yav\",\"yaw\",\"yax\",\"yay\",\"yaz\",\"yba\",\"ybb\",\"ybd\",\"ybe\",\"ybh\",\"ybi\",\"ybj\",\"ybk\",\"ybl\",\"ybm\",\"ybn\",\"ybo\",\"ybx\",\"yby\",\"ych\",\"ycl\",\"ycn\",\"ycp\",\"yda\",\"ydd\",\"yde\",\"ydg\",\"ydk\",\"yds\",\"yea\",\"yec\",\"yee\",\"yei\",\"yej\",\"yel\",\"yen\",\"yer\",\"yes\",\"yet\",\"yeu\",\"yev\",\"yey\",\"yga\",\"ygi\",\"ygl\",\"ygm\",\"ygp\",\"ygr\",\"ygs\",\"ygu\",\"ygw\",\"yha\",\"yhd\",\"yhl\",\"yhs\",\"yia\",\"yif\",\"yig\",\"yih\",\"yii\",\"yij\",\"yik\",\"yil\",\"yim\",\"yin\",\"yip\",\"yiq\",\"yir\",\"yis\",\"yit\",\"yiu\",\"yiv\",\"yix\",\"yiy\",\"yiz\",\"yka\",\"ykg\",\"yki\",\"ykk\",\"ykl\",\"ykm\",\"ykn\",\"yko\",\"ykr\",\"ykt\",\"yku\",\"yky\",\"yla\",\"ylb\",\"yle\",\"ylg\",\"yli\",\"yll\",\"ylm\",\"yln\",\"ylo\",\"ylr\",\"ylu\",\"yly\",\"yma\",\"ymb\",\"ymc\",\"ymd\",\"yme\",\"ymg\",\"ymh\",\"ymi\",\"ymk\",\"yml\",\"ymm\",\"ymn\",\"ymo\",\"ymp\",\"ymq\",\"ymr\",\"yms\",\"ymt\",\"ymx\",\"ymz\",\"yna\",\"ynd\",\"yne\",\"yng\",\"ynh\",\"ynk\",\"ynl\",\"ynn\",\"yno\",\"ynq\",\"yns\",\"ynu\",\"yob\",\"yog\",\"yoi\",\"yok\",\"yol\",\"yom\",\"yon\",\"yos\",\"yot\",\"yox\",\"yoy\",\"ypa\",\"ypb\",\"ypg\",\"yph\",\"ypk\",\"ypm\",\"ypn\",\"ypo\",\"ypp\",\"ypz\",\"yra\",\"yrb\",\"yre\",\"yri\",\"yrk\",\"yrl\",\"yrm\",\"yrn\",\"yro\",\"yrs\",\"yrw\",\"yry\",\"ysc\",\"ysd\",\"ysg\",\"ysl\",\"ysn\",\"yso\",\"ysp\",\"ysr\",\"yss\",\"ysy\",\"yta\",\"ytl\",\"ytp\",\"ytw\",\"yty\",\"yua\",\"yub\",\"yuc\",\"yud\",\"yue\",\"yuf\",\"yug\",\"yui\",\"yuj\",\"yuk\",\"yul\",\"yum\",\"yun\",\"yup\",\"yuq\",\"yur\",\"yut\",\"yuu\",\"yuw\",\"yux\",\"yuy\",\"yuz\",\"yva\",\"yvt\",\"ywa\",\"ywg\",\"ywl\",\"ywn\",\"ywq\",\"ywr\",\"ywt\",\"ywu\",\"yww\",\"yxa\",\"yxg\",\"yxl\",\"yxm\",\"yxu\",\"yxy\",\"yyr\",\"yyu\",\"yyz\",\"yzg\",\"yzk\",\"zaa\",\"zab\",\"zac\",\"zad\",\"zae\",\"zaf\",\"zag\",\"zah\",\"zai\",\"zaj\",\"zak\",\"zal\",\"zam\",\"zao\",\"zap\",\"zaq\",\"zar\",\"zas\",\"zat\",\"zau\",\"zav\",\"zaw\",\"zax\",\"zay\",\"zaz\",\"zbc\",\"zbe\",\"zbl\",\"zbt\",\"zbw\",\"zca\",\"zch\",\"zdj\",\"zea\",\"zeg\",\"zeh\",\"zen\",\"zga\",\"zgb\",\"zgh\",\"zgm\",\"zgn\",\"zgr\",\"zhb\",\"zhd\",\"zhi\",\"zhn\",\"zhw\",\"zhx\",\"zia\",\"zib\",\"zik\",\"zil\",\"zim\",\"zin\",\"zir\",\"ziw\",\"ziz\",\"zka\",\"zkb\",\"zkd\",\"zkg\",\"zkh\",\"zkk\",\"zkn\",\"zko\",\"zkp\",\"zkr\",\"zkt\",\"zku\",\"zkv\",\"zkz\",\"zle\",\"zlj\",\"zlm\",\"zln\",\"zlq\",\"zls\",\"zlw\",\"zma\",\"zmb\",\"zmc\",\"zmd\",\"zme\",\"zmf\",\"zmg\",\"zmh\",\"zmi\",\"zmj\",\"zmk\",\"zml\",\"zmm\",\"zmn\",\"zmo\",\"zmp\",\"zmq\",\"zmr\",\"zms\",\"zmt\",\"zmu\",\"zmv\",\"zmw\",\"zmx\",\"zmy\",\"zmz\",\"zna\",\"znd\",\"zne\",\"zng\",\"znk\",\"zns\",\"zoc\",\"zoh\",\"zom\",\"zoo\",\"zoq\",\"zor\",\"zos\",\"zpa\",\"zpb\",\"zpc\",\"zpd\",\"zpe\",\"zpf\",\"zpg\",\"zph\",\"zpi\",\"zpj\",\"zpk\",\"zpl\",\"zpm\",\"zpn\",\"zpo\",\"zpp\",\"zpq\",\"zpr\",\"zps\",\"zpt\",\"zpu\",\"zpv\",\"zpw\",\"zpx\",\"zpy\",\"zpz\",\"zqe\",\"zra\",\"zrg\",\"zrn\",\"zro\",\"zrp\",\"zrs\",\"zsa\",\"zsk\",\"zsl\",\"zsm\",\"zsr\",\"zsu\",\"zte\",\"ztg\",\"ztl\",\"ztm\",\"ztn\",\"ztp\",\"ztq\",\"zts\",\"ztt\",\"ztu\",\"ztx\",\"zty\",\"zua\",\"zuh\",\"zum\",\"zun\",\"zuy\",\"zwa\",\"zxx\",\"zyb\",\"zyg\",\"zyj\",\"zyn\",\"zyp\",\"zza\",\"zzj\"],\nid:\"valid-lang\"}]},{id:\"image-alt\",selector:\"img, [role='img']\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-alt\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\",\"role-presentation\",\"role-none\"],none:[]},{id:\"image-redundant-alt\",selector:'button, [role=\"button\"], a[href], p, li, td, th',tags:[\"cat.text-alternatives\",\"best-practice\"],all:[],any:[],none:[\"duplicate-img-label\"]},{id:\"input-image-alt\",selector:'input[type=\"image\"]',tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-alt\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\"],none:[]},{id:\"label-title-only\",selector:\"input:not([type='hidden']):not([type='image']):not([type='button']):not([type='submit']):not([type='reset']), select, textarea\",enabled:!1,tags:[\"cat.forms\",\"best-practice\"],all:[],any:[],none:[\"title-only\"]},{id:\"label\",selector:\"input:not([type='hidden']):not([type='image']):not([type='button']):not([type='submit']):not([type='reset']), select, textarea\",tags:[\"cat.forms\",\"wcag2a\",\"wcag332\",\"wcag131\",\"section508\",\"section508.22.n\"],all:[],any:[\"aria-label\",\"aria-labelledby\",\"implicit-label\",\"explicit-label\",\"non-empty-title\"],none:[\"help-same-as-label\",\"multiple-label\"]},{id:\"layout-table\",selector:\"table\",matches:function(a){return!axe.commons.table.isDataTable(a)},tags:[\"cat.semantics\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"has-th\",\"has-caption\",\"has-summary\"]},{id:\"link-in-text-block\",selector:\"a[href]:not([role]), *[role=link]\",matches:function(a){return!!axe.commons.text.sanitize(a.textContent)&&!!axe.commons.dom.isVisible(a,!1)&&axe.commons.dom.isInTextBlock(a)},excludeHidden:!1,enabled:!1,tags:[\"cat.color\",\"experimental\",\"wcag2a\",\"wcag141\"],all:[\"link-in-text-block\"],any:[],none:[]},{id:\"link-name\",selector:'a[href]:not([role=\"button\"]), [role=link][href]',tags:[\"cat.name-role-value\",\"wcag2a\",\"wcag111\",\"wcag412\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-visible-text\",\"aria-label\",\"aria-labelledby\",\"role-presentation\",\"role-none\"],none:[\"focusable-no-name\"]},{id:\"list\",selector:\"ul:not([role]), ol:not([role])\",tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"only-listitems\"]},{id:\"listitem\",selector:\"li:not([role])\",tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[\"listitem\"],none:[]},{id:\"marquee\",selector:\"marquee\",excludeHidden:!1,tags:[\"cat.parsing\",\"wcag2a\",\"wcag222\"],all:[],any:[],none:[\"is-on-screen\"]},{id:\"meta-refresh\",selector:'meta[http-equiv=\"refresh\"]',excludeHidden:!1,tags:[\"cat.time\",\"wcag2a\",\"wcag2aaa\",\"wcag221\",\"wcag224\",\"wcag325\"],all:[],any:[\"meta-refresh\"],none:[]},{id:\"meta-viewport-large\",selector:'meta[name=\"viewport\"]',excludeHidden:!1,tags:[\"cat.sensory-and-visual-cues\",\"best-practice\"],all:[],any:[{options:{scaleMinimum:5,lowerBound:2},id:\"meta-viewport-large\"}],none:[]},{id:\"meta-viewport\",selector:'meta[name=\"viewport\"]',excludeHidden:!1,tags:[\"cat.sensory-and-visual-cues\",\"wcag2aa\",\"wcag144\"],all:[],any:[{options:{scaleMinimum:2},id:\"meta-viewport\"}],none:[]},{id:\"object-alt\",selector:\"object\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-visible-text\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\"],none:[]},{id:\"p-as-heading\",selector:\"p\",matches:function(a){var b=Array.from(a.parentNode.childNodes),c=a.textContent.trim();return!(0===c.length||(c.match(/[.!?:;](?![.!?:;])/g)||[]).length>=2)&&0!==b.slice(b.indexOf(a)+1).filter(function(a){return\"P\"===a.nodeName.toUpperCase()&&\"\"!==a.textContent.trim()}).length},tags:[\"cat.semantics\",\"wcag2a\",\"wcag131\",\"experimental\"],all:[{options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]},id:\"p-as-heading\"}],any:[],none:[]},{id:\"radiogroup\",selector:\"input[type=radio][name]\",tags:[\"cat.forms\",\"best-practice\"],all:[],any:[\"group-labelledby\",\"fieldset\"],none:[]},{id:\"region\",selector:\"html\",pageLevel:!0,enabled:!1,tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"region\"],none:[]},{id:\"scope-attr-valid\",selector:\"td[scope], th[scope]\",enabled:!0,tags:[\"cat.tables\",\"best-practice\"],all:[\"html5-scope\",\"scope-value\"],any:[],none:[]},{id:\"server-side-image-map\",selector:\"img[ismap]\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag211\",\"section508\",\"section508.22.f\"],all:[],any:[],none:[\"exists\"]},{id:\"skip-link\",selector:\"a[href]\",pageLevel:!0,enabled:!1,tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"skip-link\"],none:[]},{id:\"tabindex\",selector:\"[tabindex]\",tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"tabindex\"],none:[]},{id:\"table-duplicate-name\",selector:\"table\",tags:[\"cat.tables\",\"best-practice\"],all:[],any:[],none:[\"same-caption-summary\"]},{id:\"table-fake-caption\",selector:\"table\",matches:function(a){return axe.commons.table.isDataTable(a)},tags:[\"cat.tables\",\"experimental\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"caption-faked\"],any:[],none:[]},{id:\"td-has-header\",selector:\"table\",matches:function(a){if(axe.commons.table.isDataTable(a)){var b=axe.commons.table.toArray(a);return b.length>=3&&b[0].length>=3&&b[1].length>=3&&b[2].length>=3}return!1},tags:[\"cat.tables\",\"experimental\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"td-has-header\"],any:[],none:[]},{id:\"td-headers-attr\",selector:\"table\",tags:[\"cat.tables\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"td-headers-attr\"],any:[],none:[]},{id:\"th-has-data-cells\",selector:\"table\",matches:function(a){return axe.commons.table.isDataTable(a)},tags:[\"cat.tables\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"th-has-data-cells\"],any:[],none:[]},{id:\"valid-lang\",selector:\"[lang]:not(html), [xml\\\\:lang]:not(html)\",tags:[\"cat.language\",\"wcag2aa\",\"wcag312\"],all:[],any:[],none:[{\noptions:[\"aa\",\"ab\",\"ae\",\"af\",\"ak\",\"am\",\"an\",\"ar\",\"as\",\"av\",\"ay\",\"az\",\"ba\",\"be\",\"bg\",\"bh\",\"bi\",\"bm\",\"bn\",\"bo\",\"br\",\"bs\",\"ca\",\"ce\",\"ch\",\"co\",\"cr\",\"cs\",\"cu\",\"cv\",\"cy\",\"da\",\"de\",\"dv\",\"dz\",\"ee\",\"el\",\"en\",\"eo\",\"es\",\"et\",\"eu\",\"fa\",\"ff\",\"fi\",\"fj\",\"fo\",\"fr\",\"fy\",\"ga\",\"gd\",\"gl\",\"gn\",\"gu\",\"gv\",\"ha\",\"he\",\"hi\",\"ho\",\"hr\",\"ht\",\"hu\",\"hy\",\"hz\",\"ia\",\"id\",\"ie\",\"ig\",\"ii\",\"ik\",\"in\",\"io\",\"is\",\"it\",\"iu\",\"iw\",\"ja\",\"ji\",\"jv\",\"jw\",\"ka\",\"kg\",\"ki\",\"kj\",\"kk\",\"kl\",\"km\",\"kn\",\"ko\",\"kr\",\"ks\",\"ku\",\"kv\",\"kw\",\"ky\",\"la\",\"lb\",\"lg\",\"li\",\"ln\",\"lo\",\"lt\",\"lu\",\"lv\",\"mg\",\"mh\",\"mi\",\"mk\",\"ml\",\"mn\",\"mo\",\"mr\",\"ms\",\"mt\",\"my\",\"na\",\"nb\",\"nd\",\"ne\",\"ng\",\"nl\",\"nn\",\"no\",\"nr\",\"nv\",\"ny\",\"oc\",\"oj\",\"om\",\"or\",\"os\",\"pa\",\"pi\",\"pl\",\"ps\",\"pt\",\"qu\",\"rm\",\"rn\",\"ro\",\"ru\",\"rw\",\"sa\",\"sc\",\"sd\",\"se\",\"sg\",\"sh\",\"si\",\"sk\",\"sl\",\"sm\",\"sn\",\"so\",\"sq\",\"sr\",\"ss\",\"st\",\"su\",\"sv\",\"sw\",\"ta\",\"te\",\"tg\",\"th\",\"ti\",\"tk\",\"tl\",\"tn\",\"to\",\"tr\",\"ts\",\"tt\",\"tw\",\"ty\",\"ug\",\"uk\",\"ur\",\"uz\",\"ve\",\"vi\",\"vo\",\"wa\",\"wo\",\"xh\",\"yi\",\"yo\",\"za\",\"zh\",\"zu\",\"aaa\",\"aab\",\"aac\",\"aad\",\"aae\",\"aaf\",\"aag\",\"aah\",\"aai\",\"aak\",\"aal\",\"aam\",\"aan\",\"aao\",\"aap\",\"aaq\",\"aas\",\"aat\",\"aau\",\"aav\",\"aaw\",\"aax\",\"aaz\",\"aba\",\"abb\",\"abc\",\"abd\",\"abe\",\"abf\",\"abg\",\"abh\",\"abi\",\"abj\",\"abl\",\"abm\",\"abn\",\"abo\",\"abp\",\"abq\",\"abr\",\"abs\",\"abt\",\"abu\",\"abv\",\"abw\",\"abx\",\"aby\",\"abz\",\"aca\",\"acb\",\"acd\",\"ace\",\"acf\",\"ach\",\"aci\",\"ack\",\"acl\",\"acm\",\"acn\",\"acp\",\"acq\",\"acr\",\"acs\",\"act\",\"acu\",\"acv\",\"acw\",\"acx\",\"acy\",\"acz\",\"ada\",\"adb\",\"add\",\"ade\",\"adf\",\"adg\",\"adh\",\"adi\",\"adj\",\"adl\",\"adn\",\"ado\",\"adp\",\"adq\",\"adr\",\"ads\",\"adt\",\"adu\",\"adw\",\"adx\",\"ady\",\"adz\",\"aea\",\"aeb\",\"aec\",\"aed\",\"aee\",\"aek\",\"ael\",\"aem\",\"aen\",\"aeq\",\"aer\",\"aes\",\"aeu\",\"aew\",\"aey\",\"aez\",\"afa\",\"afb\",\"afd\",\"afe\",\"afg\",\"afh\",\"afi\",\"afk\",\"afn\",\"afo\",\"afp\",\"afs\",\"aft\",\"afu\",\"afz\",\"aga\",\"agb\",\"agc\",\"agd\",\"age\",\"agf\",\"agg\",\"agh\",\"agi\",\"agj\",\"agk\",\"agl\",\"agm\",\"agn\",\"ago\",\"agp\",\"agq\",\"agr\",\"ags\",\"agt\",\"agu\",\"agv\",\"agw\",\"agx\",\"agy\",\"agz\",\"aha\",\"ahb\",\"ahg\",\"ahh\",\"ahi\",\"ahk\",\"ahl\",\"ahm\",\"ahn\",\"aho\",\"ahp\",\"ahr\",\"ahs\",\"aht\",\"aia\",\"aib\",\"aic\",\"aid\",\"aie\",\"aif\",\"aig\",\"aih\",\"aii\",\"aij\",\"aik\",\"ail\",\"aim\",\"ain\",\"aio\",\"aip\",\"aiq\",\"air\",\"ais\",\"ait\",\"aiw\",\"aix\",\"aiy\",\"aja\",\"ajg\",\"aji\",\"ajn\",\"ajp\",\"ajt\",\"aju\",\"ajw\",\"ajz\",\"akb\",\"akc\",\"akd\",\"ake\",\"akf\",\"akg\",\"akh\",\"aki\",\"akj\",\"akk\",\"akl\",\"akm\",\"ako\",\"akp\",\"akq\",\"akr\",\"aks\",\"akt\",\"aku\",\"akv\",\"akw\",\"akx\",\"aky\",\"akz\",\"ala\",\"alc\",\"ald\",\"ale\",\"alf\",\"alg\",\"alh\",\"ali\",\"alj\",\"alk\",\"all\",\"alm\",\"aln\",\"alo\",\"alp\",\"alq\",\"alr\",\"als\",\"alt\",\"alu\",\"alv\",\"alw\",\"alx\",\"aly\",\"alz\",\"ama\",\"amb\",\"amc\",\"ame\",\"amf\",\"amg\",\"ami\",\"amj\",\"amk\",\"aml\",\"amm\",\"amn\",\"amo\",\"amp\",\"amq\",\"amr\",\"ams\",\"amt\",\"amu\",\"amv\",\"amw\",\"amx\",\"amy\",\"amz\",\"ana\",\"anb\",\"anc\",\"and\",\"ane\",\"anf\",\"ang\",\"anh\",\"ani\",\"anj\",\"ank\",\"anl\",\"anm\",\"ann\",\"ano\",\"anp\",\"anq\",\"anr\",\"ans\",\"ant\",\"anu\",\"anv\",\"anw\",\"anx\",\"any\",\"anz\",\"aoa\",\"aob\",\"aoc\",\"aod\",\"aoe\",\"aof\",\"aog\",\"aoh\",\"aoi\",\"aoj\",\"aok\",\"aol\",\"aom\",\"aon\",\"aor\",\"aos\",\"aot\",\"aou\",\"aox\",\"aoz\",\"apa\",\"apb\",\"apc\",\"apd\",\"ape\",\"apf\",\"apg\",\"aph\",\"api\",\"apj\",\"apk\",\"apl\",\"apm\",\"apn\",\"apo\",\"app\",\"apq\",\"apr\",\"aps\",\"apt\",\"apu\",\"apv\",\"apw\",\"apx\",\"apy\",\"apz\",\"aqa\",\"aqc\",\"aqd\",\"aqg\",\"aql\",\"aqm\",\"aqn\",\"aqp\",\"aqr\",\"aqt\",\"aqz\",\"arb\",\"arc\",\"ard\",\"are\",\"arh\",\"ari\",\"arj\",\"ark\",\"arl\",\"arn\",\"aro\",\"arp\",\"arq\",\"arr\",\"ars\",\"art\",\"aru\",\"arv\",\"arw\",\"arx\",\"ary\",\"arz\",\"asa\",\"asb\",\"asc\",\"asd\",\"ase\",\"asf\",\"asg\",\"ash\",\"asi\",\"asj\",\"ask\",\"asl\",\"asn\",\"aso\",\"asp\",\"asq\",\"asr\",\"ass\",\"ast\",\"asu\",\"asv\",\"asw\",\"asx\",\"asy\",\"asz\",\"ata\",\"atb\",\"atc\",\"atd\",\"ate\",\"atg\",\"ath\",\"ati\",\"atj\",\"atk\",\"atl\",\"atm\",\"atn\",\"ato\",\"atp\",\"atq\",\"atr\",\"ats\",\"att\",\"atu\",\"atv\",\"atw\",\"atx\",\"aty\",\"atz\",\"aua\",\"aub\",\"auc\",\"aud\",\"aue\",\"auf\",\"aug\",\"auh\",\"aui\",\"auj\",\"auk\",\"aul\",\"aum\",\"aun\",\"auo\",\"aup\",\"auq\",\"aur\",\"aus\",\"aut\",\"auu\",\"auw\",\"aux\",\"auy\",\"auz\",\"avb\",\"avd\",\"avi\",\"avk\",\"avl\",\"avm\",\"avn\",\"avo\",\"avs\",\"avt\",\"avu\",\"avv\",\"awa\",\"awb\",\"awc\",\"awd\",\"awe\",\"awg\",\"awh\",\"awi\",\"awk\",\"awm\",\"awn\",\"awo\",\"awr\",\"aws\",\"awt\",\"awu\",\"awv\",\"aww\",\"awx\",\"awy\",\"axb\",\"axe\",\"axg\",\"axk\",\"axl\",\"axm\",\"axx\",\"aya\",\"ayb\",\"ayc\",\"ayd\",\"aye\",\"ayg\",\"ayh\",\"ayi\",\"ayk\",\"ayl\",\"ayn\",\"ayo\",\"ayp\",\"ayq\",\"ayr\",\"ays\",\"ayt\",\"ayu\",\"ayx\",\"ayy\",\"ayz\",\"aza\",\"azb\",\"azc\",\"azd\",\"azg\",\"azj\",\"azm\",\"azn\",\"azo\",\"azt\",\"azz\",\"baa\",\"bab\",\"bac\",\"bad\",\"bae\",\"baf\",\"bag\",\"bah\",\"bai\",\"baj\",\"bal\",\"ban\",\"bao\",\"bap\",\"bar\",\"bas\",\"bat\",\"bau\",\"bav\",\"baw\",\"bax\",\"bay\",\"baz\",\"bba\",\"bbb\",\"bbc\",\"bbd\",\"bbe\",\"bbf\",\"bbg\",\"bbh\",\"bbi\",\"bbj\",\"bbk\",\"bbl\",\"bbm\",\"bbn\",\"bbo\",\"bbp\",\"bbq\",\"bbr\",\"bbs\",\"bbt\",\"bbu\",\"bbv\",\"bbw\",\"bbx\",\"bby\",\"bbz\",\"bca\",\"bcb\",\"bcc\",\"bcd\",\"bce\",\"bcf\",\"bcg\",\"bch\",\"bci\",\"bcj\",\"bck\",\"bcl\",\"bcm\",\"bcn\",\"bco\",\"bcp\",\"bcq\",\"bcr\",\"bcs\",\"bct\",\"bcu\",\"bcv\",\"bcw\",\"bcy\",\"bcz\",\"bda\",\"bdb\",\"bdc\",\"bdd\",\"bde\",\"bdf\",\"bdg\",\"bdh\",\"bdi\",\"bdj\",\"bdk\",\"bdl\",\"bdm\",\"bdn\",\"bdo\",\"bdp\",\"bdq\",\"bdr\",\"bds\",\"bdt\",\"bdu\",\"bdv\",\"bdw\",\"bdx\",\"bdy\",\"bdz\",\"bea\",\"beb\",\"bec\",\"bed\",\"bee\",\"bef\",\"beg\",\"beh\",\"bei\",\"bej\",\"bek\",\"bem\",\"beo\",\"bep\",\"beq\",\"ber\",\"bes\",\"bet\",\"beu\",\"bev\",\"bew\",\"bex\",\"bey\",\"bez\",\"bfa\",\"bfb\",\"bfc\",\"bfd\",\"bfe\",\"bff\",\"bfg\",\"bfh\",\"bfi\",\"bfj\",\"bfk\",\"bfl\",\"bfm\",\"bfn\",\"bfo\",\"bfp\",\"bfq\",\"bfr\",\"bfs\",\"bft\",\"bfu\",\"bfw\",\"bfx\",\"bfy\",\"bfz\",\"bga\",\"bgb\",\"bgc\",\"bgd\",\"bge\",\"bgf\",\"bgg\",\"bgi\",\"bgj\",\"bgk\",\"bgl\",\"bgm\",\"bgn\",\"bgo\",\"bgp\",\"bgq\",\"bgr\",\"bgs\",\"bgt\",\"bgu\",\"bgv\",\"bgw\",\"bgx\",\"bgy\",\"bgz\",\"bha\",\"bhb\",\"bhc\",\"bhd\",\"bhe\",\"bhf\",\"bhg\",\"bhh\",\"bhi\",\"bhj\",\"bhk\",\"bhl\",\"bhm\",\"bhn\",\"bho\",\"bhp\",\"bhq\",\"bhr\",\"bhs\",\"bht\",\"bhu\",\"bhv\",\"bhw\",\"bhx\",\"bhy\",\"bhz\",\"bia\",\"bib\",\"bic\",\"bid\",\"bie\",\"bif\",\"big\",\"bij\",\"bik\",\"bil\",\"bim\",\"bin\",\"bio\",\"bip\",\"biq\",\"bir\",\"bit\",\"biu\",\"biv\",\"biw\",\"bix\",\"biy\",\"biz\",\"bja\",\"bjb\",\"bjc\",\"bjd\",\"bje\",\"bjf\",\"bjg\",\"bjh\",\"bji\",\"bjj\",\"bjk\",\"bjl\",\"bjm\",\"bjn\",\"bjo\",\"bjp\",\"bjq\",\"bjr\",\"bjs\",\"bjt\",\"bju\",\"bjv\",\"bjw\",\"bjx\",\"bjy\",\"bjz\",\"bka\",\"bkb\",\"bkc\",\"bkd\",\"bkf\",\"bkg\",\"bkh\",\"bki\",\"bkj\",\"bkk\",\"bkl\",\"bkm\",\"bkn\",\"bko\",\"bkp\",\"bkq\",\"bkr\",\"bks\",\"bkt\",\"bku\",\"bkv\",\"bkw\",\"bkx\",\"bky\",\"bkz\",\"bla\",\"blb\",\"blc\",\"bld\",\"ble\",\"blf\",\"blg\",\"blh\",\"bli\",\"blj\",\"blk\",\"bll\",\"blm\",\"bln\",\"blo\",\"blp\",\"blq\",\"blr\",\"bls\",\"blt\",\"blv\",\"blw\",\"blx\",\"bly\",\"blz\",\"bma\",\"bmb\",\"bmc\",\"bmd\",\"bme\",\"bmf\",\"bmg\",\"bmh\",\"bmi\",\"bmj\",\"bmk\",\"bml\",\"bmm\",\"bmn\",\"bmo\",\"bmp\",\"bmq\",\"bmr\",\"bms\",\"bmt\",\"bmu\",\"bmv\",\"bmw\",\"bmx\",\"bmy\",\"bmz\",\"bna\",\"bnb\",\"bnc\",\"bnd\",\"bne\",\"bnf\",\"bng\",\"bni\",\"bnj\",\"bnk\",\"bnl\",\"bnm\",\"bnn\",\"bno\",\"bnp\",\"bnq\",\"bnr\",\"bns\",\"bnt\",\"bnu\",\"bnv\",\"bnw\",\"bnx\",\"bny\",\"bnz\",\"boa\",\"bob\",\"boe\",\"bof\",\"bog\",\"boh\",\"boi\",\"boj\",\"bok\",\"bol\",\"bom\",\"bon\",\"boo\",\"bop\",\"boq\",\"bor\",\"bot\",\"bou\",\"bov\",\"bow\",\"box\",\"boy\",\"boz\",\"bpa\",\"bpb\",\"bpd\",\"bpg\",\"bph\",\"bpi\",\"bpj\",\"bpk\",\"bpl\",\"bpm\",\"bpn\",\"bpo\",\"bpp\",\"bpq\",\"bpr\",\"bps\",\"bpt\",\"bpu\",\"bpv\",\"bpw\",\"bpx\",\"bpy\",\"bpz\",\"bqa\",\"bqb\",\"bqc\",\"bqd\",\"bqf\",\"bqg\",\"bqh\",\"bqi\",\"bqj\",\"bqk\",\"bql\",\"bqm\",\"bqn\",\"bqo\",\"bqp\",\"bqq\",\"bqr\",\"bqs\",\"bqt\",\"bqu\",\"bqv\",\"bqw\",\"bqx\",\"bqy\",\"bqz\",\"bra\",\"brb\",\"brc\",\"brd\",\"brf\",\"brg\",\"brh\",\"bri\",\"brj\",\"brk\",\"brl\",\"brm\",\"brn\",\"bro\",\"brp\",\"brq\",\"brr\",\"brs\",\"brt\",\"bru\",\"brv\",\"brw\",\"brx\",\"bry\",\"brz\",\"bsa\",\"bsb\",\"bsc\",\"bse\",\"bsf\",\"bsg\",\"bsh\",\"bsi\",\"bsj\",\"bsk\",\"bsl\",\"bsm\",\"bsn\",\"bso\",\"bsp\",\"bsq\",\"bsr\",\"bss\",\"bst\",\"bsu\",\"bsv\",\"bsw\",\"bsx\",\"bsy\",\"bta\",\"btb\",\"btc\",\"btd\",\"bte\",\"btf\",\"btg\",\"bth\",\"bti\",\"btj\",\"btk\",\"btl\",\"btm\",\"btn\",\"bto\",\"btp\",\"btq\",\"btr\",\"bts\",\"btt\",\"btu\",\"btv\",\"btw\",\"btx\",\"bty\",\"btz\",\"bua\",\"bub\",\"buc\",\"bud\",\"bue\",\"buf\",\"bug\",\"buh\",\"bui\",\"buj\",\"buk\",\"bum\",\"bun\",\"buo\",\"bup\",\"buq\",\"bus\",\"but\",\"buu\",\"buv\",\"buw\",\"bux\",\"buy\",\"buz\",\"bva\",\"bvb\",\"bvc\",\"bvd\",\"bve\",\"bvf\",\"bvg\",\"bvh\",\"bvi\",\"bvj\",\"bvk\",\"bvl\",\"bvm\",\"bvn\",\"bvo\",\"bvp\",\"bvq\",\"bvr\",\"bvt\",\"bvu\",\"bvv\",\"bvw\",\"bvx\",\"bvy\",\"bvz\",\"bwa\",\"bwb\",\"bwc\",\"bwd\",\"bwe\",\"bwf\",\"bwg\",\"bwh\",\"bwi\",\"bwj\",\"bwk\",\"bwl\",\"bwm\",\"bwn\",\"bwo\",\"bwp\",\"bwq\",\"bwr\",\"bws\",\"bwt\",\"bwu\",\"bww\",\"bwx\",\"bwy\",\"bwz\",\"bxa\",\"bxb\",\"bxc\",\"bxd\",\"bxe\",\"bxf\",\"bxg\",\"bxh\",\"bxi\",\"bxj\",\"bxk\",\"bxl\",\"bxm\",\"bxn\",\"bxo\",\"bxp\",\"bxq\",\"bxr\",\"bxs\",\"bxu\",\"bxv\",\"bxw\",\"bxx\",\"bxz\",\"bya\",\"byb\",\"byc\",\"byd\",\"bye\",\"byf\",\"byg\",\"byh\",\"byi\",\"byj\",\"byk\",\"byl\",\"bym\",\"byn\",\"byo\",\"byp\",\"byq\",\"byr\",\"bys\",\"byt\",\"byv\",\"byw\",\"byx\",\"byy\",\"byz\",\"bza\",\"bzb\",\"bzc\",\"bzd\",\"bze\",\"bzf\",\"bzg\",\"bzh\",\"bzi\",\"bzj\",\"bzk\",\"bzl\",\"bzm\",\"bzn\",\"bzo\",\"bzp\",\"bzq\",\"bzr\",\"bzs\",\"bzt\",\"bzu\",\"bzv\",\"bzw\",\"bzx\",\"bzy\",\"bzz\",\"caa\",\"cab\",\"cac\",\"cad\",\"cae\",\"caf\",\"cag\",\"cah\",\"cai\",\"caj\",\"cak\",\"cal\",\"cam\",\"can\",\"cao\",\"cap\",\"caq\",\"car\",\"cas\",\"cau\",\"cav\",\"caw\",\"cax\",\"cay\",\"caz\",\"cba\",\"cbb\",\"cbc\",\"cbd\",\"cbe\",\"cbg\",\"cbh\",\"cbi\",\"cbj\",\"cbk\",\"cbl\",\"cbn\",\"cbo\",\"cbq\",\"cbr\",\"cbs\",\"cbt\",\"cbu\",\"cbv\",\"cbw\",\"cby\",\"cca\",\"ccc\",\"ccd\",\"cce\",\"ccg\",\"cch\",\"ccj\",\"ccl\",\"ccm\",\"ccn\",\"cco\",\"ccp\",\"ccq\",\"ccr\",\"ccs\",\"cda\",\"cdc\",\"cdd\",\"cde\",\"cdf\",\"cdg\",\"cdh\",\"cdi\",\"cdj\",\"cdm\",\"cdn\",\"cdo\",\"cdr\",\"cds\",\"cdy\",\"cdz\",\"cea\",\"ceb\",\"ceg\",\"cek\",\"cel\",\"cen\",\"cet\",\"cfa\",\"cfd\",\"cfg\",\"cfm\",\"cga\",\"cgc\",\"cgg\",\"cgk\",\"chb\",\"chc\",\"chd\",\"chf\",\"chg\",\"chh\",\"chj\",\"chk\",\"chl\",\"chm\",\"chn\",\"cho\",\"chp\",\"chq\",\"chr\",\"cht\",\"chw\",\"chx\",\"chy\",\"chz\",\"cia\",\"cib\",\"cic\",\"cid\",\"cie\",\"cih\",\"cik\",\"cim\",\"cin\",\"cip\",\"cir\",\"ciw\",\"ciy\",\"cja\",\"cje\",\"cjh\",\"cji\",\"cjk\",\"cjm\",\"cjn\",\"cjo\",\"cjp\",\"cjr\",\"cjs\",\"cjv\",\"cjy\",\"cka\",\"ckb\",\"ckh\",\"ckl\",\"ckn\",\"cko\",\"ckq\",\"ckr\",\"cks\",\"ckt\",\"cku\",\"ckv\",\"ckx\",\"cky\",\"ckz\",\"cla\",\"clc\",\"cld\",\"cle\",\"clh\",\"cli\",\"clj\",\"clk\",\"cll\",\"clm\",\"clo\",\"clt\",\"clu\",\"clw\",\"cly\",\"cma\",\"cmc\",\"cme\",\"cmg\",\"cmi\",\"cmk\",\"cml\",\"cmm\",\"cmn\",\"cmo\",\"cmr\",\"cms\",\"cmt\",\"cna\",\"cnb\",\"cnc\",\"cng\",\"cnh\",\"cni\",\"cnk\",\"cnl\",\"cno\",\"cns\",\"cnt\",\"cnu\",\"cnw\",\"cnx\",\"coa\",\"cob\",\"coc\",\"cod\",\"coe\",\"cof\",\"cog\",\"coh\",\"coj\",\"cok\",\"col\",\"com\",\"con\",\"coo\",\"cop\",\"coq\",\"cot\",\"cou\",\"cov\",\"cow\",\"cox\",\"coy\",\"coz\",\"cpa\",\"cpb\",\"cpc\",\"cpe\",\"cpf\",\"cpg\",\"cpi\",\"cpn\",\"cpo\",\"cpp\",\"cps\",\"cpu\",\"cpx\",\"cpy\",\"cqd\",\"cqu\",\"cra\",\"crb\",\"crc\",\"crd\",\"crf\",\"crg\",\"crh\",\"cri\",\"crj\",\"crk\",\"crl\",\"crm\",\"crn\",\"cro\",\"crp\",\"crq\",\"crr\",\"crs\",\"crt\",\"crv\",\"crw\",\"crx\",\"cry\",\"crz\",\"csa\",\"csb\",\"csc\",\"csd\",\"cse\",\"csf\",\"csg\",\"csh\",\"csi\",\"csj\",\"csk\",\"csl\",\"csm\",\"csn\",\"cso\",\"csq\",\"csr\",\"css\",\"cst\",\"csu\",\"csv\",\"csw\",\"csy\",\"csz\",\"cta\",\"ctc\",\"ctd\",\"cte\",\"ctg\",\"cth\",\"ctl\",\"ctm\",\"ctn\",\"cto\",\"ctp\",\"cts\",\"ctt\",\"ctu\",\"ctz\",\"cua\",\"cub\",\"cuc\",\"cug\",\"cuh\",\"cui\",\"cuj\",\"cuk\",\"cul\",\"cum\",\"cuo\",\"cup\",\"cuq\",\"cur\",\"cus\",\"cut\",\"cuu\",\"cuv\",\"cuw\",\"cux\",\"cvg\",\"cvn\",\"cwa\",\"cwb\",\"cwd\",\"cwe\",\"cwg\",\"cwt\",\"cya\",\"cyb\",\"cyo\",\"czh\",\"czk\",\"czn\",\"czo\",\"czt\",\"daa\",\"dac\",\"dad\",\"dae\",\"daf\",\"dag\",\"dah\",\"dai\",\"daj\",\"dak\",\"dal\",\"dam\",\"dao\",\"dap\",\"daq\",\"dar\",\"das\",\"dau\",\"dav\",\"daw\",\"dax\",\"day\",\"daz\",\"dba\",\"dbb\",\"dbd\",\"dbe\",\"dbf\",\"dbg\",\"dbi\",\"dbj\",\"dbl\",\"dbm\",\"dbn\",\"dbo\",\"dbp\",\"dbq\",\"dbr\",\"dbt\",\"dbu\",\"dbv\",\"dbw\",\"dby\",\"dcc\",\"dcr\",\"dda\",\"ddd\",\"dde\",\"ddg\",\"ddi\",\"ddj\",\"ddn\",\"ddo\",\"ddr\",\"dds\",\"ddw\",\"dec\",\"ded\",\"dee\",\"def\",\"deg\",\"deh\",\"dei\",\"dek\",\"del\",\"dem\",\"den\",\"dep\",\"deq\",\"der\",\"des\",\"dev\",\"dez\",\"dga\",\"dgb\",\"dgc\",\"dgd\",\"dge\",\"dgg\",\"dgh\",\"dgi\",\"dgk\",\"dgl\",\"dgn\",\"dgo\",\"dgr\",\"dgs\",\"dgt\",\"dgu\",\"dgw\",\"dgx\",\"dgz\",\"dha\",\"dhd\",\"dhg\",\"dhi\",\"dhl\",\"dhm\",\"dhn\",\"dho\",\"dhr\",\"dhs\",\"dhu\",\"dhv\",\"dhw\",\"dhx\",\"dia\",\"dib\",\"dic\",\"did\",\"dif\",\"dig\",\"dih\",\"dii\",\"dij\",\"dik\",\"dil\",\"dim\",\"din\",\"dio\",\"dip\",\"diq\",\"dir\",\"dis\",\"dit\",\"diu\",\"diw\",\"dix\",\"diy\",\"diz\",\"dja\",\"djb\",\"djc\",\"djd\",\"dje\",\"djf\",\"dji\",\"djj\",\"djk\",\"djl\",\"djm\",\"djn\",\"djo\",\"djr\",\"dju\",\"djw\",\"dka\",\"dkk\",\"dkl\",\"dkr\",\"dks\",\"dkx\",\"dlg\",\"dlk\",\"dlm\",\"dln\",\"dma\",\"dmb\",\"dmc\",\"dmd\",\"dme\",\"dmg\",\"dmk\",\"dml\",\"dmm\",\"dmn\",\"dmo\",\"dmr\",\"dms\",\"dmu\",\"dmv\",\"dmw\",\"dmx\",\"dmy\",\"dna\",\"dnd\",\"dne\",\"dng\",\"dni\",\"dnj\",\"dnk\",\"dnn\",\"dnr\",\"dnt\",\"dnu\",\"dnv\",\"dnw\",\"dny\",\"doa\",\"dob\",\"doc\",\"doe\",\"dof\",\"doh\",\"doi\",\"dok\",\"dol\",\"don\",\"doo\",\"dop\",\"doq\",\"dor\",\"dos\",\"dot\",\"dov\",\"dow\",\"dox\",\"doy\",\"doz\",\"dpp\",\"dra\",\"drb\",\"drc\",\"drd\",\"dre\",\"drg\",\"drh\",\"dri\",\"drl\",\"drn\",\"dro\",\"drq\",\"drr\",\"drs\",\"drt\",\"dru\",\"drw\",\"dry\",\"dsb\",\"dse\",\"dsh\",\"dsi\",\"dsl\",\"dsn\",\"dso\",\"dsq\",\"dta\",\"dtb\",\"dtd\",\"dth\",\"dti\",\"dtk\",\"dtm\",\"dtn\",\"dto\",\"dtp\",\"dtr\",\"dts\",\"dtt\",\"dtu\",\"dty\",\"dua\",\"dub\",\"duc\",\"dud\",\"due\",\"duf\",\"dug\",\"duh\",\"dui\",\"duj\",\"duk\",\"dul\",\"dum\",\"dun\",\"duo\",\"dup\",\"duq\",\"dur\",\"dus\",\"duu\",\"duv\",\"duw\",\"dux\",\"duy\",\"duz\",\"dva\",\"dwa\",\"dwl\",\"dwr\",\"dws\",\"dwu\",\"dww\",\"dwy\",\"dya\",\"dyb\",\"dyd\",\"dyg\",\"dyi\",\"dym\",\"dyn\",\"dyo\",\"dyu\",\"dyy\",\"dza\",\"dzd\",\"dze\",\"dzg\",\"dzl\",\"dzn\",\"eaa\",\"ebg\",\"ebk\",\"ebo\",\"ebr\",\"ebu\",\"ecr\",\"ecs\",\"ecy\",\"eee\",\"efa\",\"efe\",\"efi\",\"ega\",\"egl\",\"ego\",\"egx\",\"egy\",\"ehu\",\"eip\",\"eit\",\"eiv\",\"eja\",\"eka\",\"ekc\",\"eke\",\"ekg\",\"eki\",\"ekk\",\"ekl\",\"ekm\",\"eko\",\"ekp\",\"ekr\",\"eky\",\"ele\",\"elh\",\"eli\",\"elk\",\"elm\",\"elo\",\"elp\",\"elu\",\"elx\",\"ema\",\"emb\",\"eme\",\"emg\",\"emi\",\"emk\",\"emm\",\"emn\",\"emo\",\"emp\",\"ems\",\"emu\",\"emw\",\"emx\",\"emy\",\"ena\",\"enb\",\"enc\",\"end\",\"enf\",\"enh\",\"enl\",\"enm\",\"enn\",\"eno\",\"enq\",\"enr\",\"enu\",\"env\",\"enw\",\"enx\",\"eot\",\"epi\",\"era\",\"erg\",\"erh\",\"eri\",\"erk\",\"ero\",\"err\",\"ers\",\"ert\",\"erw\",\"ese\",\"esg\",\"esh\",\"esi\",\"esk\",\"esl\",\"esm\",\"esn\",\"eso\",\"esq\",\"ess\",\"esu\",\"esx\",\"esy\",\"etb\",\"etc\",\"eth\",\"etn\",\"eto\",\"etr\",\"ets\",\"ett\",\"etu\",\"etx\",\"etz\",\"euq\",\"eve\",\"evh\",\"evn\",\"ewo\",\"ext\",\"eya\",\"eyo\",\"eza\",\"eze\",\"faa\",\"fab\",\"fad\",\"faf\",\"fag\",\"fah\",\"fai\",\"faj\",\"fak\",\"fal\",\"fam\",\"fan\",\"fap\",\"far\",\"fat\",\"fau\",\"fax\",\"fay\",\"faz\",\"fbl\",\"fcs\",\"fer\",\"ffi\",\"ffm\",\"fgr\",\"fia\",\"fie\",\"fil\",\"fip\",\"fir\",\"fit\",\"fiu\",\"fiw\",\"fkk\",\"fkv\",\"fla\",\"flh\",\"fli\",\"fll\",\"fln\",\"flr\",\"fly\",\"fmp\",\"fmu\",\"fnb\",\"fng\",\"fni\",\"fod\",\"foi\",\"fom\",\"fon\",\"for\",\"fos\",\"fox\",\"fpe\",\"fqs\",\"frc\",\"frd\",\"frk\",\"frm\",\"fro\",\"frp\",\"frq\",\"frr\",\"frs\",\"frt\",\"fse\",\"fsl\",\"fss\",\"fub\",\"fuc\",\"fud\",\"fue\",\"fuf\",\"fuh\",\"fui\",\"fuj\",\"fum\",\"fun\",\"fuq\",\"fur\",\"fut\",\"fuu\",\"fuv\",\"fuy\",\"fvr\",\"fwa\",\"fwe\",\"gaa\",\"gab\",\"gac\",\"gad\",\"gae\",\"gaf\",\"gag\",\"gah\",\"gai\",\"gaj\",\"gak\",\"gal\",\"gam\",\"gan\",\"gao\",\"gap\",\"gaq\",\"gar\",\"gas\",\"gat\",\"gau\",\"gav\",\"gaw\",\"gax\",\"gay\",\"gaz\",\"gba\",\"gbb\",\"gbc\",\"gbd\",\"gbe\",\"gbf\",\"gbg\",\"gbh\",\"gbi\",\"gbj\",\"gbk\",\"gbl\",\"gbm\",\"gbn\",\"gbo\",\"gbp\",\"gbq\",\"gbr\",\"gbs\",\"gbu\",\"gbv\",\"gbw\",\"gbx\",\"gby\",\"gbz\",\"gcc\",\"gcd\",\"gce\",\"gcf\",\"gcl\",\"gcn\",\"gcr\",\"gct\",\"gda\",\"gdb\",\"gdc\",\"gdd\",\"gde\",\"gdf\",\"gdg\",\"gdh\",\"gdi\",\"gdj\",\"gdk\",\"gdl\",\"gdm\",\"gdn\",\"gdo\",\"gdq\",\"gdr\",\"gds\",\"gdt\",\"gdu\",\"gdx\",\"gea\",\"geb\",\"gec\",\"ged\",\"geg\",\"geh\",\"gei\",\"gej\",\"gek\",\"gel\",\"gem\",\"geq\",\"ges\",\"gev\",\"gew\",\"gex\",\"gey\",\"gez\",\"gfk\",\"gft\",\"gfx\",\"gga\",\"ggb\",\"ggd\",\"gge\",\"ggg\",\"ggk\",\"ggl\",\"ggn\",\"ggo\",\"ggr\",\"ggt\",\"ggu\",\"ggw\",\"gha\",\"ghc\",\"ghe\",\"ghh\",\"ghk\",\"ghl\",\"ghn\",\"gho\",\"ghr\",\"ghs\",\"ght\",\"gia\",\"gib\",\"gic\",\"gid\",\"gig\",\"gih\",\"gil\",\"gim\",\"gin\",\"gio\",\"gip\",\"giq\",\"gir\",\"gis\",\"git\",\"giu\",\"giw\",\"gix\",\"giy\",\"giz\",\"gji\",\"gjk\",\"gjm\",\"gjn\",\"gjr\",\"gju\",\"gka\",\"gke\",\"gkn\",\"gko\",\"gkp\",\"gku\",\"glc\",\"gld\",\"glh\",\"gli\",\"glj\",\"glk\",\"gll\",\"glo\",\"glr\",\"glu\",\"glw\",\"gly\",\"gma\",\"gmb\",\"gmd\",\"gme\",\"gmg\",\"gmh\",\"gml\",\"gmm\",\"gmn\",\"gmq\",\"gmu\",\"gmv\",\"gmw\",\"gmx\",\"gmy\",\"gmz\",\"gna\",\"gnb\",\"gnc\",\"gnd\",\"gne\",\"gng\",\"gnh\",\"gni\",\"gnk\",\"gnl\",\"gnm\",\"gnn\",\"gno\",\"gnq\",\"gnr\",\"gnt\",\"gnu\",\"gnw\",\"gnz\",\"goa\",\"gob\",\"goc\",\"god\",\"goe\",\"gof\",\"gog\",\"goh\",\"goi\",\"goj\",\"gok\",\"gol\",\"gom\",\"gon\",\"goo\",\"gop\",\"goq\",\"gor\",\"gos\",\"got\",\"gou\",\"gow\",\"gox\",\"goy\",\"goz\",\"gpa\",\"gpe\",\"gpn\",\"gqa\",\"gqi\",\"gqn\",\"gqr\",\"gqu\",\"gra\",\"grb\",\"grc\",\"grd\",\"grg\",\"grh\",\"gri\",\"grj\",\"grk\",\"grm\",\"gro\",\"grq\",\"grr\",\"grs\",\"grt\",\"gru\",\"grv\",\"grw\",\"grx\",\"gry\",\"grz\",\"gse\",\"gsg\",\"gsl\",\"gsm\",\"gsn\",\"gso\",\"gsp\",\"gss\",\"gsw\",\"gta\",\"gti\",\"gtu\",\"gua\",\"gub\",\"guc\",\"gud\",\"gue\",\"guf\",\"gug\",\"guh\",\"gui\",\"guk\",\"gul\",\"gum\",\"gun\",\"guo\",\"gup\",\"guq\",\"gur\",\"gus\",\"gut\",\"guu\",\"guv\",\"guw\",\"gux\",\"guz\",\"gva\",\"gvc\",\"gve\",\"gvf\",\"gvj\",\"gvl\",\"gvm\",\"gvn\",\"gvo\",\"gvp\",\"gvr\",\"gvs\",\"gvy\",\"gwa\",\"gwb\",\"gwc\",\"gwd\",\"gwe\",\"gwf\",\"gwg\",\"gwi\",\"gwj\",\"gwm\",\"gwn\",\"gwr\",\"gwt\",\"gwu\",\"gww\",\"gwx\",\"gxx\",\"gya\",\"gyb\",\"gyd\",\"gye\",\"gyf\",\"gyg\",\"gyi\",\"gyl\",\"gym\",\"gyn\",\"gyr\",\"gyy\",\"gza\",\"gzi\",\"gzn\",\"haa\",\"hab\",\"hac\",\"had\",\"hae\",\"haf\",\"hag\",\"hah\",\"hai\",\"haj\",\"hak\",\"hal\",\"ham\",\"han\",\"hao\",\"hap\",\"haq\",\"har\",\"has\",\"hav\",\"haw\",\"hax\",\"hay\",\"haz\",\"hba\",\"hbb\",\"hbn\",\"hbo\",\"hbu\",\"hca\",\"hch\",\"hdn\",\"hds\",\"hdy\",\"hea\",\"hed\",\"heg\",\"heh\",\"hei\",\"hem\",\"hgm\",\"hgw\",\"hhi\",\"hhr\",\"hhy\",\"hia\",\"hib\",\"hid\",\"hif\",\"hig\",\"hih\",\"hii\",\"hij\",\"hik\",\"hil\",\"him\",\"hio\",\"hir\",\"hit\",\"hiw\",\"hix\",\"hji\",\"hka\",\"hke\",\"hkk\",\"hks\",\"hla\",\"hlb\",\"hld\",\"hle\",\"hlt\",\"hlu\",\"hma\",\"hmb\",\"hmc\",\"hmd\",\"hme\",\"hmf\",\"hmg\",\"hmh\",\"hmi\",\"hmj\",\"hmk\",\"hml\",\"hmm\",\"hmn\",\"hmp\",\"hmq\",\"hmr\",\"hms\",\"hmt\",\"hmu\",\"hmv\",\"hmw\",\"hmx\",\"hmy\",\"hmz\",\"hna\",\"hnd\",\"hne\",\"hnh\",\"hni\",\"hnj\",\"hnn\",\"hno\",\"hns\",\"hnu\",\"hoa\",\"hob\",\"hoc\",\"hod\",\"hoe\",\"hoh\",\"hoi\",\"hoj\",\"hok\",\"hol\",\"hom\",\"hoo\",\"hop\",\"hor\",\"hos\",\"hot\",\"hov\",\"how\",\"hoy\",\"hoz\",\"hpo\",\"hps\",\"hra\",\"hrc\",\"hre\",\"hrk\",\"hrm\",\"hro\",\"hrp\",\"hrr\",\"hrt\",\"hru\",\"hrw\",\"hrx\",\"hrz\",\"hsb\",\"hsh\",\"hsl\",\"hsn\",\"hss\",\"hti\",\"hto\",\"hts\",\"htu\",\"htx\",\"hub\",\"huc\",\"hud\",\"hue\",\"huf\",\"hug\",\"huh\",\"hui\",\"huj\",\"huk\",\"hul\",\"hum\",\"huo\",\"hup\",\"huq\",\"hur\",\"hus\",\"hut\",\"huu\",\"huv\",\"huw\",\"hux\",\"huy\",\"huz\",\"hvc\",\"hve\",\"hvk\",\"hvn\",\"hvv\",\"hwa\",\"hwc\",\"hwo\",\"hya\",\"hyx\",\"iai\",\"ian\",\"iap\",\"iar\",\"iba\",\"ibb\",\"ibd\",\"ibe\",\"ibg\",\"ibi\",\"ibl\",\"ibm\",\"ibn\",\"ibr\",\"ibu\",\"iby\",\"ica\",\"ich\",\"icl\",\"icr\",\"ida\",\"idb\",\"idc\",\"idd\",\"ide\",\"idi\",\"idr\",\"ids\",\"idt\",\"idu\",\"ifa\",\"ifb\",\"ife\",\"iff\",\"ifk\",\"ifm\",\"ifu\",\"ify\",\"igb\",\"ige\",\"igg\",\"igl\",\"igm\",\"ign\",\"igo\",\"igs\",\"igw\",\"ihb\",\"ihi\",\"ihp\",\"ihw\",\"iin\",\"iir\",\"ijc\",\"ije\",\"ijj\",\"ijn\",\"ijo\",\"ijs\",\"ike\",\"iki\",\"ikk\",\"ikl\",\"iko\",\"ikp\",\"ikr\",\"iks\",\"ikt\",\"ikv\",\"ikw\",\"ikx\",\"ikz\",\"ila\",\"ilb\",\"ilg\",\"ili\",\"ilk\",\"ill\",\"ilm\",\"ilo\",\"ilp\",\"ils\",\"ilu\",\"ilv\",\"ilw\",\"ima\",\"ime\",\"imi\",\"iml\",\"imn\",\"imo\",\"imr\",\"ims\",\"imy\",\"inb\",\"inc\",\"ine\",\"ing\",\"inh\",\"inj\",\"inl\",\"inm\",\"inn\",\"ino\",\"inp\",\"ins\",\"int\",\"inz\",\"ior\",\"iou\",\"iow\",\"ipi\",\"ipo\",\"iqu\",\"iqw\",\"ira\",\"ire\",\"irh\",\"iri\",\"irk\",\"irn\",\"iro\",\"irr\",\"iru\",\"irx\",\"iry\",\"isa\",\"isc\",\"isd\",\"ise\",\"isg\",\"ish\",\"isi\",\"isk\",\"ism\",\"isn\",\"iso\",\"isr\",\"ist\",\"isu\",\"itb\",\"itc\",\"itd\",\"ite\",\"iti\",\"itk\",\"itl\",\"itm\",\"ito\",\"itr\",\"its\",\"itt\",\"itv\",\"itw\",\"itx\",\"ity\",\"itz\",\"ium\",\"ivb\",\"ivv\",\"iwk\",\"iwm\",\"iwo\",\"iws\",\"ixc\",\"ixl\",\"iya\",\"iyo\",\"iyx\",\"izh\",\"izi\",\"izr\",\"izz\",\"jaa\",\"jab\",\"jac\",\"jad\",\"jae\",\"jaf\",\"jah\",\"jaj\",\"jak\",\"jal\",\"jam\",\"jan\",\"jao\",\"jaq\",\"jar\",\"jas\",\"jat\",\"jau\",\"jax\",\"jay\",\"jaz\",\"jbe\",\"jbi\",\"jbj\",\"jbk\",\"jbn\",\"jbo\",\"jbr\",\"jbt\",\"jbu\",\"jbw\",\"jcs\",\"jct\",\"jda\",\"jdg\",\"jdt\",\"jeb\",\"jee\",\"jeg\",\"jeh\",\"jei\",\"jek\",\"jel\",\"jen\",\"jer\",\"jet\",\"jeu\",\"jgb\",\"jge\",\"jgk\",\"jgo\",\"jhi\",\"jhs\",\"jia\",\"jib\",\"jic\",\"jid\",\"jie\",\"jig\",\"jih\",\"jii\",\"jil\",\"jim\",\"jio\",\"jiq\",\"jit\",\"jiu\",\"jiv\",\"jiy\",\"jje\",\"jjr\",\"jka\",\"jkm\",\"jko\",\"jkp\",\"jkr\",\"jku\",\"jle\",\"jls\",\"jma\",\"jmb\",\"jmc\",\"jmd\",\"jmi\",\"jml\",\"jmn\",\"jmr\",\"jms\",\"jmw\",\"jmx\",\"jna\",\"jnd\",\"jng\",\"jni\",\"jnj\",\"jnl\",\"jns\",\"job\",\"jod\",\"jog\",\"jor\",\"jos\",\"jow\",\"jpa\",\"jpr\",\"jpx\",\"jqr\",\"jra\",\"jrb\",\"jrr\",\"jrt\",\"jru\",\"jsl\",\"jua\",\"jub\",\"juc\",\"jud\",\"juh\",\"jui\",\"juk\",\"jul\",\"jum\",\"jun\",\"juo\",\"jup\",\"jur\",\"jus\",\"jut\",\"juu\",\"juw\",\"juy\",\"jvd\",\"jvn\",\"jwi\",\"jya\",\"jye\",\"jyy\",\"kaa\",\"kab\",\"kac\",\"kad\",\"kae\",\"kaf\",\"kag\",\"kah\",\"kai\",\"kaj\",\"kak\",\"kam\",\"kao\",\"kap\",\"kaq\",\"kar\",\"kav\",\"kaw\",\"kax\",\"kay\",\"kba\",\"kbb\",\"kbc\",\"kbd\",\"kbe\",\"kbf\",\"kbg\",\"kbh\",\"kbi\",\"kbj\",\"kbk\",\"kbl\",\"kbm\",\"kbn\",\"kbo\",\"kbp\",\"kbq\",\"kbr\",\"kbs\",\"kbt\",\"kbu\",\"kbv\",\"kbw\",\"kbx\",\"kby\",\"kbz\",\"kca\",\"kcb\",\"kcc\",\"kcd\",\"kce\",\"kcf\",\"kcg\",\"kch\",\"kci\",\"kcj\",\"kck\",\"kcl\",\"kcm\",\"kcn\",\"kco\",\"kcp\",\"kcq\",\"kcr\",\"kcs\",\"kct\",\"kcu\",\"kcv\",\"kcw\",\"kcx\",\"kcy\",\"kcz\",\"kda\",\"kdc\",\"kdd\",\"kde\",\"kdf\",\"kdg\",\"kdh\",\"kdi\",\"kdj\",\"kdk\",\"kdl\",\"kdm\",\"kdn\",\"kdo\",\"kdp\",\"kdq\",\"kdr\",\"kdt\",\"kdu\",\"kdv\",\"kdw\",\"kdx\",\"kdy\",\"kdz\",\"kea\",\"keb\",\"kec\",\"ked\",\"kee\",\"kef\",\"keg\",\"keh\",\"kei\",\"kej\",\"kek\",\"kel\",\"kem\",\"ken\",\"keo\",\"kep\",\"keq\",\"ker\",\"kes\",\"ket\",\"keu\",\"kev\",\"kew\",\"kex\",\"key\",\"kez\",\"kfa\",\"kfb\",\"kfc\",\"kfd\",\"kfe\",\"kff\",\"kfg\",\"kfh\",\"kfi\",\"kfj\",\"kfk\",\"kfl\",\"kfm\",\"kfn\",\"kfo\",\"kfp\",\"kfq\",\"kfr\",\"kfs\",\"kft\",\"kfu\",\"kfv\",\"kfw\",\"kfx\",\"kfy\",\"kfz\",\"kga\",\"kgb\",\"kgc\",\"kgd\",\"kge\",\"kgf\",\"kgg\",\"kgh\",\"kgi\",\"kgj\",\"kgk\",\"kgl\",\"kgm\",\"kgn\",\"kgo\",\"kgp\",\"kgq\",\"kgr\",\"kgs\",\"kgt\",\"kgu\",\"kgv\",\"kgw\",\"kgx\",\"kgy\",\"kha\",\"khb\",\"khc\",\"khd\",\"khe\",\"khf\",\"khg\",\"khh\",\"khi\",\"khj\",\"khk\",\"khl\",\"khn\",\"kho\",\"khp\",\"khq\",\"khr\",\"khs\",\"kht\",\"khu\",\"khv\",\"khw\",\"khx\",\"khy\",\"khz\",\"kia\",\"kib\",\"kic\",\"kid\",\"kie\",\"kif\",\"kig\",\"kih\",\"kii\",\"kij\",\"kil\",\"kim\",\"kio\",\"kip\",\"kiq\",\"kis\",\"kit\",\"kiu\",\"kiv\",\"kiw\",\"kix\",\"kiy\",\"kiz\",\"kja\",\"kjb\",\"kjc\",\"kjd\",\"kje\",\"kjf\",\"kjg\",\"kjh\",\"kji\",\"kjj\",\"kjk\",\"kjl\",\"kjm\",\"kjn\",\"kjo\",\"kjp\",\"kjq\",\"kjr\",\"kjs\",\"kjt\",\"kju\",\"kjv\",\"kjx\",\"kjy\",\"kjz\",\"kka\",\"kkb\",\"kkc\",\"kkd\",\"kke\",\"kkf\",\"kkg\",\"kkh\",\"kki\",\"kkj\",\"kkk\",\"kkl\",\"kkm\",\"kkn\",\"kko\",\"kkp\",\"kkq\",\"kkr\",\"kks\",\"kkt\",\"kku\",\"kkv\",\"kkw\",\"kkx\",\"kky\",\"kkz\",\"kla\",\"klb\",\"klc\",\"kld\",\"kle\",\"klf\",\"klg\",\"klh\",\"kli\",\"klj\",\"klk\",\"kll\",\"klm\",\"kln\",\"klo\",\"klp\",\"klq\",\"klr\",\"kls\",\"klt\",\"klu\",\"klv\",\"klw\",\"klx\",\"kly\",\"klz\",\"kma\",\"kmb\",\"kmc\",\"kmd\",\"kme\",\"kmf\",\"kmg\",\"kmh\",\"kmi\",\"kmj\",\"kmk\",\"kml\",\"kmm\",\"kmn\",\"kmo\",\"kmp\",\"kmq\",\"kmr\",\"kms\",\"kmt\",\"kmu\",\"kmv\",\"kmw\",\"kmx\",\"kmy\",\"kmz\",\"kna\",\"knb\",\"knc\",\"knd\",\"kne\",\"knf\",\"kng\",\"kni\",\"knj\",\"knk\",\"knl\",\"knm\",\"knn\",\"kno\",\"knp\",\"knq\",\"knr\",\"kns\",\"knt\",\"knu\",\"knv\",\"knw\",\"knx\",\"kny\",\"knz\",\"koa\",\"koc\",\"kod\",\"koe\",\"kof\",\"kog\",\"koh\",\"koi\",\"koj\",\"kok\",\"kol\",\"koo\",\"kop\",\"koq\",\"kos\",\"kot\",\"kou\",\"kov\",\"kow\",\"kox\",\"koy\",\"koz\",\"kpa\",\"kpb\",\"kpc\",\"kpd\",\"kpe\",\"kpf\",\"kpg\",\"kph\",\"kpi\",\"kpj\",\"kpk\",\"kpl\",\"kpm\",\"kpn\",\"kpo\",\"kpp\",\"kpq\",\"kpr\",\"kps\",\"kpt\",\"kpu\",\"kpv\",\"kpw\",\"kpx\",\"kpy\",\"kpz\",\"kqa\",\"kqb\",\"kqc\",\"kqd\",\"kqe\",\"kqf\",\"kqg\",\"kqh\",\"kqi\",\"kqj\",\"kqk\",\"kql\",\"kqm\",\"kqn\",\"kqo\",\"kqp\",\"kqq\",\"kqr\",\"kqs\",\"kqt\",\"kqu\",\"kqv\",\"kqw\",\"kqx\",\"kqy\",\"kqz\",\"kra\",\"krb\",\"krc\",\"krd\",\"kre\",\"krf\",\"krh\",\"kri\",\"krj\",\"krk\",\"krl\",\"krm\",\"krn\",\"kro\",\"krp\",\"krr\",\"krs\",\"krt\",\"kru\",\"krv\",\"krw\",\"krx\",\"kry\",\"krz\",\"ksa\",\"ksb\",\"ksc\",\"ksd\",\"kse\",\"ksf\",\"ksg\",\"ksh\",\"ksi\",\"ksj\",\"ksk\",\"ksl\",\"ksm\",\"ksn\",\"kso\",\"ksp\",\"ksq\",\"ksr\",\"kss\",\"kst\",\"ksu\",\"ksv\",\"ksw\",\"ksx\",\"ksy\",\"ksz\",\"kta\",\"ktb\",\"ktc\",\"ktd\",\"kte\",\"ktf\",\"ktg\",\"kth\",\"kti\",\"ktj\",\"ktk\",\"ktl\",\"ktm\",\"ktn\",\"kto\",\"ktp\",\"ktq\",\"ktr\",\"kts\",\"ktt\",\"ktu\",\"ktv\",\"ktw\",\"ktx\",\"kty\",\"ktz\",\"kub\",\"kuc\",\"kud\",\"kue\",\"kuf\",\"kug\",\"kuh\",\"kui\",\"kuj\",\"kuk\",\"kul\",\"kum\",\"kun\",\"kuo\",\"kup\",\"kuq\",\"kus\",\"kut\",\"kuu\",\"kuv\",\"kuw\",\"kux\",\"kuy\",\"kuz\",\"kva\",\"kvb\",\"kvc\",\"kvd\",\"kve\",\"kvf\",\"kvg\",\"kvh\",\"kvi\",\"kvj\",\"kvk\",\"kvl\",\"kvm\",\"kvn\",\"kvo\",\"kvp\",\"kvq\",\"kvr\",\"kvs\",\"kvt\",\"kvu\",\"kvv\",\"kvw\",\"kvx\",\"kvy\",\"kvz\",\"kwa\",\"kwb\",\"kwc\",\"kwd\",\"kwe\",\"kwf\",\"kwg\",\"kwh\",\"kwi\",\"kwj\",\"kwk\",\"kwl\",\"kwm\",\"kwn\",\"kwo\",\"kwp\",\"kwq\",\"kwr\",\"kws\",\"kwt\",\"kwu\",\"kwv\",\"kww\",\"kwx\",\"kwy\",\"kwz\",\"kxa\",\"kxb\",\"kxc\",\"kxd\",\"kxe\",\"kxf\",\"kxh\",\"kxi\",\"kxj\",\"kxk\",\"kxl\",\"kxm\",\"kxn\",\"kxo\",\"kxp\",\"kxq\",\"kxr\",\"kxs\",\"kxt\",\"kxu\",\"kxv\",\"kxw\",\"kxx\",\"kxy\",\"kxz\",\"kya\",\"kyb\",\"kyc\",\"kyd\",\"kye\",\"kyf\",\"kyg\",\"kyh\",\"kyi\",\"kyj\",\"kyk\",\"kyl\",\"kym\",\"kyn\",\"kyo\",\"kyp\",\"kyq\",\"kyr\",\"kys\",\"kyt\",\"kyu\",\"kyv\",\"kyw\",\"kyx\",\"kyy\",\"kyz\",\"kza\",\"kzb\",\"kzc\",\"kzd\",\"kze\",\"kzf\",\"kzg\",\"kzh\",\"kzi\",\"kzj\",\"kzk\",\"kzl\",\"kzm\",\"kzn\",\"kzo\",\"kzp\",\"kzq\",\"kzr\",\"kzs\",\"kzt\",\"kzu\",\"kzv\",\"kzw\",\"kzx\",\"kzy\",\"kzz\",\"laa\",\"lab\",\"lac\",\"lad\",\"lae\",\"laf\",\"lag\",\"lah\",\"lai\",\"laj\",\"lak\",\"lal\",\"lam\",\"lan\",\"lap\",\"laq\",\"lar\",\"las\",\"lau\",\"law\",\"lax\",\"lay\",\"laz\",\"lba\",\"lbb\",\"lbc\",\"lbe\",\"lbf\",\"lbg\",\"lbi\",\"lbj\",\"lbk\",\"lbl\",\"lbm\",\"lbn\",\"lbo\",\"lbq\",\"lbr\",\"lbs\",\"lbt\",\"lbu\",\"lbv\",\"lbw\",\"lbx\",\"lby\",\"lbz\",\"lcc\",\"lcd\",\"lce\",\"lcf\",\"lch\",\"lcl\",\"lcm\",\"lcp\",\"lcq\",\"lcs\",\"lda\",\"ldb\",\"ldd\",\"ldg\",\"ldh\",\"ldi\",\"ldj\",\"ldk\",\"ldl\",\"ldm\",\"ldn\",\"ldo\",\"ldp\",\"ldq\",\"lea\",\"leb\",\"lec\",\"led\",\"lee\",\"lef\",\"leg\",\"leh\",\"lei\",\"lej\",\"lek\",\"lel\",\"lem\",\"len\",\"leo\",\"lep\",\"leq\",\"ler\",\"les\",\"let\",\"leu\",\"lev\",\"lew\",\"lex\",\"ley\",\"lez\",\"lfa\",\"lfn\",\"lga\",\"lgb\",\"lgg\",\"lgh\",\"lgi\",\"lgk\",\"lgl\",\"lgm\",\"lgn\",\"lgq\",\"lgr\",\"lgt\",\"lgu\",\"lgz\",\"lha\",\"lhh\",\"lhi\",\"lhl\",\"lhm\",\"lhn\",\"lhp\",\"lhs\",\"lht\",\"lhu\",\"lia\",\"lib\",\"lic\",\"lid\",\"lie\",\"lif\",\"lig\",\"lih\",\"lii\",\"lij\",\"lik\",\"lil\",\"lio\",\"lip\",\"liq\",\"lir\",\"lis\",\"liu\",\"liv\",\"liw\",\"lix\",\"liy\",\"liz\",\"lja\",\"lje\",\"lji\",\"ljl\",\"ljp\",\"ljw\",\"ljx\",\"lka\",\"lkb\",\"lkc\",\"lkd\",\"lke\",\"lkh\",\"lki\",\"lkj\",\"lkl\",\"lkm\",\"lkn\",\"lko\",\"lkr\",\"lks\",\"lkt\",\"lku\",\"lky\",\"lla\",\"llb\",\"llc\",\"lld\",\"lle\",\"llf\",\"llg\",\"llh\",\"lli\",\"llj\",\"llk\",\"lll\",\"llm\",\"lln\",\"llo\",\"llp\",\"llq\",\"lls\",\"llu\",\"llx\",\"lma\",\"lmb\",\"lmc\",\"lmd\",\"lme\",\"lmf\",\"lmg\",\"lmh\",\"lmi\",\"lmj\",\"lmk\",\"lml\",\"lmm\",\"lmn\",\"lmo\",\"lmp\",\"lmq\",\"lmr\",\"lmu\",\"lmv\",\"lmw\",\"lmx\",\"lmy\",\"lmz\",\"lna\",\"lnb\",\"lnd\",\"lng\",\"lnh\",\"lni\",\"lnj\",\"lnl\",\"lnm\",\"lnn\",\"lno\",\"lns\",\"lnu\",\"lnw\",\"lnz\",\"loa\",\"lob\",\"loc\",\"loe\",\"lof\",\"log\",\"loh\",\"loi\",\"loj\",\"lok\",\"lol\",\"lom\",\"lon\",\"loo\",\"lop\",\"loq\",\"lor\",\"los\",\"lot\",\"lou\",\"lov\",\"low\",\"lox\",\"loy\",\"loz\",\"lpa\",\"lpe\",\"lpn\",\"lpo\",\"lpx\",\"lra\",\"lrc\",\"lre\",\"lrg\",\"lri\",\"lrk\",\"lrl\",\"lrm\",\"lrn\",\"lro\",\"lrr\",\"lrt\",\"lrv\",\"lrz\",\"lsa\",\"lsd\",\"lse\",\"lsg\",\"lsh\",\"lsi\",\"lsl\",\"lsm\",\"lso\",\"lsp\",\"lsr\",\"lss\",\"lst\",\"lsy\",\"ltc\",\"ltg\",\"lti\",\"ltn\",\"lto\",\"lts\",\"ltu\",\"lua\",\"luc\",\"lud\",\"lue\",\"luf\",\"lui\",\"luj\",\"luk\",\"lul\",\"lum\",\"lun\",\"luo\",\"lup\",\"luq\",\"lur\",\"lus\",\"lut\",\"luu\",\"luv\",\"luw\",\"luy\",\"luz\",\"lva\",\"lvk\",\"lvs\",\"lvu\",\"lwa\",\"lwe\",\"lwg\",\"lwh\",\"lwl\",\"lwm\",\"lwo\",\"lwt\",\"lwu\",\"lww\",\"lya\",\"lyg\",\"lyn\",\"lzh\",\"lzl\",\"lzn\",\"lzz\",\"maa\",\"mab\",\"mad\",\"mae\",\"maf\",\"mag\",\"mai\",\"maj\",\"mak\",\"mam\",\"man\",\"map\",\"maq\",\"mas\",\"mat\",\"mau\",\"mav\",\"maw\",\"max\",\"maz\",\"mba\",\"mbb\",\"mbc\",\"mbd\",\"mbe\",\"mbf\",\"mbh\",\"mbi\",\"mbj\",\"mbk\",\"mbl\",\"mbm\",\"mbn\",\"mbo\",\"mbp\",\"mbq\",\"mbr\",\"mbs\",\"mbt\",\"mbu\",\"mbv\",\"mbw\",\"mbx\",\"mby\",\"mbz\",\"mca\",\"mcb\",\"mcc\",\"mcd\",\"mce\",\"mcf\",\"mcg\",\"mch\",\"mci\",\"mcj\",\"mck\",\"mcl\",\"mcm\",\"mcn\",\"mco\",\"mcp\",\"mcq\",\"mcr\",\"mcs\",\"mct\",\"mcu\",\"mcv\",\"mcw\",\"mcx\",\"mcy\",\"mcz\",\"mda\",\"mdb\",\"mdc\",\"mdd\",\"mde\",\"mdf\",\"mdg\",\"mdh\",\"mdi\",\"mdj\",\"mdk\",\"mdl\",\"mdm\",\"mdn\",\"mdp\",\"mdq\",\"mdr\",\"mds\",\"mdt\",\"mdu\",\"mdv\",\"mdw\",\"mdx\",\"mdy\",\"mdz\",\"mea\",\"meb\",\"mec\",\"med\",\"mee\",\"mef\",\"meg\",\"meh\",\"mei\",\"mej\",\"mek\",\"mel\",\"mem\",\"men\",\"meo\",\"mep\",\"meq\",\"mer\",\"mes\",\"met\",\"meu\",\"mev\",\"mew\",\"mey\",\"mez\",\"mfa\",\"mfb\",\"mfc\",\"mfd\",\"mfe\",\"mff\",\"mfg\",\"mfh\",\"mfi\",\"mfj\",\"mfk\",\"mfl\",\"mfm\",\"mfn\",\"mfo\",\"mfp\",\"mfq\",\"mfr\",\"mfs\",\"mft\",\"mfu\",\"mfv\",\"mfw\",\"mfx\",\"mfy\",\"mfz\",\"mga\",\"mgb\",\"mgc\",\"mgd\",\"mge\",\"mgf\",\"mgg\",\"mgh\",\"mgi\",\"mgj\",\"mgk\",\"mgl\",\"mgm\",\"mgn\",\"mgo\",\"mgp\",\"mgq\",\"mgr\",\"mgs\",\"mgt\",\"mgu\",\"mgv\",\"mgw\",\"mgx\",\"mgy\",\"mgz\",\"mha\",\"mhb\",\"mhc\",\"mhd\",\"mhe\",\"mhf\",\"mhg\",\"mhh\",\"mhi\",\"mhj\",\"mhk\",\"mhl\",\"mhm\",\"mhn\",\"mho\",\"mhp\",\"mhq\",\"mhr\",\"mhs\",\"mht\",\"mhu\",\"mhw\",\"mhx\",\"mhy\",\"mhz\",\"mia\",\"mib\",\"mic\",\"mid\",\"mie\",\"mif\",\"mig\",\"mih\",\"mii\",\"mij\",\"mik\",\"mil\",\"mim\",\"min\",\"mio\",\"mip\",\"miq\",\"mir\",\"mis\",\"mit\",\"miu\",\"miw\",\"mix\",\"miy\",\"miz\",\"mja\",\"mjb\",\"mjc\",\"mjd\",\"mje\",\"mjg\",\"mjh\",\"mji\",\"mjj\",\"mjk\",\"mjl\",\"mjm\",\"mjn\",\"mjo\",\"mjp\",\"mjq\",\"mjr\",\"mjs\",\"mjt\",\"mju\",\"mjv\",\"mjw\",\"mjx\",\"mjy\",\"mjz\",\"mka\",\"mkb\",\"mkc\",\"mke\",\"mkf\",\"mkg\",\"mkh\",\"mki\",\"mkj\",\"mkk\",\"mkl\",\"mkm\",\"mkn\",\"mko\",\"mkp\",\"mkq\",\"mkr\",\"mks\",\"mkt\",\"mku\",\"mkv\",\"mkw\",\"mkx\",\"mky\",\"mkz\",\"mla\",\"mlb\",\"mlc\",\"mld\",\"mle\",\"mlf\",\"mlh\",\"mli\",\"mlj\",\"mlk\",\"mll\",\"mlm\",\"mln\",\"mlo\",\"mlp\",\"mlq\",\"mlr\",\"mls\",\"mlu\",\"mlv\",\"mlw\",\"mlx\",\"mlz\",\"mma\",\"mmb\",\"mmc\",\"mmd\",\"mme\",\"mmf\",\"mmg\",\"mmh\",\"mmi\",\"mmj\",\"mmk\",\"mml\",\"mmm\",\"mmn\",\"mmo\",\"mmp\",\"mmq\",\"mmr\",\"mmt\",\"mmu\",\"mmv\",\"mmw\",\"mmx\",\"mmy\",\"mmz\",\"mna\",\"mnb\",\"mnc\",\"mnd\",\"mne\",\"mnf\",\"mng\",\"mnh\",\"mni\",\"mnj\",\"mnk\",\"mnl\",\"mnm\",\"mnn\",\"mno\",\"mnp\",\"mnq\",\"mnr\",\"mns\",\"mnt\",\"mnu\",\"mnv\",\"mnw\",\"mnx\",\"mny\",\"mnz\",\"moa\",\"moc\",\"mod\",\"moe\",\"mof\",\"mog\",\"moh\",\"moi\",\"moj\",\"mok\",\"mom\",\"moo\",\"mop\",\"moq\",\"mor\",\"mos\",\"mot\",\"mou\",\"mov\",\"mow\",\"mox\",\"moy\",\"moz\",\"mpa\",\"mpb\",\"mpc\",\"mpd\",\"mpe\",\"mpg\",\"mph\",\"mpi\",\"mpj\",\"mpk\",\"mpl\",\"mpm\",\"mpn\",\"mpo\",\"mpp\",\"mpq\",\"mpr\",\"mps\",\"mpt\",\"mpu\",\"mpv\",\"mpw\",\"mpx\",\"mpy\",\"mpz\",\"mqa\",\"mqb\",\"mqc\",\"mqe\",\"mqf\",\"mqg\",\"mqh\",\"mqi\",\"mqj\",\"mqk\",\"mql\",\"mqm\",\"mqn\",\"mqo\",\"mqp\",\"mqq\",\"mqr\",\"mqs\",\"mqt\",\"mqu\",\"mqv\",\"mqw\",\"mqx\",\"mqy\",\"mqz\",\"mra\",\"mrb\",\"mrc\",\"mrd\",\"mre\",\"mrf\",\"mrg\",\"mrh\",\"mrj\",\"mrk\",\"mrl\",\"mrm\",\"mrn\",\"mro\",\"mrp\",\"mrq\",\"mrr\",\"mrs\",\"mrt\",\"mru\",\"mrv\",\"mrw\",\"mrx\",\"mry\",\"mrz\",\"msb\",\"msc\",\"msd\",\"mse\",\"msf\",\"msg\",\"msh\",\"msi\",\"msj\",\"msk\",\"msl\",\"msm\",\"msn\",\"mso\",\"msp\",\"msq\",\"msr\",\"mss\",\"mst\",\"msu\",\"msv\",\"msw\",\"msx\",\"msy\",\"msz\",\"mta\",\"mtb\",\"mtc\",\"mtd\",\"mte\",\"mtf\",\"mtg\",\"mth\",\"mti\",\"mtj\",\"mtk\",\"mtl\",\"mtm\",\"mtn\",\"mto\",\"mtp\",\"mtq\",\"mtr\",\"mts\",\"mtt\",\"mtu\",\"mtv\",\"mtw\",\"mtx\",\"mty\",\"mua\",\"mub\",\"muc\",\"mud\",\"mue\",\"mug\",\"muh\",\"mui\",\"muj\",\"muk\",\"mul\",\"mum\",\"mun\",\"muo\",\"mup\",\"muq\",\"mur\",\"mus\",\"mut\",\"muu\",\"muv\",\"mux\",\"muy\",\"muz\",\"mva\",\"mvb\",\"mvd\",\"mve\",\"mvf\",\"mvg\",\"mvh\",\"mvi\",\"mvk\",\"mvl\",\"mvm\",\"mvn\",\"mvo\",\"mvp\",\"mvq\",\"mvr\",\"mvs\",\"mvt\",\"mvu\",\"mvv\",\"mvw\",\"mvx\",\"mvy\",\"mvz\",\"mwa\",\"mwb\",\"mwc\",\"mwd\",\"mwe\",\"mwf\",\"mwg\",\"mwh\",\"mwi\",\"mwj\",\"mwk\",\"mwl\",\"mwm\",\"mwn\",\"mwo\",\"mwp\",\"mwq\",\"mwr\",\"mws\",\"mwt\",\"mwu\",\"mwv\",\"mww\",\"mwx\",\"mwy\",\"mwz\",\"mxa\",\"mxb\",\"mxc\",\"mxd\",\"mxe\",\"mxf\",\"mxg\",\"mxh\",\"mxi\",\"mxj\",\"mxk\",\"mxl\",\"mxm\",\"mxn\",\"mxo\",\"mxp\",\"mxq\",\"mxr\",\"mxs\",\"mxt\",\"mxu\",\"mxv\",\"mxw\",\"mxx\",\"mxy\",\"mxz\",\"myb\",\"myc\",\"myd\",\"mye\",\"myf\",\"myg\",\"myh\",\"myi\",\"myj\",\"myk\",\"myl\",\"mym\",\"myn\",\"myo\",\"myp\",\"myq\",\"myr\",\"mys\",\"myt\",\"myu\",\"myv\",\"myw\",\"myx\",\"myy\",\"myz\",\"mza\",\"mzb\",\"mzc\",\"mzd\",\"mze\",\"mzg\",\"mzh\",\"mzi\",\"mzj\",\"mzk\",\"mzl\",\"mzm\",\"mzn\",\"mzo\",\"mzp\",\"mzq\",\"mzr\",\"mzs\",\"mzt\",\"mzu\",\"mzv\",\"mzw\",\"mzx\",\"mzy\",\"mzz\",\"naa\",\"nab\",\"nac\",\"nad\",\"nae\",\"naf\",\"nag\",\"nah\",\"nai\",\"naj\",\"nak\",\"nal\",\"nam\",\"nan\",\"nao\",\"nap\",\"naq\",\"nar\",\"nas\",\"nat\",\"naw\",\"nax\",\"nay\",\"naz\",\"nba\",\"nbb\",\"nbc\",\"nbd\",\"nbe\",\"nbf\",\"nbg\",\"nbh\",\"nbi\",\"nbj\",\"nbk\",\"nbm\",\"nbn\",\"nbo\",\"nbp\",\"nbq\",\"nbr\",\"nbs\",\"nbt\",\"nbu\",\"nbv\",\"nbw\",\"nbx\",\"nby\",\"nca\",\"ncb\",\"ncc\",\"ncd\",\"nce\",\"ncf\",\"ncg\",\"nch\",\"nci\",\"ncj\",\"nck\",\"ncl\",\"ncm\",\"ncn\",\"nco\",\"ncp\",\"ncr\",\"ncs\",\"nct\",\"ncu\",\"ncx\",\"ncz\",\"nda\",\"ndb\",\"ndc\",\"ndd\",\"ndf\",\"ndg\",\"ndh\",\"ndi\",\"ndj\",\"ndk\",\"ndl\",\"ndm\",\"ndn\",\"ndp\",\"ndq\",\"ndr\",\"nds\",\"ndt\",\"ndu\",\"ndv\",\"ndw\",\"ndx\",\"ndy\",\"ndz\",\"nea\",\"neb\",\"nec\",\"ned\",\"nee\",\"nef\",\"neg\",\"neh\",\"nei\",\"nej\",\"nek\",\"nem\",\"nen\",\"neo\",\"neq\",\"ner\",\"nes\",\"net\",\"neu\",\"nev\",\"new\",\"nex\",\"ney\",\"nez\",\"nfa\",\"nfd\",\"nfl\",\"nfr\",\"nfu\",\"nga\",\"ngb\",\"ngc\",\"ngd\",\"nge\",\"ngf\",\"ngg\",\"ngh\",\"ngi\",\"ngj\",\"ngk\",\"ngl\",\"ngm\",\"ngn\",\"ngo\",\"ngp\",\"ngq\",\"ngr\",\"ngs\",\"ngt\",\"ngu\",\"ngv\",\"ngw\",\"ngx\",\"ngy\",\"ngz\",\"nha\",\"nhb\",\"nhc\",\"nhd\",\"nhe\",\"nhf\",\"nhg\",\"nhh\",\"nhi\",\"nhk\",\"nhm\",\"nhn\",\"nho\",\"nhp\",\"nhq\",\"nhr\",\"nht\",\"nhu\",\"nhv\",\"nhw\",\"nhx\",\"nhy\",\"nhz\",\"nia\",\"nib\",\"nic\",\"nid\",\"nie\",\"nif\",\"nig\",\"nih\",\"nii\",\"nij\",\"nik\",\"nil\",\"nim\",\"nin\",\"nio\",\"niq\",\"nir\",\"nis\",\"nit\",\"niu\",\"niv\",\"niw\",\"nix\",\"niy\",\"niz\",\"nja\",\"njb\",\"njd\",\"njh\",\"nji\",\"njj\",\"njl\",\"njm\",\"njn\",\"njo\",\"njr\",\"njs\",\"njt\",\"nju\",\"njx\",\"njy\",\"njz\",\"nka\",\"nkb\",\"nkc\",\"nkd\",\"nke\",\"nkf\",\"nkg\",\"nkh\",\"nki\",\"nkj\",\"nkk\",\"nkm\",\"nkn\",\"nko\",\"nkp\",\"nkq\",\"nkr\",\"nks\",\"nkt\",\"nku\",\"nkv\",\"nkw\",\"nkx\",\"nkz\",\"nla\",\"nlc\",\"nle\",\"nlg\",\"nli\",\"nlj\",\"nlk\",\"nll\",\"nln\",\"nlo\",\"nlq\",\"nlr\",\"nlu\",\"nlv\",\"nlw\",\"nlx\",\"nly\",\"nlz\",\"nma\",\"nmb\",\"nmc\",\"nmd\",\"nme\",\"nmf\",\"nmg\",\"nmh\",\"nmi\",\"nmj\",\"nmk\",\"nml\",\"nmm\",\"nmn\",\"nmo\",\"nmp\",\"nmq\",\"nmr\",\"nms\",\"nmt\",\"nmu\",\"nmv\",\"nmw\",\"nmx\",\"nmy\",\"nmz\",\"nna\",\"nnb\",\"nnc\",\"nnd\",\"nne\",\"nnf\",\"nng\",\"nnh\",\"nni\",\"nnj\",\"nnk\",\"nnl\",\"nnm\",\"nnn\",\"nnp\",\"nnq\",\"nnr\",\"nns\",\"nnt\",\"nnu\",\"nnv\",\"nnw\",\"nnx\",\"nny\",\"nnz\",\"noa\",\"noc\",\"nod\",\"noe\",\"nof\",\"nog\",\"noh\",\"noi\",\"noj\",\"nok\",\"nol\",\"nom\",\"non\",\"noo\",\"nop\",\"noq\",\"nos\",\"not\",\"nou\",\"nov\",\"now\",\"noy\",\"noz\",\"npa\",\"npb\",\"npg\",\"nph\",\"npi\",\"npl\",\"npn\",\"npo\",\"nps\",\"npu\",\"npy\",\"nqg\",\"nqk\",\"nqm\",\"nqn\",\"nqo\",\"nqq\",\"nqy\",\"nra\",\"nrb\",\"nrc\",\"nre\",\"nrf\",\"nrg\",\"nri\",\"nrk\",\"nrl\",\"nrm\",\"nrn\",\"nrp\",\"nrr\",\"nrt\",\"nru\",\"nrx\",\"nrz\",\"nsa\",\"nsc\",\"nsd\",\"nse\",\"nsf\",\"nsg\",\"nsh\",\"nsi\",\"nsk\",\"nsl\",\"nsm\",\"nsn\",\"nso\",\"nsp\",\"nsq\",\"nsr\",\"nss\",\"nst\",\"nsu\",\"nsv\",\"nsw\",\"nsx\",\"nsy\",\"nsz\",\"ntd\",\"nte\",\"ntg\",\"nti\",\"ntj\",\"ntk\",\"ntm\",\"nto\",\"ntp\",\"ntr\",\"nts\",\"ntu\",\"ntw\",\"ntx\",\"nty\",\"ntz\",\"nua\",\"nub\",\"nuc\",\"nud\",\"nue\",\"nuf\",\"nug\",\"nuh\",\"nui\",\"nuj\",\"nuk\",\"nul\",\"num\",\"nun\",\"nuo\",\"nup\",\"nuq\",\"nur\",\"nus\",\"nut\",\"nuu\",\"nuv\",\"nuw\",\"nux\",\"nuy\",\"nuz\",\"nvh\",\"nvm\",\"nvo\",\"nwa\",\"nwb\",\"nwc\",\"nwe\",\"nwg\",\"nwi\",\"nwm\",\"nwo\",\"nwr\",\"nwx\",\"nwy\",\"nxa\",\"nxd\",\"nxe\",\"nxg\",\"nxi\",\"nxk\",\"nxl\",\"nxm\",\"nxn\",\"nxo\",\"nxq\",\"nxr\",\"nxu\",\"nxx\",\"nyb\",\"nyc\",\"nyd\",\"nye\",\"nyf\",\"nyg\",\"nyh\",\"nyi\",\"nyj\",\"nyk\",\"nyl\",\"nym\",\"nyn\",\"nyo\",\"nyp\",\"nyq\",\"nyr\",\"nys\",\"nyt\",\"nyu\",\"nyv\",\"nyw\",\"nyx\",\"nyy\",\"nza\",\"nzb\",\"nzi\",\"nzk\",\"nzm\",\"nzs\",\"nzu\",\"nzy\",\"nzz\",\"oaa\",\"oac\",\"oar\",\"oav\",\"obi\",\"obk\",\"obl\",\"obm\",\"obo\",\"obr\",\"obt\",\"obu\",\"oca\",\"och\",\"oco\",\"ocu\",\"oda\",\"odk\",\"odt\",\"odu\",\"ofo\",\"ofs\",\"ofu\",\"ogb\",\"ogc\",\"oge\",\"ogg\",\"ogo\",\"ogu\",\"oht\",\"ohu\",\"oia\",\"oin\",\"ojb\",\"ojc\",\"ojg\",\"ojp\",\"ojs\",\"ojv\",\"ojw\",\"oka\",\"okb\",\"okd\",\"oke\",\"okg\",\"okh\",\"oki\",\"okj\",\"okk\",\"okl\",\"okm\",\"okn\",\"oko\",\"okr\",\"oks\",\"oku\",\"okv\",\"okx\",\"ola\",\"old\",\"ole\",\"olk\",\"olm\",\"olo\",\"olr\",\"olt\",\"olu\",\"oma\",\"omb\",\"omc\",\"ome\",\"omg\",\"omi\",\"omk\",\"oml\",\"omn\",\"omo\",\"omp\",\"omq\",\"omr\",\"omt\",\"omu\",\"omv\",\"omw\",\"omx\",\"ona\",\"onb\",\"one\",\"ong\",\"oni\",\"onj\",\"onk\",\"onn\",\"ono\",\"onp\",\"onr\",\"ons\",\"ont\",\"onu\",\"onw\",\"onx\",\"ood\",\"oog\",\"oon\",\"oor\",\"oos\",\"opa\",\"opk\",\"opm\",\"opo\",\"opt\",\"opy\",\"ora\",\"orc\",\"ore\",\"org\",\"orh\",\"orn\",\"oro\",\"orr\",\"ors\",\"ort\",\"oru\",\"orv\",\"orw\",\"orx\",\"ory\",\"orz\",\"osa\",\"osc\",\"osi\",\"oso\",\"osp\",\"ost\",\"osu\",\"osx\",\"ota\",\"otb\",\"otd\",\"ote\",\"oti\",\"otk\",\"otl\",\"otm\",\"otn\",\"oto\",\"otq\",\"otr\",\"ots\",\"ott\",\"otu\",\"otw\",\"otx\",\"oty\",\"otz\",\"oua\",\"oub\",\"oue\",\"oui\",\"oum\",\"oun\",\"ovd\",\"owi\",\"owl\",\"oyb\",\"oyd\",\"oym\",\"oyy\",\"ozm\",\"paa\",\"pab\",\"pac\",\"pad\",\"pae\",\"paf\",\"pag\",\"pah\",\"pai\",\"pak\",\"pal\",\"pam\",\"pao\",\"pap\",\"paq\",\"par\",\"pas\",\"pat\",\"pau\",\"pav\",\"paw\",\"pax\",\"pay\",\"paz\",\"pbb\",\"pbc\",\"pbe\",\"pbf\",\"pbg\",\"pbh\",\"pbi\",\"pbl\",\"pbn\",\"pbo\",\"pbp\",\"pbr\",\"pbs\",\"pbt\",\"pbu\",\"pbv\",\"pby\",\"pbz\",\"pca\",\"pcb\",\"pcc\",\"pcd\",\"pce\",\"pcf\",\"pcg\",\"pch\",\"pci\",\"pcj\",\"pck\",\"pcl\",\"pcm\",\"pcn\",\"pcp\",\"pcr\",\"pcw\",\"pda\",\"pdc\",\"pdi\",\"pdn\",\"pdo\",\"pdt\",\"pdu\",\"pea\",\"peb\",\"ped\",\"pee\",\"pef\",\"peg\",\"peh\",\"pei\",\"pej\",\"pek\",\"pel\",\"pem\",\"peo\",\"pep\",\"peq\",\"pes\",\"pev\",\"pex\",\"pey\",\"pez\",\"pfa\",\"pfe\",\"pfl\",\"pga\",\"pgd\",\"pgg\",\"pgi\",\"pgk\",\"pgl\",\"pgn\",\"pgs\",\"pgu\",\"pgy\",\"pgz\",\"pha\",\"phd\",\"phg\",\"phh\",\"phi\",\"phk\",\"phl\",\"phm\",\"phn\",\"pho\",\"phq\",\"phr\",\"pht\",\"phu\",\"phv\",\"phw\",\"pia\",\"pib\",\"pic\",\"pid\",\"pie\",\"pif\",\"pig\",\"pih\",\"pii\",\"pij\",\"pil\",\"pim\",\"pin\",\"pio\",\"pip\",\"pir\",\"pis\",\"pit\",\"piu\",\"piv\",\"piw\",\"pix\",\"piy\",\"piz\",\"pjt\",\"pka\",\"pkb\",\"pkc\",\"pkg\",\"pkh\",\"pkn\",\"pko\",\"pkp\",\"pkr\",\"pks\",\"pkt\",\"pku\",\"pla\",\"plb\",\"plc\",\"pld\",\"ple\",\"plf\",\"plg\",\"plh\",\"plj\",\"plk\",\"pll\",\"pln\",\"plo\",\"plp\",\"plq\",\"plr\",\"pls\",\"plt\",\"plu\",\"plv\",\"plw\",\"ply\",\"plz\",\"pma\",\"pmb\",\"pmc\",\"pmd\",\"pme\",\"pmf\",\"pmh\",\"pmi\",\"pmj\",\"pmk\",\"pml\",\"pmm\",\"pmn\",\"pmo\",\"pmq\",\"pmr\",\"pms\",\"pmt\",\"pmu\",\"pmw\",\"pmx\",\"pmy\",\"pmz\",\"pna\",\"pnb\",\"pnc\",\"pne\",\"png\",\"pnh\",\"pni\",\"pnj\",\"pnk\",\"pnl\",\"pnm\",\"pnn\",\"pno\",\"pnp\",\"pnq\",\"pnr\",\"pns\",\"pnt\",\"pnu\",\"pnv\",\"pnw\",\"pnx\",\"pny\",\"pnz\",\"poc\",\"pod\",\"poe\",\"pof\",\"pog\",\"poh\",\"poi\",\"pok\",\"pom\",\"pon\",\"poo\",\"pop\",\"poq\",\"pos\",\"pot\",\"pov\",\"pow\",\"pox\",\"poy\",\"poz\",\"ppa\",\"ppe\",\"ppi\",\"ppk\",\"ppl\",\"ppm\",\"ppn\",\"ppo\",\"ppp\",\"ppq\",\"ppr\",\"pps\",\"ppt\",\"ppu\",\"pqa\",\"pqe\",\"pqm\",\"pqw\",\"pra\",\"prb\",\"prc\",\"prd\",\"pre\",\"prf\",\"prg\",\"prh\",\"pri\",\"prk\",\"prl\",\"prm\",\"prn\",\"pro\",\"prp\",\"prq\",\"prr\",\"prs\",\"prt\",\"pru\",\"prw\",\"prx\",\"pry\",\"prz\",\"psa\",\"psc\",\"psd\",\"pse\",\"psg\",\"psh\",\"psi\",\"psl\",\"psm\",\"psn\",\"pso\",\"psp\",\"psq\",\"psr\",\"pss\",\"pst\",\"psu\",\"psw\",\"psy\",\"pta\",\"pth\",\"pti\",\"ptn\",\"pto\",\"ptp\",\"ptq\",\"ptr\",\"ptt\",\"ptu\",\"ptv\",\"ptw\",\"pty\",\"pua\",\"pub\",\"puc\",\"pud\",\"pue\",\"puf\",\"pug\",\"pui\",\"puj\",\"puk\",\"pum\",\"puo\",\"pup\",\"puq\",\"pur\",\"put\",\"puu\",\"puw\",\"pux\",\"puy\",\"puz\",\"pwa\",\"pwb\",\"pwg\",\"pwi\",\"pwm\",\"pwn\",\"pwo\",\"pwr\",\"pww\",\"pxm\",\"pye\",\"pym\",\"pyn\",\"pys\",\"pyu\",\"pyx\",\"pyy\",\"pzn\",\"qaa..qtz\",\"qua\",\"qub\",\"quc\",\"qud\",\"quf\",\"qug\",\"quh\",\"qui\",\"quk\",\"qul\",\"qum\",\"qun\",\"qup\",\"quq\",\"qur\",\"qus\",\"quv\",\"quw\",\"qux\",\"quy\",\"quz\",\"qva\",\"qvc\",\"qve\",\"qvh\",\"qvi\",\"qvj\",\"qvl\",\"qvm\",\"qvn\",\"qvo\",\"qvp\",\"qvs\",\"qvw\",\"qvy\",\"qvz\",\"qwa\",\"qwc\",\"qwe\",\"qwh\",\"qwm\",\"qws\",\"qwt\",\"qxa\",\"qxc\",\"qxh\",\"qxl\",\"qxn\",\"qxo\",\"qxp\",\"qxq\",\"qxr\",\"qxs\",\"qxt\",\"qxu\",\"qxw\",\"qya\",\"qyp\",\"raa\",\"rab\",\"rac\",\"rad\",\"raf\",\"rag\",\"rah\",\"rai\",\"raj\",\"rak\",\"ral\",\"ram\",\"ran\",\"rao\",\"rap\",\"raq\",\"rar\",\"ras\",\"rat\",\"rau\",\"rav\",\"raw\",\"rax\",\"ray\",\"raz\",\"rbb\",\"rbk\",\"rbl\",\"rbp\",\"rcf\",\"rdb\",\"rea\",\"reb\",\"ree\",\"reg\",\"rei\",\"rej\",\"rel\",\"rem\",\"ren\",\"rer\",\"res\",\"ret\",\"rey\",\"rga\",\"rge\",\"rgk\",\"rgn\",\"rgr\",\"rgs\",\"rgu\",\"rhg\",\"rhp\",\"ria\",\"rie\",\"rif\",\"ril\",\"rim\",\"rin\",\"rir\",\"rit\",\"riu\",\"rjg\",\"rji\",\"rjs\",\"rka\",\"rkb\",\"rkh\",\"rki\",\"rkm\",\"rkt\",\"rkw\",\"rma\",\"rmb\",\"rmc\",\"rmd\",\"rme\",\"rmf\",\"rmg\",\"rmh\",\"rmi\",\"rmk\",\"rml\",\"rmm\",\"rmn\",\"rmo\",\"rmp\",\"rmq\",\"rmr\",\"rms\",\"rmt\",\"rmu\",\"rmv\",\"rmw\",\"rmx\",\"rmy\",\"rmz\",\"rna\",\"rnd\",\"rng\",\"rnl\",\"rnn\",\"rnp\",\"rnr\",\"rnw\",\"roa\",\"rob\",\"roc\",\"rod\",\"roe\",\"rof\",\"rog\",\"rol\",\"rom\",\"roo\",\"rop\",\"ror\",\"rou\",\"row\",\"rpn\",\"rpt\",\"rri\",\"rro\",\"rrt\",\"rsb\",\"rsi\",\"rsl\",\"rsm\",\"rtc\",\"rth\",\"rtm\",\"rts\",\"rtw\",\"rub\",\"ruc\",\"rue\",\"ruf\",\"rug\",\"ruh\",\"rui\",\"ruk\",\"ruo\",\"rup\",\"ruq\",\"rut\",\"ruu\",\"ruy\",\"ruz\",\"rwa\",\"rwk\",\"rwm\",\"rwo\",\"rwr\",\"rxd\",\"rxw\",\"ryn\",\"rys\",\"ryu\",\"rzh\",\"saa\",\"sab\",\"sac\",\"sad\",\"sae\",\"saf\",\"sah\",\"sai\",\"saj\",\"sak\",\"sal\",\"sam\",\"sao\",\"sap\",\"saq\",\"sar\",\"sas\",\"sat\",\"sau\",\"sav\",\"saw\",\"sax\",\"say\",\"saz\",\"sba\",\"sbb\",\"sbc\",\"sbd\",\"sbe\",\"sbf\",\"sbg\",\"sbh\",\"sbi\",\"sbj\",\"sbk\",\"sbl\",\"sbm\",\"sbn\",\"sbo\",\"sbp\",\"sbq\",\"sbr\",\"sbs\",\"sbt\",\"sbu\",\"sbv\",\"sbw\",\"sbx\",\"sby\",\"sbz\",\"sca\",\"scb\",\"sce\",\"scf\",\"scg\",\"sch\",\"sci\",\"sck\",\"scl\",\"scn\",\"sco\",\"scp\",\"scq\",\"scs\",\"scu\",\"scv\",\"scw\",\"scx\",\"sda\",\"sdb\",\"sdc\",\"sde\",\"sdf\",\"sdg\",\"sdh\",\"sdj\",\"sdk\",\"sdl\",\"sdm\",\"sdn\",\"sdo\",\"sdp\",\"sdr\",\"sds\",\"sdt\",\"sdu\",\"sdv\",\"sdx\",\"sdz\",\"sea\",\"seb\",\"sec\",\"sed\",\"see\",\"sef\",\"seg\",\"seh\",\"sei\",\"sej\",\"sek\",\"sel\",\"sem\",\"sen\",\"seo\",\"sep\",\"seq\",\"ser\",\"ses\",\"set\",\"seu\",\"sev\",\"sew\",\"sey\",\"sez\",\"sfb\",\"sfe\",\"sfm\",\"sfs\",\"sfw\",\"sga\",\"sgb\",\"sgc\",\"sgd\",\"sge\",\"sgg\",\"sgh\",\"sgi\",\"sgj\",\"sgk\",\"sgl\",\"sgm\",\"sgn\",\"sgo\",\"sgp\",\"sgr\",\"sgs\",\"sgt\",\"sgu\",\"sgw\",\"sgx\",\"sgy\",\"sgz\",\"sha\",\"shb\",\"shc\",\"shd\",\"she\",\"shg\",\"shh\",\"shi\",\"shj\",\"shk\",\"shl\",\"shm\",\"shn\",\"sho\",\"shp\",\"shq\",\"shr\",\"shs\",\"sht\",\"shu\",\"shv\",\"shw\",\"shx\",\"shy\",\"shz\",\"sia\",\"sib\",\"sid\",\"sie\",\"sif\",\"sig\",\"sih\",\"sii\",\"sij\",\"sik\",\"sil\",\"sim\",\"sio\",\"sip\",\"siq\",\"sir\",\"sis\",\"sit\",\"siu\",\"siv\",\"siw\",\"six\",\"siy\",\"siz\",\"sja\",\"sjb\",\"sjd\",\"sje\",\"sjg\",\"sjk\",\"sjl\",\"sjm\",\"sjn\",\"sjo\",\"sjp\",\"sjr\",\"sjs\",\"sjt\",\"sju\",\"sjw\",\"ska\",\"skb\",\"skc\",\"skd\",\"ske\",\"skf\",\"skg\",\"skh\",\"ski\",\"skj\",\"skk\",\"skm\",\"skn\",\"sko\",\"skp\",\"skq\",\"skr\",\"sks\",\"skt\",\"sku\",\"skv\",\"skw\",\"skx\",\"sky\",\"skz\",\"sla\",\"slc\",\"sld\",\"sle\",\"slf\",\"slg\",\"slh\",\"sli\",\"slj\",\"sll\",\"slm\",\"sln\",\"slp\",\"slq\",\"slr\",\"sls\",\"slt\",\"slu\",\"slw\",\"slx\",\"sly\",\"slz\",\"sma\",\"smb\",\"smc\",\"smd\",\"smf\",\"smg\",\"smh\",\"smi\",\"smj\",\"smk\",\"sml\",\"smm\",\"smn\",\"smp\",\"smq\",\"smr\",\"sms\",\"smt\",\"smu\",\"smv\",\"smw\",\"smx\",\"smy\",\"smz\",\"snb\",\"snc\",\"sne\",\"snf\",\"sng\",\"snh\",\"sni\",\"snj\",\"snk\",\"snl\",\"snm\",\"snn\",\"sno\",\"snp\",\"snq\",\"snr\",\"sns\",\"snu\",\"snv\",\"snw\",\"snx\",\"sny\",\"snz\",\"soa\",\"sob\",\"soc\",\"sod\",\"soe\",\"sog\",\"soh\",\"soi\",\"soj\",\"sok\",\"sol\",\"son\",\"soo\",\"sop\",\"soq\",\"sor\",\"sos\",\"sou\",\"sov\",\"sow\",\"sox\",\"soy\",\"soz\",\"spb\",\"spc\",\"spd\",\"spe\",\"spg\",\"spi\",\"spk\",\"spl\",\"spm\",\"spn\",\"spo\",\"spp\",\"spq\",\"spr\",\"sps\",\"spt\",\"spu\",\"spv\",\"spx\",\"spy\",\"sqa\",\"sqh\",\"sqj\",\"sqk\",\"sqm\",\"sqn\",\"sqo\",\"sqq\",\"sqr\",\"sqs\",\"sqt\",\"squ\",\"sra\",\"srb\",\"src\",\"sre\",\"srf\",\"srg\",\"srh\",\"sri\",\"srk\",\"srl\",\"srm\",\"srn\",\"sro\",\"srq\",\"srr\",\"srs\",\"srt\",\"sru\",\"srv\",\"srw\",\"srx\",\"sry\",\"srz\",\"ssa\",\"ssb\",\"ssc\",\"ssd\",\"sse\",\"ssf\",\"ssg\",\"ssh\",\"ssi\",\"ssj\",\"ssk\",\"ssl\",\"ssm\",\"ssn\",\"sso\",\"ssp\",\"ssq\",\"ssr\",\"sss\",\"sst\",\"ssu\",\"ssv\",\"ssx\",\"ssy\",\"ssz\",\"sta\",\"stb\",\"std\",\"ste\",\"stf\",\"stg\",\"sth\",\"sti\",\"stj\",\"stk\",\"stl\",\"stm\",\"stn\",\"sto\",\"stp\",\"stq\",\"str\",\"sts\",\"stt\",\"stu\",\"stv\",\"stw\",\"sty\",\"sua\",\"sub\",\"suc\",\"sue\",\"sug\",\"sui\",\"suj\",\"suk\",\"sul\",\"sum\",\"suq\",\"sur\",\"sus\",\"sut\",\"suv\",\"suw\",\"sux\",\"suy\",\"suz\",\"sva\",\"svb\",\"svc\",\"sve\",\"svk\",\"svm\",\"svr\",\"svs\",\"svx\",\"swb\",\"swc\",\"swf\",\"swg\",\"swh\",\"swi\",\"swj\",\"swk\",\"swl\",\"swm\",\"swn\",\"swo\",\"swp\",\"swq\",\"swr\",\"sws\",\"swt\",\"swu\",\"swv\",\"sww\",\"swx\",\"swy\",\"sxb\",\"sxc\",\"sxe\",\"sxg\",\"sxk\",\"sxl\",\"sxm\",\"sxn\",\"sxo\",\"sxr\",\"sxs\",\"sxu\",\"sxw\",\"sya\",\"syb\",\"syc\",\"syd\",\"syi\",\"syk\",\"syl\",\"sym\",\"syn\",\"syo\",\"syr\",\"sys\",\"syw\",\"syx\",\"syy\",\"sza\",\"szb\",\"szc\",\"szd\",\"sze\",\"szg\",\"szl\",\"szn\",\"szp\",\"szv\",\"szw\",\"taa\",\"tab\",\"tac\",\"tad\",\"tae\",\"taf\",\"tag\",\"tai\",\"taj\",\"tak\",\"tal\",\"tan\",\"tao\",\"tap\",\"taq\",\"tar\",\"tas\",\"tau\",\"tav\",\"taw\",\"tax\",\"tay\",\"taz\",\"tba\",\"tbb\",\"tbc\",\"tbd\",\"tbe\",\"tbf\",\"tbg\",\"tbh\",\"tbi\",\"tbj\",\"tbk\",\"tbl\",\"tbm\",\"tbn\",\"tbo\",\"tbp\",\"tbq\",\"tbr\",\"tbs\",\"tbt\",\"tbu\",\"tbv\",\"tbw\",\"tbx\",\"tby\",\"tbz\",\"tca\",\"tcb\",\"tcc\",\"tcd\",\"tce\",\"tcf\",\"tcg\",\"tch\",\"tci\",\"tck\",\"tcl\",\"tcm\",\"tcn\",\"tco\",\"tcp\",\"tcq\",\"tcs\",\"tct\",\"tcu\",\"tcw\",\"tcx\",\"tcy\",\"tcz\",\"tda\",\"tdb\",\"tdc\",\"tdd\",\"tde\",\"tdf\",\"tdg\",\"tdh\",\"tdi\",\"tdj\",\"tdk\",\"tdl\",\"tdm\",\"tdn\",\"tdo\",\"tdq\",\"tdr\",\"tds\",\"tdt\",\"tdu\",\"tdv\",\"tdx\",\"tdy\",\"tea\",\"teb\",\"tec\",\"ted\",\"tee\",\"tef\",\"teg\",\"teh\",\"tei\",\"tek\",\"tem\",\"ten\",\"teo\",\"tep\",\"teq\",\"ter\",\"tes\",\"tet\",\"teu\",\"tev\",\"tew\",\"tex\",\"tey\",\"tfi\",\"tfn\",\"tfo\",\"tfr\",\"tft\",\"tga\",\"tgb\",\"tgc\",\"tgd\",\"tge\",\"tgf\",\"tgg\",\"tgh\",\"tgi\",\"tgj\",\"tgn\",\"tgo\",\"tgp\",\"tgq\",\"tgr\",\"tgs\",\"tgt\",\"tgu\",\"tgv\",\"tgw\",\"tgx\",\"tgy\",\"tgz\",\"thc\",\"thd\",\"the\",\"thf\",\"thh\",\"thi\",\"thk\",\"thl\",\"thm\",\"thn\",\"thp\",\"thq\",\"thr\",\"ths\",\"tht\",\"thu\",\"thv\",\"thw\",\"thx\",\"thy\",\"thz\",\"tia\",\"tic\",\"tid\",\"tie\",\"tif\",\"tig\",\"tih\",\"tii\",\"tij\",\"tik\",\"til\",\"tim\",\"tin\",\"tio\",\"tip\",\"tiq\",\"tis\",\"tit\",\"tiu\",\"tiv\",\"tiw\",\"tix\",\"tiy\",\"tiz\",\"tja\",\"tjg\",\"tji\",\"tjl\",\"tjm\",\"tjn\",\"tjo\",\"tjs\",\"tju\",\"tjw\",\"tka\",\"tkb\",\"tkd\",\"tke\",\"tkf\",\"tkg\",\"tkk\",\"tkl\",\"tkm\",\"tkn\",\"tkp\",\"tkq\",\"tkr\",\"tks\",\"tkt\",\"tku\",\"tkv\",\"tkw\",\"tkx\",\"tkz\",\"tla\",\"tlb\",\"tlc\",\"tld\",\"tlf\",\"tlg\",\"tlh\",\"tli\",\"tlj\",\"tlk\",\"tll\",\"tlm\",\"tln\",\"tlo\",\"tlp\",\"tlq\",\"tlr\",\"tls\",\"tlt\",\"tlu\",\"tlv\",\"tlw\",\"tlx\",\"tly\",\"tma\",\"tmb\",\"tmc\",\"tmd\",\"tme\",\"tmf\",\"tmg\",\"tmh\",\"tmi\",\"tmj\",\"tmk\",\"tml\",\"tmm\",\"tmn\",\"tmo\",\"tmp\",\"tmq\",\"tmr\",\"tms\",\"tmt\",\"tmu\",\"tmv\",\"tmw\",\"tmy\",\"tmz\",\"tna\",\"tnb\",\"tnc\",\"tnd\",\"tne\",\"tnf\",\"tng\",\"tnh\",\"tni\",\"tnk\",\"tnl\",\"tnm\",\"tnn\",\"tno\",\"tnp\",\"tnq\",\"tnr\",\"tns\",\"tnt\",\"tnu\",\"tnv\",\"tnw\",\"tnx\",\"tny\",\"tnz\",\"tob\",\"toc\",\"tod\",\"toe\",\"tof\",\"tog\",\"toh\",\"toi\",\"toj\",\"tol\",\"tom\",\"too\",\"top\",\"toq\",\"tor\",\"tos\",\"tou\",\"tov\",\"tow\",\"tox\",\"toy\",\"toz\",\"tpa\",\"tpc\",\"tpe\",\"tpf\",\"tpg\",\"tpi\",\"tpj\",\"tpk\",\"tpl\",\"tpm\",\"tpn\",\"tpo\",\"tpp\",\"tpq\",\"tpr\",\"tpt\",\"tpu\",\"tpv\",\"tpw\",\"tpx\",\"tpy\",\"tpz\",\"tqb\",\"tql\",\"tqm\",\"tqn\",\"tqo\",\"tqp\",\"tqq\",\"tqr\",\"tqt\",\"tqu\",\"tqw\",\"tra\",\"trb\",\"trc\",\"trd\",\"tre\",\"trf\",\"trg\",\"trh\",\"tri\",\"trj\",\"trk\",\"trl\",\"trm\",\"trn\",\"tro\",\"trp\",\"trq\",\"trr\",\"trs\",\"trt\",\"tru\",\"trv\",\"trw\",\"trx\",\"try\",\"trz\",\"tsa\",\"tsb\",\"tsc\",\"tsd\",\"tse\",\"tsf\",\"tsg\",\"tsh\",\"tsi\",\"tsj\",\"tsk\",\"tsl\",\"tsm\",\"tsp\",\"tsq\",\"tsr\",\"tss\",\"tst\",\"tsu\",\"tsv\",\"tsw\",\"tsx\",\"tsy\",\"tsz\",\"tta\",\"ttb\",\"ttc\",\"ttd\",\"tte\",\"ttf\",\"ttg\",\"tth\",\"tti\",\"ttj\",\"ttk\",\"ttl\",\"ttm\",\"ttn\",\"tto\",\"ttp\",\"ttq\",\"ttr\",\"tts\",\"ttt\",\"ttu\",\"ttv\",\"ttw\",\"tty\",\"ttz\",\"tua\",\"tub\",\"tuc\",\"tud\",\"tue\",\"tuf\",\"tug\",\"tuh\",\"tui\",\"tuj\",\"tul\",\"tum\",\"tun\",\"tuo\",\"tup\",\"tuq\",\"tus\",\"tut\",\"tuu\",\"tuv\",\"tuw\",\"tux\",\"tuy\",\"tuz\",\"tva\",\"tvd\",\"tve\",\"tvk\",\"tvl\",\"tvm\",\"tvn\",\"tvo\",\"tvs\",\"tvt\",\"tvu\",\"tvw\",\"tvy\",\"twa\",\"twb\",\"twc\",\"twd\",\"twe\",\"twf\",\"twg\",\"twh\",\"twl\",\"twm\",\"twn\",\"two\",\"twp\",\"twq\",\"twr\",\"twt\",\"twu\",\"tww\",\"twx\",\"twy\",\"txa\",\"txb\",\"txc\",\"txe\",\"txg\",\"txh\",\"txi\",\"txj\",\"txm\",\"txn\",\"txo\",\"txq\",\"txr\",\"txs\",\"txt\",\"txu\",\"txx\",\"txy\",\"tya\",\"tye\",\"tyh\",\"tyi\",\"tyj\",\"tyl\",\"tyn\",\"typ\",\"tyr\",\"tys\",\"tyt\",\"tyu\",\"tyv\",\"tyx\",\"tyz\",\"tza\",\"tzh\",\"tzj\",\"tzl\",\"tzm\",\"tzn\",\"tzo\",\"tzx\",\"uam\",\"uan\",\"uar\",\"uba\",\"ubi\",\"ubl\",\"ubr\",\"ubu\",\"uby\",\"uda\",\"ude\",\"udg\",\"udi\",\"udj\",\"udl\",\"udm\",\"udu\",\"ues\",\"ufi\",\"uga\",\"ugb\",\"uge\",\"ugn\",\"ugo\",\"ugy\",\"uha\",\"uhn\",\"uis\",\"uiv\",\"uji\",\"uka\",\"ukg\",\"ukh\",\"ukl\",\"ukp\",\"ukq\",\"uks\",\"uku\",\"ukw\",\"uky\",\"ula\",\"ulb\",\"ulc\",\"ule\",\"ulf\",\"uli\",\"ulk\",\"ull\",\"ulm\",\"uln\",\"ulu\",\"ulw\",\"uma\",\"umb\",\"umc\",\"umd\",\"umg\",\"umi\",\"umm\",\"umn\",\"umo\",\"ump\",\"umr\",\"ums\",\"umu\",\"una\",\"und\",\"une\",\"ung\",\"unk\",\"unm\",\"unn\",\"unp\",\"unr\",\"unu\",\"unx\",\"unz\",\"uok\",\"upi\",\"upv\",\"ura\",\"urb\",\"urc\",\"ure\",\"urf\",\"urg\",\"urh\",\"uri\",\"urj\",\"urk\",\"url\",\"urm\",\"urn\",\"uro\",\"urp\",\"urr\",\"urt\",\"uru\",\"urv\",\"urw\",\"urx\",\"ury\",\"urz\",\"usa\",\"ush\",\"usi\",\"usk\",\"usp\",\"usu\",\"uta\",\"ute\",\"utp\",\"utr\",\"utu\",\"uum\",\"uun\",\"uur\",\"uuu\",\"uve\",\"uvh\",\"uvl\",\"uwa\",\"uya\",\"uzn\",\"uzs\",\"vaa\",\"vae\",\"vaf\",\"vag\",\"vah\",\"vai\",\"vaj\",\"val\",\"vam\",\"van\",\"vao\",\"vap\",\"var\",\"vas\",\"vau\",\"vav\",\"vay\",\"vbb\",\"vbk\",\"vec\",\"ved\",\"vel\",\"vem\",\"veo\",\"vep\",\"ver\",\"vgr\",\"vgt\",\"vic\",\"vid\",\"vif\",\"vig\",\"vil\",\"vin\",\"vis\",\"vit\",\"viv\",\"vka\",\"vki\",\"vkj\",\"vkk\",\"vkl\",\"vkm\",\"vko\",\"vkp\",\"vkt\",\"vku\",\"vlp\",\"vls\",\"vma\",\"vmb\",\"vmc\",\"vmd\",\"vme\",\"vmf\",\"vmg\",\"vmh\",\"vmi\",\"vmj\",\"vmk\",\"vml\",\"vmm\",\"vmp\",\"vmq\",\"vmr\",\"vms\",\"vmu\",\"vmv\",\"vmw\",\"vmx\",\"vmy\",\"vmz\",\"vnk\",\"vnm\",\"vnp\",\"vor\",\"vot\",\"vra\",\"vro\",\"vrs\",\"vrt\",\"vsi\",\"vsl\",\"vsv\",\"vto\",\"vum\",\"vun\",\"vut\",\"vwa\",\"waa\",\"wab\",\"wac\",\"wad\",\"wae\",\"waf\",\"wag\",\"wah\",\"wai\",\"waj\",\"wak\",\"wal\",\"wam\",\"wan\",\"wao\",\"wap\",\"waq\",\"war\",\"was\",\"wat\",\"wau\",\"wav\",\"waw\",\"wax\",\"way\",\"waz\",\"wba\",\"wbb\",\"wbe\",\"wbf\",\"wbh\",\"wbi\",\"wbj\",\"wbk\",\"wbl\",\"wbm\",\"wbp\",\"wbq\",\"wbr\",\"wbt\",\"wbv\",\"wbw\",\"wca\",\"wci\",\"wdd\",\"wdg\",\"wdj\",\"wdk\",\"wdu\",\"wdy\",\"wea\",\"wec\",\"wed\",\"weg\",\"weh\",\"wei\",\"wem\",\"wen\",\"weo\",\"wep\",\"wer\",\"wes\",\"wet\",\"weu\",\"wew\",\"wfg\",\"wga\",\"wgb\",\"wgg\",\"wgi\",\"wgo\",\"wgu\",\"wgw\",\"wgy\",\"wha\",\"whg\",\"whk\",\"whu\",\"wib\",\"wic\",\"wie\",\"wif\",\"wig\",\"wih\",\"wii\",\"wij\",\"wik\",\"wil\",\"wim\",\"win\",\"wir\",\"wit\",\"wiu\",\"wiv\",\"wiw\",\"wiy\",\"wja\",\"wji\",\"wka\",\"wkb\",\"wkd\",\"wkl\",\"wku\",\"wkw\",\"wky\",\"wla\",\"wlc\",\"wle\",\"wlg\",\"wli\",\"wlk\",\"wll\",\"wlm\",\"wlo\",\"wlr\",\"wls\",\"wlu\",\"wlv\",\"wlw\",\"wlx\",\"wly\",\"wma\",\"wmb\",\"wmc\",\"wmd\",\"wme\",\"wmh\",\"wmi\",\"wmm\",\"wmn\",\"wmo\",\"wms\",\"wmt\",\"wmw\",\"wmx\",\"wnb\",\"wnc\",\"wnd\",\"wne\",\"wng\",\"wni\",\"wnk\",\"wnm\",\"wnn\",\"wno\",\"wnp\",\"wnu\",\"wnw\",\"wny\",\"woa\",\"wob\",\"woc\",\"wod\",\"woe\",\"wof\",\"wog\",\"woi\",\"wok\",\"wom\",\"won\",\"woo\",\"wor\",\"wos\",\"wow\",\"woy\",\"wpc\",\"wra\",\"wrb\",\"wrd\",\"wrg\",\"wrh\",\"wri\",\"wrk\",\"wrl\",\"wrm\",\"wrn\",\"wro\",\"wrp\",\"wrr\",\"wrs\",\"wru\",\"wrv\",\"wrw\",\"wrx\",\"wry\",\"wrz\",\"wsa\",\"wsg\",\"wsi\",\"wsk\",\"wsr\",\"wss\",\"wsu\",\"wsv\",\"wtf\",\"wth\",\"wti\",\"wtk\",\"wtm\",\"wtw\",\"wua\",\"wub\",\"wud\",\"wuh\",\"wul\",\"wum\",\"wun\",\"wur\",\"wut\",\"wuu\",\"wuv\",\"wux\",\"wuy\",\"wwa\",\"wwb\",\"wwo\",\"wwr\",\"www\",\"wxa\",\"wxw\",\"wya\",\"wyb\",\"wyi\",\"wym\",\"wyr\",\"wyy\",\"xaa\",\"xab\",\"xac\",\"xad\",\"xae\",\"xag\",\"xai\",\"xaj\",\"xak\",\"xal\",\"xam\",\"xan\",\"xao\",\"xap\",\"xaq\",\"xar\",\"xas\",\"xat\",\"xau\",\"xav\",\"xaw\",\"xay\",\"xba\",\"xbb\",\"xbc\",\"xbd\",\"xbe\",\"xbg\",\"xbi\",\"xbj\",\"xbm\",\"xbn\",\"xbo\",\"xbp\",\"xbr\",\"xbw\",\"xbx\",\"xby\",\"xcb\",\"xcc\",\"xce\",\"xcg\",\"xch\",\"xcl\",\"xcm\",\"xcn\",\"xco\",\"xcr\",\"xct\",\"xcu\",\"xcv\",\"xcw\",\"xcy\",\"xda\",\"xdc\",\"xdk\",\"xdm\",\"xdy\",\"xeb\",\"xed\",\"xeg\",\"xel\",\"xem\",\"xep\",\"xer\",\"xes\",\"xet\",\"xeu\",\"xfa\",\"xga\",\"xgb\",\"xgd\",\"xgf\",\"xgg\",\"xgi\",\"xgl\",\"xgm\",\"xgn\",\"xgr\",\"xgu\",\"xgw\",\"xha\",\"xhc\",\"xhd\",\"xhe\",\"xhr\",\"xht\",\"xhu\",\"xhv\",\"xia\",\"xib\",\"xii\",\"xil\",\"xin\",\"xip\",\"xir\",\"xis\",\"xiv\",\"xiy\",\"xjb\",\"xjt\",\"xka\",\"xkb\",\"xkc\",\"xkd\",\"xke\",\"xkf\",\"xkg\",\"xkh\",\"xki\",\"xkj\",\"xkk\",\"xkl\",\"xkn\",\"xko\",\"xkp\",\"xkq\",\"xkr\",\"xks\",\"xkt\",\"xku\",\"xkv\",\"xkw\",\"xkx\",\"xky\",\"xkz\",\"xla\",\"xlb\",\"xlc\",\"xld\",\"xle\",\"xlg\",\"xli\",\"xln\",\"xlo\",\"xlp\",\"xls\",\"xlu\",\"xly\",\"xma\",\"xmb\",\"xmc\",\"xmd\",\"xme\",\"xmf\",\"xmg\",\"xmh\",\"xmj\",\"xmk\",\"xml\",\"xmm\",\"xmn\",\"xmo\",\"xmp\",\"xmq\",\"xmr\",\"xms\",\"xmt\",\"xmu\",\"xmv\",\"xmw\",\"xmx\",\"xmy\",\"xmz\",\"xna\",\"xnb\",\"xnd\",\"xng\",\"xnh\",\"xni\",\"xnk\",\"xnn\",\"xno\",\"xnr\",\"xns\",\"xnt\",\"xnu\",\"xny\",\"xnz\",\"xoc\",\"xod\",\"xog\",\"xoi\",\"xok\",\"xom\",\"xon\",\"xoo\",\"xop\",\"xor\",\"xow\",\"xpa\",\"xpc\",\"xpe\",\"xpg\",\"xpi\",\"xpj\",\"xpk\",\"xpm\",\"xpn\",\"xpo\",\"xpp\",\"xpq\",\"xpr\",\"xps\",\"xpt\",\"xpu\",\"xpy\",\"xqa\",\"xqt\",\"xra\",\"xrb\",\"xrd\",\"xre\",\"xrg\",\"xri\",\"xrm\",\"xrn\",\"xrq\",\"xrr\",\"xrt\",\"xru\",\"xrw\",\"xsa\",\"xsb\",\"xsc\",\"xsd\",\"xse\",\"xsh\",\"xsi\",\"xsj\",\"xsl\",\"xsm\",\"xsn\",\"xso\",\"xsp\",\"xsq\",\"xsr\",\"xss\",\"xsu\",\"xsv\",\"xsy\",\"xta\",\"xtb\",\"xtc\",\"xtd\",\"xte\",\"xtg\",\"xth\",\"xti\",\"xtj\",\"xtl\",\"xtm\",\"xtn\",\"xto\",\"xtp\",\"xtq\",\"xtr\",\"xts\",\"xtt\",\"xtu\",\"xtv\",\"xtw\",\"xty\",\"xtz\",\"xua\",\"xub\",\"xud\",\"xug\",\"xuj\",\"xul\",\"xum\",\"xun\",\"xuo\",\"xup\",\"xur\",\"xut\",\"xuu\",\"xve\",\"xvi\",\"xvn\",\"xvo\",\"xvs\",\"xwa\",\"xwc\",\"xwd\",\"xwe\",\"xwg\",\"xwj\",\"xwk\",\"xwl\",\"xwo\",\"xwr\",\"xwt\",\"xww\",\"xxb\",\"xxk\",\"xxm\",\"xxr\",\"xxt\",\"xya\",\"xyb\",\"xyj\",\"xyk\",\"xyl\",\"xyt\",\"xyy\",\"xzh\",\"xzm\",\"xzp\",\"yaa\",\"yab\",\"yac\",\"yad\",\"yae\",\"yaf\",\"yag\",\"yah\",\"yai\",\"yaj\",\"yak\",\"yal\",\"yam\",\"yan\",\"yao\",\"yap\",\"yaq\",\"yar\",\"yas\",\"yat\",\"yau\",\"yav\",\"yaw\",\"yax\",\"yay\",\"yaz\",\"yba\",\"ybb\",\"ybd\",\"ybe\",\"ybh\",\"ybi\",\"ybj\",\"ybk\",\"ybl\",\"ybm\",\"ybn\",\"ybo\",\"ybx\",\"yby\",\"ych\",\"ycl\",\"ycn\",\"ycp\",\"yda\",\"ydd\",\"yde\",\"ydg\",\"ydk\",\"yds\",\"yea\",\"yec\",\"yee\",\"yei\",\"yej\",\"yel\",\"yen\",\"yer\",\"yes\",\"yet\",\"yeu\",\"yev\",\"yey\",\"yga\",\"ygi\",\"ygl\",\"ygm\",\"ygp\",\"ygr\",\"ygs\",\"ygu\",\"ygw\",\"yha\",\"yhd\",\"yhl\",\"yhs\",\"yia\",\"yif\",\"yig\",\"yih\",\"yii\",\"yij\",\"yik\",\"yil\",\"yim\",\"yin\",\"yip\",\"yiq\",\"yir\",\"yis\",\"yit\",\"yiu\",\"yiv\",\"yix\",\"yiy\",\"yiz\",\"yka\",\"ykg\",\"yki\",\"ykk\",\"ykl\",\"ykm\",\"ykn\",\"yko\",\"ykr\",\"ykt\",\"yku\",\"yky\",\"yla\",\"ylb\",\"yle\",\"ylg\",\"yli\",\"yll\",\"ylm\",\"yln\",\"ylo\",\"ylr\",\"ylu\",\"yly\",\"yma\",\"ymb\",\"ymc\",\"ymd\",\"yme\",\"ymg\",\"ymh\",\"ymi\",\"ymk\",\"yml\",\"ymm\",\"ymn\",\"ymo\",\"ymp\",\"ymq\",\"ymr\",\"yms\",\"ymt\",\"ymx\",\"ymz\",\"yna\",\"ynd\",\"yne\",\"yng\",\"ynh\",\"ynk\",\"ynl\",\"ynn\",\"yno\",\"ynq\",\"yns\",\"ynu\",\"yob\",\"yog\",\"yoi\",\"yok\",\"yol\",\"yom\",\"yon\",\"yos\",\"yot\",\"yox\",\"yoy\",\"ypa\",\"ypb\",\"ypg\",\"yph\",\"ypk\",\"ypm\",\"ypn\",\"ypo\",\"ypp\",\"ypz\",\"yra\",\"yrb\",\"yre\",\"yri\",\"yrk\",\"yrl\",\"yrm\",\"yrn\",\"yro\",\"yrs\",\"yrw\",\"yry\",\"ysc\",\"ysd\",\"ysg\",\"ysl\",\"ysn\",\"yso\",\"ysp\",\"ysr\",\"yss\",\"ysy\",\"yta\",\"ytl\",\"ytp\",\"ytw\",\"yty\",\"yua\",\"yub\",\"yuc\",\"yud\",\"yue\",\"yuf\",\"yug\",\"yui\",\"yuj\",\"yuk\",\"yul\",\"yum\",\"yun\",\"yup\",\"yuq\",\"yur\",\"yut\",\"yuu\",\"yuw\",\"yux\",\"yuy\",\"yuz\",\"yva\",\"yvt\",\"ywa\",\"ywg\",\"ywl\",\"ywn\",\"ywq\",\"ywr\",\"ywt\",\"ywu\",\"yww\",\"yxa\",\"yxg\",\"yxl\",\"yxm\",\"yxu\",\"yxy\",\"yyr\",\"yyu\",\"yyz\",\"yzg\",\"yzk\",\"zaa\",\"zab\",\"zac\",\"zad\",\"zae\",\"zaf\",\"zag\",\"zah\",\"zai\",\"zaj\",\"zak\",\"zal\",\"zam\",\"zao\",\"zap\",\"zaq\",\"zar\",\"zas\",\"zat\",\"zau\",\"zav\",\"zaw\",\"zax\",\"zay\",\"zaz\",\"zbc\",\"zbe\",\"zbl\",\"zbt\",\"zbw\",\"zca\",\"zch\",\"zdj\",\"zea\",\"zeg\",\"zeh\",\"zen\",\"zga\",\"zgb\",\"zgh\",\"zgm\",\"zgn\",\"zgr\",\"zhb\",\"zhd\",\"zhi\",\"zhn\",\"zhw\",\"zhx\",\"zia\",\"zib\",\"zik\",\"zil\",\"zim\",\"zin\",\"zir\",\"ziw\",\"ziz\",\"zka\",\"zkb\",\"zkd\",\"zkg\",\"zkh\",\"zkk\",\"zkn\",\"zko\",\"zkp\",\"zkr\",\"zkt\",\"zku\",\"zkv\",\"zkz\",\"zle\",\"zlj\",\"zlm\",\"zln\",\"zlq\",\"zls\",\"zlw\",\"zma\",\"zmb\",\"zmc\",\"zmd\",\"zme\",\"zmf\",\"zmg\",\"zmh\",\"zmi\",\"zmj\",\"zmk\",\"zml\",\"zmm\",\"zmn\",\"zmo\",\"zmp\",\"zmq\",\"zmr\",\"zms\",\"zmt\",\"zmu\",\"zmv\",\"zmw\",\"zmx\",\"zmy\",\"zmz\",\"zna\",\"znd\",\"zne\",\"zng\",\"znk\",\"zns\",\"zoc\",\"zoh\",\"zom\",\"zoo\",\"zoq\",\"zor\",\"zos\",\"zpa\",\"zpb\",\"zpc\",\"zpd\",\"zpe\",\"zpf\",\"zpg\",\"zph\",\"zpi\",\"zpj\",\"zpk\",\"zpl\",\"zpm\",\"zpn\",\"zpo\",\"zpp\",\"zpq\",\"zpr\",\"zps\",\"zpt\",\"zpu\",\"zpv\",\"zpw\",\"zpx\",\"zpy\",\"zpz\",\"zqe\",\"zra\",\"zrg\",\"zrn\",\"zro\",\"zrp\",\"zrs\",\"zsa\",\"zsk\",\"zsl\",\"zsm\",\"zsr\",\"zsu\",\"zte\",\"ztg\",\"ztl\",\"ztm\",\"ztn\",\"ztp\",\"ztq\",\"zts\",\"ztt\",\"ztu\",\"ztx\",\"zty\",\"zua\",\"zuh\",\"zum\",\"zun\",\"zuy\",\"zwa\",\"zxx\",\"zyb\",\"zyg\",\"zyj\",\"zyn\",\"zyp\",\"zza\",\"zzj\"],\nid:\"valid-lang\"}]},{id:\"video-caption\",selector:\"video\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag122\",\"wcag123\",\"section508\",\"section508.22.a\"],all:[],any:[],none:[\"caption\"]},{id:\"video-description\",selector:\"video\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2aa\",\"wcag125\",\"section508\",\"section508.22.b\"],all:[],any:[],none:[\"description\"]}],checks:[{id:\"abstractrole\",evaluate:function(a,b){return\"abstract\"===axe.commons.aria.getRoleType(a.getAttribute(\"role\"))}},{id:\"aria-allowed-attr\",evaluate:function(a,b){var c,d,e,f=[],g=a.getAttribute(\"role\"),h=a.attributes;if(g||(g=axe.commons.aria.implicitRole(a)),e=axe.commons.aria.allowedAttr(g),g&&e)for(var i=0,j=h.length;i<j;i++)c=h[i],d=c.name,axe.commons.aria.validateAttr(d)&&-1===e.indexOf(d)&&f.push(d+'=\"'+c.nodeValue+'\"');return!f.length||(this.data(f),!1)}},{id:\"invalidrole\",evaluate:function(a,b){return!axe.commons.aria.isValidRole(a.getAttribute(\"role\"))}},{id:\"aria-required-attr\",evaluate:function(a,b){var c=[];if(a.hasAttributes()){var d,e=a.getAttribute(\"role\"),f=axe.commons.aria.requiredAttr(e);if(e&&f)for(var g=0,h=f.length;g<h;g++)d=f[g],a.getAttribute(d)||c.push(d)}return!c.length||(this.data(c),!1)}},{id:\"aria-required-children\",evaluate:function(a,b){function c(a,b,c){if(null===a)return!1;var d=f(b),e=['[role=\"'+b+'\"]'];return d&&(e=e.concat(d)),e=e.join(\",\"),c?g(a,e)||!!a.querySelector(e):!!a.querySelector(e)}function d(a,b){var d,e;for(d=0,e=a.length;d<e;d++)if(null!==a[d]&&c(a[d],b,!0))return!0;return!1}var e=axe.commons.aria.requiredOwned,f=axe.commons.aria.implicitNodes,g=axe.commons.utils.matchesSelector,h=axe.commons.dom.idrefs,i=a.getAttribute(\"role\"),j=e(i);if(!j)return!0;var k=!1,l=j.one;if(!l){var k=!0;l=j.all}var m=function(a,b,e){var f,g=b.length,i=[],j=h(a,\"aria-owns\");for(f=0;f<g;f++){var k=b[f];if(c(a,k)||d(j,k)){if(!e)return null}else e&&i.push(k)}return i.length?i:!e&&b.length?b:null}(a,l,k);return!m||(this.data(m),!1)}},{id:\"aria-required-parent\",evaluate:function(a,b){function c(a){return(axe.commons.aria.implicitNodes(a)||[]).concat('[role=\"'+a+'\"]').join(\",\")}function d(a,b,d){var e,f,g=a.getAttribute(\"role\"),h=[];if(b||(b=axe.commons.aria.requiredContext(g)),!b)return null;for(e=0,f=b.length;e<f;e++){if(d&&axe.utils.matchesSelector(a,c(b[e])))return null;if(axe.commons.dom.findUp(a,c(b[e])))return null;h.push(b[e])}return h}var e=d(a);if(!e)return!0;var f=function(a){for(var b=[],c=null;a;)a.id&&(c=document.querySelector(\"[aria-owns~=\"+axe.commons.utils.escapeSelector(a.id)+\"]\"))&&b.push(c),a=a.parentNode;return b.length?b:null}(a);if(f)for(var g=0,h=f.length;g<h;g++)if(!(e=d(f[g],e,!0)))return!0;return this.data(e),!1}},{id:\"aria-valid-attr-value\",evaluate:function(a,b){b=Array.isArray(b)?b:[];for(var c,d,e=[],f=/^aria-/,g=a.attributes,h=0,i=g.length;h<i;h++)c=g[h],d=c.name,-1===b.indexOf(d)&&f.test(d)&&!axe.commons.aria.validateAttrValue(a,d)&&e.push(d+'=\"'+c.nodeValue+'\"');return!e.length||(this.data(e),!1)},options:[]},{id:\"aria-valid-attr\",evaluate:function(a,b){b=Array.isArray(b)?b:[];for(var c,d=[],e=/^aria-/,f=a.attributes,g=0,h=f.length;g<h;g++)c=f[g].name,-1===b.indexOf(c)&&e.test(c)&&!axe.commons.aria.validateAttr(c)&&d.push(c);return!d.length||(this.data(d),!1)},options:[]},{id:\"color-contrast\",evaluate:function(a,b){if(!axe.commons.dom.isVisible(a,!1))return!0;var c=!!(b||{}).noScroll,d=[],e=axe.commons.color.getBackgroundColor(a,d,c),f=axe.commons.color.getForegroundColor(a,c),g=window.getComputedStyle(a),h=parseFloat(g.getPropertyValue(\"font-size\")),i=g.getPropertyValue(\"font-weight\"),j=-1!==[\"bold\",\"bolder\",\"600\",\"700\",\"800\",\"900\"].indexOf(i),k=axe.commons.color.hasValidContrastRatio(e,f,h,j),l=Math.floor(100*k.contrastRatio)/100,m=[];null===f&&m.push(axe.commons.color.incompleteData.get(\"fgColor\")),null===e&&m.push(axe.commons.color.incompleteData.get(\"bgColor\"));var n={fgColor:f?f.toHexString():void 0,bgColor:e?e.toHexString():void 0,contrastRatio:k?l:void 0,fontSize:(72*h/96).toFixed(1)+\"pt\",fontWeight:j?\"bold\":\"normal\",missingData:m};return this.data(n),k.isValid||this.relatedNodes(d),null===f||null===e?(m=[],void axe.commons.color.incompleteData.clear()):k.isValid}},{id:\"link-in-text-block\",evaluate:function(a,b){function c(a,b){var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(c,d)+.05)/(Math.min(c,d)+.05)}function d(a){var b=window.getComputedStyle(a).getPropertyValue(\"display\");return-1!==f.indexOf(b)||\"table-\"===b.substr(0,6)}var e=axe.commons.color,f=[\"block\",\"list-item\",\"table\",\"flex\",\"grid\",\"inline-block\"];if(d(a))return!1;for(var g=a.parentNode;1===g.nodeType&&!d(g);)g=g.parentNode;if(e.elementIsDistinct(a,g))return!0;var h,i;if(h=e.getForegroundColor(a),i=e.getForegroundColor(g),h&&i){var j=c(h,i);if(1===j)return!0;if(j>=3)return axe.commons.color.incompleteData.set(\"fgColor\",{reason:\"bgContrast\"}),this.data({missingData:[axe.commons.color.incompleteData.get(\"fgColor\")]}),void axe.commons.color.incompleteData.clear();if(h=e.getBackgroundColor(a),i=e.getBackgroundColor(g),!h||!i||c(h,i)>=3){var k=void 0;return k=h&&i?\"bgContrast\":axe.commons.color.incompleteData.get(\"bgColor\").reason,axe.commons.color.incompleteData.set(\"fgColor\",{reason:k}),this.data({missingData:[axe.commons.color.incompleteData.get(\"fgColor\")]}),void axe.commons.color.incompleteData.clear()}return!1}}},{id:\"fieldset\",evaluate:function(a,b){function c(a,b){return axe.commons.utils.toArray(a.querySelectorAll('select,textarea,button,input:not([name=\"'+b+'\"]):not([type=\"hidden\"])'))}function d(a,b){var d=a.firstElementChild;if(!d||\"LEGEND\"!==d.nodeName.toUpperCase())return h.relatedNodes([a]),g=\"no-legend\",!1;if(!axe.commons.text.accessibleText(d))return h.relatedNodes([d]),g=\"empty-legend\",!1;var e=c(a,b);return!e.length||(h.relatedNodes(e),g=\"mixed-inputs\",!1)}function e(a,b){var d=axe.commons.dom.idrefs(a,\"aria-labelledby\").some(function(a){return a&&axe.commons.text.accessibleText(a)}),e=a.getAttribute(\"aria-label\");if(!(d||e&&axe.commons.text.sanitize(e)))return h.relatedNodes(a),g=\"no-group-label\",!1;var f=c(a,b);return!f.length||(h.relatedNodes(f),g=\"group-mixed-inputs\",!1)}function f(a,b){return axe.commons.utils.toArray(a).filter(function(a){return a!==b})}var g,h=this,i={name:a.getAttribute(\"name\"),type:a.getAttribute(\"type\")},j=function(b){var c=axe.commons.utils.escapeSelector(a.name),i=document.querySelectorAll('input[type=\"'+axe.commons.utils.escapeSelector(a.type)+'\"][name=\"'+c+'\"]');if(i.length<2)return!0;var j=axe.commons.dom.findUp(b,\"fieldset\"),k=axe.commons.dom.findUp(b,'[role=\"group\"]'+(\"radio\"===a.type?',[role=\"radiogroup\"]':\"\"));return k||j?j?d(j,c):e(k,c):(g=\"no-group\",h.relatedNodes(f(i,b)),!1)}(a);return j||(i.failureCode=g),this.data(i),j},after:function(a,b){var c={};return a.filter(function(a){if(a.result)return!0;var b=a.data;if(b){if(c[b.type]=c[b.type]||{},!c[b.type][b.name])return c[b.type][b.name]=[b],!0;var d=c[b.type][b.name].some(function(a){return a.failureCode===b.failureCode});return d||c[b.type][b.name].push(b),!d}return!1})}},{id:\"group-labelledby\",evaluate:function(a,b){this.data({name:a.getAttribute(\"name\"),type:a.getAttribute(\"type\")});var c=document.querySelectorAll('input[type=\"'+axe.commons.utils.escapeSelector(a.type)+'\"][name=\"'+axe.commons.utils.escapeSelector(a.name)+'\"]');return c.length<=1||0!==[].map.call(c,function(a){var b=a.getAttribute(\"aria-labelledby\");return b?b.split(/\\s+/):[]}).reduce(function(a,b){return a.filter(function(a){return-1!==b.indexOf(a)})}).filter(function(a){var b=document.getElementById(a);return b&&axe.commons.text.accessibleText(b)}).length},after:function(a,b){var c={};return a.filter(function(a){var b=a.data;return!(!b||(c[b.type]=c[b.type]||{},c[b.type][b.name]))&&(c[b.type][b.name]=!0,!0)})}},{id:\"accesskeys\",evaluate:function(a,b){return axe.commons.dom.isVisible(a,!1)&&(this.data(a.getAttribute(\"accesskey\")),this.relatedNodes([a])),!0},after:function(a,b){var c={};return a.filter(function(a){if(!a.data)return!1;var b=a.data.toUpperCase();return c[b]?(c[b].relatedNodes.push(a.relatedNodes[0]),!1):(c[b]=a,a.relatedNodes=[],!0)}).map(function(a){return a.result=!!a.relatedNodes.length,a})}},{id:\"focusable-no-name\",evaluate:function(a,b){var c=a.getAttribute(\"tabindex\");return!!(axe.commons.dom.isFocusable(a)&&c>-1)&&!axe.commons.text.accessibleText(a)}},{id:\"tabindex\",evaluate:function(a,b){return a.tabIndex<=0}},{id:\"duplicate-img-label\",evaluate:function(a,b){var c=a.querySelectorAll(\"img\"),d=axe.commons.text.visible(a,!0).toLowerCase();if(\"\"===d)return!1;for(var e=0,f=c.length;e<f;e++){var g=c[e];if(axe.commons.text.accessibleText(g).toLowerCase()===d&&\"presentation\"!==g.getAttribute(\"role\")&&axe.commons.dom.isVisible(g))return!0}return!1}},{id:\"explicit-label\",evaluate:function(a,b){if(a.id){var c=document.querySelector('label[for=\"'+axe.commons.utils.escapeSelector(a.id)+'\"]');if(c)return!!axe.commons.text.accessibleText(c)}return!1}},{id:\"help-same-as-label\",evaluate:function(a,b){var c=axe.commons.text.label(a),d=a.getAttribute(\"title\");if(!c)return!1;if(!d&&(d=\"\",a.getAttribute(\"aria-describedby\"))){d=axe.commons.dom.idrefs(a,\"aria-describedby\").map(function(a){return a?axe.commons.text.accessibleText(a):\"\"}).join(\"\")}return axe.commons.text.sanitize(d)===axe.commons.text.sanitize(c)},enabled:!1},{id:\"implicit-label\",evaluate:function(a,b){var c=axe.commons.dom.findUp(a,\"label\");return!!c&&!!axe.commons.text.accessibleText(c)}},{id:\"multiple-label\",evaluate:function(a,b){var c=[].slice.call(document.querySelectorAll('label[for=\"'+axe.commons.utils.escapeSelector(a.id)+'\"]')),d=a.parentNode;for(c.length&&(c=c.filter(function(a,b){if(0===b&&!axe.commons.dom.isVisible(a,!0)||axe.commons.dom.isVisible(a,!0))return a}));d;)\"LABEL\"===d.tagName&&-1===c.indexOf(d)&&c.push(d),d=d.parentNode;return this.relatedNodes(c),c.length>1}},{id:\"title-only\",evaluate:function(a,b){return!(axe.commons.text.label(a)||!a.getAttribute(\"title\")&&!a.getAttribute(\"aria-describedby\"))}},{id:\"has-lang\",evaluate:function(a,b){return!!(a.getAttribute(\"lang\")||a.getAttribute(\"xml:lang\")||\"\").trim()}},{id:\"valid-lang\",\noptions:[\"aa\",\"ab\",\"ae\",\"af\",\"ak\",\"am\",\"an\",\"ar\",\"as\",\"av\",\"ay\",\"az\",\"ba\",\"be\",\"bg\",\"bh\",\"bi\",\"bm\",\"bn\",\"bo\",\"br\",\"bs\",\"ca\",\"ce\",\"ch\",\"co\",\"cr\",\"cs\",\"cu\",\"cv\",\"cy\",\"da\",\"de\",\"dv\",\"dz\",\"ee\",\"el\",\"en\",\"eo\",\"es\",\"et\",\"eu\",\"fa\",\"ff\",\"fi\",\"fj\",\"fo\",\"fr\",\"fy\",\"ga\",\"gd\",\"gl\",\"gn\",\"gu\",\"gv\",\"ha\",\"he\",\"hi\",\"ho\",\"hr\",\"ht\",\"hu\",\"hy\",\"hz\",\"ia\",\"id\",\"ie\",\"ig\",\"ii\",\"ik\",\"in\",\"io\",\"is\",\"it\",\"iu\",\"iw\",\"ja\",\"ji\",\"jv\",\"jw\",\"ka\",\"kg\",\"ki\",\"kj\",\"kk\",\"kl\",\"km\",\"kn\",\"ko\",\"kr\",\"ks\",\"ku\",\"kv\",\"kw\",\"ky\",\"la\",\"lb\",\"lg\",\"li\",\"ln\",\"lo\",\"lt\",\"lu\",\"lv\",\"mg\",\"mh\",\"mi\",\"mk\",\"ml\",\"mn\",\"mo\",\"mr\",\"ms\",\"mt\",\"my\",\"na\",\"nb\",\"nd\",\"ne\",\"ng\",\"nl\",\"nn\",\"no\",\"nr\",\"nv\",\"ny\",\"oc\",\"oj\",\"om\",\"or\",\"os\",\"pa\",\"pi\",\"pl\",\"ps\",\"pt\",\"qu\",\"rm\",\"rn\",\"ro\",\"ru\",\"rw\",\"sa\",\"sc\",\"sd\",\"se\",\"sg\",\"sh\",\"si\",\"sk\",\"sl\",\"sm\",\"sn\",\"so\",\"sq\",\"sr\",\"ss\",\"st\",\"su\",\"sv\",\"sw\",\"ta\",\"te\",\"tg\",\"th\",\"ti\",\"tk\",\"tl\",\"tn\",\"to\",\"tr\",\"ts\",\"tt\",\"tw\",\"ty\",\"ug\",\"uk\",\"ur\",\"uz\",\"ve\",\"vi\",\"vo\",\"wa\",\"wo\",\"xh\",\"yi\",\"yo\",\"za\",\"zh\",\"zu\",\"aaa\",\"aab\",\"aac\",\"aad\",\"aae\",\"aaf\",\"aag\",\"aah\",\"aai\",\"aak\",\"aal\",\"aam\",\"aan\",\"aao\",\"aap\",\"aaq\",\"aas\",\"aat\",\"aau\",\"aav\",\"aaw\",\"aax\",\"aaz\",\"aba\",\"abb\",\"abc\",\"abd\",\"abe\",\"abf\",\"abg\",\"abh\",\"abi\",\"abj\",\"abl\",\"abm\",\"abn\",\"abo\",\"abp\",\"abq\",\"abr\",\"abs\",\"abt\",\"abu\",\"abv\",\"abw\",\"abx\",\"aby\",\"abz\",\"aca\",\"acb\",\"acd\",\"ace\",\"acf\",\"ach\",\"aci\",\"ack\",\"acl\",\"acm\",\"acn\",\"acp\",\"acq\",\"acr\",\"acs\",\"act\",\"acu\",\"acv\",\"acw\",\"acx\",\"acy\",\"acz\",\"ada\",\"adb\",\"add\",\"ade\",\"adf\",\"adg\",\"adh\",\"adi\",\"adj\",\"adl\",\"adn\",\"ado\",\"adp\",\"adq\",\"adr\",\"ads\",\"adt\",\"adu\",\"adw\",\"adx\",\"ady\",\"adz\",\"aea\",\"aeb\",\"aec\",\"aed\",\"aee\",\"aek\",\"ael\",\"aem\",\"aen\",\"aeq\",\"aer\",\"aes\",\"aeu\",\"aew\",\"aey\",\"aez\",\"afa\",\"afb\",\"afd\",\"afe\",\"afg\",\"afh\",\"afi\",\"afk\",\"afn\",\"afo\",\"afp\",\"afs\",\"aft\",\"afu\",\"afz\",\"aga\",\"agb\",\"agc\",\"agd\",\"age\",\"agf\",\"agg\",\"agh\",\"agi\",\"agj\",\"agk\",\"agl\",\"agm\",\"agn\",\"ago\",\"agp\",\"agq\",\"agr\",\"ags\",\"agt\",\"agu\",\"agv\",\"agw\",\"agx\",\"agy\",\"agz\",\"aha\",\"ahb\",\"ahg\",\"ahh\",\"ahi\",\"ahk\",\"ahl\",\"ahm\",\"ahn\",\"aho\",\"ahp\",\"ahr\",\"ahs\",\"aht\",\"aia\",\"aib\",\"aic\",\"aid\",\"aie\",\"aif\",\"aig\",\"aih\",\"aii\",\"aij\",\"aik\",\"ail\",\"aim\",\"ain\",\"aio\",\"aip\",\"aiq\",\"air\",\"ais\",\"ait\",\"aiw\",\"aix\",\"aiy\",\"aja\",\"ajg\",\"aji\",\"ajn\",\"ajp\",\"ajt\",\"aju\",\"ajw\",\"ajz\",\"akb\",\"akc\",\"akd\",\"ake\",\"akf\",\"akg\",\"akh\",\"aki\",\"akj\",\"akk\",\"akl\",\"akm\",\"ako\",\"akp\",\"akq\",\"akr\",\"aks\",\"akt\",\"aku\",\"akv\",\"akw\",\"akx\",\"aky\",\"akz\",\"ala\",\"alc\",\"ald\",\"ale\",\"alf\",\"alg\",\"alh\",\"ali\",\"alj\",\"alk\",\"all\",\"alm\",\"aln\",\"alo\",\"alp\",\"alq\",\"alr\",\"als\",\"alt\",\"alu\",\"alv\",\"alw\",\"alx\",\"aly\",\"alz\",\"ama\",\"amb\",\"amc\",\"ame\",\"amf\",\"amg\",\"ami\",\"amj\",\"amk\",\"aml\",\"amm\",\"amn\",\"amo\",\"amp\",\"amq\",\"amr\",\"ams\",\"amt\",\"amu\",\"amv\",\"amw\",\"amx\",\"amy\",\"amz\",\"ana\",\"anb\",\"anc\",\"and\",\"ane\",\"anf\",\"ang\",\"anh\",\"ani\",\"anj\",\"ank\",\"anl\",\"anm\",\"ann\",\"ano\",\"anp\",\"anq\",\"anr\",\"ans\",\"ant\",\"anu\",\"anv\",\"anw\",\"anx\",\"any\",\"anz\",\"aoa\",\"aob\",\"aoc\",\"aod\",\"aoe\",\"aof\",\"aog\",\"aoh\",\"aoi\",\"aoj\",\"aok\",\"aol\",\"aom\",\"aon\",\"aor\",\"aos\",\"aot\",\"aou\",\"aox\",\"aoz\",\"apa\",\"apb\",\"apc\",\"apd\",\"ape\",\"apf\",\"apg\",\"aph\",\"api\",\"apj\",\"apk\",\"apl\",\"apm\",\"apn\",\"apo\",\"app\",\"apq\",\"apr\",\"aps\",\"apt\",\"apu\",\"apv\",\"apw\",\"apx\",\"apy\",\"apz\",\"aqa\",\"aqc\",\"aqd\",\"aqg\",\"aql\",\"aqm\",\"aqn\",\"aqp\",\"aqr\",\"aqt\",\"aqz\",\"arb\",\"arc\",\"ard\",\"are\",\"arh\",\"ari\",\"arj\",\"ark\",\"arl\",\"arn\",\"aro\",\"arp\",\"arq\",\"arr\",\"ars\",\"art\",\"aru\",\"arv\",\"arw\",\"arx\",\"ary\",\"arz\",\"asa\",\"asb\",\"asc\",\"asd\",\"ase\",\"asf\",\"asg\",\"ash\",\"asi\",\"asj\",\"ask\",\"asl\",\"asn\",\"aso\",\"asp\",\"asq\",\"asr\",\"ass\",\"ast\",\"asu\",\"asv\",\"asw\",\"asx\",\"asy\",\"asz\",\"ata\",\"atb\",\"atc\",\"atd\",\"ate\",\"atg\",\"ath\",\"ati\",\"atj\",\"atk\",\"atl\",\"atm\",\"atn\",\"ato\",\"atp\",\"atq\",\"atr\",\"ats\",\"att\",\"atu\",\"atv\",\"atw\",\"atx\",\"aty\",\"atz\",\"aua\",\"aub\",\"auc\",\"aud\",\"aue\",\"auf\",\"aug\",\"auh\",\"aui\",\"auj\",\"auk\",\"aul\",\"aum\",\"aun\",\"auo\",\"aup\",\"auq\",\"aur\",\"aus\",\"aut\",\"auu\",\"auw\",\"aux\",\"auy\",\"auz\",\"avb\",\"avd\",\"avi\",\"avk\",\"avl\",\"avm\",\"avn\",\"avo\",\"avs\",\"avt\",\"avu\",\"avv\",\"awa\",\"awb\",\"awc\",\"awd\",\"awe\",\"awg\",\"awh\",\"awi\",\"awk\",\"awm\",\"awn\",\"awo\",\"awr\",\"aws\",\"awt\",\"awu\",\"awv\",\"aww\",\"awx\",\"awy\",\"axb\",\"axe\",\"axg\",\"axk\",\"axl\",\"axm\",\"axx\",\"aya\",\"ayb\",\"ayc\",\"ayd\",\"aye\",\"ayg\",\"ayh\",\"ayi\",\"ayk\",\"ayl\",\"ayn\",\"ayo\",\"ayp\",\"ayq\",\"ayr\",\"ays\",\"ayt\",\"ayu\",\"ayx\",\"ayy\",\"ayz\",\"aza\",\"azb\",\"azc\",\"azd\",\"azg\",\"azj\",\"azm\",\"azn\",\"azo\",\"azt\",\"azz\",\"baa\",\"bab\",\"bac\",\"bad\",\"bae\",\"baf\",\"bag\",\"bah\",\"bai\",\"baj\",\"bal\",\"ban\",\"bao\",\"bap\",\"bar\",\"bas\",\"bat\",\"bau\",\"bav\",\"baw\",\"bax\",\"bay\",\"baz\",\"bba\",\"bbb\",\"bbc\",\"bbd\",\"bbe\",\"bbf\",\"bbg\",\"bbh\",\"bbi\",\"bbj\",\"bbk\",\"bbl\",\"bbm\",\"bbn\",\"bbo\",\"bbp\",\"bbq\",\"bbr\",\"bbs\",\"bbt\",\"bbu\",\"bbv\",\"bbw\",\"bbx\",\"bby\",\"bbz\",\"bca\",\"bcb\",\"bcc\",\"bcd\",\"bce\",\"bcf\",\"bcg\",\"bch\",\"bci\",\"bcj\",\"bck\",\"bcl\",\"bcm\",\"bcn\",\"bco\",\"bcp\",\"bcq\",\"bcr\",\"bcs\",\"bct\",\"bcu\",\"bcv\",\"bcw\",\"bcy\",\"bcz\",\"bda\",\"bdb\",\"bdc\",\"bdd\",\"bde\",\"bdf\",\"bdg\",\"bdh\",\"bdi\",\"bdj\",\"bdk\",\"bdl\",\"bdm\",\"bdn\",\"bdo\",\"bdp\",\"bdq\",\"bdr\",\"bds\",\"bdt\",\"bdu\",\"bdv\",\"bdw\",\"bdx\",\"bdy\",\"bdz\",\"bea\",\"beb\",\"bec\",\"bed\",\"bee\",\"bef\",\"beg\",\"beh\",\"bei\",\"bej\",\"bek\",\"bem\",\"beo\",\"bep\",\"beq\",\"ber\",\"bes\",\"bet\",\"beu\",\"bev\",\"bew\",\"bex\",\"bey\",\"bez\",\"bfa\",\"bfb\",\"bfc\",\"bfd\",\"bfe\",\"bff\",\"bfg\",\"bfh\",\"bfi\",\"bfj\",\"bfk\",\"bfl\",\"bfm\",\"bfn\",\"bfo\",\"bfp\",\"bfq\",\"bfr\",\"bfs\",\"bft\",\"bfu\",\"bfw\",\"bfx\",\"bfy\",\"bfz\",\"bga\",\"bgb\",\"bgc\",\"bgd\",\"bge\",\"bgf\",\"bgg\",\"bgi\",\"bgj\",\"bgk\",\"bgl\",\"bgm\",\"bgn\",\"bgo\",\"bgp\",\"bgq\",\"bgr\",\"bgs\",\"bgt\",\"bgu\",\"bgv\",\"bgw\",\"bgx\",\"bgy\",\"bgz\",\"bha\",\"bhb\",\"bhc\",\"bhd\",\"bhe\",\"bhf\",\"bhg\",\"bhh\",\"bhi\",\"bhj\",\"bhk\",\"bhl\",\"bhm\",\"bhn\",\"bho\",\"bhp\",\"bhq\",\"bhr\",\"bhs\",\"bht\",\"bhu\",\"bhv\",\"bhw\",\"bhx\",\"bhy\",\"bhz\",\"bia\",\"bib\",\"bic\",\"bid\",\"bie\",\"bif\",\"big\",\"bij\",\"bik\",\"bil\",\"bim\",\"bin\",\"bio\",\"bip\",\"biq\",\"bir\",\"bit\",\"biu\",\"biv\",\"biw\",\"bix\",\"biy\",\"biz\",\"bja\",\"bjb\",\"bjc\",\"bjd\",\"bje\",\"bjf\",\"bjg\",\"bjh\",\"bji\",\"bjj\",\"bjk\",\"bjl\",\"bjm\",\"bjn\",\"bjo\",\"bjp\",\"bjq\",\"bjr\",\"bjs\",\"bjt\",\"bju\",\"bjv\",\"bjw\",\"bjx\",\"bjy\",\"bjz\",\"bka\",\"bkb\",\"bkc\",\"bkd\",\"bkf\",\"bkg\",\"bkh\",\"bki\",\"bkj\",\"bkk\",\"bkl\",\"bkm\",\"bkn\",\"bko\",\"bkp\",\"bkq\",\"bkr\",\"bks\",\"bkt\",\"bku\",\"bkv\",\"bkw\",\"bkx\",\"bky\",\"bkz\",\"bla\",\"blb\",\"blc\",\"bld\",\"ble\",\"blf\",\"blg\",\"blh\",\"bli\",\"blj\",\"blk\",\"bll\",\"blm\",\"bln\",\"blo\",\"blp\",\"blq\",\"blr\",\"bls\",\"blt\",\"blv\",\"blw\",\"blx\",\"bly\",\"blz\",\"bma\",\"bmb\",\"bmc\",\"bmd\",\"bme\",\"bmf\",\"bmg\",\"bmh\",\"bmi\",\"bmj\",\"bmk\",\"bml\",\"bmm\",\"bmn\",\"bmo\",\"bmp\",\"bmq\",\"bmr\",\"bms\",\"bmt\",\"bmu\",\"bmv\",\"bmw\",\"bmx\",\"bmy\",\"bmz\",\"bna\",\"bnb\",\"bnc\",\"bnd\",\"bne\",\"bnf\",\"bng\",\"bni\",\"bnj\",\"bnk\",\"bnl\",\"bnm\",\"bnn\",\"bno\",\"bnp\",\"bnq\",\"bnr\",\"bns\",\"bnt\",\"bnu\",\"bnv\",\"bnw\",\"bnx\",\"bny\",\"bnz\",\"boa\",\"bob\",\"boe\",\"bof\",\"bog\",\"boh\",\"boi\",\"boj\",\"bok\",\"bol\",\"bom\",\"bon\",\"boo\",\"bop\",\"boq\",\"bor\",\"bot\",\"bou\",\"bov\",\"bow\",\"box\",\"boy\",\"boz\",\"bpa\",\"bpb\",\"bpd\",\"bpg\",\"bph\",\"bpi\",\"bpj\",\"bpk\",\"bpl\",\"bpm\",\"bpn\",\"bpo\",\"bpp\",\"bpq\",\"bpr\",\"bps\",\"bpt\",\"bpu\",\"bpv\",\"bpw\",\"bpx\",\"bpy\",\"bpz\",\"bqa\",\"bqb\",\"bqc\",\"bqd\",\"bqf\",\"bqg\",\"bqh\",\"bqi\",\"bqj\",\"bqk\",\"bql\",\"bqm\",\"bqn\",\"bqo\",\"bqp\",\"bqq\",\"bqr\",\"bqs\",\"bqt\",\"bqu\",\"bqv\",\"bqw\",\"bqx\",\"bqy\",\"bqz\",\"bra\",\"brb\",\"brc\",\"brd\",\"brf\",\"brg\",\"brh\",\"bri\",\"brj\",\"brk\",\"brl\",\"brm\",\"brn\",\"bro\",\"brp\",\"brq\",\"brr\",\"brs\",\"brt\",\"bru\",\"brv\",\"brw\",\"brx\",\"bry\",\"brz\",\"bsa\",\"bsb\",\"bsc\",\"bse\",\"bsf\",\"bsg\",\"bsh\",\"bsi\",\"bsj\",\"bsk\",\"bsl\",\"bsm\",\"bsn\",\"bso\",\"bsp\",\"bsq\",\"bsr\",\"bss\",\"bst\",\"bsu\",\"bsv\",\"bsw\",\"bsx\",\"bsy\",\"bta\",\"btb\",\"btc\",\"btd\",\"bte\",\"btf\",\"btg\",\"bth\",\"bti\",\"btj\",\"btk\",\"btl\",\"btm\",\"btn\",\"bto\",\"btp\",\"btq\",\"btr\",\"bts\",\"btt\",\"btu\",\"btv\",\"btw\",\"btx\",\"bty\",\"btz\",\"bua\",\"bub\",\"buc\",\"bud\",\"bue\",\"buf\",\"bug\",\"buh\",\"bui\",\"buj\",\"buk\",\"bum\",\"bun\",\"buo\",\"bup\",\"buq\",\"bus\",\"but\",\"buu\",\"buv\",\"buw\",\"bux\",\"buy\",\"buz\",\"bva\",\"bvb\",\"bvc\",\"bvd\",\"bve\",\"bvf\",\"bvg\",\"bvh\",\"bvi\",\"bvj\",\"bvk\",\"bvl\",\"bvm\",\"bvn\",\"bvo\",\"bvp\",\"bvq\",\"bvr\",\"bvt\",\"bvu\",\"bvv\",\"bvw\",\"bvx\",\"bvy\",\"bvz\",\"bwa\",\"bwb\",\"bwc\",\"bwd\",\"bwe\",\"bwf\",\"bwg\",\"bwh\",\"bwi\",\"bwj\",\"bwk\",\"bwl\",\"bwm\",\"bwn\",\"bwo\",\"bwp\",\"bwq\",\"bwr\",\"bws\",\"bwt\",\"bwu\",\"bww\",\"bwx\",\"bwy\",\"bwz\",\"bxa\",\"bxb\",\"bxc\",\"bxd\",\"bxe\",\"bxf\",\"bxg\",\"bxh\",\"bxi\",\"bxj\",\"bxk\",\"bxl\",\"bxm\",\"bxn\",\"bxo\",\"bxp\",\"bxq\",\"bxr\",\"bxs\",\"bxu\",\"bxv\",\"bxw\",\"bxx\",\"bxz\",\"bya\",\"byb\",\"byc\",\"byd\",\"bye\",\"byf\",\"byg\",\"byh\",\"byi\",\"byj\",\"byk\",\"byl\",\"bym\",\"byn\",\"byo\",\"byp\",\"byq\",\"byr\",\"bys\",\"byt\",\"byv\",\"byw\",\"byx\",\"byy\",\"byz\",\"bza\",\"bzb\",\"bzc\",\"bzd\",\"bze\",\"bzf\",\"bzg\",\"bzh\",\"bzi\",\"bzj\",\"bzk\",\"bzl\",\"bzm\",\"bzn\",\"bzo\",\"bzp\",\"bzq\",\"bzr\",\"bzs\",\"bzt\",\"bzu\",\"bzv\",\"bzw\",\"bzx\",\"bzy\",\"bzz\",\"caa\",\"cab\",\"cac\",\"cad\",\"cae\",\"caf\",\"cag\",\"cah\",\"cai\",\"caj\",\"cak\",\"cal\",\"cam\",\"can\",\"cao\",\"cap\",\"caq\",\"car\",\"cas\",\"cau\",\"cav\",\"caw\",\"cax\",\"cay\",\"caz\",\"cba\",\"cbb\",\"cbc\",\"cbd\",\"cbe\",\"cbg\",\"cbh\",\"cbi\",\"cbj\",\"cbk\",\"cbl\",\"cbn\",\"cbo\",\"cbq\",\"cbr\",\"cbs\",\"cbt\",\"cbu\",\"cbv\",\"cbw\",\"cby\",\"cca\",\"ccc\",\"ccd\",\"cce\",\"ccg\",\"cch\",\"ccj\",\"ccl\",\"ccm\",\"ccn\",\"cco\",\"ccp\",\"ccq\",\"ccr\",\"ccs\",\"cda\",\"cdc\",\"cdd\",\"cde\",\"cdf\",\"cdg\",\"cdh\",\"cdi\",\"cdj\",\"cdm\",\"cdn\",\"cdo\",\"cdr\",\"cds\",\"cdy\",\"cdz\",\"cea\",\"ceb\",\"ceg\",\"cek\",\"cel\",\"cen\",\"cet\",\"cfa\",\"cfd\",\"cfg\",\"cfm\",\"cga\",\"cgc\",\"cgg\",\"cgk\",\"chb\",\"chc\",\"chd\",\"chf\",\"chg\",\"chh\",\"chj\",\"chk\",\"chl\",\"chm\",\"chn\",\"cho\",\"chp\",\"chq\",\"chr\",\"cht\",\"chw\",\"chx\",\"chy\",\"chz\",\"cia\",\"cib\",\"cic\",\"cid\",\"cie\",\"cih\",\"cik\",\"cim\",\"cin\",\"cip\",\"cir\",\"ciw\",\"ciy\",\"cja\",\"cje\",\"cjh\",\"cji\",\"cjk\",\"cjm\",\"cjn\",\"cjo\",\"cjp\",\"cjr\",\"cjs\",\"cjv\",\"cjy\",\"cka\",\"ckb\",\"ckh\",\"ckl\",\"ckn\",\"cko\",\"ckq\",\"ckr\",\"cks\",\"ckt\",\"cku\",\"ckv\",\"ckx\",\"cky\",\"ckz\",\"cla\",\"clc\",\"cld\",\"cle\",\"clh\",\"cli\",\"clj\",\"clk\",\"cll\",\"clm\",\"clo\",\"clt\",\"clu\",\"clw\",\"cly\",\"cma\",\"cmc\",\"cme\",\"cmg\",\"cmi\",\"cmk\",\"cml\",\"cmm\",\"cmn\",\"cmo\",\"cmr\",\"cms\",\"cmt\",\"cna\",\"cnb\",\"cnc\",\"cng\",\"cnh\",\"cni\",\"cnk\",\"cnl\",\"cno\",\"cns\",\"cnt\",\"cnu\",\"cnw\",\"cnx\",\"coa\",\"cob\",\"coc\",\"cod\",\"coe\",\"cof\",\"cog\",\"coh\",\"coj\",\"cok\",\"col\",\"com\",\"con\",\"coo\",\"cop\",\"coq\",\"cot\",\"cou\",\"cov\",\"cow\",\"cox\",\"coy\",\"coz\",\"cpa\",\"cpb\",\"cpc\",\"cpe\",\"cpf\",\"cpg\",\"cpi\",\"cpn\",\"cpo\",\"cpp\",\"cps\",\"cpu\",\"cpx\",\"cpy\",\"cqd\",\"cqu\",\"cra\",\"crb\",\"crc\",\"crd\",\"crf\",\"crg\",\"crh\",\"cri\",\"crj\",\"crk\",\"crl\",\"crm\",\"crn\",\"cro\",\"crp\",\"crq\",\"crr\",\"crs\",\"crt\",\"crv\",\"crw\",\"crx\",\"cry\",\"crz\",\"csa\",\"csb\",\"csc\",\"csd\",\"cse\",\"csf\",\"csg\",\"csh\",\"csi\",\"csj\",\"csk\",\"csl\",\"csm\",\"csn\",\"cso\",\"csq\",\"csr\",\"css\",\"cst\",\"csu\",\"csv\",\"csw\",\"csy\",\"csz\",\"cta\",\"ctc\",\"ctd\",\"cte\",\"ctg\",\"cth\",\"ctl\",\"ctm\",\"ctn\",\"cto\",\"ctp\",\"cts\",\"ctt\",\"ctu\",\"ctz\",\"cua\",\"cub\",\"cuc\",\"cug\",\"cuh\",\"cui\",\"cuj\",\"cuk\",\"cul\",\"cum\",\"cuo\",\"cup\",\"cuq\",\"cur\",\"cus\",\"cut\",\"cuu\",\"cuv\",\"cuw\",\"cux\",\"cvg\",\"cvn\",\"cwa\",\"cwb\",\"cwd\",\"cwe\",\"cwg\",\"cwt\",\"cya\",\"cyb\",\"cyo\",\"czh\",\"czk\",\"czn\",\"czo\",\"czt\",\"daa\",\"dac\",\"dad\",\"dae\",\"daf\",\"dag\",\"dah\",\"dai\",\"daj\",\"dak\",\"dal\",\"dam\",\"dao\",\"dap\",\"daq\",\"dar\",\"das\",\"dau\",\"dav\",\"daw\",\"dax\",\"day\",\"daz\",\"dba\",\"dbb\",\"dbd\",\"dbe\",\"dbf\",\"dbg\",\"dbi\",\"dbj\",\"dbl\",\"dbm\",\"dbn\",\"dbo\",\"dbp\",\"dbq\",\"dbr\",\"dbt\",\"dbu\",\"dbv\",\"dbw\",\"dby\",\"dcc\",\"dcr\",\"dda\",\"ddd\",\"dde\",\"ddg\",\"ddi\",\"ddj\",\"ddn\",\"ddo\",\"ddr\",\"dds\",\"ddw\",\"dec\",\"ded\",\"dee\",\"def\",\"deg\",\"deh\",\"dei\",\"dek\",\"del\",\"dem\",\"den\",\"dep\",\"deq\",\"der\",\"des\",\"dev\",\"dez\",\"dga\",\"dgb\",\"dgc\",\"dgd\",\"dge\",\"dgg\",\"dgh\",\"dgi\",\"dgk\",\"dgl\",\"dgn\",\"dgo\",\"dgr\",\"dgs\",\"dgt\",\"dgu\",\"dgw\",\"dgx\",\"dgz\",\"dha\",\"dhd\",\"dhg\",\"dhi\",\"dhl\",\"dhm\",\"dhn\",\"dho\",\"dhr\",\"dhs\",\"dhu\",\"dhv\",\"dhw\",\"dhx\",\"dia\",\"dib\",\"dic\",\"did\",\"dif\",\"dig\",\"dih\",\"dii\",\"dij\",\"dik\",\"dil\",\"dim\",\"din\",\"dio\",\"dip\",\"diq\",\"dir\",\"dis\",\"dit\",\"diu\",\"diw\",\"dix\",\"diy\",\"diz\",\"dja\",\"djb\",\"djc\",\"djd\",\"dje\",\"djf\",\"dji\",\"djj\",\"djk\",\"djl\",\"djm\",\"djn\",\"djo\",\"djr\",\"dju\",\"djw\",\"dka\",\"dkk\",\"dkl\",\"dkr\",\"dks\",\"dkx\",\"dlg\",\"dlk\",\"dlm\",\"dln\",\"dma\",\"dmb\",\"dmc\",\"dmd\",\"dme\",\"dmg\",\"dmk\",\"dml\",\"dmm\",\"dmn\",\"dmo\",\"dmr\",\"dms\",\"dmu\",\"dmv\",\"dmw\",\"dmx\",\"dmy\",\"dna\",\"dnd\",\"dne\",\"dng\",\"dni\",\"dnj\",\"dnk\",\"dnn\",\"dnr\",\"dnt\",\"dnu\",\"dnv\",\"dnw\",\"dny\",\"doa\",\"dob\",\"doc\",\"doe\",\"dof\",\"doh\",\"doi\",\"dok\",\"dol\",\"don\",\"doo\",\"dop\",\"doq\",\"dor\",\"dos\",\"dot\",\"dov\",\"dow\",\"dox\",\"doy\",\"doz\",\"dpp\",\"dra\",\"drb\",\"drc\",\"drd\",\"dre\",\"drg\",\"drh\",\"dri\",\"drl\",\"drn\",\"dro\",\"drq\",\"drr\",\"drs\",\"drt\",\"dru\",\"drw\",\"dry\",\"dsb\",\"dse\",\"dsh\",\"dsi\",\"dsl\",\"dsn\",\"dso\",\"dsq\",\"dta\",\"dtb\",\"dtd\",\"dth\",\"dti\",\"dtk\",\"dtm\",\"dtn\",\"dto\",\"dtp\",\"dtr\",\"dts\",\"dtt\",\"dtu\",\"dty\",\"dua\",\"dub\",\"duc\",\"dud\",\"due\",\"duf\",\"dug\",\"duh\",\"dui\",\"duj\",\"duk\",\"dul\",\"dum\",\"dun\",\"duo\",\"dup\",\"duq\",\"dur\",\"dus\",\"duu\",\"duv\",\"duw\",\"dux\",\"duy\",\"duz\",\"dva\",\"dwa\",\"dwl\",\"dwr\",\"dws\",\"dwu\",\"dww\",\"dwy\",\"dya\",\"dyb\",\"dyd\",\"dyg\",\"dyi\",\"dym\",\"dyn\",\"dyo\",\"dyu\",\"dyy\",\"dza\",\"dzd\",\"dze\",\"dzg\",\"dzl\",\"dzn\",\"eaa\",\"ebg\",\"ebk\",\"ebo\",\"ebr\",\"ebu\",\"ecr\",\"ecs\",\"ecy\",\"eee\",\"efa\",\"efe\",\"efi\",\"ega\",\"egl\",\"ego\",\"egx\",\"egy\",\"ehu\",\"eip\",\"eit\",\"eiv\",\"eja\",\"eka\",\"ekc\",\"eke\",\"ekg\",\"eki\",\"ekk\",\"ekl\",\"ekm\",\"eko\",\"ekp\",\"ekr\",\"eky\",\"ele\",\"elh\",\"eli\",\"elk\",\"elm\",\"elo\",\"elp\",\"elu\",\"elx\",\"ema\",\"emb\",\"eme\",\"emg\",\"emi\",\"emk\",\"emm\",\"emn\",\"emo\",\"emp\",\"ems\",\"emu\",\"emw\",\"emx\",\"emy\",\"ena\",\"enb\",\"enc\",\"end\",\"enf\",\"enh\",\"enl\",\"enm\",\"enn\",\"eno\",\"enq\",\"enr\",\"enu\",\"env\",\"enw\",\"enx\",\"eot\",\"epi\",\"era\",\"erg\",\"erh\",\"eri\",\"erk\",\"ero\",\"err\",\"ers\",\"ert\",\"erw\",\"ese\",\"esg\",\"esh\",\"esi\",\"esk\",\"esl\",\"esm\",\"esn\",\"eso\",\"esq\",\"ess\",\"esu\",\"esx\",\"esy\",\"etb\",\"etc\",\"eth\",\"etn\",\"eto\",\"etr\",\"ets\",\"ett\",\"etu\",\"etx\",\"etz\",\"euq\",\"eve\",\"evh\",\"evn\",\"ewo\",\"ext\",\"eya\",\"eyo\",\"eza\",\"eze\",\"faa\",\"fab\",\"fad\",\"faf\",\"fag\",\"fah\",\"fai\",\"faj\",\"fak\",\"fal\",\"fam\",\"fan\",\"fap\",\"far\",\"fat\",\"fau\",\"fax\",\"fay\",\"faz\",\"fbl\",\"fcs\",\"fer\",\"ffi\",\"ffm\",\"fgr\",\"fia\",\"fie\",\"fil\",\"fip\",\"fir\",\"fit\",\"fiu\",\"fiw\",\"fkk\",\"fkv\",\"fla\",\"flh\",\"fli\",\"fll\",\"fln\",\"flr\",\"fly\",\"fmp\",\"fmu\",\"fnb\",\"fng\",\"fni\",\"fod\",\"foi\",\"fom\",\"fon\",\"for\",\"fos\",\"fox\",\"fpe\",\"fqs\",\"frc\",\"frd\",\"frk\",\"frm\",\"fro\",\"frp\",\"frq\",\"frr\",\"frs\",\"frt\",\"fse\",\"fsl\",\"fss\",\"fub\",\"fuc\",\"fud\",\"fue\",\"fuf\",\"fuh\",\"fui\",\"fuj\",\"fum\",\"fun\",\"fuq\",\"fur\",\"fut\",\"fuu\",\"fuv\",\"fuy\",\"fvr\",\"fwa\",\"fwe\",\"gaa\",\"gab\",\"gac\",\"gad\",\"gae\",\"gaf\",\"gag\",\"gah\",\"gai\",\"gaj\",\"gak\",\"gal\",\"gam\",\"gan\",\"gao\",\"gap\",\"gaq\",\"gar\",\"gas\",\"gat\",\"gau\",\"gav\",\"gaw\",\"gax\",\"gay\",\"gaz\",\"gba\",\"gbb\",\"gbc\",\"gbd\",\"gbe\",\"gbf\",\"gbg\",\"gbh\",\"gbi\",\"gbj\",\"gbk\",\"gbl\",\"gbm\",\"gbn\",\"gbo\",\"gbp\",\"gbq\",\"gbr\",\"gbs\",\"gbu\",\"gbv\",\"gbw\",\"gbx\",\"gby\",\"gbz\",\"gcc\",\"gcd\",\"gce\",\"gcf\",\"gcl\",\"gcn\",\"gcr\",\"gct\",\"gda\",\"gdb\",\"gdc\",\"gdd\",\"gde\",\"gdf\",\"gdg\",\"gdh\",\"gdi\",\"gdj\",\"gdk\",\"gdl\",\"gdm\",\"gdn\",\"gdo\",\"gdq\",\"gdr\",\"gds\",\"gdt\",\"gdu\",\"gdx\",\"gea\",\"geb\",\"gec\",\"ged\",\"geg\",\"geh\",\"gei\",\"gej\",\"gek\",\"gel\",\"gem\",\"geq\",\"ges\",\"gev\",\"gew\",\"gex\",\"gey\",\"gez\",\"gfk\",\"gft\",\"gfx\",\"gga\",\"ggb\",\"ggd\",\"gge\",\"ggg\",\"ggk\",\"ggl\",\"ggn\",\"ggo\",\"ggr\",\"ggt\",\"ggu\",\"ggw\",\"gha\",\"ghc\",\"ghe\",\"ghh\",\"ghk\",\"ghl\",\"ghn\",\"gho\",\"ghr\",\"ghs\",\"ght\",\"gia\",\"gib\",\"gic\",\"gid\",\"gig\",\"gih\",\"gil\",\"gim\",\"gin\",\"gio\",\"gip\",\"giq\",\"gir\",\"gis\",\"git\",\"giu\",\"giw\",\"gix\",\"giy\",\"giz\",\"gji\",\"gjk\",\"gjm\",\"gjn\",\"gjr\",\"gju\",\"gka\",\"gke\",\"gkn\",\"gko\",\"gkp\",\"gku\",\"glc\",\"gld\",\"glh\",\"gli\",\"glj\",\"glk\",\"gll\",\"glo\",\"glr\",\"glu\",\"glw\",\"gly\",\"gma\",\"gmb\",\"gmd\",\"gme\",\"gmg\",\"gmh\",\"gml\",\"gmm\",\"gmn\",\"gmq\",\"gmu\",\"gmv\",\"gmw\",\"gmx\",\"gmy\",\"gmz\",\"gna\",\"gnb\",\"gnc\",\"gnd\",\"gne\",\"gng\",\"gnh\",\"gni\",\"gnk\",\"gnl\",\"gnm\",\"gnn\",\"gno\",\"gnq\",\"gnr\",\"gnt\",\"gnu\",\"gnw\",\"gnz\",\"goa\",\"gob\",\"goc\",\"god\",\"goe\",\"gof\",\"gog\",\"goh\",\"goi\",\"goj\",\"gok\",\"gol\",\"gom\",\"gon\",\"goo\",\"gop\",\"goq\",\"gor\",\"gos\",\"got\",\"gou\",\"gow\",\"gox\",\"goy\",\"goz\",\"gpa\",\"gpe\",\"gpn\",\"gqa\",\"gqi\",\"gqn\",\"gqr\",\"gqu\",\"gra\",\"grb\",\"grc\",\"grd\",\"grg\",\"grh\",\"gri\",\"grj\",\"grk\",\"grm\",\"gro\",\"grq\",\"grr\",\"grs\",\"grt\",\"gru\",\"grv\",\"grw\",\"grx\",\"gry\",\"grz\",\"gse\",\"gsg\",\"gsl\",\"gsm\",\"gsn\",\"gso\",\"gsp\",\"gss\",\"gsw\",\"gta\",\"gti\",\"gtu\",\"gua\",\"gub\",\"guc\",\"gud\",\"gue\",\"guf\",\"gug\",\"guh\",\"gui\",\"guk\",\"gul\",\"gum\",\"gun\",\"guo\",\"gup\",\"guq\",\"gur\",\"gus\",\"gut\",\"guu\",\"guv\",\"guw\",\"gux\",\"guz\",\"gva\",\"gvc\",\"gve\",\"gvf\",\"gvj\",\"gvl\",\"gvm\",\"gvn\",\"gvo\",\"gvp\",\"gvr\",\"gvs\",\"gvy\",\"gwa\",\"gwb\",\"gwc\",\"gwd\",\"gwe\",\"gwf\",\"gwg\",\"gwi\",\"gwj\",\"gwm\",\"gwn\",\"gwr\",\"gwt\",\"gwu\",\"gww\",\"gwx\",\"gxx\",\"gya\",\"gyb\",\"gyd\",\"gye\",\"gyf\",\"gyg\",\"gyi\",\"gyl\",\"gym\",\"gyn\",\"gyr\",\"gyy\",\"gza\",\"gzi\",\"gzn\",\"haa\",\"hab\",\"hac\",\"had\",\"hae\",\"haf\",\"hag\",\"hah\",\"hai\",\"haj\",\"hak\",\"hal\",\"ham\",\"han\",\"hao\",\"hap\",\"haq\",\"har\",\"has\",\"hav\",\"haw\",\"hax\",\"hay\",\"haz\",\"hba\",\"hbb\",\"hbn\",\"hbo\",\"hbu\",\"hca\",\"hch\",\"hdn\",\"hds\",\"hdy\",\"hea\",\"hed\",\"heg\",\"heh\",\"hei\",\"hem\",\"hgm\",\"hgw\",\"hhi\",\"hhr\",\"hhy\",\"hia\",\"hib\",\"hid\",\"hif\",\"hig\",\"hih\",\"hii\",\"hij\",\"hik\",\"hil\",\"him\",\"hio\",\"hir\",\"hit\",\"hiw\",\"hix\",\"hji\",\"hka\",\"hke\",\"hkk\",\"hks\",\"hla\",\"hlb\",\"hld\",\"hle\",\"hlt\",\"hlu\",\"hma\",\"hmb\",\"hmc\",\"hmd\",\"hme\",\"hmf\",\"hmg\",\"hmh\",\"hmi\",\"hmj\",\"hmk\",\"hml\",\"hmm\",\"hmn\",\"hmp\",\"hmq\",\"hmr\",\"hms\",\"hmt\",\"hmu\",\"hmv\",\"hmw\",\"hmx\",\"hmy\",\"hmz\",\"hna\",\"hnd\",\"hne\",\"hnh\",\"hni\",\"hnj\",\"hnn\",\"hno\",\"hns\",\"hnu\",\"hoa\",\"hob\",\"hoc\",\"hod\",\"hoe\",\"hoh\",\"hoi\",\"hoj\",\"hok\",\"hol\",\"hom\",\"hoo\",\"hop\",\"hor\",\"hos\",\"hot\",\"hov\",\"how\",\"hoy\",\"hoz\",\"hpo\",\"hps\",\"hra\",\"hrc\",\"hre\",\"hrk\",\"hrm\",\"hro\",\"hrp\",\"hrr\",\"hrt\",\"hru\",\"hrw\",\"hrx\",\"hrz\",\"hsb\",\"hsh\",\"hsl\",\"hsn\",\"hss\",\"hti\",\"hto\",\"hts\",\"htu\",\"htx\",\"hub\",\"huc\",\"hud\",\"hue\",\"huf\",\"hug\",\"huh\",\"hui\",\"huj\",\"huk\",\"hul\",\"hum\",\"huo\",\"hup\",\"huq\",\"hur\",\"hus\",\"hut\",\"huu\",\"huv\",\"huw\",\"hux\",\"huy\",\"huz\",\"hvc\",\"hve\",\"hvk\",\"hvn\",\"hvv\",\"hwa\",\"hwc\",\"hwo\",\"hya\",\"hyx\",\"iai\",\"ian\",\"iap\",\"iar\",\"iba\",\"ibb\",\"ibd\",\"ibe\",\"ibg\",\"ibi\",\"ibl\",\"ibm\",\"ibn\",\"ibr\",\"ibu\",\"iby\",\"ica\",\"ich\",\"icl\",\"icr\",\"ida\",\"idb\",\"idc\",\"idd\",\"ide\",\"idi\",\"idr\",\"ids\",\"idt\",\"idu\",\"ifa\",\"ifb\",\"ife\",\"iff\",\"ifk\",\"ifm\",\"ifu\",\"ify\",\"igb\",\"ige\",\"igg\",\"igl\",\"igm\",\"ign\",\"igo\",\"igs\",\"igw\",\"ihb\",\"ihi\",\"ihp\",\"ihw\",\"iin\",\"iir\",\"ijc\",\"ije\",\"ijj\",\"ijn\",\"ijo\",\"ijs\",\"ike\",\"iki\",\"ikk\",\"ikl\",\"iko\",\"ikp\",\"ikr\",\"iks\",\"ikt\",\"ikv\",\"ikw\",\"ikx\",\"ikz\",\"ila\",\"ilb\",\"ilg\",\"ili\",\"ilk\",\"ill\",\"ilm\",\"ilo\",\"ilp\",\"ils\",\"ilu\",\"ilv\",\"ilw\",\"ima\",\"ime\",\"imi\",\"iml\",\"imn\",\"imo\",\"imr\",\"ims\",\"imy\",\"inb\",\"inc\",\"ine\",\"ing\",\"inh\",\"inj\",\"inl\",\"inm\",\"inn\",\"ino\",\"inp\",\"ins\",\"int\",\"inz\",\"ior\",\"iou\",\"iow\",\"ipi\",\"ipo\",\"iqu\",\"iqw\",\"ira\",\"ire\",\"irh\",\"iri\",\"irk\",\"irn\",\"iro\",\"irr\",\"iru\",\"irx\",\"iry\",\"isa\",\"isc\",\"isd\",\"ise\",\"isg\",\"ish\",\"isi\",\"isk\",\"ism\",\"isn\",\"iso\",\"isr\",\"ist\",\"isu\",\"itb\",\"itc\",\"itd\",\"ite\",\"iti\",\"itk\",\"itl\",\"itm\",\"ito\",\"itr\",\"its\",\"itt\",\"itv\",\"itw\",\"itx\",\"ity\",\"itz\",\"ium\",\"ivb\",\"ivv\",\"iwk\",\"iwm\",\"iwo\",\"iws\",\"ixc\",\"ixl\",\"iya\",\"iyo\",\"iyx\",\"izh\",\"izi\",\"izr\",\"izz\",\"jaa\",\"jab\",\"jac\",\"jad\",\"jae\",\"jaf\",\"jah\",\"jaj\",\"jak\",\"jal\",\"jam\",\"jan\",\"jao\",\"jaq\",\"jar\",\"jas\",\"jat\",\"jau\",\"jax\",\"jay\",\"jaz\",\"jbe\",\"jbi\",\"jbj\",\"jbk\",\"jbn\",\"jbo\",\"jbr\",\"jbt\",\"jbu\",\"jbw\",\"jcs\",\"jct\",\"jda\",\"jdg\",\"jdt\",\"jeb\",\"jee\",\"jeg\",\"jeh\",\"jei\",\"jek\",\"jel\",\"jen\",\"jer\",\"jet\",\"jeu\",\"jgb\",\"jge\",\"jgk\",\"jgo\",\"jhi\",\"jhs\",\"jia\",\"jib\",\"jic\",\"jid\",\"jie\",\"jig\",\"jih\",\"jii\",\"jil\",\"jim\",\"jio\",\"jiq\",\"jit\",\"jiu\",\"jiv\",\"jiy\",\"jje\",\"jjr\",\"jka\",\"jkm\",\"jko\",\"jkp\",\"jkr\",\"jku\",\"jle\",\"jls\",\"jma\",\"jmb\",\"jmc\",\"jmd\",\"jmi\",\"jml\",\"jmn\",\"jmr\",\"jms\",\"jmw\",\"jmx\",\"jna\",\"jnd\",\"jng\",\"jni\",\"jnj\",\"jnl\",\"jns\",\"job\",\"jod\",\"jog\",\"jor\",\"jos\",\"jow\",\"jpa\",\"jpr\",\"jpx\",\"jqr\",\"jra\",\"jrb\",\"jrr\",\"jrt\",\"jru\",\"jsl\",\"jua\",\"jub\",\"juc\",\"jud\",\"juh\",\"jui\",\"juk\",\"jul\",\"jum\",\"jun\",\"juo\",\"jup\",\"jur\",\"jus\",\"jut\",\"juu\",\"juw\",\"juy\",\"jvd\",\"jvn\",\"jwi\",\"jya\",\"jye\",\"jyy\",\"kaa\",\"kab\",\"kac\",\"kad\",\"kae\",\"kaf\",\"kag\",\"kah\",\"kai\",\"kaj\",\"kak\",\"kam\",\"kao\",\"kap\",\"kaq\",\"kar\",\"kav\",\"kaw\",\"kax\",\"kay\",\"kba\",\"kbb\",\"kbc\",\"kbd\",\"kbe\",\"kbf\",\"kbg\",\"kbh\",\"kbi\",\"kbj\",\"kbk\",\"kbl\",\"kbm\",\"kbn\",\"kbo\",\"kbp\",\"kbq\",\"kbr\",\"kbs\",\"kbt\",\"kbu\",\"kbv\",\"kbw\",\"kbx\",\"kby\",\"kbz\",\"kca\",\"kcb\",\"kcc\",\"kcd\",\"kce\",\"kcf\",\"kcg\",\"kch\",\"kci\",\"kcj\",\"kck\",\"kcl\",\"kcm\",\"kcn\",\"kco\",\"kcp\",\"kcq\",\"kcr\",\"kcs\",\"kct\",\"kcu\",\"kcv\",\"kcw\",\"kcx\",\"kcy\",\"kcz\",\"kda\",\"kdc\",\"kdd\",\"kde\",\"kdf\",\"kdg\",\"kdh\",\"kdi\",\"kdj\",\"kdk\",\"kdl\",\"kdm\",\"kdn\",\"kdo\",\"kdp\",\"kdq\",\"kdr\",\"kdt\",\"kdu\",\"kdv\",\"kdw\",\"kdx\",\"kdy\",\"kdz\",\"kea\",\"keb\",\"kec\",\"ked\",\"kee\",\"kef\",\"keg\",\"keh\",\"kei\",\"kej\",\"kek\",\"kel\",\"kem\",\"ken\",\"keo\",\"kep\",\"keq\",\"ker\",\"kes\",\"ket\",\"keu\",\"kev\",\"kew\",\"kex\",\"key\",\"kez\",\"kfa\",\"kfb\",\"kfc\",\"kfd\",\"kfe\",\"kff\",\"kfg\",\"kfh\",\"kfi\",\"kfj\",\"kfk\",\"kfl\",\"kfm\",\"kfn\",\"kfo\",\"kfp\",\"kfq\",\"kfr\",\"kfs\",\"kft\",\"kfu\",\"kfv\",\"kfw\",\"kfx\",\"kfy\",\"kfz\",\"kga\",\"kgb\",\"kgc\",\"kgd\",\"kge\",\"kgf\",\"kgg\",\"kgh\",\"kgi\",\"kgj\",\"kgk\",\"kgl\",\"kgm\",\"kgn\",\"kgo\",\"kgp\",\"kgq\",\"kgr\",\"kgs\",\"kgt\",\"kgu\",\"kgv\",\"kgw\",\"kgx\",\"kgy\",\"kha\",\"khb\",\"khc\",\"khd\",\"khe\",\"khf\",\"khg\",\"khh\",\"khi\",\"khj\",\"khk\",\"khl\",\"khn\",\"kho\",\"khp\",\"khq\",\"khr\",\"khs\",\"kht\",\"khu\",\"khv\",\"khw\",\"khx\",\"khy\",\"khz\",\"kia\",\"kib\",\"kic\",\"kid\",\"kie\",\"kif\",\"kig\",\"kih\",\"kii\",\"kij\",\"kil\",\"kim\",\"kio\",\"kip\",\"kiq\",\"kis\",\"kit\",\"kiu\",\"kiv\",\"kiw\",\"kix\",\"kiy\",\"kiz\",\"kja\",\"kjb\",\"kjc\",\"kjd\",\"kje\",\"kjf\",\"kjg\",\"kjh\",\"kji\",\"kjj\",\"kjk\",\"kjl\",\"kjm\",\"kjn\",\"kjo\",\"kjp\",\"kjq\",\"kjr\",\"kjs\",\"kjt\",\"kju\",\"kjv\",\"kjx\",\"kjy\",\"kjz\",\"kka\",\"kkb\",\"kkc\",\"kkd\",\"kke\",\"kkf\",\"kkg\",\"kkh\",\"kki\",\"kkj\",\"kkk\",\"kkl\",\"kkm\",\"kkn\",\"kko\",\"kkp\",\"kkq\",\"kkr\",\"kks\",\"kkt\",\"kku\",\"kkv\",\"kkw\",\"kkx\",\"kky\",\"kkz\",\"kla\",\"klb\",\"klc\",\"kld\",\"kle\",\"klf\",\"klg\",\"klh\",\"kli\",\"klj\",\"klk\",\"kll\",\"klm\",\"kln\",\"klo\",\"klp\",\"klq\",\"klr\",\"kls\",\"klt\",\"klu\",\"klv\",\"klw\",\"klx\",\"kly\",\"klz\",\"kma\",\"kmb\",\"kmc\",\"kmd\",\"kme\",\"kmf\",\"kmg\",\"kmh\",\"kmi\",\"kmj\",\"kmk\",\"kml\",\"kmm\",\"kmn\",\"kmo\",\"kmp\",\"kmq\",\"kmr\",\"kms\",\"kmt\",\"kmu\",\"kmv\",\"kmw\",\"kmx\",\"kmy\",\"kmz\",\"kna\",\"knb\",\"knc\",\"knd\",\"kne\",\"knf\",\"kng\",\"kni\",\"knj\",\"knk\",\"knl\",\"knm\",\"knn\",\"kno\",\"knp\",\"knq\",\"knr\",\"kns\",\"knt\",\"knu\",\"knv\",\"knw\",\"knx\",\"kny\",\"knz\",\"koa\",\"koc\",\"kod\",\"koe\",\"kof\",\"kog\",\"koh\",\"koi\",\"koj\",\"kok\",\"kol\",\"koo\",\"kop\",\"koq\",\"kos\",\"kot\",\"kou\",\"kov\",\"kow\",\"kox\",\"koy\",\"koz\",\"kpa\",\"kpb\",\"kpc\",\"kpd\",\"kpe\",\"kpf\",\"kpg\",\"kph\",\"kpi\",\"kpj\",\"kpk\",\"kpl\",\"kpm\",\"kpn\",\"kpo\",\"kpp\",\"kpq\",\"kpr\",\"kps\",\"kpt\",\"kpu\",\"kpv\",\"kpw\",\"kpx\",\"kpy\",\"kpz\",\"kqa\",\"kqb\",\"kqc\",\"kqd\",\"kqe\",\"kqf\",\"kqg\",\"kqh\",\"kqi\",\"kqj\",\"kqk\",\"kql\",\"kqm\",\"kqn\",\"kqo\",\"kqp\",\"kqq\",\"kqr\",\"kqs\",\"kqt\",\"kqu\",\"kqv\",\"kqw\",\"kqx\",\"kqy\",\"kqz\",\"kra\",\"krb\",\"krc\",\"krd\",\"kre\",\"krf\",\"krh\",\"kri\",\"krj\",\"krk\",\"krl\",\"krm\",\"krn\",\"kro\",\"krp\",\"krr\",\"krs\",\"krt\",\"kru\",\"krv\",\"krw\",\"krx\",\"kry\",\"krz\",\"ksa\",\"ksb\",\"ksc\",\"ksd\",\"kse\",\"ksf\",\"ksg\",\"ksh\",\"ksi\",\"ksj\",\"ksk\",\"ksl\",\"ksm\",\"ksn\",\"kso\",\"ksp\",\"ksq\",\"ksr\",\"kss\",\"kst\",\"ksu\",\"ksv\",\"ksw\",\"ksx\",\"ksy\",\"ksz\",\"kta\",\"ktb\",\"ktc\",\"ktd\",\"kte\",\"ktf\",\"ktg\",\"kth\",\"kti\",\"ktj\",\"ktk\",\"ktl\",\"ktm\",\"ktn\",\"kto\",\"ktp\",\"ktq\",\"ktr\",\"kts\",\"ktt\",\"ktu\",\"ktv\",\"ktw\",\"ktx\",\"kty\",\"ktz\",\"kub\",\"kuc\",\"kud\",\"kue\",\"kuf\",\"kug\",\"kuh\",\"kui\",\"kuj\",\"kuk\",\"kul\",\"kum\",\"kun\",\"kuo\",\"kup\",\"kuq\",\"kus\",\"kut\",\"kuu\",\"kuv\",\"kuw\",\"kux\",\"kuy\",\"kuz\",\"kva\",\"kvb\",\"kvc\",\"kvd\",\"kve\",\"kvf\",\"kvg\",\"kvh\",\"kvi\",\"kvj\",\"kvk\",\"kvl\",\"kvm\",\"kvn\",\"kvo\",\"kvp\",\"kvq\",\"kvr\",\"kvs\",\"kvt\",\"kvu\",\"kvv\",\"kvw\",\"kvx\",\"kvy\",\"kvz\",\"kwa\",\"kwb\",\"kwc\",\"kwd\",\"kwe\",\"kwf\",\"kwg\",\"kwh\",\"kwi\",\"kwj\",\"kwk\",\"kwl\",\"kwm\",\"kwn\",\"kwo\",\"kwp\",\"kwq\",\"kwr\",\"kws\",\"kwt\",\"kwu\",\"kwv\",\"kww\",\"kwx\",\"kwy\",\"kwz\",\"kxa\",\"kxb\",\"kxc\",\"kxd\",\"kxe\",\"kxf\",\"kxh\",\"kxi\",\"kxj\",\"kxk\",\"kxl\",\"kxm\",\"kxn\",\"kxo\",\"kxp\",\"kxq\",\"kxr\",\"kxs\",\"kxt\",\"kxu\",\"kxv\",\"kxw\",\"kxx\",\"kxy\",\"kxz\",\"kya\",\"kyb\",\"kyc\",\"kyd\",\"kye\",\"kyf\",\"kyg\",\"kyh\",\"kyi\",\"kyj\",\"kyk\",\"kyl\",\"kym\",\"kyn\",\"kyo\",\"kyp\",\"kyq\",\"kyr\",\"kys\",\"kyt\",\"kyu\",\"kyv\",\"kyw\",\"kyx\",\"kyy\",\"kyz\",\"kza\",\"kzb\",\"kzc\",\"kzd\",\"kze\",\"kzf\",\"kzg\",\"kzh\",\"kzi\",\"kzj\",\"kzk\",\"kzl\",\"kzm\",\"kzn\",\"kzo\",\"kzp\",\"kzq\",\"kzr\",\"kzs\",\"kzt\",\"kzu\",\"kzv\",\"kzw\",\"kzx\",\"kzy\",\"kzz\",\"laa\",\"lab\",\"lac\",\"lad\",\"lae\",\"laf\",\"lag\",\"lah\",\"lai\",\"laj\",\"lak\",\"lal\",\"lam\",\"lan\",\"lap\",\"laq\",\"lar\",\"las\",\"lau\",\"law\",\"lax\",\"lay\",\"laz\",\"lba\",\"lbb\",\"lbc\",\"lbe\",\"lbf\",\"lbg\",\"lbi\",\"lbj\",\"lbk\",\"lbl\",\"lbm\",\"lbn\",\"lbo\",\"lbq\",\"lbr\",\"lbs\",\"lbt\",\"lbu\",\"lbv\",\"lbw\",\"lbx\",\"lby\",\"lbz\",\"lcc\",\"lcd\",\"lce\",\"lcf\",\"lch\",\"lcl\",\"lcm\",\"lcp\",\"lcq\",\"lcs\",\"lda\",\"ldb\",\"ldd\",\"ldg\",\"ldh\",\"ldi\",\"ldj\",\"ldk\",\"ldl\",\"ldm\",\"ldn\",\"ldo\",\"ldp\",\"ldq\",\"lea\",\"leb\",\"lec\",\"led\",\"lee\",\"lef\",\"leg\",\"leh\",\"lei\",\"lej\",\"lek\",\"lel\",\"lem\",\"len\",\"leo\",\"lep\",\"leq\",\"ler\",\"les\",\"let\",\"leu\",\"lev\",\"lew\",\"lex\",\"ley\",\"lez\",\"lfa\",\"lfn\",\"lga\",\"lgb\",\"lgg\",\"lgh\",\"lgi\",\"lgk\",\"lgl\",\"lgm\",\"lgn\",\"lgq\",\"lgr\",\"lgt\",\"lgu\",\"lgz\",\"lha\",\"lhh\",\"lhi\",\"lhl\",\"lhm\",\"lhn\",\"lhp\",\"lhs\",\"lht\",\"lhu\",\"lia\",\"lib\",\"lic\",\"lid\",\"lie\",\"lif\",\"lig\",\"lih\",\"lii\",\"lij\",\"lik\",\"lil\",\"lio\",\"lip\",\"liq\",\"lir\",\"lis\",\"liu\",\"liv\",\"liw\",\"lix\",\"liy\",\"liz\",\"lja\",\"lje\",\"lji\",\"ljl\",\"ljp\",\"ljw\",\"ljx\",\"lka\",\"lkb\",\"lkc\",\"lkd\",\"lke\",\"lkh\",\"lki\",\"lkj\",\"lkl\",\"lkm\",\"lkn\",\"lko\",\"lkr\",\"lks\",\"lkt\",\"lku\",\"lky\",\"lla\",\"llb\",\"llc\",\"lld\",\"lle\",\"llf\",\"llg\",\"llh\",\"lli\",\"llj\",\"llk\",\"lll\",\"llm\",\"lln\",\"llo\",\"llp\",\"llq\",\"lls\",\"llu\",\"llx\",\"lma\",\"lmb\",\"lmc\",\"lmd\",\"lme\",\"lmf\",\"lmg\",\"lmh\",\"lmi\",\"lmj\",\"lmk\",\"lml\",\"lmm\",\"lmn\",\"lmo\",\"lmp\",\"lmq\",\"lmr\",\"lmu\",\"lmv\",\"lmw\",\"lmx\",\"lmy\",\"lmz\",\"lna\",\"lnb\",\"lnd\",\"lng\",\"lnh\",\"lni\",\"lnj\",\"lnl\",\"lnm\",\"lnn\",\"lno\",\"lns\",\"lnu\",\"lnw\",\"lnz\",\"loa\",\"lob\",\"loc\",\"loe\",\"lof\",\"log\",\"loh\",\"loi\",\"loj\",\"lok\",\"lol\",\"lom\",\"lon\",\"loo\",\"lop\",\"loq\",\"lor\",\"los\",\"lot\",\"lou\",\"lov\",\"low\",\"lox\",\"loy\",\"loz\",\"lpa\",\"lpe\",\"lpn\",\"lpo\",\"lpx\",\"lra\",\"lrc\",\"lre\",\"lrg\",\"lri\",\"lrk\",\"lrl\",\"lrm\",\"lrn\",\"lro\",\"lrr\",\"lrt\",\"lrv\",\"lrz\",\"lsa\",\"lsd\",\"lse\",\"lsg\",\"lsh\",\"lsi\",\"lsl\",\"lsm\",\"lso\",\"lsp\",\"lsr\",\"lss\",\"lst\",\"lsy\",\"ltc\",\"ltg\",\"lti\",\"ltn\",\"lto\",\"lts\",\"ltu\",\"lua\",\"luc\",\"lud\",\"lue\",\"luf\",\"lui\",\"luj\",\"luk\",\"lul\",\"lum\",\"lun\",\"luo\",\"lup\",\"luq\",\"lur\",\"lus\",\"lut\",\"luu\",\"luv\",\"luw\",\"luy\",\"luz\",\"lva\",\"lvk\",\"lvs\",\"lvu\",\"lwa\",\"lwe\",\"lwg\",\"lwh\",\"lwl\",\"lwm\",\"lwo\",\"lwt\",\"lwu\",\"lww\",\"lya\",\"lyg\",\"lyn\",\"lzh\",\"lzl\",\"lzn\",\"lzz\",\"maa\",\"mab\",\"mad\",\"mae\",\"maf\",\"mag\",\"mai\",\"maj\",\"mak\",\"mam\",\"man\",\"map\",\"maq\",\"mas\",\"mat\",\"mau\",\"mav\",\"maw\",\"max\",\"maz\",\"mba\",\"mbb\",\"mbc\",\"mbd\",\"mbe\",\"mbf\",\"mbh\",\"mbi\",\"mbj\",\"mbk\",\"mbl\",\"mbm\",\"mbn\",\"mbo\",\"mbp\",\"mbq\",\"mbr\",\"mbs\",\"mbt\",\"mbu\",\"mbv\",\"mbw\",\"mbx\",\"mby\",\"mbz\",\"mca\",\"mcb\",\"mcc\",\"mcd\",\"mce\",\"mcf\",\"mcg\",\"mch\",\"mci\",\"mcj\",\"mck\",\"mcl\",\"mcm\",\"mcn\",\"mco\",\"mcp\",\"mcq\",\"mcr\",\"mcs\",\"mct\",\"mcu\",\"mcv\",\"mcw\",\"mcx\",\"mcy\",\"mcz\",\"mda\",\"mdb\",\"mdc\",\"mdd\",\"mde\",\"mdf\",\"mdg\",\"mdh\",\"mdi\",\"mdj\",\"mdk\",\"mdl\",\"mdm\",\"mdn\",\"mdp\",\"mdq\",\"mdr\",\"mds\",\"mdt\",\"mdu\",\"mdv\",\"mdw\",\"mdx\",\"mdy\",\"mdz\",\"mea\",\"meb\",\"mec\",\"med\",\"mee\",\"mef\",\"meg\",\"meh\",\"mei\",\"mej\",\"mek\",\"mel\",\"mem\",\"men\",\"meo\",\"mep\",\"meq\",\"mer\",\"mes\",\"met\",\"meu\",\"mev\",\"mew\",\"mey\",\"mez\",\"mfa\",\"mfb\",\"mfc\",\"mfd\",\"mfe\",\"mff\",\"mfg\",\"mfh\",\"mfi\",\"mfj\",\"mfk\",\"mfl\",\"mfm\",\"mfn\",\"mfo\",\"mfp\",\"mfq\",\"mfr\",\"mfs\",\"mft\",\"mfu\",\"mfv\",\"mfw\",\"mfx\",\"mfy\",\"mfz\",\"mga\",\"mgb\",\"mgc\",\"mgd\",\"mge\",\"mgf\",\"mgg\",\"mgh\",\"mgi\",\"mgj\",\"mgk\",\"mgl\",\"mgm\",\"mgn\",\"mgo\",\"mgp\",\"mgq\",\"mgr\",\"mgs\",\"mgt\",\"mgu\",\"mgv\",\"mgw\",\"mgx\",\"mgy\",\"mgz\",\"mha\",\"mhb\",\"mhc\",\"mhd\",\"mhe\",\"mhf\",\"mhg\",\"mhh\",\"mhi\",\"mhj\",\"mhk\",\"mhl\",\"mhm\",\"mhn\",\"mho\",\"mhp\",\"mhq\",\"mhr\",\"mhs\",\"mht\",\"mhu\",\"mhw\",\"mhx\",\"mhy\",\"mhz\",\"mia\",\"mib\",\"mic\",\"mid\",\"mie\",\"mif\",\"mig\",\"mih\",\"mii\",\"mij\",\"mik\",\"mil\",\"mim\",\"min\",\"mio\",\"mip\",\"miq\",\"mir\",\"mis\",\"mit\",\"miu\",\"miw\",\"mix\",\"miy\",\"miz\",\"mja\",\"mjb\",\"mjc\",\"mjd\",\"mje\",\"mjg\",\"mjh\",\"mji\",\"mjj\",\"mjk\",\"mjl\",\"mjm\",\"mjn\",\"mjo\",\"mjp\",\"mjq\",\"mjr\",\"mjs\",\"mjt\",\"mju\",\"mjv\",\"mjw\",\"mjx\",\"mjy\",\"mjz\",\"mka\",\"mkb\",\"mkc\",\"mke\",\"mkf\",\"mkg\",\"mkh\",\"mki\",\"mkj\",\"mkk\",\"mkl\",\"mkm\",\"mkn\",\"mko\",\"mkp\",\"mkq\",\"mkr\",\"mks\",\"mkt\",\"mku\",\"mkv\",\"mkw\",\"mkx\",\"mky\",\"mkz\",\"mla\",\"mlb\",\"mlc\",\"mld\",\"mle\",\"mlf\",\"mlh\",\"mli\",\"mlj\",\"mlk\",\"mll\",\"mlm\",\"mln\",\"mlo\",\"mlp\",\"mlq\",\"mlr\",\"mls\",\"mlu\",\"mlv\",\"mlw\",\"mlx\",\"mlz\",\"mma\",\"mmb\",\"mmc\",\"mmd\",\"mme\",\"mmf\",\"mmg\",\"mmh\",\"mmi\",\"mmj\",\"mmk\",\"mml\",\"mmm\",\"mmn\",\"mmo\",\"mmp\",\"mmq\",\"mmr\",\"mmt\",\"mmu\",\"mmv\",\"mmw\",\"mmx\",\"mmy\",\"mmz\",\"mna\",\"mnb\",\"mnc\",\"mnd\",\"mne\",\"mnf\",\"mng\",\"mnh\",\"mni\",\"mnj\",\"mnk\",\"mnl\",\"mnm\",\"mnn\",\"mno\",\"mnp\",\"mnq\",\"mnr\",\"mns\",\"mnt\",\"mnu\",\"mnv\",\"mnw\",\"mnx\",\"mny\",\"mnz\",\"moa\",\"moc\",\"mod\",\"moe\",\"mof\",\"mog\",\"moh\",\"moi\",\"moj\",\"mok\",\"mom\",\"moo\",\"mop\",\"moq\",\"mor\",\"mos\",\"mot\",\"mou\",\"mov\",\"mow\",\"mox\",\"moy\",\"moz\",\"mpa\",\"mpb\",\"mpc\",\"mpd\",\"mpe\",\"mpg\",\"mph\",\"mpi\",\"mpj\",\"mpk\",\"mpl\",\"mpm\",\"mpn\",\"mpo\",\"mpp\",\"mpq\",\"mpr\",\"mps\",\"mpt\",\"mpu\",\"mpv\",\"mpw\",\"mpx\",\"mpy\",\"mpz\",\"mqa\",\"mqb\",\"mqc\",\"mqe\",\"mqf\",\"mqg\",\"mqh\",\"mqi\",\"mqj\",\"mqk\",\"mql\",\"mqm\",\"mqn\",\"mqo\",\"mqp\",\"mqq\",\"mqr\",\"mqs\",\"mqt\",\"mqu\",\"mqv\",\"mqw\",\"mqx\",\"mqy\",\"mqz\",\"mra\",\"mrb\",\"mrc\",\"mrd\",\"mre\",\"mrf\",\"mrg\",\"mrh\",\"mrj\",\"mrk\",\"mrl\",\"mrm\",\"mrn\",\"mro\",\"mrp\",\"mrq\",\"mrr\",\"mrs\",\"mrt\",\"mru\",\"mrv\",\"mrw\",\"mrx\",\"mry\",\"mrz\",\"msb\",\"msc\",\"msd\",\"mse\",\"msf\",\"msg\",\"msh\",\"msi\",\"msj\",\"msk\",\"msl\",\"msm\",\"msn\",\"mso\",\"msp\",\"msq\",\"msr\",\"mss\",\"mst\",\"msu\",\"msv\",\"msw\",\"msx\",\"msy\",\"msz\",\"mta\",\"mtb\",\"mtc\",\"mtd\",\"mte\",\"mtf\",\"mtg\",\"mth\",\"mti\",\"mtj\",\"mtk\",\"mtl\",\"mtm\",\"mtn\",\"mto\",\"mtp\",\"mtq\",\"mtr\",\"mts\",\"mtt\",\"mtu\",\"mtv\",\"mtw\",\"mtx\",\"mty\",\"mua\",\"mub\",\"muc\",\"mud\",\"mue\",\"mug\",\"muh\",\"mui\",\"muj\",\"muk\",\"mul\",\"mum\",\"mun\",\"muo\",\"mup\",\"muq\",\"mur\",\"mus\",\"mut\",\"muu\",\"muv\",\"mux\",\"muy\",\"muz\",\"mva\",\"mvb\",\"mvd\",\"mve\",\"mvf\",\"mvg\",\"mvh\",\"mvi\",\"mvk\",\"mvl\",\"mvm\",\"mvn\",\"mvo\",\"mvp\",\"mvq\",\"mvr\",\"mvs\",\"mvt\",\"mvu\",\"mvv\",\"mvw\",\"mvx\",\"mvy\",\"mvz\",\"mwa\",\"mwb\",\"mwc\",\"mwd\",\"mwe\",\"mwf\",\"mwg\",\"mwh\",\"mwi\",\"mwj\",\"mwk\",\"mwl\",\"mwm\",\"mwn\",\"mwo\",\"mwp\",\"mwq\",\"mwr\",\"mws\",\"mwt\",\"mwu\",\"mwv\",\"mww\",\"mwx\",\"mwy\",\"mwz\",\"mxa\",\"mxb\",\"mxc\",\"mxd\",\"mxe\",\"mxf\",\"mxg\",\"mxh\",\"mxi\",\"mxj\",\"mxk\",\"mxl\",\"mxm\",\"mxn\",\"mxo\",\"mxp\",\"mxq\",\"mxr\",\"mxs\",\"mxt\",\"mxu\",\"mxv\",\"mxw\",\"mxx\",\"mxy\",\"mxz\",\"myb\",\"myc\",\"myd\",\"mye\",\"myf\",\"myg\",\"myh\",\"myi\",\"myj\",\"myk\",\"myl\",\"mym\",\"myn\",\"myo\",\"myp\",\"myq\",\"myr\",\"mys\",\"myt\",\"myu\",\"myv\",\"myw\",\"myx\",\"myy\",\"myz\",\"mza\",\"mzb\",\"mzc\",\"mzd\",\"mze\",\"mzg\",\"mzh\",\"mzi\",\"mzj\",\"mzk\",\"mzl\",\"mzm\",\"mzn\",\"mzo\",\"mzp\",\"mzq\",\"mzr\",\"mzs\",\"mzt\",\"mzu\",\"mzv\",\"mzw\",\"mzx\",\"mzy\",\"mzz\",\"naa\",\"nab\",\"nac\",\"nad\",\"nae\",\"naf\",\"nag\",\"nah\",\"nai\",\"naj\",\"nak\",\"nal\",\"nam\",\"nan\",\"nao\",\"nap\",\"naq\",\"nar\",\"nas\",\"nat\",\"naw\",\"nax\",\"nay\",\"naz\",\"nba\",\"nbb\",\"nbc\",\"nbd\",\"nbe\",\"nbf\",\"nbg\",\"nbh\",\"nbi\",\"nbj\",\"nbk\",\"nbm\",\"nbn\",\"nbo\",\"nbp\",\"nbq\",\"nbr\",\"nbs\",\"nbt\",\"nbu\",\"nbv\",\"nbw\",\"nbx\",\"nby\",\"nca\",\"ncb\",\"ncc\",\"ncd\",\"nce\",\"ncf\",\"ncg\",\"nch\",\"nci\",\"ncj\",\"nck\",\"ncl\",\"ncm\",\"ncn\",\"nco\",\"ncp\",\"ncr\",\"ncs\",\"nct\",\"ncu\",\"ncx\",\"ncz\",\"nda\",\"ndb\",\"ndc\",\"ndd\",\"ndf\",\"ndg\",\"ndh\",\"ndi\",\"ndj\",\"ndk\",\"ndl\",\"ndm\",\"ndn\",\"ndp\",\"ndq\",\"ndr\",\"nds\",\"ndt\",\"ndu\",\"ndv\",\"ndw\",\"ndx\",\"ndy\",\"ndz\",\"nea\",\"neb\",\"nec\",\"ned\",\"nee\",\"nef\",\"neg\",\"neh\",\"nei\",\"nej\",\"nek\",\"nem\",\"nen\",\"neo\",\"neq\",\"ner\",\"nes\",\"net\",\"neu\",\"nev\",\"new\",\"nex\",\"ney\",\"nez\",\"nfa\",\"nfd\",\"nfl\",\"nfr\",\"nfu\",\"nga\",\"ngb\",\"ngc\",\"ngd\",\"nge\",\"ngf\",\"ngg\",\"ngh\",\"ngi\",\"ngj\",\"ngk\",\"ngl\",\"ngm\",\"ngn\",\"ngo\",\"ngp\",\"ngq\",\"ngr\",\"ngs\",\"ngt\",\"ngu\",\"ngv\",\"ngw\",\"ngx\",\"ngy\",\"ngz\",\"nha\",\"nhb\",\"nhc\",\"nhd\",\"nhe\",\"nhf\",\"nhg\",\"nhh\",\"nhi\",\"nhk\",\"nhm\",\"nhn\",\"nho\",\"nhp\",\"nhq\",\"nhr\",\"nht\",\"nhu\",\"nhv\",\"nhw\",\"nhx\",\"nhy\",\"nhz\",\"nia\",\"nib\",\"nic\",\"nid\",\"nie\",\"nif\",\"nig\",\"nih\",\"nii\",\"nij\",\"nik\",\"nil\",\"nim\",\"nin\",\"nio\",\"niq\",\"nir\",\"nis\",\"nit\",\"niu\",\"niv\",\"niw\",\"nix\",\"niy\",\"niz\",\"nja\",\"njb\",\"njd\",\"njh\",\"nji\",\"njj\",\"njl\",\"njm\",\"njn\",\"njo\",\"njr\",\"njs\",\"njt\",\"nju\",\"njx\",\"njy\",\"njz\",\"nka\",\"nkb\",\"nkc\",\"nkd\",\"nke\",\"nkf\",\"nkg\",\"nkh\",\"nki\",\"nkj\",\"nkk\",\"nkm\",\"nkn\",\"nko\",\"nkp\",\"nkq\",\"nkr\",\"nks\",\"nkt\",\"nku\",\"nkv\",\"nkw\",\"nkx\",\"nkz\",\"nla\",\"nlc\",\"nle\",\"nlg\",\"nli\",\"nlj\",\"nlk\",\"nll\",\"nln\",\"nlo\",\"nlq\",\"nlr\",\"nlu\",\"nlv\",\"nlw\",\"nlx\",\"nly\",\"nlz\",\"nma\",\"nmb\",\"nmc\",\"nmd\",\"nme\",\"nmf\",\"nmg\",\"nmh\",\"nmi\",\"nmj\",\"nmk\",\"nml\",\"nmm\",\"nmn\",\"nmo\",\"nmp\",\"nmq\",\"nmr\",\"nms\",\"nmt\",\"nmu\",\"nmv\",\"nmw\",\"nmx\",\"nmy\",\"nmz\",\"nna\",\"nnb\",\"nnc\",\"nnd\",\"nne\",\"nnf\",\"nng\",\"nnh\",\"nni\",\"nnj\",\"nnk\",\"nnl\",\"nnm\",\"nnn\",\"nnp\",\"nnq\",\"nnr\",\"nns\",\"nnt\",\"nnu\",\"nnv\",\"nnw\",\"nnx\",\"nny\",\"nnz\",\"noa\",\"noc\",\"nod\",\"noe\",\"nof\",\"nog\",\"noh\",\"noi\",\"noj\",\"nok\",\"nol\",\"nom\",\"non\",\"noo\",\"nop\",\"noq\",\"nos\",\"not\",\"nou\",\"nov\",\"now\",\"noy\",\"noz\",\"npa\",\"npb\",\"npg\",\"nph\",\"npi\",\"npl\",\"npn\",\"npo\",\"nps\",\"npu\",\"npy\",\"nqg\",\"nqk\",\"nqm\",\"nqn\",\"nqo\",\"nqq\",\"nqy\",\"nra\",\"nrb\",\"nrc\",\"nre\",\"nrf\",\"nrg\",\"nri\",\"nrk\",\"nrl\",\"nrm\",\"nrn\",\"nrp\",\"nrr\",\"nrt\",\"nru\",\"nrx\",\"nrz\",\"nsa\",\"nsc\",\"nsd\",\"nse\",\"nsf\",\"nsg\",\"nsh\",\"nsi\",\"nsk\",\"nsl\",\"nsm\",\"nsn\",\"nso\",\"nsp\",\"nsq\",\"nsr\",\"nss\",\"nst\",\"nsu\",\"nsv\",\"nsw\",\"nsx\",\"nsy\",\"nsz\",\"ntd\",\"nte\",\"ntg\",\"nti\",\"ntj\",\"ntk\",\"ntm\",\"nto\",\"ntp\",\"ntr\",\"nts\",\"ntu\",\"ntw\",\"ntx\",\"nty\",\"ntz\",\"nua\",\"nub\",\"nuc\",\"nud\",\"nue\",\"nuf\",\"nug\",\"nuh\",\"nui\",\"nuj\",\"nuk\",\"nul\",\"num\",\"nun\",\"nuo\",\"nup\",\"nuq\",\"nur\",\"nus\",\"nut\",\"nuu\",\"nuv\",\"nuw\",\"nux\",\"nuy\",\"nuz\",\"nvh\",\"nvm\",\"nvo\",\"nwa\",\"nwb\",\"nwc\",\"nwe\",\"nwg\",\"nwi\",\"nwm\",\"nwo\",\"nwr\",\"nwx\",\"nwy\",\"nxa\",\"nxd\",\"nxe\",\"nxg\",\"nxi\",\"nxk\",\"nxl\",\"nxm\",\"nxn\",\"nxo\",\"nxq\",\"nxr\",\"nxu\",\"nxx\",\"nyb\",\"nyc\",\"nyd\",\"nye\",\"nyf\",\"nyg\",\"nyh\",\"nyi\",\"nyj\",\"nyk\",\"nyl\",\"nym\",\"nyn\",\"nyo\",\"nyp\",\"nyq\",\"nyr\",\"nys\",\"nyt\",\"nyu\",\"nyv\",\"nyw\",\"nyx\",\"nyy\",\"nza\",\"nzb\",\"nzi\",\"nzk\",\"nzm\",\"nzs\",\"nzu\",\"nzy\",\"nzz\",\"oaa\",\"oac\",\"oar\",\"oav\",\"obi\",\"obk\",\"obl\",\"obm\",\"obo\",\"obr\",\"obt\",\"obu\",\"oca\",\"och\",\"oco\",\"ocu\",\"oda\",\"odk\",\"odt\",\"odu\",\"ofo\",\"ofs\",\"ofu\",\"ogb\",\"ogc\",\"oge\",\"ogg\",\"ogo\",\"ogu\",\"oht\",\"ohu\",\"oia\",\"oin\",\"ojb\",\"ojc\",\"ojg\",\"ojp\",\"ojs\",\"ojv\",\"ojw\",\"oka\",\"okb\",\"okd\",\"oke\",\"okg\",\"okh\",\"oki\",\"okj\",\"okk\",\"okl\",\"okm\",\"okn\",\"oko\",\"okr\",\"oks\",\"oku\",\"okv\",\"okx\",\"ola\",\"old\",\"ole\",\"olk\",\"olm\",\"olo\",\"olr\",\"olt\",\"olu\",\"oma\",\"omb\",\"omc\",\"ome\",\"omg\",\"omi\",\"omk\",\"oml\",\"omn\",\"omo\",\"omp\",\"omq\",\"omr\",\"omt\",\"omu\",\"omv\",\"omw\",\"omx\",\"ona\",\"onb\",\"one\",\"ong\",\"oni\",\"onj\",\"onk\",\"onn\",\"ono\",\"onp\",\"onr\",\"ons\",\"ont\",\"onu\",\"onw\",\"onx\",\"ood\",\"oog\",\"oon\",\"oor\",\"oos\",\"opa\",\"opk\",\"opm\",\"opo\",\"opt\",\"opy\",\"ora\",\"orc\",\"ore\",\"org\",\"orh\",\"orn\",\"oro\",\"orr\",\"ors\",\"ort\",\"oru\",\"orv\",\"orw\",\"orx\",\"ory\",\"orz\",\"osa\",\"osc\",\"osi\",\"oso\",\"osp\",\"ost\",\"osu\",\"osx\",\"ota\",\"otb\",\"otd\",\"ote\",\"oti\",\"otk\",\"otl\",\"otm\",\"otn\",\"oto\",\"otq\",\"otr\",\"ots\",\"ott\",\"otu\",\"otw\",\"otx\",\"oty\",\"otz\",\"oua\",\"oub\",\"oue\",\"oui\",\"oum\",\"oun\",\"ovd\",\"owi\",\"owl\",\"oyb\",\"oyd\",\"oym\",\"oyy\",\"ozm\",\"paa\",\"pab\",\"pac\",\"pad\",\"pae\",\"paf\",\"pag\",\"pah\",\"pai\",\"pak\",\"pal\",\"pam\",\"pao\",\"pap\",\"paq\",\"par\",\"pas\",\"pat\",\"pau\",\"pav\",\"paw\",\"pax\",\"pay\",\"paz\",\"pbb\",\"pbc\",\"pbe\",\"pbf\",\"pbg\",\"pbh\",\"pbi\",\"pbl\",\"pbn\",\"pbo\",\"pbp\",\"pbr\",\"pbs\",\"pbt\",\"pbu\",\"pbv\",\"pby\",\"pbz\",\"pca\",\"pcb\",\"pcc\",\"pcd\",\"pce\",\"pcf\",\"pcg\",\"pch\",\"pci\",\"pcj\",\"pck\",\"pcl\",\"pcm\",\"pcn\",\"pcp\",\"pcr\",\"pcw\",\"pda\",\"pdc\",\"pdi\",\"pdn\",\"pdo\",\"pdt\",\"pdu\",\"pea\",\"peb\",\"ped\",\"pee\",\"pef\",\"peg\",\"peh\",\"pei\",\"pej\",\"pek\",\"pel\",\"pem\",\"peo\",\"pep\",\"peq\",\"pes\",\"pev\",\"pex\",\"pey\",\"pez\",\"pfa\",\"pfe\",\"pfl\",\"pga\",\"pgd\",\"pgg\",\"pgi\",\"pgk\",\"pgl\",\"pgn\",\"pgs\",\"pgu\",\"pgy\",\"pgz\",\"pha\",\"phd\",\"phg\",\"phh\",\"phi\",\"phk\",\"phl\",\"phm\",\"phn\",\"pho\",\"phq\",\"phr\",\"pht\",\"phu\",\"phv\",\"phw\",\"pia\",\"pib\",\"pic\",\"pid\",\"pie\",\"pif\",\"pig\",\"pih\",\"pii\",\"pij\",\"pil\",\"pim\",\"pin\",\"pio\",\"pip\",\"pir\",\"pis\",\"pit\",\"piu\",\"piv\",\"piw\",\"pix\",\"piy\",\"piz\",\"pjt\",\"pka\",\"pkb\",\"pkc\",\"pkg\",\"pkh\",\"pkn\",\"pko\",\"pkp\",\"pkr\",\"pks\",\"pkt\",\"pku\",\"pla\",\"plb\",\"plc\",\"pld\",\"ple\",\"plf\",\"plg\",\"plh\",\"plj\",\"plk\",\"pll\",\"pln\",\"plo\",\"plp\",\"plq\",\"plr\",\"pls\",\"plt\",\"plu\",\"plv\",\"plw\",\"ply\",\"plz\",\"pma\",\"pmb\",\"pmc\",\"pmd\",\"pme\",\"pmf\",\"pmh\",\"pmi\",\"pmj\",\"pmk\",\"pml\",\"pmm\",\"pmn\",\"pmo\",\"pmq\",\"pmr\",\"pms\",\"pmt\",\"pmu\",\"pmw\",\"pmx\",\"pmy\",\"pmz\",\"pna\",\"pnb\",\"pnc\",\"pne\",\"png\",\"pnh\",\"pni\",\"pnj\",\"pnk\",\"pnl\",\"pnm\",\"pnn\",\"pno\",\"pnp\",\"pnq\",\"pnr\",\"pns\",\"pnt\",\"pnu\",\"pnv\",\"pnw\",\"pnx\",\"pny\",\"pnz\",\"poc\",\"pod\",\"poe\",\"pof\",\"pog\",\"poh\",\"poi\",\"pok\",\"pom\",\"pon\",\"poo\",\"pop\",\"poq\",\"pos\",\"pot\",\"pov\",\"pow\",\"pox\",\"poy\",\"poz\",\"ppa\",\"ppe\",\"ppi\",\"ppk\",\"ppl\",\"ppm\",\"ppn\",\"ppo\",\"ppp\",\"ppq\",\"ppr\",\"pps\",\"ppt\",\"ppu\",\"pqa\",\"pqe\",\"pqm\",\"pqw\",\"pra\",\"prb\",\"prc\",\"prd\",\"pre\",\"prf\",\"prg\",\"prh\",\"pri\",\"prk\",\"prl\",\"prm\",\"prn\",\"pro\",\"prp\",\"prq\",\"prr\",\"prs\",\"prt\",\"pru\",\"prw\",\"prx\",\"pry\",\"prz\",\"psa\",\"psc\",\"psd\",\"pse\",\"psg\",\"psh\",\"psi\",\"psl\",\"psm\",\"psn\",\"pso\",\"psp\",\"psq\",\"psr\",\"pss\",\"pst\",\"psu\",\"psw\",\"psy\",\"pta\",\"pth\",\"pti\",\"ptn\",\"pto\",\"ptp\",\"ptq\",\"ptr\",\"ptt\",\"ptu\",\"ptv\",\"ptw\",\"pty\",\"pua\",\"pub\",\"puc\",\"pud\",\"pue\",\"puf\",\"pug\",\"pui\",\"puj\",\"puk\",\"pum\",\"puo\",\"pup\",\"puq\",\"pur\",\"put\",\"puu\",\"puw\",\"pux\",\"puy\",\"puz\",\"pwa\",\"pwb\",\"pwg\",\"pwi\",\"pwm\",\"pwn\",\"pwo\",\"pwr\",\"pww\",\"pxm\",\"pye\",\"pym\",\"pyn\",\"pys\",\"pyu\",\"pyx\",\"pyy\",\"pzn\",\"qaa..qtz\",\"qua\",\"qub\",\"quc\",\"qud\",\"quf\",\"qug\",\"quh\",\"qui\",\"quk\",\"qul\",\"qum\",\"qun\",\"qup\",\"quq\",\"qur\",\"qus\",\"quv\",\"quw\",\"qux\",\"quy\",\"quz\",\"qva\",\"qvc\",\"qve\",\"qvh\",\"qvi\",\"qvj\",\"qvl\",\"qvm\",\"qvn\",\"qvo\",\"qvp\",\"qvs\",\"qvw\",\"qvy\",\"qvz\",\"qwa\",\"qwc\",\"qwe\",\"qwh\",\"qwm\",\"qws\",\"qwt\",\"qxa\",\"qxc\",\"qxh\",\"qxl\",\"qxn\",\"qxo\",\"qxp\",\"qxq\",\"qxr\",\"qxs\",\"qxt\",\"qxu\",\"qxw\",\"qya\",\"qyp\",\"raa\",\"rab\",\"rac\",\"rad\",\"raf\",\"rag\",\"rah\",\"rai\",\"raj\",\"rak\",\"ral\",\"ram\",\"ran\",\"rao\",\"rap\",\"raq\",\"rar\",\"ras\",\"rat\",\"rau\",\"rav\",\"raw\",\"rax\",\"ray\",\"raz\",\"rbb\",\"rbk\",\"rbl\",\"rbp\",\"rcf\",\"rdb\",\"rea\",\"reb\",\"ree\",\"reg\",\"rei\",\"rej\",\"rel\",\"rem\",\"ren\",\"rer\",\"res\",\"ret\",\"rey\",\"rga\",\"rge\",\"rgk\",\"rgn\",\"rgr\",\"rgs\",\"rgu\",\"rhg\",\"rhp\",\"ria\",\"rie\",\"rif\",\"ril\",\"rim\",\"rin\",\"rir\",\"rit\",\"riu\",\"rjg\",\"rji\",\"rjs\",\"rka\",\"rkb\",\"rkh\",\"rki\",\"rkm\",\"rkt\",\"rkw\",\"rma\",\"rmb\",\"rmc\",\"rmd\",\"rme\",\"rmf\",\"rmg\",\"rmh\",\"rmi\",\"rmk\",\"rml\",\"rmm\",\"rmn\",\"rmo\",\"rmp\",\"rmq\",\"rmr\",\"rms\",\"rmt\",\"rmu\",\"rmv\",\"rmw\",\"rmx\",\"rmy\",\"rmz\",\"rna\",\"rnd\",\"rng\",\"rnl\",\"rnn\",\"rnp\",\"rnr\",\"rnw\",\"roa\",\"rob\",\"roc\",\"rod\",\"roe\",\"rof\",\"rog\",\"rol\",\"rom\",\"roo\",\"rop\",\"ror\",\"rou\",\"row\",\"rpn\",\"rpt\",\"rri\",\"rro\",\"rrt\",\"rsb\",\"rsi\",\"rsl\",\"rsm\",\"rtc\",\"rth\",\"rtm\",\"rts\",\"rtw\",\"rub\",\"ruc\",\"rue\",\"ruf\",\"rug\",\"ruh\",\"rui\",\"ruk\",\"ruo\",\"rup\",\"ruq\",\"rut\",\"ruu\",\"ruy\",\"ruz\",\"rwa\",\"rwk\",\"rwm\",\"rwo\",\"rwr\",\"rxd\",\"rxw\",\"ryn\",\"rys\",\"ryu\",\"rzh\",\"saa\",\"sab\",\"sac\",\"sad\",\"sae\",\"saf\",\"sah\",\"sai\",\"saj\",\"sak\",\"sal\",\"sam\",\"sao\",\"sap\",\"saq\",\"sar\",\"sas\",\"sat\",\"sau\",\"sav\",\"saw\",\"sax\",\"say\",\"saz\",\"sba\",\"sbb\",\"sbc\",\"sbd\",\"sbe\",\"sbf\",\"sbg\",\"sbh\",\"sbi\",\"sbj\",\"sbk\",\"sbl\",\"sbm\",\"sbn\",\"sbo\",\"sbp\",\"sbq\",\"sbr\",\"sbs\",\"sbt\",\"sbu\",\"sbv\",\"sbw\",\"sbx\",\"sby\",\"sbz\",\"sca\",\"scb\",\"sce\",\"scf\",\"scg\",\"sch\",\"sci\",\"sck\",\"scl\",\"scn\",\"sco\",\"scp\",\"scq\",\"scs\",\"scu\",\"scv\",\"scw\",\"scx\",\"sda\",\"sdb\",\"sdc\",\"sde\",\"sdf\",\"sdg\",\"sdh\",\"sdj\",\"sdk\",\"sdl\",\"sdm\",\"sdn\",\"sdo\",\"sdp\",\"sdr\",\"sds\",\"sdt\",\"sdu\",\"sdv\",\"sdx\",\"sdz\",\"sea\",\"seb\",\"sec\",\"sed\",\"see\",\"sef\",\"seg\",\"seh\",\"sei\",\"sej\",\"sek\",\"sel\",\"sem\",\"sen\",\"seo\",\"sep\",\"seq\",\"ser\",\"ses\",\"set\",\"seu\",\"sev\",\"sew\",\"sey\",\"sez\",\"sfb\",\"sfe\",\"sfm\",\"sfs\",\"sfw\",\"sga\",\"sgb\",\"sgc\",\"sgd\",\"sge\",\"sgg\",\"sgh\",\"sgi\",\"sgj\",\"sgk\",\"sgl\",\"sgm\",\"sgn\",\"sgo\",\"sgp\",\"sgr\",\"sgs\",\"sgt\",\"sgu\",\"sgw\",\"sgx\",\"sgy\",\"sgz\",\"sha\",\"shb\",\"shc\",\"shd\",\"she\",\"shg\",\"shh\",\"shi\",\"shj\",\"shk\",\"shl\",\"shm\",\"shn\",\"sho\",\"shp\",\"shq\",\"shr\",\"shs\",\"sht\",\"shu\",\"shv\",\"shw\",\"shx\",\"shy\",\"shz\",\"sia\",\"sib\",\"sid\",\"sie\",\"sif\",\"sig\",\"sih\",\"sii\",\"sij\",\"sik\",\"sil\",\"sim\",\"sio\",\"sip\",\"siq\",\"sir\",\"sis\",\"sit\",\"siu\",\"siv\",\"siw\",\"six\",\"siy\",\"siz\",\"sja\",\"sjb\",\"sjd\",\"sje\",\"sjg\",\"sjk\",\"sjl\",\"sjm\",\"sjn\",\"sjo\",\"sjp\",\"sjr\",\"sjs\",\"sjt\",\"sju\",\"sjw\",\"ska\",\"skb\",\"skc\",\"skd\",\"ske\",\"skf\",\"skg\",\"skh\",\"ski\",\"skj\",\"skk\",\"skm\",\"skn\",\"sko\",\"skp\",\"skq\",\"skr\",\"sks\",\"skt\",\"sku\",\"skv\",\"skw\",\"skx\",\"sky\",\"skz\",\"sla\",\"slc\",\"sld\",\"sle\",\"slf\",\"slg\",\"slh\",\"sli\",\"slj\",\"sll\",\"slm\",\"sln\",\"slp\",\"slq\",\"slr\",\"sls\",\"slt\",\"slu\",\"slw\",\"slx\",\"sly\",\"slz\",\"sma\",\"smb\",\"smc\",\"smd\",\"smf\",\"smg\",\"smh\",\"smi\",\"smj\",\"smk\",\"sml\",\"smm\",\"smn\",\"smp\",\"smq\",\"smr\",\"sms\",\"smt\",\"smu\",\"smv\",\"smw\",\"smx\",\"smy\",\"smz\",\"snb\",\"snc\",\"sne\",\"snf\",\"sng\",\"snh\",\"sni\",\"snj\",\"snk\",\"snl\",\"snm\",\"snn\",\"sno\",\"snp\",\"snq\",\"snr\",\"sns\",\"snu\",\"snv\",\"snw\",\"snx\",\"sny\",\"snz\",\"soa\",\"sob\",\"soc\",\"sod\",\"soe\",\"sog\",\"soh\",\"soi\",\"soj\",\"sok\",\"sol\",\"son\",\"soo\",\"sop\",\"soq\",\"sor\",\"sos\",\"sou\",\"sov\",\"sow\",\"sox\",\"soy\",\"soz\",\"spb\",\"spc\",\"spd\",\"spe\",\"spg\",\"spi\",\"spk\",\"spl\",\"spm\",\"spn\",\"spo\",\"spp\",\"spq\",\"spr\",\"sps\",\"spt\",\"spu\",\"spv\",\"spx\",\"spy\",\"sqa\",\"sqh\",\"sqj\",\"sqk\",\"sqm\",\"sqn\",\"sqo\",\"sqq\",\"sqr\",\"sqs\",\"sqt\",\"squ\",\"sra\",\"srb\",\"src\",\"sre\",\"srf\",\"srg\",\"srh\",\"sri\",\"srk\",\"srl\",\"srm\",\"srn\",\"sro\",\"srq\",\"srr\",\"srs\",\"srt\",\"sru\",\"srv\",\"srw\",\"srx\",\"sry\",\"srz\",\"ssa\",\"ssb\",\"ssc\",\"ssd\",\"sse\",\"ssf\",\"ssg\",\"ssh\",\"ssi\",\"ssj\",\"ssk\",\"ssl\",\"ssm\",\"ssn\",\"sso\",\"ssp\",\"ssq\",\"ssr\",\"sss\",\"sst\",\"ssu\",\"ssv\",\"ssx\",\"ssy\",\"ssz\",\"sta\",\"stb\",\"std\",\"ste\",\"stf\",\"stg\",\"sth\",\"sti\",\"stj\",\"stk\",\"stl\",\"stm\",\"stn\",\"sto\",\"stp\",\"stq\",\"str\",\"sts\",\"stt\",\"stu\",\"stv\",\"stw\",\"sty\",\"sua\",\"sub\",\"suc\",\"sue\",\"sug\",\"sui\",\"suj\",\"suk\",\"sul\",\"sum\",\"suq\",\"sur\",\"sus\",\"sut\",\"suv\",\"suw\",\"sux\",\"suy\",\"suz\",\"sva\",\"svb\",\"svc\",\"sve\",\"svk\",\"svm\",\"svr\",\"svs\",\"svx\",\"swb\",\"swc\",\"swf\",\"swg\",\"swh\",\"swi\",\"swj\",\"swk\",\"swl\",\"swm\",\"swn\",\"swo\",\"swp\",\"swq\",\"swr\",\"sws\",\"swt\",\"swu\",\"swv\",\"sww\",\"swx\",\"swy\",\"sxb\",\"sxc\",\"sxe\",\"sxg\",\"sxk\",\"sxl\",\"sxm\",\"sxn\",\"sxo\",\"sxr\",\"sxs\",\"sxu\",\"sxw\",\"sya\",\"syb\",\"syc\",\"syd\",\"syi\",\"syk\",\"syl\",\"sym\",\"syn\",\"syo\",\"syr\",\"sys\",\"syw\",\"syx\",\"syy\",\"sza\",\"szb\",\"szc\",\"szd\",\"sze\",\"szg\",\"szl\",\"szn\",\"szp\",\"szv\",\"szw\",\"taa\",\"tab\",\"tac\",\"tad\",\"tae\",\"taf\",\"tag\",\"tai\",\"taj\",\"tak\",\"tal\",\"tan\",\"tao\",\"tap\",\"taq\",\"tar\",\"tas\",\"tau\",\"tav\",\"taw\",\"tax\",\"tay\",\"taz\",\"tba\",\"tbb\",\"tbc\",\"tbd\",\"tbe\",\"tbf\",\"tbg\",\"tbh\",\"tbi\",\"tbj\",\"tbk\",\"tbl\",\"tbm\",\"tbn\",\"tbo\",\"tbp\",\"tbq\",\"tbr\",\"tbs\",\"tbt\",\"tbu\",\"tbv\",\"tbw\",\"tbx\",\"tby\",\"tbz\",\"tca\",\"tcb\",\"tcc\",\"tcd\",\"tce\",\"tcf\",\"tcg\",\"tch\",\"tci\",\"tck\",\"tcl\",\"tcm\",\"tcn\",\"tco\",\"tcp\",\"tcq\",\"tcs\",\"tct\",\"tcu\",\"tcw\",\"tcx\",\"tcy\",\"tcz\",\"tda\",\"tdb\",\"tdc\",\"tdd\",\"tde\",\"tdf\",\"tdg\",\"tdh\",\"tdi\",\"tdj\",\"tdk\",\"tdl\",\"tdm\",\"tdn\",\"tdo\",\"tdq\",\"tdr\",\"tds\",\"tdt\",\"tdu\",\"tdv\",\"tdx\",\"tdy\",\"tea\",\"teb\",\"tec\",\"ted\",\"tee\",\"tef\",\"teg\",\"teh\",\"tei\",\"tek\",\"tem\",\"ten\",\"teo\",\"tep\",\"teq\",\"ter\",\"tes\",\"tet\",\"teu\",\"tev\",\"tew\",\"tex\",\"tey\",\"tfi\",\"tfn\",\"tfo\",\"tfr\",\"tft\",\"tga\",\"tgb\",\"tgc\",\"tgd\",\"tge\",\"tgf\",\"tgg\",\"tgh\",\"tgi\",\"tgj\",\"tgn\",\"tgo\",\"tgp\",\"tgq\",\"tgr\",\"tgs\",\"tgt\",\"tgu\",\"tgv\",\"tgw\",\"tgx\",\"tgy\",\"tgz\",\"thc\",\"thd\",\"the\",\"thf\",\"thh\",\"thi\",\"thk\",\"thl\",\"thm\",\"thn\",\"thp\",\"thq\",\"thr\",\"ths\",\"tht\",\"thu\",\"thv\",\"thw\",\"thx\",\"thy\",\"thz\",\"tia\",\"tic\",\"tid\",\"tie\",\"tif\",\"tig\",\"tih\",\"tii\",\"tij\",\"tik\",\"til\",\"tim\",\"tin\",\"tio\",\"tip\",\"tiq\",\"tis\",\"tit\",\"tiu\",\"tiv\",\"tiw\",\"tix\",\"tiy\",\"tiz\",\"tja\",\"tjg\",\"tji\",\"tjl\",\"tjm\",\"tjn\",\"tjo\",\"tjs\",\"tju\",\"tjw\",\"tka\",\"tkb\",\"tkd\",\"tke\",\"tkf\",\"tkg\",\"tkk\",\"tkl\",\"tkm\",\"tkn\",\"tkp\",\"tkq\",\"tkr\",\"tks\",\"tkt\",\"tku\",\"tkv\",\"tkw\",\"tkx\",\"tkz\",\"tla\",\"tlb\",\"tlc\",\"tld\",\"tlf\",\"tlg\",\"tlh\",\"tli\",\"tlj\",\"tlk\",\"tll\",\"tlm\",\"tln\",\"tlo\",\"tlp\",\"tlq\",\"tlr\",\"tls\",\"tlt\",\"tlu\",\"tlv\",\"tlw\",\"tlx\",\"tly\",\"tma\",\"tmb\",\"tmc\",\"tmd\",\"tme\",\"tmf\",\"tmg\",\"tmh\",\"tmi\",\"tmj\",\"tmk\",\"tml\",\"tmm\",\"tmn\",\"tmo\",\"tmp\",\"tmq\",\"tmr\",\"tms\",\"tmt\",\"tmu\",\"tmv\",\"tmw\",\"tmy\",\"tmz\",\"tna\",\"tnb\",\"tnc\",\"tnd\",\"tne\",\"tnf\",\"tng\",\"tnh\",\"tni\",\"tnk\",\"tnl\",\"tnm\",\"tnn\",\"tno\",\"tnp\",\"tnq\",\"tnr\",\"tns\",\"tnt\",\"tnu\",\"tnv\",\"tnw\",\"tnx\",\"tny\",\"tnz\",\"tob\",\"toc\",\"tod\",\"toe\",\"tof\",\"tog\",\"toh\",\"toi\",\"toj\",\"tol\",\"tom\",\"too\",\"top\",\"toq\",\"tor\",\"tos\",\"tou\",\"tov\",\"tow\",\"tox\",\"toy\",\"toz\",\"tpa\",\"tpc\",\"tpe\",\"tpf\",\"tpg\",\"tpi\",\"tpj\",\"tpk\",\"tpl\",\"tpm\",\"tpn\",\"tpo\",\"tpp\",\"tpq\",\"tpr\",\"tpt\",\"tpu\",\"tpv\",\"tpw\",\"tpx\",\"tpy\",\"tpz\",\"tqb\",\"tql\",\"tqm\",\"tqn\",\"tqo\",\"tqp\",\"tqq\",\"tqr\",\"tqt\",\"tqu\",\"tqw\",\"tra\",\"trb\",\"trc\",\"trd\",\"tre\",\"trf\",\"trg\",\"trh\",\"tri\",\"trj\",\"trk\",\"trl\",\"trm\",\"trn\",\"tro\",\"trp\",\"trq\",\"trr\",\"trs\",\"trt\",\"tru\",\"trv\",\"trw\",\"trx\",\"try\",\"trz\",\"tsa\",\"tsb\",\"tsc\",\"tsd\",\"tse\",\"tsf\",\"tsg\",\"tsh\",\"tsi\",\"tsj\",\"tsk\",\"tsl\",\"tsm\",\"tsp\",\"tsq\",\"tsr\",\"tss\",\"tst\",\"tsu\",\"tsv\",\"tsw\",\"tsx\",\"tsy\",\"tsz\",\"tta\",\"ttb\",\"ttc\",\"ttd\",\"tte\",\"ttf\",\"ttg\",\"tth\",\"tti\",\"ttj\",\"ttk\",\"ttl\",\"ttm\",\"ttn\",\"tto\",\"ttp\",\"ttq\",\"ttr\",\"tts\",\"ttt\",\"ttu\",\"ttv\",\"ttw\",\"tty\",\"ttz\",\"tua\",\"tub\",\"tuc\",\"tud\",\"tue\",\"tuf\",\"tug\",\"tuh\",\"tui\",\"tuj\",\"tul\",\"tum\",\"tun\",\"tuo\",\"tup\",\"tuq\",\"tus\",\"tut\",\"tuu\",\"tuv\",\"tuw\",\"tux\",\"tuy\",\"tuz\",\"tva\",\"tvd\",\"tve\",\"tvk\",\"tvl\",\"tvm\",\"tvn\",\"tvo\",\"tvs\",\"tvt\",\"tvu\",\"tvw\",\"tvy\",\"twa\",\"twb\",\"twc\",\"twd\",\"twe\",\"twf\",\"twg\",\"twh\",\"twl\",\"twm\",\"twn\",\"two\",\"twp\",\"twq\",\"twr\",\"twt\",\"twu\",\"tww\",\"twx\",\"twy\",\"txa\",\"txb\",\"txc\",\"txe\",\"txg\",\"txh\",\"txi\",\"txj\",\"txm\",\"txn\",\"txo\",\"txq\",\"txr\",\"txs\",\"txt\",\"txu\",\"txx\",\"txy\",\"tya\",\"tye\",\"tyh\",\"tyi\",\"tyj\",\"tyl\",\"tyn\",\"typ\",\"tyr\",\"tys\",\"tyt\",\"tyu\",\"tyv\",\"tyx\",\"tyz\",\"tza\",\"tzh\",\"tzj\",\"tzl\",\"tzm\",\"tzn\",\"tzo\",\"tzx\",\"uam\",\"uan\",\"uar\",\"uba\",\"ubi\",\"ubl\",\"ubr\",\"ubu\",\"uby\",\"uda\",\"ude\",\"udg\",\"udi\",\"udj\",\"udl\",\"udm\",\"udu\",\"ues\",\"ufi\",\"uga\",\"ugb\",\"uge\",\"ugn\",\"ugo\",\"ugy\",\"uha\",\"uhn\",\"uis\",\"uiv\",\"uji\",\"uka\",\"ukg\",\"ukh\",\"ukl\",\"ukp\",\"ukq\",\"uks\",\"uku\",\"ukw\",\"uky\",\"ula\",\"ulb\",\"ulc\",\"ule\",\"ulf\",\"uli\",\"ulk\",\"ull\",\"ulm\",\"uln\",\"ulu\",\"ulw\",\"uma\",\"umb\",\"umc\",\"umd\",\"umg\",\"umi\",\"umm\",\"umn\",\"umo\",\"ump\",\"umr\",\"ums\",\"umu\",\"una\",\"und\",\"une\",\"ung\",\"unk\",\"unm\",\"unn\",\"unp\",\"unr\",\"unu\",\"unx\",\"unz\",\"uok\",\"upi\",\"upv\",\"ura\",\"urb\",\"urc\",\"ure\",\"urf\",\"urg\",\"urh\",\"uri\",\"urj\",\"urk\",\"url\",\"urm\",\"urn\",\"uro\",\"urp\",\"urr\",\"urt\",\"uru\",\"urv\",\"urw\",\"urx\",\"ury\",\"urz\",\"usa\",\"ush\",\"usi\",\"usk\",\"usp\",\"usu\",\"uta\",\"ute\",\"utp\",\"utr\",\"utu\",\"uum\",\"uun\",\"uur\",\"uuu\",\"uve\",\"uvh\",\"uvl\",\"uwa\",\"uya\",\"uzn\",\"uzs\",\"vaa\",\"vae\",\"vaf\",\"vag\",\"vah\",\"vai\",\"vaj\",\"val\",\"vam\",\"van\",\"vao\",\"vap\",\"var\",\"vas\",\"vau\",\"vav\",\"vay\",\"vbb\",\"vbk\",\"vec\",\"ved\",\"vel\",\"vem\",\"veo\",\"vep\",\"ver\",\"vgr\",\"vgt\",\"vic\",\"vid\",\"vif\",\"vig\",\"vil\",\"vin\",\"vis\",\"vit\",\"viv\",\"vka\",\"vki\",\"vkj\",\"vkk\",\"vkl\",\"vkm\",\"vko\",\"vkp\",\"vkt\",\"vku\",\"vlp\",\"vls\",\"vma\",\"vmb\",\"vmc\",\"vmd\",\"vme\",\"vmf\",\"vmg\",\"vmh\",\"vmi\",\"vmj\",\"vmk\",\"vml\",\"vmm\",\"vmp\",\"vmq\",\"vmr\",\"vms\",\"vmu\",\"vmv\",\"vmw\",\"vmx\",\"vmy\",\"vmz\",\"vnk\",\"vnm\",\"vnp\",\"vor\",\"vot\",\"vra\",\"vro\",\"vrs\",\"vrt\",\"vsi\",\"vsl\",\"vsv\",\"vto\",\"vum\",\"vun\",\"vut\",\"vwa\",\"waa\",\"wab\",\"wac\",\"wad\",\"wae\",\"waf\",\"wag\",\"wah\",\"wai\",\"waj\",\"wak\",\"wal\",\"wam\",\"wan\",\"wao\",\"wap\",\"waq\",\"war\",\"was\",\"wat\",\"wau\",\"wav\",\"waw\",\"wax\",\"way\",\"waz\",\"wba\",\"wbb\",\"wbe\",\"wbf\",\"wbh\",\"wbi\",\"wbj\",\"wbk\",\"wbl\",\"wbm\",\"wbp\",\"wbq\",\"wbr\",\"wbt\",\"wbv\",\"wbw\",\"wca\",\"wci\",\"wdd\",\"wdg\",\"wdj\",\"wdk\",\"wdu\",\"wdy\",\"wea\",\"wec\",\"wed\",\"weg\",\"weh\",\"wei\",\"wem\",\"wen\",\"weo\",\"wep\",\"wer\",\"wes\",\"wet\",\"weu\",\"wew\",\"wfg\",\"wga\",\"wgb\",\"wgg\",\"wgi\",\"wgo\",\"wgu\",\"wgw\",\"wgy\",\"wha\",\"whg\",\"whk\",\"whu\",\"wib\",\"wic\",\"wie\",\"wif\",\"wig\",\"wih\",\"wii\",\"wij\",\"wik\",\"wil\",\"wim\",\"win\",\"wir\",\"wit\",\"wiu\",\"wiv\",\"wiw\",\"wiy\",\"wja\",\"wji\",\"wka\",\"wkb\",\"wkd\",\"wkl\",\"wku\",\"wkw\",\"wky\",\"wla\",\"wlc\",\"wle\",\"wlg\",\"wli\",\"wlk\",\"wll\",\"wlm\",\"wlo\",\"wlr\",\"wls\",\"wlu\",\"wlv\",\"wlw\",\"wlx\",\"wly\",\"wma\",\"wmb\",\"wmc\",\"wmd\",\"wme\",\"wmh\",\"wmi\",\"wmm\",\"wmn\",\"wmo\",\"wms\",\"wmt\",\"wmw\",\"wmx\",\"wnb\",\"wnc\",\"wnd\",\"wne\",\"wng\",\"wni\",\"wnk\",\"wnm\",\"wnn\",\"wno\",\"wnp\",\"wnu\",\"wnw\",\"wny\",\"woa\",\"wob\",\"woc\",\"wod\",\"woe\",\"wof\",\"wog\",\"woi\",\"wok\",\"wom\",\"won\",\"woo\",\"wor\",\"wos\",\"wow\",\"woy\",\"wpc\",\"wra\",\"wrb\",\"wrd\",\"wrg\",\"wrh\",\"wri\",\"wrk\",\"wrl\",\"wrm\",\"wrn\",\"wro\",\"wrp\",\"wrr\",\"wrs\",\"wru\",\"wrv\",\"wrw\",\"wrx\",\"wry\",\"wrz\",\"wsa\",\"wsg\",\"wsi\",\"wsk\",\"wsr\",\"wss\",\"wsu\",\"wsv\",\"wtf\",\"wth\",\"wti\",\"wtk\",\"wtm\",\"wtw\",\"wua\",\"wub\",\"wud\",\"wuh\",\"wul\",\"wum\",\"wun\",\"wur\",\"wut\",\"wuu\",\"wuv\",\"wux\",\"wuy\",\"wwa\",\"wwb\",\"wwo\",\"wwr\",\"www\",\"wxa\",\"wxw\",\"wya\",\"wyb\",\"wyi\",\"wym\",\"wyr\",\"wyy\",\"xaa\",\"xab\",\"xac\",\"xad\",\"xae\",\"xag\",\"xai\",\"xaj\",\"xak\",\"xal\",\"xam\",\"xan\",\"xao\",\"xap\",\"xaq\",\"xar\",\"xas\",\"xat\",\"xau\",\"xav\",\"xaw\",\"xay\",\"xba\",\"xbb\",\"xbc\",\"xbd\",\"xbe\",\"xbg\",\"xbi\",\"xbj\",\"xbm\",\"xbn\",\"xbo\",\"xbp\",\"xbr\",\"xbw\",\"xbx\",\"xby\",\"xcb\",\"xcc\",\"xce\",\"xcg\",\"xch\",\"xcl\",\"xcm\",\"xcn\",\"xco\",\"xcr\",\"xct\",\"xcu\",\"xcv\",\"xcw\",\"xcy\",\"xda\",\"xdc\",\"xdk\",\"xdm\",\"xdy\",\"xeb\",\"xed\",\"xeg\",\"xel\",\"xem\",\"xep\",\"xer\",\"xes\",\"xet\",\"xeu\",\"xfa\",\"xga\",\"xgb\",\"xgd\",\"xgf\",\"xgg\",\"xgi\",\"xgl\",\"xgm\",\"xgn\",\"xgr\",\"xgu\",\"xgw\",\"xha\",\"xhc\",\"xhd\",\"xhe\",\"xhr\",\"xht\",\"xhu\",\"xhv\",\"xia\",\"xib\",\"xii\",\"xil\",\"xin\",\"xip\",\"xir\",\"xis\",\"xiv\",\"xiy\",\"xjb\",\"xjt\",\"xka\",\"xkb\",\"xkc\",\"xkd\",\"xke\",\"xkf\",\"xkg\",\"xkh\",\"xki\",\"xkj\",\"xkk\",\"xkl\",\"xkn\",\"xko\",\"xkp\",\"xkq\",\"xkr\",\"xks\",\"xkt\",\"xku\",\"xkv\",\"xkw\",\"xkx\",\"xky\",\"xkz\",\"xla\",\"xlb\",\"xlc\",\"xld\",\"xle\",\"xlg\",\"xli\",\"xln\",\"xlo\",\"xlp\",\"xls\",\"xlu\",\"xly\",\"xma\",\"xmb\",\"xmc\",\"xmd\",\"xme\",\"xmf\",\"xmg\",\"xmh\",\"xmj\",\"xmk\",\"xml\",\"xmm\",\"xmn\",\"xmo\",\"xmp\",\"xmq\",\"xmr\",\"xms\",\"xmt\",\"xmu\",\"xmv\",\"xmw\",\"xmx\",\"xmy\",\"xmz\",\"xna\",\"xnb\",\"xnd\",\"xng\",\"xnh\",\"xni\",\"xnk\",\"xnn\",\"xno\",\"xnr\",\"xns\",\"xnt\",\"xnu\",\"xny\",\"xnz\",\"xoc\",\"xod\",\"xog\",\"xoi\",\"xok\",\"xom\",\"xon\",\"xoo\",\"xop\",\"xor\",\"xow\",\"xpa\",\"xpc\",\"xpe\",\"xpg\",\"xpi\",\"xpj\",\"xpk\",\"xpm\",\"xpn\",\"xpo\",\"xpp\",\"xpq\",\"xpr\",\"xps\",\"xpt\",\"xpu\",\"xpy\",\"xqa\",\"xqt\",\"xra\",\"xrb\",\"xrd\",\"xre\",\"xrg\",\"xri\",\"xrm\",\"xrn\",\"xrq\",\"xrr\",\"xrt\",\"xru\",\"xrw\",\"xsa\",\"xsb\",\"xsc\",\"xsd\",\"xse\",\"xsh\",\"xsi\",\"xsj\",\"xsl\",\"xsm\",\"xsn\",\"xso\",\"xsp\",\"xsq\",\"xsr\",\"xss\",\"xsu\",\"xsv\",\"xsy\",\"xta\",\"xtb\",\"xtc\",\"xtd\",\"xte\",\"xtg\",\"xth\",\"xti\",\"xtj\",\"xtl\",\"xtm\",\"xtn\",\"xto\",\"xtp\",\"xtq\",\"xtr\",\"xts\",\"xtt\",\"xtu\",\"xtv\",\"xtw\",\"xty\",\"xtz\",\"xua\",\"xub\",\"xud\",\"xug\",\"xuj\",\"xul\",\"xum\",\"xun\",\"xuo\",\"xup\",\"xur\",\"xut\",\"xuu\",\"xve\",\"xvi\",\"xvn\",\"xvo\",\"xvs\",\"xwa\",\"xwc\",\"xwd\",\"xwe\",\"xwg\",\"xwj\",\"xwk\",\"xwl\",\"xwo\",\"xwr\",\"xwt\",\"xww\",\"xxb\",\"xxk\",\"xxm\",\"xxr\",\"xxt\",\"xya\",\"xyb\",\"xyj\",\"xyk\",\"xyl\",\"xyt\",\"xyy\",\"xzh\",\"xzm\",\"xzp\",\"yaa\",\"yab\",\"yac\",\"yad\",\"yae\",\"yaf\",\"yag\",\"yah\",\"yai\",\"yaj\",\"yak\",\"yal\",\"yam\",\"yan\",\"yao\",\"yap\",\"yaq\",\"yar\",\"yas\",\"yat\",\"yau\",\"yav\",\"yaw\",\"yax\",\"yay\",\"yaz\",\"yba\",\"ybb\",\"ybd\",\"ybe\",\"ybh\",\"ybi\",\"ybj\",\"ybk\",\"ybl\",\"ybm\",\"ybn\",\"ybo\",\"ybx\",\"yby\",\"ych\",\"ycl\",\"ycn\",\"ycp\",\"yda\",\"ydd\",\"yde\",\"ydg\",\"ydk\",\"yds\",\"yea\",\"yec\",\"yee\",\"yei\",\"yej\",\"yel\",\"yen\",\"yer\",\"yes\",\"yet\",\"yeu\",\"yev\",\"yey\",\"yga\",\"ygi\",\"ygl\",\"ygm\",\"ygp\",\"ygr\",\"ygs\",\"ygu\",\"ygw\",\"yha\",\"yhd\",\"yhl\",\"yhs\",\"yia\",\"yif\",\"yig\",\"yih\",\"yii\",\"yij\",\"yik\",\"yil\",\"yim\",\"yin\",\"yip\",\"yiq\",\"yir\",\"yis\",\"yit\",\"yiu\",\"yiv\",\"yix\",\"yiy\",\"yiz\",\"yka\",\"ykg\",\"yki\",\"ykk\",\"ykl\",\"ykm\",\"ykn\",\"yko\",\"ykr\",\"ykt\",\"yku\",\"yky\",\"yla\",\"ylb\",\"yle\",\"ylg\",\"yli\",\"yll\",\"ylm\",\"yln\",\"ylo\",\"ylr\",\"ylu\",\"yly\",\"yma\",\"ymb\",\"ymc\",\"ymd\",\"yme\",\"ymg\",\"ymh\",\"ymi\",\"ymk\",\"yml\",\"ymm\",\"ymn\",\"ymo\",\"ymp\",\"ymq\",\"ymr\",\"yms\",\"ymt\",\"ymx\",\"ymz\",\"yna\",\"ynd\",\"yne\",\"yng\",\"ynh\",\"ynk\",\"ynl\",\"ynn\",\"yno\",\"ynq\",\"yns\",\"ynu\",\"yob\",\"yog\",\"yoi\",\"yok\",\"yol\",\"yom\",\"yon\",\"yos\",\"yot\",\"yox\",\"yoy\",\"ypa\",\"ypb\",\"ypg\",\"yph\",\"ypk\",\"ypm\",\"ypn\",\"ypo\",\"ypp\",\"ypz\",\"yra\",\"yrb\",\"yre\",\"yri\",\"yrk\",\"yrl\",\"yrm\",\"yrn\",\"yro\",\"yrs\",\"yrw\",\"yry\",\"ysc\",\"ysd\",\"ysg\",\"ysl\",\"ysn\",\"yso\",\"ysp\",\"ysr\",\"yss\",\"ysy\",\"yta\",\"ytl\",\"ytp\",\"ytw\",\"yty\",\"yua\",\"yub\",\"yuc\",\"yud\",\"yue\",\"yuf\",\"yug\",\"yui\",\"yuj\",\"yuk\",\"yul\",\"yum\",\"yun\",\"yup\",\"yuq\",\"yur\",\"yut\",\"yuu\",\"yuw\",\"yux\",\"yuy\",\"yuz\",\"yva\",\"yvt\",\"ywa\",\"ywg\",\"ywl\",\"ywn\",\"ywq\",\"ywr\",\"ywt\",\"ywu\",\"yww\",\"yxa\",\"yxg\",\"yxl\",\"yxm\",\"yxu\",\"yxy\",\"yyr\",\"yyu\",\"yyz\",\"yzg\",\"yzk\",\"zaa\",\"zab\",\"zac\",\"zad\",\"zae\",\"zaf\",\"zag\",\"zah\",\"zai\",\"zaj\",\"zak\",\"zal\",\"zam\",\"zao\",\"zap\",\"zaq\",\"zar\",\"zas\",\"zat\",\"zau\",\"zav\",\"zaw\",\"zax\",\"zay\",\"zaz\",\"zbc\",\"zbe\",\"zbl\",\"zbt\",\"zbw\",\"zca\",\"zch\",\"zdj\",\"zea\",\"zeg\",\"zeh\",\"zen\",\"zga\",\"zgb\",\"zgh\",\"zgm\",\"zgn\",\"zgr\",\"zhb\",\"zhd\",\"zhi\",\"zhn\",\"zhw\",\"zhx\",\"zia\",\"zib\",\"zik\",\"zil\",\"zim\",\"zin\",\"zir\",\"ziw\",\"ziz\",\"zka\",\"zkb\",\"zkd\",\"zkg\",\"zkh\",\"zkk\",\"zkn\",\"zko\",\"zkp\",\"zkr\",\"zkt\",\"zku\",\"zkv\",\"zkz\",\"zle\",\"zlj\",\"zlm\",\"zln\",\"zlq\",\"zls\",\"zlw\",\"zma\",\"zmb\",\"zmc\",\"zmd\",\"zme\",\"zmf\",\"zmg\",\"zmh\",\"zmi\",\"zmj\",\"zmk\",\"zml\",\"zmm\",\"zmn\",\"zmo\",\"zmp\",\"zmq\",\"zmr\",\"zms\",\"zmt\",\"zmu\",\"zmv\",\"zmw\",\"zmx\",\"zmy\",\"zmz\",\"zna\",\"znd\",\"zne\",\"zng\",\"znk\",\"zns\",\"zoc\",\"zoh\",\"zom\",\"zoo\",\"zoq\",\"zor\",\"zos\",\"zpa\",\"zpb\",\"zpc\",\"zpd\",\"zpe\",\"zpf\",\"zpg\",\"zph\",\"zpi\",\"zpj\",\"zpk\",\"zpl\",\"zpm\",\"zpn\",\"zpo\",\"zpp\",\"zpq\",\"zpr\",\"zps\",\"zpt\",\"zpu\",\"zpv\",\"zpw\",\"zpx\",\"zpy\",\"zpz\",\"zqe\",\"zra\",\"zrg\",\"zrn\",\"zro\",\"zrp\",\"zrs\",\"zsa\",\"zsk\",\"zsl\",\"zsm\",\"zsr\",\"zsu\",\"zte\",\"ztg\",\"ztl\",\"ztm\",\"ztn\",\"ztp\",\"ztq\",\"zts\",\"ztt\",\"ztu\",\"ztx\",\"zty\",\"zua\",\"zuh\",\"zum\",\"zun\",\"zuy\",\"zwa\",\"zxx\",\"zyb\",\"zyg\",\"zyj\",\"zyn\",\"zyp\",\"zza\",\"zzj\"],\nevaluate:function(a,b){function c(a){return a.trim().split(\"-\")[0].toLowerCase()}var d,e;return d=(b||[]).map(c),e=[\"lang\",\"xml:lang\"].reduce(function(b,e){var f=a.getAttribute(e);if(\"string\"!=typeof f)return b;var g=c(f);return\"\"!==g&&-1===d.indexOf(g)&&b.push(e+'=\"'+a.getAttribute(e)+'\"'),b},[]),!!e.length&&(this.data(e),!0)}},{id:\"dlitem\",evaluate:function(a,b){return\"DL\"===a.parentNode.tagName}},{id:\"has-listitem\",evaluate:function(a,b){var c=a.children;if(0===c.length)return!0;for(var d=0;d<c.length;d++)if(\"LI\"===c[d].nodeName.toUpperCase())return!1;return!0}},{id:\"listitem\",evaluate:function(a,b){return-1!==[\"UL\",\"OL\"].indexOf(a.parentNode.nodeName.toUpperCase())||\"list\"===a.parentNode.getAttribute(\"role\")}},{id:\"only-dlitems\",evaluate:function(a,b){for(var c,d,e=[],f=a.childNodes,g=[\"STYLE\",\"META\",\"LINK\",\"MAP\",\"AREA\",\"SCRIPT\",\"DATALIST\",\"TEMPLATE\"],h=!1,i=0;i<f.length;i++){c=f[i];var d=c.nodeName.toUpperCase();1===c.nodeType&&\"DT\"!==d&&\"DD\"!==d&&-1===g.indexOf(d)?e.push(c):3===c.nodeType&&\"\"!==c.nodeValue.trim()&&(h=!0)}return e.length&&this.relatedNodes(e),!!e.length||h}},{id:\"only-listitems\",evaluate:function(a,b){for(var c,d,e=[],f=a.childNodes,g=[\"STYLE\",\"META\",\"LINK\",\"MAP\",\"AREA\",\"SCRIPT\",\"DATALIST\",\"TEMPLATE\"],h=!1,i=0;i<f.length;i++)c=f[i],d=c.nodeName.toUpperCase(),1===c.nodeType&&\"LI\"!==d&&-1===g.indexOf(d)?e.push(c):3===c.nodeType&&\"\"!==c.nodeValue.trim()&&(h=!0);return e.length&&this.relatedNodes(e),!!e.length||h}},{id:\"structured-dlitems\",evaluate:function(a,b){var c=a.children;if(!c||!c.length)return!1;for(var d,e=!1,f=!1,g=0;g<c.length;g++){if(d=c[g].nodeName.toUpperCase(),\"DT\"===d&&(e=!0),e&&\"DD\"===d)return!1;\"DD\"===d&&(f=!0)}return e||f}},{id:\"caption\",evaluate:function(a,b){var c=a.querySelectorAll(\"track\");if(c.length){for(var d=0;d<c.length;d++){var e=c[d].getAttribute(\"kind\");if(e&&\"captions\"===e)return!1}return!0}}},{id:\"description\",evaluate:function(a,b){var c=a.querySelectorAll(\"track\");if(c.length){for(var d=0;d<c.length;d++){var e=c[d].getAttribute(\"kind\");if(e&&\"descriptions\"===e)return!1}return!0}}},{id:\"meta-viewport-large\",evaluate:function(a,b){b=b||{};for(var c,d=a.getAttribute(\"content\")||\"\",e=d.split(/[;,]/),f={},g=b.scaleMinimum||2,h=b.lowerBound||!1,i=0,j=e.length;i<j;i++){c=e[i].split(\"=\");var k=c.shift().toLowerCase();k&&c.length&&(f[k.trim()]=c.shift().trim().toLowerCase())}return!!(h&&f[\"maximum-scale\"]&&parseFloat(f[\"maximum-scale\"])<h)||!(!h&&\"no\"===f[\"user-scalable\"])&&!(f[\"maximum-scale\"]&&parseFloat(f[\"maximum-scale\"])<g)},options:{scaleMinimum:5,lowerBound:2}},{id:\"meta-viewport\",evaluate:function(a,b){b=b||{};for(var c,d=a.getAttribute(\"content\")||\"\",e=d.split(/[;,]/),f={},g=b.scaleMinimum||2,h=b.lowerBound||!1,i=0,j=e.length;i<j;i++){c=e[i].split(\"=\");var k=c.shift().toLowerCase();k&&c.length&&(f[k.trim()]=c.shift().trim().toLowerCase())}return!!(h&&f[\"maximum-scale\"]&&parseFloat(f[\"maximum-scale\"])<h)||!(!h&&\"no\"===f[\"user-scalable\"])&&!(f[\"maximum-scale\"]&&parseFloat(f[\"maximum-scale\"])<g)},options:{scaleMinimum:2}},{id:\"header-present\",evaluate:function(a,b){return!!a.querySelector('h1, h2, h3, h4, h5, h6, [role=\"heading\"]')}},{id:\"heading-order\",evaluate:function(a,b){var c=a.getAttribute(\"aria-level\");if(null!==c)return this.data(parseInt(c,10)),!0;var d=a.tagName.match(/H(\\d)/);return!d||(this.data(parseInt(d[1],10)),!0)},after:function(a,b){if(a.length<2)return a;for(var c=a[0].data,d=1;d<a.length;d++)a[d].result&&a[d].data>c+1&&(a[d].result=!1),c=a[d].data;return a}},{id:\"href-no-hash\",evaluate:function(a,b){return\"#\"!==a.getAttribute(\"href\")}},{id:\"internal-link-present\",evaluate:function(a,b){return!!a.querySelector('a[href^=\"#\"]')}},{id:\"landmark\",evaluate:function(a,b){return a.getElementsByTagName(\"main\").length>0||!!a.querySelector('[role=\"main\"]')}},{id:\"meta-refresh\",evaluate:function(a,b){var c=a.getAttribute(\"content\")||\"\",d=c.split(/[;,]/);return\"\"===c||\"0\"===d[0]}},{id:\"p-as-heading\",evaluate:function(a,b){function c(a){for(var b=a,c=a.textContent.trim(),d=c;d===c&&void 0!==b;){var e=-1;if(a=b,0===a.children.length)return a;do{e++,d=a.children[e].textContent.trim()}while(\"\"===d&&e+1<a.children.length);b=a.children[e]}return a}function d(a){switch(a){case\"lighter\":return 100;case\"normal\":return 400;case\"bold\":return 700;case\"bolder\":return 900}return a=parseInt(a),isNaN(a)?400:a}function e(a){var b=window.getComputedStyle(c(a));return{fontWeight:d(b.getPropertyValue(\"font-weight\")),fontSize:parseInt(b.getPropertyValue(\"font-size\")),isItalic:\"italic\"===b.getPropertyValue(\"font-style\")}}function f(a,b,c){return c.reduce(function(c,d){return c||(!d.size||a.fontSize/d.size>b.fontSize)&&(!d.weight||a.fontWeight-d.weight>b.fontWeight)&&(!d.italic||a.isItalic&&!b.isItalic)},!1)}var g=Array.from(a.parentNode.children),h=g.indexOf(a);b=b||{};var i=b.margins||[],j=g.slice(h+1).find(function(a){return\"P\"===a.nodeName.toUpperCase()}),k=g.slice(0,h).reverse().find(function(a){return\"P\"===a.nodeName.toUpperCase()}),l=e(a),m=j?e(j):null,n=k?e(k):null;if(!m||!f(l,m,i))return!0;var o=axe.commons.dom.findUp(a,\"blockquote\");return!!(o&&\"BLOCKQUOTE\"===o.nodeName.toUpperCase()||n&&!f(l,n,i))&&void 0},options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]}},{id:\"region\",evaluate:function(a,b){function c(a){return h&&axe.commons.dom.isFocusable(axe.commons.dom.getElementByReference(h,\"href\"))&&h===a}function d(a){var b=a.getAttribute(\"role\");return b&&-1!==g.indexOf(b)}function e(a){return d(a)?null:c(a)?f(a):axe.commons.dom.isVisible(a,!0)&&(axe.commons.text.visible(a,!0,!0)||axe.commons.dom.isVisualContent(a))?a:f(a)}function f(a){var b=axe.commons.utils.toArray(a.children);return 0===b.length?[]:b.map(e).filter(function(a){return null!==a}).reduce(function(a,b){return a.concat(b)},[])}var g=axe.commons.aria.getRolesByType(\"landmark\"),h=a.querySelector(\"a[href]\"),i=f(a);return this.relatedNodes(i),!i.length},after:function(a,b){return[a[0]]}},{id:\"skip-link\",evaluate:function(a,b){return axe.commons.dom.isFocusable(axe.commons.dom.getElementByReference(a,\"href\"))},after:function(a,b){return[a[0]]}},{id:\"unique-frame-title\",evaluate:function(a,b){var c=axe.commons.text.sanitize(a.title).trim().toLowerCase();return this.data(c),!0},after:function(a,b){var c={};return a.forEach(function(a){c[a.data]=void 0!==c[a.data]?++c[a.data]:0}),a.forEach(function(a){a.result=!!c[a.data]}),a}},{id:\"aria-label\",evaluate:function(a,b){var c=a.getAttribute(\"aria-label\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"aria-labelledby\",evaluate:function(a,b){return(0,axe.commons.dom.idrefs)(a,\"aria-labelledby\").some(function(a){return a&&axe.commons.text.accessibleText(a,!0)})}},{id:\"button-has-visible-text\",evaluate:function(a,b){var c=a.nodeName.toUpperCase(),d=a.getAttribute(\"role\"),e=void 0;return(\"BUTTON\"===c||\"button\"===d&&\"INPUT\"!==c)&&(e=axe.commons.text.accessibleText(a),this.data(e),!!e)}},{id:\"doc-has-title\",evaluate:function(a,b){var c=document.title;return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"duplicate-id\",evaluate:function(a,b){if(!a.id.trim())return!0;for(var c=document.querySelectorAll('[id=\"'+axe.commons.utils.escapeSelector(a.id)+'\"]'),d=[],e=0;e<c.length;e++)c[e]!==a&&d.push(c[e]);return d.length&&this.relatedNodes(d),this.data(a.getAttribute(\"id\")),c.length<=1},after:function(a,b){var c=[];return a.filter(function(a){return-1===c.indexOf(a.data)&&(c.push(a.data),!0)})}},{id:\"exists\",evaluate:function(a,b){return!0}},{id:\"has-alt\",evaluate:function(a,b){var c=a.nodeName.toLowerCase();return a.hasAttribute(\"alt\")&&(\"img\"===c||\"input\"===c||\"area\"===c)}},{id:\"has-visible-text\",evaluate:function(a,b){return axe.commons.text.accessibleText(a).length>0}},{id:\"is-on-screen\",evaluate:function(a,b){return axe.commons.dom.isVisible(a,!1)&&!axe.commons.dom.isOffscreen(a)}},{id:\"non-empty-alt\",evaluate:function(a,b){var c=a.getAttribute(\"alt\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"non-empty-if-present\",evaluate:function(a,b){var c=a.nodeName.toUpperCase(),d=(a.getAttribute(\"type\")||\"\").toLowerCase(),e=a.getAttribute(\"value\");return this.data(e),\"INPUT\"===c&&-1!==[\"submit\",\"reset\"].indexOf(d)&&null===e}},{id:\"non-empty-title\",evaluate:function(a,b){var c=a.getAttribute(\"title\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"non-empty-value\",evaluate:function(a,b){var c=a.getAttribute(\"value\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")}},{id:\"role-none\",evaluate:function(a,b){return\"none\"===a.getAttribute(\"role\")}},{id:\"role-presentation\",evaluate:function(a,b){return\"presentation\"===a.getAttribute(\"role\")}},{id:\"caption-faked\",evaluate:function(a,b){var c=axe.commons.table.toGrid(a),d=c[0];return c.length<=1||d.length<=1||a.rows.length<=1||d.reduce(function(a,b,c){return a||b!==d[c+1]&&void 0!==d[c+1]},!1)}},{id:\"has-caption\",evaluate:function(a,b){return!!a.caption}},{id:\"has-summary\",evaluate:function(a,b){return!!a.summary}},{id:\"has-th\",evaluate:function(a,b){for(var c,d,e=[],f=0,g=a.rows.length;f<g;f++){c=a.rows[f];for(var h=0,i=c.cells.length;h<i;h++)d=c.cells[h],\"TH\"!==d.nodeName.toUpperCase()&&-1===[\"rowheader\",\"columnheader\"].indexOf(d.getAttribute(\"role\"))||e.push(d)}return!!e.length&&(this.relatedNodes(e),!0)}},{id:\"html5-scope\",evaluate:function(a,b){return!axe.commons.dom.isHTML5(document)||\"TH\"===a.nodeName.toUpperCase()}},{id:\"same-caption-summary\",evaluate:function(a,b){return!(!a.summary||!a.caption)&&a.summary===axe.commons.text.accessibleText(a.caption)}},{id:\"scope-value\",evaluate:function(a,b){b=b||{};var c=a.getAttribute(\"scope\").toLowerCase();return-1!==([\"row\",\"col\",\"rowgroup\",\"colgroup\"]||b.values).indexOf(c)}},{id:\"td-has-header\",evaluate:function(a,b){var c=axe.commons.table,d=[];return c.getAllCells(a).forEach(function(a){if(axe.commons.dom.hasContent(a)&&c.isDataCell(a)&&!axe.commons.aria.label(a)){var b=c.getHeaders(a);(b=b.reduce(function(a,b){return a||null!==b&&!!axe.commons.dom.hasContent(b)},!1))||d.push(a)}}),!d.length||(this.relatedNodes(d),!1)}},{id:\"td-headers-attr\",evaluate:function(a,b){for(var c=[],d=0,e=a.rows.length;d<e;d++)for(var f=a.rows[d],g=0,h=f.cells.length;g<h;g++)c.push(f.cells[g]);var i=c.reduce(function(a,b){return b.id&&a.push(b.id),a},[]),j=c.reduce(function(a,b){var c,d,e=(b.getAttribute(\"headers\")||\"\").split(/\\s/).reduce(function(a,b){return b=b.trim(),b&&a.push(b),a},[]);return 0!==e.length&&(b.id&&(c=-1!==e.indexOf(b.id.trim())),d=e.reduce(function(a,b){return a||-1===i.indexOf(b)},!1),(c||d)&&a.push(b)),a},[]);return!(j.length>0)||(this.relatedNodes(j),!1)}},{id:\"th-has-data-cells\",evaluate:function(a,b){var c=axe.commons.table,d=c.getAllCells(a),e=this,f=[];d.forEach(function(a){var b=a.getAttribute(\"headers\");b&&(f=f.concat(b.split(/\\s+/)));var c=a.getAttribute(\"aria-labelledby\");c&&(f=f.concat(c.split(/\\s+/)))});var g=d.filter(function(a){return\"\"!==axe.commons.text.sanitize(a.textContent)&&(\"TH\"===a.nodeName.toUpperCase()||-1!==[\"rowheader\",\"columnheader\"].indexOf(a.getAttribute(\"role\")))}),h=c.toGrid(a);return!!g.reduce(function(a,b){if(b.id&&-1!==f.indexOf(b.id))return!!a||a;var d=!1,g=c.getCellPosition(b,h);return c.isColumnHeader(b)&&(d=c.traverse(\"down\",g,h).reduce(function(a,b){return a||axe.commons.dom.hasContent(b)&&!c.isColumnHeader(b)},!1)),!d&&c.isRowHeader(b)&&(d=c.traverse(\"right\",g,h).reduce(function(a,b){return a||axe.commons.dom.hasContent(b)&&!c.isRowHeader(b)},!1)),d||e.relatedNodes(b),a&&d},!0)||void 0}}],commons:function(){function a(a){return a.getPropertyValue(\"font-family\").split(/[,;]/g).map(function(a){return a.trim().toLowerCase()})}function b(b,c){var d=window.getComputedStyle(b);if(\"none\"!==d.getPropertyValue(\"background-image\"))return!0;if([\"border-bottom\",\"border-top\",\"outline\"].reduce(function(a,b){var c=new v.Color;return c.parseRgbString(d.getPropertyValue(b+\"-color\")),a||\"none\"!==d.getPropertyValue(b+\"-style\")&&parseFloat(d.getPropertyValue(b+\"-width\"))>0&&0!==c.alpha},!1))return!0;var e=window.getComputedStyle(c);if(a(d)[0]!==a(e)[0])return!0;var f=[\"text-decoration-line\",\"text-decoration-style\",\"font-weight\",\"font-style\",\"font-size\"].reduce(function(a,b){return a||d.getPropertyValue(b)!==e.getPropertyValue(b)},!1),g=d.getPropertyValue(\"text-decoration\");return g.split(\" \").length<3&&(f=f||g!==e.getPropertyValue(\"text-decoration\")),f}function c(a,b){var c=a.nodeName.toUpperCase();if(z.includes(c))return axe.commons.color.incompleteData.set(\"bgColor\",{reason:\"imgNode\"}),!0;b=b||window.getComputedStyle(a);var d=b.getPropertyValue(\"background-image\"),e=\"none\"!==d;if(e){var f=/gradient/.test(d);axe.commons.color.incompleteData.set(\"bgColor\",{reason:f?\"bgGradient\":\"bgImage\"})}return e}function d(a,b){b=b||window.getComputedStyle(a);var c=new v.Color;if(c.parseRgbString(b.getPropertyValue(\"background-color\")),0!==c.alpha){var d=b.getPropertyValue(\"opacity\");c.alpha=c.alpha*d}return c}function e(a,b){var c=0;if(a>0)for(var e=a-1;e>=0;e--){var f=b[e],g=window.getComputedStyle(f),h=d(f,g);h.alpha?c+=h.alpha:b.splice(e,1)}return c}function f(a,b,c){return a!==b&&!w.visuallyContains(a,b)&&0!==c.alpha}function g(a,b){\"use strict\";var c=b(a);for(a=a.firstChild;a;)!1!==c&&g(a,b),a=a.nextSibling}function h(a){\"use strict\";var b=window.getComputedStyle(a).getPropertyValue(\"display\");return-1!==A.indexOf(b)||\"table-\"===b.substr(0,6)}function i(a){\"use strict\";var b=a.match(/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/);return!(!b||5!==b.length)&&(b[3]-b[1]<=0&&b[2]-b[4]<=0)}function j(a){var b=null;return a.id&&(b=document.querySelector('label[for=\"'+axe.utils.escapeSelector(a.id)+'\"]'))?b:b=w.findUp(a,\"label\")}function k(a){return-1!==[\"button\",\"reset\",\"submit\"].indexOf(a.type)}function l(a){var b=a.nodeName.toUpperCase();return\"TEXTAREA\"===b||\"SELECT\"===b||\"INPUT\"===b&&\"hidden\"!==a.type.toLowerCase()}function m(a){return-1!==[\"BUTTON\",\"SUMMARY\",\"A\"].indexOf(a.nodeName.toUpperCase())}function n(a){return-1!==[\"TABLE\",\"FIGURE\"].indexOf(a.nodeName.toUpperCase())}function o(a){var b=a.nodeName.toUpperCase();if(\"INPUT\"===b)return!a.hasAttribute(\"type\")||-1!==D.indexOf(a.getAttribute(\"type\").toLowerCase())&&a.value?a.value:\"\";if(\"SELECT\"===b){var c=a.options;if(c&&c.length){for(var d=\"\",e=0;e<c.length;e++)c[e].selected&&(d+=\" \"+c[e].text);return y.sanitize(d)}return\"\"}return\"TEXTAREA\"===b&&a.value?a.value:\"\"}function p(a,b){var c=a.querySelector(b.toLowerCase());return c?y.accessibleText(c):\"\"}function q(a){if(!a)return!1;switch(a.nodeName.toUpperCase()){case\"SELECT\":case\"TEXTAREA\":return!0;case\"INPUT\":return!a.hasAttribute(\"type\")||-1!==D.indexOf(a.getAttribute(\"type\").toLowerCase());default:return!1}}function r(a){var b=a.nodeName.toUpperCase();return\"INPUT\"===b&&\"image\"===a.type.toLowerCase()||-1!==[\"IMG\",\"APPLET\",\"AREA\"].indexOf(b)}function s(a){return!!y.sanitize(a)}var commons={},t=commons.aria={},u=t._lut={};u.attributes={\"aria-activedescendant\":{type:\"idref\"},\"aria-atomic\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-autocomplete\":{type:\"nmtoken\",values:[\"inline\",\"list\",\"both\",\"none\"]},\"aria-busy\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-checked\":{type:\"nmtoken\",values:[\"true\",\"false\",\"mixed\",\"undefined\"]},\"aria-colcount\":{type:\"int\"},\"aria-colindex\":{type:\"int\"},\"aria-colspan\":{type:\"int\"},\"aria-controls\":{type:\"idrefs\"},\"aria-current\":{type:\"nmtoken\",values:[\"page\",\"step\",\"location\",\"date\",\"time\",\"true\",\"false\"]},\"aria-describedby\":{type:\"idrefs\"},\"aria-disabled\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-dropeffect\":{type:\"nmtokens\",values:[\"copy\",\"move\",\"reference\",\"execute\",\"popup\",\"none\"]},\"aria-expanded\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-flowto\":{type:\"idrefs\"},\"aria-grabbed\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-haspopup\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-hidden\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-invalid\":{type:\"nmtoken\",values:[\"true\",\"false\",\"spelling\",\"grammar\"]},\"aria-label\":{type:\"string\"},\"aria-labelledby\":{type:\"idrefs\"},\"aria-level\":{type:\"int\"},\"aria-live\":{type:\"nmtoken\",values:[\"off\",\"polite\",\"assertive\"]},\"aria-multiline\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-multiselectable\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-orientation\":{type:\"nmtoken\",values:[\"horizontal\",\"vertical\"]},\"aria-owns\":{type:\"idrefs\"},\"aria-posinset\":{type:\"int\"},\"aria-pressed\":{type:\"nmtoken\",values:[\"true\",\"false\",\"mixed\",\"undefined\"]},\"aria-readonly\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-relevant\":{type:\"nmtokens\",values:[\"additions\",\"removals\",\"text\",\"all\"]},\"aria-required\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-rowcount\":{type:\"int\"},\"aria-rowindex\":{type:\"int\"},\"aria-rowspan\":{type:\"int\"},\"aria-selected\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-setsize\":{type:\"int\"},\"aria-sort\":{type:\"nmtoken\",values:[\"ascending\",\"descending\",\"other\",\"none\"]},\"aria-valuemax\":{type:\"decimal\"},\"aria-valuemin\":{type:\"decimal\"},\"aria-valuenow\":{type:\"decimal\"},\"aria-valuetext\":{type:\"string\"}},u.globalAttributes=[\"aria-atomic\",\"aria-busy\",\"aria-controls\",\"aria-current\",\"aria-describedby\",\"aria-disabled\",\"aria-dropeffect\",\"aria-flowto\",\"aria-grabbed\",\"aria-haspopup\",\"aria-hidden\",\"aria-invalid\",\"aria-label\",\"aria-labelledby\",\"aria-live\",\"aria-owns\",\"aria-relevant\"],u.role={alert:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},alertdialog:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},application:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},article:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"article\"]},banner:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"header\"]},button:{type:\"widget\",attributes:{allowed:[\"aria-expanded\",\"aria-pressed\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"button\",'input[type=\"button\"]','input[type=\"image\"]','input[type=\"reset\"]','input[type=\"submit\"]',\"summary\"]},cell:{type:\"structure\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-rowindex\",\"aria-rowspan\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"td\",\"th\"]},checkbox:{type:\"widget\",attributes:{required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:['input[type=\"checkbox\"]']},columnheader:{type:\"structure\",attributes:{allowed:[\"aria-expanded\",\"aria-sort\",\"aria-readonly\",\"aria-selected\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"th\"]},combobox:{type:\"composite\",attributes:{required:[\"aria-expanded\"],allowed:[\"aria-autocomplete\",\"aria-required\",\"aria-activedescendant\"]},owned:{all:[\"listbox\",\"textbox\"]},nameFrom:[\"author\"],context:null},command:{nameFrom:[\"author\"],type:\"abstract\"},complementary:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"aside\"]},composite:{nameFrom:[\"author\"],type:\"abstract\"},contentinfo:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"footer\"]},definition:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"dd\"]},dialog:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"dialog\"]},directory:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},document:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"body\"]},form:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"form\"]},grid:{type:\"composite\",attributes:{allowed:[\"aria-level\",\"aria-multiselectable\",\"aria-readonly\",\"aria-activedescendant\",\"aria-expanded\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null,implicit:[\"table\"]},gridcell:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-readonly\",\"aria-expanded\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"td\",\"th\"]},group:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"details\",\"optgroup\"]},heading:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"h1\",\"h2\",\"h3\",\"h4\",\"h5\",\"h6\"]},img:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"img\"]},input:{nameFrom:[\"author\"],type:\"abstract\"},landmark:{nameFrom:[\"author\"],type:\"abstract\"},link:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"a[href]\"]},list:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:{all:[\"listitem\"]},nameFrom:[\"author\"],context:null,implicit:[\"ol\",\"ul\",\"dl\"]},listbox:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-multiselectable\",\"aria-required\",\"aria-expanded\"]},owned:{all:[\"option\"]},nameFrom:[\"author\"],context:null,implicit:[\"select\"]},listitem:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-posinset\",\"aria-setsize\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"list\"],implicit:[\"li\",\"dt\"]},log:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},main:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"main\"]},marquee:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},math:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"math\"]},menu:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:{one:[\"menuitem\",\"menuitemradio\",\"menuitemcheckbox\"]},nameFrom:[\"author\"],context:null,implicit:['menu[type=\"context\"]']},menubar:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},menuitem:{type:\"widget\",attributes:null,owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"command\"]']},menuitemcheckbox:{type:\"widget\",attributes:{required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"checkbox\"]']},menuitemradio:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-posinset\",\"aria-setsize\"],required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"radio\"]']},navigation:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"nav\"]},none:{type:\"structure\",attributes:null,owned:null,nameFrom:[\"author\"],context:null},note:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},option:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-posinset\",\"aria-setsize\",\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"listbox\"],implicit:[\"option\"]},presentation:{type:\"structure\",attributes:null,owned:null,nameFrom:[\"author\"],context:null},progressbar:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"progress\"]},radio:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-posinset\",\"aria-setsize\"],required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:['input[type=\"radio\"]']},radiogroup:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-required\",\"aria-expanded\"]},owned:{all:[\"radio\"]},nameFrom:[\"author\"],context:null},range:{nameFrom:[\"author\"],type:\"abstract\"},region:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"section\"]},roletype:{type:\"abstract\"},row:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-selected\",\"aria-activedescendant\",\"aria-expanded\"]},owned:{one:[\"cell\",\"columnheader\",\"rowheader\",\"gridcell\"]},nameFrom:[\"author\",\"contents\"],context:[\"rowgroup\",\"grid\",\"treegrid\",\"table\"],implicit:[\"tr\"]},rowgroup:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:{all:[\"row\"]},nameFrom:[\"author\",\"contents\"],context:[\"grid\",\"table\"],implicit:[\"tbody\",\"thead\",\"tfoot\"]},rowheader:{type:\"structure\",attributes:{allowed:[\"aria-sort\",\"aria-required\",\"aria-readonly\",\"aria-expanded\",\"aria-selected\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"th\"]},scrollbar:{type:\"widget\",attributes:{required:[\"aria-controls\",\"aria-orientation\",\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"],allowed:[\"aria-valuetext\"]},owned:null,nameFrom:[\"author\"],context:null},search:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},searchbox:{type:\"widget\",attributes:{allowed:[\"aria-activedescendant\",\"aria-autocomplete\",\"aria-multiline\",\"aria-readonly\",\"aria-required\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"search\"]']},section:{nameFrom:[\"author\",\"contents\"],type:\"abstract\"},sectionhead:{nameFrom:[\"author\",\"contents\"],type:\"abstract\"},select:{nameFrom:[\"author\"],type:\"abstract\"},separator:{type:\"structure\",attributes:{allowed:[\"aria-expanded\",\"aria-orientation\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"hr\"]},slider:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-orientation\"],required:[\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"range\"]']},spinbutton:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-required\"],required:[\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"number\"]']},status:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"output\"]},structure:{type:\"abstract\"},switch:{type:\"widget\",attributes:{required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},tab:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"tablist\"]},table:{type:\"structure\",attributes:{allowed:[\"aria-colcount\",\"aria-rowcount\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null,implicit:[\"table\"]},tablist:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-level\",\"aria-multiselectable\"]},owned:{all:[\"tab\"]},nameFrom:[\"author\"],context:null},tabpanel:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},text:{type:\"structure\",owned:null,nameFrom:[\"author\",\"contents\"],context:null},textbox:{type:\"widget\",attributes:{allowed:[\"aria-activedescendant\",\"aria-autocomplete\",\"aria-multiline\",\"aria-readonly\",\"aria-required\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"text\"]','input[type=\"email\"]','input[type=\"password\"]','input[type=\"tel\"]','input[type=\"url\"]',\"input:not([type])\",\"textarea\"]},timer:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},toolbar:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['menu[type=\"toolbar\"]']},tooltip:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},tree:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-multiselectable\",\"aria-required\",\"aria-expanded\"]},owned:{all:[\"treeitem\"]},nameFrom:[\"author\"],context:null},treegrid:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-level\",\"aria-multiselectable\",\"aria-readonly\",\"aria-required\"]},owned:{all:[\"treeitem\"]},nameFrom:[\"author\"],context:null},treeitem:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-selected\",\"aria-expanded\",\"aria-level\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"treegrid\",\"tree\"]},widget:{type:\"abstract\"},window:{nameFrom:[\"author\"],type:\"abstract\"}};var v={};commons.color=v;var w=commons.dom={},x=commons.table={},y=commons.text={};commons.utils=axe.utils;t.requiredAttr=function(a){\"use strict\";var b=u.role[a];return b&&b.attributes&&b.attributes.required||[]},t.allowedAttr=function(a){\"use strict\";var b=u.role[a],c=b&&b.attributes&&b.attributes.allowed||[],d=b&&b.attributes&&b.attributes.required||[];return c.concat(u.globalAttributes).concat(d)},t.validateAttr=function(a){\"use strict\";return!!u.attributes[a]},t.validateAttrValue=function(a,b){\"use strict\";var c,d,e=document,f=a.getAttribute(b),g=u.attributes[b];if(!g)return!0;switch(g.type){case\"boolean\":case\"nmtoken\":return\"string\"==typeof f&&-1!==g.values.indexOf(f.toLowerCase());case\"nmtokens\":return d=axe.utils.tokenList(f),d.reduce(function(a,b){return a&&-1!==g.values.indexOf(b)},0!==d.length);case\"idref\":return!(!f||!e.getElementById(f));case\"idrefs\":return d=axe.utils.tokenList(f),d.reduce(function(a,b){return!(!a||!e.getElementById(b))},0!==d.length);case\"string\":return!0;case\"decimal\":return!(!(c=f.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!c[1]&&!c[2]);case\"int\":return/^[-+]?[0-9]+$/.test(f)}},t.label=function(a){var b,c;return a.getAttribute(\"aria-labelledby\")&&(b=w.idrefs(a,\"aria-labelledby\"),c=b.map(function(a){return a?y.visible(a,!0):\"\"}).join(\" \").trim())?c:(c=a.getAttribute(\"aria-label\"),c&&(c=y.sanitize(c).trim())?c:null)},t.isValidRole=function(a){\"use strict\";return!!u.role[a]},t.getRolesWithNameFromContents=function(){return Object.keys(u.role).filter(function(a){return u.role[a].nameFrom&&-1!==u.role[a].nameFrom.indexOf(\"contents\")})},t.getRolesByType=function(a){return Object.keys(u.role).filter(function(b){return u.role[b].type===a})},t.getRoleType=function(a){var b=u.role[a];return b&&b.type||null},t.requiredOwned=function(a){\"use strict\";var b=null,c=u.role[a];return c&&(b=axe.utils.clone(c.owned)),b},t.requiredContext=function(a){\"use strict\";var b=null,c=u.role[a];return c&&(b=axe.utils.clone(c.context)),b},t.implicitNodes=function(a){\"use strict\";var b=null,c=u.role[a];return c&&c.implicit&&(b=axe.utils.clone(c.implicit)),b},t.implicitRole=function(a){\"use strict\";var b=function(b,c){var d=function(b){return axe.utils.matchesSelector(a,b)};return c.implicit&&c.implicit.some(d)&&b.push(c.name),b},c=Object.keys(u.role).map(function(a){var b=u.role[a];return{name:a,implicit:b&&b.implicit}}),d=c.reduce(b,[]);if(!d.length)return null;for(var e=a.attributes,f=[],g=0,h=e.length;g<h;g++){var i=e[g];i.name.match(/^aria-/)&&f.push(i.name)}return function(a,b){var c=function(a){return t.allowedAttr(a).reduce(function(a,c){return a+(b.indexOf(c)>-1?1:0)},0)};return a.map(function(a){return{score:c(a),name:a}}).sort(function(a,b){return b.score-a.score}).map(function(a){return a.name})}(d,f).shift()},v.Color=function(a,b,c,d){this.red=a,this.green=b,this.blue=c,this.alpha=d,this.toHexString=function(){var a=Math.round(this.red).toString(16),b=Math.round(this.green).toString(16),c=Math.round(this.blue).toString(16);return\"#\"+(this.red>15.5?a:\"0\"+a)+(this.green>15.5?b:\"0\"+b)+(this.blue>15.5?c:\"0\"+c)};this.parseRgbString=function(a){if(\"transparent\"===a)return this.red=0,this.green=0,this.blue=0,void(this.alpha=0);var b=a.match(/^rgb\\((\\d+), (\\d+), (\\d+)\\)$/);return b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),this.blue=parseInt(b[3],10),void(this.alpha=1)):(b=a.match(/^rgba\\((\\d+), (\\d+), (\\d+), (\\d*(\\.\\d+)?)\\)/),b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),\nthis.blue=parseInt(b[3],10),void(this.alpha=parseFloat(b[4]))):void 0)},this.getRelativeLuminance=function(){var a=this.red/255,b=this.green/255,c=this.blue/255;return.2126*(a<=.03928?a/12.92:Math.pow((a+.055)/1.055,2.4))+.7152*(b<=.03928?b/12.92:Math.pow((b+.055)/1.055,2.4))+.0722*(c<=.03928?c/12.92:Math.pow((c+.055)/1.055,2.4))}},v.flattenColors=function(a,b){var c=a.alpha,d=(1-c)*b.red+c*a.red,e=(1-c)*b.green+c*a.green,f=(1-c)*b.blue+c*a.blue,g=a.alpha+b.alpha*(1-a.alpha);return new v.Color(d,e,f,g)},v.getContrast=function(a,b){if(!b||!a)return null;b.alpha<1&&(b=v.flattenColors(b,a));var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(d,c)+.05)/(Math.min(d,c)+.05)},v.hasValidContrastRatio=function(a,b,c,d){var e=v.getContrast(a,b),f=d&&Math.ceil(72*c)/96<14||!d&&Math.ceil(72*c)/96<18;return{isValid:f&&e>=4.5||!f&&e>=3,contrastRatio:e}},v.elementIsDistinct=b;var z=[\"IMG\",\"CANVAS\",\"OBJECT\",\"IFRAME\",\"VIDEO\",\"SVG\"];v.getBackgroundStack=function(a){var b=a.getBoundingClientRect(),f=void 0,g=void 0;if(!(b.left>window.innerWidth||b.top>window.innerHeight)){f=Math.min(Math.ceil(b.left+b.width/2),window.innerWidth-1),g=Math.min(Math.ceil(b.top+b.height/2),window.innerHeight-1);var h=document.elementsFromPoint(f,g);h=w.reduceToElementsBelowFloating(h,a);var i=h.indexOf(document.body);i>1&&!c(document.documentElement)&&0===d(document.documentElement).alpha&&(h.splice(i,1),h.splice(h.indexOf(document.documentElement),1),h.push(document.body));var j=h.indexOf(a);return e(j,h)>=.99?(axe.commons.color.incompleteData.set(\"bgColor\",{reason:\"bgOverlap\"}),null):-1!==j?h:null}},v.getBackgroundColor=function(a){var b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];!0!==(arguments.length>2&&void 0!==arguments[2]&&arguments[2])&&a.scrollIntoView();var e=[],g=v.getBackgroundStack(a);if((g||[]).some(function(g){var h=window.getComputedStyle(g),i=d(g,h);return f(a,g,i)||c(g,h)?(e=null,b.push(g),!0):0!==i.alpha&&(b.push(g),e.push(i),1===i.alpha)}),null!==e&&null!==g){e.push(new v.Color(255,255,255,1));return e.reduce(v.flattenColors)}return null},w.isOpaque=function(a){var b=window.getComputedStyle(a);return c(a,b)||1===d(a,b).alpha},v.getForegroundColor=function(a,b){var c=window.getComputedStyle(a),d=new v.Color;d.parseRgbString(c.getPropertyValue(\"color\"));var e=c.getPropertyValue(\"opacity\");if(d.alpha=d.alpha*e,1===d.alpha)return d;var f=v.getBackgroundColor(a,[],b);if(null===f){var g=axe.commons.color.incompleteData.get(\"bgColor\").reason;return axe.commons.color.incompleteData.set(\"fgColor\",{reason:g}),null}return v.flattenColors(d,f)},v.incompleteData=function(){var a={};return{set:function(b,c){if(\"string\"!=typeof b)throw new Error(\"Incomplete data: key must be a string\");c&&(a[b]=c)},get:function(b){return a[b]},clear:function(){a={}}}}(),w.reduceToElementsBelowFloating=function(a,b){var c,d,e,f=[\"fixed\",\"sticky\"],g=[],h=!1;for(c=0;c<a.length;++c)d=a[c],d===b&&(h=!0),e=window.getComputedStyle(d),h||-1===f.indexOf(e.position)?g.push(d):g=[];return g},w.findUp=function(a,b){\"use strict\";var c,d=document.querySelectorAll(b);if(!d.length)return null;for(d=axe.utils.toArray(d),c=a.parentNode;c&&-1===d.indexOf(c);)c=c.parentNode;return c},w.getElementByReference=function(a,b){\"use strict\";var c,d=a.getAttribute(b),e=document;if(d&&\"#\"===d.charAt(0)){if(d=d.substring(1),c=e.getElementById(d))return c;if(c=e.getElementsByName(d),c.length)return c[0]}return null},w.getElementCoordinates=function(a){\"use strict\";var b=w.getScrollOffset(document),c=b.left,d=b.top,e=a.getBoundingClientRect();return{top:e.top+d,right:e.right+c,bottom:e.bottom+d,left:e.left+c,width:e.right-e.left,height:e.bottom-e.top}},w.getScrollOffset=function(a){\"use strict\";if(!a.nodeType&&a.document&&(a=a.document),9===a.nodeType){var b=a.documentElement,c=a.body;return{left:b&&b.scrollLeft||c&&c.scrollLeft||0,top:b&&b.scrollTop||c&&c.scrollTop||0}}return{left:a.scrollLeft,top:a.scrollTop}},w.getViewportSize=function(a){\"use strict\";var b,c=a.document,d=c.documentElement;return a.innerWidth?{width:a.innerWidth,height:a.innerHeight}:d?{width:d.clientWidth,height:d.clientHeight}:(b=c.body,{width:b.clientWidth,height:b.clientHeight})},w.hasContent=function(a){var b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];if(a.textContent.trim()||t.label(a))return!0;for(var c=a.querySelectorAll(\"*\"),d=0;d<c.length;d++)if(-1===b.indexOf(c[d])&&t.label(c[d])||w.isVisualContent(c[d]))return!0;return!1},w.idrefs=function(a,b){\"use strict\";var c,d,e=document,f=[],g=a.getAttribute(b);if(g)for(g=axe.utils.tokenList(g),c=0,d=g.length;c<d;c++)f.push(e.getElementById(g[c]));return f},w.isFocusable=function(a){\"use strict\";if(!a||a.disabled||!w.isVisible(a)&&\"AREA\"!==a.nodeName.toUpperCase())return!1;switch(a.nodeName.toUpperCase()){case\"A\":case\"AREA\":if(a.href)return!0;break;case\"INPUT\":return\"hidden\"!==a.type;case\"TEXTAREA\":case\"SELECT\":case\"DETAILS\":case\"BUTTON\":return!0}var b=a.getAttribute(\"tabindex\");return!(!b||isNaN(parseInt(b,10)))},w.isHTML5=function(a){var b=a.doctype;return null!==b&&(\"html\"===b.name&&!b.publicId&&!b.systemId)};var A=[\"block\",\"list-item\",\"table\",\"flex\",\"grid\",\"inline-block\"];w.isInTextBlock=function(a){\"use strict\";if(h(a))return!1;for(var b=a.parentNode;1===b.nodeType&&!h(b);)b=b.parentNode;var c=\"\",d=\"\",e=0;return g(b,function(b){if(2===e)return!1;if(3===b.nodeType&&(c+=b.nodeValue),1===b.nodeType){var f=(b.nodeName||\"\").toUpperCase();if(-1!==[\"BR\",\"HR\"].indexOf(f))0===e?(c=\"\",d=\"\"):e=2;else{if(\"none\"===b.style.display||\"hidden\"===b.style.overflow||-1===[\"\",null,\"none\"].indexOf(b.style.float)||-1===[\"\",null,\"relative\"].indexOf(b.style.position))return!1;if(\"A\"===f&&b.href||\"link\"===(b.getAttribute(\"role\")||\"\").toLowerCase())return b===a&&(e=1),d+=b.textContent,!1}}}),c=axe.commons.text.sanitize(c),d=axe.commons.text.sanitize(d),c.length>d.length},w.isNode=function(a){\"use strict\";return a instanceof Node},w.isOffscreen=function(a){\"use strict\";var b,c=document.documentElement,d=window.getComputedStyle(document.body||c).getPropertyValue(\"direction\"),e=w.getElementCoordinates(a);if(e.bottom<0&&function(a,b){for(a=a.parentNode;\"html\"!==a.nodeName.toLowerCase();){if(a.scrollTop&&(b+=a.scrollTop)>=0)return!1;a=a.parentNode}return!0}(a,e.bottom))return!0;if(0===e.left&&0===e.right)return!1;if(\"ltr\"===d){if(e.right<=0)return!0}else if(b=Math.max(c.scrollWidth,w.getViewportSize(window).width),e.left>=b)return!0;return!1},w.isVisible=function(a,b,c){\"use strict\";var d,e=a.nodeName.toUpperCase(),f=a.parentNode;return 9===a.nodeType||null!==(d=window.getComputedStyle(a,null))&&(!(\"none\"===d.getPropertyValue(\"display\")||\"STYLE\"===e.toUpperCase()||\"SCRIPT\"===e.toUpperCase()||!b&&i(d.getPropertyValue(\"clip\"))||!c&&(\"hidden\"===d.getPropertyValue(\"visibility\")||!b&&w.isOffscreen(a))||b&&\"true\"===a.getAttribute(\"aria-hidden\"))&&(!!f&&w.isVisible(f,b,!0)))};var B=[\"checkbox\",\"img\",\"radio\",\"range\",\"slider\",\"spinbutton\",\"textbox\"];w.isVisualContent=function(a){var b=a.getAttribute(\"role\");if(b)return-1!==B.indexOf(b);switch(a.tagName.toUpperCase()){case\"IMG\":case\"IFRAME\":case\"OBJECT\":case\"VIDEO\":case\"AUDIO\":case\"CANVAS\":case\"SVG\":case\"MATH\":case\"BUTTON\":case\"SELECT\":case\"TEXTAREA\":case\"KEYGEN\":case\"PROGRESS\":case\"METER\":return!0;case\"INPUT\":return\"hidden\"!==a.type;default:return!1}},w.visuallyContains=function(a,b){var c=a.getBoundingClientRect(),d={top:c.top+.01,bottom:c.bottom-.01,left:c.left+.01,right:c.right-.01},e=b.getBoundingClientRect(),f=e.top,g=e.left,h={top:f-b.scrollTop,bottom:f-b.scrollTop+b.scrollHeight,left:g-b.scrollLeft,right:g-b.scrollLeft+b.scrollWidth};if(d.left<h.left&&d.left<e.left||d.top<h.top&&d.top<e.top||d.right>h.right&&d.right>e.right||d.bottom>h.bottom&&d.bottom>e.bottom)return!1;var i=window.getComputedStyle(b);return!(d.right>e.right||d.bottom>e.bottom)||(\"scroll\"===i.overflow||\"auto\"===i.overflow||\"hidden\"===i.overflow||b instanceof HTMLBodyElement||b instanceof HTMLHtmlElement)},w.visuallyOverlaps=function(a,b){var c=b.getBoundingClientRect(),d=c.top,e=c.left,f={top:d-b.scrollTop,bottom:d-b.scrollTop+b.scrollHeight,left:e-b.scrollLeft,right:e-b.scrollLeft+b.scrollWidth};if(a.left>f.right&&a.left>c.right||a.top>f.bottom&&a.top>c.bottom||a.right<f.left&&a.right<c.left||a.bottom<f.top&&a.bottom<c.top)return!1;var g=window.getComputedStyle(b);return!(a.left>c.right||a.top>c.bottom)||(\"scroll\"===g.overflow||\"auto\"===g.overflow||b instanceof HTMLBodyElement||b instanceof HTMLHtmlElement)},x.getAllCells=function(a){var b,c,d,e,f=[];for(b=0,d=a.rows.length;b<d;b++)for(c=0,e=a.rows[b].cells.length;c<e;c++)f.push(a.rows[b].cells[c]);return f},x.getCellPosition=function(a,b){var c,d;for(b||(b=x.toGrid(w.findUp(a,\"table\"))),c=0;c<b.length;c++)if(b[c]&&-1!==(d=b[c].indexOf(a)))return{x:d,y:c}},x.getHeaders=function(a){if(a.hasAttribute(\"headers\"))return commons.dom.idrefs(a,\"headers\");var b=commons.table.toGrid(commons.dom.findUp(a,\"table\")),c=commons.table.getCellPosition(a,b);return[].concat(x.traverse(\"left\",c,b).filter(function(a){return x.isRowHeader(a)}),x.traverse(\"up\",c,b).filter(function(a){return x.isColumnHeader(a)})).reverse()},x.getScope=function(a){var b=a.getAttribute(\"scope\"),c=a.getAttribute(\"role\");if(a instanceof Element==!1||-1===[\"TD\",\"TH\"].indexOf(a.nodeName.toUpperCase()))throw new TypeError(\"Expected TD or TH element\");if(\"columnheader\"===c)return\"col\";if(\"rowheader\"===c)return\"row\";if(\"col\"===b||\"row\"===b)return b;if(\"TH\"!==a.nodeName.toUpperCase())return!1;var d=x.toGrid(w.findUp(a,\"table\")),e=x.getCellPosition(a);return d[e.y].reduce(function(a,b){return a&&\"TH\"===b.nodeName.toUpperCase()},!0)?\"col\":d.map(function(a){return a[e.x]}).reduce(function(a,b){return a&&\"TH\"===b.nodeName.toUpperCase()},!0)?\"row\":\"auto\"},x.isColumnHeader=function(a){return-1!==[\"col\",\"auto\"].indexOf(x.getScope(a))},x.isDataCell=function(a){return!(!a.children.length&&!a.textContent.trim())&&\"TD\"===a.nodeName.toUpperCase()},x.isDataTable=function(a){var b=a.getAttribute(\"role\");if((\"presentation\"===b||\"none\"===b)&&!w.isFocusable(a))return!1;if(\"true\"===a.getAttribute(\"contenteditable\")||w.findUp(a,'[contenteditable=\"true\"]'))return!0;if(\"grid\"===b||\"treegrid\"===b||\"table\"===b)return!0;if(\"landmark\"===commons.aria.getRoleType(b))return!0;if(\"0\"===a.getAttribute(\"datatable\"))return!1;if(a.getAttribute(\"summary\"))return!0;if(a.tHead||a.tFoot||a.caption)return!0;for(var c=0,d=a.children.length;c<d;c++)if(\"COLGROUP\"===a.children[c].nodeName.toUpperCase())return!0;for(var e,f,g=0,h=a.rows.length,i=!1,j=0;j<h;j++){e=a.rows[j];for(var k=0,l=e.cells.length;k<l;k++){if(f=e.cells[k],\"TH\"===f.nodeName.toUpperCase())return!0;if(i||f.offsetWidth===f.clientWidth&&f.offsetHeight===f.clientHeight||(i=!0),f.getAttribute(\"scope\")||f.getAttribute(\"headers\")||f.getAttribute(\"abbr\"))return!0;if(-1!==[\"columnheader\",\"rowheader\"].indexOf(f.getAttribute(\"role\")))return!0;if(1===f.children.length&&\"ABBR\"===f.children[0].nodeName.toUpperCase())return!0;g++}}if(a.getElementsByTagName(\"table\").length)return!1;if(h<2)return!1;var m=a.rows[Math.ceil(h/2)];if(1===m.cells.length&&1===m.cells[0].colSpan)return!1;if(m.cells.length>=5)return!0;if(i)return!0;var n,o;for(j=0;j<h;j++){if(e=a.rows[j],n&&n!==window.getComputedStyle(e).getPropertyValue(\"background-color\"))return!0;if(n=window.getComputedStyle(e).getPropertyValue(\"background-color\"),o&&o!==window.getComputedStyle(e).getPropertyValue(\"background-image\"))return!0;o=window.getComputedStyle(e).getPropertyValue(\"background-image\")}return h>=20||!(w.getElementCoordinates(a).width>.95*w.getViewportSize(window).width)&&(!(g<10)&&!a.querySelector(\"object, embed, iframe, applet\"))},x.isHeader=function(a){return!(!x.isColumnHeader(a)&&!x.isRowHeader(a))||!!a.id&&!!document.querySelector('[headers~=\"'+axe.utils.escapeSelector(a.id)+'\"]')},x.isRowHeader=function(a){return-1!==[\"row\",\"auto\"].indexOf(x.getScope(a))},x.toGrid=function(a){for(var b=[],c=a.rows,d=0,e=c.length;d<e;d++){var f=c[d].cells;b[d]=b[d]||[];for(var g=0,h=0,i=f.length;h<i;h++)for(var j=0;j<f[h].colSpan;j++){for(var k=0;k<f[h].rowSpan;k++){for(b[d+k]=b[d+k]||[];b[d+k][g];)g++;b[d+k][g]=f[h]}g++}}return b},x.toArray=x.toGrid,function(a){var b=function a(b,c,d,e){var f,g=d[c.y]?d[c.y][c.x]:void 0;return g?\"function\"==typeof e&&!0===(f=e(g,c,d))?[g]:(f=a(b,{x:c.x+b.x,y:c.y+b.y},d,e),f.unshift(g),f):[]};a.traverse=function(a,c,d,e){if(Array.isArray(c)&&(e=d,d=c,c={x:0,y:0}),\"string\"==typeof a)switch(a){case\"left\":a={x:-1,y:0};break;case\"up\":a={x:0,y:-1};break;case\"right\":a={x:1,y:0};break;case\"down\":a={x:0,y:1}}return b(a,{x:c.x+a.x,y:c.y+a.y},d,e)}}(x);var C={submit:\"Submit\",reset:\"Reset\"},D=[\"text\",\"search\",\"tel\",\"url\",\"email\",\"date\",\"time\",\"number\",\"range\",\"color\"],E=[\"A\",\"EM\",\"STRONG\",\"SMALL\",\"MARK\",\"ABBR\",\"DFN\",\"I\",\"B\",\"S\",\"U\",\"CODE\",\"VAR\",\"SAMP\",\"KBD\",\"SUP\",\"SUB\",\"Q\",\"CITE\",\"SPAN\",\"BDO\",\"BDI\",\"BR\",\"WBR\",\"INS\",\"DEL\",\"IMG\",\"EMBED\",\"OBJECT\",\"IFRAME\",\"MAP\",\"AREA\",\"SCRIPT\",\"NOSCRIPT\",\"RUBY\",\"VIDEO\",\"AUDIO\",\"INPUT\",\"TEXTAREA\",\"SELECT\",\"BUTTON\",\"LABEL\",\"OUTPUT\",\"DATALIST\",\"KEYGEN\",\"PROGRESS\",\"COMMAND\",\"CANVAS\",\"TIME\",\"METER\"];return y.accessibleText=function(a,b){function c(a,b,c){for(var d,e=a.childNodes,g=\"\",h=0;h<e.length;h++)d=e[h],3===d.nodeType?g+=d.textContent:1===d.nodeType&&(-1===E.indexOf(d.nodeName.toUpperCase())&&(g+=\" \"),g+=f(e[h],b,c));return g}function d(a,b,d){var e=\"\",g=a.nodeName.toUpperCase();if(m(a)&&(e=c(a,!1,!1)||\"\",s(e)))return e;if(\"FIGURE\"===g&&(e=p(a,\"figcaption\"),s(e)))return e;if(\"TABLE\"===g){if(e=p(a,\"caption\"),s(e))return e;if(e=a.getAttribute(\"title\")||a.getAttribute(\"summary\")||\"\",s(e))return e}if(r(a))return a.getAttribute(\"alt\")||\"\";if(l(a)&&!d){if(k(a))return a.value||a.title||C[a.type]||\"\";var h=j(a);if(h)return f(h,b,!0)}return\"\"}function e(a,b,c){return!b&&a.hasAttribute(\"aria-labelledby\")?y.sanitize(w.idrefs(a,\"aria-labelledby\").map(function(b){return a===b&&g.pop(),f(b,!0,a!==b)}).join(\" \")):c&&q(a)||!a.hasAttribute(\"aria-label\")?\"\":y.sanitize(a.getAttribute(\"aria-label\"))}var f,g=[];return f=function(a,b,f){\"use strict\";var h;if(null===a||-1!==g.indexOf(a))return\"\";if(!b&&!w.isVisible(a,!0))return\"\";g.push(a);var i=a.getAttribute(\"role\");return h=e(a,b,f),s(h)?h:(h=d(a,b,f),s(h)?h:f&&(h=o(a),s(h))?h:n(a)||i&&-1===t.getRolesWithNameFromContents().indexOf(i)||(h=c(a,b,f),!s(h))?a.hasAttribute(\"title\")?a.getAttribute(\"title\"):\"\":h)},y.sanitize(f(a,b))},y.label=function(a){var b,c;return(c=t.label(a))?c:a.id&&(b=document.querySelector('label[for=\"'+axe.utils.escapeSelector(a.id)+'\"]'),c=b&&y.visible(b,!0))?c:(b=w.findUp(a,\"label\"),(c=b&&y.visible(b,!0))||null)},y.sanitize=function(a){\"use strict\";return a.replace(/\\r\\n/g,\"\\n\").replace(/\\u00A0/g,\" \").replace(/[\\s]{2,}/g,\" \").trim()},y.visible=function(a,b,c){\"use strict\";var d,e,f=a.childNodes,g=f.length,h=\"\";for(d=0;d<g;d++)e=f[d],3===e.nodeType?e.nodeValue&&w.isVisible(a,b)&&(h+=e.nodeValue):c||(h+=y.visible(e,b));return y.sanitize(h)},axe.utils.toArray=function(a){\"use strict\";return Array.prototype.slice.call(a)},axe.utils.tokenList=function(a){\"use strict\";return a.trim().replace(/\\s{2,}/g,\" \").split(\" \")},commons}()})}(\"object\"==typeof window?window:this);";function runA11yChecks(){return window.axe.run(document,{elementRef:true,runOnly:{type:'tag',values:['wcag2a','wcag2aa']},rules:{'tabindex':{enabled:true},'table-fake-caption':{enabled:true},'td-has-header':{enabled:true},'area-alt':{enabled:false},'blink':{enabled:false},'server-side-image-map':{enabled:false}}}).then(axeResult=>{axeResult.violations.forEach(v=>v.nodes.forEach(node=>{node.path=getNodePath(node.element);node.snippet=getOuterHTMLSnippet(node.element);node.element=node.any=node.all=node.none=undefined;}));axeResult={violations:axeResult.violations};return axeResult;});function getNodePath(node){function getNodeIndex(node){let index=0;while(node=node.previousSibling){if(node.nodeType===Node.TEXT_NODE&&node.textContent.trim().length===0)continue;index++;}
return index;}
const path=[];while(node&&node.parentNode){const index=getNodeIndex(node);path.push([index,node.nodeName]);node=node.parentNode;}
path.reverse();return path.join(',');}
function getOuterHTMLSnippet(node){const reOpeningTag=/^.*?\>/;const match=node.outerHTML.match(reOpeningTag);return match&&match[0];}}
class Accessibility extends Gatherer{afterPass(options){const driver=options.driver;const expression=`(function () {
      ${axeLibSource};
      return (${runA11yChecks.toString()}());
    })()`;return driver.evaluateAsync(expression).then(returnedValue=>{if(!returnedValue){throw new Error('No axe-core results returned');}
if(!Array.isArray(returnedValue.violations)){throw new Error('Unable to parse axe results'+returnedValue);}
return returnedValue;});}}
module.exports=Accessibility;},{"./gatherer":15}],"./gatherers/cache-contents":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getCacheContents(){return caches.keys().then(cacheNames=>Promise.all(cacheNames.map(cacheName=>caches.open(cacheName)))).then(caches=>{const requests=[];return Promise.all(caches.map(cache=>{return cache.keys().then(reqs=>{requests.push(...reqs.map(r=>r.url));});})).then(_=>{return requests;});});}
class CacheContents extends Gatherer{afterPass(options){const driver=options.driver;return driver.evaluateAsync(`(${getCacheContents.toString()}())`).then(returnedValue=>{if(!returnedValue||!Array.isArray(returnedValue)){throw new Error('Unable to retrieve cache contents');}
return returnedValue;});}}
module.exports=CacheContents;},{"./gatherer":15}],"./gatherers/chrome-console-messages":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ChromeConsoleMessages extends Gatherer{constructor(){super();this._logEntries=[];this._onConsoleEntryAdded=this.onConsoleEntry.bind(this);}
onConsoleEntry(entry){this._logEntries.push(entry);}
beforePass(options){const driver=options.driver;driver.on('Log.entryAdded',this._onConsoleEntryAdded);return driver.sendCommand('Log.enable').then(()=>driver.sendCommand('Log.startViolationsReport',{config:[{name:'discouragedAPIUse',threshold:-1}]}));}
afterPass(options){return Promise.resolve().then(_=>options.driver.sendCommand('Log.stopViolationsReport')).then(_=>options.driver.off('Log.entryAdded',this._onConsoleEntryAdded)).then(_=>options.driver.sendCommand('Log.disable')).then(_=>this._logEntries);}}
module.exports=ChromeConsoleMessages;},{"./gatherer":15}],"./gatherers/css-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class CSSUsage extends Gatherer{beforePass(options){return options.driver.sendCommand('DOM.enable').then(_=>options.driver.sendCommand('CSS.enable')).then(_=>options.driver.sendCommand('CSS.startRuleUsageTracking')).catch(err=>{if(/startRuleUsageTracking/.test(err.message)){throw new Error('CSS Usage tracking requires Chrome \u2265 56');}
throw err;});}
afterPass(options){const driver=options.driver;return driver.sendCommand('CSS.stopRuleUsageTracking').then(results=>{return driver.sendCommand('CSS.disable').then(_=>driver.sendCommand('DOM.disable')).then(_=>results.ruleUsage);});}}
module.exports=CSSUsage;},{"./gatherer":15}],"./gatherers/dobetterweb/all-event-listeners":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class EventListeners extends Gatherer{listenForScriptParsedEvents(){this._listener=script=>{this._parsedScripts.set(script.scriptId,script);};this.driver.on('Debugger.scriptParsed',this._listener);return this.driver.sendCommand('Debugger.enable');}
unlistenForScriptParsedEvents(){this.driver.off('Debugger.scriptParsed',this._listener);return this.driver.sendCommand('Debugger.disable');}
_listEventListeners(nodeIdOrObject){let promise;if(typeof nodeIdOrObject==='string'){promise=this.driver.sendCommand('Runtime.evaluate',{expression:nodeIdOrObject,objectGroup:'event-listeners-gatherer'});}else{promise=this.driver.sendCommand('DOM.resolveNode',{nodeId:nodeIdOrObject,objectGroup:'event-listeners-gatherer'});}
return promise.then(result=>{const obj=result.object||result.result;return this.driver.sendCommand('DOMDebugger.getEventListeners',{objectId:obj.objectId}).then(results=>{return{listeners:results.listeners,tagName:obj.description};});});}
getEventListeners(nodeId){const matchedListeners=[];return this._listEventListeners(nodeId).then(results=>{results.listeners.forEach(listener=>{const script=this._parsedScripts.get(listener.scriptId);if(script){const combo=Object.assign(listener,script);combo.objectName=results.tagName;combo.line=combo.lineNumber+1;combo.col=combo.columnNumber+1;matchedListeners.push(combo);}});return matchedListeners;});}
collectListeners(nodes){return Promise.all(nodes.map(node=>{return this.getEventListeners(node.element?node.element.nodeId:node);})).then(nestedListeners=>[].concat(...nestedListeners));}
afterPass(options){this.driver=options.driver;this._parsedScripts=new Map();return Promise.resolve().then(()=>this.listenForScriptParsedEvents()).then(()=>this.unlistenForScriptParsedEvents()).then(_=>options.driver.querySelectorAll('body, body /deep/ *')).then(nodes=>{nodes.push('document','window');return this.collectListeners(nodes);});}}
module.exports=EventListeners;},{"../gatherer":15}],"./gatherers/dobetterweb/anchors-with-no-rel-noopener":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class AnchorsWithNoRelNoopener extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelectorAll('a[target="_blank"]:not([rel~="noopener"])').then(failingNodeList=>{const failingNodes=failingNodeList.map(node=>{return Promise.all([node.getAttribute('href'),node.getAttribute('rel'),node.getAttribute('target')]);});return Promise.all(failingNodes);}).then(failingNodes=>{return failingNodes.map(node=>{return{href:node[0],rel:node[1],target:node[2]};});});}}
module.exports=AnchorsWithNoRelNoopener;},{"../gatherer":15}],"./gatherers/dobetterweb/appcache":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class AppCacheManifest extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('html').then(node=>node&&node.getAttribute('manifest'));}}
module.exports=AppCacheManifest;},{"../gatherer":15}],"./gatherers/dobetterweb/domstats":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function createSelectorsLabel(element){let name=element.localName||'';const idAttr=element.getAttribute&&element.getAttribute('id');if(idAttr){name+=`#${idAttr}`;}
if(element.classList){const className=element.classList.toString();if(className){name+=`.${className.trim().replace(/\s+/g,'.')}`;}}else if(ShadowRoot.prototype.isPrototypeOf(element)){name+='#shadow-root';}
return name;}
function elementPathInDOM(element){const path=[createSelectorsLabel(element)];let node=element;while(node){if(ShadowRoot.prototype.isPrototypeOf(node)){const isShadowHost=node.host&&node.localName!=='a';node=isShadowHost?node.host:node.parentElement;}else{const isShadowHost=node.parentNode&&node.parentNode.host&&node.parentNode.localName!=='a';node=isShadowHost?node.parentNode.host:node.parentElement;}
if(node){path.unshift(createSelectorsLabel(node));}}
return path;}
function getDOMStats(element,deep=true){let deepestNode=null;let maxDepth=0;let maxWidth=0;let parentWithMostChildren=null;const _calcDOMWidthAndHeight=function(element,depth=1){if(depth>maxDepth){deepestNode=element;maxDepth=depth;}
if(element.children.length>maxWidth){parentWithMostChildren=element;maxWidth=element.children.length;}
let child=element.firstElementChild;while(child){_calcDOMWidthAndHeight(child,depth+1);if(deep&&child.shadowRoot){_calcDOMWidthAndHeight(child.shadowRoot,depth+1);}
child=child.nextElementSibling;}
return{maxDepth,maxWidth};};const result=_calcDOMWidthAndHeight(element);return{totalDOMNodes:document.querySelectorAll('html, html /deep/ *').length,depth:{max:result.maxDepth,pathToElement:elementPathInDOM(deepestNode)},width:{max:result.maxWidth,pathToElement:elementPathInDOM(parentWithMostChildren)}};}
class DOMStats extends Gatherer{afterPass(options){const expression=`(function() {
      ${createSelectorsLabel.toString()};
      ${elementPathInDOM.toString()};
      return (${getDOMStats.toString()}(document.documentElement));
    })()`;return options.driver.evaluateAsync(expression);}}
module.exports=DOMStats;},{"../gatherer":15}],"./gatherers/dobetterweb/optimized-images":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const URL=require('../../../lib/url-shim');function getOptimizedNumBytes(url){return new Promise(function(resolve,reject){const img=new Image();const canvas=document.createElement('canvas');const context=canvas.getContext('2d');function getTypeStats(type,quality){const dataURI=canvas.toDataURL(type,quality);const base64=dataURI.slice(dataURI.indexOf(',')+1);return{base64:base64.length,binary:atob(base64).length};}
img.addEventListener('error',reject);img.addEventListener('load',()=>{try{canvas.height=img.height;canvas.width=img.width;context.drawImage(img,0,0);const jpeg=getTypeStats('image/jpeg',0.85);const webp=getTypeStats('image/webp',0.85);resolve({jpeg,webp});}catch(err){reject(err);}},false);img.src=url;});}
class OptimizedImages extends Gatherer{static filterImageRequests(pageUrl,networkRecords){const seenUrls=new Set();return networkRecords.reduce((prev,record)=>{if(seenUrls.has(record._url)||!record.finished){return prev;}
seenUrls.add(record._url);const isOptimizableImage=/image\/(png|bmp|jpeg)/.test(record._mimeType);const isSameOrigin=URL.originsMatch(pageUrl,record._url);const isBase64DataUri=/^data:.{2,40}base64\s*,/.test(record._url);if(isOptimizableImage){prev.push({isSameOrigin,isBase64DataUri,requestId:record._requestId,url:record._url,mimeType:record._mimeType,resourceSize:record._resourceSize});}
return prev;},[]);}
calculateImageStats(driver,networkRecord){if(!networkRecord.isSameOrigin&&!networkRecord.isBase64DataUri){return Promise.resolve(null);}
return Promise.resolve(networkRecord.url).then(uri=>{const script=`(${getOptimizedNumBytes.toString()})(${JSON.stringify(uri)})`;return driver.evaluateAsync(script).then(stats=>{if(!stats){return null;}
const isBase64DataUri=networkRecord.isBase64DataUri;const base64Length=networkRecord.url.length-networkRecord.url.indexOf(',')-1;return{originalSize:isBase64DataUri?base64Length:networkRecord.resourceSize,jpegSize:isBase64DataUri?stats.jpeg.base64:stats.jpeg.binary,webpSize:isBase64DataUri?stats.webp.base64:stats.webp.binary};});});}
computeOptimizedImages(driver,imageRecords){return imageRecords.reduce((promise,record)=>{return promise.then(results=>{return this.calculateImageStats(driver,record).catch(err=>({failed:true,err})).then(stats=>{if(!stats){return results;}
return results.concat(Object.assign(stats,record));});});},Promise.resolve([]));}
afterPass(options,traceData){const networkRecords=traceData.networkRecords;const imageRecords=OptimizedImages.filterImageRequests(options.url,networkRecords);return Promise.resolve().then(_=>this.computeOptimizedImages(options.driver,imageRecords)).then(results=>{const successfulResults=results.filter(result=>!result.failed);if(results.length&&!successfulResults.length){throw new Error('All image optimizations failed');}
return results;});}}
module.exports=OptimizedImages;},{"../../../lib/url-shim":27,"../gatherer":15}],"./gatherers/dobetterweb/response-compression":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('../gatherer');const gzip=require('zlib').gzip;const compressionTypes=['gzip','br','deflate'];class ResponseCompression extends Gatherer{static filterUnoptimizedResponses(networkRecords){const unoptimizedResponses=[];networkRecords.forEach(record=>{const isTextBasedResource=record.resourceType()&&record.resourceType().isTextType();if(!isTextBasedResource||!record.resourceSize||!record.finished){return;}
const isContentEncoded=record.responseHeaders.find(header=>header.name.toLowerCase()==='content-encoding'&&compressionTypes.includes(header.value));if(!isContentEncoded){unoptimizedResponses.push({requestId:record.requestId,url:record.url,mimeType:record.mimeType,resourceSize:record.resourceSize});}});return unoptimizedResponses;}
afterPass(options,traceData){const networkRecords=traceData.networkRecords;const textRecords=ResponseCompression.filterUnoptimizedResponses(networkRecords);const driver=options.driver;return Promise.all(textRecords.map(record=>{return driver.getRequestContent(record.requestId).then(content=>{if(!content){record.gzipSize=0;return record;}
return new Promise((resolve,reject)=>{return gzip(content,(err,res)=>{if(err){return reject(err);}
record.gzipSize=Buffer.byteLength(res,'utf8');resolve(record);});});});}));}}
module.exports=ResponseCompression;}).call(this,require("buffer").Buffer);},{"../gatherer":15,"buffer":204,"zlib":201}],"./gatherers/dobetterweb/tags-blocking-first-paint":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function collectTagsThatBlockFirstPaint(){return new Promise((resolve,reject)=>{try{const tagList=[...document.querySelectorAll('link, head script[src]')].filter(tag=>{if(tag.tagName==='SCRIPT'){return!tag.hasAttribute('async')&&!tag.hasAttribute('defer')&&!/^data:/.test(tag.src);}
const blockingStylesheet=tag.rel==='stylesheet'&&window.matchMedia(tag.media).matches&&!tag.disabled;const blockingImport=tag.rel==='import'&&!tag.hasAttribute('async');return blockingStylesheet||blockingImport;}).map(tag=>{return{tagName:tag.tagName,url:tag.tagName==='LINK'?tag.href:tag.src,src:tag.src,href:tag.href,rel:tag.rel,media:tag.media,disabled:tag.disabled};});resolve(tagList);}catch(e){const friendly='Unable to gather Scripts/Stylesheets/HTML Imports on the page';reject(new Error(`${friendly}: ${e.message}`));}});}
function filteredAndIndexedByUrl(networkRecords){return networkRecords.reduce((prev,record)=>{if(!record.finished){return prev;}
const isParserGenerated=record._initiator.type==='parser';const isParserScriptOrStyle=/(css|script)/.test(record._mimeType)&&isParserGenerated;const isFailedRequest=record._failed;const isHtml=record._mimeType&&record._mimeType.includes('html');if(isHtml||isParserScriptOrStyle||isFailedRequest&&isParserGenerated){prev[record._url]={isLinkPreload:record.isLinkPreload,transferSize:record._transferSize,startTime:record._startTime,endTime:record._endTime};}
return prev;},{});}
class TagsBlockingFirstPaint extends Gatherer{constructor(){super();this._filteredAndIndexedByUrl=filteredAndIndexedByUrl;}
static findBlockingTags(driver,networkRecords){const scriptSrc=`(${collectTagsThatBlockFirstPaint.toString()}())`;return driver.evaluateAsync(scriptSrc).then(tags=>{const requests=filteredAndIndexedByUrl(networkRecords);return tags.reduce((prev,tag)=>{const request=requests[tag.url];if(request&&!request.isLinkPreload){prev.push({tag,transferSize:request.transferSize||0,startTime:request.startTime,endTime:request.endTime});requests[tag.url]=null;}
return prev;},[]);});}
afterPass(options,tracingData){return TagsBlockingFirstPaint.findBlockingTags(options.driver,tracingData.networkRecords);}}
module.exports=TagsBlockingFirstPaint;},{"../gatherer":15}],"./gatherers/dobetterweb/websql":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const MAX_WAIT_TIMEOUT=500;class WebSQL extends Gatherer{listenForDatabaseEvents(driver){let timeout;return new Promise((resolve,reject)=>{driver.once('Database.addDatabase',db=>{clearTimeout(timeout);driver.sendCommand('Database.disable').then(_=>resolve(db),reject);});driver.sendCommand('Database.enable').catch(reject);timeout=setTimeout(function(){resolve(null);},MAX_WAIT_TIMEOUT);});}
afterPass(options){return this.listenForDatabaseEvents(options.driver).then(result=>{return result&&result.database;});}}
module.exports=WebSQL;},{"../gatherer":15}],"./gatherers/html-without-javascript":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getBodyText(){const body=document.querySelector('body');return Promise.resolve(body?body.innerText:'');}
class HTMLWithoutJavaScript extends Gatherer{beforePass(options){options.disableJavaScript=true;}
afterPass(options){options.disableJavaScript=false;return options.driver.evaluateAsync(`(${getBodyText.toString()}())`).then(result=>{if(typeof result!=='string'){throw new Error('document body innerText returned by protocol was not a string');}
return{value:result};});}}
module.exports=HTMLWithoutJavaScript;},{"./gatherer":15}],"./gatherers/http-redirect":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class HTTPRedirect extends Gatherer{constructor(){super();this._preRedirectURL=undefined;}
beforePass(options){this._preRedirectURL=options.url;options.url=this._preRedirectURL.replace(/^https/,'http');}
afterPass(options){options.url=this._preRedirectURL;const timeout=options._testTimeout||10000;const securityPromise=options.driver.getSecurityState().then(state=>{return{value:state.schemeIsCryptographic};});let noSecurityChangesTimeout;const timeoutPromise=new Promise((resolve,reject)=>{noSecurityChangesTimeout=setTimeout(_=>{reject(new Error('Timed out waiting for HTTP redirection.'));},timeout);});return Promise.race([securityPromise,timeoutPromise]).then(result=>{clearTimeout(noSecurityChangesTimeout);return result;}).catch(err=>{clearTimeout(noSecurityChangesTimeout);throw err;});}}
module.exports=HTTPRedirect;},{"./gatherer":15}],"./gatherers/image-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function collectImageElementInfo(){function getClientRect(element){const clientRect=element.getBoundingClientRect();return{top:clientRect.top,bottom:clientRect.bottom,left:clientRect.left,right:clientRect.right};}
const htmlImages=[...document.querySelectorAll('img')].map(element=>{return{src:element.currentSrc,clientWidth:element.clientWidth,clientHeight:element.clientHeight,clientRect:getClientRect(element),naturalWidth:element.naturalWidth,naturalHeight:element.naturalHeight,isCss:false,isPicture:element.parentElement.tagName==='PICTURE'};});const CSS_URL_REGEX=/^url\("([^"]+)"\)$/;const CSS_SIZE_REGEX=/(auto|contain|cover)/;const cssImages=[...document.querySelectorAll('html /deep/ *')].reduce((images,element)=>{const style=window.getComputedStyle(element);if(!CSS_URL_REGEX.test(style.backgroundImage)||!CSS_SIZE_REGEX.test(style.backgroundSize)){return images;}
const imageMatch=style.backgroundImage.match(CSS_URL_REGEX);const url=imageMatch[1];const differentImages=images.filter(image=>image.src!==url);if(images.length-differentImages.length>2){return differentImages;}
images.push({src:url,clientWidth:element.clientWidth,clientHeight:element.clientHeight,clientRect:getClientRect(element),naturalWidth:Number.MAX_VALUE,naturalHeight:Number.MAX_VALUE,isCss:true,isPicture:false});return images;},[]);return htmlImages.concat(cssImages);}
function determineNaturalSize(url){return new Promise((resolve,reject)=>{const img=new Image();img.addEventListener('error',reject);img.addEventListener('load',()=>{resolve({naturalWidth:img.naturalWidth,naturalHeight:img.naturalHeight});});img.src=url;});}
class ImageUsage extends Gatherer{fetchElementWithSizeInformation(element){const url=JSON.stringify(element.src);return this.driver.evaluateAsync(`(${determineNaturalSize.toString()})(${url})`).then(size=>{return Object.assign(element,size);});}
afterPass(options,traceData){const driver=this.driver=options.driver;const indexedNetworkRecords=traceData.networkRecords.reduce((map,record)=>{if(/^image/.test(record._mimeType)&&record.finished){map[record._url]={url:record.url,resourceSize:record.resourceSize,startTime:record.startTime,endTime:record.endTime,responseReceivedTime:record.responseReceivedTime,mimeType:record._mimeType};}
return map;},{});return driver.evaluateAsync(`(${collectImageElementInfo.toString()})()`).then(elements=>{return elements.reduce((promise,element)=>{return promise.then(collector=>{element.networkRecord=indexedNetworkRecords[element.src];const elementPromise=(element.isPicture||element.isCss)&&element.networkRecord?this.fetchElementWithSizeInformation(element):Promise.resolve(element);return elementPromise.then(element=>{collector.push(element);return collector;});});},Promise.resolve([]));});}}
module.exports=ImageUsage;},{"./gatherer":15}],"./gatherers/manifest":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const manifestParser=require('../../lib/manifest-parser');class Manifest extends Gatherer{afterPass(options){return options.driver.getAppManifest().then(response=>{return manifestParser(response.data,response.url,options.url);}).catch(err=>{if(err==='No web app manifest found.'){return null;}
return Promise.reject(err);});}}
module.exports=Manifest;},{"../../lib/manifest-parser":22,"./gatherer":15}],"./gatherers/offline":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const URL=require('../../lib/url-shim');class Offline extends Gatherer{beforePass(options){return options.driver.goOffline();}
afterPass(options,tracingData){const navigationRecord=tracingData.networkRecords.filter(record=>{return URL.equalWithExcludedFragments(record._url,options.url)&&record._fetchedViaServiceWorker;}).pop();return options.driver.goOnline(options).then(_=>navigationRecord?navigationRecord.statusCode:-1);}}
module.exports=Offline;},{"../../lib/url-shim":27,"./gatherer":15}],"./gatherers/service-worker":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ServiceWorker extends Gatherer{beforePass(options){const driver=options.driver;return driver.getServiceWorkerVersions().then(data=>{return{versions:data.versions};});}}
module.exports=ServiceWorker;},{"./gatherer":15}],"./gatherers/start-url":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const URL=require('../../lib/url-shim');const manifestParser=require('../../lib/manifest-parser');class StartUrl extends Gatherer{constructor(){super();this.startUrl=null;this.err=null;}
executeFetchRequest(driver,url){return new Promise((resolve,reject)=>{let requestId;const fetchRequestId=data=>{if(URL.equalWithExcludedFragments(data.request.url,url)){requestId=data.requestId;driver.off('Network.requestWillBeSent',fetchRequestId);}};const fetchDone=data=>{if(data.requestId===requestId){driver.off('Network.loadingFinished',fetchDone);driver.off('Network.loadingFailed',fetchDone);resolve();}};driver.on('Network.requestWillBeSent',fetchRequestId);driver.on('Network.loadingFinished',fetchDone);driver.on('Network.loadingFailed',fetchDone);driver.evaluateAsync(`fetch('${url}')
          .then(response => response.status)
          .catch(err => -1)`).catch(err=>reject(err));});}
pass(options){return options.driver.getAppManifest().then(response=>{return manifestParser(response.data,response.url,options.url);}).then(manifest=>{if(!manifest.value.start_url||!manifest.value.start_url.raw){return Promise.reject(new Error(`No web app manifest found on page ${options.url}`));}
if(manifest.value.start_url.debugString){return Promise.reject(new Error(manifest.value.start_url.debugString));}
this.startUrl=manifest.value.start_url.value;}).then(_=>this.executeFetchRequest(options.driver,this.startUrl));}
afterPass(options,tracingData){if(!this.startUrl){return Promise.reject(new Error('No start_url found inside the manifest'));}
const networkRecords=tracingData.networkRecords;const navigationRecord=networkRecords.filter(record=>{return URL.equalWithExcludedFragments(record._url,this.startUrl)&&record._fetchedViaServiceWorker;}).pop();return options.driver.goOnline(options).then(_=>navigationRecord?navigationRecord.statusCode:-1);}}
module.exports=StartUrl;},{"../../lib/manifest-parser":22,"../../lib/url-shim":27,"./gatherer":15}],"./gatherers/styles":[function(require,module,exports){'use strict';const WebInspector=require('../../lib/web-inspector');const Gatherer=require('./gatherer');const log=require('../../lib/log.js');function getCSSPropsInStyleSheet(parseTree){const results=[];parseTree.traverseByType('declaration',function(node,index,parent){if(parent.type==='arguments'){return;}
const keyVal=node.toString().split(':').map(item=>item.trim());results.push({property:{name:keyVal[0],val:keyVal[1]},declarationRange:node.declarationRange,selector:parent.selectors.toString()});});return results;}
class Styles extends Gatherer{constructor(){super();this._activeStyleSheetIds=[];this._activeStyleHeaders={};this._onStyleSheetAdded=this.onStyleSheetAdded.bind(this);this._onStyleSheetRemoved=this.onStyleSheetRemoved.bind(this);}
onStyleSheetAdded(styleHeader){if(styleHeader.header.origin!=='regular'){return;}
this._activeStyleHeaders[styleHeader.header.styleSheetId]=styleHeader;this._activeStyleSheetIds.push(styleHeader.header.styleSheetId);}
onStyleSheetRemoved(styleHeader){delete this._activeStyleHeaders[styleHeader.styleSheetId];const idx=this._activeStyleSheetIds.indexOf(styleHeader.styleSheetId);if(idx!==-1){this._activeStyleSheetIds.splice(idx,1);}}
beginStylesCollect(driver){driver.on('CSS.styleSheetAdded',this._onStyleSheetAdded);driver.on('CSS.styleSheetRemoved',this._onStyleSheetRemoved);return driver.sendCommand('DOM.enable').then(_=>driver.sendCommand('CSS.enable'));}
endStylesCollect(driver){return new Promise((resolve,reject)=>{if(!this._activeStyleSheetIds.length){resolve([]);return;}
const parser=new WebInspector.SCSSParser();const contentPromises=this._activeStyleSheetIds.map(sheetId=>{return driver.sendCommand('CSS.getStyleSheetText',{styleSheetId:sheetId}).then(content=>{const styleHeader=this._activeStyleHeaders[sheetId];styleHeader.content=content.text;const parsedContent=parser.parse(styleHeader.content);if(parsedContent.error){const error=parsedContent.error.toString().slice(0,100);log.warn('Styles Gatherer',`Could not parse content: ${error}…`);styleHeader.parsedContent=[];}else{styleHeader.parsedContent=getCSSPropsInStyleSheet(parsedContent);}
return styleHeader;});});Promise.all(contentPromises).then(styleHeaders=>{driver.off('CSS.styleSheetAdded',this._onStyleSheetAdded);driver.off('CSS.styleSheetRemoved',this._onStyleSheetRemoved);return driver.sendCommand('CSS.disable').then(_=>driver.sendCommand('DOM.disable')).then(_=>resolve(styleHeaders));}).catch(err=>reject(err));});}
beforePass(options){return this.beginStylesCollect(options.driver);}
afterPass(options){return this.endStylesCollect(options.driver).then(stylesheets=>{const map=new Map(stylesheets.map(s=>[s.content,s]));return stylesheets.map(stylesheet=>{const idInMap=map.get(stylesheet.content).header.styleSheetId;stylesheet.isDuplicate=idInMap!==stylesheet.header.styleSheetId;return stylesheet;});});}}
module.exports=Styles;},{"../../lib/log.js":21,"../../lib/web-inspector":28,"./gatherer":15}],"./gatherers/theme-color":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ThemeColor extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('head meta[name="theme-color"]').then(node=>node&&node.getAttribute('content'));}}
module.exports=ThemeColor;},{"./gatherer":15}],"./gatherers/url":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class URL extends Gatherer{afterPass(options){return{initialUrl:options.initialUrl,finalUrl:options.url};}}
module.exports=URL;},{"./gatherer":15}],"./gatherers/viewport-dimensions":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getViewportDimensions(){return Promise.resolve({innerWidth:window.innerWidth,innerHeight:window.innerHeight,outerWidth:window.outerWidth,outerHeight:window.outerHeight,devicePixelRatio:window.devicePixelRatio});}
class ViewportDimensions extends Gatherer{afterPass(options){const driver=options.driver;return driver.evaluateAsync(`(${getViewportDimensions.toString()}())`).then(dimensions=>{const allNumeric=Object.keys(dimensions).every(key=>Number.isFinite(dimensions[key]));if(!allNumeric){const results=JSON.stringify(dimensions);throw new Error(`ViewportDimensions results were not numeric: ${results}`);}
return dimensions;});}}
module.exports=ViewportDimensions;},{"./gatherer":15}],"./gatherers/viewport":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class Viewport extends Gatherer{afterPass(options){const driver=options.driver;return driver.querySelector('head meta[name="viewport"]').then(node=>node&&node.getAttribute('content'));}}
module.exports=Viewport;},{"./gatherer":15}],1:[function(require,module,exports){'use strict';const Audit=require('../audit');const Formatter=require('../../report/formatter');class AxeAudit extends Audit{static audit(artifacts){const violations=artifacts.Accessibility.violations;const rule=violations.find(result=>result.id===this.meta.name);let nodeDetails=[];if(rule&&rule.nodes){nodeDetails=rule.nodes.map(node=>({type:'node',selector:Array.isArray(node.target)?node.target.join(' '):'',path:node.path,snippet:node.snippet}));}
return{rawValue:typeof rule==='undefined',extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.ACCESSIBILITY,value:rule},details:{type:'list',header:{type:'text',text:'View failing elements'},items:nodeDetails}};}}
module.exports=AxeAudit;},{"../../report/formatter":29,"../audit":2}],2:[function(require,module,exports){'use strict';const DEFAULT_PASS='defaultPass';class Audit{static get DEFAULT_PASS(){return DEFAULT_PASS;}
static get SCORING_MODES(){return{NUMERIC:'numeric',BINARY:'binary'};}
static get meta(){throw new Error('Audit meta information must be overridden.');}
static generateErrorAuditResult(audit,debugString){return Audit.generateAuditResult(audit,{rawValue:null,error:true,debugString});}
static makeV1TableHeadings(headings){const tableHeadings={};headings.forEach(heading=>tableHeadings[heading.key]=heading.text);return tableHeadings;}
static makeV2TableRows(headings,results){const tableRows=results.map(item=>{return headings.map(heading=>{const value=item[heading.key];if(typeof value==='object'&&value&&value.type)return value;return{type:heading.itemType,text:value};});});return tableRows;}
static makeV2TableHeaders(headings){return headings.map(heading=>({type:'text',itemType:heading.itemType,text:heading.text}));}
static makeV2TableDetails(headings,results){const v2TableHeaders=Audit.makeV2TableHeaders(headings);const v2TableRows=Audit.makeV2TableRows(headings,results);return{type:'table',header:'View Details',itemHeaders:v2TableHeaders,items:v2TableRows};}
static generateAuditResult(audit,result){if(typeof result.rawValue==='undefined'){throw new Error('generateAuditResult requires a rawValue');}
const score=typeof result.score==='undefined'?result.rawValue:result.score;let displayValue=result.displayValue;if(typeof displayValue==='undefined'){displayValue=result.rawValue?result.rawValue:'';}
if(displayValue===score){displayValue='';}
return{score,displayValue:`${displayValue}`,rawValue:result.rawValue,error:result.error,debugString:result.debugString,optimalValue:result.optimalValue,extendedInfo:result.extendedInfo,scoringMode:audit.meta.scoringMode||Audit.SCORING_MODES.BINARY,informative:audit.meta.informative,manual:audit.meta.manual,name:audit.meta.name,category:audit.meta.category,description:audit.meta.description,helpText:audit.meta.helpText,details:result.details};}}
module.exports=Audit;Audit.Headings;Audit.HeadingsResult;},{}],3:[function(require,module,exports){'use strict';const Audit=require('../audit');const Formatter=require('../../report/formatter');const KB_IN_BYTES=1024;const WASTED_MS_FOR_AVERAGE=300;const WASTED_MS_FOR_POOR=750;class UnusedBytes extends Audit{static scoreForWastedMs(wastedMs){if(wastedMs===0)return 100;else
if(wastedMs<WASTED_MS_FOR_AVERAGE)return 90;else
if(wastedMs<WASTED_MS_FOR_POOR)return 65;else
return 0;}
static bytesToKbString(bytes){return Math.round(bytes/KB_IN_BYTES).toLocaleString()+' KB';}
static toSavingsString(bytes=0,percent=0){const kbDisplay=this.bytesToKbString(bytes);const percentDisplay=Math.round(percent).toLocaleString()+'%';return`${kbDisplay} (${percentDisplay})`;}
static bytesToMsString(bytes,networkThroughput){return(Math.round(bytes/networkThroughput*100)*10).toLocaleString()+'ms';}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{return artifacts.requestNetworkThroughput(networkRecords).then(networkThroughput=>Promise.resolve(this.audit_(artifacts,networkRecords)).then(result=>this.createAuditResult(result,networkThroughput)));});}
static createAuditResult(result,networkThroughput){const debugString=result.debugString;const results=result.results.map(item=>{const wastedPercent=100*item.wastedBytes/item.totalBytes;item.wastedKb=this.bytesToKbString(item.wastedBytes);item.wastedMs=this.bytesToMsString(item.wastedBytes,networkThroughput);item.totalKb=this.bytesToKbString(item.totalBytes);item.totalMs=this.bytesToMsString(item.totalBytes,networkThroughput);item.potentialSavings=this.toSavingsString(item.wastedBytes,wastedPercent);return item;}).sort((itemA,itemB)=>itemB.wastedBytes-itemA.wastedBytes);const wastedBytes=results.reduce((sum,item)=>sum+item.wastedBytes,0);const wastedKb=Math.round(wastedBytes/KB_IN_BYTES);const wastedMs=Math.round(wastedBytes/networkThroughput*100)*10;let displayValue=result.displayValue||'';if(typeof result.displayValue==='undefined'&&wastedBytes){const wastedKbDisplay=this.bytesToKbString(wastedBytes);const wastedMsDisplay=this.bytesToMsString(wastedBytes,networkThroughput);displayValue=`Potential savings of ${wastedKbDisplay} (~${wastedMsDisplay})`;}
const v1TableHeadings=Audit.makeV1TableHeadings(result.headings);const v2TableDetails=Audit.makeV2TableDetails(result.headings,results);return{debugString,displayValue,rawValue:wastedMs,score:UnusedBytes.scoreForWastedMs(wastedMs),extendedInfo:{formatter:Formatter.SUPPORTED_FORMATS.TABLE,value:{wastedMs,wastedKb,results,tableHeadings:v1TableHeadings}},details:v2TableDetails};}
static audit_(){throw new Error('audit_ unimplemented');}}
module.exports=UnusedBytes;},{"../../report/formatter":29,"../audit":2}],4:[function(require,module,exports){'use strict';const Audit=require('../audit');class ManualAudit extends Audit{static get meta(){return{informative:true,manual:true,requiredArtifacts:[]};}
static audit(){return{rawValue:false};}}
module.exports=ManualAudit;},{"../audit":2}],5:[function(require,module,exports){'use strict';const Audit=require('./audit');const Formatter=require('../report/formatter');class MultiCheckAudit extends Audit{static audit(artifacts){return Promise.resolve(this.audit_(artifacts)).then(result=>this.createAuditResult(result));}
static createAuditResult(result){const extendedInfo={value:result,formatter:Formatter.SUPPORTED_FORMATS.NULL};if(result.failures.length>0){return{rawValue:false,debugString:`Failures: ${result.failures.join(', ')}.`,extendedInfo};}
return{rawValue:true,extendedInfo};}
static audit_(){throw new Error('audit_ unimplemented');}}
module.exports=MultiCheckAudit;},{"../report/formatter":29,"./audit":2}],6:[function(require,module,exports){'use strict';const Audit=require('./audit');class ViolationAudit extends Audit{static getViolationResults(artifacts,pattern){return artifacts.ChromeConsoleMessages.map(message=>message.entry).filter(entry=>entry.source==='violation'&&pattern.test(entry.text)).map(entry=>Object.assign({label:`line: ${entry.lineNumber}`},entry));}}
module.exports=ViolationAudit;},{"./audit":2}],7:[function(require,module,exports){(function(__dirname){'use strict';const defaultConfigPath='./default.js';const defaultConfig=require('./default.js');const GatherRunner=require('../gather/gather-runner');const log=require('../lib/log');const path=require('path');const Audit=require('../audits/audit');const Runner=require('../runner');const _flatten=arr=>[].concat(...arr);function cleanTrace(trace){const traceEvents=trace.traceEvents;const threads=[];const countsByThread={};const traceStartEvents=[];const makeMockEvent=(evt,ts)=>{return{pid:evt.pid,tid:evt.tid,ts:ts||0,ph:'I',cat:'disabled-by-default-devtools.timeline',name:'TracingStartedInPage',args:{data:{page:evt.frame}},s:'t'};};let frame;let data;let name;let counter;traceEvents.forEach((evt,idx)=>{if(evt.name.startsWith('TracingStartedIn')){traceStartEvents.push(idx);}
data=evt.args&&(evt.args.data||evt.args.beginData||evt.args.counters);frame=evt.args&&evt.args.frame||data&&(data.frame||data.page);if(!frame){return;}
name=`pid${evt.pid}-tid${evt.tid}-frame${frame}`;counter=countsByThread[name];if(!counter){counter={pid:evt.pid,tid:evt.tid,frame:frame,count:0};countsByThread[name]=counter;threads.push(counter);}
counter.count++;});threads.sort((a,b)=>b.count-a.count);const mostActiveFrame=threads[0];const ts=traceEvents[traceStartEvents[0]]&&traceEvents[traceStartEvents[0]].ts;let i=0;for(const dup of traceStartEvents){traceEvents.splice(dup-i,1);i++;}
traceEvents.unshift(makeMockEvent(mostActiveFrame,ts));return trace;}
function validatePasses(passes,audits,rootPath){if(!Array.isArray(passes)){return;}
const requiredGatherers=Config.getGatherersNeededByAudits(audits);passes.forEach(pass=>{pass.gatherers.forEach(gatherer=>{const GathererClass=GatherRunner.getGathererClass(gatherer,rootPath);const isGatherRequiredByAudits=requiredGatherers.has(GathererClass.name);if(isGatherRequiredByAudits===false){const msg=`${GathererClass.name} gatherer requested, however no audit requires it.`;log.warn('config',msg);}});});const usedNames=new Set();let defaultUsed=false;passes.forEach((pass,index)=>{let passName=pass.passName;if(!passName){if(defaultUsed){throw new Error(`passes[${index}] requires a passName`);}
passName=Audit.DEFAULT_PASS;defaultUsed=true;}
if(usedNames.has(passName)){throw new Error(`Passes must have unique names (repeated passName: ${passName}.`);}
usedNames.add(passName);});}
function validateCategories(categories,audits,auditResults,groups){if(!categories){return;}
const auditIds=audits?audits.map(audit=>audit.meta.name):auditResults.map(audit=>audit.name);Object.keys(categories).forEach(categoryId=>{categories[categoryId].audits.forEach((audit,index)=>{if(!audit.id){throw new Error(`missing an audit id at ${categoryId}[${index}]`);}
if(!auditIds.includes(audit.id)){throw new Error(`could not find ${audit.id} audit for category ${categoryId}`);}
if(categoryId==='accessibility'&&!audit.group){throw new Error(`${audit.id} accessibility audit does not have a group`);}
if(audit.group&&!groups[audit.group]){throw new Error(`${audit.id} references unknown group ${audit.group}`);}});});}
function assertValidAudit(auditDefinition,auditPath){const auditName=auditPath||auditDefinition.meta.name;if(typeof auditDefinition.audit!=='function'){throw new Error(`${auditName} has no audit() method.`);}
if(typeof auditDefinition.meta.name!=='string'){throw new Error(`${auditName} has no meta.name property, or the property is not a string.`);}
if(typeof auditDefinition.meta.category!=='string'){throw new Error(`${auditName} has no meta.category property, or the property is not a string.`);}
if(typeof auditDefinition.meta.description!=='string'){throw new Error(`${auditName} has no meta.description property, or the property is not a string.`);}
if(typeof auditDefinition.meta.helpText!=='string'){throw new Error(`${auditName} has no meta.helpText property, or the property is not a string.`);}
if(!Array.isArray(auditDefinition.meta.requiredArtifacts)){throw new Error(`${auditName} has no meta.requiredArtifacts property, or the property is not an array.`);}}
function expandArtifacts(artifacts){if(!artifacts){return null;}
if(artifacts.traces){Object.keys(artifacts.traces).forEach(key=>{log.log('info','Normalizng trace contents into expected state...');let trace=require(artifacts.traces[key]);if(Array.isArray(trace)){trace={traceEvents:trace};}
trace=cleanTrace(trace);artifacts.traces[key]=trace;});}
if(artifacts.devtoolsLogs){Object.keys(artifacts.devtoolsLogs).forEach(key=>{artifacts.devtoolsLogs[key]=require(artifacts.devtoolsLogs[key]);});}
return artifacts;}
function merge(base,extension){if(typeof base==='undefined'){return extension;}else if(Array.isArray(extension)){if(!Array.isArray(base))throw new TypeError(`Expected array but got ${typeof base}`);return base.concat(extension);}else if(typeof extension==='object'){if(typeof base!=='object')throw new TypeError(`Expected object but got ${typeof base}`);Object.keys(extension).forEach(key=>{base[key]=merge(base[key],extension[key]);});return base;}
return extension;}
function deepClone(json){return JSON.parse(JSON.stringify(json));}
class Config{constructor(configJSON,configPath){if(!configJSON){configJSON=defaultConfig;configPath=path.resolve(__dirname,defaultConfigPath);}
if(configPath&&!path.isAbsolute(configPath)){throw new Error('configPath must be an absolute path.');}
const inputConfig=configJSON;configJSON=deepClone(configJSON);if(Array.isArray(inputConfig.passes)){configJSON.passes.forEach((pass,i)=>{pass.gatherers=Array.from(inputConfig.passes[i].gatherers);});}
if(Array.isArray(inputConfig.audits)){configJSON.audits=Array.from(inputConfig.audits);}
if(configJSON.extends){configJSON=Config.extendConfigJSON(deepClone(defaultConfig),configJSON);}
if(configJSON.settings&&(Array.isArray(configJSON.settings.onlyCategories)||Array.isArray(configJSON.settings.onlyAudits))){const categoryIds=configJSON.settings.onlyCategories;const auditIds=configJSON.settings.onlyAudits;configJSON=Config.generateNewFilteredConfig(configJSON,categoryIds,auditIds);}
this._configDir=configPath?path.dirname(configPath):undefined;this._passes=configJSON.passes||null;this._auditResults=configJSON.auditResults||null;if(this._auditResults&&!Array.isArray(this._auditResults)){throw new Error('config.auditResults must be an array');}
this._aggregations=configJSON.aggregations||null;this._audits=Config.requireAudits(configJSON.audits,this._configDir);this._artifacts=expandArtifacts(configJSON.artifacts);this._categories=configJSON.categories;this._groups=configJSON.groups;validatePasses(configJSON.passes,this._audits,this._configDir);validateCategories(configJSON.categories,this._audits,this._auditResults,this._groups);}
static extendConfigJSON(baseJSON,extendJSON){if(extendJSON.passes){extendJSON.passes.forEach(pass=>{const basePass=baseJSON.passes.find(candidate=>candidate.passName===pass.passName);if(!basePass||!pass.passName){baseJSON.passes.push(pass);}else{merge(basePass,pass);}});delete extendJSON.passes;}
return merge(baseJSON,extendJSON);}
static generateNewFilteredConfig(oldConfig,categoryIds,auditIds){const config=deepClone(oldConfig);config.categories=Config.filterCategoriesAndAudits(config.categories,categoryIds,auditIds);const requestedAuditNames=Config.getAuditIdsInCategories(config.categories);const auditPathToNameMap=Config.getMapOfAuditPathToName(config);config.audits=config.audits.filter(auditPath=>requestedAuditNames.has(auditPathToNameMap.get(auditPath)));const auditObjectsSelected=Config.requireAudits(config.audits);const requiredGatherers=Config.getGatherersNeededByAudits(auditObjectsSelected);config.passes=Config.generatePassesNeededByGatherers(config.passes,requiredGatherers);return config;}
static filterCategoriesAndAudits(oldCategories,categoryIds=[],auditIds=[]){const categories={};categoryIds.forEach(categoryId=>{if(!oldCategories[categoryId]){log.warn('config',`unrecognized category in 'onlyCategories': ${categoryId}`);}});auditIds.forEach(auditId=>{const foundCategory=Object.keys(oldCategories).find(categoryId=>{const audits=oldCategories[categoryId].audits;return audits.find(candidate=>candidate.id===auditId);});if(!foundCategory){log.warn('config',`unrecognized audit in 'onlyAudits': ${auditId}`);}
if(categoryIds.includes(foundCategory)){log.warn('config',`${auditId} in 'onlyAudits' is already included by `+`${foundCategory} in 'onlyCategories'`);}});Object.keys(oldCategories).forEach(categoryId=>{if(categoryIds.includes(categoryId)){categories[categoryId]=oldCategories[categoryId];}else{const newCategory=deepClone(oldCategories[categoryId]);newCategory.audits=newCategory.audits.filter(audit=>auditIds.includes(audit.id));if(newCategory.audits.length){categories[categoryId]=newCategory;}}});return categories;}
static getAuditIdsInCategories(categories){const audits=_flatten(Object.keys(categories).map(id=>categories[id].audits));return new Set(audits.map(audit=>audit.id));}
static getCategories(config){return Object.keys(config.categories).map(id=>{const name=config.categories[id].name;return{id,name};});}
static getMapOfAuditPathToName(config){const auditObjectsAll=Config.requireAudits(config.audits);const auditPathToName=new Map(auditObjectsAll.map((AuditClass,index)=>{const auditPath=config.audits[index];const auditName=AuditClass.meta.name;return[auditPath,auditName];}));return auditPathToName;}
static getGatherersNeededByAudits(audits){if(!audits){return new Set();}
return audits.reduce((list,audit)=>{audit.meta.requiredArtifacts.forEach(artifact=>list.add(artifact));return list;},new Set());}
static generatePassesNeededByGatherers(oldPasses,requiredGatherers){const auditsNeedTrace=requiredGatherers.has('traces');const passes=JSON.parse(JSON.stringify(oldPasses));const filteredPasses=passes.map(pass=>{pass.gatherers=pass.gatherers.filter(gathererName=>{gathererName=GatherRunner.getGathererClass(gathererName).name;return requiredGatherers.has(gathererName);});if(pass.recordTrace&&!auditsNeedTrace){const passName=pass.passName||'unknown pass';log.warn('config',`Trace not requested by an audit, dropping trace in ${passName}`);pass.recordTrace=false;}
return pass;}).filter(pass=>{if(pass.recordTrace)return true;return pass.gatherers.length>0;});return filteredPasses;}
static requireAudits(audits,configPath){if(!audits){return null;}
const coreList=Runner.getAuditList();return audits.map(pathOrAuditClass=>{let AuditClass;if(typeof pathOrAuditClass==='string'){const path=pathOrAuditClass;const coreAudit=coreList.find(a=>a===`${path}.js`);let requirePath=`../audits/${path}`;if(!coreAudit){requirePath=Runner.resolvePlugin(path,configPath,'audit');}
AuditClass=require(requirePath);assertValidAudit(AuditClass,path);}else{AuditClass=pathOrAuditClass;assertValidAudit(AuditClass);}
return AuditClass;});}
get configDir(){return this._configDir;}
get passes(){return this._passes;}
get audits(){return this._audits;}
get auditResults(){return this._auditResults;}
get artifacts(){return this._artifacts;}
get aggregations(){return this._aggregations;}
get categories(){return this._categories;}
get groups(){return this._groups;}}
module.exports=Config;}).call(this,"/../lighthouse-core/config");},{"../audits/audit":2,"../gather/gather-runner":14,"../lib/log":21,"../runner":32,"./default.js":8,"path":219}],8:[function(require,module,exports){module.exports={"settings":{},"passes":[{"passName":"defaultPass","recordTrace":true,"pauseAfterLoadMs":5250,"networkQuietThresholdMs":5000,"pauseAfterNetworkQuietMs":2500,"useThrottling":true,"gatherers":["url","viewport","viewport-dimensions","theme-color","manifest","chrome-console-messages","image-usage","accessibility","dobetterweb/all-event-listeners","dobetterweb/anchors-with-no-rel-noopener","dobetterweb/appcache","dobetterweb/domstats","dobetterweb/optimized-images","dobetterweb/response-compression","dobetterweb/tags-blocking-first-paint","dobetterweb/websql"]},{"passName":"offlinePass","useThrottling":false,"networkQuietThresholdMs":0,"gatherers":["service-worker","offline","start-url"]},{"passName":"redirectPass","useThrottling":false,"networkQuietThresholdMs":0,"blockedUrlPatterns":["*.css","*.jpg","*.jpeg","*.png","*.gif","*.svg","*.ttf","*.woff","*.woff2"],"gatherers":["http-redirect","html-without-javascript"]}],"audits":["is-on-https","redirects-http","service-worker","works-offline","viewport","without-javascript","first-meaningful-paint","load-fast-enough-for-pwa","speed-index-metric","screenshot-thumbnails","estimated-input-latency","first-interactive","consistently-interactive","time-to-interactive","user-timings","critical-request-chains","webapp-install-banner","splash-screen","themed-omnibox","manifest-short-name-length","content-width","deprecations","manual/pwa-cross-browser","manual/pwa-page-transitions","manual/pwa-each-page-has-url","accessibility/accesskeys","accessibility/aria-allowed-attr","accessibility/aria-required-attr","accessibility/aria-required-children","accessibility/aria-required-parent","accessibility/aria-roles","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/audio-caption","accessibility/button-name","accessibility/bypass","accessibility/color-contrast","accessibility/definition-list","accessibility/dlitem","accessibility/document-title","accessibility/duplicate-id","accessibility/frame-title","accessibility/html-has-lang","accessibility/html-lang-valid","accessibility/image-alt","accessibility/input-image-alt","accessibility/label","accessibility/layout-table","accessibility/link-name","accessibility/list","accessibility/listitem","accessibility/meta-refresh","accessibility/meta-viewport","accessibility/object-alt","accessibility/tabindex","accessibility/td-headers-attr","accessibility/th-has-data-cells","accessibility/valid-lang","accessibility/video-caption","accessibility/video-description","byte-efficiency/total-byte-weight","byte-efficiency/offscreen-images","byte-efficiency/uses-webp-images","byte-efficiency/uses-optimized-images","byte-efficiency/uses-request-compression","byte-efficiency/uses-responsive-images","dobetterweb/appcache-manifest","dobetterweb/dom-size","dobetterweb/external-anchors-use-rel-noopener","dobetterweb/geolocation-on-start","dobetterweb/link-blocking-first-paint","dobetterweb/no-document-write","dobetterweb/no-mutation-events","dobetterweb/no-websql","dobetterweb/notification-on-start","dobetterweb/script-blocking-first-paint","dobetterweb/uses-http2","dobetterweb/uses-passive-event-listeners"],"aggregations":[{"name":"Progressive Web App","id":"pwa","description":"These audits validate the aspects of a Progressive Web App. They are a subset of the baseline [PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist).","scored":true,"categorizable":true,"items":[{"name":"App can load on offline/flaky connections","description":"Ensuring your web app can respond when the network connection is unavailable or flaky is critical to providing your users a good experience. This is achieved through use of a [Service Worker](https://developers.google.com/web/fundamentals/primers/service-worker/).","audits":{"service-worker":{"expectedValue":true,"weight":1},"works-offline":{"expectedValue":true,"weight":1}}},{"name":"Page load performance is fast","description":"Users notice if sites and apps don't perform well. These top-level metrics capture the most important perceived performance concerns.","audits":{"load-fast-enough-for-pwa":{"expectedValue":true,"weight":1},"first-meaningful-paint":{"expectedValue":100,"weight":1},"speed-index-metric":{"expectedValue":100,"weight":1},"estimated-input-latency":{"expectedValue":100,"weight":1},"time-to-interactive":{"expectedValue":100,"weight":1}}},{"name":"Site is progressively enhanced","description":"Progressive enhancement means that everyone can access the basic content and functionality of a page in any browser, and those without certain browser features may receive a reduced but still functional experience.","audits":{"without-javascript":{"expectedValue":true,"weight":1}}},{"name":"Network connection is secure","description":"Security is an important part of the web for both developers and users. Moving forward, Transport Layer Security (TLS) support will be required for many APIs.","audits":{"is-on-https":{"expectedValue":true,"weight":1},"redirects-http":{"expectedValue":true,"weight":1}}},{"name":"User can be prompted to Add to Homescreen","audits":{"webapp-install-banner":{"expectedValue":true,"weight":1}}},{"name":"Installed web app will launch with custom splash screen","audits":{"splash-screen":{"expectedValue":true,"weight":1}}},{"name":"Address bar matches brand colors","audits":{"themed-omnibox":{"expectedValue":true,"weight":1}}},{"name":"Design is mobile-friendly","description":"Users increasingly experience your app on mobile devices, so it's important to ensure that the experience can adapt to smaller screens.","audits":{"viewport":{"expectedValue":true,"weight":1},"content-width":{"expectedValue":true,"weight":1}}}]},{"name":"Best Practices","id":"bp","description":"We've compiled some recommendations for modernizing your web app and avoiding performance pitfalls. These audits do not affect your score but are worth a look.","scored":false,"categorizable":true,"items":[{"name":"Using modern offline features","audits":{"appcache-manifest":{"expectedValue":true,"weight":1},"no-websql":{"expectedValue":true,"weight":1}}},{"name":"Using modern protocols","audits":{"is-on-https":{"expectedValue":true,"weight":1},"uses-http2":{"expectedValue":true,"description":"Resources made by this application should be severed over HTTP/2 for improved performance.","weight":1}}},{"name":"Using modern CSS features","audits":{"no-old-flexbox":{"expectedValue":true,"weight":1}}},{"name":"Using modern JavaScript features","audits":{"uses-passive-event-listeners":{"expectedValue":true,"weight":1},"no-mutation-events":{"expectedValue":true,"weight":1}}},{"name":"Avoiding APIs that harm the user experience","audits":{"no-document-write":{"expectedValue":true,"weight":1},"external-anchors-use-rel-noopener":{"expectedValue":true,"weight":1},"geolocation-on-start":{"expectedValue":true,"weight":1},"notification-on-start":{"expectedValue":true,"weight":1}}},{"name":"Avoiding deprecated APIs and browser interventions","audits":{"deprecations":{"expectedValue":true,"weight":1}}},{"name":"Other","audits":{"manifest-short-name-length":{"expectedValue":true,"weight":1}}}]},{"name":"Accessibility","id":"accessibility","description":"These checks highlight opportunities to [improve the accessibility of your app](https://developers.google.com/web/fundamentals/accessibility).","scored":false,"categorizable":true,"items":[{"name":"Color contrast of elements is satisfactory","audits":{"color-contrast":{"expectedValue":true,"weight":1}}},{"name":"Elements are well structured","audits":{"definition-list":{"expectedValue":true,"weight":1},"dlitem":{"expectedValue":true,"weight":1},"duplicate-id":{"expectedValue":true,"weight":1},"list":{"expectedValue":true,"weight":1},"listitem":{"expectedValue":true,"weight":1}}},{"name":"Elements avoid incorrect use of attributes","audits":{"accesskeys":{"expectedValue":true,"weight":1},"audio-caption":{"expectedValue":true,"weight":1},"image-alt":{"expectedValue":true,"weight":1},"input-image-alt":{"expectedValue":true,"weight":1},"tabindex":{"expectedValue":true,"weight":1},"td-headers-attr":{"expectedValue":true,"weight":1},"th-has-data-cells":{"expectedValue":true,"weight":1}}},{"name":"Elements applying ARIA follow correct practices","audits":{"aria-allowed-attr":{"expectedValue":true,"weight":1},"aria-required-attr":{"expectedValue":true,"weight":1},"aria-required-children":{"expectedValue":true,"weight":1},"aria-required-parent":{"expectedValue":true,"weight":1},"aria-roles":{"expectedValue":true,"weight":1},"aria-valid-attr-value":{"expectedValue":true,"weight":1},"aria-valid-attr":{"expectedValue":true,"weight":1}}},{"name":"Elements describe their contents well","audits":{"document-title":{"expectedValue":true,"weight":1},"frame-title":{"expectedValue":true,"weight":1},"label":{"expectedValue":true,"weight":1},"layout-table":{"expectedValue":true,"weight":1},"object-alt":{"expectedValue":true,"weight":1},"video-caption":{"expectedValue":true,"weight":1},"video-description":{"expectedValue":true,"weight":1}}},{"name":"The page's language is specified and valid","audits":{"html-has-lang":{"expectedValue":true,"weight":1},"html-lang-valid":{"expectedValue":true,"weight":1},"valid-lang":{"expectedValue":true,"weight":1}}},{"name":"The document does not use <meta http-equiv=\"refresh\">","audits":{"meta-refresh":{"expectedValue":true,"weight":1}}},{"name":"The <meta name=\"viewport\"> element follows best practices","audits":{"meta-viewport":{"expectedValue":true,"weight":1}}},{"name":"Links and buttons have discernable names","audits":{"button-name":{"expectedValue":true,"weight":1},"link-name":{"expectedValue":true,"weight":1}}},{"name":"Repetitive content can be bypassed","audits":{"bypass":{"expectedValue":true,"weight":1}}}]},{"name":"Performance","id":"perf","description":"These encapsulate your app's performance.","scored":false,"categorizable":false,"items":[{"audits":{"total-byte-weight":{"expectedValue":100,"weight":1},"dom-size":{"expectedValue":100,"weight":1},"uses-optimized-images":{"expectedValue":true,"weight":1},"uses-request-compression":{"expectedValue":true,"weight":1},"uses-responsive-images":{"expectedValue":true,"weight":1},"offscreen-images":{"expectedValue":true,"weight":1},"link-blocking-first-paint":{"expectedValue":true,"weight":1},"script-blocking-first-paint":{"expectedValue":true,"weight":1},"critical-request-chains":{"expectedValue":true,"weight":1},"user-timings":{"expectedValue":true,"weight":1}}}]},{"name":"Fancier stuff","id":"fancy","description":"A list of newer features that you could be using in your app. These audits do not affect your score and are just suggestions.","scored":false,"categorizable":true,"additional":true,"items":[{"name":"New JavaScript features","audits":{"no-datenow":{"expectedValue":true,"weight":1},"no-console-time":{"expectedValue":true,"weight":1}}}]}],"groups":{"perf-metric":{"title":"Metrics","description":"These metrics encapsulate your app's performance across a number of dimensions."},"perf-hint":{"title":"Opportunities","description":"These are opportunities to speed up your application by optimizing the following resources."},"perf-info":{"title":"Diagnostics","description":"More information about the performance of your application."},"a11y-color-contrast":{"title":"Color Contrast Is Satisfactory","description":"Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content."},"a11y-describe-contents":{"title":"Elements Describe Contents Well","description":"Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content."},"a11y-well-structured":{"title":"Elements Are Well Structured","description":"Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content."},"a11y-aria":{"title":"ARIA Attributes Follow Best Practices","description":"Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content."},"a11y-correct-attributes":{"title":"Elements Use Attributes Correctly","description":"Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content."},"a11y-element-names":{"title":"Elements Have Discernable Names","description":"Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content."},"a11y-language":{"title":"Page Specifies Valid Language","description":"Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content."},"a11y-meta":{"title":"Meta Tags Used Properly","description":"Screen readers and other assistive technologies require annotations to understand otherwise ambiguous content."},"manual-pwa-checks":{"title":"Manual checks to verify","description":"These audits are required by the baseline "+"[PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist) but are "+"not automatically checked by Lighthouse. They do not affect your score but it's important that you verify them manually."}},"categories":{"pwa":{"name":"Progressive Web App","weight":1,"description":"These audits validate the aspects of a Progressive Web App, as specified by the baseline [PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist).","audits":[{"id":"service-worker","weight":1},{"id":"works-offline","weight":1},{"id":"without-javascript","weight":1},{"id":"is-on-https","weight":1},{"id":"redirects-http","weight":1},{"id":"load-fast-enough-for-pwa","weight":1},{"id":"webapp-install-banner","weight":1},{"id":"splash-screen","weight":1},{"id":"themed-omnibox","weight":1},{"id":"viewport","weight":1},{"id":"content-width","weight":1},{"id":"pwa-cross-browser","weight":0,"group":"manual-pwa-checks"},{"id":"pwa-page-transitions","weight":0,"group":"manual-pwa-checks"},{"id":"pwa-each-page-has-url","weight":0,"group":"manual-pwa-checks"}]},"performance":{"name":"Performance","description":"These encapsulate your app's performance.","audits":[{"id":"first-meaningful-paint","weight":5,"group":"perf-metric"},{"id":"first-interactive","weight":5,"group":"perf-metric"},{"id":"consistently-interactive","weight":5,"group":"perf-metric"},{"id":"speed-index-metric","weight":1,"group":"perf-metric"},{"id":"estimated-input-latency","weight":1,"group":"perf-metric"},{"id":"link-blocking-first-paint","weight":0,"group":"perf-hint"},{"id":"script-blocking-first-paint","weight":0,"group":"perf-hint"},{"id":"uses-responsive-images","weight":0,"group":"perf-hint"},{"id":"offscreen-images","weight":0,"group":"perf-hint"},{"id":"uses-optimized-images","weight":0,"group":"perf-hint"},{"id":"uses-webp-images","weight":0,"group":"perf-hint"},{"id":"uses-request-compression","weight":0,"group":"perf-hint"},{"id":"total-byte-weight","weight":0,"group":"perf-info"},{"id":"dom-size","weight":0,"group":"perf-info"},{"id":"critical-request-chains","weight":0,"group":"perf-info"},{"id":"user-timings","weight":0,"group":"perf-info"},{"id":"screenshot-thumbnails","weight":0}]},"accessibility":{"name":"Accessibility","description":"These checks highlight opportunities to [improve the accessibility of your app](https://developers.google.com/web/fundamentals/accessibility).","audits":[{"id":"accesskeys","weight":1,"group":"a11y-correct-attributes"},{"id":"aria-allowed-attr","weight":1,"group":"a11y-aria"},{"id":"aria-required-attr","weight":1,"group":"a11y-aria"},{"id":"aria-required-children","weight":1,"group":"a11y-aria"},{"id":"aria-required-parent","weight":1,"group":"a11y-aria"},{"id":"aria-roles","weight":1,"group":"a11y-aria"},{"id":"aria-valid-attr-value","weight":1,"group":"a11y-aria"},{"id":"aria-valid-attr","weight":1,"group":"a11y-aria"},{"id":"audio-caption","weight":1,"group":"a11y-correct-attributes"},{"id":"button-name","weight":1,"group":"a11y-element-names"},{"id":"bypass","weight":1,"group":"a11y-describe-contents"},{"id":"color-contrast","weight":1,"group":"a11y-color-contrast"},{"id":"definition-list","weight":1,"group":"a11y-well-structured"},{"id":"dlitem","weight":1,"group":"a11y-well-structured"},{"id":"document-title","weight":1,"group":"a11y-describe-contents"},{"id":"duplicate-id","weight":1,"group":"a11y-well-structured"},{"id":"frame-title","weight":1,"group":"a11y-describe-contents"},{"id":"html-has-lang","weight":1,"group":"a11y-language"},{"id":"html-lang-valid","weight":1,"group":"a11y-language"},{"id":"image-alt","weight":1,"group":"a11y-correct-attributes"},{"id":"input-image-alt","weight":1,"group":"a11y-correct-attributes"},{"id":"label","weight":1,"group":"a11y-describe-contents"},{"id":"layout-table","weight":1,"group":"a11y-describe-contents"},{"id":"link-name","weight":1,"group":"a11y-element-names"},{"id":"list","weight":1,"group":"a11y-well-structured"},{"id":"listitem","weight":1,"group":"a11y-well-structured"},{"id":"meta-refresh","weight":1,"group":"a11y-meta"},{"id":"meta-viewport","weight":1,"group":"a11y-meta"},{"id":"object-alt","weight":1,"group":"a11y-describe-contents"},{"id":"tabindex","weight":1,"group":"a11y-correct-attributes"},{"id":"td-headers-attr","weight":1,"group":"a11y-correct-attributes"},{"id":"th-has-data-cells","weight":1,"group":"a11y-correct-attributes"},{"id":"valid-lang","weight":1,"group":"a11y-language"},{"id":"video-caption","weight":1,"group":"a11y-describe-contents"},{"id":"video-description","weight":1,"group":"a11y-describe-contents"}]},"best-practices":{"name":"Best Practices","description":"We've compiled some recommendations for modernizing your web app and avoiding performance pitfalls. These audits do not affect your score but are worth a look.","audits":[{"id":"appcache-manifest","weight":1},{"id":"no-websql","weight":1},{"id":"is-on-https","weight":1},{"id":"uses-http2","weight":1},{"id":"uses-passive-event-listeners","weight":1},{"id":"no-mutation-events","weight":1},{"id":"no-document-write","weight":1},{"id":"external-anchors-use-rel-noopener","weight":1},{"id":"geolocation-on-start","weight":1},{"id":"notification-on-start","weight":1},{"id":"deprecations","weight":1},{"id":"manifest-short-name-length","weight":1}]}}};},{}],9:[function(require,module,exports){'use strict';const EventEmitter=require('events').EventEmitter;const log=require('../../lib/log.js');class Connection{constructor(){this._lastCommandId=0;this._callbacks=new Map();this._eventEmitter=new EventEmitter();}
connect(){return Promise.reject(new Error('Not implemented'));}
disconnect(){return Promise.reject(new Error('Not implemented'));}
sendCommand(method,params={}){log.formatProtocol('method => browser',{method,params},'verbose');const id=++this._lastCommandId;const message=JSON.stringify({id,method,params});this.sendRawMessage(message);return new Promise((resolve,reject)=>{this._callbacks.set(id,{resolve,reject,method});});}
on(eventName,cb){if(eventName!=='notification'){throw new Error('Only supports "notification" events');}
this._eventEmitter.on(eventName,cb);}
sendRawMessage(message){return Promise.reject(new Error('Not implemented'));}
handleRawMessage(message){const object=JSON.parse(message);if(object.id){const callback=this._callbacks.get(object.id);this._callbacks.delete(object.id);return callback.resolve(Promise.resolve().then(_=>{if(object.error){log.formatProtocol('method <= browser ERR',{method:callback.method},'error');throw new Error(`Protocol error (${callback.method}): ${object.error.message}`);}
log.formatProtocol('method <= browser OK',{method:callback.method,params:object.result},'verbose');return object.result;}));}
log.formatProtocol('<= event',{method:object.method,params:object.params},'verbose');this.emitNotification(object.method,object.params);}
emitNotification(method,params){this._eventEmitter.emit('notification',{method,params});}
dispose(){this._eventEmitter.removeAllListeners();this._eventEmitter=null;}}
module.exports=Connection;},{"../../lib/log.js":21,"events":206}],10:[function(require,module,exports){'use strict';const Connection=require('./connection.js');const log=require('../../lib/log.js');class ExtensionConnection extends Connection{constructor(){super();this._tabId=null;this._onEvent=this._onEvent.bind(this);this._onUnexpectedDetach=this._onUnexpectedDetach.bind(this);}
_onEvent(source,method,params){log.log('<=',method,params);this.emitNotification(method,params);}
_onUnexpectedDetach(debuggee,detachReason){this._detachCleanup();throw new Error('Lighthouse detached from browser: '+detachReason);}
_detachCleanup(){this._tabId=null;chrome.debugger.onEvent.removeListener(this._onEvent);chrome.debugger.onDetach.removeListener(this._onUnexpectedDetach);this.dispose();}
connect(){if(this._tabId!==null){return Promise.resolve();}
return this._queryCurrentTab().then(tab=>{const tabId=this._tabId=tab.id;chrome.debugger.onEvent.addListener(this._onEvent);chrome.debugger.onDetach.addListener(this._onUnexpectedDetach);return new Promise((resolve,reject)=>{chrome.debugger.attach({tabId},'1.1',_=>{if(chrome.runtime.lastError){return reject(new Error(chrome.runtime.lastError.message));}
resolve(tabId);});});});}
disconnect(){if(this._tabId===null){log.warn('ExtensionConnection','disconnect() was called without an established connection.');return Promise.resolve();}
const tabId=this._tabId;return new Promise((resolve,reject)=>{chrome.debugger.detach({tabId},_=>{if(chrome.runtime.lastError){return reject(new Error(chrome.runtime.lastError.message));}
chrome.tabs.reload(tabId);resolve();});}).then(_=>this._detachCleanup());}
sendCommand(command,params){return new Promise((resolve,reject)=>{log.formatProtocol('method => browser',{method:command,params:params},'verbose');if(!this._tabId){log.error('ExtensionConnection','No tabId set for sendCommand');}
chrome.debugger.sendCommand({tabId:this._tabId},command,params,result=>{if(chrome.runtime.lastError){const message=chrome.runtime.lastError.message;let errorMessage;try{errorMessage=JSON.parse(message).message;}catch(e){}
errorMessage=errorMessage||'Unknown debugger protocol error.';log.formatProtocol('method <= browser ERR',{method:command},'error');return reject(new Error(`Protocol error (${command}): ${errorMessage}`));}
log.formatProtocol('method <= browser OK',{method:command,params:result},'verbose');resolve(result);});});}
_queryCurrentTab(){return new Promise((resolve,reject)=>{const queryOpts={active:true,currentWindow:true};chrome.tabs.query(queryOpts,tabs=>{if(chrome.runtime.lastError){return reject(chrome.runtime.lastError);}
if(tabs.length===0){const message='Couldn\'t resolve current tab. Please file a bug.';return reject(new Error(message));}
if(tabs.length>1){log.warn('ExtensionConnection','_queryCurrentTab returned multiple tabs');}
resolve(tabs[0]);});});}
getCurrentTabURL(){return this._queryCurrentTab().then(tab=>{if(!tab.url){log.error('ExtensionConnection','getCurrentTabURL returned empty string',tab);}
return tab.url;});}}
module.exports=ExtensionConnection;},{"../../lib/log.js":21,"./connection.js":9}],11:[function(require,module,exports){'use strict';const Connection=require('./connection.js');class Port{on(eventName,cb){}
send(message){}
close(){}}
class RawConnection extends Connection{constructor(port){super();this._port=port;this._port.on('message',this.handleRawMessage.bind(this));this._port.on('close',this.dispose.bind(this));}
connect(){return Promise.resolve();}
disconnect(){this._port.close();return Promise.resolve();}
sendRawMessage(message){this._port.send(message);}}
module.exports=RawConnection;},{"./connection.js":9}],12:[function(require,module,exports){'use strict';class DevtoolsLog{constructor(regexFilter){this._filter=regexFilter;this._messages=[];this._isRecording=false;}
get messages(){return this._messages;}
reset(){this._messages=[];}
beginRecording(){this._isRecording=true;}
endRecording(){this._isRecording=false;}
record(message){if(this._isRecording&&(!this._filter||this._filter.test(message.method))){this._messages.push(message);}}}
module.exports=DevtoolsLog;},{}],13:[function(require,module,exports){'use strict';const NetworkRecorder=require('../lib/network-recorder');const emulation=require('../lib/emulation');const Element=require('../lib/element');const EventEmitter=require('events').EventEmitter;const URL=require('../lib/url-shim');const log=require('../lib/log.js');const DevtoolsLog=require('./devtools-log');const DEFAULT_PAUSE_AFTER_LOAD=0;const DEFAULT_NETWORK_QUIET_THRESHOLD=5000;const DEFAULT_PAUSE_AFTER_NETWORK_QUIET=0;const _uniq=arr=>Array.from(new Set(arr));class Driver{static get MAX_WAIT_FOR_FULLY_LOADED(){return 30*1000;}
constructor(connection){this._traceEvents=[];this._traceCategories=Driver.traceCategories;this._eventEmitter=new EventEmitter();this._connection=connection;this._devtoolsLog=new DevtoolsLog(/^(Page|Network)\./);this.online=true;this._domainEnabledCounts=new Map();this._networkStatusMonitor=null;this._monitoredUrl=null;connection.on('notification',event=>{this._devtoolsLog.record(event);if(this._networkStatusMonitor){this._networkStatusMonitor.dispatch(event.method,event.params);}
this._eventEmitter.emit(event.method,event.params);});}
static get traceCategories(){return['-*','toplevel','blink.console','blink.user_timing','benchmark','loading','latencyInfo','devtools.timeline','disabled-by-default-devtools.timeline','disabled-by-default-devtools.timeline.frame','disabled-by-default-devtools.timeline.stack','disabled-by-default-devtools.screenshot'];}
getUserAgent(){return this.evaluateAsync('navigator.userAgent');}
connect(){return this._connection.connect();}
disconnect(){return this._connection.disconnect();}
on(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen for event =>',{method:eventName},'verbose');this._eventEmitter.on(eventName,cb);}
once(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen once for event =>',{method:eventName},'verbose');this._eventEmitter.once(eventName,cb);}
off(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to remove an event listener.');}
this._eventEmitter.removeListener(eventName,cb);}
_shouldToggleDomain(domain,enable){const enabledCount=this._domainEnabledCounts.get(domain)||0;const newCount=enabledCount+(enable?1:-1);this._domainEnabledCounts.set(domain,Math.max(0,newCount));if(enable&&newCount===1||!enable&&newCount===0){log.verbose('Driver',`${domain}.${enable?'enable':'disable'}`);return true;}else{if(newCount<0){log.error('Driver',`Attempted to disable domain '${domain}' when already disabled.`);}
return false;}}
sendCommand(method,params){const domainCommand=/^(\w+)\.(enable|disable)$/.exec(method);if(domainCommand){const enable=domainCommand[2]==='enable';if(!this._shouldToggleDomain(domainCommand[1],enable)){return Promise.resolve();}}
return this._connection.sendCommand(method,params);}
isDomainEnabled(domain){return!!this._domainEnabledCounts.get(domain);}
evaluateScriptOnLoad(scriptSource){return this.sendCommand('Page.addScriptToEvaluateOnLoad',{scriptSource});}
evaluateAsync(expression){return new Promise((resolve,reject)=>{const asyncTimeout=setTimeout(_=>reject(new Error('The asynchronous expression exceeded the allotted time of 60s')),60000);this.sendCommand('Runtime.evaluate',{expression:`(function wrapInNativePromise() {
          const __nativePromise = window.__nativePromise || Promise;
          return new __nativePromise(function (resolve) {
            return __nativePromise.resolve()
              .then(_ => ${expression})
              .catch(${wrapRuntimeEvalErrorInBrowser.toString()})
              .then(resolve);
          });
        }())`,includeCommandLineAPI:true,awaitPromise:true,returnByValue:true}).then(result=>{clearTimeout(asyncTimeout);const value=result.result.value;if(result.exceptionDetails){reject(new Error('an unexpected driver error occurred'));}if(value&&value.__failedInBrowser){reject(Object.assign(new Error(),value));}else{resolve(value);}}).catch(err=>{clearTimeout(asyncTimeout);reject(err);});});}
getAppManifest(){return new Promise((resolve,reject)=>{this.sendCommand('Page.getAppManifest').then(response=>{if(!response.data){if(response.url){return reject(new Error(`Unable to retrieve manifest at ${response.url}.`));}
return reject('No web app manifest found.');}
resolve(response);}).catch(err=>reject(err));});}
getSecurityState(){return new Promise((resolve,reject)=>{this.once('Security.securityStateChanged',data=>{this.sendCommand('Security.disable').then(_=>resolve(data),reject);});this.sendCommand('Security.enable').catch(reject);});}
getServiceWorkerVersions(){return new Promise((resolve,reject)=>{const versionUpdatedListener=data=>{const activateCandidates=data.versions.filter(sw=>{return sw.status!=='redundant';});const hasActiveServiceWorker=activateCandidates.find(sw=>{return sw.status==='activated';});if(!activateCandidates.length||hasActiveServiceWorker){this.off('ServiceWorker.workerVersionUpdated',versionUpdatedListener);this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);}};this.on('ServiceWorker.workerVersionUpdated',versionUpdatedListener);this.sendCommand('ServiceWorker.enable').catch(reject);});}
getServiceWorkerRegistrations(){return new Promise((resolve,reject)=>{this.once('ServiceWorker.workerRegistrationUpdated',data=>{this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);});this.sendCommand('ServiceWorker.enable').catch(reject);});}
assertNoSameOriginServiceWorkerClients(pageUrl){let registrations;let versions;return this.getServiceWorkerRegistrations().then(data=>{registrations=data.registrations;}).then(_=>this.getServiceWorkerVersions()).then(data=>{versions=data.versions;}).then(_=>{const origin=new URL(pageUrl).origin;registrations.filter(reg=>{const swOrigin=new URL(reg.scopeURL).origin;return origin===swOrigin;}).forEach(reg=>{versions.forEach(ver=>{if(ver.registrationId!==reg.registrationId){return;}
if(ver.controlledClients&&ver.controlledClients.length>0){throw new Error('You probably have multiple tabs open to the same origin.');}});});});}
_waitForNetworkIdle(networkQuietThresholdMs,pauseAfterNetworkQuietMs){let idleTimeout;let cancel;const promise=new Promise((resolve,reject)=>{const onIdle=()=>{this._networkStatusMonitor.once('network-2-busy',onBusy);idleTimeout=setTimeout(_=>{cancel();resolve();},networkQuietThresholdMs);};const onBusy=()=>{this._networkStatusMonitor.once('network-2-idle',onIdle);clearTimeout(idleTimeout);};cancel=()=>{clearTimeout(idleTimeout);this._networkStatusMonitor.removeListener('network-2-busy',onBusy);this._networkStatusMonitor.removeListener('network-2-idle',onIdle);};if(this._networkStatusMonitor.is2Idle()){onIdle();}else{onBusy();}}).then(()=>{return new Promise(resolve=>setTimeout(resolve,pauseAfterNetworkQuietMs));});return{promise,cancel};}
_waitForLoadEvent(pauseAfterLoadMs){let loadListener;let loadTimeout;const promise=new Promise((resolve,reject)=>{loadListener=function(){loadTimeout=setTimeout(resolve,pauseAfterLoadMs);};this.once('Page.loadEventFired',loadListener);});const cancel=()=>{this.off('Page.loadEventFired',loadListener);clearTimeout(loadTimeout);};return{promise,cancel};}
_waitForFullyLoaded(pauseAfterLoadMs,networkQuietThresholdMs,pauseAfterNetworkQuietMs,maxWaitForLoadedMs){let maxTimeoutHandle;const waitForLoadEvent=this._waitForLoadEvent(pauseAfterLoadMs);const waitForNetworkIdle=this._waitForNetworkIdle(networkQuietThresholdMs,pauseAfterNetworkQuietMs);const loadPromise=Promise.all([waitForLoadEvent.promise,waitForNetworkIdle.promise]).then(()=>{return function(){log.verbose('Driver','loadEventFired and network considered idle');clearTimeout(maxTimeoutHandle);};});const maxTimeoutPromise=new Promise((resolve,reject)=>{maxTimeoutHandle=setTimeout(resolve,maxWaitForLoadedMs);}).then(_=>{return function(){log.warn('Driver','Timed out waiting for page load. Moving on...');waitForLoadEvent.cancel();waitForNetworkIdle.cancel();};});return Promise.race([loadPromise,maxTimeoutPromise]).then(cleanup=>cleanup());}
_beginNetworkStatusMonitoring(startingUrl){this._networkStatusMonitor=new NetworkRecorder([]);this._monitoredUrl=startingUrl;this._networkStatusMonitor.on('requestloaded',redirectRequest=>{if(!redirectRequest.redirectSource){return;}
const earlierRequest=redirectRequest.redirectSource;if(earlierRequest.url===this._monitoredUrl){this._monitoredUrl=redirectRequest.url;}});return this.sendCommand('Network.enable');}
_endNetworkStatusMonitoring(){this._networkStatusMonitor=null;const finalUrl=this._monitoredUrl;this._monitoredUrl=null;return finalUrl;}
gotoURL(url,options={}){const waitForLoad=options.waitForLoad||false;const disableJS=options.disableJavaScript||false;let pauseAfterLoadMs=options.config&&options.config.pauseAfterLoadMs;let networkQuietThresholdMs=options.config&&options.config.networkQuietThresholdMs;let pauseAfterNetworkQuietMs=options.config&&options.config.pauseAfterNetworkQuietMs;let maxWaitMs=options.flags&&options.flags.maxWaitForLoad;if(typeof pauseAfterLoadMs!=='number')pauseAfterLoadMs=DEFAULT_PAUSE_AFTER_LOAD;if(typeof networkQuietThresholdMs!=='number')networkQuietThresholdMs=DEFAULT_NETWORK_QUIET_THRESHOLD;if(typeof pauseAfterNetworkQuietMs!=='number')pauseAfterNetworkQuietMs=DEFAULT_PAUSE_AFTER_NETWORK_QUIET;if(typeof maxWaitMs!=='number')maxWaitMs=Driver.MAX_WAIT_FOR_FULLY_LOADED;return this._beginNetworkStatusMonitoring(url).then(_=>this.sendCommand('Page.enable')).then(_=>this.sendCommand('Emulation.setScriptExecutionDisabled',{value:disableJS})).then(_=>this.sendCommand('Page.navigate',{url})).then(_=>waitForLoad&&this._waitForFullyLoaded(pauseAfterLoadMs,networkQuietThresholdMs,pauseAfterNetworkQuietMs,maxWaitMs)).then(_=>this._endNetworkStatusMonitoring());}
getObjectProperty(objectId,propName){return new Promise((resolve,reject)=>{this.sendCommand('Runtime.getProperties',{objectId,accessorPropertiesOnly:true,generatePreview:false,ownProperties:false}).then(properties=>{const propertyForName=properties.result.find(property=>property.name===propName);if(propertyForName&&propertyForName.value){resolve(propertyForName.value.value);}else{resolve(null);}}).catch(reject);});}
getRequestContent(requestId){return this.sendCommand('Network.getResponseBody',{requestId}).then(result=>result.body);}
queryPermissionState(name){const expressionToEval=`
      navigator.permissions.query({name: '${name}'}).then(result => {
        return result.state;
      })
    `;return this.evaluateAsync(expressionToEval);}
querySelector(selector){return this.sendCommand('DOM.getDocument').then(result=>result.root.nodeId).then(nodeId=>this.sendCommand('DOM.querySelector',{nodeId,selector})).then(element=>{if(element.nodeId===0){return null;}
return new Element(element,this);});}
querySelectorAll(selector){return this.sendCommand('DOM.getDocument').then(result=>result.root.nodeId).then(nodeId=>this.sendCommand('DOM.querySelectorAll',{nodeId,selector})).then(nodeList=>{const elementList=[];nodeList.nodeIds.forEach(nodeId=>{if(nodeId!==0){elementList.push(new Element({nodeId},this));}});return elementList;});}
beginTrace(flags){const additionalCategories=flags&&flags.additionalTraceCategories&&flags.additionalTraceCategories.split(',')||[];const traceCategories=this._traceCategories.concat(additionalCategories);const tracingOpts={categories:_uniq(traceCategories).join(','),transferMode:'ReturnAsStream',options:'sampling-frequency=10000'};if(this.isDomainEnabled('Debugger')){throw new Error('Debugger domain enabled when starting trace');}
if(this.isDomainEnabled('CSS')){throw new Error('CSS domain enabled when starting trace');}
if(this.isDomainEnabled('DOM')){throw new Error('DOM domain enabled when starting trace');}
return this.sendCommand('Page.enable').then(_=>this.sendCommand('Tracing.start',tracingOpts));}
endTrace(){return new Promise((resolve,reject)=>{this.once('Tracing.tracingComplete',streamHandle=>{this._readTraceFromStream(streamHandle).then(traceContents=>resolve(traceContents),reject);});return this.sendCommand('Tracing.end').catch(reject);});}
_readTraceFromStream(streamHandle){return new Promise((resolve,reject)=>{let isEOF=false;let result='';const readArguments={handle:streamHandle.stream};const onChunkRead=response=>{if(isEOF){return;}
result+=response.data;if(response.eof){isEOF=true;return resolve(JSON.parse(result));}
return this.sendCommand('IO.read',readArguments).then(onChunkRead);};this.sendCommand('IO.read',readArguments).then(onChunkRead).catch(reject);});}
beginDevtoolsLog(){this._devtoolsLog.reset();this._devtoolsLog.beginRecording();}
endDevtoolsLog(){this._devtoolsLog.endRecording();return this._devtoolsLog.messages;}
enableRuntimeEvents(){return this.sendCommand('Runtime.enable');}
beginEmulation(flags){return Promise.resolve().then(_=>{if(!flags.disableDeviceEmulation)return emulation.enableNexus5X(this);}).then(_=>this.setThrottling(flags,{useThrottling:true}));}
setThrottling(flags,passConfig){const throttleCpu=passConfig.useThrottling&&!flags.disableCpuThrottling;const throttleNetwork=passConfig.useThrottling&&!flags.disableNetworkThrottling;const cpuPromise=throttleCpu?emulation.enableCPUThrottling(this):emulation.disableCPUThrottling(this);const networkPromise=throttleNetwork?emulation.enableNetworkThrottling(this):emulation.disableNetworkThrottling(this);return Promise.all([cpuPromise,networkPromise]);}
goOffline(){return this.sendCommand('Network.enable').then(_=>emulation.goOffline(this)).then(_=>this.online=false);}
goOnline(options){return this.setThrottling(options.flags,options.config).then(_=>this.online=true);}
cleanBrowserCaches(){return this.sendCommand('Network.clearBrowserCache').then(_=>this.sendCommand('Network.setCacheDisabled',{cacheDisabled:true})).then(_=>this.sendCommand('Network.setCacheDisabled',{cacheDisabled:false}));}
clearDataForOrigin(url){const origin=new URL(url).origin;const typesToClear=['appcache','file_systems','indexeddb','local_storage','shader_cache','websql','service_workers','cache_storage'].join(',');return this.sendCommand('Storage.clearDataForOrigin',{origin:origin,storageTypes:typesToClear});}
cacheNatives(){return this.evaluateScriptOnLoad(`window.__nativePromise = Promise;
        window.__nativeError = Error;`);}
captureFunctionCallSites(funcName){const globalVarToPopulate=`window['__${funcName}StackTraces']`;const collectUsage=()=>{return this.evaluateAsync(`Promise.resolve(Array.from(${globalVarToPopulate}).map(item => JSON.parse(item)))`).then(result=>{if(!Array.isArray(result)){throw new Error('Driver failure: Expected evaluateAsync results to be an array '+`but got "${JSON.stringify(result)}" instead.`);}
return result.filter(item=>!item.isExtension);});};const funcBody=captureJSCallUsage.toString();this.evaluateScriptOnLoad(`
        ${globalVarToPopulate} = new Set();
        (${funcName} = ${funcBody}(${funcName}, ${globalVarToPopulate}))`);return collectUsage;}
blockUrlPatterns(urls){return this.sendCommand('Network.setBlockedURLs',{urls}).catch(err=>{if(!/wasn't found/.test(err.message)){throw err;}});}
dismissJavaScriptDialogs(){return this.sendCommand('Page.enable').then(_=>{this.on('Page.javascriptDialogOpening',data=>{log.warn('Driver',`${data.type} dialog opened by the page automatically suppressed.`);this.sendCommand('Page.handleJavaScriptDialog',{accept:true,promptText:'Lighthouse prompt response'});});});}}
function captureJSCallUsage(funcRef,set){const __nativeError=window.__nativeError||Error;const originalFunc=funcRef;const originalPrepareStackTrace=__nativeError.prepareStackTrace;return function(...args){__nativeError.prepareStackTrace=function(error,structStackTrace){const callFrame=structStackTrace[1];let url=callFrame.getFileName()||callFrame.getEvalOrigin();const line=callFrame.getLineNumber();const col=callFrame.getColumnNumber();const isEval=callFrame.isEval();let isExtension=false;const stackTrace=structStackTrace.slice(1).map(callsite=>callsite.toString());if(isEval){url=stackTrace[1];}
if(stackTrace[0].startsWith('<anonymous>')){url=stackTrace[0];isExtension=true;}
return{url,args,line,col,isEval,isExtension};};const e=new __nativeError(`__called ${funcRef.name}__`);set.add(JSON.stringify(e.stack));__nativeError.prepareStackTrace=originalPrepareStackTrace;return originalFunc.apply(this,args);};}
function wrapRuntimeEvalErrorInBrowser(err){err=err||new Error();const fallbackMessage=typeof err==='string'?err:'unknown error';return{__failedInBrowser:true,name:err.name||'Error',message:err.message||fallbackMessage,stack:err.stack||new Error().stack};}
module.exports=Driver;},{"../lib/element":17,"../lib/emulation":18,"../lib/log.js":21,"../lib/network-recorder":23,"../lib/url-shim":27,"./devtools-log":12,"events":206}],14:[function(require,module,exports){'use strict';const log=require('../lib/log.js');const Audit=require('../audits/audit');const URL=require('../lib/url-shim');const NetworkRecorder=require('../lib/network-recorder.js');let GathererResults;class GatherRunner{static loadBlank(driver,url='about:blank',duration=300){return driver.gotoURL(url).then(_=>new Promise(resolve=>setTimeout(resolve,duration)));}
static loadPage(driver,options){return driver.gotoURL(options.url,{waitForLoad:true,disableJavaScript:!!options.disableJavaScript,flags:options.flags,config:options.config}).then(finalUrl=>{options.url=finalUrl;});}
static setupDriver(driver,gathererResults,options){log.log('status','Initializing…');const resetStorage=!options.flags.disableStorageReset;return driver.assertNoSameOriginServiceWorkerClients(options.url).then(_=>driver.beginEmulation(options.flags)).then(_=>driver.enableRuntimeEvents()).then(_=>driver.cacheNatives()).then(_=>driver.dismissJavaScriptDialogs()).then(_=>resetStorage&&driver.clearDataForOrigin(options.url)).then(_=>gathererResults.UserAgent=[driver.getUserAgent()]);}
static disposeDriver(driver){log.log('status','Disconnecting from browser...');driver.disconnect().catch(err=>{if(!/close\/.*status: 500$/.test(err.message)){log.error('GatherRunner disconnect',err.message);}});}
static recoverOrThrow(promise){return promise.catch(err=>{if(err.fatal){throw err;}});}
static assertPageLoaded(url,driver,networkRecords){const mainRecord=networkRecords.find(record=>{return URL.equalWithExcludedFragments(record.url,url);});if(driver.online&&(!mainRecord||mainRecord.failed)){const message=mainRecord?mainRecord.localizedFailDescription:'timeout reached';log.error('GatherRunner',message);const error=new Error(`Unable to load the page: ${message}`);error.code='PAGE_LOAD_ERROR';throw error;}}
static beforePass(options,gathererResults){const blockedUrls=(options.config.blockedUrlPatterns||[]).concat(options.flags.blockedUrlPatterns||[]);const blankPage=options.config.blankPage;const blankDuration=options.config.blankDuration;const pass=GatherRunner.loadBlank(options.driver,blankPage,blankDuration).then(()=>options.driver.blockUrlPatterns(blockedUrls));return options.config.gatherers.reduce((chain,gatherer)=>{return chain.then(_=>{const artifactPromise=Promise.resolve().then(_=>gatherer.beforePass(options));gathererResults[gatherer.name]=[artifactPromise];return GatherRunner.recoverOrThrow(artifactPromise);});},pass);}
static pass(options,gathererResults){const driver=options.driver;const config=options.config;const gatherers=config.gatherers;const recordTrace=config.recordTrace;const isPerfRun=!options.flags.disableStorageReset&&recordTrace&&config.useThrottling;const gatherernames=gatherers.map(g=>g.name).join(', ');const status='Loading page & waiting for onload';log.log('status',status,gatherernames);const pass=Promise.resolve().then(_=>isPerfRun&&driver.cleanBrowserCaches()).then(_=>driver.beginDevtoolsLog()).then(_=>recordTrace&&driver.beginTrace(options.flags)).then(_=>GatherRunner.loadPage(driver,options)).then(_=>log.log('statusEnd',status));return gatherers.reduce((chain,gatherer)=>{return chain.then(_=>{const artifactPromise=Promise.resolve().then(_=>gatherer.pass(options));gathererResults[gatherer.name].push(artifactPromise);return GatherRunner.recoverOrThrow(artifactPromise);});},pass);}
static afterPass(options,gathererResults){const driver=options.driver;const config=options.config;const gatherers=config.gatherers;const passData={};let pass=Promise.resolve();if(config.recordTrace){pass=pass.then(_=>{log.log('status','Retrieving trace');return driver.endTrace();}).then(traceContents=>{passData.trace=Array.isArray(traceContents)?{traceEvents:traceContents}:traceContents;log.verbose('statusEnd','Retrieving trace');});}
pass=pass.then(_=>{const status='Retrieving devtoolsLog and network records';log.log('status',status);const devtoolsLog=driver.endDevtoolsLog();const networkRecords=NetworkRecorder.recordsFromLogs(devtoolsLog);GatherRunner.assertPageLoaded(options.url,driver,networkRecords);log.verbose('statusEnd',status);passData.devtoolsLog=devtoolsLog;passData.networkRecords=networkRecords;});pass=pass.then(_=>driver.setThrottling(options.flags,{useThrottling:false}));pass=gatherers.reduce((chain,gatherer)=>{const status=`Retrieving: ${gatherer.name}`;return chain.then(_=>{log.log('status',status);const artifactPromise=Promise.resolve().then(_=>gatherer.afterPass(options,passData));gathererResults[gatherer.name].push(artifactPromise);return GatherRunner.recoverOrThrow(artifactPromise);}).then(_=>{log.verbose('statusEnd',status);});},pass);return pass.then(_=>passData);}
static collectArtifacts(gathererResults){const artifacts={};return Object.keys(gathererResults).reduce((chain,gathererName)=>{return chain.then(_=>{const phaseResultsPromises=gathererResults[gathererName];return Promise.all(phaseResultsPromises).then(phaseResults=>{const definedResults=phaseResults.filter(element=>element!==undefined);const artifact=definedResults[definedResults.length-1];if(artifact===undefined){throw new Error(`${gathererName} failed to provide an artifact.`);}
artifacts[gathererName]=artifact;},err=>{artifacts[gathererName]=err;});});},Promise.resolve()).then(_=>{return artifacts;});}
static run(passes,options){const driver=options.driver;const tracingData={traces:{},devtoolsLogs:{},networkRecords:{}};if(typeof options.url!=='string'||options.url.length===0){return Promise.reject(new Error('You must provide a url to the gather-runner'));}
if(typeof options.flags==='undefined'){options.flags={};}
if(typeof options.config==='undefined'){return Promise.reject(new Error('You must provide a config'));}
if(typeof options.flags.disableCpuThrottling==='undefined'){options.flags.disableCpuThrottling=false;}
passes=this.instantiateGatherers(passes,options.config.configDir);const gathererResults={};return driver.connect().then(_=>GatherRunner.loadBlank(driver)).then(_=>GatherRunner.setupDriver(driver,gathererResults,options)).then(_=>{let urlAfterRedirects;return passes.reduce((chain,config,passIndex)=>{const runOptions=Object.assign({},options,{config});return chain.then(_=>driver.setThrottling(options.flags,config)).then(_=>GatherRunner.beforePass(runOptions,gathererResults)).then(_=>GatherRunner.pass(runOptions,gathererResults)).then(_=>GatherRunner.afterPass(runOptions,gathererResults)).then(passData=>{const passName=config.passName||Audit.DEFAULT_PASS;tracingData.devtoolsLogs[passName]=passData.devtoolsLog;if(config.recordTrace){tracingData.traces[passName]=passData.trace;}
if(passIndex===0){urlAfterRedirects=runOptions.url;}});},Promise.resolve()).then(_=>{options.url=urlAfterRedirects;});}).then(_=>GatherRunner.disposeDriver(driver)).then(_=>GatherRunner.collectArtifacts(gathererResults)).then(artifacts=>{return Object.assign(artifacts,tracingData);}).catch(err=>{GatherRunner.disposeDriver(driver);throw err;});}
static getGathererClass(nameOrGathererClass,configPath){const Runner=require('../runner');const coreList=Runner.getGathererList();let GathererClass;if(typeof nameOrGathererClass==='string'){const name=nameOrGathererClass;const coreGatherer=coreList.find(a=>a===`${name}.js`);let requirePath=`./gatherers/${name}`;if(!coreGatherer){requirePath=Runner.resolvePlugin(name,configPath,'gatherer');}
GathererClass=require(requirePath);this.assertValidGatherer(GathererClass,name);}else{GathererClass=nameOrGathererClass;this.assertValidGatherer(GathererClass);}
return GathererClass;}
static assertValidGatherer(GathererDefinition,gathererName){const gathererInstance=new GathererDefinition();gathererName=gathererName||gathererInstance.name||'gatherer';if(typeof gathererInstance.beforePass!=='function'){throw new Error(`${gathererName} has no beforePass() method.`);}
if(typeof gathererInstance.pass!=='function'){throw new Error(`${gathererName} has no pass() method.`);}
if(typeof gathererInstance.afterPass!=='function'){throw new Error(`${gathererName} has no afterPass() method.`);}}
static instantiateGatherers(passes,rootPath){return passes.map(pass=>{pass.gatherers=pass.gatherers.map(gatherer=>{if(typeof gatherer!=='string'){return gatherer;}
const GathererClass=GatherRunner.getGathererClass(gatherer,rootPath);return new GathererClass();});return pass;});}}
module.exports=GatherRunner;},{"../audits/audit":2,"../lib/log.js":21,"../lib/network-recorder.js":23,"../lib/url-shim":27,"../runner":32}],15:[function(require,module,exports){'use strict';class Gatherer{get name(){return this.constructor.name;}
beforePass(options){}
pass(options){}
afterPass(options,loadData){}}
module.exports=Gatherer;},{}],16:[function(require,module,exports){'use strict';const log=require('./log.js');class ConsoleQuieter{static mute(opts){ConsoleQuieter._logs=ConsoleQuieter._logs||[];console.log=function(...args){ConsoleQuieter._logs.push({type:'log',args,prefix:opts.prefix});};console.warn=function(...args){ConsoleQuieter._logs.push({type:'warn',args,prefix:opts.prefix});};console.error=function(...args){ConsoleQuieter._logs.push({type:'error',args,prefix:opts.prefix});};}
static unmuteAndFlush(){console.log=ConsoleQuieter._consolelog;console.warn=ConsoleQuieter._consolewarn;console.error=ConsoleQuieter._consoleerror;ConsoleQuieter._logs.forEach(entry=>{log.verbose(`${entry.prefix}-${entry.type}`,...entry.args);});ConsoleQuieter._logs=[];}}
ConsoleQuieter._consolelog=console.log.bind(console);ConsoleQuieter._consolewarn=console.warn.bind(console);ConsoleQuieter._consoleerror=console.error.bind(console);module.exports=ConsoleQuieter;},{"./log.js":21}],17:[function(require,module,exports){'use strict';class Element{constructor(element,driver){if(!element||!driver){throw Error('Driver and element required to create Element');}
this.driver=driver;this.element=element;}
getAttribute(name){return this.driver.sendCommand('DOM.getAttributes',{nodeId:this.element.nodeId}).then(resp=>{const attrIndex=resp.attributes.indexOf(name);if(attrIndex===-1){return null;}
return resp.attributes[attrIndex+1];});}
getProperty(propName){return this.driver.sendCommand('DOM.resolveNode',{nodeId:this.element.nodeId}).then(resp=>{return this.driver.getObjectProperty(resp.object.objectId,propName);});}}
module.exports=Element;},{}],18:[function(require,module,exports){'use strict';const NEXUS5X_EMULATION_METRICS={mobile:true,screenWidth:412,screenHeight:732,width:412,height:732,positionX:0,positionY:0,scale:1,deviceScaleFactor:2.625,fitWindow:false,screenOrientation:{angle:0,type:'portraitPrimary'}};const NEXUS5X_USERAGENT={userAgent:'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5 Build/MRA58N) AppleWebKit/537.36'+'(KHTML, like Gecko) Chrome/59.0.3033.0 Mobile Safari/537.36'};const LATENCY_FACTOR=3.75;const THROUGHPUT_FACTOR=0.9;const TARGET_LATENCY=150;const TARGET_DOWNLOAD_THROUGHPUT=Math.floor(1.6*1024*1024/8);const TARGET_UPLOAD_THROUGHPUT=Math.floor(750*1024/8);const TYPICAL_MOBILE_THROTTLING_METRICS={targetLatency:TARGET_LATENCY,latency:TARGET_LATENCY*LATENCY_FACTOR,targetDownloadThroughput:TARGET_DOWNLOAD_THROUGHPUT,downloadThroughput:TARGET_DOWNLOAD_THROUGHPUT*THROUGHPUT_FACTOR,targetUploadThroughput:TARGET_UPLOAD_THROUGHPUT,uploadThroughput:TARGET_UPLOAD_THROUGHPUT*THROUGHPUT_FACTOR,offline:false};const OFFLINE_METRICS={offline:true,latency:0,downloadThroughput:0,uploadThroughput:0};const NO_THROTTLING_METRICS={latency:0,downloadThroughput:0,uploadThroughput:0,offline:false};const NO_CPU_THROTTLE_METRICS={rate:1};const CPU_THROTTLE_METRICS={rate:4};function enableNexus5X(driver){const injectedTouchEventsFunction=function(){const touchEvents=['ontouchstart','ontouchend','ontouchmove','ontouchcancel'];const recepients=[window.__proto__,document.__proto__];for(let i=0;i<touchEvents.length;++i){for(let j=0;j<recepients.length;++j){if(!(touchEvents[i]in recepients[j])){Object.defineProperty(recepients[j],touchEvents[i],{value:null,writable:true,configurable:true,enumerable:true});}}}};return Promise.all([driver.sendCommand('Emulation.setDeviceMetricsOverride',NEXUS5X_EMULATION_METRICS),driver.sendCommand('Emulation.setVisibleSize',{width:NEXUS5X_EMULATION_METRICS.screenWidth,height:NEXUS5X_EMULATION_METRICS.screenHeight}),driver.sendCommand('Network.enable'),driver.sendCommand('Network.setUserAgentOverride',NEXUS5X_USERAGENT),driver.sendCommand('Emulation.setTouchEmulationEnabled',{enabled:true,configuration:'mobile'}),driver.sendCommand('Page.addScriptToEvaluateOnLoad',{scriptSource:'('+injectedTouchEventsFunction.toString()+')()'})]);}
function enableNetworkThrottling(driver){return driver.sendCommand('Network.emulateNetworkConditions',TYPICAL_MOBILE_THROTTLING_METRICS);}
function disableNetworkThrottling(driver){return driver.sendCommand('Network.emulateNetworkConditions',NO_THROTTLING_METRICS);}
function goOffline(driver){return driver.sendCommand('Network.emulateNetworkConditions',OFFLINE_METRICS);}
function enableCPUThrottling(driver){return driver.sendCommand('Emulation.setCPUThrottlingRate',CPU_THROTTLE_METRICS);}
function disableCPUThrottling(driver){return driver.sendCommand('Emulation.setCPUThrottlingRate',NO_CPU_THROTTLE_METRICS);}
function getEmulationDesc(){const{latency,downloadThroughput,uploadThroughput}=TYPICAL_MOBILE_THROTTLING_METRICS;const byteToMbit=bytes=>(bytes/1024/1024*8).toFixed(1);return{'deviceEmulation':'Nexus 5X','cpuThrottling':`${CPU_THROTTLE_METRICS.rate}x slowdown`,'networkThrottling':`${latency}ms RTT, ${byteToMbit(downloadThroughput)}Mbps down, `+`${byteToMbit(uploadThroughput)}Mbps up`};}
module.exports={enableNexus5X,enableNetworkThrottling,disableNetworkThrottling,enableCPUThrottling,disableCPUThrottling,goOffline,getEmulationDesc,settings:{NEXUS5X_EMULATION_METRICS,NEXUS5X_USERAGENT,TYPICAL_MOBILE_THROTTLING_METRICS,OFFLINE_METRICS,NO_THROTTLING_METRICS,NO_CPU_THROTTLE_METRICS,CPU_THROTTLE_METRICS}};},{}],19:[function(require,module,exports){'use strict';function addFormattedCodeSnippet(listener){const handler=listener.handler?listener.handler.description:'...';const objectName=listener.objectName.toLowerCase().replace('#document','document');return Object.assign({label:`line: ${listener.line}, col: ${listener.col}`,pre:`${objectName}.addEventListener('${listener.type}', ${handler})`},listener);}
function groupCodeSnippetsByLocation(listeners){const locToListenersMap=new Map();listeners.forEach(loc=>{const key=JSON.stringify({line:loc.line,col:loc.col,url:loc.url,type:loc.type});if(locToListenersMap.has(key)){locToListenersMap.get(key).push(loc);}else{locToListenersMap.set(key,[loc]);}});const results=[];locToListenersMap.forEach((listenersForLocation,key)=>{const lineColUrlObj=JSON.parse(key);const codeSnippets=listenersForLocation.reduce((prev,loc)=>{return prev+loc.pre.trim()+'\n\n';},'');lineColUrlObj.pre=codeSnippets;lineColUrlObj.label=listenersForLocation[0].label;results.push(lineColUrlObj);});return results;}
module.exports={addFormattedCodeSnippet,groupCodeSnippetsByLocation};},{}],20:[function(require,module,exports){'use strict';function doExist(manifest){if(!manifest||!manifest.icons){return false;}
if(manifest.icons.value.length===0){return false;}
return true;}
function sizeAtLeast(sizeRequirement,manifest){const iconValues=manifest.icons.value;const nestedSizes=iconValues.map(icon=>icon.value.sizes.value);const flattenedSizes=[].concat(...nestedSizes);return flattenedSizes.filter(size=>typeof size==='string').filter(size=>/\d+x\d+/.test(size)).filter(size=>{const sizeStrs=size.split(/x/i);const sizeNums=[parseFloat(sizeStrs[0]),parseFloat(sizeStrs[1])];const areIconsBigEnough=sizeNums[0]>=sizeRequirement&&sizeNums[1]>=sizeRequirement;const areIconsSquare=sizeNums[0]===sizeNums[1];return areIconsBigEnough&&areIconsSquare;});}
module.exports={doExist,sizeAtLeast};},{}],21:[function(require,module,exports){(function(process){'use strict';const debug=require('debug');const EventEmitter=require('events').EventEmitter;const isWindows=process.platform==='win32';const isBrowser=process.browser;const colors={red:isBrowser?'crimson':1,yellow:isBrowser?'gold':3,cyan:isBrowser?'darkturquoise':6,green:isBrowser?'forestgreen':2,blue:isBrowser?'steelblue':4,magenta:isBrowser?'palevioletred':5};debug.colors=[colors.cyan,colors.green,colors.blue,colors.magenta];class Emitter extends EventEmitter{issueStatus(title,argsArray){if(title==='status'||title==='statusEnd'){this.emit(title,[title,...argsArray]);}}
issueWarning(title,argsArray){this.emit('warning',[title,...argsArray]);}}
const loggersByTitle={};const loggingBufferColumns=25;class Log{static _logToStdErr(title,argsArray){const log=Log.loggerfn(title);log(...argsArray);}
static loggerfn(title){let log=loggersByTitle[title];if(!log){log=debug(title);loggersByTitle[title]=log;if(title.endsWith('error')){log.color=colors.red;}else if(title.endsWith('warn')){log.color=colors.yellow;}}
return log;}
static setLevel(level){switch(level){case'silent':debug.enable('-*');break;case'verbose':debug.enable('*');break;case'error':debug.enable('-*, *:error');break;default:debug.enable('*, -*:verbose');}}
static formatProtocol(prefix,data,level){const columns=!process||process.browser?Infinity:process.stdout.columns;const maxLength=columns-data.method.length-prefix.length-loggingBufferColumns;const snippet=data.params&&data.method!=='IO.read'?JSON.stringify(data.params).substr(0,maxLength):'';Log._logToStdErr(`${prefix}:${level||''}`,[data.method,snippet]);}
static log(title,...args){Log.events.issueStatus(title,args);return Log._logToStdErr(title,args);}
static warn(title,...args){Log.events.issueWarning(title,args);return Log._logToStdErr(`${title}:warn`,args);}
static error(title,...args){return Log._logToStdErr(`${title}:error`,args);}
static verbose(title,...args){Log.events.issueStatus(title,args);return Log._logToStdErr(`${title}:verbose`,args);}
static greenify(str){return`${Log.green}${str}${Log.reset}`;}
static redify(str){return`${Log.red}${str}${Log.reset}`;}
static get green(){return'\x1B[32m';}
static get red(){return'\x1B[31m';}
static get yellow(){return'\x1b[33m';}
static get purple(){return'\x1b[95m';}
static get reset(){return'\x1B[0m';}
static get bold(){return'\x1b[1m';}
static get dim(){return'\x1b[2m';}
static get tick(){return isWindows?'\u221A':'✓';}
static get cross(){return isWindows?'\u00D7':'✘';}
static get whiteSmallSquare(){return isWindows?'\u0387':'▫';}
static get heavyHorizontal(){return isWindows?'\u2500':'━';}
static get heavyVertical(){return isWindows?'\u2502 ':'┃ ';}
static get heavyUpAndRight(){return isWindows?'\u2514':'┗';}
static get heavyVerticalAndRight(){return isWindows?'\u251C':'┣';}
static get heavyDownAndHorizontal(){return isWindows?'\u252C':'┳';}
static get doubleLightHorizontal(){return'──';}}
Log.events=new Emitter();module.exports=Log;}).call(this,require('_process'));},{"_process":221,"debug":261,"events":206}],22:[function(require,module,exports){'use strict';const URL=require('./url-shim');const validateColor=require('./web-inspector').Color.parse;const ALLOWED_DISPLAY_VALUES=['fullscreen','standalone','minimal-ui','browser'];const DEFAULT_DISPLAY_MODE='browser';const ALLOWED_ORIENTATION_VALUES=['any','natural','landscape','portrait','portrait-primary','portrait-secondary','landscape-primary','landscape-secondary'];function parseString(raw,trim){let value;let debugString;if(typeof raw==='string'){value=trim?raw.trim():raw;}else{if(raw!==undefined){debugString='ERROR: expected a string.';}
value=undefined;}
return{raw,value,debugString};}
function parseColor(raw){const color=parseString(raw);if(color.value===undefined){return color;}
const validatedColor=validateColor(color.raw);if(!validatedColor){color.value=undefined;color.debugString='ERROR: color parsing failed.';}
return color;}
function parseName(jsonInput){return parseString(jsonInput.name,true);}
function parseShortName(jsonInput){return parseString(jsonInput.short_name,true);}
function checkSameOrigin(url1,url2){const parsed1=new URL(url1);const parsed2=new URL(url2);return parsed1.origin===parsed2.origin;}
function parseStartUrl(jsonInput,manifestUrl,documentUrl){const raw=jsonInput.start_url;if(raw===''){return{raw,value:documentUrl,debugString:'ERROR: start_url string empty'};}
const parsedAsString=parseString(raw);if(!parsedAsString.value){parsedAsString.value=documentUrl;return parsedAsString;}
let startUrl;try{startUrl=new URL(raw,manifestUrl).href;}catch(e){return{raw,value:documentUrl,debugString:'ERROR: invalid start_url relative to ${manifestUrl}'};}
if(!checkSameOrigin(startUrl,documentUrl)){return{raw,value:documentUrl,debugString:'ERROR: start_url must be same-origin as document'};}
return{raw,value:startUrl};}
function parseDisplay(jsonInput){const display=parseString(jsonInput.display,true);if(!display.value){display.value=DEFAULT_DISPLAY_MODE;return display;}
display.value=display.value.toLowerCase();if(!ALLOWED_DISPLAY_VALUES.includes(display.value)){display.debugString='ERROR: \'display\' has invalid value '+display.value+` will fall back to ${DEFAULT_DISPLAY_MODE}.`;display.value=DEFAULT_DISPLAY_MODE;}
return display;}
function parseOrientation(jsonInput){const orientation=parseString(jsonInput.orientation,true);if(orientation.value&&!ALLOWED_ORIENTATION_VALUES.includes(orientation.value.toLowerCase())){orientation.value=undefined;orientation.debugString='ERROR: \'orientation\' has an invalid value, will be ignored.';}
return orientation;}
function parseIcon(raw,manifestUrl){const src=parseString(raw.src,true);if(src.value===''){src.value=undefined;}
if(src.value){src.value=new URL(src.value,manifestUrl).href;}
const type=parseString(raw.type,true);const density={raw:raw.density,value:1,debugString:undefined};if(density.raw!==undefined){density.value=parseFloat(density.raw);if(isNaN(density.value)||!isFinite(density.value)||density.value<=0){density.value=1;density.debugString='ERROR: icon density cannot be NaN, +∞, or less than or equal to +0.';}}
const sizes=parseString(raw.sizes);if(sizes.value!==undefined){const set=new Set();sizes.value.trim().split(/\s+/).forEach(size=>set.add(size.toLowerCase()));sizes.value=set.size>0?Array.from(set):undefined;}
return{raw,value:{src,type,density,sizes},debugString:undefined};}
function parseIcons(jsonInput,manifestUrl){const raw=jsonInput.icons;if(raw===undefined){return{raw,value:[],debugString:undefined};}
if(!Array.isArray(raw)){return{raw,value:[],debugString:'ERROR: \'icons\' expected to be an array but is not.'};}
const value=raw.filter(icon=>icon.src!==undefined).map(icon=>parseIcon(icon,manifestUrl)).filter(parsedIcon=>parsedIcon.value.src.value!==undefined);return{raw,value,debugString:undefined};}
function parseApplication(raw){const platform=parseString(raw.platform,true);const id=parseString(raw.id,true);const appUrl=parseString(raw.url,true);if(appUrl.value){try{appUrl.value=new URL(appUrl.value).href;}catch(e){appUrl.value=undefined;appUrl.debugString='ERROR: invalid application URL ${raw.url}';}}
return{raw,value:{platform,id,url:appUrl},debugString:undefined};}
function parseRelatedApplications(jsonInput){const raw=jsonInput.related_applications;if(raw===undefined){return{raw,value:undefined,debugString:undefined};}
if(!Array.isArray(raw)){return{raw,value:undefined,debugString:'ERROR: \'related_applications\' expected to be an array but is not.'};}
const value=raw.filter(application=>!!application.platform).map(parseApplication).filter(parsedApp=>!!parsedApp.value.id.value||!!parsedApp.value.url.value);return{raw,value,debugString:undefined};}
function parsePreferRelatedApplications(jsonInput){const raw=jsonInput.prefer_related_applications;let value;let debugString;if(typeof raw==='boolean'){value=raw;}else{if(raw!==undefined){debugString='ERROR: \'prefer_related_applications\' expected to be a boolean.';}
value=undefined;}
return{raw,value,debugString};}
function parseThemeColor(jsonInput){return parseColor(jsonInput.theme_color);}
function parseBackgroundColor(jsonInput){return parseColor(jsonInput.background_color);}
function parse(string,manifestUrl,documentUrl){if(manifestUrl===undefined||documentUrl===undefined){throw new Error('Manifest and document URLs required for manifest parsing.');}
let jsonInput;try{jsonInput=JSON.parse(string);}catch(e){return{raw:string,value:undefined,debugString:'ERROR: file isn\'t valid JSON: '+e};}
const manifest={name:parseName(jsonInput),short_name:parseShortName(jsonInput),start_url:parseStartUrl(jsonInput,manifestUrl,documentUrl),display:parseDisplay(jsonInput),orientation:parseOrientation(jsonInput),icons:parseIcons(jsonInput,manifestUrl),related_applications:parseRelatedApplications(jsonInput),prefer_related_applications:parsePreferRelatedApplications(jsonInput),theme_color:parseThemeColor(jsonInput),background_color:parseBackgroundColor(jsonInput)};return{raw:string,value:manifest,debugString:undefined};}
module.exports=parse;},{"./url-shim":27,"./web-inspector":28}],23:[function(require,module,exports){'use strict';const NetworkManager=require('./web-inspector').NetworkManager;const EventEmitter=require('events').EventEmitter;const log=require('../lib/log.js');class NetworkRecorder extends EventEmitter{constructor(recordArray){super();this._records=recordArray;this.networkManager=NetworkManager.createWithFakeTarget();this.startedRequestCount=0;this.finishedRequestCount=0;this.networkManager.addEventListener(this.EventTypes.RequestStarted,this.onRequestStarted.bind(this));this.networkManager.addEventListener(this.EventTypes.RequestFinished,this.onRequestFinished.bind(this));}
get EventTypes(){return NetworkManager.Events;}
activeRequestCount(){return this.startedRequestCount-this.finishedRequestCount;}
isIdle(){return this.activeRequestCount()===0;}
is2Idle(){return this.activeRequestCount()<=2;}
onRequestStarted(request){this.startedRequestCount++;this._records.push(request.data);const activeCount=this.activeRequestCount();log.verbose('NetworkRecorder',`Request started. ${activeCount} requests in progress`+` (${this.startedRequestCount} started and ${this.finishedRequestCount} finished).`);if(activeCount===1){this.emit('networkbusy');}
if(activeCount===3){this.emit('network-2-busy');}}
onRequestFinished(request){this.finishedRequestCount++;this.emit('requestloaded',request.data);const activeCount=this.activeRequestCount();log.verbose('NetworkRecorder',`Request finished. ${activeCount} requests in progress`+` (${this.startedRequestCount} started and ${this.finishedRequestCount} finished).`);if(this.isIdle()){this.emit('networkidle');}
if(this.is2Idle()){this.emit('network-2-idle');}}
onRequestWillBeSent(data){this.networkManager._dispatcher.requestWillBeSent(data.requestId,data.frameId,data.loaderId,data.documentURL,data.request,data.timestamp,data.wallTime,data.initiator,data.redirectResponse,data.type);}
onRequestServedFromCache(data){this.networkManager._dispatcher.requestServedFromCache(data.requestId);}
onResponseReceived(data){this.networkManager._dispatcher.responseReceived(data.requestId,data.frameId,data.loaderId,data.timestamp,data.type,data.response);}
onDataReceived(data){this.networkManager._dispatcher.dataReceived(data.requestId,data.timestamp,data.dataLength,data.encodedDataLength);}
onLoadingFinished(data){this.networkManager._dispatcher.loadingFinished(data.requestId,data.timestamp,data.encodedDataLength);}
onLoadingFailed(data){this.networkManager._dispatcher.loadingFailed(data.requestId,data.timestamp,data.type,data.errorText,data.canceled,data.blockedReason);}
onResourceChangedPriority(data){this.networkManager._dispatcher.resourceChangedPriority(data.requestId,data.newPriority,data.timestamp);}
dispatch(method,params){if(!method.startsWith('Network.')){return;}
switch(method){case'Network.requestWillBeSent':return this.onRequestWillBeSent(params);case'Network.requestServedFromCache':return this.onRequestServedFromCache(params);case'Network.responseReceived':return this.onResponseReceived(params);case'Network.dataReceived':return this.onDataReceived(params);case'Network.loadingFinished':return this.onLoadingFinished(params);case'Network.loadingFailed':return this.onLoadingFailed(params);case'Network.resourceChangedPriority':return this.onResourceChangedPriority(params);default:return;}}
static recordsFromLogs(devtoolsLog){const records=[];const nr=new NetworkRecorder(records);devtoolsLog.forEach(message=>{nr.dispatch(message.method,message.params);});return records;}}
module.exports=NetworkRecorder;},{"../lib/log.js":21,"./web-inspector":28,"events":206}],24:[function(require,module,exports){'use strict';function filterStylesheetsByUsage(stylesheets,propName,propVal){if(!propName&&!propVal){return[];}
const deepClone=stylesheets.map(sheet=>Object.assign({},sheet));return deepClone.filter(s=>{if(s.isDuplicate){return false;}
s.parsedContent=s.parsedContent.filter(item=>{let usedName='';let usedVal='';if(propName){propName=Array.isArray(propName)?propName:[propName];usedName=propName.includes(item.property.name);}
if(propVal){propVal=Array.isArray(propVal)?propVal:[propVal];usedVal=propVal.includes(item.property.val);}
if(propName&&!propVal){return usedName;}else if(!propName&&propVal){return usedVal;}else if(propName&&propVal){return usedName&&usedVal;}
return false;});return s.parsedContent.length>0;});}
function getFormattedStyleRule(content,parsedContent){const lines=content.split('\n');const declarationRange=parsedContent.declarationRange;const startLine=declarationRange.startLine;const endLine=declarationRange.endLine;const start=declarationRange.startColumn;const end=declarationRange.endColumn;let rule;if(startLine===endLine){rule=lines[startLine].substring(start,end);}else{rule=lines.slice(startLine,endLine+1).reduce((prev,line)=>{prev.push(line);return prev;},[]).join('\n');}
const block=parsedContent.selector+' {\n'+`  ${rule.trim()}\n`+'}';return{styleRule:block.trim(),startLine,location:`${start}:${end}`};}
function addVendorPrefixes(propsNames){const vendorPrefixes=['-o-','-ms-','-moz-','-webkit-'];propsNames=Array.isArray(propsNames)?propsNames:[propsNames];let propsNamesWithPrefixes=propsNames;for(const prefix of vendorPrefixes){const temp=propsNames.map(propName=>`${prefix}${propName}`);propsNamesWithPrefixes=propsNamesWithPrefixes.concat(temp);}
return propsNamesWithPrefixes;}
module.exports={filterStylesheetsByUsage,getFormattedStyleRule,addVendorPrefixes};},{}],25:[function(require,module,exports){'use strict';const WebInspector=require('../web-inspector');const ConsoleQuieter=require('../console-quieter');const TimelineModelTreeView=require('devtools-timeline-model/lib/timeline-model-treeview.js')(WebInspector);class TimelineModel{constructor(events){this.init(events);}
init(events){this._tracingModel=new WebInspector.TracingModel(new WebInspector.TempFileBackingStorage('tracing'));this._timelineModel=new WebInspector.TimelineModel(WebInspector.TimelineUIUtils.visibleEventsFilter());if(typeof events==='string'){events=JSON.parse(events);}
if(events.hasOwnProperty('traceEvents')){events=events.traceEvents;}
this._tracingModel.reset();ConsoleQuieter.mute({prefix:'timelineModel'});this._tracingModel.addEvents(events);this._tracingModel.tracingComplete();this._timelineModel.setEvents(this._tracingModel);ConsoleQuieter.unmuteAndFlush();return this;}
_createAggregator(){return WebInspector.AggregatedTimelineTreeView.prototype._createAggregator();}
timelineModel(){return this._timelineModel;}
tracingModel(){return this._tracingModel;}
topDown(){const filters=[];filters.push(WebInspector.TimelineUIUtils.visibleEventsFilter());filters.push(new WebInspector.ExcludeTopLevelFilter());const nonessentialEvents=[WebInspector.TimelineModel.RecordType.EventDispatch,WebInspector.TimelineModel.RecordType.FunctionCall,WebInspector.TimelineModel.RecordType.TimerFire];filters.push(new WebInspector.ExclusiveNameFilter(nonessentialEvents));const topDown=WebInspector.TimelineProfileTree.buildTopDown(this._timelineModel.mainThreadEvents(),filters,0,Infinity,WebInspector.TimelineAggregator.eventId);return topDown;}
bottomUp(){const topDown=this.topDown();const noGrouping=WebInspector.TimelineAggregator.GroupBy.None;const noGroupAggregator=this._createAggregator().groupFunction(noGrouping);return WebInspector.TimelineProfileTree.buildBottomUp(topDown,noGroupAggregator);}
bottomUpGroupBy(grouping){const topDown=this.topDown();const groupSetting=WebInspector.TimelineAggregator.GroupBy[grouping];const groupingAggregator=this._createAggregator().groupFunction(groupSetting);const bottomUpGrouped=WebInspector.TimelineProfileTree.buildBottomUp(topDown,groupingAggregator);new TimelineModelTreeView(bottomUpGrouped).sortingChanged('self','desc');return bottomUpGrouped;}
frameModel(){const frameModel=new WebInspector.TimelineFrameModel(event=>WebInspector.TimelineUIUtils.eventStyle(event).category.name);frameModel.addTraceEvents({},this._timelineModel.inspectedTargetEvents(),this._timelineModel.sessionId()||'');return frameModel;}
filmStripModel(){return new WebInspector.FilmStripModel(this._tracingModel);}
interactionModel(){const irModel=new WebInspector.TimelineIRModel();irModel.populate(this._timelineModel);return irModel;}}
module.exports=TimelineModel;},{"../console-quieter":16,"../web-inspector":28,"devtools-timeline-model/lib/timeline-model-treeview.js":263}],26:[function(require,module,exports){(function(global,Buffer){'use strict';if(typeof global.window==='undefined'){global.window=global;}
const BASE_RESPONSE_LATENCY=16;const SCHEDULABLE_TASK_TITLE='TaskQueueManager::ProcessTaskFromWorkQueue';const glMatrixModule=require('gl-matrix');Object.keys(glMatrixModule).forEach(exportName=>{global[exportName]=glMatrixModule[exportName];});global.JSZip={};global.mannwhitneyu={};global.HTMLImportsLoader={};global.HTMLImportsLoader.hrefToAbsolutePath=function(path){if(path==='/gl-matrix-min.js'){return'../../../lib/empty-stub.js';}
if(path==='/jszip.min.js'){return'../../../lib/empty-stub.js';}
if(path==='/mannwhitneyu.js'){return'../../../lib/empty-stub.js';}};require('../../third_party/traceviewer-js/');const traceviewer=global.tr;if(typeof atob==='undefined'){traceviewer.b.Base64.atob=input=>new Buffer(input).toString('base64');traceviewer.b.Base64.btoa=input=>new Buffer(input,'base64').toString();}
class TraceProcessor{get RESPONSE(){return'Response';}
get ANIMATION(){return'Animation';}
get LOAD(){return'Load';}
init(trace){const io=new traceviewer.importer.ImportOptions();io.showImportWarnings=false;io.pruneEmptyContainers=false;io.shiftWorldToZero=true;const model=new traceviewer.Model();const importer=new traceviewer.importer.Import(model,io);importer.importTraces([trace]);return model;}
static _findMainThreadFromIds(model,processId,threadId){const modelHelper=model.getOrCreateHelper(traceviewer.model.helpers.ChromeModelHelper);const renderHelpers=traceviewer.b.dictionaryValues(modelHelper.rendererHelpers);const mainThread=renderHelpers.find(helper=>{return helper.mainThread&&helper.pid===processId&&helper.mainThread.tid===threadId;}).mainThread;return mainThread;}
static _riskPercentiles(durations,totalTime,percentiles,clippedLength=0){let busyTime=0;for(let i=0;i<durations.length;i++){busyTime+=durations[i];}
busyTime-=clippedLength;let completedTime=totalTime-busyTime;let duration=0;let cdfTime=completedTime;const results=[];let durationIndex=-1;let remainingCount=durations.length+1;if(clippedLength>0){remainingCount--;}
for(const percentile of percentiles){const percentileTime=percentile*totalTime;while(cdfTime<percentileTime&&durationIndex<durations.length-1){completedTime+=duration;remainingCount-=duration<0?-1:1;if(clippedLength>0&&clippedLength<durations[durationIndex+1]){duration=-clippedLength;clippedLength=0;}else{durationIndex++;duration=durations[durationIndex];}
cdfTime=completedTime+Math.abs(duration)*remainingCount;}
results.push({percentile,time:Math.max(0,(percentileTime-completedTime)/remainingCount)+BASE_RESPONSE_LATENCY});}
return results;}
static getRiskToResponsiveness(model,trace,startTime,endTime,percentiles){startTime=startTime===undefined?model.bounds.min:startTime;endTime=endTime===undefined?model.bounds.max:endTime;const totalTime=endTime-startTime;if(percentiles){percentiles.sort((a,b)=>a-b);}else{percentiles=[0.5,0.75,0.9,0.99,1];}
const ret=TraceProcessor.getMainThreadTopLevelEventDurations(model,trace,startTime,endTime);return TraceProcessor._riskPercentiles(ret.durations,totalTime,percentiles,ret.clippedLength);}
static getMainThreadTopLevelEventDurations(model,trace,startTime,endTime){const slices=TraceProcessor.getMainThreadTopLevelEvents(model,trace,startTime,endTime);const durations=[];let clippedLength=0;slices.forEach(slice=>{let duration=slice.duration;let sliceStart=slice.start;if(sliceStart<startTime){sliceStart=startTime;duration=slice.end-sliceStart;}
if(slice.end>endTime){clippedLength=duration-(endTime-sliceStart);}
durations.push(duration);});durations.sort((a,b)=>a-b);return{durations,clippedLength};}
static getMainThreadTopLevelEvents(model,trace,startTime=-Infinity,endTime=Infinity){const startEvent=trace.traceEvents.find(event=>event.name==='TracingStartedInPage');const mainThread=TraceProcessor._findMainThreadFromIds(model,startEvent.pid,startEvent.tid);return mainThread.sliceGroup.slices.filter(slice=>{return slice.title===SCHEDULABLE_TASK_TITLE&&slice.end>startTime&&slice.start<endTime;});}
static getLogNormalDistribution(median,falloff){const location=Math.log(median);const logRatio=Math.log(falloff/median);const shape=0.5*Math.sqrt(1-3*logRatio-
Math.sqrt((logRatio-3)*(logRatio-3)-8));return new traceviewer.b.Statistics.LogNormalDistribution(location,shape);}}
module.exports=TraceProcessor;}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{},require("buffer").Buffer);},{"../../third_party/traceviewer-js/":84,"buffer":204,"gl-matrix":264}],27:[function(require,module,exports){'use strict';const Util=require('../report/v2/renderer/util.js');const URL=typeof self!=='undefined'&&self.URL||require('whatwg-url').URL;URL.INVALID_URL_DEBUG_STRING='Lighthouse was unable to determine the URL of some script executions. '+'It\'s possible a Chrome extension or other eval\'d code is the source.';URL.isValid=function isValid(url){try{new URL(url);return true;}catch(e){return false;}};URL.hostsMatch=function hostsMatch(urlA,urlB){try{return new URL(urlA).host===new URL(urlB).host;}catch(e){return false;}};URL.originsMatch=function originsMatch(urlA,urlB){try{return new URL(urlA).origin===new URL(urlB).origin;}catch(e){return false;}};URL.getOrigin=function getOrigin(url){try{const urlInfo=new URL(url);return urlInfo.host&&urlInfo.origin||null;}catch(e){return null;}};URL.getURLDisplayName=function getURLDisplayName(url,options){return Util.getURLDisplayName(new URL(url),options);};function rewriteChromeInternalUrl(url){if(!url.startsWith('chrome://'))return url;return url.replace(/^chrome:\/\/chrome\//,'chrome://');}
URL.equalWithExcludedFragments=function(url1,url2){[url1,url2]=[url1,url2].map(rewriteChromeInternalUrl);try{url1=new URL(url1);url1.hash='';url2=new URL(url2);url2.hash='';return url1.href===url2.href;}catch(e){return false;}};module.exports=URL;},{"../report/v2/renderer/util.js":30,"whatwg-url":202}],28:[function(require,module,exports){(function(global){'use strict';module.exports=function(){if(global.WebInspector){return global.WebInspector;}
if(global.self!==global){global.self=global;}
if(typeof global.window==='undefined'){global.window=global;}
global.Runtime={};global.Runtime.experiments={isEnabled(experimentName){switch(experimentName){case'timelineLatencyInfo':return true;default:return false;}}};global.Runtime.queryParam=function(arg){switch(arg){case'remoteFrontend':return false;case'ws':return false;default:throw Error('Mock queryParam case not implemented.');}};global.TreeElement={};global.WorkerRuntime={};global.Protocol={Agents(){}};global.WebInspector={};const WebInspector=global.WebInspector;WebInspector._moduleSettings={cacheDisabled:{addChangeListener(){},get(){return false;}},monitoringXHREnabled:{addChangeListener(){},get(){return false;}},showNativeFunctionsInJSProfile:{addChangeListener(){},get(){return true;}}};WebInspector.moduleSetting=function(settingName){return this._moduleSettings[settingName];};global.NetworkAgent={RequestMixedContentType:{Blockable:'blockable',OptionallyBlockable:'optionally-blockable',None:'none'},BlockedReason:{CSP:'csp',MixedContent:'mixed-content',Origin:'origin',Inspector:'inspector',Other:'other'},InitiatorType:{Other:'other',Parser:'parser',Redirect:'redirect',Script:'script'}};global.SecurityAgent={SecurityState:{Unknown:'unknown',Neutral:'neutral',Insecure:'insecure',Warning:'warning',Secure:'secure',Info:'info'}};global.PageAgent={ResourceType:{Document:'document',Stylesheet:'stylesheet',Image:'image',Media:'media',Font:'font',Script:'script',TextTrack:'texttrack',XHR:'xhr',Fetch:'fetch',EventSource:'eventsource',WebSocket:'websocket',Manifest:'manifest',Other:'other'}};require('chrome-devtools-frontend/front_end/common/Object.js');require('chrome-devtools-frontend/front_end/common/ParsedURL.js');require('chrome-devtools-frontend/front_end/common/ResourceType.js');require('chrome-devtools-frontend/front_end/common/UIString.js');require('chrome-devtools-frontend/front_end/platform/utilities.js');require('chrome-devtools-frontend/front_end/sdk/Target.js');require('chrome-devtools-frontend/front_end/sdk/TargetManager.js');require('chrome-devtools-frontend/front_end/sdk/NetworkManager.js');require('chrome-devtools-frontend/front_end/sdk/NetworkRequest.js');WebInspector.targetManager={observeTargets(){},addEventListener(){}};WebInspector.settings={createSetting(){return{get(){return false;},addChangeListener(){}};}};WebInspector.console={error(){}};WebInspector.VBox=function(){};WebInspector.HBox=function(){};WebInspector.ViewportDataGrid=function(){};WebInspector.ViewportDataGridNode=function(){};global.WorkerRuntime.Worker=function(){};require('chrome-devtools-frontend/front_end/common/SegmentedRange.js');require('chrome-devtools-frontend/front_end/bindings/TempFile.js');require('chrome-devtools-frontend/front_end/sdk/TracingModel.js');require('chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js');require('chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js');require('chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js');require('chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js');require('chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js');require('chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js');require('chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js');require('chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js');WebInspector.DeferredTempFile=function(){};WebInspector.DeferredTempFile.prototype={write:function(){},finishWriting:function(){}};WebInspector.ConsoleMessage=function(){};WebInspector.ConsoleMessage.MessageSource={Network:'network'};WebInspector.ConsoleMessage.MessageLevel={Log:'log'};WebInspector.ConsoleMessage.MessageType={Log:'log'};WebInspector.NetworkLog=function(target){this._requests=new Map();target.networkManager.addEventListener(WebInspector.NetworkManager.Events.RequestStarted,this._onRequestStarted,this);};WebInspector.NetworkLog.prototype={requestForURL:function(url){return this._requests.get(url)||null;},_onRequestStarted:function(event){const request=event.data;if(this._requests.has(request.url)){return;}
this._requests.set(request.url,request);}};require('chrome-devtools-frontend/front_end/common/Color.js');const Dispatcher=WebInspector.NetworkDispatcher;const origUpdateRequest=Dispatcher.prototype._updateNetworkRequestWithRequest;Dispatcher.prototype._updateNetworkRequestWithRequest=function(netRecord,request){origUpdateRequest.apply(this,arguments);netRecord.isLinkPreload=Boolean(request.isLinkPreload);netRecord._isLinkPreload=Boolean(request.isLinkPreload);};WebInspector.NetworkManager.createWithFakeTarget=function(){const fakeNetworkAgent={enable(){},getResponseBody(){throw new Error('Use driver.getRequestContent() for network request content');}};const fakeConsoleModel={addMessage(){},target(){}};const fakeTarget={_modelByConstructor:new Map(),get consoleModel(){return fakeConsoleModel;},networkAgent(){return fakeNetworkAgent;},registerNetworkDispatcher(){},model(){}};fakeTarget.networkManager=new WebInspector.NetworkManager(fakeTarget);fakeTarget.networkLog=new WebInspector.NetworkLog(fakeTarget);WebInspector.NetworkLog.fromTarget=()=>{return fakeTarget.networkLog;};return fakeTarget.networkManager;};require('chrome-devtools-frontend/front_end/common/TextRange.js');const gonzales=require('chrome-devtools-frontend/front_end/gonzales/gonzales-scss.js');require('chrome-devtools-frontend/front_end/gonzales/SCSSParser.js');WebInspector.SCSSParser.prototype.parse=function(content){let ast=null;try{ast=gonzales.parse(content,{syntax:'css'});}catch(e){return{error:e};}
const rootBlock={properties:[],node:ast};const blocks=[rootBlock];ast.selectors=[];WebInspector.SCSSParser.extractNodes(ast,blocks,rootBlock);return ast;};return WebInspector;}();}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"chrome-devtools-frontend/front_end/bindings/TempFile.js":233,"chrome-devtools-frontend/front_end/common/Color.js":234,"chrome-devtools-frontend/front_end/common/Object.js":235,"chrome-devtools-frontend/front_end/common/ParsedURL.js":236,"chrome-devtools-frontend/front_end/common/ResourceType.js":237,"chrome-devtools-frontend/front_end/common/SegmentedRange.js":238,"chrome-devtools-frontend/front_end/common/TextRange.js":239,"chrome-devtools-frontend/front_end/common/UIString.js":240,"chrome-devtools-frontend/front_end/components_lazy/FilmStripModel.js":241,"chrome-devtools-frontend/front_end/gonzales/SCSSParser.js":242,"chrome-devtools-frontend/front_end/gonzales/gonzales-scss.js":243,"chrome-devtools-frontend/front_end/platform/utilities.js":244,"chrome-devtools-frontend/front_end/sdk/CPUProfileDataModel.js":245,"chrome-devtools-frontend/front_end/sdk/NetworkManager.js":246,"chrome-devtools-frontend/front_end/sdk/NetworkRequest.js":247,"chrome-devtools-frontend/front_end/sdk/ProfileTreeModel.js":248,"chrome-devtools-frontend/front_end/sdk/Target.js":249,"chrome-devtools-frontend/front_end/sdk/TargetManager.js":250,"chrome-devtools-frontend/front_end/sdk/TracingModel.js":251,"chrome-devtools-frontend/front_end/timeline/TimelineTreeView.js":252,"chrome-devtools-frontend/front_end/timeline/TimelineUIUtils.js":253,"chrome-devtools-frontend/front_end/timeline_model/LayerTreeModel.js":254,"chrome-devtools-frontend/front_end/timeline_model/TimelineFrameModel.js":255,"chrome-devtools-frontend/front_end/timeline_model/TimelineIRModel.js":256,"chrome-devtools-frontend/front_end/timeline_model/TimelineJSProfile.js":257,"chrome-devtools-frontend/front_end/timeline_model/TimelineModel.js":258,"chrome-devtools-frontend/front_end/timeline_model/TimelineProfileTree.js":259,"chrome-devtools-frontend/front_end/ui_lazy/SortableDataGrid.js":260}],29:[function(require,module,exports){'use strict';const formatters={};["accessibility.html","cards.css","cards.html","critical-request-chains.css","critical-request-chains.html","null.html","speedline.html","table.css","table.html","templates","url-list.css","url-list.html","user-timings.css","user-timings.html"].filter(filename=>filename.endsWith('.html')).forEach(filename=>{const baseName=filename.replace(/\.html$/,'');const capsName=baseName.replace(/-/g,'_').toUpperCase();formatters[capsName]=baseName;});class Formatter{static get SUPPORTED_FORMATS(){return formatters;}}
module.exports=Formatter;},{}],30:[function(require,module,exports){'use strict';const ELLIPSIS='\u2026';const NBSP='\xa0';const RATINGS={PASS:{label:'pass',minScore:75},AVERAGE:{label:'average',minScore:45},FAIL:{label:'fail'}};class Util{static calculateRating(score){let rating=RATINGS.FAIL.label;if(score>=RATINGS.PASS.minScore){rating=RATINGS.PASS.label;}else if(score>=RATINGS.AVERAGE.minScore){rating=RATINGS.AVERAGE.label;}
return rating;}
static formatNumber(number){return number.toLocaleString(undefined,{maximumFractionDigits:1});}
static formateBytesToKB(size,decimalPlaces=2){return(size/1024).toLocaleString(undefined,{maximumFractionDigits:decimalPlaces});}
static formatMilliseconds(ms,granularity=10){const coarseTime=Math.round(ms/granularity)*granularity;return`${coarseTime.toLocaleString()}${NBSP}ms`;}
static formatDateTime(date){const options={month:'short',day:'numeric',year:'numeric',hour:'numeric',minute:'numeric',timeZoneName:'short'};let formatter=new Intl.DateTimeFormat('en-US',options);const tz=formatter.resolvedOptions().timeZone;if(!tz||tz.toLowerCase()==='etc/unknown'){options.timeZone='UTC';formatter=new Intl.DateTimeFormat('en-US',options);}
return formatter.format(new Date(date));}
static getURLDisplayName(parsedUrl,options={}){const numPathParts=options.numPathParts!==undefined?options.numPathParts:2;const preserveQuery=options.preserveQuery!==undefined?options.preserveQuery:true;const preserveHost=options.preserveHost||false;let name;if(parsedUrl.protocol==='about:'||parsedUrl.protocol==='data:'){name=parsedUrl.href;}else{name=parsedUrl.pathname;const parts=name.split('/').filter(part=>part.length);if(numPathParts&&parts.length>numPathParts){name=ELLIPSIS+parts.slice(-1*numPathParts).join('/');}
if(preserveHost){name=`${parsedUrl.host}/${name.replace(/^\//,'')}`;}
if(preserveQuery){name=`${name}${parsedUrl.search}`;}}
const MAX_LENGTH=64;name=name.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${ELLIPSIS}`);if(name.length>MAX_LENGTH&&name.includes('?')){name=name.replace(/\?([^=]*)(=)?.*/,`?$1$2${ELLIPSIS}`);if(name.length>MAX_LENGTH){name=name.replace(/\?.*/,`?${ELLIPSIS}`);}}
if(name.length>MAX_LENGTH){const dotIndex=name.lastIndexOf('.');if(dotIndex>=0){name=name.slice(0,MAX_LENGTH-1-(name.length-dotIndex))+`${ELLIPSIS}${name.slice(dotIndex)}`;}else{name=name.slice(0,MAX_LENGTH-1)+ELLIPSIS;}}
return name;}
static parseURL(url){const parsedUrl=new URL(url);return{file:Util.getURLDisplayName(parsedUrl),hostname:parsedUrl.hostname};}
static chainDuration(startTime,endTime){return Util.formatNumber((endTime-startTime)*1000);}}
if(typeof module!=='undefined'&&module.exports){module.exports=Util;}else{self.Util=Util;}},{}],31:[function(require,module,exports){'use strict';const REPORT_TEMPLATE="<!--\n\nCopyright 2017 Google Inc. All rights reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n-->\n<!doctype html>\n<html lang=\"en\">\n<head>\n  <meta charset=\"utf-8\">\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, minimum-scale=1\">\n  <link rel=\"icon\" href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAADjklEQVR4AWI08P/HQEvAQrxSQKvlECfLFYXx75xCY2qmh89GbNvOMjb3v9jOOlxnFWxj206ebQ3b7q6q+z1rNagu8/zvPSZACAABpeUAA0miMgU7SA7JjCraFGwZwECOwvL75dWjsKgWBKtx0jvWo+vkBAFbACCkByMP6nMn48+AVgXB2fzSCwsv22/lMGlUhmJ0AE7BH8dyUUDbUEgN6RzJRSeaPxhdRYR0Inel+7Hd5lBiFpkMAxACc0394//9C4voFHDiAAGLpuOXebdfdHfctgwJKaZRLRKy6ItrSis6RBnVBgGtbHyKTEmJHQoEXoBCE5BCrDeA2ogMUIGDAKEBDEhUqwgMqBYDjW4DQzmuffVdqff42/ZQYYqVcMXGZsMPyCsH3lyJSetxvEaxAQXdjR1HjfwCdIS7lo2DZke26Qe+MXO12OWkGT0O6oE7vMGkMnkYw4aN1KQgMKExhXqswfiov4+a7MQ11XPnbr/5qpKlgACAAQj94Lu271bN9DUecQasIZlNzG72llRAAKJiAi+/BSHrSFjRvQhg3DEKEqJh08tsmLTx597+f6enr4cc2Zpk57pihfX24dW7RHcOLLUbJYhJSl0ErQCI9BVXH/XrO97QasuvQQSiECa0BrQCIIJp6X9T/r8QG6L71WYSqCoIIGo2BZDUBnS/D9EA9Nun1iYvbM0MFExIDQRoKFatc1Z6zrm5uWeObJotq0BGV9FuQBWq5a4Fw3PPz848rZHstZSuA5FWAFSMP2nOppOOGpl6qh9PCSg0IFyHKjSQyDNQHTru2t75NOEe0fsf246oAmFkI6vCdnWvbQFQFCKx8vCswV8TrDLiDLgH4Nr7RAtNsrC9d8sfk7b8ls4igdNy8CQKAISlsB0FjZfd3Lfp155tf8fKI4BxZZIj/oTdVEAIAcJFOCmzauHG71I7/rdreUAgAqpDP05fDARCAQQARwEIBQSVxq0FyaLvZZtevpHa8WHw8cft6cpxlq8eAJtIhnSbWDf951yx3y13OqUuu5qyGgkxCgGFh9cDihDGbTa6BqvT1lWmrav3bmt2ZMJ4mU6TGgIC4DBzcv/JqAau1WhzSt3x9Ixk/4Jk/8J4ZrrViFMA4W6A7+WK8xcVjvyrOmVD0FbAXokcT48r+xVqLKvuJYbmpNadnlp3mpufJHOe/GXktM+r09bT8kEdq9BRYAbGSgzP7ll82U71Mc+ZFooXgwAAAABJRU5ErkJggg==\">\n  <title>Lighthouse Report</title>\n  <style>/*%%LIGHTHOUSE_CSS%%*/</style>\n</head>\n<body class=\"lh-root lh-vars\">\n  <noscript>Lighthouse report requires JavaScript. Please enable.</noscript>\n  <div hidden>%%LIGHTHOUSE_TEMPLATES%%</div>\n\n  <main><!-- report populated here --></main>\n\n  <div id=\"lh-log\"></div>\n\n  <script>%%LIGHTHOUSE_JAVASCRIPT%%</script>\n  <script>window.__LIGHTHOUSE_JSON__ = %%LIGHTHOUSE_JSON%%;</script>\n  <script>\n    window.addEventListener('DOMContentLoaded', _ => {\n      const dom = new DOM(document);\n      const detailsRenderer = new DetailsRenderer(dom);\n      const categoryRenderer = new CategoryRenderer(dom, detailsRenderer);\n      const features = new ReportUIFeatures(dom);\n      const renderer = new ReportRenderer(dom, categoryRenderer, features);\n\n      const container = document.querySelector('main');\n      renderer.renderReport(window.__LIGHTHOUSE_JSON__, container);\n    });\n\n    document.addEventListener('lh-analytics', e => {\n      if (window.ga) {\n        ga(e.detail.cmd, e.detail.fields);\n      }\n    });\n\n    document.addEventListener('lh-log', e => {\n      const logger = new Logger(document.querySelector('#lh-log'));\n\n      switch (e.detail.cmd) {\n        case 'log':\n          logger.log(e.detail.msg);\n          break;\n        case 'warn':\n          logger.warn(e.detail.msg);\n          break;\n        case 'error':\n          logger.error(e.detail.msg);\n          break;\n        case 'hide':\n          logger.hide();\n          break;\n      }\n    });\n  </script>\n</body>\n</html>\n";const REPORT_JAVASCRIPT=["/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n'use strict';\n\n/* globals self URL */\n\nconst ELLIPSIS = '\\u2026';\nconst NBSP = '\\xa0';\n\nconst RATINGS = {\n  PASS: {label: 'pass', minScore: 75},\n  AVERAGE: {label: 'average', minScore: 45},\n  FAIL: {label: 'fail'}\n};\n\nclass Util {\n  /**\n   * Convert a score to a rating label.\n   * @param {number} score\n   * @return {string}\n   */\n  static calculateRating(score) {\n    let rating = RATINGS.FAIL.label;\n    if (score >= RATINGS.PASS.minScore) {\n      rating = RATINGS.PASS.label;\n    } else if (score >= RATINGS.AVERAGE.minScore) {\n      rating = RATINGS.AVERAGE.label;\n    }\n    return rating;\n  }\n\n  /**\n   * Format number.\n   * @param {number} number\n   * @return {string}\n   */\n  static formatNumber(number) {\n    return number.toLocaleString(undefined, {maximumFractionDigits: 1});\n  }\n\n  /**\n   * @param {number} size\n   * @param {number=} decimalPlaces Number of decimal places to include. Defaults to 2.\n   * @return {string}\n   */\n  static formateBytesToKB(size, decimalPlaces = 2) {\n    return (size / 1024).toLocaleString(undefined, {maximumFractionDigits: decimalPlaces});\n  }\n\n  /**\n   * @param {number} ms\n   * @param {number=} granularity Controls how coarse the displayed value is, defaults to 10\n   * @return {string}\n   */\n  static formatMilliseconds(ms, granularity = 10) {\n    const coarseTime = Math.round(ms / granularity) * granularity;\n    return `${coarseTime.toLocaleString()}${NBSP}ms`;\n  }\n\n  /**\n   * Format time.\n   * @param {string} date\n   * @return {string}\n   */\n  static formatDateTime(date) {\n    const options = {\n      month: 'short', day: 'numeric', year: 'numeric',\n      hour: 'numeric', minute: 'numeric', timeZoneName: 'short'\n    };\n    let formatter = new Intl.DateTimeFormat('en-US', options);\n\n    // Force UTC if runtime timezone could not be detected.\n    // See https://github.com/GoogleChrome/lighthouse/issues/1056\n    const tz = formatter.resolvedOptions().timeZone;\n    if (!tz || tz.toLowerCase() === 'etc/unknown') {\n      options.timeZone = 'UTC';\n      formatter = new Intl.DateTimeFormat('en-US', options);\n    }\n    return formatter.format(new Date(date));\n  }\n\n  /**\n   * @param {!URL} parsedUrl\n   * @param {{numPathParts: (number|undefined), preserveQuery: (boolean|undefined), preserveHost: (boolean|undefined)}=} options\n   * @return {string}\n   */\n  static getURLDisplayName(parsedUrl, options = {}) {\n    const numPathParts = options.numPathParts !== undefined ? options.numPathParts : 2;\n    const preserveQuery = options.preserveQuery !== undefined ? options.preserveQuery : true;\n    const preserveHost = options.preserveHost || false;\n\n    let name;\n\n    if (parsedUrl.protocol === 'about:' || parsedUrl.protocol === 'data:') {\n      // Handle 'about:*' and 'data:*' URLs specially since they have no path.\n      name = parsedUrl.href;\n    } else {\n      name = parsedUrl.pathname;\n      const parts = name.split('/').filter(part => part.length);\n      if (numPathParts && parts.length > numPathParts) {\n        name = ELLIPSIS + parts.slice(-1 * numPathParts).join('/');\n      }\n\n      if (preserveHost) {\n        name = `${parsedUrl.host}/${name.replace(/^\\//, '')}`;\n      }\n      if (preserveQuery) {\n        name = `${name}${parsedUrl.search}`;\n      }\n    }\n\n    const MAX_LENGTH = 64;\n    // Always elide hash\n    name = name.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g, `$1${ELLIPSIS}`);\n\n    // Elide query params first\n    if (name.length > MAX_LENGTH && name.includes('?')) {\n      // Try to leave the first query parameter intact\n      name = name.replace(/\\?([^=]*)(=)?.*/, `?$1$2${ELLIPSIS}`);\n\n      // Remove it all if it's still too long\n      if (name.length > MAX_LENGTH) {\n        name = name.replace(/\\?.*/, `?${ELLIPSIS}`);\n      }\n    }\n\n    // Elide too long names next\n    if (name.length > MAX_LENGTH) {\n      const dotIndex = name.lastIndexOf('.');\n      if (dotIndex >= 0) {\n        name = name.slice(0, MAX_LENGTH - 1 - (name.length - dotIndex)) +\n            // Show file extension\n            `${ELLIPSIS}${name.slice(dotIndex)}`;\n      } else {\n        name = name.slice(0, MAX_LENGTH - 1) + ELLIPSIS;\n      }\n    }\n\n    return name;\n  }\n\n  /**\n   * Split a URL into a file and hostname for easy display.\n   * @param {string} url\n   * @return {{file: string, hostname: string}}\n   */\n  static parseURL(url) {\n    const parsedUrl = new URL(url);\n    return {file: Util.getURLDisplayName(parsedUrl), hostname: parsedUrl.hostname};\n  }\n\n  /**\n   * @param {number} startTime\n   * @param {number} endTime\n   * @return {string}\n   */\n  static chainDuration(startTime, endTime) {\n    return Util.formatNumber((endTime - startTime) * 1000);\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = Util;\n} else {\n  self.Util = Util;\n}\n","/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n'use strict';\n\n/* globals URL self */\n\nclass DOM {\n  /**\n   * @param {!Document} document\n   */\n  constructor(document) {\n    /** @private {!Document} */\n    this._document = document;\n  }\n\n  /**\n   * @param {string} name\n   * @param {string=} className\n   * @param {!Object<string, (string|undefined)>=} attrs Attribute key/val pairs.\n   *     Note: if an attribute key has an undefined value, this method does not\n   *     set the attribute on the node.\n   * @return {!Element}\n   */\n  createElement(name, className, attrs = {}) {\n    const element = this._document.createElement(name);\n    if (className) {\n      element.className = className;\n    }\n    Object.keys(attrs).forEach(key => {\n      const value = attrs[key];\n      if (typeof value !== 'undefined') {\n        element.setAttribute(key, value);\n      }\n    });\n    return element;\n  }\n\n  /**\n   * @param {!Element} parentElem\n   * @param {string} elementName\n   * @param {string=} className\n   * @param {!Object<string, (string|undefined)>=} attrs Attribute key/val pairs.\n   *     Note: if an attribute key has an undefined value, this method does not\n   *     set the attribute on the node.\n   * @return {!Element}\n   */\n  createChildOf(parentElem, elementName, className, attrs) {\n    const element = this.createElement(elementName, className, attrs);\n    parentElem.appendChild(element);\n    return element;\n  }\n\n  /**\n   * @param {string} selector\n   * @param {!Node} context\n   * @return {!DocumentFragment} A clone of the template content.\n   * @throws {Error}\n   */\n  cloneTemplate(selector, context) {\n    const template = /** @type {?HTMLTemplateElement} */ (context.querySelector(selector));\n    if (!template) {\n      throw new Error(`Template not found: template${selector}`);\n    }\n\n    const clone = /** @type {!DocumentFragment} */ (\n        this._document.importNode(template.content, true));\n\n    // Prevent duplicate styles in the DOM. After a template has been stamped\n    // for the first time, remove the clone's styles so they're not re-added.\n    if (template.hasAttribute('data-stamped')) {\n      this.findAll('style', clone).forEach(style => style.remove());\n    }\n    template.setAttribute('data-stamped', true);\n\n    return clone;\n  }\n\n  /**\n   * Resets the \"stamped\" state of the templates.\n   */\n  resetTemplates() {\n    this.findAll('template[data-stamped]', this._document).forEach(t => {\n      t.removeAttribute('data-stamped');\n    });\n  }\n\n  /**\n   * @param {string} text\n   * @return {!Element}\n   */\n  convertMarkdownLinkSnippets(text) {\n    const element = this.createElement('span');\n\n    // Split on markdown links (e.g. [some link](https://...)).\n    const parts = text.split(/\\[(.*?)\\]\\((https?:\\/\\/.*?)\\)/g);\n\n    while (parts.length) {\n      // Pop off the same number of elements as there are capture groups.\n      const [preambleText, linkText, linkHref] = parts.splice(0, 3);\n      element.appendChild(this._document.createTextNode(preambleText));\n\n      // Append link if there are any.\n      if (linkText && linkHref) {\n        const a = /** @type {!HTMLAnchorElement} */ (this.createElement('a'));\n        a.rel = 'noopener';\n        a.target = '_blank';\n        a.textContent = linkText;\n        a.href = (new URL(linkHref)).href;\n        element.appendChild(a);\n      }\n    }\n\n    return element;\n  }\n\n  /**\n   * @param {string} text\n   * @return {!Element}\n   */\n  convertMarkdownCodeSnippets(text) {\n    const element = this.createElement('span');\n\n    const parts = text.split(/`(.*?)`/g); // Split on markdown code slashes\n    while (parts.length) {\n      // Pop off the same number of elements as there are capture groups.\n      const [preambleText, codeText] = parts.splice(0, 2);\n      element.appendChild(this._document.createTextNode(preambleText));\n      if (codeText) {\n        const pre = /** @type {!HTMLPreElement} */ (this.createElement('code'));\n        pre.textContent = codeText;\n        element.appendChild(pre);\n      }\n    }\n\n    return element;\n  }\n\n  /**\n   * @return {!Document}\n   */\n  document() {\n    return this._document;\n  }\n\n  /**\n   * Guaranteed context.querySelector. Always returns an element or throws if\n   * nothing matches query.\n   * @param {string} query\n   * @param {!Node} context\n   * @return {!Element}\n   */\n  find(query, context) {\n    const result = context.querySelector(query);\n    if (result === null) {\n      throw new Error(`query ${query} not found`);\n    }\n    return result;\n  }\n\n  /**\n   * Helper for context.querySelectorAll. Returns an Array instead of a NodeList.\n   * @param {string} query\n   * @param {!Node} context\n   * @return {!Array<!Element>}\n   */\n  findAll(query, context) {\n    return Array.from(context.querySelectorAll(query));\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = DOM;\n} else {\n  self.DOM = DOM;\n}\n","/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n'use strict';\n\n/* globals self CriticalRequestChainRenderer Util */\n\nclass DetailsRenderer {\n  /**\n   * @param {!DOM} dom\n   */\n  constructor(dom) {\n    /** @private {!DOM} */\n    this._dom = dom;\n    /** @private {!Document|!Element} */\n    this._templateContext; // eslint-disable-line no-unused-expressions\n  }\n\n  /**\n   * @param {!Document|!Element} context\n   */\n  setTemplateContext(context) {\n    this._templateContext = context;\n  }\n\n  /**\n   * @param {!DetailsRenderer.DetailsJSON} details\n   * @return {!Node}\n   */\n  render(details) {\n    switch (details.type) {\n      case 'text':\n        return this._renderText(details);\n      case 'url':\n        return this._renderURL(details);\n      case 'thumbnail':\n        return this._renderThumbnail(/** @type {!DetailsRenderer.ThumbnailDetails} */ (details));\n      case 'filmstrip':\n        return this._renderFilmstrip(/** @type {!DetailsRenderer.FilmstripDetails} */ (details));\n      case 'cards':\n        return this._renderCards(/** @type {!DetailsRenderer.CardsDetailsJSON} */ (details));\n      case 'table':\n        return this._renderTable(/** @type {!DetailsRenderer.TableDetailsJSON} */ (details));\n      case 'code':\n        return this._renderCode(details);\n      case 'node':\n        return this.renderNode(/** @type {!DetailsRenderer.NodeDetailsJSON} */(details));\n      case 'criticalrequestchain':\n        return CriticalRequestChainRenderer.render(this._dom, this._templateContext,\n            /** @type {!CriticalRequestChainRenderer.CRCDetailsJSON} */ (details));\n      case 'list':\n        return this._renderList(/** @type {!DetailsRenderer.ListDetailsJSON} */ (details));\n      default:\n        throw new Error(`Unknown type: ${details.type}`);\n    }\n  }\n\n  /**\n   * @param {!DetailsRenderer.DetailsJSON} text\n   * @return {!Element}\n   */\n  _renderURL(text) {\n    const element = this._renderText(text);\n    element.classList.add('lh-text__url');\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.DetailsJSON} text\n   * @return {!Element}\n   */\n  _renderText(text) {\n    const element = this._dom.createElement('div', 'lh-text');\n    element.textContent = text.text;\n    return element;\n  }\n\n  /**\n   * Create small thumbnail with scaled down image asset.\n   * If the supplied details doesn't have an image/* mimeType, then an empty span is returned.\n   * @param {!DetailsRenderer.ThumbnailDetails} value\n   * @return {!Element}\n   */\n  _renderThumbnail(value) {\n    if (/^image/.test(value.mimeType) === false) {\n      return this._dom.createElement('span');\n    }\n\n    const element = this._dom.createElement('img', 'lh-thumbnail');\n    element.src = value.url;\n    element.alt = '';\n    element.title = value.url;\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.ListDetailsJSON} list\n   * @return {!Element}\n   */\n  _renderList(list) {\n    if (!list.items.length) return this._dom.createElement('span');\n\n    const element = this._dom.createElement('details', 'lh-details');\n    if (list.header) {\n      const summary = this._dom.createElement('summary', 'lh-list__header');\n      summary.textContent = list.header.text;\n      element.appendChild(summary);\n    }\n\n    const itemsElem = this._dom.createChildOf(element, 'div', 'lh-list__items');\n    for (const item of list.items) {\n      const itemElem = this._dom.createChildOf(itemsElem, 'span', 'lh-list__item');\n      itemElem.appendChild(this.render(item));\n    }\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.TableDetailsJSON} details\n   * @return {!Element}\n   */\n  _renderTable(details) {\n    if (!details.items.length) return this._dom.createElement('span');\n\n    const element = this._dom.createElement('details', 'lh-details');\n    if (details.header) {\n      element.appendChild(this._dom.createElement('summary')).textContent = details.header;\n    }\n\n    const tableElem = this._dom.createChildOf(element, 'table', 'lh-table');\n    const theadElem = this._dom.createChildOf(tableElem, 'thead');\n    const theadTrElem = this._dom.createChildOf(theadElem, 'tr');\n\n    for (const heading of details.itemHeaders) {\n      const itemType = heading.itemType || 'text';\n      const classes = `lh-table-column--${itemType}`;\n      this._dom.createChildOf(theadTrElem, 'th', classes).appendChild(this.render(heading));\n    }\n\n    const tbodyElem = this._dom.createChildOf(tableElem, 'tbody');\n    for (const row of details.items) {\n      const rowElem = this._dom.createChildOf(tbodyElem, 'tr');\n      for (const columnItem of row) {\n        const classes = `lh-table-column--${columnItem.type}`;\n        this._dom.createChildOf(rowElem, 'td', classes).appendChild(this.render(columnItem));\n      }\n    }\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.NodeDetailsJSON} item\n   * @return {!Element}\n   * @protected\n   */\n  renderNode(item) {\n    const element = this._dom.createElement('span', 'lh-node');\n    element.textContent = item.snippet;\n    element.title = item.selector;\n    if (item.text) element.setAttribute('data-text', item.text);\n    if (item.path) element.setAttribute('data-path', item.path);\n    if (item.selector) element.setAttribute('data-selector', item.selector);\n    if (item.snippet) element.setAttribute('data-snippet', item.snippet);\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.CardsDetailsJSON} details\n   * @return {!Element}\n   */\n  _renderCards(details) {\n    const element = this._dom.createElement('details', 'lh-details');\n    if (details.header) {\n      element.appendChild(this._dom.createElement('summary')).textContent = details.header.text;\n    }\n\n    const cardsParent = this._dom.createElement('div', 'lh-scorecards');\n    for (const item of details.items) {\n      const card = cardsParent.appendChild(\n          this._dom.createElement('div', 'lh-scorecard', {title: item.snippet}));\n      const titleEl = this._dom.createElement('div', 'lh-scorecard__title');\n      const valueEl = this._dom.createElement('div', 'lh-scorecard__value');\n      const targetEl = this._dom.createElement('div', 'lh-scorecard__target');\n\n      card.appendChild(titleEl).textContent = item.title;\n      card.appendChild(valueEl).textContent = item.value;\n\n      if (item.target) {\n        card.appendChild(targetEl).textContent = `target: ${item.target}`;\n      }\n    }\n\n    element.appendChild(cardsParent);\n    return element;\n  }\n\n  /**\n   * @param {!DetailsRenderer.FilmstripDetails} details\n   * @return {!Element}\n   */\n  _renderFilmstrip(details) {\n    const filmstripEl = this._dom.createElement('div', 'lh-filmstrip');\n\n    for (const thumbnail of details.items) {\n      const frameEl = this._dom.createChildOf(filmstripEl, 'div', 'lh-filmstrip__frame');\n\n      let timing = thumbnail.timing.toLocaleString() + ' ms';\n      if (thumbnail.timing > 1000) {\n        timing = Util.formatNumber(thumbnail.timing / 1000) + ' s';\n      }\n\n      const timingEl = this._dom.createChildOf(frameEl, 'div', 'lh-filmstrip__timestamp');\n      timingEl.textContent = timing;\n\n      const base64data = thumbnail.data;\n      this._dom.createChildOf(frameEl, 'img', 'lh-filmstrip__thumbnail', {\n        src: `data:image/jpeg;base64,${base64data}`,\n        alt: `Screenshot at ${timing}`,\n      });\n    }\n\n    return filmstripEl;\n  }\n\n  /**\n   * @param {!DetailsRenderer.DetailsJSON} details\n   * @return {!Element}\n   */\n  _renderCode(details) {\n    const pre = this._dom.createElement('pre', 'lh-code');\n    pre.textContent = details.text;\n    return pre;\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = DetailsRenderer;\n} else {\n  self.DetailsRenderer = DetailsRenderer;\n}\n\n/**\n * @typedef {{\n *     type: string,\n *     text: (string|undefined)\n * }}\n */\nDetailsRenderer.DetailsJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     type: string,\n *     header: ({text: string}|undefined),\n *     items: !Array<{type: string, text: (string|undefined)}>\n * }}\n */\nDetailsRenderer.ListDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     type: string,\n *     text: (string|undefined),\n *     path: (string|undefined),\n *     selector: (string|undefined),\n *     snippet:(string|undefined)\n * }}\n */\nDetailsRenderer.NodeDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     type: string,\n *     header: ({text: string}|undefined),\n *     items: !Array<{title: string, value: string, snippet: (string|undefined), target: string}>\n * }}\n */\nDetailsRenderer.CardsDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     type: string,\n *     itemType: (string|undefined),\n *     text: (string|undefined)\n * }}\n */\nDetailsRenderer.TableHeaderJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     type: string,\n *     text: (string|undefined),\n *     path: (string|undefined),\n *     selector: (string|undefined),\n *     snippet:(string|undefined)\n * }}\n */\nDetailsRenderer.NodeDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     type: string,\n *     header: ({text: string}|undefined),\n *     items: !Array<!Array<!DetailsRenderer.DetailsJSON>>,\n *     itemHeaders: !Array<!DetailsRenderer.TableHeaderJSON>\n * }}\n */\nDetailsRenderer.TableDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     type: string,\n *     url: ({text: string}|undefined),\n *     mimeType: ({text: string}|undefined)\n * }}\n */\nDetailsRenderer.ThumbnailDetails; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     type: string,\n *     scale: number,\n *     items: !Array<{timing: number, timestamp: number, data: string}>,\n * }}\n */\nDetailsRenderer.FilmstripDetails; // eslint-disable-line no-unused-expressions\n","/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n'use strict';\n\n/**\n * @fileoverview This file contains helpers for constructing and rendering the\n * critical request chains network tree.\n */\n\n/* globals self Util */\n\nclass CriticalRequestChainRenderer {\n  /**\n   * Create render context for critical-request-chain tree display.\n   * @param {!Object<string, !CriticalRequestChainRenderer.CRCNode>} tree\n   * @return {{tree: !Object<string, !CriticalRequestChainRenderer.CRCNode>, startTime: number, transferSize: number}}\n   */\n  static initTree(tree) {\n    let startTime = 0;\n    const rootNodes = Object.keys(tree);\n    if (rootNodes.length > 0) {\n      const node = tree[rootNodes[0]];\n      startTime = node.request.startTime;\n    }\n\n    return {tree, startTime, transferSize: 0};\n  }\n\n  /**\n   * Helper to create context for each critical-request-chain node based on its\n   * parent. Calculates if this node is the last child, whether it has any\n   * children itself and what the tree looks like all the way back up to the root,\n   * so the tree markers can be drawn correctly.\n   * @param {!Object<string, !CriticalRequestChainRenderer.CRCNode>} parent\n   * @param {string} id\n   * @param {number} startTime\n   * @param {number} transferSize\n   * @param {!Array<boolean>=} treeMarkers\n   * @param {boolean=} parentIsLastChild\n   * @return {!CriticalRequestChainRenderer.CRCSegment}\n   */\n  static createSegment(parent, id, startTime, transferSize, treeMarkers, parentIsLastChild) {\n    const node = parent[id];\n    const siblings = Object.keys(parent);\n    const isLastChild = siblings.indexOf(id) === (siblings.length - 1);\n    const hasChildren = Object.keys(node.children).length > 0;\n\n    // Copy the tree markers so that we don't change by reference.\n    const newTreeMarkers = Array.isArray(treeMarkers) ? treeMarkers.slice(0) : [];\n\n    // Add on the new entry.\n    if (typeof parentIsLastChild !== 'undefined') {\n      newTreeMarkers.push(!parentIsLastChild);\n    }\n\n    return {\n      node,\n      isLastChild,\n      hasChildren,\n      startTime,\n      transferSize: transferSize + node.request.transferSize,\n      treeMarkers: newTreeMarkers\n    };\n  }\n\n  /**\n   * Creates the DOM for a tree segment.\n   * @param {!DOM} dom\n   * @param {!DocumentFragment} tmpl\n   * @param {!CriticalRequestChainRenderer.CRCSegment} segment\n   * @param {!CriticalRequestChainRenderer.CRCDetailsJSON} details\n   * @return {!Node}\n   */\n  static createChainNode(dom, tmpl, segment, details) {\n    const chainsEl = dom.cloneTemplate('#tmpl-lh-crc__chains', tmpl);\n\n    // Hovering over request shows full URL.\n    dom.find('.crc-node', chainsEl).setAttribute('title', segment.node.request.url);\n\n    const treeMarkeEl = dom.find('.crc-node__tree-marker', chainsEl);\n\n    // Construct lines and add spacers for sub requests.\n    segment.treeMarkers.forEach(separator => {\n      if (separator) {\n        treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker vert'));\n        treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker'));\n      } else {\n        treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker'));\n        treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker'));\n      }\n    });\n\n    if (segment.isLastChild) {\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker up-right'));\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker right'));\n    } else {\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker vert-right'));\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker right'));\n    }\n\n    if (segment.hasChildren) {\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker horiz-down'));\n    } else {\n      treeMarkeEl.appendChild(dom.createElement('span', 'tree-marker right'));\n    }\n\n    // Fill in url, host, and request size information.\n    const {file, hostname} = Util.parseURL(segment.node.request.url);\n    const treevalEl = dom.find('.crc-node__tree-value', chainsEl);\n    dom.find('.crc-node__tree-file', treevalEl).textContent = `${file}`;\n    dom.find('.crc-node__tree-hostname', treevalEl).textContent = `(${hostname})`;\n\n    if (!segment.hasChildren) {\n      const span = dom.createElement('span', 'crc-node__chain-duration');\n      span.textContent = ' - ' + Util.chainDuration(\n          segment.node.request.startTime, segment.node.request.endTime) + 'ms, ';\n      const span2 = dom.createElement('span', 'crc-node__chain-duration');\n      span2.textContent = Util.formateBytesToKB(details.longestChain.transferSize) + 'KB';\n\n      treevalEl.appendChild(span);\n      treevalEl.appendChild(span2);\n    }\n\n    return chainsEl;\n  }\n\n  /**\n   * Recursively builds a tree from segments.\n   * @param {!DOM} dom\n   * @param {!DocumentFragment} tmpl\n   * @param {!CriticalRequestChainRenderer.CRCSegment} segment\n   * @param {!Element} detailsEl Parent details element.\n   * @param {!CriticalRequestChainRenderer.CRCDetailsJSON} details\n   */\n  static buildTree(dom, tmpl, segment, detailsEl, details) {\n    detailsEl.appendChild(CriticalRequestChainRenderer.createChainNode(dom, tmpl, segment,\n        details));\n\n    for (const key of Object.keys(segment.node.children)) {\n      const childSegment = CriticalRequestChainRenderer.createSegment(segment.node.children, key,\n         segment.startTime, segment.transferSize, segment.treeMarkers, segment.isLastChild);\n      CriticalRequestChainRenderer.buildTree(dom, tmpl, childSegment, detailsEl, details);\n    }\n  }\n\n  /**\n   * @param {!DOM} dom\n   * @param {!Node} templateContext\n   * @param {!CriticalRequestChainRenderer.CRCDetailsJSON} details\n   * @return {!Node}\n   */\n  static render(dom, templateContext, details) {\n    const tmpl = dom.cloneTemplate('#tmpl-lh-crc', templateContext);\n\n    // Fill in top summary.\n    dom.find('.lh-crc__longest_duration', tmpl).textContent =\n        Util.formatNumber(details.longestChain.duration) + 'ms';\n    dom.find('.lh-crc__longest_length', tmpl).textContent = details.longestChain.length;\n    dom.find('.lh-crc__longest_transfersize', tmpl).textContent =\n        Util.formateBytesToKB(details.longestChain.transferSize) + 'KB';\n\n    const detailsEl = dom.find('.lh-details', tmpl);\n\n    dom.find('.lh-details > summary', tmpl).textContent = details.header.text;\n\n    // Construct visual tree.\n    const root = CriticalRequestChainRenderer.initTree(details.chains);\n    for (const key of Object.keys(root.tree)) {\n      const segment = CriticalRequestChainRenderer.createSegment(root.tree, key,\n          root.startTime, root.transferSize);\n      CriticalRequestChainRenderer.buildTree(dom, tmpl, segment, detailsEl, details);\n    }\n\n    return tmpl;\n  }\n}\n\n// Allow Node require()'ing.\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = CriticalRequestChainRenderer;\n} else {\n  self.CriticalRequestChainRenderer = CriticalRequestChainRenderer;\n}\n\n/** @typedef {{\n *     type: string,\n *     header: {text: string},\n *     longestChain: {duration: number, length: number, transferSize: number},\n *     chains: !Object<string, !CriticalRequestChainRenderer.CRCNode>\n * }}\n */\nCriticalRequestChainRenderer.CRCDetailsJSON; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     endTime: number,\n *     responseReceivedTime: number,\n *     startTime: number,\n *     transferSize: number,\n *     url: string\n * }}\n */\nCriticalRequestChainRenderer.CRCRequest; // eslint-disable-line no-unused-expressions\n\n/**\n * Record type so children can circularly have CRCNode values.\n * @struct\n * @record\n */\nCriticalRequestChainRenderer.CRCNode = function() {};\n\n/** @type {!Object<string, !CriticalRequestChainRenderer.CRCNode>} */\nCriticalRequestChainRenderer.CRCNode.prototype.children; // eslint-disable-line no-unused-expressions\n\n/** @type {!CriticalRequestChainRenderer.CRCRequest} */\nCriticalRequestChainRenderer.CRCNode.prototype.request; // eslint-disable-line no-unused-expressions\n\n/** @typedef {{\n *     node: !CriticalRequestChainRenderer.CRCNode,\n *     isLastChild: boolean,\n *     hasChildren: boolean,\n *     startTime: number,\n *     transferSize: number,\n *     treeMarkers: !Array<boolean>\n * }}\n */\nCriticalRequestChainRenderer.CRCSegment; // eslint-disable-line no-unused-expressions\n","/**\n * @license\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n'use strict';\n\n/* global URL */\n\n/**\n * Generate a filenamePrefix of hostname_YYYY-MM-DD_HH-MM-SS\n * Date/time uses the local timezone, however Node has unreliable ICU\n * support, so we must construct a YYYY-MM-DD date format manually. :/\n * @param {{url: string, generatedTime: string}} results\n * @return {string}\n */\nfunction getFilenamePrefix(results) {\n  const hostname = new (URLConstructor || URL)(results.url).hostname;\n  const date = (results.generatedTime && new Date(results.generatedTime)) || new Date();\n\n  const timeStr = date.toLocaleTimeString('en-US', {hour12: false});\n  const dateParts = date.toLocaleDateString('en-US', {\n    year: 'numeric', month: '2-digit', day: '2-digit'\n  }).split('/');\n  dateParts.unshift(dateParts.pop());\n  const dateStr = dateParts.join('-');\n\n  const filenamePrefix = `${hostname}_${dateStr}_${timeStr}`;\n  // replace characters that are unfriendly to filenames\n  return filenamePrefix.replace(/[\\/\\?<>\\\\:\\*\\|\":]/g, '-');\n}\n\nlet URLConstructor;\nif (typeof module !== 'undefined' && module.exports) {\n  URLConstructor = require('./url-shim');\n\n  module.exports = {getFilenamePrefix};\n}\n","/**\n * @license\n * Copyright 2017 Google Inc. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n'use strict';\n\n/**\n * Logs messages via a UI butter.\n */\nclass Logger {\n  /**\n   * @param {!Element} element\n   */\n  constructor(element) {\n    /** @type {!Element} */\n    this.el = element;\n    /** @private {?number} */\n    this._id = null;\n  }\n\n  /**\n   * Shows a butter bar.\n   * @param {!string} msg The message to show.\n   * @param {boolean=} autoHide True to hide the message after a duration.\n   *     Default is true.\n   */\n  log(msg, autoHide = true) {\n    clearTimeout(this._id);\n\n    this.el.textContent = msg;\n    this.el.classList.add('show');\n    if (autoHide) {\n      this._id = setTimeout(_ => {\n        this.el.classList.remove('show');\n      }, 7000);\n    }\n  }\n\n  /**\n   * @param {string} msg\n   */\n  warn(msg) {\n    this.log('Warning: ' + msg);\n  }\n\n  /**\n   * @param {string} msg\n   */\n  error(msg) {\n    this.log(msg);\n  }\n\n  /**\n   * Explicitly hides the butter bar.\n   */\n  hide() {\n    clearTimeout(this._id);\n    this.el.classList.remove('show');\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = Logger;\n}\n","/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n'use strict';\n\n/**\n * @fileoverview Adds export button, print, and other dynamic functionality to\n * the report.\n */\n\n/* globals self URL Blob CustomEvent getFilenamePrefix */\n\nclass ReportUIFeatures {\n\n  /**\n   * @param {!DOM} dom\n   */\n  constructor(dom) {\n    /** @type {!ReportRenderer.ReportJSON} */\n    this.json; // eslint-disable-line no-unused-expressions\n    /** @private {!DOM} */\n    this._dom = dom;\n    /** @private {!Document} */\n    this._document = this._dom.document();\n    /** @private {boolean} */\n    this._copyAttempt = false;\n    /** @type {!Element} **/\n    this.exportButton; // eslint-disable-line no-unused-expressions\n\n    this.onMediaQueryChange = this.onMediaQueryChange.bind(this);\n    this.onCopy = this.onCopy.bind(this);\n    this.onExportButtonClick = this.onExportButtonClick.bind(this);\n    this.onExport = this.onExport.bind(this);\n    this.onKeyDown = this.onKeyDown.bind(this);\n    this.printShortCutDetect = this.printShortCutDetect.bind(this);\n  }\n\n  /**\n   * Adds export button, print, and other functionality to the report. The method\n   * should be called whenever the report needs to be re-rendered.\n   * @param {!ReportRenderer.ReportJSON} report\n   */\n  initFeatures(report) {\n    this.json = report;\n    this._setupMediaQueryListeners();\n    this._setupExportButton();\n    this._setUpCollapseDetailsAfterPrinting();\n    this._resetUIState();\n    this._document.addEventListener('keydown', this.printShortCutDetect);\n    this._document.addEventListener('copy', this.onCopy);\n  }\n\n  /**\n   * Fires a custom DOM event on target.\n   * @param {string} name Name of the event.\n   * @param {!Node=} target DOM node to fire the event on.\n   * @param {*=} detail Custom data to include.\n   */\n  _fireEventOn(name, target = this._document, detail) {\n    const event = new CustomEvent(name, detail ? {detail} : null);\n    this._document.dispatchEvent(event);\n  }\n\n  _setupMediaQueryListeners() {\n    const mediaQuery = self.matchMedia('(max-width: 600px)');\n    mediaQuery.addListener(this.onMediaQueryChange);\n    // Ensure the handler is called on init\n    this.onMediaQueryChange(mediaQuery);\n  }\n\n  /**\n   * Handle media query change events.\n   * @param {!MediaQueryList} mql\n   */\n  onMediaQueryChange(mql) {\n    const root = this._dom.find('.lh-root', this._document);\n    root.classList.toggle('lh-narrow', mql.matches);\n  }\n\n  _setupExportButton() {\n    this.exportButton = this._dom.find('.lh-export__button', this._document);\n    this.exportButton.addEventListener('click', this.onExportButtonClick);\n\n    const dropdown = this._dom.find('.lh-export__dropdown', this._document);\n    dropdown.addEventListener('click', this.onExport);\n  }\n\n  /**\n   * Handle copy events.\n   * @param {!Event} e\n   */\n  onCopy(e) {\n    // Only handle copy button presses (e.g. ignore the user copying page text).\n    if (this._copyAttempt) {\n      // We want to write our own data to the clipboard, not the user's text selection.\n      e.preventDefault();\n      e.clipboardData.setData('text/plain', JSON.stringify(this.json, null, 2));\n\n      this._fireEventOn('lh-log', this._document, {\n        cmd: 'log', msg: 'Report JSON copied to clipboard'\n      });\n    }\n\n    this._copyAttempt = false;\n  }\n\n  /**\n   * Copies the report JSON to the clipboard (if supported by the browser).\n   * @suppress {reportUnknownTypes}\n   */\n  onCopyButtonClick() {\n    this._fireEventOn('lh-analytics', this._document, {\n      cmd: 'send',\n      fields: {hitType: 'event', eventCategory: 'report', eventAction: 'copy'}\n    });\n\n    try {\n      if (this._document.queryCommandSupported('copy')) {\n        this._copyAttempt = true;\n\n        // Note: In Safari 10.0.1, execCommand('copy') returns true if there's\n        // a valid text selection on the page. See http://caniuse.com/#feat=clipboard.\n        if (!this._document.execCommand('copy')) {\n          this._copyAttempt = false; // Prevent event handler from seeing this as a copy attempt.\n\n          this._fireEventOn('lh-log', this._document, {\n            cmd: 'warn', msg: 'Your browser does not support copy to clipboard.'\n          });\n        }\n      }\n    } catch (/** @type {!Error} */ e) {\n      this._copyAttempt = false;\n      this._fireEventOn('lh-log', this._document, {cmd: 'log', msg: e.message});\n    }\n  }\n\n  closeExportDropdown() {\n    this.exportButton.classList.remove('active');\n  }\n\n  /**\n   * Click handler for export button.\n   * @param {!Event} e\n   */\n  onExportButtonClick(e) {\n    e.preventDefault();\n    const el = /** @type {!Element} */ (e.target);\n    el.classList.toggle('active');\n    this._document.addEventListener('keydown', this.onKeyDown);\n  }\n\n  /**\n   * Resets the state of page before capturing the page for export.\n   * When the user opens the exported HTML page, certain UI elements should\n   * be in their closed state (not opened) and the templates should be unstamped.\n   */\n  _resetUIState() {\n    this.closeExportDropdown();\n    this._dom.resetTemplates();\n  }\n\n  /**\n   * Handler for \"export as\" button.\n   * @param {!Event} e\n   */\n  onExport(e) {\n    e.preventDefault();\n\n    const el = /** @type {!Element} */ (e.target);\n\n    if (!el.hasAttribute('data-action')) {\n      return;\n    }\n\n    switch (el.getAttribute('data-action')) {\n      case 'copy':\n        this.onCopyButtonClick();\n        break;\n      case 'print':\n        this.expandAllDetails();\n        self.print();\n        break;\n      case 'save-json': {\n        const jsonStr = JSON.stringify(this.json, null, 2);\n        this._saveFile(new Blob([jsonStr], {type: 'application/json'}));\n        break;\n      }\n      case 'save-html': {\n        this._resetUIState();\n\n        const htmlStr = this._document.documentElement.outerHTML;\n        try {\n          this._saveFile(new Blob([htmlStr], {type: 'text/html'}));\n        } catch (/** @type {!Error} */ e) {\n          this._fireEventOn('lh-log', this._document, {\n            cmd: 'error', msg: 'Could not export as HTML. ' + e.message\n          });\n        }\n        break;\n      }\n    }\n\n    this.closeExportDropdown();\n    this._document.removeEventListener('keydown', this.onKeyDown);\n  }\n\n  /**\n   * Keydown handler for the document.\n   * @param {!Event} e\n   */\n  onKeyDown(e) {\n    if (e.keyCode === 27) { // ESC\n      this.closeExportDropdown();\n    }\n  }\n\n  /**\n   * Expands audit details when user prints via keyboard shortcut.\n   * @param {!Event} e\n   */\n  printShortCutDetect(e) {\n    if ((e.ctrlKey || e.metaKey) && e.keyCode === 80) { // Ctrl+P\n      this.expandAllDetails();\n    }\n  }\n\n  /**\n   * Expands all audit `<details>`.\n   * Ideally, a print stylesheet could take care of this, but CSS has no way to\n   * open a `<details>` element.\n   */\n  expandAllDetails() {\n    const details = this._dom.findAll('.lh-categories details', this._document);\n    details.map(detail => detail.open = true);\n  }\n\n  /**\n   * Collapses all audit `<details>`.\n   * open a `<details>` element.\n   */\n  collapseAllDetails() {\n    const details = this._dom.findAll('.lh-categories details', this._document);\n    details.map(detail => detail.open = false);\n  }\n\n  /**\n   * Sets up listeners to collapse audit `<details>` when the user closes the\n   * print dialog, all `<details>` are collapsed.\n   */\n  _setUpCollapseDetailsAfterPrinting() {\n    // FF and IE implement these old events.\n    if ('onbeforeprint' in self) {\n      self.addEventListener('afterprint', this.collapseAllDetails);\n    } else {\n      // Note: FF implements both window.onbeforeprint and media listeners. However,\n      // it doesn't matchMedia doesn't fire when matching 'print'.\n      self.matchMedia('print').addListener(mql => {\n        if (mql.matches) {\n          this.expandAllDetails();\n        } else {\n          this.collapseAllDetails();\n        }\n      });\n    }\n  }\n  /**\n   * Downloads a file (blob) using a[download].\n   * @param {!Blob|!File} blob The file to save.\n   */\n  _saveFile(blob) {\n    const filename = getFilenamePrefix({\n      url: this.json.url,\n      generatedTime: this.json.generatedTime\n    });\n\n    const ext = blob.type.match('json') ? '.json' : '.html';\n    const href = URL.createObjectURL(blob);\n\n    const a = /** @type {!HTMLAnchorElement} */ (this._dom.createElement('a'));\n    a.download = `${filename}${ext}`;\n    a.href = href;\n    this._document.body.appendChild(a); // Firefox requires anchor to be in the DOM.\n    a.click();\n\n    // cleanup.\n    this._document.body.removeChild(a);\n    setTimeout(_ => URL.revokeObjectURL(href), 500);\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = ReportUIFeatures;\n} else {\n  self.ReportUIFeatures = ReportUIFeatures;\n}\n","/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n'use strict';\n\n/* globals self, Util */\n\nclass CategoryRenderer {\n  /**\n   * @param {!DOM} dom\n   * @param {!DetailsRenderer} detailsRenderer\n   */\n  constructor(dom, detailsRenderer) {\n    /** @private {!DOM} */\n    this._dom = dom;\n    /** @private {!DetailsRenderer} */\n    this._detailsRenderer = detailsRenderer;\n    /** @private {!Document|!Element} */\n    this._templateContext = this._dom.document();\n\n    this._detailsRenderer.setTemplateContext(this._templateContext);\n  }\n\n  /**\n   * @param {!ReportRenderer.AuditJSON} audit\n   * @return {!Element}\n   */\n  _renderAuditScore(audit) {\n    const tmpl = this._dom.cloneTemplate('#tmpl-lh-audit-score', this._templateContext);\n\n    const scoringMode = audit.result.scoringMode;\n    const description = audit.result.helpText;\n    let title = audit.result.description;\n\n    if (audit.result.displayValue) {\n      title += `:  ${audit.result.displayValue}`;\n    }\n    if (audit.result.optimalValue) {\n      title += ` (target: ${audit.result.optimalValue})`;\n    }\n\n    if (audit.result.debugString) {\n      const debugStrEl = tmpl.appendChild(this._dom.createElement('div', 'lh-debug'));\n      debugStrEl.textContent = audit.result.debugString;\n    }\n\n    // Append audit details to header section so the entire audit is within a <details>.\n    const header = /** @type {!HTMLDetailsElement} */ (this._dom.find('.lh-score__header', tmpl));\n    if (audit.result.details) {\n      header.appendChild(this._detailsRenderer.render(audit.result.details));\n    }\n\n    const scoreEl = this._dom.find('.lh-score', tmpl);\n    if (audit.result.informative) {\n      scoreEl.classList.add('lh-score--informative');\n    }\n    if (audit.result.manual) {\n      scoreEl.classList.add('lh-score--manual');\n    }\n\n    return this._populateScore(tmpl, audit.score, scoringMode, title, description);\n  }\n\n  /**\n   * @param {!DocumentFragment|!Element} element DOM node to populate with values.\n   * @param {number} score\n   * @param {string} scoringMode\n   * @param {string} title\n   * @param {string} description\n   * @return {!Element}\n   */\n  _populateScore(element, score, scoringMode, title, description) {\n    // Fill in the blanks.\n    const valueEl = this._dom.find('.lh-score__value', element);\n    valueEl.textContent = Util.formatNumber(score);\n    valueEl.classList.add(`lh-score__value--${Util.calculateRating(score)}`,\n        `lh-score__value--${scoringMode}`);\n\n    this._dom.find('.lh-score__title', element).appendChild(\n        this._dom.convertMarkdownCodeSnippets(title));\n    this._dom.find('.lh-score__description', element)\n        .appendChild(this._dom.convertMarkdownLinkSnippets(description));\n\n    return /** @type {!Element} **/ (element);\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @return {!Element}\n   */\n  _renderCategoryScore(category) {\n    const tmpl = this._dom.cloneTemplate('#tmpl-lh-category-score', this._templateContext);\n    const score = Math.round(category.score);\n\n    const gaugeContainerEl = this._dom.find('.lh-score__gauge', tmpl);\n    const gaugeEl = this.renderScoreGauge(category);\n    gaugeContainerEl.appendChild(gaugeEl);\n\n    return this._populateScore(tmpl, score, 'numeric', category.name, category.description);\n  }\n\n  /**\n   * @param {!ReportRenderer.AuditJSON} audit\n   * @return {!Element}\n   */\n  _renderAudit(audit) {\n    const element = this._dom.createElement('div', 'lh-audit');\n    element.appendChild(this._renderAuditScore(audit));\n    return element;\n  }\n\n  /**\n   * @param {!ReportRenderer.AuditJSON} audit\n   * @param {number} scale\n   * @return {!Element}\n   */\n  _renderTimelineMetricAudit(audit, scale) {\n    const element = this._dom.createElement('div',\n        `lh-timeline-metric lh-timeline-metric--${Util.calculateRating(audit.score)}`);\n\n    const sparklineContainerEl = this._dom.createChildOf(element, 'div',\n        'lh-timeline-metric__sparkline');\n    const titleEl = this._dom.createChildOf(element, 'div', 'lh-timeline-metric__title');\n    const titleNameEl = this._dom.createChildOf(titleEl, 'span', 'lh-timeline-metric__name');\n    const titleValueEl = this._dom.createChildOf(titleEl, 'span', 'lh-timeline-metric__value');\n    titleNameEl.textContent = audit.result.description;\n    titleValueEl.textContent = audit.result.displayValue;\n\n    if (typeof audit.result.rawValue !== 'number') {\n      const debugStrEl = this._dom.createChildOf(element, 'div', 'lh-debug');\n      debugStrEl.textContent = audit.result.debugString || 'Report error: no metric information';\n      return element;\n    }\n\n    const sparklineEl = this._dom.createChildOf(sparklineContainerEl, 'div',\n        'lh-sparkline lh-sparkline--thin');\n    const sparklineBarEl = this._dom.createChildOf(sparklineEl, 'div', 'lh-sparkline__bar');\n    sparklineBarEl.style.width = `${audit.result.rawValue / scale * 100}%`;\n\n    const descriptionEl = this._dom.createChildOf(element, 'div',\n        'lh-timeline-metric__description');\n    descriptionEl.appendChild(this._dom.convertMarkdownLinkSnippets(audit.result.helpText));\n\n    return element;\n  }\n\n  /**\n   * @param {!ReportRenderer.AuditJSON} audit\n   * @param {number} scale\n   * @return {!Element}\n   */\n  _renderPerfHintAudit(audit, scale) {\n    const extendedInfo = /** @type {!CategoryRenderer.PerfHintExtendedInfo}\n        */ (audit.result.extendedInfo);\n    const tooltipAttrs = {title: audit.result.displayValue};\n\n    const element = this._dom.createElement('details', [\n      'lh-perf-hint',\n      `lh-perf-hint--${Util.calculateRating(audit.score)}`,\n      'lh-expandable-details',\n    ].join(' '));\n\n    const summary = this._dom.createChildOf(element, 'summary', 'lh-perf-hint__summary ' +\n        'lh-expandable-details__summary');\n    const titleEl = this._dom.createChildOf(summary, 'div', 'lh-perf-hint__title');\n    titleEl.textContent = audit.result.description;\n\n    if (!extendedInfo || typeof audit.result.rawValue !== 'number') {\n      const debugStrEl = this._dom.createChildOf(summary, 'div', 'lh-debug');\n      debugStrEl.textContent = audit.result.debugString || 'Report error: no extended information';\n      return element;\n    }\n\n    const sparklineContainerEl = this._dom.createChildOf(summary, 'div', 'lh-perf-hint__sparkline',\n        tooltipAttrs);\n    const sparklineEl = this._dom.createChildOf(sparklineContainerEl, 'div', 'lh-sparkline');\n    const sparklineBarEl = this._dom.createChildOf(sparklineEl, 'div', 'lh-sparkline__bar');\n    sparklineBarEl.style.width = audit.result.rawValue / scale * 100 + '%';\n\n    const statsEl = this._dom.createChildOf(summary, 'div', 'lh-perf-hint__stats', tooltipAttrs);\n    const statsMsEl = this._dom.createChildOf(statsEl, 'div', 'lh-perf-hint__primary-stat');\n    statsMsEl.textContent = Util.formatMilliseconds(audit.result.rawValue);\n\n    this._dom.createChildOf(summary, 'div', 'lh-toggle-arrow', {title: 'See resources'});\n\n    if (extendedInfo.value.wastedKb) {\n      const statsKbEl = this._dom.createChildOf(statsEl, 'div', 'lh-perf-hint__secondary-stat');\n      statsKbEl.textContent = extendedInfo.value.wastedKb.toLocaleString() + ' KB';\n    }\n\n    const descriptionEl = this._dom.createChildOf(element, 'div', 'lh-perf-hint__description');\n    descriptionEl.appendChild(this._dom.convertMarkdownLinkSnippets(audit.result.helpText));\n\n    if (audit.result.details) {\n      element.appendChild(this._detailsRenderer.render(audit.result.details));\n    }\n\n    return element;\n  }\n\n  /**\n   * Renders the group container for a group of audits. Individual audit elements can be added\n   * directly to the returned element.\n   * @param {!ReportRenderer.GroupJSON} group\n   * @return {!HTMLDetailsElement}\n   */\n  _renderAuditGroup(group) {\n    const auditGroupElem = /** @type {!HTMLDetailsElement} */ (this._dom.createElement('details',\n          'lh-audit-group lh-expandable-details'));\n    const auditGroupHeader = this._dom.createElement('div',\n          'lh-audit-group__header lh-expandable-details__header');\n    auditGroupHeader.textContent = group.title;\n\n    const auditGroupDescription = this._dom.createElement('div', 'lh-audit-group__description');\n    auditGroupDescription.appendChild(this._dom.convertMarkdownLinkSnippets(group.description));\n\n    const auditGroupSummary = this._dom.createElement('summary',\n          'lh-audit-group__summary lh-expandable-details__summary');\n    const auditGroupArrow = this._dom.createElement('div', 'lh-toggle-arrow', {\n      title: 'See audits',\n    });\n    auditGroupSummary.appendChild(auditGroupHeader);\n    auditGroupSummary.appendChild(auditGroupArrow);\n\n    auditGroupElem.appendChild(auditGroupSummary);\n    auditGroupElem.appendChild(auditGroupDescription);\n    return auditGroupElem;\n  }\n\n  /**\n   * @param {!Array<!Element>} elements\n   * @return {!Element}\n   */\n  _renderPassedAuditsSection(elements) {\n    const passedElem = this._dom.createElement('details', 'lh-passed-audits');\n    const passedSummary = this._dom.createElement('summary', 'lh-passed-audits-summary');\n    passedElem.appendChild(passedSummary);\n    passedSummary.textContent = `View ${elements.length} passed items`;\n    elements.forEach(elem => passedElem.appendChild(elem));\n    return passedElem;\n  }\n\n  /**\n   * @param {!Array<!ReportRenderer.AuditJSON>} manualAudits\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groupDefinitions\n   * @param {!Element} element Parent container to add the manual audits to.\n   */\n  _renderManualAudits(manualAudits, groupDefinitions, element) {\n    const auditsGroupedByGroup = /** @type {!Object<string,\n        !Array<!ReportRenderer.AuditJSON>>} */ ({});\n    manualAudits.forEach(audit => {\n      const group = auditsGroupedByGroup[audit.group] || [];\n      group.push(audit);\n      auditsGroupedByGroup[audit.group] = group;\n    });\n\n    Object.keys(auditsGroupedByGroup).forEach(groupId => {\n      const group = groupDefinitions[groupId];\n      const auditGroupElem = this._renderAuditGroup(group);\n      auditGroupElem.classList.add('lh-audit-group--manual');\n\n      auditsGroupedByGroup[groupId].forEach(audit => {\n        auditGroupElem.appendChild(this._renderAudit(audit));\n      });\n\n      element.appendChild(auditGroupElem);\n    });\n  }\n\n  /**\n   * @param {!Document|!Element} context\n   */\n  setTemplateContext(context) {\n    this._templateContext = context;\n    this._detailsRenderer.setTemplateContext(context);\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @return {!DocumentFragment}\n   */\n  renderScoreGauge(category) {\n    const tmpl = this._dom.cloneTemplate('#tmpl-lh-gauge', this._templateContext);\n    this._dom.find('.lh-gauge__wrapper', tmpl).href = `#${category.id}`;\n    this._dom.find('.lh-gauge__label', tmpl).textContent = category.name;\n\n    const score = Math.round(category.score);\n    const fillRotation = Math.floor((score / 100) * 180);\n\n    const gauge = this._dom.find('.lh-gauge', tmpl);\n    gauge.setAttribute('data-progress', score); // .dataset not supported in jsdom.\n    gauge.classList.add(`lh-gauge--${Util.calculateRating(score)}`);\n\n    this._dom.findAll('.lh-gauge__fill', gauge).forEach(el => {\n      el.style.transform = `rotate(${fillRotation}deg)`;\n    });\n\n    this._dom.find('.lh-gauge__mask--full', gauge).style.transform =\n        `rotate(${fillRotation}deg)`;\n    this._dom.find('.lh-gauge__fill--fix', gauge).style.transform =\n        `rotate(${fillRotation * 2}deg)`;\n    this._dom.find('.lh-gauge__percentage', gauge).textContent = score;\n\n    return tmpl;\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groups\n   * @return {!Element}\n   */\n  render(category, groups) {\n    switch (category.id) {\n      case 'performance':\n        return this._renderPerformanceCategory(category, groups);\n      case 'accessibility':\n        return this._renderAccessibilityCategory(category, groups);\n      default:\n        return this._renderDefaultCategory(category, groups);\n    }\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groupDefinitions\n   * @return {!Element}\n   */\n  _renderDefaultCategory(category, groupDefinitions) {\n    const element = this._dom.createElement('div', 'lh-category');\n    element.id = category.id;\n    element.appendChild(this._renderCategoryScore(category));\n\n    const manualAudits = category.audits.filter(audit => audit.result.manual);\n    const nonManualAudits = category.audits.filter(audit => !manualAudits.includes(audit));\n    const passedAudits = nonManualAudits.filter(audit => audit.score === 100);\n    const nonPassedAudits = nonManualAudits.filter(audit => !passedAudits.includes(audit));\n\n    for (const audit of nonPassedAudits) {\n      element.appendChild(this._renderAudit(audit));\n    }\n\n    // Create a passed section if there are passing audits.\n    if (passedAudits.length) {\n      const passedElements = passedAudits.map(audit => this._renderAudit(audit));\n      const passedElem = this._renderPassedAuditsSection(passedElements);\n      element.appendChild(passedElem);\n    }\n\n    // Render manual audits after passing.\n    this._renderManualAudits(manualAudits, groupDefinitions, element);\n\n    return element;\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groups\n   * @return {!Element}\n   */\n  _renderPerformanceCategory(category, groups) {\n    const element = this._dom.createElement('div', 'lh-category');\n    element.id = category.id;\n    element.appendChild(this._renderCategoryScore(category));\n\n    const metricAudits = category.audits.filter(audit => audit.group === 'perf-metric');\n    const metricAuditsEl = this._renderAuditGroup(groups['perf-metric']);\n    const timelineContainerEl = this._dom.createChildOf(metricAuditsEl, 'div',\n        'lh-timeline-container');\n    const timelineEl = this._dom.createChildOf(timelineContainerEl, 'div', 'lh-timeline');\n\n    let perfTimelineScale = 0;\n    metricAudits.forEach(audit => {\n      if (typeof audit.result.rawValue === 'number' && audit.result.rawValue) {\n        perfTimelineScale = Math.max(perfTimelineScale, audit.result.rawValue);\n      }\n    });\n\n    const thumbnailAudit = category.audits.find(audit => audit.id === 'screenshot-thumbnails');\n    const thumbnailResult = thumbnailAudit && thumbnailAudit.result;\n    if (thumbnailResult && thumbnailResult.details) {\n      const thumbnailDetails = /** @type {!DetailsRenderer.FilmstripDetails} */\n          (thumbnailResult.details);\n      perfTimelineScale = Math.max(perfTimelineScale, thumbnailDetails.scale);\n      const filmstripEl = this._detailsRenderer.render(thumbnailDetails);\n      timelineEl.appendChild(filmstripEl);\n    }\n\n    metricAudits.forEach(item => {\n      if (item.id === 'speed-index-metric' || item.id === 'estimated-input-latency') {\n        return metricAuditsEl.appendChild(this._renderAudit(item));\n      }\n\n      timelineEl.appendChild(this._renderTimelineMetricAudit(item, perfTimelineScale));\n    });\n\n    metricAuditsEl.open = true;\n    element.appendChild(metricAuditsEl);\n\n    const hintAudits = category.audits\n        .filter(audit => audit.group === 'perf-hint' && audit.score < 100)\n        .sort((auditA, auditB) => auditB.result.rawValue - auditA.result.rawValue);\n    if (hintAudits.length) {\n      const maxWaste = Math.max(...hintAudits.map(audit => audit.result.rawValue));\n      const scale = Math.ceil(maxWaste / 1000) * 1000;\n      const hintAuditsEl = this._renderAuditGroup(groups['perf-hint']);\n      hintAudits.forEach(item => hintAuditsEl.appendChild(this._renderPerfHintAudit(item, scale)));\n      hintAuditsEl.open = true;\n      element.appendChild(hintAuditsEl);\n    }\n\n    const infoAudits = category.audits\n        .filter(audit => audit.group === 'perf-info' && audit.score < 100);\n    if (infoAudits.length) {\n      const infoAuditsEl = this._renderAuditGroup(groups['perf-info']);\n      infoAudits.forEach(item => infoAuditsEl.appendChild(this._renderAudit(item)));\n      infoAuditsEl.open = true;\n      element.appendChild(infoAuditsEl);\n    }\n\n    const passedElements = category.audits\n        .filter(audit => (audit.group === 'perf-hint' || audit.group === 'perf-info') &&\n            audit.score === 100)\n        .map(audit => this._renderAudit(audit));\n\n    if (!passedElements.length) return element;\n\n    const passedElem = this._renderPassedAuditsSection(passedElements);\n    element.appendChild(passedElem);\n    return element;\n  }\n\n  /**\n   * @param {!ReportRenderer.CategoryJSON} category\n   * @param {!Object<string, !ReportRenderer.GroupJSON>} groupDefinitions\n   * @return {!Element}\n   */\n  _renderAccessibilityCategory(category, groupDefinitions) {\n    const element = this._dom.createElement('div', 'lh-category');\n    element.id = category.id;\n    element.appendChild(this._renderCategoryScore(category));\n\n    const auditsGroupedByGroup = /** @type {!Object<string,\n        {passed: !Array<!ReportRenderer.AuditJSON>,\n        failed: !Array<!ReportRenderer.AuditJSON>}>} */ ({});\n    category.audits.forEach(audit => {\n      const groupId = audit.group;\n      const groups = auditsGroupedByGroup[groupId] || {passed: [], failed: []};\n\n      if (audit.score === 100) {\n        groups.passed.push(audit);\n      } else {\n        groups.failed.push(audit);\n      }\n\n      auditsGroupedByGroup[groupId] = groups;\n    });\n\n    const passedElements = /** @type {!Array<!Element>} */ ([]);\n    Object.keys(auditsGroupedByGroup).forEach(groupId => {\n      const group = groupDefinitions[groupId];\n      const groups = auditsGroupedByGroup[groupId];\n      if (groups.failed.length) {\n        const auditGroupElem = this._renderAuditGroup(group);\n        groups.failed.forEach(item => auditGroupElem.appendChild(this._renderAudit(item)));\n        auditGroupElem.open = true;\n        element.appendChild(auditGroupElem);\n      }\n\n      if (groups.passed.length) {\n        const auditGroupElem = this._renderAuditGroup(group);\n        groups.passed.forEach(item => auditGroupElem.appendChild(this._renderAudit(item)));\n        passedElements.push(auditGroupElem);\n      }\n    });\n\n    // don't create a passed section if there are no passed\n    if (!passedElements.length) return element;\n\n    const passedElem = this._renderPassedAuditsSection(passedElements);\n    element.appendChild(passedElem);\n    return element;\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = CategoryRenderer;\n} else {\n  self.CategoryRenderer = CategoryRenderer;\n}\n\n\n/**\n * @typedef {{\n *     value: {\n *       wastedMs: (number|undefined),\n *       wastedKb: (number|undefined),\n *     }\n * }}\n */\nCategoryRenderer.PerfHintExtendedInfo; // eslint-disable-line no-unused-expressions\n","/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n'use strict';\n\n/**\n * @fileoverview The entry point for rendering the Lighthouse report based on the JSON output.\n *    This file is injected into the report HTML along with the JSON report.\n *\n * Dummy text for ensuring report robustness: </script> pre$`post %%LIGHTHOUSE_JSON%%\n */\n\n/* globals self, Util */\n\nclass ReportRenderer {\n  /**\n   * @param {!DOM} dom\n   * @param {!CategoryRenderer} categoryRenderer\n   * @param {?ReportUIFeatures=} uiFeatures\n   */\n  constructor(dom, categoryRenderer, uiFeatures = null) {\n    /** @private {!DOM} */\n    this._dom = dom;\n    /** @private {!CategoryRenderer} */\n    this._categoryRenderer = categoryRenderer;\n    /** @private {!Document|!Element} */\n    this._templateContext = this._dom.document();\n    /** @private {ReportUIFeatures} */\n    this._uiFeatures = uiFeatures;\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @param {!Element} container Parent element to render the report into.\n   */\n  renderReport(report, container) {\n    container.textContent = ''; // Remove previous report.\n    const element = container.appendChild(this._renderReport(report));\n\n    // Hook in JS features and page-level event listeners after the report\n    // is in the document.\n    if (this._uiFeatures) {\n      this._uiFeatures.initFeatures(report);\n    }\n\n    return /** @type {!Element} **/ (element);\n  }\n\n  /**\n   * Define a custom element for <templates> to be extracted from. For example:\n   *     this.setTemplateContext(new DOMParser().parseFromString(htmlStr, 'text/html'))\n   * @param {!Document|!Element} context\n   */\n  setTemplateContext(context) {\n    this._templateContext = context;\n    this._categoryRenderer.setTemplateContext(context);\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @return {!DocumentFragment}\n   */\n  _renderReportHeader(report) {\n    const header = this._dom.cloneTemplate('#tmpl-lh-heading', this._templateContext);\n    this._dom.find('.lh-config__timestamp', header).textContent =\n        Util.formatDateTime(report.generatedTime);\n    const url = this._dom.find('.lh-metadata__url', header);\n    url.href = report.url;\n    url.textContent = report.url;\n\n    this._dom.find('.lh-env__item__ua', header).textContent = report.userAgent;\n\n    const env = this._dom.find('.lh-env__items', header);\n    report.runtimeConfig.environment.forEach(runtime => {\n      const item = this._dom.cloneTemplate('#tmpl-lh-env__items', env);\n      this._dom.find('.lh-env__name', item).textContent = runtime.name;\n      this._dom.find('.lh-env__description', item).textContent = runtime.description;\n      this._dom.find('.lh-env__enabled', item).textContent =\n          runtime.enabled ? 'Enabled' : 'Disabled';\n      env.appendChild(item);\n    });\n\n    return header;\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @return {!DocumentFragment}\n   */\n  _renderReportFooter(report) {\n    const footer = this._dom.cloneTemplate('#tmpl-lh-footer', this._templateContext);\n    this._dom.find('.lh-footer__version', footer).textContent = report.lighthouseVersion;\n    this._dom.find('.lh-footer__timestamp', footer).textContent =\n        Util.formatDateTime(report.generatedTime);\n    return footer;\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @return {!DocumentFragment}\n   */\n  _renderReportNav(report) {\n    const leftNav = this._dom.cloneTemplate('#tmpl-lh-leftnav', this._templateContext);\n\n    this._dom.find('.leftnav__header__version', leftNav).textContent =\n        `Version: ${report.lighthouseVersion}`;\n\n    const nav = this._dom.find('.lh-leftnav', leftNav);\n    for (const category of report.reportCategories) {\n      const itemsTmpl = this._dom.cloneTemplate('#tmpl-lh-leftnav__items', leftNav);\n\n      const navItem = this._dom.find('.lh-leftnav__item', itemsTmpl);\n      navItem.href = `#${category.id}`;\n\n      this._dom.find('.leftnav-item__category', navItem).textContent = category.name;\n      const score = this._dom.find('.leftnav-item__score', navItem);\n      score.classList.add(`lh-score__value--${Util.calculateRating(category.score)}`);\n      score.textContent = Math.round(Util.formatNumber(category.score));\n      nav.appendChild(navItem);\n    }\n    return leftNav;\n  }\n\n  /**\n   * @param {!ReportRenderer.ReportJSON} report\n   * @return {!Element}\n   */\n  _renderReport(report) {\n    const container = this._dom.createElement('div', 'lh-container');\n\n    container.appendChild(this._renderReportHeader(report)); // sticky header goes at the top.\n    container.appendChild(this._renderReportNav(report));\n\n    const reportSection = container.appendChild(this._dom.createElement('div', 'lh-report'));\n\n    const scoreHeader = reportSection.appendChild(\n        this._dom.createElement('div', 'lh-scores-header'));\n\n    const categories = reportSection.appendChild(this._dom.createElement('div', 'lh-categories'));\n    for (const category of report.reportCategories) {\n      scoreHeader.appendChild(this._categoryRenderer.renderScoreGauge(category));\n      categories.appendChild(this._categoryRenderer.render(category, report.reportGroups));\n    }\n\n    reportSection.appendChild(this._renderReportFooter(report));\n\n    return container;\n  }\n}\n\nif (typeof module !== 'undefined' && module.exports) {\n  module.exports = ReportRenderer;\n} else {\n  self.ReportRenderer = ReportRenderer;\n}\n\n/**\n * @typedef {{\n *     id: string,\n *     weight: number,\n *     score: number,\n *     group: string,\n *     result: {\n *       rawValue: (number|undefined),\n *       description: string,\n *       informative: boolean,\n *       manual: boolean,\n *       debugString: string,\n *       displayValue: string,\n *       helpText: string,\n *       score: (number|boolean),\n *       scoringMode: string,\n *       optimalValue: number,\n *       extendedInfo: Object,\n *       details: (!DetailsRenderer.DetailsJSON|undefined)\n *     }\n * }}\n */\nReportRenderer.AuditJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     name: string,\n *     id: string,\n *     weight: number,\n *     score: number,\n *     description: string,\n *     audits: !Array<!ReportRenderer.AuditJSON>\n * }}\n */\nReportRenderer.CategoryJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     title: string,\n *     description: string,\n * }}\n */\nReportRenderer.GroupJSON; // eslint-disable-line no-unused-expressions\n\n/**\n * @typedef {{\n *     lighthouseVersion: string,\n *     userAgent: string,\n *     generatedTime: string,\n *     timing: {total: number},\n *     initialUrl: string,\n *     url: string,\n *     artifacts: {traces: !Object},\n *     reportCategories: !Array<!ReportRenderer.CategoryJSON>,\n *     reportGroups: !Object<string, !ReportRenderer.GroupJSON>,\n *     runtimeConfig: {\n *       blockedUrlPatterns: !Array<string>,\n *       environment: !Array<{description: string, enabled: boolean, name: string}>\n *     }\n * }}\n */\nReportRenderer.ReportJSON; // eslint-disable-line no-unused-expressions\n"].join(';\n');const REPORT_CSS="/**\n * Copyright 2017 Google Inc. All rights reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n.lh-vars {\n  --text-font-family: '.SFNSDisplay-Regular', 'Helvetica Neue', 'Lucida Grande', sans-serif;\n  --monospace-font-family: 'Menlo', 'dejavu sans mono', 'Consolas', 'Lucida Console', monospace;\n  --body-font-size: 12px;\n  --header-font-size: 14px;\n  --body-line-height: 1.5;\n  --default-padding: 12px;\n  --section-padding: 16px;\n\n  --secondary-text-color: #565656;\n  /*--accent-color: #3879d9;*/\n  --fail-color: #df332f;\n  --pass-color: #2b882f;\n  --informative-color: #0c50c7;\n  --manual-color: #757575;\n  --average-color: #ef6c00; /* md orange 800 */\n  --warning-color: #ffab00; /* md amber a700 */\n\n  --report-border-color: #ccc;\n  --report-secondary-border-color: #ebebeb;\n  --report-width: 850px;\n  --report-menu-width: 280px;\n  --report-content-width: calc(var(--report-width) + var(--report-menu-width));\n\n  --lh-score-highlight-bg: #fafafa;\n  --lh-score-icon-background-size: 24px;\n  --lh-score-margin: calc(var(--default-padding) / 2);\n\n  --lh-table-header-bg: #ccc;\n  --lh-table-higlight-bg: #fafafa;\n\n  --lh-sparkline-height: 8px;\n  --lh-sparkline-thin-height: 3px;\n  --lh-filmstrip-thumbnail-width: 60px;\n  --lh-audit-score-width: 35px;\n  --lh-category-score-width: 60px;\n}\n\n.lh-root * {\n  box-sizing: border-box;\n}\n\n.lh-root {\n  font-family: var(--text-font-family);\n  font-size: var(--body-font-size);\n  margin: 0;\n  line-height: var(--body-line-height);\n  background: #f5f5f5;\n  scroll-behavior: smooth;\n}\n\n.lh-root [hidden] {\n  display: none !important;\n}\n\na {\n  color: #0c50c7;\n}\n\nsummary {\n  cursor: pointer;\n}\n\n.lh-details {\n  font-size: var(--body-font-size);\n  margin-top: var(--default-padding);\n}\n\n.lh-details[open] summary {\n  margin-bottom: var(--default-padding);\n}\n\n.lh-details.flex .lh-code {\n  max-width: 70%;\n}\n\n/* Report header */\n\n.report-icon {\n  opacity: 0.7;\n}\n.report-icon:hover {\n  opacity: 1;\n}\n.report-icon[disabled] {\n  opacity: 0.3;\n  pointer-events: none;\n}\n\n.report-icon--share {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path fill=\"none\" d=\"M0 0h24v24H0z\"/><path d=\"M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z\"/></svg>');\n}\n.report-icon--print {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path d=\"M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z\"/><path fill=\"none\" d=\"M0 0h24v24H0z\"/></svg>');\n}\n.report-icon--copy {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z\"/></svg>');\n}\n.report-icon--open {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z\"/></svg>');\n}\n.report-icon--download {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z\"/><path d=\"M0 0h24v24H0z\" fill=\"none\"/></svg>');\n}\n\n/* List */\n.lh-list {\n  font-size: smaller;\n  margin-top: var(--default-padding);\n}\n\n.lh-list__items {\n  padding-left: var(--default-padding);\n}\n\n.lh-list__item {\n  margin-bottom: 2px;\n}\n\n/* Node */\n.lh-node {\n  display: block;\n  font-family: var(--monospace-font-family);\n  word-break: break-word;\n  color: hsl(174, 100%, 27%);\n}\nspan.lh-node:hover {\n    background: hsl(0, 0%, 98%);\n    border-radius: 2px;\n}\n\n/* Card */\n.lh-scorecards {\n  display: flex;\n  flex-wrap: wrap;\n}\n.lh-scorecard {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex: 0 0 180px;\n  flex-direction: column;\n  padding: var(--default-padding);\n  padding-top: calc(32px + var(--default-padding));\n  border-radius: 3px;\n  margin-right: var(--default-padding);\n  position: relative;\n  line-height: inherit;\n  border: 1px solid #ebebeb;\n}\n.lh-scorecard__title {\n  background-color: #eee;\n  position: absolute;\n  top: 0;\n  right: 0;\n  left: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: calc(var(--default-padding) / 2);\n}\n.lh-scorecard__value {\n  font-size: 28px;\n}\n.lh-scorecard__target {\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n/* Score */\n\n.lh-score {\n  display: flex;\n  align-items: flex-start;\n}\n\n.lh-score__value {\n  flex: none;\n  margin-right: var(--lh-score-margin);\n  width: var(--lh-audit-score-width);\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  border-radius: 2px;\n  position: relative;\n  font-weight: bold;\n  top: 1px;\n}\n\n.lh-score__value::after {\n  content: '';\n  position: absolute;\n  left: 0;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  border-radius: inherit;\n}\n\n.lh-score--informative .lh-score__value {\n  color: var(--informative-color);\n  border-radius: 50%;\n  top: 3px;\n}\n\n.lh-score--informative .lh-score__value::after {\n  background: url('data:image/svg+xml;utf8,<svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>info</title><path d=\"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z\" fill=\"#0c50c7\"/></svg>') no-repeat 50% 50%;\n  background-size: var(--lh-score-icon-background-size);\n}\n\n.lh-score--manual .lh-score__value::after {\n  background: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>manual</title><path d=\"M2 5h8v2H2z\" fill=\"#fff\" fill-rule=\"evenodd\"/></svg>') no-repeat 50% 50%;\n  background-size: 18px;\n  background-color: var(--manual-color);\n  width: 20px;\n  height:  20px;\n  position: relative;\n}\n\n.lh-score__value--binary {\n  text-indent: -5000px;\n}\n\n/* No icon for audits with number scores. */\n.lh-score__value:not(.lh-score__value--binary)::after {\n  content: none;\n}\n\n.lh-score__value--pass {\n  color: var(--pass-color);\n}\n\n.lh-score__value--pass::after {\n  background: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>pass</title><path d=\"M9.17 2.33L4.5 7 2.83 5.33 1.5 6.66l3 3 6-6z\" fill=\"#2b882f\" fill-rule=\"evenodd\"/></svg>') no-repeat 50% 50%;\n  background-size: var(--lh-score-icon-background-size);\n}\n\n.lh-score__value--average {\n  color: var(--average-color);\n}\n\n.lh-score__value--average::after {\n  background: none;\n  content: '!';\n  color: var(--average-color);\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  font-weight: 500;\n  font-size: 15px;\n}\n\n.lh-score__value--fail {\n  color: var(--fail-color);\n}\n\n.lh-score__value--fail::after {\n  background: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>fail</title><path d=\"M8.33 2.33l1.33 1.33-2.335 2.335L9.66 8.33 8.33 9.66 5.995 7.325 3.66 9.66 2.33 8.33l2.335-2.335L2.33 3.66l1.33-1.33 2.335 2.335z\" fill=\"#df332f\"/></svg>') no-repeat 50% 50%;\n  background-size: var(--lh-score-icon-background-size);\n}\n\n.lh-score__description {\n  font-size: smaller;\n  color: var(--secondary-text-color);\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n.lh-score__snippet {\n  align-items: center;\n  justify-content: space-between;\n  /*outline: none;*/\n}\n\n.lh-score__snippet::-moz-list-bullet {\n  display: none;\n}\n\n.lh-toggle-arrow {\n  background: url('data:image/svg+xml;utf8,<svg fill=\"#9e9e9e\" height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M8.59 16.34l4.58-4.59-4.58-4.59L10 5.75l6 6-6 6z\"/><path d=\"M0-.25h24v24H0z\" fill=\"none\"/></svg>') no-repeat 50% 50%;\n  background-size: contain;\n  background-color: transparent;\n  width: 24px;\n  height: 24px;\n  flex: none;\n  margin-left: calc(var(--default-padding) / 2);\n  transition: transform 150ms ease-in-out;\n  cursor: pointer;\n  border: none;\n  transform: rotateZ(90deg);\n}\n\n/* Expandable Details (Audit Groups, Audits) */\n\n.lh-expandable-details {\n  flex: 1;\n}\n\n.lh-expandable-details__summary {\n  display: flex;\n  cursor: pointer;\n}\n\n.lh-expandable-details__header {\n  flex: 1;\n}\n\n.lh-expandable-details[open] > .lh-expandable-details__summary > .lh-toggle-arrow {\n  transform: rotateZ(-90deg);\n}\n\n.lh-expandable-details__summary::-webkit-details-marker {\n  display: none;\n}\n\n/*.lh-score__snippet:focus .lh-score__title {\n  outline: rgb(59, 153, 252) auto 5px;\n}*/\n\n/* Perf Timeline */\n\n.lh-timeline {\n  padding: var(--default-padding);\n  padding-bottom: 0;\n  min-width: calc(var(--lh-filmstrip-thumbnail-width) * 10 + var(--default-padding) * 2);\n}\n\n.lh-narrow .lh-timeline-container {\n  width: calc(100vw - var(--section-padding) * 2);\n  overflow-x: scroll;\n}\n\n.lh-devtools .lh-timeline-container {\n  width: 100%;\n  overflow-x: scroll;\n}\n\n/* Perf Timeline Metric */\n\n.lh-timeline-metric {\n  padding: 5px 0;\n  margin-bottom: calc(var(--body-font-size) / 2);\n}\n\n.lh-timeline-metric__title {\n  font-size: var(--header-font-size);\n}\n\n.lh-timeline-metric__description {\n  color: var(--secondary-text-color);\n}\n\n.lh-timeline-metric__name::after {\n  margin-right: 10px;\n  content: ':';\n}\n\n.lh-timeline-metric--pass .lh-timeline-metric__value {\n  color: var(--pass-color);\n}\n\n.lh-timeline-metric--average .lh-timeline-metric__value {\n  color: var(--average-color);\n}\n\n.lh-timeline-metric--fail .lh-timeline-metric__value {\n  color: var(--fail-color);\n}\n\n.lh-timeline-metric__sparkline {\n  width: 100%;\n}\n\n.lh-timeline-metric__sparkline .lh-sparkline {\n  margin-left: 0;\n  margin-right: 0;\n  border-bottom: 1px solid var(--report-border-color);\n}\n\n.lh-timeline-metric__sparkline .lh-sparkline__bar {\n  float: none;\n}\n\n.lh-timeline-metric--pass .lh-sparkline__bar {\n  background: var(--pass-color);\n}\n\n.lh-timeline-metric--average .lh-sparkline__bar {\n  background: var(--average-color);\n}\n\n.lh-timeline-metric--fail .lh-sparkline__bar {\n  background: var(--fail-color);\n}\n\n/* Perf Hint */\n\n.lh-perf-hint {\n  margin-top: var(--default-padding);\n  margin-left: var(--default-padding);\n  padding-bottom: var(--default-padding);\n  border-bottom: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-perf-hint:last-of-type {\n  border-bottom: none;\n}\n\n.lh-perf-hint__summary {\n  display: flex;\n  align-items: center;\n}\n\n.lh-perf-hint__title {\n  font-size: var(--header-font-size);\n  flex: 10;\n}\n\n.lh-perf-hint__sparkline {\n  flex: 0 0 50%;\n}\n\n.lh-perf-hint__sparkline .lh-sparkline {\n  width: calc(100% - var(--default-padding) * 2);\n  float: right;\n}\n\n.lh-perf-hint__stats {\n  text-align: right;\n  flex: 0 0 70px;\n}\n\n.lh-perf-hint__primary-stat {\n  font-size: var(--header-font-size);\n}\n\n.lh-perf-hint__description {\n  color: var(--secondary-text-color);\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n.lh-perf-hint--pass .lh-perf-hint__stats {\n  color: var(--pass-color);\n}\n\n.lh-perf-hint--pass .lh-sparkline__bar {\n  background: var(--pass-color);\n}\n\n.lh-perf-hint--average .lh-sparkline__bar {\n  background: var(--average-color);\n}\n\n.lh-perf-hint--average .lh-perf-hint__stats {\n  color: var(--average-color);\n}\n\n.lh-perf-hint--fail .lh-sparkline__bar {\n  background: var(--fail-color);\n}\n\n.lh-perf-hint--fail .lh-perf-hint__stats {\n  color: var(--fail-color);\n}\n\n/* Filmstrip */\n\n.lh-filmstrip {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  padding-bottom: var(--default-padding);\n}\n\n.lh-filmstrip__frame {\n  text-align: center;\n}\n\n.lh-filmstrip__timestamp {\n  margin-bottom: 5px;\n}\n\n.lh-filmstrip__thumbnail {\n  border: 1px solid var(--report-secondary-border-color);\n  max-height: 100px;\n}\n\n/* Sparkline */\n\n.lh-sparkline {\n  margin: 5px;\n  height: var(--lh-sparkline-height);\n  width: 100%;\n}\n\n.lh-sparkline--thin {\n  height: calc(var(--lh-sparkline-height) / 2);\n}\n\n.lh-sparkline__bar {\n  background: var(--warning-color);\n  height: 100%;\n  float: right;\n}\n\n/* Audit */\n\n.lh-audit {\n  margin-top: var(--default-padding);\n  padding-bottom: var(--default-padding);\n  border-bottom: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-audit:last-of-type {\n  border-bottom: none;\n}\n\n.lh-audit > .lh-score {\n  font-size: var(--header-font-size);\n}\n\n/* Audit Group */\n\n.lh-audit-group {\n  padding-top: var(--default-padding);\n  padding-bottom: var(--default-padding);\n  border-top: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-category > .lh-audit-group.lh-audit-group--manual {\n  border-top: none;\n  margin-left: var(--default-padding);\n}\n\n.lh-audit-group__header {\n  font-size: 18px;\n}\n\n.lh-audit-group--manual .lh-audit-group__summary {\n  display: flex;\n  align-items: center;\n  font-size: 15px;\n}\n\n.lh-audit-group--manual .lh-audit-group__summary .lh-audit-group__header  {\n  font-size: inherit;\n}\n\n.lh-audit-group--manual .lh-audit-group__summary .lh-toggle-arrow {\n  display: none;\n}\n\n.lh-audit-group--manual .lh-audit-group__summary::-webkit-details-marker {\n  display: initial;\n  background: var(--manual-color) !important;\n}\n\n.lh-audit-group__description {\n  font-size: var(--header-font-size);\n  color: var(--secondary-text-color);\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n.lh-debug {\n  margin-top: calc(var(--default-padding) / 2);\n  margin-left: calc(var(--lh-audit-score-width) + var(--lh-score-margin));\n  color: var(--fail-color);\n}\n\n.lh-debug::before {\n  display: inline-block;\n  content: '';\n  background: url('data:image/svg+xml;utf8,<svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>warn</title><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z\" fill=\"#FFAB00\"/></svg>') no-repeat 50% 50%;\n  background-size: contain;\n  width: 20px;\n  height: 20px;\n  position: relative;\n  margin-right: calc(var(--default-padding) / 2);\n  top: 5px;\n}\n\n\n/* Report */\n\n.lh-container {\n  display: flex;\n  max-width: var(--report-content-width);\n  margin: 0 auto;\n}\n\n.lh-report {\n  margin-left: var(--report-menu-width);\n  width: var(--report-width);\n  background-color: #fff;\n}\n\n.lh-exception {\n  font-size: large;\n}\n\n.lh-text__url {\n  white-space: nowrap;\n}\n\n.lh-code {\n  text-overflow: ellipsis;\n  white-space: pre-line;\n  margin-top: 0;\n}\n\n.lh-scores-header {\n  display: flex;\n  overflow-x: hidden;\n  margin: var(--report-header-height) 0 0 0;\n  padding: calc(var(--default-padding) * 2) var(--default-padding);\n  border-bottom: 1px solid var(--report-border-color);\n}\n\n.lh-categories {\n  width: 100%;\n  overflow: hidden;\n}\n\n.lh-category {\n  padding: var(--section-padding);\n  border-top: 1px solid var(--report-border-color);\n}\n\n.lh-category:first-of-type {\n  border: none;\n}\n\n.lh-category .lh-audit {\n  margin-left: calc(var(--default-padding) * 2);\n}\n\n.lh-category .lh-audit-group {\n  margin-left: calc(var(--lh-category-score-width) + var(--default-padding));\n}\n\n.lh-category > .lh-audit-group {\n  margin-left: 0;\n}\n\n.lh-category .lh-audit-group .lh-audit {\n  margin-left: var(--default-padding);\n}\n\n.lh-category > .lh-score {\n  font-size: 20px;\n  padding-bottom: var(--default-padding);\n}\n\n.lh-category > .lh-score .lh-score__value,\n.lh-category > .lh-score .lh-score__gauge .lh-gauge__label {\n  display: none;\n}\n\n.lh-category .lh-score__gauge {\n  margin: calc(var(--default-padding) / 2) var(--default-padding) 0 0;\n  flex-basis: var(--circle-size);\n  flex-shrink: 0;\n}\n\n.lh-category .lh-score__gauge .lh-gauge {\n  --circle-size: 60px;\n}\n\n/* Category snippet shouldnt have pointer cursor. */\n.lh-category > .lh-score .lh-score__snippet {\n  cursor: initial;\n}\n\n.lh-category > .lh-score .lh-score__title {\n  font-size: 24px;\n  font-weight: 400;\n}\n\n.lh-passed-audits[open] summary.lh-passed-audits-summary {\n  margin-bottom: calc(var(--default-padding) * 2);\n}\n\nsummary.lh-passed-audits-summary {\n  margin: calc(var(--default-padding) * 2) var(--default-padding);\n  margin-left: var(--default-padding);\n  margin-bottom: 0;\n  font-size: 15px;\n  display: flex;\n  align-items: center;\n}\n\nsummary.lh-passed-audits-summary::-webkit-details-marker,\n.lh-audit-group--manual > summary::-webkit-details-marker {\n  background: var(--pass-color);\n  color: white;\n  padding: 3px 3px 3px 6px;\n  border-radius: 2px;\n}\n\n.lh-passed-audits[open] summary.lh-passed-audits-summary::-webkit-details-marker,\n.lh-audit-group--manual[open] > summary::-webkit-details-marker {\n  padding: 3px 5px 3px 4px;\n}\n\n#lh-log {\n  position: fixed;\n  background-color: #323232;\n  color: #fff;\n  min-height: 48px;\n  min-width: 288px;\n  padding: 16px 24px;\n  box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);\n  border-radius: 2px;\n  margin: 12px;\n  font-size: 14px;\n  cursor: default;\n  transition: transform 0.3s, opacity 0.3s;\n  transform: translateY(100px);\n  opacity: 0;\n  -webkit-font-smoothing: antialiased;\n  bottom: 0;\n  left: 0;\n  z-index: 3;\n}\n\n#lh-log.show {\n  opacity: 1;\n  transform: translateY(0);\n}\n\n@media screen and (max-width: 767px) {\n  .lh-report {\n    margin-left: 0;\n    width: 100%;\n    min-width: 400px;\n  }\n  .lh-category {\n    padding: 24px var(--default-padding);\n  }\n}\n\n@media print {\n  body {\n    -webkit-print-color-adjust: exact; /* print background colors */\n  }\n  .lh-report {\n    margin-left: 0;\n  }\n  .lh-categories {\n    margin-top: 0;\n  }\n}\n\n.lh-table {\n  --image-preview-size: 24px;\n  border: 1px solid var(--report-secondary-border-color);\n  border-collapse: collapse;\n  table-layout: fixed;\n  width: 100%;\n}\n\n.lh-table thead {\n  background: var(--lh-table-header-bg);\n}\n\n.lh-table tbody tr:nth-child(even) {\n  background-color: var(--lh-table-higlight-bg);\n}\n\n.lh-table th,\n.lh-table td {\n  padding: 10px;\n  overflow: auto;\n}\n\n.lh-table-column--text {\n  text-align: right;\n}\n\n.lh-table-column--thumbnail {\n  width: calc(var(--image-preview-size) * 2);\n}\n\n.lh-table-column--url {\n  text-align: left;\n  min-width: 250px;\n  white-space: nowrap;\n}\n\n.lh-thumbnail {\n  height: var(--image-preview-size);\n  width: var(--image-preview-size);\n  object-fit: contain;\n}\n\n/*# sourceURL=report.styles.css */\n";const REPORT_TEMPLATES="<!-- Lighthouse category score -->\n<template id=\"tmpl-lh-category-score\">\n  <div class=\"lh-score\">\n    <div class=\"lh-score__value\"><!-- fill me --></div>\n    <div class=\"lh-score__gauge\"></div>\n    <div class=\"lh-score__header\">\n      <div class=\"lh-score__snippet\">\n        <span class=\"lh-score__title\"><!-- fill me --></span>\n      </div>\n      <div class=\"lh-score__description\"><!-- fill me --></div>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse audit score -->\n<template id=\"tmpl-lh-audit-score\">\n  <div class=\"lh-score\">\n    <div class=\"lh-score__value\"><!-- fill me --></div>\n    <details class=\"lh-score__header lh-expandable-details\">\n      <summary class=\"lh-score__snippet lh-expandable-details__summary\">\n        <span class=\"lh-score__title\"><!-- fill me --></span>\n        <div class=\"lh-toggle-arrow\" title=\"See audits\"></div>\n      </summary>\n      <div class=\"lh-score__description\"><!-- fill me --></div>\n    </details>\n  </div>\n</template>\n\n<!-- Lighthouse left nav -->\n<template id=\"tmpl-lh-leftnav\">\n  <style>\n    .lh-leftnav {\n      width: var(--report-menu-width);\n      border-right: 1px solid var(--report-secondary-border-color);\n      position: fixed;\n      height: 100%;\n      background: #fff;\n      will-change: transform; /* prevent excessive paints */\n      z-index: 2;\n    }\n    .lh-leftnav__item {\n      padding: var(--default-padding);\n      color: var(--secondary-text-color);\n      font-size: 16px;\n      display: flex;\n      justify-content: space-between;\n      text-decoration: none;\n      color: inherit;\n    }\n    .leftnav-item__score {\n      background: transparent;\n    }\n    .leftnav-item__score::after {\n      content: '';\n    }\n    .leftnav-item__score.lh-score__value--pass {\n      color: var(--pass-color);\n    }\n    .leftnav-item__score.lh-score__value--average {\n      color: var(--average-color);\n    }\n    .leftnav-item__score.lh-score__value--fail {\n      color: var(--fail-color);\n    }\n    .leftnav__header {\n      padding: 0 20px;\n      height: 115px;\n      font-size: 18px;\n      display: flex;\n      flex-direction: column;\n      justify-content: center;\n      background: url(data:image/png;base64,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) no-repeat 150% 100%;\n      background-color: #2238b3;\n      background-size: 205px;\n      background-blend-mode: luminosity;\n    }\n    .leftnav__header__title {\n      font-family: var(--text-font-family);\n      font-weight: 300;\n      color: #fff;\n      margin: 0;\n      padding: 0;\n      line-height: 1.5;\n    }\n    .leftnav__header__version {\n      color: #aab3ed;\n      font-family: var(--text-font-family);\n      font-size: 14px;\n      line-height: 1.5;\n    }\n    @media screen and (max-width: 767px) {\n      .lh-leftnav {\n        display: none;\n      }\n    }\n    @media print {\n      .lh-leftnav {\n        display: none;\n      }\n    }\n  </style>\n  <nav class=\"lh-leftnav\">\n    <div class=\"leftnav__header\">\n      <h1 class=\"leftnav__header__title\">Lighthouse</h1>\n      <div class=\"leftnav__header__version\"><!-- fill me --></div>\n    </div>\n    <template id=\"tmpl-lh-leftnav__items\">\n      <a href=\"#\" class=\"lh-leftnav__item\">\n        <span class=\"leftnav-item__category\"><!-- fill me --></span>\n        <span class=\"leftnav-item__score\"><!-- fill me --></span>\n      </a>\n    </template>\n  </nav>\n</template>\n\n<!-- Lighthouse header -->\n<template id=\"tmpl-lh-heading\">\n  <style>\n    :root {\n      --report-header-height: 58px;\n      --report-header-bg-color: #fafafa;\n    }\n    .lh-header {\n      display: flex;\n      height: var(--report-header-height);\n      left: 0;\n      right: 0;\n      max-width: 100%; /* support text-overflow on url */\n      border-bottom: 1px solid var(--report-secondary-border-color);\n      position: fixed;\n      z-index: 1;\n      will-change: transform;\n      background-color: var(--report-header-bg-color);\n      margin-left: var(--report-menu-width);\n      align-items: center;\n      padding: 0 calc(var(--default-padding) * 2);\n    }\n    .lh-metadata {\n      flex: 1 1 0;\n      padding-right: calc(var(--default-padding) / 2);\n      line-height: 20px;\n      color: var(--secondary-text-color);\n      overflow-x: hidden;\n    }\n    .lh-metadata__results {\n      overflow: hidden;\n      text-overflow: ellipsis;\n      white-space: nowrap;\n    }\n    .lh-metadata__url {\n      color: currentColor;\n    }\n    .lh-export {\n      position: relative;\n    }\n    .lh-export__button {\n      background-color: #fff;\n      border: 1px solid var(--report-border-color);\n      border-radius: 3px;\n      cursor: pointer;\n      outline: none;\n      height: 32px;\n      width: 48px;\n      background-repeat: no-repeat;\n      background-size: 20px;\n      background-position: 50% 50%;\n    }\n    .lh-export__button:focus,\n    .lh-export__button.active {\n      box-shadow: 1px 1px 3px #ccc;\n    }\n    .lh-export__button.active + .lh-export__dropdown {\n      opacity: 1;\n      clip: rect(0, 164px, 200px, 0);\n    }\n    .lh-export__dropdown {\n      position: absolute;\n      background-color: #fff;\n      border: 1px solid var(--report-border-color);\n      border-radius: 3px;\n      padding: calc(var(--default-padding) / 2) 0;\n      cursor: pointer;\n      top: 36px;\n      right: 0;\n      box-shadow: 1px 1px 3px #ccc;\n      min-width: 125px;\n      clip: rect(0, 164px, 0, 0);\n      opacity: 0;\n      transition: all 200ms cubic-bezier(0,0,0.2,1);\n    }\n    .lh-export__dropdown a {\n      display: block;\n      color: currentColor;\n      text-decoration: none;\n      white-space: nowrap;\n      padding: 0 12px;\n      line-height: 2;\n    }\n    .lh-export__dropdown a:hover,\n    .lh-export__dropdown a:focus {\n      background-color: #efefef;\n      outline: none;\n    }\n    .lh-export__dropdown .report-icon {\n      cursor: pointer;\n      background-repeat: no-repeat;\n      background-position: 8px 50%;\n      background-size: 18px;\n      background-color: transparent;\n      text-indent: 18px;\n    }\n    /* copy icon needs slight adjustments to look great */\n    .lh-export__dropdown .report-icon--copy {\n      background-size: 16px;\n      background-position: 9px 50%;\n    }\n    .lh-config {\n      display: flex;\n    }\n    .lh-env {\n      padding: var(--default-padding) 0 var(--default-padding) calc(var(--default-padding) * 2);\n      left: 0;\n      top: 100%;\n      position: absolute;\n      width: 100%;\n      background-color: var(--report-header-bg-color);\n      border-top: 1px solid var(--report-secondary-border-color);\n      border-bottom: 1px solid var(--report-secondary-border-color);\n    }\n    .lh-env__title {\n      font-size: var(--header-font-size);\n    }\n    .lh-env__items {\n      margin: var(--default-padding) 0 0 0;\n    }\n    .lh-config__timestamp {\n      margin-right: 6px;\n    }\n    .lh-config__settings-toggle {\n      margin-left: 6px;\n    }\n    .lh-config__timestamp,\n    .lh-config__settings-toggle summary {\n      color: var(--secondary-text-color);\n    }\n    .lh-config__settings-toggle summary {\n      display: flex;\n      align-items: center;\n    }\n    .lh-config__settings-toggle .lh-toggle-arrow {\n      width: 16px;\n      height: 16px;\n      margin-left: 2px;\n    }\n    .lh-config__settings-toggle[open] .lh-toggle-arrow {\n      transform: rotateZ(90deg);\n    }\n    .lh-config__settings-toggle summary::-moz-list-bullet {\n      display: none;\n    }\n    .lh-config__settings-toggle summary::-webkit-details-marker {\n      display: none;\n    }\n    @media screen and (min-width: 1130px) {\n      .lh-header {\n        width: var(--report-width);\n        right: initial;\n        left: initial;\n      }\n    }\n    @media screen and (max-width: 767px) {\n      .lh-export__dropdown {\n        right: 0;\n        left: initial;\n      }\n      .lh-header {\n        padding: 0 var(--default-padding);\n        margin-left: 0;\n      }\n    }\n    @media print {\n      .lh-header {\n        display: none;\n        margin-left: 0;\n      }\n    }\n  </style>\n  <div class=\"lh-header\">\n    <div class=\"lh-metadata\">\n      <div class=\"lh-metadata__results\">Results for: <a href=\"\" class=\"lh-metadata__url\" target=\"_blank\" rel=\"noopener\"><!-- fill me --></a></div>\n      <div class=\"lh-config\">\n        <span class=\"lh-config__timestamp\"><!-- fill me --></span> &bullet;\n        <details class=\"lh-config__settings-toggle\">\n          <summary>\n            <span>Runtime settings</span>\n            <span class=\"lh-toggle-arrow\" title=\"See report's runtime settings\"></span>\n          </summary>\n          <div class=\"lh-env\">\n            <div class=\"lh-env__title\">Runtime environment</div>\n            <ul class=\"lh-env__items\">\n              <li class=\"lh-env__item\">\n                <span class=\"lh-env__name\">User agent:</span>\n                <b class=\"lh-env__item__ua\"><!-- fill me --></b>\n              </li>\n              <template id=\"tmpl-lh-env__items\">\n                <li class=\"lh-env__item\">\n                  <span class=\"lh-env__name\"><!-- fill me --></span>\n                  <span class=\"lh-env__description\"><!-- fill me --></span>:\n                  <b class=\"lh-env__enabled\"><!-- fill me --></b>\n                </li>\n              </template>\n            </ul>\n          </div>\n        </details>\n      </div>\n    </div>\n    <div class=\"lh-export\">\n      <button class=\"report-icon report-icon--share lh-export__button\" title=\"Export report\"></button>\n      <div class=\"lh-export__dropdown\">\n        <a href=\"#\" class=\"report-icon report-icon--print\" data-action=\"print\">Print...</a>\n        <a href=\"#\" class=\"report-icon report-icon--copy\" data-action=\"copy\">Copy JSON</a>\n        <a href=\"#\" class=\"report-icon report-icon--download\" data-action=\"save-html\">Save as HTML</a>\n        <a href=\"#\" class=\"report-icon report-icon--download\" data-action=\"save-json\">Save as JSON</a>\n      </div>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse footer -->\n<template id=\"tmpl-lh-footer\">\n  <style>\n    .lh-footer {\n      text-align: center;\n      line-height: 90px;\n      background-color: var(--report-header-bg-color);\n      border-top: 1px solid var(--report-secondary-border-color);\n    }\n  </style>\n  <footer class=\"lh-footer\">\n    Generated by <b>Lighthouse</b> <span class=\"lh-footer__version\"><!-- fill me --></span> on\n    <span class=\"lh-footer__timestamp\"><!-- fill me --></span> |\n    <a href=\"https://github.com/GoogleChrome/Lighthouse/issues\" target=\"_blank\" rel=\"noopener\">File an issue</a>\n  </footer>\n</template>\n\n<!-- Lighthouse score gauge -->\n<template id=\"tmpl-lh-gauge\">\n  <style>\n    .lh-gauge {\n      --circle-size: 80px;\n      --circle-size-half: calc(var(--circle-size) / 2);\n      --circle-background: #eee;\n      --circle-border-width: 8px;\n      --inset-size: calc(var(--circle-size) - var(--circle-border-width));\n      --inset-color: #fff;\n      --transition-length: 1s;\n      width: var(--circle-size);\n      height: var(--circle-size);\n      background-color: var(--circle-background);\n      border-radius: 50%;\n    }\n    .lh-gauge--pass {\n      --circle-color: var(--pass-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge--average {\n      --circle-color: var(--average-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge--fail {\n      --circle-color: var(--fail-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge__mask,\n    .lh-gauge__fill {\n      width: var(--circle-size);\n      height: var(--circle-size);\n      position: absolute;\n      transition: transform var(--transition-length);\n      border-radius: 50%;\n    }\n    .lh-gauge__mask {\n      clip: rect(0px, var(--circle-size), var(--circle-size), var(--circle-size-half));\n    }\n    .lh-gauge__mask .lh-gauge__fill {\n      clip: rect(0px, var(--circle-size-half), var(--circle-size), 0px);\n      background-color: var(--circle-color);\n      backface-visibility: hidden;\n    }\n    .lh-gauge__percentage {\n      --spacer: calc((var(--circle-size) - var(--inset-size)) / 2);\n      width: var(--inset-size);\n      height: var(--inset-size);\n      position: absolute;\n      margin-left: var(--spacer);\n      margin-top: var(--spacer);\n      background-color: var(--inset-color);\n      border-radius: inherit;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      font-size: calc(var(--circle-size) / 3);\n    }\n    .lh-gauge__wrapper {\n      display: inline-flex;\n      align-items: center;\n      flex-direction: column;\n      text-decoration: none;\n      color: inherit;\n      flex: 1;\n      min-width: auto;\n      position: relative;\n    }\n    .lh-gauge__label {\n      font-size: 16px;\n      margin-top: var(--default-padding);\n      text-align: center;\n    }\n    @media screen and (max-width: 767px) {\n      .lh-gauge__label {\n        font-size: 12px;\n      }\n    }\n  </style>\n  <a href=\"#\" class=\"lh-gauge__wrapper\">\n    <div class=\"lh-gauge\" data-progress=\"0\">\n      <div class=\"lh-gauge__circle\">\n        <div class=\"lh-gauge__mask lh-gauge__mask--full\">\n          <div class=\"lh-gauge__fill\"></div>\n        </div>\n        <div class=\"lh-gauge__mask lh-gauge__mask--half\">\n          <div class=\"lh-gauge__fill\"></div>\n          <div class=\"lh-gauge__fill lh-gauge__fill--fix\"></div>\n        </div>\n      </div>\n      <div class=\"lh-gauge__percentage\"></div>\n    </div>\n    <div class=\"lh-gauge__label\"><!-- fill me --></div>\n  </a>\n</template>\n\n<!-- Lighthouse crtiical request chains component -->\n<template id=\"tmpl-lh-crc\">\n  <style>\n    .lh-crc .tree-marker {\n      width: 12px;\n      height: 26px;\n      display: block;\n      float: left;\n      background-position: top left;\n    }\n    .lh-crc .horiz-down {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"#D8D8D8\" fill-rule=\"evenodd\"><path d=\"M16 12v2H-2v-2z\"/><path d=\"M9 12v14H7V12z\"/></g></svg>');\n    }\n    .lh-crc .right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 12v2H0v-2z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .up-right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v14H7zm2 12h7v2H9z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .vert-right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v27H7zm2 12h7v2H9z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .vert {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v26H7z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .crc-tree {\n      font-size: 14px;\n      width: 100%;\n      overflow-x: auto;\n    }\n    .lh-crc .crc-node {\n      height: 26px;\n      line-height: 26px;\n      white-space: nowrap;\n    }\n    .lh-crc .crc-node__tree-value {\n      margin-left: 10px;\n    }\n    .lh-crc .crc-node__chain-duration {\n      font-weight: 700;\n    }\n    .lh-crc .crc-node__tree-hostname {\n      color: #595959;\n    }\n    .lh-crc .crc-initial-nav {\n      color: #595959;\n      font-style: italic;\n    }\n  </style>\n  <div class=\"lh-score__description\">\n    Longest chain: <b class=\"lh-crc__longest_duration\"><!-- fill me: longestChain.duration --></b>\n    over <b class=\"lh-crc__longest_length\"><!-- fill me: longestChain.length --></b> requests, totalling\n    <b class=\"lh-crc__longest_transfersize\"><!-- fill me: longestChain.length --></b>\n  </div>\n  <div class=\"lh-crc\">\n    <details class=\"lh-details\">\n      <summary><!-- fill me --></summary>\n      <div class=\"crc-initial-nav\">Initial Navigation</div>\n      <!-- stamp for each chain -->\n      <template id=\"tmpl-lh-crc__chains\">\n        <div class=\"crc-node\">\n          <span class=\"crc-node__tree-marker\">\n            <!-- fill me -->\n          </span>\n          <span class=\"crc-node__tree-value\">\n            <span class=\"crc-node__tree-file\"><!-- fill me: node.request.url.file --></span>\n            <span class=\"crc-node__tree-hostname\">(<!-- fill me: node.request.url.host -->)</span>\n            <!-- fill me -->\n          </span>\n        </div>\n      </template>\n    </details>\n  </div>\n</template>\n";class ReportGeneratorV2{static arithmeticMean(items){const results=items.reduce((result,item)=>{const score=Number(item.score)||0;const weight=Number(item.weight)||0;return{weight:result.weight+weight,sum:result.sum+score*weight};},{weight:0,sum:0});return results.sum/results.weight||0;}
static replaceStrings(source,replacements){if(replacements.length===0){return source;}
const firstReplacement=replacements[0];const nextReplacements=replacements.slice(1);return source.split(firstReplacement.search).map(part=>ReportGeneratorV2.replaceStrings(part,nextReplacements)).join(firstReplacement.replacement);}
static _getAggregations(reportCategories){return reportCategories.map(category=>{const name=category.name;const description=category.description;return{name,description,categorizable:false,scored:category.id==='pwa',total:category.score/100,score:[{name,description,overall:category.score/100,subItems:category.audits.map(audit=>audit.result)}]};});}
generateReportJson(config,resultsByAuditId){const categories=Object.keys(config.categories).map(categoryId=>{const category=config.categories[categoryId];category.id=categoryId;const audits=category.audits.map(audit=>{const result=resultsByAuditId[audit.id];let auditScore=Number(result.score)||0;if(typeof result.score==='boolean'){auditScore=result.score?100:0;}
return Object.assign({},audit,{result,score:auditScore});});const categoryScore=ReportGeneratorV2.arithmeticMean(audits);return Object.assign({},category,{audits,score:categoryScore});});const overallScore=ReportGeneratorV2.arithmeticMean(categories);const aggregations=ReportGeneratorV2._getAggregations(categories);return{score:overallScore,categories,aggregations};}
generateReportHtml(reportAsJson){const sanitizedJson=JSON.stringify(reportAsJson).replace(/</g,'\\u003c');const sanitizedJavascript=REPORT_JAVASCRIPT.replace(/<\//g,'\\u003c/');return ReportGeneratorV2.replaceStrings(REPORT_TEMPLATE,[{search:'%%LIGHTHOUSE_JSON%%',replacement:sanitizedJson},{search:'%%LIGHTHOUSE_JAVASCRIPT%%',replacement:sanitizedJavascript},{search:'/*%%LIGHTHOUSE_CSS%%*/',replacement:REPORT_CSS},{search:'%%LIGHTHOUSE_TEMPLATES%%',replacement:REPORT_TEMPLATES}]);}}
module.exports=ReportGeneratorV2;},{}],32:[function(require,module,exports){(function(process,__dirname){'use strict';const Driver=require('./gather/driver.js');const GatherRunner=require('./gather/gather-runner');const ReportGeneratorV2=require('./report/v2/report-generator');const Audit=require('./audits/audit');const emulation=require('./lib/emulation');const log=require('./lib/log');const path=require('path');const URL=require('./lib/url-shim');class Runner{static run(connection,opts){opts.flags=opts.flags||{};const config=opts.config;opts.initialUrl=opts.url;if(typeof opts.initialUrl!=='string'||opts.initialUrl.length===0){return Promise.reject(new Error('You must provide a url to the runner'));}
let parsedURL;try{parsedURL=new URL(opts.url);}catch(e){const err=new Error('The url provided should have a proper protocol and hostname.');return Promise.reject(err);}
if(parsedURL.protocol!=='https:'&&parsedURL.hostname!=='localhost'){log.warn('Lighthouse','The URL provided should be on HTTPS');log.warn('Lighthouse','Performance stats will be skewed redirecting from HTTP to HTTPS.');}
opts.url=parsedURL.href;const validPassesAndAudits=config.passes&&config.audits;const validArtifactsAndAudits=config.artifacts&&config.audits;let run=Promise.resolve();if(validPassesAndAudits||validArtifactsAndAudits){if(validPassesAndAudits){opts.driver=opts.driverMock||new Driver(connection);run=run.then(_=>GatherRunner.run(config.passes,opts));}else if(validArtifactsAndAudits){run=run.then(_=>config.artifacts);}
run=run.then(artifacts=>{return Object.assign({},artifacts,Runner.instantiateComputedArtifacts());});run=run.then(artifacts=>{for(const passName of Object.keys(artifacts.traces||{})){const trace=artifacts.traces[passName];if(!Array.isArray(trace.traceEvents)){throw new Error(passName+' trace was invalid. `traceEvents` was not an array.');}}
return artifacts;});run=run.then(artifacts=>{log.log('status','Analyzing and running audits...');return artifacts;});const auditResults=[];for(const audit of config.audits){run=run.then(artifacts=>{return Runner._runAudit(audit,artifacts).then(ret=>auditResults.push(ret)).then(_=>artifacts);});}
run=run.then(artifacts=>{return{artifacts,auditResults};});}else if(config.auditResults){const artifacts=Object.assign({},config.artifacts||{},Runner.instantiateComputedArtifacts());run=run.then(_=>{return{artifacts,auditResults:config.auditResults};});}else{const err=Error('The config must provide passes and audits, artifacts and audits, or auditResults');return Promise.reject(err);}
run=run.then(runResults=>{log.log('status','Generating results...');const resultsById=runResults.auditResults.reduce((results,audit)=>{results[audit.name]=audit;return results;},{});let aggregations=[];let reportCategories=[];let score=0;if(config.categories){const reportGenerator=new ReportGeneratorV2();const report=reportGenerator.generateReportJson(config,resultsById);reportCategories=report.categories;aggregations=report.aggregations;score=report.score;}
return{userAgent:runResults.artifacts.UserAgent,lighthouseVersion:require('../package').version,generatedTime:new Date().toJSON(),initialUrl:opts.initialUrl,url:opts.url,audits:resultsById,artifacts:runResults.artifacts,runtimeConfig:Runner.getRuntimeConfig(opts.flags),score,reportCategories,reportGroups:config.groups,aggregations};});return run;}
static _runAudit(audit,artifacts){const status=`Evaluating: ${audit.meta.description}`;return Promise.resolve().then(_=>{log.log('status',status);for(const artifactName of audit.meta.requiredArtifacts){const noArtifact=typeof artifacts[artifactName]==='undefined';const noTrace=artifactName==='traces'&&!artifacts.traces[Audit.DEFAULT_PASS];if(noArtifact||noTrace){log.warn('Runner',`${artifactName} gatherer, required by audit ${audit.meta.name}, did not run.`);throw new Error(`Required ${artifactName} gatherer did not run.`);}
if(artifacts[artifactName]instanceof Error){const artifactError=artifacts[artifactName];log.warn('Runner',`${artifactName} gatherer, required by audit ${audit.meta.name},`+` encountered an error: ${artifactError.message}`);throw new Error(`Required ${artifactName} gatherer encountered an error: ${artifactError.message}`);}}
return audit.audit(artifacts);}).then(auditResult=>Audit.generateAuditResult(audit,auditResult)).catch(err=>{log.warn(audit.meta.name,`Caught exception: ${err.message}`);if(err.fatal){throw err;}
return Audit.generateErrorAuditResult(audit,'Audit error: '+err.message);}).then(result=>{log.verbose('statusEnd',status);return result;});}
static getAuditList(){const ignoredFiles=['audit.js','violation-audit.js','accessibility/axe-audit.js','multi-check-audit.js','byte-efficiency/byte-efficiency-audit.js','manual/manual-audit.js'];const fileList=[...["accessibility","audit.js","byte-efficiency","cache-start-url.js","consistently-interactive.js","content-width.js","critical-request-chains.js","deprecations.js","dobetterweb","estimated-input-latency.js","first-interactive.js","first-meaningful-paint.js","is-on-https.js","load-fast-enough-for-pwa.js","manifest-short-name-length.js","manual","multi-check-audit.js","redirects-http.js","screenshot-thumbnails.js","service-worker.js","speed-index-metric.js","splash-screen.js","themed-omnibox.js","time-to-firstbyte.js","time-to-interactive.js","user-timings.js","viewport.js","violation-audit.js","webapp-install-banner.js","without-javascript.js","works-offline.js"],...["appcache-manifest.js","dom-size.js","external-anchors-use-rel-noopener.js","geolocation-on-start.js","link-blocking-first-paint.js","no-document-write.js","no-mutation-events.js","no-old-flexbox.js","no-websql.js","notification-on-start.js","script-blocking-first-paint.js","uses-http2.js","uses-passive-event-listeners.js"].map(f=>`dobetterweb/${f}`),...["accesskeys.js","aria-allowed-attr.js","aria-required-attr.js","aria-required-children.js","aria-required-parent.js","aria-roles.js","aria-valid-attr-value.js","aria-valid-attr.js","audio-caption.js","axe-audit.js","button-name.js","bypass.js","color-contrast.js","definition-list.js","dlitem.js","document-title.js","duplicate-id.js","frame-title.js","html-has-lang.js","html-lang-valid.js","image-alt.js","input-image-alt.js","label.js","layout-table.js","link-name.js","list.js","listitem.js","meta-refresh.js","meta-viewport.js","object-alt.js","tabindex.js","td-headers-attr.js","th-has-data-cells.js","valid-lang.js","video-caption.js","video-description.js"].map(f=>`accessibility/${f}`),...["byte-efficiency-audit.js","offscreen-images.js","total-byte-weight.js","unused-css-rules.js","uses-optimized-images.js","uses-request-compression.js","uses-responsive-images.js","uses-webp-images.js"].map(f=>`byte-efficiency/${f}`),...["manual-audit.js","pwa-cross-browser.js","pwa-each-page-has-url.js","pwa-page-transitions.js"].map(f=>`manual/${f}`)];return fileList.filter(f=>{return/\.js$/.test(f)&&!ignoredFiles.includes(f);}).sort();}
static getGathererList(){const fileList=[...["accessibility.js","cache-contents.js","chrome-console-messages.js","css-usage.js","dobetterweb","gatherer.js","html-without-javascript.js","http-redirect.js","image-usage.js","manifest.js","offline.js","service-worker.js","start-url.js","styles.js","theme-color.js","url.js","viewport-dimensions.js","viewport.js"],...["all-event-listeners.js","anchors-with-no-rel-noopener.js","appcache.js","domstats.js","optimized-images.js","response-compression.js","tags-blocking-first-paint.js","websql.js"].map(f=>`dobetterweb/${f}`)];return fileList.filter(f=>/\.js$/.test(f)&&f!=='gatherer.js').sort();}
static instantiateComputedArtifacts(){const computedArtifacts={};["computed-artifact.js","critical-request-chains.js","first-interactive.js","manifest-values.js","network-records.js","network-throughput.js","pushed-requests.js","screenshots.js","speedline.js","trace-of-tab.js","tracing-model.js"].forEach(function(filename){if(filename==='computed-artifact.js')return;filename=filename.replace(/\.js$/,'');const ArtifactClass=require('./gather/computed/'+filename);const artifact=new ArtifactClass(computedArtifacts);computedArtifacts['request'+artifact.name]=artifact.request.bind(artifact);});return computedArtifacts;}
static resolvePlugin(plugin,configDir,category){try{return require.resolve(plugin);}catch(e){}
const cwdPath=path.resolve(process.cwd(),plugin);try{return require.resolve(cwdPath);}catch(e){}
const errorString='Unable to locate '+(category?`${category}: `:'')+`${plugin} (tried to require() from '${__dirname}' and load from '${cwdPath}'`;if(!configDir){throw new Error(errorString+')');}
const relativePath=path.resolve(configDir,plugin);try{return require.resolve(relativePath);}catch(requireError){}
throw new Error(errorString+` and '${relativePath}')`);}
static getRuntimeConfig(flags){const emulationDesc=emulation.getEmulationDesc();const environment=[{name:'Device Emulation',enabled:!flags.disableDeviceEmulation,description:emulationDesc['deviceEmulation']},{name:'Network Throttling',enabled:!flags.disableNetworkThrottling,description:emulationDesc['networkThrottling']},{name:'CPU Throttling',enabled:!flags.disableCpuThrottling,description:emulationDesc['cpuThrottling']}];return{environment,blockedUrlPatterns:flags.blockedUrlPatterns||[]};}}
module.exports=Runner;}).call(this,require('_process'),"/../lighthouse-core");},{"../package":283,"./audits/audit":2,"./gather/driver.js":13,"./gather/gather-runner":14,"./lib/emulation":18,"./lib/log":21,"./lib/url-shim":27,"./report/v2/report-generator":31,"_process":221,"path":219}],33:[function(require,module,exports){(function(global){"use strict";'use strict';global.tr=function(){if(global.tr){console.warn('Base was multiply initialized. First init wins.');return global.tr;}function exportPath(name){var parts=name.split('.');var cur=global;for(var part;parts.length&&(part=parts.shift());){if(part in cur){cur=cur[part];}else{cur=cur[part]={};}}return cur;};function isExported(name){var parts=name.split('.');var cur=global;for(var part;parts.length&&(part=parts.shift());){if(part in cur){cur=cur[part];}else{return false;}}return true;}function isDefined(name){var parts=name.split('.');var curObject=global;for(var i=0;i<parts.length;i++){var partName=parts[i];var nextObject=curObject[partName];if(nextObject===undefined)return false;curObject=nextObject;}return true;}var panicElement=undefined;var rawPanicMessages=[];function showPanicElementIfNeeded(){if(panicElement)return;var panicOverlay=document.createElement('div');panicOverlay.style.backgroundColor='white';panicOverlay.style.border='3px solid red';panicOverlay.style.boxSizing='border-box';panicOverlay.style.color='black';panicOverlay.style.display='-webkit-flex';panicOverlay.style.height='100%';panicOverlay.style.left=0;panicOverlay.style.padding='8px';panicOverlay.style.position='fixed';panicOverlay.style.top=0;panicOverlay.style.webkitFlexDirection='column';panicOverlay.style.width='100%';panicElement=document.createElement('div');panicElement.style.webkitFlex='1 1 auto';panicElement.style.overflow='auto';panicOverlay.appendChild(panicElement);if(!document.body){setTimeout(function(){document.body.appendChild(panicOverlay);},150);}else{document.body.appendChild(panicOverlay);}}function showPanic(panicTitle,panicDetails){if(tr.isHeadless){if(panicDetails instanceof Error)throw panicDetails;throw new Error('Panic: '+panicTitle+':\n'+panicDetails);}if(panicDetails instanceof Error)panicDetails=panicDetails.stack;showPanicElementIfNeeded();var panicMessageEl=document.createElement('div');panicMessageEl.innerHTML='<h2 id="message"></h2>'+'<pre id="details"></pre>';panicMessageEl.querySelector('#message').textContent=panicTitle;panicMessageEl.querySelector('#details').textContent=panicDetails;panicElement.appendChild(panicMessageEl);rawPanicMessages.push({title:panicTitle,details:panicDetails});}function hasPanic(){return rawPanicMessages.length!==0;}function getPanicText(){return rawPanicMessages.map(function(msg){return msg.title;}).join(', ');}function exportTo(namespace,fn){var obj=exportPath(namespace);var exports=fn();for(var propertyName in exports){var propertyDescriptor=Object.getOwnPropertyDescriptor(exports,propertyName);if(propertyDescriptor)Object.defineProperty(obj,propertyName,propertyDescriptor);}};function initialize(){if(global.isVinn){tr.isVinn=true;}else if(global.process&&global.process.versions.node){tr.isNode=true;}else{tr.isVinn=false;tr.isNode=false;tr.doc=document;tr.isMac=/Mac/.test(navigator.platform);tr.isWindows=/Win/.test(navigator.platform);tr.isChromeOS=/CrOS/.test(navigator.userAgent);tr.isLinux=/Linux/.test(navigator.userAgent);}tr.isHeadless=tr.isVinn||tr.isNode;}return{initialize:initialize,exportTo:exportTo,isExported:isExported,isDefined:isDefined,showPanic:showPanic,hasPanic:hasPanic,getPanicText:getPanicText};}();tr.initialize();}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{}],34:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function Base64(){}function b64ToUint6(nChr){if(nChr>64&&nChr<91)return nChr-65;if(nChr>96&&nChr<123)return nChr-71;if(nChr>47&&nChr<58)return nChr+4;if(nChr===43)return 62;if(nChr===47)return 63;return 0;}Base64.getDecodedBufferLength=function(input){return input.length*3+1>>2;};Base64.EncodeArrayBufferToString=function(input){var binary='';var bytes=new Uint8Array(input);var len=bytes.byteLength;for(var i=0;i<len;i++)binary+=String.fromCharCode(bytes[i]);return btoa(binary);};Base64.DecodeToTypedArray=function(input,output){var nInLen=input.length;var nOutLen=nInLen*3+1>>2;var nMod3=0;var nMod4=0;var nUint24=0;var nOutIdx=0;if(nOutLen>output.byteLength)throw new Error('Output buffer too small to decode.');for(var nInIdx=0;nInIdx<nInLen;nInIdx++){nMod4=nInIdx&3;nUint24|=b64ToUint6(input.charCodeAt(nInIdx))<<18-6*nMod4;if(nMod4===3||nInLen-nInIdx===1){for(nMod3=0;nMod3<3&&nOutIdx<nOutLen;nMod3++,nOutIdx++){output.setUint8(nOutIdx,nUint24>>>(16>>>nMod3&24)&255);}nUint24=0;}}return nOutIdx-1;};Base64.btoa=function(input){return btoa(input);};Base64.atob=function(input){return atob(input);};return{Base64:Base64};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],35:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){var categoryPartsFor={};function getCategoryParts(category){var parts=categoryPartsFor[category];if(parts!==undefined)return parts;parts=category.split(',');categoryPartsFor[category]=parts;return parts;}return{getCategoryParts:getCategoryParts};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],36:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function clamp01(value){return Math.max(0,Math.min(1,value));}function Color(opt_r,opt_g,opt_b,opt_a){this.r=Math.floor(opt_r)||0;this.g=Math.floor(opt_g)||0;this.b=Math.floor(opt_b)||0;this.a=opt_a;}Color.fromString=function(str){var tmp;var values;if(str.substr(0,4)=='rgb('){tmp=str.substr(4,str.length-5);values=tmp.split(',').map(function(v){return v.replace(/^\s+/,'','g');});if(values.length!=3)throw new Error('Malformatted rgb-expression');return new Color(parseInt(values[0]),parseInt(values[1]),parseInt(values[2]));}else if(str.substr(0,5)=='rgba('){tmp=str.substr(5,str.length-6);values=tmp.split(',').map(function(v){return v.replace(/^\s+/,'','g');});if(values.length!=4)throw new Error('Malformatted rgb-expression');return new Color(parseInt(values[0]),parseInt(values[1]),parseInt(values[2]),parseFloat(values[3]));}else if(str[0]=='#'&&str.length==7){return new Color(parseInt(str.substr(1,2),16),parseInt(str.substr(3,2),16),parseInt(str.substr(5,2),16));}else{throw new Error('Unrecognized string format.');}};Color.lerp=function(a,b,percent){if(a.a!==undefined&&b.a!==undefined)return Color.lerpRGBA(a,b,percent);return Color.lerpRGB(a,b,percent);};Color.lerpRGB=function(a,b,percent){return new Color((b.r-a.r)*percent+a.r,(b.g-a.g)*percent+a.g,(b.b-a.b)*percent+a.b);};Color.lerpRGBA=function(a,b,percent){return new Color((b.r-a.r)*percent+a.r,(b.g-a.g)*percent+a.g,(b.b-a.b)*percent+a.b,(b.a-a.a)*percent+a.a);};Color.fromDict=function(dict){return new Color(dict.r,dict.g,dict.b,dict.a);};Color.fromHSLExplicit=function(h,s,l,a){var r,g,b;function hue2rgb(p,q,t){if(t<0)t+=1;if(t>1)t-=1;if(t<1/6)return p+(q-p)*6*t;if(t<1/2)return q;if(t<2/3)return p+(q-p)*(2/3-t)*6;return p;}if(s===0){r=g=b=l;}else{var q=l<0.5?l*(1+s):l+s-l*s;var p=2*l-q;r=hue2rgb(p,q,h+1/3);g=hue2rgb(p,q,h);b=hue2rgb(p,q,h-1/3);}return new Color(Math.floor(r*255),Math.floor(g*255),Math.floor(b*255),a);};Color.fromHSL=function(hsl){return Color.fromHSLExplicit(hsl.h,hsl.s,hsl.l,hsl.a);};Color.prototype={clone:function(){var c=new Color();c.r=this.r;c.g=this.g;c.b=this.b;c.a=this.a;return c;},blendOver:function(bgColor){var oneMinusThisAlpha=1-this.a;var outA=this.a+bgColor.a*oneMinusThisAlpha;var bgBlend=bgColor.a*oneMinusThisAlpha/bgColor.a;return new Color(this.r*this.a+bgColor.r*bgBlend,this.g*this.a+bgColor.g*bgBlend,this.b*this.a+bgColor.b*bgBlend,outA);},brighten:function(opt_k){var k;k=opt_k||0.45;return new Color(Math.min(255,this.r+Math.floor(this.r*k)),Math.min(255,this.g+Math.floor(this.g*k)),Math.min(255,this.b+Math.floor(this.b*k)),this.a);},lighten:function(k,opt_maxL){var maxL=opt_maxL!==undefined?opt_maxL:1.0;var hsl=this.toHSL();hsl.l=clamp01(hsl.l+k);return Color.fromHSL(hsl);},darken:function(opt_k){var k;if(opt_k!==undefined)k=opt_k;else k=0.45;return new Color(Math.min(255,this.r-Math.floor(this.r*k)),Math.min(255,this.g-Math.floor(this.g*k)),Math.min(255,this.b-Math.floor(this.b*k)),this.a);},desaturate:function(opt_desaturateFactor){var desaturateFactor;if(opt_desaturateFactor!==undefined)desaturateFactor=opt_desaturateFactor;else desaturateFactor=1;var hsl=this.toHSL();hsl.s=clamp01(hsl.s*(1-desaturateFactor));return Color.fromHSL(hsl);},withAlpha:function(a){return new Color(this.r,this.g,this.b,a);},toString:function(){if(this.a!==undefined){return'rgba('+this.r+','+this.g+','+this.b+','+this.a+')';}return'rgb('+this.r+','+this.g+','+this.b+')';},toHSL:function(){var r=this.r/255;var g=this.g/255;var b=this.b/255;var max=Math.max(r,g,b);var min=Math.min(r,g,b);var h,s;var l=(max+min)/2;if(min===max){h=0;s=0;}else{var delta=max-min;if(l>0.5)s=delta/(2-max-min);else s=delta/(max+min);if(r===max){h=(g-b)/delta;if(g<b)h+=6;}else if(g===max){h=2+(b-r)/delta;}else{h=4+(r-g)/delta;}h/=6;}return{h:h,s:s,l:l,a:this.a};},toStringWithAlphaOverride:function(alpha){return'rgba('+this.r+','+this.g+','+this.b+','+alpha+')';}};return{Color:Color};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],37:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./color.js");require("./iteration_helpers.js");'use strict';global.tr.exportTo('tr.b',function(){var generalPurposeColors=[new tr.b.Color(122,98,135),new tr.b.Color(150,83,105),new tr.b.Color(44,56,189),new tr.b.Color(99,86,147),new tr.b.Color(104,129,107),new tr.b.Color(130,178,55),new tr.b.Color(87,109,147),new tr.b.Color(111,145,88),new tr.b.Color(81,152,131),new tr.b.Color(142,91,111),new tr.b.Color(81,163,70),new tr.b.Color(148,94,86),new tr.b.Color(144,89,118),new tr.b.Color(83,150,97),new tr.b.Color(105,94,139),new tr.b.Color(89,144,122),new tr.b.Color(105,119,128),new tr.b.Color(96,128,137),new tr.b.Color(145,88,145),new tr.b.Color(88,145,144),new tr.b.Color(90,100,143),new tr.b.Color(121,97,136),new tr.b.Color(111,160,73),new tr.b.Color(112,91,142),new tr.b.Color(86,147,86),new tr.b.Color(63,100,170),new tr.b.Color(81,152,107),new tr.b.Color(60,164,173),new tr.b.Color(143,72,161),new tr.b.Color(159,74,86)];var reservedColorsByName={thread_state_uninterruptible:new tr.b.Color(182,125,143),thread_state_iowait:new tr.b.Color(255,140,0),thread_state_running:new tr.b.Color(126,200,148),thread_state_runnable:new tr.b.Color(133,160,210),thread_state_sleeping:new tr.b.Color(240,240,240),thread_state_unknown:new tr.b.Color(199,155,125),background_memory_dump:new tr.b.Color(0,180,180),light_memory_dump:new tr.b.Color(0,0,180),detailed_memory_dump:new tr.b.Color(180,0,180),generic_work:new tr.b.Color(125,125,125),good:new tr.b.Color(0,125,0),bad:new tr.b.Color(180,125,0),terrible:new tr.b.Color(180,0,0),black:new tr.b.Color(0,0,0),rail_response:new tr.b.Color(67,135,253),rail_animation:new tr.b.Color(244,74,63),rail_idle:new tr.b.Color(238,142,0),rail_load:new tr.b.Color(13,168,97),startup:new tr.b.Color(230,230,0),used_memory_column:new tr.b.Color(0,0,255),older_used_memory_column:new tr.b.Color(153,204,255),tracing_memory_column:new tr.b.Color(153,153,153),heap_dump_stack_frame:new tr.b.Color(128,128,128),heap_dump_object_type:new tr.b.Color(0,0,255),heap_dump_child_node_arrow:new tr.b.Color(204,102,0),cq_build_running:new tr.b.Color(255,255,119),cq_build_passed:new tr.b.Color(153,238,102),cq_build_failed:new tr.b.Color(238,136,136),cq_build_abandoned:new tr.b.Color(187,187,187),cq_build_attempt_runnig:new tr.b.Color(222,222,75),cq_build_attempt_passed:new tr.b.Color(103,218,35),cq_build_attempt_failed:new tr.b.Color(197,81,81)};var numGeneralPurposeColorIds=generalPurposeColors.length;var numReservedColorIds=tr.b.dictionaryLength(reservedColorsByName);var numColorsPerVariant=numGeneralPurposeColorIds+numReservedColorIds;function ColorScheme(){}var paletteBase=[];paletteBase.push.apply(paletteBase,generalPurposeColors);paletteBase.push.apply(paletteBase,tr.b.dictionaryValues(reservedColorsByName));ColorScheme.colors=[];ColorScheme.properties={};ColorScheme.properties={numColorsPerVariant:numColorsPerVariant};function pushVariant(func){var variantColors=paletteBase.map(func);ColorScheme.colors.push.apply(ColorScheme.colors,variantColors);}pushVariant(function(c){return c;});ColorScheme.properties.brightenedOffsets=[];ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.lighten(0.3,0.9);});ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.lighten(0.48,0.9);});ColorScheme.properties.brightenedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.lighten(0.65,0.9);});ColorScheme.properties.dimmedOffsets=[];ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.desaturate();});ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.desaturate(0.5);});ColorScheme.properties.dimmedOffsets.push(ColorScheme.colors.length);pushVariant(function(c){return c.desaturate(0.3);});ColorScheme.colorsAsStrings=ColorScheme.colors.map(function(c){return c.toString();});var reservedColorNameToIdMap=function(){var m=new Map();var i=generalPurposeColors.length;tr.b.iterItems(reservedColorsByName,function(key,value){m.set(key,i++);});return m;}();ColorScheme.getColorIdForReservedName=function(name){var id=reservedColorNameToIdMap.get(name);if(id===undefined)throw new Error('Unrecognized color ')+name;return id;};ColorScheme.getColorForReservedNameAsString=function(reservedName){var id=ColorScheme.getColorIdForReservedName(reservedName);return ColorScheme.colorsAsStrings[id];};ColorScheme.getStringHash=function(name){var hash=0;for(var i=0;i<name.length;++i)hash=(hash+37*hash+11*name.charCodeAt(i))%0xFFFFFFFF;return hash;};var stringColorIdCache=new Map();ColorScheme.getColorIdForGeneralPurposeString=function(string){if(stringColorIdCache.get(string)===undefined){var hash=ColorScheme.getStringHash(string);stringColorIdCache.set(string,hash%numGeneralPurposeColorIds);}return stringColorIdCache.get(string);};return{ColorScheme:ColorScheme};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33,"./color.js":36,"./iteration_helpers.js":46}],38:[function(require,module,exports){(function(global){"use strict";require("./event_target.js");'use strict';global.tr.exportTo('tr.b',function(){var Event;if(tr.isHeadless){function HeadlessEvent(type,opt_bubbles,opt_preventable){this.type=type;this.bubbles=opt_bubbles!==undefined?!!opt_bubbles:false;this.cancelable=opt_preventable!==undefined?!!opt_preventable:false;this.defaultPrevented=false;this.cancelBubble=false;};HeadlessEvent.prototype={preventDefault:function(){this.defaultPrevented=true;},stopPropagation:function(){this.cancelBubble=true;}};Event=HeadlessEvent;}else{function TrEvent(type,opt_bubbles,opt_preventable){var e=tr.doc.createEvent('Event');e.initEvent(type,!!opt_bubbles,!!opt_preventable);e.__proto__=global.Event.prototype;return e;};TrEvent.prototype={__proto__:global.Event.prototype};Event=TrEvent;}function dispatchSimpleEvent(target,type,opt_bubbles,opt_cancelable,opt_fields){var e=new tr.b.Event(type,opt_bubbles,opt_cancelable);if(opt_fields){tr.b.iterItems(opt_fields,function(name,value){e[name]=value;});}return target.dispatchEvent(e);}return{Event:Event,dispatchSimpleEvent:dispatchSimpleEvent};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./event_target.js":39}],39:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function EventTarget(){}EventTarget.decorate=function(target){for(var k in EventTarget.prototype){if(k=='decorate')continue;var v=EventTarget.prototype[k];if(typeof v!=='function')continue;target[k]=v;}};EventTarget.prototype={addEventListener:function(type,handler){if(!this.listeners_)this.listeners_=Object.create(null);if(!(type in this.listeners_)){this.listeners_[type]=[handler];}else{var handlers=this.listeners_[type];if(handlers.indexOf(handler)<0)handlers.push(handler);}},removeEventListener:function(type,handler){if(!this.listeners_)return;if(type in this.listeners_){var handlers=this.listeners_[type];var index=handlers.indexOf(handler);if(index>=0){if(handlers.length==1)delete this.listeners_[type];else handlers.splice(index,1);}}},dispatchEvent:function(event){if(!this.listeners_)return true;var self=this;event.__defineGetter__('target',function(){return self;});var realPreventDefault=event.preventDefault;event.preventDefault=function(){realPreventDefault.call(this);this.rawReturnValue=false;};var type=event.type;var prevented=0;if(type in this.listeners_){var handlers=this.listeners_[type].concat();for(var i=0,handler;handler=handlers[i];i++){if(handler.handleEvent)prevented|=handler.handleEvent.call(handler,event)===false;else prevented|=handler.call(this,event)===false;}}return!prevented&&event.rawReturnValue;},hasEventListener:function(type){return this.listeners_[type]!==undefined;}};var EventTargetHelper={decorate:function(target){for(var k in EventTargetHelper){if(k=='decorate')continue;var v=EventTargetHelper[k];if(typeof v!=='function')continue;target[k]=v;}target.listenerCounts_={};},addEventListener:function(type,listener,useCapture){this.__proto__.addEventListener.call(this,type,listener,useCapture);if(this.listenerCounts_[type]===undefined)this.listenerCounts_[type]=0;this.listenerCounts_[type]++;},removeEventListener:function(type,listener,useCapture){this.__proto__.removeEventListener.call(this,type,listener,useCapture);this.listenerCounts_[type]--;},hasEventListener:function(type){return this.listenerCounts_[type]>0;}};return{EventTarget:EventTarget,EventTargetHelper:EventTargetHelper};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],40:[function(require,module,exports){(function(global){"use strict";require("./event_target.js");require("./extension_registry_base.js");require("./extension_registry_basic.js");require("./extension_registry_type_based.js");require("./iteration_helpers.js");'use strict';global.tr.exportTo('tr.b',function(){function decorateExtensionRegistry(registry,registryOptions){if(registry.register)throw new Error('Already has registry');registryOptions.freeze();if(registryOptions.mode==tr.b.BASIC_REGISTRY_MODE){tr.b._decorateBasicExtensionRegistry(registry,registryOptions);}else if(registryOptions.mode==tr.b.TYPE_BASED_REGISTRY_MODE){tr.b._decorateTypeBasedExtensionRegistry(registry,registryOptions);}else{throw new Error('Unrecognized mode');}if(registry.addEventListener===undefined)tr.b.EventTarget.decorate(registry);}return{decorateExtensionRegistry:decorateExtensionRegistry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./event_target.js":39,"./extension_registry_base.js":41,"./extension_registry_basic.js":42,"./extension_registry_type_based.js":43,"./iteration_helpers.js":46}],41:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function RegisteredTypeInfo(constructor,metadata){this.constructor=constructor;this.metadata=metadata;};var BASIC_REGISTRY_MODE='BASIC_REGISTRY_MODE';var TYPE_BASED_REGISTRY_MODE='TYPE_BASED_REGISTRY_MODE';var ALL_MODES={BASIC_REGISTRY_MODE:true,TYPE_BASED_REGISTRY_MODE:true};function ExtensionRegistryOptions(mode){if(mode===undefined)throw new Error('Mode is required');if(!ALL_MODES[mode])throw new Error('Not a mode.');this.mode_=mode;this.defaultMetadata_={};this.defaultConstructor_=undefined;this.defaultTypeInfo_=undefined;this.frozen_=false;}ExtensionRegistryOptions.prototype={freeze:function(){if(this.frozen_)throw new Error('Frozen');this.frozen_=true;},get mode(){return this.mode_;},get defaultMetadata(){return this.defaultMetadata_;},set defaultMetadata(defaultMetadata){if(this.frozen_)throw new Error('Frozen');this.defaultMetadata_=defaultMetadata;this.defaultTypeInfo_=undefined;},get defaultConstructor(){return this.defaultConstructor_;},set defaultConstructor(defaultConstructor){if(this.frozen_)throw new Error('Frozen');this.defaultConstructor_=defaultConstructor;this.defaultTypeInfo_=undefined;},get defaultTypeInfo(){if(this.defaultTypeInfo_===undefined&&this.defaultConstructor_){this.defaultTypeInfo_=new RegisteredTypeInfo(this.defaultConstructor,this.defaultMetadata);}return this.defaultTypeInfo_;},validateConstructor:function(constructor){if(!this.mandatoryBaseClass)return;var curProto=constructor.prototype.__proto__;var ok=false;while(curProto){if(curProto===this.mandatoryBaseClass.prototype){ok=true;break;}curProto=curProto.__proto__;}if(!ok)throw new Error(constructor+'must be subclass of '+registry);}};return{BASIC_REGISTRY_MODE:BASIC_REGISTRY_MODE,TYPE_BASED_REGISTRY_MODE:TYPE_BASED_REGISTRY_MODE,ExtensionRegistryOptions:ExtensionRegistryOptions,RegisteredTypeInfo:RegisteredTypeInfo};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],42:[function(require,module,exports){(function(global){"use strict";require("./event.js");require("./extension_registry_base.js");'use strict';global.tr.exportTo('tr.b',function(){var RegisteredTypeInfo=tr.b.RegisteredTypeInfo;var ExtensionRegistryOptions=tr.b.ExtensionRegistryOptions;function decorateBasicExtensionRegistry(registry,extensionRegistryOptions){var savedStateStack=[];registry.registeredTypeInfos_=[];registry.register=function(constructor,opt_metadata){if(registry.findIndexOfRegisteredConstructor(constructor)!==undefined)throw new Error('Handler already registered for '+constructor);extensionRegistryOptions.validateConstructor(constructor);var metadata={};for(var k in extensionRegistryOptions.defaultMetadata)metadata[k]=extensionRegistryOptions.defaultMetadata[k];if(opt_metadata){for(var k in opt_metadata)metadata[k]=opt_metadata[k];}var typeInfo=new RegisteredTypeInfo(constructor,metadata);var e=new tr.b.Event('will-register');e.typeInfo=typeInfo;registry.dispatchEvent(e);registry.registeredTypeInfos_.push(typeInfo);e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.pushCleanStateBeforeTest=function(){savedStateStack.push(registry.registeredTypeInfos_);registry.registeredTypeInfos_=[];var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.popCleanStateAfterTest=function(){registry.registeredTypeInfos_=savedStateStack[0];savedStateStack.splice(0,1);var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.findIndexOfRegisteredConstructor=function(constructor){for(var i=0;i<registry.registeredTypeInfos_.length;i++)if(registry.registeredTypeInfos_[i].constructor==constructor)return i;return undefined;};registry.unregister=function(constructor){var foundIndex=registry.findIndexOfRegisteredConstructor(constructor);if(foundIndex===undefined)throw new Error(constructor+' not registered');registry.registeredTypeInfos_.splice(foundIndex,1);var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.getAllRegisteredTypeInfos=function(){return registry.registeredTypeInfos_;};registry.findTypeInfo=function(constructor){var foundIndex=this.findIndexOfRegisteredConstructor(constructor);if(foundIndex!==undefined)return this.registeredTypeInfos_[foundIndex];return undefined;};registry.findTypeInfoMatching=function(predicate,opt_this){opt_this=opt_this?opt_this:undefined;for(var i=0;i<registry.registeredTypeInfos_.length;++i){var typeInfo=registry.registeredTypeInfos_[i];if(predicate.call(opt_this,typeInfo))return typeInfo;}return extensionRegistryOptions.defaultTypeInfo;};registry.findTypeInfoWithName=function(name){if(typeof name!=='string')throw new Error('Name is not a string.');var typeInfo=registry.findTypeInfoMatching(function(ti){return ti.constructor.name===name;});if(typeInfo)return typeInfo;return undefined;};}return{_decorateBasicExtensionRegistry:decorateBasicExtensionRegistry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./event.js":38,"./extension_registry_base.js":41}],43:[function(require,module,exports){(function(global){"use strict";require("./category_util.js");require("./event.js");require("./extension_registry_base.js");'use strict';global.tr.exportTo('tr.b',function(){var getCategoryParts=tr.b.getCategoryParts;var RegisteredTypeInfo=tr.b.RegisteredTypeInfo;var ExtensionRegistryOptions=tr.b.ExtensionRegistryOptions;function decorateTypeBasedExtensionRegistry(registry,extensionRegistryOptions){var savedStateStack=[];registry.registeredTypeInfos_=[];registry.categoryPartToTypeInfoMap_=new Map();registry.typeNameToTypeInfoMap_=new Map();registry.register=function(constructor,metadata){extensionRegistryOptions.validateConstructor(constructor);var typeInfo=new RegisteredTypeInfo(constructor,metadata||extensionRegistryOptions.defaultMetadata);typeInfo.typeNames=[];typeInfo.categoryParts=[];if(metadata&&metadata.typeName)typeInfo.typeNames.push(metadata.typeName);if(metadata&&metadata.typeNames){typeInfo.typeNames.push.apply(typeInfo.typeNames,metadata.typeNames);}if(metadata&&metadata.categoryParts){typeInfo.categoryParts.push.apply(typeInfo.categoryParts,metadata.categoryParts);}if(typeInfo.typeNames.length===0&&typeInfo.categoryParts.length===0)throw new Error('typeName or typeNames must be provided');typeInfo.typeNames.forEach(function(typeName){if(registry.typeNameToTypeInfoMap_.has(typeName))throw new Error('typeName '+typeName+' already registered');});typeInfo.categoryParts.forEach(function(categoryPart){if(registry.categoryPartToTypeInfoMap_.has(categoryPart)){throw new Error('categoryPart '+categoryPart+' already registered');}});var e=new tr.b.Event('will-register');e.typeInfo=typeInfo;registry.dispatchEvent(e);typeInfo.typeNames.forEach(function(typeName){registry.typeNameToTypeInfoMap_.set(typeName,typeInfo);});typeInfo.categoryParts.forEach(function(categoryPart){registry.categoryPartToTypeInfoMap_.set(categoryPart,typeInfo);});registry.registeredTypeInfos_.push(typeInfo);var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.pushCleanStateBeforeTest=function(){savedStateStack.push({registeredTypeInfos:registry.registeredTypeInfos_,typeNameToTypeInfoMap:registry.typeNameToTypeInfoMap_,categoryPartToTypeInfoMap:registry.categoryPartToTypeInfoMap_});registry.registeredTypeInfos_=[];registry.typeNameToTypeInfoMap_=new Map();registry.categoryPartToTypeInfoMap_=new Map();var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.popCleanStateAfterTest=function(){var state=savedStateStack[0];savedStateStack.splice(0,1);registry.registeredTypeInfos_=state.registeredTypeInfos;registry.typeNameToTypeInfoMap_=state.typeNameToTypeInfoMap;registry.categoryPartToTypeInfoMap_=state.categoryPartToTypeInfoMap;var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.unregister=function(constructor){var typeInfoIndex=-1;for(var i=0;i<registry.registeredTypeInfos_.length;i++){if(registry.registeredTypeInfos_[i].constructor==constructor){typeInfoIndex=i;break;}}if(typeInfoIndex===-1)throw new Error(constructor+' not registered');var typeInfo=registry.registeredTypeInfos_[typeInfoIndex];registry.registeredTypeInfos_.splice(typeInfoIndex,1);typeInfo.typeNames.forEach(function(typeName){registry.typeNameToTypeInfoMap_.delete(typeName);});typeInfo.categoryParts.forEach(function(categoryPart){registry.categoryPartToTypeInfoMap_.delete(categoryPart);});var e=new tr.b.Event('registry-changed');registry.dispatchEvent(e);};registry.getTypeInfo=function(category,typeName){if(category){var categoryParts=getCategoryParts(category);for(var i=0;i<categoryParts.length;i++){var categoryPart=categoryParts[i];var typeInfo=registry.categoryPartToTypeInfoMap_.get(categoryPart);if(typeInfo!==undefined)return typeInfo;}}var typeInfo=registry.typeNameToTypeInfoMap_.get(typeName);if(typeInfo!==undefined)return typeInfo;return extensionRegistryOptions.defaultTypeInfo;};registry.getConstructor=function(category,typeName){var typeInfo=registry.getTypeInfo(category,typeName);if(typeInfo)return typeInfo.constructor;return undefined;};}return{_decorateTypeBasedExtensionRegistry:decorateTypeBasedExtensionRegistry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./category_util.js":35,"./event.js":38,"./extension_registry_base.js":41}],44:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){var nextGUID=1;var UUID4_PATTERN='xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx';var GUID={allocateSimple:function(){return nextGUID++;},getLastSimpleGuid:function(){return nextGUID-1;},allocateUUID4:function(){return UUID4_PATTERN.replace(/[xy]/g,function(c){var r=parseInt(Math.random()*16);if(c==='y')r=(r&3)+8;return r.toString(16);});}};return{GUID:GUID};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],45:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function max(a,b){if(a===undefined)return b;if(b===undefined)return a;return Math.max(a,b);}function IntervalTree(beginPositionCb,endPositionCb){this.beginPositionCb_=beginPositionCb;this.endPositionCb_=endPositionCb;this.root_=undefined;this.size_=0;}IntervalTree.prototype={insert:function(datum){var startPosition=this.beginPositionCb_(datum);var endPosition=this.endPositionCb_(datum);var node=new IntervalTreeNode(datum,startPosition,endPosition);this.size_++;this.root_=this.insertNode_(this.root_,node);this.root_.colour=Colour.BLACK;return datum;},insertNode_:function(root,node){if(root===undefined)return node;if(root.leftNode&&root.leftNode.isRed&&root.rightNode&&root.rightNode.isRed)this.flipNodeColour_(root);if(node.key<root.key)root.leftNode=this.insertNode_(root.leftNode,node);else if(node.key===root.key)root.merge(node);else root.rightNode=this.insertNode_(root.rightNode,node);if(root.rightNode&&root.rightNode.isRed&&(root.leftNode===undefined||!root.leftNode.isRed))root=this.rotateLeft_(root);if(root.leftNode&&root.leftNode.isRed&&root.leftNode.leftNode&&root.leftNode.leftNode.isRed)root=this.rotateRight_(root);return root;},rotateRight_:function(node){var sibling=node.leftNode;node.leftNode=sibling.rightNode;sibling.rightNode=node;sibling.colour=node.colour;node.colour=Colour.RED;return sibling;},rotateLeft_:function(node){var sibling=node.rightNode;node.rightNode=sibling.leftNode;sibling.leftNode=node;sibling.colour=node.colour;node.colour=Colour.RED;return sibling;},flipNodeColour_:function(node){node.colour=this.flipColour_(node.colour);node.leftNode.colour=this.flipColour_(node.leftNode.colour);node.rightNode.colour=this.flipColour_(node.rightNode.colour);},flipColour_:function(colour){return colour===Colour.RED?Colour.BLACK:Colour.RED;},updateHighValues:function(){this.updateHighValues_(this.root_);},updateHighValues_:function(node){if(node===undefined)return undefined;node.maxHighLeft=this.updateHighValues_(node.leftNode);node.maxHighRight=this.updateHighValues_(node.rightNode);return max(max(node.maxHighLeft,node.highValue),node.maxHighRight);},validateFindArguments_:function(queryLow,queryHigh){if(queryLow===undefined||queryHigh===undefined)throw new Error('queryLow and queryHigh must be defined');if(typeof queryLow!=='number'||typeof queryHigh!=='number')throw new Error('queryLow and queryHigh must be numbers');},findIntersection:function(queryLow,queryHigh){this.validateFindArguments_(queryLow,queryHigh);if(this.root_===undefined)return[];var ret=[];this.root_.appendIntersectionsInto_(ret,queryLow,queryHigh);return ret;},get size(){return this.size_;},get root(){return this.root_;},dump_:function(){if(this.root_===undefined)return[];return this.root_.dump();}};var Colour={RED:'red',BLACK:'black'};function IntervalTreeNode(datum,lowValue,highValue){this.lowValue_=lowValue;this.data_=[{datum:datum,high:highValue,low:lowValue}];this.colour_=Colour.RED;this.parentNode_=undefined;this.leftNode_=undefined;this.rightNode_=undefined;this.maxHighLeft_=undefined;this.maxHighRight_=undefined;}IntervalTreeNode.prototype={appendIntersectionsInto_:function(ret,queryLow,queryHigh){if(this.lowValue_>=queryHigh){if(!this.leftNode_)return;return this.leftNode_.appendIntersectionsInto_(ret,queryLow,queryHigh);}if(this.maxHighLeft_>queryLow){this.leftNode_.appendIntersectionsInto_(ret,queryLow,queryHigh);}if(this.highValue>queryLow){for(var i=this.data.length-1;i>=0;--i){if(this.data[i].high<queryLow)break;ret.push(this.data[i].datum);}}if(this.rightNode_){this.rightNode_.appendIntersectionsInto_(ret,queryLow,queryHigh);}},get colour(){return this.colour_;},set colour(colour){this.colour_=colour;},get key(){return this.lowValue_;},get lowValue(){return this.lowValue_;},get highValue(){return this.data_[this.data_.length-1].high;},set leftNode(left){this.leftNode_=left;},get leftNode(){return this.leftNode_;},get hasLeftNode(){return this.leftNode_!==undefined;},set rightNode(right){this.rightNode_=right;},get rightNode(){return this.rightNode_;},get hasRightNode(){return this.rightNode_!==undefined;},set parentNode(parent){this.parentNode_=parent;},get parentNode(){return this.parentNode_;},get isRootNode(){return this.parentNode_===undefined;},set maxHighLeft(high){this.maxHighLeft_=high;},get maxHighLeft(){return this.maxHighLeft_;},set maxHighRight(high){this.maxHighRight_=high;},get maxHighRight(){return this.maxHighRight_;},get data(){return this.data_;},get isRed(){return this.colour_===Colour.RED;},merge:function(node){for(var i=0;i<node.data.length;i++)this.data_.push(node.data[i]);this.data_.sort(function(a,b){return a.high-b.high;});},dump:function(){var ret={};if(this.leftNode_)ret['left']=this.leftNode_.dump();ret['data']=this.data_.map(function(d){return[d.low,d.high];});if(this.rightNode_)ret['right']=this.rightNode_.dump();return ret;}};return{IntervalTree:IntervalTree};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],46:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function asArray(x){var values=[];if(x[Symbol.iterator])for(var value of x)values.push(value);else for(var i=0;i<x.length;i++)values.push(x[i]);return values;}function getOnlyElement(iterable){var iterator=iterable[Symbol.iterator]();var firstIteration=iterator.next();if(firstIteration.done)throw new Error('getOnlyElement was passed an empty iterable.');var secondIteration=iterator.next();if(!secondIteration.done)throw new Error('getOnlyElement was passed an iterable with multiple elements.');return firstIteration.value;}function getFirstElement(iterable){var iterator=iterable[Symbol.iterator]();var result=iterator.next();if(result.done)throw new Error('getFirstElement was passed an empty iterable.');return result.value;}function compareArrays(x,y,elementCmp){var minLength=Math.min(x.length,y.length);for(var i=0;i<minLength;i++){var tmp=elementCmp(x[i],y[i]);if(tmp)return tmp;}if(x.length==y.length)return 0;if(x[i]===undefined)return-1;return 1;}function comparePossiblyUndefinedValues(x,y,cmp,opt_this){if(x!==undefined&&y!==undefined)return cmp.call(opt_this,x,y);if(x!==undefined)return-1;if(y!==undefined)return 1;return 0;}function compareNumericWithNaNs(x,y){if(!isNaN(x)&&!isNaN(y))return x-y;if(isNaN(x))return 1;if(isNaN(y))return-1;return 0;}function concatenateArrays(){var values=[];for(var i=0;i<arguments.length;i++){if(!(arguments[i]instanceof Array))throw new Error('Arguments '+i+'is not an array');values.push.apply(values,arguments[i]);}return values;}function concatenateObjects(){var result={};for(var i=0;i<arguments.length;i++){var object=arguments[i];for(var j in object){result[j]=object[j];}}return result;}function cloneDictionary(dict){var clone={};for(var k in dict){clone[k]=dict[k];}return clone;}function dictionaryKeys(dict){var keys=[];for(var key in dict)keys.push(key);return keys;}function dictionaryValues(dict){var values=[];for(var key in dict)values.push(dict[key]);return values;}function dictionaryLength(dict){var n=0;for(var key in dict)n++;return n;}function dictionaryContainsValue(dict,value){for(var key in dict)if(dict[key]===value)return true;return false;}function every(iterable,predicate){for(var x of iterable)if(!predicate(x))return false;return true;}function group(ary,callback,opt_this,opt_arrayConstructor){var arrayConstructor=opt_arrayConstructor||Array;var results={};for(var element of ary){var key=callback.call(opt_this,element);if(!(key in results))results[key]=new arrayConstructor();results[key].push(element);}return results;}function groupIntoMap(ary,callback,opt_this,opt_arrayConstructor){var arrayConstructor=opt_arrayConstructor||Array;var results=new Map();for(var element of ary){var key=callback.call(opt_this,element);var items=results.get(key);if(items===undefined){items=new arrayConstructor();results.set(key,items);}items.push(element);}return results;}function iterItems(dict,fn,opt_this){opt_this=opt_this||this;var keys=Object.keys(dict);for(var i=0;i<keys.length;i++){var key=keys[i];fn.call(opt_this,key,dict[key]);}}function mapItems(dict,fn,opt_this){opt_this=opt_this||this;var result={};var keys=Object.keys(dict);for(var i=0;i<keys.length;i++){var key=keys[i];result[key]=fn.call(opt_this,key,dict[key]);}return result;}function filterItems(dict,predicate,opt_this){opt_this=opt_this||this;var result={};var keys=Object.keys(dict);for(var i=0;i<keys.length;i++){var key=keys[i];var value=dict[key];if(predicate.call(opt_this,key,value))result[key]=value;}return result;}function iterObjectFieldsRecursively(object,func){if(!(object instanceof Object))return;if(object instanceof Array){for(var i=0;i<object.length;i++){func(object,i,object[i]);iterObjectFieldsRecursively(object[i],func);}return;}for(var key in object){var value=object[key];func(object,key,value);iterObjectFieldsRecursively(value,func);}}function invertArrayOfDicts(array,opt_dictGetter,opt_this){opt_this=opt_this||this;var result={};for(var i=0;i<array.length;i++){var item=array[i];if(item===undefined)continue;var dict=opt_dictGetter?opt_dictGetter.call(opt_this,item):item;if(dict===undefined)continue;for(var key in dict){var valueList=result[key];if(valueList===undefined)result[key]=valueList=new Array(array.length);valueList[i]=dict[key];}}return result;}function arrayToDict(array,valueToKeyFn,opt_this){opt_this=opt_this||this;var result={};var length=array.length;for(var i=0;i<length;i++){var value=array[i];var key=valueToKeyFn.call(opt_this,value);result[key]=value;}return result;}function identity(d){return d;}function findFirstIndexInArray(ary,opt_func,opt_this){var func=opt_func||identity;for(var i=0;i<ary.length;i++){if(func.call(opt_this,ary[i],i))return i;}return-1;}function findFirstInArray(ary,opt_func,opt_this){var i=findFirstIndexInArray(ary,opt_func,opt_func);if(i===-1)return undefined;return ary[i];}function findFirstKeyInDictMatching(dict,opt_func,opt_this){var func=opt_func||identity;for(var key in dict){if(func.call(opt_this,key,dict[key]))return key;}return undefined;}function mapValues(map){var values=[];for(var value of map.values())values.push(value);return values;}function iterMapItems(map,fn,opt_this){opt_this=opt_this||this;for(var key of map.keys())fn.call(opt_this,key,map.get(key));}return{asArray:asArray,concatenateArrays:concatenateArrays,concatenateObjects:concatenateObjects,compareArrays:compareArrays,comparePossiblyUndefinedValues:comparePossiblyUndefinedValues,compareNumericWithNaNs:compareNumericWithNaNs,cloneDictionary:cloneDictionary,dictionaryLength:dictionaryLength,dictionaryKeys:dictionaryKeys,dictionaryValues:dictionaryValues,dictionaryContainsValue:dictionaryContainsValue,every:every,getOnlyElement:getOnlyElement,getFirstElement:getFirstElement,group:group,groupIntoMap:groupIntoMap,iterItems:iterItems,mapItems:mapItems,filterItems:filterItems,iterObjectFieldsRecursively:iterObjectFieldsRecursively,invertArrayOfDicts:invertArrayOfDicts,arrayToDict:arrayToDict,identity:identity,findFirstIndexInArray:findFirstIndexInArray,findFirstInArray:findFirstInArray,findFirstKeyInDictMatching:findFirstKeyInDictMatching,mapValues:mapValues,iterMapItems:iterMapItems};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],47:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';(function(){if(tr.isNode){var glMatrixAbsPath=HTMLImportsLoader.hrefToAbsolutePath('/gl-matrix-min.js');var glMatrixModule=require(glMatrixAbsPath);for(var exportName in glMatrixModule){global[exportName]=glMatrixModule[exportName];}}})(this);'use strict';global.tr.exportTo('tr.b',function(){function approximately(x,y,delta){if(delta===undefined)delta=1e-9;return Math.abs(x-y)<delta;}function clamp(x,lo,hi){return Math.min(Math.max(x,lo),hi);}function lerp(percentage,lo,hi){var range=hi-lo;return lo+percentage*range;}function normalize(value,lo,hi){return(value-lo)/(hi-lo);}function deg2rad(deg){return Math.PI*deg/180.0;}function erf(x){var sign=x>=0?1:-1;x=Math.abs(x);var a1=0.254829592;var a2=-0.284496736;var a3=1.421413741;var a4=-1.453152027;var a5=1.061405429;var p=0.3275911;var t=1.0/(1.0+p*x);var y=1.0-((((a5*t+a4)*t+a3)*t+a2)*t+a1)*t*Math.exp(-x*x);return sign*y;}var tmpVec2=vec2.create();var tmpVec2b=vec2.create();var tmpVec4=vec4.create();var tmpMat2d=mat2d.create();vec2.createFromArray=function(arr){if(arr.length!=2)throw new Error('Should be length 2');var v=vec2.create();vec2.set(v,arr[0],arr[1]);return v;};vec2.createXY=function(x,y){var v=vec2.create();vec2.set(v,x,y);return v;};vec2.toString=function(a){return'['+a[0]+', '+a[1]+']';};vec2.addTwoScaledUnitVectors=function(out,u1,scale1,u2,scale2){vec2.scale(tmpVec2,u1,scale1);vec2.scale(tmpVec2b,u2,scale2);vec2.add(out,tmpVec2,tmpVec2b);};vec2.interpolatePiecewiseFunction=function(points,x){if(x<points[0][0])return points[0][1];for(var i=1;i<points.length;++i){if(x<points[i][0]){var percent=normalize(x,points[i-1][0],points[i][0]);return lerp(percent,points[i-1][1],points[i][1]);}}return points[points.length-1][1];};vec3.createXYZ=function(x,y,z){var v=vec3.create();vec3.set(v,x,y,z);return v;};vec3.toString=function(a){return'vec3('+a[0]+', '+a[1]+', '+a[2]+')';};mat2d.translateXY=function(out,x,y){vec2.set(tmpVec2,x,y);mat2d.translate(out,out,tmpVec2);};mat2d.scaleXY=function(out,x,y){vec2.set(tmpVec2,x,y);mat2d.scale(out,out,tmpVec2);};vec4.unitize=function(out,a){out[0]=a[0]/a[3];out[1]=a[1]/a[3];out[2]=a[2]/a[3];out[3]=1;return out;};vec2.copyFromVec4=function(out,a){vec4.unitize(tmpVec4,a);vec2.copy(out,tmpVec4);};return{approximately:approximately,clamp:clamp,lerp:lerp,normalize:normalize,deg2rad:deg2rad,erf:erf};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],48:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function MultiDimensionalViewNode(title,valueCount){this.title=title;var dimensions=title.length;this.children=new Array(dimensions);for(var i=0;i<dimensions;i++)this.children[i]=new Map();this.values=new Array(valueCount);for(var v=0;v<valueCount;v++)this.values[v]={self:0,total:0,totalState:NOT_PROVIDED};}MultiDimensionalViewNode.TotalState={NOT_PROVIDED:0,LOWER_BOUND:1,EXACT:2};var NOT_PROVIDED=MultiDimensionalViewNode.TotalState.NOT_PROVIDED;var LOWER_BOUND=MultiDimensionalViewNode.TotalState.LOWER_BOUND;var EXACT=MultiDimensionalViewNode.TotalState.EXACT;MultiDimensionalViewNode.prototype={get subRows(){return tr.b.mapValues(this.children[0]);}};function MultiDimensionalViewBuilder(dimensions,valueCount){if(typeof dimensions!=='number'||dimensions<0)throw new Error('Dimensions must be a non-negative number');this.dimensions_=dimensions;if(typeof valueCount!=='number'||valueCount<0)throw new Error('Number of values must be a non-negative number');this.valueCount_=valueCount;this.buildRoot_=this.createRootNode_();this.topDownTreeViewRoot_=undefined;this.topDownHeavyViewRoot_=undefined;this.bottomUpHeavyViewNode_=undefined;this.maxDimensionDepths_=new Array(dimensions);for(var d=0;d<dimensions;d++)this.maxDimensionDepths_[d]=0;}MultiDimensionalViewBuilder.ValueKind={SELF:0,TOTAL:1};MultiDimensionalViewBuilder.ViewType={TOP_DOWN_TREE_VIEW:0,TOP_DOWN_HEAVY_VIEW:1,BOTTOM_UP_HEAVY_VIEW:2};MultiDimensionalViewBuilder.prototype={addPath:function(path,values,valueKind){if(this.buildRoot_===undefined){throw new Error('Paths cannot be added after either view has been built');}if(path.length!==this.dimensions_)throw new Error('Path must be '+this.dimensions_+'-dimensional');if(values.length!==this.valueCount_)throw new Error('Must provide '+this.valueCount_+' values');var isTotal;switch(valueKind){case MultiDimensionalViewBuilder.ValueKind.SELF:isTotal=false;break;case MultiDimensionalViewBuilder.ValueKind.TOTAL:isTotal=true;break;default:throw new Error('Invalid value kind: '+valueKind);}var node=this.buildRoot_;for(var d=0;d<path.length;d++){var singleDimensionPath=path[d];var singleDimensionPathLength=singleDimensionPath.length;this.maxDimensionDepths_[d]=Math.max(this.maxDimensionDepths_[d],singleDimensionPathLength);for(var i=0;i<singleDimensionPathLength;i++)node=this.getOrCreateChildNode_(node,d,singleDimensionPath[i]);}for(var v=0;v<this.valueCount_;v++){var addedValue=values[v];if(addedValue===undefined)continue;var nodeValue=node.values[v];if(isTotal){nodeValue.total+=addedValue;nodeValue.totalState=EXACT;}else{nodeValue.self+=addedValue;nodeValue.totalState=Math.max(nodeValue.totalState,LOWER_BOUND);}}},buildView:function(viewType){switch(viewType){case MultiDimensionalViewBuilder.ViewType.TOP_DOWN_TREE_VIEW:return this.buildTopDownTreeView();case MultiDimensionalViewBuilder.ViewType.TOP_DOWN_HEAVY_VIEW:return this.buildTopDownHeavyView();case MultiDimensionalViewBuilder.ViewType.BOTTOM_UP_HEAVY_VIEW:return this.buildBottomUpHeavyView();default:throw new Error('Unknown multi-dimensional view type: '+viewType);}},buildTopDownTreeView:function(){if(this.topDownTreeViewRoot_===undefined){var treeViewRoot=this.buildRoot_;this.buildRoot_=undefined;this.setUpMissingChildRelationships_(treeViewRoot,0);this.finalizeTotalValues_(treeViewRoot,0,new WeakMap());this.topDownTreeViewRoot_=treeViewRoot;}return this.topDownTreeViewRoot_;},buildTopDownHeavyView:function(){if(this.topDownHeavyViewRoot_===undefined){this.topDownHeavyViewRoot_=this.buildGenericHeavyView_(this.addDimensionToTopDownHeavyViewNode_.bind(this));}return this.topDownHeavyViewRoot_;},buildBottomUpHeavyView:function(){if(this.bottomUpHeavyViewNode_===undefined){this.bottomUpHeavyViewNode_=this.buildGenericHeavyView_(this.addDimensionToBottomUpHeavyViewNode_.bind(this));}return this.bottomUpHeavyViewNode_;},createRootNode_:function(){return new MultiDimensionalViewNode(new Array(this.dimensions_),this.valueCount_);},getOrCreateChildNode_:function(parentNode,dimension,childDimensionTitle){if(dimension<0||dimension>=this.dimensions_)throw new Error('Invalid dimension');var dimensionChildren=parentNode.children[dimension];var childNode=dimensionChildren.get(childDimensionTitle);if(childNode!==undefined)return childNode;var childTitle=parentNode.title.slice();childTitle[dimension]=childDimensionTitle;childNode=new MultiDimensionalViewNode(childTitle,this.valueCount_);dimensionChildren.set(childDimensionTitle,childNode);return childNode;},setUpMissingChildRelationships_:function(node,firstDimensionToSetUp){for(var d=firstDimensionToSetUp;d<this.dimensions_;d++){var currentDimensionChildTitles=new Set(node.children[d].keys());for(var i=0;i<d;i++){for(var previousDimensionChildNode of node.children[i].values()){for(var previousDimensionGrandChildTitle of previousDimensionChildNode.children[d].keys()){currentDimensionChildTitles.add(previousDimensionGrandChildTitle);}}}for(var currentDimensionChildTitle of currentDimensionChildTitles){var currentDimensionChildNode=this.getOrCreateChildNode_(node,d,currentDimensionChildTitle);for(var i=0;i<d;i++){for(var previousDimensionChildNode of node.children[i].values()){var previousDimensionGrandChildNode=previousDimensionChildNode.children[d].get(currentDimensionChildTitle);if(previousDimensionGrandChildNode!==undefined){currentDimensionChildNode.children[i].set(previousDimensionChildNode.title[i],previousDimensionGrandChildNode);}}}this.setUpMissingChildRelationships_(currentDimensionChildNode,d);}}},finalizeTotalValues_:function(node,firstDimensionToFinalize,dimensionalSelfSumsMap){var dimensionalSelfSums=new Array(this.dimensions_);var minResidual=new Array(this.valueCount_);for(var v=0;v<this.valueCount_;v++)minResidual[v]=0;var nodeValues=node.values;var nodeSelfSums=new Array(this.valueCount_);for(var v=0;v<this.valueCount_;v++)nodeSelfSums[v]=nodeValues[v].self;for(var d=0;d<this.dimensions_;d++){var childResidualSums=new Array(this.valueCount_);for(var v=0;v<this.valueCount_;v++)childResidualSums[v]=0;for(var childNode of node.children[d].values()){if(d>=firstDimensionToFinalize)this.finalizeTotalValues_(childNode,d,dimensionalSelfSumsMap);var childNodeSelfSums=dimensionalSelfSumsMap.get(childNode);var childNodeValues=childNode.values;for(var v=0;v<this.valueCount_;v++){nodeSelfSums[v]+=childNodeSelfSums[d][v];var residual=childNodeValues[v].total-childNodeSelfSums[this.dimensions_-1][v];childResidualSums[v]+=residual;if(childNodeValues[v].totalState>NOT_PROVIDED){nodeValues[v].totalState=Math.max(nodeValues[v].totalState,LOWER_BOUND);}}}dimensionalSelfSums[d]=nodeSelfSums.slice();for(var v=0;v<this.valueCount_;v++)minResidual[v]=Math.max(minResidual[v],childResidualSums[v]);}for(var v=0;v<this.valueCount_;v++){nodeValues[v].total=Math.max(nodeValues[v].total,nodeSelfSums[v]+minResidual[v]);}if(dimensionalSelfSumsMap.has(node))throw new Error('Internal error: Node finalized more than once');dimensionalSelfSumsMap.set(node,dimensionalSelfSums);},buildGenericHeavyView_:function(treeViewNodeHandler){var treeViewRoot=this.buildTopDownTreeView();var heavyViewRoot=this.createRootNode_();heavyViewRoot.values=treeViewRoot.values;var recursionDepthTrackers=new Array(this.dimensions_);for(var d=0;d<this.dimensions_;d++){recursionDepthTrackers[d]=new RecursionDepthTracker(this.maxDimensionDepths_[d],d);}this.addDimensionsToGenericHeavyViewNode_(treeViewRoot,heavyViewRoot,0,recursionDepthTrackers,false,treeViewNodeHandler);this.setUpMissingChildRelationships_(heavyViewRoot,0);return heavyViewRoot;},addDimensionsToGenericHeavyViewNode_:function(treeViewParentNode,heavyViewParentNode,startDimension,recursionDepthTrackers,previousDimensionsRecursive,treeViewNodeHandler){for(var d=startDimension;d<this.dimensions_;d++){this.addDimensionDescendantsToGenericHeavyViewNode_(treeViewParentNode,heavyViewParentNode,d,recursionDepthTrackers,previousDimensionsRecursive,treeViewNodeHandler);}},addDimensionDescendantsToGenericHeavyViewNode_:function(treeViewParentNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,treeViewNodeHandler){var treeViewChildren=treeViewParentNode.children[currentDimension];var recursionDepthTracker=recursionDepthTrackers[currentDimension];for(var treeViewChildNode of treeViewChildren.values()){recursionDepthTracker.push(treeViewChildNode);treeViewNodeHandler(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive);this.addDimensionDescendantsToGenericHeavyViewNode_(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,treeViewNodeHandler);recursionDepthTracker.pop();}},addDimensionToTopDownHeavyViewNode_:function(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive){this.addDimensionToTopDownHeavyViewNodeRecursively_(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,1);},addDimensionToTopDownHeavyViewNodeRecursively_:function(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,subTreeDepth){var recursionDepthTracker=recursionDepthTrackers[currentDimension];var currentDimensionRecursive=subTreeDepth<=recursionDepthTracker.recursionDepth;var currentOrPreviousDimensionsRecursive=currentDimensionRecursive||previousDimensionsRecursive;var dimensionTitle=treeViewChildNode.title[currentDimension];var heavyViewChildNode=this.getOrCreateChildNode_(heavyViewParentNode,currentDimension,dimensionTitle);this.addNodeValues_(treeViewChildNode,heavyViewChildNode,!currentOrPreviousDimensionsRecursive);this.addDimensionsToGenericHeavyViewNode_(treeViewChildNode,heavyViewChildNode,currentDimension+1,recursionDepthTrackers,currentOrPreviousDimensionsRecursive,this.addDimensionToTopDownHeavyViewNode_.bind(this));for(var treeViewGrandChildNode of treeViewChildNode.children[currentDimension].values()){recursionDepthTracker.push(treeViewGrandChildNode);this.addDimensionToTopDownHeavyViewNodeRecursively_(treeViewGrandChildNode,heavyViewChildNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive,subTreeDepth+1);recursionDepthTracker.pop();}},addDimensionToBottomUpHeavyViewNode_:function(treeViewChildNode,heavyViewParentNode,currentDimension,recursionDepthTrackers,previousDimensionsRecursive){var recursionDepthTracker=recursionDepthTrackers[currentDimension];var bottomIndex=recursionDepthTracker.bottomIndex;var topIndex=recursionDepthTracker.topIndex;var firstNonRecursiveIndex=bottomIndex+recursionDepthTracker.recursionDepth;var viewNodePath=recursionDepthTracker.viewNodePath;var trackerAncestorNode=recursionDepthTracker.trackerAncestorNode;var heavyViewDescendantNode=heavyViewParentNode;for(var i=bottomIndex;i<topIndex;i++){var treeViewAncestorNode=viewNodePath[i];var dimensionTitle=treeViewAncestorNode.title[currentDimension];heavyViewDescendantNode=this.getOrCreateChildNode_(heavyViewDescendantNode,currentDimension,dimensionTitle);var currentDimensionRecursive=i<firstNonRecursiveIndex;var currentOrPreviousDimensionsRecursive=currentDimensionRecursive||previousDimensionsRecursive;this.addNodeValues_(treeViewChildNode,heavyViewDescendantNode,!currentOrPreviousDimensionsRecursive);this.addDimensionsToGenericHeavyViewNode_(treeViewChildNode,heavyViewDescendantNode,currentDimension+1,recursionDepthTrackers,currentOrPreviousDimensionsRecursive,this.addDimensionToBottomUpHeavyViewNode_.bind(this));}},addNodeValues_:function(sourceNode,targetNode,addTotal){var targetNodeValues=targetNode.values;var sourceNodeValues=sourceNode.values;for(var v=0;v<this.valueCount_;v++){var targetNodeValue=targetNodeValues[v];var sourceNodeValue=sourceNodeValues[v];targetNodeValue.self+=sourceNodeValue.self;if(addTotal){targetNodeValue.total+=sourceNodeValue.total;if(sourceNodeValue.totalState>NOT_PROVIDED){targetNodeValue.totalState=Math.max(targetNodeValue.totalState,LOWER_BOUND);}}}}};function RecursionDepthTracker(maxDepth,dimension){this.titlePath=new Array(maxDepth);this.viewNodePath=new Array(maxDepth);this.bottomIndex=this.topIndex=maxDepth;this.dimension_=dimension;this.currentTrackerNode_=this.createNode_(0,undefined);}RecursionDepthTracker.prototype={push:function(viewNode){if(this.bottomIndex===0)throw new Error('Cannot push to a full tracker');var title=viewNode.title[this.dimension_];this.bottomIndex--;this.titlePath[this.bottomIndex]=title;this.viewNodePath[this.bottomIndex]=viewNode;var childTrackerNode=this.currentTrackerNode_.children.get(title);if(childTrackerNode!==undefined){this.currentTrackerNode_=childTrackerNode;return;}var maxLengths=zFunction(this.titlePath,this.bottomIndex);var recursionDepth=0;for(var i=0;i<maxLengths.length;i++)recursionDepth=Math.max(recursionDepth,maxLengths[i]);childTrackerNode=this.createNode_(recursionDepth,this.currentTrackerNode_);this.currentTrackerNode_.children.set(title,childTrackerNode);this.currentTrackerNode_=childTrackerNode;},pop:function(){if(this.bottomIndex===this.topIndex)throw new Error('Cannot pop from an empty tracker');this.titlePath[this.bottomIndex]=undefined;this.viewNodePath[this.bottomIndex]=undefined;this.bottomIndex++;this.currentTrackerNode_=this.currentTrackerNode_.parent;},get recursionDepth(){return this.currentTrackerNode_.recursionDepth;},createNode_:function(recursionDepth,parent){return{recursionDepth:recursionDepth,parent:parent,children:new Map()};}};function zFunction(list,startIndex){var n=list.length-startIndex;if(n===0)return[];var z=new Array(n);z[0]=0;for(var i=1,left=0,right=0;i<n;++i){var maxLength;if(i<=right)maxLength=Math.min(right-i+1,z[i-left]);else maxLength=0;while(i+maxLength<n&&list[startIndex+maxLength]===list[startIndex+i+maxLength]){++maxLength;}if(i+maxLength-1>right){left=i;right=i+maxLength-1;}z[i]=maxLength;}return z;}return{MultiDimensionalViewBuilder:MultiDimensionalViewBuilder,MultiDimensionalViewNode:MultiDimensionalViewNode,RecursionDepthTracker:RecursionDepthTracker,zFunction:zFunction};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],49:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){var PERCENTILE_PRECISION=1e-7;function PiecewiseLinearFunction(){this.pieces=[];}PiecewiseLinearFunction.prototype={push:function(x1,y1,x2,y2){if(x1>=x2)throw new Error('Invalid segment');if(this.pieces.length>0&&this.pieces[this.pieces.length-1].x2>x1){throw new Error('Potentially overlapping segments');}if(x1<x2)this.pieces.push(new Piece(x1,y1,x2,y2));},partBelow:function(y){return this.pieces.reduce((acc,p)=>acc+p.partBelow(y),0);},get min(){return this.pieces.reduce((acc,p)=>Math.min(acc,p.min),Infinity);},get max(){return this.pieces.reduce((acc,p)=>Math.max(acc,p.max),-Infinity);},get average(){var weightedSum=0;var totalWeight=0;this.pieces.forEach(function(piece){weightedSum+=piece.width*piece.average;totalWeight+=piece.width;});if(totalWeight===0)return 0;return weightedSum/totalWeight;},percentile:function(percent){if(!(percent>=0&&percent<=1))throw new Error('percent must be [0,1]');var lower=this.min;var upper=this.max;var total=this.partBelow(upper);if(total===0)return 0;while(upper-lower>PERCENTILE_PRECISION){var middle=(lower+upper)/2;var below=this.partBelow(middle);if(below/total<percent)lower=middle;else upper=middle;}return(lower+upper)/2;}};function Piece(x1,y1,x2,y2){this.x1=x1;this.y1=y1;this.x2=x2;this.y2=y2;}Piece.prototype={partBelow:function(y){var width=this.width;if(width===0)return 0;var minY=this.min;var maxY=this.max;if(y>=maxY)return width;if(y<minY)return 0;return(y-minY)/(maxY-minY)*width;},get min(){return Math.min(this.y1,this.y2);},get max(){return Math.max(this.y1,this.y2);},get average(){return(this.y1+this.y2)/2;},get width(){return this.x2-this.x1;}};return{PiecewiseLinearFunction:PiecewiseLinearFunction};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],50:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./math.js");'use strict';global.tr.exportTo('tr.b',function(){var tmpVec2s=[];for(var i=0;i<8;i++)tmpVec2s[i]=vec2.create();var tmpVec2a=vec4.create();var tmpVec4a=vec4.create();var tmpVec4b=vec4.create();var tmpMat4=mat4.create();var tmpMat4b=mat4.create();var p00=vec2.createXY(0,0);var p10=vec2.createXY(1,0);var p01=vec2.createXY(0,1);var p11=vec2.createXY(1,1);var lerpingVecA=vec2.create();var lerpingVecB=vec2.create();function lerpVec2(out,a,b,amt){vec2.scale(lerpingVecA,a,amt);vec2.scale(lerpingVecB,b,1-amt);vec2.add(out,lerpingVecA,lerpingVecB);vec2.normalize(out,out);return out;}function Quad(){this.p1=vec2.create();this.p2=vec2.create();this.p3=vec2.create();this.p4=vec2.create();}Quad.fromXYWH=function(x,y,w,h){var q=new Quad();vec2.set(q.p1,x,y);vec2.set(q.p2,x+w,y);vec2.set(q.p3,x+w,y+h);vec2.set(q.p4,x,y+h);return q;};Quad.fromRect=function(r){return new Quad.fromXYWH(r.x,r.y,r.width,r.height);};Quad.from4Vecs=function(p1,p2,p3,p4){var q=new Quad();vec2.set(q.p1,p1[0],p1[1]);vec2.set(q.p2,p2[0],p2[1]);vec2.set(q.p3,p3[0],p3[1]);vec2.set(q.p4,p4[0],p4[1]);return q;};Quad.from8Array=function(arr){if(arr.length!=8)throw new Error('Array must be 8 long');var q=new Quad();q.p1[0]=arr[0];q.p1[1]=arr[1];q.p2[0]=arr[2];q.p2[1]=arr[3];q.p3[0]=arr[4];q.p3[1]=arr[5];q.p4[0]=arr[6];q.p4[1]=arr[7];return q;};Quad.prototype={pointInside:function(point){return pointInImplicitQuad(point,this.p1,this.p2,this.p3,this.p4);},boundingRect:function(){var x0=Math.min(this.p1[0],this.p2[0],this.p3[0],this.p4[0]);var y0=Math.min(this.p1[1],this.p2[1],this.p3[1],this.p4[1]);var x1=Math.max(this.p1[0],this.p2[0],this.p3[0],this.p4[0]);var y1=Math.max(this.p1[1],this.p2[1],this.p3[1],this.p4[1]);return new tr.b.Rect.fromXYWH(x0,y0,x1-x0,y1-y0);},clone:function(){var q=new Quad();vec2.copy(q.p1,this.p1);vec2.copy(q.p2,this.p2);vec2.copy(q.p3,this.p3);vec2.copy(q.p4,this.p4);return q;},scale:function(s){var q=new Quad();this.scaleFast(q,s);return q;},scaleFast:function(dstQuad,s){vec2.copy(dstQuad.p1,this.p1,s);vec2.copy(dstQuad.p2,this.p2,s);vec2.copy(dstQuad.p3,this.p3,s);vec2.copy(dstQuad.p3,this.p3,s);},isRectangle:function(){var bounds=this.boundingRect();return bounds.x==this.p1[0]&&bounds.y==this.p1[1]&&bounds.width==this.p2[0]-this.p1[0]&&bounds.y==this.p2[1]&&bounds.width==this.p3[0]-this.p1[0]&&bounds.height==this.p3[1]-this.p2[1]&&bounds.x==this.p4[0]&&bounds.height==this.p4[1]-this.p2[1];},projectUnitRect:function(rect){var q=new Quad();this.projectUnitRectFast(q,rect);return q;},projectUnitRectFast:function(dstQuad,rect){var v12=tmpVec2s[0];var v14=tmpVec2s[1];var v23=tmpVec2s[2];var v43=tmpVec2s[3];var l12,l14,l23,l43;vec2.sub(v12,this.p2,this.p1);l12=vec2.length(v12);vec2.scale(v12,v12,1/l12);vec2.sub(v14,this.p4,this.p1);l14=vec2.length(v14);vec2.scale(v14,v14,1/l14);vec2.sub(v23,this.p3,this.p2);l23=vec2.length(v23);vec2.scale(v23,v23,1/l23);vec2.sub(v43,this.p3,this.p4);l43=vec2.length(v43);vec2.scale(v43,v43,1/l43);var b12=tmpVec2s[0];var b14=tmpVec2s[1];var b23=tmpVec2s[2];var b43=tmpVec2s[3];lerpVec2(b12,v12,v43,rect.y);lerpVec2(b43,v12,v43,1-rect.bottom);lerpVec2(b14,v14,v23,rect.x);lerpVec2(b23,v14,v23,1-rect.right);vec2.addTwoScaledUnitVectors(tmpVec2a,b12,l12*rect.x,b14,l14*rect.y);vec2.add(dstQuad.p1,this.p1,tmpVec2a);vec2.addTwoScaledUnitVectors(tmpVec2a,b12,l12*-(1.0-rect.right),b23,l23*rect.y);vec2.add(dstQuad.p2,this.p2,tmpVec2a);vec2.addTwoScaledUnitVectors(tmpVec2a,b43,l43*-(1.0-rect.right),b23,l23*-(1.0-rect.bottom));vec2.add(dstQuad.p3,this.p3,tmpVec2a);vec2.addTwoScaledUnitVectors(tmpVec2a,b43,l43*rect.left,b14,l14*-(1.0-rect.bottom));vec2.add(dstQuad.p4,this.p4,tmpVec2a);},toString:function(){return'Quad('+vec2.toString(this.p1)+', '+vec2.toString(this.p2)+', '+vec2.toString(this.p3)+', '+vec2.toString(this.p4)+')';}};function sign(p1,p2,p3){return(p1[0]-p3[0])*(p2[1]-p3[1])-(p2[0]-p3[0])*(p1[1]-p3[1]);}function pointInTriangle2(pt,p1,p2,p3){var b1=sign(pt,p1,p2)<0.0;var b2=sign(pt,p2,p3)<0.0;var b3=sign(pt,p3,p1)<0.0;return b1==b2&&b2==b3;}function pointInImplicitQuad(point,p1,p2,p3,p4){return pointInTriangle2(point,p1,p2,p3)||pointInTriangle2(point,p1,p3,p4);}return{pointInTriangle2:pointInTriangle2,pointInImplicitQuad:pointInImplicitQuad,Quad:Quad};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33,"./math.js":47}],51:[function(require,module,exports){(function(global){"use strict";require("./utils.js");'use strict';global.tr.exportTo('tr.b',function(){var ESTIMATED_IDLE_PERIOD_LENGTH_MILLISECONDS=10;var REQUEST_IDLE_CALLBACK_TIMEOUT_MILLISECONDS=100;var recordRAFStacks=false;var pendingPreAFs=[];var pendingRAFs=[];var pendingIdleCallbacks=[];var currentRAFDispatchList=undefined;var rafScheduled=false;var idleWorkScheduled=false;function scheduleRAF(){if(rafScheduled)return;rafScheduled=true;if(tr.isHeadless){Promise.resolve().then(function(){processRequests(false,0);},function(e){console.log(e.stack);throw e;});}else{if(window.requestAnimationFrame){window.requestAnimationFrame(processRequests.bind(this,false));}else{var delta=Date.now()-window.performance.now();window.webkitRequestAnimationFrame(function(domTimeStamp){processRequests(false,domTimeStamp-delta);});}}}function nativeRequestIdleCallbackSupported(){return!tr.isHeadless&&window.requestIdleCallback;}function scheduleIdleWork(){if(idleWorkScheduled)return;if(!nativeRequestIdleCallbackSupported()){scheduleRAF();return;}idleWorkScheduled=true;window.requestIdleCallback(function(deadline,didTimeout){processIdleWork(false,deadline);},{timeout:REQUEST_IDLE_CALLBACK_TIMEOUT_MILLISECONDS});}function onAnimationFrameError(e,opt_stack){console.log(e.stack);if(tr.isHeadless)throw e;if(opt_stack)console.log(opt_stack);if(e.message)console.assert(true,e.message,e.stack);else console.assert(true,e);}function runTask(task,frameBeginTime){try{task.callback.call(task.context,frameBeginTime);}catch(e){tr.b.onAnimationFrameError(e,task.stack);}}function processRequests(forceAllTasksToRun,frameBeginTime){rafScheduled=false;var currentPreAFs=pendingPreAFs;currentRAFDispatchList=pendingRAFs;pendingPreAFs=[];pendingRAFs=[];var hasRAFTasks=currentPreAFs.length||currentRAFDispatchList.length;for(var i=0;i<currentPreAFs.length;i++)runTask(currentPreAFs[i],frameBeginTime);while(currentRAFDispatchList.length>0)runTask(currentRAFDispatchList.shift(),frameBeginTime);currentRAFDispatchList=undefined;if(!hasRAFTasks&&!nativeRequestIdleCallbackSupported()||forceAllTasksToRun){var rafCompletionDeadline=frameBeginTime+ESTIMATED_IDLE_PERIOD_LENGTH_MILLISECONDS;processIdleWork(forceAllTasksToRun,{timeRemaining:function(){return rafCompletionDeadline-window.performance.now();}});}if(pendingIdleCallbacks.length>0)scheduleIdleWork();}function processIdleWork(forceAllTasksToRun,deadline){idleWorkScheduled=false;while(pendingIdleCallbacks.length>0){runTask(pendingIdleCallbacks.shift());if(!forceAllTasksToRun&&(tr.isHeadless||deadline.timeRemaining()<=0)){break;}}if(pendingIdleCallbacks.length>0)scheduleIdleWork();}function getStack_(){if(!recordRAFStacks)return'';var stackLines=tr.b.stackTrace();stackLines.shift();return stackLines.join('\n');}function requestPreAnimationFrame(callback,opt_this){pendingPreAFs.push({callback:callback,context:opt_this||global,stack:getStack_()});scheduleRAF();}function requestAnimationFrameInThisFrameIfPossible(callback,opt_this){if(!currentRAFDispatchList){requestAnimationFrame(callback,opt_this);return;}currentRAFDispatchList.push({callback:callback,context:opt_this||global,stack:getStack_()});return;}function requestAnimationFrame(callback,opt_this){pendingRAFs.push({callback:callback,context:opt_this||global,stack:getStack_()});scheduleRAF();}function requestIdleCallback(callback,opt_this){pendingIdleCallbacks.push({callback:callback,context:opt_this||global,stack:getStack_()});scheduleIdleWork();}function forcePendingRAFTasksToRun(frameBeginTime){if(!rafScheduled)return;processRequests(false,frameBeginTime);}function forceAllPendingTasksToRunForTest(){if(!rafScheduled&&!idleWorkScheduled)return;processRequests(true,0);}return{onAnimationFrameError:onAnimationFrameError,requestPreAnimationFrame:requestPreAnimationFrame,requestAnimationFrame:requestAnimationFrame,requestAnimationFrameInThisFrameIfPossible:requestAnimationFrameInThisFrameIfPossible,requestIdleCallback:requestIdleCallback,forcePendingRAFTasksToRun:forcePendingRAFTasksToRun,forceAllPendingTasksToRunForTest:forceAllPendingTasksToRunForTest};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./utils.js":64}],52:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./iteration_helpers.js");require("./math.js");'use strict';global.tr.exportTo('tr.b',function(){function Range(){this.isEmpty_=true;this.min_=undefined;this.max_=undefined;}Range.prototype={__proto__:Object.prototype,reset:function(){this.isEmpty_=true;this.min_=undefined;this.max_=undefined;},get isEmpty(){return this.isEmpty_;},addRange:function(range){if(range.isEmpty)return;this.addValue(range.min);this.addValue(range.max);},addValue:function(value){if(this.isEmpty_){this.max_=value;this.min_=value;this.isEmpty_=false;return;}this.max_=Math.max(this.max_,value);this.min_=Math.min(this.min_,value);},set min(min){this.isEmpty_=false;this.min_=min;},get min(){if(this.isEmpty_)return undefined;return this.min_;},get max(){if(this.isEmpty_)return undefined;return this.max_;},set max(max){this.isEmpty_=false;this.max_=max;},get range(){if(this.isEmpty_)return undefined;return this.max_-this.min_;},get center(){return(this.min_+this.max_)*0.5;},get duration(){if(this.isEmpty_)return 0;return this.max_-this.min_;},normalize:function(x){return tr.b.normalize(x,this.min,this.max);},lerp:function(x){return tr.b.lerp(x,this.min,this.max);},equals:function(that){if(this.isEmpty&&that.isEmpty)return true;if(this.isEmpty!=that.isEmpty)return false;return tr.b.approximately(this.min,that.min)&&tr.b.approximately(this.max,that.max);},containsExplicitRangeInclusive:function(min,max){if(this.isEmpty)return false;return this.min_<=min&&max<=this.max_;},containsExplicitRangeExclusive:function(min,max){if(this.isEmpty)return false;return this.min_<min&&max<this.max_;},intersectsExplicitRangeInclusive:function(min,max){if(this.isEmpty)return false;return this.min_<=max&&min<=this.max_;},intersectsExplicitRangeExclusive:function(min,max){if(this.isEmpty)return false;return this.min_<max&&min<this.max_;},containsRangeInclusive:function(range){if(range.isEmpty)return false;return this.containsExplicitRangeInclusive(range.min_,range.max_);},containsRangeExclusive:function(range){if(range.isEmpty)return false;return this.containsExplicitRangeExclusive(range.min_,range.max_);},intersectsRangeInclusive:function(range){if(range.isEmpty)return false;return this.intersectsExplicitRangeInclusive(range.min_,range.max_);},intersectsRangeExclusive:function(range){if(range.isEmpty)return false;return this.intersectsExplicitRangeExclusive(range.min_,range.max_);},findExplicitIntersectionDuration:function(min,max){var min=Math.max(this.min,min);var max=Math.min(this.max,max);if(max<min)return 0;return max-min;},findIntersection:function(range){if(this.isEmpty||range.isEmpty)return new Range();var min=Math.max(this.min,range.min);var max=Math.min(this.max,range.max);if(max<min)return new Range();return Range.fromExplicitRange(min,max);},toJSON:function(){if(this.isEmpty_)return{isEmpty:true};return{isEmpty:false,max:this.max,min:this.min};},filterArray:function(array,opt_keyFunc,opt_this){if(this.isEmpty_)return[];function binSearch(test){var i0=0;var i1=array.length;while(i0<i1){var i=Math.trunc((i0+i1)/2);if(test(i))i1=i;else i0=i+1;}return i1;}var keyFunc=opt_keyFunc||tr.b.identity;function getValue(index){return keyFunc.call(opt_this,array[index]);}var first=binSearch(function(i){return this.min_===undefined||this.min_<=getValue(i);}.bind(this));var last=binSearch(function(i){return this.max_!==undefined&&this.max_<getValue(i);}.bind(this));return array.slice(first,last);}};Range.fromDict=function(d){if(d.isEmpty===true){return new Range();}else if(d.isEmpty===false){var range=new Range();range.min=d.min;range.max=d.max;return range;}else{throw new Error('Not a range');}};Range.fromExplicitRange=function(min,max){var range=new Range();range.min=min;range.max=max;return range;};Range.compareByMinTimes=function(a,b){if(!a.isEmpty&&!b.isEmpty)return a.min_-b.min_;if(a.isEmpty&&!b.isEmpty)return-1;if(!a.isEmpty&&b.isEmpty)return 1;return 0;};Range.PERCENT_RANGE=Range.fromExplicitRange(0,1);Object.freeze(Range.PERCENT_RANGE);return{Range:Range};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33,"./iteration_helpers.js":46,"./math.js":47}],53:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./iteration_helpers.js");'use strict';global.tr.exportTo('tr.b',function(){function convertEventsToRanges(events){return events.map(function(event){return tr.b.Range.fromExplicitRange(event.start,event.end);});}function mergeRanges(inRanges,mergeThreshold,mergeFunction){var remainingEvents=inRanges.slice();remainingEvents.sort(function(x,y){return x.min-y.min;});if(remainingEvents.length<=1){var merged=[];if(remainingEvents.length==1){merged.push(mergeFunction(remainingEvents));}return merged;}var mergedEvents=[];var currentMergeBuffer=[];var rightEdge;function beginMerging(){currentMergeBuffer.push(remainingEvents[0]);remainingEvents.splice(0,1);rightEdge=currentMergeBuffer[0].max;}function flushCurrentMergeBuffer(){if(currentMergeBuffer.length==0)return;mergedEvents.push(mergeFunction(currentMergeBuffer));currentMergeBuffer=[];if(remainingEvents.length!=0)beginMerging();}beginMerging();while(remainingEvents.length){var currentEvent=remainingEvents[0];var distanceFromRightEdge=currentEvent.min-rightEdge;if(distanceFromRightEdge<mergeThreshold){rightEdge=Math.max(rightEdge,currentEvent.max);remainingEvents.splice(0,1);currentMergeBuffer.push(currentEvent);continue;}flushCurrentMergeBuffer();}flushCurrentMergeBuffer();return mergedEvents;}function findEmptyRangesBetweenRanges(inRanges,opt_totalRange){if(opt_totalRange&&opt_totalRange.isEmpty)opt_totalRange=undefined;var emptyRanges=[];if(!inRanges.length){if(opt_totalRange)emptyRanges.push(opt_totalRange);return emptyRanges;}inRanges=inRanges.slice();inRanges.sort(function(x,y){return x.min-y.min;});if(opt_totalRange&&opt_totalRange.min<inRanges[0].min){emptyRanges.push(tr.b.Range.fromExplicitRange(opt_totalRange.min,inRanges[0].min));}inRanges.forEach(function(range,index){for(var otherIndex=0;otherIndex<inRanges.length;++otherIndex){if(index===otherIndex)continue;var other=inRanges[otherIndex];if(other.min>range.max){emptyRanges.push(tr.b.Range.fromExplicitRange(range.max,other.min));return;}if(other.max>range.max){return;}}if(opt_totalRange&&range.max<opt_totalRange.max){emptyRanges.push(tr.b.Range.fromExplicitRange(range.max,opt_totalRange.max));}});return emptyRanges;}return{convertEventsToRanges:convertEventsToRanges,findEmptyRangesBetweenRanges:findEmptyRangesBetweenRanges,mergeRanges:mergeRanges};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33,"./iteration_helpers.js":46}],54:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./math.js");'use strict';global.tr.exportTo('tr.b',function(){function Rect(){this.x=0;this.y=0;this.width=0;this.height=0;};Rect.fromXYWH=function(x,y,w,h){var rect=new Rect();rect.x=x;rect.y=y;rect.width=w;rect.height=h;return rect;};Rect.fromArray=function(ary){if(ary.length!=4)throw new Error('ary.length must be 4');var rect=new Rect();rect.x=ary[0];rect.y=ary[1];rect.width=ary[2];rect.height=ary[3];return rect;};Rect.prototype={__proto__:Object.prototype,get left(){return this.x;},get top(){return this.y;},get right(){return this.x+this.width;},get bottom(){return this.y+this.height;},toString:function(){return'Rect('+this.x+', '+this.y+', '+this.width+', '+this.height+')';},toArray:function(){return[this.x,this.y,this.width,this.height];},clone:function(){var rect=new Rect();rect.x=this.x;rect.y=this.y;rect.width=this.width;rect.height=this.height;return rect;},enlarge:function(pad){var rect=new Rect();this.enlargeFast(rect,pad);return rect;},enlargeFast:function(out,pad){out.x=this.x-pad;out.y=this.y-pad;out.width=this.width+2*pad;out.height=this.height+2*pad;return out;},size:function(){return{width:this.width,height:this.height};},scale:function(s){var rect=new Rect();this.scaleFast(rect,s);return rect;},scaleSize:function(s){return Rect.fromXYWH(this.x,this.y,this.width*s,this.height*s);},scaleFast:function(out,s){out.x=this.x*s;out.y=this.y*s;out.width=this.width*s;out.height=this.height*s;return out;},translate:function(v){var rect=new Rect();this.translateFast(rect,v);return rect;},translateFast:function(out,v){out.x=this.x+v[0];out.y=this.x+v[1];out.width=this.width;out.height=this.height;return out;},asUVRectInside:function(containingRect){var rect=new Rect();rect.x=(this.x-containingRect.x)/containingRect.width;rect.y=(this.y-containingRect.y)/containingRect.height;rect.width=this.width/containingRect.width;rect.height=this.height/containingRect.height;return rect;},intersects:function(that){var ok=true;ok&=this.x<that.right;ok&=this.right>that.x;ok&=this.y<that.bottom;ok&=this.bottom>that.y;return ok;},equalTo:function(rect){return rect&&this.x===rect.x&&this.y===rect.y&&this.width===rect.width&&this.height===rect.height;}};return{Rect:Rect};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33,"./math.js":47}],55:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){class RunningStatistics{constructor(){this.mean_=0;this.count_=0;this.max_=-Infinity;this.min_=Infinity;this.sum_=0;this.variance_=0;this.meanlogs_=0;}get count(){return this.count_;}get geometricMean(){if(this.meanlogs_===undefined)return 0;return Math.exp(this.meanlogs_);}get mean(){if(this.count_==0)return undefined;return this.mean_;}get max(){return this.max_;}get min(){return this.min_;}get sum(){return this.sum_;}get variance(){if(this.count_==0)return undefined;if(this.count_==1)return 0;return this.variance_/(this.count_-1);}get stddev(){if(this.count_==0)return undefined;return Math.sqrt(this.variance);}add(x){this.count_++;this.max_=Math.max(this.max_,x);this.min_=Math.min(this.min_,x);this.sum_+=x;if(x<=0)this.meanlogs_=undefined;else if(this.meanlogs_!==undefined)this.meanlogs_+=(Math.log(Math.abs(x))-this.meanlogs_)/this.count;if(this.count_===1){this.mean_=x;this.variance_=0;}else{var oldMean=this.mean_;var oldVariance=this.variance_;if(oldMean===Infinity||oldMean===-Infinity){this.mean_=this.sum_/this.count_;}else{this.mean_=oldMean+(x-oldMean)/this.count_;}this.variance_=oldVariance+(x-oldMean)*(x-this.mean_);}}merge(other){var result=new RunningStatistics();result.count_=this.count_+other.count_;result.sum_=this.sum_+other.sum_;result.min_=Math.min(this.min_,other.min_);result.max_=Math.max(this.max_,other.max_);if(result.count===0){result.mean_=0;result.variance_=0;result.meanlogs_=0;}else{result.mean_=result.sum/result.count;var deltaMean=(this.mean||0)-(other.mean||0);result.variance_=this.variance_+other.variance_+this.count*other.count*deltaMean*deltaMean/result.count;if(this.meanlogs_===undefined||other.meanlogs_===undefined){result.meanlogs_=undefined;}else{result.meanlogs_=(this.count*this.meanlogs_+other.count*other.meanlogs_)/result.count;}}return result;}asDict(){if(!this.count){return[];}return[this.count_,this.max_,this.meanlogs_,this.mean_,this.min_,this.sum_,this.variance_];}static fromDict(dict){var result=new RunningStatistics();if(dict.length!=7){return result;}[result.count_,result.max_,result.meanlogs_,result.mean_,result.min_,result.sum_,result.variance_]=dict;return result;}}return{RunningStatistics:RunningStatistics};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],56:[function(require,module,exports){(function(global){"use strict";require("./color.js");require("./iteration_helpers.js");require("./math.js");'use strict';global.tr.exportTo('tr.b',function(){function SinebowColorGenerator(opt_a,opt_brightness){this.a_=opt_a===undefined?1:opt_a;this.brightness_=opt_brightness===undefined?1:opt_brightness;this.colorIndex_=0;this.keyToColor={};}SinebowColorGenerator.prototype={colorForKey:function(key){if(!this.keyToColor[key])this.keyToColor[key]=this.nextColor();return this.keyToColor[key];},nextColor:function(){var components=SinebowColorGenerator.nthColor(this.colorIndex_++);return tr.b.Color.fromString(SinebowColorGenerator.calculateColor(components[0],components[1],components[2],this.a_,this.brightness_));}};SinebowColorGenerator.PHI=(1+Math.sqrt(5))/2;SinebowColorGenerator.sinebow_=function(h){h+=0.5;h=-h;var r=Math.sin(Math.PI*h);var g=Math.sin(Math.PI*(h+1/3));var b=Math.sin(Math.PI*(h+2/3));r*=r;g*=g;b*=b;var y=2*(0.2989*r+0.5870*g+0.1140*b);r/=y;g/=y;b/=y;return[256*r,256*g,256*b];};SinebowColorGenerator.nthColor=function(n){return SinebowColorGenerator.sinebow_(n*this.PHI);};SinebowColorGenerator.calculateColor=function(r,g,b,a,brightness){if(brightness<=1){r*=brightness;g*=brightness;b*=brightness;}else{r=tr.b.lerp(tr.b.normalize(brightness,1,2),r,255);g=tr.b.lerp(tr.b.normalize(brightness,1,2),g,255);b=tr.b.lerp(tr.b.normalize(brightness,1,2),b,255);}r=Math.round(r);g=Math.round(g);b=Math.round(b);return'rgba('+r+','+g+','+b+', '+a+')';};return{SinebowColorGenerator:SinebowColorGenerator};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./color.js":36,"./iteration_helpers.js":46,"./math.js":47}],57:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function findLowIndexInSortedArray(ary,mapFn,loVal){if(ary.length==0)return 1;var low=0;var high=ary.length-1;var i,comparison;var hitPos=-1;while(low<=high){i=Math.floor((low+high)/2);comparison=mapFn(ary[i])-loVal;if(comparison<0){low=i+1;continue;}else if(comparison>0){high=i-1;continue;}else{hitPos=i;high=i-1;}}return hitPos!=-1?hitPos:low;}function findHighIndexInSortedArray(ary,mapFn,loVal,hiVal){var lo=loVal||0;var hi=hiVal!==undefined?hiVal:ary.length;while(lo<hi){var mid=lo+hi>>1;if(mapFn(ary[mid])>=0)lo=mid+1;else hi=mid;}return hi;}function findIndexInSortedIntervals(ary,mapLoFn,mapWidthFn,loVal){var first=findLowIndexInSortedArray(ary,mapLoFn,loVal);if(first==0){if(loVal>=mapLoFn(ary[0])&&loVal<mapLoFn(ary[0])+mapWidthFn(ary[0],0)){return 0;}else{return-1;}}else if(first<ary.length){if(loVal>=mapLoFn(ary[first])&&loVal<mapLoFn(ary[first])+mapWidthFn(ary[first],first)){return first;}else if(loVal>=mapLoFn(ary[first-1])&&loVal<mapLoFn(ary[first-1])+mapWidthFn(ary[first-1],first-1)){return first-1;}else{return ary.length;}}else if(first==ary.length){if(loVal>=mapLoFn(ary[first-1])&&loVal<mapLoFn(ary[first-1])+mapWidthFn(ary[first-1],first-1)){return first-1;}else{return ary.length;}}else{return ary.length;}}function findIndexInSortedClosedIntervals(ary,mapLoFn,mapHiFn,val){var i=findLowIndexInSortedArray(ary,mapLoFn,val);if(i===0){if(val>=mapLoFn(ary[0],0)&&val<=mapHiFn(ary[0],0)){return 0;}else{return-1;}}else if(i<ary.length){if(val>=mapLoFn(ary[i-1],i-1)&&val<=mapHiFn(ary[i-1],i-1)){return i-1;}else if(val>=mapLoFn(ary[i],i)&&val<=mapHiFn(ary[i],i)){return i;}else{return ary.length;}}else if(i==ary.length){if(val>=mapLoFn(ary[i-1],i-1)&&val<=mapHiFn(ary[i-1],i-1)){return i-1;}else{return ary.length;}}else{return ary.length;}}function iterateOverIntersectingIntervals(ary,mapLoFn,mapWidthFn,loVal,hiVal,cb){if(ary.length==0)return;if(loVal>hiVal)return;var i=findLowIndexInSortedArray(ary,mapLoFn,loVal);if(i==-1){return;}if(i>0){var hi=mapLoFn(ary[i-1])+mapWidthFn(ary[i-1],i-1);if(hi>=loVal){cb(ary[i-1],i-1);}}if(i==ary.length){return;}for(var n=ary.length;i<n;i++){var lo=mapLoFn(ary[i]);if(lo>=hiVal)break;cb(ary[i],i);}}function getIntersectingIntervals(ary,mapLoFn,mapWidthFn,loVal,hiVal){var tmp=[];iterateOverIntersectingIntervals(ary,mapLoFn,mapWidthFn,loVal,hiVal,function(d){tmp.push(d);});return tmp;}function findClosestElementInSortedArray(ary,mapFn,val,maxDiff){if(ary.length===0)return null;var aftIdx=findLowIndexInSortedArray(ary,mapFn,val);var befIdx=aftIdx>0?aftIdx-1:0;if(aftIdx===ary.length)aftIdx-=1;var befDiff=Math.abs(val-mapFn(ary[befIdx]));var aftDiff=Math.abs(val-mapFn(ary[aftIdx]));if(befDiff>maxDiff&&aftDiff>maxDiff)return null;var idx=befDiff<aftDiff?befIdx:aftIdx;return ary[idx];}function findClosestIntervalInSortedIntervals(ary,mapLoFn,mapHiFn,val,maxDiff){if(ary.length===0)return null;var idx=findLowIndexInSortedArray(ary,mapLoFn,val);if(idx>0)idx-=1;var hiInt=ary[idx];var loInt=hiInt;if(val>mapHiFn(hiInt)&&idx+1<ary.length)loInt=ary[idx+1];var loDiff=Math.abs(val-mapLoFn(loInt));var hiDiff=Math.abs(val-mapHiFn(hiInt));if(loDiff>maxDiff&&hiDiff>maxDiff)return null;if(loDiff<hiDiff)return loInt;else return hiInt;}return{findLowIndexInSortedArray:findLowIndexInSortedArray,findHighIndexInSortedArray:findHighIndexInSortedArray,findIndexInSortedIntervals:findIndexInSortedIntervals,findIndexInSortedClosedIntervals:findIndexInSortedClosedIntervals,iterateOverIntersectingIntervals:iterateOverIntersectingIntervals,getIntersectingIntervals:getIntersectingIntervals,findClosestElementInSortedArray:findClosestElementInSortedArray,findClosestIntervalInSortedIntervals:findClosestIntervalInSortedIntervals};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],58:[function(require,module,exports){(function(global){"use strict";require("./math.js");require("./range.js");'use strict';(function(){if(tr.isNode){var mwuAbsPath=HTMLImportsLoader.hrefToAbsolutePath('/mannwhitneyu.js');var mwuModule=require(mwuAbsPath);for(var exportName in mwuModule){global[exportName]=mwuModule[exportName];}}})(this);'use strict';global.tr.exportTo('tr.b',function(){var identity=x=>x;var Statistics={};Statistics.divideIfPossibleOrZero=function(numerator,denominator){if(denominator===0)return 0;return numerator/denominator;};Statistics.sum=function(ary,opt_func,opt_this){var func=opt_func||identity;var ret=0;var i=0;for(var elt of ary)ret+=func.call(opt_this,elt,i++);return ret;};Statistics.mean=function(ary,opt_func,opt_this){var func=opt_func||identity;var sum=0;var i=0;for(var elt of ary)sum+=func.call(opt_this,elt,i++);if(i===0)return undefined;return sum/i;};Statistics.geometricMean=function(ary,opt_func,opt_this){var func=opt_func||identity;var i=0;var logsum=0;for(var elt of ary){var x=func.call(opt_this,elt,i++);if(x<=0)return 0;logsum+=Math.log(Math.abs(x));}if(i===0)return 1;return Math.exp(logsum/i);};Statistics.weightedMean=function(ary,weightCallback,opt_valueCallback,opt_this){var valueCallback=opt_valueCallback||identity;var numerator=0;var denominator=0;var i=-1;for(var elt of ary){i++;var value=valueCallback.call(opt_this,elt,i);if(value===undefined)continue;var weight=weightCallback.call(opt_this,elt,i,value);numerator+=weight*value;denominator+=weight;}if(denominator===0)return undefined;return numerator/denominator;};Statistics.variance=function(ary,opt_func,opt_this){if(ary.length===0)return undefined;if(ary.length===1)return 0;var func=opt_func||identity;var mean=Statistics.mean(ary,func,opt_this);var sumOfSquaredDistances=Statistics.sum(ary,function(d,i){var v=func.call(this,d,i)-mean;return v*v;},opt_this);return sumOfSquaredDistances/(ary.length-1);};Statistics.stddev=function(ary,opt_func,opt_this){if(ary.length==0)return undefined;return Math.sqrt(Statistics.variance(ary,opt_func,opt_this));};Statistics.max=function(ary,opt_func,opt_this){var func=opt_func||identity;var ret=-Infinity;var i=0;for(var elt of ary)ret=Math.max(ret,func.call(opt_this,elt,i++));return ret;};Statistics.min=function(ary,opt_func,opt_this){var func=opt_func||identity;var ret=Infinity;var i=0;for(var elt of ary)ret=Math.min(ret,func.call(opt_this,elt,i++));return ret;};Statistics.range=function(ary,opt_func,opt_this){var func=opt_func||identity;var ret=new tr.b.Range();var i=0;for(var elt of ary)ret.addValue(func.call(opt_this,elt,i++));return ret;};Statistics.percentile=function(ary,percent,opt_func,opt_this){if(!(percent>=0&&percent<=1))throw new Error('percent must be [0,1]');var func=opt_func||identity;var tmp=new Array(ary.length);var i=0;for(var elt of ary)tmp[i]=func.call(opt_this,elt,i++);tmp.sort((a,b)=>a-b);var idx=Math.floor((ary.length-1)*percent);return tmp[idx];};Statistics.normalizeSamples=function(samples){if(samples.length===0){return{normalized_samples:samples,scale:1.0};}samples=samples.slice().sort(function(a,b){return a-b;});var low=Math.min.apply(null,samples);var high=Math.max.apply(null,samples);var newLow=0.5/samples.length;var newHigh=(samples.length-0.5)/samples.length;if(high-low===0.0){samples=Array.apply(null,new Array(samples.length)).map(function(){return 0.5;});return{normalized_samples:samples,scale:1.0};}var scale=(newHigh-newLow)/(high-low);for(var i=0;i<samples.length;i++){samples[i]=(samples[i]-low)*scale+newLow;}return{normalized_samples:samples,scale:scale};};Statistics.discrepancy=function(samples,opt_locationCount){if(samples.length===0)return 0.0;var maxLocalDiscrepancy=0;var invSampleCount=1.0/samples.length;var locations=[];var countLess=[];var countLessEqual=[];if(opt_locationCount!==undefined){var sampleIndex=0;for(var i=0;i<opt_locationCount;i++){var location=i/(opt_locationCount-1);locations.push(location);while(sampleIndex<samples.length&&samples[sampleIndex]<location){sampleIndex+=1;}countLess.push(sampleIndex);while(sampleIndex<samples.length&&samples[sampleIndex]<=location){sampleIndex+=1;}countLessEqual.push(sampleIndex);}}else{if(samples[0]>0.0){locations.push(0.0);countLess.push(0);countLessEqual.push(0);}for(var i=0;i<samples.length;i++){locations.push(samples[i]);countLess.push(i);countLessEqual.push(i+1);}if(samples[-1]<1.0){locations.push(1.0);countLess.push(samples.length);countLessEqual.push(samples.length);}}var maxDiff=0;var minDiff=0;for(var i=1;i<locations.length;i++){var length=locations[i]-locations[i-1];var countClosed=countLessEqual[i]-countLess[i-1];var countOpen=countLess[i]-countLessEqual[i-1];var countClosedIncrement=countLessEqual[i]-countLessEqual[i-1];var countOpenIncrement=countLess[i]-countLess[i-1];maxDiff=Math.max(countClosedIncrement*invSampleCount-length+maxDiff,countClosed*invSampleCount-length);minDiff=Math.min(countOpenIncrement*invSampleCount-length+minDiff,countOpen*invSampleCount-length);maxLocalDiscrepancy=Math.max(maxDiff,-minDiff,maxLocalDiscrepancy);}return maxLocalDiscrepancy;};Statistics.timestampsDiscrepancy=function(timestamps,opt_absolute,opt_locationCount){if(timestamps.length===0)return 0.0;if(opt_absolute===undefined)opt_absolute=true;if(Array.isArray(timestamps[0])){var rangeDiscrepancies=timestamps.map(function(r){return Statistics.timestampsDiscrepancy(r);});return Math.max.apply(null,rangeDiscrepancies);}var s=Statistics.normalizeSamples(timestamps);var samples=s.normalized_samples;var sampleScale=s.scale;var discrepancy=Statistics.discrepancy(samples,opt_locationCount);var invSampleCount=1.0/samples.length;if(opt_absolute===true){discrepancy/=sampleScale;}else{discrepancy=tr.b.clamp((discrepancy-invSampleCount)/(1.0-invSampleCount),0.0,1.0);}return discrepancy;};Statistics.durationsDiscrepancy=function(durations,opt_absolute,opt_locationCount){if(durations.length===0)return 0.0;var timestamps=durations.reduce(function(prev,curr,index,array){prev.push(prev[prev.length-1]+curr);return prev;},[0]);return Statistics.timestampsDiscrepancy(timestamps,opt_absolute,opt_locationCount);};Statistics.uniformlySampleArray=function(samples,count){if(samples.length<=count){return samples;}while(samples.length>count){var i=parseInt(Math.random()*samples.length);samples.splice(i,1);}return samples;};Statistics.uniformlySampleStream=function(samples,streamLength,newElement,numSamples){if(streamLength<=numSamples){if(samples.length>=streamLength)samples[streamLength-1]=newElement;else samples.push(newElement);return;}var probToKeep=numSamples/streamLength;if(Math.random()>probToKeep)return;var index=Math.floor(Math.random()*numSamples);samples[index]=newElement;};Statistics.mergeSampledStreams=function(samplesA,streamLengthA,samplesB,streamLengthB,numSamples){if(streamLengthB<numSamples){var nbElements=Math.min(streamLengthB,samplesB.length);for(var i=0;i<nbElements;++i){Statistics.uniformlySampleStream(samplesA,streamLengthA+i+1,samplesB[i],numSamples);}return;}if(streamLengthA<numSamples){var nbElements=Math.min(streamLengthA,samplesA.length);var tempSamples=samplesB.slice();for(var i=0;i<nbElements;++i){Statistics.uniformlySampleStream(tempSamples,streamLengthB+i+1,samplesA[i],numSamples);}for(var i=0;i<tempSamples.length;++i){samplesA[i]=tempSamples[i];}return;}var nbElements=Math.min(numSamples,samplesB.length);var probOfSwapping=streamLengthB/(streamLengthA+streamLengthB);for(var i=0;i<nbElements;++i){if(Math.random()<probOfSwapping){samplesA[i]=samplesB[i];}}};function Distribution(){}Distribution.prototype={computeDensity:function(x){throw Error('Not implemented');},computePercentile:function(x){throw Error('Not implemented');},computeComplementaryPercentile:function(x){return 1-this.computePercentile(x);},get mean(){throw Error('Not implemented');},get mode(){throw Error('Not implemented');},get median(){throw Error('Not implemented');},get standardDeviation(){throw Error('Not implemented');},get variance(){throw Error('Not implemented');}};Statistics.UniformDistribution=function(opt_range){if(!opt_range)opt_range=tr.b.Range.fromExplicitRange(0,1);this.range=opt_range;};Statistics.UniformDistribution.prototype={__proto__:Distribution.prototype,computeDensity:function(x){return 1/this.range.range;},computePercentile:function(x){return tr.b.normalize(x,this.range.min,this.range.max);},get mean(){return this.range.center;},get mode(){return undefined;},get median(){return this.mean;},get standardDeviation(){return Math.sqrt(this.variance);},get variance(){return Math.pow(this.range.range,2)/12;}};Statistics.NormalDistribution=function(opt_mean,opt_variance){this.mean_=opt_mean||0;this.variance_=opt_variance||1;this.standardDeviation_=Math.sqrt(this.variance_);};Statistics.NormalDistribution.prototype={__proto__:Distribution.prototype,computeDensity:function(x){var scale=1.0/(this.standardDeviation*Math.sqrt(2.0*Math.PI));var exponent=-Math.pow(x-this.mean,2)/(2.0*this.variance);return scale*Math.exp(exponent);},computePercentile:function(x){var standardizedX=(x-this.mean)/Math.sqrt(2.0*this.variance);return(1.0+tr.b.erf(standardizedX))/2.0;},get mean(){return this.mean_;},get median(){return this.mean;},get mode(){return this.mean;},get standardDeviation(){return this.standardDeviation_;},get variance(){return this.variance_;}};Statistics.LogNormalDistribution=function(opt_location,opt_shape){this.normalDistribution_=new Statistics.NormalDistribution(opt_location,Math.pow(opt_shape||1,2));};Statistics.LogNormalDistribution.prototype={__proto__:Statistics.NormalDistribution.prototype,computeDensity:function(x){return this.normalDistribution_.computeDensity(Math.log(x))/x;},computePercentile:function(x){return this.normalDistribution_.computePercentile(Math.log(x));},get mean(){return Math.exp(this.normalDistribution_.mean+this.normalDistribution_.variance/2);},get variance(){var nm=this.normalDistribution_.mean;var nv=this.normalDistribution_.variance;return Math.exp(2*(nm+nv))-Math.exp(2*nm+nv);},get standardDeviation(){return Math.sqrt(this.variance);},get median(){return Math.exp(this.normalDistribution_.mean);},get mode(){return Math.exp(this.normalDistribution_.mean-this.normalDistribution_.variance);}};Statistics.LogNormalDistribution.fromMedianAndDiminishingReturns=function(median,diminishingReturns){diminishingReturns=Math.log(diminishingReturns/median);var shape=Math.sqrt(1-3*diminishingReturns-Math.sqrt(Math.pow(diminishingReturns-3,2)-8))/2;var location=Math.log(median);return new Statistics.LogNormalDistribution(location,shape);};Statistics.DEFAULT_ALPHA=0.05;Statistics.Significance={INSIGNIFICANT:-1,DONT_CARE:0,SIGNIFICANT:1};Statistics.mwu=function(a,b,opt_alpha){var result=mannwhitneyu.test(a,b);var alpha=opt_alpha||Statistics.DEFAULT_ALPHA;result.significance=result.p<alpha?Statistics.Significance.SIGNIFICANT:Statistics.Significance.INSIGNIFICANT;return result;};return{Statistics:Statistics};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./math.js":47,"./range.js":52}],59:[function(require,module,exports){(function(global){"use strict";require("./raf.js");require("./timing.js");'use strict';global.tr.exportTo('tr.b',function(){var Timing=tr.b.Timing;function Task(runCb,thisArg){if(runCb!==undefined&&thisArg===undefined)throw new Error('Almost certainly, you meant to pass a thisArg.');this.runCb_=runCb;this.thisArg_=thisArg;this.afterTask_=undefined;this.subTasks_=[];}Task.prototype={get name(){return this.runCb_.name;},subTask:function(cb,thisArg){if(cb instanceof Task)this.subTasks_.push(cb);else this.subTasks_.push(new Task(cb,thisArg));return this.subTasks_[this.subTasks_.length-1];},run:function(){if(this.runCb_!==undefined)this.runCb_.call(this.thisArg_,this);var subTasks=this.subTasks_;this.subTasks_=undefined;if(!subTasks.length)return this.afterTask_;for(var i=1;i<subTasks.length;i++)subTasks[i-1].afterTask_=subTasks[i];subTasks[subTasks.length-1].afterTask_=this.afterTask_;return subTasks[0];},after:function(cb,thisArg){if(this.afterTask_)throw new Error('Has an after task already');if(cb instanceof Task)this.afterTask_=cb;else this.afterTask_=new Task(cb,thisArg);return this.afterTask_;},timedAfter:function(groupName,cb,thisArg,opt_args){if(cb.name==='')throw new Error('Anonymous Task is not allowed');return this.namedTimedAfter(groupName,cb.name,cb,thisArg,opt_args);},namedTimedAfter:function(groupName,name,cb,thisArg,opt_args){if(this.afterTask_)throw new Error('Has an after task already');var realTask;if(cb instanceof Task)realTask=cb;else realTask=new Task(cb,thisArg);this.afterTask_=new Task(function(task){var markedTask=Timing.mark(groupName,name,opt_args);task.subTask(realTask,thisArg);task.subTask(function(){markedTask.end();},thisArg);},thisArg);return this.afterTask_;},enqueue:function(cb,thisArg){var lastTask=this;while(lastTask.afterTask_)lastTask=lastTask.afterTask_;return lastTask.after(cb,thisArg);}};Task.RunSynchronously=function(task){var curTask=task;while(curTask)curTask=curTask.run();};Task.RunWhenIdle=function(task){return new Promise(function(resolve,reject){var curTask=task;function runAnother(){try{curTask=curTask.run();}catch(e){reject(e);console.assert(true,e.stack);return;}if(curTask){tr.b.requestIdleCallback(runAnother);return;}resolve();}tr.b.requestIdleCallback(runAnother);});};return{Task:Task};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./raf.js":51,"./timing.js":61}],60:[function(require,module,exports){(function(global){"use strict";require("./unit_scale.js");'use strict';global.tr.exportTo('tr.b',function(){var msDisplayMode={scale:1e-3,suffix:'ms',roundedLess:function(a,b){return Math.round(a*1000)<Math.round(b*1000);},formatSpec:{unit:'s',unitPrefix:tr.b.UnitScale.Metric.MILLI,minimumFractionDigits:3}};var nsDisplayMode={scale:1e-9,suffix:'ns',roundedLess:function(a,b){return Math.round(a*1000000)<Math.round(b*1000000);},formatSpec:{unit:'s',unitPrefix:tr.b.UnitScale.Metric.NANO,maximumFractionDigits:0}};var TimeDisplayModes={ns:nsDisplayMode,ms:msDisplayMode};return{TimeDisplayModes:TimeDisplayModes};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./unit_scale.js":63}],61:[function(require,module,exports){(function(global){"use strict";require("./base.js");require("./base64.js");'use strict';global.tr.exportTo('tr.b',function(){var Base64=tr.b.Base64;function computeUserTimingMarkName(groupName,functionName,opt_args){if(groupName===undefined)throw new Error('getMeasureString should have group name');if(functionName===undefined)throw new Error('getMeasureString should have function name');var userTimingMarkName=groupName+':'+functionName;if(opt_args!==undefined){userTimingMarkName+='/';userTimingMarkName+=Base64.btoa(JSON.stringify(opt_args));}return userTimingMarkName;}function Timing(){}Timing.nextMarkNumber=0;Timing.mark=function(groupName,functionName,opt_args){if(tr.isHeadless){return{end:function(){}};}var userTimingMarkName=computeUserTimingMarkName(groupName,functionName,opt_args);var markBeginName='tvcm.mark'+Timing.nextMarkNumber++;var markEndName='tvcm.mark'+Timing.nextMarkNumber++;window.performance.mark(markBeginName);return{end:function(){window.performance.mark(markEndName);window.performance.measure(userTimingMarkName,markBeginName,markEndName);}};};Timing.wrap=function(groupName,callback,opt_args){if(groupName===undefined)throw new Error('Timing.wrap should have group name');if(callback.name==='')throw new Error('Anonymous function is not allowed');return Timing.wrapNamedFunction(groupName,callback.name,callback,opt_args);};Timing.wrapNamedFunction=function(groupName,functionName,callback,opt_args){function timedNamedFunction(){var markedTime=Timing.mark(groupName,functionName,opt_args);try{callback.apply(this,arguments);}finally{markedTime.end();}}return timedNamedFunction;};function TimedNamedPromise(groupName,name,executor,opt_args){var markedTime=Timing.mark(groupName,name,opt_args);var promise=new Promise(executor);promise.then(function(result){markedTime.end();return result;},function(e){markedTime.end();throw e;});return promise;}return{_computeUserTimingMarkName:computeUserTimingMarkName,TimedNamedPromise:TimedNamedPromise,Timing:Timing};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33,"./base64.js":34}],62:[function(require,module,exports){(function(global){"use strict";require("./event.js");require("./event_target.js");require("./iteration_helpers.js");require("./time_display_modes.js");require("./unit_scale.js");'use strict';global.tr.exportTo('tr.b',function(){var TimeDisplayModes=tr.b.TimeDisplayModes;var PLUS_MINUS_SIGN=String.fromCharCode(177);function max(a,b){if(a===undefined)return b;if(b===undefined)return a;return a.scale>b.scale?a:b;}var ImprovementDirection={DONT_CARE:0,BIGGER_IS_BETTER:1,SMALLER_IS_BETTER:2};function Unit(unitName,jsonName,basePrefix,isDelta,improvementDirection,formatSpec){this.unitName=unitName;this.jsonName=jsonName;this.basePrefix=basePrefix;this.isDelta=isDelta;this.improvementDirection=improvementDirection;this.formatSpec_=formatSpec;this.baseUnit=undefined;this.correspondingDeltaUnit=undefined;}Unit.prototype={asJSON:function(){return this.jsonName;},get unitString(){var formatSpec=this.formatSpec_;if(typeof formatSpec==='function')formatSpec=formatSpec();if(!formatSpec.unit){return'';}var unitString='';var unitPrefix=formatSpec.unitPrefix;if(unitPrefix!==undefined){var selectedPrefix;if(unitPrefix instanceof Array){selectedPrefix=unitPrefix[0];}else{selectedPrefix=unitPrefix;}unitString+=selectedPrefix.symbol||'';}unitString+=formatSpec.unit;return unitString;},format:function(value,opt_context){var context=opt_context||{};var formatSpec=this.formatSpec_;if(typeof formatSpec==='function')formatSpec=formatSpec();function resolveProperty(propertyName){if(propertyName in context)return context[propertyName];else if(propertyName in formatSpec)return formatSpec[propertyName];else return undefined;}var signString='';if(value<0){signString='-';value=-value;}else if(this.isDelta){signString=value===0?PLUS_MINUS_SIGN:'+';}var unitString='';if(formatSpec.unit){if(formatSpec.unitHasPrecedingSpace!==false)unitString+=' ';var unitPrefix=resolveProperty('unitPrefix');if(unitPrefix!==undefined){var selectedPrefix;if(unitPrefix instanceof Array){var i=0;while(i<unitPrefix.length-1&&value/unitPrefix[i+1].value>=1){i++;}selectedPrefix=unitPrefix[i];}else{selectedPrefix=unitPrefix;}unitString+=selectedPrefix.symbol||'';value=tr.b.convertUnit(value,this.basePrefix,selectedPrefix);}else{value=tr.b.convertUnit(value,this.basePrefix,tr.b.UnitScale.Metric.NONE);}unitString+=formatSpec.unit;}var minimumFractionDigits=resolveProperty('minimumFractionDigits');var maximumFractionDigits=resolveProperty('maximumFractionDigits');if(minimumFractionDigits>maximumFractionDigits){if('minimumFractionDigits'in context&&!('maximumFractionDigits'in context)){maximumFractionDigits=minimumFractionDigits;}else if('maximumFractionDigits'in context&&!('minimumFractionDigits'in context)){minimumFractionDigits=maximumFractionDigits;}}var numberString=value.toLocaleString(undefined,{minimumFractionDigits:minimumFractionDigits,maximumFractionDigits:maximumFractionDigits});return signString+numberString+unitString;}};Unit.reset=function(){Unit.currentTimeDisplayMode=TimeDisplayModes.ms;};Unit.timestampFromUs=function(us){return tr.b.convertUnit(us,tr.b.UnitScale.Metric.MICRO,tr.b.UnitScale.Metric.MILLI);};Object.defineProperty(Unit,'currentTimeDisplayMode',{get:function(){return Unit.currentTimeDisplayMode_;},set:function(value){if(Unit.currentTimeDisplayMode_===value)return;Unit.currentTimeDisplayMode_=value;Unit.dispatchEvent(new tr.b.Event('display-mode-changed'));}});Unit.didPreferredTimeDisplayUnitChange=function(){var largest=undefined;var els=tr.b.findDeepElementsMatching(document.body,'tr-v-ui-preferred-display-unit');els.forEach(function(el){largest=max(largest,el.preferredTimeDisplayMode);});Unit.currentDisplayUnit=largest===undefined?TimeDisplayModes.ms:largest;};Unit.byName={};Unit.byJSONName={};Unit.fromJSON=function(object){var u=Unit.byJSONName[object];if(u){return u;}throw new Error('Unrecognized unit');};Unit.define=function(params){var definedUnits=[];tr.b.iterItems(ImprovementDirection,function(_,improvementDirection){var regularUnit=Unit.defineUnitVariant_(params,false,improvementDirection);var deltaUnit=Unit.defineUnitVariant_(params,true,improvementDirection);regularUnit.correspondingDeltaUnit=deltaUnit;deltaUnit.correspondingDeltaUnit=deltaUnit;definedUnits.push(regularUnit,deltaUnit);});var baseUnit=Unit.byName[params.baseUnitName];definedUnits.forEach(u=>u.baseUnit=baseUnit);};Unit.nameSuffixForImprovementDirection=function(improvementDirection){switch(improvementDirection){case ImprovementDirection.DONT_CARE:return'';case ImprovementDirection.BIGGER_IS_BETTER:return'_biggerIsBetter';case ImprovementDirection.SMALLER_IS_BETTER:return'_smallerIsBetter';default:throw new Error('Unknown improvement direction: '+improvementDirection);}};Unit.defineUnitVariant_=function(params,isDelta,improvementDirection){var nameSuffix=isDelta?'Delta':'';nameSuffix+=Unit.nameSuffixForImprovementDirection(improvementDirection);var unitName=params.baseUnitName+nameSuffix;var jsonName=params.baseJsonName+nameSuffix;if(Unit.byName[unitName]!==undefined)throw new Error('Unit \''+unitName+'\' already exists');if(Unit.byJSONName[jsonName]!==undefined)throw new Error('JSON unit \''+jsonName+'\' alread exists');var basePrefix=params.basePrefix?params.basePrefix:tr.b.UnitScale.Metric.NONE;var unit=new Unit(unitName,jsonName,basePrefix,isDelta,improvementDirection,params.formatSpec);Unit.byName[unitName]=unit;Unit.byJSONName[jsonName]=unit;return unit;};tr.b.EventTarget.decorate(Unit);Unit.reset();Unit.define({baseUnitName:'timeDurationInMs',baseJsonName:'ms',basePrefix:tr.b.UnitScale.Metric.MILLI,formatSpec:function(){return Unit.currentTimeDisplayMode_.formatSpec;}});Unit.define({baseUnitName:'timeStampInMs',baseJsonName:'tsMs',basePrefix:tr.b.UnitScale.Metric.MILLI,formatSpec:function(){return Unit.currentTimeDisplayMode_.formatSpec;}});Unit.define({baseUnitName:'normalizedPercentage',baseJsonName:'n%',formatSpec:{unit:'%',unitPrefix:{value:0.01},unitHasPrecedingSpace:false,minimumFractionDigits:3,maximumFractionDigits:3}});Unit.define({baseUnitName:'sizeInBytes',baseJsonName:'sizeInBytes',formatSpec:{unit:'B',unitPrefix:tr.b.UnitScale.Binary.AUTO,minimumFractionDigits:1,maximumFractionDigits:1}});Unit.define({baseUnitName:'energyInJoules',baseJsonName:'J',formatSpec:{unit:'J',minimumFractionDigits:3}});Unit.define({baseUnitName:'powerInWatts',baseJsonName:'W',formatSpec:{unit:'W',minimumFractionDigits:3}});Unit.define({baseUnitName:'unitlessNumber',baseJsonName:'unitless',formatSpec:{minimumFractionDigits:3,maximumFractionDigits:3}});Unit.define({baseUnitName:'count',baseJsonName:'count',formatSpec:{minimumFractionDigits:0,maximumFractionDigits:0}});Unit.define({baseUnitName:'sigma',baseJsonName:'sigma',formatSpec:{unit:String.fromCharCode(963),minimumFractionDigits:1,maximumFractionDigits:1}});return{ImprovementDirection:ImprovementDirection,Unit:Unit};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./event.js":38,"./event_target.js":39,"./iteration_helpers.js":46,"./time_display_modes.js":60,"./unit_scale.js":63}],63:[function(require,module,exports){(function(global){"use strict";require("./iteration_helpers.js");'use strict';var GREEK_SMALL_LETTER_MU=String.fromCharCode(956);global.tr.exportTo('tr.b',function(){var UnitScale={};function defineUnitScale(name,prefixes){if(UnitScale[name]!==undefined)throw new Error('Unit scale \''+name+'\' already exists');if(prefixes.AUTO!==undefined){throw new Error('\'AUTO\' unit prefix will be added automatically '+'for unit scale \''+name+'\'');}prefixes.AUTO=tr.b.dictionaryValues(prefixes);prefixes.AUTO.sort((a,b)=>a.value-b.value);UnitScale[name]=prefixes;}function convertUnit(value,fromPrefix,toPrefix){if(value===undefined)return undefined;return value*(fromPrefix.value/toPrefix.value);}defineUnitScale('Binary',{NONE:{value:Math.pow(1024,0),symbol:''},KIBI:{value:Math.pow(1024,1),symbol:'Ki'},MEBI:{value:Math.pow(1024,2),symbol:'Mi'},GIBI:{value:Math.pow(1024,3),symbol:'Gi'},TEBI:{value:Math.pow(1024,4),symbol:'Ti'}});defineUnitScale('Metric',{NANO:{value:1e-9,symbol:'n'},MICRO:{value:1e-6,symbol:GREEK_SMALL_LETTER_MU},MILLI:{value:1e-3,symbol:'m'},NONE:{value:1,symbol:''},KILO:{value:1e3,symbol:'k'},MEGA:{value:1e6,symbol:'M'},GIGA:{value:1e9,symbol:'G'}});return{UnitScale:UnitScale,convertUnit:convertUnit};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./iteration_helpers.js":46}],64:[function(require,module,exports){(function(global){"use strict";require("./base.js");'use strict';global.tr.exportTo('tr.b',function(){function addSingletonGetter(ctor){ctor.getInstance=function(){return ctor.instance_||(ctor.instance_=new ctor());};}function deepCopy(value){if(!(value instanceof Object)){if(value===undefined||value===null)return value;if(typeof value=='string')return value.substring();if(typeof value=='boolean')return value;if(typeof value=='number')return value;throw new Error('Unrecognized: '+typeof value);}var object=value;if(object instanceof Array){var res=new Array(object.length);for(var i=0;i<object.length;i++)res[i]=deepCopy(object[i]);return res;}if(object.__proto__!=Object.prototype)throw new Error('Can only clone simple types');var res={};for(var key in object){res[key]=deepCopy(object[key]);}return res;}function normalizeException(e){if(e===undefined||e===null){return{typeName:'UndefinedError',message:'Unknown: null or undefined exception',stack:'Unknown'};}if(typeof e=='string'){return{typeName:'StringError',message:e,stack:[e]};}var typeName;if(e.name){typeName=e.name;}else if(e.constructor){if(e.constructor.name){typeName=e.constructor.name;}else{typeName='AnonymousError';}}else{typeName='ErrorWithNoConstructor';}var msg=e.message?e.message:'Unknown';return{typeName:typeName,message:msg,stack:e.stack?e.stack:[msg]};}function stackTraceAsString(){return new Error().stack+'';}function stackTrace(){var stack=stackTraceAsString();stack=stack.split('\n');return stack.slice(2);}function getUsingPath(path,fromDict){var parts=path.split('.');var cur=fromDict;for(var part;parts.length&&(part=parts.shift());){if(!parts.length){return cur[part];}else if(part in cur){cur=cur[part];}else{return undefined;}}return undefined;}function formatDate(date){return date.toISOString().replace('T',' ').slice(0,19);}return{addSingletonGetter:addSingletonGetter,deepCopy:deepCopy,normalizeException:normalizeException,stackTrace:stackTrace,stackTraceAsString:stackTraceAsString,formatDate:formatDate,getUsingPath:getUsingPath};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./base.js":33}],65:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/extension_registry.js");'use strict';global.tr.exportTo('tr.c',function(){function Auditor(model){this.model_=model;}Auditor.prototype={__proto__:Object.prototype,get model(){return this.model_;},runAnnotate:function(){},installUserFriendlyCategoryDriverIfNeeded:function(){},runAudit:function(){}};var options=new tr.b.ExtensionRegistryOptions(tr.b.BASIC_REGISTRY_MODE);options.defaultMetadata={};options.mandatoryBaseClass=Auditor;tr.b.decorateExtensionRegistry(Auditor,options);return{Auditor:Auditor};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../base/base.js":33,"../base/extension_registry.js":40}],66:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.c',function(){function makeCaseInsensitiveRegex(pattern){pattern=pattern.replace(/[.*+?^${}()|[\]\\]/g,'\\$&');return new RegExp(pattern,'i');}function Filter(){}Filter.prototype={__proto__:Object.prototype,matchCounter:function(counter){return true;},matchCpu:function(cpu){return true;},matchProcess:function(process){return true;},matchSlice:function(slice){return true;},matchThread:function(thread){return true;}};function TitleOrCategoryFilter(text){Filter.call(this);this.regex_=makeCaseInsensitiveRegex(text);if(!text.length)throw new Error('Filter text is empty.');}TitleOrCategoryFilter.prototype={__proto__:Filter.prototype,matchSlice:function(slice){if(slice.title===undefined&&slice.category===undefined)return false;return this.regex_.test(slice.title)||!!slice.category&&this.regex_.test(slice.category);}};function ExactTitleFilter(text){Filter.call(this);this.text_=text;if(!text.length)throw new Error('Filter text is empty.');}ExactTitleFilter.prototype={__proto__:Filter.prototype,matchSlice:function(slice){return slice.title===this.text_;}};function FullTextFilter(text){Filter.call(this);this.regex_=makeCaseInsensitiveRegex(text);this.titleOrCategoryFilter_=new TitleOrCategoryFilter(text);}FullTextFilter.prototype={__proto__:Filter.prototype,matchObject_:function(obj){for(var key in obj){if(!obj.hasOwnProperty(key))continue;if(this.regex_.test(key))return true;if(this.regex_.test(obj[key]))return true;}return false;},matchSlice:function(slice){if(this.titleOrCategoryFilter_.matchSlice(slice))return true;return this.matchObject_(slice.args);}};return{Filter:Filter,TitleOrCategoryFilter:TitleOrCategoryFilter,ExactTitleFilter:ExactTitleFilter,FullTextFilter:FullTextFilter};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../base/base.js":33}],67:[function(require,module,exports){(function(global){"use strict";require("../../../model/async_slice.js");require("../../../model/event_set.js");require("../../../model/helpers/chrome_model_helper.js");'use strict';global.tr.exportTo('tr.e.cc',function(){var AsyncSlice=tr.model.AsyncSlice;var EventSet=tr.model.EventSet;var UI_COMP_NAME='INPUT_EVENT_LATENCY_UI_COMPONENT';var ORIGINAL_COMP_NAME='INPUT_EVENT_LATENCY_ORIGINAL_COMPONENT';var BEGIN_COMP_NAME='INPUT_EVENT_LATENCY_BEGIN_RWH_COMPONENT';var END_COMP_NAME='INPUT_EVENT_LATENCY_TERMINATED_FRAME_SWAP_COMPONENT';var MAIN_RENDERER_THREAD_NAME='CrRendererMain';var COMPOSITOR_THREAD_NAME='Compositor';var POSTTASK_FLOW_EVENT='disabled-by-default-toplevel.flow';var IPC_FLOW_EVENT='disabled-by-default-ipc.flow';var INPUT_EVENT_TYPE_NAMES={CHAR:'Char',CLICK:'GestureClick',CONTEXT_MENU:'ContextMenu',FLING_CANCEL:'GestureFlingCancel',FLING_START:'GestureFlingStart',KEY_DOWN:'KeyDown',KEY_DOWN_RAW:'RawKeyDown',KEY_UP:'KeyUp',LATENCY_SCROLL_UPDATE:'ScrollUpdate',MOUSE_DOWN:'MouseDown',MOUSE_ENTER:'MouseEnter',MOUSE_LEAVE:'MouseLeave',MOUSE_MOVE:'MouseMove',MOUSE_UP:'MouseUp',MOUSE_WHEEL:'MouseWheel',PINCH_BEGIN:'GesturePinchBegin',PINCH_END:'GesturePinchEnd',PINCH_UPDATE:'GesturePinchUpdate',SCROLL_BEGIN:'GestureScrollBegin',SCROLL_END:'GestureScrollEnd',SCROLL_UPDATE:'GestureScrollUpdate',SCROLL_UPDATE_RENDERER:'ScrollUpdate',SHOW_PRESS:'GestureShowPress',TAP:'GestureTap',TAP_CANCEL:'GestureTapCancel',TAP_DOWN:'GestureTapDown',TOUCH_CANCEL:'TouchCancel',TOUCH_END:'TouchEnd',TOUCH_MOVE:'TouchMove',TOUCH_START:'TouchStart',UNKNOWN:'UNKNOWN'};function InputLatencyAsyncSlice(){AsyncSlice.apply(this,arguments);this.associatedEvents_=new EventSet();this.typeName_=undefined;if(!this.isLegacyEvent)this.determineModernTypeName_();}InputLatencyAsyncSlice.prototype={__proto__:AsyncSlice.prototype,get isLegacyEvent(){return this.title==='InputLatency';},get typeName(){if(!this.typeName_)this.determineLegacyTypeName_();return this.typeName_;},checkTypeName_:function(){if(!this.typeName_)throw'Unable to determine typeName';var found=false;for(var typeName in INPUT_EVENT_TYPE_NAMES){if(this.typeName===INPUT_EVENT_TYPE_NAMES[typeName]){found=true;break;}}if(!found)this.typeName_=INPUT_EVENT_TYPE_NAMES.UNKNOWN;},determineModernTypeName_:function(){var lastColonIndex=this.title.lastIndexOf(':');if(lastColonIndex<0)return;var characterAfterLastColonIndex=lastColonIndex+1;this.typeName_=this.title.slice(characterAfterLastColonIndex);this.checkTypeName_();},determineLegacyTypeName_:function(){for(var subSlice of this.enumerateAllDescendents()){var subSliceIsAInputLatencyAsyncSlice=subSlice instanceof InputLatencyAsyncSlice;if(!subSliceIsAInputLatencyAsyncSlice)continue;if(!subSlice.typeName)continue;if(this.typeName_&&subSlice.typeName_){var subSliceHasDifferentTypeName=this.typeName_!==subSlice.typeName_;if(subSliceHasDifferentTypeName){throw'InputLatencyAsyncSlice.determineLegacyTypeName_() '+' found multiple typeNames';}}this.typeName_=subSlice.typeName_;}if(!this.typeName_)throw'InputLatencyAsyncSlice.determineLegacyTypeName_() failed';this.checkTypeName_();},getRendererHelper:function(sourceSlices){var traceModel=this.startThread.parent.model;var modelHelper=traceModel.getOrCreateHelper(tr.model.helpers.ChromeModelHelper);if(!modelHelper)return undefined;var mainThread=undefined;var compositorThread=undefined;for(var i in sourceSlices){if(sourceSlices[i].parentContainer.name===MAIN_RENDERER_THREAD_NAME)mainThread=sourceSlices[i].parentContainer;else if(sourceSlices[i].parentContainer.name===COMPOSITOR_THREAD_NAME)compositorThread=sourceSlices[i].parentContainer;if(mainThread&&compositorThread)break;}var rendererHelpers=modelHelper.rendererHelpers;var pids=Object.keys(rendererHelpers);for(var i=0;i<pids.length;i++){var pid=pids[i];var rendererHelper=rendererHelpers[pid];if(rendererHelper.mainThread===mainThread||rendererHelper.compositorThread===compositorThread)return rendererHelper;}return undefined;},addEntireSliceHierarchy:function(slice){this.associatedEvents_.push(slice);slice.iterateAllSubsequentSlices(function(subsequentSlice){this.associatedEvents_.push(subsequentSlice);},this);},addDirectlyAssociatedEvents:function(flowEvents){var slices=[];flowEvents.forEach(function(flowEvent){this.associatedEvents_.push(flowEvent);var newSource=flowEvent.startSlice.mostTopLevelSlice;if(slices.indexOf(newSource)===-1)slices.push(newSource);},this);var lastFlowEvent=flowEvents[flowEvents.length-1];var lastSource=lastFlowEvent.endSlice.mostTopLevelSlice;if(slices.indexOf(lastSource)===-1)slices.push(lastSource);return slices;},addScrollUpdateEvents:function(rendererHelper){if(!rendererHelper||!rendererHelper.compositorThread)return;var compositorThread=rendererHelper.compositorThread;var gestureScrollUpdateStart=this.start;var gestureScrollUpdateEnd=this.end;var allCompositorAsyncSlices=compositorThread.asyncSliceGroup.slices;for(var i in allCompositorAsyncSlices){var slice=allCompositorAsyncSlices[i];if(slice.title!=='Latency::ScrollUpdate')continue;var parentId=slice.args.data.INPUT_EVENT_LATENCY_FORWARD_SCROLL_UPDATE_TO_MAIN_COMPONENT.sequence_number;if(parentId===undefined){if(slice.start<gestureScrollUpdateStart||slice.start>=gestureScrollUpdateEnd)continue;}else{if(parseInt(parentId)!==parseInt(this.id))continue;}slice.associatedEvents.forEach(function(event){this.associatedEvents_.push(event);},this);break;}},belongToOtherInputs:function(slice,flowEvents){var fromOtherInputs=false;slice.iterateEntireHierarchy(function(subsequentSlice){if(fromOtherInputs)return;subsequentSlice.inFlowEvents.forEach(function(inflow){if(fromOtherInputs)return;if(inflow.category.indexOf('input')>-1){if(flowEvents.indexOf(inflow)===-1)fromOtherInputs=true;}},this);},this);return fromOtherInputs;},triggerOtherInputs:function(event,flowEvents){if(event.outFlowEvents===undefined||event.outFlowEvents.length===0)return false;var flow=event.outFlowEvents[0];if(flow.category!==POSTTASK_FLOW_EVENT||!flow.endSlice)return false;var endSlice=flow.endSlice;if(this.belongToOtherInputs(endSlice.mostTopLevelSlice,flowEvents))return true;return false;},followSubsequentSlices:function(event,queue,visited,flowEvents){var stopFollowing=false;var inputAck=false;event.iterateAllSubsequentSlices(function(slice){if(stopFollowing)return;if(slice.title==='TaskQueueManager::RunTask')return;if(slice.title==='ThreadProxy::ScheduledActionSendBeginMainFrame')return;if(slice.title==='Scheduler::ScheduleBeginImplFrameDeadline'){if(this.triggerOtherInputs(slice,flowEvents))return;}if(slice.title==='CompositorImpl::PostComposite'){if(this.triggerOtherInputs(slice,flowEvents))return;}if(slice.title==='InputRouterImpl::ProcessInputEventAck')inputAck=true;if(inputAck&&slice.title==='InputRouterImpl::FilterAndSendWebInputEvent')stopFollowing=true;this.followCurrentSlice(slice,queue,visited);},this);},followCurrentSlice:function(event,queue,visited){event.outFlowEvents.forEach(function(outflow){if((outflow.category===POSTTASK_FLOW_EVENT||outflow.category===IPC_FLOW_EVENT)&&outflow.endSlice){this.associatedEvents_.push(outflow);var nextEvent=outflow.endSlice.mostTopLevelSlice;if(!visited.contains(nextEvent)){visited.push(nextEvent);queue.push(nextEvent);}}},this);},backtraceFromDraw:function(beginImplFrame,visited){var pendingEventQueue=[];pendingEventQueue.push(beginImplFrame.mostTopLevelSlice);while(pendingEventQueue.length!==0){var event=pendingEventQueue.pop();this.addEntireSliceHierarchy(event);event.inFlowEvents.forEach(function(inflow){if(inflow.category===POSTTASK_FLOW_EVENT&&inflow.startSlice){var nextEvent=inflow.startSlice.mostTopLevelSlice;if(!visited.contains(nextEvent)){visited.push(nextEvent);pendingEventQueue.push(nextEvent);}}},this);}},sortRasterizerSlices:function(rasterWorkerThreads,sortedRasterizerSlices){rasterWorkerThreads.forEach(function(rasterizer){Array.prototype.push.apply(sortedRasterizerSlices,rasterizer.sliceGroup.slices);},this);sortedRasterizerSlices.sort(function(a,b){if(a.start!==b.start)return a.start-b.start;return a.guid-b.guid;});},addRasterizationEvents:function(prepareTiles,rendererHelper,visited,flowEvents,sortedRasterizerSlices){if(!prepareTiles.args.prepare_tiles_id)return;if(!rendererHelper||!rendererHelper.rasterWorkerThreads)return;var rasterWorkerThreads=rendererHelper.rasterWorkerThreads;var prepareTileId=prepareTiles.args.prepare_tiles_id;var pendingEventQueue=[];if(sortedRasterizerSlices.length===0)this.sortRasterizerSlices(rasterWorkerThreads,sortedRasterizerSlices);var numFinishedTasks=0;var RASTER_TASK_TITLE='RasterizerTaskImpl::RunOnWorkerThread';var IMAGEDECODE_TASK_TITLE='ImageDecodeTaskImpl::RunOnWorkerThread';var FINISHED_TASK_TITLE='TaskSetFinishedTaskImpl::RunOnWorkerThread';for(var i=0;i<sortedRasterizerSlices.length;i++){var task=sortedRasterizerSlices[i];if(task.title===RASTER_TASK_TITLE||task.title===IMAGEDECODE_TASK_TITLE){if(task.args.source_prepare_tiles_id===prepareTileId)this.addEntireSliceHierarchy(task.mostTopLevelSlice);}else if(task.title===FINISHED_TASK_TITLE){if(task.start>prepareTiles.start){pendingEventQueue.push(task.mostTopLevelSlice);if(++numFinishedTasks===3)break;}}}while(pendingEventQueue.length!=0){var event=pendingEventQueue.pop();this.addEntireSliceHierarchy(event);this.followSubsequentSlices(event,pendingEventQueue,visited,flowEvents);}},addOtherCausallyRelatedEvents:function(rendererHelper,sourceSlices,flowEvents,sortedRasterizerSlices){var pendingEventQueue=[];var visitedEvents=new EventSet();var beginImplFrame=undefined;var prepareTiles=undefined;var sortedRasterizerSlices=[];sourceSlices.forEach(function(sourceSlice){if(!visitedEvents.contains(sourceSlice)){visitedEvents.push(sourceSlice);pendingEventQueue.push(sourceSlice);}},this);while(pendingEventQueue.length!=0){var event=pendingEventQueue.pop();this.addEntireSliceHierarchy(event);this.followCurrentSlice(event,pendingEventQueue,visitedEvents);this.followSubsequentSlices(event,pendingEventQueue,visitedEvents,flowEvents);var COMPOSITOR_PREPARE_TILES='TileManager::PrepareTiles';prepareTiles=event.findDescendentSlice(COMPOSITOR_PREPARE_TILES);if(prepareTiles)this.addRasterizationEvents(prepareTiles,rendererHelper,visitedEvents,flowEvents,sortedRasterizerSlices);var COMPOSITOR_ON_BIFD='Scheduler::OnBeginImplFrameDeadline';beginImplFrame=event.findDescendentSlice(COMPOSITOR_ON_BIFD);if(beginImplFrame)this.backtraceFromDraw(beginImplFrame,visitedEvents);}var INPUT_GSU='InputLatency::GestureScrollUpdate';if(this.title===INPUT_GSU)this.addScrollUpdateEvents(rendererHelper);},get associatedEvents(){if(this.associatedEvents_.length!==0)return this.associatedEvents_;var modelIndices=this.startThread.parent.model.modelIndices;var flowEvents=modelIndices.getFlowEventsWithId(this.id);if(flowEvents.length===0)return this.associatedEvents_;var sourceSlices=this.addDirectlyAssociatedEvents(flowEvents);var rendererHelper=this.getRendererHelper(sourceSlices);this.addOtherCausallyRelatedEvents(rendererHelper,sourceSlices,flowEvents);return this.associatedEvents_;},get inputLatency(){if(!('data'in this.args))return undefined;var data=this.args.data;if(!(END_COMP_NAME in data))return undefined;var latency=0;var endTime=data[END_COMP_NAME].time;if(ORIGINAL_COMP_NAME in data){latency=endTime-data[ORIGINAL_COMP_NAME].time;}else if(UI_COMP_NAME in data){latency=endTime-data[UI_COMP_NAME].time;}else if(BEGIN_COMP_NAME in data){latency=endTime-data[BEGIN_COMP_NAME].time;}else{throw new Error('No valid begin latency component');}return latency;}};var eventTypeNames=['Char','ContextMenu','GestureClick','GestureFlingCancel','GestureFlingStart','GestureScrollBegin','GestureScrollEnd','GestureScrollUpdate','GestureShowPress','GestureTap','GestureTapCancel','GestureTapDown','GesturePinchBegin','GesturePinchEnd','GesturePinchUpdate','KeyDown','KeyUp','MouseDown','MouseEnter','MouseLeave','MouseMove','MouseUp','MouseWheel','RawKeyDown','ScrollUpdate','TouchCancel','TouchEnd','TouchMove','TouchStart'];var allTypeNames=['InputLatency'];eventTypeNames.forEach(function(eventTypeName){allTypeNames.push('InputLatency:'+eventTypeName);allTypeNames.push('InputLatency::'+eventTypeName);});AsyncSlice.subTypes.register(InputLatencyAsyncSlice,{typeNames:allTypeNames,categoryParts:['latencyInfo']});return{InputLatencyAsyncSlice:InputLatencyAsyncSlice,INPUT_EVENT_TYPE_NAMES:INPUT_EVENT_TYPE_NAMES};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../../../model/async_slice.js":108,"../../../model/event_set.js":125,"../../../model/helpers/chrome_model_helper.js":132}],68:[function(require,module,exports){(function(global){"use strict";require("../../base/event.js");require("../../base/iteration_helpers.js");require("../../base/sinebow_color_generator.js");'use strict';global.tr.exportTo('tr.e.chrome',function(){var SAME_AS_PARENT='same-as-parent';var TITLES_FOR_USER_FRIENDLY_CATEGORY={composite:['CompositingInputsUpdater::update','ThreadProxy::SetNeedsUpdateLayers','LayerTreeHost::UpdateLayers::CalcDrawProps','UpdateLayerTree'],gc:['minorGC','majorGC','MajorGC','MinorGC','V8.GCScavenger','V8.GCIncrementalMarking','V8.GCIdleNotification','V8.GCContext','V8.GCCompactor','V8GCController::traceDOMWrappers'],iframe_creation:['WebLocalFrameImpl::createChildframe'],imageDecode:['Decode Image','ImageFrameGenerator::decode','ImageFrameGenerator::decodeAndScale'],input:['HitTest','ScrollableArea::scrollPositionChanged','EventHandler::handleMouseMoveEvent'],layout:['FrameView::invalidateTree','FrameView::layout','FrameView::performLayout','FrameView::performPostLayoutTasks','FrameView::performPreLayoutTasks','Layer::updateLayerPositionsAfterLayout','Layout','LayoutView::hitTest','ResourceLoadPriorityOptimizer::updateAllImageResourcePriorities','WebViewImpl::layout'],parseHTML:['ParseHTML','HTMLDocumentParser::didReceiveParsedChunkFromBackgroundParser','HTMLDocumentParser::processParsedChunkFromBackgroundParser'],raster:['DisplayListRasterSource::PerformSolidColorAnalysis','Picture::Raster','RasterBufferImpl::Playback','RasterTask','RasterizerTaskImpl::RunOnWorkerThread','SkCanvas::drawImageRect()','SkCanvas::drawPicture()','SkCanvas::drawTextBlob()','TileTaskWorkerPool::PlaybackToMemory'],record:['ContentLayerDelegate::paintContents','DeprecatedPaintLayerCompositor::updateIfNeededRecursive','DeprecatedPaintLayerCompositor::updateLayerPositionsAfterLayout','Paint','Picture::Record','PictureLayer::Update','RenderLayer::updateLayerPositionsAfterLayout'],style:['CSSParserImpl::parseStyleSheet.parse','CSSParserImpl::parseStyleSheet.tokenize','Document::updateStyle','Document::updateStyleInvalidationIfNeeded','ParseAuthorStyleSheet','RuleSet::addRulesFromSheet','StyleElement::processStyleSheet','StyleEngine::createResolver','StyleSheetContents::parseAuthorStyleSheet','UpdateLayoutTree'],script_parse_and_compile:['v8.parseOnBackground','V8.ScriptCompiler'],script_execute:['V8.Execute','WindowProxy::initialize'],resource_loading:['ResourceFetcher::requestResource','ResourceDispatcher::OnReceivedData','ResourceDispatcher::OnRequestComplete','ResourceDispatcher::OnReceivedResponse','Resource::appendData'],renderer_misc:['DecodeFont','ThreadState::completeSweep'],v8_runtime:[],[SAME_AS_PARENT]:['SyncChannel::Send']};var COLOR_FOR_USER_FRIENDLY_CATEGORY=new tr.b.SinebowColorGenerator();var USER_FRIENDLY_CATEGORY_FOR_TITLE=new Map();for(var category in TITLES_FOR_USER_FRIENDLY_CATEGORY){TITLES_FOR_USER_FRIENDLY_CATEGORY[category].forEach(function(title){USER_FRIENDLY_CATEGORY_FOR_TITLE.set(title,category);});}var USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY={netlog:'net',overhead:'overhead',startup:'startup',gpu:'gpu'};function ChromeUserFriendlyCategoryDriver(){}ChromeUserFriendlyCategoryDriver.fromEvent=function(event){var userFriendlyCategory=USER_FRIENDLY_CATEGORY_FOR_TITLE.get(event.title);if(userFriendlyCategory){if(userFriendlyCategory==SAME_AS_PARENT){if(event.parentSlice)return ChromeUserFriendlyCategoryDriver.fromEvent(event.parentSlice);}else{return userFriendlyCategory;}}var eventCategoryParts=tr.b.getCategoryParts(event.category);for(var i=0;i<eventCategoryParts.length;++i){var eventCategory=eventCategoryParts[i];userFriendlyCategory=USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY[eventCategory];if(userFriendlyCategory)return userFriendlyCategory;}return'other';};ChromeUserFriendlyCategoryDriver.getColor=function(ufc){return COLOR_FOR_USER_FRIENDLY_CATEGORY.colorForKey(ufc);};ChromeUserFriendlyCategoryDriver.ALL_TITLES=['other'];for(var category in TITLES_FOR_USER_FRIENDLY_CATEGORY){if(category===SAME_AS_PARENT)continue;ChromeUserFriendlyCategoryDriver.ALL_TITLES.push(category);}for(var category of tr.b.dictionaryValues(USER_FRIENDLY_CATEGORY_FOR_EVENT_CATEGORY)){ChromeUserFriendlyCategoryDriver.ALL_TITLES.push(category);}ChromeUserFriendlyCategoryDriver.ALL_TITLES.sort();for(var category of ChromeUserFriendlyCategoryDriver.ALL_TITLES)ChromeUserFriendlyCategoryDriver.getColor(category);return{ChromeUserFriendlyCategoryDriver:ChromeUserFriendlyCategoryDriver};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../../base/event.js":38,"../../base/iteration_helpers.js":46,"../../base/sinebow_color_generator.js":56}],69:[function(require,module,exports){(function(global){"use strict";require("../../model/source_info/js_source_info.js");'use strict';global.tr.exportTo('tr.e.importer',function(){function TraceCodeEntry(address,size,name,scriptId){this.id_=tr.b.GUID.allocateSimple();this.address_=address;this.size_=size;var rePrefix=/^(\w*:)?([*~]?)(.*)$/m;var tokens=rePrefix.exec(name);var prefix=tokens[1];var state=tokens[2];var body=tokens[3];if(state==='*'){state=tr.model.source_info.JSSourceState.OPTIMIZED;}else if(state==='~'){state=tr.model.source_info.JSSourceState.OPTIMIZABLE;}else if(state===''){state=tr.model.source_info.JSSourceState.COMPILED;}else{console.warning('Unknown v8 code state '+state);state=tr.model.source_info.JSSourceState.UNKNOWN;}var rawName;var rawUrl;if(prefix==='Script:'){rawName='';rawUrl=body;}else{var spacePos=body.lastIndexOf(' ');rawName=spacePos!==-1?body.substr(0,spacePos):body;rawUrl=spacePos!==-1?body.substr(spacePos+1):'';}function splitLineAndColumn(url){var lineColumnRegEx=/(?::(\d+))?(?::(\d+))?$/;var lineColumnMatch=lineColumnRegEx.exec(url);var lineNumber;var columnNumber;if(typeof lineColumnMatch[1]==='string'){lineNumber=parseInt(lineColumnMatch[1],10);lineNumber=isNaN(lineNumber)?undefined:lineNumber-1;}if(typeof lineColumnMatch[2]==='string'){columnNumber=parseInt(lineColumnMatch[2],10);columnNumber=isNaN(columnNumber)?undefined:columnNumber-1;}return{url:url.substring(0,url.length-lineColumnMatch[0].length),lineNumber:lineNumber,columnNumber:columnNumber};}var nativeSuffix=' native';var isNative=rawName.endsWith(nativeSuffix);this.name_=isNative?rawName.slice(0,-nativeSuffix.length):rawName;var urlData=splitLineAndColumn(rawUrl);var url=urlData.url||'';var line=urlData.lineNumber||0;var column=urlData.columnNumber||0;this.sourceInfo_=new tr.model.source_info.JSSourceInfo(url,line,column,isNative,scriptId,state);};TraceCodeEntry.prototype={get id(){return this.id_;},get sourceInfo(){return this.sourceInfo_;},get name(){return this.name_;},set address(address){this.address_=address;},get address(){return this.address_;},set size(size){this.size_=size;},get size(){return this.size_;}};return{TraceCodeEntry:TraceCodeEntry};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../../model/source_info/js_source_info.js":158}],70:[function(require,module,exports){(function(global){"use strict";require("./trace_code_entry.js");'use strict';global.tr.exportTo('tr.e.importer',function(){function TraceCodeMap(){this.banks_=new Map();}TraceCodeMap.prototype={addEntry:function(addressHex,size,name,scriptId){var entry=new tr.e.importer.TraceCodeEntry(this.getAddress_(addressHex),size,name,scriptId);this.addEntry_(addressHex,entry);},moveEntry:function(oldAddressHex,newAddressHex,size){var entry=this.getBank_(oldAddressHex).removeEntry(this.getAddress_(oldAddressHex));if(!entry)return;entry.address=this.getAddress_(newAddressHex);entry.size=size;this.addEntry_(newAddressHex,entry);},lookupEntry:function(addressHex){return this.getBank_(addressHex).lookupEntry(this.getAddress_(addressHex));},addEntry_:function(addressHex,entry){this.getBank_(addressHex).addEntry(entry);},getAddress_:function(addressHex){var bankSizeHexDigits=13;addressHex=addressHex.slice(2);return parseInt(addressHex.slice(-bankSizeHexDigits),16);},getBank_:function(addressHex){addressHex=addressHex.slice(2);var bankSizeHexDigits=13;var maxHexDigits=16;var bankName=addressHex.slice(-maxHexDigits,-bankSizeHexDigits);var bank=this.banks_.get(bankName);if(!bank){bank=new TraceCodeBank();this.banks_.set(bankName,bank);}return bank;}};function TraceCodeBank(){this.entries_=[];}TraceCodeBank.prototype={removeEntry:function(address){if(this.entries_.length===0)return undefined;var index=tr.b.findLowIndexInSortedArray(this.entries_,function(entry){return entry.address;},address);var entry=this.entries_[index];if(!entry||entry.address!==address)return undefined;this.entries_.splice(index,1);return entry;},lookupEntry:function(address){var index=tr.b.findHighIndexInSortedArray(this.entries_,function(e){return address-e.address;})-1;var entry=this.entries_[index];return entry&&address<entry.address+entry.size?entry:undefined;},addEntry:function(newEntry){if(this.entries_.length===0)this.entries_.push(newEntry);var endAddress=newEntry.address+newEntry.size;var lastIndex=tr.b.findLowIndexInSortedArray(this.entries_,function(entry){return entry.address;},endAddress);var index;for(index=lastIndex-1;index>=0;--index){var entry=this.entries_[index];var entryEndAddress=entry.address+entry.size;if(entryEndAddress<=newEntry.address)break;}++index;this.entries_.splice(index,lastIndex-index,newEntry);}};return{TraceCodeMap:TraceCodeMap};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./trace_code_entry.js":69}],71:[function(require,module,exports){(function(global){"use strict";require("../../base/base64.js");require("../../base/color_scheme.js");require("../../base/range.js");require("../../base/unit.js");require("../../base/utils.js");require("./trace_code_entry.js");require("./trace_code_map.js");require("./v8/codemap.js");require("../../importer/context_processor.js");require("../../importer/importer.js");require("../../model/comment_box_annotation.js");require("../../model/constants.js");require("../../model/container_memory_dump.js");require("../../model/counter_series.js");require("../../model/flow_event.js");require("../../model/global_memory_dump.js");require("../../model/heap_dump.js");require("../../model/instant_event.js");require("../../model/memory_allocator_dump.js");require("../../model/model.js");require("../../model/process_memory_dump.js");require("../../model/rect_annotation.js");require("../../model/scoped_id.js");require("../../model/slice_group.js");require("../../model/vm_region.js");require("../../model/x_marker_annotation.js");require("../../value/numeric.js");'use strict';global.tr.exportTo('tr.e.importer',function(){var Base64=tr.b.Base64;var deepCopy=tr.b.deepCopy;var ColorScheme=tr.b.ColorScheme;function getEventColor(event,opt_customName){if(event.cname)return ColorScheme.getColorIdForReservedName(event.cname);else if(opt_customName||event.name){return ColorScheme.getColorIdForGeneralPurposeString(opt_customName||event.name);}}var PRODUCER='producer';var CONSUMER='consumer';var STEP='step';var BACKGROUND=tr.model.ContainerMemoryDump.LevelOfDetail.BACKGROUND;var LIGHT=tr.model.ContainerMemoryDump.LevelOfDetail.LIGHT;var DETAILED=tr.model.ContainerMemoryDump.LevelOfDetail.DETAILED;var MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER=[undefined,BACKGROUND,LIGHT,DETAILED];var GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX='global/';var ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX='ClockSyncEvent.';var BYTE_STAT_NAME_MAP={'pc':'privateCleanResident','pd':'privateDirtyResident','sc':'sharedCleanResident','sd':'sharedDirtyResident','pss':'proportionalResident','sw':'swapped'};var WEAK_MEMORY_ALLOCATOR_DUMP_FLAG=1<<0;var OBJECT_TYPE_NAME_PATTERNS=[{prefix:'const char *WTF::getStringWithTypeName() [T = ',suffix:']'},{prefix:'const char* WTF::getStringWithTypeName() [with T = ',suffix:']'},{prefix:'const char *__cdecl WTF::getStringWithTypeName<',suffix:'>(void)'}];var SUBTRACE_FIELDS=new Set(['powerTraceAsString','systemTraceEvents']);var NON_METADATA_FIELDS=new Set(['samples','stackFrames','traceAnnotations','traceEvents']);for(var subtraceField in SUBTRACE_FIELDS)NON_METADATA_FIELDS.add(subtraceField);function TraceEventImporter(model,eventData){this.importPriority=1;this.model_=model;this.events_=undefined;this.sampleEvents_=undefined;this.stackFrameEvents_=undefined;this.subtraces_=[];this.eventsWereFromString_=false;this.softwareMeasuredCpuCount_=undefined;this.allAsyncEvents_=[];this.allFlowEvents_=[];this.allObjectEvents_=[];this.contextProcessorPerThread={};this.traceEventSampleStackFramesByName_={};this.v8ProcessCodeMaps_={};this.v8ProcessRootStackFrame_={};this.v8SamplingData_=[];this.asyncClockSyncStart_=undefined;this.asyncClockSyncFinish_=undefined;this.allMemoryDumpEvents_={};this.objectTypeNameMap_={};this.clockDomainId_=tr.model.ClockDomainId.UNKNOWN_CHROME_LEGACY;this.toModelTime_=undefined;if(typeof eventData==='string'||eventData instanceof String){eventData=eventData.trim();if(eventData[0]==='['){eventData=eventData.replace(/\s*,\s*$/,'');if(eventData[eventData.length-1]!==']')eventData=eventData+']';}this.events_=JSON.parse(eventData);this.eventsWereFromString_=true;}else{this.events_=eventData;}this.traceAnnotations_=this.events_.traceAnnotations;if(this.events_.traceEvents){var container=this.events_;this.events_=this.events_.traceEvents;for(var subtraceField of SUBTRACE_FIELDS)if(container[subtraceField])this.subtraces_.push(container[subtraceField]);this.sampleEvents_=container.samples;this.stackFrameEvents_=container.stackFrames;if(container.displayTimeUnit){var unitName=container.displayTimeUnit;var unit=tr.b.TimeDisplayModes[unitName];if(unit===undefined){throw new Error('Unit '+unitName+' is not supported.');}this.model_.intrinsicTimeUnit=unit;}for(var fieldName in container){if(NON_METADATA_FIELDS.has(fieldName))continue;this.model_.metadata.push({name:fieldName,value:container[fieldName]});if(fieldName==='metadata'){var metadata=container[fieldName];if(metadata['highres-ticks'])this.model_.isTimeHighResolution=metadata['highres-ticks'];if(metadata['clock-domain'])this.clockDomainId_=metadata['clock-domain'];}}}}TraceEventImporter.canImport=function(eventData){if(typeof eventData==='string'||eventData instanceof String){eventData=eventData.trim();return eventData[0]==='{'||eventData[0]==='[';}if(eventData instanceof Array&&eventData.length&&eventData[0].ph)return true;if(eventData.traceEvents){if(eventData.traceEvents instanceof Array){if(eventData.traceEvents.length&&eventData.traceEvents[0].ph)return true;if(eventData.samples.length&&eventData.stackFrames!==undefined)return true;}}return false;};TraceEventImporter.prototype={__proto__:tr.importer.Importer.prototype,get importerName(){return'TraceEventImporter';},extractSubtraces:function(){var subtraces=this.subtraces_;this.subtraces_=[];return subtraces;},deepCopyIfNeeded_:function(obj){if(obj===undefined)obj={};if(this.eventsWereFromString_)return obj;return deepCopy(obj);},deepCopyAlways_:function(obj){if(obj===undefined)obj={};return deepCopy(obj);},processAsyncEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allAsyncEvents_.push({sequenceNumber:this.allAsyncEvents_.length,event:event,thread:thread});},processFlowEvent:function(event,opt_slice){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allFlowEvents_.push({refGuid:tr.b.GUID.getLastSimpleGuid(),sequenceNumber:this.allFlowEvents_.length,event:event,slice:opt_slice,thread:thread});},processCounterEvent:function(event){var ctrName;if(event.id!==undefined)ctrName=event.name+'['+event.id+']';else ctrName=event.name;var ctr=this.model_.getOrCreateProcess(event.pid).getOrCreateCounter(event.cat,ctrName);var reservedColorId=event.cname?getEventColor(event):undefined;if(ctr.numSeries===0){for(var seriesName in event.args){var colorId=reservedColorId||getEventColor(event,ctr.name+'.'+seriesName);ctr.addSeries(new tr.model.CounterSeries(seriesName,colorId));}if(ctr.numSeries===0){this.model_.importWarning({type:'counter_parse_error',message:'Expected counter '+event.name+' to have at least one argument to use as a value.'});delete ctr.parent.counters[ctr.name];return;}}var ts=this.toModelTimeFromUs_(event.ts);ctr.series.forEach(function(series){var val=event.args[series.name]?event.args[series.name]:0;series.addCounterSample(ts,val);});},scopedIdForEvent_:function(event){return new tr.model.ScopedId(event.scope||tr.model.OBJECT_DEFAULT_SCOPE,event.id);},processObjectEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);this.allObjectEvents_.push({sequenceNumber:this.allObjectEvents_.length,event:event,thread:thread});if(thread.guid in this.contextProcessorPerThread){var processor=this.contextProcessorPerThread[thread.guid];var scopedId=this.scopedIdForEvent_(event);if(event.ph==='D')processor.destroyContext(scopedId);processor.invalidateContextCacheForSnapshot(scopedId);}},processContextEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);if(!(thread.guid in this.contextProcessorPerThread)){this.contextProcessorPerThread[thread.guid]=new tr.importer.ContextProcessor(this.model_);}var scopedId=this.scopedIdForEvent_(event);var contextType=event.name;var processor=this.contextProcessorPerThread[thread.guid];if(event.ph==='('){processor.enterContext(contextType,scopedId);}else if(event.ph===')'){processor.leaveContext(contextType,scopedId);}else{this.model_.importWarning({type:'unknown_context_phase',message:'Unknown context event phase: '+event.ph+'.'});}},setContextsFromThread_:function(thread,slice){if(thread.guid in this.contextProcessorPerThread){slice.contexts=this.contextProcessorPerThread[thread.guid].activeContexts;}},processDurationEvent:function(event){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var ts=this.toModelTimeFromUs_(event.ts);if(!thread.sliceGroup.isTimestampValidForBeginOrEnd(ts)){this.model_.importWarning({type:'duration_parse_error',message:'Timestamps are moving backward.'});return;}if(event.ph==='B'){var slice=thread.sliceGroup.beginSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args),this.toModelTimeFromUs_(event.tts),event.argsStripped,getEventColor(event));slice.startStackFrame=this.getStackFrameForEvent_(event);this.setContextsFromThread_(thread,slice);}else if(event.ph==='I'||event.ph==='i'||event.ph==='R'){if(event.s!==undefined&&event.s!=='t')throw new Error('This should never happen');thread.sliceGroup.beginSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args),this.toModelTimeFromUs_(event.tts),event.argsStripped,getEventColor(event));var slice=thread.sliceGroup.endSlice(this.toModelTimeFromUs_(event.ts),this.toModelTimeFromUs_(event.tts));slice.startStackFrame=this.getStackFrameForEvent_(event);slice.endStackFrame=undefined;}else{if(!thread.sliceGroup.openSliceCount){this.model_.importWarning({type:'duration_parse_error',message:'E phase event without a matching B phase event.'});return;}var slice=thread.sliceGroup.endSlice(this.toModelTimeFromUs_(event.ts),this.toModelTimeFromUs_(event.tts),getEventColor(event));if(event.name&&slice.title!=event.name){this.model_.importWarning({type:'title_match_error',message:'Titles do not match. Title is '+slice.title+' in openSlice, and is '+event.name+' in endSlice'});}slice.endStackFrame=this.getStackFrameForEvent_(event);this.mergeArgsInto_(slice.args,event.args,slice.title);}},mergeArgsInto_:function(dstArgs,srcArgs,eventName){for(var arg in srcArgs){if(dstArgs[arg]!==undefined){this.model_.importWarning({type:'arg_merge_error',message:'Different phases of '+eventName+' provided values for argument '+arg+'.'+' The last provided value will be used.'});}dstArgs[arg]=this.deepCopyIfNeeded_(srcArgs[arg]);}},processCompleteEvent:function(event){if(event.cat!==undefined&&event.cat.indexOf('trace_event_overhead')>-1)return undefined;var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);if(event.flow_out){if(event.flow_in)event.flowPhase=STEP;else event.flowPhase=PRODUCER;}else if(event.flow_in){event.flowPhase=CONSUMER;}var slice=thread.sliceGroup.pushCompleteSlice(event.cat,event.name,this.toModelTimeFromUs_(event.ts),this.maybeToModelTimeFromUs_(event.dur),this.maybeToModelTimeFromUs_(event.tts),this.maybeToModelTimeFromUs_(event.tdur),this.deepCopyIfNeeded_(event.args),event.argsStripped,getEventColor(event),event.bind_id);slice.startStackFrame=this.getStackFrameForEvent_(event);slice.endStackFrame=this.getStackFrameForEvent_(event,true);this.setContextsFromThread_(thread,slice);return slice;},processJitCodeEvent:function(event){if(this.v8ProcessCodeMaps_[event.pid]===undefined)this.v8ProcessCodeMaps_[event.pid]=new tr.e.importer.TraceCodeMap();var map=this.v8ProcessCodeMaps_[event.pid];var data=event.args.data;if(event.name==='JitCodeMoved')map.moveEntry(data.code_start,data.new_code_start,data.code_len);else map.addEntry(data.code_start,data.code_len,data.name,data.script_id);},processMetadataEvent:function(event){if(event.name==='JitCodeAdded'||event.name==='JitCodeMoved'){this.v8SamplingData_.push(event);return;}if(event.argsStripped)return;if(event.name==='process_name'){var process=this.model_.getOrCreateProcess(event.pid);process.name=event.args.name;}else if(event.name==='process_labels'){var process=this.model_.getOrCreateProcess(event.pid);var labels=event.args.labels.split(',');for(var i=0;i<labels.length;i++)process.addLabelIfNeeded(labels[i]);}else if(event.name==='process_sort_index'){var process=this.model_.getOrCreateProcess(event.pid);process.sortIndex=event.args.sort_index;}else if(event.name==='thread_name'){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);thread.name=event.args.name;}else if(event.name==='thread_sort_index'){var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);thread.sortIndex=event.args.sort_index;}else if(event.name==='num_cpus'){var n=event.args.number;if(this.softwareMeasuredCpuCount_!==undefined)n=Math.max(n,this.softwareMeasuredCpuCount_);this.softwareMeasuredCpuCount_=n;}else if(event.name==='stackFrames'){var stackFrames=event.args.stackFrames;if(stackFrames===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'No stack frames found in a \''+event.name+'\' metadata event'});}else{this.importStackFrames_(stackFrames,'p'+event.pid+':');}}else if(event.name==='typeNames'){var objectTypeNameMap=event.args.typeNames;if(objectTypeNameMap===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'No mapping from object type IDs to names found in a \''+event.name+'\' metadata event'});}else{this.importObjectTypeNameMap_(objectTypeNameMap,event.pid);}}else if(event.name==='TraceConfig'){this.model_.metadata.push({name:'TraceConfig',value:event.args.value});}else{this.model_.importWarning({type:'metadata_parse_error',message:'Unrecognized metadata name: '+event.name});}},processInstantEvent:function(event){if(event.name==='JitCodeAdded'||event.name==='JitCodeMoved'){this.v8SamplingData_.push(event);return;}if(event.s==='t'||event.s===undefined){this.processDurationEvent(event);return;}var constructor;switch(event.s){case'g':constructor=tr.model.GlobalInstantEvent;break;case'p':constructor=tr.model.ProcessInstantEvent;break;default:this.model_.importWarning({type:'instant_parse_error',message:'I phase event with unknown "s" field value.'});return;}var instantEvent=new constructor(event.cat,event.name,getEventColor(event),this.toModelTimeFromUs_(event.ts),this.deepCopyIfNeeded_(event.args));switch(instantEvent.type){case tr.model.InstantEventType.GLOBAL:this.model_.instantEvents.push(instantEvent);break;case tr.model.InstantEventType.PROCESS:var process=this.model_.getOrCreateProcess(event.pid);process.instantEvents.push(instantEvent);break;default:throw new Error('Unknown instant event type: '+event.s);}},processV8Sample:function(event){var data=event.args.data;if(data.vm_state==='js'&&!data.stack.length)return;var rootStackFrame=this.v8ProcessRootStackFrame_[event.pid];if(!rootStackFrame){rootStackFrame=new tr.model.StackFrame(undefined,'v8-root-stack-frame','v8-root-stack-frame',0);this.v8ProcessRootStackFrame_[event.pid]=rootStackFrame;}function findChildWithEntryID(stackFrame,entryID){return tr.b.findFirstInArray(stackFrame.children,function(child){return child.entryID===entryID;});}var model=this.model_;function addStackFrame(lastStackFrame,entry){var childFrame=findChildWithEntryID(lastStackFrame,entry.id);if(childFrame)return childFrame;var frame=new tr.model.StackFrame(lastStackFrame,tr.b.GUID.allocateSimple(),entry.name,ColorScheme.getColorIdForGeneralPurposeString(entry.name),entry.sourceInfo);frame.entryID=entry.id;model.addStackFrame(frame);return frame;}var lastStackFrame=rootStackFrame;if(data.stack.length>0&&this.v8ProcessCodeMaps_[event.pid]){var map=this.v8ProcessCodeMaps_[event.pid];data.stack.reverse();for(var i=0;i<data.stack.length;i++){var entry=map.lookupEntry(data.stack[i]);if(entry===undefined){entry={id:'unknown',name:'unknown',sourceInfo:undefined};}lastStackFrame=addStackFrame(lastStackFrame,entry);}}else{var entry={id:data.vm_state,name:data.vm_state,sourceInfo:undefined};lastStackFrame=addStackFrame(lastStackFrame,entry);}var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var sample=new tr.model.Sample(undefined,thread,'V8 Sample',this.toModelTimeFromUs_(event.ts),lastStackFrame,1,this.deepCopyIfNeeded_(event.args));this.model_.samples.push(sample);},processTraceSampleEvent:function(event){if(event.name==='V8Sample'){this.v8SamplingData_.push(event);return;}var stackFrame=this.getStackFrameForEvent_(event);if(stackFrame===undefined){stackFrame=this.traceEventSampleStackFramesByName_[event.name];}if(stackFrame===undefined){var id='te-'+tr.b.GUID.allocateSimple();stackFrame=new tr.model.StackFrame(undefined,id,event.name,ColorScheme.getColorIdForGeneralPurposeString(event.name));this.model_.addStackFrame(stackFrame);this.traceEventSampleStackFramesByName_[event.name]=stackFrame;}var thread=this.model_.getOrCreateProcess(event.pid).getOrCreateThread(event.tid);var sample=new tr.model.Sample(undefined,thread,'Trace Event Sample',this.toModelTimeFromUs_(event.ts),stackFrame,1,this.deepCopyIfNeeded_(event.args));this.setContextsFromThread_(thread,sample);this.model_.samples.push(sample);},processMemoryDumpEvent:function(event){if(event.ph!=='v')throw new Error('Invalid memory dump event phase "'+event.ph+'".');var dumpId=event.id;if(dumpId===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory dump event (phase \''+event.ph+'\') without a dump ID.'});return;}var pid=event.pid;if(pid===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory dump event (phase\''+event.ph+'\', dump ID \''+dumpId+'\') without a PID.'});return;}var allEvents=this.allMemoryDumpEvents_;var dumpIdEvents=allEvents[dumpId];if(dumpIdEvents===undefined)allEvents[dumpId]=dumpIdEvents={};var processEvents=dumpIdEvents[pid];if(processEvents===undefined)dumpIdEvents[pid]=processEvents=[];processEvents.push(event);},processClockSyncEvent:function(event){if(event.ph!=='c')throw new Error('Invalid clock sync event phase "'+event.ph+'".');var syncId=event.args.sync_id;if(syncId===undefined){this.model_.importWarning({type:'clock_sync_parse_error',message:'Clock sync at time '+event.ts+' without an ID.'});return;}if(event.args&&event.args.issue_ts!==undefined){this.model_.clockSyncManager.addClockSyncMarker(this.clockDomainId_,syncId,tr.b.Unit.timestampFromUs(event.args.issue_ts),tr.b.Unit.timestampFromUs(event.ts));}else{this.model_.clockSyncManager.addClockSyncMarker(this.clockDomainId_,syncId,tr.b.Unit.timestampFromUs(event.ts));}},processV8Events:function(){this.v8SamplingData_.sort(function(a,b){if(a.ts!==b.ts)return a.ts-b.ts;if(a.ph==='M'||a.ph==='I')return-1;else if(b.ph==='M'||b.ph==='I')return 1;return 0;});var length=this.v8SamplingData_.length;for(var i=0;i<length;++i){var event=this.v8SamplingData_[i];if(event.ph==='M'||event.ph==='I'){this.processJitCodeEvent(event);}else if(event.ph==='P'){this.processV8Sample(event);}}},initBackcompatClockSyncEventTracker_:function(event){if(event.name!==undefined&&event.name.startsWith(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX)&&event.ph==='S')this.asyncClockSyncStart_=event;if(event.name!==undefined&&event.name.startsWith(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX)&&event.ph==='F')this.asyncClockSyncFinish_=event;if(this.asyncClockSyncStart_==undefined||this.asyncClockSyncFinish_==undefined)return;var syncId=this.asyncClockSyncStart_.name.substring(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX.length);if(syncId!==this.asyncClockSyncFinish_.name.substring(ASYNC_CLOCK_SYNC_EVENT_TITLE_PREFIX.length)){throw new Error('Inconsistent clock sync id of async clock sync '+'events.');}var clockSyncEvent={ph:'c',args:{sync_id:syncId,issue_ts:this.asyncClockSyncStart_.ts},ts:this.asyncClockSyncFinish_.ts};this.asyncClockSyncStart_=undefined;this.asyncClockSyncFinish_=undefined;return clockSyncEvent;},importClockSyncMarkers:function(){var asyncClockSyncStart,asyncClockSyncFinish;for(var i=0;i<this.events_.length;i++){var event=this.events_[i];var possibleBackCompatClockSyncEvent=this.initBackcompatClockSyncEventTracker_(event);if(possibleBackCompatClockSyncEvent)this.processClockSyncEvent(possibleBackCompatClockSyncEvent);if(event.ph!=='c')continue;var eventSizeInBytes=this.model_.importOptions.trackDetailedModelStats?JSON.stringify(event).length:undefined;this.model_.stats.willProcessBasicTraceEvent('clock_sync',event.cat,event.name,event.ts,eventSizeInBytes);this.processClockSyncEvent(event);}},importEvents:function(){if(this.stackFrameEvents_)this.importStackFrames_(this.stackFrameEvents_,'g');if(this.traceAnnotations_)this.importAnnotations_();var importOptions=this.model_.importOptions;var trackDetailedModelStats=importOptions.trackDetailedModelStats;var modelStats=this.model_.stats;var events=this.events_;for(var eI=0;eI<events.length;eI++){var event=events[eI];if(event.args==='__stripped__'){event.argsStripped=true;event.args=undefined;}var eventSizeInBytes;if(trackDetailedModelStats)eventSizeInBytes=JSON.stringify(event).length;else eventSizeInBytes=undefined;if(event.ph==='B'||event.ph==='E'){modelStats.willProcessBasicTraceEvent('begin_end (non-compact)',event.cat,event.name,event.ts,eventSizeInBytes);this.processDurationEvent(event);}else if(event.ph==='X'){modelStats.willProcessBasicTraceEvent('begin_end (compact)',event.cat,event.name,event.ts,eventSizeInBytes);var slice=this.processCompleteEvent(event);if(slice!==undefined&&event.bind_id!==undefined)this.processFlowEvent(event,slice);}else if(event.ph==='b'||event.ph==='e'||event.ph==='n'||event.ph==='S'||event.ph==='F'||event.ph==='T'||event.ph==='p'){modelStats.willProcessBasicTraceEvent('async',event.cat,event.name,event.ts,eventSizeInBytes);this.processAsyncEvent(event);}else if(event.ph==='I'||event.ph==='i'||event.ph==='R'){modelStats.willProcessBasicTraceEvent('instant',event.cat,event.name,event.ts,eventSizeInBytes);this.processInstantEvent(event);}else if(event.ph==='P'){modelStats.willProcessBasicTraceEvent('samples',event.cat,event.name,event.ts,eventSizeInBytes);this.processTraceSampleEvent(event);}else if(event.ph==='C'){modelStats.willProcessBasicTraceEvent('counters',event.cat,event.name,event.ts,eventSizeInBytes);this.processCounterEvent(event);}else if(event.ph==='M'){modelStats.willProcessBasicTraceEvent('metadata',event.cat,event.name,event.ts,eventSizeInBytes);this.processMetadataEvent(event);}else if(event.ph==='N'||event.ph==='D'||event.ph==='O'){modelStats.willProcessBasicTraceEvent('objects',event.cat,event.name,event.ts,eventSizeInBytes);this.processObjectEvent(event);}else if(event.ph==='s'||event.ph==='t'||event.ph==='f'){modelStats.willProcessBasicTraceEvent('flows',event.cat,event.name,event.ts,eventSizeInBytes);this.processFlowEvent(event);}else if(event.ph==='v'){modelStats.willProcessBasicTraceEvent('memory_dumps',event.cat,event.name,event.ts,eventSizeInBytes);this.processMemoryDumpEvent(event);}else if(event.ph==='('||event.ph===')'){this.processContextEvent(event);}else if(event.ph==='c'){}else{modelStats.willProcessBasicTraceEvent('unknown',event.cat,event.name,event.ts,eventSizeInBytes);this.model_.importWarning({type:'parse_error',message:'Unrecognized event phase: '+event.ph+' ('+event.name+')'});}}this.processV8Events();tr.b.iterItems(this.v8ProcessRootStackFrame_,function(name,frame){frame.removeAllChildren();});},importStackFrames_:function(rawStackFrames,idPrefix){var model=this.model_;for(var id in rawStackFrames){var rawStackFrame=rawStackFrames[id];var fullId=idPrefix+id;var textForColor=rawStackFrame.category?rawStackFrame.category:rawStackFrame.name;var stackFrame=new tr.model.StackFrame(undefined,fullId,rawStackFrame.name,ColorScheme.getColorIdForGeneralPurposeString(textForColor));model.addStackFrame(stackFrame);}for(var id in rawStackFrames){var fullId=idPrefix+id;var stackFrame=model.stackFrames[fullId];if(stackFrame===undefined)throw new Error('Internal error');var rawStackFrame=rawStackFrames[id];var parentId=rawStackFrame.parent;var parentStackFrame;if(parentId===undefined){parentStackFrame=undefined;}else{var parentFullId=idPrefix+parentId;parentStackFrame=model.stackFrames[parentFullId];if(parentStackFrame===undefined){this.model_.importWarning({type:'metadata_parse_error',message:'Missing parent frame with ID '+parentFullId+' for stack frame \''+stackFrame.name+'\' (ID '+fullId+').'});}}stackFrame.parentFrame=parentStackFrame;}},importObjectTypeNameMap_:function(rawObjectTypeNameMap,pid){if(pid in this.objectTypeNameMap_){this.model_.importWarning({type:'metadata_parse_error',message:'Mapping from object type IDs to names provided for pid='+pid+' multiple times.'});return;}var objectTypeNamePrefix=undefined;var objectTypeNameSuffix=undefined;var objectTypeNameMap={};for(var objectTypeId in rawObjectTypeNameMap){var rawObjectTypeName=rawObjectTypeNameMap[objectTypeId];if(objectTypeNamePrefix===undefined){for(var i=0;i<OBJECT_TYPE_NAME_PATTERNS.length;i++){var pattern=OBJECT_TYPE_NAME_PATTERNS[i];if(rawObjectTypeName.startsWith(pattern.prefix)&&rawObjectTypeName.endsWith(pattern.suffix)){objectTypeNamePrefix=pattern.prefix;objectTypeNameSuffix=pattern.suffix;break;}}}if(objectTypeNamePrefix!==undefined&&rawObjectTypeName.startsWith(objectTypeNamePrefix)&&rawObjectTypeName.endsWith(objectTypeNameSuffix)){objectTypeNameMap[objectTypeId]=rawObjectTypeName.substring(objectTypeNamePrefix.length,rawObjectTypeName.length-objectTypeNameSuffix.length);}else{objectTypeNameMap[objectTypeId]=rawObjectTypeName;}}this.objectTypeNameMap_[pid]=objectTypeNameMap;},importAnnotations_:function(){for(var id in this.traceAnnotations_){var annotation=tr.model.Annotation.fromDictIfPossible(this.traceAnnotations_[id]);if(!annotation){this.model_.importWarning({type:'annotation_warning',message:'Unrecognized traceAnnotation typeName \"'+this.traceAnnotations_[id].typeName+'\"'});continue;}this.model_.addAnnotation(annotation);}},finalizeImport:function(){if(this.softwareMeasuredCpuCount_!==undefined){this.model_.kernel.softwareMeasuredCpuCount=this.softwareMeasuredCpuCount_;}this.createAsyncSlices_();this.createFlowSlices_();this.createExplicitObjects_();this.createImplicitObjects_();this.createMemoryDumps_();},getStackFrameForEvent_:function(event,opt_lookForEndEvent){var sf;var stack;if(opt_lookForEndEvent){sf=event.esf;stack=event.estack;}else{sf=event.sf;stack=event.stack;}if(stack!==undefined&&sf!==undefined){this.model_.importWarning({type:'stack_frame_and_stack_error',message:'Event at '+event.ts+' cannot have both a stack and a stackframe.'});return undefined;}if(stack!==undefined)return this.model_.resolveStackToStackFrame_(event.pid,stack);if(sf===undefined)return undefined;var stackFrame=this.model_.stackFrames['g'+sf];if(stackFrame===undefined){this.model_.importWarning({type:'sample_import_error',message:'No frame for '+sf});return;}return stackFrame;},resolveStackToStackFrame_:function(pid,stack){return undefined;},importSampleData:function(){if(!this.sampleEvents_)return;var m=this.model_;var events=this.sampleEvents_;if(this.events_.length===0){for(var i=0;i<events.length;i++){var event=events[i];m.getOrCreateProcess(event.tid).getOrCreateThread(event.tid);}}var threadsByTid={};m.getAllThreads().forEach(function(t){threadsByTid[t.tid]=t;});for(var i=0;i<events.length;i++){var event=events[i];var thread=threadsByTid[event.tid];if(thread===undefined){m.importWarning({type:'sample_import_error',message:'Thread '+events.tid+'not found'});continue;}var cpu;if(event.cpu!==undefined)cpu=m.kernel.getOrCreateCpu(event.cpu);var stackFrame=this.getStackFrameForEvent_(event);var sample=new tr.model.Sample(cpu,thread,event.name,this.toModelTimeFromUs_(event.ts),stackFrame,event.weight);m.samples.push(sample);}},createAsyncSlices_:function(){if(this.allAsyncEvents_.length===0)return;this.allAsyncEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!==0)return d;return x.sequenceNumber-y.sequenceNumber;});var legacyEvents=[];var nestableAsyncEventsByKey={};var nestableMeasureAsyncEventsByKey={};for(var i=0;i<this.allAsyncEvents_.length;i++){var asyncEventState=this.allAsyncEvents_[i];var event=asyncEventState.event;if(event.ph==='S'||event.ph==='F'||event.ph==='T'||event.ph==='p'){legacyEvents.push(asyncEventState);continue;}if(event.cat===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require a '+'cat parameter.'});continue;}if(event.name===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require a '+'name parameter.'});continue;}if(event.id===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async events (ph: b, e, or n) require an '+'id parameter.'});continue;}if(event.cat==='blink.user_timing'){var matched=/([^\/:]+):([^\/:]+)\/?(.*)/.exec(event.name);if(matched!==null){var key=matched[1]+':'+event.cat;event.args=JSON.parse(Base64.atob(matched[3])||'{}');if(nestableMeasureAsyncEventsByKey[key]===undefined)nestableMeasureAsyncEventsByKey[key]=[];nestableMeasureAsyncEventsByKey[key].push(asyncEventState);continue;}}var key=event.cat+':'+event.id;if(nestableAsyncEventsByKey[key]===undefined)nestableAsyncEventsByKey[key]=[];nestableAsyncEventsByKey[key].push(asyncEventState);}this.createLegacyAsyncSlices_(legacyEvents);this.createNestableAsyncSlices_(nestableMeasureAsyncEventsByKey);this.createNestableAsyncSlices_(nestableAsyncEventsByKey);},createLegacyAsyncSlices_:function(legacyEvents){if(legacyEvents.length===0)return;legacyEvents.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var asyncEventStatesByNameThenID={};for(var i=0;i<legacyEvents.length;i++){var asyncEventState=legacyEvents[i];var event=asyncEventState.event;var name=event.name;if(name===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Async events (ph: S, T, p, or F) require a name '+' parameter.'});continue;}var id=event.id;if(id===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'Async events (ph: S, T, p, or F) require an id parameter.'});continue;}if(event.ph==='S'){if(asyncEventStatesByNameThenID[name]===undefined)asyncEventStatesByNameThenID[name]={};if(asyncEventStatesByNameThenID[name][id]){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', a slice of the same id '+id+' was alrady open.'});continue;}asyncEventStatesByNameThenID[name][id]=[];asyncEventStatesByNameThenID[name][id].push(asyncEventState);}else{if(asyncEventStatesByNameThenID[name]===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', no slice named '+name+' was open.'});continue;}if(asyncEventStatesByNameThenID[name][id]===undefined){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.ts+', no slice named '+name+' with id='+id+' was open.'});continue;}var events=asyncEventStatesByNameThenID[name][id];events.push(asyncEventState);if(event.ph==='F'){var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(events[0].event.cat,name);var slice=new asyncSliceConstructor(events[0].event.cat,name,getEventColor(events[0].event),this.toModelTimeFromUs_(events[0].event.ts),tr.b.concatenateObjects(events[0].event.args,events[events.length-1].event.args),this.toModelTimeFromUs_(event.ts-events[0].event.ts),true,undefined,undefined,events[0].event.argsStripped);slice.startThread=events[0].thread;slice.endThread=asyncEventState.thread;slice.id=id;var stepType=events[1].event.ph;var isValid=true;for(var j=1;j<events.length-1;++j){if(events[j].event.ph==='T'||events[j].event.ph==='p'){isValid=this.assertStepTypeMatches_(stepType,events[j]);if(!isValid)break;}if(events[j].event.ph==='S'){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had a step before the start event.'});continue;}if(events[j].event.ph==='F'){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had a step after the finish event.'});continue;}var startIndex=j+(stepType==='T'?0:-1);var endIndex=startIndex+1;var subName=events[j].event.name;if(!events[j].event.argsStripped&&(events[j].event.ph==='T'||events[j].event.ph==='p'))subName=subName+':'+events[j].event.args.step;var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(events[0].event.cat,subName);var subSlice=new asyncSliceConstructor(events[0].event.cat,subName,getEventColor(event,subName+j),this.toModelTimeFromUs_(events[startIndex].event.ts),this.deepCopyIfNeeded_(events[j].event.args),this.toModelTimeFromUs_(events[endIndex].event.ts-events[startIndex].event.ts),undefined,undefined,events[startIndex].event.argsStripped);subSlice.startThread=events[startIndex].thread;subSlice.endThread=events[endIndex].thread;subSlice.id=id;slice.subSlices.push(subSlice);}if(isValid){slice.startThread.asyncSliceGroup.push(slice);}delete asyncEventStatesByNameThenID[name][id];}}}},createNestableAsyncSlices_:function(nestableEventsByKey){for(var key in nestableEventsByKey){var eventStateEntries=nestableEventsByKey[key];var parentStack=[];for(var i=0;i<eventStateEntries.length;++i){var eventStateEntry=eventStateEntries[i];if(eventStateEntry.event.ph==='e'){var parentIndex=-1;for(var k=parentStack.length-1;k>=0;--k){if(parentStack[k].event.name===eventStateEntry.event.name){parentIndex=k;break;}}if(parentIndex===-1){eventStateEntry.finished=false;}else{parentStack[parentIndex].end=eventStateEntry;while(parentIndex<parentStack.length){parentStack.pop();}}}if(parentStack.length>0)eventStateEntry.parentEntry=parentStack[parentStack.length-1];if(eventStateEntry.event.ph==='b'){parentStack.push(eventStateEntry);}}var topLevelSlices=[];for(var i=0;i<eventStateEntries.length;++i){var eventStateEntry=eventStateEntries[i];if(eventStateEntry.event.ph==='e'&&eventStateEntry.finished===undefined){continue;}var startState=undefined;var endState=undefined;var sliceArgs=eventStateEntry.event.args||{};var sliceError=undefined;if(eventStateEntry.event.ph==='n'){startState=eventStateEntry;endState=eventStateEntry;}else if(eventStateEntry.event.ph==='b'){if(eventStateEntry.end===undefined){eventStateEntry.end=eventStateEntries[eventStateEntries.length-1];sliceError='Slice has no matching END. End time has been adjusted.';this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async BEGIN event at '+eventStateEntry.event.ts+' with name='+eventStateEntry.event.name+' and id='+eventStateEntry.event.id+' was unmatched.'});}else{function concatenateArguments(args1,args2){if(args1.params===undefined||args2.params===undefined)return tr.b.concatenateObjects(args1,args2);var args3={};args3.params=tr.b.concatenateObjects(args1.params,args2.params);return tr.b.concatenateObjects(args1,args2,args3);}var endArgs=eventStateEntry.end.event.args||{};sliceArgs=concatenateArguments(sliceArgs,endArgs);}startState=eventStateEntry;endState=eventStateEntry.end;}else{sliceError='Slice has no matching BEGIN. Start time has been adjusted.';this.model_.importWarning({type:'async_slice_parse_error',message:'Nestable async END event at '+eventStateEntry.event.ts+' with name='+eventStateEntry.event.name+' and id='+eventStateEntry.event.id+' was unmatched.'});startState=eventStateEntries[0];endState=eventStateEntry;}var isTopLevel=eventStateEntry.parentEntry===undefined;var asyncSliceConstructor=tr.model.AsyncSlice.subTypes.getConstructor(eventStateEntry.event.cat,eventStateEntry.event.name);var threadStart=undefined;var threadDuration=undefined;if(startState.event.tts&&startState.event.use_async_tts){threadStart=this.toModelTimeFromUs_(startState.event.tts);if(endState.event.tts){var threadEnd=this.toModelTimeFromUs_(endState.event.tts);threadDuration=threadEnd-threadStart;}}var slice=new asyncSliceConstructor(eventStateEntry.event.cat,eventStateEntry.event.name,getEventColor(endState.event),this.toModelTimeFromUs_(startState.event.ts),sliceArgs,this.toModelTimeFromUs_(endState.event.ts-startState.event.ts),isTopLevel,threadStart,threadDuration,startState.event.argsStripped);slice.startThread=startState.thread;slice.endThread=endState.thread;slice.startStackFrame=this.getStackFrameForEvent_(startState.event);slice.endStackFrame=this.getStackFrameForEvent_(endState.event);slice.id=key;if(sliceError!==undefined)slice.error=sliceError;eventStateEntry.slice=slice;if(isTopLevel){topLevelSlices.push(slice);}else if(eventStateEntry.parentEntry.slice!==undefined){eventStateEntry.parentEntry.slice.subSlices.push(slice);}}for(var si=0;si<topLevelSlices.length;si++){topLevelSlices[si].startThread.asyncSliceGroup.push(topLevelSlices[si]);}}},assertStepTypeMatches_:function(stepType,event){if(stepType!=event.event.ph){this.model_.importWarning({type:'async_slice_parse_error',message:'At '+event.event.ts+', a slice named '+event.event.name+' with id='+event.event.id+' had both begin and end steps, which is not allowed.'});return false;}return true;},createFlowSlices_:function(){if(this.allFlowEvents_.length===0)return;var that=this;function validateFlowEvent(){if(event.name===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow events (ph: s, t or f) require a name parameter.'});return false;}if(event.ph==='s'||event.ph==='f'||event.ph==='t'){if(event.id===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow events (ph: s, t or f) require an id parameter.'});return false;}return true;}if(event.bind_id){if(event.flow_in===undefined&&event.flow_out===undefined){that.model_.importWarning({type:'flow_slice_parse_error',message:'Flow producer or consumer require flow_in or flow_out.'});return false;}return true;}return false;}var createFlowEvent=function(thread,event,opt_slice){var startSlice,flowId,flowStartTs;if(event.bind_id){startSlice=opt_slice;flowId=event.bind_id;flowStartTs=this.toModelTimeFromUs_(event.ts+event.dur);}else{var ts=this.toModelTimeFromUs_(event.ts);startSlice=thread.sliceGroup.findSliceAtTs(ts);if(startSlice===undefined)return undefined;flowId=event.id;flowStartTs=ts;}var flowEvent=new tr.model.FlowEvent(event.cat,flowId,event.name,getEventColor(event),flowStartTs,that.deepCopyAlways_(event.args));flowEvent.startSlice=startSlice;flowEvent.startStackFrame=that.getStackFrameForEvent_(event);flowEvent.endStackFrame=undefined;startSlice.outFlowEvents.push(flowEvent);return flowEvent;}.bind(this);var finishFlowEventWith=function(flowEvent,thread,event,refGuid,bindToParent,opt_slice){var endSlice;if(event.bind_id){endSlice=opt_slice;}else{var ts=this.toModelTimeFromUs_(event.ts);if(bindToParent){endSlice=thread.sliceGroup.findSliceAtTs(ts);}else{endSlice=thread.sliceGroup.findNextSliceAfter(ts,refGuid);}if(endSlice===undefined)return false;}endSlice.inFlowEvents.push(flowEvent);flowEvent.endSlice=endSlice;flowEvent.duration=this.toModelTimeFromUs_(event.ts)-flowEvent.start;flowEvent.endStackFrame=that.getStackFrameForEvent_(event);that.mergeArgsInto_(flowEvent.args,event.args,flowEvent.title);return true;}.bind(this);function processFlowConsumer(flowIdToEvent,sliceGuidToEvent,event,slice){var flowEvent=flowIdToEvent[event.bind_id];if(flowEvent===undefined){that.model_.importWarning({type:'flow_slice_ordering_error',message:'Flow consumer '+event.bind_id+' does not have '+'a flow producer'});return false;}else if(flowEvent.endSlice){var flowProducer=flowEvent.startSlice;flowEvent=createFlowEvent(undefined,sliceGuidToEvent[flowProducer.guid],flowProducer);}var ok=finishFlowEventWith(flowEvent,undefined,event,refGuid,undefined,slice);if(ok){that.model_.flowEvents.push(flowEvent);}else{that.model_.importWarning({type:'flow_slice_end_error',message:'Flow consumer '+event.bind_id+' does not end '+'at an actual slice, so cannot be created.'});return false;}return true;}function processFlowProducer(flowIdToEvent,flowStatus,event,slice){if(flowIdToEvent[event.bind_id]&&flowStatus[event.bind_id]){that.model_.importWarning({type:'flow_slice_start_error',message:'Flow producer '+event.bind_id+' already seen'});return false;}var flowEvent=createFlowEvent(undefined,event,slice);if(!flowEvent){that.model_.importWarning({type:'flow_slice_start_error',message:'Flow producer '+event.bind_id+' does not start'+'a flow'});return false;}flowIdToEvent[event.bind_id]=flowEvent;}this.allFlowEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var flowIdToEvent={};var sliceGuidToEvent={};var flowStatus={};for(var i=0;i<this.allFlowEvents_.length;++i){var data=this.allFlowEvents_[i];var refGuid=data.refGuid;var event=data.event;var thread=data.thread;if(!validateFlowEvent(event))continue;if(event.bind_id){var slice=data.slice;sliceGuidToEvent[slice.guid]=event;if(event.flowPhase===PRODUCER){if(!processFlowProducer(flowIdToEvent,flowStatus,event,slice))continue;flowStatus[event.bind_id]=true;}else{if(!processFlowConsumer(flowIdToEvent,sliceGuidToEvent,event,slice))continue;flowStatus[event.bind_id]=false;if(event.flowPhase===STEP){if(!processFlowProducer(flowIdToEvent,flowStatus,event,slice))continue;flowStatus[event.bind_id]=true;}}continue;}var flowEvent;if(event.ph==='s'){if(flowIdToEvent[event.id]){this.model_.importWarning({type:'flow_slice_start_error',message:'event id '+event.id+' already seen when '+'encountering start of flow event.'});continue;}flowEvent=createFlowEvent(thread,event);if(!flowEvent){this.model_.importWarning({type:'flow_slice_start_error',message:'event id '+event.id+' does not start '+'at an actual slice, so cannot be created.'});continue;}flowIdToEvent[event.id]=flowEvent;}else if(event.ph==='t'||event.ph==='f'){flowEvent=flowIdToEvent[event.id];if(flowEvent===undefined){this.model_.importWarning({type:'flow_slice_ordering_error',message:'Found flow phase '+event.ph+' for id: '+event.id+' but no flow start found.'});continue;}var bindToParent=event.ph==='t';if(event.ph==='f'){if(event.bp===undefined){if(event.cat.indexOf('input')>-1)bindToParent=true;else if(event.cat.indexOf('ipc.flow')>-1)bindToParent=true;}else{if(event.bp!=='e'){this.model_.importWarning({type:'flow_slice_bind_point_error',message:'Flow event with invalid binding point (event.bp).'});continue;}bindToParent=true;}}var ok=finishFlowEventWith(flowEvent,thread,event,refGuid,bindToParent);if(ok){that.model_.flowEvents.push(flowEvent);}else{this.model_.importWarning({type:'flow_slice_end_error',message:'event id '+event.id+' does not end '+'at an actual slice, so cannot be created.'});}flowIdToEvent[event.id]=undefined;if(ok&&event.ph==='t'){flowEvent=createFlowEvent(thread,event);flowIdToEvent[event.id]=flowEvent;}}}},createExplicitObjects_:function(){if(this.allObjectEvents_.length===0)return;var processEvent=function(objectEventState){var event=objectEventState.event;var scopedId=this.scopedIdForEvent_(event);var thread=objectEventState.thread;if(event.name===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+JSON.stringify(event)+': '+'Object events require an name parameter.'});}if(scopedId.id===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+JSON.stringify(event)+': '+'Object events require an id parameter.'});}var process=thread.parent;var ts=this.toModelTimeFromUs_(event.ts);var instance;if(event.ph==='N'){try{instance=process.objects.idWasCreated(scopedId,event.cat,event.name,ts);}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing create of '+scopedId+' at ts='+ts+': '+e});return;}}else if(event.ph==='O'){if(event.args.snapshot===undefined){this.model_.importWarning({type:'object_parse_error',message:'While processing '+scopedId+' at ts='+ts+': '+'Snapshots must have args: {snapshot: ...}'});return;}var snapshot;try{var args=this.deepCopyIfNeeded_(event.args.snapshot);var cat;if(args.cat){cat=args.cat;delete args.cat;}else{cat=event.cat;}var baseTypename;if(args.base_type){baseTypename=args.base_type;delete args.base_type;}else{baseTypename=undefined;}snapshot=process.objects.addSnapshot(scopedId,cat,event.name,ts,args,baseTypename);snapshot.snapshottedOnThread=thread;}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing snapshot of '+scopedId+' at ts='+ts+': '+e});return;}instance=snapshot.objectInstance;}else if(event.ph==='D'){try{process.objects.idWasDeleted(scopedId,event.cat,event.name,ts);var instanceMap=process.objects.getOrCreateInstanceMap_(scopedId);instance=instanceMap.lastInstance;}catch(e){this.model_.importWarning({type:'object_parse_error',message:'While processing delete of '+scopedId+' at ts='+ts+': '+e});return;}}if(instance)instance.colorId=getEventColor(event,instance.typeName);}.bind(this);this.allObjectEvents_.sort(function(x,y){var d=x.event.ts-y.event.ts;if(d!=0)return d;return x.sequenceNumber-y.sequenceNumber;});var allObjectEvents=this.allObjectEvents_;for(var i=0;i<allObjectEvents.length;i++){var objectEventState=allObjectEvents[i];try{processEvent.call(this,objectEventState);}catch(e){this.model_.importWarning({type:'object_parse_error',message:e.message});}}},createImplicitObjects_:function(){tr.b.iterItems(this.model_.processes,function(pid,process){this.createImplicitObjectsForProcess_(process);},this);},createImplicitObjectsForProcess_:function(process){function processField(referencingObject,referencingObjectFieldName,referencingObjectFieldValue,containingSnapshot){if(!referencingObjectFieldValue)return;if(referencingObjectFieldValue instanceof tr.model.ObjectSnapshot)return null;if(referencingObjectFieldValue.id===undefined)return;var implicitSnapshot=referencingObjectFieldValue;var rawId=implicitSnapshot.id;var m=/(.+)\/(.+)/.exec(rawId);if(!m)throw new Error('Implicit snapshots must have names.');delete implicitSnapshot.id;var name=m[1];var id=m[2];var res;var cat;if(implicitSnapshot.cat!==undefined)cat=implicitSnapshot.cat;else cat=containingSnapshot.objectInstance.category;var baseTypename;if(implicitSnapshot.base_type)baseTypename=implicitSnapshot.base_type;else baseTypename=undefined;var scope=containingSnapshot.objectInstance.scopedId.scope;try{res=process.objects.addSnapshot(new tr.model.ScopedId(scope,id),cat,name,containingSnapshot.ts,implicitSnapshot,baseTypename);}catch(e){this.model_.importWarning({type:'object_snapshot_parse_error',message:'While processing implicit snapshot of '+rawId+' at ts='+containingSnapshot.ts+': '+e});return;}res.objectInstance.hasImplicitSnapshots=true;res.containingSnapshot=containingSnapshot;res.snapshottedOnThread=containingSnapshot.snapshottedOnThread;referencingObject[referencingObjectFieldName]=res;if(!(res instanceof tr.model.ObjectSnapshot))throw new Error('Created object must be instanceof snapshot');return res.args;}function iterObject(object,func,containingSnapshot,thisArg){if(!(object instanceof Object))return;if(object instanceof Array){for(var i=0;i<object.length;i++){var res=func.call(thisArg,object,i,object[i],containingSnapshot);if(res===null)continue;if(res)iterObject(res,func,containingSnapshot,thisArg);else iterObject(object[i],func,containingSnapshot,thisArg);}return;}for(var key in object){var res=func.call(thisArg,object,key,object[key],containingSnapshot);if(res===null)continue;if(res)iterObject(res,func,containingSnapshot,thisArg);else iterObject(object[key],func,containingSnapshot,thisArg);}}process.objects.iterObjectInstances(function(instance){instance.snapshots.forEach(function(snapshot){if(snapshot.args.id!==undefined)throw new Error('args cannot have an id field inside it');iterObject(snapshot.args,processField,snapshot,this);},this);},this);},createMemoryDumps_:function(){for(var dumpId in this.allMemoryDumpEvents_)this.createGlobalMemoryDump_(this.allMemoryDumpEvents_[dumpId],dumpId);},createGlobalMemoryDump_:function(dumpIdEvents,dumpId){var globalRange=new tr.b.Range();for(var pid in dumpIdEvents){var processEvents=dumpIdEvents[pid];for(var i=0;i<processEvents.length;i++)globalRange.addValue(this.toModelTimeFromUs_(processEvents[i].ts));}if(globalRange.isEmpty)throw new Error('Internal error: Global memory dump without events');var globalMemoryDump=new tr.model.GlobalMemoryDump(this.model_,globalRange.min);globalMemoryDump.duration=globalRange.range;this.model_.globalMemoryDumps.push(globalMemoryDump);var globalMemoryAllocatorDumpsByFullName={};var levelsOfDetail={};var allMemoryAllocatorDumpsByGuid={};for(var pid in dumpIdEvents){this.createProcessMemoryDump_(globalMemoryDump,globalMemoryAllocatorDumpsByFullName,levelsOfDetail,allMemoryAllocatorDumpsByGuid,dumpIdEvents[pid],pid,dumpId);}globalMemoryDump.levelOfDetail=levelsOfDetail.global;globalMemoryDump.memoryAllocatorDumps=this.inferMemoryAllocatorDumpTree_(globalMemoryAllocatorDumpsByFullName);this.parseMemoryDumpAllocatorEdges_(allMemoryAllocatorDumpsByGuid,dumpIdEvents,dumpId);},createProcessMemoryDump_:function(globalMemoryDump,globalMemoryAllocatorDumpsByFullName,levelsOfDetail,allMemoryAllocatorDumpsByGuid,processEvents,pid,dumpId){var processRange=new tr.b.Range();for(var i=0;i<processEvents.length;i++)processRange.addValue(this.toModelTimeFromUs_(processEvents[i].ts));if(processRange.isEmpty)throw new Error('Internal error: Process memory dump without events');var process=this.model_.getOrCreateProcess(pid);var processMemoryDump=new tr.model.ProcessMemoryDump(globalMemoryDump,process,processRange.min);processMemoryDump.duration=processRange.range;process.memoryDumps.push(processMemoryDump);globalMemoryDump.processMemoryDumps[pid]=processMemoryDump;var processMemoryAllocatorDumpsByFullName={};for(var i=0;i<processEvents.length;i++){var processEvent=processEvents[i];var dumps=processEvent.args.dumps;if(dumps===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'\'dumps\' field not found in a process memory dump'+' event for PID='+pid+' and dump ID='+dumpId+'.'});continue;}this.parseMemoryDumpTotals_(processMemoryDump,dumps,pid,dumpId);this.parseMemoryDumpVmRegions_(processMemoryDump,dumps,pid,dumpId);this.parseMemoryDumpHeapDumps_(processMemoryDump,dumps,pid,dumpId);this.parseMemoryDumpLevelOfDetail_(levelsOfDetail,dumps,pid,dumpId);this.parseMemoryDumpAllocatorDumps_(processMemoryDump,globalMemoryDump,processMemoryAllocatorDumpsByFullName,globalMemoryAllocatorDumpsByFullName,allMemoryAllocatorDumpsByGuid,dumps,pid,dumpId);}if(levelsOfDetail.process===undefined){levelsOfDetail.process=processMemoryDump.vmRegions?DETAILED:LIGHT;}if(!this.updateMemoryDumpLevelOfDetail_(levelsOfDetail,'global',levelsOfDetail.process)){this.model_.importWarning({type:'memory_dump_parse_error',message:'diffent levels of detail provided for global memory'+' dump (dump ID='+dumpId+').'});}processMemoryDump.levelOfDetail=levelsOfDetail.process;delete levelsOfDetail.process;processMemoryDump.memoryAllocatorDumps=this.inferMemoryAllocatorDumpTree_(processMemoryAllocatorDumpsByFullName);},parseMemoryDumpTotals_:function(processMemoryDump,dumps,pid,dumpId){var rawTotals=dumps.process_totals;if(rawTotals===undefined)return;if(processMemoryDump.totals!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Process totals provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}var totals={};var platformSpecificTotals=undefined;for(var rawTotalName in rawTotals){var rawTotalValue=rawTotals[rawTotalName];if(rawTotalValue===undefined)continue;if(rawTotalName==='resident_set_bytes'){totals.residentBytes=parseInt(rawTotalValue,16);continue;}if(rawTotalName==='peak_resident_set_bytes'){totals.peakResidentBytes=parseInt(rawTotalValue,16);continue;}if(rawTotalName==='is_peak_rss_resetable'){totals.arePeakResidentBytesResettable=!!rawTotalValue;continue;}if(platformSpecificTotals===undefined){platformSpecificTotals={};totals.platformSpecific=platformSpecificTotals;}platformSpecificTotals[rawTotalName]=parseInt(rawTotalValue,16);}if(totals.peakResidentBytes===undefined&&totals.arePeakResidentBytesResettable!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Optional field peak_resident_set_bytes found'+' but is_peak_rss_resetable not found in'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});}if(totals.arePeakResidentBytesResettable!==undefined&&totals.peakResidentBytes===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Optional field is_peak_rss_resetable found'+' but peak_resident_set_bytes not found in'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});}processMemoryDump.totals=totals;},parseMemoryDumpVmRegions_:function(processMemoryDump,dumps,pid,dumpId){var rawProcessMmaps=dumps.process_mmaps;if(rawProcessMmaps===undefined)return;var rawVmRegions=rawProcessMmaps.vm_regions;if(rawVmRegions===undefined)return;if(processMemoryDump.vmRegions!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'VM regions provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}var vmRegions=new Array(rawVmRegions.length);for(var i=0;i<rawVmRegions.length;i++){var rawVmRegion=rawVmRegions[i];var byteStats={};var rawByteStats=rawVmRegion.bs;for(var rawByteStatName in rawByteStats){var rawByteStatValue=rawByteStats[rawByteStatName];if(rawByteStatValue===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Byte stat \''+rawByteStatName+'\' of VM region '+i+' ('+rawVmRegion.mf+') in process memory dump for '+'PID='+pid+' and dump ID='+dumpId+' does not have a value.'});continue;}var byteStatName=BYTE_STAT_NAME_MAP[rawByteStatName];if(byteStatName===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Unknown byte stat name \''+rawByteStatName+'\' ('+rawByteStatValue+') of VM region '+i+' ('+rawVmRegion.mf+') in process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});continue;}byteStats[byteStatName]=parseInt(rawByteStatValue,16);}vmRegions[i]=new tr.model.VMRegion(parseInt(rawVmRegion.sa,16),parseInt(rawVmRegion.sz,16),rawVmRegion.pf,rawVmRegion.mf,byteStats);}processMemoryDump.vmRegions=tr.model.VMRegionClassificationNode.fromRegions(vmRegions);},parseMemoryDumpHeapDumps_:function(processMemoryDump,dumps,pid,dumpId){var rawHeapDumps=dumps.heaps;if(rawHeapDumps===undefined)return;if(processMemoryDump.heapDumps!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Heap dumps provided multiple times for'+' process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}var model=this.model_;var idPrefix='p'+pid+':';var heapDumps={};var objectTypeNameMap=this.objectTypeNameMap_[pid];if(objectTypeNameMap===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing mapping from object type IDs to names.'});}for(var allocatorName in rawHeapDumps){var entries=rawHeapDumps[allocatorName].entries;if(entries===undefined||entries.length===0){this.model_.importWarning({type:'memory_dump_parse_error',message:'No heap entries in a '+allocatorName+' heap dump for PID='+pid+' and dump ID='+dumpId+'.'});continue;}var isOldFormat=entries[0].bt===undefined;if(!isOldFormat&&objectTypeNameMap===undefined){continue;}var heapDump=new tr.model.HeapDump(processMemoryDump,allocatorName);for(var i=0;i<entries.length;i++){var entry=entries[i];var leafStackFrameIndex=entry.bt;var leafStackFrame;if(isOldFormat){if(leafStackFrameIndex===undefined){leafStackFrame=undefined;}else{var leafStackFrameId=idPrefix+leafStackFrameIndex;if(leafStackFrameIndex===''){leafStackFrame=undefined;}else{leafStackFrame=model.stackFrames[leafStackFrameId];if(leafStackFrame===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing leaf stack frame (ID '+leafStackFrameId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}}leafStackFrameId+=':self';if(model.stackFrames[leafStackFrameId]!==undefined){leafStackFrame=model.stackFrames[leafStackFrameId];}else{leafStackFrame=new tr.model.StackFrame(leafStackFrame,leafStackFrameId,'<self>',undefined);model.addStackFrame(leafStackFrame);}}}else{if(leafStackFrameIndex===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing stack frame ID of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}var leafStackFrameId=idPrefix+leafStackFrameIndex;if(leafStackFrameIndex===''){leafStackFrame=undefined;}else{leafStackFrame=model.stackFrames[leafStackFrameId];if(leafStackFrame===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing leaf stack frame (ID '+leafStackFrameId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for PID='+pid+'.'});continue;}}}var objectTypeId=entry.type;var objectTypeName;if(objectTypeId===undefined){objectTypeName=undefined;}else if(objectTypeNameMap===undefined){continue;}else{objectTypeName=objectTypeNameMap[objectTypeId];if(objectTypeName===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Missing object type name (ID '+objectTypeId+') of heap entry '+i+' (size '+size+') in a '+allocatorName+' heap dump for pid='+pid+'.'});continue;}}var size=parseInt(entry.size,16);var count=entry.count===undefined?undefined:parseInt(entry.count,16);heapDump.addEntry(leafStackFrame,objectTypeName,size,count);}if(heapDump.entries.length>0)heapDumps[allocatorName]=heapDump;}if(Object.keys(heapDumps).length>0)processMemoryDump.heapDumps=heapDumps;},parseMemoryDumpLevelOfDetail_:function(levelsOfDetail,dumps,pid,dumpId){var rawLevelOfDetail=dumps.level_of_detail;var level;switch(rawLevelOfDetail){case'background':level=BACKGROUND;break;case'light':level=LIGHT;break;case'detailed':level=DETAILED;break;case undefined:level=undefined;break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'unknown raw level of detail \''+rawLevelOfDetail+'\' of process memory dump for PID='+pid+' and dump ID='+dumpId+'.'});return;}if(!this.updateMemoryDumpLevelOfDetail_(levelsOfDetail,'process',level)){this.model_.importWarning({type:'memory_dump_parse_error',message:'diffent levels of detail provided for process memory'+' dump for PID='+pid+' (dump ID='+dumpId+').'});}},updateMemoryDumpLevelOfDetail_:function(levelsOfDetail,scope,level){if(!(scope in levelsOfDetail)||level===levelsOfDetail[scope]){levelsOfDetail[scope]=level;return true;}if(MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER.indexOf(level)>MEMORY_DUMP_LEVEL_OF_DETAIL_ORDER.indexOf(levelsOfDetail[scope])){levelsOfDetail[scope]=level;}return false;},parseMemoryDumpAllocatorDumps_:function(processMemoryDump,globalMemoryDump,processMemoryAllocatorDumpsByFullName,globalMemoryAllocatorDumpsByFullName,allMemoryAllocatorDumpsByGuid,dumps,pid,dumpId){var rawAllocatorDumps=dumps.allocators;if(rawAllocatorDumps===undefined)return;for(var fullName in rawAllocatorDumps){var rawAllocatorDump=rawAllocatorDumps[fullName];var guid=rawAllocatorDump.guid;if(guid===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' for PID='+pid+' and dump ID='+dumpId+' does not have a GUID.'});}var flags=rawAllocatorDump.flags||0;var isWeakDump=!!(flags&WEAK_MEMORY_ALLOCATOR_DUMP_FLAG);var containerMemoryDump;var dstIndex;if(fullName.startsWith(GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX)){fullName=fullName.substring(GLOBAL_MEMORY_ALLOCATOR_DUMP_PREFIX.length);containerMemoryDump=globalMemoryDump;dstIndex=globalMemoryAllocatorDumpsByFullName;}else{containerMemoryDump=processMemoryDump;dstIndex=processMemoryAllocatorDumpsByFullName;}var allocatorDump=allMemoryAllocatorDumpsByGuid[guid];if(allocatorDump===undefined){if(fullName in dstIndex){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple GUIDs provided for'+' memory allocator dump '+fullName+': '+dstIndex[fullName].guid+', '+guid+' (ignored) for'+' PID='+pid+' and dump ID='+dumpId+'.'});continue;}allocatorDump=new tr.model.MemoryAllocatorDump(containerMemoryDump,fullName,guid);allocatorDump.weak=isWeakDump;dstIndex[fullName]=allocatorDump;if(guid!==undefined)allMemoryAllocatorDumpsByGuid[guid]=allocatorDump;}else{if(allocatorDump.containerMemoryDump!==containerMemoryDump){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+' dumped in different contexts.'});continue;}if(allocatorDump.fullName!==fullName){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump with GUID='+guid+' for PID='+pid+' and dump ID='+dumpId+' has multiple names: '+allocatorDump.fullName+', '+fullName+' (ignored).'});continue;}if(!isWeakDump){allocatorDump.weak=false;}}var attributes=rawAllocatorDump.attrs;if(attributes===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+' does not have attributes.'});attributes={};}for(var attrName in attributes){var attrArgs=attributes[attrName];var attrType=attrArgs.type;var attrValue=attrArgs.value;switch(attrType){case'scalar':if(attrName in allocatorDump.numerics){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple values provided for scalar attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+'.'});break;}var unit=attrArgs.units==='bytes'?tr.b.Unit.byName.sizeInBytes_smallerIsBetter:tr.b.Unit.byName.unitlessNumber_smallerIsBetter;var value=parseInt(attrValue,16);allocatorDump.addNumeric(attrName,new tr.v.ScalarNumeric(unit,value));break;case'string':if(attrName in allocatorDump.diagnostics){this.model_.importWarning({type:'memory_dump_parse_error',message:'Multiple values provided for string attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+'.'});break;}allocatorDump.addDiagnostic(attrName,attrValue);break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'Unknown type provided for attribute '+attrName+' of memory allocator dump '+fullName+' (GUID='+guid+') for PID='+pid+' and dump ID='+dumpId+': '+attrType});break;}}}},inferMemoryAllocatorDumpTree_:function(memoryAllocatorDumpsByFullName){var rootAllocatorDumps=[];var fullNames=Object.keys(memoryAllocatorDumpsByFullName);fullNames.sort();for(var i=0;i<fullNames.length;i++){var fullName=fullNames[i];var allocatorDump=memoryAllocatorDumpsByFullName[fullName];while(true){var lastSlashIndex=fullName.lastIndexOf('/');if(lastSlashIndex===-1){rootAllocatorDumps.push(allocatorDump);break;}var parentFullName=fullName.substring(0,lastSlashIndex);var parentAllocatorDump=memoryAllocatorDumpsByFullName[parentFullName];var parentAlreadyExisted=true;if(parentAllocatorDump===undefined){parentAlreadyExisted=false;parentAllocatorDump=new tr.model.MemoryAllocatorDump(allocatorDump.containerMemoryDump,parentFullName);if(allocatorDump.weak!==false){parentAllocatorDump.weak=undefined;}memoryAllocatorDumpsByFullName[parentFullName]=parentAllocatorDump;}allocatorDump.parent=parentAllocatorDump;parentAllocatorDump.children.push(allocatorDump);if(parentAlreadyExisted){if(!allocatorDump.weak){while(parentAllocatorDump!==undefined&&parentAllocatorDump.weak===undefined){parentAllocatorDump.weak=false;parentAllocatorDump=parentAllocatorDump.parent;}}break;}fullName=parentFullName;allocatorDump=parentAllocatorDump;}}for(var fullName in memoryAllocatorDumpsByFullName){var allocatorDump=memoryAllocatorDumpsByFullName[fullName];if(allocatorDump.weak===undefined)allocatorDump.weak=true;}return rootAllocatorDumps;},parseMemoryDumpAllocatorEdges_:function(allMemoryAllocatorDumpsByGuid,dumpIdEvents,dumpId){for(var pid in dumpIdEvents){var processEvents=dumpIdEvents[pid];for(var i=0;i<processEvents.length;i++){var processEvent=processEvents[i];var dumps=processEvent.args.dumps;if(dumps===undefined)continue;var rawEdges=dumps.allocators_graph;if(rawEdges===undefined)continue;for(var j=0;j<rawEdges.length;j++){var rawEdge=rawEdges[j];var sourceGuid=rawEdge.source;var sourceDump=allMemoryAllocatorDumpsByGuid[sourceGuid];if(sourceDump===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Edge for PID='+pid+' and dump ID='+dumpId+' is missing source memory allocator dump (GUID='+sourceGuid+').'});continue;}var targetGuid=rawEdge.target;var targetDump=allMemoryAllocatorDumpsByGuid[targetGuid];if(targetDump===undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Edge for PID='+pid+' and dump ID='+dumpId+' is missing target memory allocator dump (GUID='+targetGuid+').'});continue;}var importance=rawEdge.importance;var edge=new tr.model.MemoryAllocatorDumpLink(sourceDump,targetDump,importance);switch(rawEdge.type){case'ownership':if(sourceDump.owns!==undefined){this.model_.importWarning({type:'memory_dump_parse_error',message:'Memory allocator dump '+sourceDump.fullName+' (GUID='+sourceGuid+') already owns a memory'+' allocator dump ('+sourceDump.owns.target.fullName+').'});}else{sourceDump.owns=edge;targetDump.ownedBy.push(edge);}break;case'retention':sourceDump.retains.push(edge);targetDump.retainedBy.push(edge);break;default:this.model_.importWarning({type:'memory_dump_parse_error',message:'Invalid edge type: '+rawEdge.type+' (PID='+pid+', dump ID='+dumpId+', source='+sourceGuid+', target='+targetGuid+', importance='+importance+').'});}}}}},toModelTimeFromUs_:function(ts){if(!this.toModelTime_){this.toModelTime_=this.model_.clockSyncManager.getModelTimeTransformer(this.clockDomainId_);}return this.toModelTime_(tr.b.Unit.timestampFromUs(ts));},maybeToModelTimeFromUs_:function(ts){if(ts===undefined)return undefined;return this.toModelTimeFromUs_(ts);}};tr.importer.Importer.register(TraceEventImporter);return{TraceEventImporter:TraceEventImporter};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../../base/base64.js":34,"../../base/color_scheme.js":37,"../../base/range.js":52,"../../base/unit.js":62,"../../base/utils.js":64,"../../importer/context_processor.js":75,"../../importer/importer.js":81,"../../model/comment_box_annotation.js":111,"../../model/constants.js":113,"../../model/container_memory_dump.js":114,"../../model/counter_series.js":117,"../../model/flow_event.js":126,"../../model/global_memory_dump.js":128,"../../model/heap_dump.js":129,"../../model/instant_event.js":135,"../../model/memory_allocator_dump.js":139,"../../model/model.js":140,"../../model/process_memory_dump.js":150,"../../model/rect_annotation.js":151,"../../model/scoped_id.js":153,"../../model/slice_group.js":157,"../../model/vm_region.js":173,"../../model/x_marker_annotation.js":174,"../../value/numeric.js":195,"./trace_code_entry.js":69,"./trace_code_map.js":70,"./v8/codemap.js":72}],72:[function(require,module,exports){(function(global){"use strict";require("./splaytree.js");'use strict';global.tr.exportTo('tr.e.importer.v8',function(){function CodeMap(){this.dynamics_=new tr.e.importer.v8.SplayTree();this.dynamicsNameGen_=new tr.e.importer.v8.CodeMap.NameGenerator();this.statics_=new tr.e.importer.v8.SplayTree();this.libraries_=new tr.e.importer.v8.SplayTree();this.pages_=[];}CodeMap.PAGE_ALIGNMENT=12;CodeMap.PAGE_SIZE=1<<CodeMap.PAGE_ALIGNMENT;CodeMap.prototype.addCode=function(start,codeEntry){this.deleteAllCoveredNodes_(this.dynamics_,start,start+codeEntry.size);this.dynamics_.insert(start,codeEntry);};CodeMap.prototype.moveCode=function(from,to){var removedNode=this.dynamics_.remove(from);this.deleteAllCoveredNodes_(this.dynamics_,to,to+removedNode.value.size);this.dynamics_.insert(to,removedNode.value);};CodeMap.prototype.deleteCode=function(start){var removedNode=this.dynamics_.remove(start);};CodeMap.prototype.addLibrary=function(start,codeEntry){this.markPages_(start,start+codeEntry.size);this.libraries_.insert(start,codeEntry);};CodeMap.prototype.addStaticCode=function(start,codeEntry){this.statics_.insert(start,codeEntry);};CodeMap.prototype.markPages_=function(start,end){for(var addr=start;addr<=end;addr+=CodeMap.PAGE_SIZE){this.pages_[addr>>>CodeMap.PAGE_ALIGNMENT]=1;}};CodeMap.prototype.deleteAllCoveredNodes_=function(tree,start,end){var toDelete=[];var addr=end-1;while(addr>=start){var node=tree.findGreatestLessThan(addr);if(!node)break;var start2=node.key,end2=start2+node.value.size;if(start2<end&&start<end2)toDelete.push(start2);addr=start2-1;}for(var i=0,l=toDelete.length;i<l;++i)tree.remove(toDelete[i]);};CodeMap.prototype.isAddressBelongsTo_=function(addr,node){return addr>=node.key&&addr<node.key+node.value.size;};CodeMap.prototype.findInTree_=function(tree,addr){var node=tree.findGreatestLessThan(addr);return node&&this.isAddressBelongsTo_(addr,node)?node.value:null;};CodeMap.prototype.findEntryInLibraries=function(addr){var pageAddr=addr>>>CodeMap.PAGE_ALIGNMENT;if(pageAddr in this.pages_)return this.findInTree_(this.libraries_,addr);return undefined;};CodeMap.prototype.findEntry=function(addr){var pageAddr=addr>>>CodeMap.PAGE_ALIGNMENT;if(pageAddr in this.pages_){return this.findInTree_(this.statics_,addr)||this.findInTree_(this.libraries_,addr);}var min=this.dynamics_.findMin();var max=this.dynamics_.findMax();if(max!=null&&addr<max.key+max.value.size&&addr>=min.key){var dynaEntry=this.findInTree_(this.dynamics_,addr);if(dynaEntry==null)return null;if(!dynaEntry.nameUpdated_){dynaEntry.name=this.dynamicsNameGen_.getName(dynaEntry.name);dynaEntry.nameUpdated_=true;}return dynaEntry;}return null;};CodeMap.prototype.findDynamicEntryByStartAddress=function(addr){var node=this.dynamics_.find(addr);return node?node.value:null;};CodeMap.prototype.getAllDynamicEntries=function(){return this.dynamics_.exportValues();};CodeMap.prototype.getAllDynamicEntriesWithAddresses=function(){return this.dynamics_.exportKeysAndValues();};CodeMap.prototype.getAllStaticEntries=function(){return this.statics_.exportValues();};CodeMap.prototype.getAllLibrariesEntries=function(){return this.libraries_.exportValues();};CodeMap.CodeState={COMPILED:0,OPTIMIZABLE:1,OPTIMIZED:2};CodeMap.CodeEntry=function(size,opt_name,opt_type){this.id=tr.b.GUID.allocateSimple();this.size=size;this.name_=opt_name||'';this.type=opt_type||'';this.nameUpdated_=false;};CodeMap.CodeEntry.prototype={__proto__:Object.prototype,get name(){return this.name_;},set name(value){this.name_=value;},toString:function(){this.name_+': '+this.size.toString(16);}};CodeMap.CodeEntry.TYPE={SHARED_LIB:'SHARED_LIB',CPP:'CPP'};CodeMap.DynamicFuncCodeEntry=function(size,type,func,state){CodeMap.CodeEntry.call(this,size,'',type);this.func=func;this.state=state;};CodeMap.DynamicFuncCodeEntry.STATE_PREFIX=['','~','*'];CodeMap.DynamicFuncCodeEntry.prototype={__proto__:CodeMap.CodeEntry.prototype,get name(){return CodeMap.DynamicFuncCodeEntry.STATE_PREFIX[this.state]+this.func.name;},set name(value){this.name_=value;},getRawName:function(){return this.func.getName();},isJSFunction:function(){return true;},toString:function(){return this.type+': '+this.name+': '+this.size.toString(16);}};CodeMap.FunctionEntry=function(name){CodeMap.CodeEntry.call(this,0,name);};CodeMap.FunctionEntry.prototype={__proto__:CodeMap.CodeEntry.prototype,get name(){var name=this.name_;if(name.length==0){name='<anonymous>';}else if(name.charAt(0)==' '){name='<anonymous>'+name;}return name;},set name(value){this.name_=value;}};CodeMap.NameGenerator=function(){this.knownNames_={};};CodeMap.NameGenerator.prototype.getName=function(name){if(!(name in this.knownNames_)){this.knownNames_[name]=0;return name;}var count=++this.knownNames_[name];return name+' {'+count+'}';};return{CodeMap:CodeMap};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"./splaytree.js":73}],73:[function(require,module,exports){(function(global){"use strict";require("../../../base/base.js");'use strict';global.tr.exportTo('tr.e.importer.v8',function(){function SplayTree(){};SplayTree.prototype.root_=null;SplayTree.prototype.isEmpty=function(){return!this.root_;};SplayTree.prototype.insert=function(key,value){if(this.isEmpty()){this.root_=new SplayTree.Node(key,value);return;}this.splay_(key);if(this.root_.key==key){return;}var node=new SplayTree.Node(key,value);if(key>this.root_.key){node.left=this.root_;node.right=this.root_.right;this.root_.right=null;}else{node.right=this.root_;node.left=this.root_.left;this.root_.left=null;}this.root_=node;};SplayTree.prototype.remove=function(key){if(this.isEmpty()){throw Error('Key not found: '+key);}this.splay_(key);if(this.root_.key!=key){throw Error('Key not found: '+key);}var removed=this.root_;if(!this.root_.left){this.root_=this.root_.right;}else{var right=this.root_.right;this.root_=this.root_.left;this.splay_(key);this.root_.right=right;}return removed;};SplayTree.prototype.find=function(key){if(this.isEmpty()){return null;}this.splay_(key);return this.root_.key==key?this.root_:null;};SplayTree.prototype.findMin=function(){if(this.isEmpty()){return null;}var current=this.root_;while(current.left){current=current.left;}return current;};SplayTree.prototype.findMax=function(opt_startNode){if(this.isEmpty()){return null;}var current=opt_startNode||this.root_;while(current.right){current=current.right;}return current;};SplayTree.prototype.findGreatestLessThan=function(key){if(this.isEmpty()){return null;}this.splay_(key);if(this.root_.key<=key){return this.root_;}else if(this.root_.left){return this.findMax(this.root_.left);}else{return null;}};SplayTree.prototype.exportKeysAndValues=function(){var result=[];this.traverse_(function(node){result.push([node.key,node.value]);});return result;};SplayTree.prototype.exportValues=function(){var result=[];this.traverse_(function(node){result.push(node.value);});return result;};SplayTree.prototype.splay_=function(key){if(this.isEmpty()){return;}var dummy,left,right;dummy=left=right=new SplayTree.Node(null,null);var current=this.root_;while(true){if(key<current.key){if(!current.left){break;}if(key<current.left.key){var tmp=current.left;current.left=tmp.right;tmp.right=current;current=tmp;if(!current.left){break;}}right.left=current;right=current;current=current.left;}else if(key>current.key){if(!current.right){break;}if(key>current.right.key){var tmp=current.right;current.right=tmp.left;tmp.left=current;current=tmp;if(!current.right){break;}}left.right=current;left=current;current=current.right;}else{break;}}left.right=current.left;right.left=current.right;current.left=dummy.right;current.right=dummy.left;this.root_=current;};SplayTree.prototype.traverse_=function(f){var nodesToVisit=[this.root_];while(nodesToVisit.length>0){var node=nodesToVisit.shift();if(node==null){continue;}f(node);nodesToVisit.push(node.left);nodesToVisit.push(node.right);}};SplayTree.Node=function(key,value){this.key=key;this.value=value;};SplayTree.Node.prototype.left=null;SplayTree.Node.prototype.right=null;return{SplayTree:SplayTree};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../../../base/base.js":33}],74:[function(require,module,exports){"use strict";require("./importer/trace_event_importer.js");require("../model/model.js");},{"../model/model.js":140,"./importer/trace_event_importer.js":71}],75:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");'use strict';global.tr.exportTo('tr.importer',function(){function ContextProcessor(model){this.model_=model;this.activeContexts_=[];this.stackPerType_={};this.contextCache_={};this.contextSetCache_={};this.cachedEntryForActiveContexts_=undefined;this.seenSnapshots_={};};ContextProcessor.prototype={enterContext:function(contextType,scopedId){var newActiveContexts=[this.getOrCreateContext_(contextType,scopedId)];for(var oldContext of this.activeContexts_){if(oldContext.type===contextType){this.pushContext_(oldContext);}else{newActiveContexts.push(oldContext);}}this.activeContexts_=newActiveContexts;this.cachedEntryForActiveContexts_=undefined;},leaveContext:function(contextType,scopedId){this.leaveContextImpl_(context=>context.type===contextType&&context.snapshot.scope===scopedId.scope&&context.snapshot.idRef===scopedId.id);},destroyContext:function(scopedId){tr.b.iterItems(this.stackPerType_,function(contextType,stack){var newLength=0;for(var i=0;i<stack.length;++i){if(stack[i].snapshot.scope!==scopedId.scope||stack[i].snapshot.idRef!==scopedId.id){stack[newLength++]=stack[i];}}stack.length=newLength;});this.leaveContextImpl_(context=>context.snapshot.scope===scopedId.scope&&context.snapshot.idRef===scopedId.id);},leaveContextImpl_:function(predicate){var newActiveContexts=[];for(var oldContext of this.activeContexts_){if(predicate(oldContext)){var previousContext=this.popContext_(oldContext.type);if(previousContext)newActiveContexts.push(previousContext);}else{newActiveContexts.push(oldContext);}}this.activeContexts_=newActiveContexts;this.cachedEntryForActiveContexts_=undefined;},getOrCreateContext_:function(contextType,scopedId){var context={type:contextType,snapshot:{scope:scopedId.scope,idRef:scopedId.id}};var key=this.getContextKey_(context);if(key in this.contextCache_)return this.contextCache_[key];this.contextCache_[key]=context;var snapshotKey=this.getSnapshotKey_(scopedId);this.seenSnapshots_[snapshotKey]=true;return context;},pushContext_:function(context){if(!(context.type in this.stackPerType_))this.stackPerType_[context.type]=[];this.stackPerType_[context.type].push(context);},popContext_:function(contextType){if(!(contextType in this.stackPerType_))return undefined;return this.stackPerType_[contextType].pop();},getContextKey_:function(context){return[context.type,context.snapshot.scope,context.snapshot.idRef].join('\x00');},getSnapshotKey_:function(scopedId){return[scopedId.scope,scopedId.idRef].join('\x00');},get activeContexts(){if(this.cachedEntryForActiveContexts_===undefined){var key=[];for(var context of this.activeContexts_)key.push(this.getContextKey_(context));key.sort();key=key.join('\x00');if(key in this.contextSetCache_){this.cachedEntryForActiveContexts_=this.contextSetCache_[key];}else{this.activeContexts_.sort(function(a,b){var keyA=this.getContextKey_(a);var keyB=this.getContextKey_(b);if(keyA<keyB)return-1;if(keyA>keyB)return 1;return 0;}.bind(this));this.contextSetCache_[key]=Object.freeze(this.activeContexts_);this.cachedEntryForActiveContexts_=this.contextSetCache_[key];}}return this.cachedEntryForActiveContexts_;},invalidateContextCacheForSnapshot:function(scopedId){var snapshotKey=this.getSnapshotKey_(scopedId);if(!(snapshotKey in this.seenSnapshots_))return;this.contextCache_={};this.contextSetCache_={};this.cachedEntryForActiveContexts_=undefined;this.activeContexts_=this.activeContexts_.map(function(context){if(context.snapshot.scope!==scopedId.scope||context.snapshot.idRef!==scopedId.id)return context;return{type:context.type,snapshot:{scope:context.snapshot.scope,idRef:context.snapshot.idRef}};});this.seenSnapshots_={};}};return{ContextProcessor:ContextProcessor};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../base/base.js":33}],76:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("./importer.js");'use strict';global.tr.exportTo('tr.importer',function(){function EmptyImporter(events){this.importPriority=0;};EmptyImporter.canImport=function(eventData){if(eventData instanceof Array&&eventData.length==0)return true;if(typeof eventData==='string'||eventData instanceof String){return eventData.length==0;}return false;};EmptyImporter.prototype={__proto__:tr.importer.Importer.prototype,get importerName(){return'EmptyImporter';}};tr.importer.Importer.register(EmptyImporter);return{EmptyImporter:EmptyImporter};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../base/base.js":33,"./importer.js":81}],77:[function(require,module,exports){(function(global){"use strict";require("../base/range_utils.js");require("../extras/chrome/cc/input_latency_async_slice.js");require("./proto_expectation.js");'use strict';global.tr.exportTo('tr.importer',function(){var ProtoExpectation=tr.importer.ProtoExpectation;var INPUT_TYPE=tr.e.cc.INPUT_EVENT_TYPE_NAMES;var KEYBOARD_TYPE_NAMES=[INPUT_TYPE.CHAR,INPUT_TYPE.KEY_DOWN_RAW,INPUT_TYPE.KEY_DOWN,INPUT_TYPE.KEY_UP];var MOUSE_RESPONSE_TYPE_NAMES=[INPUT_TYPE.CLICK,INPUT_TYPE.CONTEXT_MENU];var MOUSE_WHEEL_TYPE_NAMES=[INPUT_TYPE.MOUSE_WHEEL];var MOUSE_DRAG_TYPE_NAMES=[INPUT_TYPE.MOUSE_DOWN,INPUT_TYPE.MOUSE_MOVE,INPUT_TYPE.MOUSE_UP];var TAP_TYPE_NAMES=[INPUT_TYPE.TAP,INPUT_TYPE.TAP_CANCEL,INPUT_TYPE.TAP_DOWN];var PINCH_TYPE_NAMES=[INPUT_TYPE.PINCH_BEGIN,INPUT_TYPE.PINCH_END,INPUT_TYPE.PINCH_UPDATE];var FLING_TYPE_NAMES=[INPUT_TYPE.FLING_CANCEL,INPUT_TYPE.FLING_START];var TOUCH_TYPE_NAMES=[INPUT_TYPE.TOUCH_END,INPUT_TYPE.TOUCH_MOVE,INPUT_TYPE.TOUCH_START];var SCROLL_TYPE_NAMES=[INPUT_TYPE.SCROLL_BEGIN,INPUT_TYPE.SCROLL_END,INPUT_TYPE.SCROLL_UPDATE];var ALL_HANDLED_TYPE_NAMES=[].concat(KEYBOARD_TYPE_NAMES,MOUSE_RESPONSE_TYPE_NAMES,MOUSE_WHEEL_TYPE_NAMES,MOUSE_DRAG_TYPE_NAMES,PINCH_TYPE_NAMES,TAP_TYPE_NAMES,FLING_TYPE_NAMES,TOUCH_TYPE_NAMES,SCROLL_TYPE_NAMES);var RENDERER_FLING_TITLE='InputHandlerProxy::HandleGestureFling::started';var PLAYBACK_EVENT_TITLE='VideoPlayback';var CSS_ANIMATION_TITLE='Animation';var INPUT_MERGE_THRESHOLD_MS=200;var ANIMATION_MERGE_THRESHOLD_MS=32;var MOUSE_WHEEL_THRESHOLD_MS=40;var MOUSE_MOVE_THRESHOLD_MS=40;var KEYBOARD_IR_NAME='Keyboard';var MOUSE_IR_NAME='Mouse';var MOUSEWHEEL_IR_NAME='MouseWheel';var TAP_IR_NAME='Tap';var PINCH_IR_NAME='Pinch';var FLING_IR_NAME='Fling';var TOUCH_IR_NAME='Touch';var SCROLL_IR_NAME='Scroll';var CSS_IR_NAME='CSS';var WEBGL_IR_NAME='WebGL';var VIDEO_IR_NAME='Video';function compareEvents(x,y){if(x.start!==y.start)return x.start-y.start;if(x.end!==y.end)return x.end-y.end;if(x.guid&&y.guid)return x.guid-y.guid;return 0;}function forEventTypesIn(events,typeNames,cb,opt_this){events.forEach(function(event){if(typeNames.indexOf(event.typeName)>=0){cb.call(opt_this,event);}});}function causedFrame(event){return event.associatedEvents.some(x=>x.title===tr.model.helpers.IMPL_RENDERING_STATS);}function getSortedFrameEventsByProcess(modelHelper){var frameEventsByPid={};tr.b.iterItems(modelHelper.rendererHelpers,function(pid,rendererHelper){frameEventsByPid[pid]=rendererHelper.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE,modelHelper.model.bounds);});return frameEventsByPid;}function getSortedInputEvents(modelHelper){var inputEvents=[];var browserProcess=modelHelper.browserHelper.process;var mainThread=browserProcess.findAtMostOneThreadNamed('CrBrowserMain');for(var slice of mainThread.asyncSliceGroup.getDescendantEvents()){if(!slice.isTopLevel)continue;if(!(slice instanceof tr.e.cc.InputLatencyAsyncSlice))continue;if(isNaN(slice.start)||isNaN(slice.duration)||isNaN(slice.end))continue;inputEvents.push(slice);}return inputEvents.sort(compareEvents);}function findProtoExpectations(modelHelper,sortedInputEvents){var protoExpectations=[];var handlers=[handleKeyboardEvents,handleMouseResponseEvents,handleMouseWheelEvents,handleMouseDragEvents,handleTapResponseEvents,handlePinchEvents,handleFlingEvents,handleTouchEvents,handleScrollEvents,handleCSSAnimations,handleWebGLAnimations,handleVideoAnimations];handlers.forEach(function(handler){protoExpectations.push.apply(protoExpectations,handler(modelHelper,sortedInputEvents));});protoExpectations.sort(compareEvents);return protoExpectations;}function handleKeyboardEvents(modelHelper,sortedInputEvents){var protoExpectations=[];forEventTypesIn(sortedInputEvents,KEYBOARD_TYPE_NAMES,function(event){var pe=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,KEYBOARD_IR_NAME);pe.pushEvent(event);protoExpectations.push(pe);});return protoExpectations;}function handleMouseResponseEvents(modelHelper,sortedInputEvents){var protoExpectations=[];forEventTypesIn(sortedInputEvents,MOUSE_RESPONSE_TYPE_NAMES,function(event){var pe=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSE_IR_NAME);pe.pushEvent(event);protoExpectations.push(pe);});return protoExpectations;}function handleMouseWheelEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var prevEvent_=undefined;forEventTypesIn(sortedInputEvents,MOUSE_WHEEL_TYPE_NAMES,function(event){var prevEvent=prevEvent_;prevEvent_=event;if(currentPE&&prevEvent.start+MOUSE_WHEEL_THRESHOLD_MS>=event.start){if(currentPE.irType===ProtoExpectation.ANIMATION_TYPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,MOUSEWHEEL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}return;}currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSEWHEEL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);});return protoExpectations;}function handleMouseDragEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var mouseDownEvent=undefined;forEventTypesIn(sortedInputEvents,MOUSE_DRAG_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.MOUSE_DOWN:if(causedFrame(event)){var pe=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSE_IR_NAME);pe.pushEvent(event);protoExpectations.push(pe);}else{mouseDownEvent=event;}break;case INPUT_TYPE.MOUSE_MOVE:if(!causedFrame(event)){var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);}else if(!currentPE||!currentPE.isNear(event,MOUSE_MOVE_THRESHOLD_MS)){currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSE_IR_NAME);currentPE.pushEvent(event);if(mouseDownEvent){currentPE.associatedEvents.push(mouseDownEvent);mouseDownEvent=undefined;}protoExpectations.push(currentPE);}else{if(currentPE.irType===ProtoExpectation.ANIMATION_TYPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,MOUSE_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}}break;case INPUT_TYPE.MOUSE_UP:if(!mouseDownEvent){var pe=new ProtoExpectation(causedFrame(event)?ProtoExpectation.RESPONSE_TYPE:ProtoExpectation.IGNORED_TYPE,MOUSE_IR_NAME);pe.pushEvent(event);protoExpectations.push(pe);break;}if(currentPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,MOUSE_IR_NAME);if(mouseDownEvent)currentPE.associatedEvents.push(mouseDownEvent);currentPE.pushEvent(event);protoExpectations.push(currentPE);}mouseDownEvent=undefined;currentPE=undefined;break;}});if(mouseDownEvent){currentPE=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);currentPE.pushEvent(mouseDownEvent);protoExpectations.push(currentPE);}return protoExpectations;}function handleTapResponseEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;forEventTypesIn(sortedInputEvents,TAP_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.TAP_DOWN:currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,TAP_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);break;case INPUT_TYPE.TAP:if(currentPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,TAP_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}currentPE=undefined;break;case INPUT_TYPE.TAP_CANCEL:if(!currentPE){var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);break;}if(currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,TAP_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}currentPE=undefined;break;}});return protoExpectations;}function handlePinchEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var sawFirstUpdate=false;var modelBounds=modelHelper.model.bounds;forEventTypesIn(sortedInputEvents,PINCH_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.PINCH_BEGIN:if(currentPE&&currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){currentPE.pushEvent(event);break;}currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,PINCH_IR_NAME);currentPE.pushEvent(event);currentPE.isAnimationBegin=true;protoExpectations.push(currentPE);sawFirstUpdate=false;break;case INPUT_TYPE.PINCH_UPDATE:if(!currentPE||currentPE.irType===ProtoExpectation.RESPONSE_TYPE&&sawFirstUpdate||!currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,PINCH_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}else{currentPE.pushEvent(event);sawFirstUpdate=true;}break;case INPUT_TYPE.PINCH_END:if(currentPE){currentPE.pushEvent(event);}else{var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);}currentPE=undefined;break;}});return protoExpectations;}function handleFlingEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;function isRendererFling(event){return event.title===RENDERER_FLING_TITLE;}var browserHelper=modelHelper.browserHelper;var flingEvents=browserHelper.getAllAsyncSlicesMatching(isRendererFling);forEventTypesIn(sortedInputEvents,FLING_TYPE_NAMES,function(event){flingEvents.push(event);});flingEvents.sort(compareEvents);flingEvents.forEach(function(event){if(event.title===RENDERER_FLING_TITLE){if(currentPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,FLING_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}return;}switch(event.typeName){case INPUT_TYPE.FLING_START:if(currentPE){console.assert(true,'Another FlingStart? File a bug with this trace!');currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,FLING_IR_NAME);currentPE.pushEvent(event);currentPE.end=0;protoExpectations.push(currentPE);}break;case INPUT_TYPE.FLING_CANCEL:if(currentPE){currentPE.pushEvent(event);currentPE.end=event.start;currentPE=undefined;}else{var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);}break;}});if(currentPE&&!currentPE.end)currentPE.end=modelHelper.model.bounds.max;return protoExpectations;}function handleTouchEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var sawFirstMove=false;forEventTypesIn(sortedInputEvents,TOUCH_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.TOUCH_START:if(currentPE){currentPE.pushEvent(event);}else{currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,TOUCH_IR_NAME);currentPE.pushEvent(event);currentPE.isAnimationBegin=true;protoExpectations.push(currentPE);sawFirstMove=false;}break;case INPUT_TYPE.TOUCH_MOVE:if(!currentPE){currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,TOUCH_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);break;}if(sawFirstMove&&currentPE.irType===ProtoExpectation.RESPONSE_TYPE||!currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){var prevEnd=currentPE.end;currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,TOUCH_IR_NAME);currentPE.pushEvent(event);currentPE.start=prevEnd;protoExpectations.push(currentPE);}else{currentPE.pushEvent(event);sawFirstMove=true;}break;case INPUT_TYPE.TOUCH_END:if(!currentPE){var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);break;}if(currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)){currentPE.pushEvent(event);}else{var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);}currentPE=undefined;break;}});return protoExpectations;}function handleScrollEvents(modelHelper,sortedInputEvents){var protoExpectations=[];var currentPE=undefined;var sawFirstUpdate=false;forEventTypesIn(sortedInputEvents,SCROLL_TYPE_NAMES,function(event){switch(event.typeName){case INPUT_TYPE.SCROLL_BEGIN:currentPE=new ProtoExpectation(ProtoExpectation.RESPONSE_TYPE,SCROLL_IR_NAME);currentPE.pushEvent(event);currentPE.isAnimationBegin=true;protoExpectations.push(currentPE);sawFirstUpdate=false;break;case INPUT_TYPE.SCROLL_UPDATE:if(currentPE){if(currentPE.isNear(event,INPUT_MERGE_THRESHOLD_MS)&&(currentPE.irType===ProtoExpectation.ANIMATION_TYPE||!sawFirstUpdate)){currentPE.pushEvent(event);sawFirstUpdate=true;}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,SCROLL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}}else{currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,SCROLL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}break;case INPUT_TYPE.SCROLL_END:if(!currentPE){console.assert(true,'ScrollEnd without ScrollUpdate? '+'File a bug with this trace!');var pe=new ProtoExpectation(ProtoExpectation.IGNORED_TYPE);pe.pushEvent(event);protoExpectations.push(pe);break;}currentPE.pushEvent(event);break;}});return protoExpectations;}function handleVideoAnimations(modelHelper,sortedInputEvents){var events=[];for(var pid in modelHelper.rendererHelpers){for(var asyncSlice of modelHelper.rendererHelpers[pid].mainThread.asyncSliceGroup.slices){if(asyncSlice.title===PLAYBACK_EVENT_TITLE)events.push(asyncSlice);}}events.sort(tr.importer.compareEvents);var protoExpectations=[];for(var event of events){var currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,VIDEO_IR_NAME);currentPE.start=event.start;currentPE.end=event.end;currentPE.pushEvent(event);protoExpectations.push(currentPE);}return protoExpectations;}function handleCSSAnimations(modelHelper,sortedInputEvents){var animationEvents=modelHelper.browserHelper.getAllAsyncSlicesMatching(function(event){return event.title===CSS_ANIMATION_TITLE&&event.isTopLevel&&event.duration>0;});var animationRanges=[];function pushAnimationRange(start,end,animation){var range=tr.b.Range.fromExplicitRange(start,end);range.animation=animation;animationRanges.push(range);}animationEvents.forEach(function(animation){if(animation.subSlices.length===0){pushAnimationRange(animation.start,animation.end,animation);}else{var start=undefined;animation.subSlices.forEach(function(sub){if(sub.args.data.state==='running'&&start===undefined){start=sub.start;}else if(sub.args.data.state==='paused'||sub.args.data.state==='idle'||sub.args.data.state==='finished'){if(start===undefined){start=modelHelper.model.bounds.min;}pushAnimationRange(start,sub.start,animation);start=undefined;}});if(start!==undefined)pushAnimationRange(start,animation.end,animation);}});return animationRanges.map(function(range){var protoExpectation=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,CSS_IR_NAME);protoExpectation.start=range.min;protoExpectation.end=range.max;protoExpectation.associatedEvents.push(range.animation);return protoExpectation;});}function findWebGLEvents(modelHelper,mailboxEvents,animationEvents){for(var event of modelHelper.model.getDescendantEvents()){if(event.title==='DrawingBuffer::prepareMailbox')mailboxEvents.push(event);else if(event.title==='PageAnimator::serviceScriptedAnimations')animationEvents.push(event);}}function findMailboxEventsNearAnimationEvents(mailboxEvents,animationEvents){if(animationEvents.length===0)return[];mailboxEvents.sort(compareEvents);animationEvents.sort(compareEvents);var animationIterator=animationEvents[Symbol.iterator]();var animationEvent=animationIterator.next().value;var filteredEvents=[];for(var event of mailboxEvents){while(animationEvent&&animationEvent.start<event.start-ANIMATION_MERGE_THRESHOLD_MS)animationEvent=animationIterator.next().value;if(!animationEvent)break;if(animationEvent.start<event.start+ANIMATION_MERGE_THRESHOLD_MS)filteredEvents.push(event);}return filteredEvents;}function createProtoExpectationsFromMailboxEvents(mailboxEvents){var protoExpectations=[];var currentPE=undefined;for(var event of mailboxEvents){if(currentPE===undefined||!currentPE.isNear(event,ANIMATION_MERGE_THRESHOLD_MS)){currentPE=new ProtoExpectation(ProtoExpectation.ANIMATION_TYPE,WEBGL_IR_NAME);currentPE.pushEvent(event);protoExpectations.push(currentPE);}else{currentPE.pushEvent(event);}}return protoExpectations;}function handleWebGLAnimations(modelHelper,sortedInputEvents){var prepareMailboxEvents=[];var scriptedAnimationEvents=[];findWebGLEvents(modelHelper,prepareMailboxEvents,scriptedAnimationEvents);var webGLMailboxEvents=findMailboxEventsNearAnimationEvents(prepareMailboxEvents,scriptedAnimationEvents);return createProtoExpectationsFromMailboxEvents(webGLMailboxEvents);}function postProcessProtoExpectations(modelHelper,protoExpectations){protoExpectations=findFrameEventsForAnimations(modelHelper,protoExpectations);protoExpectations=mergeIntersectingResponses(protoExpectations);protoExpectations=mergeIntersectingAnimations(protoExpectations);protoExpectations=fixResponseAnimationStarts(protoExpectations);protoExpectations=fixTapResponseTouchAnimations(protoExpectations);return protoExpectations;}function mergeIntersectingResponses(protoExpectations){var newPEs=[];while(protoExpectations.length){var pe=protoExpectations.shift();newPEs.push(pe);if(pe.irType!==ProtoExpectation.RESPONSE_TYPE)continue;for(var i=0;i<protoExpectations.length;++i){var otherPE=protoExpectations[i];if(otherPE.irType!==pe.irType)continue;if(!otherPE.intersects(pe))continue;var typeNames=pe.associatedEvents.map(function(event){return event.typeName;});if(otherPE.containsTypeNames(typeNames))continue;pe.merge(otherPE);protoExpectations.splice(i,1);--i;}}return newPEs;}function mergeIntersectingAnimations(protoExpectations){var newPEs=[];while(protoExpectations.length){var pe=protoExpectations.shift();newPEs.push(pe);if(pe.irType!==ProtoExpectation.ANIMATION_TYPE)continue;var isCSS=pe.containsSliceTitle(CSS_ANIMATION_TITLE);var isFling=pe.containsTypeNames([INPUT_TYPE.FLING_START]);var isVideo=pe.containsTypeNames([VIDEO_IR_NAME]);for(var i=0;i<protoExpectations.length;++i){var otherPE=protoExpectations[i];if(otherPE.irType!==pe.irType)continue;if(isCSS!=otherPE.containsSliceTitle(CSS_ANIMATION_TITLE))continue;if(isCSS){if(!pe.isNear(otherPE,ANIMATION_MERGE_THRESHOLD_MS))continue;}else if(!otherPE.intersects(pe)){continue;}if(isFling!==otherPE.containsTypeNames([INPUT_TYPE.FLING_START]))continue;if(isVideo!==otherPE.containsTypeNames([VIDEO_IR_NAME]))continue;pe.merge(otherPE);protoExpectations.splice(i,1);--i;}}return newPEs;}function fixResponseAnimationStarts(protoExpectations){protoExpectations.forEach(function(ape){if(ape.irType!==ProtoExpectation.ANIMATION_TYPE)return;protoExpectations.forEach(function(rpe){if(rpe.irType!==ProtoExpectation.RESPONSE_TYPE)return;if(!ape.containsTimestampInclusive(rpe.end))return;if(ape.containsTimestampInclusive(rpe.start))return;ape.start=rpe.end;});});return protoExpectations;}function fixTapResponseTouchAnimations(protoExpectations){function isTapResponse(pe){return pe.irType===ProtoExpectation.RESPONSE_TYPE&&pe.containsTypeNames([INPUT_TYPE.TAP]);}function isTouchAnimation(pe){return pe.irType===ProtoExpectation.ANIMATION_TYPE&&pe.containsTypeNames([INPUT_TYPE.TOUCH_MOVE])&&!pe.containsTypeNames([INPUT_TYPE.SCROLL_UPDATE,INPUT_TYPE.PINCH_UPDATE]);}var newPEs=[];while(protoExpectations.length){var pe=protoExpectations.shift();newPEs.push(pe);var peIsTapResponse=isTapResponse(pe);var peIsTouchAnimation=isTouchAnimation(pe);if(!peIsTapResponse&&!peIsTouchAnimation)continue;for(var i=0;i<protoExpectations.length;++i){var otherPE=protoExpectations[i];if(!otherPE.intersects(pe))continue;if(peIsTapResponse&&!isTouchAnimation(otherPE))continue;if(peIsTouchAnimation&&!isTapResponse(otherPE))continue;pe.irType=ProtoExpectation.RESPONSE_TYPE;pe.merge(otherPE);protoExpectations.splice(i,1);--i;}}return newPEs;}function findFrameEventsForAnimations(modelHelper,protoExpectations){var newPEs=[];var frameEventsByPid=getSortedFrameEventsByProcess(modelHelper);for(var pe of protoExpectations){if(pe.irType!==ProtoExpectation.ANIMATION_TYPE){newPEs.push(pe);continue;}var frameEvents=[];for(var pid of Object.keys(modelHelper.rendererHelpers)){var range=tr.b.Range.fromExplicitRange(pe.start,pe.end);frameEvents.push.apply(frameEvents,range.filterArray(frameEventsByPid[pid],e=>e.start));}if(frameEvents.length===0&&!pe.names.has(WEBGL_IR_NAME)){pe.irType=ProtoExpectation.IGNORED_TYPE;newPEs.push(pe);continue;}pe.associatedEvents.addEventSet(frameEvents);newPEs.push(pe);}return newPEs;}function checkAllInputEventsHandled(sortedInputEvents,protoExpectations){var handledEvents=[];protoExpectations.forEach(function(protoExpectation){protoExpectation.associatedEvents.forEach(function(event){if(event.title===CSS_ANIMATION_TITLE&&event.subSlices.length>0)return;if(handledEvents.indexOf(event)>=0&&event.title!==tr.model.helpers.IMPL_RENDERING_STATS){console.assert(true,'double-handled event',event.typeName,parseInt(event.start),parseInt(event.end),protoExpectation);return;}handledEvents.push(event);});});sortedInputEvents.forEach(function(event){if(handledEvents.indexOf(event)<0){console.assert(true,'UNHANDLED INPUT EVENT!',event.typeName,parseInt(event.start),parseInt(event.end));}});}function findInputExpectations(modelHelper){var sortedInputEvents=getSortedInputEvents(modelHelper);var protoExpectations=findProtoExpectations(modelHelper,sortedInputEvents);protoExpectations=postProcessProtoExpectations(modelHelper,protoExpectations);checkAllInputEventsHandled(sortedInputEvents,protoExpectations);var irs=[];protoExpectations.forEach(function(protoExpectation){var ir=protoExpectation.createInteractionRecord(modelHelper.model);if(ir)irs.push(ir);});return irs;}return{findInputExpectations:findInputExpectations,compareEvents:compareEvents,CSS_ANIMATION_TITLE:CSS_ANIMATION_TITLE};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../base/range_utils.js":53,"../extras/chrome/cc/input_latency_async_slice.js":67,"./proto_expectation.js":82}],78:[function(require,module,exports){(function(global){"use strict";require("../model/user_model/load_expectation.js");'use strict';global.tr.exportTo('tr.importer',function(){var NAVIGATION_START='NavigationTiming navigationStart';var FIRST_CONTENTFUL_PAINT_TITLE='firstContentfulPaint';function findLoadExpectations(modelHelper){var events=[];for(var event of modelHelper.model.getDescendantEvents()){if(event.title===NAVIGATION_START||event.title===FIRST_CONTENTFUL_PAINT_TITLE)events.push(event);}events.sort(tr.importer.compareEvents);var loads=[];var startEvent=undefined;for(var event of events){if(event.title===NAVIGATION_START){startEvent=event;}else if(event.title===FIRST_CONTENTFUL_PAINT_TITLE){if(startEvent){loads.push(new tr.model.um.LoadExpectation(modelHelper.model,tr.model.um.LOAD_SUBTYPE_NAMES.SUCCESSFUL,startEvent.start,event.start-startEvent.start));startEvent=undefined;}}}if(startEvent){loads.push(new tr.model.um.LoadExpectation(modelHelper.model,tr.model.um.LOAD_SUBTYPE_NAMES.SUCCESSFUL,startEvent.start,modelHelper.model.bounds.max-startEvent.start));}return loads;}return{findLoadExpectations:findLoadExpectations};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../model/user_model/load_expectation.js":168}],79:[function(require,module,exports){(function(global){"use strict";require("../model/user_model/startup_expectation.js");'use strict';global.tr.exportTo('tr.importer',function(){function getAllFrameEvents(modelHelper){var frameEvents=[];frameEvents.push.apply(frameEvents,modelHelper.browserHelper.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE,modelHelper.model.bounds));tr.b.iterItems(modelHelper.rendererHelpers,function(pid,renderer){frameEvents.push.apply(frameEvents,renderer.getFrameEventsInRange(tr.model.helpers.IMPL_FRAMETIME_TYPE,modelHelper.model.bounds));});return frameEvents.sort(tr.importer.compareEvents);}function getStartupEvents(modelHelper){function isStartupSlice(slice){return slice.title==='BrowserMainLoop::CreateThreads';}var events=modelHelper.browserHelper.getAllAsyncSlicesMatching(isStartupSlice);var deduper=new tr.model.EventSet();events.forEach(function(event){var sliceGroup=event.parentContainer.sliceGroup;var slice=sliceGroup&&sliceGroup.findFirstSlice();if(slice)deduper.push(slice);});return deduper.toArray();}function findStartupExpectations(modelHelper){var openingEvents=getStartupEvents(modelHelper);var closingEvents=getAllFrameEvents(modelHelper);var startups=[];openingEvents.forEach(function(openingEvent){closingEvents.forEach(function(closingEvent){if(openingEvent.closingEvent)return;if(closingEvent.openingEvent)return;if(closingEvent.start<=openingEvent.start)return;if(openingEvent.parentContainer.parent.pid!==closingEvent.parentContainer.parent.pid)return;openingEvent.closingEvent=closingEvent;closingEvent.openingEvent=openingEvent;var se=new tr.model.um.StartupExpectation(modelHelper.model,openingEvent.start,closingEvent.end-openingEvent.start);se.associatedEvents.push(openingEvent);se.associatedEvents.push(closingEvent);startups.push(se);});});return startups;}return{findStartupExpectations:findStartupExpectations};});}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../model/user_model/startup_expectation.js":170}],80:[function(require,module,exports){(function(global){"use strict";require("../base/base.js");require("../base/timing.js");require("./empty_importer.js");require("./importer.js");require("./user_model_builder.js");require("../ui/base/overlay.js");'use strict';global.tr.exportTo('tr.importer',function(){var Timing=tr.b.Timing;function ImportOptions(){this.shiftWorldToZero=true;this.pruneEmptyContainers=true;this.showImportWarnings=true;this.trackDetailedModelStats=false;this.customizeModelCallback=undefined;var auditorTypes=tr.c.Auditor.getAllRegisteredTypeInfos();this.auditorConstructors=auditorTypes.map(function(typeInfo){return typeInfo.constructor;});}function Import(model,opt_options){if(model===undefined)throw new Error('Must provide model to import into.');this.importing_=false;this.importOptions_=opt_options||new ImportOptions();this.model_=model;this.model_.importOptions=this.importOptions_;}Import.prototype={__proto__:Object.prototype,importTraces:function(traces){var progressMeter={update:function(msg){}};tr.b.Task.RunSynchronously(this.createImportTracesTask(progressMeter,traces));},importTracesWithProgressDialog:f