'use strict';const ELLIPSIS='\u2026';const NBSP='\xa0';const RATINGS={PASS:{label:'pass',minScore:75},AVERAGE:{label:'average',minScore:45},FAIL:{label:'fail'}};class Util{static calculateRating(score){let rating=RATINGS.FAIL.label;if(score>=RATINGS.PASS.minScore){rating=RATINGS.PASS.label;}else if(score>=RATINGS.AVERAGE.minScore){rating=RATINGS.AVERAGE.label;}
return rating;}
static formatNumber(number,decimalPlaces=1){return number.toLocaleString(undefined,{maximumFractionDigits:decimalPlaces});}
static formatBytesToKB(size,decimalPlaces=2){const kbs=(size/1024).toLocaleString(undefined,{maximumFractionDigits:decimalPlaces});return`${kbs}${NBSP}KB`;}
static formatMilliseconds(ms,granularity=10){const coarseTime=Math.round(ms/granularity)*granularity;return`${coarseTime.toLocaleString()}${NBSP}ms`;}
static formatDateTime(date){const options={month:'short',day:'numeric',year:'numeric',hour:'numeric',minute:'numeric',timeZoneName:'short'};let formatter=new Intl.DateTimeFormat('en-US',options);const tz=formatter.resolvedOptions().timeZone;if(!tz||tz.toLowerCase()==='etc/unknown'){options.timeZone='UTC';formatter=new Intl.DateTimeFormat('en-US',options);}
return formatter.format(new Date(date));}
static getURLDisplayName(parsedUrl,options={}){const numPathParts=options.numPathParts!==undefined?options.numPathParts:2;const preserveQuery=options.preserveQuery!==undefined?options.preserveQuery:true;const preserveHost=options.preserveHost||false;let name;if(parsedUrl.protocol==='about:'||parsedUrl.protocol==='data:'){name=parsedUrl.href;}else{name=parsedUrl.pathname;const parts=name.split('/').filter(part=>part.length);if(numPathParts&&parts.length>numPathParts){name=ELLIPSIS+parts.slice(-1*numPathParts).join('/');}
if(preserveHost){name=`${parsedUrl.host}/${name.replace(/^\//, '')}`;}
if(preserveQuery){name=`${name}${parsedUrl.search}`;}}
const MAX_LENGTH=64;name=name.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${ELLIPSIS}`);if(name.length>MAX_LENGTH&&name.includes('?')){name=name.replace(/\?([^=]*)(=)?.*/,`?$1$2${ELLIPSIS}`);if(name.length>MAX_LENGTH){name=name.replace(/\?.*/,`?${ELLIPSIS}`);}}
if(name.length>MAX_LENGTH){const dotIndex=name.lastIndexOf('.');if(dotIndex>=0){name=name.slice(0,MAX_LENGTH-1-(name.length-dotIndex))+`${ELLIPSIS}${name.slice(dotIndex)}`;}else{name=name.slice(0,MAX_LENGTH-1)+ELLIPSIS;}}
return name;}
static parseURL(url){const parsedUrl=new URL(url);return{file:Util.getURLDisplayName(parsedUrl),hostname:parsedUrl.hostname};}
static chainDuration(startTime,endTime){return Util.formatNumber((endTime-startTime)*1000);}}
if(typeof module!=='undefined'&&module.exports){module.exports=Util;}else{self.Util=Util;};'use strict';class DOM{constructor(document){this._document=document;}
createElement(name,className,attrs={}){const element=this._document.createElement(name);if(className){element.className=className;}
Object.keys(attrs).forEach(key=>{const value=attrs[key];if(typeof value!=='undefined'){element.setAttribute(key,value);}});return element;}
createChildOf(parentElem,elementName,className,attrs){const element=this.createElement(elementName,className,attrs);parentElem.appendChild(element);return element;}
cloneTemplate(selector,context){const template=(context.querySelector(selector));if(!template){throw new Error(`Template not found: template${selector}`);}
const clone=(this._document.importNode(template.content,true));if(template.hasAttribute('data-stamped')){this.findAll('style',clone).forEach(style=>style.remove());}
template.setAttribute('data-stamped',true);return clone;}
resetTemplates(){this.findAll('template[data-stamped]',this._document).forEach(t=>{t.removeAttribute('data-stamped');});}
convertMarkdownLinkSnippets(text){const element=this.createElement('span');const parts=text.split(/\[(.*?)\]\((https?:\/\/.*?)\)/g);while(parts.length){const[preambleText,linkText,linkHref]=parts.splice(0,3);element.appendChild(this._document.createTextNode(preambleText));if(linkText&&linkHref){const a=(this.createElement('a'));a.rel='noopener';a.target='_blank';a.textContent=linkText;a.href=(new URL(linkHref)).href;element.appendChild(a);}}
return element;}
convertMarkdownCodeSnippets(text){const element=this.createElement('span');const parts=text.split(/`(.*?)`/g);while(parts.length){const[preambleText,codeText]=parts.splice(0,2);element.appendChild(this._document.createTextNode(preambleText));if(codeText){const pre=(this.createElement('code'));pre.textContent=codeText;element.appendChild(pre);}}
return element;}
document(){return this._document;}
find(query,context){const result=context.querySelector(query);if(result===null){throw new Error(`query ${query} not found`);}
return result;}
findAll(query,context){return Array.from(context.querySelectorAll(query));}}
if(typeof module!=='undefined'&&module.exports){module.exports=DOM;}else{self.DOM=DOM;};'use strict';class CategoryRenderer{constructor(dom,detailsRenderer){this._dom=dom;this._detailsRenderer=detailsRenderer;this._templateContext=this._dom.document();this._detailsRenderer.setTemplateContext(this._templateContext);}
_renderAuditScore(audit){const tmpl=this._dom.cloneTemplate('#tmpl-lh-audit-score',this._templateContext);const scoringMode=audit.result.scoringMode;const description=audit.result.helpText;let title=audit.result.description;if(audit.result.displayValue){title+=`:  ${audit.result.displayValue}`;}
if(audit.result.optimalValue){title+=` (target: ${audit.result.optimalValue})`;}
if(audit.result.debugString){const debugStrEl=tmpl.appendChild(this._dom.createElement('div','lh-debug'));debugStrEl.textContent=audit.result.debugString;}
const header=(this._dom.find('.lh-score__header',tmpl));if(audit.result.details){header.appendChild(this._detailsRenderer.render(audit.result.details));}
const scoreEl=this._dom.find('.lh-score',tmpl);if(audit.result.informative){scoreEl.classList.add('lh-score--informative');}
if(audit.result.manual){scoreEl.classList.add('lh-score--manual');}
return this._populateScore(tmpl,audit.score,scoringMode,title,description);}
_populateScore(element,score,scoringMode,title,description){const valueEl=this._dom.find('.lh-score__value',element);valueEl.textContent=Util.formatNumber(score);valueEl.classList.add(`lh-score__value--${Util.calculateRating(score)}`,`lh-score__value--${scoringMode}`);this._dom.find('.lh-score__title',element).appendChild(this._dom.convertMarkdownCodeSnippets(title));this._dom.find('.lh-score__description',element).appendChild(this._dom.convertMarkdownLinkSnippets(description));return(element);}
_renderCategoryScore(category){const tmpl=this._dom.cloneTemplate('#tmpl-lh-category-score',this._templateContext);const score=Math.round(category.score);const gaugeContainerEl=this._dom.find('.lh-score__gauge',tmpl);const gaugeEl=this.renderScoreGauge(category);gaugeContainerEl.appendChild(gaugeEl);return this._populateScore(tmpl,score,'numeric',category.name,category.description);}
_renderAudit(audit){const element=this._dom.createElement('div','lh-audit');element.appendChild(this._renderAuditScore(audit));return element;}
_renderTimelineMetricAudit(audit,scale){const tmpl=this._dom.cloneTemplate('#tmpl-lh-timeline-metric',this._templateContext);const element=this._dom.find('.lh-timeline-metric',tmpl);element.classList.add(`lh-timeline-metric--${Util.calculateRating(audit.score)}`);const titleEl=this._dom.find('.lh-timeline-metric__title',tmpl);titleEl.textContent=audit.result.description;const valueEl=this._dom.find('.lh-timeline-metric__value',tmpl);valueEl.textContent=audit.result.displayValue;const descriptionEl=this._dom.find('.lh-timeline-metric__description',tmpl);descriptionEl.appendChild(this._dom.convertMarkdownLinkSnippets(audit.result.helpText));if(typeof audit.result.rawValue!=='number'){const debugStrEl=this._dom.createChildOf(element,'div','lh-debug');debugStrEl.textContent=audit.result.debugString||'Report error: no metric information';return element;}
const sparklineBarEl=this._dom.find('.lh-sparkline__bar',tmpl);sparklineBarEl.style.width=`${audit.result.rawValue / scale * 100}%`;return element;}
_renderPerfHintAudit(audit,scale){const extendedInfo=(audit.result.extendedInfo);const tooltipAttrs={title:audit.result.displayValue};const element=this._dom.createElement('details',['lh-perf-hint',`lh-perf-hint--${Util.calculateRating(audit.score)}`,'lh-expandable-details',].join(' '));const summary=this._dom.createChildOf(element,'summary','lh-perf-hint__summary '+'lh-expandable-details__summary');const titleEl=this._dom.createChildOf(summary,'div','lh-perf-hint__title');titleEl.textContent=audit.result.description;this._dom.createChildOf(summary,'div','lh-toggle-arrow',{title:'See resources'});if(!extendedInfo||typeof audit.result.rawValue!=='number'){const debugStrEl=this._dom.createChildOf(summary,'div','lh-debug');debugStrEl.textContent=audit.result.debugString||'Report error: no extended information';return element;}
const sparklineContainerEl=this._dom.createChildOf(summary,'div','lh-perf-hint__sparkline',tooltipAttrs);const sparklineEl=this._dom.createChildOf(sparklineContainerEl,'div','lh-sparkline');const sparklineBarEl=this._dom.createChildOf(sparklineEl,'div','lh-sparkline__bar');sparklineBarEl.style.width=audit.result.rawValue/scale*100+'%';const statsEl=this._dom.createChildOf(summary,'div','lh-perf-hint__stats',tooltipAttrs);const statsMsEl=this._dom.createChildOf(statsEl,'div','lh-perf-hint__primary-stat');statsMsEl.textContent=Util.formatMilliseconds(audit.result.rawValue);if(extendedInfo.value.wastedKb){const statsKbEl=this._dom.createChildOf(statsEl,'div','lh-perf-hint__secondary-stat');statsKbEl.textContent=Util.formatNumber(extendedInfo.value.wastedKb)+' KB';}
const descriptionEl=this._dom.createChildOf(element,'div','lh-perf-hint__description');descriptionEl.appendChild(this._dom.convertMarkdownLinkSnippets(audit.result.helpText));if(audit.result.debugString){const debugStrEl=this._dom.createChildOf(summary,'div','lh-debug');debugStrEl.textContent=audit.result.debugString;}
if(audit.result.details){element.appendChild(this._detailsRenderer.render(audit.result.details));}
return element;}
_renderAuditGroup(group,opts){const expandable=opts.expandable;const element=this._dom.createElement(expandable?'details':'div','lh-audit-group');const summmaryEl=this._dom.createChildOf(element,'summary','lh-audit-group__summary');const headerEl=this._dom.createChildOf(summmaryEl,'div','lh-audit-group__header');this._dom.createChildOf(summmaryEl,'div',`lh-toggle-arrow  ${expandable ? '' : ' lh-toggle-arrow-unexpandable'}`,{title:'See audits',});if(group.description){const auditGroupDescription=this._dom.createElement('div','lh-audit-group__description');auditGroupDescription.appendChild(this._dom.convertMarkdownLinkSnippets(group.description));element.appendChild(auditGroupDescription);}
headerEl.textContent=group.title;return element;}
_renderPassedAuditsSection(elements){const passedElem=this._renderAuditGroup({title:`${elements.length} Passed Audits`,},{expandable:true});passedElem.classList.add('lh-passed-audits');elements.forEach(elem=>passedElem.appendChild(elem));return passedElem;}
_renderManualAudits(manualAudits,groupDefinitions,element){const auditsGroupedByGroup=({});manualAudits.forEach(audit=>{const group=auditsGroupedByGroup[audit.group]||[];group.push(audit);auditsGroupedByGroup[audit.group]=group;});Object.keys(auditsGroupedByGroup).forEach(groupId=>{const group=groupDefinitions[groupId];const auditGroupElem=this._renderAuditGroup(group,{expandable:true});auditGroupElem.classList.add('lh-audit-group--manual');auditsGroupedByGroup[groupId].forEach(audit=>{auditGroupElem.appendChild(this._renderAudit(audit));});element.appendChild(auditGroupElem);});}
setTemplateContext(context){this._templateContext=context;this._detailsRenderer.setTemplateContext(context);}
renderScoreGauge(category){const tmpl=this._dom.cloneTemplate('#tmpl-lh-gauge',this._templateContext);this._dom.find('.lh-gauge__wrapper',tmpl).href=`#${category.id}`;this._dom.find('.lh-gauge__label',tmpl).textContent=category.name;const score=Math.round(category.score);const fillRotation=Math.floor((score/100)*180);const gauge=this._dom.find('.lh-gauge',tmpl);gauge.setAttribute('data-progress',score);gauge.classList.add(`lh-gauge--${Util.calculateRating(score)}`);this._dom.findAll('.lh-gauge__fill',gauge).forEach(el=>{el.style.transform=`rotate(${fillRotation}deg)`;});this._dom.find('.lh-gauge__mask--full',gauge).style.transform=`rotate(${fillRotation}deg)`;this._dom.find('.lh-gauge__fill--fix',gauge).style.transform=`rotate(${fillRotation * 2}deg)`;this._dom.find('.lh-gauge__percentage',gauge).textContent=score;return tmpl;}
render(category,groups){switch(category.id){case'performance':return this._renderPerformanceCategory(category,groups);case'accessibility':return this._renderAccessibilityCategory(category,groups);default:return this._renderDefaultCategory(category,groups);}}
_renderDefaultCategory(category,groupDefinitions){const element=this._dom.createElement('div','lh-category');this._createPermalinkSpan(element,category.id);element.appendChild(this._renderCategoryScore(category));const manualAudits=category.audits.filter(audit=>audit.result.manual);const nonManualAudits=category.audits.filter(audit=>!manualAudits.includes(audit));const passedAudits=nonManualAudits.filter(audit=>audit.score===100&&!audit.result.debugString);const nonPassedAudits=nonManualAudits.filter(audit=>!passedAudits.includes(audit));const nonPassedElem=this._renderAuditGroup({title:`${nonPassedAudits.length} failed audits`,},{expandable:false});nonPassedElem.classList.add('lh-failed-audits');nonPassedAudits.forEach(audit=>nonPassedElem.appendChild(this._renderAudit(audit)));element.appendChild(nonPassedElem);if(passedAudits.length){const passedElem=this._renderPassedAuditsSection(passedAudits.map(audit=>this._renderAudit(audit)));element.appendChild(passedElem);}
this._renderManualAudits(manualAudits,groupDefinitions,element);return element;}
_renderPerformanceCategory(category,groups){const element=this._dom.createElement('div','lh-category');this._createPermalinkSpan(element,category.id);element.appendChild(this._renderCategoryScore(category));const metricAudits=category.audits.filter(audit=>audit.group==='perf-metric');const metricAuditsEl=this._renderAuditGroup(groups['perf-metric'],{expandable:false});const timelineContainerEl=this._dom.createChildOf(metricAuditsEl,'div','lh-timeline-container');const timelineEl=this._dom.createChildOf(timelineContainerEl,'div','lh-timeline');let perfTimelineScale=0;metricAudits.forEach(audit=>{if(typeof audit.result.rawValue==='number'&&audit.result.rawValue){perfTimelineScale=Math.max(perfTimelineScale,audit.result.rawValue);}});const thumbnailAudit=category.audits.find(audit=>audit.id==='screenshot-thumbnails');const thumbnailResult=thumbnailAudit&&thumbnailAudit.result;if(thumbnailResult&&thumbnailResult.details){const thumbnailDetails=(thumbnailResult.details);perfTimelineScale=Math.max(perfTimelineScale,thumbnailDetails.scale);const filmstripEl=this._detailsRenderer.render(thumbnailDetails);timelineEl.appendChild(filmstripEl);}
metricAudits.forEach(item=>{if(item.id==='speed-index-metric'||item.id==='estimated-input-latency'){return metricAuditsEl.appendChild(this._renderAudit(item));}
timelineEl.appendChild(this._renderTimelineMetricAudit(item,perfTimelineScale));});metricAuditsEl.open=true;element.appendChild(metricAuditsEl);const hintAudits=category.audits.filter(audit=>audit.group==='perf-hint'&&audit.score<100).sort((auditA,auditB)=>auditB.result.rawValue-auditA.result.rawValue);if(hintAudits.length){const maxWaste=Math.max(...hintAudits.map(audit=>audit.result.rawValue));const scale=Math.ceil(maxWaste/1000)*1000;const hintAuditsEl=this._renderAuditGroup(groups['perf-hint'],{expandable:false});hintAudits.forEach(item=>hintAuditsEl.appendChild(this._renderPerfHintAudit(item,scale)));hintAuditsEl.open=true;element.appendChild(hintAuditsEl);}
const infoAudits=category.audits.filter(audit=>audit.group==='perf-info'&&audit.score<100);if(infoAudits.length){const infoAuditsEl=this._renderAuditGroup(groups['perf-info'],{expandable:false});infoAudits.forEach(item=>infoAuditsEl.appendChild(this._renderAudit(item)));infoAuditsEl.open=true;element.appendChild(infoAuditsEl);}
const passedElements=category.audits.filter(audit=>(audit.group==='perf-hint'||audit.group==='perf-info')&&audit.score===100).map(audit=>this._renderAudit(audit));if(!passedElements.length)return element;const passedElem=this._renderPassedAuditsSection(passedElements);element.appendChild(passedElem);return element;}
_renderAccessibilityCategory(category,groupDefinitions){const element=this._dom.createElement('div','lh-category');this._createPermalinkSpan(element,category.id);element.appendChild(this._renderCategoryScore(category));const auditsGroupedByGroup=({});category.audits.forEach(audit=>{const groupId=audit.group;const groups=auditsGroupedByGroup[groupId]||{passed:[],failed:[]};if(audit.score===100){groups.passed.push(audit);}else{groups.failed.push(audit);}
auditsGroupedByGroup[groupId]=groups;});const passedElements=([]);Object.keys(auditsGroupedByGroup).forEach(groupId=>{const group=groupDefinitions[groupId];const groups=auditsGroupedByGroup[groupId];if(groups.failed.length){const auditGroupElem=this._renderAuditGroup(group,{expandable:false});groups.failed.forEach(item=>auditGroupElem.appendChild(this._renderAudit(item)));auditGroupElem.open=true;element.appendChild(auditGroupElem);}
if(groups.passed.length){const auditGroupElem=this._renderAuditGroup(group,{expandable:true});groups.passed.forEach(item=>auditGroupElem.appendChild(this._renderAudit(item)));passedElements.push(auditGroupElem);}});if(!passedElements.length)return element;const passedElem=this._renderPassedAuditsSection(passedElements);element.appendChild(passedElem);return element;}
_createPermalinkSpan(element,id){const permalinkEl=this._dom.createChildOf(element,'span','lh-permalink');permalinkEl.id=id;}}
if(typeof module!=='undefined'&&module.exports){module.exports=CategoryRenderer;}else{self.CategoryRenderer=CategoryRenderer;}
CategoryRenderer.PerfHintExtendedInfo;;'use strict';class DetailsRenderer{constructor(dom){this._dom=dom;this._templateContext;}
setTemplateContext(context){this._templateContext=context;}
render(details){switch(details.type){case'text':return this._renderText(details);case'url':return this._renderURL(details);case'thumbnail':return this._renderThumbnail((details));case'filmstrip':return this._renderFilmstrip((details));case'cards':return this._renderCards((details));case'table':return this._renderTable((details));case'code':return this._renderCode(details);case'node':return this.renderNode((details));case'criticalrequestchain':return CriticalRequestChainRenderer.render(this._dom,this._templateContext,(details));case'list':return this._renderList((details));default:throw new Error(`Unknown type: ${details.type}`);}}
_renderURL(text){const url=text.text||'';let displayedURL;let title;try{displayedURL=Util.parseURL(url).file;title=url;}catch(e){if(!(e instanceof TypeError)){throw e;}
displayedURL=url;}
const element=this._renderText({type:'url',text:displayedURL});element.classList.add('lh-text__url');if(title){element.title=url;}
return element;}
_renderText(text){const element=this._dom.createElement('div','lh-text');element.textContent=text.text;return element;}
_renderThumbnail(value){if(/^image/.test(value.mimeType)===false){return this._dom.createElement('span');}
const element=this._dom.createElement('img','lh-thumbnail');element.src=value.url;element.alt='';element.title=value.url;return element;}
_renderList(list){if(!list.items.length)return this._dom.createElement('span');const element=this._dom.createElement('details','lh-details');element.open=true;if(list.header){const summary=this._dom.createElement('summary','lh-list__header');summary.textContent=list.header.text;element.appendChild(summary);}
const itemsElem=this._dom.createChildOf(element,'div','lh-list__items');for(const item of list.items){const itemElem=this._dom.createChildOf(itemsElem,'span','lh-list__item');itemElem.appendChild(this.render(item));}
return element;}
_renderTable(details){if(!details.items.length)return this._dom.createElement('span');const element=this._dom.createElement('details','lh-details');element.open=true;if(details.header){element.appendChild(this._dom.createElement('summary')).textContent=details.header;}
const tableElem=this._dom.createChildOf(element,'table','lh-table');const theadElem=this._dom.createChildOf(tableElem,'thead');const theadTrElem=this._dom.createChildOf(theadElem,'tr');for(const heading of details.itemHeaders){const itemType=heading.itemType||'text';const classes=`lh-table-column--${itemType}`;this._dom.createChildOf(theadTrElem,'th',classes).appendChild(this.render(heading));}
const tbodyElem=this._dom.createChildOf(tableElem,'tbody');for(const row of details.items){const rowElem=this._dom.createChildOf(tbodyElem,'tr');for(const columnItem of row){const classes=`lh-table-column--${columnItem.type}`;this._dom.createChildOf(rowElem,'td',classes).appendChild(this.render(columnItem));}}
return element;}
renderNode(item){const element=this._dom.createElement('span','lh-node');element.textContent=item.snippet;element.title=item.selector;if(item.text)element.setAttribute('data-text',item.text);if(item.path)element.setAttribute('data-path',item.path);if(item.selector)element.setAttribute('data-selector',item.selector);if(item.snippet)element.setAttribute('data-snippet',item.snippet);return element;}
_renderCards(details){const element=this._dom.createElement('details','lh-details');element.open=true;if(details.header){element.appendChild(this._dom.createElement('summary')).textContent=details.header.text;}
const cardsParent=this._dom.createElement('div','lh-scorecards');for(const item of details.items){const card=cardsParent.appendChild(this._dom.createElement('div','lh-scorecard',{title:item.snippet}));const titleEl=this._dom.createElement('div','lh-scorecard__title');const valueEl=this._dom.createElement('div','lh-scorecard__value');const targetEl=this._dom.createElement('div','lh-scorecard__target');card.appendChild(titleEl).textContent=item.title;card.appendChild(valueEl).textContent=item.value;if(item.target){card.appendChild(targetEl).textContent=`target: ${item.target}`;}}
element.appendChild(cardsParent);return element;}
_renderFilmstrip(details){const filmstripEl=this._dom.createElement('div','lh-filmstrip');for(const thumbnail of details.items){const frameEl=this._dom.createChildOf(filmstripEl,'div','lh-filmstrip__frame');let timing=Util.formatMilliseconds(thumbnail.timing,1);if(thumbnail.timing>1000){timing=Util.formatNumber(thumbnail.timing/1000)+' s';}
const timingEl=this._dom.createChildOf(frameEl,'div','lh-filmstrip__timestamp');timingEl.textContent=timing;const base64data=thumbnail.data;this._dom.createChildOf(frameEl,'img','lh-filmstrip__thumbnail',{src:`data:image/jpeg;base64,${base64data}`,alt:`Screenshot at ${timing}`,});}
return filmstripEl;}
_renderCode(details){const pre=this._dom.createElement('pre','lh-code');pre.textContent=details.text;return pre;}}
if(typeof module!=='undefined'&&module.exports){module.exports=DetailsRenderer;}else{self.DetailsRenderer=DetailsRenderer;}
DetailsRenderer.DetailsJSON;DetailsRenderer.ListDetailsJSON;DetailsRenderer.NodeDetailsJSON;DetailsRenderer.CardsDetailsJSON;DetailsRenderer.TableHeaderJSON;DetailsRenderer.NodeDetailsJSON;DetailsRenderer.TableDetailsJSON;DetailsRenderer.ThumbnailDetails;DetailsRenderer.FilmstripDetails;;'use strict';class CriticalRequestChainRenderer{static initTree(tree){let startTime=0;const rootNodes=Object.keys(tree);if(rootNodes.length>0){const node=tree[rootNodes[0]];startTime=node.request.startTime;}
return{tree,startTime,transferSize:0};}
static createSegment(parent,id,startTime,transferSize,treeMarkers,parentIsLastChild){const node=parent[id];const siblings=Object.keys(parent);const isLastChild=siblings.indexOf(id)===(siblings.length-1);const hasChildren=Object.keys(node.children).length>0;const newTreeMarkers=Array.isArray(treeMarkers)?treeMarkers.slice(0):[];if(typeof parentIsLastChild!=='undefined'){newTreeMarkers.push(!parentIsLastChild);}
return{node,isLastChild,hasChildren,startTime,transferSize:transferSize+node.request.transferSize,treeMarkers:newTreeMarkers};}
static createChainNode(dom,tmpl,segment){const chainsEl=dom.cloneTemplate('#tmpl-lh-crc__chains',tmpl);dom.find('.crc-node',chainsEl).setAttribute('title',segment.node.request.url);const treeMarkeEl=dom.find('.crc-node__tree-marker',chainsEl);segment.treeMarkers.forEach(separator=>{if(separator){treeMarkeEl.appendChild(dom.createElement('span','tree-marker vert'));treeMarkeEl.appendChild(dom.createElement('span','tree-marker'));}else{treeMarkeEl.appendChild(dom.createElement('span','tree-marker'));treeMarkeEl.appendChild(dom.createElement('span','tree-marker'));}});if(segment.isLastChild){treeMarkeEl.appendChild(dom.createElement('span','tree-marker up-right'));treeMarkeEl.appendChild(dom.createElement('span','tree-marker right'));}else{treeMarkeEl.appendChild(dom.createElement('span','tree-marker vert-right'));treeMarkeEl.appendChild(dom.createElement('span','tree-marker right'));}
if(segment.hasChildren){treeMarkeEl.appendChild(dom.createElement('span','tree-marker horiz-down'));}else{treeMarkeEl.appendChild(dom.createElement('span','tree-marker right'));}
const{file,hostname}=Util.parseURL(segment.node.request.url);const treevalEl=dom.find('.crc-node__tree-value',chainsEl);dom.find('.crc-node__tree-file',treevalEl).textContent=`${file}`;dom.find('.crc-node__tree-hostname',treevalEl).textContent=`(${hostname})`;if(!segment.hasChildren){const span=dom.createElement('span','crc-node__chain-duration');span.textContent=' - '+Util.chainDuration(segment.node.request.startTime,segment.node.request.endTime)+'ms, ';const span2=dom.createElement('span','crc-node__chain-duration');span2.textContent=Util.formatBytesToKB(segment.node.request.transferSize);treevalEl.appendChild(span);treevalEl.appendChild(span2);}
return chainsEl;}
static buildTree(dom,tmpl,segment,detailsEl,details){detailsEl.appendChild(CriticalRequestChainRenderer.createChainNode(dom,tmpl,segment));for(const key of Object.keys(segment.node.children)){const childSegment=CriticalRequestChainRenderer.createSegment(segment.node.children,key,segment.startTime,segment.transferSize,segment.treeMarkers,segment.isLastChild);CriticalRequestChainRenderer.buildTree(dom,tmpl,childSegment,detailsEl,details);}}
static render(dom,templateContext,details){const tmpl=dom.cloneTemplate('#tmpl-lh-crc',templateContext);dom.find('.lh-crc__longest_duration',tmpl).textContent=Util.formatNumber(details.longestChain.duration)+'ms';dom.find('.lh-crc__longest_length',tmpl).textContent=details.longestChain.length;dom.find('.lh-crc__longest_transfersize',tmpl).textContent=Util.formatBytesToKB(details.longestChain.transferSize);const detailsEl=dom.find('.lh-details',tmpl);detailsEl.open=true;dom.find('.lh-details > summary',tmpl).textContent=details.header.text;const root=CriticalRequestChainRenderer.initTree(details.chains);for(const key of Object.keys(root.tree)){const segment=CriticalRequestChainRenderer.createSegment(root.tree,key,root.startTime,root.transferSize);CriticalRequestChainRenderer.buildTree(dom,tmpl,segment,detailsEl,details);}
return tmpl;}}
if(typeof module!=='undefined'&&module.exports){module.exports=CriticalRequestChainRenderer;}else{self.CriticalRequestChainRenderer=CriticalRequestChainRenderer;}
CriticalRequestChainRenderer.CRCDetailsJSON;CriticalRequestChainRenderer.CRCRequest;CriticalRequestChainRenderer.CRCNode=function(){};CriticalRequestChainRenderer.CRCNode.prototype.children;CriticalRequestChainRenderer.CRCNode.prototype.request;CriticalRequestChainRenderer.CRCSegment;;'use strict';class ReportRenderer{constructor(dom,categoryRenderer){this._dom=dom;this._categoryRenderer=categoryRenderer;this._templateContext=this._dom.document();}
renderReport(report,container){container.textContent='';const element=container.appendChild(this._renderReport(report));return(element);}
setTemplateContext(context){this._templateContext=context;this._categoryRenderer.setTemplateContext(context);}
_renderReportHeader(report){const header=this._dom.cloneTemplate('#tmpl-lh-heading',this._templateContext);this._dom.find('.lh-config__timestamp',header).textContent=Util.formatDateTime(report.generatedTime);const url=this._dom.find('.lh-metadata__url',header);url.href=report.url;url.textContent=report.url;this._dom.find('.lh-env__item__ua',header).textContent=report.userAgent;const env=this._dom.find('.lh-env__items',header);report.runtimeConfig.environment.forEach(runtime=>{const item=this._dom.cloneTemplate('#tmpl-lh-env__items',env);this._dom.find('.lh-env__name',item).textContent=runtime.name;this._dom.find('.lh-env__description',item).textContent=runtime.description;this._dom.find('.lh-env__enabled',item).textContent=runtime.enabled?'Enabled':'Disabled';env.appendChild(item);});return header;}
_renderReportFooter(report){const footer=this._dom.cloneTemplate('#tmpl-lh-footer',this._templateContext);this._dom.find('.lh-footer__version',footer).textContent=report.lighthouseVersion;this._dom.find('.lh-footer__timestamp',footer).textContent=Util.formatDateTime(report.generatedTime);return footer;}
_renderReportNav(report){const leftNav=this._dom.cloneTemplate('#tmpl-lh-leftnav',this._templateContext);this._dom.find('.leftnav__header__version',leftNav).textContent=`Version: ${report.lighthouseVersion}`;const nav=this._dom.find('.lh-leftnav',leftNav);for(const category of report.reportCategories){const itemsTmpl=this._dom.cloneTemplate('#tmpl-lh-leftnav__items',leftNav);const navItem=this._dom.find('.lh-leftnav__item',itemsTmpl);navItem.href=`#${category.id}`;this._dom.find('.leftnav-item__category',navItem).textContent=category.name;const score=this._dom.find('.leftnav-item__score',navItem);score.classList.add(`lh-score__value--${Util.calculateRating(category.score)}`);score.textContent=Math.round(category.score);nav.appendChild(navItem);}
return leftNav;}
_renderReport(report){const container=this._dom.createElement('div','lh-container');container.appendChild(this._renderReportHeader(report));container.appendChild(this._renderReportNav(report));const reportSection=container.appendChild(this._dom.createElement('div','lh-report'));let scoreHeader;const isSoloCategory=report.reportCategories.length===1;if(!isSoloCategory){scoreHeader=reportSection.appendChild(this._dom.createElement('div','lh-scores-header'));}
const categories=reportSection.appendChild(this._dom.createElement('div','lh-categories'));for(const category of report.reportCategories){if(scoreHeader){scoreHeader.appendChild(this._categoryRenderer.renderScoreGauge(category));}
categories.appendChild(this._categoryRenderer.render(category,report.reportGroups));}
reportSection.appendChild(this._renderReportFooter(report));return container;}}
if(typeof module!=='undefined'&&module.exports){module.exports=ReportRenderer;}else{self.ReportRenderer=ReportRenderer;}
ReportRenderer.AuditJSON;ReportRenderer.CategoryJSON;ReportRenderer.GroupJSON;ReportRenderer.ReportJSON;;Audits2.Audits2Panel=class extends UI.Panel{constructor(){super('audits2');this.registerRequiredCSS('audits2/lighthouse/report-styles.css');this.registerRequiredCSS('audits2/audits2Panel.css');this._protocolService=new Audits2.ProtocolService();this._protocolService.registerStatusCallback(msg=>this._updateStatus(Common.UIString(msg)));var toolbar=new UI.Toolbar('',this.element);var newButton=new UI.ToolbarButton(Common.UIString('New audit\u2026'),'largeicon-add');toolbar.appendToolbarItem(newButton);newButton.addEventListener(UI.ToolbarButton.Events.Click,this._showLauncherUI.bind(this));var downloadButton=new UI.ToolbarButton(Common.UIString('Download report'),'largeicon-download');toolbar.appendToolbarItem(downloadButton);downloadButton.addEventListener(UI.ToolbarButton.Events.Click,this._downloadSelected.bind(this));toolbar.appendSeparator();this._reportSelector=new Audits2.ReportSelector();toolbar.appendToolbarItem(this._reportSelector.comboBox());var clearButton=new UI.ToolbarButton(Common.UIString('Clear all'),'largeicon-clear');toolbar.appendToolbarItem(clearButton);clearButton.addEventListener(UI.ToolbarButton.Events.Click,this._clearAll.bind(this));this._auditResultsElement=this.contentElement.createChild('div','audits2-results-container');this._dropTarget=new UI.DropTarget(this.contentElement,[UI.DropTarget.Types.Files],Common.UIString('Drop audit file here'),this._handleDrop.bind(this));for(var preset of Audits2.Audits2Panel.Presets)
preset.setting.addChangeListener(this._updateStartButtonEnabled.bind(this));this._showLandingPage();SDK.targetManager.observeModels(SDK.ServiceWorkerManager,this);}
modelAdded(serviceWorkerManager){if(this._manager)
return;this._manager=serviceWorkerManager;this._serviceWorkerListeners=[this._manager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationUpdated,this._updateStartButtonEnabled,this),this._manager.addEventListener(SDK.ServiceWorkerManager.Events.RegistrationDeleted,this._updateStartButtonEnabled,this),];this._updateStartButtonEnabled();}
modelRemoved(serviceWorkerManager){if(!this._manager||this._manager!==serviceWorkerManager)
return;Common.EventTarget.removeEventListeners(this._serviceWorkerListeners);this._manager=null;this._serviceWorkerListeners=null;this._updateStartButtonEnabled();}
_hasActiveServiceWorker(){if(!this._manager)
return false;var inspectedURL=SDK.targetManager.mainTarget().inspectedURL().asParsedURL();var inspectedOrigin=inspectedURL&&inspectedURL.securityOrigin();for(var registration of this._manager.registrations().values()){if(registration.securityOrigin!==inspectedOrigin)
continue;for(var version of registration.versions.values()){if(version.controlledClients.length>1)
return true;}}
return false;}
_hasAtLeastOneCategory(){return Audits2.Audits2Panel.Presets.some(preset=>preset.setting.get());}
_unauditablePageMessage(){if(!this._manager)
return null;var inspectedURL=SDK.targetManager.mainTarget().inspectedURL();if(/^about:/.test(inspectedURL))
return Common.UIString('Cannot audit about:* pages. Navigate to a different page to start an audit.');return null;}
_updateStartButtonEnabled(){var hasActiveServiceWorker=this._hasActiveServiceWorker();var hasAtLeastOneCategory=this._hasAtLeastOneCategory();var unauditablePageMessage=this._unauditablePageMessage();var isDisabled=hasActiveServiceWorker||!hasAtLeastOneCategory||!!unauditablePageMessage;if(this._dialogHelpText&&hasActiveServiceWorker){this._dialogHelpText.textContent=Common.UIString('Multiple tabs are being controlled by the same service worker. '+'Close your other tabs on the same origin to audit this page.');}
if(this._dialogHelpText&&!hasAtLeastOneCategory)
this._dialogHelpText.textContent=Common.UIString('At least one category must be selected.');if(this._dialogHelpText&&unauditablePageMessage)
this._dialogHelpText.textContent=unauditablePageMessage;if(this._dialogHelpText)
this._dialogHelpText.classList.toggle('hidden',!isDisabled);if(this._startButton)
this._startButton.disabled=isDisabled;}
_clearAll(){this._reportSelector.clearAll();this._showLandingPage();}
_downloadSelected(){this._reportSelector.downloadSelected();}
_showLandingPage(){if(this._reportSelector.comboBox().size())
return;this._auditResultsElement.removeChildren();var landingPage=this._auditResultsElement.createChild('div','vbox audits2-landing-page');var landingCenter=landingPage.createChild('div','vbox audits2-landing-center');landingCenter.createChild('div','audits2-logo');var text=landingCenter.createChild('div','audits2-landing-text');text.createChild('span','audits2-landing-bold-text').textContent=Common.UIString('Audits');text.createChild('span').textContent=Common.UIString(' help you identify and fix common problems that affect'+' your site\'s performance, accessibility, and user experience. ');var link=text.createChild('span','link');link.textContent=Common.UIString('Learn more');link.addEventListener('click',()=>InspectorFrontendHost.openInNewTab('https://developers.google.com/web/tools/lighthouse/'));var newButton=UI.createTextButton(Common.UIString('Perform an audit\u2026'),this._showLauncherUI.bind(this),'',true);landingCenter.appendChild(newButton);this.setDefaultFocusedElement(newButton);}
_showLauncherUI(){this._dialog=new UI.Dialog();this._dialog.setOutsideClickCallback(event=>event.consume(true));var root=UI.createShadowRootWithCoreStyles(this._dialog.contentElement,'audits2/audits2Dialog.css');var auditsViewElement=root.createChild('div','audits2-view');var closeButton=auditsViewElement.createChild('div','dialog-close-button','dt-close-button');closeButton.addEventListener('click',()=>this._cancelAndClose());var uiElement=auditsViewElement.createChild('div');var headerElement=uiElement.createChild('header');this._headerTitleElement=headerElement.createChild('p');this._headerTitleElement.textContent=Common.UIString('Audits to perform');uiElement.appendChild(headerElement);this._auditSelectorForm=uiElement.createChild('form','audits2-form');for(var preset of Audits2.Audits2Panel.Presets){preset.setting.setTitle(preset.title);var checkbox=new UI.ToolbarSettingCheckbox(preset.setting);var row=this._auditSelectorForm.createChild('div','vbox audits2-launcher-row');row.appendChild(checkbox.element);row.createChild('span','audits2-launcher-description dimmed').textContent=preset.description;}
this._statusView=this._createStatusView(uiElement);this._dialogHelpText=uiElement.createChild('div','audits2-dialog-help-text');var buttonsRow=uiElement.createChild('div','audits2-dialog-buttons hbox');this._startButton=UI.createTextButton(Common.UIString('Run audit'),this._start.bind(this),'',true);this._startButton.autofocus=true;this._updateStartButtonEnabled();buttonsRow.appendChild(this._startButton);this._cancelButton=UI.createTextButton(Common.UIString('Cancel'),this._cancel.bind(this));buttonsRow.appendChild(this._cancelButton);this._dialog.setSizeBehavior(UI.GlassPane.SizeBehavior.SetExactWidthMaxHeight);this._dialog.setMaxContentSize(new UI.Size(500,400));this._dialog.show(this._auditResultsElement);auditsViewElement.tabIndex=0;auditsViewElement.focus();}
_createStatusView(launcherUIElement){var statusView=launcherUIElement.createChild('div','audits2-status vbox hidden');this._statusIcon=statusView.createChild('div','icon');this._statusElement=statusView.createChild('div');this._updateStatus(Common.UIString('Loading...'));return statusView;}
_updateInspectedURL(){var mainTarget=SDK.targetManager.mainTarget();var runtimeModel=mainTarget.model(SDK.RuntimeModel);var executionContext=runtimeModel&&runtimeModel.defaultExecutionContext();this._inspectedURL=mainTarget.inspectedURL();if(!executionContext)
return Promise.resolve();return executionContext.evaluate({expression:'window.location.href',objectGroup:'audits',includeCommandLineAPI:false,silent:false,returnByValue:true,generatePreview:false},false,false).then(result=>{if(!result.exceptionDetails&&result.object){this._inspectedURL=result.object.value;result.object.release();}});}
_start(){var emulationModel=self.singleton(Emulation.DeviceModeModel);this._emulationEnabledBefore=emulationModel.enabledSetting().get();this._emulationOutlineEnabledBefore=emulationModel.deviceOutlineSetting().get();emulationModel.enabledSetting().set(true);emulationModel.deviceOutlineSetting().set(true);emulationModel.toolbarControlsEnabledSetting().set(false);for(var device of Emulation.EmulatedDevicesList.instance().standard()){if(device.title==='Nexus 5X')
emulationModel.emulate(Emulation.DeviceModeModel.Type.Device,device,device.modes[0],1);}
this._dialog.setCloseOnEscape(false);var categoryIDs=[];for(var preset of Audits2.Audits2Panel.Presets){if(preset.setting.get())
categoryIDs.push(preset.configID);}
Host.userMetrics.actionTaken(Host.UserMetrics.Action.Audits2Started);return Promise.resolve().then(_=>this._updateInspectedURL()).then(_=>this._protocolService.attach()).then(_=>{this._auditRunning=true;this._updateButton();this._updateStatus(Common.UIString('Loading\u2026'));}).then(_=>this._protocolService.startLighthouse(this._inspectedURL,categoryIDs)).then(lighthouseResult=>{if(lighthouseResult&&lighthouseResult.fatal){const error=new Error(lighthouseResult.message);error.stack=lighthouseResult.stack;throw error;}
return this._stopAndReattach().then(()=>this._buildReportUI(lighthouseResult));}).catch(err=>{if(err instanceof Error)
this._renderBugReport(err);});}
_hideDialog(){if(!this._dialog)
return;this._dialog.hide();delete this._dialog;delete this._statusView;delete this._statusIcon;delete this._statusElement;delete this._startButton;delete this._cancelButton;delete this._auditSelectorForm;delete this._headerTitleElement;delete this._emulationEnabledBefore;delete this._emulationOutlineEnabledBefore;}
_cancelAndClose(){this._cancel();this._hideDialog();}
_cancel(){if(this._auditRunning){this._updateStatus(Common.UIString('Cancelling\u2026'));this._stopAndReattach();}else{this._hideDialog();}}
_updateButton(){if(!this._dialog)
return;this._startButton.classList.toggle('hidden',this._auditRunning);this._startButton.disabled=this._auditRunning;this._statusView.classList.toggle('hidden',!this._auditRunning);this._auditSelectorForm.classList.toggle('hidden',this._auditRunning);if(this._auditRunning)
this._headerTitleElement.textContent=Common.UIString('Auditing your web page \u2026');else
this._headerTitleElement.textContent=Common.UIString('Audits to perform');}
_updateStatus(statusMessage){if(!this._dialog)
return;this._statusElement.textContent=statusMessage;}
async _stopAndReattach(){await this._protocolService.detach();var emulationModel=self.singleton(Emulation.DeviceModeModel);emulationModel.enabledSetting().set(this._emulationEnabledBefore);emulationModel.deviceOutlineSetting().set(this._emulationOutlineEnabledBefore);emulationModel.toolbarControlsEnabledSetting().set(true);Emulation.InspectedPagePlaceholder.instance().update(true);Host.userMetrics.actionTaken(Host.UserMetrics.Action.Audits2Finished);var resourceTreeModel=SDK.targetManager.mainTarget().model(SDK.ResourceTreeModel);await resourceTreeModel.navigate(this._inspectedURL);this._auditRunning=false;this._updateButton();}
_buildReportUI(lighthouseResult){if(lighthouseResult===null){this._updateStatus(Common.UIString('Auditing failed.'));return;}
var optionElement=new Audits2.ReportSelector.Item(lighthouseResult,this._auditResultsElement,this._showLandingPage.bind(this));this._reportSelector.prepend(optionElement);this._hideDialog();}
_renderBugReport(err){console.error(err);this._statusElement.textContent='';this._statusIcon.classList.add('error');this._statusElement.createTextChild(Common.UIString('Ah, sorry! We ran into an error: '));this._statusElement.createChild('em').createTextChild(err.message);this._createBugReportLink(err,this._statusElement);}
_createBugReportLink(err,parentElem){var baseURI='https://github.com/GoogleChrome/lighthouse/issues/new?';var title=encodeURI('title=DevTools Error: '+err.message.substring(0,60));var issueBody=`
**Initial URL**: ${this._inspectedURL}
**Chrome Version**: ${navigator.userAgent.match(/Chrome\/(\S+)/)[1]}
**Error Message**: ${err.message}
**Stack Trace**:
\`\`\`
${err.stack}
\`\`\`
    `;var body='&body='+encodeURI(issueBody.trim());var reportErrorEl=parentElem.createChild('a','audits2-link audits2-report-error');reportErrorEl.href=baseURI+title+body;reportErrorEl.textContent=Common.UIString('Report this bug');reportErrorEl.target='_blank';}
_handleDrop(dataTransfer){var items=dataTransfer.items;if(!items.length)
return;var item=items[0];if(item.kind==='file'){var entry=items[0].webkitGetAsEntry();if(!entry.isFile)
return;entry.file(file=>{var reader=new FileReader();reader.onload=()=>this._loadedFromFile((reader.result));reader.readAsText(file);});}}
_loadedFromFile(profile){var data=JSON.parse(profile);if(!data['lighthouseVersion'])
return;this._buildReportUI((data));}};Audits2.Audits2Panel.ReportRenderer=class extends ReportRenderer{_renderReportNav(){return createDocumentFragment();}
_renderReportHeader(report){return createDocumentFragment();}};class ReportUIFeatures{initFeatures(report){}}
Audits2.Audits2Panel.Preset;Audits2.Audits2Panel.Presets=[{setting:Common.settings.createSetting('audits2.cat_pwa',true),configID:'pwa',title:'Progressive Web App',description:'Does this page meet the standard of a Progressive Web App'},{setting:Common.settings.createSetting('audits2.cat_perf',true),configID:'performance',title:'Performance',description:'How long does this app take to show content and become usable'},{setting:Common.settings.createSetting('audits2.cat_best_practices',true),configID:'best-practices',title:'Best practices',description:'Does this page follow best practices for modern web development'},{setting:Common.settings.createSetting('audits2.cat_a11y',true),configID:'accessibility',title:'Accessibility',description:'Is this page usable by people with disabilities or impairments'},];Audits2.ProtocolService=class extends Common.Object{constructor(){super();this._rawConnection=null;this._backend=null;this._backendPromise=null;this._status=null;}
attach(){return SDK.targetManager.interceptMainConnection(this._dispatchProtocolMessage.bind(this)).then(rawConnection=>{this._rawConnection=rawConnection;});}
startLighthouse(inspectedURL,categoryIDs){return this._send('start',{url:inspectedURL,categoryIDs});}
detach(){return Promise.resolve().then(()=>this._send('stop')).then(()=>this._backend.dispose()).then(()=>{delete this._backend;delete this._backendPromise;return this._rawConnection.disconnect();});}
registerStatusCallback(callback){this._status=callback;}
_dispatchProtocolMessage(message){this._send('dispatchProtocolMessage',{message:message});}
_initWorker(){this._backendPromise=Services.serviceManager.createAppService('audits2_worker','Audits2Service').then(backend=>{if(this._backend)
return;this._backend=backend;this._backend.on('statusUpdate',result=>this._status(result.message));this._backend.on('sendProtocolMessage',result=>this._sendProtocolMessage(result.message));});}
_sendProtocolMessage(message){this._rawConnection.sendMessage(message);}
_send(method,params){if(!this._backendPromise)
this._initWorker();return this._backendPromise.then(_=>this._backend.send(method,params));}};Audits2.ReportSelector=class{constructor(){this._comboBox=new UI.ToolbarComboBox(this._handleChange.bind(this),'audits2-report');this._comboBox.setMaxWidth(270);this._comboBox.setMinWidth(200);this._itemByOptionElement=new Map();}
_handleChange(event){var item=this._selectedItem();if(item)
item.select();}
_selectedItem(){var option=this._comboBox.selectedOption();return this._itemByOptionElement.get(option);}
comboBox(){return this._comboBox;}
prepend(item){var optionEl=item.optionElement();var selectEl=this._comboBox.selectElement();this._itemByOptionElement.set(optionEl,item);selectEl.insertBefore(optionEl,selectEl.firstElementChild);this._comboBox.select(optionEl);item.select();}
clearAll(){for(var elem of this._comboBox.options())
this._itemByOptionElement.get(elem).delete();}
downloadSelected(){var item=this._selectedItem();item.download();}};Audits2.ReportSelector.Item=class{constructor(lighthouseResult,resultsView,showLandingCallback){this._lighthouseResult=lighthouseResult;this._resultsView=resultsView;this._showLandingCallback=showLandingCallback;this._reportContainer=null;var url=new Common.ParsedURL(lighthouseResult.url);var timestamp=lighthouseResult.generatedTime;this._element=createElement('option');this._element.label=`${url.domain()} ${new Date(timestamp).toLocaleString()}`;}
select(){this._renderReport();}
optionElement(){return this._element;}
delete(){if(this._element)
this._element.remove();this._showLandingCallback();}
download(){var url=new Common.ParsedURL(this._lighthouseResult.url).domain();var timestamp=this._lighthouseResult.generatedTime;var fileName=`${url}-${new Date(timestamp).toISO8601Compact()}.json`;Workspace.fileManager.save(fileName,JSON.stringify(this._lighthouseResult),true);}
_renderReport(){this._resultsView.removeChildren();if(this._reportContainer){this._resultsView.appendChild(this._reportContainer);return;}
this._reportContainer=this._resultsView.createChild('div','lh-vars lh-root lh-devtools');var dom=new DOM((this._resultsView.ownerDocument));var detailsRenderer=new Audits2.DetailsRenderer(dom);var categoryRenderer=new CategoryRenderer(dom,detailsRenderer);var renderer=new Audits2.Audits2Panel.ReportRenderer(dom,categoryRenderer);var templatesHTML=Runtime.cachedResources['audits2/lighthouse/templates.html'];var templatesDOM=new DOMParser().parseFromString(templatesHTML,'text/html');if(!templatesDOM)
return;renderer.setTemplateContext(templatesDOM);renderer.renderReport(this._lighthouseResult,this._reportContainer);}};Audits2.DetailsRenderer=class extends DetailsRenderer{constructor(dom){super(dom);this._onMainFrameNavigatedPromise=null;}
renderNode(item){var element=super.renderNode(item);this._replaceWithDeferredNodeBlock(element,item);return element;}
async _replaceWithDeferredNodeBlock(origElement,detailsItem){var mainTarget=SDK.targetManager.mainTarget();if(!this._onMainFrameNavigatedPromise){var resourceTreeModel=mainTarget.model(SDK.ResourceTreeModel);this._onMainFrameNavigatedPromise=resourceTreeModel.once(SDK.ResourceTreeModel.Events.MainFrameNavigated);}
await this._onMainFrameNavigatedPromise;var domModel=mainTarget.model(SDK.DOMModel);if(!detailsItem.path)
return;var nodeId=await domModel.pushNodeByPathToFrontend(detailsItem.path);if(!nodeId)
return;var node=domModel.nodeForId(nodeId);if(!node)
return;var element=Components.DOMPresentationUtils.linkifyNodeReference(node,undefined,detailsItem.snippet);origElement.title='';origElement.textContent='';origElement.appendChild(element);}};;Runtime.cachedResources["audits2/audits2Dialog.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.audits2-view {\n    margin: 7px 20px;\n    flex: auto;\n    align-items: center;\n}\n\n.audits2-view .dialog-close-button {\n    position: absolute;\n    top: 10px;\n    right: 10px;\n}\n\nheader {\n    color: #666;\n    font-weight: bold;\n    font-size: 14px;\n}\n\n.audits2-form label {\n    display: flex;\n}\n\n.audits2-form label div {\n    display: inline;\n}\n\n.audits2-status {\n    flex: auto;\n    align-items: center;\n    color: #666;\n}\n\n.audits2-status .icon {\n    width: 64px;\n    height: 64px;\n    margin: 20px;\n    animation: spinner-animation 1200ms linear infinite;\n    transform-origin: 50% 50%;\n    padding: 4px;\n}\n\n.audits2-status .icon::before {\n    display: inline-block;\n    border: 4px solid #1565C0;\n    border-radius: 28px;\n    width: 56px;\n    height: 56px;\n    content: \"\";\n    position: absolute;\n    box-sizing: border-box;\n}\n\n.audits2-status .icon::after {\n    display: inline-block;\n    width: 24px;\n    height: 28px;\n    background: white;\n    position: absolute;\n    content: \"\";\n}\n\n.audits2-report-error {\n    display: block;\n    margin-top: 5px;\n}\n\nbutton {\n    margin: 15px 10px;\n}\n\n.audits2-status .icon.error,\n.audits2-status .icon.error::before,\n.audits2-status .icon.error::after {\n    display: none;\n}\n\n.audits2-launcher-row {\n    padding: 6px;\n}\n\n.audits2-launcher-description {\n    padding: 3px 0 0 22px;\n}\n\n.audits2-dialog-help-text {\n    color: red;\n    margin-top: 10px;\n}\n\n.audits2-dialog-buttons {\n    justify-content: center;\n}\n\n@keyframes spinner-animation {\n    from { transform: rotate(0); }\n    to { transform: rotate(360deg); }\n\n/*# sourceURL=audits2/audits2Dialog.css */";Runtime.cachedResources["audits2/audits2Panel.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.toolbar {\n    border-bottom: 1px solid #ccc;\n}\n\n.audits2-logo {\n    width: 210px;\n    height: 200px;\n    flex-shrink: 0;\n    background-repeat: no-repeat;\n    background-size: contain;\n    margin-top: 10px;\n    background-image: url(Images/audits_logo.svg);\n}\n\n.audits2-landing-page {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    overflow: auto;\n}\n\n\n.audits2-landing-center {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    max-width: 400px;\n    margin: 50px;\n}\n\n.audits2-landing-center > * {\n    flex-shrink: 0;\n}\n\n.audits2-landing-text {\n    color: #666;\n}\n\n.audits2-landing-bold-text {\n    font-weight: bold;\n}\n\n.lh-root {\n  --report-menu-width: 0;\n  user-select: initial;\n  background: #fff;\n}\n\n.audits2-landing-center button {\n    margin-top: 20px;\n}\n\n.audits2-results-container {\n    overflow-y: scroll;\n    position: relative;\n}\n\n/*# sourceURL=audits2/audits2Panel.css */";Runtime.cachedResources["audits2/lighthouse/report-styles.css"]="/**\n * @license Copyright 2017 Google Inc. All Rights Reserved.\n * Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0\n * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n */\n\n.lh-vars {\n  --text-font-family: Roboto, Helvetica, Arial, sans-serif;\n  --monospace-font-family: 'Menlo', 'dejavu sans mono', 'Consolas', 'Lucida Console', monospace;\n  --body-font-size: 14px;\n  --body-line-height: 18px;\n  --subheader-font-size: 16px;\n  --subheader-line-height: 20px;\n  --header-font-size: 20px;\n  --header-line-height: 24px;\n  --title-font-size: 24px;\n  --title-line-height: 28px;\n  --caption-font-size: 12px;\n  --caption-line-height: 16px;\n  --default-padding: 12px;\n  --section-padding: 20px;\n  --section-indent: 16px;\n  --audit-group-indent: 16px;\n  --audit-indent: 16px;\n  --expandable-indent: 20px;\n  --secondary-text-color: #565656;\n  /*--accent-color: #3879d9;*/\n  --fail-color: #df332f;\n  --pass-color: #2b882f;\n  --informative-color: #0c50c7;\n  --manual-color: #757575;\n  --average-color: #ef6c00; /* md orange 800 */\n  --warning-color: #ffab00; /* md amber a700 */\n  --report-border-color: #ccc;\n  --report-secondary-border-color: #ebebeb;\n  --report-width: calc(60 * var(--body-font-size));\n  --report-menu-width: calc(20 * var(--body-font-size));\n  --report-content-width: calc(var(--report-width) + var(--report-menu-width));\n  --navitem-font-size: var(--body-font-size);\n  --navitem-line-height: var(--body-line-height);\n  --navitem-hpadding: var(--body-font-size);\n  --navitem-vpadding: calc(var(--navitem-line-height) / 2);\n  --lh-score-highlight-bg: #fafafa;\n  --lh-score-icon-background-size: 24px;\n  --lh-score-margin: 12px;\n  --lh-table-header-bg: #ccc;\n  --lh-table-higlight-bg: #fafafa;\n  --lh-sparkline-height: 5px;\n  --lh-sparkline-thin-height: 3px;\n  --lh-filmstrip-thumbnail-width: 60px;\n  --lh-audit-score-width: calc(5 * var(--body-font-size));\n  --lh-category-score-width: calc(5 * var(--body-font-size));\n  --lh-audit-vpadding: 8px;\n  --lh-audit-hgap: 12px;\n  --lh-audit-group-vpadding: 12px;\n  --lh-section-vpadding: 12px;\n  --pass-icon-url: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><path stroke=\"#007F04\" stroke-width=\"1.5\" d=\"M1 5.75l3.5 3.5 6.5-6.5\" fill=\"none\" fill-rule=\"evenodd\"/></svg>');\n  --fail-icon-url: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><g stroke=\"#EE1D0A\" stroke-width=\"1.5\" fill=\"none\" fill-rule=\"evenodd\"><path d=\"M2 10l8-8M10 10L2 2\"/></g></svg>');\n  --collapsed-icon-url: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"none\" fill-rule=\"evenodd\"><path fill=\"none\" d=\"M0 0h12v12H0z\"/><path fill=\"hsl(0, 0%, 60%)\" d=\"M3 2l6 4-6 4z\"/></g></svg>');\n  --expanded-icon-url: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"none\" fill-rule=\"evenodd\"><path fill=\"none\" d=\"M0 0h12v12H0z\"/><path fill=\"hsl(0, 0%, 60%)\" d=\"M10 3L6 9 2 3z\"/></g></svg>');\n}\n\n.lh-vars.lh-devtools {\n  --text-font-family: '.SFNSDisplay-Regular', 'Helvetica Neue', 'Lucida Grande', sans-serif;\n  --monospace-font-family: 'Menlo', 'dejavu sans mono', 'Consolas', 'Lucida Console', monospace;\n  --body-font-size: 12px;\n  --body-line-height: 16px;\n  --subheader-font-size: 14px;\n  --subheader-line-height: 18px;\n  --header-font-size: 16px;\n  --header-line-height: 20px;\n  --title-font-size: 20px;\n  --title-line-height: 24px;\n  --caption-font-size: 11px;\n  --caption-line-height: 14px;\n  --default-padding: 12px;\n  --section-padding: 16px;\n  --section-indent: 16px;\n  --audit-group-indent: 16px;\n  --audit-indent: 16px;\n  --expandable-indent: 16px;\n\n  --lh-audit-vpadding: 4px;\n  --lh-audit-hgap: 12px;\n  --lh-audit-group-vpadding: 8px;\n  --lh-section-vpadding: 8px;\n}\n\n.lh-root * {\n  box-sizing: border-box;\n}\n\n.lh-root {\n  font-family: var(--text-font-family);\n  font-size: var(--body-font-size);\n  margin: 0;\n  line-height: var(--body-line-height);\n  background: #f5f5f5;\n  scroll-behavior: smooth;\n}\n\n.lh-root :focus {\n    outline: -webkit-focus-ring-color auto 3px;\n}\n\n.lh-root [hidden] {\n  display: none !important;\n}\n\na {\n  color: #0c50c7;\n}\n\nsummary {\n  cursor: pointer;\n}\n\n.lh-details {\n  font-size: var(--body-font-size);\n  margin-top: var(--default-padding);\n}\n\n.lh-details[open] summary {\n  margin-bottom: var(--default-padding);\n}\n\n.lh-details summary::-webkit-details-marker {\n  color: #9e9e9e;\n}\n\n.lh-details.flex .lh-code {\n  max-width: 70%;\n}\n\n/* Report header */\n\n.report-icon {\n  opacity: 0.7;\n}\n.report-icon:hover {\n  opacity: 1;\n}\n.report-icon[disabled] {\n  opacity: 0.3;\n  pointer-events: none;\n}\n\n.report-icon--share {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path fill=\"none\" d=\"M0 0h24v24H0z\"/><path d=\"M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92 1.61 0 2.92-1.31 2.92-2.92s-1.31-2.92-2.92-2.92z\"/></svg>');\n}\n.report-icon--print {\n  background-image: url('data:image/svg+xml;utf8,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\"><path d=\"M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z\"/><path fill=\"none\" d=\"M0 0h24v24H0z\"/></svg>');\n}\n.report-icon--copy {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z\"/></svg>');\n}\n.report-icon--open {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z\"/></svg>');\n}\n.report-icon--download {\n  background-image: url('data:image/svg+xml;utf8,<svg height=\"24\" viewBox=\"0 0 24 24\" width=\"24\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z\"/><path d=\"M0 0h24v24H0z\" fill=\"none\"/></svg>');\n}\n\n/* List */\n.lh-list {\n  font-size: smaller;\n  margin-top: var(--default-padding);\n}\n\n.lh-list__items {\n  padding-left: var(--default-padding);\n}\n\n.lh-list__item {\n  margin-bottom: 2px;\n}\n\n/* Node */\n.lh-node {\n  display: block;\n  font-family: var(--monospace-font-family);\n  word-break: break-word;\n  color: hsl(174, 100%, 27%);\n}\nspan.lh-node:hover {\n    background: hsl(0, 0%, 98%);\n    border-radius: 2px;\n}\n\n/* Card */\n.lh-scorecards {\n  display: flex;\n  flex-wrap: wrap;\n}\n.lh-scorecard {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex: 0 0 calc(12 * var(--body-font-size));\n  flex-direction: column;\n  padding: var(--default-padding);\n  padding-top: calc(32px + var(--default-padding));\n  border-radius: 3px;\n  margin-right: var(--default-padding);\n  position: relative;\n  line-height: inherit;\n  border: 1px solid #ebebeb;\n}\n.lh-scorecard__title {\n  background-color: #eee;\n  position: absolute;\n  top: 0;\n  right: 0;\n  left: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  padding: calc(var(--default-padding) / 2);\n}\n.lh-scorecard__value {\n  font-size: calc(1.6 * var(--body-font-size));\n}\n.lh-scorecard__target {\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n/* Score */\n\n.lh-score {\n  display: flex;\n  align-items: flex-start;\n}\n\n.lh-score__value {\n  flex: none;\n  margin-left: var(--lh-score-margin);\n  width: calc(var(--lh-audit-score-width) - var(--lh-score-margin));\n  position: relative;\n  font-weight: bold;\n  top: 1px;\n  text-align: right;\n}\n\n.lh-score__value::after {\n  content: '';\n  position: absolute;\n  right: 0;\n  top: 0;\n  bottom: 0;\n  border-radius: inherit;\n  width: 16px;\n}\n\n.lh-score--informative .lh-score__value {\n  color: var(--informative-color);\n  border-radius: 50%;\n  top: 3px;\n}\n\n.lh-score--informative .lh-score__value::after {\n  display: none;\n  background: url('data:image/svg+xml;utf8,<svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>info</title><path d=\"M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z\" fill=\"hsl(218, 89%, 41%)\"/></svg>') no-repeat 50% 50%;\n  background-size: var(--lh-score-icon-background-size);\n}\n\n.lh-score--manual .lh-score__value::after {\n  background: url('data:image/svg+xml;utf8,<svg width=\"12\" height=\"12\" viewBox=\"0 0 12 12\" xmlns=\"http://www.w3.org/2000/svg\"><title>manual</title><path d=\"M2 5h8v2H2z\" fill=\"hsl(0, 0%, 100%)\" fill-rule=\"evenodd\"/></svg>') no-repeat 50% 50%;\n  background-size: 18px;\n  background-color: var(--manual-color);\n  width: 20px;\n  height:  20px;\n  position: relative;\n}\n\n.lh-score__value--binary {\n  color: transparent !important;\n}\n\n/* No icon for audits with number scores. */\n.lh-score__value:not(.lh-score__value--binary)::after {\n  content: none;\n}\n\n.lh-score__value--pass {\n  color: var(--pass-color);\n}\n\n.lh-score__value--pass::after {\n  background: var(--pass-icon-url) no-repeat center center / 12px 12px;\n}\n\n.lh-score__value--average {\n  color: var(--average-color);\n}\n\n.lh-score__value--average::after {\n  background: none;\n  content: '!';\n  color: var(--average-color);\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  font-weight: 500;\n  font-size: 15px;\n}\n\n.lh-score__value--fail {\n  color: var(--fail-color);\n}\n\n.lh-score__value--fail::after {\n  background: var(--fail-icon-url) no-repeat center center / 12px 12px;\n}\n\n.lh-score__description {\n  font-size: var(--body-font-size);\n  color: var(--secondary-text-color);\n  line-height: var(--body-line-height);\n}\n\n.lh-score__snippet {\n  align-items: center;\n  justify-content: space-between;\n  /*outline: none;*/\n}\n\n.lh-score__snippet::-moz-list-bullet {\n  display: none;\n}\n\n.lh-score__title {\n  flex: 1;\n}\n\n.lh-toggle-arrow {\n  background: var(--collapsed-icon-url) no-repeat center center / 12px 12px;\n  background-color: transparent;\n  width: 12px;\n  height: 12px;\n  flex: none;\n  transition: transform 150ms ease-in-out;\n  cursor: pointer;\n  border: none;\n  order: -1;\n  margin-right: calc(var(--expandable-indent) - 12px);\n  align-self: flex-start;\n}\n\n.lh-toggle-arrow-unexpandable {\n  visibility: hidden;\n}\n\n/* Expandable Details (Audit Groups, Audits) */\n\n.lh-score__header {\n  order: -1;\n  flex: 1;\n}\n\n.lh-expandable-details {\n  padding-left: var(--expandable-indent);\n}\n\n.lh-expandable-details__summary {\n  display: flex;\n  align-items: center;\n  cursor: pointer;\n  margin-left: calc(0px - var(--expandable-indent));\n}\n\n.lh-expandable-details[open] > .lh-expandable-details__summary > .lh-toggle-arrow {\n  background-image: var(--expanded-icon-url);\n}\n\n.lh-audit-group__summary::-webkit-details-marker,\n.lh-expandable-details__summary::-webkit-details-marker {\n  display: none;\n}\n\n.lh-score__snippet .lh-toggle-arrow {\n  margin-top: calc((var(--body-line-height) - 12px) / 2);\n}\n\n/* Perf Timeline */\n\n.lh-timeline {\n  padding: 0;\n  padding-bottom: 0;\n  min-width: calc(var(--lh-filmstrip-thumbnail-width) * 10 + var(--default-padding) * 2);\n}\n\n.lh-narrow .lh-timeline-container {\n  width: calc(100vw - var(--section-padding) * 2);\n  overflow-x: scroll;\n}\n\n.lh-devtools .lh-timeline-container {\n  width: 100%;\n  overflow-x: scroll;\n}\n\n/* Perf Timeline Metric */\n\n.lh-timeline-metric {\n  position: relative;\n  margin-bottom: calc(2 * var(--lh-audit-vpadding));\n  padding-top: var(--lh-audit-vpadding);\n  border-top: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-timeline-metric__header {\n  display: flex;\n}\n\n.lh-timeline-metric__details {\n  order: -1;\n}\n\n.lh-timeline-metric__title {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n  display: flex;\n}\n\n.lh-timeline-metric__name {\n  flex: 1;\n}\n\n.lh-timeline-metric__description {\n  color: var(--secondary-text-color);\n}\n\n.lh-timeline-metric__value {\n  width: var(--lh-audit-score-width);\n  text-align: right;\n}\n\n.lh-timeline-metric--pass .lh-timeline-metric__value {\n  color: var(--pass-color);\n}\n\n.lh-timeline-metric--average .lh-timeline-metric__value {\n  color: var(--average-color);\n}\n\n.lh-timeline-metric--fail .lh-timeline-metric__value {\n  color: var(--fail-color);\n}\n\n.lh-timeline-metric__sparkline {\n  position: absolute;\n  left: 0;\n  right: 0;\n  top: -1px;\n  height: 3px;\n  width: 100%;\n}\n\n.lh-timeline-metric__sparkline .lh-sparkline__bar {\n  float: none;\n}\n\n.lh-timeline-metric--pass .lh-sparkline__bar {\n  background: var(--pass-color);\n}\n\n.lh-timeline-metric--average .lh-sparkline__bar {\n  background: var(--average-color);\n}\n\n.lh-timeline-metric--fail .lh-sparkline__bar {\n  background: var(--fail-color);\n}\n\n.lh-timeline-metric .lh-debug {\n  margin-left: var(--expandable-indent);\n}\n\n/* Perf Hint */\n\n.lh-perf-hint {\n  padding-top: var(--lh-audit-vpadding);\n  padding-bottom: var(--lh-audit-vpadding);\n  border-top: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-perf-hint:last-of-type {\n  border-bottom: none;\n}\n\n.lh-perf-hint__summary {\n  display: flex;\n  align-items: flex-start;\n  flex-wrap: wrap;\n  min-height: calc(var(--body-line-height) + var(--caption-line-height));\n}\n\n.lh-perf-hint__summary .lh-toggle-arrow {\n  margin-top: calc((var(--subheader-line-height) - 12px) / 2);\n}\n\n.lh-perf-hint__summary .lh-debug {\n  width: calc(100% - var(--expandable-indent));\n  margin: 0 var(--expandable-indent);\n}\n\n.lh-perf-hint__title {\n  font-size: var(--body-font-size);\n  flex: 10;\n}\n\n.lh-perf-hint__sparkline {\n  flex: 0 0 50%;\n  margin-top: calc((var(--body-line-height) - var(--lh-sparkline-height)) / 2);\n}\n\n.lh-perf-hint__sparkline .lh-sparkline {\n  width: 100%;\n  float: right;\n  margin: 0;\n}\n\n.lh-perf-hint__stats {\n  text-align: right;\n  flex: 0 0 var(--lh-audit-score-width);\n}\n\n.lh-perf-hint__primary-stat {\n  font-size: var(--body-font-size);\n  line-height: var(--body-line-height);\n}\n\n.lh-perf-hint__secondary-stat {\n  font-size: var(--caption-font-size);\n  line-height: var(--caption-line-height);\n}\n\n.lh-perf-hint__description {\n  color: var(--secondary-text-color);\n  margin-top: calc(var(--default-padding) / 2);\n}\n\n.lh-perf-hint--pass .lh-perf-hint__stats {\n  color: var(--pass-color);\n}\n\n.lh-perf-hint--pass .lh-sparkline__bar {\n  background: var(--pass-color);\n}\n\n.lh-perf-hint--average .lh-sparkline__bar {\n  background: var(--average-color);\n}\n\n.lh-perf-hint--average .lh-perf-hint__stats {\n  color: var(--average-color);\n}\n\n.lh-perf-hint--fail .lh-sparkline__bar {\n  background: var(--fail-color);\n}\n\n.lh-perf-hint--fail .lh-perf-hint__stats {\n  color: var(--fail-color);\n}\n\n/* Filmstrip */\n\n.lh-filmstrip {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  padding-bottom: var(--default-padding);\n}\n\n.lh-filmstrip__frame {\n  text-align: center;\n}\n\n.lh-filmstrip__timestamp {\n  margin-bottom: calc(0.5 * var(--caption-line-height));\n  font-size: var(--caption-font-size);\n  line-height: var(--caption-line-height);\n}\n\n.lh-filmstrip__thumbnail {\n  border: 1px solid var(--report-secondary-border-color);\n  max-height: 100px;\n}\n\n/* Sparkline */\n\n.lh-sparkline {\n  margin: 5px;\n  height: var(--lh-sparkline-height);\n  width: 100%;\n}\n\n.lh-sparkline--thin {\n  height: calc(var(--lh-sparkline-height) / 2);\n}\n\n.lh-sparkline__bar {\n  background: var(--warning-color);\n  height: 100%;\n  float: right;\n}\n\n/* Audit */\n\n.lh-audit {\n  margin-bottom: var(--lh-audit-vpadding);\n  padding-top: var(--lh-audit-vpadding);\n  border-top: 1px solid var(--report-secondary-border-color);\n}\n\n.lh-audit:last-of-type {\n  border-bottom: none;\n}\n\n.lh-audit > .lh-score {\n  font-size: var(--body-font-size);\n}\n\n.lh-audit .lh-debug {\n  margin-left: var(--expandable-indent);\n  margin-right: var(--lh-audit-score-width);\n}\n\n/* Audit Group */\n\n.lh-audit-group {\n  padding-top: var(--lh-audit-group-vpadding);\n  border-top: 1px solid var(--report-secondary-border-color);\n  padding-left: var(--expandable-indent);\n}\n\n.lh-audit-group__header {\n  font-size: var(--subheader-font-size);\n  line-height: var(--subheader-line-height);\n}\n\n.lh-audit-group__summary {\n  display: flex;\n  align-items: center;\n  margin-bottom: var(--lh-audit-group-vpadding);\n  margin-left: calc(0px - var(--expandable-indent));\n}\n\n.lh-audit-group__summary .lh-toggle-arrow {\n  margin-top: calc((var(--subheader-line-height) - 12px) / 2);\n}\n\n.lh-audit-group__description {\n  font-size: var(--body-font-size);\n  color: var(--secondary-text-color);\n  margin-top: calc(0px - var(--lh-audit-group-vpadding));\n  margin-bottom: var(--lh-audit-group-vpadding);\n  line-height: var(--body-line-height);\n}\n\n\n.lh-debug {\n  font-size: var(--caption-font-size);\n  line-height: var(--caption-line-height);\n  color: var(--fail-color);\n  margin-top: 3px;\n}\n\n.lh-debug::before {\n  display: none;\n  content: '';\n  background: url('data:image/svg+xml;utf8,<svg width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\"><title>warn</title><path d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z\" fill=\"hsl(40, 100%, 50%)\"/></svg>') no-repeat 50% 50%;\n  background-size: contain;\n  width: 20px;\n  height: 20px;\n  position: relative;\n  margin-right: calc(var(--default-padding) / 2);\n  top: 5px;\n}\n\n\n/* Report */\n\n.lh-container {\n  display: flex;\n  max-width: var(--report-content-width);\n  margin: 0 auto;\n}\n\n.lh-report {\n  margin-left: var(--report-menu-width);\n  background-color: #fff;\n  padding-top: var(--report-header-height);\n}\n@media screen {\n  .lh-report {\n    width: var(--report-width);\n  }\n}\n\n.lh-exception {\n  font-size: large;\n}\n\n.lh-text__url {\n  white-space: nowrap;\n}\n\n.lh-code {\n  text-overflow: ellipsis;\n  white-space: pre-line;\n  margin-top: 0;\n}\n\n.lh-scores-header {\n  display: flex;\n  justify-content: center;\n  overflow-x: hidden;\n  padding: var(--section-padding);\n  border-bottom: 1px solid var(--report-border-color);\n}\n.lh-scores-header__solo {\n  padding: 0;\n  border: 0;\n}\n\n.lh-categories {\n  width: 100%;\n  overflow: hidden;\n}\n\n.lh-category {\n  padding: var(--section-padding);\n  border-top: 1px solid var(--report-border-color);\n}\n\n/* section hash link jump should preserve fixed header\n   https://css-tricks.com/hash-tag-links-padding/\n*/\n.lh-category > .lh-permalink {\n  margin-top: calc((var(--report-header-height) + var(--default-padding)) * -1);\n  padding-bottom: calc(var(--report-header-height) + var(--default-padding));\n  display: block;\n  visibility: hidden;\n}\n\n.lh-category:first-of-type {\n  border: none;\n}\n\n.lh-category > .lh-score {\n  font-size: var(--header-font-size);\n  padding-bottom: var(--lh-section-vpadding);\n}\n\n.lh-category > .lh-score .lh-score__value,\n.lh-category > .lh-score .lh-score__gauge .lh-gauge__label {\n  display: none;\n}\n\n.lh-category .lh-score__gauge {\n  margin-left: var(--section-indent);\n  flex-basis: var(--circle-size);\n  flex-shrink: 0;\n}\n\n.lh-category .lh-score__gauge .lh-gauge {\n  --circle-size: calc(2.5 * var(--header-font-size));\n}\n\n/* Category snippet shouldnt have pointer cursor. */\n.lh-category > .lh-score .lh-score__snippet {\n  cursor: initial;\n}\n\n.lh-category > .lh-score .lh-score__title {\n  font-size: var(--header-font-size);\n  line-height: var(--header-line-height);\n}\n\n.lh-passed-audits[open] summary.lh-passed-audits-summary {\n  margin-bottom: calc(var(--default-padding) * 2);\n}\n\nsummary.lh-passed-audits-summary {\n  margin: calc(var(--default-padding) * 2) var(--default-padding);\n  margin-left: var(--default-padding);\n  margin-bottom: 0;\n  font-size: 15px;\n  display: flex;\n  align-items: center;\n}\n\n#lh-log {\n  position: fixed;\n  background-color: #323232;\n  color: #fff;\n  min-height: 48px;\n  min-width: 288px;\n  padding: 16px 24px;\n  box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);\n  border-radius: 2px;\n  margin: 12px;\n  font-size: 14px;\n  cursor: default;\n  transition: transform 0.3s, opacity 0.3s;\n  transform: translateY(100px);\n  opacity: 0;\n  -webkit-font-smoothing: antialiased;\n  bottom: 0;\n  left: 0;\n  z-index: 3;\n}\n\n#lh-log.show {\n  opacity: 1;\n  transform: translateY(0);\n}\n\n/* 964 fits the min-width of the filmstrip */\n@media screen and (max-width: 964px) {\n  .lh-report {\n    margin-left: 0;\n    width: 100%;\n    min-width: 400px;\n  }\n}\n\n@media print {\n  body {\n    -webkit-print-color-adjust: exact; /* print background colors */\n  }\n  .lh-container {\n    display: block;\n  }\n  .lh-report {\n    margin-left: 0;\n    padding-top: 0;\n  }\n  .lh-categories {\n    margin-top: 0;\n  }\n}\n\n.lh-table {\n  --image-preview-size: 24px;\n  border: 1px solid var(--report-secondary-border-color);\n  border-collapse: collapse;\n  table-layout: fixed;\n  width: 100%;\n}\n\n.lh-table thead {\n  background: var(--lh-table-header-bg);\n}\n\n.lh-table tbody tr:nth-child(even) {\n  background-color: var(--lh-table-higlight-bg);\n}\n\n.lh-table th,\n.lh-table td {\n  padding: 10px;\n  overflow: auto;\n}\n\n.lh-table-column--text {\n  text-align: right;\n}\n\n.lh-table-column--thumbnail {\n  width: calc(var(--image-preview-size) * 2);\n}\n\n.lh-table-column--url {\n  text-align: left;\n  min-width: 250px;\n  white-space: nowrap;\n}\n\n.lh-thumbnail {\n  height: var(--image-preview-size);\n  width: var(--image-preview-size);\n  object-fit: contain;\n}\n\n\n/*# sourceURL=audits2/lighthouse/report-styles.css */";Runtime.cachedResources["audits2/lighthouse/templates.html"]="<!-- Lighthouse category score -->\n<template id=\"tmpl-lh-category-score\">\n  <div class=\"lh-score\">\n    <div class=\"lh-score__value\"><!-- fill me --></div>\n    <div class=\"lh-score__gauge\"></div>\n    <div class=\"lh-score__header\">\n      <div class=\"lh-score__snippet\">\n        <span class=\"lh-score__title\"><!-- fill me --></span>\n      </div>\n      <div class=\"lh-score__description\"><!-- fill me --></div>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse audit score -->\n<template id=\"tmpl-lh-audit-score\">\n  <div class=\"lh-score\">\n    <div class=\"lh-score__value\"><!-- fill me --></div>\n    <details class=\"lh-score__header lh-expandable-details\">\n      <summary class=\"lh-score__snippet lh-expandable-details__summary\">\n        <span class=\"lh-score__title\"><!-- fill me --></span>\n        <div class=\"lh-toggle-arrow\" title=\"See audits\"></div>\n      </summary>\n      <div class=\"lh-score__description\"><!-- fill me --></div>\n    </details>\n  </div>\n</template>\n\n<!-- Lighthouse timeline metric -->\n<template id=\"tmpl-lh-timeline-metric\">\n  <div class=\"lh-timeline-metric\">\n    <div class=\"lh-timeline-metric__sparkline\">\n      <div class=\"lh-sparkline__bar\"></div>\n    </div>\n    <div class=\"lh-timeline-metric__header\">\n      <div class=\"lh-timeline-metric__value\"><!-- fill me --></div>\n      <details class=\"lh-timeline-metric__details lh-expandable-details\">\n        <summary class=\"lh-timeline-metric__summary lh-expandable-details__summary\">\n          <span class=\"lh-timeline-metric__title\"><!-- fill me --></span>\n          <div class=\"lh-toggle-arrow\" title=\"See audits\"></div>\n        </summary>\n        <div class=\"lh-timeline-metric__description\"><!-- fill me --></div>\n      </details>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse left nav -->\n<template id=\"tmpl-lh-leftnav\">\n  <style>\n    .lh-leftnav {\n      width: var(--report-menu-width);\n      border-right: 1px solid var(--report-border-color);\n      position: fixed;\n      height: 100%;\n      background: #fff;\n      will-change: transform; /* prevent excessive paints */\n      z-index: 2;\n    }\n    .lh-leftnav__item {\n      padding: var(--navitem-vpadding) var(--navitem-hpadding);\n      color: var(--secondary-text-color);\n      font-size: var(--navitem-font-size);\n      line-height: var(--navitem-line-height);\n      display: flex;\n      justify-content: space-between;\n      text-decoration: none;\n      color: inherit;\n    }\n    .leftnav-item__score {\n      background: transparent;\n    }\n    .leftnav-item__score::after {\n      content: '';\n    }\n    .leftnav-item__score.lh-score__value--pass {\n      color: var(--pass-color);\n    }\n    .leftnav-item__score.lh-score__value--average {\n      color: var(--average-color);\n    }\n    .leftnav-item__score.lh-score__value--fail {\n      color: var(--fail-color);\n    }\n    .leftnav__header {\n      padding: 0 20px;\n      margin-bottom: var(--navitem-vpadding);\n      height: 115px;\n      font-size: 18px;\n      display: flex;\n      flex-direction: column;\n      justify-content: center;\n      background: url(data:image/png;base64,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) no-repeat 150% 100%;\n      background-color: #2238b3;\n      background-size: 205px;\n      background-blend-mode: luminosity;\n    }\n    .leftnav__header__title {\n      font-family: var(--text-font-family);\n      font-size: var(--title-font-size);\n      line-height: var(--title-line-height);\n      font-weight: 300;\n      color: #fff;\n      margin: 0;\n      padding: 0;\n    }\n    .leftnav__header__version {\n      color: #aab3ed;\n      font-family: var(--text-font-family);\n      font-size: var(--body-font-size);\n      line-height: var(--body-line-height);\n    }\n    @media screen and (max-width: 964px) {\n      .lh-leftnav {\n        display: none;\n      }\n    }\n    @media print {\n      .lh-leftnav {\n        display: none;\n      }\n    }\n  </style>\n  <nav class=\"lh-leftnav\">\n    <div class=\"leftnav__header\">\n      <h1 class=\"leftnav__header__title\">Lighthouse</h1>\n      <div class=\"leftnav__header__version\"><!-- fill me --></div>\n    </div>\n    <template id=\"tmpl-lh-leftnav__items\">\n      <a href=\"#\" class=\"lh-leftnav__item\">\n        <span class=\"leftnav-item__category\"><!-- fill me --></span>\n        <span class=\"leftnav-item__score\"><!-- fill me --></span>\n      </a>\n    </template>\n  </nav>\n</template>\n\n<!-- Lighthouse header -->\n<template id=\"tmpl-lh-heading\">\n  <style>\n    :root {\n      --report-header-height: 58px;\n      --report-header-bg-color: #fafafa;\n    }\n    .lh-header {\n      display: flex;\n      height: var(--report-header-height);\n      left: 0;\n      right: 0;\n      max-width: 100%; /* support text-overflow on url */\n      border-bottom: 1px solid var(--report-secondary-border-color);\n      position: fixed;\n      z-index: 1;\n      will-change: transform;\n      background-color: var(--report-header-bg-color);\n      margin-left: var(--report-menu-width);\n      align-items: center;\n      padding: 0 calc(var(--default-padding) * 2);\n    }\n    .lh-metadata {\n      flex: 1 1 0;\n      padding-right: calc(var(--default-padding) / 2);\n      line-height: 20px;\n      color: var(--secondary-text-color);\n      overflow-x: hidden;\n    }\n    .lh-metadata__results {\n      overflow: hidden;\n      text-overflow: ellipsis;\n      white-space: nowrap;\n    }\n    .lh-metadata__url {\n      color: currentColor;\n    }\n    .lh-export {\n      position: relative;\n    }\n    .lh-export__button {\n      background-color: #fff;\n      border: 1px solid var(--report-border-color);\n      border-radius: 3px;\n      cursor: pointer;\n      outline: none;\n      height: 32px;\n      width: 48px;\n      background-repeat: no-repeat;\n      background-size: 20px;\n      background-position: 50% 50%;\n    }\n    .lh-export__button:focus,\n    .lh-export__button.active {\n      box-shadow: 1px 1px 3px #ccc;\n    }\n    .lh-export__button.active + .lh-export__dropdown {\n      opacity: 1;\n      clip: rect(0, 164px, 200px, 0);\n    }\n    .lh-export__dropdown {\n      position: absolute;\n      background-color: #fff;\n      border: 1px solid var(--report-border-color);\n      border-radius: 3px;\n      padding: calc(var(--default-padding) / 2) 0;\n      cursor: pointer;\n      top: 36px;\n      right: 0;\n      box-shadow: 1px 1px 3px #ccc;\n      min-width: 125px;\n      clip: rect(0, 164px, 0, 0);\n      opacity: 0;\n      transition: all 200ms cubic-bezier(0,0,0.2,1);\n    }\n    .lh-export__dropdown a {\n      display: block;\n      color: currentColor;\n      text-decoration: none;\n      white-space: nowrap;\n      padding: 0 12px;\n      line-height: 2;\n    }\n    .lh-export__dropdown a:hover,\n    .lh-export__dropdown a:focus {\n      background-color: #efefef;\n      outline: none;\n    }\n    .lh-export__dropdown .report-icon {\n      cursor: pointer;\n      background-repeat: no-repeat;\n      background-position: 8px 50%;\n      background-size: 18px;\n      background-color: transparent;\n      text-indent: 18px;\n    }\n    /* copy icon needs slight adjustments to look great */\n    .lh-export__dropdown .report-icon--copy {\n      background-size: 16px;\n      background-position: 9px 50%;\n    }\n    /* save-as-gist option hidden in report */\n    .lh-export__dropdown .lh-export--gist {\n      display: none;\n    }\n    .lh-config {\n      display: flex;\n    }\n    .lh-env {\n      padding: var(--default-padding) 0 var(--default-padding) calc(var(--default-padding) * 2);\n      left: 0;\n      top: 100%;\n      position: absolute;\n      width: 100%;\n      background-color: var(--report-header-bg-color);\n      border-top: 1px solid var(--report-secondary-border-color);\n      border-bottom: 1px solid var(--report-secondary-border-color);\n    }\n    .lh-env__title {\n      font-size: var(--header-font-size);\n    }\n    .lh-env__items {\n      margin: var(--default-padding) 0 0 0;\n    }\n    .lh-config__timestamp {\n      margin-right: 6px;\n    }\n    .lh-config__settings-toggle {\n      margin-left: 6px;\n    }\n    .lh-config__timestamp,\n    .lh-config__settings-toggle summary {\n      color: var(--secondary-text-color);\n    }\n    .lh-config__settings-toggle summary {\n      display: flex;\n      align-items: center;\n    }\n    .lh-config__settings-toggle .lh-toggle-arrow {\n      width: 16px;\n      height: 16px;\n      margin-left: 2px;\n    }\n    .lh-config__settings-toggle[open] .lh-toggle-arrow {\n      transform: rotateZ(90deg);\n    }\n    .lh-config__settings-toggle summary::-moz-list-bullet {\n      display: none;\n    }\n    .lh-config__settings-toggle summary::-webkit-details-marker {\n      display: none;\n    }\n    @media screen and (min-width: 965px) {\n      .lh-header {\n        width: var(--report-width);\n        right: initial;\n        left: initial;\n      }\n    }\n    @media screen and (max-width: 964px) {\n      .lh-export__dropdown {\n        right: 0;\n        left: initial;\n      }\n      .lh-header {\n        padding: 0 var(--default-padding);\n        margin-left: 0;\n      }\n    }\n    @media print {\n      .lh-header {\n        position: static;\n        margin-left: 0;\n      }\n    }\n  </style>\n  <div class=\"lh-header\">\n    <div class=\"lh-metadata\">\n      <div class=\"lh-metadata__results\">Results for: <a href=\"\" class=\"lh-metadata__url\" target=\"_blank\" rel=\"noopener\"><!-- fill me --></a></div>\n      <div class=\"lh-config\">\n        <span class=\"lh-config__timestamp\"><!-- fill me --></span> &bullet;\n        <details class=\"lh-config__settings-toggle\">\n          <summary>\n            <span>Runtime settings</span>\n            <span class=\"lh-toggle-arrow\" title=\"See report's runtime settings\"></span>\n          </summary>\n          <div class=\"lh-env\">\n            <div class=\"lh-env__title\">Runtime environment</div>\n            <ul class=\"lh-env__items\">\n              <li class=\"lh-env__item\">\n                <span class=\"lh-env__name\">User agent:</span>\n                <b class=\"lh-env__item__ua\"><!-- fill me --></b>\n              </li>\n              <template id=\"tmpl-lh-env__items\">\n                <li class=\"lh-env__item\">\n                  <span class=\"lh-env__name\"><!-- fill me --></span>\n                  <span class=\"lh-env__description\"><!-- fill me --></span>:\n                  <b class=\"lh-env__enabled\"><!-- fill me --></b>\n                </li>\n              </template>\n            </ul>\n          </div>\n        </details>\n      </div>\n    </div>\n    <div class=\"lh-export\">\n      <button class=\"report-icon report-icon--share lh-export__button\" title=\"Export report\"></button>\n      <div class=\"lh-export__dropdown\">\n        <a href=\"#\" class=\"report-icon report-icon--print\" data-action=\"print\">Print...</a>\n        <a href=\"#\" class=\"report-icon report-icon--copy\" data-action=\"copy\">Copy JSON</a>\n        <a href=\"#\" class=\"report-icon report-icon--download\" data-action=\"save-html\">Save as HTML</a>\n        <a href=\"#\" class=\"report-icon report-icon--download\" data-action=\"save-json\">Save as JSON</a>\n        <a href=\"#\" class=\"report-icon report-icon--open lh-export--viewer\" data-action=\"open-viewer\">Open in Viewer</a>\n        <a href=\"#\" class=\"report-icon report-icon--open lh-export--gist\" data-action=\"save-gist\">Save as Gist</a>\n      </div>\n    </div>\n  </div>\n</template>\n\n<!-- Lighthouse footer -->\n<template id=\"tmpl-lh-footer\">\n  <style>\n    .lh-footer {\n      min-height: 90px;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      background-color: var(--report-header-bg-color);\n      border-top: 1px solid var(--report-secondary-border-color);\n    }\n\n    .lh-footer span {\n      text-align: center;\n    }\n  </style>\n  <footer class=\"lh-footer\">\n    <span>\n      Generated by <b>Lighthouse</b> <span class=\"lh-footer__version\"><!-- fill me --></span> on\n      <span class=\"lh-footer__timestamp\"><!-- fill me --></span> |\n      <a href=\"https://github.com/GoogleChrome/Lighthouse/issues\" target=\"_blank\" rel=\"noopener\">File an issue</a>\n    </span>\n  </footer>\n</template>\n\n<!-- Lighthouse score gauge -->\n<template id=\"tmpl-lh-gauge\">\n  <style>\n    .lh-gauge {\n      --circle-size: calc(2.5 * var(--header-font-size));\n      --circle-size-half: calc(var(--circle-size) / 2);\n      --circle-background: #ccc;\n      --circle-border-width: 2px;\n      --inset-size: calc(var(--circle-size) - 2 * var(--circle-border-width));\n      --inset-color: #fff;\n      --transition-length: 1s;\n      width: var(--circle-size);\n      height: var(--circle-size);\n      background-color: var(--circle-background);\n      border-radius: 50%;\n    }\n    .lh-gauge--pass {\n      --circle-color: var(--pass-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge--average {\n      --circle-color: var(--average-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge--fail {\n      --circle-color: var(--fail-color);\n      color: var(--circle-color);\n    }\n    .lh-gauge__mask,\n    .lh-gauge__fill {\n      width: var(--circle-size);\n      height: var(--circle-size);\n      position: absolute;\n      transition: transform var(--transition-length);\n      border-radius: 50%;\n    }\n    .lh-gauge__mask {\n      clip: rect(0px, var(--circle-size), var(--circle-size), var(--circle-size-half));\n    }\n    .lh-gauge__mask .lh-gauge__fill {\n      clip: rect(0px, var(--circle-size-half), var(--circle-size), 0px);\n      background-color: var(--circle-color);\n      backface-visibility: hidden;\n    }\n    .lh-gauge__percentage {\n      --spacer: calc((var(--circle-size) - var(--inset-size)) / 2);\n      width: var(--inset-size);\n      height: var(--inset-size);\n      position: absolute;\n      margin-left: var(--spacer);\n      margin-top: var(--spacer);\n      background-color: var(--inset-color);\n      border-radius: inherit;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      font-size: var(--header-font-size);\n    }\n    .lh-gauge__wrapper {\n      display: inline-flex;\n      align-items: center;\n      flex-direction: column;\n      text-decoration: none;\n      color: inherit;\n      flex: 1;\n      min-width: auto;\n      position: relative;\n    }\n    .lh-scores-header .lh-gauge__wrapper {\n      width: calc(10.5 * var(--body-font-size));\n    }\n    .lh-gauge__label {\n      font-size: var(--body-font-size);\n      line-height: var(--body-line-height);\n      margin-top: calc(0.5 * var(--body-line-height));\n    }\n  </style>\n  <a href=\"#\" class=\"lh-gauge__wrapper\">\n    <div class=\"lh-gauge\" data-progress=\"0\">\n      <div class=\"lh-gauge__circle\">\n        <div class=\"lh-gauge__mask lh-gauge__mask--full\">\n          <div class=\"lh-gauge__fill\"></div>\n        </div>\n        <div class=\"lh-gauge__mask lh-gauge__mask--half\">\n          <div class=\"lh-gauge__fill\"></div>\n          <div class=\"lh-gauge__fill lh-gauge__fill--fix\"></div>\n        </div>\n      </div>\n      <div class=\"lh-gauge__percentage\"></div>\n    </div>\n    <div class=\"lh-gauge__label\"><!-- fill me --></div>\n  </a>\n</template>\n\n<!-- Lighthouse crtiical request chains component -->\n<template id=\"tmpl-lh-crc\">\n  <style>\n    .lh-crc .tree-marker {\n      width: 12px;\n      height: 26px;\n      display: block;\n      float: left;\n      background-position: top left;\n    }\n    .lh-crc .horiz-down {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><g fill=\"#D8D8D8\" fill-rule=\"evenodd\"><path d=\"M16 12v2H-2v-2z\"/><path d=\"M9 12v14H7V12z\"/></g></svg>');\n    }\n    .lh-crc .right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M16 12v2H0v-2z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .up-right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v14H7zm2 12h7v2H9z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .vert-right {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v27H7zm2 12h7v2H9z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .vert {\n      background: url('data:image/svg+xml;utf8,<svg width=\"16\" height=\"26\" viewBox=\"0 0 16 26\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 0h2v26H7z\" fill=\"#D8D8D8\" fill-rule=\"evenodd\"/></svg>');\n    }\n    .lh-crc .crc-tree {\n      font-size: 14px;\n      width: 100%;\n      overflow-x: auto;\n    }\n    .lh-crc .crc-node {\n      height: 26px;\n      line-height: 26px;\n      white-space: nowrap;\n    }\n    .lh-crc .crc-node__tree-value {\n      margin-left: 10px;\n    }\n    .lh-crc .crc-node__chain-duration {\n      font-weight: 700;\n    }\n    .lh-crc .crc-node__tree-hostname {\n      color: #595959;\n    }\n    .lh-crc .crc-initial-nav {\n      color: #595959;\n      font-style: italic;\n    }\n  </style>\n  <div class=\"lh-score__description\">\n    Longest chain: <b class=\"lh-crc__longest_duration\"><!-- fill me: longestChain.duration --></b>\n    over <b class=\"lh-crc__longest_length\"><!-- fill me: longestChain.length --></b> requests, totalling\n    <b class=\"lh-crc__longest_transfersize\"><!-- fill me: longestChain.length --></b>\n  </div>\n  <div class=\"lh-crc\">\n    <details class=\"lh-details\">\n      <summary><!-- fill me --></summary>\n      <div class=\"crc-initial-nav\">Initial Navigation</div>\n      <!-- stamp for each chain -->\n      <template id=\"tmpl-lh-crc__chains\">\n        <div class=\"crc-node\">\n          <span class=\"crc-node__tree-marker\">\n            <!-- fill me -->\n          </span>\n          <span class=\"crc-node__tree-value\">\n            <span class=\"crc-node__tree-file\"><!-- fill me: node.request.url.file --></span>\n            <span class=\"crc-node__tree-hostname\">(<!-- fill me: node.request.url.host -->)</span>\n            <!-- fill me -->\n          </span>\n        </div>\n      </template>\n    </details>\n  </div>\n</template>\n\n/*# sourceURL=audits2/lighthouse/templates.html */";