require=function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a;}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r);},p,p.exports,r,e,n,t);}return n[i].exports;}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o;}return r;}()({"../audits/accessibility/accesskeys":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Accesskeys extends AxeAudit{static get meta(){return{id:'accesskeys',title:'`[accesskey]` values are unique',failureTitle:'`[accesskey]` values are not unique',description:'Access keys let users quickly focus a part of the page. For proper '+'navigation, each access key must be unique. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/accesskeys?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=Accesskeys;},{"./axe-audit":1}],"../audits/accessibility/aria-allowed-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAAllowedAttr extends AxeAudit{static get meta(){return{id:'aria-allowed-attr',title:'`[aria-*]` attributes match their roles',failureTitle:'`[aria-*]` attributes do not match their roles',description:'Each ARIA `role` supports a specific subset of `aria-*` attributes. '+'Mismatching these invalidates the `aria-*` attributes. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-allowed-attr?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAAllowedAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-required-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIARequiredAttr extends AxeAudit{static get meta(){return{id:'aria-required-attr',title:'`[role]`s have all required `[aria-*]` attributes',failureTitle:'`[role]`s do not have all required `[aria-*]` attributes',description:'Some ARIA roles have required attributes that describe the state '+'of the element to screen readers. [Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-attr?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIARequiredAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-required-children":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRequiredChildren extends AxeAudit{static get meta(){return{id:'aria-required-children',title:'Elements with `[role]` that require specific children `[role]`s, are present',failureTitle:'Elements with `[role]` that require specific children `[role]`s, '+'are missing.',description:'Some ARIA parent roles must contain specific child roles to perform '+'their intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-children?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRequiredChildren;},{"./axe-audit":1}],"../audits/accessibility/aria-required-parent":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRequiredParent extends AxeAudit{static get meta(){return{id:'aria-required-parent',title:'`[role]`s are contained by their required parent element',failureTitle:'`[role]`s are not contained by their required parent element',description:'Some ARIA child roles must be contained by specific parent roles to '+'properly perform their intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-required-parent?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRequiredParent;},{"./axe-audit":1}],"../audits/accessibility/aria-roles":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AriaRoles extends AxeAudit{static get meta(){return{id:'aria-roles',title:'`[role]` values are valid',failureTitle:'`[role]` values are not valid',description:'ARIA roles must have valid values in order to perform their '+'intended accessibility functions. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/aria-roles?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=AriaRoles;},{"./axe-audit":1}],"../audits/accessibility/aria-valid-attr-value":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{id:'aria-valid-attr-value',title:'`[aria-*]` attributes have valid values',failureTitle:'`[aria-*]` attributes do not have valid values',description:'Assistive technologies, like screen readers, can\'t interpret ARIA '+'attributes with invalid values. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-valid-attr-value?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":1}],"../audits/accessibility/aria-valid-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ARIAValidAttr extends AxeAudit{static get meta(){return{id:'aria-valid-attr',title:'`[aria-*]` attributes are valid and not misspelled',failureTitle:'`[aria-*]` attributes are not valid or misspelled',description:'Assistive technologies, like screen readers, can\'t interpret ARIA '+'attributes with invalid names. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/aria-valid-attr?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ARIAValidAttr;},{"./axe-audit":1}],"../audits/accessibility/audio-caption":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class AudioCaption extends AxeAudit{static get meta(){return{id:'audio-caption',title:'`<audio>` elements contain a `<track>` element with `[kind="captions"]`',failureTitle:'`<audio>` elements are missing a `<track>` element with '+'`[kind="captions"]`.',description:'Captions make audio elements usable for deaf or hearing-impaired users, '+'providing critical information such as who is talking, what they\'re saying, '+'and other non-speech information. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/audio-caption?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=AudioCaption;},{"./axe-audit":1}],"../audits/accessibility/button-name":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ButtonName extends AxeAudit{static get meta(){return{id:'button-name',title:'Buttons have an accessible name',failureTitle:'Buttons do not have an accessible name',description:'When a button doesn\'t have an accessible name, screen readers announce it '+'as "button", making it unusable for users who rely on screen readers. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/button-name?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ButtonName;},{"./axe-audit":1}],"../audits/accessibility/bypass":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Bypass extends AxeAudit{static get meta(){return{id:'bypass',title:'The page contains a heading, skip link, or landmark region',failureTitle:'The page does not contain a heading, skip link, or landmark region',description:'Adding ways to bypass repetitive content lets keyboard users navigate the '+'page more efficiently. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/bypass?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=Bypass;},{"./axe-audit":1}],"../audits/accessibility/color-contrast":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ColorContrast extends AxeAudit{static get meta(){return{id:'color-contrast',title:'Background and foreground colors have a sufficient contrast ratio',failureTitle:'Background and foreground colors do not have a '+'sufficient contrast ratio.',description:'Low-contrast text is difficult or impossible for many users to read. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/color-contrast?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ColorContrast;},{"./axe-audit":1}],"../audits/accessibility/definition-list":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DefinitionList extends AxeAudit{static get meta(){return{id:'definition-list',title:'`<dl>`\'s contain only properly-ordered `<dt>` and `<dd>` groups, `<script>` '+'or `<template>` elements.',failureTitle:'`<dl>`\'s do not contain only properly-ordered `<dt>` and `<dd>` '+'groups, `<script>` or `<template>` elements.',description:'When definition lists are not properly marked up, screen readers may produce '+'confusing or inaccurate output. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/definition-list?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=DefinitionList;},{"./axe-audit":1}],"../audits/accessibility/dlitem":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DLItem extends AxeAudit{static get meta(){return{id:'dlitem',title:'Definition list items are wrapped in `<dl>` elements',failureTitle:'Definition list items are not wrapped in `<dl>` elements',description:'Definition list items (`<dt>` and `<dd>`) must be wrapped in a '+'parent `<dl>` element to ensure that screen readers can properly announce them. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/dlitem?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=DLItem;},{"./axe-audit":1}],"../audits/accessibility/document-title":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DocumentTitle extends AxeAudit{static get meta(){return{id:'document-title',title:'Document has a `<title>` element',failureTitle:'Document doesn\'t have a `<title>` element',description:'The title gives screen reader users an overview of the page, and search '+'engine users rely on it heavily to determine if a page is relevant to their search. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/title).',requiredArtifacts:['Accessibility']};}}
module.exports=DocumentTitle;},{"./axe-audit":1}],"../audits/accessibility/duplicate-id":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class DuplicateId extends AxeAudit{static get meta(){return{id:'duplicate-id',title:'`[id]` attributes on the page are unique',failureTitle:'`[id]` attributes on the page are not unique',description:'The value of an id attribute must be unique to prevent '+'other instances from being overlooked by assistive technologies. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/duplicate-id?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=DuplicateId;},{"./axe-audit":1}],"../audits/accessibility/frame-title":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class FrameTitle extends AxeAudit{static get meta(){return{id:'frame-title',title:'`<frame>` or `<iframe>` elements have a title',failureTitle:'`<frame>` or `<iframe>` elements do not have a title',description:'Screen reader users rely on frame titles to describe the contents of frames. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/frame-title?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=FrameTitle;},{"./axe-audit":1}],"../audits/accessibility/html-has-lang":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class HTMLHasLang extends AxeAudit{static get meta(){return{id:'html-has-lang',title:'`<html>` element has a `[lang]` attribute',failureTitle:'`<html>` element does not have a `[lang]` attribute',description:'If a page doesn\'t specify a lang attribute, a screen reader assumes '+'that the page is in the default language that the user chose when setting up the '+'screen reader. If the page isn\'t actually in the default language, then the screen '+'reader might not announce the page\'s text correctly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/html-lang?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=HTMLHasLang;},{"./axe-audit":1}],"../audits/accessibility/html-lang-valid":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class HTMLLangValid extends AxeAudit{static get meta(){return{id:'html-lang-valid',title:'`<html>` element has a valid value for its `[lang]` attribute',failureTitle:'`<html>` element does not have a valid value for '+'its `[lang]` attribute.',description:'Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) '+'helps screen readers announce text properly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/valid-lang?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=HTMLLangValid;},{"./axe-audit":1}],"../audits/accessibility/image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ImageAlt extends AxeAudit{static get meta(){return{id:'image-alt',title:'Image elements have `[alt]` attributes',failureTitle:'Image elements do not have `[alt]` attributes',description:'Informative elements should aim for short, descriptive alternate text. '+'Decorative elements can be ignored with an empty alt attribute. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/image-alt?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ImageAlt;},{"./axe-audit":1}],"../audits/accessibility/input-image-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class InputImageAlt extends AxeAudit{static get meta(){return{id:'input-image-alt',title:'`<input type="image">` elements have `[alt]` text',failureTitle:'`<input type="image">` elements do not have `[alt]` text',description:'When an image is being used as an `<input>` button, providing alternative '+'text can help screen reader users understand the purpose of the button. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/input-image-alt?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=InputImageAlt;},{"./axe-audit":1}],"../audits/accessibility/label":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class Label extends AxeAudit{static get meta(){return{id:'label',title:'Form elements have associated labels',failureTitle:'Form elements do not have associated labels',description:'Labels ensure that form controls are announced properly by assistive '+'technologies, like screen readers. [Learn '+'more](https://dequeuniversity.com/rules/axe/2.2/label?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=Label;},{"./axe-audit":1}],"../audits/accessibility/layout-table":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class LayoutTable extends AxeAudit{static get meta(){return{id:'layout-table',title:'Presentational `<table>` elements avoid using `<th>`, `<caption>` or the '+'`[summary]` attribute.',failureTitle:'Presentational `<table>` elements do not avoid using `<th>`, '+'`<caption>` or the `[summary]` attribute.',description:'A table being used for layout purposes should not include data elements, '+'such as the th or caption elements or the summary attribute, because this can '+'create a confusing experience for screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/layout-table?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=LayoutTable;},{"./axe-audit":1}],"../audits/accessibility/link-name":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class LinkName extends AxeAudit{static get meta(){return{id:'link-name',title:'Links have a discernible name',failureTitle:'Links do not have a discernible name',description:'Link text (and alternate text for images, when used as links) that is '+'discernible, unique, and focusable improves the navigation experience for '+'screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/link-name?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=LinkName;},{"./axe-audit":1}],"../audits/accessibility/listitem":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ListItem extends AxeAudit{static get meta(){return{id:'listitem',title:'List items (`<li>`) are contained within `<ul>` or `<ol>` parent elements',failureTitle:'List items (`<li>`) are not contained within `<ul>` '+'or `<ol>` parent elements.',description:'Screen readers require list items (`<li>`) to be contained within a '+'parent `<ul>` or `<ol>` to be announced properly. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/listitem?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ListItem;},{"./axe-audit":1}],"../audits/accessibility/list":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class List extends AxeAudit{static get meta(){return{id:'list',title:'Lists contain only `<li>` elements and script supporting elements '+'(`<script>` and `<template>`).',failureTitle:'Lists do not contain only `<li>` elements and script '+'supporting elements (`<script>` and `<template>`).',description:'Screen readers have a specific way of announcing lists. Ensuring proper list '+'structure aids screen reader output. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/list?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=List;},{"./axe-audit":1}],"../audits/accessibility/manual/custom-controls-labels":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class CustomControlsLabels extends ManualAudit{static get meta(){return Object.assign({id:'custom-controls-labels',description:'Custom interactive controls have associated labels, provided by aria-label or aria-labelledby. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#try_it_with_a_screen_reader).',title:'Custom controls have associated labels'},super.partialMeta);}}
module.exports=CustomControlsLabels;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/custom-controls-roles":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class CustomControlsRoles extends ManualAudit{static get meta(){return Object.assign({id:'custom-controls-roles',description:'Custom interactive controls have appropriate ARIA roles. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#try_it_with_a_screen_reader).',title:'Custom controls have ARIA roles'},super.partialMeta);}}
module.exports=CustomControlsRoles;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/focus-traps":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class FocusTraps extends ManualAudit{static get meta(){return Object.assign({id:'focus-traps',description:'A user can tab into and out of any control or region without accidentally trapping their focus. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#start_with_the_keyboard).',title:'User focus is not accidentally trapped in a region'},super.partialMeta);}}
module.exports=FocusTraps;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/focusable-controls":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class FocusableControls extends ManualAudit{static get meta(){return Object.assign({id:'focusable-controls',description:'Custom interactive controls are keyboard focusable and display a focus indicator. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#start_with_the_keyboard).',title:'Interactive controls are keyboard focusable'},super.partialMeta);}}
module.exports=FocusableControls;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/heading-levels":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class HeadingLevels extends ManualAudit{static get meta(){return Object.assign({id:'heading-levels',description:'Headings are used to create an outline for the page and heading levels are not skipped. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#take_advantage_of_headings_and_landmarks).',title:'Headings don\'t skip levels'},super.partialMeta);}}
module.exports=HeadingLevels;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/interactive-element-affordance":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class InteractiveElementAffordance extends ManualAudit{static get meta(){return Object.assign({id:'interactive-element-affordance',description:'Interactive elements, such as links and buttons, should indicate their state and be distinguishable from non-interactive elements. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#interactive_elements_like_links_and_buttons_should_indicate_their_purpose_and_state).',title:'Interactive elements indicate their purpose and state'},super.partialMeta);}}
module.exports=InteractiveElementAffordance;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/logical-tab-order":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class LogicalTabOrder extends ManualAudit{static get meta(){return Object.assign({id:'logical-tab-order',description:'Tabbing through the page follows the visual layout. Users cannot focus elements that are offscreen. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#start_with_the_keyboard).',title:'The page has a logical tab order'},super.partialMeta);}}
module.exports=LogicalTabOrder;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/managed-focus":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class ManagedFocus extends ManualAudit{static get meta(){return Object.assign({id:'managed-focus',description:'If new content, such as a dialog, is added to the page, the user\'s focus is directed to it. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#start_with_the_keyboard).',title:'The user\'s focus is directed to new content added to the page'},super.partialMeta);}}
module.exports=ManagedFocus;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/offscreen-content-hidden":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class OffscreenContentHidden extends ManualAudit{static get meta(){return Object.assign({id:'offscreen-content-hidden',description:'Offscreen content is hidden with display: none or aria-hidden=true. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#try_it_with_a_screen_reader).',title:'Offscreen content is hidden from assistive technology'},super.partialMeta);}}
module.exports=OffscreenContentHidden;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/use-landmarks":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class UseLandmarks extends ManualAudit{static get meta(){return Object.assign({id:'use-landmarks',description:'Landmark elements (<main>, <nav>, etc.) are used to improve the keyboard navigation of the page for assistive technology. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#take_advantage_of_headings_and_landmarks).',title:'HTML5 landmark elements are used to improve navigation'},super.partialMeta);}}
module.exports=UseLandmarks;},{"../../manual/manual-audit":4}],"../audits/accessibility/manual/visual-order-follows-dom":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class VisualOrderFollowsDOM extends ManualAudit{static get meta(){return Object.assign({id:'visual-order-follows-dom',description:'DOM order matches the visual order, improving navigation for assistive technology. [Learn more](https://developers.google.com/web/fundamentals/accessibility/how-to-review#try_it_with_a_screen_reader).',title:'Visual order on the page follows DOM order'},super.partialMeta);}}
module.exports=VisualOrderFollowsDOM;},{"../../manual/manual-audit":4}],"../audits/accessibility/meta-refresh":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class MetaRefresh extends AxeAudit{static get meta(){return{id:'meta-refresh',title:'The document does not use `<meta http-equiv="refresh">`',failureTitle:'The document uses `<meta http-equiv="refresh">`',description:'Users do not expect a page to refresh automatically, and doing so will move '+'focus back to the top of the page. This may create a frustrating or '+'confusing experience. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/meta-refresh?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=MetaRefresh;},{"./axe-audit":1}],"../audits/accessibility/meta-viewport":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class MetaViewport extends AxeAudit{static get meta(){return{id:'meta-viewport',title:'`[user-scalable="no"]` is not used in the `<meta name="viewport">` '+'element and the `[maximum-scale]` attribute is not less than 5.',failureTitle:'`[user-scalable="no"]` is used in the `<meta name="viewport">` '+'element or the `[maximum-scale]` attribute is less than 5.',description:'Disabling zooming is problematic for users with low vision who rely on '+'screen magnification to properly see the contents of a web page. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/meta-viewport?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=MetaViewport;},{"./axe-audit":1}],"../audits/accessibility/object-alt":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ObjectAlt extends AxeAudit{static get meta(){return{id:'object-alt',title:'`<object>` elements have `[alt]` text',failureTitle:'`<object>` elements do not have `[alt]` text',description:'Screen readers cannot translate non-text content. Adding alt text to '+'`<object>` elements helps screen readers convey meaning to users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/object-alt?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ObjectAlt;},{"./axe-audit":1}],"../audits/accessibility/tabindex":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TabIndex extends AxeAudit{static get meta(){return{id:'tabindex',title:'No element has a `[tabindex]` value greater than 0',failureTitle:'Some elements have a `[tabindex]` value greater than 0',description:'A value greater than 0 implies an explicit navigation ordering. '+'Although technically valid, this often creates frustrating experiences '+'for users who rely on assistive technologies. [Learn more](https://dequeuniversity.com/rules/axe/2.2/tabindex?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=TabIndex;},{"./axe-audit":1}],"../audits/accessibility/td-headers-attr":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class TDHeadersAttr extends AxeAudit{static get meta(){return{id:'td-headers-attr',title:'Cells in a `<table>` element that use the `[headers]` attribute only refer '+'to other cells of that same table.',failureTitle:'Cells in a `<table>` element that use the `[headers]` '+'attribute refers to other cells of that same table.',description:'Screen readers have features to make navigating tables easier. Ensuring '+'`<td>` cells using the `[headers]` attribute only refer to other cells in the same '+'table may improve the experience for screen reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/td-headers-attr?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=TDHeadersAttr;},{"./axe-audit":1}],"../audits/accessibility/th-has-data-cells":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class THHasDataCells extends AxeAudit{static get meta(){return{id:'th-has-data-cells',title:'`<th>` elements and elements with `[role="columnheader"/"rowheader"]` have '+'data cells they describe.',failureTitle:'`<th>` elements and elements with '+'`[role="columnheader"/"rowheader"]` do not have data cells they describe.',description:'Screen readers have features to make navigating tables easier. Ensuring '+'table headers always refer to some set of cells may improve the experience for screen '+'reader users. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/th-has-data-cells?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=THHasDataCells;},{"./axe-audit":1}],"../audits/accessibility/valid-lang":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class ValidLang extends AxeAudit{static get meta(){return{id:'valid-lang',title:'`[lang]` attributes have a valid value',failureTitle:'`[lang]` attributes do not have a valid value',description:'Specifying a valid [BCP 47 language](https://www.w3.org/International/questions/qa-choosing-language-tags#question) '+'on elements helps ensure that text is pronounced correctly by a screen reader. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/valid-lang?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=ValidLang;},{"./axe-audit":1}],"../audits/accessibility/video-caption":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class VideoCaption extends AxeAudit{static get meta(){return{id:'video-caption',title:'`<video>` elements contain a `<track>` element with `[kind="captions"]`',failureTitle:'`<video>` elements do not contain a `<track>` element '+'with `[kind="captions"]`.',description:'When a video provides a caption it is easier for deaf and hearing impaired '+'users to access its information. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/video-caption?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=VideoCaption;},{"./axe-audit":1}],"../audits/accessibility/video-description":[function(require,module,exports){'use strict';const AxeAudit=require('./axe-audit');class VideoDescription extends AxeAudit{static get meta(){return{id:'video-description',title:'`<video>` elements contain a `<track>` element with `[kind="description"]`',failureTitle:'`<video>` elements do not contain a `<track>` element with '+'`[kind="description"]`.',description:'Audio descriptions provide relevant information for videos that dialogue '+'cannot, such as facial expressions and scenes. '+'[Learn more](https://dequeuniversity.com/rules/axe/2.2/video-description?application=lighthouse).',requiredArtifacts:['Accessibility']};}}
module.exports=VideoDescription;},{"./axe-audit":1}],"../audits/bootup-time":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('./audit');const NetworkRequest=require('../lib/network-request');const{taskGroups}=require('../lib/task-groups');const i18n=require('../lib/i18n/i18n.js');const UIStrings={title:'JavaScript execution time',failureTitle:'Reduce JavaScript execution time',description:'Consider reducing the time spent parsing, compiling, and executing JS. '+'You may find delivering smaller JS payloads helps with this. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/bootup).',columnTotal:'Total',columnScriptEval:'Script Evaluation',columnScriptParse:'Script Parse',chromeExtensionsWarning:'Chrome extensions negatively affected this page\'s load performance. '+'Try auditing the page in incognito mode or from a Chrome profile without extensions.'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class BootupTime extends Audit{static get meta(){return{id:'bootup-time',title:str_(UIStrings.title),failureTitle:str_(UIStrings.failureTitle),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:600,scoreMedian:3500,thresholdInMs:50};}
static getJavaScriptURLs(records){const urls=new Set();for(const record of records){if(record.resourceType===NetworkRequest.TYPES.Script){urls.add(record.url);}}
return urls;}
static getExecutionTimingsByURL(tasks,jsURLs){const result=new Map();for(const task of tasks){const jsURL=task.attributableURLs.find(url=>jsURLs.has(url));const fallbackURL=task.attributableURLs[0];const attributableURL=jsURL||fallbackURL;if(!attributableURL||attributableURL==='about:blank')continue;const timingByGroupId=result.get(attributableURL)||{};const originalTime=timingByGroupId[task.group.id]||0;timingByGroupId[task.group.id]=originalTime+task.selfTime;result.set(attributableURL,timingByGroupId);}
return result;}
static async audit(artifacts,context){const settings=context.settings||{};const trace=artifacts.traces[BootupTime.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[BootupTime.DEFAULT_PASS];const networkRecords=await artifacts.requestNetworkRecords(devtoolsLog);const tasks=await artifacts.requestMainThreadTasks(trace);const multiplier=settings.throttlingMethod==='simulate'?settings.throttling.cpuSlowdownMultiplier:1;const jsURLs=BootupTime.getJavaScriptURLs(networkRecords);const executionTimings=BootupTime.getExecutionTimingsByURL(tasks,jsURLs);let hadExcessiveChromeExtension=false;let totalBootupTime=0;const results=Array.from(executionTimings).map(([url,timingByGroupId])=>{let bootupTimeForURL=0;for(const[groupId,timespanMs]of Object.entries(timingByGroupId)){timingByGroupId[groupId]=timespanMs*multiplier;bootupTimeForURL+=timespanMs*multiplier;}
if(bootupTimeForURL>=context.options.thresholdInMs){totalBootupTime+=bootupTimeForURL;}
const scriptingTotal=timingByGroupId[taskGroups.scriptEvaluation.id]||0;const parseCompileTotal=timingByGroupId[taskGroups.scriptParseCompile.id]||0;hadExcessiveChromeExtension=hadExcessiveChromeExtension||url.startsWith('chrome-extension:')&&scriptingTotal>100;return{url:url,total:bootupTimeForURL,scripting:scriptingTotal,scriptParseCompile:parseCompileTotal};}).filter(result=>result.total>=context.options.thresholdInMs).sort((a,b)=>b.total-a.total);if(hadExcessiveChromeExtension){context.LighthouseRunWarnings.push(str_(UIStrings.chromeExtensionsWarning));}
const summary={wastedMs:totalBootupTime};const headings=[{key:'url',itemType:'url',text:str_(i18n.UIStrings.columnURL)},{key:'total',granularity:1,itemType:'ms',text:str_(UIStrings.columnTotal)},{key:'scripting',granularity:1,itemType:'ms',text:str_(UIStrings.columnScriptEval)},{key:'scriptParseCompile',granularity:1,itemType:'ms',text:str_(UIStrings.columnScriptParse)}];const details=BootupTime.makeTableDetails(headings,results,summary);const score=Audit.computeLogNormalScore(totalBootupTime,context.options.scorePODR,context.options.scoreMedian);return{score,rawValue:totalBootupTime,displayValue:totalBootupTime>0?str_(i18n.UIStrings.seconds,{timeInMs:totalBootupTime}):'',details};}}
module.exports=BootupTime;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/bootup-time.js");},{"../lib/i18n/i18n.js":36,"../lib/network-request":88,"../lib/task-groups":93,"./audit":2}],"../audits/byte-efficiency/efficient-animated-content":[function(require,module,exports){(function(__filename){'use strict';const NetworkRequest=require('../../lib/network-request');const ByteEfficiencyAudit=require('./byte-efficiency-audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Use video formats for animated content',description:'Large GIFs are inefficient for delivering animated content. Consider using '+'MPEG4/WebM videos for animations and PNG/WebP for static images instead of GIF to save '+'network bytes. [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const GIF_BYTE_THRESHOLD=100*1024;class EfficientAnimatedContent extends ByteEfficiencyAudit{static get meta(){return{id:'efficient-animated-content',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['devtoolsLogs','traces']};}
static getPercentSavings(bytes){return Math.round(29.1*Math.log10(bytes)-100.7)/100;}
static audit_(artifacts,networkRecords){const unoptimizedContent=networkRecords.filter(record=>record.mimeType==='image/gif'&&record.resourceType===NetworkRequest.TYPES.Image&&(record.resourceSize||0)>GIF_BYTE_THRESHOLD);const items=unoptimizedContent.map(record=>{const resourceSize=record.resourceSize||0;return{url:record.url,totalBytes:resourceSize,wastedBytes:Math.round(resourceSize*EfficientAnimatedContent.getPercentSavings(resourceSize))};});const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{items,headings};}}
module.exports=EfficientAnimatedContent;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/efficient-animated-content.js");},{"../../lib/i18n/i18n.js":36,"../../lib/network-request":88,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/offscreen-images":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const Sentry=require('../../lib/sentry');const URL=require('../../lib/url-shim');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Defer offscreen images',description:'Consider lazy-loading offscreen and hidden images after all critical resources have '+'finished loading to lower time to interactive. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const ALLOWABLE_OFFSCREEN_X=100;const ALLOWABLE_OFFSCREEN_Y=200;const IGNORE_THRESHOLD_IN_BYTES=2048;const IGNORE_THRESHOLD_IN_PERCENT=75;const IGNORE_THRESHOLD_IN_MS=50;class OffscreenImages extends ByteEfficiencyAudit{static get meta(){return{id:'offscreen-images',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['ImageUsage','ViewportDimensions','devtoolsLogs','traces']};}
static computeVisiblePixels(imageRect,viewportDimensions){const innerWidth=viewportDimensions.innerWidth;const innerHeight=viewportDimensions.innerHeight;const top=Math.max(imageRect.top,-1*ALLOWABLE_OFFSCREEN_Y);const right=Math.min(imageRect.right,innerWidth+ALLOWABLE_OFFSCREEN_X);const bottom=Math.min(imageRect.bottom,innerHeight+ALLOWABLE_OFFSCREEN_Y);const left=Math.max(imageRect.left,-1*ALLOWABLE_OFFSCREEN_X);return Math.max(right-left,0)*Math.max(bottom-top,0);}
static computeWaste(image,viewportDimensions){if(!image.networkRecord){return null;}
const url=URL.elideDataURI(image.src);const totalPixels=image.clientWidth*image.clientHeight;const visiblePixels=this.computeVisiblePixels(image.clientRect,viewportDimensions);const wastedRatio=totalPixels===0?1:1-visiblePixels/totalPixels;const totalBytes=image.networkRecord.resourceSize;const wastedBytes=Math.round(totalBytes*wastedRatio);if(!Number.isFinite(wastedRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,requestStartTime:image.networkRecord.startTime,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static filterLanternResults(images,lanternMetricData){const nodeTimings=lanternMetricData.pessimisticEstimate.nodeTimings;let lastLongTaskStartTime=0;const startTimesByURL=new Map();for(const[node,timing]of nodeTimings){if(node.type==='cpu'&&timing.duration>=50){lastLongTaskStartTime=Math.max(lastLongTaskStartTime,timing.startTime);}else if(node.type==='network'){const networkNode=node;startTimesByURL.set(networkNode.record.url,timing.startTime);}}
return images.filter(image=>{if(image.wastedBytes<IGNORE_THRESHOLD_IN_BYTES)return false;if(image.wastedPercent<IGNORE_THRESHOLD_IN_PERCENT)return false;const imageRequestStartTime=startTimesByURL.get(image.url)||0;return imageRequestStartTime<lastLongTaskStartTime-IGNORE_THRESHOLD_IN_MS;});}
static filterObservedResults(images,interactiveTimestamp){return images.filter(image=>{if(image.wastedBytes<IGNORE_THRESHOLD_IN_BYTES)return false;if(image.wastedPercent<IGNORE_THRESHOLD_IN_PERCENT)return false;return image.requestStartTime<interactiveTimestamp/1e6-IGNORE_THRESHOLD_IN_MS/1000;});}
static computeWasteWithTTIGraph(results,graph,simulator){return super.computeWasteWithTTIGraph(results,graph,simulator,{includeLoad:false});}
static audit_(artifacts,networkRecords,context){const images=artifacts.ImageUsage;const viewportDimensions=artifacts.ViewportDimensions;const trace=artifacts.traces[ByteEfficiencyAudit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];const warnings=[];const resultsMap=images.reduce((results,image)=>{const processed=OffscreenImages.computeWaste(image,viewportDimensions);if(processed===null){return results;}
if(processed instanceof Error){warnings.push(processed.message);Sentry.captureException(processed,{tags:{audit:this.meta.id},level:'warning'});return results;}
const existing=results.get(processed.url);if(!existing||existing.wastedBytes>processed.wastedBytes){results.set(processed.url,processed);}
return results;},new Map());const settings=context.settings;return artifacts.requestInteractive({trace,devtoolsLog,settings}).then(interactive=>{const unfilteredResults=Array.from(resultsMap.values());const lanternInteractive=interactive;const items=context.settings.throttlingMethod==='simulate'?OffscreenImages.filterLanternResults(unfilteredResults,lanternInteractive):OffscreenImages.filterObservedResults(unfilteredResults,interactive.timestamp);const headings=[{key:'url',valueType:'thumbnail',label:''},{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{warnings,items,headings};});}}
module.exports=OffscreenImages;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/offscreen-images.js");},{"../../lib/i18n/i18n.js":36,"../../lib/sentry":90,"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/byte-efficiency/render-blocking-resources":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const i18n=require('../../lib/i18n/i18n.js');const BaseNode=require('../../lib/dependency-graph/base-node');const ByteEfficiencyAudit=require('./byte-efficiency-audit');const UnusedCSS=require('./unused-css-rules');const NetworkRequest=require('../../lib/network-request');const MINIMUM_WASTED_MS=50;const UIStrings={title:'Eliminate render-blocking resources',description:'Resources are blocking the first paint of your page. Consider '+'delivering critical JS/CSS inline and deferring all non-critical '+'JS/styles. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);function getNodesAndTimingByUrl(nodeTimings){const urlMap={};const nodes=Array.from(nodeTimings.keys());nodes.forEach(node=>{if(node.type!=='network')return;const nodeTiming=nodeTimings.get(node);if(!nodeTiming)return;urlMap[node.record.url]={node,nodeTiming};});return urlMap;}
class RenderBlockingResources extends Audit{static get meta(){return{id:'render-blocking-resources',title:str_(UIStrings.title),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,description:str_(UIStrings.description),requiredArtifacts:['URL','TagsBlockingFirstPaint','traces']};}
static async computeResults(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const simulatorData={devtoolsLog,settings:context.settings};const traceOfTab=await artifacts.requestTraceOfTab(trace);const simulator=await artifacts.requestLoadSimulator(simulatorData);const wastedCssBytes=await RenderBlockingResources.computeWastedCSSBytes(artifacts,context);const metricSettings={throttlingMethod:'simulate'};const metricComputationData={trace,devtoolsLog,simulator,settings:metricSettings};const fcpSimulation=await artifacts.requestFirstContentfulPaint(metricComputationData);const fcpTsInMs=traceOfTab.timestamps.firstContentfulPaint/1000;const nodesByUrl=getNodesAndTimingByUrl(fcpSimulation.optimisticEstimate.nodeTimings);const results=[];const deferredNodeIds=new Set();for(const resource of artifacts.TagsBlockingFirstPaint){if(resource.endTime*1000>fcpTsInMs)continue;if(!nodesByUrl[resource.tag.url])continue;const{node,nodeTiming}=nodesByUrl[resource.tag.url];node.traverse(node=>deferredNodeIds.add(node.id));const wastedMs=Math.round(nodeTiming.duration);if(wastedMs<MINIMUM_WASTED_MS)continue;results.push({url:resource.tag.url,totalBytes:resource.transferSize,wastedMs});}
if(!results.length){return{results,wastedMs:0};}
const wastedMs=RenderBlockingResources.estimateSavingsWithGraphs(simulator,fcpSimulation.optimisticGraph,deferredNodeIds,wastedCssBytes);return{results,wastedMs};}
static estimateSavingsWithGraphs(simulator,fcpGraph,deferredIds,wastedCssBytesByUrl){const originalEstimate=simulator.simulate(fcpGraph).timeInMs;let totalChildNetworkBytes=0;const minimalFCPGraph=fcpGraph.cloneWithRelationships(node=>{const canDeferRequest=deferredIds.has(node.id);if(node.type!==BaseNode.TYPES.NETWORK)return!canDeferRequest;const isStylesheet=node.record.resourceType===NetworkRequest.TYPES.Stylesheet;if(canDeferRequest&&isStylesheet){const wastedBytes=wastedCssBytesByUrl.get(node.record.url)||0;totalChildNetworkBytes+=(node.record.transferSize||0)-wastedBytes;}
return!canDeferRequest;});const originalTransferSize=minimalFCPGraph.record.transferSize;const safeTransferSize=originalTransferSize||0;minimalFCPGraph.record.transferSize=safeTransferSize+totalChildNetworkBytes;const estimateAfterInline=simulator.simulate(minimalFCPGraph).timeInMs;minimalFCPGraph.record.transferSize=originalTransferSize;return Math.round(Math.max(originalEstimate-estimateAfterInline,0));}
static async computeWastedCSSBytes(artifacts,context){const wastedBytesByUrl=new Map();try{const results=await UnusedCSS.audit(artifacts,context);for(const item of results.details.items){wastedBytesByUrl.set(item.url,item.wastedBytes);}}catch(_){}
return wastedBytesByUrl;}
static async audit(artifacts,context){const{results,wastedMs}=await RenderBlockingResources.computeResults(artifacts,context);let displayValue='';if(results.length>0){displayValue=str_(i18n.UIStrings.displayValueMsSavings,{wastedMs});}
const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedMs',valueType:'timespanMs',label:str_(i18n.UIStrings.columnWastedMs)}];const details=Audit.makeOpportunityDetails(headings,results,wastedMs);return{displayValue,score:ByteEfficiencyAudit.scoreForWastedMs(wastedMs),rawValue:wastedMs,details};}}
module.exports=RenderBlockingResources;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/render-blocking-resources.js");},{"../../lib/dependency-graph/base-node":25,"../../lib/i18n/i18n.js":36,"../../lib/network-request":88,"../audit":2,"./byte-efficiency-audit":3,"./unused-css-rules":"../audits/byte-efficiency/unused-css-rules"}],"../audits/byte-efficiency/total-byte-weight":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Avoids enormous network payloads',failureTitle:'Avoid enormous network payloads',description:'Large network payloads cost users real money and are highly correlated with '+'long load times. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/network-payloads).',displayValue:'Total size was {totalBytes, number, bytes}\xa0KB'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class TotalByteWeight extends ByteEfficiencyAudit{static get meta(){return{id:'total-byte-weight',title:str_(UIStrings.title),failureTitle:str_(UIStrings.failureTitle),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['devtoolsLogs','traces']};}
static get defaultOptions(){return{scorePODR:2500*1024,scoreMedian:4000*1024};}
static async audit(artifacts,context){const devtoolsLogs=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];const[networkRecords,networkThroughput]=await Promise.all([artifacts.requestNetworkRecords(devtoolsLogs),artifacts.requestNetworkThroughput(devtoolsLogs)]);let totalBytes=0;let results=[];networkRecords.forEach(record=>{if(record.parsedURL.scheme==='data'||!record.finished)return;const result={url:record.url,totalBytes:record.transferSize,totalMs:ByteEfficiencyAudit.bytesToMs(record.transferSize,networkThroughput)};totalBytes+=result.totalBytes;results.push(result);});const totalCompletedRequests=results.length;results=results.sort((itemA,itemB)=>itemB.totalBytes-itemA.totalBytes).slice(0,10);const score=ByteEfficiencyAudit.computeLogNormalScore(totalBytes,context.options.scorePODR,context.options.scoreMedian);const headings=[{key:'url',itemType:'url',text:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',itemType:'bytes',text:str_(i18n.UIStrings.columnSize)}];const tableDetails=ByteEfficiencyAudit.makeTableDetails(headings,results);return{score,rawValue:totalBytes,displayValue:str_(UIStrings.displayValue,{totalBytes}),extendedInfo:{value:{results,totalCompletedRequests}},details:tableDetails};}}
module.exports=TotalByteWeight;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/total-byte-weight.js");},{"../../lib/i18n/i18n.js":36,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/unminified-css":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const UnusedCSSRules=require('./unused-css-rules');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Minify CSS',description:'Minifying CSS files can reduce network payload sizes. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/minify-css).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_PERCENT=5;const IGNORE_THRESHOLD_IN_BYTES=2048;class UnminifiedCSS extends ByteEfficiencyAudit{static get meta(){return{id:'unminified-css',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['CSSUsage','devtoolsLogs','traces']};}
static computeTokenLength(content){let totalTokenLength=0;let isInComment=false;let isInLicenseComment=false;let isInString=false;let stringOpenChar=null;for(let i=0;i<content.length;i++){const twoChars=content.substr(i,2);const char=twoChars.charAt(0);const isWhitespace=char===' '||char==='\n'||char==='\t';const isAStringOpenChar=char===`'`||char==='"';if(isInComment){if(isInLicenseComment)totalTokenLength++;if(twoChars==='*/'){if(isInLicenseComment)totalTokenLength++;isInComment=false;i++;}}else if(isInString){totalTokenLength++;if(char==='\\'){totalTokenLength++;i++;}else if(char===stringOpenChar){isInString=false;}}else{if(twoChars==='/*'){isInComment=true;isInLicenseComment=content.charAt(i+2)==='!';if(isInLicenseComment)totalTokenLength+=2;i++;}else if(isAStringOpenChar){isInString=true;stringOpenChar=char;totalTokenLength++;}else if(!isWhitespace){totalTokenLength++;}}}
if(isInComment||isInString){return content.length;}
return totalTokenLength;}
static computeWaste(stylesheet,networkRecord,pageUrl){const content=stylesheet.content;const totalTokenLength=UnminifiedCSS.computeTokenLength(content);let url=stylesheet.header.sourceURL;if(!url||url===pageUrl){const contentPreview=UnusedCSSRules.determineContentPreview(stylesheet.content);url=contentPreview;}
const totalBytes=ByteEfficiencyAudit.estimateTransferSize(networkRecord,content.length,'Stylesheet');const wastedRatio=1-totalTokenLength/content.length;const wastedBytes=Math.round(totalBytes*wastedRatio);return{url,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts,networkRecords){const pageUrl=artifacts.URL.finalUrl;const items=[];for(const stylesheet of artifacts.CSSUsage.stylesheets){const networkRecord=networkRecords.find(record=>record.url===stylesheet.header.sourceURL);if(!stylesheet.content)continue;const result=UnminifiedCSS.computeWaste(stylesheet,networkRecord,pageUrl);if(result.wastedPercent<IGNORE_THRESHOLD_IN_PERCENT||result.wastedBytes<IGNORE_THRESHOLD_IN_BYTES||!Number.isFinite(result.wastedBytes))continue;items.push(result);}
const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{items,headings};}}
module.exports=UnminifiedCSS;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/unminified-css.js");},{"../../lib/i18n/i18n.js":36,"./byte-efficiency-audit":3,"./unused-css-rules":"../audits/byte-efficiency/unused-css-rules"}],"../audits/byte-efficiency/unminified-javascript":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const esprima=require('esprima');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Minify JavaScript',description:'Minifying JavaScript files can reduce payload sizes and script parse time. '+'[Learn more](https://developers.google.com/speed/docs/insights/MinifyResources).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_PERCENT=10;const IGNORE_THRESHOLD_IN_BYTES=2048;class UnminifiedJavaScript extends ByteEfficiencyAudit{static get meta(){return{id:'unminified-javascript',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['Scripts','devtoolsLogs','traces']};}
static computeWaste(scriptContent,networkRecord){const contentLength=scriptContent.length;let totalTokenLength=0;const tokens=esprima.tokenize(scriptContent,{tolerant:true});if(!tokens.length&&tokens.errors&&tokens.errors.length){throw tokens.errors[0];}
for(const token of tokens){totalTokenLength+=token.value.length;}
const totalBytes=ByteEfficiencyAudit.estimateTransferSize(networkRecord,contentLength,'Script');const wastedRatio=1-totalTokenLength/contentLength;const wastedBytes=Math.round(totalBytes*wastedRatio);return{url:networkRecord.url,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts,networkRecords){const items=[];const warnings=[];for(const requestId of Object.keys(artifacts.Scripts)){const scriptContent=artifacts.Scripts[requestId];const networkRecord=networkRecords.find(record=>record.requestId===requestId);if(!networkRecord||!scriptContent)continue;try{const result=UnminifiedJavaScript.computeWaste(scriptContent,networkRecord);if(result.wastedPercent<IGNORE_THRESHOLD_IN_PERCENT||result.wastedBytes<IGNORE_THRESHOLD_IN_BYTES||!Number.isFinite(result.wastedBytes))continue;items.push(result);}catch(err){warnings.push(`Unable to process ${networkRecord.url}: ${err.message}`);}}
const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{items,warnings,headings};}}
module.exports=UnminifiedJavaScript;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/unminified-javascript.js");},{"../../lib/i18n/i18n.js":36,"./byte-efficiency-audit":3,"esprima":162}],"../audits/byte-efficiency/unused-css-rules":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Defer unused CSS',description:'Remove unused rules from stylesheets to reduce unnecessary '+'bytes consumed by network activity. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/unused-css).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_BYTES=2048;const PREVIEW_LENGTH=100;class UnusedCSSRules extends ByteEfficiencyAudit{static get meta(){return{id:'unused-css-rules',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['CSSUsage','URL','devtoolsLogs','traces']};}
static indexStylesheetsById(styles,networkRecords){const indexedNetworkRecords=networkRecords.reduce((indexed,record)=>{indexed[record.url]=record;return indexed;},{});return styles.reduce((indexed,stylesheet)=>{indexed[stylesheet.header.styleSheetId]=Object.assign({usedRules:[],networkRecord:indexedNetworkRecords[stylesheet.header.sourceURL]},stylesheet);return indexed;},{});}
static indexUsedRules(rules,indexedStylesheets){rules.forEach(rule=>{const stylesheetInfo=indexedStylesheets[rule.styleSheetId];if(!stylesheetInfo){return;}
if(rule.used){stylesheetInfo.usedRules.push(rule);}});}
static computeUsage(stylesheetInfo){let usedUncompressedBytes=0;const totalUncompressedBytes=stylesheetInfo.content.length;for(const usedRule of stylesheetInfo.usedRules){usedUncompressedBytes+=usedRule.endOffset-usedRule.startOffset;}
const totalTransferredBytes=ByteEfficiencyAudit.estimateTransferSize(stylesheetInfo.networkRecord,totalUncompressedBytes,'Stylesheet');const percentUnused=(totalUncompressedBytes-usedUncompressedBytes)/totalUncompressedBytes;const wastedBytes=Math.round(percentUnused*totalTransferredBytes);return{wastedBytes,wastedPercent:percentUnused*100,totalBytes:totalTransferredBytes};}
static determineContentPreview(content){let preview=(content||'').slice(0,PREVIEW_LENGTH*5).replace(/( {2,}|\t)+/g,'  ').replace(/\n\s+}/g,'\n}').trim();if(preview.length>PREVIEW_LENGTH){const firstRuleStart=preview.indexOf('{');const firstRuleEnd=preview.indexOf('}');if(firstRuleStart===-1||firstRuleEnd===-1||firstRuleStart>firstRuleEnd||firstRuleStart>PREVIEW_LENGTH){preview=preview.slice(0,PREVIEW_LENGTH)+'...';}else if(firstRuleEnd<PREVIEW_LENGTH){preview=preview.slice(0,firstRuleEnd+1)+' ...';}else{const lastSemicolonIndex=preview.slice(0,PREVIEW_LENGTH).lastIndexOf(';');preview=lastSemicolonIndex<firstRuleStart?preview.slice(0,PREVIEW_LENGTH)+'... } ...':preview.slice(0,lastSemicolonIndex+1)+' ... } ...';}}
return preview;}
static mapSheetToResult(stylesheetInfo,pageUrl){let url=stylesheetInfo.header.sourceURL;if(!url||url===pageUrl){const contentPreview=UnusedCSSRules.determineContentPreview(stylesheetInfo.content);url=contentPreview;}
const usage=UnusedCSSRules.computeUsage(stylesheetInfo);return Object.assign({url},usage);}
static audit_(artifacts){const styles=artifacts.CSSUsage.stylesheets;const usage=artifacts.CSSUsage.rules;const pageUrl=artifacts.URL.finalUrl;const devtoolsLogs=artifacts.devtoolsLogs[ByteEfficiencyAudit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const indexedSheets=UnusedCSSRules.indexStylesheetsById(styles,networkRecords);UnusedCSSRules.indexUsedRules(usage,indexedSheets);const items=Object.keys(indexedSheets).map(sheetId=>UnusedCSSRules.mapSheetToResult(indexedSheets[sheetId],pageUrl)).filter(sheet=>sheet&&sheet.wastedBytes>IGNORE_THRESHOLD_IN_BYTES);const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{items,headings};});}}
module.exports=UnusedCSSRules;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/unused-css-rules.js");},{"../../lib/i18n/i18n.js":36,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/unused-javascript":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Remove unused JavaScript',description:'Remove unused JavaScript to reduce bytes consumed by network activity.'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_BYTES=2048;class UnusedJavaScript extends ByteEfficiencyAudit{static get meta(){return{id:'unused-javascript',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['JsUsage','devtoolsLogs','traces']};}
static computeWaste(script){let maximumEndOffset=0;for(const func of script.functions){for(const range of func.ranges){maximumEndOffset=Math.max(maximumEndOffset,range.endOffset);}}
const unusedByIndex=new Uint8Array(maximumEndOffset);for(const func of script.functions){for(const range of func.ranges){if(range.count===0){for(let i=range.startOffset;i<range.endOffset;i++){unusedByIndex[i]=1;}}}}
let unused=0;for(const x of unusedByIndex){unused+=x;}
return{unusedLength:unused,contentLength:maximumEndOffset};}
static mergeWaste(wasteData,networkRecord){let unusedLength=0;let contentLength=0;for(const usage of wasteData){unusedLength+=usage.unusedLength;contentLength+=usage.contentLength;}
const totalBytes=ByteEfficiencyAudit.estimateTransferSize(networkRecord,contentLength,'Script');const wastedRatio=unusedLength/contentLength||0;const wastedBytes=Math.round(totalBytes*wastedRatio);return{url:networkRecord.url,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts,networkRecords){const scriptsByUrl=new Map();for(const script of artifacts.JsUsage){const scripts=scriptsByUrl.get(script.url)||[];scripts.push(script);scriptsByUrl.set(script.url,scripts);}
const items=[];for(const[url,scripts]of scriptsByUrl.entries()){const networkRecord=networkRecords.find(record=>record.url===url);if(!networkRecord)continue;const wasteData=scripts.map(UnusedJavaScript.computeWaste);const item=UnusedJavaScript.mergeWaste(wasteData,networkRecord);if(item.wastedBytes<=IGNORE_THRESHOLD_IN_BYTES)continue;items.push(item);}
return{items,headings:[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}]};}}
module.exports=UnusedJavaScript;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/unused-javascript.js");},{"../../lib/i18n/i18n.js":36,"./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-long-cache-ttl":[function(require,module,exports){(function(__filename){'use strict';const assert=require('assert');const parseCacheControl=require('parse-cache-control');const Audit=require('../audit');const NetworkRequest=require('../../lib/network-request');const URL=require('../../lib/url-shim');const linearInterpolation=require('../../lib/statistics').linearInterpolation;const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Uses efficient cache policy on static assets',failureTitle:'Serve static assets with an efficient cache policy',description:'A long cache lifetime can speed up repeat visits to your page. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/cache-policy).',displayValue:`{itemCount, plural,
    =1 {1 resource found}
    other {# resources found}
    }`};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_PERCENT=0.925;class CacheHeaders extends Audit{static get meta(){return{id:'uses-long-cache-ttl',title:str_(UIStrings.title),failureTitle:str_(UIStrings.failureTitle),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['devtoolsLogs','traces']};}
static get defaultOptions(){return{scorePODR:4*1024,scoreMedian:128*1024};}
static getCacheHitProbability(maxAgeInSeconds){const RESOURCE_AGE_IN_HOURS_DECILES=[0,0.2,1,3,8,12,24,48,72,168,8760,Infinity];assert.ok(RESOURCE_AGE_IN_HOURS_DECILES.length===12,'deciles 0-10 and 1 for overflow');const maxAgeInHours=maxAgeInSeconds/3600;const upperDecileIndex=RESOURCE_AGE_IN_HOURS_DECILES.findIndex(decile=>decile>=maxAgeInHours);if(upperDecileIndex===RESOURCE_AGE_IN_HOURS_DECILES.length-1)return 1;if(upperDecileIndex===0)return 0;const upperDecileValue=RESOURCE_AGE_IN_HOURS_DECILES[upperDecileIndex];const lowerDecileValue=RESOURCE_AGE_IN_HOURS_DECILES[upperDecileIndex-1];const upperDecile=upperDecileIndex/10;const lowerDecile=(upperDecileIndex-1)/10;return linearInterpolation(lowerDecileValue,lowerDecile,upperDecileValue,upperDecile,maxAgeInHours);}
static computeCacheLifetimeInSeconds(headers,cacheControl){if(cacheControl){if(cacheControl['no-cache']||cacheControl['no-store'])return 0;const maxAge=cacheControl['max-age'];if(maxAge!==undefined&&Number.isFinite(maxAge))return Math.max(maxAge,0);}else if((headers.get('pragma')||'').includes('no-cache')){return 0;}
const expiresHeaders=headers.get('expires');if(expiresHeaders){const expires=new Date(expiresHeaders).getTime();if(!expires)return 0;return Math.max(0,Math.ceil((expires-Date.now())/1000));}
return null;}
static isCacheableAsset(record){const CACHEABLE_STATUS_CODES=new Set([200,203,206]);const STATIC_RESOURCE_TYPES=new Set([NetworkRequest.TYPES.Font,NetworkRequest.TYPES.Image,NetworkRequest.TYPES.Media,NetworkRequest.TYPES.Script,NetworkRequest.TYPES.Stylesheet]);const resourceUrl=record.url;return(CACHEABLE_STATUS_CODES.has(record.statusCode)&&STATIC_RESOURCE_TYPES.has(record.resourceType||'Other')&&!resourceUrl.includes('data:'));}
static audit(artifacts,context){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(records=>{const results=[];let queryStringCount=0;let totalWastedBytes=0;for(const record of records){if(!CacheHeaders.isCacheableAsset(record))continue;const headers=new Map();for(const header of record.responseHeaders||[]){if(headers.has(header.name.toLowerCase())){const previousHeaderValue=headers.get(header.name.toLowerCase());headers.set(header.name.toLowerCase(),`${previousHeaderValue}, ${header.value}`);}else{headers.set(header.name.toLowerCase(),header.value);}}
const cacheControl=parseCacheControl(headers.get('cache-control'));let cacheLifetimeInSeconds=CacheHeaders.computeCacheLifetimeInSeconds(headers,cacheControl);if(cacheLifetimeInSeconds===0)continue;cacheLifetimeInSeconds=cacheLifetimeInSeconds||0;const cacheHitProbability=CacheHeaders.getCacheHitProbability(cacheLifetimeInSeconds);if(cacheHitProbability>IGNORE_THRESHOLD_IN_PERCENT)continue;const url=URL.elideDataURI(record.url);const totalBytes=record.transferSize||0;const wastedBytes=(1-cacheHitProbability)*totalBytes;totalWastedBytes+=wastedBytes;if(url.includes('?'))queryStringCount++;results.push({url,cacheControl,cacheLifetimeMs:cacheLifetimeInSeconds*1000,cacheHitProbability,totalBytes,wastedBytes});}
results.sort((a,b)=>a.cacheLifetimeMs-b.cacheLifetimeMs||b.totalBytes-a.totalBytes);const score=Audit.computeLogNormalScore(totalWastedBytes,context.options.scorePODR,context.options.scoreMedian);const headings=[{key:'url',itemType:'url',text:str_(i18n.UIStrings.columnURL)},{key:'cacheLifetimeMs',itemType:'ms',text:str_(i18n.UIStrings.columnCacheTTL),displayUnit:'duration'},{key:'totalBytes',itemType:'bytes',text:str_(i18n.UIStrings.columnSize),displayUnit:'kb',granularity:1}];const summary={wastedBytes:totalWastedBytes};const details=Audit.makeTableDetails(headings,results,summary);return{score,rawValue:totalWastedBytes,displayValue:str_(UIStrings.displayValue,{itemCount:results.length}),extendedInfo:{value:{results,queryStringCount}},details};});}}
module.exports=CacheHeaders;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js");},{"../../lib/i18n/i18n.js":36,"../../lib/network-request":88,"../../lib/statistics":91,"../../lib/url-shim":"url","../audit":2,"assert":102,"parse-cache-control":181}],"../audits/byte-efficiency/uses-optimized-images":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Efficiently encode images',description:'Optimized images load faster and consume less cellular data. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/optimize-images).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_BYTES=4096;class UsesOptimizedImages extends ByteEfficiencyAudit{static get meta(){return{id:'uses-optimized-images',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['OptimizedImages','devtoolsLogs','traces']};}
static computeSavings(image){const bytes=image.originalSize-image.jpegSize;const percent=100*bytes/image.originalSize;return{bytes,percent};}
static audit_(artifacts){const images=artifacts.OptimizedImages;const items=[];const warnings=[];for(const image of images){if(image.failed){warnings.push(`Unable to decode ${URL.getURLDisplayName(image.url)}`);continue;}else if(/(jpeg|bmp)/.test(image.mimeType)===false||image.originalSize<image.jpegSize+IGNORE_THRESHOLD_IN_BYTES){continue;}
const url=URL.elideDataURI(image.url);const jpegSavings=UsesOptimizedImages.computeSavings(image);items.push({url,fromProtocol:image.fromProtocol,isCrossOrigin:!image.isSameOrigin,totalBytes:image.originalSize,wastedBytes:jpegSavings.bytes});}
const headings=[{key:'url',valueType:'thumbnail',label:''},{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{warnings,items,headings};}}
module.exports=UsesOptimizedImages;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/uses-optimized-images.js");},{"../../lib/i18n/i18n.js":36,"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-responsive-images":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const Sentry=require('../../lib/sentry');const URL=require('../../lib/url-shim');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Properly size images',description:'Serve images that are appropriately-sized to save cellular data '+'and improve load time. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/oversized-images).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_BYTES=2048;class UsesResponsiveImages extends ByteEfficiencyAudit{static get meta(){return{id:'uses-responsive-images',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['ImageUsage','ViewportDimensions','devtoolsLogs','traces']};}
static computeWaste(image,DPR){if(!image.networkRecord){return null;}
const url=URL.elideDataURI(image.src);const actualPixels=image.naturalWidth*image.naturalHeight;const usedPixels=image.clientWidth*image.clientHeight*Math.pow(DPR,2);const wastedRatio=1-usedPixels/actualPixels;const totalBytes=image.networkRecord.resourceSize;const wastedBytes=Math.round(totalBytes*wastedRatio);if(!usedPixels){return null;}
if(!Number.isFinite(wastedRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,totalBytes,wastedBytes,wastedPercent:100*wastedRatio};}
static audit_(artifacts){const images=artifacts.ImageUsage;const DPR=artifacts.ViewportDimensions.devicePixelRatio;const warnings=[];const resultsMap=new Map();images.forEach(image=>{if(!image.networkRecord||image.networkRecord.mimeType==='image/svg+xml'){return;}
const processed=UsesResponsiveImages.computeWaste(image,DPR);if(!processed)return;if(processed instanceof Error){warnings.push(processed.message);Sentry.captureException(processed,{tags:{audit:this.meta.id},level:'warning'});return;}
const existing=resultsMap.get(processed.url);if(!existing||existing.wastedBytes>processed.wastedBytes){resultsMap.set(processed.url,processed);}});const items=Array.from(resultsMap.values()).filter(item=>item.wastedBytes>IGNORE_THRESHOLD_IN_BYTES);const headings=[{key:'url',valueType:'thumbnail',label:''},{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{warnings,items,headings};}}
module.exports=UsesResponsiveImages;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/uses-responsive-images.js");},{"../../lib/i18n/i18n.js":36,"../../lib/sentry":90,"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-text-compression":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Enable text compression',description:'Text-based resources should be served with compression (gzip, deflate or'+' brotli) to minimize total network bytes.'+' [Learn more](https://developers.google.com/web/tools/lighthouse/audits/text-compression).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_BYTES=1400;const IGNORE_THRESHOLD_IN_PERCENT=0.1;class ResponsesAreCompressed extends ByteEfficiencyAudit{static get meta(){return{id:'uses-text-compression',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['ResponseCompression','devtoolsLogs','traces']};}
static audit_(artifacts){const uncompressedResponses=artifacts.ResponseCompression;const items=[];uncompressedResponses.forEach(record=>{if(!record.gzipSize||record.gzipSize<0)return;const originalSize=record.resourceSize;const gzipSize=record.gzipSize;const gzipSavings=originalSize-gzipSize;if(1-gzipSize/originalSize<IGNORE_THRESHOLD_IN_PERCENT||gzipSavings<IGNORE_THRESHOLD_IN_BYTES||record.transferSize<gzipSize)
{return;}
const url=URL.elideDataURI(record.url);const isDuplicate=items.find(item=>item.url===url&&item.totalBytes===record.resourceSize);if(isDuplicate){return;}
items.push({url,totalBytes:originalSize,wastedBytes:gzipSavings});});const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{items,headings};}}
module.exports=ResponsesAreCompressed;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/uses-text-compression.js");},{"../../lib/i18n/i18n.js":36,"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/byte-efficiency/uses-webp-images":[function(require,module,exports){(function(__filename){'use strict';const ByteEfficiencyAudit=require('./byte-efficiency-audit');const URL=require('../../lib/url-shim');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Serve images in next-gen formats',description:'Image formats like JPEG 2000, JPEG XR, and WebP often provide better '+'compression than PNG or JPEG, which means faster downloads and less data consumption. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/webp).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const IGNORE_THRESHOLD_IN_BYTES=8192;class UsesWebPImages extends ByteEfficiencyAudit{static get meta(){return{id:'uses-webp-images',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:ByteEfficiencyAudit.SCORING_MODES.NUMERIC,requiredArtifacts:['OptimizedImages','devtoolsLogs','traces']};}
static computeSavings(image){const bytes=image.originalSize-image.webpSize;const percent=100*bytes/image.originalSize;return{bytes,percent};}
static audit_(artifacts){const images=artifacts.OptimizedImages;const items=[];const warnings=[];for(const image of images){if(image.failed){warnings.push(`Unable to decode ${URL.getURLDisplayName(image.url)}`);continue;}else if(image.originalSize<image.webpSize+IGNORE_THRESHOLD_IN_BYTES){continue;}
const url=URL.elideDataURI(image.url);const webpSavings=UsesWebPImages.computeSavings(image);items.push({url,fromProtocol:image.fromProtocol,isCrossOrigin:!image.isSameOrigin,totalBytes:image.originalSize,wastedBytes:webpSavings.bytes});}
const headings=[{key:'url',valueType:'thumbnail',label:''},{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'totalBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnSize)},{key:'wastedBytes',valueType:'bytes',label:str_(i18n.UIStrings.columnWastedBytes)}];return{warnings,items,headings};}}
module.exports=UsesWebPImages;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/byte-efficiency/uses-webp-images.js");},{"../../lib/i18n/i18n.js":36,"../../lib/url-shim":"url","./byte-efficiency-audit":3}],"../audits/content-width":[function(require,module,exports){'use strict';const Audit=require('./audit');class ContentWidth extends Audit{static get meta(){return{id:'content-width',title:'Content is sized correctly for the viewport',failureTitle:'Content is not sized correctly for the viewport',description:'If the width of your app\'s content doesn\'t match the width '+'of the viewport, your app might not be optimized for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/content-sized-correctly-for-viewport).',requiredArtifacts:['ViewportDimensions','HostUserAgent']};}
static audit(artifacts,context){const userAgent=artifacts.HostUserAgent;const viewportWidth=artifacts.ViewportDimensions.innerWidth;const windowWidth=artifacts.ViewportDimensions.outerWidth;const widthsMatch=viewportWidth===windowWidth;const isMobileHost=userAgent.includes('Android')||userAgent.includes('Mobile');const isMobile=context.settings.emulatedFormFactor==='mobile'||context.settings.emulatedFormFactor!=='desktop'&&isMobileHost;if(isMobile){return{rawValue:widthsMatch,explanation:this.createExplanation(widthsMatch,artifacts.ViewportDimensions)};}else{return{rawValue:true,notApplicable:true};}}
static createExplanation(match,artifact){if(match){return'';}
return'The viewport size is '+artifact.innerWidth+'px, '+'whereas the window size is '+artifact.outerWidth+'px.';}}
module.exports=ContentWidth;},{"./audit":2}],"../audits/critical-request-chains":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('./audit');const i18n=require('../lib/i18n/i18n.js');const UIStrings={title:'Minimize Critical Requests Depth',description:'The Critical Request Chains below show you what resources are '+'loaded with a high priority. Consider reducing '+'the length of chains, reducing the download size of resources, or '+'deferring the download of unnecessary resources to improve page load. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains).',displayValue:`{itemCount, plural,
    =1 {1 chain found}
    other {# chains found}
    }`};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class CriticalRequestChains extends Audit{static get meta(){return{id:'critical-request-chains',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,requiredArtifacts:['devtoolsLogs','URL']};}
static _traverse(tree,cb){function walk(node,depth,startTime,transferSize=0){const children=Object.keys(node);if(children.length===0){return;}
children.forEach(id=>{const child=node[id];if(!startTime){startTime=child.request.startTime;}
cb({depth,id,node:child,chainDuration:(child.request.endTime-startTime)*1000,chainTransferSize:transferSize+child.request.transferSize});walk(child.children,depth+1,startTime);},'');}
walk(tree,0);}
static _getLongestChain(tree){const longest={duration:0,length:0,transferSize:0};CriticalRequestChains._traverse(tree,opts=>{const duration=opts.chainDuration;if(duration>longest.duration){longest.duration=duration;longest.transferSize=opts.chainTransferSize;longest.length=opts.depth;}});longest.length++;return longest;}
static flattenRequests(tree){const flattendChains={};const chainMap=new Map();function flatten(opts){const request=opts.node.request;const simpleRequest={url:request.url,startTime:request.startTime,endTime:request.endTime,responseReceivedTime:request.responseReceivedTime,transferSize:request.transferSize};let chain=chainMap.get(opts.id);if(chain){chain.request=simpleRequest;}else{chain={request:simpleRequest,children:{}};flattendChains[opts.id]=chain;}
for(const chainId of Object.keys(opts.node.children)){const childChain={request:{},children:{}};chainMap.set(chainId,childChain);chain.children[chainId]=childChain;}
chainMap.set(opts.id,chain);}
CriticalRequestChains._traverse(tree,flatten);return flattendChains;}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const URL=artifacts.URL;return artifacts.requestCriticalRequestChains({devtoolsLog,URL}).then(chains=>{let chainCount=0;function walk(node,depth){const children=Object.keys(node);if(children.length===0){chainCount++;}
children.forEach(id=>{const child=node[id];walk(child.children,depth+1);},'');}
const flattenedChains=CriticalRequestChains.flattenRequests(chains);const initialNavKey=Object.keys(flattenedChains)[0];const initialNavChildren=initialNavKey&&flattenedChains[initialNavKey].children;if(initialNavChildren&&Object.keys(initialNavChildren).length>0){walk(initialNavChildren,0);}
const longestChain=CriticalRequestChains._getLongestChain(flattenedChains);return{rawValue:chainCount===0,notApplicable:chainCount===0,displayValue:chainCount?str_(UIStrings.displayValue,{itemCount:chainCount}):'',extendedInfo:{value:{chains:flattenedChains,longestChain}},details:{type:'criticalrequestchain',chains:flattenedChains,longestChain}};});}}
module.exports=CriticalRequestChains;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/critical-request-chains.js");},{"../lib/i18n/i18n.js":36,"./audit":2}],"../audits/deprecations":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');class Deprecations extends Audit{static get meta(){return{id:'deprecations',title:'Avoids deprecated APIs',failureTitle:'Uses deprecated APIs',description:'Deprecated APIs will eventually be removed from the browser. '+'[Learn more](https://www.chromestatus.com/features#deprecated).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const entries=artifacts.ChromeConsoleMessages;const deprecations=entries.filter(log=>log.entry.source==='deprecation').map(log=>{return{value:log.entry.text,url:log.entry.url||'',source:log.entry.source,lineNumber:log.entry.lineNumber};});const headings=[{key:'value',itemType:'code',text:'Deprecation / Warning'},{key:'url',itemType:'url',text:'URL'},{key:'lineNumber',itemType:'text',text:'Line'}];const details=Audit.makeTableDetails(headings,deprecations);let displayValue='';if(deprecations.length>1){displayValue=`${Util.formatNumber(deprecations.length)} warnings found`;}else if(deprecations.length===1){displayValue=`${deprecations.length} warning found`;}
return{rawValue:deprecations.length===0,displayValue,extendedInfo:{value:deprecations},details};}}
module.exports=Deprecations;},{"../report/html/renderer/util":97,"./audit":2}],"../audits/dobetterweb/appcache-manifest":[function(require,module,exports){'use strict';const Audit=require('../audit');class AppCacheManifestAttr extends Audit{static get meta(){return{id:'appcache-manifest',title:'Avoids Application Cache',failureTitle:'Uses Application Cache',description:'Application Cache is deprecated. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/appcache).',requiredArtifacts:['AppCacheManifest']};}
static audit(artifacts){const usingAppcache=artifacts.AppCacheManifest!==null;const displayValue=usingAppcache?`Found "${artifacts.AppCacheManifest}"`:'';return{rawValue:!usingAppcache,displayValue};}}
module.exports=AppCacheManifestAttr;},{"../audit":2}],"../audits/dobetterweb/doctype":[function(require,module,exports){'use strict';const Audit=require('../audit');class Doctype extends Audit{static get meta(){return{id:'doctype',title:'Page has the HTML doctype',failureTitle:'Page is missing the HTML doctype',description:'Specifying a doctype prevents the browser from switching to quirks-mode.'+'Read more on the '+'[MDN Web Docs page](https://developer.mozilla.org/en-US/docs/Glossary/Doctype)',requiredArtifacts:['Doctype']};}
static audit(artifacts){if(!artifacts.Doctype){return{rawValue:false,explanation:'Document must contain a doctype'};}
const doctypeName=artifacts.Doctype.name.trim();const doctypePublicId=artifacts.Doctype.publicId;const doctypeSystemId=artifacts.Doctype.systemId;if(doctypePublicId!==''){return{rawValue:false,explanation:'Expected publicId to be an empty string'};}
if(doctypeSystemId!==''){return{rawValue:false,explanation:'Expected systemId to be an empty string'};}
if(doctypeName==='html'){return{rawValue:true};}else{return{rawValue:false,explanation:'Doctype name must be the lowercase string `html`'};}}}
module.exports=Doctype;},{"../audit":2}],"../audits/dobetterweb/dom-size":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const Util=require('../../report/html/renderer/util.js');const i18n=require('../../lib/i18n/i18n.js');const MAX_DOM_NODES=1500;const MAX_DOM_TREE_WIDTH=60;const MAX_DOM_TREE_DEPTH=32;const UIStrings={title:'Avoids an excessive DOM size',failureTitle:'Avoid an excessive DOM size',description:'Browser engineers recommend pages contain fewer than '+`~${MAX_DOM_NODES.toLocaleString()} DOM nodes. The sweet spot is a tree `+`depth < ${MAX_DOM_TREE_DEPTH} elements and fewer than ${MAX_DOM_TREE_WIDTH} `+'children/parent element. A large DOM can increase memory usage, cause longer '+'[style calculations](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations), '+'and produce costly [layout reflows](https://developers.google.com/speed/articles/reflow). [Learn more](https://developers.google.com/web/tools/lighthouse/audits/dom-size).',columnStatistic:'Statistic',columnElement:'Element',columnValue:'Value',displayValue:`{itemCount, plural,
    =1 {1 node}
    other {# nodes}
    }`,statisticDOMNodes:'Total DOM Nodes',statisticDOMDepth:'Maximum DOM Depth',statisticDOMWidth:'Maximum Child Elements'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class DOMSize extends Audit{static get MAX_DOM_NODES(){return MAX_DOM_NODES;}
static get meta(){return{id:'dom-size',title:str_(UIStrings.title),failureTitle:str_(UIStrings.failureTitle),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['DOMStats']};}
static get defaultOptions(){return{scorePODR:700,scoreMedian:1400};}
static audit(artifacts,context){const stats=artifacts.DOMStats;const score=Audit.computeLogNormalScore(stats.totalDOMNodes,context.options.scorePODR,context.options.scoreMedian);const headings=[{key:'statistic',itemType:'text',text:str_(UIStrings.columnStatistic)},{key:'element',itemType:'code',text:str_(UIStrings.columnElement)},{key:'value',itemType:'text',text:str_(UIStrings.columnValue)}];const items=[{statistic:str_(UIStrings.statisticDOMNodes),element:'',value:Util.formatNumber(stats.totalDOMNodes)},{statistic:str_(UIStrings.statisticDOMDepth),element:{type:'code',value:stats.depth.snippet},value:Util.formatNumber(stats.depth.max)},{statistic:str_(UIStrings.statisticDOMWidth),element:{type:'code',value:stats.width.snippet},value:Util.formatNumber(stats.width.max)}];return{score,rawValue:stats.totalDOMNodes,displayValue:str_(UIStrings.displayValue,{itemCount:stats.totalDOMNodes}),extendedInfo:{value:items},details:Audit.makeTableDetails(headings,items)};}}
module.exports=DOMSize;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/dobetterweb/dom-size.js");},{"../../lib/i18n/i18n.js":36,"../../report/html/renderer/util.js":97,"../audit":2}],"../audits/dobetterweb/external-anchors-use-rel-noopener":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');class ExternalAnchorsUseRelNoopenerAudit extends Audit{static get meta(){return{id:'external-anchors-use-rel-noopener',title:'Links to cross-origin destinations are safe',failureTitle:'Links to cross-origin destinations are unsafe',description:'Add `rel="noopener"` or `rel="noreferrer"` to any external links to improve '+'performance and prevent security vulnerabilities. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/noopener).',requiredArtifacts:['URL','AnchorsWithNoRelNoopener']};}
static audit(artifacts){const warnings=[];const pageHost=new URL(artifacts.URL.finalUrl).host;const failingAnchors=artifacts.AnchorsWithNoRelNoopener.filter(anchor=>{try{return new URL(anchor.href).host!==pageHost;}catch(err){warnings.push(`Unable to determine the destination for anchor (${anchor.outerHTML}). `+'If not used as a hyperlink, consider removing target=_blank.');return true;}}).filter(anchor=>{return!anchor.href||anchor.href.toLowerCase().startsWith('http');}).map(anchor=>{return{href:anchor.href||'Unknown',target:anchor.target||'',rel:anchor.rel||'',outerHTML:anchor.outerHTML||''};});const headings=[{key:'href',itemType:'url',text:'URL'},{key:'target',itemType:'text',text:'Target'},{key:'rel',itemType:'text',text:'Rel'}];const details=Audit.makeTableDetails(headings,failingAnchors);return{rawValue:failingAnchors.length===0,extendedInfo:{value:failingAnchors},details,warnings};}}
module.exports=ExternalAnchorsUseRelNoopenerAudit;},{"../../lib/url-shim":"url","../audit":2}],"../audits/dobetterweb/geolocation-on-start":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class GeolocationOnStart extends ViolationAudit{static get meta(){return{id:'geolocation-on-start',title:'Avoids requesting the geolocation permission on page load',failureTitle:'Requests the geolocation permission on page load',description:'Users are mistrustful of or confused by sites that request their '+'location without context. Consider tying the request to user gestures instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/geolocation-on-load).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/geolocation/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=GeolocationOnStart;},{"../violation-audit":6}],"../audits/dobetterweb/js-libraries":[function(require,module,exports){'use strict';const Audit=require('../audit');class JsLibrariesAudit extends Audit{static get meta(){return{id:'js-libraries',title:'Detected JavaScript libraries',description:'All front-end JavaScript libraries detected on the page.',requiredArtifacts:['JSLibraries']};}
static audit(artifacts){const libDetails=artifacts.JSLibraries.map(lib=>({name:lib.name,version:lib.version,npm:lib.npmPkgName||null}));const headings=[{key:'name',itemType:'text',text:'Name'},{key:'version',itemType:'text',text:'Version'}];const details=Audit.makeTableDetails(headings,libDetails,{});return{rawValue:true,details};}}
module.exports=JsLibrariesAudit;},{"../audit":2}],"../audits/dobetterweb/no-document-write":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class NoDocWriteAudit extends ViolationAudit{static get meta(){return{id:'no-document-write',title:'Avoids `document.write()`',failureTitle:'Uses `document.write()`',description:'For users on slow connections, external scripts dynamically injected via '+'`document.write()` can delay page load by tens of seconds. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/document-write).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/document\.write/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=NoDocWriteAudit;},{"../violation-audit":6}],"../audits/dobetterweb/no-vulnerable-libraries":[function(require,module,exports){'use strict';const Audit=require('../audit');const Sentry=require('../../lib/sentry');const semver=require('semver');const snykDatabase=require('../../../third-party/snyk/snapshot.json');const SEMVER_REGEX=/^(\d+\.\d+\.\d+)[^-0-9]+/;class NoVulnerableLibrariesAudit extends Audit{static get meta(){return{id:'no-vulnerable-libraries',title:'Avoids front-end JavaScript libraries'+' with known security vulnerabilities',failureTitle:'Includes front-end JavaScript libraries'+' with known security vulnerabilities',description:'Some third-party scripts may contain known security vulnerabilities '+'that are easily identified and exploited by attackers. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/vulnerabilities).',requiredArtifacts:['JSLibraries']};}
static get snykDB(){return snykDatabase;}
static get severityMap(){return{high:3,medium:2,low:1};}
static normalizeVersion(version){if(!version)return version;if(semver.valid(version))return version;if(/^\d+\.\d+$/.test(version))return`${version}.0`;const versionMatch=version.match(SEMVER_REGEX);if(versionMatch)return versionMatch[1];return version;}
static getVulnerabilities(normalizedVersion,lib){const snykDB=NoVulnerableLibrariesAudit.snykDB;if(!lib.npmPkgName||!snykDB.npm[lib.npmPkgName]){return[];}
try{semver.satisfies(normalizedVersion,'*');}catch(err){err.pkgName=lib.npmPkgName;Sentry.captureException(err,{level:'warning'});return[];}
const snykInfo=snykDB.npm[lib.npmPkgName];const vulns=snykInfo.filter(vuln=>semver.satisfies(normalizedVersion,vuln.semver.vulnerable[0])).map(vuln=>{return{severity:vuln.severity,numericSeverity:this.severityMap[vuln.severity],library:`${lib.name}@${normalizedVersion}`,url:'https://snyk.io/vuln/'+vuln.id};});return vulns;}
static highestSeverity(vulnerabilities){const sortedVulns=vulnerabilities.sort((a,b)=>b.numericSeverity-a.numericSeverity);return sortedVulns[0].severity;}
static audit(artifacts){const foundLibraries=artifacts.JSLibraries;if(!foundLibraries.length){return{rawValue:true};}
let totalVulns=0;const vulnerabilityResults=[];const libraryVulns=foundLibraries.map(lib=>{const version=this.normalizeVersion(lib.version)||'';const vulns=this.getVulnerabilities(version,lib);const vulnCount=vulns.length;totalVulns+=vulnCount;let highestSeverity;if(vulns.length>0){highestSeverity=this.highestSeverity(vulns).replace(/^\w/,l=>l.toUpperCase());vulnerabilityResults.push({highestSeverity,vulnCount,detectedLib:{text:lib.name+'@'+version,url:`https://snyk.io/vuln/npm:${lib.npmPkgName}?lh=${version}`,type:'link'}});}
return{name:lib.name,npmPkgName:lib.npmPkgName,version,vulns,highestSeverity};});let displayValue='';if(totalVulns>1){displayValue=`${totalVulns} vulnerabilities detected`;}else if(totalVulns===1){displayValue=`${totalVulns} vulnerability detected`;}
const headings=[{key:'detectedLib',itemType:'link',text:'Library Version'},{key:'vulnCount',itemType:'text',text:'Vulnerability Count'},{key:'highestSeverity',itemType:'text',text:'Highest Severity'}];const details=Audit.makeTableDetails(headings,vulnerabilityResults,{});return{rawValue:totalVulns===0,displayValue,extendedInfo:{jsLibs:libraryVulns,vulnerabilities:vulnerabilityResults},details};}}
module.exports=NoVulnerableLibrariesAudit;},{"../../../third-party/snyk/snapshot.json":189,"../../lib/sentry":90,"../audit":2,"semver":184}],"../audits/dobetterweb/no-websql":[function(require,module,exports){'use strict';const Audit=require('../audit');class NoWebSQLAudit extends Audit{static get meta(){return{id:'no-websql',title:'Avoids WebSQL DB',failureTitle:'Uses WebSQL DB',description:'Web SQL is deprecated. Consider using IndexedDB instead. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/web-sql).',requiredArtifacts:['WebSQL']};}
static audit(artifacts){const db=artifacts.WebSQL;const displayValue=db?`Found "${db.name}" (v${db.version})`:'';return{rawValue:!db,displayValue};}}
module.exports=NoWebSQLAudit;},{"../audit":2}],"../audits/dobetterweb/notification-on-start":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class NotificationOnStart extends ViolationAudit{static get meta(){return{id:'notification-on-start',title:'Avoids requesting the notification permission on page load',failureTitle:'Requests the notification permission on page load',description:'Users are mistrustful of or confused by sites that request to send '+'notifications without context. Consider tying the request to user gestures '+'instead. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/notifications-on-load).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/notification permission/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=NotificationOnStart;},{"../violation-audit":6}],"../audits/dobetterweb/password-inputs-can-be-pasted-into":[function(require,module,exports){'use strict';const Audit=require('../audit');class PasswordInputsCanBePastedIntoAudit extends Audit{static get meta(){return{id:'password-inputs-can-be-pasted-into',title:'Allows users to paste into password fields',failureTitle:'Prevents users to paste into password fields',description:'Preventing password pasting undermines good security policy. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/password-pasting).',requiredArtifacts:['PasswordInputsWithPreventedPaste']};}
static audit(artifacts){const passwordInputsWithPreventedPaste=artifacts.PasswordInputsWithPreventedPaste;const items=[];passwordInputsWithPreventedPaste.forEach(input=>{items.push({node:{type:'node',snippet:input.snippet}});});const headings=[{key:'node',itemType:'node',text:'Failing Elements'}];return{rawValue:passwordInputsWithPreventedPaste.length===0,extendedInfo:{value:passwordInputsWithPreventedPaste},details:Audit.makeTableDetails(headings,items)};}}
module.exports=PasswordInputsCanBePastedIntoAudit;},{"../audit":2}],"../audits/dobetterweb/uses-http2":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const Util=require('../../report/html/renderer/util.js');class UsesHTTP2Audit extends Audit{static get meta(){return{id:'uses-http2',title:'Uses HTTP/2 for its own resources',failureTitle:'Does not use HTTP/2 for all of its resources',description:'HTTP/2 offers many benefits over HTTP/1.1, including binary headers, '+'multiplexing, and server push. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http2).',requiredArtifacts:['URL','devtoolsLogs']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const finalHost=new URL(artifacts.URL.finalUrl).host;const seenURLs=new Set();const resources=networkRecords.filter(record=>{const isOldHttp=/HTTP\/[01][.\d]?/i.test(record.protocol);if(!isOldHttp)return false;const requestHost=new URL(record.url).host;return requestHost===finalHost;}).map(record=>{return{protocol:record.protocol,url:record.url};}).filter(record=>{if(seenURLs.has(record.url))return false;seenURLs.add(record.url);return true;});let displayValue='';if(resources.length>1){displayValue=`${Util.formatNumber(resources.length)} requests not served via HTTP/2`;}else if(resources.length===1){displayValue=`${resources.length} request not served via HTTP/2`;}
const headings=[{key:'url',itemType:'url',text:'URL'},{key:'protocol',itemType:'text',text:'Protocol'}];const details=Audit.makeTableDetails(headings,resources);return{rawValue:resources.length===0,displayValue:displayValue,extendedInfo:{value:{results:resources}},details};});}}
module.exports=UsesHTTP2Audit;},{"../../lib/url-shim":"url","../../report/html/renderer/util.js":97,"../audit":2}],"../audits/dobetterweb/uses-passive-event-listeners":[function(require,module,exports){'use strict';const ViolationAudit=require('../violation-audit');class PassiveEventsAudit extends ViolationAudit{static get meta(){return{id:'uses-passive-event-listeners',title:'Uses passive listeners to improve scrolling performance',failureTitle:'Does not use passive listeners to improve scrolling performance',description:'Consider marking your touch and wheel event listeners as `passive` '+'to improve your page\'s scroll performance. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/passive-event-listeners).',requiredArtifacts:['ChromeConsoleMessages']};}
static audit(artifacts){const results=ViolationAudit.getViolationResults(artifacts,/passive event listener/);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'label',itemType:'text',text:'Location'}];const details=ViolationAudit.makeTableDetails(headings,results);return{rawValue:results.length===0,extendedInfo:{value:results},details};}}
module.exports=PassiveEventsAudit;},{"../violation-audit":6}],"../audits/errors-in-console":[function(require,module,exports){'use strict';const Audit=require('./audit');class ErrorLogs extends Audit{static get meta(){return{id:'errors-in-console',title:'No browser errors logged to the console',description:'Errors logged to the console indicate unresolved problems. '+'They can come from network request failures and other browser concerns.',failureTitle:'Browser errors were logged to the console',requiredArtifacts:['ChromeConsoleMessages','RuntimeExceptions']};}
static audit(artifacts){const consoleEntries=artifacts.ChromeConsoleMessages;const runtimeExceptions=artifacts.RuntimeExceptions;const consoleRows=consoleEntries.filter(log=>log.entry&&log.entry.level==='error').map(item=>{return{source:item.entry.source,description:item.entry.text,url:item.entry.url};});const runtimeExRows=runtimeExceptions.filter(entry=>entry.exceptionDetails!==undefined).map(entry=>{const description=entry.exceptionDetails.exception?entry.exceptionDetails.exception.description:entry.exceptionDetails.text;return{source:'Runtime.exception',description,url:entry.exceptionDetails.url};});const tableRows=consoleRows.concat(runtimeExRows);const headings=[{key:'url',itemType:'url',text:'URL'},{key:'description',itemType:'code',text:'Description'}];const details=Audit.makeTableDetails(headings,tableRows);const numErrors=tableRows.length;return{score:Number(numErrors===0),rawValue:numErrors,details};}}
module.exports=ErrorLogs;},{"./audit":2}],"../audits/final-screenshot":[function(require,module,exports){'use strict';const Audit=require('./audit');const LHError=require('../lib/lh-error');class FinalScreenshot extends Audit{static get meta(){return{id:'final-screenshot',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,title:'Final Screenshot',description:'The last screenshot captured of the pageload.',requiredArtifacts:['traces']};}
static async audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];const screenshots=await artifacts.requestScreenshots(trace);const finalScreenshot=screenshots[screenshots.length-1];if(!finalScreenshot){throw new LHError(LHError.errors.NO_SCREENSHOTS);}
return{rawValue:true,details:{type:'screenshot',timestamp:finalScreenshot.timestamp,data:finalScreenshot.datauri}};}}
module.exports=FinalScreenshot;},{"../lib/lh-error":85,"./audit":2}],"../audits/font-display":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('./audit');const NetworkRequest=require('../lib/network-request');const allowedFontFaceDisplays=['block','fallback','optional','swap'];const i18n=require('../lib/i18n/i18n.js');const UIStrings={title:'All text remains visible during webfont loads',failureTitle:'Ensure text remains visible during webfont load',description:'Leverage the font-display CSS feature to ensure text is user-visible while '+'webfonts are loading. '+'[Learn more](https://developers.google.com/web/updates/2016/02/font-display).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class FontDisplay extends Audit{static get meta(){return{id:'font-display',title:str_(UIStrings.title),failureTitle:str_(UIStrings.failureTitle),description:str_(UIStrings.description),requiredArtifacts:['devtoolsLogs','Fonts']};}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[this.DEFAULT_PASS];const fontFaces=artifacts.Fonts;const fontsWithoutProperDisplay=fontFaces.filter(fontFace=>!fontFace.display||!allowedFontFaceDisplays.includes(fontFace.display));return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const results=networkRecords.filter(record=>{const isFont=record.resourceType===NetworkRequest.TYPES.Font;return isFont;}).filter(fontRecord=>{return!!fontsWithoutProperDisplay.find(fontFace=>{return!!fontFace.src&&!!fontFace.src.find(src=>fontRecord.url===src);});}).map(record=>{const wastedMs=Math.min((record.endTime-record.startTime)*1000,3000);return{url:record.url,wastedMs};});const headings=[{key:'url',itemType:'url',text:str_(i18n.UIStrings.columnURL)},{key:'wastedMs',itemType:'ms',text:str_(i18n.UIStrings.columnWastedMs)}];const details=Audit.makeTableDetails(headings,results);return{score:Number(results.length===0),rawValue:results.length===0,details};});}}
module.exports=FontDisplay;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/font-display.js");},{"../lib/i18n/i18n.js":36,"../lib/network-request":88,"./audit":2}],"../audits/image-aspect-ratio":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const THRESHOLD_PX=2;class ImageAspectRatio extends Audit{static get meta(){return{id:'image-aspect-ratio',title:'Displays images with correct aspect ratio',failureTitle:'Displays images with incorrect aspect ratio',description:'Image display dimensions should match natural aspect ratio. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/aspect-ratio).',requiredArtifacts:['ImageUsage']};}
static computeAspectRatios(image){const url=URL.elideDataURI(image.src);const actualAspectRatio=image.naturalWidth/image.naturalHeight;const displayedAspectRatio=image.width/image.height;const targetDisplayHeight=image.width/actualAspectRatio;const doRatiosMatch=Math.abs(targetDisplayHeight-image.height)<THRESHOLD_PX;if(!Number.isFinite(actualAspectRatio)||!Number.isFinite(displayedAspectRatio)){return new Error(`Invalid image sizing information ${url}`);}
return{url,displayedAspectRatio:`${image.width} x ${image.height}
        (${displayedAspectRatio.toFixed(2)})`,actualAspectRatio:`${image.naturalWidth} x ${image.naturalHeight}
        (${actualAspectRatio.toFixed(2)})`,doRatiosMatch};}
static audit(artifacts){const images=artifacts.ImageUsage;const warnings=[];const results=[];images.filter(image=>{return image.networkRecord&&image.networkRecord.mimeType!=='image/svg+xml'&&image.width&&image.height&&!image.usesObjectFit;}).forEach(image=>{const wellDefinedImage=image;const processed=ImageAspectRatio.computeAspectRatios(wellDefinedImage);if(processed instanceof Error){warnings.push(processed.message);return;}
if(!processed.doRatiosMatch)results.push(processed);});const headings=[{key:'url',itemType:'thumbnail',text:''},{key:'url',itemType:'url',text:'URL'},{key:'displayedAspectRatio',itemType:'text',text:'Aspect Ratio (Displayed)'},{key:'actualAspectRatio',itemType:'text',text:'Aspect Ratio (Actual)'}];return{rawValue:results.length===0,warnings,details:Audit.makeTableDetails(headings,results)};}}
module.exports=ImageAspectRatio;},{"../lib/url-shim":"url","./audit":2}],"../audits/is-on-https":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const Util=require('../report/html/renderer/util');const SECURE_SCHEMES=['data','https','wss','blob','chrome','chrome-extension','about'];const SECURE_DOMAINS=['localhost','127.0.0.1'];class HTTPS extends Audit{static get meta(){return{id:'is-on-https',title:'Uses HTTPS',failureTitle:'Does not use HTTPS',description:'All sites should be protected with HTTPS, even ones that don\'t handle '+'sensitive data. HTTPS prevents intruders from tampering with or passively listening '+'in on the communications between your app and your users, and is a prerequisite for '+'HTTP/2 and many new web platform APIs. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/https).',requiredArtifacts:['devtoolsLogs']};}
static isSecureRecord(record){return SECURE_SCHEMES.includes(record.parsedURL.scheme)||SECURE_SCHEMES.includes(record.protocol)||SECURE_DOMAINS.includes(record.parsedURL.host);}
static audit(artifacts){const devtoolsLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLogs).then(networkRecords=>{const insecureURLs=networkRecords.filter(record=>!HTTPS.isSecureRecord(record)).map(record=>URL.elideDataURI(record.url));let displayValue='';if(insecureURLs.length>1){displayValue=`${Util.formatNumber(insecureURLs.length)} insecure requests found`;}else if(insecureURLs.length===1){displayValue=`${insecureURLs.length} insecure request found`;}
const items=Array.from(new Set(insecureURLs)).map(url=>({url}));const headings=[{key:'url',itemType:'url',text:'Insecure URL'}];return{rawValue:items.length===0,displayValue,extendedInfo:{value:items},details:Audit.makeTableDetails(headings,items)};});}}
module.exports=HTTPS;},{"../lib/url-shim":"url","../report/html/renderer/util":97,"./audit":2}],"../audits/load-fast-enough-for-pwa":[function(require,module,exports){'use strict';const isDeepEqual=require('lodash.isequal');const Audit=require('./audit');const mobile3GThrottling=require('../config/constants').throttling.mobile3G;const MAXIMUM_TTI=10*1000;class LoadFastEnough4Pwa extends Audit{static get meta(){return{id:'load-fast-enough-for-pwa',title:'Page load is fast enough on 3G',failureTitle:'Page load is not fast enough on 3G',description:'A fast page load over a 3G network ensures a good mobile user experience. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/fast-3g).',requiredArtifacts:['traces','devtoolsLogs']};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const settingOverrides={throttlingMethod:'simulate',throttling:mobile3GThrottling};const settings=context.settings.throttlingMethod!=='provided'&&isDeepEqual(context.settings.throttling,mobile3GThrottling)?context.settings:Object.assign({},context.settings,settingOverrides);const metricComputationData={trace,devtoolsLog,settings};const tti=await artifacts.requestInteractive(metricComputationData);const score=Number(tti.timing<MAXIMUM_TTI);let displayValue;let explanation;if(!score){displayValue=[`Interactive at %d\xa0s`,tti.timing/1000];explanation='Your page loads too slowly and is not interactive within 10 seconds. '+'Look at the opportunities and diagnostics in the "Performance" section to learn how to '+'improve.';}
return{score,displayValue,explanation,rawValue:tti.timing};}}
module.exports=LoadFastEnough4Pwa;},{"../config/constants":8,"./audit":2,"lodash.isequal":178}],"../audits/mainthread-work-breakdown":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('./audit');const{taskGroups}=require('../lib/task-groups');const i18n=require('../lib/i18n/i18n.js');const UIStrings={title:'Minimizes main-thread work',failureTitle:'Minimize main-thread work',description:'Consider reducing the time spent parsing, compiling and executing JS. '+'You may find delivering smaller JS payloads helps with this.',columnCategory:'Category'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class MainThreadWorkBreakdown extends Audit{static get meta(){return{id:'mainthread-work-breakdown',title:str_(UIStrings.title),failureTitle:str_(UIStrings.failureTitle),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:1500,scoreMedian:4000};}
static getExecutionTimingsByGroup(tasks){const result=new Map();for(const task of tasks){const originalTime=result.get(task.group.id)||0;result.set(task.group.id,originalTime+task.selfTime);}
return result;}
static async audit(artifacts,context){const settings=context.settings||{};const trace=artifacts.traces[MainThreadWorkBreakdown.DEFAULT_PASS];const tasks=await artifacts.requestMainThreadTasks(trace);const multiplier=settings.throttlingMethod==='simulate'?settings.throttling.cpuSlowdownMultiplier:1;const executionTimings=MainThreadWorkBreakdown.getExecutionTimingsByGroup(tasks);let totalExecutionTime=0;const categoryTotals={};const results=Array.from(executionTimings).map(([groupId,rawDuration])=>{const duration=rawDuration*multiplier;totalExecutionTime+=duration;const categoryTotal=categoryTotals[groupId]||0;categoryTotals[groupId]=categoryTotal+duration;return{group:groupId,groupLabel:taskGroups[groupId].label,duration:duration};});const headings=[{key:'groupLabel',itemType:'text',text:str_(UIStrings.columnCategory)},{key:'duration',itemType:'ms',granularity:1,text:str_(i18n.UIStrings.columnTimeSpent)}];results.sort((a,b)=>categoryTotals[b.group]-categoryTotals[a.group]);const tableDetails=MainThreadWorkBreakdown.makeTableDetails(headings,results);const score=Audit.computeLogNormalScore(totalExecutionTime,context.options.scorePODR,context.options.scoreMedian);return{score,rawValue:totalExecutionTime,displayValue:str_(i18n.UIStrings.seconds,{timeInMs:totalExecutionTime}),details:tableDetails};}}
module.exports=MainThreadWorkBreakdown;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/mainthread-work-breakdown.js");},{"../lib/i18n/i18n.js":36,"../lib/task-groups":93,"./audit":2}],"../audits/manifest-short-name-length":[function(require,module,exports){'use strict';const Audit=require('./audit');const ManifestValues=require('../gather/computed/manifest-values');class ManifestShortNameLength extends Audit{static get meta(){return{id:'manifest-short-name-length',title:'The `short_name` won\'t be truncated on the homescreen',failureTitle:'The `short_name` will be truncated on the homescreen',description:'Make your app\'s `short_name` fewer than 12 characters to '+'ensure that it\'s not truncated on homescreens. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/manifest-short_name-is-not-truncated).',requiredArtifacts:['Manifest']};}
static async audit(artifacts,context){const manifestValues=await ManifestValues.request(context,artifacts.Manifest);if(manifestValues.isParseFailure){return{rawValue:true,notApplicable:true};}
const shortNameCheck=manifestValues.allChecks.find(i=>i.id==='hasShortName');const shortNameLengthCheck=manifestValues.allChecks.find(i=>i.id==='shortNameLength');if(shortNameCheck&&!shortNameCheck.passing){return{rawValue:true,notApplicable:true};}
if(shortNameLengthCheck&&!shortNameLengthCheck.passing){return{rawValue:false,explanation:`Failure: ${shortNameLengthCheck.failureText}.`};}
return{rawValue:true};}}
module.exports=ManifestShortNameLength;},{"../gather/computed/manifest-values":12,"./audit":2}],"../audits/manual/pwa-cross-browser":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWACrossBrowser extends ManualAudit{static get meta(){return Object.assign({id:'pwa-cross-browser',description:'To reach the most number of users, sites should work across '+'every major browser. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#site-works-cross-browser).',title:'Site works cross-browser'},super.partialMeta);}}
module.exports=PWACrossBrowser;},{"./manual-audit":4}],"../audits/manual/pwa-each-page-has-url":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWAEachPageHasURL extends ManualAudit{static get meta(){return Object.assign({id:'pwa-each-page-has-url',description:'Ensure individual pages are deep linkable via the URLs and that URLs are '+'unique for the purpose of shareability on social media. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#each-page-has-a-url).',title:'Each page has a URL'},super.partialMeta);}}
module.exports=PWAEachPageHasURL;},{"./manual-audit":4}],"../audits/manual/pwa-page-transitions":[function(require,module,exports){'use strict';const ManualAudit=require('./manual-audit');class PWAPageTransitions extends ManualAudit{static get meta(){return Object.assign({id:'pwa-page-transitions',description:'Transitions should feel snappy as you tap around, even on a slow network, a '+'key to perceived performance. [Learn more](https://developers.google.com/web/progressive-web-apps/checklist#page-transitions-dont-feel-like-they-block-on-the-network).',title:'Page transitions don\'t feel like they block on the network'},super.partialMeta);}}
module.exports=PWAPageTransitions;},{"./manual-audit":4}],"../audits/metrics/estimated-input-latency":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Estimated Input Latency',description:'The score above is an estimate of how long your app takes to respond to user '+'input, in milliseconds, during the busiest 5s window of page load. If your '+'latency is higher than 50 ms, users may perceive your app as laggy. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class EstimatedInputLatency extends Audit{static get meta(){return{id:'estimated-input-latency',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:50,scoreMedian:100};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestEstimatedInputLatency(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:str_(i18n.UIStrings.ms,{timeInMs:metricResult.timing})};}}
module.exports=EstimatedInputLatency;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/metrics/estimated-input-latency.js");},{"../../lib/i18n/i18n.js":36,"../audit":2}],"../audits/metrics/first-contentful-paint":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'First Contentful Paint',description:'First Contentful Paint marks the time at which the first text or image is '+`painted. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint).`};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class FirstContentfulPaint extends Audit{static get meta(){return{id:'first-contentful-paint',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static get defaultOptions(){return{scorePODR:2000,scoreMedian:4000};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestFirstContentfulPaint(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:str_(i18n.UIStrings.seconds,{timeInMs:metricResult.timing})};}}
module.exports=FirstContentfulPaint;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/metrics/first-contentful-paint.js");},{"../../lib/i18n/i18n.js":36,"../audit":2}],"../audits/metrics/first-cpu-idle":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'First CPU Idle',description:'First CPU Idle marks the first time at which the page\'s main thread is '+'quiet enough to handle input. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-interactive).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class FirstCPUIdle extends Audit{static get meta(){return{id:'first-cpu-idle',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:2900,scoreMedian:6500};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestFirstCPUIdle(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:str_(i18n.UIStrings.seconds,{timeInMs:metricResult.timing})};}}
module.exports=FirstCPUIdle;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/metrics/first-cpu-idle.js");},{"../../lib/i18n/i18n.js":36,"../audit":2}],"../audits/metrics/first-meaningful-paint":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'First Meaningful Paint',description:'First Meaningful Paint measures when the primary content of a page is '+'visible. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class FirstMeaningfulPaint extends Audit{static get meta(){return{id:'first-meaningful-paint',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces']};}
static get defaultOptions(){return{scorePODR:2000,scoreMedian:4000};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestFirstMeaningfulPaint(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:str_(i18n.UIStrings.seconds,{timeInMs:metricResult.timing})};}}
module.exports=FirstMeaningfulPaint;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/metrics/first-meaningful-paint.js");},{"../../lib/i18n/i18n.js":36,"../audit":2}],"../audits/metrics/interactive":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Time to Interactive',description:'Interactive marks the time at which the page is fully interactive. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class InteractiveMetric extends Audit{static get meta(){return{id:'interactive',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static get defaultOptions(){return{scorePODR:2900,scoreMedian:7300};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestInteractive(metricComputationData);const timeInMs=metricResult.timing;const extendedInfo={timeInMs,timestamp:metricResult.timestamp,optimistic:metricResult.optimisticEstimate&&metricResult.optimisticEstimate.timeInMs,pessimistic:metricResult.pessimisticEstimate&&metricResult.pessimisticEstimate.timeInMs};return{score:Audit.computeLogNormalScore(timeInMs,context.options.scorePODR,context.options.scoreMedian),rawValue:timeInMs,displayValue:str_(i18n.UIStrings.seconds,{timeInMs}),extendedInfo:{value:extendedInfo}};}}
module.exports=InteractiveMetric;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/metrics/interactive.js");},{"../../lib/i18n/i18n.js":36,"../audit":2}],"../audits/metrics/speed-index":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const i18n=require('../../lib/i18n/i18n.js');const UIStrings={title:'Speed Index',description:'Speed Index shows how quickly the contents of a page are visibly populated. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/speed-index).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class SpeedIndex extends Audit{static get meta(){return{id:'speed-index',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static get defaultOptions(){return{scorePODR:2900,scoreMedian:5800};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const metricResult=await artifacts.requestSpeedIndex(metricComputationData);return{score:Audit.computeLogNormalScore(metricResult.timing,context.options.scorePODR,context.options.scoreMedian),rawValue:metricResult.timing,displayValue:str_(i18n.UIStrings.seconds,{timeInMs:metricResult.timing})};}}
module.exports=SpeedIndex;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/metrics/speed-index.js");},{"../../lib/i18n/i18n.js":36,"../audit":2}],"../audits/metrics":[function(require,module,exports){'use strict';const Audit=require('./audit');class Metrics extends Audit{static get meta(){return{id:'metrics',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,title:'Metrics',description:'Collects all available metrics.',requiredArtifacts:['traces','devtoolsLogs']};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const traceOfTab=await artifacts.requestTraceOfTab(trace);const speedline=await artifacts.requestSpeedline(trace);const firstContentfulPaint=await artifacts.requestFirstContentfulPaint(metricComputationData);const firstMeaningfulPaint=await artifacts.requestFirstMeaningfulPaint(metricComputationData);const firstCPUIdle=await artifacts.requestFirstCPUIdle(metricComputationData);const interactive=await artifacts.requestInteractive(metricComputationData);const speedIndex=await artifacts.requestSpeedIndex(metricComputationData);const estimatedInputLatency=await artifacts.requestEstimatedInputLatency(metricComputationData);const metrics={firstContentfulPaint:firstContentfulPaint.timing,firstContentfulPaintTs:firstContentfulPaint.timestamp,firstMeaningfulPaint:firstMeaningfulPaint.timing,firstMeaningfulPaintTs:firstMeaningfulPaint.timestamp,firstCPUIdle:firstCPUIdle.timing,firstCPUIdleTs:firstCPUIdle.timestamp,interactive:interactive.timing,interactiveTs:interactive.timestamp,speedIndex:speedIndex.timing,speedIndexTs:speedIndex.timestamp,estimatedInputLatency:estimatedInputLatency.timing,estimatedInputLatencyTs:estimatedInputLatency.timestamp,observedNavigationStart:traceOfTab.timings.navigationStart,observedNavigationStartTs:traceOfTab.timestamps.navigationStart,observedFirstPaint:traceOfTab.timings.firstPaint,observedFirstPaintTs:traceOfTab.timestamps.firstPaint,observedFirstContentfulPaint:traceOfTab.timings.firstContentfulPaint,observedFirstContentfulPaintTs:traceOfTab.timestamps.firstContentfulPaint,observedFirstMeaningfulPaint:traceOfTab.timings.firstMeaningfulPaint,observedFirstMeaningfulPaintTs:traceOfTab.timestamps.firstMeaningfulPaint,observedTraceEnd:traceOfTab.timings.traceEnd,observedTraceEndTs:traceOfTab.timestamps.traceEnd,observedLoad:traceOfTab.timings.load,observedLoadTs:traceOfTab.timestamps.load,observedDomContentLoaded:traceOfTab.timings.domContentLoaded,observedDomContentLoadedTs:traceOfTab.timestamps.domContentLoaded,observedFirstVisualChange:speedline.first,observedFirstVisualChangeTs:(speedline.first+speedline.beginning)*1000,observedLastVisualChange:speedline.complete,observedLastVisualChangeTs:(speedline.complete+speedline.beginning)*1000,observedSpeedIndex:speedline.speedIndex,observedSpeedIndexTs:(speedline.speedIndex+speedline.beginning)*1000};for(const[name,value]of Object.entries(metrics)){const key=name;if(typeof value!=='undefined'){metrics[key]=Math.round(value);}}
const details={items:[metrics]};return{score:1,rawValue:interactive.timing,details};}}
module.exports=Metrics;},{"./audit":2}],"../audits/mixed-content":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');const Util=require('../report/html/renderer/util');class MixedContent extends Audit{static get meta(){return{id:'mixed-content',title:'All resources loaded are secure',failureTitle:'Some insecure resources can be upgraded to HTTPS',description:`Mixed content warnings can prevent you from upgrading to HTTPS.
      This audit shows which insecure resources this page uses that can be
      upgraded to HTTPS. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/mixed-content)`,requiredArtifacts:['devtoolsLogs','MixedContent']};}
static upgradeURL(url){const parsedURL=new URL(url);parsedURL.protocol='https:';return parsedURL.href;}
static simplifyURL(url){const parsedURL=new URL(url);parsedURL.hash='';parsedURL.search='';return parsedURL.href;}
static displayURL(url=''){const displayOptions={numPathParts:4,preserveQuery:false,preserveHost:true};return URL.getURLDisplayName(url,displayOptions);}
static audit(artifacts){const defaultLogs=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const upgradeLogs=artifacts.devtoolsLogs['mixedContentPass'];const baseHostname=new URL(artifacts.MixedContent.url).host;const computedArtifacts=[artifacts.requestNetworkRecords(defaultLogs),artifacts.requestNetworkRecords(upgradeLogs)];return Promise.all(computedArtifacts).then(([defaultRecords,upgradedRecords])=>{const insecureRecords=defaultRecords.filter(record=>!record.isSecure);const secureRecords=defaultRecords.filter(record=>record.isSecure);const upgradePassHosts=new Set();const upgradePassSecureHosts=new Set();upgradedRecords.forEach(record=>{upgradePassHosts.add(new URL(record.url).hostname);if(record.isSecure&&record.finished&&!record.failed){upgradePassSecureHosts.add(new URL(record.url).hostname);}});const seen=new Set();const upgradeableResources=[];for(const record of insecureRecords){const simpleUrl=this.simplifyURL(record.url);if(seen.has(simpleUrl))continue;seen.add(simpleUrl);const resource={host:new URL(record.url).hostname,fullUrl:record.url,referrerDocUrl:this.displayURL(record.documentURL)};if(!upgradePassSecureHosts.has(resource.host))continue;if(!resource.referrerDocUrl.includes(baseHostname))continue;upgradeableResources.push(resource);}
const displayValue=`${Util.formatNumber(upgradeableResources.length)}
          ${upgradeableResources.length===1?'request':'requests'}`;const headings=[{key:'fullUrl',itemType:'url',text:'URL'}];const details=Audit.makeTableDetails(headings,upgradeableResources);const totalRecords=defaultRecords.length;const score=(secureRecords.length+0.5*upgradeableResources.length)/totalRecords;return{rawValue:upgradeableResources.length===0,score,displayValue:displayValue,details};});}}
module.exports=MixedContent;},{"../lib/url-shim":"url","../report/html/renderer/util":97,"./audit":2}],"../audits/network-requests":[function(require,module,exports){'use strict';const Audit=require('./audit');const URL=require('../lib/url-shim');class NetworkRequests extends Audit{static get meta(){return{id:'network-requests',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,title:'Network Requests',description:'Lists the network requests that were made during page load.',requiredArtifacts:['devtoolsLogs']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestNetworkRecords(devtoolsLog).then(records=>{const earliestStartTime=records.reduce((min,record)=>Math.min(min,record.startTime),Infinity);const timeToMs=time=>time<earliestStartTime||!Number.isFinite(time)?undefined:(time-earliestStartTime)*1000;const results=records.map(record=>{return{url:URL.elideDataURI(record.url),startTime:timeToMs(record.startTime),endTime:timeToMs(record.endTime),transferSize:record.transferSize,statusCode:record.statusCode,mimeType:record.mimeType,resourceType:record.resourceType};});const headings=[{key:'url',itemType:'url',text:'URL'},{key:'startTime',itemType:'ms',granularity:1,text:'Start Time'},{key:'endTime',itemType:'ms',granularity:1,text:'End Time'},{key:'transferSize',itemType:'bytes',displayUnit:'kb',granularity:1,text:'Transfer Size'},{key:'statusCode',itemType:'text',text:'Status Code'},{key:'mimeType',itemType:'text',text:'MIME Type'},{key:'resourceType',itemType:'text',text:'Resource Type'}];const tableDetails=Audit.makeTableDetails(headings,results);return{score:1,rawValue:results.length,details:tableDetails};});}}
module.exports=NetworkRequests;},{"../lib/url-shim":"url","./audit":2}],"../audits/predictive-perf":[function(require,module,exports){'use strict';const Audit=require('./audit');const Util=require('../report/html/renderer/util');const SCORING_POINT_OF_DIMINISHING_RETURNS=1700;const SCORING_MEDIAN=10000;class PredictivePerf extends Audit{static get meta(){return{id:'predictive-perf',title:'Predicted Performance (beta)',description:'Predicted performance evaluates how your site will perform under '+'a 3G connection on a mobile device.',scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['traces','devtoolsLogs']};}
static async audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const settings={};const fcp=await artifacts.requestLanternFirstContentfulPaint({trace,devtoolsLog,settings});const fmp=await artifacts.requestLanternFirstMeaningfulPaint({trace,devtoolsLog,settings});const tti=await artifacts.requestLanternInteractive({trace,devtoolsLog,settings});const ttfcpui=await artifacts.requestLanternFirstCPUIdle({trace,devtoolsLog,settings});const si=await artifacts.requestLanternSpeedIndex({trace,devtoolsLog,settings});const eil=await artifacts.requestLanternEstimatedInputLatency({trace,devtoolsLog,settings});const values={roughEstimateOfFCP:fcp.timing,optimisticFCP:fcp.optimisticEstimate.timeInMs,pessimisticFCP:fcp.pessimisticEstimate.timeInMs,roughEstimateOfFMP:fmp.timing,optimisticFMP:fmp.optimisticEstimate.timeInMs,pessimisticFMP:fmp.pessimisticEstimate.timeInMs,roughEstimateOfTTI:tti.timing,optimisticTTI:tti.optimisticEstimate.timeInMs,pessimisticTTI:tti.pessimisticEstimate.timeInMs,roughEstimateOfTTFCPUI:ttfcpui.timing,optimisticTTFCPUI:ttfcpui.optimisticEstimate.timeInMs,pessimisticTTFCPUI:ttfcpui.pessimisticEstimate.timeInMs,roughEstimateOfSI:si.timing,optimisticSI:si.optimisticEstimate.timeInMs,pessimisticSI:si.pessimisticEstimate.timeInMs,roughEstimateOfEIL:eil.timing,optimisticEIL:eil.optimisticEstimate.timeInMs,pessimisticEIL:eil.pessimisticEstimate.timeInMs};const score=Audit.computeLogNormalScore(values.roughEstimateOfTTI,SCORING_POINT_OF_DIMINISHING_RETURNS,SCORING_MEDIAN);return{score,rawValue:values.roughEstimateOfTTI,displayValue:Util.formatMilliseconds(values.roughEstimateOfTTI),details:{items:[values]}};}}
module.exports=PredictivePerf;},{"../report/html/renderer/util":97,"./audit":2}],"../audits/redirects-http":[function(require,module,exports){'use strict';const Audit=require('./audit');class RedirectsHTTP extends Audit{static get meta(){return{id:'redirects-http',title:'Redirects HTTP traffic to HTTPS',failureTitle:'Does not redirect HTTP traffic to HTTPS',description:'If you\'ve already set up HTTPS, make sure that you redirect all HTTP '+'traffic to HTTPS. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-redirects-to-https).',requiredArtifacts:['HTTPRedirect']};}
static audit(artifacts){return{rawValue:artifacts.HTTPRedirect.value};}}
module.exports=RedirectsHTTP;},{"./audit":2}],"../audits/redirects":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('./audit');const UnusedBytes=require('./byte-efficiency/byte-efficiency-audit');const i18n=require('../lib/i18n/i18n.js');const UIStrings={title:'Avoid multiple page redirects',description:'Redirects introduce additional delays before the page can be loaded. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/redirects).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class Redirects extends Audit{static get meta(){return{id:'redirects',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.NUMERIC,requiredArtifacts:['URL','devtoolsLogs','traces']};}
static async audit(artifacts,context){const settings=context.settings;const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const traceOfTab=await artifacts.requestTraceOfTab(trace);const networkRecords=await artifacts.requestNetworkRecords(devtoolsLog);const mainResource=await artifacts.requestMainResource({URL:artifacts.URL,devtoolsLog});const metricComputationData={trace,devtoolsLog,traceOfTab,networkRecords,settings};const metricResult=await artifacts.requestLanternInteractive(metricComputationData);const nodeTimingsByUrl=new Map();for(const[node,timing]of metricResult.pessimisticEstimate.nodeTimings.entries()){if(node.type==='network'){const networkNode=node;nodeTimingsByUrl.set(networkNode.record.url,timing);}}
const redirectRequests=Array.from(mainResource.redirects||[]);redirectRequests.push(mainResource);let totalWastedMs=0;const pageRedirects=[];if(redirectRequests.length>1){pageRedirects.push({url:`(Initial: ${redirectRequests[0].url})`,wastedMs:0});}
for(let i=1;i<redirectRequests.length;i++){const initialRequest=redirectRequests[i-1];const redirectedRequest=redirectRequests[i];const initialTiming=nodeTimingsByUrl.get(initialRequest.url);const redirectedTiming=nodeTimingsByUrl.get(redirectedRequest.url);if(!initialTiming||!redirectedTiming){throw new Error('Could not find redirects in graph');}
const wastedMs=redirectedTiming.startTime-initialTiming.startTime;totalWastedMs+=wastedMs;pageRedirects.push({url:redirectedRequest.url,wastedMs});}
const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'wastedMs',valueType:'timespanMs',label:str_(i18n.UIStrings.columnTimeSpent)}];const details=Audit.makeOpportunityDetails(headings,pageRedirects,totalWastedMs);return{score:redirectRequests.length<=2?1:UnusedBytes.scoreForWastedMs(totalWastedMs),rawValue:totalWastedMs,displayValue:totalWastedMs?str_(i18n.UIStrings.displayValueMsSavings,{wastedMs:totalWastedMs}):'',extendedInfo:{value:{wastedMs:totalWastedMs}},details};}}
module.exports=Redirects;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/redirects.js");},{"../lib/i18n/i18n.js":36,"./audit":2,"./byte-efficiency/byte-efficiency-audit":3}],"../audits/screenshot-thumbnails":[function(require,module,exports){'use strict';const Audit=require('./audit');const LHError=require('../lib/lh-error');const jpeg=require('jpeg-js');const NUMBER_OF_THUMBNAILS=10;const THUMBNAIL_WIDTH=120;class ScreenshotThumbnails extends Audit{static get meta(){return{id:'screenshot-thumbnails',scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,title:'Screenshot Thumbnails',description:'This is what the load of your site looked like.',requiredArtifacts:['traces','devtoolsLogs']};}
static scaleImageToThumbnail(imageData){const scaledWidth=THUMBNAIL_WIDTH;const scaleFactor=imageData.width/scaledWidth;const scaledHeight=Math.floor(imageData.height/scaleFactor);const outPixels=new Uint8Array(scaledWidth*scaledHeight*4);for(let i=0;i<scaledWidth;i++){for(let j=0;j<scaledHeight;j++){const origX=Math.floor(i*scaleFactor);const origY=Math.floor(j*scaleFactor);const origPos=(origY*imageData.width+origX)*4;const outPos=(j*scaledWidth+i)*4;outPixels[outPos]=imageData.data[origPos];outPixels[outPos+1]=imageData.data[origPos+1];outPixels[outPos+2]=imageData.data[origPos+2];outPixels[outPos+3]=imageData.data[origPos+3];}}
return{width:scaledWidth,height:scaledHeight,data:outPixels};}
static async audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const cachedThumbnails=new Map();const speedline=await artifacts.requestSpeedline(trace);let minimumTimelineDuration=context.options.minimumTimelineDuration||3000;if(context.settings.throttlingMethod!=='simulate'){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const metricComputationData={trace,devtoolsLog,settings:context.settings};const tti=artifacts.requestInteractive(metricComputationData);try{minimumTimelineDuration=Math.max((await tti).timing,minimumTimelineDuration);}catch(_){}}
const thumbnails=[];const analyzedFrames=speedline.frames.filter(frame=>!frame.isProgressInterpolated());const maxFrameTime=speedline.complete||Math.max(...speedline.frames.map(frame=>frame.getTimeStamp()-speedline.beginning));const timelineEnd=Math.max(maxFrameTime,minimumTimelineDuration);if(!analyzedFrames.length||!Number.isFinite(timelineEnd)){throw new LHError(LHError.errors.INVALID_SPEEDLINE);}
for(let i=1;i<=NUMBER_OF_THUMBNAILS;i++){const targetTimestamp=speedline.beginning+timelineEnd*i/NUMBER_OF_THUMBNAILS;let frameForTimestamp=null;if(i===NUMBER_OF_THUMBNAILS){frameForTimestamp=analyzedFrames[analyzedFrames.length-1];}else{analyzedFrames.forEach(frame=>{if(frame.getTimeStamp()<=targetTimestamp){frameForTimestamp=frame;}});}
let base64Data;if(cachedThumbnails.has(frameForTimestamp)){base64Data=cachedThumbnails.get(frameForTimestamp);}else{const imageData=frameForTimestamp.getParsedImage();const thumbnailImageData=ScreenshotThumbnails.scaleImageToThumbnail(imageData);base64Data=jpeg.encode(thumbnailImageData,90).data.toString('base64');cachedThumbnails.set(frameForTimestamp,base64Data);}
thumbnails.push({timing:Math.round(targetTimestamp-speedline.beginning),timestamp:targetTimestamp*1000,data:base64Data});}
return{score:1,rawValue:thumbnails.length>0,details:{type:'filmstrip',scale:timelineEnd,items:thumbnails}};}}
module.exports=ScreenshotThumbnails;},{"../lib/lh-error":85,"./audit":2,"jpeg-js":175}],"../audits/seo/canonical":[function(require,module,exports){'use strict';const Audit=require('../audit');const LinkHeader=require('http-link-header');const URL=require('../../lib/url-shim');const LINK_HEADER='link';function getCanonicalLinksFromHeader(headerValue){const linkHeader=LinkHeader.parse(headerValue);return linkHeader.get('rel','canonical').map(c=>c.uri);}
function getHreflangsFromHeader(headerValue){const linkHeader=LinkHeader.parse(headerValue);return linkHeader.get('rel','alternate').map(h=>h.uri);}
function isValidRelativeOrAbsoluteURL(url){try{new URL(url,'https://example.com/');return true;}catch(e){return false;}}
function getPrimaryDomain(url){return url.hostname.split('.').slice(-2).join('.');}
class Canonical extends Audit{static get meta(){return{id:'canonical',title:'Document has a valid `rel=canonical`',failureTitle:'Document does not have a valid `rel=canonical`',description:'Canonical links suggest which URL to show in search results. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/canonical).',requiredArtifacts:['Canonical','Hreflang','URL']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestMainResource({devtoolsLog,URL:artifacts.URL}).then(mainResource=>{const baseURL=new URL(mainResource.url);let canonicals=[];let hreflangs=[];mainResource.responseHeaders&&mainResource.responseHeaders.filter(h=>h.name.toLowerCase()===LINK_HEADER).forEach(h=>{canonicals=canonicals.concat(getCanonicalLinksFromHeader(h.value));hreflangs=hreflangs.concat(getHreflangsFromHeader(h.value));});for(const canonical of artifacts.Canonical){if(canonical!==null){canonicals.push(canonical);}}
canonicals=Array.from(new Set(canonicals));artifacts.Hreflang.forEach(({href})=>hreflangs.push(href));hreflangs=hreflangs.filter(href=>isValidRelativeOrAbsoluteURL(href)).map(href=>new URL(href,baseURL).href);if(canonicals.length===0){return{rawValue:true,notApplicable:true};}
if(canonicals.length>1){return{rawValue:false,explanation:`Multiple conflicting URLs (${canonicals.join(', ')})`};}
const canonical=canonicals[0];if(!isValidRelativeOrAbsoluteURL(canonical)){return{rawValue:false,explanation:`Invalid URL (${canonical})`};}
if(!URL.isValid(canonical)){return{rawValue:false,explanation:`Relative URL (${canonical})`};}
const canonicalURL=new URL(canonical);if(hreflangs.includes(baseURL.href)&&hreflangs.includes(canonicalURL.href)&&baseURL.href!==canonicalURL.href){return{rawValue:false,explanation:`Points to another hreflang location (${baseURL.href})`};}
if(getPrimaryDomain(canonicalURL)!==getPrimaryDomain(baseURL)){return{rawValue:false,explanation:`Points to a different domain (${canonicalURL})`};}
if(canonicalURL.origin===baseURL.origin&&canonicalURL.pathname==='/'&&baseURL.pathname!=='/'){return{rawValue:false,explanation:'Points to a root of the same origin'};}
return{rawValue:true};});}}
module.exports=Canonical;},{"../../lib/url-shim":"url","../audit":2,"http-link-header":163}],"../audits/seo/font-size":[function(require,module,exports){'use strict';const URL=require('../../lib/url-shim');const Audit=require('../audit');const ViewportAudit=require('../viewport');const MINIMAL_PERCENTAGE_OF_LEGIBLE_TEXT=60;function getUniqueFailingRules(fontSizeArtifact){const failingRules=new Map();fontSizeArtifact.forEach(({cssRule,fontSize,textLength,node})=>{const artifactId=getFontArtifactId(cssRule,node);const failingRule=failingRules.get(artifactId);if(!failingRule){failingRules.set(artifactId,{node,cssRule,fontSize,textLength});}else{failingRule.textLength+=textLength;}});return[...failingRules.values()];}
function getAttributeMap(attributes=[]){const map=new Map();for(let i=0;i<attributes.length;i+=2){const name=attributes[i].toLowerCase();const value=attributes[i+1].trim();if(value){map.set(name,value);}}
return map;}
function getSelector(node){const attributeMap=getAttributeMap(node.attributes);if(attributeMap.has('id')){return'#'+attributeMap.get('id');}else{const attrClass=attributeMap.get('class');if(attrClass){return'.'+attrClass.split(/\s+/).join('.');}}
return node.localName.toLowerCase();}
function nodeToTableNode(node){const attributes=node.attributes||[];const attributesString=attributes.map((value,idx)=>idx%2===0?` ${value}`:`="${value}"`).join('');return{type:'node',selector:node.parentNode?getSelector(node.parentNode):'',snippet:`<${node.localName}${attributesString}>`};}
function findStyleRuleSource(baseURL,styleDeclaration,node){if(!styleDeclaration||styleDeclaration.type==='Attributes'||styleDeclaration.type==='Inline')
{return{selector:nodeToTableNode(node),source:baseURL};}
if(styleDeclaration.parentRule&&styleDeclaration.parentRule.origin==='user-agent'){return{selector:styleDeclaration.parentRule.selectors.map(item=>item.text).join(', '),source:'User Agent Stylesheet'};}
if(styleDeclaration.type==='Regular'&&styleDeclaration.parentRule){const rule=styleDeclaration.parentRule;const stylesheet=styleDeclaration.stylesheet;if(stylesheet){let source;const selector=rule.selectors.map(item=>item.text).join(', ');if(stylesheet.sourceURL){const url=new URL(stylesheet.sourceURL,baseURL);const range=styleDeclaration.range;source=`${url.href}`;if(range){const absoluteStartLine=range.startLine+stylesheet.startLine+1;const absoluteStartColumn=range.startColumn+stylesheet.startColumn+1;source+=`:${absoluteStartLine}:${absoluteStartColumn}`;}}else{source='dynamic';}
return{selector,source};}}
return{selector:'',source:'Unknown'};}
function getFontArtifactId(styleDeclaration,node){if(styleDeclaration&&styleDeclaration.type==='Regular'){const startLine=styleDeclaration.range?styleDeclaration.range.startLine:0;const startColumn=styleDeclaration.range?styleDeclaration.range.startColumn:0;return`${styleDeclaration.styleSheetId}@${startLine}:${startColumn}`;}else{return`node_${node.nodeId}`;}}
class FontSize extends Audit{static get meta(){return{id:'font-size',title:'Document uses legible font sizes',failureTitle:'Document doesn\'t use legible font sizes',description:'Font sizes less than 12px are too small to be legible and require mobile '+'visitors to “pinch to zoom” in order to read. Strive to have >60% of page text ≥12px. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/font-sizes).',requiredArtifacts:['FontSize','URL','Viewport']};}
static audit(artifacts){const hasViewportSet=ViewportAudit.audit(artifacts).rawValue;if(!hasViewportSet){return{rawValue:false,explanation:'Text is illegible because of a missing viewport config'};}
const{analyzedFailingNodesData,analyzedFailingTextLength,failingTextLength,visitedTextLength,totalTextLength}=artifacts.FontSize;if(totalTextLength===0){return{rawValue:true};}
const failingRules=getUniqueFailingRules(analyzedFailingNodesData);const percentageOfPassingText=(visitedTextLength-failingTextLength)/visitedTextLength*100;const pageUrl=artifacts.URL.finalUrl;const headings=[{key:'source',itemType:'url',text:'Source'},{key:'selector',itemType:'code',text:'Selector'},{key:'coverage',itemType:'text',text:'% of Page Text'},{key:'fontSize',itemType:'text',text:'Font Size'}];const tableData=failingRules.sort((a,b)=>b.textLength-a.textLength).map(({cssRule,textLength,fontSize,node})=>{const percentageOfAffectedText=textLength/visitedTextLength*100;const origin=findStyleRuleSource(pageUrl,cssRule,node);return{source:origin.source,selector:origin.selector,coverage:`${percentageOfAffectedText.toFixed(2)}%`,fontSize:`${fontSize}px`};});if(analyzedFailingTextLength<failingTextLength){const percentageOfUnanalyzedFailingText=(failingTextLength-analyzedFailingTextLength)/visitedTextLength*100;tableData.push({source:'Add\'l illegible text',selector:'',coverage:`${percentageOfUnanalyzedFailingText.toFixed(2)}%`,fontSize:'< 12px'});}
if(percentageOfPassingText>0){tableData.push({source:'Legible text',selector:'',coverage:`${percentageOfPassingText.toFixed(2)}%`,fontSize:'≥ 12px'});}
const displayValue=['%.1d% legible text',percentageOfPassingText];const details=Audit.makeTableDetails(headings,tableData);const passed=percentageOfPassingText>=MINIMAL_PERCENTAGE_OF_LEGIBLE_TEXT;let explanation;if(!passed){const percentageOfFailingText=parseFloat((100-percentageOfPassingText).toFixed(2));let disclaimer='';if(visitedTextLength<totalTextLength){const percentageOfVisitedText=visitedTextLength/totalTextLength*100;disclaimer=` (based on ${percentageOfVisitedText.toFixed()}% sample)`;}
explanation=`${percentageOfFailingText}% of text is too small${disclaimer}.`;}
return{rawValue:passed,details,displayValue,explanation};}}
module.exports=FontSize;},{"../../lib/url-shim":"url","../audit":2,"../viewport":"../audits/viewport"}],"../audits/seo/hreflang":[function(require,module,exports){(function(global){'use strict';const Audit=require('../audit');const LinkHeader=require('http-link-header');const VALID_LANGS=importValidLangs();const LINK_HEADER='link';const NO_LANGUAGE='x-default';function importValidLangs(){const axeCache=global.axe;global.axe={utils:{}};require('axe-core/lib/commons/utils/valid-langs.js');const validLangs=global.axe.utils.validLangs();global.axe=axeCache;return validLangs;}
function isValidHreflang(hreflang){if(hreflang.toLowerCase()===NO_LANGUAGE){return true;}
const[lang]=hreflang.split('-');return VALID_LANGS.includes(lang.toLowerCase());}
function headerHasValidHreflangs(headerValue){const linkHeader=LinkHeader.parse(headerValue);return linkHeader.get('rel','alternate').every(link=>!!link.hreflang&&isValidHreflang(link.hreflang));}
class Hreflang extends Audit{static get meta(){return{id:'hreflang',title:'Document has a valid `hreflang`',failureTitle:'Document doesn\'t have a valid `hreflang`',description:'hreflang links tell search engines what version of a page they should '+'list in search results for a given language or region. [Learn more]'+'(https://developers.google.com/web/tools/lighthouse/audits/hreflang).',requiredArtifacts:['Hreflang','URL']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const URL=artifacts.URL;return artifacts.requestMainResource({devtoolsLog,URL}).then(mainResource=>{const invalidHreflangs=[];if(artifacts.Hreflang){artifacts.Hreflang.forEach(({href,hreflang})=>{if(!isValidHreflang(hreflang)){invalidHreflangs.push({source:{type:'node',snippet:`<link name="alternate" hreflang="${hreflang}" href="${href}" />`}});}});}
mainResource.responseHeaders&&mainResource.responseHeaders.filter(h=>h.name.toLowerCase()===LINK_HEADER&&!headerHasValidHreflangs(h.value)).forEach(h=>invalidHreflangs.push({source:`${h.name}: ${h.value}`}));const headings=[{key:'source',itemType:'code',text:'Source'}];const details=Audit.makeTableDetails(headings,invalidHreflangs);return{rawValue:invalidHreflangs.length===0,details};});}}
module.exports=Hreflang;}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../audit":2,"axe-core/lib/commons/utils/valid-langs.js":152,"http-link-header":163}],"../audits/seo/http-status-code":[function(require,module,exports){'use strict';const Audit=require('../audit');const HTTP_UNSUCCESSFUL_CODE_LOW=400;const HTTP_UNSUCCESSFUL_CODE_HIGH=599;class HTTPStatusCode extends Audit{static get meta(){return{id:'http-status-code',title:'Page has successful HTTP status code',failureTitle:'Page has unsuccessful HTTP status code',description:'Pages with unsuccessful HTTP status codes may not be indexed properly. '+'[Learn more]'+'(https://developers.google.com/web/tools/lighthouse/audits/successful-http-code).',requiredArtifacts:['devtoolsLogs','URL']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const URL=artifacts.URL;return artifacts.requestMainResource({devtoolsLog,URL}).then(mainResource=>{const statusCode=mainResource.statusCode;if(statusCode>=HTTP_UNSUCCESSFUL_CODE_LOW&&statusCode<=HTTP_UNSUCCESSFUL_CODE_HIGH){return{rawValue:false,displayValue:`${statusCode}`};}
return{rawValue:true};});}}
module.exports=HTTPStatusCode;},{"../audit":2}],"../audits/seo/is-crawlable":[function(require,module,exports){'use strict';const Audit=require('../audit');const robotsParser=require('robots-parser');const URL=require('../../lib/url-shim');const BLOCKLIST=new Set(['noindex','none']);const ROBOTS_HEADER='x-robots-tag';const UNAVAILABLE_AFTER='unavailable_after';function isUnavailable(directive){const parts=directive.split(':');if(parts.length<=1||parts[0]!==UNAVAILABLE_AFTER){return false;}
const date=Date.parse(parts.slice(1).join(':'));return!isNaN(date)&&date<Date.now();}
function hasBlockingDirective(directives){return directives.split(',').map(d=>d.toLowerCase().trim()).some(d=>BLOCKLIST.has(d)||isUnavailable(d));}
function hasUserAgent(directives){const parts=directives.match(/^([^,:]+):/);return!!parts&&parts[1].toLowerCase()!==UNAVAILABLE_AFTER;}
class IsCrawlable extends Audit{static get meta(){return{id:'is-crawlable',title:'Page isn’t blocked from indexing',failureTitle:'Page is blocked from indexing',description:'Search engines are unable to include your pages in search results '+'if they don\'t have permission to crawl them. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/indexing).',requiredArtifacts:['MetaRobots','RobotsTxt','URL']};}
static audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];return artifacts.requestMainResource({devtoolsLog,URL:artifacts.URL}).then(mainResource=>{const blockingDirectives=[];if(artifacts.MetaRobots){const isBlocking=hasBlockingDirective(artifacts.MetaRobots);if(isBlocking){blockingDirectives.push({source:{type:'node',snippet:`<meta name="robots" content="${artifacts.MetaRobots}" />`}});}}
mainResource.responseHeaders&&mainResource.responseHeaders.filter(h=>h.name.toLowerCase()===ROBOTS_HEADER&&!hasUserAgent(h.value)&&hasBlockingDirective(h.value)).forEach(h=>blockingDirectives.push({source:`${h.name}: ${h.value}`}));if(artifacts.RobotsTxt.content){const robotsFileUrl=new URL('/robots.txt',mainResource.url);const robotsTxt=robotsParser(robotsFileUrl.href,artifacts.RobotsTxt.content);if(!robotsTxt.isAllowed(mainResource.url)){blockingDirectives.push({source:{type:'url',value:robotsFileUrl.href}});}}
const headings=[{key:'source',itemType:'code',text:'Blocking Directive Source'}];const details=Audit.makeTableDetails(headings,blockingDirectives);return{rawValue:blockingDirectives.length===0,details};});}}
module.exports=IsCrawlable;},{"../../lib/url-shim":"url","../audit":2,"robots-parser":183}],"../audits/seo/link-text":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const BLOCKLIST=new Set(['click here','click this','go','here','this','start','right here','more','learn more']);class LinkText extends Audit{static get meta(){return{id:'link-text',title:'Links have descriptive text',failureTitle:'Links do not have descriptive text',description:'Descriptive link text helps search engines understand your content. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/descriptive-link-text).',requiredArtifacts:['URL','CrawlableLinks']};}
static audit(artifacts){const failingLinks=artifacts.CrawlableLinks.filter(link=>{if(link.href.toLowerCase().startsWith('javascript:')||URL.equalWithExcludedFragments(link.href,artifacts.URL.finalUrl))
{return false;}
return BLOCKLIST.has(link.text.trim().toLowerCase());});const headings=[{key:'href',itemType:'url',text:'Link destination'},{key:'text',itemType:'text',text:'Link Text'}];const details=Audit.makeTableDetails(headings,failingLinks,{});let displayValue;if(failingLinks.length){displayValue=failingLinks.length>1?`${failingLinks.length} links found`:'1 link found';}
return{rawValue:failingLinks.length===0,details,displayValue};}}
module.exports=LinkText;},{"../../lib/url-shim":"url","../audit":2}],"../audits/seo/manual/mobile-friendly":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class MobileFriendly extends ManualAudit{static get meta(){return Object.assign({id:'mobile-friendly',description:'Take the [Mobile-Friendly Test](https://search.google.com/test/mobile-friendly) to check for audits not covered by Lighthouse, like sizing tap targets appropriately. [Learn more](https://developers.google.com/search/mobile-sites/).',title:'Page is mobile friendly'},super.partialMeta);}}
module.exports=MobileFriendly;},{"../../manual/manual-audit":4}],"../audits/seo/manual/structured-data":[function(require,module,exports){'use strict';const ManualAudit=require('../../manual/manual-audit');class StructuredData extends ManualAudit{static get meta(){return Object.assign({id:'structured-data',description:'Run the [Structured Data Testing Tool](https://search.google.com/structured-data/testing-tool/) and the [Structured Data Linter](http://linter.structured-data.org/) to validate structured data. [Learn more](https://developers.google.com/search/docs/guides/mark-up-content).',title:'Structured data is valid'},super.partialMeta);}}
module.exports=StructuredData;},{"../../manual/manual-audit":4}],"../audits/seo/meta-description":[function(require,module,exports){'use strict';const Audit=require('../audit');class Description extends Audit{static get meta(){return{id:'meta-description',title:'Document has a meta description',failureTitle:'Document does not have a meta description',description:'Meta descriptions may be included in search results to concisely summarize '+'page content. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/description).',requiredArtifacts:['MetaDescription']};}
static audit(artifacts){if(artifacts.MetaDescription===null){return{rawValue:false};}
if(artifacts.MetaDescription.trim().length===0){return{rawValue:false,explanation:'Description text is empty.'};}
return{rawValue:true};}}
module.exports=Description;},{"../audit":2}],"../audits/seo/plugins":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const JAVA_APPLET_TYPE='application/x-java-applet';const JAVA_BEAN_TYPE='application/x-java-bean';const TYPE_BLOCKLIST=new Set(['application/x-shockwave-flash',JAVA_APPLET_TYPE,JAVA_BEAN_TYPE,'application/x-silverlight','application/x-silverlight-2']);const FILE_EXTENSION_BLOCKLIST=new Set(['swf','flv','class','xap']);const SOURCE_PARAMS=new Set(['code','movie','source','src']);function isPluginType(type){type=type.trim().toLowerCase();return TYPE_BLOCKLIST.has(type)||type.startsWith(JAVA_APPLET_TYPE)||type.startsWith(JAVA_BEAN_TYPE);}
function isPluginURL(url){try{const filePath=new URL(url,'http://example.com').pathname;const parts=filePath.split('.');if(parts.length<2){return false;}
const part=parts.pop();return FILE_EXTENSION_BLOCKLIST.has(part.trim().toLowerCase());}catch(e){return false;}}
class Plugins extends Audit{static get meta(){return{id:'plugins',title:'Document avoids plugins',failureTitle:'Document uses plugins',description:'Search engines can\'t index plugin content, and '+'many devices restrict plugins or don\'t support them. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/plugins).',requiredArtifacts:['EmbeddedContent']};}
static audit(artifacts){const plugins=artifacts.EmbeddedContent.filter(item=>{if(item.tagName==='APPLET'){return true;}
if((item.tagName==='EMBED'||item.tagName==='OBJECT')&&item.type&&isPluginType(item.type))
{return true;}
const embedSrc=item.src||item.code;if(item.tagName==='EMBED'&&embedSrc&&isPluginURL(embedSrc)){return true;}
if(item.tagName==='OBJECT'&&item.data&&isPluginURL(item.data)){return true;}
const failingParams=item.params.filter(param=>SOURCE_PARAMS.has(param.name.trim().toLowerCase())&&isPluginURL(param.value));return failingParams.length>0;}).map(plugin=>{const tagName=plugin.tagName.toLowerCase();const attributeKeys=['src','data','code','type'];const attributes=attributeKeys.reduce((result,attr)=>{if(plugin[attr]!==null){result+=` ${attr}="${plugin[attr]}"`;}
return result;},'');const params=plugin.params.filter(param=>SOURCE_PARAMS.has(param.name.trim().toLowerCase())).map(param=>`<param ${param.name}="${param.value}" />`).join('');return{source:{type:'node',snippet:`<${tagName}${attributes}>${params}</${tagName}>`}};});const headings=[{key:'source',itemType:'code',text:'Element source'}];const details=Audit.makeTableDetails(headings,plugins);return{rawValue:plugins.length===0,details};}}
module.exports=Plugins;},{"../../lib/url-shim":"url","../audit":2}],"../audits/seo/robots-txt":[function(require,module,exports){'use strict';const Audit=require('../audit');const URL=require('../../lib/url-shim');const HTTP_CLIENT_ERROR_CODE_LOW=400;const HTTP_SERVER_ERROR_CODE_LOW=500;const DIRECTIVE_SITEMAP='sitemap';const DIRECTIVE_USER_AGENT='user-agent';const DIRECTIVE_ALLOW='allow';const DIRECTIVE_DISALLOW='disallow';const DIRECTIVES_GROUP_MEMBERS=new Set([DIRECTIVE_ALLOW,DIRECTIVE_DISALLOW]);const DIRECTIVE_SAFELIST=new Set([DIRECTIVE_USER_AGENT,DIRECTIVE_DISALLOW,DIRECTIVE_ALLOW,DIRECTIVE_SITEMAP,'crawl-delay','clean-param','host','request-rate','visit-time','noindex']);const SITEMAP_VALID_PROTOCOLS=new Set(['https:','http:','ftp:']);function verifyDirective(directiveName,directiveValue){if(!DIRECTIVE_SAFELIST.has(directiveName)){throw new Error('Unknown directive');}
if(directiveName===DIRECTIVE_SITEMAP){let sitemapUrl;try{sitemapUrl=new URL(directiveValue);}catch(e){throw new Error('Invalid sitemap URL');}
if(!SITEMAP_VALID_PROTOCOLS.has(sitemapUrl.protocol)){throw new Error('Invalid sitemap URL protocol');}}
if(directiveName===DIRECTIVE_USER_AGENT&&!directiveValue){throw new Error('No user-agent specified');}
if(directiveName===DIRECTIVE_ALLOW||directiveName===DIRECTIVE_DISALLOW){if(directiveValue!==''&&directiveValue[0]!=='/'&&directiveValue[0]!=='*'){throw new Error('Pattern should either be empty, start with "/" or "*"');}
const dollarIndex=directiveValue.indexOf('$');if(dollarIndex!==-1&&dollarIndex!==directiveValue.length-1){throw new Error('"$" should only be used at the end of the pattern');}}}
function parseLine(line){const hashIndex=line.indexOf('#');if(hashIndex!==-1){line=line.substr(0,hashIndex);}
line=line.trim();if(line.length===0){return null;}
const colonIndex=line.indexOf(':');if(colonIndex===-1){throw new Error('Syntax not understood');}
const directiveName=line.slice(0,colonIndex).trim().toLowerCase();const directiveValue=line.slice(colonIndex+1).trim();verifyDirective(directiveName,directiveValue);return{directive:directiveName,value:directiveValue};}
function validateRobots(content){const errors=[];let inGroup=false;content.split(/\r\n|\r|\n/).forEach((line,index)=>{let parsedLine;try{parsedLine=parseLine(line);}catch(e){errors.push({index:(index+1).toString(),line:line,message:e.message.toString()});}
if(!parsedLine){return;}
if(parsedLine.directive===DIRECTIVE_USER_AGENT){inGroup=true;}else if(!inGroup&&DIRECTIVES_GROUP_MEMBERS.has(parsedLine.directive)){errors.push({index:(index+1).toString(),line:line,message:'No user-agent specified'});}});return errors;}
class RobotsTxt extends Audit{static get meta(){return{id:'robots-txt',title:'robots.txt is valid',failureTitle:'robots.txt is not valid',description:'If your robots.txt file is malformed, crawlers may not be able to understand '+'how you want your website to be crawled or indexed.',requiredArtifacts:['RobotsTxt']};}
static audit(artifacts){const{status,content}=artifacts.RobotsTxt;if(!status){return{rawValue:false,explanation:'Lighthouse was unable to download your robots.txt file'};}
if(status>=HTTP_SERVER_ERROR_CODE_LOW){return{rawValue:false,displayValue:`request for robots.txt returned HTTP${status}`};}else if(status>=HTTP_CLIENT_ERROR_CODE_LOW||content===''){return{rawValue:true,notApplicable:true};}
if(content===null){throw new Error(`Status ${status} was valid, but content was null`);}
const validationErrors=validateRobots(content);const headings=[{key:'index',itemType:'text',text:'Line #'},{key:'line',itemType:'code',text:'Content'},{key:'message',itemType:'code',text:'Error'}];const details=Audit.makeTableDetails(headings,validationErrors,{});let displayValue;if(validationErrors.length){displayValue=validationErrors.length>1?`${validationErrors.length} errors found`:'1 error found';}
return{rawValue:validationErrors.length===0,details,displayValue};}}
module.exports=RobotsTxt;},{"../../lib/url-shim":"url","../audit":2}],"../audits/service-worker":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');class ServiceWorker extends Audit{static get meta(){return{id:'service-worker',title:'Registers a service worker',failureTitle:'Does not register a service worker',description:'The service worker is the technology that enables your app to use many '+'Progressive Web App features, such as offline, add to homescreen, and push '+'notifications. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/registered-service-worker).',requiredArtifacts:['URL','ServiceWorker']};}
static audit(artifacts){const versions=artifacts.ServiceWorker.versions;const url=artifacts.URL.finalUrl;const origin=new URL(url).origin;const matchingSW=versions.filter(v=>v.status==='activated').find(v=>new URL(v.scriptURL).origin===origin);return{rawValue:!!matchingSW};}}
module.exports=ServiceWorker;},{"../lib/url-shim":"url","./audit":2}],"../audits/splash-screen":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const ManifestValues=require('../gather/computed/manifest-values');class SplashScreen extends MultiCheckAudit{static get meta(){return{id:'splash-screen',title:'Configured for a custom splash screen',failureTitle:'Is not configured for a custom splash screen',description:'A themed splash screen ensures a high-quality experience when '+'users launch your app from their homescreens. [Learn '+'more](https://developers.google.com/web/tools/lighthouse/audits/custom-splash-screen).',requiredArtifacts:['Manifest']};}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure&&manifestValues.parseFailureReason){failures.push(manifestValues.parseFailureReason);return;}
const splashScreenCheckIds=['hasName','hasBackgroundColor','hasThemeColor','hasIconsAtLeast512px'];manifestValues.allChecks.filter(item=>splashScreenCheckIds.includes(item.id)).forEach(item=>{if(!item.passing){failures.push(item.failureText);}});}
static async audit_(artifacts,context){const failures=[];const manifestValues=await ManifestValues.request(context,artifacts.Manifest);SplashScreen.assessManifest(manifestValues,failures);return{failures,manifestValues};}}
module.exports=SplashScreen;},{"../gather/computed/manifest-values":12,"./multi-check-audit":5}],"../audits/themed-omnibox":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const ManifestValues=require('../gather/computed/manifest-values');const cssParsers=require('cssstyle/lib/parsers');class ThemedOmnibox extends MultiCheckAudit{static get meta(){return{id:'themed-omnibox',title:'Address bar matches brand colors',failureTitle:'Address bar does not match brand colors',description:'The browser address bar can be themed to match your site. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/address-bar).',requiredArtifacts:['Manifest','ThemeColor']};}
static isValidColor(color){return cssParsers.valueType(color)===cssParsers.TYPES.COLOR;}
static assessMetaThemecolor(themeColorMeta,failures){if(themeColorMeta===null){failures.push('No `<meta name="theme-color">` tag found');}else if(!ThemedOmnibox.isValidColor(themeColorMeta)){failures.push('The theme-color meta tag did not contain a valid CSS color');}}
static assessManifest(manifestValues,failures){if(manifestValues.isParseFailure&&manifestValues.parseFailureReason){failures.push(manifestValues.parseFailureReason);return;}
const themeColorCheck=manifestValues.allChecks.find(i=>i.id==='hasThemeColor');if(themeColorCheck&&!themeColorCheck.passing){failures.push(themeColorCheck.failureText);}}
static async audit_(artifacts,context){const failures=[];const manifestValues=await ManifestValues.request(context,artifacts.Manifest);ThemedOmnibox.assessManifest(manifestValues,failures);ThemedOmnibox.assessMetaThemecolor(artifacts.ThemeColor,failures);return{failures,manifestValues,themeColor:artifacts.ThemeColor};}}
module.exports=ThemedOmnibox;},{"../gather/computed/manifest-values":12,"./multi-check-audit":5,"cssstyle/lib/parsers":161}],"../audits/time-to-first-byte":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('./audit');const i18n=require('../lib/i18n/i18n.js');const UIStrings={title:'Server response times are low (TTFB)',failureTitle:'Reduce server response times (TTFB)',description:'Time To First Byte identifies the time at which your server sends a response.'+' [Learn more](https://developers.google.com/web/tools/lighthouse/audits/ttfb).',displayValue:`Root document took {timeInMs, number, milliseconds}\xa0ms`};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const TTFB_THRESHOLD=600;class TTFBMetric extends Audit{static get meta(){return{id:'time-to-first-byte',title:str_(UIStrings.title),failureTitle:str_(UIStrings.failureTitle),description:str_(UIStrings.description),requiredArtifacts:['devtoolsLogs','URL']};}
static caclulateTTFB(record){const timing=record.timing;return timing?timing.receiveHeadersEnd-timing.sendEnd:0;}
static async audit(artifacts){const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const mainResource=await artifacts.requestMainResource({devtoolsLog,URL:artifacts.URL});const ttfb=TTFBMetric.caclulateTTFB(mainResource);const passed=ttfb<TTFB_THRESHOLD;const displayValue=str_(UIStrings.displayValue,{timeInMs:ttfb});const details={type:'opportunity',overallSavingsMs:ttfb-TTFB_THRESHOLD,headings:[],items:[]};return{rawValue:ttfb,score:Number(passed),displayValue,details,extendedInfo:{value:{wastedMs:ttfb-TTFB_THRESHOLD}}};}}
module.exports=TTFBMetric;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/time-to-first-byte.js");},{"../lib/i18n/i18n.js":36,"./audit":2}],"../audits/user-timings":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('./audit');const i18n=require('../lib/i18n/i18n.js');const UIStrings={title:'User Timing marks and measures',description:'Consider instrumenting your app with the User Timing API to measure your '+'app\'s real-world performance during key user experiences. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/user-timing).',displayValue:`{itemCount, plural,
    =1 {1 user timing}
    other {# user timings}
    }`,columnName:'Name',columnType:'Type',columnStartTime:'Start Time',columnDuration:'Duration'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class UserTimings extends Audit{static get meta(){return{id:'user-timings',title:str_(UIStrings.title),description:str_(UIStrings.description),scoreDisplayMode:Audit.SCORING_MODES.INFORMATIVE,requiredArtifacts:['traces']};}
static filterTrace(tabTrace){const userTimings=[];const measuresStartTimes={};tabTrace.processEvents.filter(evt=>{if(!evt.cat.includes('blink.user_timing')){return false;}
return evt.name!=='requestStart'&&evt.name!=='navigationStart'&&evt.name!=='paintNonDefaultBackgroundColor'&&evt.args.frame===undefined;}).forEach(ut=>{if(ut.ph==='R'||ut.ph.toUpperCase()==='I'){userTimings.push({name:ut.name,isMark:true,args:ut.args,startTime:ut.ts});}else if(ut.ph.toLowerCase()==='b'){measuresStartTimes[ut.name]=ut.ts;}else if(ut.ph.toLowerCase()==='e'){userTimings.push({name:ut.name,isMark:false,args:ut.args,startTime:measuresStartTimes[ut.name],endTime:ut.ts,duration:ut.ts-measuresStartTimes[ut.name]});}});userTimings.forEach(ut=>{ut.startTime=(ut.startTime-tabTrace.navigationStartEvt.ts)/1000;if(!ut.isMark){ut.endTime=(ut.endTime-tabTrace.navigationStartEvt.ts)/1000;ut.duration=ut.duration/1000;}});return userTimings;}
static get blacklistedPrefixes(){return['goog_'];}
static excludeBlacklisted(evt){return UserTimings.blacklistedPrefixes.every(prefix=>!evt.name.startsWith(prefix));}
static audit(artifacts){const trace=artifacts.traces[Audit.DEFAULT_PASS];return artifacts.requestTraceOfTab(trace).then(tabTrace=>{const userTimings=this.filterTrace(tabTrace).filter(UserTimings.excludeBlacklisted);const tableRows=userTimings.map(item=>{return{name:item.name,startTime:item.startTime,duration:item.isMark?undefined:item.duration,timingType:item.isMark?'Mark':'Measure'};}).sort((itemA,itemB)=>{if(itemA.timingType===itemB.timingType){return itemA.startTime-itemB.startTime;}else if(itemA.timingType==='Measure'){return-1;}else{return 1;}});const headings=[{key:'name',itemType:'text',text:str_(UIStrings.columnName)},{key:'timingType',itemType:'text',text:str_(UIStrings.columnType)},{key:'startTime',itemType:'ms',granularity:0.01,text:str_(UIStrings.columnStartTime)},{key:'duration',itemType:'ms',granularity:0.01,text:str_(UIStrings.columnDuration)}];const details=Audit.makeTableDetails(headings,tableRows);let displayValue;if(userTimings.length){displayValue=str_(UIStrings.displayValue,{itemCount:userTimings.length});}
return{rawValue:userTimings.length===0,notApplicable:userTimings.length===0,displayValue,extendedInfo:{value:userTimings},details};});}}
module.exports=UserTimings;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/user-timings.js");},{"../lib/i18n/i18n.js":36,"./audit":2}],"../audits/uses-rel-preconnect":[function(require,module,exports){(function(__filename){'use strict';const Audit=require('./audit');const UnusedBytes=require('./byte-efficiency/byte-efficiency-audit');const i18n=require('../lib/i18n/i18n.js');const PRECONNECT_SOCKET_MAX_IDLE=15;const IGNORE_THRESHOLD_IN_MS=50;const UIStrings={title:'Preconnect to required origins',description:'Consider adding preconnect or dns-prefetch resource hints to establish early '+`connections to important third-party origins. [Learn more](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect).`};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);class UsesRelPreconnectAudit extends Audit{static get meta(){return{id:'uses-rel-preconnect',title:str_(UIStrings.title),description:str_(UIStrings.description),requiredArtifacts:['devtoolsLogs','URL'],scoreDisplayMode:Audit.SCORING_MODES.NUMERIC};}
static hasValidTiming(record){return!!record.timing&&record.timing.connectEnd>0&&record.timing.connectStart>0;}
static hasAlreadyConnectedToOrigin(record){return(!!record.timing&&record.timing.dnsEnd-record.timing.dnsStart===0&&record.timing.connectEnd-record.timing.connectStart===0);}
static socketStartTimeIsBelowThreshold(record,mainResource){return Math.max(0,record.startTime-mainResource.endTime)<PRECONNECT_SOCKET_MAX_IDLE;}
static async audit(artifacts,context){const devtoolsLog=artifacts.devtoolsLogs[UsesRelPreconnectAudit.DEFAULT_PASS];const URL=artifacts.URL;const settings=context.settings;let maxWasted=0;const[networkRecords,mainResource,loadSimulator]=await Promise.all([artifacts.requestNetworkRecords(devtoolsLog),artifacts.requestMainResource({devtoolsLog,URL}),artifacts.requestLoadSimulator({devtoolsLog,settings})]);const{rtt,additionalRttByOrigin}=loadSimulator.getOptions();const origins=new Map();networkRecords.forEach(record=>{if(!UsesRelPreconnectAudit.hasValidTiming(record)||record.initiator.url===mainResource.url||!record.parsedURL||!record.parsedURL.securityOrigin||mainResource.parsedURL.securityOrigin===record.parsedURL.securityOrigin||UsesRelPreconnectAudit.hasAlreadyConnectedToOrigin(record)||!UsesRelPreconnectAudit.socketStartTimeIsBelowThreshold(record,mainResource))
{return;}
const securityOrigin=record.parsedURL.securityOrigin;const records=origins.get(securityOrigin)||[];records.push(record);origins.set(securityOrigin,records);});let results=[];origins.forEach(records=>{const firstRecordOfOrigin=records.reduce((firstRecord,record)=>{return record.startTime<firstRecord.startTime?record:firstRecord;});if(!firstRecordOfOrigin.timing)return;const securityOrigin=firstRecordOfOrigin.parsedURL.securityOrigin;const additionalRtt=additionalRttByOrigin.get(securityOrigin)||0;let connectionTime=rtt+additionalRtt;if(firstRecordOfOrigin.parsedURL.scheme==='https')connectionTime=connectionTime*2;const timeBetweenMainResourceAndDnsStart=firstRecordOfOrigin.startTime*1000-
mainResource.endTime*1000+
firstRecordOfOrigin.timing.dnsStart;const wastedMs=Math.min(connectionTime,timeBetweenMainResourceAndDnsStart);if(wastedMs<IGNORE_THRESHOLD_IN_MS)return;maxWasted=Math.max(wastedMs,maxWasted);results.push({url:securityOrigin,wastedMs:wastedMs});});results=results.sort((a,b)=>b.wastedMs-a.wastedMs);const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'wastedMs',valueType:'timespanMs',label:str_(i18n.UIStrings.columnWastedMs)}];const details=Audit.makeOpportunityDetails(headings,results,maxWasted);return{score:UnusedBytes.scoreForWastedMs(maxWasted),rawValue:maxWasted,displayValue:maxWasted?str_(i18n.UIStrings.displayValueMsSavings,{wastedMs:maxWasted}):'',extendedInfo:{value:results},details};}}
module.exports=UsesRelPreconnectAudit;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/uses-rel-preconnect.js");},{"../lib/i18n/i18n.js":36,"./audit":2,"./byte-efficiency/byte-efficiency-audit":3}],"../audits/uses-rel-preload":[function(require,module,exports){(function(__filename){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');const UnusedBytes=require('./byte-efficiency/byte-efficiency-audit');const CriticalRequestChains=require('../gather/computed/critical-request-chains');const i18n=require('../lib/i18n/i18n.js');const UIStrings={title:'Preload key requests',description:'Consider using <link rel=preload> to prioritize fetching resources that are '+'currently requested later in page load. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/preload).'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const THRESHOLD_IN_MS=100;class UsesRelPreloadAudit extends Audit{static get meta(){return{id:'uses-rel-preload',title:str_(UIStrings.title),description:str_(UIStrings.description),requiredArtifacts:['devtoolsLogs','traces','URL'],scoreDisplayMode:Audit.SCORING_MODES.NUMERIC};}
static getURLsToPreload(mainResource,graph){const urls=new Set();graph.traverse((node,traversalPath)=>{if(node.type!=='network')return;const path=traversalPath.slice(1).filter(initiator=>initiator.type==='network');if(!UsesRelPreloadAudit.shouldPreloadRequest(node.record,mainResource,path))return;urls.add(node.record.url);});return urls;}
static shouldPreloadRequest(request,mainResource,initiatorPath){const mainResourceDepth=mainResource.redirects?mainResource.redirects.length:0;if(request.isLinkPreload)return false;if(!CriticalRequestChains.isCritical(request,mainResource))return false;if(URL.NON_NETWORK_PROTOCOLS.includes(request.protocol))return false;if(initiatorPath.length!==mainResourceDepth+2)return false;return URL.rootDomainsMatch(request.url,mainResource.url);}
static computeWasteWithGraph(urls,graph,simulator){if(!urls.size){return{wastedMs:0,results:[]};}
const simulationBeforeChanges=simulator.simulate(graph,{flexibleOrdering:true});const modifiedGraph=graph.cloneWithRelationships();const nodesToPreload=[];let mainDocumentNode=null;modifiedGraph.traverse(node=>{if(node.type!=='network')return;const networkNode=node;if(node.isMainDocument()){mainDocumentNode=networkNode;}else if(networkNode.record&&urls.has(networkNode.record.url)){nodesToPreload.push(networkNode);}});if(!mainDocumentNode){throw new Error('Could not find main document node');}
for(const node of nodesToPreload){node.removeAllDependencies();node.addDependency(mainDocumentNode);}
const simulationAfterChanges=simulator.simulate(modifiedGraph,{flexibleOrdering:true});const originalNodesByRecord=Array.from(simulationBeforeChanges.nodeTimings.keys()).reduce((map,node)=>map.set(node.record,node),new Map());const results=[];for(const node of nodesToPreload){const originalNode=originalNodesByRecord.get(node.record);const timingAfter=simulationAfterChanges.nodeTimings.get(node);const timingBefore=simulationBeforeChanges.nodeTimings.get(originalNode);if(!timingBefore||!timingAfter)throw new Error('Missing preload node');const wastedMs=Math.round(timingBefore.endTime-timingAfter.endTime);if(wastedMs<THRESHOLD_IN_MS)continue;results.push({url:node.record.url,wastedMs});}
if(!results.length){return{wastedMs:0,results};}
return{wastedMs:Math.max(...results.map(item=>item.wastedMs)),results};}
static async audit(artifacts,context){const trace=artifacts.traces[UsesRelPreloadAudit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[UsesRelPreloadAudit.DEFAULT_PASS];const URL=artifacts.URL;const simulatorOptions={trace,devtoolsLog,settings:context.settings};const[mainResource,graph,simulator]=await Promise.all([artifacts.requestMainResource({devtoolsLog,URL}),artifacts.requestPageDependencyGraph({trace,devtoolsLog}),artifacts.requestLoadSimulator(simulatorOptions)]);const urls=UsesRelPreloadAudit.getURLsToPreload(mainResource,graph);const{results,wastedMs}=UsesRelPreloadAudit.computeWasteWithGraph(urls,graph,simulator);results.sort((a,b)=>b.wastedMs-a.wastedMs);const headings=[{key:'url',valueType:'url',label:str_(i18n.UIStrings.columnURL)},{key:'wastedMs',valueType:'timespanMs',label:str_(i18n.UIStrings.columnWastedMs)}];const details=Audit.makeOpportunityDetails(headings,results,wastedMs);return{score:UnusedBytes.scoreForWastedMs(wastedMs),rawValue:wastedMs,displayValue:wastedMs?str_(i18n.UIStrings.displayValueMsSavings,{wastedMs}):'',extendedInfo:{value:results},details};}}
module.exports=UsesRelPreloadAudit;module.exports.UIStrings=UIStrings;}).call(this,"/../lighthouse-core/audits/uses-rel-preload.js");},{"../gather/computed/critical-request-chains":"./gather/computed/critical-request-chains","../lib/i18n/i18n.js":36,"../lib/url-shim":"url","./audit":2,"./byte-efficiency/byte-efficiency-audit":3}],"../audits/viewport":[function(require,module,exports){'use strict';const Audit=require('./audit');const Parser=require('metaviewport-parser');class Viewport extends Audit{static get meta(){return{id:'viewport',title:'Has a `<meta name="viewport">` tag with `width` or `initial-scale`',failureTitle:'Does not have a `<meta name="viewport">` tag with `width` '+'or `initial-scale`',description:'Add a viewport meta tag to optimize your app for mobile screens. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/has-viewport-meta-tag).',requiredArtifacts:['Viewport']};}
static audit(artifacts){if(artifacts.Viewport===null){return{explanation:'No viewport meta tag found',rawValue:false};}
const warnings=[];const parsedProps=Parser.parseMetaViewPortContent(artifacts.Viewport);if(Object.keys(parsedProps.unknownProperties).length){warnings.push(`Invalid properties found: ${JSON.stringify(parsedProps.unknownProperties)}`);}
if(Object.keys(parsedProps.invalidValues).length){warnings.push(`Invalid values found: ${JSON.stringify(parsedProps.invalidValues)}`);}
const viewportProps=parsedProps.validProperties;const hasMobileViewport=viewportProps.width||viewportProps['initial-scale'];return{rawValue:!!hasMobileViewport,warnings};}}
module.exports=Viewport;},{"./audit":2,"metaviewport-parser":180}],"../audits/webapp-install-banner":[function(require,module,exports){'use strict';const MultiCheckAudit=require('./multi-check-audit');const SWAudit=require('./service-worker');const ManifestValues=require('../gather/computed/manifest-values');class WebappInstallBanner extends MultiCheckAudit{static get meta(){return{id:'webapp-install-banner',title:'User can be prompted to Install the Web App',failureTitle:'User will not be prompted to Install the Web App',description:'Browsers can proactively prompt users to add your app to their homescreen, '+'which can lead to higher engagement. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/install-prompt).',requiredArtifacts:['URL','ServiceWorker','Manifest','StartUrl']};}
static assessManifest(manifestValues){if(manifestValues.isParseFailure&&manifestValues.parseFailureReason){return[manifestValues.parseFailureReason];}
const failures=[];const bannerCheckIds=['hasName','hasShortName','hasStartUrl','hasPWADisplayValue','hasIconsAtLeast192px'];manifestValues.allChecks.filter(item=>bannerCheckIds.includes(item.id)).forEach(item=>{if(!item.passing){failures.push(item.failureText);}});return failures;}
static assessServiceWorker(artifacts){const failures=[];const hasServiceWorker=SWAudit.audit(artifacts).rawValue;if(!hasServiceWorker){failures.push('Site does not register a service worker');}
return failures;}
static assessOfflineStartUrl(artifacts){const failures=[];const warnings=[];const hasOfflineStartUrl=artifacts.StartUrl.statusCode===200;if(!hasOfflineStartUrl){failures.push('Service worker does not successfully serve the manifest\'s start_url');if(artifacts.StartUrl.explanation){failures.push(artifacts.StartUrl.explanation);}}
if(artifacts.StartUrl.explanation){warnings.push(artifacts.StartUrl.explanation);}
return{failures,warnings};}
static async audit_(artifacts,context){let offlineFailures=[];let offlineWarnings=[];const manifestValues=await ManifestValues.request(context,artifacts.Manifest);const manifestFailures=WebappInstallBanner.assessManifest(manifestValues);const swFailures=WebappInstallBanner.assessServiceWorker(artifacts);if(!swFailures.length){const{failures,warnings}=WebappInstallBanner.assessOfflineStartUrl(artifacts);offlineFailures=failures;offlineWarnings=warnings;}
return{warnings:offlineWarnings,failures:[...manifestFailures,...swFailures,...offlineFailures],manifestValues};}}
module.exports=WebappInstallBanner;},{"../gather/computed/manifest-values":12,"./multi-check-audit":5,"./service-worker":"../audits/service-worker"}],"../audits/without-javascript":[function(require,module,exports){'use strict';const Audit=require('./audit');class WithoutJavaScript extends Audit{static get meta(){return{id:'without-javascript',title:'Contains some content when JavaScript is not available',failureTitle:'Does not provide fallback content when JavaScript is not available',description:'Your app should display some content when JavaScript is disabled, even if '+'it\'s just a warning to the user that JavaScript is required to use the app. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/no-js).',requiredArtifacts:['HTMLWithoutJavaScript']};}
static audit(artifacts){const artifact=artifacts.HTMLWithoutJavaScript;if(artifact.bodyText.trim()===''&&!artifact.hasNoScript){return{rawValue:false,explanation:'The page body should render some content if its scripts are not available.'};}
return{rawValue:true};}}
module.exports=WithoutJavaScript;},{"./audit":2}],"../audits/works-offline":[function(require,module,exports){'use strict';const URL=require('../lib/url-shim');const Audit=require('./audit');class WorksOffline extends Audit{static get meta(){return{id:'works-offline',title:'Responds with a 200 when offline',failureTitle:'Does not respond with a 200 when offline',description:'If you\'re building a Progressive Web App, consider using a service worker '+'so that your app can work offline. '+'[Learn more](https://developers.google.com/web/tools/lighthouse/audits/http-200-when-offline).',requiredArtifacts:['Offline','URL']};}
static audit(artifacts){const warnings=[];const passed=artifacts.Offline===200;if(!passed&&!URL.equalWithExcludedFragments(artifacts.URL.requestedUrl,artifacts.URL.finalUrl)){warnings.push('You may be not loading offline because your test URL '+`(${artifacts.URL.requestedUrl}) was redirected to "${artifacts.URL.finalUrl}". `+'Try testing the second URL directly.');}
return{rawValue:passed,warnings};}}
module.exports=WorksOffline;},{"../lib/url-shim":"url","./audit":2}],"../gather/gatherers/accessibility":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const axeLibSource="/*! aXe v3.0.0-beta.2\n * Copyright (c) 2018 Deque Systems, Inc.\n *\n * Your use of this Source Code Form is subject to the terms of the Mozilla Public\n * License, v. 2.0. If a copy of the MPL was not distributed with this\n * file, You can obtain one at http://mozilla.org/MPL/2.0/.\n *\n * This entire copyright notice must appear in every copy of this file you\n * distribute or in any file that contains substantial portions of this source\n * code.\n */\n!function a(window){function b(a){this.name=\"SupportError\",this.cause=a.cause,this.message=\"`\"+a.cause+\"` - feature unsupported in your environment.\",a.ruleId&&(this.ruleId=a.ruleId,this.message+=\" Skipping \"+this.ruleId+\" rule.\"),this.stack=(new Error).stack}function c(a){\"use strict\";var b;return a?(b=axe.utils.clone(a),b.commons=a.commons):b={},b.reporter=b.reporter||null,b.rules=b.rules||[],b.checks=b.checks||[],b.data=Object.assign({checks:{},rules:{}},b.data),b}function d(a,b,c){\"use strict\";var d,e;for(d=0,e=a.length;d<e;d++)b[c](a[d])}function e(a){this.brand=\"axe\",this.application=\"axeAPI\",this.tagExclude=[\"experimental\"],this.defaultConfig=a,this._init()}function f(a,b,c){var d=a.brand,e=a.application;return axe.constants.helpUrlBase+d+\"/\"+(c||axe.version.substring(0,axe.version.lastIndexOf(\".\")))+\"/\"+b+\"?application=\"+e}function g(a){\"use strict\";this.id=a.id,this.data=null,this.relatedNodes=[],this.result=null}function h(a){\"use strict\";return\"string\"==typeof a?new Function(\"return \"+a+\";\")():a}function i(a){a&&(this.id=a.id,this.configure(a))}function j(a,b){\"use strict\";if(!axe.utils.isHidden(b)){axe.utils.findBy(a,\"node\",b)||a.push({node:b,include:[],exclude:[]})}}function k(a,b,c){\"use strict\";a.frames=a.frames||[];var d,e,f=document.querySelectorAll(c.shift());a:for(var g=0,h=f.length;g<h;g++){e=f[g];for(var i=0,j=a.frames.length;i<j;i++)if(a.frames[i].node===e){a.frames[i][b].push(c);break a}d={node:e,include:[],exclude:[]},c&&d[b].push(c),a.frames.push(d)}}function l(a){\"use strict\";if(a&&\"object\"===(void 0===a?\"undefined\":za(a))||a instanceof NodeList){if(a instanceof Node)return{include:[a],exclude:[]};if(a.hasOwnProperty(\"include\")||a.hasOwnProperty(\"exclude\"))return{include:a.include&&+a.include.length?a.include:[document],exclude:a.exclude||[]};if(a.length===+a.length)return{include:a,exclude:[]}}return\"string\"==typeof a?{include:[a],exclude:[]}:{include:[document],exclude:[]}}function m(a,b){\"use strict\";for(var c,d,e=[],f=0,g=a[b].length;f<g;f++){if(\"string\"==typeof(c=a[b][f])){d=Array.from(document.querySelectorAll(c)),e=e.concat(d.map(function(a){return axe.utils.getFlattenedTree(a)[0]}));break}!c||!c.length||c instanceof Node?c instanceof Node&&e.push(axe.utils.getFlattenedTree(c)[0]):c.length>1?k(a,b,c):(d=Array.from(document.querySelectorAll(c[0])),e=e.concat(d.map(function(a){return axe.utils.getFlattenedTree(a)[0]})))}return e.filter(function(a){return a})}function n(a){\"use strict\";if(0===a.include.length){if(0===a.frames.length){var b=axe.utils.respondable.isInFrame()?\"frame\":\"page\";return new Error(\"No elements found for include in \"+b+\" Context\")}a.frames.forEach(function(a,b){if(0===a.include.length)return new Error(\"No elements found for include in Context of frame \"+b)})}}function o(a){\"use strict\";var b=this;this.frames=[],this.initiator=!a||\"boolean\"!=typeof a.initiator||a.initiator,this.page=!1,a=l(a),this.exclude=a.exclude,this.include=a.include,this.include=m(this,\"include\"),this.exclude=m(this,\"exclude\"),axe.utils.select(\"frame, iframe\",this).forEach(function(a){wa(a,b)&&j(b.frames,a.actualNode)}),1===this.include.length&&this.include[0].actualNode===document.documentElement&&(this.page=!0);var c=n(this);if(c instanceof Error)throw c;Array.isArray(this.include)||(this.include=Array.from(this.include)),this.include.sort(axe.utils.nodeSorter)}function p(a){\"use strict\";this.id=a.id,this.result=axe.constants.NA,this.pageLevel=a.pageLevel,this.impact=null,this.nodes=[]}function q(a,b){\"use strict\";this._audit=b,this.id=a.id,this.selector=a.selector||\"*\",this.excludeHidden=\"boolean\"!=typeof a.excludeHidden||a.excludeHidden,this.enabled=\"boolean\"!=typeof a.enabled||a.enabled,this.pageLevel=\"boolean\"==typeof a.pageLevel&&a.pageLevel,this.any=a.any||[],this.all=a.all||[],this.none=a.none||[],this.tags=a.tags||[],a.matches&&(this.matches=h(a.matches))}function r(a){\"use strict\";return axe.utils.getAllChecks(a).map(function(b){var c=a._audit.checks[b.id||b];return c&&\"function\"==typeof c.after?c:null}).filter(Boolean)}function s(a,b){\"use strict\";var c=[];return a.forEach(function(a){axe.utils.getAllChecks(a).forEach(function(a){a.id===b&&c.push(a)})}),c}function t(a){\"use strict\";return a.filter(function(a){return!0!==a.filtered})}function u(a){\"use strict\";var b=[\"any\",\"all\",\"none\"],c=a.nodes.filter(function(a){var c=0;return b.forEach(function(b){a[b]=t(a[b]),c+=a[b].length}),c>0});return a.pageLevel&&c.length&&(c=[c.reduce(function(a,c){if(a)return b.forEach(function(b){a[b].push.apply(a[b],c[b])}),a})]),c}function v(a,b){\"use strict\";if(a=a||function(){},b=b||axe.log,!axe._audit)throw new Error(\"No audit configured\");var c=axe.utils.queue(),d=[];Object.keys(axe.plugins).forEach(function(a){c.defer(function(b){var c=function(a){d.push(a),b()};try{axe.plugins[a].cleanup(b,c)}catch(a){c(a)}})});var e=axe.utils.getFlattenedTree(document.body);axe.utils.querySelectorAll(e,\"iframe, frame\").forEach(function(a){c.defer(function(b,c){return axe.utils.sendCommandToFrame(a.actualNode,{command:\"cleanup-plugin\"},b,c)})}),c.then(function(c){0===d.length?a(c):b(d)}).catch(b)}function w(a){\"use strict\";var b;if(!(b=axe._audit))throw new Error(\"No audit configured\");a.reporter&&(\"function\"==typeof a.reporter||Ca[a.reporter])&&(b.reporter=a.reporter),a.checks&&a.checks.forEach(function(a){b.addCheck(a)});var c=[];a.rules&&a.rules.forEach(function(a){c.push(a.id),b.addRule(a)}),a.disableOtherRules&&b.rules.forEach(function(a){!1===c.includes(a.id)&&(a.enabled=!1)}),void 0!==a.branding?b.setBranding(a.branding):b._constructHelpUrls(),a.tagExclude&&(b.tagExclude=a.tagExclude)}function x(a,b,c){\"use strict\";var d=c,e=function(a){a instanceof Error==!1&&(a=new Error(a)),c(a)},f=a&&a.context||{};f.hasOwnProperty(\"include\")&&!f.include.length&&(f.include=[document]);var g=a&&a.options||{};switch(a.command){case\"rules\":return A(f,g,d,e);case\"cleanup-plugin\":return v(d,e);default:if(axe._audit&&axe._audit.commands&&axe._audit.commands[a.command])return axe._audit.commands[a.command](a,c)}}function y(a){\"use strict\";this._run=a.run,this._collect=a.collect,this._registry={},a.commands.forEach(function(a){axe._audit.registerCommand(a)})}function z(){\"use strict\";var a=axe._audit;if(!a)throw new Error(\"No audit configured\");a.resetRulesAndChecks()}function A(a,b,c,d){\"use strict\";try{a=new o(a)}catch(a){return d(a)}var e=axe.utils.queue(),f=axe._audit;b.performanceTimer&&axe.utils.performanceTimer.auditStart(),a.frames.length&&!1!==b.iframes&&e.defer(function(c,d){axe.utils.collectResultsFromFrames(a,b,\"rules\",null,c,d)});var g=void 0;e.defer(function(c,d){b.restoreScroll&&(g=axe.utils.getScrollState()),f.run(a,b,c,d)}),e.then(function(e){try{g&&axe.utils.setScrollState(g),b.performanceTimer&&axe.utils.performanceTimer.auditEnd();var h=axe.utils.mergeResults(e.map(function(a){return{results:a}}));a.initiator&&(h=f.after(h,b),h.forEach(axe.utils.publishMetaData),h=h.map(axe.utils.finalizeRuleResult));try{c(h)}catch(a){axe.log(a)}}catch(a){d(a)}}).catch(d)}function B(a){\"use strict\";switch(!0){case\"string\"==typeof a:case Array.isArray(a):case Node&&a instanceof Node:case NodeList&&a instanceof NodeList:return!0;case\"object\"!==(void 0===a?\"undefined\":za(a)):return!1;case void 0!==a.include:case void 0!==a.exclude:case\"number\"==typeof a.length:return!0;default:return!1}}function C(a,b,c){\"use strict\";var d=new TypeError(\"axe.run arguments are invalid\");if(!B(a)){if(void 0!==c)throw d;c=b,b=a,a=document}if(\"object\"!==(void 0===b?\"undefined\":za(b))){if(void 0!==c)throw d;c=b,b={}}if(\"function\"!=typeof c&&void 0!==c)throw d;return{context:a,options:b,callback:c||Da}}function D(a,b){\"use strict\";[\"any\",\"all\",\"none\"].forEach(function(c){Array.isArray(a[c])&&a[c].filter(function(a){return Array.isArray(a.relatedNodes)}).forEach(function(a){a.relatedNodes=a.relatedNodes.map(function(a){var c={html:a.source};return b.elementRef&&!a.fromFrame&&(c.element=a.element),(!1!==b.selectors||a.fromFrame)&&(c.target=a.selector),b.xpath&&(c.xpath=a.xpath),c})})})}function E(a,b){return Ja.reduce(function(c,d){return c[d]=(a[d]||[]).map(function(a){return b(a,d)}),c},{})}function F(a,b,c){var d=Object.assign({},b);d.nodes=(d[c]||[]).concat(),axe.constants.resultGroups.forEach(function(a){delete d[a]}),a[c].push(d)}function G(a,b,c){\"use strict\";var d=window.getComputedStyle(a,null),e=!1;return!!d&&(b.forEach(function(a){d.getPropertyValue(a.property)===a.value&&(e=!0)}),!!e||!(a.nodeName.toUpperCase()===c.toUpperCase()||!a.parentNode)&&G(a.parentNode,b,c))}function H(a,b){\"use strict\";var c;return axe._tree&&(c=axe.utils.getSelector(b)),new Error(a+\": \"+(c||b))}function I(a,b,c,d,e,f){\"use strict\";var g=axe.utils.queue();a.frames.forEach(function(e){var f={options:b,command:c,parameter:d,context:{initiator:!1,page:a.page,include:e.include||[],exclude:e.exclude||[]}};g.defer(function(a,b){var c=e.node;axe.utils.sendCommandToFrame(c,f,function(b){if(b)return a({results:b,frameElement:c,frame:axe.utils.getSelector(c)});a(null)},b)})}),g.then(function(a){e(axe.utils.mergeResults(a,b))}).catch(f)}function J(a,b){if(b=b||300,a.length>b){var c=a.indexOf(\">\");a=a.substring(0,c+1)}return a}function K(a){var b=a.outerHTML;return b||\"function\"!=typeof XMLSerializer||(b=(new XMLSerializer).serializeToString(a)),J(b||\"\")}function L(a,b,c){this._fromFrame=!!c,this.spec=c||{},b&&b.absolutePaths&&(this._options={toRoot:!0}),this.source=void 0!==this.spec.source?this.spec.source:K(a),this._element=a}function M(a,b){return{shadowId:b,children:[],actualNode:a}}function N(a){var b=[];for(a=a.firstChild;a;)b.push(a),a=a.nextSibling;return b}function O(){var a=arguments.length>0&&void 0!==arguments[0]?arguments[0]:\"\";return 0!==a.length&&(a.match(/[0-9]/g)||\"\").length>=a.length/2}function P(a,b){return[a.substring(0,b),a.substring(b)]}function Q(a){var b=a,c=\"\",d=\"\",e=\"\",f=\"\",g=\"\",h=\"\";if(a.includes(\"#\")){var i=P(a,a.indexOf(\"#\")),j=Ka(i,2);a=j[0],h=j[1]}if(a.includes(\"?\")){var k=P(a,a.indexOf(\"?\")),l=Ka(k,2);a=l[0],g=l[1]}if(a.includes(\"://\")){var m=a.split(\"://\"),n=Ka(m,2);c=n[0],a=n[1];var o=P(a,a.indexOf(\"/\")),p=Ka(o,2);d=p[0],a=p[1]}else if(\"//\"===a.substr(0,2)){a=a.substr(2);var q=P(a,a.indexOf(\"/\")),r=Ka(q,2);d=r[0],a=r[1]}if(\"www.\"===d.substr(0,4)&&(d=d.substr(4)),d&&d.includes(\":\")){var s=P(d,d.indexOf(\":\")),t=Ka(s,2);d=t[0],e=t[1]}return f=a,{original:b,protocol:c,domain:d,port:e,path:f,query:g,hash:h}}function R(a,b){var c=b.name,d=void 0;if(-1!==c.indexOf(\"href\")||-1!==c.indexOf(\"src\")){var e=encodeURI(axe.utils.getFriendlyUriEnd(a.getAttribute(c)));if(!e)return;d=La(b.name)+'$=\"'+e+'\"'}else d=La(c)+'=\"'+La(b.value)+'\"';return d}function S(a,b){return a.count<b.count?-1:a.count===b.count?0:1}function T(a){return!Na.includes(a.name)&&-1===a.name.indexOf(\":\")&&(!a.value||a.value.length<Oa)}function U(a,b){var c=[],d=b.classes,e=b.tags;return a.classList&&Array.from(a.classList).forEach(function(b){var f=La(b);d[f]<e[a.nodeName]&&c.push({name:f,count:d[f],species:\"class\"})}),c.sort(S)}function V(a,b){var c=a.parentNode&&Array.from(a.parentNode.children||\"\")||[];if(c.find(function(c){return c!==a&&axe.utils.matchesSelector(c,b)}))return\":nth-child(\"+(1+c.indexOf(a))+\")\";return\"\"}function W(a){if(a.getAttribute(\"id\")){var b=a.getRootNode&&a.getRootNode()||document,c=\"#\"+La(a.getAttribute(\"id\")||\"\");return c.match(/player_uid_/)||1!==b.querySelectorAll(c).length?void 0:c}}function X(a){return void 0===Ma&&(Ma=axe.utils.isXHTML(document)),La(Ma?a.localName:a.nodeName.toLowerCase())}function Y(a,b){var c=[],d=b.attributes,e=b.tags;return a.attributes&&Array.from(a.attributes).filter(T).forEach(function(b){var f=R(a,b);f&&d[f]<e[a.nodeName]&&c.push({name:f,count:d[f],species:\"attribute\"})}),c.sort(S)}function Z(a,b){var c=\"\",d=void 0,e=U(a,b),f=Y(a,b);return e.length&&1===e[0].count?d=[e[0]]:f.length&&1===f[0].count?(d=[f[0]],c=X(a)):(d=e.concat(f),d.sort(S),d=d.slice(0,3),d.some(function(a){return\"class\"===a.species})?d.sort(function(a,b){return a.species!==b.species&&\"class\"===a.species?-1:a.species===b.species?0:1}):c=X(a)),c+=d.reduce(function(a,b){switch(b.species){case\"class\":return a+\".\"+b.name;case\"attribute\":return a+\"[\"+b.name+\"]\"}return a},\"\")}function $(a,b,c){axe._selectorData||(axe._selectorData=axe.utils.getSelectorData(axe._tree));var d=b.toRoot,e=void 0!==d&&d,f=void 0,g=void 0;do{var h=W(a);h||(h=Z(a,axe._selectorData),h+=V(a,h)),f=f?h+\" > \"+f:h,g=g?g.filter(function(a){return axe.utils.matchesSelector(a,f)}):Array.from(c.querySelectorAll(f)),a=a.parentElement}while((g.length>1||e)&&a&&11!==a.nodeType);return 1===g.length?f:-1!==f.indexOf(\" > \")?\":root\"+f.substring(f.indexOf(\" > \")):\":root\"}function _(a,b){var c,d;if(!a)return[];if(!b&&9===a.nodeType)return b=[{str:\"html\"}];if(b=b||[],a.parentNode&&a.parentNode!==a&&(b=_(a.parentNode,b)),a.previousSibling){d=1,c=a.previousSibling;do{1===c.nodeType&&c.nodeName===a.nodeName&&d++,c=c.previousSibling}while(c);1===d&&(d=null)}else if(a.nextSibling){c=a.nextSibling;do{1===c.nodeType&&c.nodeName===a.nodeName?(d=1,c=null):(d=null,c=c.previousSibling)}while(c)}if(1===a.nodeType){var e={};e.str=a.nodeName.toLowerCase();var f=a.getAttribute&&axe.utils.escapeSelector(a.getAttribute(\"id\"));f&&1===a.ownerDocument.querySelectorAll(\"#\"+f).length&&(e.id=a.getAttribute(\"id\")),d>1&&(e.count=d),b.push(e)}return b}function aa(a){return a.reduce(function(a,b){return b.id?\"/\"+b.str+\"[@id='\"+b.id+\"']\":a+\"/\"+b.str+(b.count>0?\"[\"+b.count+\"]\":\"\")},\"\")}function ba(a){\"use strict\";if(Pa&&Pa.parentNode)return void 0===Pa.styleSheet?Pa.appendChild(document.createTextNode(a)):Pa.styleSheet.cssText+=a,Pa;if(a){var b=document.head||document.getElementsByTagName(\"head\")[0];return Pa=document.createElement(\"style\"),Pa.type=\"text/css\",void 0===Pa.styleSheet?Pa.appendChild(document.createTextNode(a)):Pa.styleSheet.cssText=a,b.appendChild(Pa),Pa}}function ca(a,b,c,d){\"use strict\";var e=axe.utils.getXpath(c),f={element:c,selector:d,xpath:e};a.forEach(function(a){a.node=axe.utils.DqElement.fromFrame(a.node,b,f);var c=axe.utils.getAllChecks(a);c.length&&c.forEach(function(a){a.relatedNodes=a.relatedNodes.map(function(a){return axe.utils.DqElement.fromFrame(a,b,f)})})})}function da(a,b){\"use strict\";for(var c,d,e=b[0].node,f=0,g=a.length;f<g;f++)if(d=a[f].node,(c=axe.utils.nodeSorter({actualNode:d.element},{actualNode:e.element}))>0||0===c&&e.selector.length<d.selector.length)return void a.splice.apply(a,[f,0].concat(b));a.push.apply(a,b)}function ea(a){\"use strict\";return a&&a.results?Array.isArray(a.results)?a.results.length?a.results:null:[a.results]:null}function fa(a,b){function c(a){return a.incomplete&&a.incomplete.default?a.incomplete.default:Aa.incompleteFallbackMessage()}if(!a||!a.missingData)return c(b);try{var d=b.incomplete[a.missingData[0].reason];if(!d)throw new Error;return d}catch(d){return\"string\"==typeof a.missingData?b.incomplete[a.missingData]:c(b)}}function ga(a,b){\"use strict\";return function(c){var d=a[c.id]||{},e=d.messages||{},f=Object.assign({},d);delete f.messages,void 0===c.result?\"object\"===za(e.incomplete)?f.message=function(){return fa(c.data,e)}:f.message=e.incomplete:f.message=c.result===b?e.pass:e.fail,axe.utils.extendMetaData(c,f)}}function ha(a,b){return 1===a.nodeType&&(\"*\"===b.tag||a.nodeName.toLowerCase()===b.tag)}function ia(a,b){return!b.classes||b.classes.reduce(function(b,c){return b&&a.className&&a.className.match(c.regexp)},!0)}function ja(a,b){return!b.attributes||b.attributes.reduce(function(b,c){var d=a.getAttribute(c.key);return b&&null!==d&&(!c.value||c.test(d))},!0)}function ka(a,b){return!b.id||a.id===b.id}function la(a,b){return!(b.pseudos&&!b.pseudos.reduce(function(b,c){if(\"not\"===c.name)return b&&!Sa([a],c.expressions,!1).length;throw new Error(\"the pseudo selector \"+c.name+\" has not yet been implemented\")},!0))}function ma(a){/*! Credit Mootools Copyright Mootools, MIT License */\nif(a)return a.map(function(a){var b,c,d=a.name.replace(Ua,\"\"),e=(a.value||\"\").replace(Ua,\"\");switch(a.operator){case\"^=\":c=new RegExp(\"^\"+Ta(e));break;case\"$=\":c=new RegExp(Ta(e)+\"$\");break;case\"~=\":c=new RegExp(\"(^|\\\\s)\"+Ta(e)+\"(\\\\s|$)\");break;case\"|=\":c=new RegExp(\"^\"+Ta(e)+\"(-|$)\");break;case\"=\":b=function(a){return e===a};break;case\"*=\":b=function(a){return a&&a.includes(e)};break;case\"!=\":b=function(a){return e!==a};break;default:b=function(a){return!!a}}return\"\"===e&&/^[*$^]=$/.test(a.operator)&&(b=function(){return!1}),b||(b=function(a){return a&&c.test(a)}),{key:d,value:e,test:b}})}function na(a){if(a)return a.map(function(a){return a=a.replace(Ua,\"\"),{value:a,regexp:new RegExp(\"(^|\\\\s)\"+Ta(a)+\"(\\\\s|$)\")}})}function oa(a){if(a)return a.map(function(a){var b;return\"not\"===a.name&&(b=axe.utils.cssParser.parse(a.value),b=b.selectors?b.selectors:[b],b=Ra(b)),{name:a.name,expressions:b,value:a.value}})}function pa(a,b,c,d){var e={nodes:a.slice(),anyLevel:b,thisLevel:c,parentShadowId:d};return e.nodes.reverse(),e}function qa(a,b){return ha(a.actualNode,b[0])&&ia(a.actualNode,b[0])&&ja(a.actualNode,b[0])&&ka(a.actualNode,b[0])&&la(a,b[0])}function ra(a,b){\"use strict\";var c,d,e=axe._audit&&axe._audit.tagExclude?axe._audit.tagExclude:[];return b.hasOwnProperty(\"include\")||b.hasOwnProperty(\"exclude\")?(c=b.include||[],c=Array.isArray(c)?c:[c],d=b.exclude||[],d=Array.isArray(d)?d:[d],d=d.concat(e.filter(function(a){return-1===c.indexOf(a)}))):(c=Array.isArray(b)?b:[b],d=e.filter(function(a){return-1===c.indexOf(a)})),!!(c.some(function(b){return-1!==a.tags.indexOf(b)})||0===c.length&&!1!==a.enabled)&&d.every(function(b){return-1===a.tags.indexOf(b)})}function sa(a){var b=window.getComputedStyle(a),c=\"visible\"===b.getPropertyValue(\"overflow-y\"),d=\"visible\"===b.getPropertyValue(\"overflow-x\");if(!c&&a.scrollHeight>a.clientHeight||!d&&a.scrollWidth>a.clientWidth)return{elm:a,top:a.scrollTop,left:a.scrollLeft}}function ta(a,b,c){if(a===window)return a.scroll(b,c);a.scrollTop=b,a.scrollLeft=c}function ua(a){return Array.from(a.children).reduce(function(a,b){var c=sa(b);return c&&a.push(c),a.concat(ua(b))},[])}function va(a){\"use strict\";return a.sort(function(a,b){return axe.utils.contains(a,b)?1:-1})[0]}function wa(a,b){\"use strict\";var c=b.include&&va(b.include.filter(function(b){return axe.utils.contains(b,a)})),d=b.exclude&&va(b.exclude.filter(function(b){return axe.utils.contains(b,a)}));return!!(!d&&c||d&&axe.utils.contains(d,c))}function xa(a,b){\"use strict\";var c;if(0===a.length)return b;a.length<b.length&&(c=a,a=b,b=c);for(var d=0,e=b.length;d<e;d++)a.includes(b[d])||a.push(b[d]);return a}function ya(a){return a.reduce(function(a,b){return a.length&&a[a.length-1].actualNode.contains(b.actualNode)||a.push(b),a},[])}var document=window.document,za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},axe=axe||{};axe.version=\"3.0.0-beta.2\",\"function\"==typeof define&&define.amd&&define([],function(){\"use strict\";return axe}),\"object\"===(\"undefined\"==typeof module?\"undefined\":za(module))&&module.exports&&\"function\"==typeof a.toString&&(axe.source=\"(\"+a.toString()+')(typeof window === \"object\" ? window : this);',module.exports=axe),\"function\"==typeof window.getComputedStyle&&(window.axe=axe);var commons;b.prototype=Object.create(Error.prototype),b.prototype.constructor=b;var utils=axe.utils={},Aa={},za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};e.prototype._init=function(){var a=c(this.defaultConfig);axe.commons=commons=a.commons,this.reporter=a.reporter,this.commands={},this.rules=[],this.checks={},d(a.rules,this,\"addRule\"),d(a.checks,this,\"addCheck\"),this.data={},this.data.checks=a.data&&a.data.checks||{},this.data.rules=a.data&&a.data.rules||{},this.data.failureSummaries=a.data&&a.data.failureSummaries||{},this.data.incompleteFallbackMessage=a.data&&a.data.incompleteFallbackMessage||\"\",this._constructHelpUrls()},e.prototype.registerCommand=function(a){\"use strict\";this.commands[a.id]=a.callback},e.prototype.addRule=function(a){\"use strict\";a.metadata&&(this.data.rules[a.id]=a.metadata);var b=this.getRule(a.id);b?b.configure(a):this.rules.push(new q(a,this))},e.prototype.addCheck=function(a){\"use strict\";var b=a.metadata;\"object\"===(void 0===b?\"undefined\":za(b))&&(this.data.checks[a.id]=b,\"object\"===za(b.messages)&&Object.keys(b.messages).filter(function(a){return b.messages.hasOwnProperty(a)&&\"string\"==typeof b.messages[a]}).forEach(function(a){0===b.messages[a].indexOf(\"function\")&&(b.messages[a]=new Function(\"return \"+b.messages[a]+\";\")())})),this.checks[a.id]?this.checks[a.id].configure(a):this.checks[a.id]=new i(a)},e.prototype.run=function(a,b,c,d){\"use strict\";this.validateOptions(b),axe._tree=axe.utils.getFlattenedTree(document.documentElement),axe._selectCache=[];var e=axe.utils.queue();this.rules.forEach(function(c){if(axe.utils.ruleShouldRun(c,a,b)){if(b.performanceTimer){var d=\"mark_rule_end_\"+c.id,f=\"mark_rule_start_\"+c.id;axe.utils.performanceTimer.mark(f)}e.defer(function(e,g){c.run(a,b,function(a){b.performanceTimer&&(axe.utils.performanceTimer.mark(d),axe.utils.performanceTimer.measure(\"rule_\"+c.id,f,d)),e(a)},function(a){if(b.debug)g(a);else{var d=Object.assign(new p(c),{result:axe.constants.CANTTELL,description:\"An error occured while running this rule\",message:a.message,stack:a.stack,error:a});e(d)}})})}}),e.then(function(a){axe._selectCache=void 0,c(a.filter(function(a){return!!a}))}).catch(d)},e.prototype.after=function(a,b){\"use strict\";var c=this.rules;return a.map(function(a){return axe.utils.findBy(c,\"id\",a.id).after(a,b)})},e.prototype.getRule=function(a){return this.rules.find(function(b){return b.id===a})},e.prototype.validateOptions=function(a){\"use strict\";var b=this;if(\"object\"===za(a.runOnly)){var c=a.runOnly;if(\"rule\"===c.type&&Array.isArray(c.value))c.value.forEach(function(a){if(!b.getRule(a))throw new Error(\"unknown rule `\"+a+\"` in options.runOnly\")});else if(Array.isArray(c.value)&&c.value.length>0){var d=[].concat(c.value);if(b.rules.forEach(function(a){var b,c,e;if(d)for(c=0,e=a.tags.length;c<e;c++)-1!==(b=d.indexOf(a.tags[c]))&&d.splice(b,1)}),0!==d.length)throw new Error(\"could not find tags `\"+d.join(\"`, `\")+\"`\")}}return\"object\"===za(a.rules)&&Object.keys(a.rules).forEach(function(a){if(!b.getRule(a))throw new Error(\"unknown rule `\"+a+\"` in options.rules\")}),a},e.prototype.setBranding=function(a){\"use strict\";var b={brand:this.brand,application:this.application};a&&a.hasOwnProperty(\"brand\")&&a.brand&&\"string\"==typeof a.brand&&(this.brand=a.brand),a&&a.hasOwnProperty(\"application\")&&a.application&&\"string\"==typeof a.application&&(this.application=a.application),this._constructHelpUrls(b)},e.prototype._constructHelpUrls=function(){var a=this,b=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,c=(axe.version.match(/^[1-9][0-9]*\\.[0-9]+/)||[\"x.y\"])[0];this.rules.forEach(function(d){a.data.rules[d.id]||(a.data.rules[d.id]={});var e=a.data.rules[d.id];(\"string\"!=typeof e.helpUrl||b&&e.helpUrl===f(b,d.id,c))&&(e.helpUrl=f(a,d.id,c))})},e.prototype.resetRulesAndChecks=function(){\"use strict\";this._init()},i.prototype.enabled=!0,i.prototype.run=function(a,b,c,d){\"use strict\";b=b||{};var e=b.hasOwnProperty(\"enabled\")?b.enabled:this.enabled,f=b.options||this.options;if(e){var h,i=new g(this),j=axe.utils.checkHelper(i,b,c,d);try{h=this.evaluate.call(j,a.actualNode,f,a)}catch(a){return void d(a)}j.isAsync||(i.result=h,setTimeout(function(){c(i)},0))}else c(null)},i.prototype.configure=function(a){var b=this;[\"options\",\"enabled\"].filter(function(b){return a.hasOwnProperty(b)}).forEach(function(c){return b[c]=a[c]}),[\"evaluate\",\"after\"].filter(function(b){return a.hasOwnProperty(b)}).forEach(function(c){return b[c]=h(a[c])})};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};q.prototype.matches=function(){\"use strict\";return!0},q.prototype.gather=function(a){\"use strict\";var b=axe.utils.select(this.selector,a);return this.excludeHidden?b.filter(function(a){return!axe.utils.isHidden(a.actualNode)}):b},q.prototype.runChecks=function(a,b,c,d,e){\"use strict\";var f=this,g=axe.utils.queue();this[a].forEach(function(a){var d=f._audit.checks[a.id||a],e=axe.utils.getCheckOption(d,f.id,c);g.defer(function(a,c){d.run(b,e,a,c)})}),g.then(function(b){b=b.filter(function(a){return a}),d({type:a,results:b})}).catch(e)},q.prototype.run=function(a,c,d,e){var f=this,g=axe.utils.queue(),h=new p(this),i=\"mark_runchecks_start_\"+this.id,j=\"mark_runchecks_end_\"+this.id,k=void 0;try{k=this.gather(a).filter(function(a){return f.matches(a.actualNode,a)})}catch(a){return void e(new b({cause:a,ruleId:this.id}))}c.performanceTimer&&(axe.log(\"gather (\",k.length,\"):\",axe.utils.performanceTimer.timeElapsed()+\"ms\"),axe.utils.performanceTimer.mark(i)),k.forEach(function(a){g.defer(function(b,d){var e=axe.utils.queue();e.defer(function(b,d){f.runChecks(\"any\",a,c,b,d)}),e.defer(function(b,d){f.runChecks(\"all\",a,c,b,d)}),e.defer(function(b,d){f.runChecks(\"none\",a,c,b,d)}),e.then(function(d){if(d.length){var e=!1,f={};d.forEach(function(a){var b=a.results.filter(function(a){return a});f[a.type]=b,b.length&&(e=!0)}),e&&(f.node=new axe.utils.DqElement(a.actualNode,c),h.nodes.push(f))}b()}).catch(function(a){return d(a)})})}),c.performanceTimer&&(axe.utils.performanceTimer.mark(j),axe.utils.performanceTimer.measure(\"runchecks_\"+this.id,i,j)),g.then(function(){return d(h)}).catch(function(a){return e(a)})},q.prototype.after=function(a,b){\"use strict\";var c=r(this),d=this.id;return c.forEach(function(c){var e=s(a.nodes,c.id),f=axe.utils.getCheckOption(c,d,b),g=c.after(e,f);e.forEach(function(a){-1===g.indexOf(a)&&(a.filtered=!0)})}),a.nodes=u(a),a},q.prototype.configure=function(a){\"use strict\";a.hasOwnProperty(\"selector\")&&(this.selector=a.selector),a.hasOwnProperty(\"excludeHidden\")&&(this.excludeHidden=\"boolean\"!=typeof a.excludeHidden||a.excludeHidden),a.hasOwnProperty(\"enabled\")&&(this.enabled=\"boolean\"!=typeof a.enabled||a.enabled),a.hasOwnProperty(\"pageLevel\")&&(this.pageLevel=\"boolean\"==typeof a.pageLevel&&a.pageLevel),a.hasOwnProperty(\"any\")&&(this.any=a.any),a.hasOwnProperty(\"all\")&&(this.all=a.all),a.hasOwnProperty(\"none\")&&(this.none=a.none),a.hasOwnProperty(\"tags\")&&(this.tags=a.tags),a.hasOwnProperty(\"matches\")&&(\"string\"==typeof a.matches?this.matches=new Function(\"return \"+a.matches+\";\")():this.matches=a.matches)},function(axe){var a=[{name:\"NA\",value:\"inapplicable\",priority:0,group:\"inapplicable\"},{name:\"PASS\",value:\"passed\",priority:1,group:\"passes\"},{name:\"CANTTELL\",value:\"cantTell\",priority:2,group:\"incomplete\"},{name:\"FAIL\",value:\"failed\",priority:3,group:\"violations\"}],b={helpUrlBase:\"https://dequeuniversity.com/rules/\",results:[],resultGroups:[],resultGroupMap:{},impact:Object.freeze([\"minor\",\"moderate\",\"serious\",\"critical\"])};a.forEach(function(a){var c=a.name,d=a.value,e=a.priority,f=a.group;b[c]=d,b[c+\"_PRIO\"]=e,b[c+\"_GROUP\"]=f,b.results[e]=d,b.resultGroups[e]=f,b.resultGroupMap[d]=f}),Object.freeze(b.results),Object.freeze(b.resultGroups),Object.freeze(b.resultGroupMap),Object.freeze(b),Object.defineProperty(axe,\"constants\",{value:b,enumerable:!0,configurable:!1,writable:!1})}(axe);var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.log=function(){\"use strict\";\"object\"===(\"undefined\"==typeof console?\"undefined\":za(console))&&console.log&&Function.prototype.apply.call(console.log,console,arguments)},axe.cleanup=v,axe.configure=w,axe.getRules=function(a){\"use strict\";a=a||[];var b=a.length?axe._audit.rules.filter(function(b){return!!a.filter(function(a){return-1!==b.tags.indexOf(a)}).length}):axe._audit.rules,c=axe._audit.data.rules||{};return b.map(function(a){var b=c[a.id]||{};return{ruleId:a.id,description:b.description,help:b.help,helpUrl:b.helpUrl,tags:a.tags}})},axe._load=function(a){\"use strict\";axe.utils.respondable.subscribe(\"axe.ping\",function(a,b,c){c({axe:!0})}),axe.utils.respondable.subscribe(\"axe.start\",x),axe._audit=new e(a)};var axe=axe||{};axe.plugins={},y.prototype.run=function(){\"use strict\";return this._run.apply(this,arguments)},y.prototype.collect=function(){\"use strict\";return this._collect.apply(this,arguments)},y.prototype.cleanup=function(a){\"use strict\";var b=axe.utils.queue(),c=this;Object.keys(this._registry).forEach(function(a){b.defer(function(b){c._registry[a].cleanup(b)})}),b.then(function(){a()})},y.prototype.add=function(a){\"use strict\";this._registry[a.id]=a},axe.registerPlugin=function(a){\"use strict\";axe.plugins[a.id]=new y(a)};var Ba,Ca={};axe.getReporter=function(a){\"use strict\";return\"string\"==typeof a&&Ca[a]?Ca[a]:\"function\"==typeof a?a:Ba},axe.addReporter=function(a,b,c){\"use strict\";Ca[a]=b,c&&(Ba=b)},axe.reset=z,axe._runRules=A;var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},Da=function(){};axe.run=function(a,b,c){\"use strict\";if(!axe._audit)throw new Error(\"No audit configured\");var d=C(a,b,c);a=d.context,b=d.options,c=d.callback,b.reporter=b.reporter||axe._audit.reporter||\"v1\",b.performanceTimer&&axe.utils.performanceTimer.start();var e=void 0,f=Da,g=Da;return window.Promise&&c===Da&&(e=new Promise(function(a,b){f=b,g=a})),axe._runRules(a,b,function(a){var d=function(a){try{c(null,a)}catch(a){axe.log(a)}g(a)};b.performanceTimer&&axe.utils.performanceTimer.end();try{var e=axe.getReporter(b.reporter),h=e(a,b,d);axe._selectorData=void 0,axe._tree=void 0,void 0!==h&&d(h)}catch(a){c(a),f(a)}},function(a){c(a),f(a)}),e},Aa.failureSummary=function(a){\"use strict\";var b={};return b.none=a.none.concat(a.all),b.any=a.any,Object.keys(b).map(function(a){if(b[a].length){var c=axe._audit.data.failureSummaries[a];return c&&\"function\"==typeof c.failureMessage?c.failureMessage(b[a].map(function(a){return a.message||\"\"})):void 0}}).filter(function(a){return void 0!==a}).join(\"\\n\\n\")},Aa.incompleteFallbackMessage=function(){\"use strict\";return axe._audit.data.incompleteFallbackMessage()};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a},Ea=axe.constants.resultGroups;Aa.processAggregate=function(a,b){var c=axe.utils.aggregateResult(a);return c.timestamp=(new Date).toISOString(),c.url=window.location.href,Ea.forEach(function(a){b.resultTypes&&!b.resultTypes.includes(a)&&(c[a]||[]).forEach(function(a){Array.isArray(a.nodes)&&a.nodes.length>0&&(a.nodes=[a.nodes[0]])}),c[a]=(c[a]||[]).map(function(a){return a=Object.assign({},a),Array.isArray(a.nodes)&&a.nodes.length>0&&(a.nodes=a.nodes.map(function(a){return\"object\"===za(a.node)&&(a.html=a.node.source,b.elementRef&&!a.node.fromFrame&&(a.element=a.node.element),(!1!==b.selectors||a.node.fromFrame)&&(a.target=a.node.selector),b.xpath&&(a.xpath=a.node.xpath)),delete a.result,delete a.node,D(a,b),a})),Ea.forEach(function(b){return delete a[b]}),delete a.pageLevel,delete a.result,a})}),c},axe.addReporter(\"na\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=Aa.processAggregate(a,b);c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"no-passes\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={}),b.resultTypes=[\"violations\"];var d=Aa.processAggregate(a,b);c({violations:d.violations,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"raw\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={}),c(a)}),axe.addReporter(\"v1\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=Aa.processAggregate(a,b);d.violations.forEach(function(a){return a.nodes.forEach(function(a){a.failureSummary=Aa.failureSummary(a)})}),c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})}),axe.addReporter(\"v2\",function(a,b,c){\"use strict\";\"function\"==typeof b&&(c=b,b={});var d=Aa.processAggregate(a,b);c({violations:d.violations,passes:d.passes,incomplete:d.incomplete,inapplicable:d.inapplicable,timestamp:d.timestamp,url:d.url})},!0),axe.utils.aggregate=function(a,b,c){b=b.slice(),c&&b.push(c);var d=b.map(function(b){return a.indexOf(b)}).sort();return a[d.pop()]};var Fa=axe.constants,Ga=Fa.CANTTELL_PRIO,Ha=Fa.FAIL_PRIO,Ia=[];Ia[axe.constants.PASS_PRIO]=!0,Ia[axe.constants.CANTTELL_PRIO]=null,Ia[axe.constants.FAIL_PRIO]=!1;var Ja=[\"any\",\"all\",\"none\"];axe.utils.aggregateChecks=function(a){var b=Object.assign({},a);E(b,function(a,b){var c=Ia.indexOf(a.result);a.priority=-1!==c?c:axe.constants.CANTTELL_PRIO,\"none\"===b&&(a.priority=4-a.priority)});var c={all:b.all.reduce(function(a,b){return Math.max(a,b.priority)},0),none:b.none.reduce(function(a,b){return Math.max(a,b.priority)},0),any:b.any.reduce(function(a,b){return Math.min(a,b.priority)},4)%4};b.priority=Math.max(c.all,c.none,c.any);var d=[];return Ja.forEach(function(a){b[a]=b[a].filter(function(d){return d.priority===b.priority&&d.priority===c[a]}),b[a].forEach(function(a){return d.push(a.impact)})}),[Ga,Ha].includes(b.priority)?b.impact=axe.utils.aggregate(axe.constants.impact,d):b.impact=null,E(b,function(a){delete a.result,delete a.priority}),b.result=axe.constants.results[b.priority],delete b.priority,b},function(){axe.utils.aggregateNodeResults=function(a){var b={};if((a=a.map(function(a){if(a.any&&a.all&&a.none)return axe.utils.aggregateChecks(a);if(Array.isArray(a.node))return axe.utils.finalizeRuleResult(a);throw new TypeError(\"Invalid Result type\")}))&&a.length){var c=a.map(function(a){return a.result});b.result=axe.utils.aggregate(axe.constants.results,c,b.result)}else b.result=\"inapplicable\";axe.constants.resultGroups.forEach(function(a){return b[a]=[]}),a.forEach(function(a){var c=axe.constants.resultGroupMap[a.result];b[c].push(a)});var d=axe.constants.FAIL_GROUP;if(0===b[d].length&&(d=axe.constants.CANTTELL_GROUP),b[d].length>0){var e=b[d].map(function(a){return a.impact});b.impact=axe.utils.aggregate(axe.constants.impact,e)||null}else b.impact=null;return b}}(),axe.utils.aggregateResult=function(a){var b={};return axe.constants.resultGroups.forEach(function(a){return b[a]=[]}),a.forEach(function(a){a.error?F(b,a,axe.constants.CANTTELL_GROUP):a.result===axe.constants.NA?F(b,a,axe.constants.NA_GROUP):axe.constants.resultGroups.forEach(function(c){Array.isArray(a[c])&&a[c].length>0&&F(b,a,c)})}),b},axe.utils.areStylesSet=G,axe.utils.checkHelper=function(a,b,c,d){\"use strict\";return{isAsync:!1,async:function(){return this.isAsync=!0,function(b){b instanceof Error==!1?(a.result=b,c(a)):d(b)}},data:function(b){a.data=b},relatedNodes:function(c){c=c instanceof Node?[c]:axe.utils.toArray(c),a.relatedNodes=c.map(function(a){return new axe.utils.DqElement(a,b)})}}};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.clone=function(a){\"use strict\";var b,c,d=a;if(null!==a&&\"object\"===(void 0===a?\"undefined\":za(a)))if(Array.isArray(a))for(d=[],b=0,c=a.length;b<c;b++)d[b]=axe.utils.clone(a[b]);else{d={};for(b in a)d[b]=axe.utils.clone(a[b])}return d},axe.utils.sendCommandToFrame=function(a,b,c,d){\"use strict\";var e=a.contentWindow;if(!e)return axe.log(\"Frame does not have a content window\",a),void c(null);var f=setTimeout(function(){f=setTimeout(function(){var e=H(\"No response from frame\",a);b.debug?d(e):(axe.log(e),c(null))},0)},500);axe.utils.respondable(e,\"axe.ping\",null,void 0,function(){clearTimeout(f);var g=b.options&&b.options.frameWaitTime||6e4;f=setTimeout(function(){d(H(\"Axe in frame timed out\",a))},g),axe.utils.respondable(e,\"axe.start\",b,void 0,function(a){clearTimeout(f),a instanceof Error==!1?c(a):d(a)})})},axe.utils.collectResultsFromFrames=I,axe.utils.contains=function(a,b){\"use strict\";function c(a,b){return a.shadowId===b.shadowId||!!a.children.find(function(a){return c(a,b)})}return a.shadowId||b.shadowId?c(a,b):\"function\"==typeof a.actualNode.contains?a.actualNode.contains(b.actualNode):!!(16&a.actualNode.compareDocumentPosition(b.actualNode))},function(axe){/*!\n  * The copyright below covers the code within this function block only\n  *\n  * Copyright (c) 2013 Dulin Marat\n  * \n  * Permission is hereby granted, free of charge, to any person obtaining a copy\n  * of this software and associated documentation files (the \"Software\"), to deal\n  * in the Software without restriction, including without limitation the rights\n  * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n  * copies of the Software, and to permit persons to whom the Software is\n  * furnished to do so, subject to the following conditions:\n  * \n  * The above copyright notice and this permission notice shall be included in\n  * all copies or substantial portions of the Software.\n  * \n  * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n  * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n  * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n  * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n  * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n  * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n  * THE SOFTWARE.\n  */\nfunction a(){this.pseudos={},this.attrEqualityMods={},this.ruleNestingOperators={},this.substitutesEnabled=!1}function b(a){return a>=\"a\"&&a<=\"z\"||a>=\"A\"&&a<=\"Z\"||\"-\"===a||\"_\"===a}function c(a){return a>=\"a\"&&a<=\"z\"||a>=\"A\"&&a<=\"Z\"||a>=\"0\"&&a<=\"9\"||\"-\"===a||\"_\"===a}function d(a){return a>=\"a\"&&a<=\"f\"||a>=\"A\"&&a<=\"F\"||a>=\"0\"&&a<=\"9\"}function e(a,e,g,j,k,l){var m,n,o,p,q;return p=a.length,m=null,o=function(b,c){var f,g,h;for(h=\"\",e++,m=a.charAt(e);e<p;){if(m===b)return e++,h;if(\"\\\\\"===m)if(e++,(m=a.charAt(e))===b)h+=b;else if(f=c[m])h+=f;else{if(d(m)){for(g=m,e++,m=a.charAt(e);d(m);)g+=m,e++,m=a.charAt(e);\" \"===m&&(e++,m=a.charAt(e)),h+=String.fromCharCode(parseInt(g,16));continue}h+=m}else h+=m;e++,m=a.charAt(e)}return h},n=function(){var b=\"\";for(m=a.charAt(e);e<p;){if(c(m))b+=m;else{if(\"\\\\\"!==m)return b;if(++e>=p)throw Error(\"Expected symbol but end of file reached.\");if(m=a.charAt(e),f[m])b+=m;else{if(d(m)){var g=m;for(e++,m=a.charAt(e);d(m);)g+=m,e++,m=a.charAt(e);\" \"===m&&(e++,m=a.charAt(e)),b+=String.fromCharCode(parseInt(g,16));continue}b+=m}}e++,m=a.charAt(e)}return b},q=function(){m=a.charAt(e);for(var b=!1;\" \"===m||\"\\t\"===m||\"\\n\"===m||\"\\r\"===m||\"\\f\"===m;)b=!0,e++,m=a.charAt(e);return b},this.parse=function(){var b=this.parseSelector();if(e<p)throw Error('Rule expected but \"'+a.charAt(e)+'\" found.');return b},this.parseSelector=function(){var b,c=b=this.parseSingleSelector();for(m=a.charAt(e);\",\"===m;){if(e++,q(),\"selectors\"!==b.type&&(b={type:\"selectors\",selectors:[c]}),!(c=this.parseSingleSelector()))throw Error('Rule expected after \",\".');b.selectors.push(c)}return b},this.parseSingleSelector=function(){q();var b={type:\"ruleSet\"},c=this.parseRule();if(!c)return null;for(var d=b;c&&(c.type=\"rule\",d.rule=c,d=c,q(),m=a.charAt(e),!(e>=p||\",\"===m||\")\"===m));)if(k[m]){var f=m;if(e++,q(),!(c=this.parseRule()))throw Error('Rule expected after \"'+f+'\".');c.nestingOperator=f}else(c=this.parseRule())&&(c.nestingOperator=null);return b},this.parseRule=function(){for(var c=null;e<p;)if(\"*\"===(m=a.charAt(e)))e++,(c=c||{}).tagName=\"*\";else if(b(m)||\"\\\\\"===m)(c=c||{}).tagName=n();else if(\".\"===m)e++,c=c||{},(c.classNames=c.classNames||[]).push(n());else if(\"#\"===m)e++,(c=c||{}).id=n();else if(\"[\"===m){e++,q();var d={name:n()};if(q(),\"]\"===m)e++;else{var f=\"\";if(j[m]&&(f=m,e++,m=a.charAt(e)),e>=p)throw Error('Expected \"=\" but end of file reached.');if(\"=\"!==m)throw Error('Expected \"=\" but \"'+m+'\" found.');d.operator=f+\"=\",e++,q();var k=\"\";if(d.valueType=\"string\",'\"'===m)k=o('\"',i);else if(\"'\"===m)k=o(\"'\",h);else if(l&&\"$\"===m)e++,k=n(),d.valueType=\"substitute\";else{for(;e<p&&\"]\"!==m;)k+=m,e++,m=a.charAt(e);k=k.trim()}if(q(),e>=p)throw Error('Expected \"]\" but end of file reached.');if(\"]\"!==m)throw Error('Expected \"]\" but \"'+m+'\" found.');e++,d.value=k}c=c||{},(c.attrs=c.attrs||[]).push(d)}else{if(\":\"!==m)break;e++;var r=n(),s={name:r};if(\"(\"===m){e++;var t=\"\";if(q(),\"selector\"===g[r])s.valueType=\"selector\",t=this.parseSelector();else{if(s.valueType=g[r]||\"string\",'\"'===m)t=o('\"',i);else if(\"'\"===m)t=o(\"'\",h);else if(l&&\"$\"===m)e++,t=n(),s.valueType=\"substitute\";else{for(;e<p&&\")\"!==m;)t+=m,e++,m=a.charAt(e);t=t.trim()}q()}if(e>=p)throw Error('Expected \")\" but end of file reached.');if(\")\"!==m)throw Error('Expected \")\" but \"'+m+'\" found.');e++,s.value=t}c=c||{},(c.pseudos=c.pseudos||[]).push(s)}return c},this}a.prototype.registerSelectorPseudos=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],this.pseudos[a]=\"selector\";return this},a.prototype.unregisterSelectorPseudos=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],delete this.pseudos[a];return this},a.prototype.registerNumericPseudos=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],this.pseudos[a]=\"numeric\";return this},a.prototype.unregisterNumericPseudos=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],delete this.pseudos[a];return this},a.prototype.registerNestingOperators=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],this.ruleNestingOperators[a]=!0;return this},a.prototype.unregisterNestingOperators=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],delete this.ruleNestingOperators[a];return this},a.prototype.registerAttrEqualityMods=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],this.attrEqualityMods[a]=!0;return this},a.prototype.unregisterAttrEqualityMods=function(a){for(var b=0,c=arguments.length;b<c;b++)a=arguments[b],delete this.attrEqualityMods[a];return this},a.prototype.enableSubstitutes=function(){return this.substitutesEnabled=!0,this},a.prototype.disableSubstitutes=function(){return this.substitutesEnabled=!1,this};var f={\"!\":!0,'\"':!0,\"#\":!0,$:!0,\"%\":!0,\"&\":!0,\"'\":!0,\"(\":!0,\")\":!0,\"*\":!0,\"+\":!0,\",\":!0,\".\":!0,\"/\":!0,\";\":!0,\"<\":!0,\"=\":!0,\">\":!0,\"?\":!0,\"@\":!0,\"[\":!0,\"\\\\\":!0,\"]\":!0,\"^\":!0,\"`\":!0,\"{\":!0,\"|\":!0,\"}\":!0,\"~\":!0},g={\"\\n\":\"\\\\n\",\"\\r\":\"\\\\r\",\"\\t\":\"\\\\t\",\"\\f\":\"\\\\f\",\"\\v\":\"\\\\v\"},h={n:\"\\n\",r:\"\\r\",t:\"\\t\",f:\"\\f\",\"\\\\\":\"\\\\\",\"'\":\"'\"},i={n:\"\\n\",r:\"\\r\",t:\"\\t\",f:\"\\f\",\"\\\\\":\"\\\\\",'\"':'\"'};a.prototype.parse=function(a){return new e(a,0,this.pseudos,this.attrEqualityMods,this.ruleNestingOperators,this.substitutesEnabled).parse()},a.prototype.escapeIdentifier=function(a){for(var b=\"\",c=0,d=a.length;c<d;){var e=a.charAt(c);if(f[e])b+=\"\\\\\"+e;else if(\"_\"===e||\"-\"===e||e>=\"A\"&&e<=\"Z\"||e>=\"a\"&&e<=\"z\"||0!==c&&e>=\"0\"&&e<=\"9\")b+=e;else{var g=e.charCodeAt(0);if(55296==(63488&g)){var h=a.charCodeAt(c++);if(55296!=(64512&g)||56320!=(64512&h))throw Error(\"UCS-2(decode): illegal sequence\");g=((1023&g)<<10)+(1023&h)+65536}b+=\"\\\\\"+g.toString(16)+\" \"}c++}return b},a.prototype.escapeStr=function(a){for(var b,c,d=\"\",e=0,f=a.length;e<f;)b=a.charAt(e),'\"'===b?b='\\\\\"':\"\\\\\"===b?b=\"\\\\\\\\\":(c=g[b])&&(b=c),d+=b,e++;return'\"'+d+'\"'},a.prototype.render=function(a){return this._renderEntity(a).trim()},a.prototype._renderEntity=function(a){var b,c,d;switch(d=\"\",a.type){case\"ruleSet\":for(b=a.rule,c=[];b;)b.nestingOperator&&c.push(b.nestingOperator),c.push(this._renderEntity(b)),b=b.rule;d=c.join(\" \");break;case\"selectors\":d=a.selectors.map(this._renderEntity,this).join(\", \");break;case\"rule\":a.tagName&&(d=\"*\"===a.tagName?\"*\":this.escapeIdentifier(a.tagName)),a.id&&(d+=\"#\"+this.escapeIdentifier(a.id)),a.classNames&&(d+=a.classNames.map(function(a){return\".\"+this.escapeIdentifier(a)},this).join(\"\")),a.attrs&&(d+=a.attrs.map(function(a){return a.operator?\"substitute\"===a.valueType?\"[\"+this.escapeIdentifier(a.name)+a.operator+\"$\"+a.value+\"]\":\"[\"+this.escapeIdentifier(a.name)+a.operator+this.escapeStr(a.value)+\"]\":\"[\"+this.escapeIdentifier(a.name)+\"]\"},this).join(\"\")),a.pseudos&&(d+=a.pseudos.map(function(a){return a.valueType?\"selector\"===a.valueType?\":\"+this.escapeIdentifier(a.name)+\"(\"+this._renderEntity(a.value)+\")\":\"substitute\"===a.valueType?\":\"+this.escapeIdentifier(a.name)+\"($\"+a.value+\")\":\"numeric\"===a.valueType?\":\"+this.escapeIdentifier(a.name)+\"(\"+a.value+\")\":\":\"+this.escapeIdentifier(a.name)+\"(\"+this.escapeIdentifier(a.value)+\")\":\":\"+this.escapeIdentifier(a.name)},this).join(\"\"));break;default:throw Error('Unknown entity type: \"'+a.type(NaN))}return d};var j=new a;j.registerNestingOperators(\">\"),axe.utils.cssParser=j}(axe),L.prototype={get selector(){return this.spec.selector||[axe.utils.getSelector(this.element,this._options)]},get xpath(){return this.spec.xpath||[axe.utils.getXpath(this.element)]},get element(){return this._element},get fromFrame(){return this._fromFrame},toJSON:function(){\"use strict\";return{selector:this.selector,source:this.source,xpath:this.xpath}}},L.fromFrame=function(a,b,c){return a.selector.unshift(c.selector),a.xpath.unshift(c.xpath),new axe.utils.DqElement(c.element,b,a)},axe.utils.DqElement=L,axe.utils.matchesSelector=function(){\"use strict\";function a(a){var b,c,d=a.Element.prototype,e=[\"matches\",\"matchesSelector\",\"mozMatchesSelector\",\"webkitMatchesSelector\",\"msMatchesSelector\"],f=e.length;for(b=0;b<f;b++)if(c=e[b],d[c])return c}var b;return function(c,d){return b&&c[b]||(b=a(c.ownerDocument.defaultView)),c[b](d)}}(),axe.utils.escapeSelector=function(a){\"use strict\";for(var b,c=String(a),d=c.length,e=-1,f=\"\",g=c.charCodeAt(0);++e<d;){if(0==(b=c.charCodeAt(e)))throw new Error(\"INVALID_CHARACTER_ERR\");b>=1&&b<=31||b>=127&&b<=159||0==e&&b>=48&&b<=57||1==e&&b>=48&&b<=57&&45==g?f+=\"\\\\\"+b.toString(16)+\" \":f+=(1!=e||45!=b||45!=g)&&(b>=128||45==b||95==b||b>=48&&b<=57||b>=65&&b<=90||b>=97&&b<=122)?c.charAt(e):\"\\\\\"+c.charAt(e)}return f},axe.utils.extendMetaData=function(a,b){Object.assign(a,b),Object.keys(b).filter(function(a){return\"function\"==typeof b[a]}).forEach(function(c){a[c]=null;try{a[c]=b[c](a)}catch(a){}})},axe.utils.finalizeRuleResult=function(a){return Object.assign(a,axe.utils.aggregateNodeResults(a.nodes)),delete a.nodes,a};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.findBy=function(a,b,c){if(Array.isArray(a))return a.find(function(a){return\"object\"===(void 0===a?\"undefined\":za(a))&&a[b]===c})};var axe=axe||{utils:{}};axe.utils.getFlattenedTree=function(a,b){function c(a,c){var d=axe.utils.getFlattenedTree(c,b);return d&&(a=a.concat(d)),a}var d,e,f;if(a.documentElement&&(a=a.documentElement),f=a.nodeName.toLowerCase(),axe.utils.isShadowRoot(a))return d=M(a,b),b=\"a\"+Math.random().toString().substring(2),e=Array.from(a.shadowRoot.childNodes),d.children=e.reduce(c,[]),[d];if(\"content\"===f)return e=Array.from(a.getDistributedNodes()),e.reduce(c,[]);if(\"slot\"===f){e=Array.from(a.assignedNodes()),e.length||(e=N(a));window.getComputedStyle(a);return e.reduce(c,[])}return 1===a.nodeType?(d=M(a,b),e=Array.from(a.childNodes),d.children=e.reduce(c,[]),[d]):3===a.nodeType?[M(a)]:void 0},axe.utils.getNodeFromTree=function(a,b){var c;return a.actualNode===b?a:(a.children.forEach(function(a){var d;a.actualNode===b?c=a:(d=axe.utils.getNodeFromTree(a,b))&&(c=d)}),c)},axe.utils.getAllChecks=function(a){\"use strict\";return[].concat(a.any||[]).concat(a.all||[]).concat(a.none||[])},axe.utils.getCheckOption=function(a,b,c){var d=((c.rules&&c.rules[b]||{}).checks||{})[a.id],e=(c.checks||{})[a.id],f=a.enabled,g=a.options;return e&&(e.hasOwnProperty(\"enabled\")&&(f=e.enabled),e.hasOwnProperty(\"options\")&&(g=e.options)),d&&(d.hasOwnProperty(\"enabled\")&&(f=d.enabled),d.hasOwnProperty(\"options\")&&(g=d.options)),{enabled:f,options:g,absolutePaths:c.absolutePaths}};var Ka=function(){function a(a,b){var c=[],d=!0,e=!1,f=void 0;try{for(var g,h=a[Symbol.iterator]();!(d=(g=h.next()).done)&&(c.push(g.value),!b||c.length!==b);d=!0);}catch(a){e=!0,f=a}finally{try{!d&&h.return&&h.return()}finally{if(e)throw f}}return c}return function(b,c){if(Array.isArray(b))return b;if(Symbol.iterator in Object(b))return a(b,c);throw new TypeError(\"Invalid attempt to destructure non-iterable instance\")}}();axe.utils.getFriendlyUriEnd=function(){var a=arguments.length>0&&void 0!==arguments[0]?arguments[0]:\"\",b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!(a.length<=1||\"data:\"===a.substr(0,5)||\"javascript:\"===a.substr(0,11)||a.includes(\"?\"))){var c=b.currentDomain,d=b.maxLength,e=void 0===d?25:d,f=Q(a),g=f.path,h=f.domain,i=f.hash,j=g.substr(g.substr(0,g.length-2).lastIndexOf(\"/\")+1);if(i)return j&&(j+i).length<=e?j+i:j.length<2&&i.length>2&&i.length<=e?i:void 0;if(h&&h.length<e&&g.length<=1)return h+g;if(g===\"/\"+j&&h&&c&&h!==c&&(h+g).length<=e)return h+g;var k=j.lastIndexOf(\".\");return(-1===k||k>1)&&(-1!==k||j.length>2)&&j.length<=e&&!j.match(/index(\\.[a-zA-Z]{2-4})?/)&&!O(j)?j:void 0}};var La=axe.utils.escapeSelector,Ma=void 0,Na=[\"class\",\"style\",\"id\",\"selected\",\"checked\",\"disabled\",\"tabindex\",\"aria-checked\",\"aria-selected\",\"aria-invalid\",\"aria-activedescendant\",\"aria-busy\",\"aria-disabled\",\"aria-expanded\",\"aria-grabbed\",\"aria-pressed\",\"aria-valuenow\"],Oa=31;axe.utils.getSelectorData=function(a){var b={classes:{},tags:{},attributes:{}};a=Array.isArray(a)?a:[a];for(var c=a.slice(),d=[];c.length;)!function(){var a=c.pop(),e=a.actualNode;if(e.querySelectorAll){var f=e.nodeName;b.tags[f]?b.tags[f]++:b.tags[f]=1,e.classList&&Array.from(e.classList).forEach(function(a){var c=La(a);b.classes[c]?b.classes[c]++:b.classes[c]=1}),e.attributes&&Array.from(e.attributes).filter(T).forEach(function(a){var c=R(e,a);c&&(b.attributes[c]?b.attributes[c]++:b.attributes[c]=1)})}for(a.children.length&&(d.push(c),c=a.children.slice());!c.length&&d.length;)c=d.pop()}();return b},axe.utils.getSelector=function(a){var b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!a)return\"\";var c=a.getRootNode&&a.getRootNode()||document;if(11===c.nodeType){for(var d=[];11===c.nodeType;)d.push({elm:a,doc:c}),a=c.host,c=a.getRootNode();return d.push({elm:a,doc:c}),d.reverse().map(function(a){return $(a.elm,b,a.doc)})}return $(a,b,c)},axe.utils.getXpath=function(a){return aa(_(a))};var Pa;axe.utils.injectStyle=ba,axe.utils.isHidden=function(a,b){\"use strict\";var c;if(9===a.nodeType)return!1;11===a.nodeType&&(a=a.host);var d=window.getComputedStyle(a,null);return!d||!a.parentNode||\"none\"===d.getPropertyValue(\"display\")||!b&&\"hidden\"===d.getPropertyValue(\"visibility\")||\"true\"===a.getAttribute(\"aria-hidden\")||(c=a.assignedSlot?a.assignedSlot:a.parentNode,axe.utils.isHidden(c,!0))};var Qa=[\"article\",\"aside\",\"blockquote\",\"body\",\"div\",\"footer\",\"h1\",\"h2\",\"h3\",\"h4\",\"h5\",\"h6\",\"header\",\"main\",\"nav\",\"p\",\"section\",\"span\"];axe.utils.isShadowRoot=function(a){var b=a.nodeName.toLowerCase();return!(!a.shadowRoot||!/^[a-z][a-z0-9_.-]*-[a-z0-9_.-]*$/.test(b)&&!Qa.includes(b))},axe.utils.isXHTML=function(a){\"use strict\";return!!a.createElement&&\"A\"===a.createElement(\"A\").localName},axe.utils.mergeResults=function(a,b){\"use strict\";var c=[];return a.forEach(function(a){var d=ea(a);d&&d.length&&d.forEach(function(d){d.nodes&&a.frame&&ca(d.nodes,b,a.frameElement,a.frame);var e=axe.utils.findBy(c,\"id\",d.id);e?d.nodes.length&&da(e.nodes,d.nodes):c.push(d)})}),c},axe.utils.nodeSorter=function(a,b){\"use strict\";return a.actualNode===b.actualNode?0:4&a.actualNode.compareDocumentPosition(b.actualNode)?-1:1},utils.performanceTimer=function(){\"use strict\";function a(){if(window.performance&&window.performance)return window.performance.now()}var b=null,c=a();return{start:function(){this.mark(\"mark_axe_start\")},end:function(){this.mark(\"mark_axe_end\"),this.measure(\"axe\",\"mark_axe_start\",\"mark_axe_end\"),this.logMeasures(\"axe\")},auditStart:function(){this.mark(\"mark_audit_start\")},auditEnd:function(){this.mark(\"mark_audit_end\"),this.measure(\"audit_start_to_end\",\"mark_audit_start\",\"mark_audit_end\"),this.logMeasures()},mark:function(a){window.performance&&void 0!==window.performance.mark&&window.performance.mark(a)},measure:function(a,b,c){window.performance&&void 0!==window.performance.measure&&window.performance.measure(a,b,c)},logMeasures:function(a){function b(a){axe.log(\"Measure \"+a.name+\" took \"+a.duration+\"ms\")}if(window.performance&&void 0!==window.performance.getEntriesByType)for(var c=window.performance.getEntriesByType(\"measure\"),d=0;d<c.length;++d){var e=c[d];if(e.name===a)return void b(e);b(e)}},timeElapsed:function(){return a()-c},reset:function(){b||(b=a()),c=a()}}}(),\"function\"!=typeof Object.assign&&function(){Object.assign=function(a){\"use strict\";if(void 0===a||null===a)throw new TypeError(\"Cannot convert undefined or null to object\");for(var b=Object(a),c=1;c<arguments.length;c++){var d=arguments[c];if(void 0!==d&&null!==d)for(var e in d)d.hasOwnProperty(e)&&(b[e]=d[e])}return b}}(),Array.prototype.find||Object.defineProperty(Array.prototype,\"find\",{value:function(a){if(null===this)throw new TypeError(\"Array.prototype.find called on null or undefined\");if(\"function\"!=typeof a)throw new TypeError(\"predicate must be a function\");for(var b,c=Object(this),d=c.length>>>0,e=arguments[1],f=0;f<d;f++)if(b=c[f],a.call(e,b,f,c))return b}}),axe.utils.pollyfillElementsFromPoint=function(){if(document.elementsFromPoint)return document.elementsFromPoint;if(document.msElementsFromPoint)return document.msElementsFromPoint;var a=function(){var a=document.createElement(\"x\");return a.style.cssText=\"pointer-events:auto\",\"auto\"===a.style.pointerEvents}(),b=a?\"pointer-events\":\"visibility\",c=a?\"none\":\"hidden\",d=document.createElement(\"style\");return d.innerHTML=a?\"* { pointer-events: all }\":\"* { visibility: visible }\",function(a,e){var f,g,h,i=[],j=[];for(document.head.appendChild(d);(f=document.elementFromPoint(a,e))&&-1===i.indexOf(f);)i.push(f),j.push({value:f.style.getPropertyValue(b),priority:f.style.getPropertyPriority(b)}),f.style.setProperty(b,c,\"important\");for(i.indexOf(document.documentElement)<i.length-1&&(i.splice(i.indexOf(document.documentElement),1),i.push(document.documentElement)),g=j.length;h=j[--g];)i[g].style.setProperty(b,h.value?h.value:\"\",h.priority);return document.head.removeChild(d),i}},\"function\"==typeof window.addEventListener&&(document.elementsFromPoint=axe.utils.pollyfillElementsFromPoint()),Array.prototype.includes||Object.defineProperty(Array.prototype,\"includes\",{value:function(a){\"use strict\";var b=Object(this),c=parseInt(b.length,10)||0;if(0===c)return!1;var d,e=parseInt(arguments[1],10)||0;e>=0?d=e:(d=c+e)<0&&(d=0);for(var f;d<c;){if(f=b[d],a===f||a!==a&&f!==f)return!0;d++}return!1}}),Array.prototype.some||Object.defineProperty(Array.prototype,\"some\",{value:function(a){\"use strict\";if(null==this)throw new TypeError(\"Array.prototype.some called on null or undefined\");if(\"function\"!=typeof a)throw new TypeError;for(var b=Object(this),c=b.length>>>0,d=arguments.length>=2?arguments[1]:void 0,e=0;e<c;e++)if(e in b&&a.call(d,b[e],e,b))return!0;return!1}}),Array.from||Object.defineProperty(Array,\"from\",{value:function(){var a=Object.prototype.toString,b=function(b){return\"function\"==typeof b||\"[object Function]\"===a.call(b)},c=function(a){var b=Number(a);return isNaN(b)?0:0!==b&&isFinite(b)?(b>0?1:-1)*Math.floor(Math.abs(b)):b},d=Math.pow(2,53)-1,e=function(a){var b=c(a);return Math.min(Math.max(b,0),d)};return function(a){var c=this,d=Object(a);if(null==a)throw new TypeError(\"Array.from requires an array-like object - not null or undefined\");var f,g=arguments.length>1?arguments[1]:void 0;if(void 0!==g){if(!b(g))throw new TypeError(\"Array.from: when provided, the second argument must be a function\");arguments.length>2&&(f=arguments[2])}for(var h,i=e(d.length),j=b(c)?Object(new c(i)):new Array(i),k=0;k<i;)h=d[k],j[k]=g?void 0===f?g(h,k):g.call(f,h,k):h,k+=1;return j.length=i,j}}()}),String.prototype.includes||(String.prototype.includes=function(a,b){return\"number\"!=typeof b&&(b=0),!(b+a.length>this.length)&&-1!==this.indexOf(a,b)});var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};axe.utils.publishMetaData=function(a){\"use strict\";var b=axe._audit.data.checks||{},c=axe._audit.data.rules||{},d=axe.utils.findBy(axe._audit.rules,\"id\",a.id)||{};a.tags=axe.utils.clone(d.tags||[]);var e=ga(b,!0),f=ga(b,!1);a.nodes.forEach(function(a){a.any.forEach(e),a.all.forEach(e),a.none.forEach(f)}),axe.utils.extendMetaData(a,axe.utils.clone(c[a.id]||{}))};var Ra=function(){},Sa=function(){},Ta=function(){/*! Credit: XRegExp 0.6.1 (c) 2007-2008 Steven Levithan <http://stevenlevithan.com/regex/xregexp/> MIT License */\nvar a=/(?=[\\-\\[\\]{}()*+?.\\\\\\^$|,#\\s])/g;return function(b){return b.replace(a,\"\\\\\")}}(),Ua=/\\\\/g;Ra=function(a){return a.map(function(a){for(var b=[],c=a.rule;c;)b.push({tag:c.tagName?c.tagName.toLowerCase():\"*\",combinator:c.nestingOperator?c.nestingOperator:\" \",id:c.id,attributes:ma(c.attrs),classes:na(c.classNames),pseudos:oa(c.pseudos)}),c=c.rule;return b})},Sa=function(a,b,c,d){for(var e=[],f=Array.isArray(a)?a:[a],g=pa(f,b,[],a[0].shadowId),h=[];g.nodes.length;){for(var i=g.nodes.pop(),j=[],k=[],l=g.anyLevel.slice().concat(g.thisLevel),m=!1,n=0;n<l.length;n++){var o=l[n];if(qa(i,o)&&(!o[0].id||i.shadowId===g.parentShadowId))if(1===o.length)m||d&&!d(i)||(h.push(i),m=!0);else{var p=o.slice(1);if(!1===[\" \",\">\"].includes(p[0].combinator))throw new Error(\"axe.utils.querySelectorAll does not support the combinator: \"+o[1].combinator);\">\"===p[0].combinator?j.push(p):k.push(p)}!g.anyLevel.includes(o)||o[0].id&&i.shadowId!==g.parentShadowId||k.push(o)}for(i.children&&i.children.length&&c&&(e.push(g),g=pa(i.children,k,j,i.shadowId));!g.nodes.length&&e.length;)g=e.pop()}return h},axe.utils.querySelectorAll=function(a,b){return axe.utils.querySelectorAllFilter(a,b)},axe.utils.querySelectorAllFilter=function(a,b,c){a=Array.isArray(a)?a:[a];var d=axe.utils.cssParser.parse(b);return d=d.selectors?d.selectors:[d],d=Ra(d),Sa(a,d,!0,c)};var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};!function(){\"use strict\";function a(){}function b(a){if(\"function\"!=typeof a)throw new TypeError(\"Queue methods require functions as arguments\")}function c(){function c(b){return function(c){g[b]=c,(i-=1)||j===a||(k=!0,j(g))}}function d(b){return j=a,m(b),g}function e(){for(var a=g.length;h<a;h++){var b=g[h];try{b.call(null,c(h),d)}catch(a){d(a)}}}var f,g=[],h=0,i=0,j=a,k=!1,l=function(a){f=a,setTimeout(function(){void 0!==f&&null!==f&&axe.log(\"Uncaught error (of queue)\",f)},1)},m=l,n={defer:function(a){if(\"object\"===(void 0===a?\"undefined\":za(a))&&a.then&&a.catch){var c=a;a=function(a,b){c.then(a).catch(b)}}if(b(a),void 0===f){if(k)throw new Error(\"Queue already completed\");return g.push(a),++i,e(),n}},then:function(c){if(b(c),j!==a)throw new Error(\"queue `then` already set\");return f||(j=c,i||(k=!0,j(g))),n},catch:function(a){if(b(a),m!==l)throw new Error(\"queue `catch` already set\");return f?(a(f),f=null):m=a,n},abort:d};return n}axe.utils.queue=c}();var za=\"function\"==typeof Symbol&&\"symbol\"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&\"function\"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?\"symbol\":typeof a};!function(a){\"use strict\";function b(){var a=\"axe\",b=\"\";return void 0!==axe&&axe._audit&&!axe._audit.application&&(a=axe._audit.application),void 0!==axe&&(b=axe.version),a+\".\"+b}function c(a){if(\"object\"===(void 0===a?\"undefined\":za(a))&&\"string\"==typeof a.uuid&&!0===a._respondable){var c=b();return a._source===c||\"axe.x.y.z\"===a._source||\"axe.x.y.z\"===c}return!1}function d(a,c,d,e,f,g){var h;d instanceof Error&&(h={name:d.name,message:d.message,stack:d.stack},d=void 0);var i={uuid:e,topic:c,message:d,error:h,_respondable:!0,_source:b(),_keepalive:f};\"function\"==typeof g&&(j[e]=g),a.postMessage(JSON.stringify(i),\"*\")}function e(a,b,c,e,f){d(a,b,c,Va.v1(),e,f)}function f(a,b,c){return function(e,f,g){d(a,b,e,c,f,g)}}function g(a,b,c){var d=b.topic,e=k[d];if(e){var g=f(a,null,b.uuid);e(b.message,c,g)}}function h(a){var b=a.message||\"Unknown error occurred\",c=l.includes(a.name)?a.name:\"Error\",d=window[c]||Error;return a.stack&&(b+=\"\\n\"+a.stack.replace(a.message,\"\")),new d(b)}function i(a){var b;if(\"string\"==typeof a){try{b=JSON.parse(a)}catch(a){}if(c(b))return\"object\"===za(b.error)?b.error=h(b.error):b.error=void 0,b}}var j={},k={},l=Object.freeze([\"EvalError\",\"RangeError\",\"ReferenceError\",\"SyntaxError\",\"TypeError\",\"URIError\"]);e.subscribe=function(a,b){k[a]=b},e.isInFrame=function(a){return a=a||window,!!a.frameElement},\"function\"==typeof window.addEventListener&&window.addEventListener(\"message\",function(a){var b=i(a.data);if(b){var c=b.uuid,e=b._keepalive,h=j[c];if(h){h(b.error||b.message,e,f(a.source,b.topic,c)),e||delete j[c]}if(!b.error)try{g(a.source,b,e)}catch(e){d(a.source,b.topic,e,c,!1)}}},!1),a.respondable=e}(utils),axe.utils.ruleShouldRun=function(a,b,c){\"use strict\";var d=c.runOnly||{},e=(c.rules||{})[a.id];return!(a.pageLevel&&!b.page)&&(\"rule\"===d.type?-1!==d.values.indexOf(a.id):e&&\"boolean\"==typeof e.enabled?e.enabled:\"tag\"===d.type&&d.values?ra(a,d.values):ra(a,[]))},axe.utils.getScrollState=function(){var a=arguments.length>0&&void 0!==arguments[0]?arguments[0]:window,b=a.document.documentElement;return[void 0!==a.pageXOffset?{elm:a,top:a.pageYOffset,left:a.pageXOffset}:{elm:b,top:b.scrollTop,left:b.scrollLeft}].concat(ua(document.body))},axe.utils.setScrollState=function(a){a.forEach(function(a){return ta(a.elm,a.top,a.left)})},axe.utils.select=function(a,b){\"use strict\";var c,d=[];if(axe._selectCache)for(var e=0,f=axe._selectCache.length;e<f;e++){var g=axe._selectCache[e];if(g.selector===a)return g.result}for(var h=function(a){return function(b){return wa(b,a)}}(b),i=ya(b.include),j=0;j<i.length;j++)c=i[j],c.actualNode.nodeType===c.actualNode.ELEMENT_NODE&&axe.utils.matchesSelector(c.actualNode,a)&&h(c)&&(d=xa(d,[c])),d=xa(d,axe.utils.querySelectorAllFilter(c,a,h));return axe._selectCache&&axe._selectCache.push({selector:a,result:d}),d},axe.utils.toArray=function(a){\"use strict\";return Array.prototype.slice.call(a)},axe.utils.uniqueArray=function(a,b){return a.concat(b).filter(function(a,b,c){return c.indexOf(a)===b})};var Va;!function(a){function b(a,b,c){var d=b&&c||0,e=0;for(b=b||[],a.toLowerCase().replace(/[0-9a-f]{2}/g,function(a){e<16&&(b[d+e++]=l[a])});e<16;)b[d+e++]=0;return b}function c(a,b){var c=b||0,d=k;return d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+\"-\"+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]+d[a[c++]]}function d(a,b,d){var e=b&&d||0,f=b||[];a=a||{};var g=null!=a.clockseq?a.clockseq:p,h=null!=a.msecs?a.msecs:(new Date).getTime(),i=null!=a.nsecs?a.nsecs:r+1,j=h-q+(i-r)/1e4;if(j<0&&null==a.clockseq&&(g=g+1&16383),(j<0||h>q)&&null==a.nsecs&&(i=0),i>=1e4)throw new Error(\"uuid.v1(): Can't create more than 10M uuids/sec\");q=h,r=i,p=g,h+=122192928e5;var k=(1e4*(268435455&h)+i)%4294967296;f[e++]=k>>>24&255,f[e++]=k>>>16&255,f[e++]=k>>>8&255,f[e++]=255&k;var l=h/4294967296*1e4&268435455;f[e++]=l>>>8&255,f[e++]=255&l,f[e++]=l>>>24&15|16,f[e++]=l>>>16&255,f[e++]=g>>>8|128,f[e++]=255&g;for(var m=a.node||o,n=0;n<6;n++)f[e+n]=m[n];return b||c(f)}function e(a,b,d){var e=b&&d||0;\"string\"==typeof a&&(b=\"binary\"==a?new j(16):null,a=null),a=a||{};var g=a.random||(a.rng||f)();if(g[6]=15&g[6]|64,g[8]=63&g[8]|128,b)for(var h=0;h<16;h++)b[e+h]=g[h];return b||c(g)}var f,g=a.crypto||a.msCrypto;if(!f&&g&&g.getRandomValues){var h=new Uint8Array(16);f=function(){return g.getRandomValues(h),h}}if(!f){var i=new Array(16);f=function(){for(var a,b=0;b<16;b++)0==(3&b)&&(a=4294967296*Math.random()),i[b]=a>>>((3&b)<<3)&255;return i}}for(var j=\"function\"==typeof a.Buffer?a.Buffer:Array,k=[],l={},m=0;m<256;m++)k[m]=(m+256).toString(16).substr(1),l[k[m]]=m;var n=f(),o=[1|n[0],n[1],n[2],n[3],n[4],n[5]],p=16383&(n[6]<<8|n[7]),q=0,r=0;Va=e,Va.v1=d,Va.v4=e,Va.parse=b,Va.unparse=c,Va.BufferClass=j}(window),axe._load({data:{rules:{accesskeys:{description:\"Ensures every accesskey attribute value is unique\",help:\"accesskey attribute value must be unique\"},\"area-alt\":{description:\"Ensures <area> elements of image maps have alternate text\",help:\"Active <area> elements must have alternate text\"},\"aria-allowed-attr\":{description:\"Ensures ARIA attributes are allowed for an element's role\",help:\"Elements must only use allowed ARIA attributes\"},\"aria-hidden-body\":{description:\"Ensures aria-hidden='true' is not present on the document body.\",help:\"aria-hidden='true' must not be present on the document body\"},\"aria-required-attr\":{description:\"Ensures elements with ARIA roles have all required ARIA attributes\",help:\"Required ARIA attributes must be provided\"},\"aria-required-children\":{description:\"Ensures elements with an ARIA role that require child roles contain them\",help:\"Certain ARIA roles must contain particular children\"},\"aria-required-parent\":{description:\"Ensures elements with an ARIA role that require parent roles are contained by them\",help:\"Certain ARIA roles must be contained by particular parents\"},\"aria-roles\":{description:\"Ensures all elements with a role attribute use a valid value\",help:\"ARIA roles used must conform to valid values\"},\"aria-valid-attr-value\":{description:\"Ensures all ARIA attributes have valid values\",help:\"ARIA attributes must conform to valid values\"},\"aria-valid-attr\":{description:\"Ensures attributes that begin with aria- are valid ARIA attributes\",help:\"ARIA attributes must conform to valid names\"},\"audio-caption\":{description:\"Ensures <audio> elements have captions\",help:\"<audio> elements must have a captions track\"},blink:{description:\"Ensures <blink> elements are not used\",help:\"<blink> elements are deprecated and must not be used\"},\"button-name\":{description:\"Ensures buttons have discernible text\",help:\"Buttons must have discernible text\"},bypass:{description:\"Ensures each page has at least one mechanism for a user to bypass navigation and jump straight to the content\",help:\"Page must have means to bypass repeated blocks\"},checkboxgroup:{description:'Ensures related <input type=\"checkbox\"> elements have a group and that that group designation is consistent',help:\"Checkbox inputs with the same name attribute value must be part of a group\"},\"color-contrast\":{description:\"Ensures the contrast between foreground and background colors meets WCAG 2 AA contrast ratio thresholds\",help:\"Elements must have sufficient color contrast\"},\"definition-list\":{description:\"Ensures <dl> elements are structured correctly\",help:\"<dl> elements must only directly contain properly-ordered <dt> and <dd> groups, <script> or <template> elements\"},dlitem:{description:\"Ensures <dt> and <dd> elements are contained by a <dl>\",help:\"<dt> and <dd> elements must be contained by a <dl>\"},\"document-title\":{description:\"Ensures each HTML document contains a non-empty <title> element\",help:\"Documents must have <title> element to aid in navigation\"},\"duplicate-id\":{description:\"Ensures every id attribute value is unique\",help:\"id attribute value must be unique\"},\"empty-heading\":{description:\"Ensures headings have discernible text\",help:\"Headings must not be empty\"},\"focus-order-semantics\":{description:\"Ensures elements in the focus order have an appropriate role\",help:\"Elements in the focus order need a role appropriate for interactive content\"},\"frame-title-unique\":{description:\"Ensures <iframe> and <frame> elements contain a unique title attribute\",help:\"Frames must have a unique title attribute\"},\"frame-title\":{description:\"Ensures <iframe> and <frame> elements contain a non-empty title attribute\",help:\"Frames must have title attribute\"},\"heading-order\":{description:\"Ensures the order of headings is semantically correct\",help:\"Heading levels should only increase by one\"},\"hidden-content\":{description:\"Informs users about hidden content.\",help:\"Hidden content on the page cannot be analyzed\"},\"html-has-lang\":{description:\"Ensures every HTML document has a lang attribute\",help:\"<html> element must have a lang attribute\"},\"html-lang-valid\":{description:\"Ensures the lang attribute of the <html> element has a valid value\",help:\"<html> element must have a valid value for the lang attribute\"},\"image-alt\":{description:\"Ensures <img> elements have alternate text or a role of none or presentation\",help:\"Images must have alternate text\"},\"image-redundant-alt\":{description:\"Ensure button and link text is not repeated as image alternative\",help:\"Text of buttons and links should not be repeated in the image alternative\"},\"input-image-alt\":{description:'Ensures <input type=\"image\"> elements have alternate text',help:\"Image buttons must have alternate text\"},\"label-title-only\":{description:\"Ensures that every form element is not solely labeled using the title or aria-describedby attributes\",help:\"Form elements should have a visible label\"},label:{description:\"Ensures every form element has a label\",help:\"Form elements must have labels\"},\"landmark-main-is-top-level\":{description:\"The main landmark should not be contained in another landmark\",help:\"Main landmark is not at top level\"},\"landmark-one-main\":{description:\"Ensures a navigation point to the primary content of the page. If the page contains iframes, each iframe should contain either no main landmarks or just one.\",help:\"Page must contain one main landmark.\"},\"layout-table\":{description:\"Ensures presentational <table> elements do not use <th>, <caption> elements or the summary attribute\",help:\"Layout tables must not use data table elements\"},\"link-in-text-block\":{description:\"Links can be distinguished without relying on color\",help:\"Links must be distinguished from surrounding text in a way that does not rely on color\"},\"link-name\":{description:\"Ensures links have discernible text\",help:\"Links must have discernible text\"},list:{description:\"Ensures that lists are structured correctly\",help:\"<ul> and <ol> must only directly contain <li>, <script> or <template> elements\"},listitem:{description:\"Ensures <li> elements are used semantically\",help:\"<li> elements must be contained in a <ul> or <ol>\"},marquee:{description:\"Ensures <marquee> elements are not used\",help:\"<marquee> elements are deprecated and must not be used\"},\"meta-refresh\":{description:'Ensures <meta http-equiv=\"refresh\"> is not used',help:\"Timed refresh must not exist\"},\"meta-viewport-large\":{description:'Ensures <meta name=\"viewport\"> can scale a significant amount',help:\"Users should be able to zoom and scale the text up to 500%\"},\"meta-viewport\":{description:'Ensures <meta name=\"viewport\"> does not disable text scaling and zooming',help:\"Zooming and scaling must not be disabled\"},\"object-alt\":{description:\"Ensures <object> elements have alternate text\",help:\"<object> elements must have alternate text\"},\"p-as-heading\":{description:\"Ensure p elements are not used to style headings\",help:\"Bold, italic text and font-size are not used to style p elements as a heading\"},radiogroup:{description:'Ensures related <input type=\"radio\"> elements have a group and that the group designation is consistent',help:\"Radio inputs with the same name attribute value must be part of a group\"},region:{description:\"Ensures all content is contained within a landmark region\",help:\"Content should be contained in a landmark region\"},\"scope-attr-valid\":{description:\"Ensures the scope attribute is used correctly on tables\",help:\"scope attribute should be used correctly\"},\"server-side-image-map\":{description:\"Ensures that server-side image maps are not used\",help:\"Server-side image maps must not be used\"},\"skip-link\":{description:\"Ensure all skip links have a focusable target\",help:\"The skip-link target should exist and be focusable\"},tabindex:{description:\"Ensures tabindex attribute values are not greater than 0\",help:\"Elements should not have tabindex greater than zero\"},\"table-duplicate-name\":{description:\"Ensure that tables do not have the same summary and caption\",help:\"The <caption> element should not contain the same text as the summary attribute\"},\"table-fake-caption\":{description:\"Ensure that tables with a caption use the <caption> element.\",help:\"Data or header cells should not be used to give caption to a data table.\"},\"td-has-header\":{description:\"Ensure that each non-empty data cell in a large table has one or more table headers\",help:\"All non-empty td element in table larger than 3 by 3 must have an associated table header\"},\"td-headers-attr\":{description:\"Ensure that each cell in a table using the headers refers to another cell in that table\",help:\"All cells in a table element that use the headers attribute must only refer to other cells of that same table\"},\"th-has-data-cells\":{description:\"Ensure that each table header in a data table refers to data cells\",help:\"All th elements and elements with role=columnheader/rowheader must have data cells they describe\"},\"valid-lang\":{description:\"Ensures lang attributes have valid values\",help:\"lang attribute must have a valid value\"},\"video-caption\":{description:\"Ensures <video> elements have captions\",help:\"<video> elements must have captions\"},\"video-description\":{description:\"Ensures <video> elements have audio descriptions\",help:\"<video> elements must have an audio description track\"}},checks:{accesskeys:{impact:\"serious\",messages:{pass:function(a){return\"Accesskey attribute value is unique\"},fail:function(a){return\"Document has multiple elements with the same accesskey\"}}},\"non-empty-alt\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a non-empty alt attribute\"},fail:function(a){return\"Element has no alt attribute or the alt attribute is empty\"}}},\"non-empty-title\":{impact:\"serious\",messages:{pass:function(a){return\"Element has a title attribute\"},fail:function(a){return\"Element has no title attribute or the title attribute is empty\"}}},\"aria-label\":{impact:\"serious\",messages:{pass:function(a){return\"aria-label attribute exists and is not empty\"},fail:function(a){return\"aria-label attribute does not exist or is empty\"}}},\"aria-labelledby\":{impact:\"serious\",messages:{pass:function(a){return\"aria-labelledby attribute exists and references elements that are visible to screen readers\"},fail:function(a){return\"aria-labelledby attribute does not exist, references elements that do not exist or references elements that are empty or not visible\"}}},\"aria-allowed-attr\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attributes are used correctly for the defined role\"},fail:function(a){var b=\"ARIA attribute\"+(a.data&&a.data.length>1?\"s are\":\" is\")+\" not allowed:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-hidden-body\":{impact:\"critical\",messages:{pass:function(a){return\"No aria-hidden attribute is present on document body\"},fail:function(a){return\"aria-hidden=true should not be present on the document body\"}}},\"aria-required-attr\":{impact:\"critical\",messages:{pass:function(a){return\"All required ARIA attributes are present\"},fail:function(a){var b=\"Required ARIA attribute\"+(a.data&&a.data.length>1?\"s\":\"\")+\" not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-children\":{impact:\"critical\",messages:{pass:function(a){return\"Required ARIA children are present\"},fail:function(a){var b=\"Required ARIA \"+(a.data&&a.data.length>1?\"children\":\"child\")+\" role not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-required-parent\":{impact:\"critical\",messages:{pass:function(a){return\"Required ARIA parent role present\"},fail:function(a){var b=\"Required ARIA parent\"+(a.data&&a.data.length>1?\"s\":\"\")+\" role not present:\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},invalidrole:{impact:\"critical\",messages:{pass:function(a){return\"ARIA role is valid\"},fail:function(a){return\"Role must be one of the valid ARIA roles\"}}},abstractrole:{impact:\"serious\",messages:{pass:function(a){return\"Abstract roles are not used\"},fail:function(a){return\"Abstract roles cannot be directly used\"}}},\"aria-valid-attr-value\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attribute values are valid\"},fail:function(a){var b=\"Invalid ARIA attribute value\"+(a.data&&a.data.length>1?\"s\":\"\")+\":\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},\"aria-errormessage\":{impact:\"critical\",messages:{pass:function(a){return\"Uses a supported aria-errormessage technique\"},fail:function(a){var b=\"aria-errormessage value\"+(a.data&&a.data.length>1?\"s\":\"\")+\" \",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" `\"+d;return b+=\"` must use a technique to announce the message (e.g., aria-live, aria-describedby, role=alert, etc.)\"}}},\"aria-valid-attr\":{impact:\"critical\",messages:{pass:function(a){return\"ARIA attribute name\"+(a.data&&a.data.length>1?\"s\":\"\")+\" are valid\"},fail:function(a){var b=\"Invalid ARIA attribute name\"+(a.data&&a.data.length>1?\"s\":\"\")+\":\",c=a.data;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\" \"+d;return b}}},caption:{impact:\"critical\",messages:{pass:function(a){return\"The multimedia element has a captions track\"},fail:function(a){return\"The multimedia element does not have a captions track\"},incomplete:function(a){return\"A captions track for this element could not be found\"}}},\"is-on-screen\":{impact:\"serious\",messages:{pass:function(a){return\"Element is not visible\"},fail:function(a){return\"Element is visible\"}}},\"non-empty-if-present\":{impact:\"critical\",messages:{pass:function(a){var b=\"Element \";return a.data?b+=\"has a non-empty value attribute\":b+=\"does not have a value attribute\",b},fail:function(a){return\"Element has a value attribute and the value attribute is empty\"}}},\"non-empty-value\":{impact:\"critical\",messages:{pass:function(a){return\"Element has a non-empty value attribute\"},fail:function(a){return\"Element has no value attribute or the value attribute is empty\"}}},\"button-has-visible-text\":{impact:\"critical\",messages:{pass:function(a){return\"Element has inner text that is visible to screen readers\"},fail:function(a){return\"Element does not have inner text that is visible to screen readers\"}}},\"role-presentation\":{impact:\"minor\",messages:{pass:function(a){return'Element\\'s default semantics were overriden with role=\"presentation\"'},fail:function(a){return'Element\\'s default semantics were not overridden with role=\"presentation\"'}}},\"role-none\":{impact:\"minor\",messages:{pass:function(a){return'Element\\'s default semantics were overriden with role=\"none\"'},fail:function(a){return'Element\\'s default semantics were not overridden with role=\"none\"'}}},\"focusable-no-name\":{impact:\"serious\",messages:{pass:function(a){return\"Element is not in tab order or has accessible text\"},fail:function(a){return\"Element is in tab order and does not have accessible text\"}}},\"internal-link-present\":{impact:\"serious\",messages:{pass:function(a){return\"Valid skip link found\"},fail:function(a){return\"No valid skip link found\"}}},\"header-present\":{impact:\"serious\",messages:{pass:function(a){return\"Page has a header\"},fail:function(a){return\"Page does not have a header\"}}},landmark:{impact:\"serious\",messages:{pass:function(a){return\"Page has a landmark region\"},fail:function(a){return\"Page does not have a landmark region\"}}},\"group-labelledby\":{impact:\"critical\",messages:{pass:function(a){return'All elements with the name \"'+a.data.name+'\" reference the same element with aria-labelledby'},fail:function(a){return'All elements with the name \"'+a.data.name+'\" do not reference the same element with aria-labelledby'}}},fieldset:{impact:\"critical\",messages:{pass:function(a){return\"Element is contained in a fieldset\"},fail:function(a){var b=\"\",c=a.data&&a.data.failureCode;return b+=\"no-legend\"===c?\"Fieldset does not have a legend as its first child\":\"empty-legend\"===c?\"Legend does not have text that is visible to screen readers\":\"mixed-inputs\"===c?\"Fieldset contains unrelated inputs\":\"no-group-label\"===c?\"ARIA group does not have aria-label or aria-labelledby\":\"group-mixed-inputs\"===c?\"ARIA group contains unrelated inputs\":\"Element does not have a containing fieldset or ARIA group\"}}},\"color-contrast\":{impact:\"serious\",messages:{pass:function(a){return\"Element has sufficient color contrast of \"+a.data.contrastRatio},fail:function(a){return\"Element has insufficient color contrast of \"+a.data.contrastRatio+\" (foreground color: \"+a.data.fgColor+\", background color: \"+a.data.bgColor+\", font size: \"+a.data.fontSize+\", font weight: \"+a.data.fontWeight+\"). Expected contrast ratio of \"+a.data.expectedContrastRatio},incomplete:{bgImage:\"Element's background color could not be determined due to a background image\",bgGradient:\"Element's background color could not be determined due to a background gradient\",imgNode:\"Element's background color could not be determined because element contains an image node\",bgOverlap:\"Element's background color could not be determined because it is overlapped by another element\",fgAlpha:\"Element's foreground color could not be determined because of alpha transparency\",elmPartiallyObscured:\"Element's background color could not be determined because it's partially obscured by another element\",elmPartiallyObscuring:\"Element's background color could not be determined because it partially overlaps other elements\",outsideViewport:\"Element's background color could not be determined because it's outside the viewport\",equalRatio:\"Element has a 1:1 contrast ratio with the background\",default:\"Unable to determine contrast ratio\"}}},\"structured-dlitems\":{impact:\"serious\",messages:{pass:function(a){return\"When not empty, element has both <dt> and <dd> elements\"},fail:function(a){return\"When not empty, element does not have at least one <dt> element followed by at least one <dd> element\"}}},\"only-dlitems\":{impact:\"serious\",messages:{pass:function(a){return\"List element only has direct children that are allowed inside <dt> or <dd> elements\"},fail:function(a){return\"List element has direct children that are not allowed inside <dt> or <dd> elements\"}}},dlitem:{impact:\"serious\",messages:{pass:function(a){return\"Description list item has a <dl> parent element\"},fail:function(a){return\"Description list item does not have a <dl> parent element\"}}},\"doc-has-title\":{impact:\"serious\",messages:{pass:function(a){return\"Document has a non-empty <title> element\"},fail:function(a){return\"Document does not have a non-empty <title> element\"}}},\"duplicate-id\":{impact:\"moderate\",messages:{pass:function(a){return\"Document has no elements that share the same id attribute\"},fail:function(a){return\"Document has multiple elements with the same id attribute: \"+a.data}}},\"has-visible-text\":{impact:\"minor\",messages:{pass:function(a){return\"Element has text that is visible to screen readers\"},fail:function(a){return\"Element does not have text that is visible to screen readers\"}}},\"has-widget-role\":{impact:\"minor\",messages:{pass:function(a){return\"Element has a widget role.\"},fail:function(a){return\"Element does not have a widget role.\"}}},\"valid-scrollable-semantics\":{impact:\"minor\",messages:{pass:function(a){return\"Element has valid semantics for an element in the focus order.\"},fail:function(a){return\"Element has invalid semantics for an element in the focus order.\"}}},\"unique-frame-title\":{impact:\"serious\",messages:{pass:function(a){return\"Element's title attribute is unique\"},fail:function(a){return\"Element's title attribute is not unique\"}}},\"heading-order\":{impact:\"moderate\",messages:{pass:function(a){return\"Heading order valid\"},fail:function(a){return\"Heading order invalid\"}}},\"hidden-content\":{impact:\"minor\",messages:{pass:function(a){return\"All content on the page has been analyzed.\"},fail:function(a){return\"There were problems analyzing the content on this page.\"},incomplete:function(a){return\"There is hidden content on the page that was not analyzed. You will need to trigger the display of this content in order to analyze it.\"}}},\"has-lang\":{impact:\"serious\",messages:{pass:function(a){return\"The <html> element has a lang attribute\"},fail:function(a){return\"The <html> element does not have a lang attribute\"}}},\"valid-lang\":{impact:\"serious\",messages:{pass:function(a){return\"Value of lang attribute is included in the list of valid languages\"},fail:function(a){return\"Value of lang attribute not included in the list of valid languages\"}}},\"has-alt\":{impact:\"critical\",messages:{pass:function(a){return\"Element has an alt attribute\"},fail:function(a){return\"Element does not have an alt attribute\"}}},\"duplicate-img-label\":{impact:\"minor\",messages:{pass:function(a){return\"Element does not duplicate existing text in <img> alt text\"},fail:function(a){return\"Element contains <img> element with alt text that duplicates existing text\"}}},\"title-only\":{impact:\"serious\",messages:{pass:function(a){return\"Form element does not solely use title attribute for its label\"},fail:function(a){return\"Only title used to generate label for form element\"}}},\"implicit-label\":{impact:\"critical\",messages:{pass:function(a){return\"Form element has an implicit (wrapped) <label>\"},fail:function(a){return\"Form element does not have an implicit (wrapped) <label>\"}}},\"explicit-label\":{impact:\"critical\",messages:{pass:function(a){return\"Form element has an explicit <label>\"},fail:function(a){return\"Form element does not have an explicit <label>\"}}},\"help-same-as-label\":{impact:\"minor\",messages:{pass:function(a){return\"Help text (title or aria-describedby) does not duplicate label text\"},fail:function(a){return\"Help text (title or aria-describedby) text is the same as the label text\"}}},\"multiple-label\":{impact:\"serious\",messages:{pass:function(a){return\"Form element does not have multiple <label> elements\"},fail:function(a){return\"Form element has multiple <label> elements\"}}},\"main-is-top-level\":{impact:\"moderate\",messages:{pass:function(a){return\"The main landmark is at the top level.\"},fail:function(a){return\"The main landmark is contained in another landmark.\"}}},\"has-at-least-one-main\":{impact:\"moderate\",messages:{pass:function(a){return\"Document has at least one main landmark\"},fail:function(a){return\"Document has no main landmarks\"}}},\"has-no-more-than-one-main\":{impact:\"moderate\",messages:{pass:function(a){return\"Document has no more than one main landmark\"},fail:function(a){return\"Document has more than one main landmark\"}}},\"has-th\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use <th> elements\"},fail:function(a){return\"Layout table uses <th> elements\"}}},\"has-caption\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use <caption> element\"},fail:function(a){return\"Layout table uses <caption> element\"}}},\"has-summary\":{impact:\"serious\",messages:{pass:function(a){return\"Layout table does not use summary attribute\"},fail:function(a){return\"Layout table uses summary attribute\"}}},\"link-in-text-block\":{impact:\"serious\",messages:{pass:function(a){return\"Links can be distinguished from surrounding text in some way other than by color\"},fail:function(a){return\"Links need to be distinguished from surrounding text in some way other than by color\"},incomplete:{bgContrast:\"Element's contrast ratio could not be determined. Check for a distinct hover/focus style\",bgImage:\"Element's contrast ratio could not be determined due to a background image\",bgGradient:\"Element's contrast ratio could not be determined due to a background gradient\",imgNode:\"Element's contrast ratio could not be determined because element contains an image node\",bgOverlap:\"Element's contrast ratio could not be determined because of element overlap\",default:\"Unable to determine contrast ratio\"}}},\"only-listitems\":{impact:\"serious\",messages:{pass:function(a){return\"List element only has direct children that are allowed inside <li> elements\"},fail:function(a){return\"List element has direct children that are not allowed inside <li> elements\"}}},listitem:{impact:\"serious\",messages:{pass:function(a){return'List item has a <ul>, <ol> or role=\"list\" parent element'},fail:function(a){return'List item does not have a <ul>, <ol> or role=\"list\" parent element'}}},\"meta-refresh\":{impact:\"critical\",messages:{pass:function(a){return\"<meta> tag does not immediately refresh the page\"},fail:function(a){return\"<meta> tag forces timed refresh of page\"}}},\"meta-viewport-large\":{impact:\"minor\",messages:{pass:function(a){\nreturn\"<meta> tag does not prevent significant zooming on mobile devices\"},fail:function(a){return\"<meta> tag limits zooming on mobile devices\"}}},\"meta-viewport\":{impact:\"critical\",messages:{pass:function(a){return\"<meta> tag does not disable zooming on mobile devices\"},fail:function(a){return\"<meta> tag disables zooming on mobile devices\"}}},\"p-as-heading\":{impact:\"serious\",messages:{pass:function(a){return\"<p> elements are not styled as headings\"},fail:function(a){return\"Heading elements should be used instead of styled p elements\"}}},region:{impact:\"moderate\",messages:{pass:function(a){return\"Content contained by ARIA landmark\"},fail:function(a){return\"Content not contained by an ARIA landmark\"}}},\"html5-scope\":{impact:\"moderate\",messages:{pass:function(a){return\"Scope attribute is only used on table header elements (<th>)\"},fail:function(a){return\"In HTML 5, scope attributes may only be used on table header elements (<th>)\"}}},\"scope-value\":{impact:\"critical\",messages:{pass:function(a){return\"Scope attribute is used correctly\"},fail:function(a){return\"The value of the scope attribute may only be 'row' or 'col'\"}}},exists:{impact:\"minor\",messages:{pass:function(a){return\"Element does not exist\"},fail:function(a){return\"Element exists\"}}},\"skip-link\":{impact:\"moderate\",messages:{pass:function(a){return\"Skip link target exists\"},incomplete:function(a){return\"Skip link target should become visible on activation\"},fail:function(a){return\"No skip link target\"}}},tabindex:{impact:\"serious\",messages:{pass:function(a){return\"Element does not have a tabindex greater than 0\"},fail:function(a){return\"Element has a tabindex greater than 0\"}}},\"same-caption-summary\":{impact:\"minor\",messages:{pass:function(a){return\"Content of summary attribute and <caption> are not duplicated\"},fail:function(a){return\"Content of summary attribute and <caption> element are identical\"}}},\"caption-faked\":{impact:\"serious\",messages:{pass:function(a){return\"The first row of a table is not used as a caption\"},fail:function(a){return\"The first row of the table should be a caption instead of a table cell\"}}},\"td-has-header\":{impact:\"critical\",messages:{pass:function(a){return\"All non-empty data cells have table headers\"},fail:function(a){return\"Some non-empty data cells do not have table headers\"}}},\"td-headers-attr\":{impact:\"serious\",messages:{pass:function(a){return\"The headers attribute is exclusively used to refer to other cells in the table\"},fail:function(a){return\"The headers attribute is not exclusively used to refer to other cells in the table\"}}},\"th-has-data-cells\":{impact:\"serious\",messages:{pass:function(a){return\"All table header cells refer to data cells\"},fail:function(a){return\"Not all table header cells refer to data cells\"},incomplete:function(a){return\"Table data cells are missing or empty\"}}},description:{impact:\"critical\",messages:{pass:function(a){return\"The multimedia element has an audio description track\"},fail:function(a){return\"The multimedia element does not have an audio description track\"},incomplete:function(a){return\"An audio description track for this element could not be found\"}}}},failureSummaries:{any:{failureMessage:function(a){var b=\"Fix any of the following:\",c=a;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\"\\n  \"+d.split(\"\\n\").join(\"\\n  \");return b}},none:{failureMessage:function(a){var b=\"Fix all of the following:\",c=a;if(c)for(var d,e=-1,f=c.length-1;e<f;)d=c[e+=1],b+=\"\\n  \"+d.split(\"\\n\").join(\"\\n  \");return b}}},incompleteFallbackMessage:function(a){return\"aXe couldn't tell the reason. Time to break out the element inspector!\"}},rules:[{id:\"accesskeys\",selector:\"[accesskey]\",excludeHidden:!1,tags:[\"wcag2a\",\"wcag211\",\"cat.keyboard\"],all:[],any:[],none:[\"accesskeys\"]},{id:\"area-alt\",selector:\"map area[href]\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-alt\",\"non-empty-title\",\"aria-label\",\"aria-labelledby\"],none:[]},{id:\"aria-allowed-attr\",matches:function(a,b){var c=a.getAttribute(\"role\");c||(c=axe.commons.aria.implicitRole(a));var d=axe.commons.aria.allowedAttr(c);if(c&&d){var e=/^aria-/;if(a.hasAttributes())for(var f=a.attributes,g=0,h=f.length;g<h;g++)if(e.test(f[g].name))return!0}return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag411\",\"wcag412\"],all:[],any:[\"aria-allowed-attr\"],none:[]},{id:\"aria-hidden-body\",selector:\"body\",excludeHidden:!1,tags:[\"cat.aria\",\"wcag2a\",\"wcag412\"],all:[],any:[\"aria-hidden-body\"],none:[]},{id:\"aria-required-attr\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag411\",\"wcag412\"],all:[],any:[\"aria-required-attr\"],none:[]},{id:\"aria-required-children\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\"],all:[],any:[\"aria-required-children\"],none:[]},{id:\"aria-required-parent\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\"],all:[],any:[\"aria-required-parent\"],none:[]},{id:\"aria-roles\",selector:\"[role]\",tags:[\"cat.aria\",\"wcag2a\",\"wcag131\",\"wcag411\",\"wcag412\"],all:[],any:[],none:[\"invalidrole\",\"abstractrole\"]},{id:\"aria-valid-attr-value\",matches:function(a,b){var c=/^aria-/;if(a.hasAttributes())for(var d=a.attributes,e=0,f=d.length;e<f;e++)if(c.test(d[e].name))return!0;return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag131\",\"wcag411\",\"wcag412\"],all:[{options:[],id:\"aria-valid-attr-value\"},\"aria-errormessage\"],any:[],none:[]},{id:\"aria-valid-attr\",matches:function(a,b){var c=/^aria-/;if(a.hasAttributes())for(var d=a.attributes,e=0,f=d.length;e<f;e++)if(c.test(d[e].name))return!0;return!1},tags:[\"cat.aria\",\"wcag2a\",\"wcag411\"],all:[],any:[{options:[],id:\"aria-valid-attr\"}],none:[]},{id:\"audio-caption\",selector:\"audio\",excludeHidden:!1,tags:[\"cat.time-and-media\",\"wcag2a\",\"wcag121\",\"section508\",\"section508.22.a\"],all:[],any:[],none:[\"caption\"]},{id:\"blink\",selector:\"blink\",excludeHidden:!1,tags:[\"cat.time-and-media\",\"wcag2a\",\"wcag222\",\"section508\",\"section508.22.j\"],all:[],any:[],none:[\"is-on-screen\"]},{id:\"button-name\",selector:'button, [role=\"button\"], input[type=\"button\"], input[type=\"submit\"], input[type=\"reset\"]',tags:[\"cat.name-role-value\",\"wcag2a\",\"wcag412\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-if-present\",\"non-empty-value\",\"button-has-visible-text\",\"aria-label\",\"aria-labelledby\",\"role-presentation\",\"role-none\"],none:[\"focusable-no-name\"]},{id:\"bypass\",selector:\"html\",pageLevel:!0,matches:function(a,b){return!!a.querySelector(\"a[href]\")},tags:[\"cat.keyboard\",\"wcag2a\",\"wcag241\",\"section508\",\"section508.22.o\"],all:[],any:[\"internal-link-present\",\"header-present\",\"landmark\"],none:[]},{id:\"checkboxgroup\",selector:\"input[type=checkbox][name]\",tags:[\"cat.forms\",\"best-practice\"],all:[],any:[\"group-labelledby\",\"fieldset\"],none:[]},{id:\"color-contrast\",matches:function(a,b){var c=a.nodeName.toUpperCase(),d=a.type;if(\"true\"===a.getAttribute(\"aria-disabled\")||axe.commons.dom.findUpVirtual(b,'[aria-disabled=\"true\"]'))return!1;if(\"INPUT\"===c)return-1===[\"hidden\",\"range\",\"color\",\"checkbox\",\"radio\",\"image\"].indexOf(d)&&!a.disabled;if(\"SELECT\"===c)return!!a.options.length&&!a.disabled;if(\"TEXTAREA\"===c)return!a.disabled;if(\"OPTION\"===c)return!1;if(\"BUTTON\"===c&&a.disabled||axe.commons.dom.findUpVirtual(b,\"button[disabled]\"))return!1;if(\"FIELDSET\"===c&&a.disabled||axe.commons.dom.findUpVirtual(b,\"fieldset[disabled]\"))return!1;var e=axe.commons.dom.findUpVirtual(b,\"label\");if(\"LABEL\"===c||e){var f=a,g=b;e&&(f=e,g=axe.utils.getNodeFromTree(axe._tree[0],e));var h=axe.commons.dom.getRootNode(f),i=f.htmlFor&&h.getElementById(f.htmlFor);if(i&&i.disabled)return!1;var i=axe.utils.querySelectorAll(g,'input:not([type=\"hidden\"]):not([type=\"image\"]):not([type=\"button\"]):not([type=\"submit\"]):not([type=\"reset\"]), select, textarea');if(i.length&&i[0].actualNode.disabled)return!1}if(a.getAttribute(\"id\")){var j=axe.commons.utils.escapeSelector(a.getAttribute(\"id\")),k=axe.commons.dom.getRootNode(a),i=k.querySelector(\"[aria-labelledby~=\"+j+\"]\");if(i&&i.disabled)return!1}if(\"\"===axe.commons.text.visibleVirtual(b,!1,!0))return!1;var l,m,n=document.createRange(),o=b.children,p=o.length;for(m=0;m<p;m++)l=o[m],3===l.actualNode.nodeType&&\"\"!==axe.commons.text.sanitize(l.actualNode.nodeValue)&&n.selectNodeContents(l.actualNode);var q=n.getClientRects();for(p=q.length,m=0;m<p;m++)if(axe.commons.dom.visuallyOverlaps(q[m],a))return!0;return!1},excludeHidden:!1,options:{noScroll:!1},tags:[\"cat.color\",\"wcag2aa\",\"wcag143\"],all:[],any:[\"color-contrast\"],none:[]},{id:\"definition-list\",selector:\"dl\",matches:function(a,b){return!a.getAttribute(\"role\")},tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"structured-dlitems\",\"only-dlitems\"]},{id:\"dlitem\",selector:\"dd, dt\",matches:function(a,b){return!a.getAttribute(\"role\")},tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[\"dlitem\"],none:[]},{id:\"document-title\",selector:\"html\",matches:function(a,b){return a.ownerDocument.defaultView.self===a.ownerDocument.defaultView.top},tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag242\"],all:[],any:[\"doc-has-title\"],none:[]},{id:\"duplicate-id\",selector:\"[id]\",excludeHidden:!1,tags:[\"cat.parsing\",\"wcag2a\",\"wcag411\"],all:[],any:[\"duplicate-id\"],none:[]},{id:\"empty-heading\",selector:'h1, h2, h3, h4, h5, h6, [role=\"heading\"]',matches:function(a,b){var c=void 0;return a.hasAttribute(\"role\")&&(c=a.getAttribute(\"role\").split(/\\s+/i).filter(axe.commons.aria.isValidRole)),c&&c.length>0?c.includes(\"heading\"):\"heading\"===axe.commons.aria.implicitRole(a)},tags:[\"cat.name-role-value\",\"best-practice\"],all:[],any:[\"has-visible-text\"],none:[]},{id:\"focus-order-semantics\",selector:\"div, h1, h2, h3, h4, h5, h6, [role=heading], p, span\",matches:function(a,b){return axe.commons.dom.insertedIntoFocusOrder(a)},tags:[\"cat.keyboard\",\"best-practice\",\"experimental\"],all:[],any:[{options:[],id:\"has-widget-role\"},{options:[],id:\"valid-scrollable-semantics\"}],none:[]},{id:\"frame-title-unique\",selector:\"frame[title], iframe[title]\",matches:function(a,b){var c=a.getAttribute(\"title\");return!!(c?axe.commons.text.sanitize(c).trim():\"\")},tags:[\"cat.text-alternatives\",\"best-practice\"],all:[],any:[],none:[\"unique-frame-title\"]},{id:\"frame-title\",selector:\"frame, iframe\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag241\",\"section508\",\"section508.22.i\"],all:[],any:[\"aria-label\",\"aria-labelledby\",\"non-empty-title\",\"role-presentation\",\"role-none\"],none:[]},{id:\"heading-order\",selector:\"h1, h2, h3, h4, h5, h6, [role=heading]\",matches:function(a,b){var c=void 0;return a.hasAttribute(\"role\")&&(c=a.getAttribute(\"role\").split(/\\s+/i).filter(axe.commons.aria.isValidRole)),c&&c.length>0?c.includes(\"heading\"):\"heading\"===axe.commons.aria.implicitRole(a)},tags:[\"cat.semantics\",\"best-practice\"],all:[],any:[\"heading-order\"],none:[]},{id:\"hidden-content\",selector:\"*\",excludeHidden:!1,tags:[\"experimental\",\"review-item\"],all:[],any:[\"hidden-content\"],none:[]},{id:\"html-has-lang\",selector:\"html\",tags:[\"cat.language\",\"wcag2a\",\"wcag311\"],all:[],any:[\"has-lang\"],none:[]},{id:\"html-lang-valid\",selector:\"html[lang]\",tags:[\"cat.language\",\"wcag2a\",\"wcag311\"],all:[],any:[],none:[\"valid-lang\"]},{id:\"image-alt\",selector:\"img, [role='img']:not(svg)\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-alt\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\",\"role-presentation\",\"role-none\"],none:[]},{id:\"image-redundant-alt\",selector:'button, [role=\"button\"], a[href], p, li, td, th',tags:[\"cat.text-alternatives\",\"best-practice\"],all:[],any:[],none:[\"duplicate-img-label\"]},{id:\"input-image-alt\",selector:'input[type=\"image\"]',tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"non-empty-alt\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\"],none:[]},{id:\"label-title-only\",selector:\"input, select, textarea\",matches:function(a,b){return\"input\"!==a.nodeName.toLowerCase()||!1===a.hasAttribute(\"type\")||!1===[\"hidden\",\"image\",\"button\",\"submit\",\"reset\"].includes(a.getAttribute(\"type\").toLowerCase())},tags:[\"cat.forms\",\"best-practice\"],all:[],any:[],none:[\"title-only\"]},{id:\"label\",selector:\"input, select, textarea\",matches:function(a,b){return\"input\"!==a.nodeName.toLowerCase()||!1===a.hasAttribute(\"type\")||!1===[\"hidden\",\"image\",\"button\",\"submit\",\"reset\"].includes(a.getAttribute(\"type\").toLowerCase())},tags:[\"cat.forms\",\"wcag2a\",\"wcag332\",\"wcag131\",\"section508\",\"section508.22.n\"],all:[],any:[\"aria-label\",\"aria-labelledby\",\"implicit-label\",\"explicit-label\",\"non-empty-title\"],none:[\"help-same-as-label\",\"multiple-label\"]},{id:\"landmark-main-is-top-level\",selector:\"main, [role=main]\",tags:[\"best-practice\"],all:[],any:[\"main-is-top-level\"],none:[]},{id:\"landmark-one-main\",selector:\"html\",tags:[\"best-practice\"],all:[\"has-at-least-one-main\",\"has-no-more-than-one-main\"],any:[],none:[]},{id:\"layout-table\",selector:\"table\",matches:function(a,b){return!axe.commons.table.isDataTable(a)},tags:[\"cat.semantics\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"has-th\",\"has-caption\",\"has-summary\"]},{id:\"link-in-text-block\",selector:\"a[href], [role=link]\",matches:function(a,b){var c=axe.commons.text.sanitize(a.textContent),d=a.getAttribute(\"role\");return(!d||\"link\"===d)&&(!!c&&(!!axe.commons.dom.isVisible(a,!1)&&axe.commons.dom.isInTextBlock(a)))},excludeHidden:!1,tags:[\"cat.color\",\"experimental\",\"wcag2a\",\"wcag141\"],all:[\"link-in-text-block\"],any:[],none:[]},{id:\"link-name\",selector:\"a[href], [role=link][href]\",matches:function(a,b){return\"button\"!==a.getAttribute(\"role\")},tags:[\"cat.name-role-value\",\"wcag2a\",\"wcag111\",\"wcag412\",\"wcag244\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-visible-text\",\"aria-label\",\"aria-labelledby\",\"role-presentation\",\"role-none\"],none:[\"focusable-no-name\"]},{id:\"list\",selector:\"ul, ol\",matches:function(a,b){return!a.getAttribute(\"role\")},tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[],none:[\"only-listitems\"]},{id:\"listitem\",selector:\"li\",matches:function(a,b){return!a.getAttribute(\"role\")},tags:[\"cat.structure\",\"wcag2a\",\"wcag131\"],all:[],any:[\"listitem\"],none:[]},{id:\"marquee\",selector:\"marquee\",excludeHidden:!1,tags:[\"cat.parsing\",\"wcag2a\",\"wcag222\"],all:[],any:[],none:[\"is-on-screen\"]},{id:\"meta-refresh\",selector:'meta[http-equiv=\"refresh\"]',excludeHidden:!1,tags:[\"cat.time\",\"wcag2a\",\"wcag2aaa\",\"wcag221\",\"wcag224\",\"wcag325\"],all:[],any:[\"meta-refresh\"],none:[]},{id:\"meta-viewport-large\",selector:'meta[name=\"viewport\"]',excludeHidden:!1,tags:[\"cat.sensory-and-visual-cues\",\"best-practice\"],all:[],any:[{options:{scaleMinimum:5,lowerBound:2},id:\"meta-viewport-large\"}],none:[]},{id:\"meta-viewport\",selector:'meta[name=\"viewport\"]',excludeHidden:!1,tags:[\"cat.sensory-and-visual-cues\",\"wcag2aa\",\"wcag144\"],all:[],any:[{options:{scaleMinimum:2},id:\"meta-viewport\"}],none:[]},{id:\"object-alt\",selector:\"object\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag111\",\"section508\",\"section508.22.a\"],all:[],any:[\"has-visible-text\",\"aria-label\",\"aria-labelledby\",\"non-empty-title\"],none:[]},{id:\"p-as-heading\",selector:\"p\",matches:function(a,b){var c=Array.from(a.parentNode.childNodes),d=a.textContent.trim(),e=/[.!?:;](?![.!?:;])/g;return!(0===d.length||(d.match(e)||[]).length>=2)&&0!==c.slice(c.indexOf(a)+1).filter(function(a){return\"P\"===a.nodeName.toUpperCase()&&\"\"!==a.textContent.trim()}).length},tags:[\"cat.semantics\",\"wcag2a\",\"wcag131\",\"experimental\"],all:[{options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]},id:\"p-as-heading\"}],any:[],none:[]},{id:\"radiogroup\",selector:\"input[type=radio][name]\",tags:[\"cat.forms\",\"best-practice\"],all:[],any:[\"group-labelledby\",\"fieldset\"],none:[]},{id:\"region\",selector:\"html\",pageLevel:!0,tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"region\"],none:[]},{id:\"scope-attr-valid\",selector:\"td[scope], th[scope]\",tags:[\"cat.tables\",\"best-practice\"],all:[\"html5-scope\",\"scope-value\"],any:[],none:[]},{id:\"server-side-image-map\",selector:\"img[ismap]\",tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag211\",\"section508\",\"section508.22.f\"],all:[],any:[],none:[\"exists\"]},{id:\"skip-link\",selector:\"a[href]\",matches:function(a,b){var c=a.getAttribute(\"href\");return\"#\"===c[0]&&c.length>1},tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"skip-link\"],none:[]},{id:\"tabindex\",selector:\"[tabindex]\",tags:[\"cat.keyboard\",\"best-practice\"],all:[],any:[\"tabindex\"],none:[]},{id:\"table-duplicate-name\",selector:\"table\",tags:[\"cat.tables\",\"best-practice\"],all:[],any:[],none:[\"same-caption-summary\"]},{id:\"table-fake-caption\",selector:\"table\",matches:function(a,b){return axe.commons.table.isDataTable(a)},tags:[\"cat.tables\",\"experimental\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"caption-faked\"],any:[],none:[]},{id:\"td-has-header\",selector:\"table\",matches:function(a,b){if(axe.commons.table.isDataTable(a)){var c=axe.commons.table.toArray(a);return c.length>=3&&c[0].length>=3&&c[1].length>=3&&c[2].length>=3}return!1},tags:[\"cat.tables\",\"experimental\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"td-has-header\"],any:[],none:[]},{id:\"td-headers-attr\",selector:\"table\",tags:[\"cat.tables\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"td-headers-attr\"],any:[],none:[]},{id:\"th-has-data-cells\",selector:\"table\",matches:function(a,b){return axe.commons.table.isDataTable(a)},tags:[\"cat.tables\",\"wcag2a\",\"wcag131\",\"section508\",\"section508.22.g\"],all:[\"th-has-data-cells\"],any:[],none:[]},{id:\"valid-lang\",selector:\"[lang], [xml\\\\:lang]\",matches:function(a,b){return\"html\"!==a.nodeName.toLowerCase()},tags:[\"cat.language\",\"wcag2aa\",\"wcag312\"],all:[],any:[],none:[\"valid-lang\"]},{id:\"video-caption\",selector:\"video\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2a\",\"wcag122\",\"wcag123\",\"section508\",\"section508.22.a\"],all:[],any:[],none:[\"caption\"]},{id:\"video-description\",selector:\"video\",excludeHidden:!1,tags:[\"cat.text-alternatives\",\"wcag2aa\",\"wcag125\",\"section508\",\"section508.22.b\"],all:[],any:[],none:[\"description\"]}],checks:[{id:\"abstractrole\",evaluate:function(a,b,c){return\"abstract\"===axe.commons.aria.getRoleType(a.getAttribute(\"role\"))}},{id:\"aria-allowed-attr\",evaluate:function(a,b,c){b=b||{};var d,e,f,g=[],h=a.getAttribute(\"role\"),i=a.attributes;if(h||(h=axe.commons.aria.implicitRole(a)),f=axe.commons.aria.allowedAttr(h),Array.isArray(b[h])&&(f=axe.utils.uniqueArray(b[h].concat(f))),h&&f)for(var j=0,k=i.length;j<k;j++)d=i[j],e=d.name,axe.commons.aria.validateAttr(e)&&!f.includes(e)&&g.push(e+'=\"'+d.nodeValue+'\"');return!g.length||(this.data(g),!1)}},{id:\"aria-hidden-body\",evaluate:function(a,b,c){return\"true\"!==a.getAttribute(\"aria-hidden\")}},{id:\"aria-errormessage\",evaluate:function(a,b,c){b=Array.isArray(b)?b:[];var d=a.getAttribute(\"aria-errormessage\"),e=a.hasAttribute(\"aria-errormessage\"),f=axe.commons.dom.getRootNode(a);return!(-1===b.indexOf(d)&&e&&!function(){var b=d&&f.getElementById(d);if(b)return\"alert\"===b.getAttribute(\"role\")||\"assertive\"===b.getAttribute(\"aria-live\")||axe.utils.tokenList(a.getAttribute(\"aria-describedby\")||\"\").indexOf(d)>-1}())||(this.data(d),!1)}},{id:\"has-widget-role\",evaluate:function(a,b,c){var d=a.getAttribute(\"role\");if(null===d)return!1;var e=axe.commons.aria.getRoleType(d);return\"widget\"===e||\"composite\"===e},options:[]},{id:\"invalidrole\",evaluate:function(a,b,c){return!axe.commons.aria.isValidRole(a.getAttribute(\"role\"))}},{id:\"aria-required-attr\",evaluate:function(a,b,c){b=b||{};var d=[];if(a.hasAttributes()){var e,f=a.getAttribute(\"role\"),g=axe.commons.aria.requiredAttr(f);if(Array.isArray(b[f])&&(g=axe.utils.uniqueArray(b[f],g)),f&&g)for(var h=0,i=g.length;h<i;h++)e=g[h],a.getAttribute(e)||d.push(e)}return!d.length||(this.data(d),!1)}},{id:\"aria-required-children\",evaluate:function(a,b,c){function d(a,b,c,d){if(null===a)return!1;var e=g(c),f=['[role=\"'+c+'\"]'];return e&&(f=f.concat(e)),f=f.join(\",\"),d?h(a,f)||!!axe.utils.querySelectorAll(b,f)[0]:!!axe.utils.querySelectorAll(b,f)[0]}function e(a,b){var c,e;for(c=0,e=a.length;c<e;c++)if(null!==a[c]){var f=axe.utils.getNodeFromTree(axe._tree[0],a[c]);if(d(a[c],f,b,!0))return!0}return!1}var f=axe.commons.aria.requiredOwned,g=axe.commons.aria.implicitNodes,h=axe.commons.utils.matchesSelector,i=axe.commons.dom.idrefs,j=a.getAttribute(\"role\"),k=f(j);if(!k)return!0;var l=!1,m=k.one;if(!m){var l=!0;m=k.all}var n=function(a,b,f,g){var h,j=b.length,k=[],l=i(a,\"aria-owns\");for(h=0;h<j;h++){var m=b[h];if(d(a,c,m)||e(l,m)){if(!f)return null}else f&&k.push(m)}if(\"combobox\"===g){var n=k.indexOf(\"textbox\"),o=[\"text\",\"search\",\"email\",\"url\",\"tel\"];n>=0&&\"INPUT\"===a.tagName&&o.includes(a.type)&&k.splice(n,1);var p=k.indexOf(\"listbox\"),q=a.getAttribute(\"aria-expanded\");p>=0&&(!q||\"false\"===q)&&k.splice(p,1)}return k.length?k:!f&&b.length?b:null}(a,m,l,j);return!n||(this.data(n),!1)}},{id:\"aria-required-parent\",evaluate:function(a,b,c){function d(a){return(axe.commons.aria.implicitNodes(a)||[]).concat('[role=\"'+a+'\"]').join(\",\")}function e(a,b,c){var e,f,g=a.actualNode.getAttribute(\"role\"),h=[];if(b||(b=axe.commons.aria.requiredContext(g)),!b)return null;for(e=0,f=b.length;e<f;e++){if(c&&axe.utils.matchesSelector(a.actualNode,d(b[e])))return null;if(axe.commons.dom.findUpVirtual(a,d(b[e])))return null;h.push(b[e])}return h}var f=e(c);if(!f)return!0;var g=function(a){for(var b=[],c=null;a;){if(a.getAttribute(\"id\")){var d=axe.commons.utils.escapeSelector(a.getAttribute(\"id\"));c=axe.commons.dom.getRootNode(a).querySelector(\"[aria-owns~=\"+d+\"]\"),c&&b.push(c)}a=a.parentElement}return b.length?b:null}(a);if(g)for(var h=0,i=g.length;h<i;h++)if(!(f=e(axe.utils.getNodeFromTree(axe._tree[0],g[h]),f,!0)))return!0;return this.data(f),!1}},{id:\"aria-valid-attr-value\",evaluate:function(a,b,c){b=Array.isArray(b)?b:[];for(var d,e,f=[],g=/^aria-/,h=a.attributes,i=[\"aria-errormessage\"],j=0,k=h.length;j<k;j++)d=h[j],e=d.name,i.includes(e)||-1===b.indexOf(e)&&g.test(e)&&!axe.commons.aria.validateAttrValue(a,e)&&f.push(e+'=\"'+d.nodeValue+'\"');return!f.length||(this.data(f),!1)},options:[]},{id:\"aria-valid-attr\",evaluate:function(a,b,c){b=Array.isArray(b)?b:[];for(var d,e=[],f=/^aria-/,g=a.attributes,h=0,i=g.length;h<i;h++)d=g[h].name,-1===b.indexOf(d)&&f.test(d)&&!axe.commons.aria.validateAttr(d)&&e.push(d);return!e.length||(this.data(e),!1)},options:[]},{id:\"valid-scrollable-semantics\",evaluate:function(a,b,c){function d(a){var b=a.tagName.toUpperCase();return f[b]||!1}function e(a){var b=a.getAttribute(\"role\");return!!b&&(g[b.toLowerCase()]||!1)}var f={ARTICLE:!0,ASIDE:!0,NAV:!0,SECTION:!0},g={banner:!1,complementary:!0,contentinfo:!0,form:!0,main:!0,navigation:!0,region:!0,search:!1};return function(a){return e(a)||d(a)}(a)},options:[]},{id:\"color-contrast\",evaluate:function(a,b,c){if(!axe.commons.dom.isVisible(a,!1))return!0;var d,e=!!(b||{}).noScroll,f=[],g=axe.commons.color.getBackgroundColor(a,f,e),h=axe.commons.color.getForegroundColor(a,e),i=window.getComputedStyle(a),j=parseFloat(i.getPropertyValue(\"font-size\")),k=i.getPropertyValue(\"font-weight\"),l=-1!==[\"bold\",\"bolder\",\"600\",\"700\",\"800\",\"900\"].indexOf(k),m=axe.commons.color.hasValidContrastRatio(g,h,j,l),n=Math.floor(100*m.contrastRatio)/100;null===g&&(d=axe.commons.color.incompleteData.get(\"bgColor\"));var o=!1;1===n&&(o=!0,d=axe.commons.color.incompleteData.set(\"bgColor\",\"equalRatio\"));var p={fgColor:h?h.toHexString():void 0,bgColor:g?g.toHexString():void 0,contrastRatio:m?n:void 0,fontSize:(72*j/96).toFixed(1)+\"pt\",fontWeight:l?\"bold\":\"normal\",missingData:d,expectedContrastRatio:m.expectedContrastRatio+\":1\"};return this.data(p),null===h||null===g||o?(d=null,axe.commons.color.incompleteData.clear(),void this.relatedNodes(f)):(m.isValid||this.relatedNodes(f),m.isValid)}},{id:\"link-in-text-block\",evaluate:function(a,b,c){function d(a,b){var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(c,d)+.05)/(Math.min(c,d)+.05)}function e(a){var b=window.getComputedStyle(a).getPropertyValue(\"display\");return-1!==i.indexOf(b)||\"table-\"===b.substr(0,6)}var f=axe.commons,g=f.color,h=f.dom,i=[\"block\",\"list-item\",\"table\",\"flex\",\"grid\",\"inline-block\"];if(e(a))return!1;for(var j=h.getComposedParent(a);1===j.nodeType&&!e(j);)j=h.getComposedParent(j);if(this.relatedNodes([j]),g.elementIsDistinct(a,j))return!0;var k,l;if(k=g.getForegroundColor(a),l=g.getForegroundColor(j),k&&l){var m=d(k,l);if(1===m)return!0;if(m>=3)return axe.commons.color.incompleteData.set(\"fgColor\",\"bgContrast\"),this.data({missingData:axe.commons.color.incompleteData.get(\"fgColor\")}),void axe.commons.color.incompleteData.clear();if(k=g.getBackgroundColor(a),l=g.getBackgroundColor(j),!k||!l||d(k,l)>=3){var n=void 0;return n=k&&l?\"bgContrast\":axe.commons.color.incompleteData.get(\"bgColor\"),axe.commons.color.incompleteData.set(\"fgColor\",n),this.data({missingData:axe.commons.color.incompleteData.get(\"fgColor\")}),void axe.commons.color.incompleteData.clear()}return!1}}},{id:\"fieldset\",evaluate:function(a,b,c){function d(a,b){return axe.commons.utils.toArray(a.querySelectorAll('select,textarea,button,input:not([name=\"'+b+'\"]):not([type=\"hidden\"])'))}function e(a,b){var c=a.firstElementChild;if(!c||\"LEGEND\"!==c.nodeName.toUpperCase())return i.relatedNodes([a]),h=\"no-legend\",!1;if(!axe.commons.text.accessibleText(c))return i.relatedNodes([c]),h=\"empty-legend\",!1;var e=d(a,b);return!e.length||(i.relatedNodes(e),h=\"mixed-inputs\",!1)}function f(a,b){var c=axe.commons.dom.idrefs(a,\"aria-labelledby\").some(function(a){return a&&axe.commons.text.accessibleText(a)}),e=a.getAttribute(\"aria-label\");if(!(c||e&&axe.commons.text.sanitize(e)))return i.relatedNodes(a),h=\"no-group-label\",!1;var f=d(a,b);return!f.length||(i.relatedNodes(f),h=\"group-mixed-inputs\",!1)}function g(a,b){return axe.commons.utils.toArray(a).filter(function(a){return a!==b})}var h,i=this,j={name:a.getAttribute(\"name\"),type:a.getAttribute(\"type\")},k=function(a){var b=axe.commons.utils.escapeSelector(a.actualNode.name),c=axe.commons.dom.getRootNode(a.actualNode),d=c.querySelectorAll('input[type=\"'+axe.commons.utils.escapeSelector(a.actualNode.type)+'\"][name=\"'+b+'\"]');if(d.length<2)return!0;var j=axe.commons.dom.findUpVirtual(a,\"fieldset\"),k=axe.commons.dom.findUpVirtual(a,'[role=\"group\"]'+(\"radio\"===a.actualNode.type?',[role=\"radiogroup\"]':\"\"));return k||j?j?e(j,b):f(k,b):(h=\"no-group\",i.relatedNodes(g(d,a.actualNode)),!1)}(c);return k||(j.failureCode=h),this.data(j),k},after:function(a,b){var c={};return a.filter(function(a){if(a.result)return!0;var b=a.data;if(b){if(c[b.type]=c[b.type]||{},!c[b.type][b.name])return c[b.type][b.name]=[b],!0;var d=c[b.type][b.name].some(function(a){return a.failureCode===b.failureCode});return d||c[b.type][b.name].push(b),!d}return!1})}},{id:\"group-labelledby\",evaluate:function(a,b,c){this.data({name:a.getAttribute(\"name\"),type:a.getAttribute(\"type\")});var d=axe.commons.dom.getRootNode(a),e=d.querySelectorAll('input[type=\"'+axe.commons.utils.escapeSelector(a.type)+'\"][name=\"'+axe.commons.utils.escapeSelector(a.name)+'\"]');return e.length<=1||0!==[].map.call(e,function(a){var b=a.getAttribute(\"aria-labelledby\");return b?b.split(/\\s+/):[]}).reduce(function(a,b){return a.filter(function(a){return b.includes(a)})}).filter(function(a){var b=d.getElementById(a);return b&&axe.commons.text.accessibleText(b,!0)}).length},after:function(a,b){var c={};return a.filter(function(a){var b=a.data;return!(!b||(c[b.type]=c[b.type]||{},c[b.type][b.name]))&&(c[b.type][b.name]=!0,!0)})}},{id:\"accesskeys\",evaluate:function(a,b,c){return axe.commons.dom.isVisible(a,!1)&&(this.data(a.getAttribute(\"accesskey\")),this.relatedNodes([a])),!0},after:function(a,b){var c={};return a.filter(function(a){if(!a.data)return!1;var b=a.data.toUpperCase();return c[b]?(c[b].relatedNodes.push(a.relatedNodes[0]),!1):(c[b]=a,a.relatedNodes=[],!0)}).map(function(a){return a.result=!!a.relatedNodes.length,a})}},{id:\"focusable-no-name\",evaluate:function(a,b,c){var d=a.getAttribute(\"tabindex\");return!!(axe.commons.dom.isFocusable(a)&&d>-1)&&!axe.commons.text.accessibleTextVirtual(c)}},{id:\"has-at-least-one-main\",evaluate:function(a,b,c){var d=axe.utils.querySelectorAll(c,\"main,[role=main]\");return this.data(!!d[0]),!!d[0]},after:function(a,b){for(var c=!1,d=0;d<a.length&&!c;d++)c=a[d].data;for(var d=0;d<a.length;d++)a[d].result=c;return a}},{id:\"has-no-more-than-one-main\",evaluate:function(a,b,c){return axe.utils.querySelectorAll(c,\"main,[role=main]\").length<=1}},{id:\"main-is-top-level\",evaluate:function(a,b,c){for(var d=axe.commons.aria.getRolesByType(\"landmark\"),e=axe.commons.dom.getComposedParent(a);e;){var f=e.getAttribute(\"role\");if(f||\"form\"===e.tagName.toLowerCase()||(f=axe.commons.aria.implicitRole(e)),f&&d.includes(f))return!1;e=axe.commons.dom.getComposedParent(e)}return!0}},{id:\"tabindex\",evaluate:function(a,b,c){return a.tabIndex<=0}},{id:\"duplicate-img-label\",evaluate:function(a,b,c){var d=axe.commons.text.visibleVirtual(c,!0).toLowerCase();return\"\"!==d&&axe.utils.querySelectorAll(c,\"img\").filter(function(a){var b=a.actualNode;return axe.commons.dom.isVisible(b)&&![\"none\",\"presentation\"].includes(b.getAttribute(\"role\"))}).some(function(a){return d===axe.commons.text.accessibleTextVirtual(a).toLowerCase()})}},{id:\"explicit-label\",evaluate:function(a,b,c){if(a.getAttribute(\"id\")){var d=axe.commons.dom.getRootNode(a),e=axe.commons.utils.escapeSelector(a.getAttribute(\"id\")),f=d.querySelector('label[for=\"'+e+'\"]');if(f)return!!axe.commons.text.accessibleText(f)}return!1}},{id:\"help-same-as-label\",evaluate:function(a,b,c){var d=axe.commons.text.labelVirtual(c),e=a.getAttribute(\"title\");if(!d)return!1;if(!e&&(e=\"\",a.getAttribute(\"aria-describedby\"))){e=axe.commons.dom.idrefs(a,\"aria-describedby\").map(function(a){return a?axe.commons.text.accessibleText(a):\"\"}).join(\"\")}return axe.commons.text.sanitize(e)===axe.commons.text.sanitize(d)},enabled:!1},{id:\"implicit-label\",evaluate:function(a,b,c){var d=axe.commons.dom.findUpVirtual(c,\"label\");return!!d&&!!axe.commons.text.accessibleTextVirtual(d)}},{id:\"multiple-label\",evaluate:function(a,b,c){var d=axe.commons.utils.escapeSelector(a.getAttribute(\"id\")),e=Array.from(document.querySelectorAll('label[for=\"'+d+'\"]')),f=a.parentNode;for(e.length&&(e=e.filter(function(a,b){if(0===b&&!axe.commons.dom.isVisible(a,!0)||axe.commons.dom.isVisible(a,!0))return a}));f;)\"LABEL\"===f.tagName&&-1===e.indexOf(f)&&e.push(f),f=f.parentNode;return this.relatedNodes(e),e.length>1}},{id:\"title-only\",evaluate:function(a,b,c){return!(axe.commons.text.labelVirtual(c)||!a.getAttribute(\"title\")&&!a.getAttribute(\"aria-describedby\"))}},{id:\"has-lang\",evaluate:function(a,b,c){return!!(a.getAttribute(\"lang\")||a.getAttribute(\"xml:lang\")||\"\").trim()}},{id:\"valid-lang\",evaluate:function(a,b,c){function d(a){return a.trim().split(\"-\")[0].toLowerCase()}var e,f;return e=(b||axe.commons.utils.validLangs()).map(d),f=[\"lang\",\"xml:lang\"].reduce(function(b,c){var f=a.getAttribute(c);if(\"string\"!=typeof f)return b;var g=d(f);return\"\"!==g&&-1===e.indexOf(g)&&b.push(c+'=\"'+a.getAttribute(c)+'\"'),b},[]),!!f.length&&(this.data(f),!0)}},{id:\"dlitem\",evaluate:function(a,b,c){return\"DL\"===axe.commons.dom.getComposedParent(a).nodeName.toUpperCase()}},{id:\"has-listitem\",evaluate:function(a,b,c){return c.children.every(function(a){return\"LI\"!==a.actualNode.nodeName.toUpperCase()})}},{id:\"listitem\",evaluate:function(a,b,c){var d=axe.commons.dom.getComposedParent(a);return[\"UL\",\"OL\"].includes(d.nodeName.toUpperCase())||\"list\"===(d.getAttribute(\"role\")||\"\").toLowerCase()}},{id:\"only-dlitems\",evaluate:function(a,b,c){var d=[],e=[\"STYLE\",\"META\",\"LINK\",\"MAP\",\"AREA\",\"SCRIPT\",\"DATALIST\",\"TEMPLATE\"],f=!1;return c.children.forEach(function(a){var b=a.actualNode,c=b.nodeName.toUpperCase();1===b.nodeType&&\"DT\"!==c&&\"DD\"!==c&&-1===e.indexOf(c)?d.push(b):3===b.nodeType&&\"\"!==b.nodeValue.trim()&&(f=!0)}),d.length&&this.relatedNodes(d),!!d.length||f}},{id:\"only-listitems\",evaluate:function(a,b,c){var d=[],e=[\"STYLE\",\"META\",\"LINK\",\"MAP\",\"AREA\",\"SCRIPT\",\"DATALIST\",\"TEMPLATE\"],f=!1;return c.children.forEach(function(a){var b=a.actualNode,c=b.nodeName.toUpperCase();1===b.nodeType&&\"LI\"!==c&&-1===e.indexOf(c)?d.push(b):3===b.nodeType&&\"\"!==b.nodeValue.trim()&&(f=!0)}),d.length&&this.relatedNodes(d),!!d.length||f}},{id:\"structured-dlitems\",\nevaluate:function(a,b,c){var d=c.children;if(!d||!d.length)return!1;for(var e,f=!1,g=!1,h=0;h<d.length;h++){if(e=d[h].actualNode.nodeName.toUpperCase(),\"DT\"===e&&(f=!0),f&&\"DD\"===e)return!1;\"DD\"===e&&(g=!0)}return f||g}},{id:\"caption\",evaluate:function(a,b,c){var d=axe.utils.querySelectorAll(c,\"track\");if(d.length)return!d.some(function(a){return\"captions\"===(a.actualNode.getAttribute(\"kind\")||\"\").toLowerCase()})}},{id:\"description\",evaluate:function(a,b,c){var d=axe.utils.querySelectorAll(c,\"track\");if(d.length){return!d.some(function(a){return\"descriptions\"===(a.actualNode.getAttribute(\"kind\")||\"\").toLowerCase()})}}},{id:\"meta-viewport-large\",evaluate:function(a,b,c){b=b||{};for(var d,e=a.getAttribute(\"content\")||\"\",f=e.split(/[;,]/),g={},h=b.scaleMinimum||2,i=b.lowerBound||!1,j=0,k=f.length;j<k;j++){d=f[j].split(\"=\");var l=d.shift().toLowerCase();l&&d.length&&(g[l.trim()]=d.shift().trim().toLowerCase())}return!!(i&&g[\"maximum-scale\"]&&parseFloat(g[\"maximum-scale\"])<i)||!(!i&&\"no\"===g[\"user-scalable\"])&&!(g[\"maximum-scale\"]&&parseFloat(g[\"maximum-scale\"])<h)},options:{scaleMinimum:5,lowerBound:2}},{id:\"meta-viewport\",evaluate:function(a,b,c){b=b||{};for(var d,e=a.getAttribute(\"content\")||\"\",f=e.split(/[;,]/),g={},h=b.scaleMinimum||2,i=b.lowerBound||!1,j=0,k=f.length;j<k;j++){d=f[j].split(\"=\");var l=d.shift().toLowerCase();l&&d.length&&(g[l.trim()]=d.shift().trim().toLowerCase())}return!!(i&&g[\"maximum-scale\"]&&parseFloat(g[\"maximum-scale\"])<i)||!(!i&&\"no\"===g[\"user-scalable\"])&&!(g[\"maximum-scale\"]&&parseFloat(g[\"maximum-scale\"])<h)},options:{scaleMinimum:2}},{id:\"header-present\",evaluate:function(a,b,c){return!!axe.utils.querySelectorAll(c,'h1, h2, h3, h4, h5, h6, [role=\"heading\"]')[0]}},{id:\"heading-order\",evaluate:function(a,b,c){var d=a.getAttribute(\"aria-level\");if(null!==d)return this.data(parseInt(d,10)),!0;var e=a.tagName.match(/H(\\d)/);return!e||(this.data(parseInt(e[1],10)),!0)},after:function(a,b){if(a.length<2)return a;for(var c=a[0].data,d=1;d<a.length;d++)a[d].result&&a[d].data>c+1&&(a[d].result=!1),c=a[d].data;return a}},{id:\"internal-link-present\",evaluate:function(a,b,c){return axe.utils.querySelectorAll(c,\"a[href]\").some(function(a){return\"#\"===a.actualNode.getAttribute(\"href\")[0]})}},{id:\"landmark\",evaluate:function(a,b,c){return axe.utils.querySelectorAll(c,'main, [role=\"main\"]').length>0}},{id:\"meta-refresh\",evaluate:function(a,b,c){var d=a.getAttribute(\"content\")||\"\",e=d.split(/[;,]/);return\"\"===d||\"0\"===e[0]}},{id:\"p-as-heading\",evaluate:function(a,b,c){function d(a){for(var b=a,c=a.textContent.trim(),d=c;d===c&&void 0!==b;){var e=-1;if(a=b,0===a.children.length)return a;do{e++,d=a.children[e].textContent.trim()}while(\"\"===d&&e+1<a.children.length);b=a.children[e]}return a}function e(a){switch(a){case\"lighter\":return 100;case\"normal\":return 400;case\"bold\":return 700;case\"bolder\":return 900}return a=parseInt(a),isNaN(a)?400:a}function f(a){var b=window.getComputedStyle(d(a));return{fontWeight:e(b.getPropertyValue(\"font-weight\")),fontSize:parseInt(b.getPropertyValue(\"font-size\")),isItalic:\"italic\"===b.getPropertyValue(\"font-style\")}}function g(a,b,c){return c.reduce(function(c,d){return c||(!d.size||a.fontSize/d.size>b.fontSize)&&(!d.weight||a.fontWeight-d.weight>b.fontWeight)&&(!d.italic||a.isItalic&&!b.isItalic)},!1)}var h=Array.from(a.parentNode.children),i=h.indexOf(a);b=b||{};var j=b.margins||[],k=h.slice(i+1).find(function(a){return\"P\"===a.nodeName.toUpperCase()}),l=h.slice(0,i).reverse().find(function(a){return\"P\"===a.nodeName.toUpperCase()}),m=f(a),n=k?f(k):null,o=l?f(l):null;if(!n||!g(m,n,j))return!0;var p=axe.commons.dom.findUpVirtual(c,\"blockquote\");return!!(p&&\"BLOCKQUOTE\"===p.nodeName.toUpperCase()||o&&!g(m,o,j))&&void 0},options:{margins:[{weight:150,italic:!0},{weight:150,size:1.15},{italic:!0,size:1.15},{size:1.4}]}},{id:\"region\",evaluate:function(a,b,c){function d(a){return j&&j===a}function e(a){return a.hasAttribute(\"role\")?k.includes(a.getAttribute(\"role\").toLowerCase()):l.some(function(b){return axe.utils.matchesSelector(a,b)})}function f(a){var b=a.actualNode;return e(b)||d(b)||!h.isVisible(b,!0)?[]:h.hasContent(b,!0)?[b]:a.children.filter(function(a){return 1===a.actualNode.nodeType}).map(f).reduce(function(a,b){return a.concat(b)},[])}var g=axe.commons,h=g.dom,i=g.aria,j=function(a){var b=axe.utils.querySelectorAll(a,\"a[href]\")[0];if(b&&axe.commons.dom.getElementByReference(b.actualNode,\"href\"))return b.actualNode}(c),k=i.getRolesByType(\"landmark\"),l=k.reduce(function(a,b){return a.concat(i.implicitNodes(b))},[]).filter(function(a){return null!==a}),m=f(c);return this.relatedNodes(m),0===m.length},after:function(a,b){return[a[0]]}},{id:\"skip-link\",evaluate:function(a,b,c){var d=axe.commons.dom.getElementByReference(a,\"href\");return!!d&&(axe.commons.dom.isVisible(d,!0)||void 0)}},{id:\"unique-frame-title\",evaluate:function(a,b,c){var d=axe.commons.text.sanitize(a.title).trim().toLowerCase();return this.data(d),!0},after:function(a,b){var c={};return a.forEach(function(a){c[a.data]=void 0!==c[a.data]?++c[a.data]:0}),a.forEach(function(a){a.result=!!c[a.data]}),a}},{id:\"aria-label\",evaluate:function(a,b,c){var d=a.getAttribute(\"aria-label\");return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"aria-labelledby\",evaluate:function(a,b,c){return(0,axe.commons.dom.idrefs)(a,\"aria-labelledby\").some(function(a){return a&&axe.commons.text.accessibleText(a,!0)})}},{id:\"button-has-visible-text\",evaluate:function(a,b,c){var d=a.nodeName.toUpperCase(),e=a.getAttribute(\"role\"),f=void 0;return(\"BUTTON\"===d||\"button\"===e&&\"INPUT\"!==d)&&(f=axe.commons.text.accessibleTextVirtual(c),this.data(f),!!f)}},{id:\"doc-has-title\",evaluate:function(a,b,c){var d=document.title;return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"duplicate-id\",evaluate:function(a,b,c){var d=a.getAttribute(\"id\").trim();if(!d)return!0;var e=axe.commons.dom.getRootNode(a),f=Array.from(e.querySelectorAll('[id=\"'+axe.commons.utils.escapeSelector(d)+'\"]')).filter(function(b){return b!==a});return f.length&&this.relatedNodes(f),this.data(d),0===f.length},after:function(a,b){var c=[];return a.filter(function(a){return-1===c.indexOf(a.data)&&(c.push(a.data),!0)})}},{id:\"exists\",evaluate:function(a,b,c){return!0}},{id:\"has-alt\",evaluate:function(a,b,c){var d=a.nodeName.toLowerCase();return a.hasAttribute(\"alt\")&&(\"img\"===d||\"input\"===d||\"area\"===d)}},{id:\"has-visible-text\",evaluate:function(a,b,c){return axe.commons.text.accessibleTextVirtual(c).length>0}},{id:\"is-on-screen\",evaluate:function(a,b,c){return axe.commons.dom.isVisible(a,!1)&&!axe.commons.dom.isOffscreen(a)}},{id:\"non-empty-alt\",evaluate:function(a,b,c){var d=a.getAttribute(\"alt\");return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"non-empty-if-present\",evaluate:function(a,b,c){var d=a.nodeName.toUpperCase(),e=(a.getAttribute(\"type\")||\"\").toLowerCase(),f=a.getAttribute(\"value\");return this.data(f),!(\"INPUT\"!==d||![\"submit\",\"reset\"].includes(e))&&null===f}},{id:\"non-empty-title\",evaluate:function(a,b,c){var d=a.getAttribute(\"title\");return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"non-empty-value\",evaluate:function(a,b,c){var d=a.getAttribute(\"value\");return!!(d?axe.commons.text.sanitize(d).trim():\"\")}},{id:\"role-none\",evaluate:function(a,b,c){return\"none\"===a.getAttribute(\"role\")}},{id:\"role-presentation\",evaluate:function(a,b,c){return\"presentation\"===a.getAttribute(\"role\")}},{id:\"caption-faked\",evaluate:function(a,b,c){var d=axe.commons.table.toGrid(a),e=d[0];return d.length<=1||e.length<=1||a.rows.length<=1||e.reduce(function(a,b,c){return a||b!==e[c+1]&&void 0!==e[c+1]},!1)}},{id:\"has-caption\",evaluate:function(a,b,c){return!!a.caption}},{id:\"has-summary\",evaluate:function(a,b,c){return!!a.summary}},{id:\"has-th\",evaluate:function(a,b,c){for(var d,e,f=[],g=0,h=a.rows.length;g<h;g++){d=a.rows[g];for(var i=0,j=d.cells.length;i<j;i++)e=d.cells[i],\"TH\"!==e.nodeName.toUpperCase()&&-1===[\"rowheader\",\"columnheader\"].indexOf(e.getAttribute(\"role\"))||f.push(e)}return!!f.length&&(this.relatedNodes(f),!0)}},{id:\"html5-scope\",evaluate:function(a,b,c){return!axe.commons.dom.isHTML5(document)||\"TH\"===a.nodeName.toUpperCase()}},{id:\"same-caption-summary\",evaluate:function(a,b,c){return!(!a.summary||!a.caption)&&a.summary===axe.commons.text.accessibleText(a.caption)}},{id:\"scope-value\",evaluate:function(a,b,c){b=b||{};var d=a.getAttribute(\"scope\").toLowerCase();return-1!==([\"row\",\"col\",\"rowgroup\",\"colgroup\"]||b.values).indexOf(d)}},{id:\"td-has-header\",evaluate:function(a,b,c){var d=axe.commons.table,e=[];return d.getAllCells(a).forEach(function(a){if(axe.commons.dom.hasContent(a)&&d.isDataCell(a)&&!axe.commons.aria.label(a)){var b=d.getHeaders(a);(b=b.reduce(function(a,b){return a||null!==b&&!!axe.commons.dom.hasContent(b)},!1))||e.push(a)}}),!e.length||(this.relatedNodes(e),!1)}},{id:\"td-headers-attr\",evaluate:function(a,b,c){for(var d=[],e=0,f=a.rows.length;e<f;e++)for(var g=a.rows[e],h=0,i=g.cells.length;h<i;h++)d.push(g.cells[h]);var j=d.reduce(function(a,b){return b.getAttribute(\"id\")&&a.push(b.getAttribute(\"id\")),a},[]),k=d.reduce(function(a,b){var c,d,e=(b.getAttribute(\"headers\")||\"\").split(/\\s/).reduce(function(a,b){return b=b.trim(),b&&a.push(b),a},[]);return 0!==e.length&&(b.getAttribute(\"id\")&&(c=-1!==e.indexOf(b.getAttribute(\"id\").trim())),d=e.reduce(function(a,b){return a||-1===j.indexOf(b)},!1),(c||d)&&a.push(b)),a},[]);return!(k.length>0)||(this.relatedNodes(k),!1)}},{id:\"th-has-data-cells\",evaluate:function(a,b,c){var d=axe.commons.table,e=d.getAllCells(a),f=this,g=[];e.forEach(function(a){var b=a.getAttribute(\"headers\");b&&(g=g.concat(b.split(/\\s+/)));var c=a.getAttribute(\"aria-labelledby\");c&&(g=g.concat(c.split(/\\s+/)))});var h=e.filter(function(a){return\"\"!==axe.commons.text.sanitize(a.textContent)&&(\"TH\"===a.nodeName.toUpperCase()||-1!==[\"rowheader\",\"columnheader\"].indexOf(a.getAttribute(\"role\")))}),i=d.toGrid(a);return!!h.reduce(function(a,b){if(b.getAttribute(\"id\")&&g.includes(b.getAttribute(\"id\")))return!!a||a;var c=!1,e=d.getCellPosition(b,i);return d.isColumnHeader(b)&&(c=d.traverse(\"down\",e,i).reduce(function(a,b){return a||axe.commons.dom.hasContent(b)&&!d.isColumnHeader(b)},!1)),!c&&d.isRowHeader(b)&&(c=d.traverse(\"right\",e,i).reduce(function(a,b){return a||axe.commons.dom.hasContent(b)&&!d.isRowHeader(b)},!1)),c||f.relatedNodes(b),a&&c},!0)||void 0}},{id:\"hidden-content\",evaluate:function(a,b,c){if(![\"SCRIPT\",\"HEAD\",\"TITLE\",\"NOSCRIPT\",\"STYLE\",\"TEMPLATE\"].includes(a.tagName.toUpperCase())&&axe.commons.dom.hasContentVirtual(c)){var d=window.getComputedStyle(a);if(\"none\"===d.getPropertyValue(\"display\"))return;if(\"hidden\"===d.getPropertyValue(\"visibility\")){var e=axe.commons.dom.getComposedParent(a),f=e&&window.getComputedStyle(e);if(!f||\"hidden\"!==f.getPropertyValue(\"visibility\"))return}}return!0}}],commons:function(){function a(a){return a.getPropertyValue(\"font-family\").split(/[,;]/g).map(function(a){return a.trim().toLowerCase()})}function b(b,c){var d=window.getComputedStyle(b);if(\"none\"!==d.getPropertyValue(\"background-image\"))return!0;if([\"border-bottom\",\"border-top\",\"outline\"].reduce(function(a,b){var c=new C.Color;return c.parseRgbString(d.getPropertyValue(b+\"-color\")),a||\"none\"!==d.getPropertyValue(b+\"-style\")&&parseFloat(d.getPropertyValue(b+\"-width\"))>0&&0!==c.alpha},!1))return!0;var e=window.getComputedStyle(c);if(a(d)[0]!==a(e)[0])return!0;var f=[\"text-decoration-line\",\"text-decoration-style\",\"font-weight\",\"font-style\",\"font-size\"].reduce(function(a,b){return a||d.getPropertyValue(b)!==e.getPropertyValue(b)},!1),g=d.getPropertyValue(\"text-decoration\");return g.split(\" \").length<3&&(f=f||g!==e.getPropertyValue(\"text-decoration\")),f}function c(a,b){var c=a.nodeName.toUpperCase();if(G.includes(c))return axe.commons.color.incompleteData.set(\"bgColor\",\"imgNode\"),!0;b=b||window.getComputedStyle(a);var d=b.getPropertyValue(\"background-image\"),e=\"none\"!==d;if(e){var f=/gradient/.test(d);axe.commons.color.incompleteData.set(\"bgColor\",f?\"bgGradient\":\"bgImage\")}return e}function d(a,b){b=b||window.getComputedStyle(a);var c=new C.Color;if(c.parseRgbString(b.getPropertyValue(\"background-color\")),0!==c.alpha){var d=b.getPropertyValue(\"opacity\");c.alpha=c.alpha*d}return c}function e(a,b){var c=a.getClientRects()[0],d=D.shadowElementsFromPoint(c.left,c.top);if(d)for(var e=0;e<d.length;e++)if(d[e]!==a&&d[e]===b)return!0;return!1}function f(a,b,c){var f=0;if(a>0)for(var g=a-1;g>=0;g--){var h=b[g],i=window.getComputedStyle(h),j=d(h,i);j.alpha&&e(c,h)?f+=j.alpha:b.splice(g,1)}return f}function g(a,b,c){var d=a!==b&&!D.visuallyContains(a,b)&&0!==c.alpha;return d&&axe.commons.color.incompleteData.set(\"bgColor\",\"elmPartiallyObscured\"),d}function h(a,b){var c={TD:[\"TR\",\"TBODY\"],TH:[\"TR\",\"THEAD\"],INPUT:[\"LABEL\"]},d=a.map(function(a){return a.tagName}),e=a;for(var f in c)if(d.includes(f))for(var g in c[f])if(f.hasOwnProperty(g)){var h=axe.commons.dom.findUp(b,c[f][g]);if(h&&-1===a.indexOf(h)){var i=axe.commons.dom.visuallyOverlaps(b.getBoundingClientRect(),h);i&&e.splice(d.indexOf(f)+1,0,h)}b.tagName===c[f][g]&&-1===d.indexOf(b.tagName)&&e.splice(d.indexOf(f)+1,0,b)}return e}function i(a){var b=a.indexOf(document.body),e=a;return b>1&&!c(document.documentElement)&&0===d(document.documentElement).alpha&&(e.splice(b,1),e.splice(a.indexOf(document.documentElement),1),e.push(document.body)),e}function j(a){if(!H.includes(a.actualNode.nodeName.toUpperCase()))return a.children.some(function(a){var b=a.actualNode;return 3===b.nodeType&&b.nodeValue.trim()})}function k(a){return a.disabled||!D.isVisible(a,!0)&&\"AREA\"!==a.nodeName.toUpperCase()}function l(a,b){!1!==b(a.actualNode)&&a.children.forEach(function(a){return l(a,b)})}function m(a){var b=window.getComputedStyle(a).getPropertyValue(\"display\");return I.includes(b)||\"table-\"===b.substr(0,6)}function n(a){for(var b=D.getComposedParent(a);b&&!m(b);)b=D.getComposedParent(b);return axe.utils.getNodeFromTree(axe._tree[0],b)}function o(a,b){for(a=D.getComposedParent(a);a&&\"html\"!==a.nodeName.toLowerCase();){if(a.scrollTop&&(b+=a.scrollTop)>=0)return!1;a=D.getComposedParent(a)}return!0}function p(a){\"use strict\";var b=a.match(/rect\\s*\\(([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px,?\\s*([0-9]+)px\\s*\\)/);return!(!b||5!==b.length)&&(b[3]-b[1]<=0&&b[2]-b[4]<=0)}function q(a){var b=void 0;return b=a.actualNode.id?D.findElmsInContext({elm:\"label\",attr:\"for\",value:a.actualNode.id,context:a.actualNode})[0]:D.findUpVirtual(a,\"label\"),axe.utils.getNodeFromTree(axe._tree[0],b)}function r(a){return[\"button\",\"reset\",\"submit\"].includes(a.actualNode.type.toLowerCase())}function s(a){var b=a.actualNode,c=b.nodeName.toUpperCase();return\"TEXTAREA\"===c||\"SELECT\"===c||\"INPUT\"===c&&\"hidden\"!==b.type.toLowerCase()}function t(a){return[\"BUTTON\",\"SUMMARY\",\"A\"].includes(a.actualNode.nodeName.toUpperCase())}function u(a){return[\"TABLE\",\"FIGURE\"].includes(a.actualNode.nodeName.toUpperCase())}function v(a){var b=a.actualNode,c=b.nodeName.toUpperCase();if(\"INPUT\"===c)return!b.hasAttribute(\"type\")||L.includes(b.type.toLowerCase())?b.value:\"\";if(\"SELECT\"===c){var d=b.options;if(d&&d.length){for(var e=\"\",f=0;f<d.length;f++)d[f].selected&&(e+=\" \"+d[f].text);return F.sanitize(e)}return\"\"}return\"TEXTAREA\"===c&&b.value?b.value:\"\"}function w(a,b){var c=a.actualNode,d=c.querySelector(b.toLowerCase());return d?F.accessibleText(d):\"\"}function x(a){if(!a)return!1;var b=a.actualNode;switch(b.nodeName.toUpperCase()){case\"SELECT\":case\"TEXTAREA\":return!0;case\"INPUT\":return!b.hasAttribute(\"type\")||L.includes(b.getAttribute(\"type\").toLowerCase());default:return!1}}function y(a){var b=a.actualNode,c=b.nodeName.toUpperCase();return[\"IMG\",\"APPLET\",\"AREA\"].includes(c)||\"INPUT\"===c&&\"image\"===b.type.toLowerCase()}function z(a){return!!F.sanitize(a)}var commons={},A=commons.aria={},B=A.lookupTable={};B.attributes={\"aria-activedescendant\":{type:\"idref\"},\"aria-atomic\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-autocomplete\":{type:\"nmtoken\",values:[\"inline\",\"list\",\"both\",\"none\"]},\"aria-busy\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-checked\":{type:\"nmtoken\",values:[\"true\",\"false\",\"mixed\",\"undefined\"]},\"aria-colcount\":{type:\"int\"},\"aria-colindex\":{type:\"int\"},\"aria-colspan\":{type:\"int\"},\"aria-controls\":{type:\"idrefs\"},\"aria-current\":{type:\"nmtoken\",values:[\"page\",\"step\",\"location\",\"date\",\"time\",\"true\",\"false\"]},\"aria-describedby\":{type:\"idrefs\"},\"aria-disabled\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-dropeffect\":{type:\"nmtokens\",values:[\"copy\",\"move\",\"reference\",\"execute\",\"popup\",\"none\"]},\"aria-errormessage\":{type:\"idref\"},\"aria-expanded\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-flowto\":{type:\"idrefs\"},\"aria-grabbed\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-haspopup\":{type:\"nmtoken\",values:[\"true\",\"false\",\"menu\",\"listbox\",\"tree\",\"grid\",\"dialog\"]},\"aria-hidden\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-invalid\":{type:\"nmtoken\",values:[\"true\",\"false\",\"spelling\",\"grammar\"]},\"aria-keyshortcuts\":{type:\"string\"},\"aria-label\":{type:\"string\"},\"aria-labelledby\":{type:\"idrefs\"},\"aria-level\":{type:\"int\"},\"aria-live\":{type:\"nmtoken\",values:[\"off\",\"polite\",\"assertive\"]},\"aria-modal\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-multiline\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-multiselectable\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-orientation\":{type:\"nmtoken\",values:[\"horizontal\",\"vertical\"]},\"aria-owns\":{type:\"idrefs\"},\"aria-placeholder\":{type:\"string\"},\"aria-posinset\":{type:\"int\"},\"aria-pressed\":{type:\"nmtoken\",values:[\"true\",\"false\",\"mixed\",\"undefined\"]},\"aria-readonly\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-relevant\":{type:\"nmtokens\",values:[\"additions\",\"removals\",\"text\",\"all\"]},\"aria-required\":{type:\"boolean\",values:[\"true\",\"false\"]},\"aria-rowcount\":{type:\"int\"},\"aria-rowindex\":{type:\"int\"},\"aria-rowspan\":{type:\"int\"},\"aria-selected\":{type:\"nmtoken\",values:[\"true\",\"false\",\"undefined\"]},\"aria-setsize\":{type:\"int\"},\"aria-sort\":{type:\"nmtoken\",values:[\"ascending\",\"descending\",\"other\",\"none\"]},\"aria-valuemax\":{type:\"decimal\"},\"aria-valuemin\":{type:\"decimal\"},\"aria-valuenow\":{type:\"decimal\"},\"aria-valuetext\":{type:\"string\"}},B.globalAttributes=[\"aria-atomic\",\"aria-busy\",\"aria-controls\",\"aria-current\",\"aria-describedby\",\"aria-disabled\",\"aria-dropeffect\",\"aria-flowto\",\"aria-grabbed\",\"aria-haspopup\",\"aria-hidden\",\"aria-invalid\",\"aria-keyshortcuts\",\"aria-label\",\"aria-labelledby\",\"aria-live\",\"aria-owns\",\"aria-relevant\"],B.role={alert:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},alertdialog:{type:\"widget\",attributes:{allowed:[\"aria-expanded\",\"aria-modal\"]},owned:null,nameFrom:[\"author\"],context:null},application:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},article:{type:\"structure\",attributes:{allowed:[\"aria-expanded\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"article\"]},banner:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"header\"]},button:{type:\"widget\",attributes:{allowed:[\"aria-expanded\",\"aria-pressed\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"button\",'input[type=\"button\"]','input[type=\"image\"]','input[type=\"reset\"]','input[type=\"submit\"]',\"summary\"]},cell:{type:\"structure\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-rowindex\",\"aria-rowspan\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"td\",\"th\"]},checkbox:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:['input[type=\"checkbox\"]']},columnheader:{type:\"structure\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-expanded\",\"aria-rowindex\",\"aria-rowspan\",\"aria-required\",\"aria-readonly\",\"aria-selected\",\"aria-sort\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"th\"]},combobox:{type:\"composite\",attributes:{allowed:[\"aria-expanded\",\"aria-autocomplete\",\"aria-required\",\"aria-activedescendant\",\"aria-orientation\"]},owned:{all:[\"listbox\",\"textbox\"]},nameFrom:[\"author\"],context:null},command:{nameFrom:[\"author\"],type:\"abstract\"},complementary:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"aside\"]},composite:{nameFrom:[\"author\"],type:\"abstract\"},contentinfo:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"footer\"]},definition:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"dd\",\"dfn\"]},dialog:{type:\"widget\",attributes:{allowed:[\"aria-expanded\",\"aria-modal\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"dialog\"]},directory:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},document:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"body\"]},feed:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:{one:[\"article\"]},nameFrom:[\"author\"],context:null},form:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"form\"]},grid:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-colcount\",\"aria-level\",\"aria-multiselectable\",\"aria-readonly\",\"aria-rowcount\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null,implicit:[\"table\"]},gridcell:{type:\"widget\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-expanded\",\"aria-rowindex\",\"aria-rowspan\",\"aria-selected\",\"aria-readonly\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"td\",\"th\"]},group:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"details\",\"optgroup\"]},heading:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"h1\",\"h2\",\"h3\",\"h4\",\"h5\",\"h6\"]},img:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"img\"]},input:{nameFrom:[\"author\"],type:\"abstract\"},landmark:{nameFrom:[\"author\"],type:\"abstract\"},link:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"a[href]\"]},list:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:{all:[\"listitem\"]},nameFrom:[\"author\"],context:null,implicit:[\"ol\",\"ul\",\"dl\"]},listbox:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-multiselectable\",\"aria-required\",\"aria-expanded\",\"aria-orientation\"]},owned:{all:[\"option\"]},nameFrom:[\"author\"],context:null,implicit:[\"select\"]},listitem:{type:\"structure\",attributes:{allowed:[\"aria-level\",\"aria-posinset\",\"aria-setsize\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"list\"],implicit:[\"li\",\"dt\"]},log:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},main:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"main\"]},marquee:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},math:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"math\"]},menu:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-orientation\"]},owned:{one:[\"menuitem\",\"menuitemradio\",\"menuitemcheckbox\"]},nameFrom:[\"author\"],context:null,implicit:['menu[type=\"context\"]']},menubar:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-orientation\"]},owned:null,nameFrom:[\"author\"],context:null},menuitem:{type:\"widget\",attributes:{allowed:[\"aria-posinset\",\"aria-setsize\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"command\"]']},menuitemcheckbox:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"checkbox\"]']},menuitemradio:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-selected\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"menu\",\"menubar\"],implicit:['menuitem[type=\"radio\"]']},navigation:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"nav\"]},none:{type:\"structure\",attributes:null,owned:null,nameFrom:[\"author\"],context:null},note:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},option:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-posinset\",\"aria-setsize\",\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"listbox\"],implicit:[\"option\"]},presentation:{type:\"structure\",attributes:null,owned:null,nameFrom:[\"author\"],context:null},progressbar:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"progress\"]},radio:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-selected\",\"aria-posinset\",\"aria-setsize\",\"aria-required\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:['input[type=\"radio\"]']},radiogroup:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-required\",\"aria-expanded\"]},owned:{all:[\"radio\"]},nameFrom:[\"author\"],context:null},range:{nameFrom:[\"author\"],type:\"abstract\"},region:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"section[aria-label]\",\"section[aria-labelledby]\",\"section[title]\"]},roletype:{type:\"abstract\"},row:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-colindex\",\"aria-expanded\",\"aria-level\",\"aria-selected\",\"aria-rowindex\"]},owned:{one:[\"cell\",\"columnheader\",\"rowheader\",\"gridcell\"]},nameFrom:[\"author\",\"contents\"],context:[\"rowgroup\",\"grid\",\"treegrid\",\"table\"],implicit:[\"tr\"]},rowgroup:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:{all:[\"row\"]},nameFrom:[\"author\",\"contents\"],context:[\"grid\",\"table\"],implicit:[\"tbody\",\"thead\",\"tfoot\"]},rowheader:{type:\"structure\",attributes:{allowed:[\"aria-colindex\",\"aria-colspan\",\"aria-expanded\",\"aria-rowindex\",\"aria-rowspan\",\"aria-required\",\"aria-readonly\",\"aria-selected\",\"aria-sort\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"row\"],implicit:[\"th\"]},scrollbar:{type:\"widget\",attributes:{required:[\"aria-controls\",\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"],allowed:[\"aria-valuetext\",\"aria-orientation\"]},owned:null,nameFrom:[\"author\"],context:null},search:{type:\"landmark\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},searchbox:{type:\"widget\",attributes:{allowed:[\"aria-activedescendant\",\"aria-autocomplete\",\"aria-multiline\",\"aria-readonly\",\"aria-required\",\"aria-placeholder\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"search\"]']},section:{nameFrom:[\"author\",\"contents\"],type:\"abstract\"},sectionhead:{nameFrom:[\"author\",\"contents\"],type:\"abstract\"},select:{nameFrom:[\"author\"],type:\"abstract\"},separator:{type:\"structure\",attributes:{allowed:[\"aria-expanded\",\"aria-orientation\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"hr\"]},slider:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-orientation\"],required:[\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"range\"]']},spinbutton:{type:\"widget\",attributes:{allowed:[\"aria-valuetext\",\"aria-required\"],required:[\"aria-valuenow\",\"aria-valuemax\",\"aria-valuemin\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"number\"]']},status:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:[\"output\"]},structure:{type:\"abstract\"},switch:{type:\"widget\",attributes:{required:[\"aria-checked\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},tab:{type:\"widget\",attributes:{allowed:[\"aria-selected\",\"aria-expanded\",\"aria-setsize\",\"aria-posinset\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"tablist\"]},table:{type:\"structure\",attributes:{allowed:[\"aria-colcount\",\"aria-rowcount\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null,implicit:[\"table\"]},tablist:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\",\"aria-level\",\"aria-multiselectable\",\"aria-orientation\"]},owned:{all:[\"tab\"]},nameFrom:[\"author\"],context:null},tabpanel:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},term:{type:\"structure\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null,implicit:[\"dt\"]},text:{type:\"structure\",owned:null,nameFrom:[\"author\",\"contents\"],context:null},textbox:{type:\"widget\",attributes:{allowed:[\"aria-activedescendant\",\"aria-autocomplete\",\"aria-multiline\",\"aria-readonly\",\"aria-required\",\"aria-placeholder\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['input[type=\"text\"]','input[type=\"email\"]','input[type=\"password\"]','input[type=\"tel\"]','input[type=\"url\"]',\"input:not([type])\",\"textarea\"]},timer:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null},toolbar:{type:\"structure\",attributes:{allowed:[\"aria-activedescendant\",\"aria-expanded\"]},owned:null,nameFrom:[\"author\"],context:null,implicit:['menu[type=\"toolbar\"]']},tooltip:{type:\"widget\",attributes:{allowed:[\"aria-expanded\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:null},tree:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-multiselectable\",\"aria-required\",\"aria-expanded\",\"aria-orientation\"]},owned:{all:[\"treeitem\"]},nameFrom:[\"author\"],context:null},treegrid:{type:\"composite\",attributes:{allowed:[\"aria-activedescendant\",\"aria-colcount\",\"aria-expanded\",\"aria-level\",\"aria-multiselectable\",\"aria-readonly\",\"aria-required\",\"aria-rowcount\",\"aria-orientation\"]},owned:{one:[\"rowgroup\",\"row\"]},nameFrom:[\"author\"],context:null},treeitem:{type:\"widget\",attributes:{allowed:[\"aria-checked\",\"aria-selected\",\"aria-expanded\",\"aria-level\",\"aria-posinset\",\"aria-setsize\"]},owned:null,nameFrom:[\"author\",\"contents\"],context:[\"group\",\"tree\"]},widget:{type:\"abstract\"},window:{nameFrom:[\"author\"],type:\"abstract\"}};var C={};commons.color=C;var D=commons.dom={},E=commons.table={},F=commons.text={EdgeFormDefaults:{}};commons.utils=axe.utils;A.requiredAttr=function(a){\"use strict\";var b=A.lookupTable.role[a];return b&&b.attributes&&b.attributes.required||[]},A.allowedAttr=function(a){\"use strict\";var b=A.lookupTable.role[a],c=b&&b.attributes&&b.attributes.allowed||[],d=b&&b.attributes&&b.attributes.required||[];return c.concat(A.lookupTable.globalAttributes).concat(d)},A.validateAttr=function(a){\"use strict\";return!!A.lookupTable.attributes[a]},A.validateAttrValue=function(a,b){\"use strict\";var c,d,e=a.getAttribute(b),f=A.lookupTable.attributes[b],g=D.getRootNode(a);if(!f)return!0;switch(f.type){case\"boolean\":case\"nmtoken\":return\"string\"==typeof e&&-1!==f.values.indexOf(e.toLowerCase());case\"nmtokens\":return d=axe.utils.tokenList(e),d.reduce(function(a,b){return a&&-1!==f.values.indexOf(b)},0!==d.length);case\"idref\":return!(!e||!g.getElementById(e));case\"idrefs\":return d=axe.utils.tokenList(e),d.reduce(function(a,b){return!(!a||!g.getElementById(b))},0!==d.length);case\"string\":return!0;case\"decimal\":return!(!(c=e.match(/^[-+]?([0-9]*)\\.?([0-9]*)$/))||!c[1]&&!c[2]);case\"int\":return/^[-+]?[0-9]+$/.test(e)}},A.labelVirtual=function(a){var b=a.actualNode,c=void 0,d=void 0;return b.getAttribute(\"aria-labelledby\")&&(c=D.idrefs(b,\"aria-labelledby\"),d=c.map(function(a){\nvar b=axe.utils.getNodeFromTree(axe._tree[0],a);return b?F.visibleVirtual(b,!0):\"\"}).join(\" \").trim())?d:(d=b.getAttribute(\"aria-label\"),d&&(d=F.sanitize(d).trim())?d:null)},A.label=function(a){return a=axe.utils.getNodeFromTree(axe._tree[0],a),A.labelVirtual(a)},A.isValidRole=function(a){\"use strict\";return!!A.lookupTable.role[a]},A.getRolesWithNameFromContents=function(){return Object.keys(A.lookupTable.role).filter(function(a){return A.lookupTable.role[a].nameFrom&&-1!==A.lookupTable.role[a].nameFrom.indexOf(\"contents\")})},A.getRolesByType=function(a){return Object.keys(A.lookupTable.role).filter(function(b){return A.lookupTable.role[b].type===a})},A.getRoleType=function(a){var b=A.lookupTable.role[a];return b&&b.type||null},A.requiredOwned=function(a){\"use strict\";var b=null,c=A.lookupTable.role[a];return c&&(b=axe.utils.clone(c.owned)),b},A.requiredContext=function(a){\"use strict\";var b=null,c=A.lookupTable.role[a];return c&&(b=axe.utils.clone(c.context)),b},A.implicitNodes=function(a){\"use strict\";var b=null,c=A.lookupTable.role[a];return c&&c.implicit&&(b=axe.utils.clone(c.implicit)),b},A.implicitRole=function(a){\"use strict\";var b=function(b,c){var d=function(b){return axe.utils.matchesSelector(a,b)};return c.implicit&&c.implicit.some(d)&&b.push(c.name),b},c=Object.keys(A.lookupTable.role).map(function(a){var b=A.lookupTable.role[a];return{name:a,implicit:b&&b.implicit}}),d=c.reduce(b,[]);if(!d.length)return null;for(var e=a.attributes,f=[],g=0,h=e.length;g<h;g++){var i=e[g];i.name.match(/^aria-/)&&f.push(i.name)}return function(a,b){var c=function(a){return A.allowedAttr(a).reduce(function(a,c){return a+(b.indexOf(c)>-1?1:0)},0)};return a.map(function(a){return{score:c(a),name:a}}).sort(function(a,b){return b.score-a.score}).map(function(a){return a.name})}(d,f).shift()},C.Color=function(a,b,c,d){this.red=a,this.green=b,this.blue=c,this.alpha=d,this.toHexString=function(){var a=Math.round(this.red).toString(16),b=Math.round(this.green).toString(16),c=Math.round(this.blue).toString(16);return\"#\"+(this.red>15.5?a:\"0\"+a)+(this.green>15.5?b:\"0\"+b)+(this.blue>15.5?c:\"0\"+c)};var e=/^rgb\\((\\d+), (\\d+), (\\d+)\\)$/,f=/^rgba\\((\\d+), (\\d+), (\\d+), (\\d*(\\.\\d+)?)\\)/;this.parseRgbString=function(a){if(\"transparent\"===a)return this.red=0,this.green=0,this.blue=0,void(this.alpha=0);var b=a.match(e);return b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),this.blue=parseInt(b[3],10),void(this.alpha=1)):(b=a.match(f),b?(this.red=parseInt(b[1],10),this.green=parseInt(b[2],10),this.blue=parseInt(b[3],10),void(this.alpha=parseFloat(b[4]))):void 0)},this.getRelativeLuminance=function(){var a=this.red/255,b=this.green/255,c=this.blue/255;return.2126*(a<=.03928?a/12.92:Math.pow((a+.055)/1.055,2.4))+.7152*(b<=.03928?b/12.92:Math.pow((b+.055)/1.055,2.4))+.0722*(c<=.03928?c/12.92:Math.pow((c+.055)/1.055,2.4))}},C.flattenColors=function(a,b){var c=a.alpha,d=(1-c)*b.red+c*a.red,e=(1-c)*b.green+c*a.green,f=(1-c)*b.blue+c*a.blue,g=a.alpha+b.alpha*(1-a.alpha);return new C.Color(d,e,f,g)},C.getContrast=function(a,b){if(!b||!a)return null;b.alpha<1&&(b=C.flattenColors(b,a));var c=a.getRelativeLuminance(),d=b.getRelativeLuminance();return(Math.max(d,c)+.05)/(Math.min(d,c)+.05)},C.hasValidContrastRatio=function(a,b,c,d){var e=C.getContrast(a,b),f=d&&Math.ceil(72*c)/96<14||!d&&Math.ceil(72*c)/96<18,g=f?4.5:3;return{isValid:e>g,contrastRatio:e,expectedContrastRatio:g}},C.elementIsDistinct=b;var G=[\"IMG\",\"CANVAS\",\"OBJECT\",\"IFRAME\",\"VIDEO\",\"SVG\"];C.getCoords=function(a){var b=void 0,c=void 0;if(!(a.left>window.innerWidth||a.top>window.innerHeight))return b=Math.min(Math.ceil(a.left+a.width/2),window.innerWidth-1),c=Math.min(Math.ceil(a.top+a.height/2),window.innerHeight-1),{x:b,y:c}},C.getRectStack=function(a){var b=C.getCoords(a.getBoundingClientRect());if(b){var c=D.shadowElementsFromPoint(b.x,b.y),d=Array.from(a.getClientRects());if(d&&d.length>1){var e=d.filter(function(a){return a.width&&a.width>0}).map(function(a){var b=C.getCoords(a);if(b)return D.shadowElementsFromPoint(b.x,b.y)});return e.splice(0,0,c),e}return[c]}return null},C.filteredRectStack=function(a){var b=C.getRectStack(a);if(b&&1===b.length)return b[0];if(b&&b.length>1){var c=b.shift(),d=void 0;return b.forEach(function(e,f){if(0!==f){var g=b[f-1],h=b[f];d=g.every(function(a,b){return a===h[b]})||c.includes(a)}}),d?b[0]:(axe.commons.color.incompleteData.set(\"bgColor\",\"elmPartiallyObscuring\"),null)}return axe.commons.color.incompleteData.set(\"bgColor\",\"outsideViewport\"),null},C.getBackgroundStack=function(a){var b=C.filteredRectStack(a);if(null===b)return null;b=h(b,a),b=D.reduceToElementsBelowFloating(b,a),b=i(b);var c=b.indexOf(a);return f(c,b,a)>=.99?(axe.commons.color.incompleteData.set(\"bgColor\",\"bgOverlap\"),null):-1!==c?b:null},C.getBackgroundColor=function(a){var b=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];if(!0!==(arguments.length>2&&void 0!==arguments[2]&&arguments[2])){var e=a.clientHeight-2>=2*window.innerHeight;a.scrollIntoView(e)}var f=[],h=C.getBackgroundStack(a);if((h||[]).some(function(e){var h=window.getComputedStyle(e),i=d(e,h);return g(a,e,i)||c(e,h)?(f=null,b.push(e),!0):0!==i.alpha&&(b.push(e),f.push(i),1===i.alpha)}),null!==f&&null!==h){f.push(new C.Color(255,255,255,1));return f.reduce(C.flattenColors)}return null},D.isOpaque=function(a){var b=window.getComputedStyle(a);return c(a,b)||1===d(a,b).alpha},C.getForegroundColor=function(a,b){var c=window.getComputedStyle(a),d=new C.Color;d.parseRgbString(c.getPropertyValue(\"color\"));var e=c.getPropertyValue(\"opacity\");if(d.alpha=d.alpha*e,1===d.alpha)return d;var f=C.getBackgroundColor(a,[],b);if(null===f){var g=axe.commons.color.incompleteData.get(\"bgColor\");return axe.commons.color.incompleteData.set(\"fgColor\",g),null}return C.flattenColors(d,f)},C.incompleteData=function(){var a={};return{set:function(b,c){if(\"string\"!=typeof b)throw new Error(\"Incomplete data: key must be a string\");return c&&(a[b]=c),a[b]},get:function(b){return a[b]},clear:function(){a={}}}}(),D.reduceToElementsBelowFloating=function(a,b){var c,d,e,f=[\"fixed\",\"sticky\"],g=[],h=!1;for(c=0;c<a.length;++c)d=a[c],d===b&&(h=!0),e=window.getComputedStyle(d),h||-1===f.indexOf(e.position)?g.push(d):g=[];return g},D.findElmsInContext=function(a){var b=a.context,c=a.value,d=a.attr,e=a.elm,f=void 0===e?\"\":e,g=void 0,h=axe.utils.escapeSelector(c);return g=9===b.nodeType||11===b.nodeType?b:D.getRootNode(b),Array.from(g.querySelectorAll(f+\"[\"+d+\"=\"+h+\"]\"))},D.findUp=function(a,b){return D.findUpVirtual(axe.utils.getNodeFromTree(axe._tree[0],a),b)},D.findUpVirtual=function(a,b){var c=void 0;if(c=a.actualNode,!a.shadowId&&\"function\"==typeof a.actualNode.closest){var d=a.actualNode.closest(b);return d||null}do{(c=c.assignedSlot?c.assignedSlot:c.parentNode)&&11===c.nodeType&&(c=c.host)}while(c&&!axe.utils.matchesSelector(c,b)&&c!==document.documentElement);return axe.utils.matchesSelector(c,b)?c:null},D.getComposedParent=function a(b){if(b.assignedSlot)return a(b.assignedSlot);if(b.parentNode){var c=b.parentNode;if(1===c.nodeType)return c;if(c.host)return c.host}return null},D.getElementByReference=function(a,b){var c=a.getAttribute(b);if(c&&\"#\"===c.charAt(0)){c=c.substring(1);var d=document.getElementById(c);if(d)return d;if(d=document.getElementsByName(c),d.length)return d[0]}return null},D.getElementCoordinates=function(a){\"use strict\";var b=D.getScrollOffset(document),c=b.left,d=b.top,e=a.getBoundingClientRect();return{top:e.top+d,right:e.right+c,bottom:e.bottom+d,left:e.left+c,width:e.right-e.left,height:e.bottom-e.top}},D.getRootNode=function(a){var b=a.getRootNode&&a.getRootNode()||document;return b===a&&(b=document),b},D.getScrollOffset=function(a){\"use strict\";if(!a.nodeType&&a.document&&(a=a.document),9===a.nodeType){var b=a.documentElement,c=a.body;return{left:b&&b.scrollLeft||c&&c.scrollLeft||0,top:b&&b.scrollTop||c&&c.scrollTop||0}}return{left:a.scrollLeft,top:a.scrollTop}},D.getViewportSize=function(a){\"use strict\";var b,c=a.document,d=c.documentElement;return a.innerWidth?{width:a.innerWidth,height:a.innerHeight}:d?{width:d.clientWidth,height:d.clientHeight}:(b=c.body,{width:b.clientWidth,height:b.clientHeight})};var H=[\"HEAD\",\"TITLE\",\"TEMPLATE\",\"SCRIPT\",\"STYLE\",\"IFRAME\",\"OBJECT\",\"VIDEO\",\"AUDIO\",\"NOSCRIPT\"];D.hasContentVirtual=function(a,b){return j(a)||D.isVisualContent(a.actualNode)||!!A.labelVirtual(a)||!b&&a.children.some(function(a){return 1===a.actualNode.nodeType&&D.hasContentVirtual(a)})},D.hasContent=function(a,b){return a=axe.utils.getNodeFromTree(axe._tree[0],a),D.hasContentVirtual(a,b)},D.idrefs=function(a,b){\"use strict\";var c,d,e=D.getRootNode(a),f=[],g=a.getAttribute(b);if(g)for(g=axe.utils.tokenList(g),c=0,d=g.length;c<d;c++)f.push(e.getElementById(g[c]));return f},D.isFocusable=function(a){\"use strict\";if(k(a))return!1;if(D.isNativelyFocusable(a))return!0;var b=a.getAttribute(\"tabindex\");return!(!b||isNaN(parseInt(b,10)))},D.isNativelyFocusable=function(a){\"use strict\";if(!a||k(a))return!1;switch(a.nodeName.toUpperCase()){case\"A\":case\"AREA\":if(a.href)return!0;break;case\"INPUT\":return\"hidden\"!==a.type;case\"TEXTAREA\":case\"SELECT\":case\"DETAILS\":case\"BUTTON\":return!0}return!1},D.insertedIntoFocusOrder=function(a){return a.tabIndex>-1&&D.isFocusable(a)&&!D.isNativelyFocusable(a)},D.isHTML5=function(a){var b=a.doctype;return null!==b&&(\"html\"===b.name&&!b.publicId&&!b.systemId)};var I=[\"block\",\"list-item\",\"table\",\"flex\",\"grid\",\"inline-block\"];D.isInTextBlock=function(a){if(m(a))return!1;var b=n(a),c=\"\",d=\"\",e=0;return l(b,function(b){if(2===e)return!1;if(3===b.nodeType&&(c+=b.nodeValue),1===b.nodeType){var f=(b.nodeName||\"\").toUpperCase();if([\"BR\",\"HR\"].includes(f))0===e?(c=\"\",d=\"\"):e=2;else{if(\"none\"===b.style.display||\"hidden\"===b.style.overflow||![\"\",null,\"none\"].includes(b.style.float)||![\"\",null,\"relative\"].includes(b.style.position))return!1;if(\"A\"===f&&b.href||\"link\"===(b.getAttribute(\"role\")||\"\").toLowerCase())return b===a&&(e=1),d+=b.textContent,!1}}}),c=axe.commons.text.sanitize(c),d=axe.commons.text.sanitize(d),c.length>d.length},D.isNode=function(a){\"use strict\";return a instanceof Node},D.isOffscreen=function(a){var b=void 0,c=document.documentElement,d=window.getComputedStyle(a),e=window.getComputedStyle(document.body||c).getPropertyValue(\"direction\"),f=D.getElementCoordinates(a);if(f.bottom<0&&(o(a,f.bottom)||\"absolute\"===d.position))return!0;if(0===f.left&&0===f.right)return!1;if(\"ltr\"===e){if(f.right<=0)return!0}else if(b=Math.max(c.scrollWidth,D.getViewportSize(window).width),f.left>=b)return!0;return!1},D.isVisible=function(a,b,c){\"use strict\";var d,e,f;return 9===a.nodeType||(11===a.nodeType&&(a=a.host),null!==(d=window.getComputedStyle(a,null))&&(e=a.nodeName.toUpperCase(),!(\"none\"===d.getPropertyValue(\"display\")||\"STYLE\"===e.toUpperCase()||\"SCRIPT\"===e.toUpperCase()||!b&&p(d.getPropertyValue(\"clip\"))||!c&&(\"hidden\"===d.getPropertyValue(\"visibility\")||!b&&D.isOffscreen(a))||b&&\"true\"===a.getAttribute(\"aria-hidden\"))&&(!!(f=a.assignedSlot?a.assignedSlot:a.parentNode)&&D.isVisible(f,b,!0))))};var J=[\"checkbox\",\"img\",\"radio\",\"range\",\"slider\",\"spinbutton\",\"textbox\"];D.isVisualContent=function(a){var b=a.getAttribute(\"role\");if(b)return-1!==J.indexOf(b);switch(a.tagName.toUpperCase()){case\"IMG\":case\"IFRAME\":case\"OBJECT\":case\"VIDEO\":case\"AUDIO\":case\"CANVAS\":case\"SVG\":case\"MATH\":case\"BUTTON\":case\"SELECT\":case\"TEXTAREA\":case\"KEYGEN\":case\"PROGRESS\":case\"METER\":return!0;case\"INPUT\":return\"hidden\"!==a.type;default:return!1}},D.shadowElementsFromPoint=function(a,b){return(arguments.length>2&&void 0!==arguments[2]?arguments[2]:document).elementsFromPoint(a,b).reduce(function(c,d){if(axe.utils.isShadowRoot(d)){var e=D.shadowElementsFromPoint(a,b,d.shadowRoot);c=c.concat(e),c.length&&axe.commons.dom.visuallyContains(c[0],d)&&c.push(d)}else c.push(d);return c},[])},D.visuallyContains=function(a,b){var c=a.getBoundingClientRect(),d={top:c.top+.01,bottom:c.bottom-.01,left:c.left+.01,right:c.right-.01},e=b.getBoundingClientRect(),f=e.top,g=e.left,h={top:f-b.scrollTop,bottom:f-b.scrollTop+b.scrollHeight,left:g-b.scrollLeft,right:g-b.scrollLeft+b.scrollWidth},i=window.getComputedStyle(b);return\"inline\"===i.getPropertyValue(\"display\")||!(d.left<h.left&&d.left<e.left||d.top<h.top&&d.top<e.top||d.right>h.right&&d.right>e.right||d.bottom>h.bottom&&d.bottom>e.bottom)&&(!(d.right>e.right||d.bottom>e.bottom)||(\"scroll\"===i.overflow||\"auto\"===i.overflow||\"hidden\"===i.overflow||b instanceof HTMLBodyElement||b instanceof HTMLHtmlElement))},D.visuallyOverlaps=function(a,b){var c=b.getBoundingClientRect(),d=c.top,e=c.left,f={top:d-b.scrollTop,bottom:d-b.scrollTop+b.scrollHeight,left:e-b.scrollLeft,right:e-b.scrollLeft+b.scrollWidth};if(a.left>f.right&&a.left>c.right||a.top>f.bottom&&a.top>c.bottom||a.right<f.left&&a.right<c.left||a.bottom<f.top&&a.bottom<c.top)return!1;var g=window.getComputedStyle(b);return!(a.left>c.right||a.top>c.bottom)||(\"scroll\"===g.overflow||\"auto\"===g.overflow||b instanceof HTMLBodyElement||b instanceof HTMLHtmlElement)},E.getAllCells=function(a){var b,c,d,e,f=[];for(b=0,d=a.rows.length;b<d;b++)for(c=0,e=a.rows[b].cells.length;c<e;c++)f.push(a.rows[b].cells[c]);return f},E.getCellPosition=function(a,b){var c,d;for(b||(b=E.toGrid(D.findUp(a,\"table\"))),c=0;c<b.length;c++)if(b[c]&&-1!==(d=b[c].indexOf(a)))return{x:d,y:c}},E.getHeaders=function(a){if(a.hasAttribute(\"headers\"))return commons.dom.idrefs(a,\"headers\");var b=commons.table.toGrid(commons.dom.findUp(a,\"table\")),c=commons.table.getCellPosition(a,b);return[].concat(E.traverse(\"left\",c,b).filter(function(a){return E.isRowHeader(a)}),E.traverse(\"up\",c,b).filter(function(a){return E.isColumnHeader(a)})).reverse()},E.getScope=function(a){var b=a.getAttribute(\"scope\"),c=a.getAttribute(\"role\");if(a instanceof Element==!1||-1===[\"TD\",\"TH\"].indexOf(a.nodeName.toUpperCase()))throw new TypeError(\"Expected TD or TH element\");if(\"columnheader\"===c)return\"col\";if(\"rowheader\"===c)return\"row\";if(\"col\"===b||\"row\"===b)return b;if(\"TH\"!==a.nodeName.toUpperCase())return!1;var d=E.toGrid(D.findUp(a,\"table\")),e=E.getCellPosition(a);return d[e.y].reduce(function(a,b){return a&&\"TH\"===b.nodeName.toUpperCase()},!0)?\"col\":d.map(function(a){return a[e.x]}).reduce(function(a,b){return a&&\"TH\"===b.nodeName.toUpperCase()},!0)?\"row\":\"auto\"},E.isColumnHeader=function(a){return-1!==[\"col\",\"auto\"].indexOf(E.getScope(a))},E.isDataCell=function(a){return!(!a.children.length&&!a.textContent.trim())&&\"TD\"===a.nodeName.toUpperCase()},E.isDataTable=function(a){var b=(a.getAttribute(\"role\")||\"\").toLowerCase();if((\"presentation\"===b||\"none\"===b)&&!D.isFocusable(a))return!1;if(\"true\"===a.getAttribute(\"contenteditable\")||D.findUp(a,'[contenteditable=\"true\"]'))return!0;if(\"grid\"===b||\"treegrid\"===b||\"table\"===b)return!0;if(\"landmark\"===commons.aria.getRoleType(b))return!0;if(\"0\"===a.getAttribute(\"datatable\"))return!1;if(a.getAttribute(\"summary\"))return!0;if(a.tHead||a.tFoot||a.caption)return!0;for(var c=0,d=a.children.length;c<d;c++)if(\"COLGROUP\"===a.children[c].nodeName.toUpperCase())return!0;for(var e,f,g=0,h=a.rows.length,i=!1,j=0;j<h;j++){e=a.rows[j];for(var k=0,l=e.cells.length;k<l;k++){if(f=e.cells[k],\"TH\"===f.nodeName.toUpperCase())return!0;if(i||f.offsetWidth===f.clientWidth&&f.offsetHeight===f.clientHeight||(i=!0),f.getAttribute(\"scope\")||f.getAttribute(\"headers\")||f.getAttribute(\"abbr\"))return!0;if([\"columnheader\",\"rowheader\"].includes((f.getAttribute(\"role\")||\"\").toLowerCase()))return!0;if(1===f.children.length&&\"ABBR\"===f.children[0].nodeName.toUpperCase())return!0;g++}}if(a.getElementsByTagName(\"table\").length)return!1;if(h<2)return!1;var m=a.rows[Math.ceil(h/2)];if(1===m.cells.length&&1===m.cells[0].colSpan)return!1;if(m.cells.length>=5)return!0;if(i)return!0;var n,o;for(j=0;j<h;j++){if(e=a.rows[j],n&&n!==window.getComputedStyle(e).getPropertyValue(\"background-color\"))return!0;if(n=window.getComputedStyle(e).getPropertyValue(\"background-color\"),o&&o!==window.getComputedStyle(e).getPropertyValue(\"background-image\"))return!0;o=window.getComputedStyle(e).getPropertyValue(\"background-image\")}return h>=20||!(D.getElementCoordinates(a).width>.95*D.getViewportSize(window).width)&&(!(g<10)&&!a.querySelector(\"object, embed, iframe, applet\"))},E.isHeader=function(a){if(E.isColumnHeader(a)||E.isRowHeader(a))return!0;if(a.getAttribute(\"id\")){var b=axe.utils.escapeSelector(a.getAttribute(\"id\"));return!!document.querySelector('[headers~=\"'+b+'\"]')}return!1},E.isRowHeader=function(a){return[\"row\",\"auto\"].includes(E.getScope(a))},E.toGrid=function(a){for(var b=[],c=a.rows,d=0,e=c.length;d<e;d++){var f=c[d].cells;b[d]=b[d]||[];for(var g=0,h=0,i=f.length;h<i;h++)for(var j=0;j<f[h].colSpan;j++){for(var k=0;k<f[h].rowSpan;k++){for(b[d+k]=b[d+k]||[];b[d+k][g];)g++;b[d+k][g]=f[h]}g++}}return b},E.toArray=E.toGrid,function(a){var b=function a(b,c,d,e){var f,g=d[c.y]?d[c.y][c.x]:void 0;return g?\"function\"==typeof e&&!0===(f=e(g,c,d))?[g]:(f=a(b,{x:c.x+b.x,y:c.y+b.y},d,e),f.unshift(g),f):[]};a.traverse=function(a,c,d,e){if(Array.isArray(c)&&(e=d,d=c,c={x:0,y:0}),\"string\"==typeof a)switch(a){case\"left\":a={x:-1,y:0};break;case\"up\":a={x:0,y:-1};break;case\"right\":a={x:1,y:0};break;case\"down\":a={x:0,y:1}}return b(a,{x:c.x+a.x,y:c.y+a.y},d,e)}}(E);var K={submit:\"Submit\",reset:\"Reset\"},L=[\"text\",\"search\",\"tel\",\"url\",\"email\",\"date\",\"time\",\"number\",\"range\",\"color\"],M=[\"A\",\"EM\",\"STRONG\",\"SMALL\",\"MARK\",\"ABBR\",\"DFN\",\"I\",\"B\",\"S\",\"U\",\"CODE\",\"VAR\",\"SAMP\",\"KBD\",\"SUP\",\"SUB\",\"Q\",\"CITE\",\"SPAN\",\"BDO\",\"BDI\",\"BR\",\"WBR\",\"INS\",\"DEL\",\"IMG\",\"EMBED\",\"OBJECT\",\"IFRAME\",\"MAP\",\"AREA\",\"SCRIPT\",\"NOSCRIPT\",\"RUBY\",\"VIDEO\",\"AUDIO\",\"INPUT\",\"TEXTAREA\",\"SELECT\",\"BUTTON\",\"LABEL\",\"OUTPUT\",\"DATALIST\",\"KEYGEN\",\"PROGRESS\",\"COMMAND\",\"CANVAS\",\"TIME\",\"METER\"];F.accessibleText=function(a,b){var c=axe.utils.getNodeFromTree(axe._tree[0],a);return axe.commons.text.accessibleTextVirtual(c,b)},F.accessibleTextVirtual=function(a,b){function c(a,b,c){return a.children.reduce(function(a,d){var e=d.actualNode;return 3===e.nodeType?a+=e.nodeValue:1===e.nodeType&&(M.includes(e.nodeName.toUpperCase())||(a+=\" \"),a+=g(d,b,c)),a},\"\")}function d(a){return axe.commons.table.isDataTable(a.actualNode)||1!==axe.commons.table.getAllCells(a.actualNode).length?\"\":c(a,!1,!1).trim()}function e(a,b,e){var f=\"\",h=a.actualNode,i=h.nodeName.toUpperCase();if(t(a)&&(f=c(a,!1,!1)||\"\",z(f)))return f;if(\"FIGURE\"===i&&(f=w(a,\"figcaption\"),z(f)))return f;if(\"TABLE\"===i){if(f=w(a,\"caption\"),z(f))return f;if(f=h.getAttribute(\"title\")||h.getAttribute(\"summary\")||d(a)||\"\",z(f))return f}if(y(a))return h.getAttribute(\"alt\")||\"\";if(s(a)&&!e){if(r(a))return h.value||h.title||K[h.type]||\"\";var j=q(a);if(j)return g(j,b,!0)}return\"\"}function f(a,b,c){var d=\"\",e=a.actualNode;return!b&&e.hasAttribute(\"aria-labelledby\")&&(d=F.sanitize(D.idrefs(e,\"aria-labelledby\").map(function(a){if(null!==a){e===a&&h.pop();var b=axe.utils.getNodeFromTree(axe._tree[0],a);return g(b,!0,e!==a)}return\"\"}).join(\" \"))),d||c&&x(a)||!e.hasAttribute(\"aria-label\")?d:F.sanitize(e.getAttribute(\"aria-label\"))}var g=void 0,h=[];return a instanceof Node&&(a=axe.utils.getNodeFromTree(axe._tree[0],a)),g=function(a,b,d){var g=void 0;if(!a||h.includes(a))return\"\";if(null!==a&&a.actualNode instanceof Node!=!0)throw new Error(\"Invalid argument. Virtual Node must be provided\");if(!b&&!D.isVisible(a.actualNode,!0))return\"\";h.push(a);var i=a.actualNode.getAttribute(\"role\");return g=f(a,b,d),z(g)?g:(g=e(a,b,d),z(g)?g:d&&(g=v(a),z(g))?g:u(a)||i&&-1===A.getRolesWithNameFromContents().indexOf(i)||(g=c(a,b,d),!z(g))?a.actualNode.hasAttribute(\"title\")?a.actualNode.getAttribute(\"title\"):\"\":g)},F.sanitize(g(a,b))},F.labelVirtual=function(a){var b,c,d;if(c=A.labelVirtual(a))return c;if(a.actualNode.id){var e=axe.commons.utils.escapeSelector(a.actualNode.getAttribute(\"id\"));if(d=axe.commons.dom.getRootNode(a.actualNode),b=d.querySelector('label[for=\"'+e+'\"]'),c=b&&F.visible(b,!0))return c}return b=D.findUpVirtual(a,\"label\"),(c=b&&F.visible(b,!0))||null},F.label=function(a){return a=axe.utils.getNodeFromTree(axe._tree[0],a),F.labelVirtual(a)},F.sanitize=function(a){\"use strict\";return a.replace(/\\r\\n/g,\"\\n\").replace(/\\u00A0/g,\" \").replace(/[\\s]{2,}/g,\" \").trim()},F.visibleVirtual=function(a,b,c){var d=a.children.map(function(d){if(3===d.actualNode.nodeType){var e=d.actualNode.nodeValue;if(e&&D.isVisible(a.actualNode,b))return e}else if(!c)return F.visibleVirtual(d,b)}).join(\"\");return F.sanitize(d)},F.visible=function(a,b,c){return a=axe.utils.getNodeFromTree(axe._tree[0],a),F.visibleVirtual(a,b,c)},axe.utils.tokenList=function(a){\"use strict\";return a.trim().replace(/\\s{2,}/g,\" \").split(\" \")}\n;var N=[\"aa\",\"ab\",\"ae\",\"af\",\"ak\",\"am\",\"an\",\"ar\",\"as\",\"av\",\"ay\",\"az\",\"ba\",\"be\",\"bg\",\"bh\",\"bi\",\"bm\",\"bn\",\"bo\",\"br\",\"bs\",\"ca\",\"ce\",\"ch\",\"co\",\"cr\",\"cs\",\"cu\",\"cv\",\"cy\",\"da\",\"de\",\"dv\",\"dz\",\"ee\",\"el\",\"en\",\"eo\",\"es\",\"et\",\"eu\",\"fa\",\"ff\",\"fi\",\"fj\",\"fo\",\"fr\",\"fy\",\"ga\",\"gd\",\"gl\",\"gn\",\"gu\",\"gv\",\"ha\",\"he\",\"hi\",\"ho\",\"hr\",\"ht\",\"hu\",\"hy\",\"hz\",\"ia\",\"id\",\"ie\",\"ig\",\"ii\",\"ik\",\"in\",\"io\",\"is\",\"it\",\"iu\",\"iw\",\"ja\",\"ji\",\"jv\",\"jw\",\"ka\",\"kg\",\"ki\",\"kj\",\"kk\",\"kl\",\"km\",\"kn\",\"ko\",\"kr\",\"ks\",\"ku\",\"kv\",\"kw\",\"ky\",\"la\",\"lb\",\"lg\",\"li\",\"ln\",\"lo\",\"lt\",\"lu\",\"lv\",\"mg\",\"mh\",\"mi\",\"mk\",\"ml\",\"mn\",\"mo\",\"mr\",\"ms\",\"mt\",\"my\",\"na\",\"nb\",\"nd\",\"ne\",\"ng\",\"nl\",\"nn\",\"no\",\"nr\",\"nv\",\"ny\",\"oc\",\"oj\",\"om\",\"or\",\"os\",\"pa\",\"pi\",\"pl\",\"ps\",\"pt\",\"qu\",\"rm\",\"rn\",\"ro\",\"ru\",\"rw\",\"sa\",\"sc\",\"sd\",\"se\",\"sg\",\"sh\",\"si\",\"sk\",\"sl\",\"sm\",\"sn\",\"so\",\"sq\",\"sr\",\"ss\",\"st\",\"su\",\"sv\",\"sw\",\"ta\",\"te\",\"tg\",\"th\",\"ti\",\"tk\",\"tl\",\"tn\",\"to\",\"tr\",\"ts\",\"tt\",\"tw\",\"ty\",\"ug\",\"uk\",\"ur\",\"uz\",\"ve\",\"vi\",\"vo\",\"wa\",\"wo\",\"xh\",\"yi\",\"yo\",\"za\",\"zh\",\"zu\",\"aaa\",\"aab\",\"aac\",\"aad\",\"aae\",\"aaf\",\"aag\",\"aah\",\"aai\",\"aak\",\"aal\",\"aam\",\"aan\",\"aao\",\"aap\",\"aaq\",\"aas\",\"aat\",\"aau\",\"aav\",\"aaw\",\"aax\",\"aaz\",\"aba\",\"abb\",\"abc\",\"abd\",\"abe\",\"abf\",\"abg\",\"abh\",\"abi\",\"abj\",\"abl\",\"abm\",\"abn\",\"abo\",\"abp\",\"abq\",\"abr\",\"abs\",\"abt\",\"abu\",\"abv\",\"abw\",\"abx\",\"aby\",\"abz\",\"aca\",\"acb\",\"acd\",\"ace\",\"acf\",\"ach\",\"aci\",\"ack\",\"acl\",\"acm\",\"acn\",\"acp\",\"acq\",\"acr\",\"acs\",\"act\",\"acu\",\"acv\",\"acw\",\"acx\",\"acy\",\"acz\",\"ada\",\"adb\",\"add\",\"ade\",\"adf\",\"adg\",\"adh\",\"adi\",\"adj\",\"adl\",\"adn\",\"ado\",\"adp\",\"adq\",\"adr\",\"ads\",\"adt\",\"adu\",\"adw\",\"adx\",\"ady\",\"adz\",\"aea\",\"aeb\",\"aec\",\"aed\",\"aee\",\"aek\",\"ael\",\"aem\",\"aen\",\"aeq\",\"aer\",\"aes\",\"aeu\",\"aew\",\"aey\",\"aez\",\"afa\",\"afb\",\"afd\",\"afe\",\"afg\",\"afh\",\"afi\",\"afk\",\"afn\",\"afo\",\"afp\",\"afs\",\"aft\",\"afu\",\"afz\",\"aga\",\"agb\",\"agc\",\"agd\",\"age\",\"agf\",\"agg\",\"agh\",\"agi\",\"agj\",\"agk\",\"agl\",\"agm\",\"agn\",\"ago\",\"agp\",\"agq\",\"agr\",\"ags\",\"agt\",\"agu\",\"agv\",\"agw\",\"agx\",\"agy\",\"agz\",\"aha\",\"ahb\",\"ahg\",\"ahh\",\"ahi\",\"ahk\",\"ahl\",\"ahm\",\"ahn\",\"aho\",\"ahp\",\"ahr\",\"ahs\",\"aht\",\"aia\",\"aib\",\"aic\",\"aid\",\"aie\",\"aif\",\"aig\",\"aih\",\"aii\",\"aij\",\"aik\",\"ail\",\"aim\",\"ain\",\"aio\",\"aip\",\"aiq\",\"air\",\"ais\",\"ait\",\"aiw\",\"aix\",\"aiy\",\"aja\",\"ajg\",\"aji\",\"ajn\",\"ajp\",\"ajt\",\"aju\",\"ajw\",\"ajz\",\"akb\",\"akc\",\"akd\",\"ake\",\"akf\",\"akg\",\"akh\",\"aki\",\"akj\",\"akk\",\"akl\",\"akm\",\"ako\",\"akp\",\"akq\",\"akr\",\"aks\",\"akt\",\"aku\",\"akv\",\"akw\",\"akx\",\"aky\",\"akz\",\"ala\",\"alc\",\"ald\",\"ale\",\"alf\",\"alg\",\"alh\",\"ali\",\"alj\",\"alk\",\"all\",\"alm\",\"aln\",\"alo\",\"alp\",\"alq\",\"alr\",\"als\",\"alt\",\"alu\",\"alv\",\"alw\",\"alx\",\"aly\",\"alz\",\"ama\",\"amb\",\"amc\",\"ame\",\"amf\",\"amg\",\"ami\",\"amj\",\"amk\",\"aml\",\"amm\",\"amn\",\"amo\",\"amp\",\"amq\",\"amr\",\"ams\",\"amt\",\"amu\",\"amv\",\"amw\",\"amx\",\"amy\",\"amz\",\"ana\",\"anb\",\"anc\",\"and\",\"ane\",\"anf\",\"ang\",\"anh\",\"ani\",\"anj\",\"ank\",\"anl\",\"anm\",\"ann\",\"ano\",\"anp\",\"anq\",\"anr\",\"ans\",\"ant\",\"anu\",\"anv\",\"anw\",\"anx\",\"any\",\"anz\",\"aoa\",\"aob\",\"aoc\",\"aod\",\"aoe\",\"aof\",\"aog\",\"aoh\",\"aoi\",\"aoj\",\"aok\",\"aol\",\"aom\",\"aon\",\"aor\",\"aos\",\"aot\",\"aou\",\"aox\",\"aoz\",\"apa\",\"apb\",\"apc\",\"apd\",\"ape\",\"apf\",\"apg\",\"aph\",\"api\",\"apj\",\"apk\",\"apl\",\"apm\",\"apn\",\"apo\",\"app\",\"apq\",\"apr\",\"aps\",\"apt\",\"apu\",\"apv\",\"apw\",\"apx\",\"apy\",\"apz\",\"aqa\",\"aqc\",\"aqd\",\"aqg\",\"aql\",\"aqm\",\"aqn\",\"aqp\",\"aqr\",\"aqt\",\"aqz\",\"arb\",\"arc\",\"ard\",\"are\",\"arh\",\"ari\",\"arj\",\"ark\",\"arl\",\"arn\",\"aro\",\"arp\",\"arq\",\"arr\",\"ars\",\"art\",\"aru\",\"arv\",\"arw\",\"arx\",\"ary\",\"arz\",\"asa\",\"asb\",\"asc\",\"asd\",\"ase\",\"asf\",\"asg\",\"ash\",\"asi\",\"asj\",\"ask\",\"asl\",\"asn\",\"aso\",\"asp\",\"asq\",\"asr\",\"ass\",\"ast\",\"asu\",\"asv\",\"asw\",\"asx\",\"asy\",\"asz\",\"ata\",\"atb\",\"atc\",\"atd\",\"ate\",\"atg\",\"ath\",\"ati\",\"atj\",\"atk\",\"atl\",\"atm\",\"atn\",\"ato\",\"atp\",\"atq\",\"atr\",\"ats\",\"att\",\"atu\",\"atv\",\"atw\",\"atx\",\"aty\",\"atz\",\"aua\",\"aub\",\"auc\",\"aud\",\"aue\",\"auf\",\"aug\",\"auh\",\"aui\",\"auj\",\"auk\",\"aul\",\"aum\",\"aun\",\"auo\",\"aup\",\"auq\",\"aur\",\"aus\",\"aut\",\"auu\",\"auw\",\"aux\",\"auy\",\"auz\",\"avb\",\"avd\",\"avi\",\"avk\",\"avl\",\"avm\",\"avn\",\"avo\",\"avs\",\"avt\",\"avu\",\"avv\",\"awa\",\"awb\",\"awc\",\"awd\",\"awe\",\"awg\",\"awh\",\"awi\",\"awk\",\"awm\",\"awn\",\"awo\",\"awr\",\"aws\",\"awt\",\"awu\",\"awv\",\"aww\",\"awx\",\"awy\",\"axb\",\"axe\",\"axg\",\"axk\",\"axl\",\"axm\",\"axx\",\"aya\",\"ayb\",\"ayc\",\"ayd\",\"aye\",\"ayg\",\"ayh\",\"ayi\",\"ayk\",\"ayl\",\"ayn\",\"ayo\",\"ayp\",\"ayq\",\"ayr\",\"ays\",\"ayt\",\"ayu\",\"ayx\",\"ayy\",\"ayz\",\"aza\",\"azb\",\"azc\",\"azd\",\"azg\",\"azj\",\"azm\",\"azn\",\"azo\",\"azt\",\"azz\",\"baa\",\"bab\",\"bac\",\"bad\",\"bae\",\"baf\",\"bag\",\"bah\",\"bai\",\"baj\",\"bal\",\"ban\",\"bao\",\"bap\",\"bar\",\"bas\",\"bat\",\"bau\",\"bav\",\"baw\",\"bax\",\"bay\",\"baz\",\"bba\",\"bbb\",\"bbc\",\"bbd\",\"bbe\",\"bbf\",\"bbg\",\"bbh\",\"bbi\",\"bbj\",\"bbk\",\"bbl\",\"bbm\",\"bbn\",\"bbo\",\"bbp\",\"bbq\",\"bbr\",\"bbs\",\"bbt\",\"bbu\",\"bbv\",\"bbw\",\"bbx\",\"bby\",\"bbz\",\"bca\",\"bcb\",\"bcc\",\"bcd\",\"bce\",\"bcf\",\"bcg\",\"bch\",\"bci\",\"bcj\",\"bck\",\"bcl\",\"bcm\",\"bcn\",\"bco\",\"bcp\",\"bcq\",\"bcr\",\"bcs\",\"bct\",\"bcu\",\"bcv\",\"bcw\",\"bcy\",\"bcz\",\"bda\",\"bdb\",\"bdc\",\"bdd\",\"bde\",\"bdf\",\"bdg\",\"bdh\",\"bdi\",\"bdj\",\"bdk\",\"bdl\",\"bdm\",\"bdn\",\"bdo\",\"bdp\",\"bdq\",\"bdr\",\"bds\",\"bdt\",\"bdu\",\"bdv\",\"bdw\",\"bdx\",\"bdy\",\"bdz\",\"bea\",\"beb\",\"bec\",\"bed\",\"bee\",\"bef\",\"beg\",\"beh\",\"bei\",\"bej\",\"bek\",\"bem\",\"beo\",\"bep\",\"beq\",\"ber\",\"bes\",\"bet\",\"beu\",\"bev\",\"bew\",\"bex\",\"bey\",\"bez\",\"bfa\",\"bfb\",\"bfc\",\"bfd\",\"bfe\",\"bff\",\"bfg\",\"bfh\",\"bfi\",\"bfj\",\"bfk\",\"bfl\",\"bfm\",\"bfn\",\"bfo\",\"bfp\",\"bfq\",\"bfr\",\"bfs\",\"bft\",\"bfu\",\"bfw\",\"bfx\",\"bfy\",\"bfz\",\"bga\",\"bgb\",\"bgc\",\"bgd\",\"bge\",\"bgf\",\"bgg\",\"bgi\",\"bgj\",\"bgk\",\"bgl\",\"bgm\",\"bgn\",\"bgo\",\"bgp\",\"bgq\",\"bgr\",\"bgs\",\"bgt\",\"bgu\",\"bgv\",\"bgw\",\"bgx\",\"bgy\",\"bgz\",\"bha\",\"bhb\",\"bhc\",\"bhd\",\"bhe\",\"bhf\",\"bhg\",\"bhh\",\"bhi\",\"bhj\",\"bhk\",\"bhl\",\"bhm\",\"bhn\",\"bho\",\"bhp\",\"bhq\",\"bhr\",\"bhs\",\"bht\",\"bhu\",\"bhv\",\"bhw\",\"bhx\",\"bhy\",\"bhz\",\"bia\",\"bib\",\"bic\",\"bid\",\"bie\",\"bif\",\"big\",\"bij\",\"bik\",\"bil\",\"bim\",\"bin\",\"bio\",\"bip\",\"biq\",\"bir\",\"bit\",\"biu\",\"biv\",\"biw\",\"bix\",\"biy\",\"biz\",\"bja\",\"bjb\",\"bjc\",\"bjd\",\"bje\",\"bjf\",\"bjg\",\"bjh\",\"bji\",\"bjj\",\"bjk\",\"bjl\",\"bjm\",\"bjn\",\"bjo\",\"bjp\",\"bjq\",\"bjr\",\"bjs\",\"bjt\",\"bju\",\"bjv\",\"bjw\",\"bjx\",\"bjy\",\"bjz\",\"bka\",\"bkb\",\"bkc\",\"bkd\",\"bkf\",\"bkg\",\"bkh\",\"bki\",\"bkj\",\"bkk\",\"bkl\",\"bkm\",\"bkn\",\"bko\",\"bkp\",\"bkq\",\"bkr\",\"bks\",\"bkt\",\"bku\",\"bkv\",\"bkw\",\"bkx\",\"bky\",\"bkz\",\"bla\",\"blb\",\"blc\",\"bld\",\"ble\",\"blf\",\"blg\",\"blh\",\"bli\",\"blj\",\"blk\",\"bll\",\"blm\",\"bln\",\"blo\",\"blp\",\"blq\",\"blr\",\"bls\",\"blt\",\"blv\",\"blw\",\"blx\",\"bly\",\"blz\",\"bma\",\"bmb\",\"bmc\",\"bmd\",\"bme\",\"bmf\",\"bmg\",\"bmh\",\"bmi\",\"bmj\",\"bmk\",\"bml\",\"bmm\",\"bmn\",\"bmo\",\"bmp\",\"bmq\",\"bmr\",\"bms\",\"bmt\",\"bmu\",\"bmv\",\"bmw\",\"bmx\",\"bmy\",\"bmz\",\"bna\",\"bnb\",\"bnc\",\"bnd\",\"bne\",\"bnf\",\"bng\",\"bni\",\"bnj\",\"bnk\",\"bnl\",\"bnm\",\"bnn\",\"bno\",\"bnp\",\"bnq\",\"bnr\",\"bns\",\"bnt\",\"bnu\",\"bnv\",\"bnw\",\"bnx\",\"bny\",\"bnz\",\"boa\",\"bob\",\"boe\",\"bof\",\"bog\",\"boh\",\"boi\",\"boj\",\"bok\",\"bol\",\"bom\",\"bon\",\"boo\",\"bop\",\"boq\",\"bor\",\"bot\",\"bou\",\"bov\",\"bow\",\"box\",\"boy\",\"boz\",\"bpa\",\"bpb\",\"bpd\",\"bpg\",\"bph\",\"bpi\",\"bpj\",\"bpk\",\"bpl\",\"bpm\",\"bpn\",\"bpo\",\"bpp\",\"bpq\",\"bpr\",\"bps\",\"bpt\",\"bpu\",\"bpv\",\"bpw\",\"bpx\",\"bpy\",\"bpz\",\"bqa\",\"bqb\",\"bqc\",\"bqd\",\"bqf\",\"bqg\",\"bqh\",\"bqi\",\"bqj\",\"bqk\",\"bql\",\"bqm\",\"bqn\",\"bqo\",\"bqp\",\"bqq\",\"bqr\",\"bqs\",\"bqt\",\"bqu\",\"bqv\",\"bqw\",\"bqx\",\"bqy\",\"bqz\",\"bra\",\"brb\",\"brc\",\"brd\",\"brf\",\"brg\",\"brh\",\"bri\",\"brj\",\"brk\",\"brl\",\"brm\",\"brn\",\"bro\",\"brp\",\"brq\",\"brr\",\"brs\",\"brt\",\"bru\",\"brv\",\"brw\",\"brx\",\"bry\",\"brz\",\"bsa\",\"bsb\",\"bsc\",\"bse\",\"bsf\",\"bsg\",\"bsh\",\"bsi\",\"bsj\",\"bsk\",\"bsl\",\"bsm\",\"bsn\",\"bso\",\"bsp\",\"bsq\",\"bsr\",\"bss\",\"bst\",\"bsu\",\"bsv\",\"bsw\",\"bsx\",\"bsy\",\"bta\",\"btb\",\"btc\",\"btd\",\"bte\",\"btf\",\"btg\",\"bth\",\"bti\",\"btj\",\"btk\",\"btl\",\"btm\",\"btn\",\"bto\",\"btp\",\"btq\",\"btr\",\"bts\",\"btt\",\"btu\",\"btv\",\"btw\",\"btx\",\"bty\",\"btz\",\"bua\",\"bub\",\"buc\",\"bud\",\"bue\",\"buf\",\"bug\",\"buh\",\"bui\",\"buj\",\"buk\",\"bum\",\"bun\",\"buo\",\"bup\",\"buq\",\"bus\",\"but\",\"buu\",\"buv\",\"buw\",\"bux\",\"buy\",\"buz\",\"bva\",\"bvb\",\"bvc\",\"bvd\",\"bve\",\"bvf\",\"bvg\",\"bvh\",\"bvi\",\"bvj\",\"bvk\",\"bvl\",\"bvm\",\"bvn\",\"bvo\",\"bvp\",\"bvq\",\"bvr\",\"bvt\",\"bvu\",\"bvv\",\"bvw\",\"bvx\",\"bvy\",\"bvz\",\"bwa\",\"bwb\",\"bwc\",\"bwd\",\"bwe\",\"bwf\",\"bwg\",\"bwh\",\"bwi\",\"bwj\",\"bwk\",\"bwl\",\"bwm\",\"bwn\",\"bwo\",\"bwp\",\"bwq\",\"bwr\",\"bws\",\"bwt\",\"bwu\",\"bww\",\"bwx\",\"bwy\",\"bwz\",\"bxa\",\"bxb\",\"bxc\",\"bxd\",\"bxe\",\"bxf\",\"bxg\",\"bxh\",\"bxi\",\"bxj\",\"bxk\",\"bxl\",\"bxm\",\"bxn\",\"bxo\",\"bxp\",\"bxq\",\"bxr\",\"bxs\",\"bxu\",\"bxv\",\"bxw\",\"bxx\",\"bxz\",\"bya\",\"byb\",\"byc\",\"byd\",\"bye\",\"byf\",\"byg\",\"byh\",\"byi\",\"byj\",\"byk\",\"byl\",\"bym\",\"byn\",\"byo\",\"byp\",\"byq\",\"byr\",\"bys\",\"byt\",\"byv\",\"byw\",\"byx\",\"byy\",\"byz\",\"bza\",\"bzb\",\"bzc\",\"bzd\",\"bze\",\"bzf\",\"bzg\",\"bzh\",\"bzi\",\"bzj\",\"bzk\",\"bzl\",\"bzm\",\"bzn\",\"bzo\",\"bzp\",\"bzq\",\"bzr\",\"bzs\",\"bzt\",\"bzu\",\"bzv\",\"bzw\",\"bzx\",\"bzy\",\"bzz\",\"caa\",\"cab\",\"cac\",\"cad\",\"cae\",\"caf\",\"cag\",\"cah\",\"cai\",\"caj\",\"cak\",\"cal\",\"cam\",\"can\",\"cao\",\"cap\",\"caq\",\"car\",\"cas\",\"cau\",\"cav\",\"caw\",\"cax\",\"cay\",\"caz\",\"cba\",\"cbb\",\"cbc\",\"cbd\",\"cbe\",\"cbg\",\"cbh\",\"cbi\",\"cbj\",\"cbk\",\"cbl\",\"cbn\",\"cbo\",\"cbq\",\"cbr\",\"cbs\",\"cbt\",\"cbu\",\"cbv\",\"cbw\",\"cby\",\"cca\",\"ccc\",\"ccd\",\"cce\",\"ccg\",\"cch\",\"ccj\",\"ccl\",\"ccm\",\"ccn\",\"cco\",\"ccp\",\"ccq\",\"ccr\",\"ccs\",\"cda\",\"cdc\",\"cdd\",\"cde\",\"cdf\",\"cdg\",\"cdh\",\"cdi\",\"cdj\",\"cdm\",\"cdn\",\"cdo\",\"cdr\",\"cds\",\"cdy\",\"cdz\",\"cea\",\"ceb\",\"ceg\",\"cek\",\"cel\",\"cen\",\"cet\",\"cfa\",\"cfd\",\"cfg\",\"cfm\",\"cga\",\"cgc\",\"cgg\",\"cgk\",\"chb\",\"chc\",\"chd\",\"chf\",\"chg\",\"chh\",\"chj\",\"chk\",\"chl\",\"chm\",\"chn\",\"cho\",\"chp\",\"chq\",\"chr\",\"cht\",\"chw\",\"chx\",\"chy\",\"chz\",\"cia\",\"cib\",\"cic\",\"cid\",\"cie\",\"cih\",\"cik\",\"cim\",\"cin\",\"cip\",\"cir\",\"ciw\",\"ciy\",\"cja\",\"cje\",\"cjh\",\"cji\",\"cjk\",\"cjm\",\"cjn\",\"cjo\",\"cjp\",\"cjr\",\"cjs\",\"cjv\",\"cjy\",\"cka\",\"ckb\",\"ckh\",\"ckl\",\"ckn\",\"cko\",\"ckq\",\"ckr\",\"cks\",\"ckt\",\"cku\",\"ckv\",\"ckx\",\"cky\",\"ckz\",\"cla\",\"clc\",\"cld\",\"cle\",\"clh\",\"cli\",\"clj\",\"clk\",\"cll\",\"clm\",\"clo\",\"clt\",\"clu\",\"clw\",\"cly\",\"cma\",\"cmc\",\"cme\",\"cmg\",\"cmi\",\"cmk\",\"cml\",\"cmm\",\"cmn\",\"cmo\",\"cmr\",\"cms\",\"cmt\",\"cna\",\"cnb\",\"cnc\",\"cng\",\"cnh\",\"cni\",\"cnk\",\"cnl\",\"cno\",\"cns\",\"cnt\",\"cnu\",\"cnw\",\"cnx\",\"coa\",\"cob\",\"coc\",\"cod\",\"coe\",\"cof\",\"cog\",\"coh\",\"coj\",\"cok\",\"col\",\"com\",\"con\",\"coo\",\"cop\",\"coq\",\"cot\",\"cou\",\"cov\",\"cow\",\"cox\",\"coy\",\"coz\",\"cpa\",\"cpb\",\"cpc\",\"cpe\",\"cpf\",\"cpg\",\"cpi\",\"cpn\",\"cpo\",\"cpp\",\"cps\",\"cpu\",\"cpx\",\"cpy\",\"cqd\",\"cqu\",\"cra\",\"crb\",\"crc\",\"crd\",\"crf\",\"crg\",\"crh\",\"cri\",\"crj\",\"crk\",\"crl\",\"crm\",\"crn\",\"cro\",\"crp\",\"crq\",\"crr\",\"crs\",\"crt\",\"crv\",\"crw\",\"crx\",\"cry\",\"crz\",\"csa\",\"csb\",\"csc\",\"csd\",\"cse\",\"csf\",\"csg\",\"csh\",\"csi\",\"csj\",\"csk\",\"csl\",\"csm\",\"csn\",\"cso\",\"csq\",\"csr\",\"css\",\"cst\",\"csu\",\"csv\",\"csw\",\"csy\",\"csz\",\"cta\",\"ctc\",\"ctd\",\"cte\",\"ctg\",\"cth\",\"ctl\",\"ctm\",\"ctn\",\"cto\",\"ctp\",\"cts\",\"ctt\",\"ctu\",\"ctz\",\"cua\",\"cub\",\"cuc\",\"cug\",\"cuh\",\"cui\",\"cuj\",\"cuk\",\"cul\",\"cum\",\"cuo\",\"cup\",\"cuq\",\"cur\",\"cus\",\"cut\",\"cuu\",\"cuv\",\"cuw\",\"cux\",\"cvg\",\"cvn\",\"cwa\",\"cwb\",\"cwd\",\"cwe\",\"cwg\",\"cwt\",\"cya\",\"cyb\",\"cyo\",\"czh\",\"czk\",\"czn\",\"czo\",\"czt\",\"daa\",\"dac\",\"dad\",\"dae\",\"daf\",\"dag\",\"dah\",\"dai\",\"daj\",\"dak\",\"dal\",\"dam\",\"dao\",\"dap\",\"daq\",\"dar\",\"das\",\"dau\",\"dav\",\"daw\",\"dax\",\"day\",\"daz\",\"dba\",\"dbb\",\"dbd\",\"dbe\",\"dbf\",\"dbg\",\"dbi\",\"dbj\",\"dbl\",\"dbm\",\"dbn\",\"dbo\",\"dbp\",\"dbq\",\"dbr\",\"dbt\",\"dbu\",\"dbv\",\"dbw\",\"dby\",\"dcc\",\"dcr\",\"dda\",\"ddd\",\"dde\",\"ddg\",\"ddi\",\"ddj\",\"ddn\",\"ddo\",\"ddr\",\"dds\",\"ddw\",\"dec\",\"ded\",\"dee\",\"def\",\"deg\",\"deh\",\"dei\",\"dek\",\"del\",\"dem\",\"den\",\"dep\",\"deq\",\"der\",\"des\",\"dev\",\"dez\",\"dga\",\"dgb\",\"dgc\",\"dgd\",\"dge\",\"dgg\",\"dgh\",\"dgi\",\"dgk\",\"dgl\",\"dgn\",\"dgo\",\"dgr\",\"dgs\",\"dgt\",\"dgu\",\"dgw\",\"dgx\",\"dgz\",\"dha\",\"dhd\",\"dhg\",\"dhi\",\"dhl\",\"dhm\",\"dhn\",\"dho\",\"dhr\",\"dhs\",\"dhu\",\"dhv\",\"dhw\",\"dhx\",\"dia\",\"dib\",\"dic\",\"did\",\"dif\",\"dig\",\"dih\",\"dii\",\"dij\",\"dik\",\"dil\",\"dim\",\"din\",\"dio\",\"dip\",\"diq\",\"dir\",\"dis\",\"dit\",\"diu\",\"diw\",\"dix\",\"diy\",\"diz\",\"dja\",\"djb\",\"djc\",\"djd\",\"dje\",\"djf\",\"dji\",\"djj\",\"djk\",\"djl\",\"djm\",\"djn\",\"djo\",\"djr\",\"dju\",\"djw\",\"dka\",\"dkk\",\"dkl\",\"dkr\",\"dks\",\"dkx\",\"dlg\",\"dlk\",\"dlm\",\"dln\",\"dma\",\"dmb\",\"dmc\",\"dmd\",\"dme\",\"dmg\",\"dmk\",\"dml\",\"dmm\",\"dmn\",\"dmo\",\"dmr\",\"dms\",\"dmu\",\"dmv\",\"dmw\",\"dmx\",\"dmy\",\"dna\",\"dnd\",\"dne\",\"dng\",\"dni\",\"dnj\",\"dnk\",\"dnn\",\"dnr\",\"dnt\",\"dnu\",\"dnv\",\"dnw\",\"dny\",\"doa\",\"dob\",\"doc\",\"doe\",\"dof\",\"doh\",\"doi\",\"dok\",\"dol\",\"don\",\"doo\",\"dop\",\"doq\",\"dor\",\"dos\",\"dot\",\"dov\",\"dow\",\"dox\",\"doy\",\"doz\",\"dpp\",\"dra\",\"drb\",\"drc\",\"drd\",\"dre\",\"drg\",\"drh\",\"dri\",\"drl\",\"drn\",\"dro\",\"drq\",\"drr\",\"drs\",\"drt\",\"dru\",\"drw\",\"dry\",\"dsb\",\"dse\",\"dsh\",\"dsi\",\"dsl\",\"dsn\",\"dso\",\"dsq\",\"dta\",\"dtb\",\"dtd\",\"dth\",\"dti\",\"dtk\",\"dtm\",\"dtn\",\"dto\",\"dtp\",\"dtr\",\"dts\",\"dtt\",\"dtu\",\"dty\",\"dua\",\"dub\",\"duc\",\"dud\",\"due\",\"duf\",\"dug\",\"duh\",\"dui\",\"duj\",\"duk\",\"dul\",\"dum\",\"dun\",\"duo\",\"dup\",\"duq\",\"dur\",\"dus\",\"duu\",\"duv\",\"duw\",\"dux\",\"duy\",\"duz\",\"dva\",\"dwa\",\"dwl\",\"dwr\",\"dws\",\"dwu\",\"dww\",\"dwy\",\"dya\",\"dyb\",\"dyd\",\"dyg\",\"dyi\",\"dym\",\"dyn\",\"dyo\",\"dyu\",\"dyy\",\"dza\",\"dzd\",\"dze\",\"dzg\",\"dzl\",\"dzn\",\"eaa\",\"ebg\",\"ebk\",\"ebo\",\"ebr\",\"ebu\",\"ecr\",\"ecs\",\"ecy\",\"eee\",\"efa\",\"efe\",\"efi\",\"ega\",\"egl\",\"ego\",\"egx\",\"egy\",\"ehu\",\"eip\",\"eit\",\"eiv\",\"eja\",\"eka\",\"ekc\",\"eke\",\"ekg\",\"eki\",\"ekk\",\"ekl\",\"ekm\",\"eko\",\"ekp\",\"ekr\",\"eky\",\"ele\",\"elh\",\"eli\",\"elk\",\"elm\",\"elo\",\"elp\",\"elu\",\"elx\",\"ema\",\"emb\",\"eme\",\"emg\",\"emi\",\"emk\",\"emm\",\"emn\",\"emo\",\"emp\",\"ems\",\"emu\",\"emw\",\"emx\",\"emy\",\"ena\",\"enb\",\"enc\",\"end\",\"enf\",\"enh\",\"enl\",\"enm\",\"enn\",\"eno\",\"enq\",\"enr\",\"enu\",\"env\",\"enw\",\"enx\",\"eot\",\"epi\",\"era\",\"erg\",\"erh\",\"eri\",\"erk\",\"ero\",\"err\",\"ers\",\"ert\",\"erw\",\"ese\",\"esg\",\"esh\",\"esi\",\"esk\",\"esl\",\"esm\",\"esn\",\"eso\",\"esq\",\"ess\",\"esu\",\"esx\",\"esy\",\"etb\",\"etc\",\"eth\",\"etn\",\"eto\",\"etr\",\"ets\",\"ett\",\"etu\",\"etx\",\"etz\",\"euq\",\"eve\",\"evh\",\"evn\",\"ewo\",\"ext\",\"eya\",\"eyo\",\"eza\",\"eze\",\"faa\",\"fab\",\"fad\",\"faf\",\"fag\",\"fah\",\"fai\",\"faj\",\"fak\",\"fal\",\"fam\",\"fan\",\"fap\",\"far\",\"fat\",\"fau\",\"fax\",\"fay\",\"faz\",\"fbl\",\"fcs\",\"fer\",\"ffi\",\"ffm\",\"fgr\",\"fia\",\"fie\",\"fil\",\"fip\",\"fir\",\"fit\",\"fiu\",\"fiw\",\"fkk\",\"fkv\",\"fla\",\"flh\",\"fli\",\"fll\",\"fln\",\"flr\",\"fly\",\"fmp\",\"fmu\",\"fnb\",\"fng\",\"fni\",\"fod\",\"foi\",\"fom\",\"fon\",\"for\",\"fos\",\"fox\",\"fpe\",\"fqs\",\"frc\",\"frd\",\"frk\",\"frm\",\"fro\",\"frp\",\"frq\",\"frr\",\"frs\",\"frt\",\"fse\",\"fsl\",\"fss\",\"fub\",\"fuc\",\"fud\",\"fue\",\"fuf\",\"fuh\",\"fui\",\"fuj\",\"fum\",\"fun\",\"fuq\",\"fur\",\"fut\",\"fuu\",\"fuv\",\"fuy\",\"fvr\",\"fwa\",\"fwe\",\"gaa\",\"gab\",\"gac\",\"gad\",\"gae\",\"gaf\",\"gag\",\"gah\",\"gai\",\"gaj\",\"gak\",\"gal\",\"gam\",\"gan\",\"gao\",\"gap\",\"gaq\",\"gar\",\"gas\",\"gat\",\"gau\",\"gav\",\"gaw\",\"gax\",\"gay\",\"gaz\",\"gba\",\"gbb\",\"gbc\",\"gbd\",\"gbe\",\"gbf\",\"gbg\",\"gbh\",\"gbi\",\"gbj\",\"gbk\",\"gbl\",\"gbm\",\"gbn\",\"gbo\",\"gbp\",\"gbq\",\"gbr\",\"gbs\",\"gbu\",\"gbv\",\"gbw\",\"gbx\",\"gby\",\"gbz\",\"gcc\",\"gcd\",\"gce\",\"gcf\",\"gcl\",\"gcn\",\"gcr\",\"gct\",\"gda\",\"gdb\",\"gdc\",\"gdd\",\"gde\",\"gdf\",\"gdg\",\"gdh\",\"gdi\",\"gdj\",\"gdk\",\"gdl\",\"gdm\",\"gdn\",\"gdo\",\"gdq\",\"gdr\",\"gds\",\"gdt\",\"gdu\",\"gdx\",\"gea\",\"geb\",\"gec\",\"ged\",\"geg\",\"geh\",\"gei\",\"gej\",\"gek\",\"gel\",\"gem\",\"geq\",\"ges\",\"gev\",\"gew\",\"gex\",\"gey\",\"gez\",\"gfk\",\"gft\",\"gfx\",\"gga\",\"ggb\",\"ggd\",\"gge\",\"ggg\",\"ggk\",\"ggl\",\"ggn\",\"ggo\",\"ggr\",\"ggt\",\"ggu\",\"ggw\",\"gha\",\"ghc\",\"ghe\",\"ghh\",\"ghk\",\"ghl\",\"ghn\",\"gho\",\"ghr\",\"ghs\",\"ght\",\"gia\",\"gib\",\"gic\",\"gid\",\"gie\",\"gig\",\"gih\",\"gil\",\"gim\",\"gin\",\"gio\",\"gip\",\"giq\",\"gir\",\"gis\",\"git\",\"giu\",\"giw\",\"gix\",\"giy\",\"giz\",\"gji\",\"gjk\",\"gjm\",\"gjn\",\"gjr\",\"gju\",\"gka\",\"gke\",\"gkn\",\"gko\",\"gkp\",\"gku\",\"glc\",\"gld\",\"glh\",\"gli\",\"glj\",\"glk\",\"gll\",\"glo\",\"glr\",\"glu\",\"glw\",\"gly\",\"gma\",\"gmb\",\"gmd\",\"gme\",\"gmg\",\"gmh\",\"gml\",\"gmm\",\"gmn\",\"gmq\",\"gmu\",\"gmv\",\"gmw\",\"gmx\",\"gmy\",\"gmz\",\"gna\",\"gnb\",\"gnc\",\"gnd\",\"gne\",\"gng\",\"gnh\",\"gni\",\"gnk\",\"gnl\",\"gnm\",\"gnn\",\"gno\",\"gnq\",\"gnr\",\"gnt\",\"gnu\",\"gnw\",\"gnz\",\"goa\",\"gob\",\"goc\",\"god\",\"goe\",\"gof\",\"gog\",\"goh\",\"goi\",\"goj\",\"gok\",\"gol\",\"gom\",\"gon\",\"goo\",\"gop\",\"goq\",\"gor\",\"gos\",\"got\",\"gou\",\"gow\",\"gox\",\"goy\",\"goz\",\"gpa\",\"gpe\",\"gpn\",\"gqa\",\"gqi\",\"gqn\",\"gqr\",\"gqu\",\"gra\",\"grb\",\"grc\",\"grd\",\"grg\",\"grh\",\"gri\",\"grj\",\"grk\",\"grm\",\"gro\",\"grq\",\"grr\",\"grs\",\"grt\",\"gru\",\"grv\",\"grw\",\"grx\",\"gry\",\"grz\",\"gse\",\"gsg\",\"gsl\",\"gsm\",\"gsn\",\"gso\",\"gsp\",\"gss\",\"gsw\",\"gta\",\"gti\",\"gtu\",\"gua\",\"gub\",\"guc\",\"gud\",\"gue\",\"guf\",\"gug\",\"guh\",\"gui\",\"guk\",\"gul\",\"gum\",\"gun\",\"guo\",\"gup\",\"guq\",\"gur\",\"gus\",\"gut\",\"guu\",\"guv\",\"guw\",\"gux\",\"guz\",\"gva\",\"gvc\",\"gve\",\"gvf\",\"gvj\",\"gvl\",\"gvm\",\"gvn\",\"gvo\",\"gvp\",\"gvr\",\"gvs\",\"gvy\",\"gwa\",\"gwb\",\"gwc\",\"gwd\",\"gwe\",\"gwf\",\"gwg\",\"gwi\",\"gwj\",\"gwm\",\"gwn\",\"gwr\",\"gwt\",\"gwu\",\"gww\",\"gwx\",\"gxx\",\"gya\",\"gyb\",\"gyd\",\"gye\",\"gyf\",\"gyg\",\"gyi\",\"gyl\",\"gym\",\"gyn\",\"gyr\",\"gyy\",\"gza\",\"gzi\",\"gzn\",\"haa\",\"hab\",\"hac\",\"had\",\"hae\",\"haf\",\"hag\",\"hah\",\"hai\",\"haj\",\"hak\",\"hal\",\"ham\",\"han\",\"hao\",\"hap\",\"haq\",\"har\",\"has\",\"hav\",\"haw\",\"hax\",\"hay\",\"haz\",\"hba\",\"hbb\",\"hbn\",\"hbo\",\"hbu\",\"hca\",\"hch\",\"hdn\",\"hds\",\"hdy\",\"hea\",\"hed\",\"heg\",\"heh\",\"hei\",\"hem\",\"hgm\",\"hgw\",\"hhi\",\"hhr\",\"hhy\",\"hia\",\"hib\",\"hid\",\"hif\",\"hig\",\"hih\",\"hii\",\"hij\",\"hik\",\"hil\",\"him\",\"hio\",\"hir\",\"hit\",\"hiw\",\"hix\",\"hji\",\"hka\",\"hke\",\"hkk\",\"hks\",\"hla\",\"hlb\",\"hld\",\"hle\",\"hlt\",\"hlu\",\"hma\",\"hmb\",\"hmc\",\"hmd\",\"hme\",\"hmf\",\"hmg\",\"hmh\",\"hmi\",\"hmj\",\"hmk\",\"hml\",\"hmm\",\"hmn\",\"hmp\",\"hmq\",\"hmr\",\"hms\",\"hmt\",\"hmu\",\"hmv\",\"hmw\",\"hmx\",\"hmy\",\"hmz\",\"hna\",\"hnd\",\"hne\",\"hnh\",\"hni\",\"hnj\",\"hnn\",\"hno\",\"hns\",\"hnu\",\"hoa\",\"hob\",\"hoc\",\"hod\",\"hoe\",\"hoh\",\"hoi\",\"hoj\",\"hok\",\"hol\",\"hom\",\"hoo\",\"hop\",\"hor\",\"hos\",\"hot\",\"hov\",\"how\",\"hoy\",\"hoz\",\"hpo\",\"hps\",\"hra\",\"hrc\",\"hre\",\"hrk\",\"hrm\",\"hro\",\"hrp\",\"hrr\",\"hrt\",\"hru\",\"hrw\",\"hrx\",\"hrz\",\"hsb\",\"hsh\",\"hsl\",\"hsn\",\"hss\",\"hti\",\"hto\",\"hts\",\"htu\",\"htx\",\"hub\",\"huc\",\"hud\",\"hue\",\"huf\",\"hug\",\"huh\",\"hui\",\"huj\",\"huk\",\"hul\",\"hum\",\"huo\",\"hup\",\"huq\",\"hur\",\"hus\",\"hut\",\"huu\",\"huv\",\"huw\",\"hux\",\"huy\",\"huz\",\"hvc\",\"hve\",\"hvk\",\"hvn\",\"hvv\",\"hwa\",\"hwc\",\"hwo\",\"hya\",\"hyx\",\"iai\",\"ian\",\"iap\",\"iar\",\"iba\",\"ibb\",\"ibd\",\"ibe\",\"ibg\",\"ibh\",\"ibi\",\"ibl\",\"ibm\",\"ibn\",\"ibr\",\"ibu\",\"iby\",\"ica\",\"ich\",\"icl\",\"icr\",\"ida\",\"idb\",\"idc\",\"idd\",\"ide\",\"idi\",\"idr\",\"ids\",\"idt\",\"idu\",\"ifa\",\"ifb\",\"ife\",\"iff\",\"ifk\",\"ifm\",\"ifu\",\"ify\",\"igb\",\"ige\",\"igg\",\"igl\",\"igm\",\"ign\",\"igo\",\"igs\",\"igw\",\"ihb\",\"ihi\",\"ihp\",\"ihw\",\"iin\",\"iir\",\"ijc\",\"ije\",\"ijj\",\"ijn\",\"ijo\",\"ijs\",\"ike\",\"iki\",\"ikk\",\"ikl\",\"iko\",\"ikp\",\"ikr\",\"iks\",\"ikt\",\"ikv\",\"ikw\",\"ikx\",\"ikz\",\"ila\",\"ilb\",\"ilg\",\"ili\",\"ilk\",\"ill\",\"ilm\",\"ilo\",\"ilp\",\"ils\",\"ilu\",\"ilv\",\"ilw\",\"ima\",\"ime\",\"imi\",\"iml\",\"imn\",\"imo\",\"imr\",\"ims\",\"imy\",\"inb\",\"inc\",\"ine\",\"ing\",\"inh\",\"inj\",\"inl\",\"inm\",\"inn\",\"ino\",\"inp\",\"ins\",\"int\",\"inz\",\"ior\",\"iou\",\"iow\",\"ipi\",\"ipo\",\"iqu\",\"iqw\",\"ira\",\"ire\",\"irh\",\"iri\",\"irk\",\"irn\",\"iro\",\"irr\",\"iru\",\"irx\",\"iry\",\"isa\",\"isc\",\"isd\",\"ise\",\"isg\",\"ish\",\"isi\",\"isk\",\"ism\",\"isn\",\"iso\",\"isr\",\"ist\",\"isu\",\"itb\",\"itc\",\"itd\",\"ite\",\"iti\",\"itk\",\"itl\",\"itm\",\"ito\",\"itr\",\"its\",\"itt\",\"itv\",\"itw\",\"itx\",\"ity\",\"itz\",\"ium\",\"ivb\",\"ivv\",\"iwk\",\"iwm\",\"iwo\",\"iws\",\"ixc\",\"ixl\",\"iya\",\"iyo\",\"iyx\",\"izh\",\"izi\",\"izr\",\"izz\",\"jaa\",\"jab\",\"jac\",\"jad\",\"jae\",\"jaf\",\"jah\",\"jaj\",\"jak\",\"jal\",\"jam\",\"jan\",\"jao\",\"jaq\",\"jar\",\"jas\",\"jat\",\"jau\",\"jax\",\"jay\",\"jaz\",\"jbe\",\"jbi\",\"jbj\",\"jbk\",\"jbn\",\"jbo\",\"jbr\",\"jbt\",\"jbu\",\"jbw\",\"jcs\",\"jct\",\"jda\",\"jdg\",\"jdt\",\"jeb\",\"jee\",\"jeg\",\"jeh\",\"jei\",\"jek\",\"jel\",\"jen\",\"jer\",\"jet\",\"jeu\",\"jgb\",\"jge\",\"jgk\",\"jgo\",\"jhi\",\"jhs\",\"jia\",\"jib\",\"jic\",\"jid\",\"jie\",\"jig\",\"jih\",\"jii\",\"jil\",\"jim\",\"jio\",\"jiq\",\"jit\",\"jiu\",\"jiv\",\"jiy\",\"jje\",\"jjr\",\"jka\",\"jkm\",\"jko\",\"jkp\",\"jkr\",\"jku\",\"jle\",\"jls\",\"jma\",\"jmb\",\"jmc\",\"jmd\",\"jmi\",\"jml\",\"jmn\",\"jmr\",\"jms\",\"jmw\",\"jmx\",\"jna\",\"jnd\",\"jng\",\"jni\",\"jnj\",\"jnl\",\"jns\",\"job\",\"jod\",\"jog\",\"jor\",\"jos\",\"jow\",\"jpa\",\"jpr\",\"jpx\",\"jqr\",\"jra\",\"jrb\",\"jrr\",\"jrt\",\"jru\",\"jsl\",\"jua\",\"jub\",\"juc\",\"jud\",\"juh\",\"jui\",\"juk\",\"jul\",\"jum\",\"jun\",\"juo\",\"jup\",\"jur\",\"jus\",\"jut\",\"juu\",\"juw\",\"juy\",\"jvd\",\"jvn\",\"jwi\",\"jya\",\"jye\",\"jyy\",\"kaa\",\"kab\",\"kac\",\"kad\",\"kae\",\"kaf\",\"kag\",\"kah\",\"kai\",\"kaj\",\"kak\",\"kam\",\"kao\",\"kap\",\"kaq\",\"kar\",\"kav\",\"kaw\",\"kax\",\"kay\",\"kba\",\"kbb\",\"kbc\",\"kbd\",\"kbe\",\"kbf\",\"kbg\",\"kbh\",\"kbi\",\"kbj\",\"kbk\",\"kbl\",\"kbm\",\"kbn\",\"kbo\",\"kbp\",\"kbq\",\"kbr\",\"kbs\",\"kbt\",\"kbu\",\"kbv\",\"kbw\",\"kbx\",\"kby\",\"kbz\",\"kca\",\"kcb\",\"kcc\",\"kcd\",\"kce\",\"kcf\",\"kcg\",\"kch\",\"kci\",\"kcj\",\"kck\",\"kcl\",\"kcm\",\"kcn\",\"kco\",\"kcp\",\"kcq\",\"kcr\",\"kcs\",\"kct\",\"kcu\",\"kcv\",\"kcw\",\"kcx\",\"kcy\",\"kcz\",\"kda\",\"kdc\",\"kdd\",\"kde\",\"kdf\",\"kdg\",\"kdh\",\"kdi\",\"kdj\",\"kdk\",\"kdl\",\"kdm\",\"kdn\",\"kdo\",\"kdp\",\"kdq\",\"kdr\",\"kdt\",\"kdu\",\"kdv\",\"kdw\",\"kdx\",\"kdy\",\"kdz\",\"kea\",\"keb\",\"kec\",\"ked\",\"kee\",\"kef\",\"keg\",\"keh\",\"kei\",\"kej\",\"kek\",\"kel\",\"kem\",\"ken\",\"keo\",\"kep\",\"keq\",\"ker\",\"kes\",\"ket\",\"keu\",\"kev\",\"kew\",\"kex\",\"key\",\"kez\",\"kfa\",\"kfb\",\"kfc\",\"kfd\",\"kfe\",\"kff\",\"kfg\",\"kfh\",\"kfi\",\"kfj\",\"kfk\",\"kfl\",\"kfm\",\"kfn\",\"kfo\",\"kfp\",\"kfq\",\"kfr\",\"kfs\",\"kft\",\"kfu\",\"kfv\",\"kfw\",\"kfx\",\"kfy\",\"kfz\",\"kga\",\"kgb\",\"kgc\",\"kgd\",\"kge\",\"kgf\",\"kgg\",\"kgh\",\"kgi\",\"kgj\",\"kgk\",\"kgl\",\"kgm\",\"kgn\",\"kgo\",\"kgp\",\"kgq\",\"kgr\",\"kgs\",\"kgt\",\"kgu\",\"kgv\",\"kgw\",\"kgx\",\"kgy\",\"kha\",\"khb\",\"khc\",\"khd\",\"khe\",\"khf\",\"khg\",\"khh\",\"khi\",\"khj\",\"khk\",\"khl\",\"khn\",\"kho\",\"khp\",\"khq\",\"khr\",\"khs\",\"kht\",\"khu\",\"khv\",\"khw\",\"khx\",\"khy\",\"khz\",\"kia\",\"kib\",\"kic\",\"kid\",\"kie\",\"kif\",\"kig\",\"kih\",\"kii\",\"kij\",\"kil\",\"kim\",\"kio\",\"kip\",\"kiq\",\"kis\",\"kit\",\"kiu\",\"kiv\",\"kiw\",\"kix\",\"kiy\",\"kiz\",\"kja\",\"kjb\",\"kjc\",\"kjd\",\"kje\",\"kjf\",\"kjg\",\"kjh\",\"kji\",\"kjj\",\"kjk\",\"kjl\",\"kjm\",\"kjn\",\"kjo\",\"kjp\",\"kjq\",\"kjr\",\"kjs\",\"kjt\",\"kju\",\"kjv\",\"kjx\",\"kjy\",\"kjz\",\"kka\",\"kkb\",\"kkc\",\"kkd\",\"kke\",\"kkf\",\"kkg\",\"kkh\",\"kki\",\"kkj\",\"kkk\",\"kkl\",\"kkm\",\"kkn\",\"kko\",\"kkp\",\"kkq\",\"kkr\",\"kks\",\"kkt\",\"kku\",\"kkv\",\"kkw\",\"kkx\",\"kky\",\"kkz\",\"kla\",\"klb\",\"klc\",\"kld\",\"kle\",\"klf\",\"klg\",\"klh\",\"kli\",\"klj\",\"klk\",\"kll\",\"klm\",\"kln\",\"klo\",\"klp\",\"klq\",\"klr\",\"kls\",\"klt\",\"klu\",\"klv\",\"klw\",\"klx\",\"kly\",\"klz\",\"kma\",\"kmb\",\"kmc\",\"kmd\",\"kme\",\"kmf\",\"kmg\",\"kmh\",\"kmi\",\"kmj\",\"kmk\",\"kml\",\"kmm\",\"kmn\",\"kmo\",\"kmp\",\"kmq\",\"kmr\",\"kms\",\"kmt\",\"kmu\",\"kmv\",\"kmw\",\"kmx\",\"kmy\",\"kmz\",\"kna\",\"knb\",\"knc\",\"knd\",\"kne\",\"knf\",\"kng\",\"kni\",\"knj\",\"knk\",\"knl\",\"knm\",\"knn\",\"kno\",\"knp\",\"knq\",\"knr\",\"kns\",\"knt\",\"knu\",\"knv\",\"knw\",\"knx\",\"kny\",\"knz\",\"koa\",\"koc\",\"kod\",\"koe\",\"kof\",\"kog\",\"koh\",\"koi\",\"koj\",\"kok\",\"kol\",\"koo\",\"kop\",\"koq\",\"kos\",\"kot\",\"kou\",\"kov\",\"kow\",\"kox\",\"koy\",\"koz\",\"kpa\",\"kpb\",\"kpc\",\"kpd\",\"kpe\",\"kpf\",\"kpg\",\"kph\",\"kpi\",\"kpj\",\"kpk\",\"kpl\",\"kpm\",\"kpn\",\"kpo\",\"kpp\",\"kpq\",\"kpr\",\"kps\",\"kpt\",\"kpu\",\"kpv\",\"kpw\",\"kpx\",\"kpy\",\"kpz\",\"kqa\",\"kqb\",\"kqc\",\"kqd\",\"kqe\",\"kqf\",\"kqg\",\"kqh\",\"kqi\",\"kqj\",\"kqk\",\"kql\",\"kqm\",\"kqn\",\"kqo\",\"kqp\",\"kqq\",\"kqr\",\"kqs\",\"kqt\",\"kqu\",\"kqv\",\"kqw\",\"kqx\",\"kqy\",\"kqz\",\"kra\",\"krb\",\"krc\",\"krd\",\"kre\",\"krf\",\"krh\",\"kri\",\"krj\",\"krk\",\"krl\",\"krm\",\"krn\",\"kro\",\"krp\",\"krr\",\"krs\",\"krt\",\"kru\",\"krv\",\"krw\",\"krx\",\"kry\",\"krz\",\"ksa\",\"ksb\",\"ksc\",\"ksd\",\"kse\",\"ksf\",\"ksg\",\"ksh\",\"ksi\",\"ksj\",\"ksk\",\"ksl\",\"ksm\",\"ksn\",\"kso\",\"ksp\",\"ksq\",\"ksr\",\"kss\",\"kst\",\"ksu\",\"ksv\",\"ksw\",\"ksx\",\"ksy\",\"ksz\",\"kta\",\"ktb\",\"ktc\",\"ktd\",\"kte\",\"ktf\",\"ktg\",\"kth\",\"kti\",\"ktj\",\"ktk\",\"ktl\",\"ktm\",\"ktn\",\"kto\",\"ktp\",\"ktq\",\"ktr\",\"kts\",\"ktt\",\"ktu\",\"ktv\",\"ktw\",\"ktx\",\"kty\",\"ktz\",\"kub\",\"kuc\",\"kud\",\"kue\",\"kuf\",\"kug\",\"kuh\",\"kui\",\"kuj\",\"kuk\",\"kul\",\"kum\",\"kun\",\"kuo\",\"kup\",\"kuq\",\"kus\",\"kut\",\"kuu\",\"kuv\",\"kuw\",\"kux\",\"kuy\",\"kuz\",\"kva\",\"kvb\",\"kvc\",\"kvd\",\"kve\",\"kvf\",\"kvg\",\"kvh\",\"kvi\",\"kvj\",\"kvk\",\"kvl\",\"kvm\",\"kvn\",\"kvo\",\"kvp\",\"kvq\",\"kvr\",\"kvs\",\"kvt\",\"kvu\",\"kvv\",\"kvw\",\"kvx\",\"kvy\",\"kvz\",\"kwa\",\"kwb\",\"kwc\",\"kwd\",\"kwe\",\"kwf\",\"kwg\",\"kwh\",\"kwi\",\"kwj\",\"kwk\",\"kwl\",\"kwm\",\"kwn\",\"kwo\",\"kwp\",\"kwq\",\"kwr\",\"kws\",\"kwt\",\"kwu\",\"kwv\",\"kww\",\"kwx\",\"kwy\",\"kwz\",\"kxa\",\"kxb\",\"kxc\",\"kxd\",\"kxe\",\"kxf\",\"kxh\",\"kxi\",\"kxj\",\"kxk\",\"kxl\",\"kxm\",\"kxn\",\"kxo\",\"kxp\",\"kxq\",\"kxr\",\"kxs\",\"kxt\",\"kxu\",\"kxv\",\"kxw\",\"kxx\",\"kxy\",\"kxz\",\"kya\",\"kyb\",\"kyc\",\"kyd\",\"kye\",\"kyf\",\"kyg\",\"kyh\",\"kyi\",\"kyj\",\"kyk\",\"kyl\",\"kym\",\"kyn\",\"kyo\",\"kyp\",\"kyq\",\"kyr\",\"kys\",\"kyt\",\"kyu\",\"kyv\",\"kyw\",\"kyx\",\"kyy\",\"kyz\",\"kza\",\"kzb\",\"kzc\",\"kzd\",\"kze\",\"kzf\",\"kzg\",\"kzh\",\"kzi\",\"kzj\",\"kzk\",\"kzl\",\"kzm\",\"kzn\",\"kzo\",\"kzp\",\"kzq\",\"kzr\",\"kzs\",\"kzt\",\"kzu\",\"kzv\",\"kzw\",\"kzx\",\"kzy\",\"kzz\",\"laa\",\"lab\",\"lac\",\"lad\",\"lae\",\"laf\",\"lag\",\"lah\",\"lai\",\"laj\",\"lak\",\"lal\",\"lam\",\"lan\",\"lap\",\"laq\",\"lar\",\"las\",\"lau\",\"law\",\"lax\",\"lay\",\"laz\",\"lba\",\"lbb\",\"lbc\",\"lbe\",\"lbf\",\"lbg\",\"lbi\",\"lbj\",\"lbk\",\"lbl\",\"lbm\",\"lbn\",\"lbo\",\"lbq\",\"lbr\",\"lbs\",\"lbt\",\"lbu\",\"lbv\",\"lbw\",\"lbx\",\"lby\",\"lbz\",\"lcc\",\"lcd\",\"lce\",\"lcf\",\"lch\",\"lcl\",\"lcm\",\"lcp\",\"lcq\",\"lcs\",\"lda\",\"ldb\",\"ldd\",\"ldg\",\"ldh\",\"ldi\",\"ldj\",\"ldk\",\"ldl\",\"ldm\",\"ldn\",\"ldo\",\"ldp\",\"ldq\",\"lea\",\"leb\",\"lec\",\"led\",\"lee\",\"lef\",\"leg\",\"leh\",\"lei\",\"lej\",\"lek\",\"lel\",\"lem\",\"len\",\"leo\",\"lep\",\"leq\",\"ler\",\"les\",\"let\",\"leu\",\"lev\",\"lew\",\"lex\",\"ley\",\"lez\",\"lfa\",\"lfn\",\"lga\",\"lgb\",\"lgg\",\"lgh\",\"lgi\",\"lgk\",\"lgl\",\"lgm\",\"lgn\",\"lgq\",\"lgr\",\"lgt\",\"lgu\",\"lgz\",\"lha\",\"lhh\",\"lhi\",\"lhl\",\"lhm\",\"lhn\",\"lhp\",\"lhs\",\"lht\",\"lhu\",\"lia\",\"lib\",\"lic\",\"lid\",\"lie\",\"lif\",\"lig\",\"lih\",\"lii\",\"lij\",\"lik\",\"lil\",\"lio\",\"lip\",\"liq\",\"lir\",\"lis\",\"liu\",\"liv\",\"liw\",\"lix\",\"liy\",\"liz\",\"lja\",\"lje\",\"lji\",\"ljl\",\"ljp\",\"ljw\",\"ljx\",\"lka\",\"lkb\",\"lkc\",\"lkd\",\"lke\",\"lkh\",\"lki\",\"lkj\",\"lkl\",\"lkm\",\"lkn\",\"lko\",\"lkr\",\"lks\",\"lkt\",\"lku\",\"lky\",\"lla\",\"llb\",\"llc\",\"lld\",\"lle\",\"llf\",\"llg\",\"llh\",\"lli\",\"llj\",\"llk\",\"lll\",\"llm\",\"lln\",\"llo\",\"llp\",\"llq\",\"lls\",\"llu\",\"llx\",\"lma\",\"lmb\",\"lmc\",\"lmd\",\"lme\",\"lmf\",\"lmg\",\"lmh\",\"lmi\",\"lmj\",\"lmk\",\"lml\",\"lmm\",\"lmn\",\"lmo\",\"lmp\",\"lmq\",\"lmr\",\"lmu\",\"lmv\",\"lmw\",\"lmx\",\"lmy\",\"lmz\",\"lna\",\"lnb\",\"lnd\",\"lng\",\"lnh\",\"lni\",\"lnj\",\"lnl\",\"lnm\",\"lnn\",\"lno\",\"lns\",\"lnu\",\"lnw\",\"lnz\",\"loa\",\"lob\",\"loc\",\"loe\",\"lof\",\"log\",\"loh\",\"loi\",\"loj\",\"lok\",\"lol\",\"lom\",\"lon\",\"loo\",\"lop\",\"loq\",\"lor\",\"los\",\"lot\",\"lou\",\"lov\",\"low\",\"lox\",\"loy\",\"loz\",\"lpa\",\"lpe\",\"lpn\",\"lpo\",\"lpx\",\"lra\",\"lrc\",\"lre\",\"lrg\",\"lri\",\"lrk\",\"lrl\",\"lrm\",\"lrn\",\"lro\",\"lrr\",\"lrt\",\"lrv\",\"lrz\",\"lsa\",\"lsd\",\"lse\",\"lsg\",\"lsh\",\"lsi\",\"lsl\",\"lsm\",\"lso\",\"lsp\",\"lsr\",\"lss\",\"lst\",\"lsy\",\"ltc\",\"ltg\",\"lth\",\"lti\",\"ltn\",\"lto\",\"lts\",\"ltu\",\"lua\",\"luc\",\"lud\",\"lue\",\"luf\",\"lui\",\"luj\",\"luk\",\"lul\",\"lum\",\"lun\",\"luo\",\"lup\",\"luq\",\"lur\",\"lus\",\"lut\",\"luu\",\"luv\",\"luw\",\"luy\",\"luz\",\"lva\",\"lvk\",\"lvs\",\"lvu\",\"lwa\",\"lwe\",\"lwg\",\"lwh\",\"lwl\",\"lwm\",\"lwo\",\"lwt\",\"lwu\",\"lww\",\"lya\",\"lyg\",\"lyn\",\"lzh\",\"lzl\",\"lzn\",\"lzz\",\"maa\",\"mab\",\"mad\",\"mae\",\"maf\",\"mag\",\"mai\",\"maj\",\"mak\",\"mam\",\"man\",\"map\",\"maq\",\"mas\",\"mat\",\"mau\",\"mav\",\"maw\",\"max\",\"maz\",\"mba\",\"mbb\",\"mbc\",\"mbd\",\"mbe\",\"mbf\",\"mbh\",\"mbi\",\"mbj\",\"mbk\",\"mbl\",\"mbm\",\"mbn\",\"mbo\",\"mbp\",\"mbq\",\"mbr\",\"mbs\",\"mbt\",\"mbu\",\"mbv\",\"mbw\",\"mbx\",\"mby\",\"mbz\",\"mca\",\"mcb\",\"mcc\",\"mcd\",\"mce\",\"mcf\",\"mcg\",\"mch\",\"mci\",\"mcj\",\"mck\",\"mcl\",\"mcm\",\"mcn\",\"mco\",\"mcp\",\"mcq\",\"mcr\",\"mcs\",\"mct\",\"mcu\",\"mcv\",\"mcw\",\"mcx\",\"mcy\",\"mcz\",\"mda\",\"mdb\",\"mdc\",\"mdd\",\"mde\",\"mdf\",\"mdg\",\"mdh\",\"mdi\",\"mdj\",\"mdk\",\"mdl\",\"mdm\",\"mdn\",\"mdp\",\"mdq\",\"mdr\",\"mds\",\"mdt\",\"mdu\",\"mdv\",\"mdw\",\"mdx\",\"mdy\",\"mdz\",\"mea\",\"meb\",\"mec\",\"med\",\"mee\",\"mef\",\"meg\",\"meh\",\"mei\",\"mej\",\"mek\",\"mel\",\"mem\",\"men\",\"meo\",\"mep\",\"meq\",\"mer\",\"mes\",\"met\",\"meu\",\"mev\",\"mew\",\"mey\",\"mez\",\"mfa\",\"mfb\",\"mfc\",\"mfd\",\"mfe\",\"mff\",\"mfg\",\"mfh\",\"mfi\",\"mfj\",\"mfk\",\"mfl\",\"mfm\",\"mfn\",\"mfo\",\"mfp\",\"mfq\",\"mfr\",\"mfs\",\"mft\",\"mfu\",\"mfv\",\"mfw\",\"mfx\",\"mfy\",\"mfz\",\"mga\",\"mgb\",\"mgc\",\"mgd\",\"mge\",\"mgf\",\"mgg\",\"mgh\",\"mgi\",\"mgj\",\"mgk\",\"mgl\",\"mgm\",\"mgn\",\"mgo\",\"mgp\",\"mgq\",\"mgr\",\"mgs\",\"mgt\",\"mgu\",\"mgv\",\"mgw\",\"mgx\",\"mgy\",\"mgz\",\"mha\",\"mhb\",\"mhc\",\"mhd\",\"mhe\",\"mhf\",\"mhg\",\"mhh\",\"mhi\",\"mhj\",\"mhk\",\"mhl\",\"mhm\",\"mhn\",\"mho\",\"mhp\",\"mhq\",\"mhr\",\"mhs\",\"mht\",\"mhu\",\"mhw\",\"mhx\",\"mhy\",\"mhz\",\"mia\",\"mib\",\"mic\",\"mid\",\"mie\",\"mif\",\"mig\",\"mih\",\"mii\",\"mij\",\"mik\",\"mil\",\"mim\",\"min\",\"mio\",\"mip\",\"miq\",\"mir\",\"mis\",\"mit\",\"miu\",\"miw\",\"mix\",\"miy\",\"miz\",\"mja\",\"mjb\",\"mjc\",\"mjd\",\"mje\",\"mjg\",\"mjh\",\"mji\",\"mjj\",\"mjk\",\"mjl\",\"mjm\",\"mjn\",\"mjo\",\"mjp\",\"mjq\",\"mjr\",\"mjs\",\"mjt\",\"mju\",\"mjv\",\"mjw\",\"mjx\",\"mjy\",\"mjz\",\"mka\",\"mkb\",\"mkc\",\"mke\",\"mkf\",\"mkg\",\"mkh\",\"mki\",\"mkj\",\"mkk\",\"mkl\",\"mkm\",\"mkn\",\"mko\",\"mkp\",\"mkq\",\"mkr\",\"mks\",\"mkt\",\"mku\",\"mkv\",\"mkw\",\"mkx\",\"mky\",\"mkz\",\"mla\",\"mlb\",\"mlc\",\"mld\",\"mle\",\"mlf\",\"mlh\",\"mli\",\"mlj\",\"mlk\",\"mll\",\"mlm\",\"mln\",\"mlo\",\"mlp\",\"mlq\",\"mlr\",\"mls\",\"mlu\",\"mlv\",\"mlw\",\"mlx\",\"mlz\",\"mma\",\"mmb\",\"mmc\",\"mmd\",\"mme\",\"mmf\",\"mmg\",\"mmh\",\"mmi\",\"mmj\",\"mmk\",\"mml\",\"mmm\",\"mmn\",\"mmo\",\"mmp\",\"mmq\",\"mmr\",\"mmt\",\"mmu\",\"mmv\",\"mmw\",\"mmx\",\"mmy\",\"mmz\",\"mna\",\"mnb\",\"mnc\",\"mnd\",\"mne\",\"mnf\",\"mng\",\"mnh\",\"mni\",\"mnj\",\"mnk\",\"mnl\",\"mnm\",\"mnn\",\"mno\",\"mnp\",\"mnq\",\"mnr\",\"mns\",\"mnt\",\"mnu\",\"mnv\",\"mnw\",\"mnx\",\"mny\",\"mnz\",\"moa\",\"moc\",\"mod\",\"moe\",\"mof\",\"mog\",\"moh\",\"moi\",\"moj\",\"mok\",\"mom\",\"moo\",\"mop\",\"moq\",\"mor\",\"mos\",\"mot\",\"mou\",\"mov\",\"mow\",\"mox\",\"moy\",\"moz\",\"mpa\",\"mpb\",\"mpc\",\"mpd\",\"mpe\",\"mpg\",\"mph\",\"mpi\",\"mpj\",\"mpk\",\"mpl\",\"mpm\",\"mpn\",\"mpo\",\"mpp\",\"mpq\",\"mpr\",\"mps\",\"mpt\",\"mpu\",\"mpv\",\"mpw\",\"mpx\",\"mpy\",\"mpz\",\"mqa\",\"mqb\",\"mqc\",\"mqe\",\"mqf\",\"mqg\",\"mqh\",\"mqi\",\"mqj\",\"mqk\",\"mql\",\"mqm\",\"mqn\",\"mqo\",\"mqp\",\"mqq\",\"mqr\",\"mqs\",\"mqt\",\"mqu\",\"mqv\",\"mqw\",\"mqx\",\"mqy\",\"mqz\",\"mra\",\"mrb\",\"mrc\",\"mrd\",\"mre\",\"mrf\",\"mrg\",\"mrh\",\"mrj\",\"mrk\",\"mrl\",\"mrm\",\"mrn\",\"mro\",\"mrp\",\"mrq\",\"mrr\",\"mrs\",\"mrt\",\"mru\",\"mrv\",\"mrw\",\"mrx\",\"mry\",\"mrz\",\"msb\",\"msc\",\"msd\",\"mse\",\"msf\",\"msg\",\"msh\",\"msi\",\"msj\",\"msk\",\"msl\",\"msm\",\"msn\",\"mso\",\"msp\",\"msq\",\"msr\",\"mss\",\"mst\",\"msu\",\"msv\",\"msw\",\"msx\",\"msy\",\"msz\",\"mta\",\"mtb\",\"mtc\",\"mtd\",\"mte\",\"mtf\",\"mtg\",\"mth\",\"mti\",\"mtj\",\"mtk\",\"mtl\",\"mtm\",\"mtn\",\"mto\",\"mtp\",\"mtq\",\"mtr\",\"mts\",\"mtt\",\"mtu\",\"mtv\",\"mtw\",\"mtx\",\"mty\",\"mua\",\"mub\",\"muc\",\"mud\",\"mue\",\"mug\",\"muh\",\"mui\",\"muj\",\"muk\",\"mul\",\"mum\",\"mun\",\"muo\",\"mup\",\"muq\",\"mur\",\"mus\",\"mut\",\"muu\",\"muv\",\"mux\",\"muy\",\"muz\",\"mva\",\"mvb\",\"mvd\",\"mve\",\"mvf\",\"mvg\",\"mvh\",\"mvi\",\"mvk\",\"mvl\",\"mvm\",\"mvn\",\"mvo\",\"mvp\",\"mvq\",\"mvr\",\"mvs\",\"mvt\",\"mvu\",\"mvv\",\"mvw\",\"mvx\",\"mvy\",\"mvz\",\"mwa\",\"mwb\",\"mwc\",\"mwd\",\"mwe\",\"mwf\",\"mwg\",\"mwh\",\"mwi\",\"mwj\",\"mwk\",\"mwl\",\"mwm\",\"mwn\",\"mwo\",\"mwp\",\"mwq\",\"mwr\",\"mws\",\"mwt\",\"mwu\",\"mwv\",\"mww\",\"mwx\",\"mwy\",\"mwz\",\"mxa\",\"mxb\",\"mxc\",\"mxd\",\"mxe\",\"mxf\",\"mxg\",\"mxh\",\"mxi\",\"mxj\",\"mxk\",\"mxl\",\"mxm\",\"mxn\",\"mxo\",\"mxp\",\"mxq\",\"mxr\",\"mxs\",\"mxt\",\"mxu\",\"mxv\",\"mxw\",\"mxx\",\"mxy\",\"mxz\",\"myb\",\"myc\",\"myd\",\"mye\",\"myf\",\"myg\",\"myh\",\"myi\",\"myj\",\"myk\",\"myl\",\"mym\",\"myn\",\"myo\",\"myp\",\"myq\",\"myr\",\"mys\",\"myt\",\"myu\",\"myv\",\"myw\",\"myx\",\"myy\",\"myz\",\"mza\",\"mzb\",\"mzc\",\"mzd\",\"mze\",\"mzg\",\"mzh\",\"mzi\",\"mzj\",\"mzk\",\"mzl\",\"mzm\",\"mzn\",\"mzo\",\"mzp\",\"mzq\",\"mzr\",\"mzs\",\"mzt\",\"mzu\",\"mzv\",\"mzw\",\"mzx\",\"mzy\",\"mzz\",\"naa\",\"nab\",\"nac\",\"nad\",\"nae\",\"naf\",\"nag\",\"nah\",\"nai\",\"naj\",\"nak\",\"nal\",\"nam\",\"nan\",\"nao\",\"nap\",\"naq\",\"nar\",\"nas\",\"nat\",\"naw\",\"nax\",\"nay\",\"naz\",\"nba\",\"nbb\",\"nbc\",\"nbd\",\"nbe\",\"nbf\",\"nbg\",\"nbh\",\"nbi\",\"nbj\",\"nbk\",\"nbm\",\"nbn\",\"nbo\",\"nbp\",\"nbq\",\"nbr\",\"nbs\",\"nbt\",\"nbu\",\"nbv\",\"nbw\",\"nbx\",\"nby\",\"nca\",\"ncb\",\"ncc\",\"ncd\",\"nce\",\"ncf\",\"ncg\",\"nch\",\"nci\",\"ncj\",\"nck\",\"ncl\",\"ncm\",\"ncn\",\"nco\",\"ncp\",\"ncq\",\"ncr\",\"ncs\",\"nct\",\"ncu\",\"ncx\",\"ncz\",\"nda\",\"ndb\",\"ndc\",\"ndd\",\"ndf\",\"ndg\",\"ndh\",\"ndi\",\"ndj\",\"ndk\",\"ndl\",\"ndm\",\"ndn\",\"ndp\",\"ndq\",\"ndr\",\"nds\",\"ndt\",\"ndu\",\"ndv\",\"ndw\",\"ndx\",\"ndy\",\"ndz\",\"nea\",\"neb\",\"nec\",\"ned\",\"nee\",\"nef\",\"neg\",\"neh\",\"nei\",\"nej\",\"nek\",\"nem\",\"nen\",\"neo\",\"neq\",\"ner\",\"nes\",\"net\",\"neu\",\"nev\",\"new\",\"nex\",\"ney\",\"nez\",\"nfa\",\"nfd\",\"nfl\",\"nfr\",\"nfu\",\"nga\",\"ngb\",\"ngc\",\"ngd\",\"nge\",\"ngf\",\"ngg\",\"ngh\",\"ngi\",\"ngj\",\"ngk\",\"ngl\",\"ngm\",\"ngn\",\"ngo\",\"ngp\",\"ngq\",\"ngr\",\"ngs\",\"ngt\",\"ngu\",\"ngv\",\"ngw\",\"ngx\",\"ngy\",\"ngz\",\"nha\",\"nhb\",\"nhc\",\"nhd\",\"nhe\",\"nhf\",\"nhg\",\"nhh\",\"nhi\",\"nhk\",\"nhm\",\"nhn\",\"nho\",\"nhp\",\"nhq\",\"nhr\",\"nht\",\"nhu\",\"nhv\",\"nhw\",\"nhx\",\"nhy\",\"nhz\",\"nia\",\"nib\",\"nic\",\"nid\",\"nie\",\"nif\",\"nig\",\"nih\",\"nii\",\"nij\",\"nik\",\"nil\",\"nim\",\"nin\",\"nio\",\"niq\",\"nir\",\"nis\",\"nit\",\"niu\",\"niv\",\"niw\",\"nix\",\"niy\",\"niz\",\"nja\",\"njb\",\"njd\",\"njh\",\"nji\",\"njj\",\"njl\",\"njm\",\"njn\",\"njo\",\"njr\",\"njs\",\"njt\",\"nju\",\"njx\",\"njy\",\"njz\",\"nka\",\"nkb\",\"nkc\",\"nkd\",\"nke\",\"nkf\",\"nkg\",\"nkh\",\"nki\",\"nkj\",\"nkk\",\"nkm\",\"nkn\",\"nko\",\"nkp\",\"nkq\",\"nkr\",\"nks\",\"nkt\",\"nku\",\"nkv\",\"nkw\",\"nkx\",\"nkz\",\"nla\",\"nlc\",\"nle\",\"nlg\",\"nli\",\"nlj\",\"nlk\",\"nll\",\"nln\",\"nlo\",\"nlq\",\"nlr\",\"nlu\",\"nlv\",\"nlw\",\"nlx\",\"nly\",\"nlz\",\"nma\",\"nmb\",\"nmc\",\"nmd\",\"nme\",\"nmf\",\"nmg\",\"nmh\",\"nmi\",\"nmj\",\"nmk\",\"nml\",\"nmm\",\"nmn\",\"nmo\",\"nmp\",\"nmq\",\"nmr\",\"nms\",\"nmt\",\"nmu\",\"nmv\",\"nmw\",\"nmx\",\"nmy\",\"nmz\",\"nna\",\"nnb\",\"nnc\",\"nnd\",\"nne\",\"nnf\",\"nng\",\"nnh\",\"nni\",\"nnj\",\"nnk\",\"nnl\",\"nnm\",\"nnn\",\"nnp\",\"nnq\",\"nnr\",\"nns\",\"nnt\",\"nnu\",\"nnv\",\"nnw\",\"nnx\",\"nny\",\"nnz\",\"noa\",\"noc\",\"nod\",\"noe\",\"nof\",\"nog\",\"noh\",\"noi\",\"noj\",\"nok\",\"nol\",\"nom\",\"non\",\"noo\",\"nop\",\"noq\",\"nos\",\"not\",\"nou\",\"nov\",\"now\",\"noy\",\"noz\",\"npa\",\"npb\",\"npg\",\"nph\",\"npi\",\"npl\",\"npn\",\"npo\",\"nps\",\"npu\",\"npx\",\"npy\",\"nqg\",\"nqk\",\"nql\",\"nqm\",\"nqn\",\"nqo\",\"nqq\",\"nqy\",\"nra\",\"nrb\",\"nrc\",\"nre\",\"nrf\",\"nrg\",\"nri\",\"nrk\",\"nrl\",\"nrm\",\"nrn\",\"nrp\",\"nrr\",\"nrt\",\"nru\",\"nrx\",\"nrz\",\"nsa\",\"nsc\",\"nsd\",\"nse\",\"nsf\",\"nsg\",\"nsh\",\"nsi\",\"nsk\",\"nsl\",\"nsm\",\"nsn\",\"nso\",\"nsp\",\"nsq\",\"nsr\",\"nss\",\"nst\",\"nsu\",\"nsv\",\"nsw\",\"nsx\",\"nsy\",\"nsz\",\"ntd\",\"nte\",\"ntg\",\"nti\",\"ntj\",\"ntk\",\"ntm\",\"nto\",\"ntp\",\"ntr\",\"nts\",\"ntu\",\"ntw\",\"ntx\",\"nty\",\"ntz\",\"nua\",\"nub\",\"nuc\",\"nud\",\"nue\",\"nuf\",\"nug\",\"nuh\",\"nui\",\"nuj\",\"nuk\",\"nul\",\"num\",\"nun\",\"nuo\",\"nup\",\"nuq\",\"nur\",\"nus\",\"nut\",\"nuu\",\"nuv\",\"nuw\",\"nux\",\"nuy\",\"nuz\",\"nvh\",\"nvm\",\"nvo\",\"nwa\",\"nwb\",\"nwc\",\"nwe\",\"nwg\",\"nwi\",\"nwm\",\"nwo\",\"nwr\",\"nwx\",\"nwy\",\"nxa\",\"nxd\",\"nxe\",\"nxg\",\"nxi\",\"nxk\",\"nxl\",\"nxm\",\"nxn\",\"nxo\",\"nxq\",\"nxr\",\"nxu\",\"nxx\",\"nyb\",\"nyc\",\"nyd\",\"nye\",\"nyf\",\"nyg\",\"nyh\",\"nyi\",\"nyj\",\"nyk\",\"nyl\",\"nym\",\"nyn\",\"nyo\",\"nyp\",\"nyq\",\"nyr\",\"nys\",\"nyt\",\"nyu\",\"nyv\",\"nyw\",\"nyx\",\"nyy\",\"nza\",\"nzb\",\"nzi\",\"nzk\",\"nzm\",\"nzs\",\"nzu\",\"nzy\",\"nzz\",\"oaa\",\"oac\",\"oar\",\"oav\",\"obi\",\"obk\",\"obl\",\"obm\",\"obo\",\"obr\",\"obt\",\"obu\",\"oca\",\"och\",\"oco\",\"ocu\",\"oda\",\"odk\",\"odt\",\"odu\",\"ofo\",\"ofs\",\"ofu\",\"ogb\",\"ogc\",\"oge\",\"ogg\",\"ogo\",\"ogu\",\"oht\",\"ohu\",\"oia\",\"oin\",\"ojb\",\"ojc\",\"ojg\",\"ojp\",\"ojs\",\"ojv\",\"ojw\",\"oka\",\"okb\",\"okd\",\"oke\",\"okg\",\"okh\",\"oki\",\"okj\",\"okk\",\"okl\",\"okm\",\"okn\",\"oko\",\"okr\",\"oks\",\"oku\",\"okv\",\"okx\",\"ola\",\"old\",\"ole\",\"olk\",\"olm\",\"olo\",\"olr\",\"olt\",\"olu\",\"oma\",\"omb\",\"omc\",\"ome\",\"omg\",\"omi\",\"omk\",\"oml\",\"omn\",\"omo\",\"omp\",\"omq\",\"omr\",\"omt\",\"omu\",\"omv\",\"omw\",\"omx\",\"ona\",\"onb\",\"one\",\"ong\",\"oni\",\"onj\",\"onk\",\"onn\",\"ono\",\"onp\",\"onr\",\"ons\",\"ont\",\"onu\",\"onw\",\"onx\",\"ood\",\"oog\",\"oon\",\"oor\",\"oos\",\"opa\",\"opk\",\"opm\",\"opo\",\"opt\",\"opy\",\"ora\",\"orc\",\"ore\",\"org\",\"orh\",\"orn\",\"oro\",\"orr\",\"ors\",\"ort\",\"oru\",\"orv\",\"orw\",\"orx\",\"ory\",\"orz\",\"osa\",\"osc\",\"osi\",\"oso\",\"osp\",\"ost\",\"osu\",\"osx\",\"ota\",\"otb\",\"otd\",\"ote\",\"oti\",\"otk\",\"otl\",\"otm\",\"otn\",\"oto\",\"otq\",\"otr\",\"ots\",\"ott\",\"otu\",\"otw\",\"otx\",\"oty\",\"otz\",\"oua\",\"oub\",\"oue\",\"oui\",\"oum\",\"oun\",\"ovd\",\"owi\",\"owl\",\"oyb\",\"oyd\",\"oym\",\"oyy\",\"ozm\",\"paa\",\"pab\",\"pac\",\"pad\",\"pae\",\"paf\",\"pag\",\"pah\",\"pai\",\"pak\",\"pal\",\"pam\",\"pao\",\"pap\",\"paq\",\"par\",\"pas\",\"pat\",\"pau\",\"pav\",\"paw\",\"pax\",\"pay\",\"paz\",\"pbb\",\"pbc\",\"pbe\",\"pbf\",\"pbg\",\"pbh\",\"pbi\",\"pbl\",\"pbn\",\"pbo\",\"pbp\",\"pbr\",\"pbs\",\"pbt\",\"pbu\",\"pbv\",\"pby\",\"pbz\",\"pca\",\"pcb\",\"pcc\",\"pcd\",\"pce\",\"pcf\",\"pcg\",\"pch\",\"pci\",\"pcj\",\"pck\",\"pcl\",\"pcm\",\"pcn\",\"pcp\",\"pcr\",\"pcw\",\"pda\",\"pdc\",\"pdi\",\"pdn\",\"pdo\",\"pdt\",\"pdu\",\"pea\",\"peb\",\"ped\",\"pee\",\"pef\",\"peg\",\"peh\",\"pei\",\"pej\",\"pek\",\"pel\",\"pem\",\"peo\",\"pep\",\"peq\",\"pes\",\"pev\",\"pex\",\"pey\",\"pez\",\"pfa\",\"pfe\",\"pfl\",\"pga\",\"pgd\",\"pgg\",\"pgi\",\"pgk\",\"pgl\",\"pgn\",\"pgs\",\"pgu\",\"pgy\",\"pgz\",\"pha\",\"phd\",\"phg\",\"phh\",\"phi\",\"phk\",\"phl\",\"phm\",\"phn\",\"pho\",\"phq\",\"phr\",\"pht\",\"phu\",\"phv\",\"phw\",\"pia\",\"pib\",\"pic\",\"pid\",\"pie\",\"pif\",\"pig\",\"pih\",\"pii\",\"pij\",\"pil\",\"pim\",\"pin\",\"pio\",\"pip\",\"pir\",\"pis\",\"pit\",\"piu\",\"piv\",\"piw\",\"pix\",\"piy\",\"piz\",\"pjt\",\"pka\",\"pkb\",\"pkc\",\"pkg\",\"pkh\",\"pkn\",\"pko\",\"pkp\",\"pkr\",\"pks\",\"pkt\",\"pku\",\"pla\",\"plb\",\"plc\",\"pld\",\"ple\",\"plf\",\"plg\",\"plh\",\"plj\",\"plk\",\"pll\",\"pln\",\"plo\",\"plp\",\"plq\",\"plr\",\"pls\",\"plt\",\"plu\",\"plv\",\"plw\",\"ply\",\"plz\",\"pma\",\"pmb\",\"pmc\",\"pmd\",\"pme\",\"pmf\",\"pmh\",\"pmi\",\"pmj\",\"pmk\",\"pml\",\"pmm\",\"pmn\",\"pmo\",\"pmq\",\"pmr\",\"pms\",\"pmt\",\"pmu\",\"pmw\",\"pmx\",\"pmy\",\"pmz\",\"pna\",\"pnb\",\"pnc\",\"pne\",\"png\",\"pnh\",\"pni\",\"pnj\",\"pnk\",\"pnl\",\"pnm\",\"pnn\",\"pno\",\"pnp\",\"pnq\",\"pnr\",\"pns\",\"pnt\",\"pnu\",\"pnv\",\"pnw\",\"pnx\",\"pny\",\"pnz\",\"poc\",\"pod\",\"poe\",\"pof\",\"pog\",\"poh\",\"poi\",\"pok\",\"pom\",\"pon\",\"poo\",\"pop\",\"poq\",\"pos\",\"pot\",\"pov\",\"pow\",\"pox\",\"poy\",\"poz\",\"ppa\",\"ppe\",\"ppi\",\"ppk\",\"ppl\",\"ppm\",\"ppn\",\"ppo\",\"ppp\",\"ppq\",\"ppr\",\"pps\",\"ppt\",\"ppu\",\"pqa\",\"pqe\",\"pqm\",\"pqw\",\"pra\",\"prb\",\"prc\",\"prd\",\"pre\",\"prf\",\"prg\",\"prh\",\"pri\",\"prk\",\"prl\",\"prm\",\"prn\",\"pro\",\"prp\",\"prq\",\"prr\",\"prs\",\"prt\",\"pru\",\"prw\",\"prx\",\"pry\",\"prz\",\"psa\",\"psc\",\"psd\",\"pse\",\"psg\",\"psh\",\"psi\",\"psl\",\"psm\",\"psn\",\"pso\",\"psp\",\"psq\",\"psr\",\"pss\",\"pst\",\"psu\",\"psw\",\"psy\",\"pta\",\"pth\",\"pti\",\"ptn\",\"pto\",\"ptp\",\"ptq\",\"ptr\",\"ptt\",\"ptu\",\"ptv\",\"ptw\",\"pty\",\"pua\",\"pub\",\"puc\",\"pud\",\"pue\",\"puf\",\"pug\",\"pui\",\"puj\",\"puk\",\"pum\",\"puo\",\"pup\",\"puq\",\"pur\",\"put\",\"puu\",\"puw\",\"pux\",\"puy\",\"puz\",\"pwa\",\"pwb\",\"pwg\",\"pwi\",\"pwm\",\"pwn\",\"pwo\",\"pwr\",\"pww\",\"pxm\",\"pye\",\"pym\",\"pyn\",\"pys\",\"pyu\",\"pyx\",\"pyy\",\"pzn\",\"qaa..qtz\",\"qua\",\"qub\",\"quc\",\"qud\",\"quf\",\"qug\",\"quh\",\"qui\",\"quk\",\"qul\",\"qum\",\"qun\",\"qup\",\"quq\",\"qur\",\"qus\",\"quv\",\"quw\",\"qux\",\"quy\",\"quz\",\"qva\",\"qvc\",\"qve\",\"qvh\",\"qvi\",\"qvj\",\"qvl\",\"qvm\",\"qvn\",\"qvo\",\"qvp\",\"qvs\",\"qvw\",\"qvy\",\"qvz\",\"qwa\",\"qwc\",\"qwe\",\"qwh\",\"qwm\",\"qws\",\"qwt\",\"qxa\",\"qxc\",\"qxh\",\"qxl\",\"qxn\",\"qxo\",\"qxp\",\"qxq\",\"qxr\",\"qxs\",\"qxt\",\"qxu\",\"qxw\",\"qya\",\"qyp\",\"raa\",\"rab\",\"rac\",\"rad\",\"raf\",\"rag\",\"rah\",\"rai\",\"raj\",\"rak\",\"ral\",\"ram\",\"ran\",\"rao\",\"rap\",\"raq\",\"rar\",\"ras\",\"rat\",\"rau\",\"rav\",\"raw\",\"rax\",\"ray\",\"raz\",\"rbb\",\"rbk\",\"rbl\",\"rbp\",\"rcf\",\"rdb\",\"rea\",\"reb\",\"ree\",\"reg\",\"rei\",\"rej\",\"rel\",\"rem\",\"ren\",\"rer\",\"res\",\"ret\",\"rey\",\"rga\",\"rge\",\"rgk\",\"rgn\",\"rgr\",\"rgs\",\"rgu\",\"rhg\",\"rhp\",\"ria\",\"rie\",\"rif\",\"ril\",\"rim\",\"rin\",\"rir\",\"rit\",\"riu\",\"rjg\",\"rji\",\"rjs\",\"rka\",\"rkb\",\"rkh\",\"rki\",\"rkm\",\"rkt\",\"rkw\",\"rma\",\"rmb\",\"rmc\",\"rmd\",\"rme\",\"rmf\",\"rmg\",\"rmh\",\"rmi\",\"rmk\",\"rml\",\"rmm\",\"rmn\",\"rmo\",\"rmp\",\"rmq\",\"rmr\",\"rms\",\"rmt\",\"rmu\",\"rmv\",\"rmw\",\"rmx\",\"rmy\",\"rmz\",\"rna\",\"rnd\",\"rng\",\"rnl\",\"rnn\",\"rnp\",\"rnr\",\"rnw\",\"roa\",\"rob\",\"roc\",\"rod\",\"roe\",\"rof\",\"rog\",\"rol\",\"rom\",\"roo\",\"rop\",\"ror\",\"rou\",\"row\",\"rpn\",\"rpt\",\"rri\",\"rro\",\"rrt\",\"rsb\",\"rsi\",\"rsl\",\"rsm\",\"rtc\",\"rth\",\"rtm\",\"rts\",\"rtw\",\"rub\",\"ruc\",\"rue\",\"ruf\",\"rug\",\"ruh\",\"rui\",\"ruk\",\"ruo\",\"rup\",\"ruq\",\"rut\",\"ruu\",\"ruy\",\"ruz\",\"rwa\",\"rwk\",\"rwm\",\"rwo\",\"rwr\",\"rxd\",\"rxw\",\"ryn\",\"rys\",\"ryu\",\"rzh\",\"saa\",\"sab\",\"sac\",\"sad\",\"sae\",\"saf\",\"sah\",\"sai\",\"saj\",\"sak\",\"sal\",\"sam\",\"sao\",\"sap\",\"saq\",\"sar\",\"sas\",\"sat\",\"sau\",\"sav\",\"saw\",\"sax\",\"say\",\"saz\",\"sba\",\"sbb\",\"sbc\",\"sbd\",\"sbe\",\"sbf\",\"sbg\",\"sbh\",\"sbi\",\"sbj\",\"sbk\",\"sbl\",\"sbm\",\"sbn\",\"sbo\",\"sbp\",\"sbq\",\"sbr\",\"sbs\",\"sbt\",\"sbu\",\"sbv\",\"sbw\",\"sbx\",\"sby\",\"sbz\",\"sca\",\"scb\",\"sce\",\"scf\",\"scg\",\"sch\",\"sci\",\"sck\",\"scl\",\"scn\",\"sco\",\"scp\",\"scq\",\"scs\",\"sct\",\"scu\",\"scv\",\"scw\",\"scx\",\"sda\",\"sdb\",\"sdc\",\"sde\",\"sdf\",\"sdg\",\"sdh\",\"sdj\",\"sdk\",\"sdl\",\"sdm\",\"sdn\",\"sdo\",\"sdp\",\"sdr\",\"sds\",\"sdt\",\"sdu\",\"sdv\",\"sdx\",\"sdz\",\"sea\",\"seb\",\"sec\",\"sed\",\"see\",\"sef\",\"seg\",\"seh\",\"sei\",\"sej\",\"sek\",\"sel\",\"sem\",\"sen\",\"seo\",\"sep\",\"seq\",\"ser\",\"ses\",\"set\",\"seu\",\"sev\",\"sew\",\"sey\",\"sez\",\"sfb\",\"sfe\",\"sfm\",\"sfs\",\"sfw\",\"sga\",\"sgb\",\"sgc\",\"sgd\",\"sge\",\"sgg\",\"sgh\",\"sgi\",\"sgj\",\"sgk\",\"sgl\",\"sgm\",\"sgn\",\"sgo\",\"sgp\",\"sgr\",\"sgs\",\"sgt\",\"sgu\",\"sgw\",\"sgx\",\"sgy\",\"sgz\",\"sha\",\"shb\",\"shc\",\"shd\",\"she\",\"shg\",\"shh\",\"shi\",\"shj\",\"shk\",\"shl\",\"shm\",\"shn\",\"sho\",\"shp\",\"shq\",\"shr\",\"shs\",\"sht\",\"shu\",\"shv\",\"shw\",\"shx\",\"shy\",\"shz\",\"sia\",\"sib\",\"sid\",\"sie\",\"sif\",\"sig\",\"sih\",\"sii\",\"sij\",\"sik\",\"sil\",\"sim\",\"sio\",\"sip\",\"siq\",\"sir\",\"sis\",\"sit\",\"siu\",\"siv\",\"siw\",\"six\",\"siy\",\"siz\",\"sja\",\"sjb\",\"sjd\",\"sje\",\"sjg\",\"sjk\",\"sjl\",\"sjm\",\"sjn\",\"sjo\",\"sjp\",\"sjr\",\"sjs\",\"sjt\",\"sju\",\"sjw\",\"ska\",\"skb\",\"skc\",\"skd\",\"ske\",\"skf\",\"skg\",\"skh\",\"ski\",\"skj\",\"skk\",\"skm\",\"skn\",\"sko\",\"skp\",\"skq\",\"skr\",\"sks\",\"skt\",\"sku\",\"skv\",\"skw\",\"skx\",\"sky\",\"skz\",\"sla\",\"slc\",\"sld\",\"sle\",\"slf\",\"slg\",\"slh\",\"sli\",\"slj\",\"sll\",\"slm\",\"sln\",\"slp\",\"slq\",\"slr\",\"sls\",\"slt\",\"slu\",\"slw\",\"slx\",\"sly\",\"slz\",\"sma\",\"smb\",\"smc\",\"smd\",\"smf\",\"smg\",\"smh\",\"smi\",\"smj\",\"smk\",\"sml\",\"smm\",\"smn\",\"smp\",\"smq\",\"smr\",\"sms\",\"smt\",\"smu\",\"smv\",\"smw\",\"smx\",\"smy\",\"smz\",\"snb\",\"snc\",\"sne\",\"snf\",\"sng\",\"snh\",\"sni\",\"snj\",\"snk\",\"snl\",\"snm\",\"snn\",\"sno\",\"snp\",\"snq\",\"snr\",\"sns\",\"snu\",\"snv\",\"snw\",\"snx\",\"sny\",\"snz\",\"soa\",\"sob\",\"soc\",\"sod\",\"soe\",\"sog\",\"soh\",\"soi\",\"soj\",\"sok\",\"sol\",\"son\",\"soo\",\"sop\",\"soq\",\"sor\",\"sos\",\"sou\",\"sov\",\"sow\",\"sox\",\"soy\",\"soz\",\"spb\",\"spc\",\"spd\",\"spe\",\"spg\",\"spi\",\"spk\",\"spl\",\"spm\",\"spn\",\"spo\",\"spp\",\"spq\",\"spr\",\"sps\",\"spt\",\"spu\",\"spv\",\"spx\",\"spy\",\"sqa\",\"sqh\",\"sqj\",\"sqk\",\"sqm\",\"sqn\",\"sqo\",\"sqq\",\"sqr\",\"sqs\",\"sqt\",\"squ\",\"sra\",\"srb\",\"src\",\"sre\",\"srf\",\"srg\",\"srh\",\"sri\",\"srk\",\"srl\",\"srm\",\"srn\",\"sro\",\"srq\",\"srr\",\"srs\",\"srt\",\"sru\",\"srv\",\"srw\",\"srx\",\"sry\",\"srz\",\"ssa\",\"ssb\",\"ssc\",\"ssd\",\"sse\",\"ssf\",\"ssg\",\"ssh\",\"ssi\",\"ssj\",\"ssk\",\"ssl\",\"ssm\",\"ssn\",\"sso\",\"ssp\",\"ssq\",\"ssr\",\"sss\",\"sst\",\"ssu\",\"ssv\",\"ssx\",\"ssy\",\"ssz\",\"sta\",\"stb\",\"std\",\"ste\",\"stf\",\"stg\",\"sth\",\"sti\",\"stj\",\"stk\",\"stl\",\"stm\",\"stn\",\"sto\",\"stp\",\"stq\",\"str\",\"sts\",\"stt\",\"stu\",\"stv\",\"stw\",\"sty\",\"sua\",\"sub\",\"suc\",\"sue\",\"sug\",\"sui\",\"suj\",\"suk\",\"sul\",\"sum\",\"suq\",\"sur\",\"sus\",\"sut\",\"suv\",\"suw\",\"sux\",\"suy\",\"suz\",\"sva\",\"svb\",\"svc\",\"sve\",\"svk\",\"svm\",\"svr\",\"svs\",\"svx\",\"swb\",\"swc\",\"swf\",\"swg\",\"swh\",\"swi\",\"swj\",\"swk\",\"swl\",\"swm\",\"swn\",\"swo\",\"swp\",\"swq\",\"swr\",\"sws\",\"swt\",\"swu\",\"swv\",\"sww\",\"swx\",\"swy\",\"sxb\",\"sxc\",\"sxe\",\"sxg\",\"sxk\",\"sxl\",\"sxm\",\"sxn\",\"sxo\",\"sxr\",\"sxs\",\"sxu\",\"sxw\",\"sya\",\"syb\",\"syc\",\"syd\",\"syi\",\"syk\",\"syl\",\"sym\",\"syn\",\"syo\",\"syr\",\"sys\",\"syw\",\"syx\",\"syy\",\"sza\",\"szb\",\"szc\",\"szd\",\"sze\",\"szg\",\"szl\",\"szn\",\"szp\",\"szs\",\"szv\",\"szw\",\"taa\",\"tab\",\"tac\",\"tad\",\"tae\",\"taf\",\"tag\",\"tai\",\"taj\",\"tak\",\"tal\",\"tan\",\"tao\",\"tap\",\"taq\",\"tar\",\"tas\",\"tau\",\"tav\",\"taw\",\"tax\",\"tay\",\"taz\",\"tba\",\"tbb\",\"tbc\",\"tbd\",\"tbe\",\"tbf\",\"tbg\",\"tbh\",\"tbi\",\"tbj\",\"tbk\",\"tbl\",\"tbm\",\"tbn\",\"tbo\",\"tbp\",\"tbq\",\"tbr\",\"tbs\",\"tbt\",\"tbu\",\"tbv\",\"tbw\",\"tbx\",\"tby\",\"tbz\",\"tca\",\"tcb\",\"tcc\",\"tcd\",\"tce\",\"tcf\",\"tcg\",\"tch\",\"tci\",\"tck\",\"tcl\",\"tcm\",\"tcn\",\"tco\",\"tcp\",\"tcq\",\"tcs\",\"tct\",\"tcu\",\"tcw\",\"tcx\",\"tcy\",\"tcz\",\"tda\",\"tdb\",\"tdc\",\"tdd\",\"tde\",\"tdf\",\"tdg\",\"tdh\",\"tdi\",\"tdj\",\"tdk\",\"tdl\",\"tdm\",\"tdn\",\"tdo\",\"tdq\",\"tdr\",\"tds\",\"tdt\",\"tdu\",\"tdv\",\"tdx\",\"tdy\",\"tea\",\"teb\",\"tec\",\"ted\",\"tee\",\"tef\",\"teg\",\"teh\",\"tei\",\"tek\",\"tem\",\"ten\",\"teo\",\"tep\",\"teq\",\"ter\",\"tes\",\"tet\",\"teu\",\"tev\",\"tew\",\"tex\",\"tey\",\"tfi\",\"tfn\",\"tfo\",\"tfr\",\"tft\",\"tga\",\"tgb\",\"tgc\",\"tgd\",\"tge\",\"tgf\",\"tgg\",\"tgh\",\"tgi\",\"tgj\",\"tgn\",\"tgo\",\"tgp\",\"tgq\",\"tgr\",\"tgs\",\"tgt\",\"tgu\",\"tgv\",\"tgw\",\"tgx\",\"tgy\",\"tgz\",\"thc\",\"thd\",\"the\",\"thf\",\"thh\",\"thi\",\"thk\",\"thl\",\"thm\",\"thn\",\"thp\",\"thq\",\"thr\",\"ths\",\"tht\",\"thu\",\"thv\",\"thw\",\"thx\",\"thy\",\"thz\",\"tia\",\"tic\",\"tid\",\"tie\",\"tif\",\"tig\",\"tih\",\"tii\",\"tij\",\"tik\",\"til\",\"tim\",\"tin\",\"tio\",\"tip\",\"tiq\",\"tis\",\"tit\",\"tiu\",\"tiv\",\"tiw\",\"tix\",\"tiy\",\"tiz\",\"tja\",\"tjg\",\"tji\",\"tjl\",\"tjm\",\"tjn\",\"tjo\",\"tjs\",\"tju\",\"tjw\",\"tka\",\"tkb\",\"tkd\",\"tke\",\"tkf\",\"tkg\",\"tkk\",\"tkl\",\"tkm\",\"tkn\",\"tkp\",\"tkq\",\"tkr\",\"tks\",\"tkt\",\"tku\",\"tkv\",\"tkw\",\"tkx\",\"tkz\",\"tla\",\"tlb\",\"tlc\",\"tld\",\"tlf\",\"tlg\",\"tlh\",\"tli\",\"tlj\",\"tlk\",\"tll\",\"tlm\",\"tln\",\"tlo\",\"tlp\",\"tlq\",\"tlr\",\"tls\",\"tlt\",\"tlu\",\"tlv\",\"tlw\",\"tlx\",\"tly\",\"tma\",\"tmb\",\"tmc\",\"tmd\",\"tme\",\"tmf\",\"tmg\",\"tmh\",\"tmi\",\"tmj\",\"tmk\",\"tml\",\"tmm\",\"tmn\",\"tmo\",\"tmp\",\"tmq\",\"tmr\",\"tms\",\"tmt\",\"tmu\",\"tmv\",\"tmw\",\"tmy\",\"tmz\",\"tna\",\"tnb\",\"tnc\",\"tnd\",\"tne\",\"tnf\",\"tng\",\"tnh\",\"tni\",\"tnk\",\"tnl\",\"tnm\",\"tnn\",\"tno\",\"tnp\",\"tnq\",\"tnr\",\"tns\",\"tnt\",\"tnu\",\"tnv\",\"tnw\",\"tnx\",\"tny\",\"tnz\",\"tob\",\"toc\",\"tod\",\"toe\",\"tof\",\"tog\",\"toh\",\"toi\",\"toj\",\"tol\",\"tom\",\"too\",\"top\",\"toq\",\"tor\",\"tos\",\"tou\",\"tov\",\"tow\",\"tox\",\"toy\",\"toz\",\"tpa\",\"tpc\",\"tpe\",\"tpf\",\"tpg\",\"tpi\",\"tpj\",\"tpk\",\"tpl\",\"tpm\",\"tpn\",\"tpo\",\"tpp\",\"tpq\",\"tpr\",\"tpt\",\"tpu\",\"tpv\",\"tpw\",\"tpx\",\"tpy\",\"tpz\",\"tqb\",\"tql\",\"tqm\",\"tqn\",\"tqo\",\"tqp\",\"tqq\",\"tqr\",\"tqt\",\"tqu\",\"tqw\",\"tra\",\"trb\",\"trc\",\"trd\",\"tre\",\"trf\",\"trg\",\"trh\",\"tri\",\"trj\",\"trk\",\"trl\",\"trm\",\"trn\",\"tro\",\"trp\",\"trq\",\"trr\",\"trs\",\"trt\",\"tru\",\"trv\",\"trw\",\"trx\",\"try\",\"trz\",\"tsa\",\"tsb\",\"tsc\",\"tsd\",\"tse\",\"tsf\",\"tsg\",\"tsh\",\"tsi\",\"tsj\",\"tsk\",\"tsl\",\"tsm\",\"tsp\",\"tsq\",\"tsr\",\"tss\",\"tst\",\"tsu\",\"tsv\",\"tsw\",\"tsx\",\"tsy\",\"tsz\",\"tta\",\"ttb\",\"ttc\",\"ttd\",\"tte\",\"ttf\",\"ttg\",\"tth\",\"tti\",\"ttj\",\"ttk\",\"ttl\",\"ttm\",\"ttn\",\"tto\",\"ttp\",\"ttq\",\"ttr\",\"tts\",\"ttt\",\"ttu\",\"ttv\",\"ttw\",\"tty\",\"ttz\",\"tua\",\"tub\",\"tuc\",\"tud\",\"tue\",\"tuf\",\"tug\",\"tuh\",\"tui\",\"tuj\",\"tul\",\"tum\",\"tun\",\"tuo\",\"tup\",\"tuq\",\"tus\",\"tut\",\"tuu\",\"tuv\",\"tuw\",\"tux\",\"tuy\",\"tuz\",\"tva\",\"tvd\",\"tve\",\"tvk\",\"tvl\",\"tvm\",\"tvn\",\"tvo\",\"tvs\",\"tvt\",\"tvu\",\"tvw\",\"tvy\",\"twa\",\"twb\",\"twc\",\"twd\",\"twe\",\"twf\",\"twg\",\"twh\",\"twl\",\"twm\",\"twn\",\"two\",\"twp\",\"twq\",\"twr\",\"twt\",\"twu\",\"tww\",\"twx\",\"twy\",\"txa\",\"txb\",\"txc\",\"txe\",\"txg\",\"txh\",\"txi\",\"txj\",\"txm\",\"txn\",\"txo\",\"txq\",\"txr\",\"txs\",\"txt\",\"txu\",\"txx\",\"txy\",\"tya\",\"tye\",\"tyh\",\"tyi\",\"tyj\",\"tyl\",\"tyn\",\"typ\",\"tyr\",\"tys\",\"tyt\",\"tyu\",\"tyv\",\"tyx\",\"tyz\",\"tza\",\"tzh\",\"tzj\",\"tzl\",\"tzm\",\"tzn\",\"tzo\",\"tzx\",\"uam\",\"uan\",\"uar\",\"uba\",\"ubi\",\"ubl\",\"ubr\",\"ubu\",\"uby\",\"uda\",\"ude\",\"udg\",\"udi\",\"udj\",\"udl\",\"udm\",\"udu\",\"ues\",\"ufi\",\"uga\",\"ugb\",\"uge\",\"ugn\",\"ugo\",\"ugy\",\"uha\",\"uhn\",\"uis\",\"uiv\",\"uji\",\"uka\",\"ukg\",\"ukh\",\"ukk\",\"ukl\",\"ukp\",\"ukq\",\"uks\",\"uku\",\"ukw\",\"uky\",\"ula\",\"ulb\",\"ulc\",\"ule\",\"ulf\",\"uli\",\"ulk\",\"ull\",\"ulm\",\"uln\",\"ulu\",\"ulw\",\"uma\",\"umb\",\"umc\",\"umd\",\"umg\",\"umi\",\"umm\",\"umn\",\"umo\",\"ump\",\"umr\",\"ums\",\"umu\",\"una\",\"und\",\"une\",\"ung\",\"unk\",\"unm\",\"unn\",\"unp\",\"unr\",\"unu\",\"unx\",\"unz\",\"uok\",\"upi\",\"upv\",\"ura\",\"urb\",\"urc\",\"ure\",\"urf\",\"urg\",\"urh\",\"uri\",\"urj\",\"urk\",\"url\",\"urm\",\"urn\",\"uro\",\"urp\",\"urr\",\"urt\",\"uru\",\"urv\",\"urw\",\"urx\",\"ury\",\"urz\",\"usa\",\"ush\",\"usi\",\"usk\",\"usp\",\"usu\",\"uta\",\"ute\",\"utp\",\"utr\",\"utu\",\"uum\",\"uun\",\"uur\",\"uuu\",\"uve\",\"uvh\",\"uvl\",\"uwa\",\"uya\",\"uzn\",\"uzs\",\"vaa\",\"vae\",\"vaf\",\"vag\",\"vah\",\"vai\",\"vaj\",\"val\",\"vam\",\"van\",\"vao\",\"vap\",\"var\",\"vas\",\"vau\",\"vav\",\"vay\",\"vbb\",\"vbk\",\"vec\",\"ved\",\"vel\",\"vem\",\"veo\",\"vep\",\"ver\",\"vgr\",\"vgt\",\"vic\",\"vid\",\"vif\",\"vig\",\"vil\",\"vin\",\"vis\",\"vit\",\"viv\",\"vka\",\"vki\",\"vkj\",\"vkk\",\"vkl\",\"vkm\",\"vko\",\"vkp\",\"vkt\",\"vku\",\"vlp\",\"vls\",\"vma\",\"vmb\",\"vmc\",\"vmd\",\"vme\",\"vmf\",\"vmg\",\"vmh\",\"vmi\",\"vmj\",\"vmk\",\"vml\",\"vmm\",\"vmp\",\"vmq\",\"vmr\",\"vms\",\"vmu\",\"vmv\",\"vmw\",\"vmx\",\"vmy\",\"vmz\",\"vnk\",\"vnm\",\"vnp\",\"vor\",\"vot\",\"vra\",\"vro\",\"vrs\",\"vrt\",\"vsi\",\"vsl\",\"vsv\",\"vto\",\"vum\",\"vun\",\"vut\",\"vwa\",\"waa\",\"wab\",\"wac\",\"wad\",\"wae\",\"waf\",\"wag\",\"wah\",\"wai\",\"waj\",\"wak\",\"wal\",\"wam\",\"wan\",\"wao\",\"wap\",\"waq\",\"war\",\"was\",\"wat\",\"wau\",\"wav\",\"waw\",\"wax\",\"way\",\"waz\",\"wba\",\"wbb\",\"wbe\",\"wbf\",\"wbh\",\"wbi\",\"wbj\",\"wbk\",\"wbl\",\"wbm\",\"wbp\",\"wbq\",\"wbr\",\"wbs\",\"wbt\",\"wbv\",\"wbw\",\"wca\",\"wci\",\"wdd\",\"wdg\",\"wdj\",\"wdk\",\"wdu\",\"wdy\",\"wea\",\"wec\",\"wed\",\"weg\",\"weh\",\"wei\",\"wem\",\"wen\",\"weo\",\"wep\",\"wer\",\"wes\",\"wet\",\"weu\",\"wew\",\"wfg\",\"wga\",\"wgb\",\"wgg\",\"wgi\",\"wgo\",\"wgu\",\"wgw\",\"wgy\",\"wha\",\"whg\",\"whk\",\"whu\",\"wib\",\"wic\",\"wie\",\"wif\",\"wig\",\"wih\",\"wii\",\"wij\",\"wik\",\"wil\",\"wim\",\"win\",\"wir\",\"wit\",\"wiu\",\"wiv\",\"wiw\",\"wiy\",\"wja\",\"wji\",\"wka\",\"wkb\",\"wkd\",\"wkl\",\"wku\",\"wkw\",\"wky\",\"wla\",\"wlc\",\"wle\",\"wlg\",\"wli\",\"wlk\",\"wll\",\"wlm\",\"wlo\",\"wlr\",\"wls\",\"wlu\",\"wlv\",\"wlw\",\"wlx\",\"wly\",\"wma\",\"wmb\",\"wmc\",\"wmd\",\"wme\",\"wmh\",\"wmi\",\"wmm\",\"wmn\",\"wmo\",\"wms\",\"wmt\",\"wmw\",\"wmx\",\"wnb\",\"wnc\",\"wnd\",\"wne\",\"wng\",\"wni\",\"wnk\",\"wnm\",\"wnn\",\"wno\",\"wnp\",\"wnu\",\"wnw\",\"wny\",\"woa\",\"wob\",\"woc\",\"wod\",\"woe\",\"wof\",\"wog\",\"woi\",\"wok\",\"wom\",\"won\",\"woo\",\"wor\",\"wos\",\"wow\",\"woy\",\"wpc\",\"wra\",\"wrb\",\"wrd\",\"wrg\",\"wrh\",\"wri\",\"wrk\",\"wrl\",\"wrm\",\"wrn\",\"wro\",\"wrp\",\"wrr\",\"wrs\",\"wru\",\"wrv\",\"wrw\",\"wrx\",\"wry\",\"wrz\",\"wsa\",\"wsg\",\"wsi\",\"wsk\",\"wsr\",\"wss\",\"wsu\",\"wsv\",\"wtf\",\"wth\",\"wti\",\"wtk\",\"wtm\",\"wtw\",\"wua\",\"wub\",\"wud\",\"wuh\",\"wul\",\"wum\",\"wun\",\"wur\",\"wut\",\"wuu\",\"wuv\",\"wux\",\"wuy\",\"wwa\",\"wwb\",\"wwo\",\"wwr\",\"www\",\"wxa\",\"wxw\",\"wya\",\"wyb\",\"wyi\",\"wym\",\"wyr\",\"wyy\",\"xaa\",\"xab\",\"xac\",\"xad\",\"xae\",\"xag\",\"xai\",\"xaj\",\"xak\",\"xal\",\"xam\",\"xan\",\"xao\",\"xap\",\"xaq\",\"xar\",\"xas\",\"xat\",\"xau\",\"xav\",\"xaw\",\"xay\",\"xba\",\"xbb\",\"xbc\",\"xbd\",\"xbe\",\"xbg\",\"xbi\",\"xbj\",\"xbm\",\"xbn\",\"xbo\",\"xbp\",\"xbr\",\"xbw\",\"xbx\",\"xby\",\"xcb\",\"xcc\",\"xce\",\"xcg\",\"xch\",\"xcl\",\"xcm\",\"xcn\",\"xco\",\"xcr\",\"xct\",\"xcu\",\"xcv\",\"xcw\",\"xcy\",\"xda\",\"xdc\",\"xdk\",\"xdm\",\"xdo\",\"xdy\",\"xeb\",\"xed\",\"xeg\",\"xel\",\"xem\",\"xep\",\"xer\",\"xes\",\"xet\",\"xeu\",\"xfa\",\"xga\",\"xgb\",\"xgd\",\"xgf\",\"xgg\",\"xgi\",\"xgl\",\"xgm\",\"xgn\",\"xgr\",\"xgu\",\"xgw\",\"xha\",\"xhc\",\"xhd\",\"xhe\",\"xhr\",\"xht\",\"xhu\",\"xhv\",\"xia\",\"xib\",\"xii\",\"xil\",\"xin\",\"xip\",\"xir\",\"xis\",\"xiv\",\"xiy\",\"xjb\",\"xjt\",\"xka\",\"xkb\",\"xkc\",\"xkd\",\"xke\",\"xkf\",\"xkg\",\"xkh\",\"xki\",\"xkj\",\"xkk\",\"xkl\",\"xkn\",\"xko\",\"xkp\",\"xkq\",\"xkr\",\"xks\",\"xkt\",\"xku\",\"xkv\",\"xkw\",\"xkx\",\"xky\",\"xkz\",\"xla\",\"xlb\",\"xlc\",\"xld\",\"xle\",\"xlg\",\"xli\",\"xln\",\"xlo\",\"xlp\",\"xls\",\"xlu\",\"xly\",\"xma\",\"xmb\",\"xmc\",\"xmd\",\"xme\",\"xmf\",\"xmg\",\"xmh\",\"xmj\",\"xmk\",\"xml\",\"xmm\",\"xmn\",\"xmo\",\"xmp\",\"xmq\",\"xmr\",\"xms\",\"xmt\",\"xmu\",\"xmv\",\"xmw\",\"xmx\",\"xmy\",\"xmz\",\"xna\",\"xnb\",\"xnd\",\"xng\",\"xnh\",\"xni\",\"xnk\",\"xnn\",\"xno\",\"xnr\",\"xns\",\"xnt\",\"xnu\",\"xny\",\"xnz\",\"xoc\",\"xod\",\"xog\",\"xoi\",\"xok\",\"xom\",\"xon\",\"xoo\",\"xop\",\"xor\",\"xow\",\"xpa\",\"xpc\",\"xpe\",\"xpg\",\"xpi\",\"xpj\",\"xpk\",\"xpm\",\"xpn\",\"xpo\",\"xpp\",\"xpq\",\"xpr\",\"xps\",\"xpt\",\"xpu\",\"xpy\",\"xqa\",\"xqt\",\"xra\",\"xrb\",\"xrd\",\"xre\",\"xrg\",\"xri\",\"xrm\",\"xrn\",\"xrq\",\"xrr\",\"xrt\",\"xru\",\"xrw\",\"xsa\",\"xsb\",\"xsc\",\"xsd\",\"xse\",\"xsh\",\"xsi\",\"xsj\",\"xsl\",\"xsm\",\"xsn\",\"xso\",\"xsp\",\"xsq\",\"xsr\",\"xss\",\"xsu\",\"xsv\",\"xsy\",\"xta\",\"xtb\",\"xtc\",\"xtd\",\"xte\",\"xtg\",\"xth\",\"xti\",\"xtj\",\"xtl\",\"xtm\",\"xtn\",\"xto\",\"xtp\",\"xtq\",\"xtr\",\"xts\",\"xtt\",\"xtu\",\"xtv\",\"xtw\",\"xty\",\"xtz\",\"xua\",\"xub\",\"xud\",\"xug\",\"xuj\",\"xul\",\"xum\",\"xun\",\"xuo\",\"xup\",\"xur\",\"xut\",\"xuu\",\"xve\",\"xvi\",\"xvn\",\"xvo\",\"xvs\",\"xwa\",\"xwc\",\"xwd\",\"xwe\",\"xwg\",\"xwj\",\"xwk\",\"xwl\",\"xwo\",\"xwr\",\"xwt\",\"xww\",\"xxb\",\"xxk\",\"xxm\",\"xxr\",\"xxt\",\"xya\",\"xyb\",\"xyj\",\"xyk\",\"xyl\",\"xyt\",\"xyy\",\"xzh\",\"xzm\",\"xzp\",\"yaa\",\"yab\",\"yac\",\"yad\",\"yae\",\"yaf\",\"yag\",\"yah\",\"yai\",\"yaj\",\"yak\",\"yal\",\"yam\",\"yan\",\"yao\",\"yap\",\"yaq\",\"yar\",\"yas\",\"yat\",\"yau\",\"yav\",\"yaw\",\"yax\",\"yay\",\"yaz\",\"yba\",\"ybb\",\"ybd\",\"ybe\",\"ybh\",\"ybi\",\"ybj\",\"ybk\",\"ybl\",\"ybm\",\"ybn\",\"ybo\",\"ybx\",\"yby\",\"ych\",\"ycl\",\"ycn\",\"ycp\",\"yda\",\"ydd\",\"yde\",\"ydg\",\"ydk\",\"yds\",\"yea\",\"yec\",\"yee\",\"yei\",\"yej\",\"yel\",\"yen\",\"yer\",\"yes\",\"yet\",\"yeu\",\"yev\",\"yey\",\"yga\",\"ygi\",\"ygl\",\"ygm\",\"ygp\",\"ygr\",\"ygs\",\"ygu\",\"ygw\",\"yha\",\"yhd\",\"yhl\",\"yhs\",\"yia\",\"yif\",\"yig\",\"yih\",\"yii\",\"yij\",\"yik\",\"yil\",\"yim\",\"yin\",\"yip\",\"yiq\",\"yir\",\"yis\",\"yit\",\"yiu\",\"yiv\",\"yix\",\"yiy\",\"yiz\",\"yka\",\"ykg\",\"yki\",\"ykk\",\"ykl\",\"ykm\",\"ykn\",\"yko\",\"ykr\",\"ykt\",\"yku\",\"yky\",\"yla\",\"ylb\",\"yle\",\"ylg\",\"yli\",\"yll\",\"ylm\",\"yln\",\"ylo\",\"ylr\",\"ylu\",\"yly\",\"yma\",\"ymb\",\"ymc\",\"ymd\",\"yme\",\"ymg\",\"ymh\",\"ymi\",\"ymk\",\"yml\",\"ymm\",\"ymn\",\"ymo\",\"ymp\",\"ymq\",\"ymr\",\"yms\",\"ymt\",\"ymx\",\"ymz\",\"yna\",\"ynd\",\"yne\",\"yng\",\"ynh\",\"ynk\",\"ynl\",\"ynn\",\"yno\",\"ynq\",\"yns\",\"ynu\",\"yob\",\"yog\",\"yoi\",\"yok\",\"yol\",\"yom\",\"yon\",\"yos\",\"yot\",\"yox\",\"yoy\",\"ypa\",\"ypb\",\"ypg\",\"yph\",\"ypk\",\"ypm\",\"ypn\",\"ypo\",\"ypp\",\"ypz\",\"yra\",\"yrb\",\"yre\",\"yri\",\"yrk\",\"yrl\",\"yrm\",\"yrn\",\"yro\",\"yrs\",\"yrw\",\"yry\",\"ysc\",\"ysd\",\"ysg\",\"ysl\",\"ysn\",\"yso\",\"ysp\",\"ysr\",\"yss\",\"ysy\",\"yta\",\"ytl\",\"ytp\",\"ytw\",\"yty\",\"yua\",\"yub\",\"yuc\",\"yud\",\"yue\",\"yuf\",\"yug\",\"yui\",\"yuj\",\"yuk\",\"yul\",\"yum\",\"yun\",\"yup\",\"yuq\",\"yur\",\"yut\",\"yuu\",\"yuw\",\"yux\",\"yuy\",\"yuz\",\"yva\",\"yvt\",\"ywa\",\"ywg\",\"ywl\",\"ywn\",\"ywq\",\"ywr\",\"ywt\",\"ywu\",\"yww\",\"yxa\",\"yxg\",\"yxl\",\"yxm\",\"yxu\",\"yxy\",\"yyr\",\"yyu\",\"yyz\",\"yzg\",\"yzk\",\"zaa\",\"zab\",\"zac\",\"zad\",\"zae\",\"zaf\",\"zag\",\"zah\",\"zai\",\"zaj\",\"zak\",\"zal\",\"zam\",\"zao\",\"zap\",\"zaq\",\"zar\",\"zas\",\"zat\",\"zau\",\"zav\",\"zaw\",\"zax\",\"zay\",\"zaz\",\"zbc\",\"zbe\",\"zbl\",\"zbt\",\"zbw\",\"zca\",\"zch\",\"zdj\",\"zea\",\"zeg\",\"zeh\",\"zen\",\"zga\",\"zgb\",\"zgh\",\"zgm\",\"zgn\",\"zgr\",\"zhb\",\"zhd\",\"zhi\",\"zhn\",\"zhw\",\"zhx\",\"zia\",\"zib\",\"zik\",\"zil\",\"zim\",\"zin\",\"zir\",\"ziw\",\"ziz\",\"zka\",\"zkb\",\"zkd\",\"zkg\",\"zkh\",\"zkk\",\"zkn\",\"zko\",\"zkp\",\"zkr\",\"zkt\",\"zku\",\"zkv\",\"zkz\",\"zle\",\"zlj\",\"zlm\",\"zln\",\"zlq\",\"zls\",\"zlw\",\"zma\",\"zmb\",\"zmc\",\"zmd\",\"zme\",\"zmf\",\"zmg\",\"zmh\",\"zmi\",\"zmj\",\"zmk\",\"zml\",\"zmm\",\"zmn\",\"zmo\",\"zmp\",\"zmq\",\"zmr\",\"zms\",\"zmt\",\"zmu\",\"zmv\",\"zmw\",\"zmx\",\"zmy\",\"zmz\",\"zna\",\"znd\",\"zne\",\"zng\",\"znk\",\"zns\",\"zoc\",\"zoh\",\"zom\",\"zoo\",\"zoq\",\"zor\",\"zos\",\"zpa\",\"zpb\",\"zpc\",\"zpd\",\"zpe\",\"zpf\",\"zpg\",\"zph\",\"zpi\",\"zpj\",\"zpk\",\"zpl\",\"zpm\",\"zpn\",\"zpo\",\"zpp\",\"zpq\",\"zpr\",\"zps\",\"zpt\",\"zpu\",\"zpv\",\"zpw\",\"zpx\",\"zpy\",\"zpz\",\"zqe\",\"zra\",\"zrg\",\"zrn\",\"zro\",\"zrp\",\"zrs\",\"zsa\",\"zsk\",\"zsl\",\"zsm\",\"zsr\",\"zsu\",\"zte\",\"ztg\",\"ztl\",\"ztm\",\"ztn\",\"ztp\",\"ztq\",\"zts\",\"ztt\",\"ztu\",\"ztx\",\"zty\",\"zua\",\"zuh\",\"zum\",\"zun\",\"zuy\",\"zwa\",\"zxx\",\"zyb\",\"zyg\",\"zyj\",\"zyn\",\"zyp\",\"zza\",\"zzj\"]\n;return axe.utils.validLangs=function(){\"use strict\";return N},commons}()})}(\"object\"==typeof window?window:this);";const pageFunctions=require('../../lib/page-functions');function runA11yChecks(){return window.axe.run(document,{elementRef:true,runOnly:{type:'tag',values:['wcag2a','wcag2aa']},resultTypes:['violations','inapplicable'],rules:{'tabindex':{enabled:true},'table-fake-caption':{enabled:true},'td-has-header':{enabled:true},'area-alt':{enabled:false},'blink':{enabled:false},'server-side-image-map':{enabled:false}}}).then(axeResult=>{axeResult.violations.forEach(v=>v.nodes.forEach(node=>{node.path=getNodePath(node.element);node.snippet=getOuterHTMLSnippet(node.element);node.element=node.any=node.all=node.none=undefined;}));axeResult={violations:axeResult.violations,notApplicable:axeResult.inapplicable};return axeResult;});function getNodePath(node){function getNodeIndex(node){let index=0;let prevNode;while(prevNode=node.previousSibling){node=prevNode;if(node.nodeType===Node.TEXT_NODE&&node.textContent&&node.textContent.trim().length===0)continue;index++;}
return index;}
const path=[];while(node&&node.parentNode){const index=getNodeIndex(node);path.push([index,node.nodeName]);node=node.parentNode;}
path.reverse();return path.join(',');}}
class Accessibility extends Gatherer{afterPass(passContext){const driver=passContext.driver;const expression=`(function () {
      ${pageFunctions.getOuterHTMLSnippetString};
      ${axeLibSource};
      return (${runA11yChecks.toString()}());
    })()`;return driver.evaluateAsync(expression,{useIsolation:true}).then(returnedValue=>{if(!returnedValue){throw new Error('No axe-core results returned');}
if(!Array.isArray(returnedValue.violations)){throw new Error('Unable to parse axe results'+returnedValue);}
return returnedValue;});}}
module.exports=Accessibility;},{"../../lib/page-functions":89,"./gatherer":21}],"../gather/gatherers/cache-contents":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getCacheContents(){return caches.keys().then(cacheNames=>Promise.all(cacheNames.map(cacheName=>caches.open(cacheName)))).then(caches=>{const requests=[];return Promise.all(caches.map(cache=>{return cache.keys().then(reqs=>{requests.push(...reqs.map(r=>r.url));});})).then(_=>{return requests;});});}
class CacheContents extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const cacheUrls=await driver.evaluateAsync(`(${getCacheContents.toString()}())`);if(!cacheUrls||!Array.isArray(cacheUrls)){throw new Error('Unable to retrieve cache contents');}
return cacheUrls;}}
module.exports=CacheContents;},{"./gatherer":21}],"../gather/gatherers/chrome-console-messages":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ChromeConsoleMessages extends Gatherer{constructor(){super();this._logEntries=[];this._onConsoleEntryAdded=this.onConsoleEntry.bind(this);}
onConsoleEntry(entry){this._logEntries.push(entry);}
async beforePass(passContext){const driver=passContext.driver;driver.on('Log.entryAdded',this._onConsoleEntryAdded);await driver.sendCommand('Log.enable');await driver.sendCommand('Log.startViolationsReport',{config:[{name:'discouragedAPIUse',threshold:-1}]});}
async afterPass(passContext){await passContext.driver.sendCommand('Log.stopViolationsReport');await passContext.driver.off('Log.entryAdded',this._onConsoleEntryAdded);await passContext.driver.sendCommand('Log.disable');return this._logEntries;}}
module.exports=ChromeConsoleMessages;},{"./gatherer":21}],"../gather/gatherers/css-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class CSSUsage extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const stylesheets=[];const onStylesheetAdded=sheet=>stylesheets.push(sheet);driver.on('CSS.styleSheetAdded',onStylesheetAdded);await driver.sendCommand('DOM.enable');await driver.sendCommand('CSS.enable');await driver.sendCommand('CSS.startRuleUsageTracking');await driver.evaluateAsync('getComputedStyle(document.body)');driver.off('CSS.styleSheetAdded',onStylesheetAdded);const promises=stylesheets.map(sheet=>{const styleSheetId=sheet.header.styleSheetId;return driver.sendCommand('CSS.getStyleSheetText',{styleSheetId}).then(content=>{return{header:sheet.header,content:content.text};});});const styleSheetInfo=await Promise.all(promises);const ruleUsageResponse=await driver.sendCommand('CSS.stopRuleUsageTracking');await driver.sendCommand('CSS.disable');await driver.sendCommand('DOM.disable');const dedupedStylesheets=new Map(styleSheetInfo.map(sheet=>{return[sheet.content,sheet];}));return{rules:ruleUsageResponse.ruleUsage,stylesheets:Array.from(dedupedStylesheets.values())};}}
module.exports=CSSUsage;},{"./gatherer":21}],"../gather/gatherers/dobetterweb/anchors-with-no-rel-noopener":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const pageFunctions=require('../../../lib/page-functions.js');class AnchorsWithNoRelNoopener extends Gatherer{afterPass(passContext){const expression=`(function() {
      ${pageFunctions.getOuterHTMLSnippetString};
      ${pageFunctions.getElementsInDocumentString}; // define function on page
      const selector = 'a[target="_blank"]:not([rel~="noopener"]):not([rel~="noreferrer"])';
      const elements = getElementsInDocument(selector);
      return elements.map(node => ({
        href: node.href,
        rel: node.getAttribute('rel'),
        target: node.getAttribute('target'),
        outerHTML: getOuterHTMLSnippet(node),
      }));
    })()`;return passContext.driver.evaluateAsync(expression);}}
module.exports=AnchorsWithNoRelNoopener;},{"../../../lib/page-functions.js":89,"../gatherer":21}],"../gather/gatherers/dobetterweb/appcache":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class AppCacheManifest extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelector('html').then(node=>node&&node.getAttribute('manifest'));}}
module.exports=AppCacheManifest;},{"../gatherer":21}],"../gather/gatherers/dobetterweb/doctype":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');function getDoctype(){if(!document.doctype){return null;}
const{name,publicId,systemId}=document.doctype;return{name,publicId,systemId};}
class Doctype extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.evaluateAsync(`(${getDoctype.toString()}())`);}}
module.exports=Doctype;},{"../gatherer":21}],"../gather/gatherers/dobetterweb/domstats":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const pageFunctions=require('../../../lib/page-functions');function createSelectorsLabel(element){let name=element.localName||'';const idAttr=element.getAttribute&&element.getAttribute('id');if(idAttr){name+=`#${idAttr}`;}
if(element.classList){const className=element.classList.toString();if(className){name+=`.${className.trim().replace(/\s+/g,'.')}`;}}else if(ShadowRoot.prototype.isPrototypeOf(element)){name+='#shadow-root';}
return name;}
function elementPathInDOM(element){const visited=new Set();const path=[createSelectorsLabel(element)];let node=element;while(node){visited.add(node);if(ShadowRoot.prototype.isPrototypeOf(node)){const isShadowHost=node.host&&node.localName!=='a';node=isShadowHost?node.host:node.parentElement;}else{const isShadowHost=node.parentNode&&node.parentNode.host&&node.parentNode.localName!=='a';node=isShadowHost?node.parentNode.host:node.parentElement;}
if(visited.has(node)){node=null;}
if(node){path.unshift(createSelectorsLabel(node));}}
return path;}
function getDOMStats(element,deep=true){let deepestNode=null;let maxDepth=0;let maxWidth=0;let parentWithMostChildren=null;const _calcDOMWidthAndHeight=function(element,depth=1){if(depth>maxDepth){deepestNode=element;maxDepth=depth;}
if(element.children.length>maxWidth){parentWithMostChildren=element;maxWidth=element.children.length;}
let child=element.firstElementChild;while(child){_calcDOMWidthAndHeight(child,depth+1);if(deep&&child.shadowRoot){_calcDOMWidthAndHeight(child.shadowRoot,depth+1);}
child=child.nextElementSibling;}
return{maxDepth,maxWidth};};const result=_calcDOMWidthAndHeight(element);return{depth:{max:result.maxDepth,pathToElement:elementPathInDOM(deepestNode),snippet:getOuterHTMLSnippet(deepestNode,['style'])},width:{max:result.maxWidth,pathToElement:elementPathInDOM(parentWithMostChildren),snippet:getOuterHTMLSnippet(parentWithMostChildren,['style'])}};}
class DOMStats extends Gatherer{afterPass(passContext){const expression=`(function() {
      ${pageFunctions.getOuterHTMLSnippetString};
      ${createSelectorsLabel.toString()};
      ${elementPathInDOM.toString()};
      return (${getDOMStats.toString()}(document.documentElement));
    })()`;return passContext.driver.sendCommand('DOM.enable').then(()=>passContext.driver.evaluateAsync(expression,{useIsolation:true})).then(results=>passContext.driver.getElementsInDocument().then(allNodes=>{results.totalDOMNodes=allNodes.length;return passContext.driver.sendCommand('DOM.disable').then(()=>results);}));}}
module.exports=DOMStats;},{"../../../lib/page-functions":89,"../gatherer":21}],"../gather/gatherers/dobetterweb/js-libraries":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const libDetectorSource="var UNKNOWN_VERSION = null;\nvar d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests = {\n\n    'GWT': {\n        icon: 'gwt',\n        url: 'http://www.gwtproject.org/',\n        test: function(win) {\n            // pretty complicated, many possible tell tales\n            var doc = win.document,\n                hasHistFrame = doc.getElementById('__gwt_historyFrame'),\n                hasGwtUid = doc.gwt_uid,\n                hasBodyListener = doc.body.__listener,\n                hasBodyEventBits = doc.body.__eventBits,\n                hasModules = win.__gwt_activeModules,\n                hasJsonP = win.__gwt_jsonp__,\n                hasRootWinApp = win.__gwt_scriptsLoaded || win.__gwt_stylesLoaded || win.__gwt_activeModules;\n\n            // use the many possible indicators\n            if(hasHistFrame || hasGwtUid || hasBodyListener || hasBodyEventBits || hasModules || hasJsonP || hasRootWinApp) {\n\n                // carefully look at frames, but only if certain is GWT frame\n                var frames = doc.getElementsByTagName('iframe'),\n                    gwtVersion = UNKNOWN_VERSION;\n                for(var n=0; n<frames.length; n++) {\n                    // catch security access errors\n                    try {\n                        var hasNegativeTabIndex = frames[n].tabIndex < 0; // on for GWT\n                        if(hasNegativeTabIndex && frames[n].contentWindow && frames[n].contentWindow.$gwt_version) {\n                            gwtVersion = frames[n].contentWindow.$gwt_version;\n                            break;\n                        }\n                    }\n                    catch(e) {}\n                }\n\n                if(gwtVersion=='0.0.999') {\n                  gwtVersion = 'Google Internal';\n                }\n\n                return { version: gwtVersion };\n            }\n            return false;\n        }\n    },\n\n    'Ink': {\n        icon: 'ink',\n        url: 'http://ink.sapo.pt/',\n        test: function(win) {\n            if (win.Ink && win.Ink.createModule) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Vaadin': {\n        icon: 'vaadin',\n        url: 'https://vaadin.com/',\n        test: function(win) {\n            if (win.vaadin && win.vaadin.registerWidgetset) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Bootstrap': {\n        icon: 'bootstrap',\n        url: 'http://getbootstrap.com/',\n        npm: 'bootstrap',\n        // look for a function Boostrap has added to jQuery - regex for BS 2 & 3\n        test: function(win) {\n            var jQueryAvailable = win.$ && win.$.fn,\n                RE_PREFIX_V2 = '\\\\$this\\\\.data\\\\((?:\\'|\")',\n                RE_PREFIX_V3 = '\\\\$this\\\\.data\\\\((?:\\'|\")(?:bs\\\\.){1}',\n                bootstrapComponents = [\n                    'affix', 'alert', 'button', 'carousel', 'collapse', 'dropdown',\n                    'modal', 'popover', 'scrollspy', 'tab', 'tooltip'\n                ];\n\n            if(jQueryAvailable) {\n                var bootstrapVersion;\n\n                bootstrapComponents.some(function(component) {\n                    if(win.$.fn[component]) {\n                        // Bootstrap >= 3.2.0 detection\n                        if(win.$.fn[component].Constructor && win.$.fn[component].Constructor.VERSION) {\n                            bootstrapVersion = win.$.fn[component].Constructor.VERSION;\n                            return true;\n                        // Bootstrap >= 2.0.0 and <= 3.1.0 detection\n                        } else if(new RegExp(RE_PREFIX_V3 + component).test(win.$.fn[component].toString())) {\n                            bootstrapVersion = '>= 3.0.0 & <= 3.1.1';\n                            return true;\n                        // Bootstrap < 3.1.0 detection\n                        } else if(new RegExp(RE_PREFIX_V2 + component).test(win.$.fn[component].toString())) {\n                            bootstrapVersion = '>= 2.0.0 & <= 2.3.2';\n                            return true;\n                        }\n                    }\n\n                    return false;\n                });\n\n                if (bootstrapVersion) {\n                    return { version: bootstrapVersion };\n                }\n            }\n\n            return false;\n        }\n    },\n\n    'Zurb': {\n        icon: 'zurb',\n        url: 'https://foundation.zurb.com/',\n        npm: 'foundation-sites',\n        test: function(win) {\n            if(win.Foundation && win.Foundation.Toggler) {\n                return { version: win.Foundation.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Polymer': {\n        icon: 'polymer',\n        url: 'https://www.polymer-project.org/',\n        npm: '@polymer/polymer',\n        test: function(win) {\n            if(win.Polymer && win.Polymer.dom) {\n                return { version: win.Polymer.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Highcharts': {\n        icon: 'highcharts',\n        url: 'http://www.highcharts.com',\n        npm: 'highcharts',\n        test: function(win) {\n            if(win.Highcharts && win.Highcharts.Point) {\n                return { version: win.Highcharts.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'InfoVis': {\n        icon: 'jit',\n        url: 'http://philogb.github.com/jit/',\n        test: function test(win) {\n            if(win.$jit && win.$jit.PieChart) {\n                return { version: win.$jit.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'FlotCharts': {\n        icon: 'flotcharts',\n        url: 'http://www.flotcharts.org/',\n        npm: 'flot',\n        test: function(win) {\n            if(win.$ && win.$.plot) {\n                return { version: win.$.plot.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'CreateJS': {\n        icon: 'createjs',\n        url: 'https://createjs.com/',\n        npm: 'createjs',\n        test: function(win) {\n            if(win.createjs && win.createjs.promote) {\n                return { version: UNKNOWN_VERSION}; // no version info available\n            }\n            return false;\n        }\n    },\n\n    'Google Maps': {\n        icon: 'gmaps',\n        url: 'https://developers.google.com/maps/',\n        test: function(win) {\n            if (win.google && win.google.maps) {\n                return { version: win.google.maps.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'jQuery': {\n        icon: 'jquery',\n        url: 'http://jquery.com',\n        npm: 'jquery',\n        test: function(win) {\n            var jq = win.jQuery || win.$;\n            if (jq && jq.fn) {\n                return { version: jq.fn.jquery.replace(/[^\\d+\\.+]/g, '') || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'jQuery UI': {\n        icon: 'jquery_ui',\n        url: 'http://jqueryui.com',\n        npm: 'jquery-ui',\n        test: function(win) {\n            var jq = win.jQuery || win.$ || win.$jq || win.$j;\n            if(jq && jq.fn && jq.fn.jquery && jq.ui) {\n                var plugins = 'accordion,datepicker,dialog,draggable,droppable,progressbar,resizable,selectable,slider,menu,grid,tabs'.split(','), concat = [];\n                for (var i=0; i < plugins.length; i++) { if(jq.ui[plugins[i]]) concat.push(plugins[i].substr(0,1).toUpperCase() + plugins[i].substr(1)); }\n                return { version: jq.ui.version || UNKNOWN_VERSION, details: concat.length ? 'Plugins used: '+concat.join(',') : '' };\n            }\n            return false;\n        }\n    },\n\n    'Dojo': {\n        icon: 'dojo',\n        url: 'http://dojotoolkit.org',\n        npm: 'dojo',\n        test: function(win) {\n            if(win.dojo && win.dojo.delegate) {\n                var version = win.dojo.version ? win.dojo.version.toString() : UNKNOWN_VERSION;\n                return { version: version, details: 'Details: '+(win.dijit ? 'Uses Dijit' : 'none') };\n            }\n            return false;\n        }\n    },\n\n    'Prototype': {\n        icon: 'prototype',\n        url: 'http://prototypejs.org',\n        test: function(win) {\n            if(win.Prototype && win.Prototype.BrowserFeatures) {\n                return { version: win.Prototype.Version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Scriptaculous': {\n        icon: 'scriptaculous',\n        url: 'http://script.aculo.us',\n        test: function(win) {\n            if(win.Scriptaculous && win.Scriptaculous.load) {\n                return { version: win.Scriptaculous.Version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'MooTools': {\n        icon: 'mootools',\n        url: 'https://mootools.net/',\n        test: function(win) {\n            if(win.MooTools && win.MooTools.build) {\n                return { version: win.MooTools.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Spry': {\n        icon: 'spry',\n        url: 'http://labs.adobe.com/technologies/spry',\n        test: function(win) {\n            if (win.Spry && win.Spry.Data) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'YUI 2': {\n        icon: 'yui',\n        url: 'http://developer.yahoo.com/yui/2/',\n        test: function(win) {\n            if (win.YAHOO && win.YAHOO.util) {\n                return { version: win.YAHOO.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'YUI 3': {\n        icon: 'yui3',\n        url: 'https://yuilibrary.com/',\n        npm: 'yui',\n        test: function(win) {\n            if (win.YUI && win.YUI.Env) {\n                return { version: win.YUI.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Qooxdoo': {\n        icon: 'qooxdoo',\n        url: 'http://www.qooxdoo.org/',\n        npm: 'qooxdoo',\n        test: function(win) {\n            if(win.qx && win.qx.Bootstrap) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Ext JS': {\n        icon: 'extjs',\n        url: 'https://www.sencha.com/products/extjs/',\n        test: function(win) {\n            if (win.Ext && win.Ext.versions) {\n                return { version: win.Ext.versions.core.version };\n            }\n            else if(win.Ext) {\n                return { version: win.Ext.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'base2': {\n        icon: 'base2',\n        url: 'http://code.google.com/p/base2',\n        test: function(win) {\n            if(win.base2 && win.base2.dom) {\n                return { version: win.base2.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Closure Library': {\n        icon: 'closure',\n        url: 'https://developers.google.com/closure/library/',\n        npm: 'google-closure-library',\n        test: function(win) {\n            if(win.goog && win.goog.provide) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Rapha&euml;l': {\n        icon: 'raphael',\n        url: 'http://dmitrybaranovskiy.github.io/raphael/',\n        test: function(win) {\n            if (win.Raphael && win.Raphael.circle) {\n                return { version: win.Raphael.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'React': {\n        icon: 'react',\n        url: 'https://reactjs.org/',\n        npm: 'react',\n        test: function(win) {\n            function isReactNode(node) {\n                return node._reactRootContainer!=null;\n            }\n            var reactRoot = document.getElementById('react-root');\n            var altHasReact = document.querySelector('*[data-reactroot]');\n            var bodyReactRoot = isReactNode(document.body) || isReactNode(document.body.firstElementChild || {});\n            var hasReactRoot = bodyReactRoot|| document.createTreeWalker(document.body, 3, isReactNode).nextNode() != null;\n            if (hasReactRoot || reactRoot && reactRoot.innerText.length > 0 || altHasReact || win.React && win.React.Component) {\n                return { version: win.React && win.React.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Preact': {\n        icon: 'preact',\n        url: 'https://preactjs.com/',\n        npm: 'preact',\n        test: function(win) {\n            var expando = typeof Symbol!='undefined' && Symbol.for && Symbol.for('preactattr');\n            function isPreactNode(node) {\n                if (node._component!=null || node.__preactattr_!=null || expando && node[expando]!=null) {\n                    return node;\n                }\n                return null;\n            }\n            var preactRoot = isPreactNode(document.body) || isPreactNode(document.body.firstElementChild || {});\n            if (!preactRoot) {\n                preactRoot = document.createTreeWalker(document.body, 3, isPreactNode).nextNode();\n            }\n            if (preactRoot || win.preact) {\n                var version = UNKNOWN_VERSION;\n                if (expando && preactRoot && preactRoot[expando]!=null) {\n                    version = '7';\n                }\n                return { version: version };\n            }\n            return false;\n        }\n    },\n\n    'Modernizr': {\n        icon: 'modernizr',\n        url: 'https://modernizr.com/',\n        npm: 'modernizr',\n        test: function(win) {\n            if (win.Modernizr && win.Modernizr.addTest) {\n                return { version: win.Modernizr._version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Processing.js': {\n        icon: 'processingjs',\n        url: 'http://processingjs.org',\n        npm: 'processing-js',\n        test: function(win) {\n            if(win.Processing && win.Processing.box) {\n                return { version: Processing.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Backbone': {\n        icon: 'backbone',\n        url: 'http://backbonejs.org/',\n        npm: 'backbone',\n        test: function(win) {\n            if (win.Backbone && win.Backbone.Model.extend) {\n                return {version: win.Backbone.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Leaflet': {\n        icon: 'leaflet',\n        url: 'http://leafletjs.com',\n        npm: 'leaflet',\n        test: function(win) {\n            // Leaflet 3.1 uses L.Marker and L.VERSION; later versions use L.marker and L.version\n            if (win.L && win.L.GeoJSON && (win.L.marker || win.L.Marker)) {\n                return { version: win.L.version || win.L.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Mapbox': {\n        icon: 'mapbox',\n        url: 'https://www.mapbox.com/',\n        npm: 'mapbox-gl',\n        test: function(win) {\n            if (win.L && win.L.mapbox && win.L.mapbox.geocoder) {\n                return { version: win.L.mapbox.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Lo-Dash': {\n        icon: 'lodash',\n        url: 'https://lodash.com/',\n        npm: 'lodash',\n        test: function(win) {\n            var _ = typeof (_ = win._) == 'function' && _,\n                chain = typeof (chain = _ && _.chain) == 'function' && chain,\n                wrapper = (chain || _ || function() { return {}; })(1);\n\n            if (_ && wrapper.__wrapped__) {\n                return { version: _.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Underscore': {\n        icon: 'underscore',\n        url: 'http://underscorejs.org/',\n        npm: 'underscore',\n        test: function(win) {\n            if (win._ && typeof win._.tap === 'function' &&\n                !d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests['Lo-Dash'].test(win)) {\n                return {version: win._.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Sammy': {\n        icon: 'sammy',\n        url: 'http://sammyjs.org',\n        test: function(win) {\n            if (win.Sammy && win.Sammy.Application.curry) {\n                return {version: win.Sammy.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Rico': {\n        icon: 'rico',\n        url: 'http://openrico.sourceforge.net/examples/index.html',\n        test:  function(win) {\n            if (win.Rico && window.Rico.checkIfComplete) {\n                return {version: win.Rico.Version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'MochiKit': {\n        icon: 'mochikit',\n        url: 'https://mochi.github.io/mochikit/',\n        test: function(win) {\n            if (win.MochiKit && win.MochiKit.Base.module) {\n                return {version: MochiKit.VERSION || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'gRapha&euml;l': {\n        icon: 'graphael',\n        url: 'https://github.com/DmitryBaranovskiy/g.raphael',\n        test: function(win) {\n            if (win.Raphael && win.Raphael.fn.g) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Glow': {\n        icon: 'glow',\n        url: 'http://www.bbc.co.uk/glow/',\n        test: function(win) {\n            if (win.gloader && win.gloader.getRequests) {\n                return {version: UNKNOWN_VERSION};\n            }\n            else if (win.glow && win.glow.dom) {\n                return {version: win.glow.VERSION || UNKNOWN_VERSION};\n            }\n            else if (win.Glow) {\n                return {version: win.Glow.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Socket.IO': {\n        icon: 'socketio', // currently has no icon\n        url: 'https://socket.io/',\n        npm: 'socket.io',\n        test: function(win) {\n            // version 0.6.2 uses only io.Socket; more recent versions also have io.sockets\n            if (win.io && (win.io.sockets || win.io.Socket)) {\n                return {version: win.io.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Mustache': {\n        icon: 'mustache',\n        url: 'http://mustache.github.io/',\n        npm: 'mustache',\n        test: function(win) {\n            if (win.Mustache && win.Mustache.to_html) {\n                return {version: win.Mustache.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Fabric.js': {\n        icon: 'icon38', // currently has no icon\n        url: 'http://fabricjs.com/',\n        npm: 'fabric',\n        test: function(win) {\n            if (win.fabric && win.fabric.util) {\n                return {version: win.fabric.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'FuseJS': {\n        icon: 'fusejs',\n        url: 'http://fusejs.io/',\n        npm: 'fuse.js',\n        test: function(win) {\n            if (win.Fuse) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Tween.js': {\n        icon: 'icon38', // currently has no icon\n        url: 'https://github.com/tweenjs/tween.js',\n        npm: 'tween.js',\n        test: function(win) {\n            if (win.TWEEN && win.TWEEN.Easing) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'SproutCore': {\n       icon: 'sproutcore',\n       url: 'http://sproutcore.com/',\n       test: function(win) {\n           if (win.SC && win.SC.Application) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'Zepto.js': {\n       icon: 'zepto',\n       url: 'http://zeptojs.com',\n       npm: 'zepto',\n       test: function(win) {\n           if (win.Zepto && win.Zepto.fn) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'three.js': {\n       icon: 'icon38', // currently has no icon\n       url: 'https://threejs.org/',\n       npm: 'three',\n       test: function(win) {\n           if (win.THREE && win.THREE.REVISION) {\n               return {version: 'r' + win.THREE.REVISION};\n           }\n           else if (win.THREE) {\n               return {version: UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'PhiloGL': {\n       icon: 'philogl',\n       url: 'http://www.senchalabs.org/philogl/',\n       npm: 'philogl',\n       test: function(win) {\n           if (win.PhiloGL && win.PhiloGL.Camera) {\n               return {version: win.PhiloGL.version || UNKNOWN_VERSION};\n           }\n           return false;\n       }\n    },\n\n    'CamanJS': {\n        icon: 'camanjs',\n        url: 'http://camanjs.com/',\n        npm: 'caman',\n        test: function(win) {\n            if (win.Caman && win.Caman.version) {\n                return {version: win.Caman.version.release};\n            }\n            else if (win.Caman) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'yepnope': {\n        icon: 'yepnope',\n        url: 'http://yepnopejs.com/',\n        test: function(win) {\n            if (win.yepnope && win.yepnope.injectJs) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'LABjs': {\n        icon: 'icon38',\n        url: 'https://github.com/getify/LABjs',\n        test: function(win) {\n            if (win.$LAB && win.$LAB.setOptions) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'Head JS': {\n        icon: 'headjs',\n        url: 'http://headjs.com/',\n        npm: 'headjs',\n        test: function(win) {\n            if (win.head && win.head.js) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'ControlJS': {\n        icon: 'icon38',\n        url: 'http://stevesouders.com/controljs/',\n        test: function(win) {\n            if (win.CJS && win.CJS.start) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'RequireJS': {\n        icon: 'requirejs',\n        url: 'http://requirejs.org/',\n        npm: 'requirejs',\n        test: function(win) {\n            var req = win.require || win.requirejs;\n            if (req && (req.load || (req.s && req.s.contexts && req.s.contexts._ && (req.s.contexts._.loaded || req.s.contexts._.load)))) {\n                return { version: req.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'RightJS': {\n        icon: 'rightjs',\n        url: 'http://rightjs.org/',\n        test: function(win) {\n            if (win.RightJS && win.RightJS.isNode) {\n                return { version: win.RightJS.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'jQuery Tools': {\n       icon: 'jquerytools',\n       url: 'http://jquerytools.github.io/',\n       test: function(win) {\n            var jq = win.jQuery || win.$;\n            if(jq && jq.tools) {\n               return { version: jq.tools.version || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Pusher': {\n       icon: 'pusher',\n       url: 'https://pusher.com/docs/',\n       npm: 'pusher-js',\n       test: function(win) {\n            if(win.Pusher && win.Pusher.Channel) {\n               return { version: win.Pusher.VERSION || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Paper.js': {\n       icon: 'paperjs',\n       url: 'http://paperjs.org/',\n       npm: 'paper',\n       test: function(win) {\n            if(win.paper && win.paper.Point) {\n               return { version: win.paper.version || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Swiffy': {\n       icon: 'icon38',\n       url: 'https://developers.google.com/swiffy/',\n       test: function(win) {\n            if(win.swiffy && win.swiffy.Stage) {\n               return { version: UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Move': {\n       icon: 'move',\n       url: 'https://github.com/rsms/move',\n       npm: 'move',\n       test: function(win) {\n            if(win.move && win.move.compile) {\n               return { version: win.move.version() || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'AmplifyJS': {\n       icon: 'amplifyjs',\n       url: 'http://amplifyjs.com/',\n       npm: 'amplifyjs',\n       test: function(win) {\n            if(win.amplify && win.amplify.publish) {\n               return { version: UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'Popcorn.js': {\n       icon: 'popcornjs',\n       url: 'https://github.com/mozilla/popcorn-js/',\n       test: function(win) {\n            if (win.Popcorn && win.Popcorn.Events) {\n               return { version: win.Popcorn.version || UNKNOWN_VERSION };\n           }\n           return false;\n       }\n    },\n\n    'D3': {\n        icon: 'd3',\n        url: 'https://d3js.org/',\n        npm: 'd3',\n        test: function(win) {\n            if (win.d3 && win.d3.select) {\n                return { version: win.d3.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Handlebars': {\n        icon: 'handlebars',\n        url: 'http://handlebarsjs.com/',\n        npm: 'handlebars',\n        test: function(win) {\n            if(win.Handlebars && win.Handlebars.compile) {\n                return { version: win.Handlebars.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Knockout': {\n        icon: 'knockout',\n        url: 'http://knockoutjs.com/',\n        npm: 'knockout',\n        test: function(win) {\n            if (win.ko && win.ko.applyBindings) {\n                return { version: win.ko.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Spine': {\n        icon: 'icon38',\n        url: 'http://spine.github.io/',\n        test: function(win) {\n            if (win.Spine && win.Spine.Controller) {\n                return {version: win.Spine.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n\n    'jQuery Mobile': {\n        icon: 'jquery_mobile',\n        url: 'http://jquerymobile.com/',\n        npm: 'jquery-mobile',\n        test: function(win) {\n            var jq = win.jQuery || win.$ || win.$jq || win.$j;\n            if(jq && jq.fn && jq.fn.jquery && jq.mobile) {\n                return { version: jq.mobile.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'WebFont Loader': {\n        icon: 'icon38',\n        url: 'https://github.com/typekit/webfontloader',\n        npm: 'webfontloader',\n        test: function(win) {\n            if(win.WebFont && win.WebFont.load) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Angular': {\n        icon: 'angular',\n        url: 'https://angular.io/',\n        npm: '@angular/core',\n        test: function(win) {\n            var ng = win.document.querySelector('[ng-version]');\n            if (ng) {\n                return { version: ng.getAttribute('ng-version') || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'AngularJS': {\n        icon: 'angularjs',\n        url: 'https://angularjs.org/',\n        npm: 'angular',\n        test: function(win) {\n            var ng = win.angular;\n            if(ng && ng.version && ng.version.full) {\n                return { version: ng.version.full };\n            }\n            else if (ng) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Ember.js': {\n        icon: 'emberjs',\n        url: 'https://emberjs.com/',\n        npm: 'ember-source',\n        test: function(win) {\n            var ember = win.Ember || win.Em;\n            if (ember && ember.propertyDidChange) {\n                return { version: ember.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Hammer.js': {\n        icon: 'hammerjs',\n        url: 'http://eightmedia.github.io/hammer.js/',\n        npm: 'hammerjs',\n        test: function(win) {\n            if(win.Hammer && win.Hammer.Pinch) {\n                // Hammer.VERSION available in 1.0.10+\n                return { version: win.Hammer.VERSION || \"&lt; 1.0.10\" };\n            }\n            return false;\n        }\n    },\n\n    'Visibility.js': {\n        icon: 'icon38',\n        url: 'https://github.com/ai/visibilityjs',\n        npm: 'visibilityjs',\n        test: function(win) {\n            if(win.Visibility && win.Visibility.every) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'Velocity.js': {\n        icon: 'icon38',\n        url: 'http://velocityjs.org/',\n        npm: 'velocity-animate',\n        test: function(win) {\n            var jq = win.jQuery || win.$,\n                velocity = jq ? jq.Velocity : win.Velocity;\n\n            if(velocity && velocity.RegisterEffect && velocity.version) {\n                return {\n                    version:\n                        velocity.version.major + \".\" +\n                        velocity.version.minor + \".\" +\n                        velocity.version.patch\n                };\n            }\n            else if (velocity && velocity.RegisterEffect) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n\n    'IfVisible.js': {\n        icon: 'icon38',\n        url: 'http://serkanyersen.github.io/ifvisible.js/',\n        npm: 'ifvisible.js',\n        test: function(win) {\n            var iv = win.ifvisible;\n            if(iv && iv.__ceGUID === \"ifvisible.object.event.identifier\") {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Pixi.js': {\n        icon: 'pixi',\n        url: 'http://www.pixijs.com/',\n        npm: 'pixi.js',\n        test: function(win) {\n            var px = win.PIXI;\n            if(px && px.WebGLRenderer && px.VERSION) {\n                // version 4.4.3 returns simply \"4.4.3\"; version 1.5.2 returns \"v1.5.2\"\n                return { version: px.VERSION.replace('v', '') || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'DC.js': {\n        icon: 'dcjs',\n        url: 'http://dc-js.github.io/dc.js/',\n        npm: 'dc',\n        test: function(win) {\n            var dc = win.dc;\n            if(dc && dc.registerChart) {\n                return { version: dc.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'GreenSock JS': {\n        icon: 'greensock',\n        url: 'https://greensock.com/gsap',\n        npm: 'gsap',\n        test: function(win) {\n            if (win.TweenMax && win.TweenMax.pauseAll) {\n                return { version: win.TweenMax.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'FastClick': {\n        icon: 'fastclick',\n        url: 'https://github.com/ftlabs/fastclick',\n        npm: 'fastclick',\n        test: function(win) {\n            if(win.FastClick && win.FastClick.notNeeded) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Isotope': {\n        icon: 'isotope',\n        url: 'https://isotope.metafizzy.co/',\n        npm: 'isotope-layout',\n        test: function(win) {\n            if(win.Isotope || (win.$ != null && win.$.Isotope)) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Marionette': {\n        icon: 'marionette',\n        url: 'https://marionettejs.com/',\n        npm: 'backbone.marionette',\n        test: function(win) {\n            if(win.Marionette && win.Marionette.Application) {\n                return { version: win.Marionette.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Can': {\n        icon: 'canjs',\n        url: 'https://canjs.com/',\n        npm: 'can',\n        test: function (win) {\n            if (win.can && win.can.Construct) {\n                return { version: win.can.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Vue': {\n        icon: 'vue',\n        url: 'https://vuejs.org/',\n        npm: 'vue',\n        test: function(win) {\n            if (win.Vue && win.Vue.nextTick) {\n                return { version: win.Vue.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Two': {\n        icon: 'two',\n        url: 'https://two.js.org/',\n        npm: 'two.js',\n        test: function(win) {\n            if (win.Two && win.Two.Utils) {\n                return { version: win.Two.Version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Brewser': {\n        icon: 'brewser',\n        url: 'https://robertpataki.github.io/brewser/',\n        npm: 'brewser',\n        test: function(win) {\n            if(win.BREWSER && win.BREWSER.ua) {\n                return { version: BREWSER.VERSION || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Material Design Lite': {\n        icon: 'mdl',\n        url: 'https://getmdl.io/',\n        npm: 'material-design-lite',\n        test: function(win) {\n            if(win.componentHandler && win.componentHandler.upgradeElement) {\n                return { version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n    'Kendo UI': {\n        icon: 'kendoui',\n        url: 'https://github.com/telerik/kendo-ui-core',\n        npm: 'kendo-ui-core',\n        test: function(win) {\n            if (win.kendo && win.kendo.View && win.kendo.View.extend) {\n                return {version: win.kendo.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n    'Matter.js': {\n        icon: 'matter-js',\n        url: 'http://brm.io/matter-js/',\n        npm: 'matter-js',\n        test: function(win) {\n            if (win.Matter && win.Matter.Engine) {\n                return {version: UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n    'Riot': {\n        icon: 'riot',\n        url: 'http://riotjs.com/',\n        npm: 'riot',\n        test: function(win) {\n            if (win.riot && win.riot.mixin) {\n                return { version: win.riot.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Sea.js': {\n        icon: 'icon38',\n        url: 'https://seajs.github.io/seajs/docs/',\n        npm: 'seajs',\n        test: function(win) {\n            if(win.seajs && win.seajs.use) {\n                return { version: win.seajs.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Moment.js': {\n        icon: 'momentjs',\n        url: 'http://momentjs.com/',\n        npm: 'moment',\n        test: function(win) {\n            if(win.moment && (win.moment.isMoment || win.moment.lang)) {\n                // version 1.0.0 has neither \"isMoment\" nor \"version\"\n                return { version: win.moment.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Moment Timezone': {\n        icon: 'momentjs',\n        url: 'http://momentjs.com/timezone/',\n        npm: 'moment-timezone',\n        test: function(win) {\n            if (win.moment && win.moment.tz) {\n                return { version: win.moment.tz.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'ScrollMagic': {\n        icon: 'scrollmagic',\n        url: 'http://scrollmagic.io/',\n        npm: 'scrollmagic',\n        test: function(win) {\n            if (win.ScrollMagic && win.ScrollMagic.Controller) {\n                return {version: ScrollMagic.version || UNKNOWN_VERSION};\n            }\n            return false;\n        }\n    },\n    'SWFObject': {\n        icon: 'icon38', // currently has no icon\n        url: 'https://github.com/swfobject/swfobject',\n        test: function(win) {\n            if (win.swfobject && win.swfobject.embedSWF) {\n                // 2.x - exact version only for 2.3\n                return { version: win.swfobject.version || UNKNOWN_VERSION };\n            } else if(win.deconcept && win.deconcept.SWFObject) {\n                // 1.x\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'FlexSlider': {\n        icon: 'icon38', // currently has no icon\n        url: 'https://woocommerce.com/flexslider/',\n        npm: 'flexslider',\n        test: function(win) {\n            var jq = win.jQuery || win.$ || win.$jq || win.$j;\n            if (jq && jq.fn && jq.fn.jquery && jq.flexslider){\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'SPF': {\n        icon: 'icon38', // currently has no icon\n        url: 'https://youtube.github.io/spfjs/',\n        npm: 'spf',\n        test: function(win) {\n            if (win.spf && win.spf.init) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Numeral.js': {\n        icon: 'icon38', // currently has no icon\n        url: 'http://numeraljs.com/',\n        npm: 'numeraljs',\n        test: function(win) {\n            if (win.numeral && win.isNumeral) {\n                return { version: win.numeral.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'boomerang.js': {\n        icon: 'icon38', // currently has no icon\n        url: 'https://soasta.github.io/boomerang/',\n        npm: 'boomerangjs',\n        test: function(win) {\n            if (win.BOOMR && win.BOOMR.utils && win.BOOMR.init) {\n                return { version: win.BOOMR.version || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Framer': {\n        icon: 'framer',\n        url: 'https://framer.com/',\n        npm: 'framerjs',\n        test: function(win) {\n            if (win.Framer && win.Framer.Layer) {\n                return { version: win.Framer.Version.build || UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'Marko': {\n        icon: 'marko',\n        url: 'https://markojs.com/',\n        npm: 'marko',\n        test: function (win) {\n            var selector = '[data-marko-key], [data-marko]';\n            var markoElement = document.querySelector(selector);\n            if (markoElement) {\n                return { version: UNKNOWN_VERSION };\n            }\n            return false;\n        }\n    },\n    'AMP': {\n        icon: 'amp',\n        url: 'https://ampproject.org/',\n        npm: null,\n        test: function (win) {\n            var version = win.document.documentElement.getAttribute(\"amp-version\");\n            return version ? { version: version } : false;\n        }\n    },\n    'Workbox': {\n      icon: 'workbox',\n      url: 'https://developers.google.com/web/tools/workbox/',\n      npm: 'workbox-sw',\n      test: async function (win) {\n        var nav = win.navigator;\n        // Service Workers not supported\n        if (!('serviceWorker' in nav)) {\n          return false;\n        }\n        return nav.serviceWorker.getRegistration()\n        .then(function(registration) {\n          var scriptURL = nav.serviceWorker.controller.scriptURL;\n          return fetch(scriptURL, { credentials: 'include',\n            headers: { 'service-worker': 'script' }\n          })\n          .then(function(response) {\n            return response.text();\n          })\n          .then(function(scriptContent) {\n            var workboxRegExp = /new Workbox|new workbox|workbox\\.precaching\\.|workbox\\.strategies/gm;\n            if (workboxRegExp.test(scriptContent)) {\n              // Adapted from\n              // https://github.com/semver/semver/issues/232#issue-48635632\n              var semVerRegExp = /workbox.*?\\b((0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(-(0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(\\.(0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*)?(\\+[0-9a-zA-Z-]+(\\.[0-9a-zA-Z-]+)*)?)\\b/gim;\n              var matches = semVerRegExp.exec(scriptContent);\n              var version = UNKNOWN_VERSION;\n              if (Array.isArray(matches) && matches.length > 1 && matches[1]) {\n                version = matches[1];\n              }\n              return { version: version };\n            }\n            return false;\n          });\n        }).catch(function(exception) {\n          return false;\n        });\n      }\n    }\n};\n";function detectLibraries(){const libraries=[];Object.entries(d41d8cd98f00b204e9800998ecf8427e_LibraryDetectorTests).forEach(([name,lib])=>{try{const result=lib.test(window);if(result){libraries.push({name:name,version:result.version,npmPkgName:lib.npm});}}catch(e){}});return libraries;}
class JSLibraries extends Gatherer{afterPass(passContext){const expression=`(function () {
      ${libDetectorSource};
      return (${detectLibraries.toString()}());
    })()`;return passContext.driver.evaluateAsync(expression);}}
module.exports=JSLibraries;},{"../gatherer":21}],"../gather/gatherers/dobetterweb/optimized-images":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const URL=require('../../../lib/url-shim');const NetworkRequest=require('../../../lib/network-request');const Sentry=require('../../../lib/sentry');const Driver=require('../../driver.js');const JPEG_QUALITY=0.92;const WEBP_QUALITY=0.85;const MINIMUM_IMAGE_SIZE=4096;const IMAGE_REGEX=/^image\/((x|ms|x-ms)-)?(png|bmp|jpeg)$/;function getOptimizedNumBytes(url){return new Promise(function(resolve,reject){const img=new Image();const canvas=document.createElement('canvas');const context=canvas.getContext('2d');if(!context){return reject(new Error('unable to create canvas context'));}
function getTypeStats(type,quality){const dataURI=canvas.toDataURL(type,quality);const base64=dataURI.slice(dataURI.indexOf(',')+1);return{base64:base64.length,binary:atob(base64).length};}
img.addEventListener('error',reject);img.addEventListener('load',()=>{try{canvas.height=img.height;canvas.width=img.width;context.drawImage(img,0,0);const jpeg=getTypeStats('image/jpeg',0.92);const webp=getTypeStats('image/webp',0.85);resolve({jpeg,webp});}catch(err){reject(err);}},false);img.src=url;});}
class OptimizedImages extends Gatherer{static filterImageRequests(pageUrl,networkRecords){const seenUrls=new Set();return networkRecords.reduce((prev,record)=>{if(seenUrls.has(record.url)||!record.finished){return prev;}
seenUrls.add(record.url);const isOptimizableImage=record.resourceType===NetworkRequest.TYPES.Image&&IMAGE_REGEX.test(record.mimeType);const isSameOrigin=URL.originsMatch(pageUrl,record.url);const isBase64DataUri=/^data:.{2,40}base64\s*,/.test(record.url);const actualResourceSize=Math.min(record.resourceSize||0,record.transferSize||0);if(isOptimizableImage&&actualResourceSize>MINIMUM_IMAGE_SIZE){prev.push({isSameOrigin,isBase64DataUri,requestId:record.requestId,url:record.url,mimeType:record.mimeType,resourceSize:actualResourceSize});}
return prev;},[]);}
_getEncodedResponse(driver,requestId,encoding){requestId=NetworkRequest.getRequestIdForBackend(requestId);const quality=encoding==='jpeg'?JPEG_QUALITY:WEBP_QUALITY;const params={requestId,encoding,quality,sizeOnly:true};return driver.sendCommand('Audits.getEncodedResponse',params);}
calculateImageStats(driver,networkRecord){return Promise.resolve(networkRecord.requestId).then(requestId=>{if(this._getEncodedResponseUnsupported)return;return this._getEncodedResponse(driver,requestId,'jpeg').then(jpegData=>{return this._getEncodedResponse(driver,requestId,'webp').then(webpData=>{return{fromProtocol:true,originalSize:networkRecord.resourceSize,jpegSize:jpegData.encodedSize,webpSize:webpData.encodedSize};});}).catch(err=>{if(/wasn't found/.test(err.message)){this._getEncodedResponseUnsupported=true;}else{throw err;}});}).then(result=>{if(result)return result;if(!networkRecord.isSameOrigin&&!networkRecord.isBase64DataUri)return null;const script=`(${getOptimizedNumBytes.toString()})(${JSON.stringify(networkRecord.url)})`;return driver.evaluateAsync(script).then(stats=>{if(!stats)return null;const isBase64DataUri=networkRecord.isBase64DataUri;const base64Length=networkRecord.url.length-networkRecord.url.indexOf(',')-1;return{fromProtocol:false,originalSize:isBase64DataUri?base64Length:networkRecord.resourceSize,jpegSize:isBase64DataUri?stats.jpeg.base64:stats.jpeg.binary,webpSize:isBase64DataUri?stats.webp.base64:stats.webp.binary};});});}
async computeOptimizedImages(driver,imageRecords){const results=[];for(const record of imageRecords){try{const stats=await this.calculateImageStats(driver,record);if(stats===null){continue;}
const image={failed:false,...stats,...record};results.push(image);}catch(err){Sentry.captureException(err,{tags:{gatherer:'OptimizedImages'},extra:{imageUrl:URL.elideDataURI(record.url)},level:'warning'});const imageError={failed:true,errMsg:err.message,...record};results.push(imageError);}}
return results;}
afterPass(passContext,loadData){const networkRecords=loadData.networkRecords;const imageRecords=OptimizedImages.filterImageRequests(passContext.url,networkRecords);return Promise.resolve().then(_=>this.computeOptimizedImages(passContext.driver,imageRecords)).then(results=>{const successfulResults=results.filter(result=>!result.failed);if(results.length&&!successfulResults.length){throw new Error('All image optimizations failed');}
return results;});}}
module.exports=OptimizedImages;},{"../../../lib/network-request":88,"../../../lib/sentry":90,"../../../lib/url-shim":"url","../../driver.js":19,"../gatherer":21}],"../gather/gatherers/dobetterweb/password-inputs-with-prevented-paste":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const pageFunctions=require('../../../lib/page-functions');function findPasswordInputsWithPreventedPaste(){return Array.from(document.querySelectorAll('input[type="password"]')).filter(passwordInput=>!passwordInput.dispatchEvent(new ClipboardEvent('paste',{cancelable:true}))).map(passwordInput=>({snippet:getOuterHTMLSnippet(passwordInput)}));}
class PasswordInputsWithPreventedPaste extends Gatherer{afterPass(passContext){return passContext.driver.evaluateAsync(`(() => {
      ${pageFunctions.getOuterHTMLSnippetString};
      return (${findPasswordInputsWithPreventedPaste.toString()}());
    })()`);}}
module.exports=PasswordInputsWithPreventedPaste;},{"../../../lib/page-functions":89,"../gatherer":21}],"../gather/gatherers/dobetterweb/response-compression":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('../gatherer');const URL=require('../../../lib/url-shim');const Sentry=require('../../../lib/sentry');const NetworkRequest=require('../../../lib/network-request');const gzip=require('zlib').gzip;const CHROME_EXTENSION_PROTOCOL='chrome-extension:';const compressionHeaders=['content-encoding','x-original-content-encoding'];const compressionTypes=['gzip','br','deflate'];const binaryMimeTypes=['image','audio','video'];const textResourceTypes=[NetworkRequest.TYPES.Document,NetworkRequest.TYPES.Script,NetworkRequest.TYPES.Stylesheet,NetworkRequest.TYPES.XHR,NetworkRequest.TYPES.Fetch,NetworkRequest.TYPES.EventSource];class ResponseCompression extends Gatherer{static filterUnoptimizedResponses(networkRecords){const unoptimizedResponses=[];networkRecords.forEach(record=>{const mimeType=record.mimeType;const resourceType=record.resourceType||NetworkRequest.TYPES.Other;const resourceSize=record.resourceSize;const isBinaryResource=mimeType&&binaryMimeTypes.some(type=>mimeType.startsWith(type));const isTextResource=!isBinaryResource&&textResourceTypes.includes(resourceType);const isChromeExtensionResource=record.url.startsWith(CHROME_EXTENSION_PROTOCOL);if(!isTextResource||!resourceSize||!record.finished||isChromeExtensionResource||!record.transferSize||record.statusCode===304){return;}
const isContentEncoded=(record.responseHeaders||[]).find(header=>compressionHeaders.includes(header.name.toLowerCase())&&compressionTypes.includes(header.value));if(!isContentEncoded){unoptimizedResponses.push({requestId:record.requestId,url:record.url,mimeType:mimeType,transferSize:record.transferSize,resourceSize:resourceSize,gzipSize:0});}});return unoptimizedResponses;}
afterPass(passContext,loadData){const networkRecords=loadData.networkRecords;const textRecords=ResponseCompression.filterUnoptimizedResponses(networkRecords);const driver=passContext.driver;return Promise.all(textRecords.map(record=>{return driver.getRequestContent(record.requestId).then(content=>{if(!content){return record;}
return new Promise((resolve,reject)=>{return gzip(content,(err,res)=>{if(err){return reject(err);}
record.gzipSize=Buffer.byteLength(res,'utf8');resolve(record);});});}).catch(err=>{Sentry.captureException(err,{tags:{gatherer:'ResponseCompression'},extra:{url:URL.elideDataURI(record.url)},level:'warning'});record.gzipSize=undefined;return record;});}));}}
module.exports=ResponseCompression;}).call(this,require("buffer").Buffer);},{"../../../lib/network-request":88,"../../../lib/sentry":90,"../../../lib/url-shim":"url","../gatherer":21,"buffer":109,"zlib":106}],"../gather/gatherers/dobetterweb/tags-blocking-first-paint":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const Driver=require('../../driver.js');function installMediaListener(){window.___linkMediaChanges=[];Object.defineProperty(HTMLLinkElement.prototype,'media',{set:function(val){window.___linkMediaChanges.push({href:this.href,media:val,msSinceHTMLEnd:Date.now()-window.performance.timing.responseEnd,matches:window.matchMedia(val).matches});return this.setAttribute('media',val);}});}
function collectTagsThatBlockFirstPaint(){return new Promise((resolve,reject)=>{try{const tagList=[...document.querySelectorAll('link, head script[src]')].filter(tag=>{if(tag.tagName==='SCRIPT'){const scriptTag=tag;return(!scriptTag.hasAttribute('async')&&!scriptTag.hasAttribute('defer')&&!/^data:/.test(scriptTag.src)&&scriptTag.getAttribute('type')!=='module');}else if(tag.tagName==='LINK'){const linkTag=tag;const blockingStylesheet=linkTag.rel==='stylesheet'&&window.matchMedia(linkTag.media).matches&&!linkTag.disabled;const blockingImport=linkTag.rel==='import'&&!linkTag.hasAttribute('async');return blockingStylesheet||blockingImport;}
return false;}).map(tag=>{return{tagName:tag.tagName,url:tag.tagName==='LINK'?tag.href:tag.src,src:tag.src,href:tag.href,rel:tag.rel,media:tag.media,disabled:tag.disabled,mediaChanges:window.___linkMediaChanges.filter(item=>item.href===tag.href)};});resolve(tagList);}catch(e){const friendly='Unable to gather Scripts/Stylesheets/HTML Imports on the page';reject(new Error(`${friendly}: ${e.message}`));}});}
class TagsBlockingFirstPaint extends Gatherer{static _filteredAndIndexedByUrl(networkRecords){const result={};return networkRecords.reduce((prev,record)=>{if(!record.finished){return prev;}
const isParserGenerated=record.initiator.type==='parser';const isParserScriptOrStyle=/(css|script)/.test(record.mimeType)&&isParserGenerated;const isFailedRequest=record._failed;const isHtml=record.mimeType&&record.mimeType.includes('html');if(isHtml||isParserScriptOrStyle||isFailedRequest&&isParserGenerated){prev[record.url]={isLinkPreload:!!record.isLinkPreload,transferSize:record.transferSize,startTime:record.startTime,endTime:record.endTime};}
return prev;},result);}
static findBlockingTags(driver,networkRecords){const scriptSrc=`(${collectTagsThatBlockFirstPaint.toString()}())`;const firstRequestEndTime=networkRecords.reduce((min,record)=>Math.min(min,record.endTime),Infinity);return driver.evaluateAsync(scriptSrc).then(tags=>{const requests=TagsBlockingFirstPaint._filteredAndIndexedByUrl(networkRecords);return tags.reduce((prev,tag)=>{const request=requests[tag.url];if(request&&!request.isLinkPreload){const timesResourceBecameNonBlocking=(tag.mediaChanges||[]).filter(change=>!change.matches).map(change=>change.msSinceHTMLEnd);const earliestNonBlockingTime=Math.min(...timesResourceBecameNonBlocking);const lastTimeResourceWasBlocking=Math.max(request.startTime,firstRequestEndTime+earliestNonBlockingTime/1000);prev.push({tag,transferSize:request.transferSize||0,startTime:request.startTime,endTime:Math.min(request.endTime,lastTimeResourceWasBlocking)});requests[tag.url]=null;}
return prev;},[]);});}
beforePass(passContext){return passContext.driver.evaluateScriptOnNewDocument(`(${installMediaListener.toString()})()`);}
afterPass(passContext,loadData){return TagsBlockingFirstPaint.findBlockingTags(passContext.driver,loadData.networkRecords);}}
module.exports=TagsBlockingFirstPaint;},{"../../driver.js":19,"../gatherer":21}],"../gather/gatherers/dobetterweb/websql":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const Driver=require('../../driver.js');const MAX_WAIT_TIMEOUT=500;class WebSQL extends Gatherer{listenForDatabaseEvents(driver){let timeout;return new Promise((resolve,reject)=>{driver.once('Database.addDatabase',db=>{clearTimeout(timeout);driver.sendCommand('Database.disable').then(_=>resolve(db),reject);});driver.sendCommand('Database.enable').catch(reject);timeout=setTimeout(function(){resolve(null);},MAX_WAIT_TIMEOUT);});}
afterPass(passContext){return this.listenForDatabaseEvents(passContext.driver).then(result=>{return result&&result.database;});}}
module.exports=WebSQL;},{"../../driver.js":19,"../gatherer":21}],"../gather/gatherers/fonts":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const Sentry=require('../../lib/sentry');const fontFaceDescriptors=['display','family','featureSettings','stretch','style','unicodeRange','variant','weight'];function getAllLoadedFonts(descriptors){const getFont=fontFace=>{const fontRule={src:[]};descriptors.forEach(descriptor=>{fontRule[descriptor]=fontFace[descriptor];});return fontRule;};return document.fonts.ready.then(()=>{return Array.from(document.fonts).filter(fontFace=>fontFace.status==='loaded').map(getFont);});}
function getFontFaceFromStylesheets(){function getSheetsFontFaces(stylesheet){const fontUrlRegex='url\\((?:")([^"]+)(?:"|\')\\)';const fontFaceRules=[];if(stylesheet.cssRules){for(const rule of Array.from(stylesheet.cssRules)){if(rule instanceof CSSFontFaceRule){const fontsObject={display:rule.style.fontDisplay||'auto',family:rule.style.fontFamily?rule.style.fontFamily.replace(/"|'/g,''):'',stretch:rule.style.fontStretch||'normal',style:rule.style.fontStyle||'normal',weight:rule.style.fontWeight||'normal',variant:rule.style.fontVariant||'normal',unicodeRange:rule.style.unicodeRange||'U+0-10FFFF',featureSettings:rule.style.featureSettings||'normal',src:[]};const src=rule.style.src;if(src){const matches=src.match(new RegExp(fontUrlRegex,'g'));if(matches){matches.forEach(match=>{const res=new RegExp(fontUrlRegex).exec(match);if(res){fontsObject.src.push(new URL(res[1],location.href).href);}});}}
fontFaceRules.push(fontsObject);}}}
return fontFaceRules;}
function loadStylesheetWithCORS(oldNode){const newNode=oldNode.cloneNode(true);return new Promise(resolve=>{newNode.addEventListener('load',function onload(){newNode.removeEventListener('load',onload);try{const stylesheet=Array.from(document.styleSheets).find(s=>s.ownerNode===newNode);if(stylesheet){const cssStylesheet=stylesheet;resolve(getSheetsFontFaces(cssStylesheet));}else{resolve([{err:{message:'Could not load stylesheet with CORS'}}]);}}catch(err){resolve([{err:{message:err.message,stack:err.stack}}]);}});newNode.crossOrigin='anonymous';oldNode.parentNode&&oldNode.parentNode.insertBefore(newNode,oldNode);oldNode.remove();setTimeout(()=>resolve([{err:{message:'Could not load stylesheet (timeout)'}}]),5000);});}
const data=[];const corsDataPromises=[];for(const stylesheet of Array.from(document.styleSheets)){const cssStylesheet=stylesheet;try{if(!cssStylesheet.cssRules){throw new Error('Failed to read cssRules');}
data.push(...getSheetsFontFaces(cssStylesheet));}catch(err){const failedToReadRules=/Failed to read.*cssRules/.test(err.message);const alreadyCORS=!cssStylesheet.ownerNode||!!cssStylesheet.ownerNode.crossOrigin;if(failedToReadRules&&!alreadyCORS&&cssStylesheet.href){const ownerLinkEl=cssStylesheet.ownerNode;corsDataPromises.push(loadStylesheetWithCORS(ownerLinkEl));}else{data.push({err:{message:err.message,stack:err.stack}});}}}
return Promise.all(corsDataPromises).then(corsFontFaces=>data.concat(...corsFontFaces));}
class Fonts extends Gatherer{_findSameFontFamily(fontFace,fontFacesList){return fontFacesList.find(fontItem=>{return!fontFaceDescriptors.find(descriptor=>{return fontFace[descriptor]!==fontItem[descriptor];});});}
afterPass(passContext){const driver=passContext.driver;const args=JSON.stringify(fontFaceDescriptors);const fontData=Promise.all([driver.evaluateAsync(`(${getAllLoadedFonts.toString()})(${args})`),driver.evaluateAsync(`(${getFontFaceFromStylesheets.toString()})()`)]);return fontData.then(([loadedFonts,fontsAndErrors])=>{const fontFaces=fontsAndErrors.filter(fontOrError=>!('err'in fontOrError));const firstFontError=fontsAndErrors.find(fontOrError=>'err'in fontOrError);if(firstFontError){const dataError=firstFontError;if(dataError.err){const err=new Error(dataError.err.message);err.stack=dataError.err.stack||err.stack;Sentry.captureException(err,{tags:{gatherer:'Fonts'},level:'warning'});}}
return loadedFonts.map(loadedFont=>{const fontFaceItem=this._findSameFontFamily(loadedFont,fontFaces);loadedFont.src=fontFaceItem&&fontFaceItem.src||[];return loadedFont;});});}}
module.exports=Fonts;},{"../../lib/sentry":90,"./gatherer":21}],"../gather/gatherers/html-without-javascript":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getBodyText(){const body=document.querySelector('body');return Promise.resolve({bodyText:body?body.innerText:'',hasNoScript:!!document.querySelector('noscript')});}
class HTMLWithoutJavaScript extends Gatherer{beforePass(passContext){passContext.disableJavaScript=true;}
async afterPass(passContext){passContext.disableJavaScript=false;const expression=`(${getBodyText.toString()}())`;const{bodyText,hasNoScript}=await passContext.driver.evaluateAsync(expression);if(typeof bodyText!=='string'){throw new Error('document body innerText returned by protocol was not a string');}
return{bodyText,hasNoScript};}}
module.exports=HTMLWithoutJavaScript;},{"./gatherer":21}],"../gather/gatherers/http-redirect":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class HTTPRedirect extends Gatherer{constructor(){super();this._preRedirectURL='';}
beforePass(passContext){this._preRedirectURL=passContext.url;passContext.url=this._preRedirectURL.replace(/^https/,'http');}
async afterPass(passContext){passContext.url=this._preRedirectURL;const expression=`new URL(window.location).protocol === 'https:'`;const isHttps=await passContext.driver.evaluateAsync(expression,{useIsolation:true});return{value:isHttps};}}
module.exports=HTTPRedirect;},{"./gatherer":21}],"../gather/gatherers/image-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const pageFunctions=require('../../lib/page-functions.js');const Driver=require('../driver.js');function collectImageElementInfo(){function getClientRect(element){const clientRect=element.getBoundingClientRect();return{top:clientRect.top,bottom:clientRect.bottom,left:clientRect.left,right:clientRect.right};}
const allElements=getElementsInDocument();const allImageElements=allElements.filter(element=>{return element.localName==='img';});const htmlImages=allImageElements.map(element=>{const computedStyle=window.getComputedStyle(element);return{src:element.currentSrc,width:element.width,height:element.height,clientWidth:element.clientWidth,clientHeight:element.clientHeight,clientRect:getClientRect(element),naturalWidth:element.naturalWidth,naturalHeight:element.naturalHeight,isCss:false,isPicture:!!element.parentElement&&element.parentElement.tagName==='PICTURE',usesObjectFit:computedStyle.getPropertyValue('object-fit')==='cover'||computedStyle.getPropertyValue('object-fit')==='contain'};});const CSS_URL_REGEX=/^url\("([^"]+)"\)$/;const CSS_SIZE_REGEX=/(auto|contain|cover)/;const cssImages=allElements.reduce((images,element)=>{const style=window.getComputedStyle(element);if(!style.backgroundImage||!CSS_URL_REGEX.test(style.backgroundImage)||!style.backgroundSize||!CSS_SIZE_REGEX.test(style.backgroundSize)){return images;}
const imageMatch=style.backgroundImage.match(CSS_URL_REGEX);const url=imageMatch[1];const differentImages=images.filter(image=>image.src!==url);if(images.length-differentImages.length>2){return differentImages;}
images.push({src:url,clientWidth:element.clientWidth,clientHeight:element.clientHeight,clientRect:getClientRect(element),naturalWidth:Number.MAX_VALUE,naturalHeight:Number.MAX_VALUE,isCss:true,isPicture:false,usesObjectFit:false});return images;},[]);return htmlImages.concat(cssImages);}
function determineNaturalSize(url){return new Promise((resolve,reject)=>{const img=new Image();img.addEventListener('error',_=>reject(new Error('determineNaturalSize failed img load')));img.addEventListener('load',()=>{resolve({naturalWidth:img.naturalWidth,naturalHeight:img.naturalHeight});});img.src=url;});}
class ImageUsage extends Gatherer{async fetchElementWithSizeInformation(driver,element){const url=JSON.stringify(element.src);try{const size=await driver.evaluateAsync(`(${determineNaturalSize.toString()})(${url})`);return Object.assign(element,size);}catch(_){return Object.assign(element,{naturalWidth:0,naturalHeight:0});}}
async afterPass(passContext,loadData){const driver=passContext.driver;const indexedNetworkRecords=loadData.networkRecords.reduce((map,record)=>{if(/^image/.test(record.mimeType)&&record.finished){map[record.url]={url:record.url,resourceSize:Math.min(record.resourceSize||0,record.transferSize),startTime:record.startTime,endTime:record.endTime,responseReceivedTime:record.responseReceivedTime,mimeType:record.mimeType};}
return map;},{});const expression=`(function() {
      ${pageFunctions.getElementsInDocumentString}; // define function on page
      return (${collectImageElementInfo.toString()})();
    })()`;const elements=await driver.evaluateAsync(expression);const imageUsage=[];for(let element of elements){element.networkRecord=indexedNetworkRecords[element.src];if((element.isPicture||element.isCss)&&element.networkRecord){element=await this.fetchElementWithSizeInformation(driver,element);}
imageUsage.push(element);}
return imageUsage;}}
module.exports=ImageUsage;},{"../../lib/page-functions.js":89,"../driver.js":19,"./gatherer":21}],"../gather/gatherers/js-usage":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class JsUsage extends Gatherer{async beforePass(passContext){await passContext.driver.sendCommand('Profiler.enable');await passContext.driver.sendCommand('Profiler.startPreciseCoverage');}
async afterPass(passContext){const driver=passContext.driver;const coverageResponse=await driver.sendCommand('Profiler.takePreciseCoverage');await driver.sendCommand('Profiler.stopPreciseCoverage');await driver.sendCommand('Profiler.disable');return coverageResponse.result;}}
module.exports=JsUsage;},{"./gatherer":21}],"../gather/gatherers/manifest":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('./gatherer');const manifestParser=require('../../lib/manifest-parser');const BOM_LENGTH=3;const BOM_FIRSTCHAR=65279;class Manifest extends Gatherer{async afterPass(passContext){const manifestPromise=passContext.driver.getAppManifest();const timeoutPromise=new Promise(resolve=>setTimeout(resolve,3000));const response=await Promise.race([manifestPromise,timeoutPromise]);if(!response){return null;}
const isBomEncoded=response.data.charCodeAt(0)===BOM_FIRSTCHAR;if(isBomEncoded){response.data=Buffer.from(response.data).slice(BOM_LENGTH).toString();}
return manifestParser(response.data,response.url,passContext.url);}}
module.exports=Manifest;}).call(this,require("buffer").Buffer);},{"../../lib/manifest-parser":86,"./gatherer":21,"buffer":109}],"../gather/gatherers/mixed-content":[function(require,module,exports){(function(Buffer){'use strict';const Gatherer=require('./gatherer');const URL=require('../../lib/url-shim');const Driver=require('../driver.js');class MixedContent extends Gatherer{constructor(){super();this.ids=new Set();this.url=undefined;this._onRequestIntercepted=undefined;}
upgradeURL(url){const parsedURL=new URL(url);parsedURL.protocol='https:';return parsedURL.href;}
downgradeURL(url){const parsedURL=new URL(url);parsedURL.protocol='http:';return parsedURL.href;}
_getRequestInterceptor(pageUrl,driver){const onRequestIntercepted=event=>{if(new URL(event.request.url).protocol==='http:'&&!URL.equalWithExcludedFragments(event.request.url,pageUrl)&&!this.ids.has(event.interceptionId)){this.ids.add(event.interceptionId);event.request.url=this.upgradeURL(event.request.url);driver.sendCommand('Network.continueInterceptedRequest',{interceptionId:event.interceptionId,rawResponse:Buffer.from(`HTTP/1.1 302 Found\r\nLocation: ${event.request.url}\r\n\r\n`,'utf8').toString('base64')});}else{driver.sendCommand('Network.continueInterceptedRequest',{interceptionId:event.interceptionId});}};return onRequestIntercepted;}
async beforePass(passContext){const driver=passContext.driver;passContext.url=this.downgradeURL(passContext.url);this.url=passContext.url;this._onRequestIntercepted=this._getRequestInterceptor(this.url,driver);await driver.sendCommand('Network.enable');driver.on('Network.requestIntercepted',this._onRequestIntercepted);await driver.sendCommand('Network.setCacheDisabled',{cacheDisabled:true});await driver.sendCommand('Network.setRequestInterception',{patterns:[{urlPattern:'*'}]});}
async afterPass(passContext){const driver=passContext.driver;await driver.sendCommand('Network.setRequestInterception',{patterns:[]});if(this._onRequestIntercepted){driver.off('Network.requestIntercepted',this._onRequestIntercepted);}
await driver.sendCommand('Network.setCacheDisabled',{cacheDisabled:false});return{url:passContext.url};}}
module.exports=MixedContent;}).call(this,require("buffer").Buffer);},{"../../lib/url-shim":"url","../driver.js":19,"./gatherer":21,"buffer":109}],"../gather/gatherers/offline":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const URL=require('../../lib/url-shim');class Offline extends Gatherer{beforePass(passContext){return passContext.driver.goOffline();}
afterPass(passContext,loadData){const navigationRecord=loadData.networkRecords.filter(record=>{return URL.equalWithExcludedFragments(record.url,passContext.url)&&record.fetchedViaServiceWorker;}).pop();return passContext.driver.goOnline(passContext).then(_=>navigationRecord?navigationRecord.statusCode:-1);}}
module.exports=Offline;},{"../../lib/url-shim":"url","./gatherer":21}],"../gather/gatherers/runtime-exceptions":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class RuntimeExceptions extends Gatherer{constructor(){super();this._exceptions=[];this._onRuntimeExceptionThrown=this.onRuntimeExceptionThrown.bind(this);}
onRuntimeExceptionThrown(entry){this._exceptions.push(entry);}
beforePass(passContext){const driver=passContext.driver;driver.on('Runtime.exceptionThrown',this._onRuntimeExceptionThrown);}
async afterPass(passContext){await passContext.driver.off('Runtime.exceptionThrown',this._onRuntimeExceptionThrown);return this._exceptions;}}
module.exports=RuntimeExceptions;},{"./gatherer":21}],"../gather/gatherers/scripts":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const NetworkRequest=require('../../lib/network-request');class Scripts extends Gatherer{async afterPass(passContext,loadData){const driver=passContext.driver;const scriptContentMap={};const scriptRecords=loadData.networkRecords.filter(record=>record.resourceType===NetworkRequest.TYPES.Script);for(const record of scriptRecords){try{const content=await driver.getRequestContent(record.requestId);if(content){scriptContentMap[record.requestId]=content;}}catch(e){}}
return scriptContentMap;}}
module.exports=Scripts;},{"../../lib/network-request":88,"./gatherer":21}],"../gather/gatherers/seo/canonical":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class Canonical extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelectorAll('head link[rel="canonical" i]').then(nodes=>Promise.all(nodes.map(node=>node.getAttribute('href'))));}}
module.exports=Canonical;},{"../gatherer":21}],"../gather/gatherers/seo/crawlable-links":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const pageFunctions=require('../../../lib/page-functions.js');class CrawlableLinks extends Gatherer{afterPass(passContext){const expression=`(function() {
      ${pageFunctions.getElementsInDocumentString}; // define function on page
      const selector = 'a[href]:not([rel~="nofollow"])';
      const elements = getElementsInDocument(selector);
      return elements
        .map(node => ({
          href: node.href,
          text: node.innerText
        }));
    })()`;return passContext.driver.evaluateAsync(expression);}}
module.exports=CrawlableLinks;},{"../../../lib/page-functions.js":89,"../gatherer":21}],"../gather/gatherers/seo/embedded-content":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');const pageFunctions=require('../../../lib/page-functions.js');class EmbeddedContent extends Gatherer{afterPass(passContext){const expression=`(function() {
      ${pageFunctions.getElementsInDocumentString}; // define function on page
      const selector = 'object, embed, applet';
      const elements = getElementsInDocument(selector);
      return elements
        .map(node => ({
          tagName: node.tagName,
          type: node.getAttribute('type'),
          src: node.getAttribute('src'),
          data: node.getAttribute('data'),
          code: node.getAttribute('code'),
          params: Array.from(node.children)
            .filter(el => el.tagName === 'PARAM')
            .map(el => ({
              name: el.getAttribute('name') || '',
              value: el.getAttribute('value') || '',
            })),
        }));
    })()`;return passContext.driver.evaluateAsync(expression);}}
module.exports=EmbeddedContent;},{"../../../lib/page-functions.js":89,"../gatherer":21}],"../gather/gatherers/seo/font-size":[function(require,module,exports){(function(global){'use strict';const CSSMatchedStyles=require('../../../lib/web-inspector').CSSMatchedStyles;const Gatherer=require('../gatherer');const FONT_SIZE_PROPERTY_NAME='font-size';const TEXT_NODE_BLOCK_LIST=new Set(['SCRIPT','STYLE','NOSCRIPT']);const MINIMAL_LEGIBLE_FONT_SIZE_PX=12;const MAX_NODES_VISITED=500;const MAX_NODES_ANALYZED=50;const Driver=require('../../driver.js');function nodeInBody(node){if(!node){return false;}
if(node.nodeName==='BODY'){return true;}
return nodeInBody(node.parentNode);}
function getAllNodesFromBody(driver){return driver.getNodesInDocument().then(nodes=>{const nodeMap=new Map();nodes.forEach(node=>nodeMap.set(node.nodeId,node));nodes.forEach(node=>node.parentNode=nodeMap.get(node.parentId));return nodes.filter(nodeInBody);});}
function getEffectiveRule(property,node,{inlineStyle,attributesStyle,matchedCSSRules,inherited})
{const cssModel={styleSheetHeaderForId:id=>({id})};const nodeType=node.nodeType;node.nodeType=()=>nodeType;const matchedStyles=new CSSMatchedStyles(cssModel,node,inlineStyle,attributesStyle,matchedCSSRules,null,inherited,null);const nodeStyles=matchedStyles.nodeStyles();const matchingRule=nodeStyles.find(style=>style.allProperties().some(item=>item.name===property&&matchedStyles.propertyState(item)!==CSSMatchedStyles.PropertyState.Overloaded));return matchingRule;}
function getNodeTextLength(node){return!node.nodeValue?0:node.nodeValue.trim().length;}
function getFontSizeSourceRule(driver,node){return driver.sendCommand('CSS.getMatchedStylesForNode',{nodeId:node.nodeId}).then(matchedRules=>getEffectiveRule(FONT_SIZE_PROPERTY_NAME,node,matchedRules));}
function getFontSizeInformation(driver,node){return driver.sendCommand('CSS.getComputedStyleForNode',{nodeId:node.parentId}).then(result=>{const{computedStyle}=result;const fontSizeProperty=computedStyle.find(({name})=>name===FONT_SIZE_PROPERTY_NAME);return{fontSize:parseInt(fontSizeProperty.value,10),textLength:getNodeTextLength(node),node:node.parentNode};}).catch(err=>{require('../../../lib/sentry.js').captureException(err);return null;});}
function isNonEmptyTextNode(node){return node.nodeType===global.Node.TEXT_NODE&&!TEXT_NODE_BLOCK_LIST.has(node.parentNode.nodeName)&&getNodeTextLength(node)>0;}
class FontSize extends Gatherer{afterPass(passContext){const stylesheets=new Map();const onStylesheetAdd=sheet=>stylesheets.set(sheet.header.styleSheetId,sheet.header);passContext.driver.on('CSS.styleSheetAdded',onStylesheetAdd);const enableDOM=passContext.driver.sendCommand('DOM.enable');const enableCSS=passContext.driver.sendCommand('CSS.enable');let failingTextLength=0;let visitedTextLength=0;let totalTextLength=0;return Promise.all([enableDOM,enableCSS]).then(()=>getAllNodesFromBody(passContext.driver)).then(nodes=>{const textNodes=nodes.filter(isNonEmptyTextNode);totalTextLength=textNodes.reduce((sum,node)=>sum+=getNodeTextLength(node),0);const nodesToVisit=textNodes.sort((a,b)=>getNodeTextLength(b)-getNodeTextLength(a)).slice(0,MAX_NODES_VISITED);return nodesToVisit;}).then(textNodes=>Promise.all(textNodes.map(node=>getFontSizeInformation(passContext.driver,node)))).then(fontSizeInfo=>{const visitedNodes=fontSizeInfo.filter(Boolean);visitedTextLength=visitedNodes.reduce((sum,{textLength})=>sum+=textLength,0);const failingNodes=visitedNodes.filter(({fontSize})=>fontSize<MINIMAL_LEGIBLE_FONT_SIZE_PX);failingTextLength=failingNodes.reduce((sum,{textLength})=>sum+=textLength,0);return Promise.all(failingNodes.sort((a,b)=>b.textLength-a.textLength).slice(0,MAX_NODES_ANALYZED).map(info=>getFontSizeSourceRule(passContext.driver,info.node).then(sourceRule=>{if(sourceRule){info.cssRule={type:sourceRule.type,range:sourceRule.range,styleSheetId:sourceRule.styleSheetId};if(sourceRule.parentRule){info.cssRule.parentRule={origin:sourceRule.parentRule.origin,selectors:sourceRule.parentRule.selectors};}}
return info;})));}).then(analyzedFailingNodesData=>{passContext.driver.off('CSS.styleSheetAdded',onStylesheetAdd);const analyzedFailingTextLength=analyzedFailingNodesData.reduce((sum,{textLength})=>sum+=textLength,0);analyzedFailingNodesData.filter(data=>data.cssRule&&data.cssRule.styleSheetId).forEach(data=>data.cssRule.stylesheet=stylesheets.get(data.cssRule.styleSheetId));return Promise.all([passContext.driver.sendCommand('DOM.disable'),passContext.driver.sendCommand('CSS.disable')]).then(_=>({analyzedFailingNodesData,analyzedFailingTextLength,failingTextLength,visitedTextLength,totalTextLength}));});}}
module.exports=FontSize;}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{});},{"../../../lib/sentry.js":90,"../../../lib/web-inspector":96,"../../driver.js":19,"../gatherer":21}],"../gather/gatherers/seo/hreflang":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class Hreflang extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelectorAll('head link[rel="alternate" i][hreflang]').then(nodes=>Promise.all(nodes.map(node=>Promise.all([node.getAttribute('href'),node.getAttribute('hreflang')])))).then(attributeValues=>attributeValues&&attributeValues.map(values=>{const[href,hreflang]=values;return{href:href||'',hreflang:hreflang||''};}));}}
module.exports=Hreflang;},{"../gatherer":21}],"../gather/gatherers/seo/meta-description":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class MetaDescription extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelector('head meta[name="description" i]').then(node=>node&&node.getAttribute('content'));}}
module.exports=MetaDescription;},{"../gatherer":21}],"../gather/gatherers/seo/meta-robots":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');class MetaRobots extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.querySelector('head meta[name="robots" i]').then(node=>node&&node.getAttribute('content'));}}
module.exports=MetaRobots;},{"../gatherer":21}],"../gather/gatherers/seo/robots-txt":[function(require,module,exports){'use strict';const Gatherer=require('../gatherer');async function getRobotsTxtContent(){try{const response=await fetch(new URL('/robots.txt',location.href).href);if(!response.ok){return{status:response.status,content:null};}
const content=await response.text();return{status:response.status,content};}catch(_){return{status:null,content:null};}}
class RobotsTxt extends Gatherer{afterPass(passContext){return passContext.driver.evaluateAsync(`(${getRobotsTxtContent.toString()}())`);}}
module.exports=RobotsTxt;},{"../gatherer":21}],"../gather/gatherers/service-worker":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ServiceWorker extends Gatherer{async beforePass(passContext){const{versions}=await passContext.driver.getServiceWorkerVersions();return{versions};}}
module.exports=ServiceWorker;},{"./gatherer":21}],"../gather/gatherers/start-url":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');const manifestParser=require('../../lib/manifest-parser');const Driver=require('../driver.js');class StartUrl extends Gatherer{afterPass(passContext){const driver=passContext.driver;return driver.goOnline(passContext).then(()=>driver.getAppManifest()).then(response=>driver.goOffline().then(()=>response)).then(response=>response&&manifestParser(response.data,response.url,passContext.url)).then(manifest=>{const startUrlInfo=this._readManifestStartUrl(manifest);if(startUrlInfo.isReadFailure){return{statusCode:-1,explanation:startUrlInfo.reason};}
return this._attemptManifestFetch(passContext.driver,startUrlInfo.startUrl);}).catch(()=>{return{statusCode:-1,explanation:'Unable to fetch start URL via service worker'};});}
_readManifestStartUrl(manifest){if(!manifest||!manifest.value){const detailedMsg=manifest&&manifest.warning;if(detailedMsg){return{isReadFailure:true,reason:`Error fetching web app manifest: ${detailedMsg}`};}else{return{isReadFailure:true,reason:`No usable web app manifest found on page`};}}
if(manifest.value.start_url.warning){return{isReadFailure:true,reason:manifest.value.start_url.warning};}
return{isReadFailure:false,startUrl:manifest.value.start_url.value};}
_attemptManifestFetch(driver,startUrl){const timeoutPromise=new Promise(resolve=>setTimeout(()=>resolve({statusCode:-1,explanation:'Timed out waiting for fetched start_url'}),3000));const fetchPromise=new Promise(resolve=>{driver.on('Network.responseReceived',onResponseReceived);function onResponseReceived(responseEvent){const{response}=responseEvent;if(response.url!==startUrl)return;driver.off('Network.responseReceived',onResponseReceived);if(!response.fromServiceWorker){return resolve({statusCode:-1,explanation:'Unable to fetch start URL via service worker'});}
return resolve({statusCode:response.status});}});return driver.evaluateAsync(`window.location = '${startUrl}'`).then(()=>Promise.race([fetchPromise,timeoutPromise]));}}
module.exports=StartUrl;},{"../../lib/manifest-parser":86,"../driver.js":19,"./gatherer":21}],"../gather/gatherers/theme-color":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class ThemeColor extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const metaEl=await driver.querySelector('head meta[name="theme-color" i]');return metaEl&&metaEl.getAttribute('content');}}
module.exports=ThemeColor;},{"./gatherer":21}],"../gather/gatherers/viewport-dimensions":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');function getViewportDimensions(){return Promise.resolve({innerWidth:window.innerWidth,innerHeight:window.innerHeight,outerWidth:window.outerWidth,outerHeight:window.outerHeight,devicePixelRatio:window.devicePixelRatio});}
class ViewportDimensions extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const dimensions=await driver.evaluateAsync(`(${getViewportDimensions.toString()}())`,{useIsolation:true});const allNumeric=Object.values(dimensions).every(Number.isFinite);if(!allNumeric){const results=JSON.stringify(dimensions);throw new Error(`ViewportDimensions results were not numeric: ${results}`);}
return dimensions;}}
module.exports=ViewportDimensions;},{"./gatherer":21}],"../gather/gatherers/viewport":[function(require,module,exports){'use strict';const Gatherer=require('./gatherer');class Viewport extends Gatherer{async afterPass(passContext){const driver=passContext.driver;const metaEl=await driver.querySelector('head meta[name="viewport" i]');return metaEl&&metaEl.getAttribute('content');}}
module.exports=Viewport;},{"./gatherer":21}],"./gather/computed/critical-request-chains":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkRequest=require('../../lib/network-request');const assert=require('assert');class CriticalRequestChains extends ComputedArtifact{get name(){return'CriticalRequestChains';}
static isCritical(request,mainResource){assert.ok(mainResource,'mainResource not provided');if(request.isLinkPreload){return false;}
const isIframe=request.resourceType===NetworkRequest.TYPES.Document&&request.frameId!==mainResource.frameId;const nonCriticalResourceTypes=[NetworkRequest.TYPES.Image,NetworkRequest.TYPES.XHR,NetworkRequest.TYPES.Fetch,NetworkRequest.TYPES.EventSource];if(nonCriticalResourceTypes.includes(request.resourceType||'Other')||isIframe||request.mimeType&&request.mimeType.startsWith('image/')){return false;}
return['VeryHigh','High','Medium'].includes(request.priority);}
static extractChain(networkRecords,mainResource){networkRecords=networkRecords.filter(req=>req.finished);const requestIdToRequests=new Map();for(const request of networkRecords){requestIdToRequests.set(request.requestId,request);}
const criticalRequests=networkRecords.filter(request=>CriticalRequestChains.isCritical(request,mainResource));const criticalRequestChains={};for(const request of criticalRequests){const ancestors=[];let ancestorRequest=request.initiatorRequest;let node=criticalRequestChains;while(ancestorRequest){const ancestorIsCritical=CriticalRequestChains.isCritical(ancestorRequest,mainResource);if(!ancestorIsCritical||ancestors.includes(ancestorRequest.requestId)){ancestors.length=0;node=undefined;break;}
ancestors.push(ancestorRequest.requestId);ancestorRequest=ancestorRequest.initiatorRequest;}
let ancestor=ancestors.pop();while(ancestor&&node){const parentRequest=requestIdToRequests.get(ancestor);if(!parentRequest){throw new Error(`request with id ${ancestor} not found.`);}
const parentRequestId=parentRequest.requestId;if(!node[parentRequestId]){node[parentRequestId]={request:parentRequest,children:{}};}
ancestor=ancestors.pop();node=node[parentRequestId].children;}
if(!node){continue;}
if(node[request.requestId]){continue;}
node[request.requestId]={request,children:{}};}
return criticalRequestChains;}
async compute_(data,artifacts){const[networkRecords,mainResource]=await Promise.all([artifacts.requestNetworkRecords(data.devtoolsLog),artifacts.requestMainResource(data)]);return CriticalRequestChains.extractChain(networkRecords,mainResource);}}
module.exports=CriticalRequestChains;},{"../../lib/network-request":88,"./computed-artifact":11,"assert":102}],"./gather/computed/load-simulator":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const constants=require('../../config/constants');const Simulator=require('../../lib/dependency-graph/simulator/simulator');class LoadSimulatorArtifact extends ComputedArtifact{get name(){return'LoadSimulator';}
async compute_(data,artifacts){const{throttlingMethod,throttling}=data.settings;const networkAnalysis=await artifacts.requestNetworkAnalysis(data.devtoolsLog);const options={additionalRttByOrigin:networkAnalysis.additionalRttByOrigin,serverResponseTimeByOrigin:networkAnalysis.serverResponseTimeByOrigin};switch(throttlingMethod){case'provided':options.rtt=networkAnalysis.rtt;options.throughput=networkAnalysis.throughput;options.cpuSlowdownMultiplier=1;options.layoutTaskMultiplier=1;break;case'devtools':if(throttling){options.rtt=throttling.requestLatencyMs/constants.throttling.DEVTOOLS_RTT_ADJUSTMENT_FACTOR;options.throughput=throttling.downloadThroughputKbps*1024/constants.throttling.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR;}
options.cpuSlowdownMultiplier=1;options.layoutTaskMultiplier=1;break;case'simulate':if(throttling){options.rtt=throttling.rttMs;options.throughput=throttling.throughputKbps*1024;options.cpuSlowdownMultiplier=throttling.cpuSlowdownMultiplier;}
break;default:break;}
return new Simulator(options);}}
module.exports=LoadSimulatorArtifact;},{"../../config/constants":8,"../../lib/dependency-graph/simulator/simulator":31,"./computed-artifact":11}],"./gather/computed/main-resource":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const URL=require('../../lib/url-shim');class MainResource extends ComputedArtifact{get name(){return'MainResource';}
async compute_(data,artifacts){const finalUrl=data.URL.finalUrl;const requests=await artifacts.requestNetworkRecords(data.devtoolsLog);const mainResource=requests.find(request=>finalUrl.startsWith(request.url)&&URL.equalWithExcludedFragments(request.url,finalUrl));if(!mainResource){throw new Error('Unable to identify the main resource');}
return mainResource;}}
module.exports=MainResource;},{"../../lib/url-shim":"url","./computed-artifact":11}],"./gather/computed/main-thread-tasks":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const{taskGroups,taskNameToGroup}=require('../../lib/task-groups');class MainThreadTasks extends ComputedArtifact{get name(){return'MainThreadTasks';}
static _createNewTaskNode(event,parent){const newTask={event,startTime:event.ts,endTime:event.ph==='X'?event.ts+Number(event.dur||0):NaN,parent:parent,children:[],attributableURLs:[],group:taskGroups.other,duration:NaN,selfTime:NaN};if(parent){parent.children.push(newTask);}
return newTask;}
static _createTasksFromEvents(mainThreadEvents){const tasks=[];let currentTask;for(const event of mainThreadEvents){if(event.ph!=='X'&&event.ph!=='B'&&event.ph!=='E')continue;while(currentTask&&Number.isFinite(currentTask.endTime)&&currentTask.endTime<=event.ts)
{currentTask=currentTask.parent;}
if(!currentTask){if(event.ph==='E'){throw new Error('Fatal trace logic error');}
currentTask=MainThreadTasks._createNewTaskNode(event);tasks.push(currentTask);continue;}
if(event.ph==='X'||event.ph==='B'){const newTask=MainThreadTasks._createNewTaskNode(event,currentTask);tasks.push(newTask);currentTask=newTask;}else{if(currentTask.event.ph!=='B'){throw new Error('Fatal trace logic error');}
currentTask.endTime=event.ts;currentTask=currentTask.parent;}}
return tasks;}
static _computeRecursiveSelfTime(task){const childTime=task.children.map(MainThreadTasks._computeRecursiveSelfTime).reduce((sum,child)=>sum+child,0);task.duration=task.endTime-task.startTime;task.selfTime=task.duration-childTime;return task.duration;}
static _computeRecursiveAttributableURLs(task,parentURLs){const argsData=task.event.args.data||{};const stackFrameURLs=(argsData.stackTrace||[]).map(entry=>entry.url);let taskURLs=[];switch(task.event.name){case'v8.compile':case'EvaluateScript':case'FunctionCall':taskURLs=[argsData.url].concat(stackFrameURLs);break;case'v8.compileModule':taskURLs=[task.event.args.fileName].concat(stackFrameURLs);break;default:taskURLs=stackFrameURLs;break;}
const attributableURLs=Array.from(parentURLs);for(const url of taskURLs){if(!url)continue;if(attributableURLs[attributableURLs.length-1]===url)continue;attributableURLs.push(url);}
task.attributableURLs=attributableURLs;task.children.forEach(child=>MainThreadTasks._computeRecursiveAttributableURLs(child,attributableURLs));}
static _computeRecursiveTaskGroup(task,parentGroup){const group=taskNameToGroup[task.event.name];task.group=group||parentGroup||taskGroups.other;task.children.forEach(child=>MainThreadTasks._computeRecursiveTaskGroup(child,task.group));}
static getMainThreadTasks(traceEvents){const tasks=MainThreadTasks._createTasksFromEvents(traceEvents);for(const task of tasks){if(task.parent)continue;MainThreadTasks._computeRecursiveSelfTime(task);MainThreadTasks._computeRecursiveAttributableURLs(task,[]);MainThreadTasks._computeRecursiveTaskGroup(task);}
const firstTs=(tasks[0]||{startTime:0}).startTime;for(const task of tasks){task.startTime=(task.startTime-firstTs)/1000;task.endTime=(task.endTime-firstTs)/1000;task.duration/=1000;task.selfTime/=1000;if(!Number.isFinite(task.selfTime)){throw new Error('Invalid task timing data');}}
return tasks;}
async compute_(trace,artifacts){const{mainThreadEvents}=await artifacts.requestTraceOfTab(trace);return MainThreadTasks.getMainThreadTasks(mainThreadEvents);}}
module.exports=MainThreadTasks;},{"../../lib/task-groups":93,"./computed-artifact":11}],"./gather/computed/metrics/estimated-input-latency":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const LHError=require('../../../lib/lh-error');const TracingProcessor=require('../../../lib/traces/tracing-processor');const ROLLING_WINDOW_SIZE=5000;class EstimatedInputLatency extends MetricArtifact{get name(){return'EstimatedInputLatency';}
static calculateRollingWindowEIL(events){const candidateStartEvts=events.filter(evt=>evt.duration>=10);let worst90thPercentileLatency=16;for(const startEvt of candidateStartEvts){const latencyPercentiles=TracingProcessor.getRiskToResponsiveness(events,startEvt.start,startEvt.start+ROLLING_WINDOW_SIZE,[0.9]);worst90thPercentileLatency=Math.max(latencyPercentiles[0].time,worst90thPercentileLatency);}
return worst90thPercentileLatency;}
computeObservedMetric(data){const{firstMeaningfulPaint}=data.traceOfTab.timings;if(!firstMeaningfulPaint){throw new LHError(LHError.errors.NO_FMP);}
const events=TracingProcessor.getMainThreadTopLevelEvents(data.traceOfTab,firstMeaningfulPaint).filter(evt=>evt.duration>=1);return Promise.resolve({timing:EstimatedInputLatency.calculateRollingWindowEIL(events)});}}
module.exports=EstimatedInputLatency;},{"../../../lib/lh-error":85,"../../../lib/traces/tracing-processor":95,"./metric":14}],"./gather/computed/metrics/first-contentful-paint":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');class FirstContentfulPaint extends MetricArtifact{get name(){return'FirstContentfulPaint';}
async computeObservedMetric(data){const{traceOfTab}=data;return{timing:traceOfTab.timings.firstContentfulPaint,timestamp:traceOfTab.timestamps.firstContentfulPaint};}}
module.exports=FirstContentfulPaint;},{"./metric":14}],"./gather/computed/metrics/first-cpu-idle":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const TracingProcessor=require('../../../lib/traces/tracing-processor');const LHError=require('../../../lib/lh-error');const LONG_TASK_THRESHOLD=50;const MAX_TASK_CLUSTER_DURATION=250;const MIN_TASK_CLUSTER_PADDING=1000;const MIN_TASK_CLUSTER_FMP_DISTANCE=5000;const MAX_QUIET_WINDOW_SIZE=5000;const EXPONENTIATION_COEFFICIENT=-Math.log(3-1)/15;class FirstCPUIdle extends MetricArtifact{get name(){return'FirstCPUIdle';}
static getRequiredWindowSizeInMs(t){const tInSeconds=t/1000;const exponentiationComponent=Math.exp(EXPONENTIATION_COEFFICIENT*tInSeconds);return(4*exponentiationComponent+1)*1000;}
static getTaskClustersInWindow(tasks,startIndex,windowEnd){const clusters=[];let previousTaskEndTime=-Infinity;let currentCluster=[];const clusteringWindowEnd=windowEnd+MIN_TASK_CLUSTER_PADDING;const isInClusteringWindow=task=>task.start<clusteringWindowEnd;for(let i=startIndex;i<tasks.length;i++){if(!isInClusteringWindow(tasks[i])){break;}
const task=tasks[i];if(task.start-previousTaskEndTime>MIN_TASK_CLUSTER_PADDING){currentCluster=[];clusters.push(currentCluster);}
currentCluster.push(task);previousTaskEndTime=task.end;}
return clusters.map(tasks=>{const start=tasks[0].start;const end=tasks[tasks.length-1].end;const duration=end-start;return{start,end,duration};}).filter(cluster=>cluster.start<windowEnd);}
static findQuietWindow(FMP,traceEnd,longTasks){if(longTasks.length===0||longTasks[0].start>FMP+FirstCPUIdle.getRequiredWindowSizeInMs(0)){return FMP;}
const isTooCloseToFMP=cluster=>cluster.start<FMP+MIN_TASK_CLUSTER_FMP_DISTANCE;const isTooLong=cluster=>cluster.duration>MAX_TASK_CLUSTER_DURATION;const isBadCluster=cluster=>isTooCloseToFMP(cluster)||isTooLong(cluster);for(let i=0;i<longTasks.length;i++){const windowStart=longTasks[i].end;const windowSize=FirstCPUIdle.getRequiredWindowSizeInMs(windowStart-FMP);const windowEnd=windowStart+windowSize;if(windowEnd>traceEnd){throw new LHError(LHError.errors.NO_FCPUI_IDLE_PERIOD);}
if(i+1<longTasks.length&&longTasks[i+1].start-windowStart<=MIN_TASK_CLUSTER_PADDING){continue;}
const taskClusters=FirstCPUIdle.getTaskClustersInWindow(longTasks,i+1,windowEnd);const hasBadTaskClusters=taskClusters.some(isBadCluster);if(!hasBadTaskClusters){return windowStart;}}
throw new LHError(LHError.errors.NO_FCPUI_IDLE_PERIOD);}
computeObservedMetric(data){const{traceOfTab}=data;const navStart=traceOfTab.timestamps.navigationStart;const FMP=traceOfTab.timings.firstMeaningfulPaint;const DCL=traceOfTab.timings.domContentLoaded;const traceEnd=traceOfTab.timings.traceEnd;if(!FMP||!DCL){throw new LHError(FMP?LHError.errors.NO_DCL:LHError.errors.NO_FMP);}
if(traceEnd-FMP<MAX_QUIET_WINDOW_SIZE){throw new LHError(LHError.errors.FMP_TOO_LATE_FOR_FCPUI);}
const longTasksAfterFMP=TracingProcessor.getMainThreadTopLevelEvents(traceOfTab,FMP).filter(evt=>evt.duration>=LONG_TASK_THRESHOLD);const firstInteractive=FirstCPUIdle.findQuietWindow(FMP,traceEnd,longTasksAfterFMP);const valueInMs=Math.max(firstInteractive,DCL);return Promise.resolve({timing:valueInMs,timestamp:valueInMs*1000+navStart});}}
module.exports=FirstCPUIdle;},{"../../../lib/lh-error":85,"../../../lib/traces/tracing-processor":95,"./metric":14}],"./gather/computed/metrics/first-meaningful-paint":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const LHError=require('../../../lib/lh-error');class FirstMeaningfulPaint extends MetricArtifact{get name(){return'FirstMeaningfulPaint';}
async computeObservedMetric(data){const{traceOfTab}=data;if(!traceOfTab.timestamps.firstMeaningfulPaint){throw new LHError(LHError.errors.NO_FMP);}
return{timing:traceOfTab.timings.firstMeaningfulPaint,timestamp:traceOfTab.timestamps.firstMeaningfulPaint};}}
module.exports=FirstMeaningfulPaint;},{"../../../lib/lh-error":85,"./metric":14}],"./gather/computed/metrics/interactive":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');const NetworkRecorder=require('../../../lib/network-recorder');const TracingProcessor=require('../../../lib/traces/tracing-processor');const LHError=require('../../../lib/lh-error');const REQUIRED_QUIET_WINDOW=5000;const ALLOWED_CONCURRENT_REQUESTS=2;class Interactive extends MetricArtifact{get name(){return'Interactive';}
static _findNetworkQuietPeriods(networkRecords,traceOfTab){const traceEndTsInMs=traceOfTab.timestamps.traceEnd/1000;const filteredNetworkRecords=networkRecords.filter(record=>{return record.finished&&record.requestMethod==='GET'&&!record.failed&&record.statusCode<400;});return NetworkRecorder.findNetworkQuietPeriods(filteredNetworkRecords,ALLOWED_CONCURRENT_REQUESTS,traceEndTsInMs);}
static _findCPUQuietPeriods(longTasks,traceOfTab){const navStartTsInMs=traceOfTab.timestamps.navigationStart/1000;const traceEndTsInMs=traceOfTab.timestamps.traceEnd/1000;if(longTasks.length===0){return[{start:0,end:traceEndTsInMs}];}
const quietPeriods=[];longTasks.forEach((task,index)=>{if(index===0){quietPeriods.push({start:0,end:task.start+navStartTsInMs});}
if(index===longTasks.length-1){quietPeriods.push({start:task.end+navStartTsInMs,end:traceEndTsInMs});}else{quietPeriods.push({start:task.end+navStartTsInMs,end:longTasks[index+1].start+navStartTsInMs});}});return quietPeriods;}
static findOverlappingQuietPeriods(longTasks,networkRecords,traceOfTab){const FcpTsInMs=traceOfTab.timestamps.firstContentfulPaint/1000;const isLongEnoughQuietPeriod=period=>period.end>FcpTsInMs+REQUIRED_QUIET_WINDOW&&period.end-period.start>=REQUIRED_QUIET_WINDOW;const networkQuietPeriods=this._findNetworkQuietPeriods(networkRecords,traceOfTab).filter(isLongEnoughQuietPeriod);const cpuQuietPeriods=this._findCPUQuietPeriods(longTasks,traceOfTab).filter(isLongEnoughQuietPeriod);const cpuQueue=cpuQuietPeriods.slice();const networkQueue=networkQuietPeriods.slice();let cpuCandidate=cpuQueue.shift();let networkCandidate=networkQueue.shift();while(cpuCandidate&&networkCandidate){if(cpuCandidate.start>=networkCandidate.start){if(networkCandidate.end>=cpuCandidate.start+REQUIRED_QUIET_WINDOW){return{cpuQuietPeriod:cpuCandidate,networkQuietPeriod:networkCandidate,cpuQuietPeriods,networkQuietPeriods};}else{networkCandidate=networkQueue.shift();}}else{if(cpuCandidate.end>=networkCandidate.start+REQUIRED_QUIET_WINDOW){return{cpuQuietPeriod:cpuCandidate,networkQuietPeriod:networkCandidate,cpuQuietPeriods,networkQuietPeriods};}else{cpuCandidate=cpuQueue.shift();}}}
throw new LHError(cpuCandidate?LHError.errors.NO_TTI_NETWORK_IDLE_PERIOD:LHError.errors.NO_TTI_CPU_IDLE_PERIOD);}
computeObservedMetric(data){const{traceOfTab,networkRecords}=data;if(!traceOfTab.timestamps.domContentLoaded){throw new LHError(LHError.errors.NO_DCL);}
const longTasks=TracingProcessor.getMainThreadTopLevelEvents(traceOfTab).filter(event=>event.duration>=50);const quietPeriodInfo=Interactive.findOverlappingQuietPeriods(longTasks,networkRecords,traceOfTab);const cpuQuietPeriod=quietPeriodInfo.cpuQuietPeriod;const timestamp=Math.max(cpuQuietPeriod.start,traceOfTab.timestamps.firstContentfulPaint/1000,traceOfTab.timestamps.domContentLoaded/1000)*1000;const timing=(timestamp-traceOfTab.timestamps.navigationStart)/1000;return Promise.resolve({timing,timestamp});}}
module.exports=Interactive;},{"../../../lib/lh-error":85,"../../../lib/network-recorder":87,"../../../lib/traces/tracing-processor":95,"./metric":14}],"./gather/computed/metrics/lantern-estimated-input-latency":[function(require,module,exports){'use strict';const LanternMetricArtifact=require('./lantern-metric');const BaseNode=require('../../../lib/dependency-graph/base-node');const EstimatedInputLatency=require('./estimated-input-latency');class LanternEstimatedInputLatency extends LanternMetricArtifact{get name(){return'LanternEstimatedInputLatency';}
get COEFFICIENTS(){return{intercept:0,optimistic:0.4,pessimistic:0.4};}
getOptimisticGraph(dependencyGraph){return dependencyGraph;}
getPessimisticGraph(dependencyGraph){return dependencyGraph;}
getEstimateFromSimulation(simulation,extras){const fmpTimeInMs=extras.optimistic?extras.fmpResult.pessimisticEstimate.timeInMs:extras.fmpResult.optimisticEstimate.timeInMs;const events=LanternEstimatedInputLatency.getEventsAfterFMP(simulation.nodeTimings,fmpTimeInMs);return{timeInMs:EstimatedInputLatency.calculateRollingWindowEIL(events),nodeTimings:simulation.nodeTimings};}
async compute_(data,artifacts){const fmpResult=await artifacts.requestLanternFirstMeaningfulPaint(data);return this.computeMetricWithGraphs(data,artifacts,{fmpResult});}
static getEventsAfterFMP(nodeTimings,fmpTimeInMs){const events=[];for(const[node,timing]of nodeTimings.entries()){if(node.type!==BaseNode.TYPES.CPU)continue;if(timing.endTime<fmpTimeInMs)continue;events.push({start:timing.startTime,end:timing.endTime,duration:timing.duration});}
return events;}}
module.exports=LanternEstimatedInputLatency;},{"../../../lib/dependency-graph/base-node":25,"./estimated-input-latency":"./gather/computed/metrics/estimated-input-latency","./lantern-metric":13}],"./gather/computed/metrics/lantern-first-contentful-paint":[function(require,module,exports){'use strict';const MetricArtifact=require('./lantern-metric');const BaseNode=require('../../../lib/dependency-graph/base-node');class FirstContentfulPaint extends MetricArtifact{get name(){return'LanternFirstContentfulPaint';}
get COEFFICIENTS(){return{intercept:0,optimistic:0.5,pessimistic:0.5};}
getOptimisticGraph(dependencyGraph,traceOfTab){const fcp=traceOfTab.timestamps.firstContentfulPaint;const blockingScriptUrls=MetricArtifact.getScriptUrls(dependencyGraph,node=>{return(node.endTime<=fcp&&node.hasRenderBlockingPriority()&&node.initiatorType!=='script');});return dependencyGraph.cloneWithRelationships(node=>{if(node.endTime>fcp&&!node.isMainDocument())return false;if(node.type===BaseNode.TYPES.CPU){return node.isEvaluateScriptFor(blockingScriptUrls);}
return node.hasRenderBlockingPriority()&&node.initiatorType!=='script';});}
getPessimisticGraph(dependencyGraph,traceOfTab){const fcp=traceOfTab.timestamps.firstContentfulPaint;const blockingScriptUrls=MetricArtifact.getScriptUrls(dependencyGraph,node=>{return node.endTime<=fcp&&node.hasRenderBlockingPriority();});return dependencyGraph.cloneWithRelationships(node=>{if(node.endTime>fcp&&!node.isMainDocument())return false;if(node.type===BaseNode.TYPES.CPU){return node.isEvaluateScriptFor(blockingScriptUrls);}
return node.hasRenderBlockingPriority();});}}
module.exports=FirstContentfulPaint;},{"../../../lib/dependency-graph/base-node":25,"./lantern-metric":13}],"./gather/computed/metrics/lantern-first-cpu-idle":[function(require,module,exports){'use strict';const BaseNode=require('../../../lib/dependency-graph/base-node');const FirstCPUIdle=require('./first-cpu-idle');const LanternInteractive=require('./lantern-interactive');class LanternFirstCPUIdle extends LanternInteractive{get name(){return'LanternFirstCPUIdle';}
get COEFFICIENTS(){return{intercept:0,optimistic:1,pessimistic:0};}
getEstimateFromSimulation(simulation,extras){const fmpTimeInMs=extras.optimistic?extras.fmpResult.optimisticEstimate.timeInMs:extras.fmpResult.pessimisticEstimate.timeInMs;return{timeInMs:LanternFirstCPUIdle.getFirstCPUIdleWindowStart(simulation.nodeTimings,fmpTimeInMs),nodeTimings:simulation.nodeTimings};}
static getFirstCPUIdleWindowStart(nodeTimings,fmpTimeInMs,longTaskLength=50){const longTasks=[];for(const[node,timing]of nodeTimings.entries()){if(node.type!==BaseNode.TYPES.CPU)continue;if(timing.duration<longTaskLength)continue;longTasks.push({start:timing.startTime,end:timing.endTime});}
return FirstCPUIdle.findQuietWindow(fmpTimeInMs,Infinity,longTasks);}}
module.exports=LanternFirstCPUIdle;},{"../../../lib/dependency-graph/base-node":25,"./first-cpu-idle":"./gather/computed/metrics/first-cpu-idle","./lantern-interactive":"./gather/computed/metrics/lantern-interactive"}],"./gather/computed/metrics/lantern-first-meaningful-paint":[function(require,module,exports){'use strict';const MetricArtifact=require('./lantern-metric');const BaseNode=require('../../../lib/dependency-graph/base-node');const LHError=require('../../../lib/lh-error');class FirstMeaningfulPaint extends MetricArtifact{get name(){return'LanternFirstMeaningfulPaint';}
get COEFFICIENTS(){return{intercept:0,optimistic:0.5,pessimistic:0.5};}
getOptimisticGraph(dependencyGraph,traceOfTab){const fmp=traceOfTab.timestamps.firstMeaningfulPaint;if(!fmp){throw new LHError(LHError.errors.NO_FMP);}
const blockingScriptUrls=MetricArtifact.getScriptUrls(dependencyGraph,node=>{return(node.endTime<=fmp&&node.hasRenderBlockingPriority()&&node.initiatorType!=='script');});return dependencyGraph.cloneWithRelationships(node=>{if(node.endTime>fmp&&!node.isMainDocument())return false;if(node.type===BaseNode.TYPES.CPU){return node.isEvaluateScriptFor(blockingScriptUrls);}
return node.hasRenderBlockingPriority()&&node.initiatorType!=='script';});}
getPessimisticGraph(dependencyGraph,traceOfTab){const fmp=traceOfTab.timestamps.firstMeaningfulPaint;if(!fmp){throw new LHError(LHError.errors.NO_FMP);}
const requiredScriptUrls=MetricArtifact.getScriptUrls(dependencyGraph,node=>{return node.endTime<=fmp&&node.hasRenderBlockingPriority();});return dependencyGraph.cloneWithRelationships(node=>{if(node.endTime>fmp&&!node.isMainDocument())return false;if(node.type===BaseNode.TYPES.CPU){return node.didPerformLayout()||node.isEvaluateScriptFor(requiredScriptUrls);}
return node.hasRenderBlockingPriority();});}
async compute_(data,artifacts){const fcpResult=await artifacts.requestLanternFirstContentfulPaint(data);const metricResult=await this.computeMetricWithGraphs(data,artifacts);metricResult.timing=Math.max(metricResult.timing,fcpResult.timing);return metricResult;}}
module.exports=FirstMeaningfulPaint;},{"../../../lib/dependency-graph/base-node":25,"../../../lib/lh-error":85,"./lantern-metric":13}],"./gather/computed/metrics/lantern-interactive":[function(require,module,exports){'use strict';const MetricArtifact=require('./lantern-metric');const BaseNode=require('../../../lib/dependency-graph/base-node');const NetworkRequest=require('../../../lib/network-request');const CRITICAL_LONG_TASK_THRESHOLD=20;class Interactive extends MetricArtifact{get name(){return'LanternInteractive';}
get COEFFICIENTS(){return{intercept:0,optimistic:0.5,pessimistic:0.5};}
getOptimisticGraph(dependencyGraph){const minimumCpuTaskDuration=CRITICAL_LONG_TASK_THRESHOLD*1000;return dependencyGraph.cloneWithRelationships(node=>{if(node.type===BaseNode.TYPES.CPU){return node.event.dur>minimumCpuTaskDuration;}
const isImage=node.record.resourceType===NetworkRequest.TYPES.Image;const isScript=node.record.resourceType===NetworkRequest.TYPES.Script;return(!isImage&&(isScript||node.record.priority==='High'||node.record.priority==='VeryHigh'));});}
getPessimisticGraph(dependencyGraph){return dependencyGraph;}
getEstimateFromSimulation(simulationResult,extras){const lastTaskAt=Interactive.getLastLongTaskEndTime(simulationResult.nodeTimings);const minimumTime=extras.optimistic?extras.fmpResult.optimisticEstimate.timeInMs:extras.fmpResult.pessimisticEstimate.timeInMs;return{timeInMs:Math.max(minimumTime,lastTaskAt),nodeTimings:simulationResult.nodeTimings};}
async compute_(data,artifacts){const fmpResult=await artifacts.requestLanternFirstMeaningfulPaint(data);const metricResult=await this.computeMetricWithGraphs(data,artifacts,{fmpResult});metricResult.timing=Math.max(metricResult.timing,fmpResult.timing);return metricResult;}
static getLastLongTaskEndTime(nodeTimings,duration=50){return Array.from(nodeTimings.entries()).filter(([node,timing])=>{if(node.type!==BaseNode.TYPES.CPU)return false;return timing.duration>duration;}).map(([_,timing])=>timing.endTime).reduce((max,x)=>Math.max(max||0,x||0),0);}}
module.exports=Interactive;},{"../../../lib/dependency-graph/base-node":25,"../../../lib/network-request":88,"./lantern-metric":13}],"./gather/computed/metrics/lantern-speed-index":[function(require,module,exports){'use strict';const MetricArtifact=require('./lantern-metric');const BaseNode=require('../../../lib/dependency-graph/base-node');class SpeedIndex extends MetricArtifact{get name(){return'LanternSpeedIndex';}
get COEFFICIENTS(){return{intercept:-250,optimistic:1.4,pessimistic:0.65};}
getOptimisticGraph(dependencyGraph){return dependencyGraph;}
getPessimisticGraph(dependencyGraph){return dependencyGraph;}
getEstimateFromSimulation(simulationResult,extras){const fcpTimeInMs=extras.fcpResult.pessimisticEstimate.timeInMs;const estimate=extras.optimistic?extras.speedline.speedIndex:SpeedIndex.computeLayoutBasedSpeedIndex(simulationResult.nodeTimings,fcpTimeInMs);return{timeInMs:estimate,nodeTimings:simulationResult.nodeTimings};}
async compute_(data,artifacts){const speedline=await artifacts.requestSpeedline(data.trace);const fcpResult=await artifacts.requestLanternFirstContentfulPaint(data);const metricResult=await this.computeMetricWithGraphs(data,artifacts,{speedline,fcpResult});metricResult.timing=Math.max(metricResult.timing,fcpResult.timing);return metricResult;}
static computeLayoutBasedSpeedIndex(nodeTimings,fcpTimeInMs){const layoutWeights=[];for(const[node,timing]of nodeTimings.entries()){if(node.type!==BaseNode.TYPES.CPU)continue;if(node.childEvents.some(x=>x.name==='Layout')){const timingWeight=Math.max(Math.log2(timing.endTime-timing.startTime),0);layoutWeights.push({time:timing.endTime,weight:timingWeight});}}
if(!layoutWeights.length){return fcpTimeInMs;}
const totalWeightedTime=layoutWeights.map(evt=>evt.weight*Math.max(evt.time,fcpTimeInMs)).reduce((a,b)=>a+b,0);const totalWeight=layoutWeights.map(evt=>evt.weight).reduce((a,b)=>a+b,0);return totalWeightedTime/totalWeight;}}
module.exports=SpeedIndex;},{"../../../lib/dependency-graph/base-node":25,"./lantern-metric":13}],"./gather/computed/metrics/speed-index":[function(require,module,exports){'use strict';const MetricArtifact=require('./metric');class SpeedIndex extends MetricArtifact{get name(){return'SpeedIndex';}
async computeObservedMetric(data,artifacts){const speedline=await artifacts.requestSpeedline(data.trace);const timing=Math.round(speedline.speedIndex);const timestamp=(timing+speedline.beginning)*1000;return Promise.resolve({timing,timestamp});}}
module.exports=SpeedIndex;},{"./metric":14}],"./gather/computed/network-analysis":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkAnalyzer=require('../../lib/dependency-graph/simulator/network-analyzer');class NetworkAnalysis extends ComputedArtifact{get name(){return'NetworkAnalysis';}
static computeRTTAndServerResponseTime(records){const rttByOrigin=new Map();for(const[origin,summary]of NetworkAnalyzer.estimateRTTByOrigin(records).entries()){rttByOrigin.set(origin,summary.min);}
const minimumRtt=Math.min(...Array.from(rttByOrigin.values()));const responseTimeSummaries=NetworkAnalyzer.estimateServerResponseTimeByOrigin(records,{rttByOrigin});const additionalRttByOrigin=new Map();const serverResponseTimeByOrigin=new Map();for(const[origin,summary]of responseTimeSummaries.entries()){const rttForOrigin=rttByOrigin.get(origin);additionalRttByOrigin.set(origin,rttForOrigin-minimumRtt);serverResponseTimeByOrigin.set(origin,summary.median);}
return{rtt:minimumRtt,additionalRttByOrigin,serverResponseTimeByOrigin,throughput:0};}
async compute_(devtoolsLog,computedArtifacts){const records=await computedArtifacts.requestNetworkRecords(devtoolsLog);const throughput=await computedArtifacts.requestNetworkThroughput(devtoolsLog);const rttAndServerResponseTime=NetworkAnalysis.computeRTTAndServerResponseTime(records);rttAndServerResponseTime.throughput=throughput*8;return rttAndServerResponseTime;}}
module.exports=NetworkAnalysis;},{"../../lib/dependency-graph/simulator/network-analyzer":30,"./computed-artifact":11}],"./gather/computed/network-records":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkRecorder=require('../../lib/network-recorder');class NetworkRecords extends ComputedArtifact{get name(){return'NetworkRecords';}
async compute_(devtoolsLog){return NetworkRecorder.recordsFromLogs(devtoolsLog);}}
module.exports=NetworkRecords;},{"../../lib/network-recorder":87,"./computed-artifact":11}],"./gather/computed/network-throughput":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class NetworkThroughput extends ComputedArtifact{get name(){return'NetworkThroughput';}
static getThroughput(networkRecords){let totalBytes=0;const timeBoundaries=networkRecords.reduce((boundaries,record)=>{const scheme=record.parsedURL&&record.parsedURL.scheme;if(scheme==='data'||record.failed||!record.finished||record.statusCode>300||!record.transferSize){return boundaries;}
totalBytes+=record.transferSize;boundaries.push({time:record.responseReceivedTime,isStart:true});boundaries.push({time:record.endTime,isStart:false});return boundaries;},[]).sort((a,b)=>a.time-b.time);if(!timeBoundaries.length){return Infinity;}
let inflight=0;let currentStart=0;let totalDuration=0;timeBoundaries.forEach(boundary=>{if(boundary.isStart){if(inflight===0){currentStart=boundary.time;}
inflight++;}else{inflight--;if(inflight===0){totalDuration+=boundary.time-currentStart;}}});return totalBytes/totalDuration;}
compute_(devtoolsLog,computedArtifacts){return computedArtifacts.requestNetworkRecords(devtoolsLog).then(NetworkThroughput.getThroughput);}}
module.exports=NetworkThroughput;},{"./computed-artifact":11}],"./gather/computed/page-dependency-graph":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const NetworkNode=require('../../lib/dependency-graph/network-node');const CPUNode=require('../../lib/dependency-graph/cpu-node');const NetworkAnalyzer=require('../../lib/dependency-graph/simulator/network-analyzer');const TracingProcessor=require('../../lib/traces/tracing-processor');const NetworkRequest=require('../../lib/network-request');const MINIMUM_TASK_DURATION_OF_INTEREST=10;const IGNORED_MIME_TYPES_REGEX=/^video/;class PageDependencyGraphArtifact extends ComputedArtifact{get name(){return'PageDependencyGraph';}
static getNetworkInitiators(record){if(!record.initiator)return[];if(record.initiator.url)return[record.initiator.url];if(record.initiator.type==='script'&&record.initiator.stack){const frames=record.initiator.stack.callFrames;return Array.from(new Set(frames.map(frame=>frame.url))).filter(Boolean);}
return[];}
static getNetworkNodeOutput(networkRecords){const nodes=[];const idToNodeMap=new Map();const urlToNodeMap=new Map();networkRecords.forEach(record=>{if(IGNORED_MIME_TYPES_REGEX.test(record.mimeType))return;while(idToNodeMap.has(record.requestId)){record.requestId+=':duplicate';}
const node=new NetworkNode(record);nodes.push(node);const list=urlToNodeMap.get(record.url)||[];list.push(node);idToNodeMap.set(record.requestId,node);urlToNodeMap.set(record.url,list);});return{nodes,idToNodeMap,urlToNodeMap};}
static getCPUNodes(traceOfTab){const nodes=[];let i=0;TracingProcessor.assertHasToplevelEvents(traceOfTab.mainThreadEvents);const minimumEvtDur=MINIMUM_TASK_DURATION_OF_INTEREST*1000;while(i<traceOfTab.mainThreadEvents.length){const evt=traceOfTab.mainThreadEvents[i];if(!TracingProcessor.isScheduleableTask(evt)||!evt.dur||evt.dur<minimumEvtDur)
{i++;continue;}
const children=[];i++;for(const endTime=evt.ts+evt.dur;i<traceOfTab.mainThreadEvents.length&&traceOfTab.mainThreadEvents[i].ts<endTime;i++)
{children.push(traceOfTab.mainThreadEvents[i]);}
nodes.push(new CPUNode(evt,children));}
return nodes;}
static linkNetworkNodes(rootNode,networkNodeOutput){networkNodeOutput.nodes.forEach(node=>{const initiators=PageDependencyGraphArtifact.getNetworkInitiators(node.record);if(initiators.length){initiators.forEach(initiator=>{const parentCandidates=networkNodeOutput.urlToNodeMap.get(initiator)||[rootNode];const parent=parentCandidates.length===1?parentCandidates[0]:rootNode;node.addDependency(parent);});}else if(node!==rootNode){rootNode.addDependent(node);}
const redirects=Array.from(node.record.redirects||[]);redirects.push(node.record);for(let i=1;i<redirects.length;i++){const redirectNode=networkNodeOutput.idToNodeMap.get(redirects[i-1].requestId);const actualNode=networkNodeOutput.idToNodeMap.get(redirects[i].requestId);if(actualNode&&redirectNode){actualNode.addDependency(redirectNode);}}});}
static linkCPUNodes(rootNode,networkNodeOutput,cpuNodes){function addDependentNetworkRequest(cpuNode,reqId){const networkNode=networkNodeOutput.idToNodeMap.get(reqId);if(!networkNode||networkNode.record.resourceType!==NetworkRequest.TYPES.XHR||networkNode.startTime<=cpuNode.startTime)return;cpuNode.addDependent(networkNode);}
function addDependencyOnUrl(cpuNode,url){if(!url)return;const minimumAllowableTimeSinceNetworkNodeEnd=-100*1000;const candidates=networkNodeOutput.urlToNodeMap.get(url)||[];let minCandidate=null;let minDistance=Infinity;for(const candidate of candidates){if(cpuNode.startTime<=candidate.startTime)return;const distance=cpuNode.startTime-candidate.endTime;if(distance>=minimumAllowableTimeSinceNetworkNodeEnd&&distance<minDistance){minCandidate=candidate;minDistance=distance;}}
if(!minCandidate)return;cpuNode.addDependency(minCandidate);}
const timers=new Map();for(const node of cpuNodes){for(const evt of node.childEvents){if(!evt.args.data)continue;const argsUrl=evt.args.data.url;const stackTraceUrls=(evt.args.data.stackTrace||[]).map(l=>l.url).filter(Boolean);switch(evt.name){case'TimerInstall':timers.set(evt.args.data.timerId,node);stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;case'TimerFire':{const installer=timers.get(evt.args.data.timerId);if(!installer)break;installer.addDependent(node);break;}
case'InvalidateLayout':case'ScheduleStyleRecalculation':stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;case'EvaluateScript':addDependencyOnUrl(node,argsUrl);stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;case'XHRReadyStateChange':if(evt.args.data.readyState!==4)break;addDependencyOnUrl(node,argsUrl);stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;case'FunctionCall':case'v8.compile':addDependencyOnUrl(node,argsUrl);break;case'ParseAuthorStyleSheet':addDependencyOnUrl(node,evt.args.data.styleSheetUrl);break;case'ResourceSendRequest':addDependentNetworkRequest(node,evt.args.data.requestId);stackTraceUrls.forEach(url=>addDependencyOnUrl(node,url));break;}}
if(node.getNumberOfDependencies()===0){node.addDependency(rootNode);}}}
static createGraph(traceOfTab,networkRecords){const networkNodeOutput=PageDependencyGraphArtifact.getNetworkNodeOutput(networkRecords);const cpuNodes=PageDependencyGraphArtifact.getCPUNodes(traceOfTab);const rootRequest=networkRecords.reduce((min,r)=>min.startTime<r.startTime?min:r);const rootNode=networkNodeOutput.idToNodeMap.get(rootRequest.requestId);const mainDocumentRequest=NetworkAnalyzer.findMainDocument(networkRecords);const mainDocumentNode=networkNodeOutput.idToNodeMap.get(mainDocumentRequest.requestId);if(!rootNode||!mainDocumentNode){throw new Error(`${rootNode?'mainDocument':'root'}Node not found.`);}
PageDependencyGraphArtifact.linkNetworkNodes(rootNode,networkNodeOutput);PageDependencyGraphArtifact.linkCPUNodes(rootNode,networkNodeOutput,cpuNodes);mainDocumentNode.setIsMainDocument(true);if(NetworkNode.hasCycle(rootNode)){throw new Error('Invalid dependency graph created, cycle detected');}
return rootNode;}
static printGraph(rootNode,widthInCharacters=100){function padRight(str,target,padChar=' '){return str+padChar.repeat(Math.max(target-str.length,0));}
const nodes=[];rootNode.traverse(node=>nodes.push(node));nodes.sort((a,b)=>a.startTime-b.startTime);const min=nodes[0].startTime;const max=nodes.reduce((max,node)=>Math.max(max,node.endTime),0);const totalTime=max-min;const timePerCharacter=totalTime/widthInCharacters;nodes.forEach(node=>{const offset=Math.round((node.startTime-min)/timePerCharacter);const length=Math.ceil((node.endTime-node.startTime)/timePerCharacter);const bar=padRight('',offset)+padRight('',length,'=');const displayName=node.record?node.record.url:node.type;console.log(padRight(bar,widthInCharacters),`| ${displayName.slice(0,30)}`);});}
async compute_(data,artifacts){const trace=data.trace;const devtoolsLog=data.devtoolsLog;const[traceOfTab,networkRecords]=await Promise.all([artifacts.requestTraceOfTab(trace),artifacts.requestNetworkRecords(devtoolsLog)]);return PageDependencyGraphArtifact.createGraph(traceOfTab,networkRecords);}}
module.exports=PageDependencyGraphArtifact;},{"../../lib/dependency-graph/cpu-node":26,"../../lib/dependency-graph/network-node":27,"../../lib/dependency-graph/simulator/network-analyzer":30,"../../lib/network-request":88,"../../lib/traces/tracing-processor":95,"./computed-artifact":11}],"./gather/computed/pushed-requests":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');class PushedRequests extends ComputedArtifact{get name(){return'PushedRequests';}
compute_(devtoolsLog,artifacts){return artifacts.requestNetworkRecords(devtoolsLog).then(records=>{const pushedRecords=records.filter(r=>r.timing&&!!r.timing.pushStart);return pushedRecords;});}}
module.exports=PushedRequests;},{"./computed-artifact":11}],"./gather/computed/screenshots":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const SCREENSHOT_TRACE_NAME='Screenshot';class ScreenshotFilmstrip extends ComputedArtifact{get name(){return'Screenshots';}
async compute_(trace){return trace.traceEvents.filter(evt=>evt.name===SCREENSHOT_TRACE_NAME).map(evt=>{return{timestamp:evt.ts/1000,datauri:`data:image/jpeg;base64,${evt.args.snapshot}`};});}}
module.exports=ScreenshotFilmstrip;},{"./computed-artifact":11}],"./gather/computed/speedline":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const speedline=require('speedline-core');const LHError=require('../../lib/lh-error');class Speedline extends ComputedArtifact{get name(){return'Speedline';}
compute_(trace,computedArtifacts){return computedArtifacts.requestTraceOfTab(trace).then(traceOfTab=>{const traceEvents=trace.traceEvents.slice();const navStart=traceOfTab.timestamps.navigationStart;return speedline(traceEvents,{timeOrigin:navStart,fastMode:true,include:'speedIndex'});}).catch(err=>{if(/No screenshots found in trace/.test(err.message)){throw new LHError(LHError.errors.NO_SCREENSHOTS);}
throw err;}).then(speedline=>{if(speedline.frames.length===0){throw new LHError(LHError.errors.NO_SPEEDLINE_FRAMES);}
if(speedline.speedIndex===0){throw new LHError(LHError.errors.SPEEDINDEX_OF_ZERO);}
return speedline;});}}
module.exports=Speedline;},{"../../lib/lh-error":85,"./computed-artifact":11,"speedline-core":186}],"./gather/computed/trace-of-tab":[function(require,module,exports){'use strict';const ComputedArtifact=require('./computed-artifact');const log=require('lighthouse-logger');const TracingProcessor=require('../../lib/traces/tracing-processor');const LHError=require('../../lib/lh-error');const Sentry=require('../../lib/sentry');const ACCEPTABLE_NAVIGATION_URL_REGEX=/^(chrome|https?):/;class TraceOfTab extends ComputedArtifact{get name(){return'TraceOfTab';}
static isNavigationStartOfInterest(event){return event.name==='navigationStart'&&(!event.args.data||!event.args.data.documentLoaderURL||ACCEPTABLE_NAVIGATION_URL_REGEX.test(event.args.data.documentLoaderURL));}
static filteredStableSort(traceEvents,filter){const indices=[];for(let srcIndex=0;srcIndex<traceEvents.length;srcIndex++){if(filter(traceEvents[srcIndex])){indices.push(srcIndex);}}
indices.sort((indexA,indexB)=>{const result=traceEvents[indexA].ts-traceEvents[indexB].ts;return result?result:indexA-indexB;});const sorted=[];for(let i=0;i<indices.length;i++){sorted.push(traceEvents[indices[i]]);}
return sorted;}
async compute_(trace){const keyEvents=TraceOfTab.filteredStableSort(trace.traceEvents,e=>{return e.cat.includes('blink.user_timing')||e.cat.includes('loading')||e.cat.includes('devtools.timeline')||e.cat==='__metadata';});const{startedInPageEvt,frameId}=TracingProcessor.findTracingStartedEvt(keyEvents);const frameEvents=keyEvents.filter(e=>e.args.frame===frameId);const navigationStart=frameEvents.filter(TraceOfTab.isNavigationStartOfInterest).pop();if(!navigationStart)throw new LHError(LHError.errors.NO_NAVSTART);const firstPaint=frameEvents.find(e=>e.name==='firstPaint'&&e.ts>navigationStart.ts);const firstContentfulPaint=frameEvents.find(e=>e.name==='firstContentfulPaint'&&e.ts>navigationStart.ts);if(!firstContentfulPaint)throw new LHError(LHError.errors.NO_FCP);let firstMeaningfulPaint=frameEvents.find(e=>e.name==='firstMeaningfulPaint'&&e.ts>navigationStart.ts);let fmpFellBack=false;if(!firstMeaningfulPaint){Sentry.captureMessage('No firstMeaningfulPaint found, using fallback',{level:'warning'});const fmpCand='firstMeaningfulPaintCandidate';fmpFellBack=true;log.verbose('trace-of-tab',`No firstMeaningfulPaint found, falling back to last ${fmpCand}`);const lastCandidate=frameEvents.filter(e=>e.name===fmpCand).pop();if(!lastCandidate){log.verbose('trace-of-tab','No `firstMeaningfulPaintCandidate` events found in trace');}
firstMeaningfulPaint=lastCandidate;}
const load=frameEvents.find(e=>e.name==='loadEventEnd'&&e.ts>navigationStart.ts);const domContentLoaded=frameEvents.find(e=>e.name==='domContentLoadedEventEnd'&&e.ts>navigationStart.ts);const processEvents=TraceOfTab.filteredStableSort(trace.traceEvents,e=>e.pid===startedInPageEvt.pid);const mainThreadEvents=processEvents.filter(e=>e.tid===startedInPageEvt.tid);const traceEnd=trace.traceEvents.reduce((max,evt)=>{return max.ts>evt.ts?max:evt;});const fakeEndOfTraceEvt={ts:traceEnd.ts+(traceEnd.dur||0)};const getTimestamp=event=>event&&event.ts;const timestamps={navigationStart:navigationStart.ts,firstPaint:getTimestamp(firstPaint),firstContentfulPaint:firstContentfulPaint.ts,firstMeaningfulPaint:getTimestamp(firstMeaningfulPaint),traceEnd:fakeEndOfTraceEvt.ts,load:getTimestamp(load),domContentLoaded:getTimestamp(domContentLoaded)};const getTiming=ts=>(ts-navigationStart.ts)/1000;const maybeGetTiming=ts=>ts===undefined?undefined:getTiming(ts);const timings={navigationStart:0,firstPaint:maybeGetTiming(timestamps.firstPaint),firstContentfulPaint:getTiming(timestamps.firstContentfulPaint),firstMeaningfulPaint:maybeGetTiming(timestamps.firstMeaningfulPaint),traceEnd:getTiming(timestamps.traceEnd),load:maybeGetTiming(timestamps.load),domContentLoaded:maybeGetTiming(timestamps.domContentLoaded)};return{timings,timestamps,processEvents,mainThreadEvents,startedInPageEvt,navigationStartEvt:navigationStart,firstPaintEvt:firstPaint,firstContentfulPaintEvt:firstContentfulPaint,firstMeaningfulPaintEvt:firstMeaningfulPaint,loadEvt:load,domContentLoadedEvt:domContentLoaded,fmpFellBack};}}
module.exports=TraceOfTab;},{"../../lib/lh-error":85,"../../lib/sentry":90,"../../lib/traces/tracing-processor":95,"./computed-artifact":11,"lighthouse-logger":147}],1:[function(require,module,exports){'use strict';const Audit=require('../audit');class AxeAudit extends Audit{static audit(artifacts){const notApplicables=artifacts.Accessibility.notApplicable||[];const isNotApplicable=notApplicables.find(result=>result.id===this.meta.id);if(isNotApplicable){return{rawValue:true,notApplicable:true};}
const violations=artifacts.Accessibility.violations||[];const rule=violations.find(result=>result.id===this.meta.id);const impact=rule&&rule.impact;const tags=rule&&rule.tags;let items=[];if(rule&&rule.nodes){items=rule.nodes.map(node=>({node:{type:'node',selector:Array.isArray(node.target)?node.target.join(' '):'',path:node.path,snippet:node.html||node.snippet,explanation:node.failureSummary}}));}
const headings=[{key:'node',itemType:'node',text:'Failing Elements'}];return{rawValue:typeof rule==='undefined',extendedInfo:{value:rule},details:{...Audit.makeTableDetails(headings,items),impact,tags}};}}
module.exports=AxeAudit;},{"../audit":2}],2:[function(require,module,exports){'use strict';const statistics=require('../lib/statistics');const Util=require('../report/html/renderer/util');const DEFAULT_PASS='defaultPass';const clampTo2Decimals=val=>Math.round(val*100)/100;class Audit{static get DEFAULT_PASS(){return DEFAULT_PASS;}
static get SCORING_MODES(){return{NUMERIC:'numeric',BINARY:'binary',MANUAL:'manual',INFORMATIVE:'informative',NOT_APPLICABLE:'not-applicable',ERROR:'error'};}
static get meta(){throw new Error('Audit meta information must be overridden.');}
static get defaultOptions(){return{};}
static audit(artifacts,context){throw new Error('audit() method must be overriden');}
static computeLogNormalScore(measuredValue,diminishingReturnsValue,medianValue){const distribution=statistics.getLogNormalDistribution(medianValue,diminishingReturnsValue);let score=distribution.computeComplementaryPercentile(measuredValue);score=Math.min(1,score);score=Math.max(0,score);return clampTo2Decimals(score);}
static generateErrorAuditResult(audit,errorMessage){return Audit.generateAuditResult(audit,{rawValue:null,errorMessage});}
static makeTableDetails(headings,results,summary){if(results.length===0){return{type:'table',headings:[],items:[],summary};}
return{type:'table',headings:headings,items:results,summary};}
static makeOpportunityDetails(headings,items,overallSavingsMs,overallSavingsBytes){return{type:'opportunity',headings:items.length===0?[]:headings,items,overallSavingsMs,overallSavingsBytes};}
static _normalizeAuditScore(audit,result){let score=result.score===undefined?Number(result.rawValue):result.score;if(!Number.isFinite(score))throw new Error(`Invalid score: ${score}`);if(score>1)throw new Error(`Audit score for ${audit.meta.id} is > 1`);if(score<0)throw new Error(`Audit score for ${audit.meta.id} is < 0`);score=clampTo2Decimals(score);const scoreDisplayMode=audit.meta.scoreDisplayMode||Audit.SCORING_MODES.BINARY;return{score,scoreDisplayMode};}
static generateAuditResult(audit,result){if(typeof result.rawValue==='undefined'){throw new Error('generateAuditResult requires a rawValue');}
let{score,scoreDisplayMode}=Audit._normalizeAuditScore(audit,result);if(result.notApplicable){scoreDisplayMode=Audit.SCORING_MODES.NOT_APPLICABLE;result.rawValue=true;}
if(result.errorMessage){scoreDisplayMode=Audit.SCORING_MODES.ERROR;}
let auditTitle=audit.meta.title;if(audit.meta.failureTitle){if(Number(score)<Util.PASS_THRESHOLD){auditTitle=audit.meta.failureTitle;}}
if(scoreDisplayMode!==Audit.SCORING_MODES.BINARY&&scoreDisplayMode!==Audit.SCORING_MODES.NUMERIC){score=null;}
return{id:audit.meta.id,title:auditTitle,description:audit.meta.description,score,scoreDisplayMode,rawValue:result.rawValue,displayValue:result.displayValue,explanation:result.explanation,errorMessage:result.errorMessage,warnings:result.warnings,details:result.details};}}
module.exports=Audit;},{"../lib/statistics":91,"../report/html/renderer/util":97}],3:[function(require,module,exports){(function(__filename){'use strict';const Audit=require('../audit');const linearInterpolation=require('../../lib/statistics').linearInterpolation;const Interactive=require('../../gather/computed/metrics/lantern-interactive');const i18n=require('../../lib/i18n/i18n.js');const str_=i18n.createMessageInstanceIdFn(__filename,{});const KB_IN_BYTES=1024;const WASTED_MS_FOR_AVERAGE=300;const WASTED_MS_FOR_POOR=750;const WASTED_MS_FOR_SCORE_OF_ZERO=5000;class UnusedBytes extends Audit{static scoreForWastedMs(wastedMs){if(wastedMs===0){return 1;}else if(wastedMs<WASTED_MS_FOR_AVERAGE){return linearInterpolation(0,1,WASTED_MS_FOR_AVERAGE,0.75,wastedMs);}else if(wastedMs<WASTED_MS_FOR_POOR){return linearInterpolation(WASTED_MS_FOR_AVERAGE,0.75,WASTED_MS_FOR_POOR,0.5,wastedMs);}else{return Math.max(0,linearInterpolation(WASTED_MS_FOR_POOR,0.5,WASTED_MS_FOR_SCORE_OF_ZERO,0,wastedMs));}}
static bytesToMs(bytes,networkThroughput){const milliseconds=bytes/networkThroughput*1000;return milliseconds;}
static estimateTransferSize(networkRecord,totalBytes,resourceType,compressionRatio=0.5){if(!networkRecord){return Math.round(totalBytes*compressionRatio);}else if(networkRecord.resourceType===resourceType){return networkRecord.transferSize||0;}else{const transferSize=networkRecord.transferSize||0;const resourceSize=networkRecord.resourceSize;const compressionRatio=resourceSize!==undefined?transferSize/resourceSize:1;return Math.round(totalBytes*compressionRatio);}}
static audit(artifacts,context){const trace=artifacts.traces[Audit.DEFAULT_PASS];const devtoolsLog=artifacts.devtoolsLogs[Audit.DEFAULT_PASS];const settings=context&&context.settings||{};const simulatorOptions={devtoolsLog,settings};return artifacts.requestNetworkRecords(devtoolsLog).then(networkRecords=>Promise.all([this.audit_(artifacts,networkRecords,context),artifacts.requestPageDependencyGraph({trace,devtoolsLog}),artifacts.requestLoadSimulator(simulatorOptions)])).then(([result,graph,simulator])=>this.createAuditProduct(result,graph,simulator));}
static computeWasteWithTTIGraph(results,graph,simulator,options){options=Object.assign({includeLoad:true,label:this.meta.id},options);const beforeLabel=`${options.label}-before`;const afterLabel=`${options.label}-after`;const simulationBeforeChanges=simulator.simulate(graph,{label:beforeLabel});const resultsByUrl=new Map();for(const result of results){resultsByUrl.set(result.url,result);}
const originalTransferSizes=new Map();graph.traverse(node=>{if(node.type!=='network')return;const result=resultsByUrl.get(node.record.url);if(!result)return;const original=node.record.transferSize;originalTransferSizes.set(node.record.requestId,original);const wastedBytes=result.wastedBytes;node.record.transferSize=Math.max(original-wastedBytes,0);});const simulationAfterChanges=simulator.simulate(graph,{label:afterLabel});graph.traverse(node=>{if(node.type!=='network')return;const originalTransferSize=originalTransferSizes.get(node.record.requestId);if(originalTransferSize===undefined)return;node.record.transferSize=originalTransferSize;});const savingsOnOverallLoad=simulationBeforeChanges.timeInMs-simulationAfterChanges.timeInMs;const savingsOnTTI=Interactive.getLastLongTaskEndTime(simulationBeforeChanges.nodeTimings)-
Interactive.getLastLongTaskEndTime(simulationAfterChanges.nodeTimings);let savings=savingsOnTTI;if(options.includeLoad)savings=Math.max(savings,savingsOnOverallLoad);return Math.round(Math.max(savings,0)/10)*10;}
static createAuditProduct(result,graph,simulator){const results=result.items.sort((itemA,itemB)=>itemB.wastedBytes-itemA.wastedBytes);const wastedBytes=results.reduce((sum,item)=>sum+item.wastedBytes,0);const wastedKb=Math.round(wastedBytes/KB_IN_BYTES);const wastedMs=this.computeWasteWithTTIGraph(results,graph,simulator);let displayValue=result.displayValue||'';if(typeof result.displayValue==='undefined'&&wastedBytes){displayValue=str_(i18n.UIStrings.displayValueByteSavings,{wastedBytes});}
const details=Audit.makeOpportunityDetails(result.headings,results,wastedMs,wastedBytes);return{explanation:result.explanation,warnings:result.warnings,displayValue,rawValue:wastedMs,score:UnusedBytes.scoreForWastedMs(wastedMs),extendedInfo:{value:{wastedMs,wastedKb,results}},details};}
static audit_(artifacts,networkRecords,context){throw new Error('audit_ unimplemented');}}
module.exports=UnusedBytes;}).call(this,"/../lighthouse-core/audits/byte-efficiency/byte-efficiency-audit.js");},{"../../gather/computed/metrics/lantern-interactive":"./gather/computed/metrics/lantern-interactive","../../lib/i18n/i18n.js":36,"../../lib/statistics":91,"../audit":2}],4:[function(require,module,exports){'use strict';const Audit=require('../audit');class ManualAudit extends Audit{static get partialMeta(){return{scoreDisplayMode:Audit.SCORING_MODES.MANUAL,requiredArtifacts:[]};}
static audit(){return{rawValue:false};}}
module.exports=ManualAudit;},{"../audit":2}],5:[function(require,module,exports){'use strict';const Audit=require('./audit');class MultiCheckAudit extends Audit{static async audit(artifacts,context){const multiProduct=await this.audit_(artifacts,context);return this.createAuditProduct(multiProduct);}
static createAuditProduct(result){const detailsItem={...result,...result.manifestValues,manifestValues:undefined,warnings:undefined,allChecks:undefined};if(result.manifestValues&&result.manifestValues.allChecks){result.manifestValues.allChecks.forEach(check=>{detailsItem[check.id]=check.passing;});}
const details={items:[detailsItem]};if(result.failures.length>0){return{rawValue:false,explanation:`Failures: ${result.failures.join(',\n')}.`,details};}
return{rawValue:true,details,warnings:result.warnings};}
static audit_(artifacts,context){throw new Error('audit_ unimplemented');}}
module.exports=MultiCheckAudit;},{"./audit":2}],6:[function(require,module,exports){'use strict';const Audit=require('./audit');class ViolationAudit extends Audit{static getViolationResults(artifacts,pattern){const seen=new Set();return artifacts.ChromeConsoleMessages.map(message=>message.entry).filter(entry=>entry.url&&entry.source==='violation'&&pattern.test(entry.text)).map(entry=>({label:`line: ${entry.lineNumber}`,url:entry.url})).filter(entry=>{const key=`${entry.url}!${entry.label}`;if(seen.has(key))return false;seen.add(key);return true;});}}
module.exports=ViolationAudit;},{"./audit":2}],7:[function(require,module,exports){(function(__dirname){'use strict';const defaultConfigPath='./default-config.js';const defaultConfig=require('./default-config.js');const fullConfig=require('./full-config.js');const constants=require('./constants.js');const i18n=require('./../lib/i18n/i18n.js');const isDeepEqual=require('lodash.isequal');const log=require('lighthouse-logger');const path=require('path');const Audit=require('../audits/audit.js');const Runner=require('../runner.js');function validatePasses(passes,audits){if(!Array.isArray(passes)){return;}
const requiredGatherers=Config.getGatherersNeededByAudits(audits);passes.forEach(pass=>{pass.gatherers.forEach(gathererDefn=>{const gatherer=gathererDefn.instance;const isGatherRequiredByAudits=requiredGatherers.has(gatherer.name);if(!isGatherRequiredByAudits){const msg=`${gatherer.name} gatherer requested, however no audit requires it.`;log.warn('config',msg);}});});const usedNames=new Set();passes.forEach(pass=>{const passName=pass.passName;if(usedNames.has(passName)){throw new Error(`Passes must have unique names (repeated passName: ${passName}.`);}
usedNames.add(passName);});}
function validateCategories(categories,audits,groups){if(!categories){return;}
Object.keys(categories).forEach(categoryId=>{categories[categoryId].auditRefs.forEach((auditRef,index)=>{if(!auditRef.id){throw new Error(`missing an audit id at ${categoryId}[${index}]`);}
const audit=audits&&audits.find(a=>a.implementation.meta.id===auditRef.id);if(!audit){throw new Error(`could not find ${auditRef.id} audit for category ${categoryId}`);}
const auditImpl=audit.implementation;const isManual=auditImpl.meta.scoreDisplayMode==='manual';if(categoryId==='accessibility'&&!auditRef.group&&!isManual){throw new Error(`${auditRef.id} accessibility audit does not have a group`);}
if(auditRef.weight>0&&isManual){throw new Error(`${auditRef.id} is manual but has a positive weight`);}
if(auditRef.group&&(!groups||!groups[auditRef.group])){throw new Error(`${auditRef.id} references unknown group ${auditRef.group}`);}});});}
function assertValidAudit(auditDefinition,auditPath){const auditName=auditPath||auditDefinition&&auditDefinition.meta&&auditDefinition.meta.id;if(typeof auditDefinition.audit!=='function'||auditDefinition.audit===Audit.audit){throw new Error(`${auditName} has no audit() method.`);}
if(typeof auditDefinition.meta.id!=='string'){throw new Error(`${auditName} has no meta.id property, or the property is not a string.`);}
if(typeof auditDefinition.meta.title!=='string'){throw new Error(`${auditName} has no meta.title property, or the property is not a string.`);}
if(typeof auditDefinition.meta.failureTitle!=='string'&&auditDefinition.meta.scoreDisplayMode===Audit.SCORING_MODES.BINARY){throw new Error(`${auditName} has no failureTitle and should.`);}
if(typeof auditDefinition.meta.description!=='string'){throw new Error(`${auditName} has no meta.description property, or the property is not a string.`);}else if(auditDefinition.meta.description===''){throw new Error(`${auditName} has an empty meta.description string. Please add a description for the UI.`);}
if(!Array.isArray(auditDefinition.meta.requiredArtifacts)){throw new Error(`${auditName} has no meta.requiredArtifacts property, or the property is not an array.`);}}
function assertValidGatherer(gathererInstance,gathererName){gathererName=gathererName||gathererInstance.name||'gatherer';if(typeof gathererInstance.beforePass!=='function'){throw new Error(`${gathererName} has no beforePass() method.`);}
if(typeof gathererInstance.pass!=='function'){throw new Error(`${gathererName} has no pass() method.`);}
if(typeof gathererInstance.afterPass!=='function'){throw new Error(`${gathererName} has no afterPass() method.`);}}
function cleanFlagsForSettings(flags={}){const settings={};for(const key of Object.keys(flags)){if(typeof constants.defaultSettings[key]!=='undefined'){const safekey=key;settings[safekey]=flags[safekey];}}
return settings;}
function _merge(base,extension,overwriteArrays=false){if(typeof base==='undefined'||base===null){return extension;}else if(typeof extension==='undefined'){return base;}else if(Array.isArray(extension)){if(overwriteArrays)return extension;if(!Array.isArray(base))throw new TypeError(`Expected array but got ${typeof base}`);const merged=base.slice();extension.forEach(item=>{if(!merged.some(candidate=>isDeepEqual(candidate,item)))merged.push(item);});return merged;}else if(typeof extension==='object'){if(typeof base!=='object')throw new TypeError(`Expected object but got ${typeof base}`);if(Array.isArray(base))throw new TypeError('Expected object but got Array');Object.keys(extension).forEach(key=>{const localOverwriteArrays=overwriteArrays||key==='settings'&&typeof base[key]==='object';base[key]=_merge(base[key],extension[key],localOverwriteArrays);});return base;}
return extension;}
const merge=_merge;function cloneArrayWithPluginSafety(array){return array.map(item=>{if(typeof item==='object'){return Object.assign(Object.create(Object.getPrototypeOf(item)),item);}
return item;});}
function deepClone(json){return JSON.parse(JSON.stringify(json));}
function deepCloneConfigJson(json){const cloned=deepClone(json);if(Array.isArray(cloned.passes)&&Array.isArray(json.passes)){for(let i=0;i<cloned.passes.length;i++){const pass=cloned.passes[i];pass.gatherers=cloneArrayWithPluginSafety(json.passes[i].gatherers||[]);}}
if(Array.isArray(json.audits)){cloned.audits=cloneArrayWithPluginSafety(json.audits);}
return cloned;}
const mergeOptionsOfItems=function(items){const mergedItems=[];for(const item of items){const existingItem=item.path&&mergedItems.find(candidate=>candidate.path===item.path);if(!existingItem){mergedItems.push(item);continue;}
existingItem.options=Object.assign({},existingItem.options,item.options);}
return mergedItems;};class Config{constructor(configJSON,flags){let configPath=flags&&flags.configPath;if(!configJSON){configJSON=defaultConfig;configPath=path.resolve(__dirname,defaultConfigPath);}
if(configPath&&!path.isAbsolute(configPath)){throw new Error('configPath must be an absolute path.');}
configJSON=deepCloneConfigJson(configJSON);if(configJSON.extends==='lighthouse:full'){const explodedFullConfig=Config.extendConfigJSON(deepCloneConfigJson(defaultConfig),deepCloneConfigJson(fullConfig));configJSON=Config.extendConfigJSON(explodedFullConfig,configJSON);}else if(configJSON.extends){configJSON=Config.extendConfigJSON(deepCloneConfigJson(defaultConfig),configJSON);}
const configDir=configPath?path.dirname(configPath):undefined;const settings=Config.initSettings(configJSON.settings,flags);const passesWithDefaults=Config.augmentPassesWithDefaults(configJSON.passes);Config.adjustDefaultPassForThrottling(settings,passesWithDefaults);const passes=Config.requireGatherers(passesWithDefaults,configDir);this.settings=settings;this.passes=passes;this.audits=Config.requireAudits(configJSON.audits,configDir);this.categories=configJSON.categories||null;this.groups=configJSON.groups||null;Config.filterConfigIfNeeded(this);validatePasses(this.passes,this.audits);validateCategories(this.categories,this.audits,this.groups);const configJson=this;}
getPrintString(){const jsonConfig=deepClone(this);if(jsonConfig.passes){for(const pass of jsonConfig.passes){for(const gathererDefn of pass.gatherers){gathererDefn.implementation=undefined;gathererDefn.instance=undefined;if(Object.keys(gathererDefn.options).length===0){gathererDefn.options=undefined;}}}}
if(jsonConfig.audits){for(const auditDefn of jsonConfig.audits){auditDefn.implementation=undefined;if(Object.keys(auditDefn.options).length===0){auditDefn.options=undefined;}}}
i18n.replaceIcuMessageInstanceIds(jsonConfig,jsonConfig.settings.locale);return JSON.stringify(jsonConfig,null,2);}
static extendConfigJSON(baseJSON,extendJSON){if(extendJSON.passes&&baseJSON.passes){for(const pass of extendJSON.passes){const passName=pass.passName||constants.defaultPassConfig.passName;const basePass=baseJSON.passes.find(candidate=>candidate.passName===passName);if(!basePass){baseJSON.passes.push(pass);}else{merge(basePass,pass);}}
delete extendJSON.passes;}
return merge(baseJSON,extendJSON);}
static augmentPassesWithDefaults(passes){if(!passes){return null;}
const{defaultPassConfig}=constants;return passes.map(pass=>merge(deepClone(defaultPassConfig),pass));}
static initSettings(settingsJson={},flags){const locale=i18n.lookupLocale(flags&&flags.locale||settingsJson.locale);const{defaultSettings}=constants;const settingWithDefaults=merge(deepClone(defaultSettings),settingsJson,true);const settingsWithFlags=merge(settingWithDefaults||{},cleanFlagsForSettings(flags),true);settingsWithFlags.locale=locale;return settingsWithFlags;}
static expandAuditShorthand(audits){if(!audits){return null;}
const newAudits=audits.map(audit=>{if(typeof audit==='string'){return{path:audit,options:{}};}else if('implementation'in audit&&typeof audit.implementation.audit==='function'){return audit;}else if('path'in audit&&typeof audit.path==='string'){return audit;}else if('audit'in audit&&typeof audit.audit==='function'){return{implementation:audit,options:{}};}else{throw new Error('Invalid Audit type '+JSON.stringify(audit));}});return newAudits;}
static expandGathererShorthand(gatherers){const expanded=gatherers.map(gatherer=>{if(typeof gatherer==='string'){return{path:gatherer,options:{}};}else if('implementation'in gatherer||'instance'in gatherer){return gatherer;}else if('path'in gatherer){if(typeof gatherer.path!=='string'){throw new Error('Invalid Gatherer type '+JSON.stringify(gatherer));}
return gatherer;}else if(typeof gatherer==='function'){return{implementation:gatherer,options:{}};}else if(gatherer&&typeof gatherer.beforePass==='function'){return{instance:gatherer,options:{}};}else{throw new Error('Invalid Gatherer type '+JSON.stringify(gatherer));}});return expanded;}
static adjustDefaultPassForThrottling(settings,passes){if(!passes||settings.throttlingMethod!=='devtools'&&settings.throttlingMethod!=='provided'){return;}
const defaultPass=passes.find(pass=>pass.passName==='defaultPass');if(!defaultPass)return;const overrides=constants.nonSimulatedPassConfigOverrides;defaultPass.pauseAfterLoadMs=Math.max(overrides.pauseAfterLoadMs,defaultPass.pauseAfterLoadMs);defaultPass.cpuQuietThresholdMs=Math.max(overrides.cpuQuietThresholdMs,defaultPass.cpuQuietThresholdMs);defaultPass.networkQuietThresholdMs=Math.max(overrides.networkQuietThresholdMs,defaultPass.networkQuietThresholdMs);}
static filterConfigIfNeeded(config){const settings=config.settings;if(!settings.onlyCategories&&!settings.onlyAudits&&!settings.skipAudits){return;}
const{categories,requestedAuditNames}=Config.filterCategoriesAndAudits(config.categories,settings);const audits=config.audits&&config.audits.filter(auditDefn=>requestedAuditNames.has(auditDefn.implementation.meta.id));const requiredGathererIds=Config.getGatherersNeededByAudits(audits);const passes=Config.generatePassesNeededByGatherers(config.passes,requiredGathererIds);config.categories=categories;config.audits=audits;config.passes=passes;}
static filterCategoriesAndAudits(oldCategories,settings){if(!oldCategories){return{categories:null,requestedAuditNames:new Set()};}
if(settings.onlyAudits&&settings.skipAudits){throw new Error('Cannot set both skipAudits and onlyAudits');}
const categories={};const filterByIncludedCategory=!!settings.onlyCategories;const filterByIncludedAudit=!!settings.onlyAudits;const categoryIds=settings.onlyCategories||[];const auditIds=settings.onlyAudits||[];const skipAuditIds=settings.skipAudits||[];categoryIds.forEach(categoryId=>{if(!oldCategories[categoryId]){log.warn('config',`unrecognized category in 'onlyCategories': ${categoryId}`);}});const auditsToValidate=new Set(auditIds.concat(skipAuditIds));for(const auditId of auditsToValidate){const foundCategory=Object.keys(oldCategories).find(categoryId=>{const auditRefs=oldCategories[categoryId].auditRefs;return!!auditRefs.find(candidate=>candidate.id===auditId);});if(!foundCategory){const parentKeyName=skipAuditIds.includes(auditId)?'skipAudits':'onlyAudits';log.warn('config',`unrecognized audit in '${parentKeyName}': ${auditId}`);}else if(auditIds.includes(auditId)&&categoryIds.includes(foundCategory)){log.warn('config',`${auditId} in 'onlyAudits' is already included by `+`${foundCategory} in 'onlyCategories'`);}}
const includedAudits=new Set(auditIds);skipAuditIds.forEach(id=>includedAudits.delete(id));Object.keys(oldCategories).forEach(categoryId=>{const category=deepClone(oldCategories[categoryId]);if(filterByIncludedCategory&&filterByIncludedAudit){if(!categoryIds.includes(categoryId)){category.auditRefs=category.auditRefs.filter(audit=>auditIds.includes(audit.id));}}else if(filterByIncludedCategory){if(!categoryIds.includes(categoryId)){return;}}else if(filterByIncludedAudit){category.auditRefs=category.auditRefs.filter(audit=>auditIds.includes(audit.id));}
category.auditRefs=category.auditRefs.filter(audit=>!skipAuditIds.includes(audit.id));if(category.auditRefs.length){categories[categoryId]=category;category.auditRefs.forEach(audit=>includedAudits.add(audit.id));}});return{categories,requestedAuditNames:includedAudits};}
static getCategories(config){const categories=config.categories;if(!categories){return[];}
return Object.keys(categories).map(id=>{const title=categories[id].title;return{id,title};});}
static getGatherersNeededByAudits(audits){if(!audits){return new Set();}
return audits.reduce((list,auditDefn)=>{auditDefn.implementation.meta.requiredArtifacts.forEach(artifact=>list.add(artifact));return list;},new Set());}
static generatePassesNeededByGatherers(passes,requiredGatherers){if(!passes){return null;}
const auditsNeedTrace=requiredGatherers.has('traces');const filteredPasses=passes.map(pass=>{pass.gatherers=pass.gatherers.filter(gathererDefn=>{const gatherer=gathererDefn.instance;return requiredGatherers.has(gatherer.name);});if(pass.recordTrace&&!auditsNeedTrace){const passName=pass.passName||'unknown pass';log.warn('config',`Trace not requested by an audit, dropping trace in ${passName}`);pass.recordTrace=false;}
return pass;}).filter(pass=>{if(pass.recordTrace)return true;if(pass.passName==='defaultPass')return true;return pass.gatherers.length>0;});return filteredPasses;}
static requireAudits(audits,configPath){const expandedAudits=Config.expandAuditShorthand(audits);if(!expandedAudits){return null;}
const coreList=Runner.getAuditList();const auditDefns=expandedAudits.map(audit=>{let implementation;if('implementation'in audit){implementation=audit.implementation;}else{const auditPathJs=`${audit.path}.js`;const coreAudit=coreList.find(a=>a===auditPathJs);let requirePath=`../audits/${audit.path}`;if(!coreAudit){requirePath=Runner.resolvePlugin(audit.path,configPath,'audit');}
implementation=require(requirePath);}
return{implementation,path:audit.path,options:audit.options||{}};});const mergedAuditDefns=mergeOptionsOfItems(auditDefns);mergedAuditDefns.forEach(audit=>assertValidAudit(audit.implementation,audit.path));return mergedAuditDefns;}
static requireGathererFromPath(path,options,coreAuditList,configPath){const coreGatherer=coreAuditList.find(a=>a===`${path}.js`);let requirePath=`../gather/gatherers/${path}`;if(!coreGatherer){requirePath=Runner.resolvePlugin(path,configPath,'gatherer');}
const GathererClass=require(requirePath);return{instance:new GathererClass(),implementation:GathererClass,path,options:options||{}};}
static requireGatherers(passes,configPath){if(!passes){return null;}
const coreList=Runner.getGathererList();const fullPasses=passes.map(pass=>{const gathererDefns=Config.expandGathererShorthand(pass.gatherers).map(gathererDefn=>{if(gathererDefn.instance){return{instance:gathererDefn.instance,implementation:gathererDefn.implementation,path:gathererDefn.path,options:gathererDefn.options||{}};}else if(gathererDefn.implementation){const GathererClass=gathererDefn.implementation;return{instance:new GathererClass(),implementation:gathererDefn.implementation,path:gathererDefn.path,options:gathererDefn.options||{}};}else if(gathererDefn.path){const path=gathererDefn.path;const options=gathererDefn.options;return Config.requireGathererFromPath(path,options,coreList,configPath);}else{throw new Error('Invalid expanded Gatherer: '+JSON.stringify(gathererDefn));}});const mergedDefns=mergeOptionsOfItems(gathererDefns);mergedDefns.forEach(gatherer=>assertValidGatherer(gatherer.instance,gatherer.path));return Object.assign(pass,{gatherers:mergedDefns});});return fullPasses;}}
module.exports=Config;}).call(this,"/../lighthouse-core/config");},{"../audits/audit.js":2,"../runner.js":99,"./../lib/i18n/i18n.js":36,"./constants.js":8,"./default-config.js":9,"./full-config.js":10,"lighthouse-logger":147,"lodash.isequal":178,"path":124}],8:[function(require,module,exports){'use strict';const DEVTOOLS_RTT_ADJUSTMENT_FACTOR=3.75;const DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR=0.9;const throttling={DEVTOOLS_RTT_ADJUSTMENT_FACTOR,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR,mobile3G:{rttMs:150,throughputKbps:1.6*1024,requestLatencyMs:150*DEVTOOLS_RTT_ADJUSTMENT_FACTOR,downloadThroughputKbps:1.6*1024*DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR,uploadThroughputKbps:750*DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR,cpuSlowdownMultiplier:4}};const defaultSettings={output:'json',maxWaitForLoad:45*1000,throttlingMethod:'simulate',throttling:throttling.mobile3G,auditMode:false,gatherMode:false,disableStorageReset:false,disableDeviceEmulation:false,emulatedFormFactor:'mobile',locale:'en-US',blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,onlyAudits:null,onlyCategories:null,skipAudits:null};const defaultPassConfig={passName:'defaultPass',recordTrace:false,useThrottling:false,pauseAfterLoadMs:0,networkQuietThresholdMs:0,cpuQuietThresholdMs:0,blockedUrlPatterns:[],blankPage:'about:blank',blankDuration:300,gatherers:[]};const nonSimulatedPassConfigOverrides={pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250};module.exports={throttling,defaultSettings,defaultPassConfig,nonSimulatedPassConfigOverrides};},{}],9:[function(require,module,exports){(function(__filename){'use strict';const constants=require('./constants');const i18n=require('../lib/i18n/i18n.js');const UIStrings={performanceCategoryTitle:'Performance',metricGroupTitle:'Metrics',loadOpportunitiesGroupTitle:'Opportunities',loadOpportunitiesGroupDescription:'These optimizations can speed up your page load.',firstPaintImprovementsGroupTitle:'First Paint Improvements',firstPaintImprovementsGroupDescription:'The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint',overallImprovementsGroupTitle:'Overall Improvements',overallImprovementsGroupDescription:'Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index',diagnosticsGroupTitle:'Diagnostics',diagnosticsGroupDescription:'More information about the performance of your application.'};const str_=i18n.createMessageInstanceIdFn(__filename,UIStrings);const defaultConfig={settings:constants.defaultSettings,passes:[{passName:'defaultPass',recordTrace:true,useThrottling:true,pauseAfterLoadMs:1000,networkQuietThresholdMs:1000,cpuQuietThresholdMs:1000,gatherers:['scripts','css-usage','viewport','viewport-dimensions','theme-color','manifest','runtime-exceptions','chrome-console-messages','image-usage','accessibility','dobetterweb/anchors-with-no-rel-noopener','dobetterweb/appcache','dobetterweb/doctype','dobetterweb/domstats','dobetterweb/js-libraries','dobetterweb/optimized-images','dobetterweb/password-inputs-with-prevented-paste','dobetterweb/response-compression','dobetterweb/tags-blocking-first-paint','dobetterweb/websql','seo/meta-description','seo/font-size','seo/crawlable-links','seo/meta-robots','seo/hreflang','seo/embedded-content','seo/canonical','seo/robots-txt','fonts']},{passName:'offlinePass',gatherers:['service-worker','offline','start-url']},{passName:'redirectPass',blockedUrlPatterns:['*.css','*.jpg','*.jpeg','*.png','*.gif','*.svg','*.ttf','*.woff','*.woff2'],gatherers:['http-redirect','html-without-javascript']}],audits:['is-on-https','redirects-http','service-worker','works-offline','viewport','without-javascript','metrics/first-contentful-paint','metrics/first-meaningful-paint','load-fast-enough-for-pwa','metrics/speed-index','screenshot-thumbnails','final-screenshot','metrics/estimated-input-latency','errors-in-console','time-to-first-byte','metrics/first-cpu-idle','metrics/interactive','user-timings','critical-request-chains','redirects','webapp-install-banner','splash-screen','themed-omnibox','manifest-short-name-length','content-width','image-aspect-ratio','deprecations','mainthread-work-breakdown','bootup-time','uses-rel-preload','uses-rel-preconnect','font-display','network-requests','metrics','manual/pwa-cross-browser','manual/pwa-page-transitions','manual/pwa-each-page-has-url','accessibility/accesskeys','accessibility/aria-allowed-attr','accessibility/aria-required-attr','accessibility/aria-required-children','accessibility/aria-required-parent','accessibility/aria-roles','accessibility/aria-valid-attr-value','accessibility/aria-valid-attr','accessibility/audio-caption','accessibility/button-name','accessibility/bypass','accessibility/color-contrast','accessibility/definition-list','accessibility/dlitem','accessibility/document-title','accessibility/duplicate-id','accessibility/frame-title','accessibility/html-has-lang','accessibility/html-lang-valid','accessibility/image-alt','accessibility/input-image-alt','accessibility/label','accessibility/layout-table','accessibility/link-name','accessibility/list','accessibility/listitem','accessibility/meta-refresh','accessibility/meta-viewport','accessibility/object-alt','accessibility/tabindex','accessibility/td-headers-attr','accessibility/th-has-data-cells','accessibility/valid-lang','accessibility/video-caption','accessibility/video-description','accessibility/manual/custom-controls-labels','accessibility/manual/custom-controls-roles','accessibility/manual/focus-traps','accessibility/manual/focusable-controls','accessibility/manual/heading-levels','accessibility/manual/interactive-element-affordance','accessibility/manual/logical-tab-order','accessibility/manual/managed-focus','accessibility/manual/offscreen-content-hidden','accessibility/manual/use-landmarks','accessibility/manual/visual-order-follows-dom','byte-efficiency/uses-long-cache-ttl','byte-efficiency/total-byte-weight','byte-efficiency/offscreen-images','byte-efficiency/render-blocking-resources','byte-efficiency/unminified-css','byte-efficiency/unminified-javascript','byte-efficiency/unused-css-rules','byte-efficiency/uses-webp-images','byte-efficiency/uses-optimized-images','byte-efficiency/uses-text-compression','byte-efficiency/uses-responsive-images','byte-efficiency/efficient-animated-content','dobetterweb/appcache-manifest','dobetterweb/doctype','dobetterweb/dom-size','dobetterweb/external-anchors-use-rel-noopener','dobetterweb/geolocation-on-start','dobetterweb/no-document-write','dobetterweb/no-vulnerable-libraries','dobetterweb/js-libraries','dobetterweb/no-websql','dobetterweb/notification-on-start','dobetterweb/password-inputs-can-be-pasted-into','dobetterweb/uses-http2','dobetterweb/uses-passive-event-listeners','seo/meta-description','seo/http-status-code','seo/font-size','seo/link-text','seo/is-crawlable','seo/robots-txt','seo/hreflang','seo/plugins','seo/canonical','seo/manual/mobile-friendly','seo/manual/structured-data'],groups:{'metrics':{title:str_(UIStrings.metricGroupTitle)},'load-opportunities':{title:str_(UIStrings.loadOpportunitiesGroupTitle),description:str_(UIStrings.loadOpportunitiesGroupDescription)},'diagnostics':{title:str_(UIStrings.diagnosticsGroupTitle),description:str_(UIStrings.diagnosticsGroupDescription)},'a11y-color-contrast':{title:'Color Contrast Is Satisfactory',description:'These are opportunities to improve the legibility of your content.'},'a11y-describe-contents':{title:'Elements Describe Contents Well',description:'These are opportunities to make your content easier to understand for a user of assistive technology, like a screen reader.'},'a11y-well-structured':{title:'Elements Are Well Structured',description:'These are opportunities to make sure your HTML is appropriately structured.'},'a11y-aria':{title:'ARIA Attributes Follow Best Practices',description:'These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.'},'a11y-correct-attributes':{title:'Elements Use Attributes Correctly',description:'These are opportunities to improve the configuration of your HTML elements.'},'a11y-element-names':{title:'Elements Have Discernible Names',description:'These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for users of assistive technology, like a screen reader.'},'a11y-language':{title:'Page Specifies Valid Language',description:'These are opportunities to improve the interpretation of your content by users in different locales.'},'a11y-meta':{title:'Meta Tags Used Properly',description:'These are opportunities to improve the user experience of your site.'},'seo-mobile':{title:'Mobile Friendly',description:'Make sure your pages are mobile friendly so users don’t have to pinch or zoom '+'in order to read the content pages. [Learn more](https://developers.google.com/search/mobile-sites/).'},'seo-content':{title:'Content Best Practices',description:'Format your HTML in a way that enables crawlers to better understand your app’s content.'},'seo-crawl':{title:'Crawling and Indexing',description:'To appear in search results, crawlers need access to your app.'}},categories:{'performance':{title:str_(UIStrings.performanceCategoryTitle),auditRefs:[{id:'first-contentful-paint',weight:3,group:'metrics'},{id:'first-meaningful-paint',weight:1,group:'metrics'},{id:'speed-index',weight:4,group:'metrics'},{id:'interactive',weight:5,group:'metrics'},{id:'first-cpu-idle',weight:2,group:'metrics'},{id:'estimated-input-latency',weight:0,group:'metrics'},{id:'render-blocking-resources',weight:0,group:'load-opportunities'},{id:'uses-responsive-images',weight:0,group:'load-opportunities'},{id:'offscreen-images',weight:0,group:'load-opportunities'},{id:'unminified-css',weight:0,group:'load-opportunities'},{id:'unminified-javascript',weight:0,group:'load-opportunities'},{id:'unused-css-rules',weight:0,group:'load-opportunities'},{id:'uses-optimized-images',weight:0,group:'load-opportunities'},{id:'uses-webp-images',weight:0,group:'load-opportunities'},{id:'uses-text-compression',weight:0,group:'load-opportunities'},{id:'uses-rel-preconnect',weight:0,group:'load-opportunities'},{id:'time-to-first-byte',weight:0,group:'load-opportunities'},{id:'redirects',weight:0,group:'load-opportunities'},{id:'uses-rel-preload',weight:0,group:'load-opportunities'},{id:'efficient-animated-content',weight:0,group:'load-opportunities'},{id:'total-byte-weight',weight:0,group:'diagnostics'},{id:'uses-long-cache-ttl',weight:0,group:'diagnostics'},{id:'dom-size',weight:0,group:'diagnostics'},{id:'critical-request-chains',weight:0,group:'diagnostics'},{id:'network-requests',weight:0},{id:'metrics',weight:0},{id:'user-timings',weight:0,group:'diagnostics'},{id:'bootup-time',weight:0,group:'diagnostics'},{id:'screenshot-thumbnails',weight:0},{id:'final-screenshot',weight:0},{id:'mainthread-work-breakdown',weight:0,group:'diagnostics'},{id:'font-display',weight:0,group:'diagnostics'}]},'pwa':{title:'Progressive Web App',description:'These checks validate the aspects of a Progressive Web App, as specified by the baseline [PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist).',manualDescription:'These checks are required by the baseline '+'[PWA Checklist](https://developers.google.com/web/progressive-web-apps/checklist) but are '+'not automatically checked by Lighthouse. They do not affect your score but it\'s important that you verify them manually.',auditRefs:[{id:'load-fast-enough-for-pwa',weight:7},{id:'works-offline',weight:5},{id:'webapp-install-banner',weight:3},{id:'is-on-https',weight:2},{id:'redirects-http',weight:2},{id:'viewport',weight:2},{id:'service-worker',weight:1},{id:'without-javascript',weight:1},{id:'splash-screen',weight:1},{id:'themed-omnibox',weight:1},{id:'content-width',weight:1},{id:'manifest-short-name-length',weight:0},{id:'pwa-cross-browser',weight:0},{id:'pwa-page-transitions',weight:0},{id:'pwa-each-page-has-url',weight:0}]},'accessibility':{title:'Accessibility',description:'These checks highlight opportunities to [improve the accessibility of your web app](https://developers.google.com/web/fundamentals/accessibility). Only a subset of accessibility issues can be automatically detected so manual testing is also encouraged.',manualDescription:'These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://developers.google.com/web/fundamentals/accessibility/how-to-review).',auditRefs:[{id:'accesskeys',weight:1,group:'a11y-correct-attributes'},{id:'aria-allowed-attr',weight:3,group:'a11y-aria'},{id:'aria-required-attr',weight:2,group:'a11y-aria'},{id:'aria-required-children',weight:5,group:'a11y-aria'},{id:'aria-required-parent',weight:2,group:'a11y-aria'},{id:'aria-roles',weight:3,group:'a11y-aria'},{id:'aria-valid-attr-value',weight:2,group:'a11y-aria'},{id:'aria-valid-attr',weight:5,group:'a11y-aria'},{id:'audio-caption',weight:4,group:'a11y-correct-attributes'},{id:'button-name',weight:10,group:'a11y-element-names'},{id:'bypass',weight:10,group:'a11y-describe-contents'},{id:'color-contrast',weight:6,group:'a11y-color-contrast'},{id:'definition-list',weight:1,group:'a11y-well-structured'},{id:'dlitem',weight:1,group:'a11y-well-structured'},{id:'document-title',weight:2,group:'a11y-describe-contents'},{id:'duplicate-id',weight:5,group:'a11y-well-structured'},{id:'frame-title',weight:5,group:'a11y-describe-contents'},{id:'html-has-lang',weight:4,group:'a11y-language'},{id:'html-lang-valid',weight:1,group:'a11y-language'},{id:'image-alt',weight:8,group:'a11y-correct-attributes'},{id:'input-image-alt',weight:1,group:'a11y-correct-attributes'},{id:'label',weight:10,group:'a11y-describe-contents'},{id:'layout-table',weight:1,group:'a11y-describe-contents'},{id:'link-name',weight:9,group:'a11y-element-names'},{id:'list',weight:5,group:'a11y-well-structured'},{id:'listitem',weight:4,group:'a11y-well-structured'},{id:'meta-refresh',weight:1,group:'a11y-meta'},{id:'meta-viewport',weight:3,group:'a11y-meta'},{id:'object-alt',weight:4,group:'a11y-describe-contents'},{id:'tabindex',weight:4,group:'a11y-correct-attributes'},{id:'td-headers-attr',weight:1,group:'a11y-correct-attributes'},{id:'th-has-data-cells',weight:1,group:'a11y-correct-attributes'},{id:'valid-lang',weight:1,group:'a11y-language'},{id:'video-caption',weight:4,group:'a11y-describe-contents'},{id:'video-description',weight:3,group:'a11y-describe-contents'},{id:'logical-tab-order',weight:0},{id:'focusable-controls',weight:0},{id:'interactive-element-affordance',weight:0},{id:'managed-focus',weight:0},{id:'focus-traps',weight:0},{id:'custom-controls-labels',weight:0},{id:'custom-controls-roles',weight:0},{id:'visual-order-follows-dom',weight:0},{id:'offscreen-content-hidden',weight:0},{id:'heading-levels',weight:0},{id:'use-landmarks',weight:0}]},'best-practices':{title:'Best Practices',auditRefs:[{id:'appcache-manifest',weight:1},{id:'no-websql',weight:1},{id:'is-on-https',weight:1},{id:'uses-http2',weight:1},{id:'uses-passive-event-listeners',weight:1},{id:'no-document-write',weight:1},{id:'external-anchors-use-rel-noopener',weight:1},{id:'geolocation-on-start',weight:1},{id:'doctype',weight:1},{id:'no-vulnerable-libraries',weight:1},{id:'js-libraries',weight:0},{id:'notification-on-start',weight:1},{id:'deprecations',weight:1},{id:'password-inputs-can-be-pasted-into',weight:1},{id:'errors-in-console',weight:1},{id:'image-aspect-ratio',weight:1}]},'seo':{title:'SEO',description:'These checks ensure that your page is optimized for search engine results ranking. '+'There are additional factors Lighthouse does not check that may affect your search ranking. '+'[Learn more](https://support.google.com/webmasters/answer/35769).',manualDescription:'Run these additional validators on your site to check additional SEO best practices.',auditRefs:[{id:'viewport',weight:1,group:'seo-mobile'},{id:'document-title',weight:1,group:'seo-content'},{id:'meta-description',weight:1,group:'seo-content'},{id:'http-status-code',weight:1,group:'seo-crawl'},{id:'link-text',weight:1,group:'seo-content'},{id:'is-crawlable',weight:1,group:'seo-crawl'},{id:'robots-txt',weight:1,group:'seo-crawl'},{id:'hreflang',weight:1,group:'seo-content'},{id:'canonical',weight:1,group:'seo-content'},{id:'font-size',weight:1,group:'seo-mobile'},{id:'plugins',weight:1,group:'seo-content'},{id:'mobile-friendly',weight:0},{id:'structured-data',weight:0}]}}};module.exports=defaultConfig;Object.defineProperty(module.exports,'UIStrings',{enumerable:false,get:()=>UIStrings});}).call(this,"/../lighthouse-core/config/default-config.js");},{"../lib/i18n/i18n.js":36,"./constants":8}],10:[function(require,module,exports){'use strict';const fullConfig={extends:'lighthouse:default',settings:{},passes:[{passName:'extraPass',gatherers:['js-usage']}],audits:['byte-efficiency/unused-javascript'],categories:{'performance':{auditRefs:[{id:'unused-javascript',weight:0,group:'load-opportunities'}]}}};module.exports=fullConfig;},{}],11:[function(require,module,exports){'use strict';const ArbitraryEqualityMap=require('../../lib/arbitrary-equality-map');class ComputedArtifact{constructor(allComputedArtifacts){const cache=new ArbitraryEqualityMap();cache.setEqualityFn(ArbitraryEqualityMap.deepEquals);this._cache=cache;this._allComputedArtifacts=allComputedArtifacts;}
get name(){throw new Error('name getter not implemented for computed artifact '+this.constructor.name);}
async compute_(artifact,allComputedArtifacts){throw new Error('compute_() not implemented for computed artifact '+this.name);}
async request(requiredArtifacts){const computed=this._cache.get(requiredArtifacts);if(computed){return computed;}
const artifactPromise=this.compute_(requiredArtifacts,this._allComputedArtifacts);this._cache.set(requiredArtifacts,artifactPromise);return artifactPromise;}}
module.exports=ComputedArtifact;},{"../../lib/arbitrary-equality-map":23}],12:[function(require,module,exports){'use strict';const makeComputedArtifact=require('./new-computed-artifact');const icons=require('../../lib/icons');const PWA_DISPLAY_VALUES=['minimal-ui','fullscreen','standalone'];const SUGGESTED_SHORTNAME_LENGTH=12;class ManifestValues{static get validityIds(){return['hasManifest','hasParseableManifest'];}
static get manifestChecks(){return[{id:'hasStartUrl',failureText:'Manifest does not contain a `start_url`',validate:manifestValue=>!!manifestValue.start_url.value},{id:'hasIconsAtLeast192px',failureText:'Manifest does not have a PNG icon of at least 192px',validate:manifestValue=>icons.doExist(manifestValue)&&icons.pngSizedAtLeast(192,manifestValue).length>0},{id:'hasIconsAtLeast512px',failureText:'Manifest does not have a PNG icon of at least 512px',validate:manifestValue=>icons.doExist(manifestValue)&&icons.pngSizedAtLeast(512,manifestValue).length>0},{id:'hasPWADisplayValue',failureText:'Manifest\'s `display` value is not one of: '+PWA_DISPLAY_VALUES.join(' | '),validate:manifestValue=>PWA_DISPLAY_VALUES.includes(manifestValue.display.value)},{id:'hasBackgroundColor',failureText:'Manifest does not have `background_color`',validate:manifestValue=>!!manifestValue.background_color.value},{id:'hasThemeColor',failureText:'Manifest does not have `theme_color`',validate:manifestValue=>!!manifestValue.theme_color.value},{id:'hasShortName',failureText:'Manifest does not have `short_name`',validate:manifestValue=>!!manifestValue.short_name.value},{id:'shortNameLength',failureText:`Manifest's \`short_name\` is too long (>${SUGGESTED_SHORTNAME_LENGTH} `+`characters) to be displayed on a homescreen without truncation`,validate:manifestValue=>!!manifestValue.short_name.value&&manifestValue.short_name.value.length<=SUGGESTED_SHORTNAME_LENGTH},{id:'hasName',failureText:'Manifest does not have `name`',validate:manifestValue=>!!manifestValue.name.value}];}
static async compute_(manifest){let parseFailureReason;if(manifest===null){return{isParseFailure:true,parseFailureReason:'No manifest was fetched',allChecks:[]};}
const manifestValue=manifest.value;if(manifestValue===undefined){return{isParseFailure:true,parseFailureReason:'Manifest failed to parse as valid JSON',allChecks:[]};}
const remainingChecks=ManifestValues.manifestChecks.map(item=>{return{id:item.id,failureText:item.failureText,passing:item.validate(manifestValue)};});return{isParseFailure:false,parseFailureReason,allChecks:remainingChecks};}}
module.exports=makeComputedArtifact(ManifestValues);},{"../../lib/icons":83,"./new-computed-artifact":15}],13:[function(require,module,exports){'use strict';const ComputedArtifact=require('../computed-artifact');const BaseNode=require('../../../lib/dependency-graph/base-node');const NetworkRequest=require('../../../lib/network-request');class LanternMetricArtifact extends ComputedArtifact{static getScriptUrls(dependencyGraph,condition){const scriptUrls=new Set();dependencyGraph.traverse(node=>{if(node.type===BaseNode.TYPES.CPU)return;if(node.record.resourceType!==NetworkRequest.TYPES.Script)return;if(condition&&!condition(node))return;scriptUrls.add(node.record.url);});return scriptUrls;}
get COEFFICIENTS(){throw new Error('COEFFICIENTS unimplemented!');}
getOptimisticGraph(dependencyGraph,traceOfTab){throw new Error('Optimistic graph unimplemented!');}
getPessimisticGraph(dependencyGraph,traceOfTab){throw new Error('Pessmistic graph unimplemented!');}
getEstimateFromSimulation(simulationResult,extras){return simulationResult;}
async computeMetricWithGraphs(data,artifacts,extras){const{trace,devtoolsLog,settings}=data;const metricName=this.name.replace('Lantern','');const graph=await artifacts.requestPageDependencyGraph({trace,devtoolsLog});const traceOfTab=await artifacts.requestTraceOfTab(trace);const simulator=data.simulator||(await artifacts.requestLoadSimulator({devtoolsLog,settings}));const optimisticGraph=this.getOptimisticGraph(graph,traceOfTab);const pessimisticGraph=this.getPessimisticGraph(graph,traceOfTab);let simulateOptions={label:`optimistic${metricName}`};const optimisticSimulation=simulator.simulate(optimisticGraph,simulateOptions);simulateOptions={label:`optimisticFlex${metricName}`,flexibleOrdering:true};const optimisticFlexSimulation=simulator.simulate(optimisticGraph,simulateOptions);simulateOptions={label:`pessimistic${metricName}`};const pessimisticSimulation=simulator.simulate(pessimisticGraph,simulateOptions);const optimisticEstimate=this.getEstimateFromSimulation(optimisticSimulation.timeInMs<optimisticFlexSimulation.timeInMs?optimisticSimulation:optimisticFlexSimulation,Object.assign({},extras,{optimistic:true}));const pessimisticEstimate=this.getEstimateFromSimulation(pessimisticSimulation,Object.assign({},extras,{optimistic:false}));const interceptMultiplier=this.COEFFICIENTS.intercept>0?Math.min(1,optimisticEstimate.timeInMs/1000):1;const timing=this.COEFFICIENTS.intercept*interceptMultiplier+
this.COEFFICIENTS.optimistic*optimisticEstimate.timeInMs+
this.COEFFICIENTS.pessimistic*pessimisticEstimate.timeInMs;return{timing,optimisticEstimate,pessimisticEstimate,optimisticGraph,pessimisticGraph};}
compute_(data,computedArtifacts){return this.computeMetricWithGraphs(data,computedArtifacts);}}
module.exports=LanternMetricArtifact;},{"../../../lib/dependency-graph/base-node":25,"../../../lib/network-request":88,"../computed-artifact":11}],14:[function(require,module,exports){'use strict';const ComputedArtifact=require('../computed-artifact');const TracingProcessor=require('../../../lib/traces/tracing-processor');class ComputedMetric extends ComputedArtifact{get name(){throw new Error('Unimplemented');}
computeSimulatedMetric(data,artifacts){return artifacts[`requestLantern${this.name}`](data);}
computeObservedMetric(data,artifacts){throw new Error('Unimplemented');}
async compute_(data,computedArtifacts){const{trace,devtoolsLog,settings}=data;if(!trace||!devtoolsLog||!settings){throw new Error('Did not provide necessary metric computation data');}
const augmentedData=Object.assign({networkRecords:await computedArtifacts.requestNetworkRecords(devtoolsLog),traceOfTab:await computedArtifacts.requestTraceOfTab(trace)},data);TracingProcessor.assertHasToplevelEvents(augmentedData.traceOfTab.mainThreadEvents);switch(settings.throttlingMethod){case'simulate':return this.computeSimulatedMetric(augmentedData,computedArtifacts);case'provided':case'devtools':return this.computeObservedMetric(augmentedData,computedArtifacts);default:throw new TypeError(`Unrecognized throttling method: ${settings.throttlingMethod}`);}}}
module.exports=ComputedMetric;},{"../../../lib/traces/tracing-processor":95,"../computed-artifact":11}],15:[function(require,module,exports){'use strict';const ArbitraryEqualityMap=require('../../lib/arbitrary-equality-map.js');function makeComputedArtifact(computableArtifact){const request=({computedCache},artifact)=>{const cache=computedCache.get(computableArtifact.name)||new ArbitraryEqualityMap();computedCache.set(computableArtifact.name,cache);const computed=cache.get(artifact);if(computed){return computed;}
const artifactPromise=computableArtifact.compute_(artifact);cache.set(artifact,artifactPromise);return artifactPromise;};return Object.assign(computableArtifact,{request});}
module.exports=makeComputedArtifact;},{"../../lib/arbitrary-equality-map.js":23}],16:[function(require,module,exports){'use strict';const EventEmitter=require('events').EventEmitter;const log=require('lighthouse-logger');const LHError=require('../../lib/lh-error');class Connection{constructor(){this._lastCommandId=0;this._callbacks=new Map();this._eventEmitter=new EventEmitter();}
connect(){return Promise.reject(new Error('Not implemented'));}
disconnect(){return Promise.reject(new Error('Not implemented'));}
wsEndpoint(){return Promise.reject(new Error('Not implemented'));}
sendCommand(method,...paramArgs){const params=paramArgs.length?paramArgs[0]:undefined;log.formatProtocol('method => browser',{method,params},'verbose');const id=++this._lastCommandId;const message=JSON.stringify({id,method,params});this.sendRawMessage(message);return new Promise(resolve=>{this._callbacks.set(id,{method,resolve});});}
on(eventName,cb){if(eventName!=='protocolevent'){throw new Error('Only supports "protocolevent" events');}
if(!this._eventEmitter){throw new Error('Attempted to add event listener after connection disposed.');}
this._eventEmitter.on(eventName,cb);}
sendRawMessage(message){throw new Error('Not implemented');}
handleRawMessage(message){const object=JSON.parse(message);if(!('id'in object)){log.formatProtocol('<= event',{method:object.method,params:object.params},'verbose');this.emitProtocolEvent(object);return;}
const callback=this._callbacks.get(object.id);if(callback){this._callbacks.delete(object.id);return callback.resolve(Promise.resolve().then(_=>{if(object.error){log.formatProtocol('method <= browser ERR',{method:callback.method},'error');throw LHError.fromProtocolMessage(callback.method,object.error);}
log.formatProtocol('method <= browser OK',{method:callback.method,params:object.result},'verbose');return object.result;}));}else{const error=object.error&&object.error.message;log.formatProtocol(`disowned method <= browser ${error?'ERR':'OK'}`,{method:'UNKNOWN',params:error||object.result},'verbose');}}
emitProtocolEvent(eventMessage){if(!this._eventEmitter){throw new Error('Attempted to emit event after connection disposed.');}
this._eventEmitter.emit('protocolevent',eventMessage);}
dispose(){if(this._eventEmitter){this._eventEmitter.removeAllListeners();this._eventEmitter=null;}}}
module.exports=Connection;},{"../../lib/lh-error":85,"events":111,"lighthouse-logger":147}],17:[function(require,module,exports){'use strict';const Connection=require('./connection.js');class RawConnection extends Connection{constructor(port){super();this._port=port;this._port.on('message',this.handleRawMessage.bind(this));this._port.on('close',this.dispose.bind(this));}
connect(){return Promise.resolve();}
disconnect(){this._port.close();return Promise.resolve();}
sendRawMessage(message){this._port.send(message);}}
module.exports=RawConnection;},{"./connection.js":16}],18:[function(require,module,exports){'use strict';class DevtoolsLog{constructor(regexFilter){this._filter=regexFilter;this._messages=[];this._isRecording=false;}
get messages(){return this._messages;}
reset(){this._messages=[];}
beginRecording(){this._isRecording=true;}
endRecording(){this._isRecording=false;}
record(message){if(this._isRecording&&(!this._filter||this._filter.test(message.method))){this._messages.push(message);}}}
module.exports=DevtoolsLog;},{}],19:[function(require,module,exports){'use strict';const NetworkRecorder=require('../lib/network-recorder');const emulation=require('../lib/emulation');const Element=require('../lib/element');const LHError=require('../lib/lh-error');const NetworkRequest=require('../lib/network-request');const EventEmitter=require('events').EventEmitter;const URL=require('../lib/url-shim');const constants=require('../config/constants');const log=require('lighthouse-logger');const DevtoolsLog=require('./devtools-log');const pageFunctions=require('../lib/page-functions.js');const Connection=require('./connections/connection.js');const DEFAULT_PAUSE_AFTER_LOAD=0;const DEFAULT_NETWORK_QUIET_THRESHOLD=5000;const DEFAULT_CPU_QUIET_THRESHOLD=0;class Driver{constructor(connection){this._traceCategories=Driver.traceCategories;this._eventEmitter=new EventEmitter();this._connection=connection;this._devtoolsLog=new DevtoolsLog(/^(Page|Network)\./);this.online=true;this._domainEnabledCounts=new Map();this._isolatedExecutionContextId=undefined;this._networkStatusMonitor=null;this._monitoredUrl=null;connection.on('protocolevent',event=>{this._devtoolsLog.record(event);if(this._networkStatusMonitor){this._networkStatusMonitor.dispatch(event);}
this._eventEmitter.emit(event.method,event.params);});}
static get traceCategories(){return['-*','toplevel','v8.execute','blink.console','blink.user_timing','benchmark','loading','latencyInfo','devtools.timeline','disabled-by-default-devtools.timeline','disabled-by-default-devtools.timeline.frame','disabled-by-default-devtools.timeline.stack','disabled-by-default-devtools.screenshot'];}
getUserAgent(){return this.evaluateAsync('navigator.userAgent');}
getBenchmarkIndex(){return this.evaluateAsync(`(${pageFunctions.ultradumbBenchmarkString})()`);}
connect(){return this._connection.connect();}
disconnect(){return this._connection.disconnect();}
wsEndpoint(){return this._connection.wsEndpoint();}
on(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen for event =>',{method:eventName},'verbose');this._eventEmitter.on(eventName,cb);}
once(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to listen to events.');}
log.formatProtocol('listen once for event =>',{method:eventName},'verbose');this._eventEmitter.once(eventName,cb);}
off(eventName,cb){if(this._eventEmitter===null){throw new Error('connect() must be called before attempting to remove an event listener.');}
this._eventEmitter.removeListener(eventName,cb);}
_shouldToggleDomain(domain,enable){const enabledCount=this._domainEnabledCounts.get(domain)||0;const newCount=enabledCount+(enable?1:-1);this._domainEnabledCounts.set(domain,Math.max(0,newCount));if(enable&&newCount===1||!enable&&newCount===0){log.verbose('Driver',`${domain}.${enable?'enable':'disable'}`);return true;}else{if(newCount<0){log.error('Driver',`Attempted to disable domain '${domain}' when already disabled.`);}
return false;}}
sendCommand(method,...params){const domainCommand=/^(\w+)\.(enable|disable)$/.exec(method);if(domainCommand){const enable=domainCommand[2]==='enable';if(!this._shouldToggleDomain(domainCommand[1],enable)){return Promise.resolve();}}
return this._connection.sendCommand(method,...params);}
isDomainEnabled(domain){return!!this._domainEnabledCounts.get(domain);}
evaluateScriptOnNewDocument(scriptSource){return this.sendCommand('Page.addScriptToEvaluateOnLoad',{scriptSource});}
evaluateAsync(expression,options={}){const contextIdPromise=options.useIsolation?this._getOrCreateIsolatedContextId():Promise.resolve(undefined);return contextIdPromise.then(contextId=>this._evaluateInContext(expression,contextId));}
_evaluateInContext(expression,contextId){return new Promise((resolve,reject)=>{const asyncTimeout=setTimeout(_=>reject(new Error('The asynchronous expression exceeded the allotted time of 60s')),60000);const evaluationParams={expression:`(function wrapInNativePromise() {
          const __nativePromise = window.__nativePromise || Promise;
          const URL = window.__nativeURL || window.URL;
          return new __nativePromise(function (resolve) {
            return __nativePromise.resolve()
              .then(_ => ${expression})
              .catch(${pageFunctions.wrapRuntimeEvalErrorInBrowserString})
              .then(resolve);
          });
        }())`,includeCommandLineAPI:true,awaitPromise:true,returnByValue:true,contextId};this.sendCommand('Runtime.evaluate',evaluationParams).then(response=>{clearTimeout(asyncTimeout);if(response.exceptionDetails){return reject(new Error(`Evaluation exception: ${response.exceptionDetails.text}`));}
if(response.result===undefined){return reject(new Error('Runtime.evaluate response did not contain a "result" object'));}
const value=response.result.value;if(value&&value.__failedInBrowser){return reject(Object.assign(new Error(),value));}else{resolve(value);}}).catch(err=>{clearTimeout(asyncTimeout);reject(err);});});}
getAppManifest(){return this.sendCommand('Page.getAppManifest').then(response=>{if(!response.data){return null;}
return response;});}
getServiceWorkerVersions(){return new Promise((resolve,reject)=>{const versionUpdatedListener=data=>{const activateCandidates=data.versions.filter(sw=>{return sw.status!=='redundant';});const hasActiveServiceWorker=activateCandidates.find(sw=>{return sw.status==='activated';});if(!activateCandidates.length||hasActiveServiceWorker){this.off('ServiceWorker.workerVersionUpdated',versionUpdatedListener);this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);}};this.on('ServiceWorker.workerVersionUpdated',versionUpdatedListener);this.sendCommand('ServiceWorker.enable').catch(reject);});}
getServiceWorkerRegistrations(){return new Promise((resolve,reject)=>{this.once('ServiceWorker.workerRegistrationUpdated',data=>{this.sendCommand('ServiceWorker.disable').then(_=>resolve(data),reject);});this.sendCommand('ServiceWorker.enable').catch(reject);});}
assertNoSameOriginServiceWorkerClients(pageUrl){let registrations;let versions;return this.getServiceWorkerRegistrations().then(data=>{registrations=data.registrations;}).then(_=>this.getServiceWorkerVersions()).then(data=>{versions=data.versions;}).then(_=>{const origin=new URL(pageUrl).origin;registrations.filter(reg=>{const swOrigin=new URL(reg.scopeURL).origin;return origin===swOrigin;}).forEach(reg=>{versions.forEach(ver=>{if(ver.registrationId!==reg.registrationId){return;}
if(ver.controlledClients&&ver.controlledClients.length>0){throw new Error('You probably have multiple tabs open to the same origin.');}});});});}
_waitForNetworkIdle(networkQuietThresholdMs){let idleTimeout;let cancel=()=>{throw new Error('_waitForNetworkIdle.cancel() called before it was defined');};if(!this._networkStatusMonitor){throw new Error('Driver._waitForNetworkIdle called with no networkStatusMonitor');}
const networkStatusMonitor=this._networkStatusMonitor;const promise=new Promise((resolve,reject)=>{const onIdle=()=>{networkStatusMonitor.once('network-2-busy',onBusy);idleTimeout=setTimeout(_=>{cancel();resolve();},networkQuietThresholdMs);};const onBusy=()=>{networkStatusMonitor.once('network-2-idle',onIdle);idleTimeout&&clearTimeout(idleTimeout);};const domContentLoadedListener=()=>{if(networkStatusMonitor.is2Idle()){onIdle();}else{onBusy();}};this.once('Page.domContentEventFired',domContentLoadedListener);cancel=()=>{idleTimeout&&clearTimeout(idleTimeout);this.off('Page.domContentEventFired',domContentLoadedListener);networkStatusMonitor.removeListener('network-2-busy',onBusy);networkStatusMonitor.removeListener('network-2-idle',onIdle);};});return{promise,cancel};}
_waitForCPUIdle(waitForCPUQuiet){if(!waitForCPUQuiet){return{promise:Promise.resolve(),cancel:()=>undefined};}
let lastTimeout;let cancelled=false;const checkForQuietExpression=`(${pageFunctions.checkTimeSinceLastLongTaskString})()`;function checkForQuiet(driver,resolve){if(cancelled)return;return driver.evaluateAsync(checkForQuietExpression).then(timeSinceLongTask=>{if(cancelled)return;if(typeof timeSinceLongTask==='number'){if(timeSinceLongTask>=waitForCPUQuiet){log.verbose('Driver',`CPU has been idle for ${timeSinceLongTask} ms`);resolve();}else{log.verbose('Driver',`CPU has been idle for ${timeSinceLongTask} ms`);const timeToWait=waitForCPUQuiet-timeSinceLongTask;lastTimeout=setTimeout(()=>checkForQuiet(driver,resolve),timeToWait);}}});}
let cancel=()=>{throw new Error('_waitForCPUIdle.cancel() called before it was defined');};const promise=new Promise((resolve,reject)=>{checkForQuiet(this,resolve);cancel=()=>{cancelled=true;if(lastTimeout)clearTimeout(lastTimeout);reject(new Error('Wait for CPU idle cancelled'));};});return{promise,cancel};}
_waitForLoadEvent(pauseAfterLoadMs){let cancel=()=>{throw new Error('_waitForLoadEvent.cancel() called before it was defined');};const promise=new Promise((resolve,reject)=>{let loadTimeout;const loadListener=function(){loadTimeout=setTimeout(resolve,pauseAfterLoadMs);};this.once('Page.loadEventFired',loadListener);cancel=()=>{this.off('Page.loadEventFired',loadListener);loadTimeout&&clearTimeout(loadTimeout);};});return{promise,cancel};}
async _waitForFullyLoaded(pauseAfterLoadMs,networkQuietThresholdMs,cpuQuietThresholdMs,maxWaitForLoadedMs){let maxTimeoutHandle;const waitForLoadEvent=this._waitForLoadEvent(pauseAfterLoadMs);const waitForNetworkIdle=this._waitForNetworkIdle(networkQuietThresholdMs);let waitForCPUIdle=null;const loadPromise=Promise.all([waitForLoadEvent.promise,waitForNetworkIdle.promise]).then(()=>{waitForCPUIdle=this._waitForCPUIdle(cpuQuietThresholdMs);return waitForCPUIdle.promise;}).then(()=>{return function(){log.verbose('Driver','loadEventFired and network considered idle');maxTimeoutHandle&&clearTimeout(maxTimeoutHandle);};});const maxTimeoutPromise=new Promise((resolve,reject)=>{maxTimeoutHandle=setTimeout(resolve,maxWaitForLoadedMs);}).then(_=>{return function(){log.warn('Driver','Timed out waiting for page load. Moving on...');waitForLoadEvent.cancel();waitForNetworkIdle.cancel();waitForCPUIdle&&waitForCPUIdle.cancel();};});const cleanupFn=await Promise.race([loadPromise,maxTimeoutPromise]);cleanupFn();}
_beginNetworkStatusMonitoring(startingUrl){this._networkStatusMonitor=new NetworkRecorder();this._monitoredUrl=startingUrl;const requestLoadedListener=redirectRequest=>{if(!redirectRequest.redirectSource){return;}
const earlierRequest=redirectRequest.redirectSource;if(earlierRequest.url===this._monitoredUrl){this._monitoredUrl=redirectRequest.url;}};this._networkStatusMonitor.on('requestloaded',requestLoadedListener);return this.sendCommand('Network.enable');}
_endNetworkStatusMonitoring(){this._networkStatusMonitor=null;const finalUrl=this._monitoredUrl;this._monitoredUrl=null;if(!finalUrl){throw new Error('Network Status Monitoring ended with an undefined finalUrl');}
return finalUrl;}
async _getOrCreateIsolatedContextId(){if(typeof this._isolatedExecutionContextId==='number'){return this._isolatedExecutionContextId;}
const resourceTreeResponse=await this.sendCommand('Page.getResourceTree');const mainFrameId=resourceTreeResponse.frameTree.frame.id;const isolatedWorldResponse=await this.sendCommand('Page.createIsolatedWorld',{frameId:mainFrameId,worldName:'lighthouse_isolated_context'});this._isolatedExecutionContextId=isolatedWorldResponse.executionContextId;return isolatedWorldResponse.executionContextId;}
_clearIsolatedContextId(){this._isolatedExecutionContextId=undefined;}
async gotoURL(url,options={}){const waitForLoad=options.waitForLoad||false;const passContext=options.passContext||{};const disableJS=passContext.disableJavaScript||false;await this._beginNetworkStatusMonitoring(url);await this._clearIsolatedContextId();this.sendCommand('Page.enable');this.sendCommand('Emulation.setScriptExecutionDisabled',{value:disableJS});this.sendCommand('Page.navigate',{url});if(waitForLoad){const passConfig=passContext.passConfig||{};let{pauseAfterLoadMs,networkQuietThresholdMs,cpuQuietThresholdMs}=passConfig;let maxWaitMs=passContext.settings&&passContext.settings.maxWaitForLoad;if(typeof pauseAfterLoadMs!=='number')pauseAfterLoadMs=DEFAULT_PAUSE_AFTER_LOAD;if(typeof networkQuietThresholdMs!=='number')networkQuietThresholdMs=DEFAULT_NETWORK_QUIET_THRESHOLD;if(typeof cpuQuietThresholdMs!=='number')cpuQuietThresholdMs=DEFAULT_CPU_QUIET_THRESHOLD;if(typeof maxWaitMs!=='number')maxWaitMs=constants.defaultSettings.maxWaitForLoad;await this._waitForFullyLoaded(pauseAfterLoadMs,networkQuietThresholdMs,cpuQuietThresholdMs,maxWaitMs);}
return this._endNetworkStatusMonitoring();}
async getObjectProperty(objectId,propName){const propertiesResponse=await this.sendCommand('Runtime.getProperties',{objectId,accessorPropertiesOnly:true,generatePreview:false,ownProperties:false});const propertyForName=propertiesResponse.result.find(property=>property.name===propName);if(propertyForName&&propertyForName.value){return propertyForName.value.value;}else{return null;}}
getRequestContent(requestId,timeout=1000){requestId=NetworkRequest.getRequestIdForBackend(requestId);return new Promise((resolve,reject)=>{const err=new LHError(LHError.errors.REQUEST_CONTENT_TIMEOUT);const asyncTimeout=setTimeout(_=>reject(err),timeout);this.sendCommand('Network.getResponseBody',{requestId}).then(result=>{clearTimeout(asyncTimeout);resolve(result.body);}).catch(e=>{clearTimeout(asyncTimeout);reject(e);});});}
queryPermissionState(name){const expressionToEval=`
      navigator.permissions.query({name: '${name}'}).then(result => {
        return result.state;
      })
    `;return this.evaluateAsync(expressionToEval);}
async querySelector(selector){const documentResponse=await this.sendCommand('DOM.getDocument');const rootNodeId=documentResponse.root.nodeId;const targetNode=await this.sendCommand('DOM.querySelector',{nodeId:rootNodeId,selector});if(targetNode.nodeId===0){return null;}
return new Element(targetNode,this);}
async querySelectorAll(selector){const documentResponse=await this.sendCommand('DOM.getDocument');const rootNodeId=documentResponse.root.nodeId;const targetNodeList=await this.sendCommand('DOM.querySelectorAll',{nodeId:rootNodeId,selector});const elementList=[];targetNodeList.nodeIds.forEach(nodeId=>{if(nodeId!==0){elementList.push(new Element({nodeId},this));}});return elementList;}
getElementsInDocument(pierce=true){return this.getNodesInDocument(pierce).then(nodes=>nodes.filter(node=>node.nodeType===1).map(node=>new Element({nodeId:node.nodeId},this)));}
async getNodesInDocument(pierce=true){const flattenedDocument=await this.sendCommand('DOM.getFlattenedDocument',{depth:-1,pierce});return flattenedDocument.nodes?flattenedDocument.nodes:[];}
beginTrace(settings){const additionalCategories=settings&&settings.additionalTraceCategories&&settings.additionalTraceCategories.split(',')||[];const traceCategories=this._traceCategories.concat(additionalCategories);const uniqueCategories=Array.from(new Set(traceCategories));if(this.isDomainEnabled('Debugger')){throw new Error('Debugger domain enabled when starting trace');}
if(this.isDomainEnabled('CSS')){throw new Error('CSS domain enabled when starting trace');}
if(this.isDomainEnabled('DOM')){throw new Error('DOM domain enabled when starting trace');}
return this.sendCommand('Page.enable').then(_=>this.sendCommand('Tracing.start',{categories:uniqueCategories.join(','),options:'sampling-frequency=10000'}));}
endTrace(){const traceEvents=[];const dataListener=function(data){traceEvents.push(...data.value);};this.on('Tracing.dataCollected',dataListener);return new Promise((resolve,reject)=>{this.once('Tracing.tracingComplete',_=>{this.off('Tracing.dataCollected',dataListener);resolve({traceEvents});});return this.sendCommand('Tracing.end').catch(reject);});}
beginDevtoolsLog(){this._devtoolsLog.reset();this._devtoolsLog.beginRecording();}
endDevtoolsLog(){this._devtoolsLog.endRecording();return this._devtoolsLog.messages;}
enableRuntimeEvents(){return this.sendCommand('Runtime.enable');}
async beginEmulation(settings){if(!settings.disableDeviceEmulation){if(settings.emulatedFormFactor==='mobile'){await emulation.enableNexus5X(this);}else if(settings.emulatedFormFactor==='desktop'){await emulation.enableDesktop(this);}}
await this.setThrottling(settings,{useThrottling:true});}
async setThrottling(settings,passConfig){if(settings.throttlingMethod!=='devtools'){return emulation.clearAllNetworkEmulation(this);}
const cpuPromise=passConfig.useThrottling?emulation.enableCPUThrottling(this,settings.throttling):emulation.disableCPUThrottling(this);const networkPromise=passConfig.useThrottling?emulation.enableNetworkThrottling(this,settings.throttling):emulation.clearAllNetworkEmulation(this);await Promise.all([cpuPromise,networkPromise]);}
async goOffline(){await this.sendCommand('Network.enable');await emulation.goOffline(this);this.online=false;}
async goOnline(options){await this.setThrottling(options.settings,options.passConfig);this.online=true;}
cleanBrowserCaches(){return this.sendCommand('Network.clearBrowserCache').then(_=>this.sendCommand('Network.setCacheDisabled',{cacheDisabled:true})).then(_=>this.sendCommand('Network.setCacheDisabled',{cacheDisabled:false}));}
async setExtraHTTPHeaders(headers){if(!headers){return;}
return this.sendCommand('Network.setExtraHTTPHeaders',{headers});}
clearDataForOrigin(url){const origin=new URL(url).origin;const typesToClear=['appcache','file_systems','indexeddb','local_storage','shader_cache','websql','service_workers','cache_storage'].join(',');return this.sendCommand('Storage.clearDataForOrigin',{origin:origin,storageTypes:typesToClear});}
async cacheNatives(){await this.evaluateScriptOnNewDocument(`window.__nativePromise = Promise;
        window.__nativeError = Error;
        window.__nativeURL = URL;`);}
async registerPerformanceObserver(){const scriptStr=`(${pageFunctions.registerPerformanceObserverInPageString})()`;await this.evaluateScriptOnNewDocument(scriptStr);}
blockUrlPatterns(urls){return this.sendCommand('Network.setBlockedURLs',{urls}).catch(err=>{if(!/wasn't found/.test(err.message)){throw err;}});}
async dismissJavaScriptDialogs(){await this.sendCommand('Page.enable');this.on('Page.javascriptDialogOpening',data=>{log.warn('Driver',`${data.type} dialog opened by the page automatically suppressed.`);this.sendCommand('Page.handleJavaScriptDialog',{accept:true,promptText:'Lighthouse prompt response'});});}}
module.exports=Driver;},{"../config/constants":8,"../lib/element":33,"../lib/emulation":34,"../lib/lh-error":85,"../lib/network-recorder":87,"../lib/network-request":88,"../lib/page-functions.js":89,"../lib/url-shim":"url","./connections/connection.js":16,"./devtools-log":18,"events":111,"lighthouse-logger":147}],20:[function(require,module,exports){'use strict';const log=require('lighthouse-logger');const LHError=require('../lib/lh-error');const URL=require('../lib/url-shim');const NetworkRecorder=require('../lib/network-recorder.js');const constants=require('../config/constants');const Driver=require('../gather/driver.js');class GatherRunner{static async loadBlank(driver,url=constants.defaultPassConfig.blankPage,duration=constants.defaultPassConfig.blankDuration)
{await driver.gotoURL(url);await new Promise(resolve=>setTimeout(resolve,duration));}
static async loadPage(driver,passContext){const finalUrl=await driver.gotoURL(passContext.url,{waitForLoad:true,passContext});passContext.url=finalUrl;}
static async setupDriver(driver,options){log.log('status','Initializing…');const resetStorage=!options.settings.disableStorageReset;await driver.assertNoSameOriginServiceWorkerClients(options.requestedUrl);await driver.beginEmulation(options.settings);await driver.enableRuntimeEvents();await driver.cacheNatives();await driver.registerPerformanceObserver();await driver.dismissJavaScriptDialogs();if(resetStorage)await driver.clearDataForOrigin(options.requestedUrl);}
static disposeDriver(driver){log.log('status','Disconnecting from browser...');return driver.disconnect().catch(err=>{if(!/close\/.*status: 500$/.test(err.message)){log.error('GatherRunner disconnect',err.message);}});}
static recoverOrThrow(promise){return promise.catch(err=>{if(err.fatal){throw err;}});}
static getPageLoadError(url,networkRecords){const mainRecord=networkRecords.find(record=>{return URL.equalWithExcludedFragments(record.url,url);});let errorDef;if(!mainRecord){errorDef=LHError.errors.NO_DOCUMENT_REQUEST;}else if(mainRecord.failed){errorDef={...LHError.errors.FAILED_DOCUMENT_REQUEST};errorDef.message+=` ${mainRecord.localizedFailDescription}.`;}else if(mainRecord.hasErrorStatusCode()){errorDef={...LHError.errors.ERRORED_DOCUMENT_REQUEST};errorDef.message+=` Status code: ${mainRecord.statusCode}.`;}
if(errorDef){return new LHError(errorDef);}}
static async beforePass(passContext,gathererResults){const blockedUrls=(passContext.passConfig.blockedUrlPatterns||[]).concat(passContext.settings.blockedUrlPatterns||[]);const blankPage=passContext.passConfig.blankPage;const blankDuration=passContext.passConfig.blankDuration;await GatherRunner.loadBlank(passContext.driver,blankPage,blankDuration);await passContext.driver.blockUrlPatterns(blockedUrls);await passContext.driver.setExtraHTTPHeaders(passContext.settings.extraHeaders);for(const gathererDefn of passContext.passConfig.gatherers){const gatherer=gathererDefn.instance;passContext.options=gathererDefn.options||{};const artifactPromise=Promise.resolve().then(_=>gatherer.beforePass(passContext));gathererResults[gatherer.name]=[artifactPromise];await GatherRunner.recoverOrThrow(artifactPromise);}}
static async pass(passContext,gathererResults){const driver=passContext.driver;const config=passContext.passConfig;const settings=passContext.settings;const gatherers=config.gatherers;const recordTrace=config.recordTrace;const isPerfRun=!settings.disableStorageReset&&recordTrace&&config.useThrottling;const gatherernames=gatherers.map(g=>g.instance.name).join(', ');const status='Loading page & waiting for onload';log.log('status',status,gatherernames);if(isPerfRun)await driver.cleanBrowserCaches();await driver.beginDevtoolsLog();if(recordTrace)await driver.beginTrace(settings);await GatherRunner.loadPage(driver,passContext);log.log('statusEnd',status);for(const gathererDefn of gatherers){const gatherer=gathererDefn.instance;passContext.options=gathererDefn.options||{};const artifactPromise=Promise.resolve().then(_=>gatherer.pass(passContext));const gathererResult=gathererResults[gatherer.name]||[];gathererResult.push(artifactPromise);gathererResults[gatherer.name]=gathererResult;await GatherRunner.recoverOrThrow(artifactPromise);}}
static async afterPass(passContext,gathererResults){const driver=passContext.driver;const config=passContext.passConfig;const gatherers=config.gatherers;let trace;if(config.recordTrace){log.log('status','Retrieving trace');trace=await driver.endTrace();log.verbose('statusEnd','Retrieving trace');}
const status='Retrieving devtoolsLog and network records';log.log('status',status);const devtoolsLog=driver.endDevtoolsLog();const networkRecords=NetworkRecorder.recordsFromLogs(devtoolsLog);log.verbose('statusEnd',status);let pageLoadError=GatherRunner.getPageLoadError(passContext.url,networkRecords);if(!driver.online)pageLoadError=undefined;if(pageLoadError){log.error('GatherRunner',pageLoadError.message,passContext.url);passContext.LighthouseRunWarnings.push(pageLoadError.friendlyMessage);}
const passData={networkRecords,devtoolsLog,trace};await driver.setThrottling(passContext.settings,{useThrottling:false});for(const gathererDefn of gatherers){const gatherer=gathererDefn.instance;const status=`Retrieving: ${gatherer.name}`;log.log('status',status);passContext.options=gathererDefn.options||{};const artifactPromise=pageLoadError?Promise.reject(pageLoadError):Promise.resolve().then(_=>gatherer.afterPass(passContext,passData));const gathererResult=gathererResults[gatherer.name]||[];gathererResult.push(artifactPromise);gathererResults[gatherer.name]=gathererResult;await GatherRunner.recoverOrThrow(artifactPromise);log.verbose('statusEnd',status);}
return passData;}
static async collectArtifacts(gathererResults,baseArtifacts){const gathererArtifacts={};const resultsEntries=Object.entries(gathererResults);for(const[gathererName,phaseResultsPromises]of resultsEntries){if(gathererArtifacts[gathererName]!==undefined)continue;try{const phaseResults=await Promise.all(phaseResultsPromises);const definedResults=phaseResults.filter(element=>element!==undefined);const artifact=definedResults[definedResults.length-1];gathererArtifacts[gathererName]=artifact;}catch(err){gathererArtifacts[gathererName]=err;}
if(gathererArtifacts[gathererName]===undefined){throw new Error(`${gathererName} failed to provide an artifact.`);}}
baseArtifacts.LighthouseRunWarnings=Array.from(new Set(baseArtifacts.LighthouseRunWarnings));return{...baseArtifacts,...gathererArtifacts};}
static async getBaseArtifacts(options){return{fetchTime:new Date().toJSON(),LighthouseRunWarnings:[],HostUserAgent:await options.driver.getUserAgent(),NetworkUserAgent:'',BenchmarkIndex:0,traces:{},devtoolsLogs:{},settings:options.settings,URL:{requestedUrl:options.requestedUrl,finalUrl:''}};}
static async run(passes,options){const driver=options.driver;const gathererResults={};try{await driver.connect();const baseArtifacts=await GatherRunner.getBaseArtifacts(options);await GatherRunner.loadBlank(driver);baseArtifacts.BenchmarkIndex=await options.driver.getBenchmarkIndex();await GatherRunner.setupDriver(driver,options);let firstPass=true;for(const passConfig of passes){const passContext={driver:options.driver,url:options.requestedUrl,settings:options.settings,passConfig,LighthouseRunWarnings:baseArtifacts.LighthouseRunWarnings};await driver.setThrottling(options.settings,passConfig);await GatherRunner.beforePass(passContext,gathererResults);await GatherRunner.pass(passContext,gathererResults);const passData=await GatherRunner.afterPass(passContext,gathererResults);baseArtifacts.devtoolsLogs[passConfig.passName]=passData.devtoolsLog;const userAgentEntry=passData.devtoolsLog.find(entry=>entry.method==='Network.requestWillBeSent'&&!!entry.params.request.headers['User-Agent']);if(userAgentEntry&&!baseArtifacts.NetworkUserAgent){baseArtifacts.NetworkUserAgent=userAgentEntry.params.request.headers['User-Agent'];}
if(passData.trace){baseArtifacts.traces[passConfig.passName]=passData.trace;}
if(firstPass){baseArtifacts.URL.finalUrl=passContext.url;firstPass=false;}}
const resetStorage=!options.settings.disableStorageReset;if(resetStorage)await driver.clearDataForOrigin(options.requestedUrl);await GatherRunner.disposeDriver(driver);return GatherRunner.collectArtifacts(gathererResults,baseArtifacts);}catch(err){GatherRunner.disposeDriver(driver);throw err;}}}
module.exports=GatherRunner;},{"../config/constants":8,"../gather/driver.js":19,"../lib/lh-error":85,"../lib/network-recorder.js":87,"../lib/url-shim":"url","lighthouse-logger":147}],21:[function(require,module,exports){'use strict';class Gatherer{get name(){return this.constructor.name;}
beforePass(passContext){}
pass(passContext){}
afterPass(passContext,loadData){}}
module.exports=Gatherer;},{}],22:[function(require,module,exports){'use strict';const Runner=require('./runner');const log=require('lighthouse-logger');const ChromeProtocol=require('./gather/connections/cri.js');const Config=require('./config/config');const URL=require('./lib/url-shim.js');const LHError=require('./lib/lh-error.js');async function lighthouse(url,flags={},configJSON,connection){if(url&&(!URL.isValid(url)||!URL.isProtocolAllowed(url))){throw new LHError(LHError.errors.INVALID_URL);}
flags.logLevel=flags.logLevel||'error';log.setLevel(flags.logLevel);const config=generateConfig(configJSON,flags);connection=connection||new ChromeProtocol(flags.port,flags.hostname);return Runner.run(connection,{url,config});}
function generateConfig(configJson,flags){return new Config(configJson,flags);}
lighthouse.generateConfig=generateConfig;lighthouse.getAuditList=Runner.getAuditList;lighthouse.traceCategories=require('./gather/driver').traceCategories;lighthouse.Audit=require('./audits/audit');lighthouse.Gatherer=require('./gather/gatherers/gatherer');module.exports=lighthouse;},{"./audits/audit":2,"./config/config":7,"./gather/connections/cri.js":107,"./gather/driver":19,"./gather/gatherers/gatherer":21,"./lib/lh-error.js":85,"./lib/url-shim.js":"url","./runner":99,"lighthouse-logger":147}],23:[function(require,module,exports){'use strict';const isEqual=require('lodash.isequal');class ArbitraryEqualityMap{constructor(){this._equalsFn=(a,b)=>a===b;this._entries=[];}
setEqualityFn(equalsFn){this._equalsFn=equalsFn;}
has(key){return this._findIndexOf(key)!==-1;}
get(key){const entry=this._entries[this._findIndexOf(key)];return entry&&entry.value;}
set(key,value){let index=this._findIndexOf(key);if(index===-1)index=this._entries.length;this._entries[index]={key,value};}
_findIndexOf(key){for(let i=0;i<this._entries.length;i++){if(this._equalsFn(key,this._entries[i].key))return i;}
return-1;}
static deepEquals(objA,objB){return isEqual(objA,objB);}}
module.exports=ArbitraryEqualityMap;},{"lodash.isequal":178}],24:[function(require,module,exports){(function(process){'use strict';const path=require('path');const log=require('lighthouse-logger');const stream=require('stream');const Simulator=require('./dependency-graph/simulator/simulator');const lanternTraceSaver=require('./lantern-trace-saver');const Metrics=require('./traces/pwmetrics-events');const rimraf=require('rimraf');const mkdirp=require('mkdirp');const artifactsFilename='artifacts.json';const traceSuffix='.trace.json';const devtoolsLogSuffix='.devtoolslog.json';async function loadArtifacts(basePath){log.log('Reading artifacts from disk:',basePath);if(!fs.existsSync(basePath)){throw new Error('No saved artifacts found at '+basePath);}
const artifacts=JSON.parse(fs.readFileSync(path.join(basePath,artifactsFilename),'utf8'));const filenames=fs.readdirSync(basePath);artifacts.devtoolsLogs={};filenames.filter(f=>f.endsWith(devtoolsLogSuffix)).forEach(filename=>{const passName=filename.replace(devtoolsLogSuffix,'');const devtoolsLog=JSON.parse(fs.readFileSync(path.join(basePath,filename),'utf8'));artifacts.devtoolsLogs[passName]=devtoolsLog;});artifacts.traces={};filenames.filter(f=>f.endsWith(traceSuffix)).forEach(filename=>{const file=fs.readFileSync(path.join(basePath,filename),{encoding:'utf-8'});const trace=JSON.parse(file);const passName=filename.replace(traceSuffix,'');artifacts.traces[passName]=Array.isArray(trace)?{traceEvents:trace}:trace;});return artifacts;}
async function saveArtifacts(artifacts,basePath){mkdirp.sync(basePath);rimraf.sync(`${basePath}/*${traceSuffix}`);rimraf.sync(`${basePath}/${artifactsFilename}`);const{traces,devtoolsLogs,...restArtifacts}=artifacts;for(const[passName,trace]of Object.entries(traces)){await saveTrace(trace,`${basePath}/${passName}${traceSuffix}`);}
for(const[passName,devtoolsLog]of Object.entries(devtoolsLogs)){const log=JSON.stringify(devtoolsLog);fs.writeFileSync(`${basePath}/${passName}${devtoolsLogSuffix}`,log,'utf8');}
const restArtifactsString=JSON.stringify(restArtifacts,null,2);fs.writeFileSync(`${basePath}/${artifactsFilename}`,restArtifactsString,'utf8');log.log('Artifacts saved to disk in folder:',basePath);}
async function prepareAssets(artifacts,audits){const passNames=Object.keys(artifacts.traces);const assets=[];for(const passName of passNames){const trace=artifacts.traces[passName];const devtoolsLog=artifacts.devtoolsLogs[passName];const traceData=Object.assign({},trace);if(audits){const evts=new Metrics(traceData.traceEvents,audits).generateFakeEvents();traceData.traceEvents=traceData.traceEvents.concat(evts);}
assets.push({passName,traceData,devtoolsLog});}
return assets;}
function*traceJsonGenerator(traceData){const EVENTS_PER_ITERATION=500;const keys=Object.keys(traceData);yield'{\n';yield'"traceEvents": [\n';if(traceData.traceEvents.length>0){const eventsIterator=traceData.traceEvents[Symbol.iterator]();const firstEvent=eventsIterator.next().value;yield`  ${JSON.stringify(firstEvent)}`;let eventsRemaining=EVENTS_PER_ITERATION;let eventsJSON='';for(const event of eventsIterator){eventsJSON+=`,\n  ${JSON.stringify(event)}`;eventsRemaining--;if(eventsRemaining===0){yield eventsJSON;eventsRemaining=EVENTS_PER_ITERATION;eventsJSON='';}}
yield eventsJSON;}
yield'\n]';if(keys.length>1){for(const key of keys){if(key==='traceEvents')continue;yield`,\n"${key}": ${JSON.stringify(traceData[key],null,2)}`;}}
yield'}\n';}
function saveTrace(traceData,traceFilename){return new Promise((resolve,reject)=>{const traceIter=traceJsonGenerator(traceData);const traceStream=new stream.Readable({read(){const next=traceIter.next();this.push(next.done?null:next.value);}});const writeStream=fs.createWriteStream(traceFilename);writeStream.on('finish',resolve);writeStream.on('error',reject);traceStream.pipe(writeStream);});}
async function saveLanternDebugTraces(pathWithBasename){if(!process.env.LANTERN_DEBUG)return;for(const[label,nodeTimings]of Simulator.ALL_NODE_TIMINGS){if(lanternTraceSaver.simulationNamesToIgnore.includes(label))continue;const traceFilename=`${pathWithBasename}-${label}${traceSuffix}`;await saveTrace(lanternTraceSaver.convertNodeTimingsToTrace(nodeTimings),traceFilename);log.log('saveAssets',`${label} lantern trace file streamed to disk: ${traceFilename}`);}}
async function saveAssets(artifacts,audits,pathWithBasename){const allAssets=await prepareAssets(artifacts,audits);const saveAll=allAssets.map(async(passAssets,index)=>{const devtoolsLogFilename=`${pathWithBasename}-${index}${devtoolsLogSuffix}`;fs.writeFileSync(devtoolsLogFilename,JSON.stringify(passAssets.devtoolsLog,null,2));log.log('saveAssets','devtools log saved to disk: '+devtoolsLogFilename);const streamTraceFilename=`${pathWithBasename}-${index}${traceSuffix}`;log.log('saveAssets','streaming trace file to disk: '+streamTraceFilename);await saveTrace(passAssets.traceData,streamTraceFilename);log.log('saveAssets','trace file streamed to disk: '+streamTraceFilename);});await Promise.all(saveAll);await saveLanternDebugTraces(pathWithBasename);}
async function logAssets(artifacts,audits){const allAssets=await prepareAssets(artifacts,audits);allAssets.map(passAssets=>{const dtlogdata=JSON.stringify(passAssets.devtoolsLog);console.log(`loggedAsset %%% devtoolslog-${passAssets.passName}.json %%% ${dtlogdata}`);const traceIter=traceJsonGenerator(passAssets.traceData);let traceJson='';for(const trace of traceIter){traceJson+=trace;}
console.log(`loggedAsset %%% trace-${passAssets.passName}.json %%% ${traceJson}`);});}
module.exports={saveArtifacts,loadArtifacts,saveAssets,prepareAssets,saveTrace,logAssets};}).call(this,require('_process'));},{"./dependency-graph/simulator/simulator":31,"./lantern-trace-saver":84,"./traces/pwmetrics-events":94,"_process":126,"lighthouse-logger":147,"mkdirp":107,"path":124,"rimraf":107,"stream":141}],25:[function(require,module,exports){'use strict';class BaseNode{constructor(id){this._id=id;this._isMainDocument=false;this._dependents=[];this._dependencies=[];}
get id(){return this._id;}
get type(){throw new Error('Unimplemented');}
get startTime(){throw new Error('Unimplemented');}
get endTime(){throw new Error('Unimplemented');}
setIsMainDocument(value){this._isMainDocument=value;}
isMainDocument(){return this._isMainDocument;}
getDependents(){return this._dependents.slice();}
getDependencies(){return this._dependencies.slice();}
getNumberOfDependencies(){return this._dependencies.length;}
getRootNode(){let rootNode=this;while(rootNode._dependencies.length){rootNode=rootNode._dependencies[0];}
return rootNode;}
addDependent(node){node.addDependency(this);}
addDependency(node){if(this._dependencies.includes(node)){return;}
node._dependents.push(this);this._dependencies.push(node);}
removeDependent(node){node.removeDependency(this);}
removeDependency(node){if(!this._dependencies.includes(node)){return;}
const thisIndex=node._dependents.indexOf(this);node._dependents.splice(thisIndex,1);this._dependencies.splice(this._dependencies.indexOf(node),1);}
removeAllDependencies(){for(const node of this._dependencies.slice()){this.removeDependency(node);}}
cloneWithoutRelationships(){const node=new BaseNode(this.id);node.setIsMainDocument(this._isMainDocument);return node;}
cloneWithRelationships(predicate){const rootNode=this.getRootNode();let shouldIncludeNode=()=>true;if(predicate){const idsToInclude=new Set();rootNode.traverse(node=>{if(predicate(node)){node.traverse(node=>idsToInclude.add(node.id),node=>node._dependencies.filter(parent=>!idsToInclude.has(parent)));}});shouldIncludeNode=node=>idsToInclude.has(node.id);}
const idToNodeMap=new Map();rootNode.traverse(originalNode=>{if(!shouldIncludeNode(originalNode))return;const clonedNode=originalNode.cloneWithoutRelationships();idToNodeMap.set(clonedNode.id,clonedNode);});rootNode.traverse(originalNode=>{if(!shouldIncludeNode(originalNode))return;const clonedNode=idToNodeMap.get(originalNode.id);for(const dependency of originalNode._dependencies){const clonedDependency=idToNodeMap.get(dependency.id);clonedNode.addDependency(clonedDependency);}});if(!idToNodeMap.has(this.id))throw new Error(`Cloned graph missing node ${this.id}`);return idToNodeMap.get(this.id);}
_traversePaths(iterator,getNext){const stack=[[this]];while(stack.length){const path=stack.shift();const node=path[0];iterator(node,path);const nodesToAdd=getNext(node);for(const nextNode of nodesToAdd){stack.push([nextNode].concat(path));}}}
traverse(iterator,getNext){if(!getNext){getNext=node=>node.getDependents();}
const visited=new Set();const originalGetNext=getNext;getNext=node=>{visited.add(node.id);const allNodesToVisit=originalGetNext(node);const nodesToVisit=allNodesToVisit.filter(nextNode=>!visited.has(nextNode.id));nodesToVisit.forEach(nextNode=>visited.add(nextNode.id));return nodesToVisit;};this._traversePaths(iterator,getNext);}
static hasCycle(node,direction='both'){if(direction==='both'){return BaseNode.hasCycle(node,'dependents')||BaseNode.hasCycle(node,'dependencies');}
const visited=new Set();const currentPath=[];const toVisit=[node];const depthAdded=new Map([[node,0]]);while(toVisit.length){const currentNode=toVisit.pop();if(currentPath.includes(currentNode))return true;if(visited.has(currentNode))continue;while(currentPath.length>depthAdded.get(currentNode))currentPath.pop();visited.add(currentNode);currentPath.push(currentNode);const nodesToExplore=direction==='dependents'?currentNode._dependents:currentNode._dependencies;for(const nextNode of nodesToExplore){if(toVisit.includes(nextNode))continue;toVisit.push(nextNode);depthAdded.set(nextNode,currentPath.length);}}
return false;}}
BaseNode.TYPES={NETWORK:'network',CPU:'cpu'};module.exports=BaseNode;},{}],26:[function(require,module,exports){'use strict';const BaseNode=require('./base-node');class CPUNode extends BaseNode{constructor(parentEvent,childEvents=[]){const nodeId=`${parentEvent.tid}.${parentEvent.ts}`;super(nodeId);this._event=parentEvent;this._childEvents=childEvents;}
get type(){return BaseNode.TYPES.CPU;}
get startTime(){return this._event.ts;}
get endTime(){return this._event.ts+this._event.dur;}
get event(){return this._event;}
get childEvents(){return this._childEvents;}
didPerformLayout(){return this._childEvents.some(evt=>evt.name==='Layout');}
isEvaluateScriptFor(urls){return this._childEvents.some(evt=>{return evt.name==='EvaluateScript'&&!!evt.args.data&&!!evt.args.data.url&&urls.has(evt.args.data.url);});}
cloneWithoutRelationships(){return new CPUNode(this._event,this._childEvents);}}
module.exports=CPUNode;},{"./base-node":25}],27:[function(require,module,exports){'use strict';const BaseNode=require('./base-node');const NetworkRequest=require('../network-request');class NetworkNode extends BaseNode{constructor(networkRecord){super(networkRecord.requestId);this._record=networkRecord;}
get type(){return BaseNode.TYPES.NETWORK;}
get startTime(){return this._record.startTime*1000*1000;}
get endTime(){return this._record.endTime*1000*1000;}
get record(){return this._record;}
get initiatorType(){return this._record.initiator&&this._record.initiator.type;}
get fromDiskCache(){return!!this._record.fromDiskCache;}
hasRenderBlockingPriority(){const priority=this._record.priority;const isScript=this._record.resourceType===NetworkRequest.TYPES.Script;const isDocument=this._record.resourceType===NetworkRequest.TYPES.Document;const isBlockingScript=priority==='High'&&isScript;const isBlockingHtmlImport=priority==='High'&&isDocument;return priority==='VeryHigh'||isBlockingScript||isBlockingHtmlImport;}
cloneWithoutRelationships(){const node=new NetworkNode(this._record);node.setIsMainDocument(this._isMainDocument);return node;}}
module.exports=NetworkNode;},{"../network-request":88,"./base-node":25}],28:[function(require,module,exports){'use strict';const NetworkAnalyzer=require('./network-analyzer');const TcpConnection=require('./tcp-connection');const DEFAULT_SERVER_RESPONSE_TIME=30;const TLS_SCHEMES=['https','wss'];const CONNECTIONS_PER_ORIGIN=6;module.exports=class ConnectionPool{constructor(records,options){this._options=Object.assign({rtt:undefined,throughput:undefined,additionalRttByOrigin:new Map(),serverResponseTimeByOrigin:new Map()},options);if(!this._options.rtt||!this._options.throughput){throw new Error('Cannot create pool with no rtt or throughput');}
this._records=records;this._connectionsByOrigin=new Map();this._connectionsByRecord=new Map();this._connectionsInUse=new Set();this._connectionReusedByRequestId=NetworkAnalyzer.estimateIfConnectionWasReused(records,{forceCoarseEstimates:true});this._initializeConnections();}
connectionsInUse(){return Array.from(this._connectionsInUse);}
_initializeConnections(){const connectionReused=this._connectionReusedByRequestId;const additionalRttByOrigin=this._options.additionalRttByOrigin;const serverResponseTimeByOrigin=this._options.serverResponseTimeByOrigin;const recordsByOrigin=NetworkAnalyzer.groupByOrigin(this._records);for(const[origin,records]of recordsByOrigin.entries()){const connections=[];const additionalRtt=additionalRttByOrigin.get(origin)||0;const responseTime=serverResponseTimeByOrigin.get(origin)||DEFAULT_SERVER_RESPONSE_TIME;for(const record of records){if(connectionReused.get(record.requestId))continue;const isTLS=TLS_SCHEMES.includes(record.parsedURL.scheme);const isH2=record.protocol==='h2';const connection=new TcpConnection(this._options.rtt+additionalRtt,this._options.throughput,responseTime,isTLS,isH2);connections.push(connection);}
if(!connections.length){throw new Error(`Could not find a connection for origin: ${origin}`);}
while(connections.length<CONNECTIONS_PER_ORIGIN)connections.push(connections[0].clone());this._connectionsByOrigin.set(origin,connections);}}
acquire(record,options={}){if(this._connectionsByRecord.has(record)){return this._connectionsByRecord.get(record);}
const origin=String(record.parsedURL.securityOrigin);const connections=this._connectionsByOrigin.get(origin)||[];const availableConnections=connections.filter(connection=>!this._connectionsInUse.has(connection)).sort((a,b)=>b.congestionWindow-a.congestionWindow);const observedConnectionWasReused=!!this._connectionReusedByRequestId.get(record.requestId);let connectionToUse=availableConnections[0];if(!options.ignoreConnectionReused){connectionToUse=availableConnections.find(connection=>connection.isWarm()===observedConnectionWasReused);}
if(!connectionToUse)return null;this._connectionsInUse.add(connectionToUse);this._connectionsByRecord.set(record,connectionToUse);return connectionToUse;}
release(record){const connection=this._connectionsByRecord.get(record);this._connectionsByRecord.delete(record);this._connectionsInUse.delete(connection);}};},{"./network-analyzer":30,"./tcp-connection":32}],29:[function(require,module,exports){'use strict';const DNS_RESOLUTION_RTT_MULTIPLIER=2;class DNSCache{constructor(options){this._options=Object.assign({rtt:undefined},options);if(!this._options.rtt){throw new Error('Cannot create DNS cache with no rtt');}
this._rtt=this._options.rtt;this._resolvedDomainNames=new Map();}
getTimeUntilResolution(request,options){const{requestedAt=0,shouldUpdateCache=false}=options||{};const domain=request.parsedURL.host;const cacheEntry=this._resolvedDomainNames.get(domain);let timeUntilResolved=this._rtt*DNSCache.RTT_MULTIPLIER;if(cacheEntry){const timeUntilCachedIsResolved=Math.max(cacheEntry.resolvedAt-requestedAt,0);timeUntilResolved=Math.min(timeUntilCachedIsResolved,timeUntilResolved);}
const resolvedAt=requestedAt+timeUntilResolved;if(shouldUpdateCache)this._updateCacheResolvedAtIfNeeded(request,resolvedAt);return timeUntilResolved;}
_updateCacheResolvedAtIfNeeded(request,resolvedAt){const domain=request.parsedURL.host;const cacheEntry=this._resolvedDomainNames.get(domain)||{resolvedAt};cacheEntry.resolvedAt=Math.min(cacheEntry.resolvedAt,resolvedAt);this._resolvedDomainNames.set(domain,cacheEntry);}
setResolvedAt(domain,resolvedAt){this._resolvedDomainNames.set(domain,{resolvedAt});}}
DNSCache.RTT_MULTIPLIER=DNS_RESOLUTION_RTT_MULTIPLIER;module.exports=DNSCache;},{}],30:[function(require,module,exports){'use strict';const INITIAL_CWD=14*1024;const NetworkRequest=require('../../network-request');const DEFAULT_SERVER_RESPONSE_PERCENTAGE=0.4;const SERVER_RESPONSE_PERCENTAGE_OF_TTFB={Document:0.9,XHR:0.9,Fetch:0.9};class NetworkAnalyzer{static get SUMMARY(){return'__SUMMARY__';}
static groupByOrigin(records){const grouped=new Map();records.forEach(item=>{const key=item.parsedURL.securityOrigin;const group=grouped.get(key)||[];group.push(item);grouped.set(key,group);});return grouped;}
static getSummary(values){values.sort((a,b)=>a-b);return{min:values[0],max:values[values.length-1],avg:values.reduce((a,b)=>a+b,0)/values.length,median:values[Math.floor((values.length-1)/2)]};}
static summarize(values){const summaryByKey=new Map();const allEstimates=[];for(const[key,estimates]of values){summaryByKey.set(key,NetworkAnalyzer.getSummary(estimates));allEstimates.push(...estimates);}
summaryByKey.set(NetworkAnalyzer.SUMMARY,NetworkAnalyzer.getSummary(allEstimates));return summaryByKey;}
static _estimateValueByOrigin(records,iteratee){const connectionWasReused=NetworkAnalyzer.estimateIfConnectionWasReused(records);const groupedByOrigin=NetworkAnalyzer.groupByOrigin(records);const estimates=new Map();for(const[origin,originRecords]of groupedByOrigin.entries()){let originEstimates=[];for(const record of originRecords){const timing=record.timing;if(!timing)continue;const value=iteratee({record,timing,connectionReused:connectionWasReused.get(record.requestId)});if(typeof value!=='undefined'){originEstimates=originEstimates.concat(value);}}
if(!originEstimates.length)continue;estimates.set(origin,originEstimates);}
return estimates;}
static _estimateRTTByOriginViaTCPTiming(records){return NetworkAnalyzer._estimateValueByOrigin(records,({timing,connectionReused})=>{if(connectionReused)return;if(timing.sslStart>0&&timing.sslEnd>0){return[timing.connectEnd-timing.sslStart,timing.sslStart-timing.connectStart];}else if(timing.connectStart>0&&timing.connectEnd>0){return timing.connectEnd-timing.connectStart;}});}
static _estimateRTTByOriginViaDownloadTiming(records){return NetworkAnalyzer._estimateValueByOrigin(records,({record,timing,connectionReused})=>{if(connectionReused)return;if(record.transferSize<=INITIAL_CWD)return;if(!Number.isFinite(timing.receiveHeadersEnd)||timing.receiveHeadersEnd<0)return;const totalTime=(record.endTime-record.startTime)*1000;const downloadTimeAfterFirstByte=totalTime-timing.receiveHeadersEnd;const numberOfRoundTrips=Math.log2(record.transferSize/INITIAL_CWD);if(numberOfRoundTrips>5)return;return downloadTimeAfterFirstByte/numberOfRoundTrips;});}
static _estimateRTTByOriginViaSendStartTiming(records){return NetworkAnalyzer._estimateValueByOrigin(records,({record,timing,connectionReused})=>{if(connectionReused)return;if(!Number.isFinite(timing.sendStart)||timing.sendStart<0)return;let roundTrips=2;if(record.parsedURL.scheme==='https')roundTrips+=1;return timing.sendStart/roundTrips;});}
static _estimateRTTByOriginViaHeadersEndTiming(records){return NetworkAnalyzer._estimateValueByOrigin(records,({record,timing,connectionReused})=>{if(!Number.isFinite(timing.receiveHeadersEnd)||timing.receiveHeadersEnd<0)return;if(!record.resourceType)return;const serverResponseTimePercentage=SERVER_RESPONSE_PERCENTAGE_OF_TTFB[record.resourceType]||DEFAULT_SERVER_RESPONSE_PERCENTAGE;const estimatedServerResponseTime=timing.receiveHeadersEnd*serverResponseTimePercentage;let roundTrips=1;if(!connectionReused){roundTrips+=1;if(record.parsedURL.scheme==='https')roundTrips+=1;roundTrips+=1;}
return Math.max((timing.receiveHeadersEnd-estimatedServerResponseTime)/roundTrips,3);});}
static _estimateResponseTimeByOrigin(records,rttByOrigin){return NetworkAnalyzer._estimateValueByOrigin(records,({record,timing})=>{if(!Number.isFinite(timing.receiveHeadersEnd)||timing.receiveHeadersEnd<0)return;if(!Number.isFinite(timing.sendEnd)||timing.sendEnd<0)return;const ttfb=timing.receiveHeadersEnd-timing.sendEnd;const origin=record.parsedURL.securityOrigin;const rtt=rttByOrigin.get(origin)||rttByOrigin.get(NetworkAnalyzer.SUMMARY)||0;return Math.max(ttfb-rtt,0);});}
static canTrustConnectionInformation(records){const connectionIdWasStarted=new Map();for(const record of records){const started=connectionIdWasStarted.get(record.connectionId)||!record.connectionReused;connectionIdWasStarted.set(record.connectionId,started);}
if(connectionIdWasStarted.size<=1)return false;return Array.from(connectionIdWasStarted.values()).every(started=>started);}
static estimateIfConnectionWasReused(records,options){options=Object.assign({forceCoarseEstimates:false},options);if(!options.forceCoarseEstimates&&NetworkAnalyzer.canTrustConnectionInformation(records)){return new Map(records.map(record=>[record.requestId,!!record.connectionReused]));}
const connectionWasReused=new Map();const groupedByOrigin=NetworkAnalyzer.groupByOrigin(records);for(const[_,originRecords]of groupedByOrigin.entries()){const earliestReusePossible=originRecords.map(record=>record.endTime).reduce((a,b)=>Math.min(a,b),Infinity);for(const record of originRecords){connectionWasReused.set(record.requestId,record.startTime>=earliestReusePossible||record.protocol==='h2');}
const firstRecord=originRecords.reduce((a,b)=>a.startTime>b.startTime?b:a);connectionWasReused.set(firstRecord.requestId,false);}
return connectionWasReused;}
static estimateRTTByOrigin(records,options){options=Object.assign({forceCoarseEstimates:false,coarseEstimateMultiplier:0.3,useDownloadEstimates:true,useSendStartEstimates:true,useHeadersEndEstimates:true},options);let estimatesByOrigin=NetworkAnalyzer._estimateRTTByOriginViaTCPTiming(records);if(!estimatesByOrigin.size||options.forceCoarseEstimates){estimatesByOrigin=new Map();const estimatesViaDownload=NetworkAnalyzer._estimateRTTByOriginViaDownloadTiming(records);const estimatesViaSendStart=NetworkAnalyzer._estimateRTTByOriginViaSendStartTiming(records);const estimatesViaTTFB=NetworkAnalyzer._estimateRTTByOriginViaHeadersEndTiming(records);for(const[origin,estimates]of estimatesViaDownload.entries()){if(!options.useDownloadEstimates)continue;estimatesByOrigin.set(origin,estimates);}
for(const[origin,estimates]of estimatesViaSendStart.entries()){if(!options.useSendStartEstimates)continue;const existing=estimatesByOrigin.get(origin)||[];estimatesByOrigin.set(origin,existing.concat(estimates));}
for(const[origin,estimates]of estimatesViaTTFB.entries()){if(!options.useHeadersEndEstimates)continue;const existing=estimatesByOrigin.get(origin)||[];estimatesByOrigin.set(origin,existing.concat(estimates));}
for(const estimates of estimatesByOrigin.values()){estimates.forEach((x,i)=>estimates[i]=x*options.coarseEstimateMultiplier);}}
if(!estimatesByOrigin.size)throw new Error('No timing information available');return NetworkAnalyzer.summarize(estimatesByOrigin);}
static estimateServerResponseTimeByOrigin(records,options){options=Object.assign({rttByOrigin:null},options);let rttByOrigin=options.rttByOrigin;if(!rttByOrigin){rttByOrigin=NetworkAnalyzer.estimateRTTByOrigin(records,options);for(const[origin,summary]of rttByOrigin.entries()){rttByOrigin.set(origin,summary.min);}}
const estimatesByOrigin=NetworkAnalyzer._estimateResponseTimeByOrigin(records,rttByOrigin);return NetworkAnalyzer.summarize(estimatesByOrigin);}
static findMainDocument(records){const documentRequests=records.filter(record=>record.resourceType===NetworkRequest.TYPES.Document);return documentRequests.sort((a,b)=>a.startTime-b.startTime)[0];}}
module.exports=NetworkAnalyzer;},{"../../network-request":88}],31:[function(require,module,exports){'use strict';const BaseNode=require('../base-node');const TcpConnection=require('./tcp-connection');const ConnectionPool=require('./connection-pool');const DNSCache=require('./dns-cache');const mobile3G=require('../../../config/constants').throttling.mobile3G;const DEFAULT_MAXIMUM_CONCURRENT_REQUESTS=10;const DEFAULT_LAYOUT_TASK_MULTIPLIER=0.5;const DEFAULT_MAXIMUM_CPU_TASK_DURATION=10000;const NodeState={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3};const ALL_SIMULATION_NODE_TIMINGS=new Map();class Simulator{constructor(options){this._options=Object.assign({rtt:mobile3G.rttMs,throughput:mobile3G.throughputKbps*1024,maximumConcurrentRequests:DEFAULT_MAXIMUM_CONCURRENT_REQUESTS,cpuSlowdownMultiplier:mobile3G.cpuSlowdownMultiplier,layoutTaskMultiplier:DEFAULT_LAYOUT_TASK_MULTIPLIER,additionalRttByOrigin:new Map(),serverResponseTimeByOrigin:new Map()},options);this._rtt=this._options.rtt;this._throughput=this._options.throughput;this._maximumConcurrentRequests=Math.max(Math.min(TcpConnection.maximumSaturatedConnections(this._rtt,this._throughput),this._options.maximumConcurrentRequests),1);this._cpuSlowdownMultiplier=this._options.cpuSlowdownMultiplier;this._layoutTaskMultiplier=this._cpuSlowdownMultiplier*this._options.layoutTaskMultiplier;this._flexibleOrdering=false;this._nodeTimings=new Map();this._numberInProgressByType=new Map();this._nodes={};this._dns=new DNSCache({rtt:this._rtt});this._connectionPool=null;}
_initializeConnectionPool(graph){const records=[];graph.getRootNode().traverse(node=>{if(node.type===BaseNode.TYPES.NETWORK){records.push(node.record);}});this._connectionPool=new ConnectionPool(records,this._options);}
_initializeAuxiliaryData(){this._nodeTimings=new Map();this._numberInProgressByType=new Map();this._nodes={};for(const state of Object.values(NodeState)){this._nodes[state]=new Set();}}
_numberInProgress(type){return this._numberInProgressByType.get(type)||0;}
_setTimingData(node,values){const timingData=this._nodeTimings.get(node)||{};Object.assign(timingData,values);this._nodeTimings.set(node,timingData);}
_getTimingData(node){const timingData=this._nodeTimings.get(node);if(!timingData)throw new Error(`Unable to get timing data for node ${node.id}`);return timingData;}
_markNodeAsReadyToStart(node,queuedTime){this._nodes[NodeState.ReadyToStart].add(node);this._nodes[NodeState.NotReadyToStart].delete(node);this._setTimingData(node,{queuedTime});}
_markNodeAsInProgress(node,startTime){this._nodes[NodeState.InProgress].add(node);this._nodes[NodeState.ReadyToStart].delete(node);this._numberInProgressByType.set(node.type,this._numberInProgress(node.type)+1);this._setTimingData(node,{startTime});}
_markNodeAsComplete(node,endTime){this._nodes[NodeState.Complete].add(node);this._nodes[NodeState.InProgress].delete(node);this._numberInProgressByType.set(node.type,this._numberInProgress(node.type)-1);this._setTimingData(node,{endTime});for(const dependent of node.getDependents()){const dependencies=dependent.getDependencies();if(dependencies.some(dep=>!this._nodes[NodeState.Complete].has(dep)))continue;this._markNodeAsReadyToStart(dependent,endTime);}}
_acquireConnection(record){return this._connectionPool.acquire(record,{ignoreConnectionReused:this._flexibleOrdering});}
_startNodeIfPossible(node,totalElapsedTime){if(node.type===BaseNode.TYPES.CPU){if(this._numberInProgress(node.type)===0){this._markNodeAsInProgress(node,totalElapsedTime);this._setTimingData(node,{timeElapsed:0});}
return;}
if(node.type!==BaseNode.TYPES.NETWORK)throw new Error('Unsupported');if(!node.fromDiskCache){const numberOfActiveRequests=this._numberInProgress(node.type);if(numberOfActiveRequests>=this._maximumConcurrentRequests)return;const connection=this._acquireConnection(node.record);if(!connection)return;}
this._markNodeAsInProgress(node,totalElapsedTime);this._setTimingData(node,{timeElapsed:0,timeElapsedOvershoot:0,bytesDownloaded:0});}
_updateNetworkCapacity(){for(const connection of this._connectionPool.connectionsInUse()){connection.setThroughput(this._throughput/this._nodes[NodeState.InProgress].size);}}
_estimateTimeRemaining(node){if(node.type===BaseNode.TYPES.CPU){return this._estimateCPUTimeRemaining(node);}else if(node.type===BaseNode.TYPES.NETWORK){return this._estimateNetworkTimeRemaining(node);}else{throw new Error('Unsupported');}}
_estimateCPUTimeRemaining(cpuNode){const timingData=this._getTimingData(cpuNode);const multiplier=cpuNode.didPerformLayout()?this._layoutTaskMultiplier:this._cpuSlowdownMultiplier;const totalDuration=Math.min(Math.round(cpuNode.event.dur/1000*multiplier),DEFAULT_MAXIMUM_CPU_TASK_DURATION);const estimatedTimeElapsed=totalDuration-timingData.timeElapsed;this._setTimingData(cpuNode,{estimatedTimeElapsed});return estimatedTimeElapsed;}
_estimateNetworkTimeRemaining(networkNode){const record=networkNode.record;const timingData=this._getTimingData(networkNode);let timeElapsed=0;if(networkNode.fromDiskCache){const sizeInMb=(record.resourceSize||0)/1024/1024;timeElapsed=8+20*sizeInMb-timingData.timeElapsed;}else{const connection=this._acquireConnection(record);const dnsResolutionTime=this._dns.getTimeUntilResolution(record,{requestedAt:timingData.startTime,shouldUpdateCache:true});const timeAlreadyElapsed=timingData.timeElapsed;const calculation=connection.simulateDownloadUntil(record.transferSize-timingData.bytesDownloaded,{timeAlreadyElapsed,dnsResolutionTime,maximumTimeToElapse:Infinity});timeElapsed=calculation.timeElapsed;}
const estimatedTimeElapsed=timeElapsed+timingData.timeElapsedOvershoot;this._setTimingData(networkNode,{estimatedTimeElapsed});return estimatedTimeElapsed;}
_findNextNodeCompletionTime(){let minimumTime=Infinity;for(const node of this._nodes[NodeState.InProgress]){minimumTime=Math.min(minimumTime,this._estimateTimeRemaining(node));}
return minimumTime;}
_updateProgressMadeInTimePeriod(node,timePeriodLength,totalElapsedTime){const timingData=this._getTimingData(node);const isFinished=timingData.estimatedTimeElapsed===timePeriodLength;if(node.type===BaseNode.TYPES.CPU||node.fromDiskCache){return isFinished?this._markNodeAsComplete(node,totalElapsedTime):timingData.timeElapsed+=timePeriodLength;}
if(node.type!==BaseNode.TYPES.NETWORK)throw new Error('Unsupported');const record=node.record;const connection=this._acquireConnection(record);const dnsResolutionTime=this._dns.getTimeUntilResolution(record,{requestedAt:timingData.startTime,shouldUpdateCache:true});const calculation=connection.simulateDownloadUntil(record.transferSize-timingData.bytesDownloaded,{dnsResolutionTime,timeAlreadyElapsed:timingData.timeElapsed,maximumTimeToElapse:timePeriodLength-timingData.timeElapsedOvershoot});connection.setCongestionWindow(calculation.congestionWindow);connection.setH2OverflowBytesDownloaded(calculation.extraBytesDownloaded);if(isFinished){connection.setWarmed(true);this._connectionPool.release(record);this._markNodeAsComplete(node,totalElapsedTime);}else{timingData.timeElapsed+=calculation.timeElapsed;timingData.timeElapsedOvershoot+=calculation.timeElapsed-timePeriodLength;timingData.bytesDownloaded+=calculation.bytesDownloaded;}}
_computeFinalNodeTimings(){const nodeTimings=new Map();for(const[node,timing]of this._nodeTimings){nodeTimings.set(node,{startTime:timing.startTime,endTime:timing.endTime,duration:timing.endTime-timing.startTime});}
return nodeTimings;}
getOptions(){return this._options;}
simulate(graph,options){if(BaseNode.hasCycle(graph)){throw new Error('Cannot simulate graph with cycle');}
options=Object.assign({label:undefined,flexibleOrdering:false},options);this._flexibleOrdering=!!options.flexibleOrdering;this._dns=new DNSCache({rtt:this._rtt});this._initializeConnectionPool(graph);this._initializeAuxiliaryData();const nodesNotReadyToStart=this._nodes[NodeState.NotReadyToStart];const nodesReadyToStart=this._nodes[NodeState.ReadyToStart];const nodesInProgress=this._nodes[NodeState.InProgress];const rootNode=graph.getRootNode();rootNode.traverse(node=>nodesNotReadyToStart.add(node));let totalElapsedTime=0;let iteration=0;this._markNodeAsReadyToStart(rootNode,totalElapsedTime);while(nodesReadyToStart.size||nodesInProgress.size){for(const node of nodesReadyToStart){this._startNodeIfPossible(node,totalElapsedTime);}
if(!nodesInProgress.size){if(this._flexibleOrdering)throw new Error('Failed to start a node');this._flexibleOrdering=true;continue;}
this._updateNetworkCapacity();const minimumTime=this._findNextNodeCompletionTime();totalElapsedTime+=minimumTime;if(!Number.isFinite(minimumTime)||iteration>100000){throw new Error('Graph creation failed, depth exceeded');}
iteration++;for(const node of nodesInProgress){this._updateProgressMadeInTimePeriod(node,minimumTime,totalElapsedTime);}}
const nodeTimings=this._computeFinalNodeTimings();ALL_SIMULATION_NODE_TIMINGS.set(options.label||'unlabeled',nodeTimings);return{timeInMs:totalElapsedTime,nodeTimings};}
static get ALL_NODE_TIMINGS(){return ALL_SIMULATION_NODE_TIMINGS;}}
module.exports=Simulator;},{"../../../config/constants":8,"../base-node":25,"./connection-pool":28,"./dns-cache":29,"./tcp-connection":32}],32:[function(require,module,exports){'use strict';const INITIAL_CONGESTION_WINDOW=10;const TCP_SEGMENT_SIZE=1460;class TcpConnection{constructor(rtt,throughput,serverLatency=0,ssl=true,h2=false){this._warmed=false;this._ssl=ssl;this._h2=h2;this._rtt=rtt;this._throughput=throughput;this._serverLatency=serverLatency;this._congestionWindow=INITIAL_CONGESTION_WINDOW;this._h2OverflowBytesDownloaded=0;}
static maximumSaturatedConnections(rtt,availableThroughput){const roundTripsPerSecond=1000/rtt;const bytesPerRoundTrip=TCP_SEGMENT_SIZE;const bytesPerSecond=roundTripsPerSecond*bytesPerRoundTrip;const minimumThroughputRequiredPerRequest=bytesPerSecond*8;return Math.floor(availableThroughput/minimumThroughputRequiredPerRequest);}
_computeMaximumCongestionWindowInSegments(){const bytesPerSecond=this._throughput/8;const secondsPerRoundTrip=this._rtt/1000;const bytesPerRoundTrip=bytesPerSecond*secondsPerRoundTrip;return Math.floor(bytesPerRoundTrip/TCP_SEGMENT_SIZE);}
setThroughput(throughput){this._throughput=throughput;}
setCongestionWindow(congestion){this._congestionWindow=congestion;}
setWarmed(warmed){this._warmed=warmed;}
isWarm(){return this._warmed;}
isH2(){return this._h2;}
get congestionWindow(){return this._congestionWindow;}
setH2OverflowBytesDownloaded(bytes){if(!this._h2)return;this._h2OverflowBytesDownloaded=bytes;}
clone(){return Object.assign(new TcpConnection(this._rtt,this._throughput),this);}
simulateDownloadUntil(bytesToDownload,options){const{timeAlreadyElapsed=0,maximumTimeToElapse=Infinity,dnsResolutionTime=0}=options||{};if(this._warmed&&this._h2){bytesToDownload-=this._h2OverflowBytesDownloaded;}
const twoWayLatency=this._rtt;const oneWayLatency=twoWayLatency/2;const maximumCongestionWindow=this._computeMaximumCongestionWindowInSegments();let handshakeAndRequest=oneWayLatency;if(!this._warmed){handshakeAndRequest=dnsResolutionTime+
oneWayLatency+
oneWayLatency+
oneWayLatency+(this._ssl?twoWayLatency:0);}
let roundTrips=Math.ceil(handshakeAndRequest/twoWayLatency);let timeToFirstByte=handshakeAndRequest+this._serverLatency+oneWayLatency;if(this._warmed&&this._h2)timeToFirstByte=0;const timeElapsedForTTFB=Math.max(timeToFirstByte-timeAlreadyElapsed,0);const maximumDownloadTimeToElapse=maximumTimeToElapse-timeElapsedForTTFB;let congestionWindow=Math.min(this._congestionWindow,maximumCongestionWindow);let totalBytesDownloaded=0;if(timeElapsedForTTFB>0){totalBytesDownloaded=congestionWindow*TCP_SEGMENT_SIZE;}else{roundTrips=0;}
let downloadTimeElapsed=0;let bytesRemaining=bytesToDownload-totalBytesDownloaded;while(bytesRemaining>0&&downloadTimeElapsed<=maximumDownloadTimeToElapse){roundTrips++;downloadTimeElapsed+=twoWayLatency;congestionWindow=Math.max(Math.min(maximumCongestionWindow,congestionWindow*2),1);const bytesDownloadedInWindow=congestionWindow*TCP_SEGMENT_SIZE;totalBytesDownloaded+=bytesDownloadedInWindow;bytesRemaining-=bytesDownloadedInWindow;}
const timeElapsed=timeElapsedForTTFB+downloadTimeElapsed;const extraBytesDownloaded=this._h2?Math.max(totalBytesDownloaded-bytesToDownload,0):0;const bytesDownloaded=Math.max(Math.min(totalBytesDownloaded,bytesToDownload),0);return{roundTrips,timeElapsed,bytesDownloaded,extraBytesDownloaded,congestionWindow};}}
module.exports=TcpConnection;},{}],33:[function(require,module,exports){'use strict';const Driver=require('../gather/driver.js');class Element{constructor(element,driver){if(!element||!driver){throw Error('Driver and element required to create Element');}
this.driver=driver;this.element=element;}
getAttribute(name){return this.driver.sendCommand('DOM.getAttributes',{nodeId:this.element.nodeId}).then(resp=>{const attrIndex=resp.attributes.indexOf(name);if(attrIndex===-1){return null;}
return resp.attributes[attrIndex+1];});}
getNodeId(){return this.element.nodeId;}
getProperty(propName){return this.driver.sendCommand('DOM.resolveNode',{nodeId:this.element.nodeId}).then(resp=>{if(!resp.object.objectId){return null;}
return this.driver.getObjectProperty(resp.object.objectId,propName);}).catch(()=>null);}}
module.exports=Element;},{"../gather/driver.js":19}],34:[function(require,module,exports){'use strict';const NEXUS5X_EMULATION_METRICS={mobile:true,screenWidth:412,screenHeight:732,width:412,height:732,positionX:0,positionY:0,scale:1,deviceScaleFactor:2.625,screenOrientation:{angle:0,type:'portraitPrimary'}};const DESKTOP_EMULATION_METRICS={mobile:false,width:1366,height:768,deviceScaleFactor:1};const NEXUS5X_USERAGENT={userAgent:'Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5 Build/MRA58N) AppleWebKit/537.36'+'(KHTML, like Gecko) Chrome/71.0.3559.0 Mobile Safari/537.36'};const DESKTOP_USERAGENT={userAgent:'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 '+'(KHTML, like Gecko) Chrome/71.0.3559.0 Safari/537.36'};const OFFLINE_METRICS={offline:true,latency:0,downloadThroughput:0,uploadThroughput:0};const NO_THROTTLING_METRICS={latency:0,downloadThroughput:0,uploadThroughput:0,offline:false};const NO_CPU_THROTTLE_METRICS={rate:1};async function enableNexus5X(driver){await Promise.all([driver.sendCommand('Emulation.setDeviceMetricsOverride',NEXUS5X_EMULATION_METRICS),driver.sendCommand('Network.enable'),driver.sendCommand('Network.setUserAgentOverride',NEXUS5X_USERAGENT),driver.sendCommand('Emulation.setTouchEmulationEnabled',{enabled:true})]);}
async function enableDesktop(driver){await Promise.all([driver.sendCommand('Emulation.setDeviceMetricsOverride',DESKTOP_EMULATION_METRICS),driver.sendCommand('Network.enable'),driver.sendCommand('Network.setUserAgentOverride',DESKTOP_USERAGENT),driver.sendCommand('Emulation.setTouchEmulationEnabled',{enabled:false})]);}
function enableNetworkThrottling(driver,throttlingSettings){const conditions={offline:false,latency:throttlingSettings.requestLatencyMs||0,downloadThroughput:throttlingSettings.downloadThroughputKbps||0,uploadThroughput:throttlingSettings.uploadThroughputKbps||0};conditions.downloadThroughput=Math.floor(conditions.downloadThroughput*1024/8);conditions.uploadThroughput=Math.floor(conditions.uploadThroughput*1024/8);return driver.sendCommand('Network.emulateNetworkConditions',conditions);}
function clearAllNetworkEmulation(driver){return driver.sendCommand('Network.emulateNetworkConditions',NO_THROTTLING_METRICS);}
function goOffline(driver){return driver.sendCommand('Network.emulateNetworkConditions',OFFLINE_METRICS);}
function enableCPUThrottling(driver,throttlingSettings){const rate=throttlingSettings.cpuSlowdownMultiplier;return driver.sendCommand('Emulation.setCPUThrottlingRate',{rate});}
function disableCPUThrottling(driver){return driver.sendCommand('Emulation.setCPUThrottlingRate',NO_CPU_THROTTLE_METRICS);}
module.exports={enableNexus5X,enableDesktop,enableNetworkThrottling,clearAllNetworkEmulation,enableCPUThrottling,disableCPUThrottling,goOffline};},{}],35:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Chrome extensions negatively affected this page's load performance. Try auditing the page in incognito mode or from a Chrome profile without extensions.","description":"A message displayed in a Lighthouse audit result warning that Chrome extensions on the user's system substantially affected Lighthouse's measurements and instructs the user on how to run again without those extensions."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Script Evaluation","description":"Label for a time column in a data table; entries will be the number of milliseconds spent evaluating script for every script loaded by the page."},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Script Parse","description":"Label for a time column in a data table; entries will be the number of milliseconds spent parsing script files for every script loaded by the page."},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Total","description":"Label for the total time column in a data table; entries will be the number of milliseconds spent executing per resource loaded by the page."},"lighthouse-core/audits/bootup-time.js | description":{"message":"Consider reducing the time spent parsing, compiling, and executing JS. You may find delivering smaller JS payloads helps with this. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/bootup).","description":"Description of a Lighthouse audit that tells the user that they should reduce the amount of time spent executing javascript and one method of doing so. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Reduce JavaScript execution time","description":"Title of a diagnostic audit that provides detail on the time spent executing javascript files during the load. This imperative title is shown to users when there is a significant amount of execution time that could be reduced."},"lighthouse-core/audits/bootup-time.js | title":{"message":"JavaScript execution time","description":"Title of a diagnostic audit that provides detail on the time spent executing javascript files during the load. This descriptive title is shown to users when the amount is acceptable and no user action is required."},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Large GIFs are inefficient for delivering animated content. Consider using MPEG4/WebM videos for animations and PNG/WebP for static images instead of GIF to save network bytes. [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)","description":"Description of a Lighthouse audit that tells the user *why* they should use video instead of GIF format for delivering animated content. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Use video formats for animated content","description":"Imperative title of a Lighthouse audit that tells the user to use video formats rather than animated GIFs, which are wasteful. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Consider lazy-loading offscreen and hidden images after all critical resources have finished loading to lower time to interactive. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images).","description":"Description of a Lighthouse audit that tells the user *why* they should defer loading offscreen images. Offscreen images are images located outside of the visible browser viewport. As they are unseen by the user and slow down page load, they should be loaded later, closer to when the user is going to see them. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Defer offscreen images","description":"Imperative title of a Lighthouse audit that tells the user to defer loading offscreen images. Offscreen images are images located outside of the visible browser viewport. As they are unseen by the user and slow down page load, they should be loaded later, closer to when the user is going to see them. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Resources are blocking the first paint of your page. Consider delivering critical JS/CSS inline and deferring all non-critical JS/styles. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).","description":"Description of a Lighthouse audit that tells the user *why* they should reduce or remove network resources that block the initial render of the page. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Eliminate render-blocking resources","description":"Imperative title of a Lighthouse audit that tells the user to reduce or remove network resources that block the initial render of the page. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Large network payloads cost users real money and are highly correlated with long load times. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/network-payloads).","description":"Description of a Lighthouse audit that tells the user *why* they should reduce the size of the network resources required by the page. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Total size was {totalBytes, number, bytes} KB","description":"Used to summarize the total byte size of the page and all its network requests. The `{totalBytes}` placeholder will be replaced with the total byte sizes, shown in kilobytes (e.g. 142 KB)"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Avoid enormous network payloads","description":"Title of a diagnostic audit that provides detail on large network resources required during page load. 'Payloads' is roughly equivalent to 'resources'. This imperative title is shown to users when there is a significant amount of execution time that could be reduced."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Avoids enormous network payloads","description":"Title of a diagnostic audit that provides detail on large network resources required during page load. 'Payloads' is roughly equivalent to 'resources'. This descriptive title is shown to users when the amount is acceptable and no user action is required."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Minifying CSS files can reduce network payload sizes. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/minify-css).","description":"Description of a Lighthouse audit that tells the user *why* they should minify (remove whitespace) the page's CSS code. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"Minify CSS","description":"Imperative title of a Lighthouse audit that tells the user to minify (remove whitespace) the page's CSS code. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Minifying JavaScript files can reduce payload sizes and script parse time. [Learn more](https://developers.google.com/speed/docs/insights/MinifyResources).","description":"Description of a Lighthouse audit that tells the user *why* they should minify the page’s JS code to reduce file size. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"Minify JavaScript","description":"Imperative title of a Lighthouse audit that tells the user to minify the page’s JS code to reduce file size. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Remove unused rules from stylesheets to reduce unnecessary bytes consumed by network activity. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/unused-css).","description":"Description of a Lighthouse audit that tells the user *why* they should defer loading any content in CSS that isn’t needed at page load. This is displayed after a user expands the section to see more. No word length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Defer unused CSS","description":"Imperative title of a Lighthouse audit that tells the user to remove content from their CSS that isn’t needed immediately and instead load that content at a later time. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Remove unused JavaScript to reduce bytes consumed by network activity.","description":"Description of a Lighthouse audit that tells the user *why* they should remove JavaScript that is never needed/evaluated by the browser. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Remove unused JavaScript","description":"Imperative title of a Lighthouse audit that tells the user to remove JavaScript that is never evaluated during page load. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"A long cache lifetime can speed up repeat visits to your page. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/cache-policy).","description":"Description of a Lighthouse audit that tells the user *why* they need to adopt a long cache lifetime policy. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount, plural,\n    =1 {1 resource found}\n    other {# resources found}\n    }","description":"[ICU Syntax] Label for the audit identifying network resources with inefficient cache values. Clicking this will expand the audit to show the resources."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Serve static assets with an efficient cache policy","description":"Title of a diagnostic audit that provides details on the any page resources that could have been served with more efficient cache policies. Cache refers to browser disk cache, which keeps old versions of network resources around for future use. This imperative title is shown to users when there is a significant amount of assets served with poor cache policies."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Uses efficient cache policy on static assets","description":"Title of a diagnostic audit that provides detail on the cache policy applies to the page's static assets. Cache refers to browser disk cache, which keeps old versions of network resources around for future use. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Optimized images load faster and consume less cellular data. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/optimize-images).","description":"Description of a Lighthouse audit that tells the user *why* they need to efficiently encode images. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Efficiently encode images","description":"Imperative title of a Lighthouse audit that tells the user to encode images with optimization (better compression). This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Serve images that are appropriately-sized to save cellular data and improve load time. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/oversized-images).","description":"Description of a Lighthouse audit that tells the user *why* they need to serve appropriately sized images. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Properly size images","description":"Imperative title of a Lighthouse audit that tells the user to resize images to match the display dimensions. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"Text-based resources should be served with compression (gzip, deflate or brotli) to minimize total network bytes. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/text-compression).","description":"Description of a Lighthouse audit that tells the user *why* their text-based resources should be served with compression (like gzip). This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Enable text compression","description":"Imperative title of a Lighthouse audit that tells the user to enable text compression (like gzip) in order to enhance the performance of a page. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Image formats like JPEG 2000, JPEG XR, and WebP often provide better compression than PNG or JPEG, which means faster downloads and less data consumption. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/webp).","description":"Description of a Lighthouse audit that tells the user *why* they should use newer and more efficient image formats. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Serve images in next-gen formats","description":"Imperative title of a Lighthouse audit that tells the user to serve images in newer and more efficient image formats in order to enhance the performance of a page. A non-modern image format was designed 20+ years ago. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"The Critical Request Chains below show you what resources are loaded with a high priority. Consider reducing the length of chains, reducing the download size of resources, or deferring the download of unnecessary resources to improve page load. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains).","description":"Description of a Lighthouse audit that tells the user *why* they should reduce the depth of critical network requests to enhance initial load of a page . This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount, plural,\n    =1 {1 chain found}\n    other {# chains found}\n    }","description":"[ICU Syntax] Label for an audit identifying the number of sequences of dependent network requests used to load the page."},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Minimize Critical Requests Depth","description":"Imperative title of a Lighthouse audit that tells the user to reduce the depth of critical network requests to enhance initial load of a page. Critical request chains are series of dependent network requests that are important for page rendering. For example, here's a 4-request-deep chain: The biglogo.jpg image is required, but is requested via the styles.css style code, which is requested by the initialize.js javascript, which is requested by the page's HTML. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element","description":"Table column header for the DOM element. Each DOM element is described with its HTML representation."},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic","description":"Table column header for the type of statistic. These statistics describe how big the DOM is (count of DOM nodes, children, depth)."},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value","description":"Table column header for the observed value of the DOM statistic."},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Browser engineers recommend pages contain fewer than ~1,500 DOM nodes. The sweet spot is a tree depth < 32 elements and fewer than 60 children/parent element. A large DOM can increase memory usage, cause longer [style calculations](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations), and produce costly [layout reflows](https://developers.google.com/speed/articles/reflow). [Learn more](https://developers.google.com/web/tools/lighthouse/audits/dom-size).","description":"Description of a Lighthouse audit that tells the user *why* they should reduce the size of the web page's DOM. The size of a DOM is characterized by the total number of DOM nodes and greatest DOM depth. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount, plural,\n    =1 {1 node}\n    other {# nodes}\n    }","description":"[ICU Syntax] Label for an audit identifying the number of DOM nodes found in the page."},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Avoid an excessive DOM size","description":"Title of a diagnostic audit that provides detail on the size of the web page's DOM. The size of a DOM is characterized by the total number of DOM nodes and greatest DOM depth. This imperative title is shown to users when there is a significant amount of execution time that could be reduced."},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Maximum DOM Depth","description":"Label for the numeric value of the maximum depth in the page's DOM tree."},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Total DOM Nodes","description":"Label for the total number of DOM nodes found in the page."},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements","description":"Label for the numeric value of the maximum number of children any DOM element in the page has. The element described will have the most children in the page."},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Avoids an excessive DOM size","description":"Title of a diagnostic audit that provides detail on the size of the web page's DOM. The size of a DOM is characterized by the total number of DOM nodes and greatest DOM depth. This descriptive title is shown to users when the amount is acceptable and no user action is required."},"lighthouse-core/audits/font-display.js | description":{"message":"Leverage the font-display CSS feature to ensure text is user-visible while webfonts are loading. [Learn more](https://developers.google.com/web/updates/2016/02/font-display).","description":"Description of a Lighthouse audit that tells the user *why* they should use the font-display CSS feature. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Ensure text remains visible during webfont load","description":"Title of a diagnostic audit that provides detail on the load of the page's webfonts. Often the text is invisible for seconds before the webfont resource is loaded. This imperative title is shown to users when there is a significant amount of execution time that could be reduced."},"lighthouse-core/audits/font-display.js | title":{"message":"All text remains visible during webfont loads","description":"Title of a diagnostic audit that provides detail on if all the text on a webpage was visible while the page was loading its webfonts. This descriptive title is shown to users when the amount is acceptable and no user action is required."},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Category","description":"Label for the Main Thread Category column in data tables, rows will have a main thread Category and main thread Task Name."},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Consider reducing the time spent parsing, compiling and executing JS. You may find delivering smaller JS payloads helps with this.","description":"Description of a Lighthouse audit that tells the user *why* they should reduce JS execution times. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Minimize main-thread work","description":"Title of a diagnostic audit that provides detail on the main thread work the browser did to load the page. This imperative title is shown to users when there is a significant amount of execution time that could be reduced."},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Minimizes main-thread work","description":"Title of a diagnostic audit that provides detail on the main thread work the browser did to load the page. This descriptive title is shown to users when the amount is acceptable and no user action is required."},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"The score above is an estimate of how long your app takes to respond to user input, in milliseconds, during the busiest 5s window of page load. If your latency is higher than 50 ms, users may perceive your app as laggy. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency).","description":"Description of the Estimated Input Latency metric that estimates the amount of time, in milliseconds, that the app takes to respond to user input. This description is displayed within a tooltip when the user hovers on the metric name to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Estimated Input Latency","description":"The name of the metric that marks the estimated time between the page receiving input (a user clicking, tapping, or typing) and the page responding. Shown to users as the label for the numeric metric value. Ideally fits within a ~40 character limit."},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"First Contentful Paint marks the time at which the first text or image is painted. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint).","description":"Description of the First Contentful Paint (FCP) metric, which marks the time at which the first text or image is painted by the browser. This is displayed within a tooltip when the user hovers on the metric name to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"First Contentful Paint","description":"The name of the metric that marks the time at which the first text or image is painted by the browser. Shown to users as the label for the numeric metric value. Ideally fits within a ~40 character limit."},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"First CPU Idle marks the first time at which the page's main thread is quiet enough to handle input. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-interactive).","description":"Description of the First CPU Idle metric, which marks the time at which the page has displayed content and the CPU is not busy executing the page's scripts. This is displayed within a tooltip when the user hovers on the metric name to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"First CPU Idle","description":"The name of the metric that marks when the page has displayed content and the CPU is not busy executing the page's scripts. Shown to users as the label for the numeric metric value. Ideally fits within a ~40 character limit."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"First Meaningful Paint measures when the primary content of a page is visible. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint).","description":"Description of the First Meaningful Paint (FMP) metric, which marks the time at which a majority of the content has been painted by the browser. This is displayed within a tooltip when the user hovers on the metric name to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"First Meaningful Paint","description":"The name of the metric that marks the time at which a majority of the content has been painted by the browser. Shown to users as the label for the numeric metric value. Ideally fits within a ~40 character limit."},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"Interactive marks the time at which the page is fully interactive. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive).","description":"Description of the Time to Interactive (TTI) metric, which evaluates when a page has completed its primary network activity and main thread work. This is displayed within a tooltip when the user hovers on the metric name to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Time to Interactive","description":"The name of the metric that marks the time at which the page is fully loaded and is able to quickly respond to user input (clicks, taps, and keypresses feel responsive). Shown to users as the label for the numeric metric value. Ideally fits within a ~40 character limit."},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"Speed Index shows how quickly the contents of a page are visibly populated. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/speed-index).","description":"Description of the Speed Index metric, which summarizes how quickly the page looked visually complete. This is displayed within a tooltip when the user hovers on the metric name to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Speed Index","description":"The name of the metric that summarizes how quickly the page looked visually complete. The name of this metric is largely abstract and can be loosely translated. Shown to users as the label for the numeric metric value. Ideally fits within a ~40 character limit."},"lighthouse-core/audits/redirects.js | description":{"message":"Redirects introduce additional delays before the page can be loaded. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/redirects).","description":"Description of a Lighthouse audit that tells users why they should reduce the number of server-side redirects on their page. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/redirects.js | title":{"message":"Avoid multiple page redirects","description":"Imperative title of a Lighthouse audit that tells the user to eliminate the redirects taken through multiple URLs to load the page. This is shown in a list of audits that Lighthouse generates."},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"Time To First Byte identifies the time at which your server sends a response. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/ttfb).","description":"Description of a Lighthouse audit that tells the user *why* they should reduce the amount of time it takes their server to start responding to requests. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"Root document took {timeInMs, number, milliseconds} ms","description":"Used to summarize the total Time to First Byte duration for the primary HTML response. The `{timeInMs}` placeholder will be replaced with the time duration, shown in milliseconds (e.g. 210 ms)"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Reduce server response times (TTFB)","description":"Title of a diagnostic audit that provides detail on how long it took from starting a request to when the server started responding. This imperative title is shown to users when there is a significant amount of execution time that could be reduced."},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Server response times are low (TTFB)","description":"Title of a diagnostic audit that provides detail on how long it took from starting a request to when the server started responding. This descriptive title is shown to users when the amount is acceptable and no user action is required."},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Duration","description":"Label for the Duration column in the User Timing event data table. User Timing API entries are added by the developer of the web page. Durations are only provided for 'Measure' entries. Durations are the number of total number milliseconds from Start Time to their ending point. e.g. '2,020.64 ms'"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Name","description":"Label for the Name column in the User Timing event data table. User Timing API entries are added by the developer of the web page. An example user timing event name: 'pageload_logoimage_done'"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Start Time","description":"Label for the Start Time column in the User Timing event data table. User Timing API entries are added by the developer of the web page. Start Times are the number of milliseconds since the page started loading, e.g. '380.26 ms'"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Type","description":"Label for the Type column in the User Timing event data table. User Timing API entries are added by the developer of the web page. The only possible types are 'Mark' and Measure'."},"lighthouse-core/audits/user-timings.js | description":{"message":"Consider instrumenting your app with the User Timing API to measure your app's real-world performance during key user experiences. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/user-timing).","description":"Description of a Lighthouse audit that tells the user they may want to use the User Timing API to help measure the performance of aspects of their page load and interaction. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount, plural,\n    =1 {1 user timing}\n    other {# user timings}\n    }","description":"[ICU Syntax] Label for an audit identifying the number of User Timing timestamps present in the page."},"lighthouse-core/audits/user-timings.js | title":{"message":"User Timing marks and measures","description":"Descriptive title of a diagnostic audit that provides details on any timestamps generated by the page. User Timing refers to the 'User Timing API', which enables a website to record specific times as 'marks', or spans of time as 'measures'."},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Consider adding preconnect or dns-prefetch resource hints to establish early connections to important third-party origins. [Learn more](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect).","description":"Description of a Lighthouse audit that tells the user how to connect early to third-party domains that will be used to load page resources. This is displayed after a user expands the section to see more. No character length limits. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"Preconnect to required origins","description":"Imperative title of a Lighthouse audit that tells the user to connect early to internet domains that will be used to load page resources. Origin is the correct term, however 'domain name' could be used if neccsesary. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Consider using <link rel=preload> to prioritize fetching resources that are currently requested later in page load. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/preload).","description":"Description of a Lighthouse audit that tells the user *why* they should preload important network requests. The associated network requests are started halfway through pageload (or later) but should be started at the beginning. This is displayed after a user expands the section to see more. No character length limits. '<link rel=preload>' is the html code the user would include in their page and shouldn't be translated. 'Learn More' becomes link text to additional documentation."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Preload key requests","description":"Imperative title of a Lighthouse audit that tells the user to use <link rel=preload> to initiate important network requests earlier during page load. This is displayed in a list of audit titles that Lighthouse generates."},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"More information about the performance of your application.","description":"Description of the diagnostics section of the Performance category. Within this section are audits with non-imperative titles that provide more detail on the page's page load performance characteristics. Whereas the 'Opportunities' suggest an action along with expected time savings, diagnostics do not. Within this section, the user may read the details and deduce additional actions they could take."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Diagnostics","description":"Title of the diagnostics section of the Performance category. Within this section are audits with non-imperative titles that provide more detail on the page's page load performance characteristics. Whereas the 'Opportunities' suggest an action along with expected time savings, diagnostics do not. Within this section, the user may read the details and deduce additional actions they could take."},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint","description":"Description of an opportunity sub-section of the Performance category. Within this section are audits with imperative titles that suggest actions the user can take to improve the time of the first initial render of the webpage."},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"First Paint Improvements","description":"Title of an opportunity sub-section of the Performance category. Within this section are audits with imperative titles that suggest actions the user can take to improve the time of the first initial render of the webpage."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"These optimizations can speed up your page load.","description":"Description of the opportunity section of the Performance category. 'Optimizations' could also be 'recommendations' or 'suggestions'. Within this section are audits with imperative titles that suggest actions the user can take to improve the loading performance of their web page."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Opportunities","description":"Title of the opportunity section of the Performance category. Within this section are audits with imperative titles that suggest actions the user can take to improve the loading performance of their web page. 'Suggestion'/'Optimization'/'Recommendation' are reasonable synonyms for 'opportunity' in this case."},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Metrics","description":"Title of the speed metrics section of the Performance category. Within this section are various speed metrics which quantify the pageload performance into values presented in seconds and milliseconds."},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index","description":"Description of an opportunity sub-section of the Performance category. Within this section are audits with imperative titles that suggest actions the user can take to improve the overall loading performance of their web page."},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Overall Improvements","description":"Title of an opportunity sub-section of the Performance category. Within this section are audits with imperative titles that suggest actions the user can take to improve the overall loading performance of their web page."},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Performance","description":"Title of the Performance category of audits. Equivalent to 'Web performance', this term is inclusive of all web page speed and loading optimization topics. Also used as a label of a score gauge; try to limit to 20 characters."},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"Cache TTL","description":"Label for the TTL column in data tables, entries will be the time to live value of the cache header on a web resource"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Size (KB)","description":"Label for the size column in data tables, entries will be the size of a web resource in kilobytes"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Time Spent","description":"Label for the time spent column in data tables, entries will be the number of milliseconds spent during a particular activity"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"URL","description":"Label for the URL column in data tables, entries will be the URL of a web resource"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Potential Savings (KB)","description":"Label for the wasted bytes column in data tables, entries will be the number of kilobytes the user could reduce their page by if they implemented the suggestions"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Potential Savings (ms)","description":"Label for the wasted bytes column in data tables, entries will be the number of milliseconds the user could reduce page load by if they implemented the suggestions"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Potential savings of {wastedBytes, number, bytes} KB","description":"Label shown per-audit to show how many bytes smaller the page could be if the user implemented the suggestions. The `{wastedBytes}` placeholder will be replaced with the number of bytes, shown in kilobytes (e.g. 148 KB)"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Potential savings of {wastedMs, number, milliseconds} ms","description":"Label shown per-audit to show how many milliseconds faster the page load could be if the user implemented the suggestions. The `{wastedMs}` placeholder will be replaced with the time duration, shown in milliseconds (e.g. 140 ms)"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} ms","description":"Used to show the duration in milliseconds that something lasted. The `{timeInMs}` placeholder will be replaced with the time duration, shown in milliseconds (e.g. 63 ms)"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} s","description":"Used to show the duration in seconds that something lasted. The {timeInMs} placeholder will be replaced with the time duration, shown in seconds (e.g. 5.2 s)"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Show audits","description":"The tooltip text on an expandable chevron icon. Clicking the icon expands a section to reveal a list of audit results that was hidden by default."},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Initial Navigation","description":"String of text shown in a graphical representation of the flow of network requests for the web page. This label represents the initial network request that fetches an HTML page. This navigation may be redirected (eg. Initial navigation to http://example.com redirects to https://www.example.com)."},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Maximum critical path latency:","description":"Label of value shown in the summary of critical request chains. Refers to the total amount of time (milliseconds) of the longest critical path chain/sequence of network requests. Example value: 2310 ms"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Error!","description":"A label, shown next to an audit title or metric title, indicating that there was an error computing it. The user can hover on the label to reveal a tooltip with the extended error message. Translation should be short (< 20 characters)."},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Report error: no audit information","description":"An error string displayed next to a particular audit when it has errored, but not provided any specific error message."},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Lab Data","description":"Title of the lab data section of the Performance category. Within this section are various speed metrics which quantify the pageload performance into values presented in seconds and milliseconds. \"Lab\" is an abbreviated form of \"laboratory\", and refers to the fact that the data is from a controlled test of a website, not measurements from real users visiting that site."},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[Lighthouse](https://developers.google.com/web/tools/lighthouse/) analysis of the current page on emulated 3G. Values are estimated and may vary.","description":"Explanation shown to users below performance results to inform them that the test was done with a 3G network connection and to warn them that the numbers they see will likely change slightly the next time they run Lighthouse. 'Lighthouse' becomes link text to additional documentation."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Additional items to manually check","description":"Section heading shown above a list of audits that were not computed by Lighthouse. They serve as a list of suggestions for the user to go and manually check. For example, Lighthouse can't automate testing cross-browser compatibility, so that is listed within this section, so the user is reminded to test it themselves. This section is collapsed by default, as the user should be focusing on the failed audits instead. Users can click this heading to reveal the list."},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"Not applicable","description":"Section heading shown above a list of audits that do not apply to the page. For example, if an audit is 'Are images optimized?', but the page has no images on it, the audit will be marked as not applicable. This is neither passing or failing. This section is collapsed by default, as the user should be focusing on the failed audits instead. Users can click this heading to reveal the list."},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Opportunity","description":"Column heading label for the listing of opportunity audits. Each audit title represents an opportunity. There are only 2 columns, so no strict character limit."},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Estimated Savings","description":"Column heading label for the estimated page load savings of opportunity audits. Estimated Savings is the total amount of time (in seconds) that Lighthouse computed could be reduced from the total page load time, if the suggested action is taken. There are only 2 columns, so no strict character limit."},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Passed audits","description":"Section heading shown above a list of audits that are passing. 'Passed' here refers to a passing grade. This section is collapsed by default, as the user should be focusing on the failed audits instead. Users can click this heading to reveal the list."},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Score scale:","description":"Label preceding a pictorial explanation of the scoring scale: 0-50 is red (bad), 50-90 is orange (ok), 90-100 is green (good). These colors are used throughout the report to provide context for how good/bad a particular result is."},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"There were issues affecting this run of Lighthouse:","description":"Label shown preceding any important warnings that may have invalidated the entire report. For example, if the user has Chrome extensions installed, they may add enough performance overhead that Lighthouse's performance metrics are unreliable. If shown, this will be displayed at the top of the report UI."},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Values are estimated and may vary.","description":"Disclaimer shown to users below the metric values (First Contentful Paint, Time to Interactive, etc) to warn them that the numbers they see will likely change slightly the next time they run Lighthouse."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Warnings: ","description":"This label is shown above a bulleted list of warnings. It is shown directly below an audit that produced warnings. Warnings describe situations the user should be aware of, as Lighthouse was unable to complete all the work required on this audit. For example, The 'Unable to decode image (biglogo.jpg)' warning may show up below an image encoding audit."}};},{}],36:[function(require,module,exports){(function(__filename,__dirname){'use strict';const path=require('path');const isDeepEqual=require('lodash.isequal');const log=require('lighthouse-logger');const MessageFormat=require('intl-messageformat').default;const MessageParser=require('intl-messageformat-parser');const lookupClosestLocale=require('lookup-closest-locale');const LOCALES=require('./locales.js');const LH_ROOT=path.join(__dirname,'../../../');const MESSAGE_INSTANCE_ID_REGEX=/(.* \| .*) # (\d+)$/;const MESSAGE_INSTANCE_ID_QUICK_REGEX=/ # \d+$/;(()=>{try{const IntlPolyfill=require('intl');if(!IntlPolyfill.NumberFormat)return;Intl.NumberFormat=IntlPolyfill.NumberFormat;Intl.DateTimeFormat=IntlPolyfill.DateTimeFormat;}catch(_){log.warn('i18n','Failed to install `intl` polyfill');}})();const UIStrings={ms:'{timeInMs, number, milliseconds}\xa0ms',seconds:'{timeInMs, number, seconds}\xa0s',displayValueByteSavings:'Potential savings of {wastedBytes, number, bytes}\xa0KB',displayValueMsSavings:'Potential savings of {wastedMs, number, milliseconds}\xa0ms',columnURL:'URL',columnSize:'Size (KB)',columnCacheTTL:'Cache TTL',columnWastedBytes:'Potential Savings (KB)',columnWastedMs:'Potential Savings (ms)',columnTimeSpent:'Time Spent'};const formats={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1}}};function lookupLocale(locale){const canonicalLocale=Intl.getCanonicalLocales(locale)[0];const closestLocale=lookupClosestLocale(canonicalLocale,LOCALES);return closestLocale||'en';}
function _preprocessMessageValues(icuMessage,values){if(!values)return;const clonedValues=JSON.parse(JSON.stringify(values));const parsed=MessageParser.parse(icuMessage);parsed.elements.filter(el=>el.type==='argumentElement').forEach(el=>{if(el.id&&el.id in values===false){throw new Error('ICU Message contains a value reference that wasn\'t provided');}});parsed.elements.filter(el=>el.format&&el.format.style==='milliseconds').forEach(el=>clonedValues[el.id]=Math.round(clonedValues[el.id]/10)*10);parsed.elements.filter(el=>el.format&&el.format.style==='seconds'&&el.id==='timeInMs').forEach(el=>clonedValues[el.id]=Math.round(clonedValues[el.id]/100)/10);parsed.elements.filter(el=>el.format&&el.format.style==='bytes').forEach(el=>clonedValues[el.id]=clonedValues[el.id]/1024);return clonedValues;}
const _icuMessageInstanceMap=new Map();function _formatIcuMessage(locale,icuMessageId,icuMessage,values){const localeMessages=LOCALES[locale];const localeMessage=localeMessages[icuMessageId]&&localeMessages[icuMessageId].message;const messageForMessageFormat=localeMessage||icuMessage;const localeForMessageFormat=locale==='en-XA'?'de-DE':locale;const valuesForMessageFormat=_preprocessMessageValues(icuMessage,values);const formatter=new MessageFormat(messageForMessageFormat,localeForMessageFormat,formats);const formattedString=formatter.format(valuesForMessageFormat);return{formattedString,icuMessage:messageForMessageFormat};}
function _formatPathAsString(pathInLHR){let pathAsString='';for(const property of pathInLHR){if(/^[a-z]+$/i.test(property)){if(pathAsString.length)pathAsString+='.';pathAsString+=property;}else{if(/]|"|'|\s/.test(property))throw new Error(`Cannot handle "${property}" in i18n`);pathAsString+=`[${property}]`;}}
return pathAsString;}
function getRendererFormattedStrings(locale){const icuMessageIds=Object.keys(LOCALES[locale]).filter(f=>f.includes('core/report/html/'));const strings={};for(const icuMessageId of icuMessageIds){const[filename,varName]=icuMessageId.split(' | ');if(!filename.endsWith('util.js'))throw new Error(`Unexpected message: ${icuMessageId}`);strings[varName]=LOCALES[locale][icuMessageId].message;}
return strings;}
function createMessageInstanceIdFn(filename,fileStrings){const mergedStrings={...UIStrings,...fileStrings};const getMessageInstanceIdFn=(icuMessage,values)=>{const keyname=Object.keys(mergedStrings).find(key=>mergedStrings[key]===icuMessage);if(!keyname)throw new Error(`Could not locate: ${icuMessage}`);const filenameToLookup=keyname in fileStrings?filename:__filename;const unixStyleFilename=path.relative(LH_ROOT,filenameToLookup).replace(/\\/g,'/');const icuMessageId=`${unixStyleFilename} | ${keyname}`;const icuMessageInstances=_icuMessageInstanceMap.get(icuMessageId)||[];let indexOfInstance=icuMessageInstances.findIndex(inst=>isDeepEqual(inst.values,values));if(indexOfInstance===-1){icuMessageInstances.push({icuMessageId,icuMessage,values});indexOfInstance=icuMessageInstances.length-1;}
_icuMessageInstanceMap.set(icuMessageId,icuMessageInstances);return`${icuMessageId} # ${indexOfInstance}`;};return getMessageInstanceIdFn;}
function isIcuMessage(icuMessageIdOrRawString){return MESSAGE_INSTANCE_ID_QUICK_REGEX.test(icuMessageIdOrRawString)&&MESSAGE_INSTANCE_ID_REGEX.test(icuMessageIdOrRawString);}
function getFormatted(icuMessageIdOrRawString,locale){if(isIcuMessage(icuMessageIdOrRawString)){return _resolveIcuMessageInstanceId(icuMessageIdOrRawString,locale).formattedString;}
return icuMessageIdOrRawString;}
function _resolveIcuMessageInstanceId(icuMessageInstanceId,locale){const matches=icuMessageInstanceId.match(MESSAGE_INSTANCE_ID_REGEX);if(!matches)throw new Error(`${icuMessageInstanceId} is not a valid message instance ID`);const[_,icuMessageId,icuMessageInstanceIndex]=matches;const icuMessageInstances=_icuMessageInstanceMap.get(icuMessageId)||[];const icuMessageInstance=icuMessageInstances[Number(icuMessageInstanceIndex)];const{formattedString}=_formatIcuMessage(locale,icuMessageId,icuMessageInstance.icuMessage,icuMessageInstance.values);return{icuMessageInstance,formattedString};}
function replaceIcuMessageInstanceIds(inputObject,locale){function replaceInObject(subObject,icuMessagePaths,pathInLHR=[]){if(typeof subObject!=='object'||!subObject)return;for(const[property,value]of Object.entries(subObject)){const currentPathInLHR=pathInLHR.concat([property]);if(typeof value==='string'&&isIcuMessage(value)){const{icuMessageInstance,formattedString}=_resolveIcuMessageInstanceId(value,locale);const messageInstancesInLHR=icuMessagePaths[icuMessageInstance.icuMessageId]||[];const currentPathAsString=_formatPathAsString(currentPathInLHR);messageInstancesInLHR.push(icuMessageInstance.values?{values:icuMessageInstance.values,path:currentPathAsString}:currentPathAsString);subObject[property]=formattedString;icuMessagePaths[icuMessageInstance.icuMessageId]=messageInstancesInLHR;}else{replaceInObject(value,icuMessagePaths,currentPathInLHR);}}}
const icuMessagePaths={};replaceInObject(inputObject,icuMessagePaths);return icuMessagePaths;}
module.exports={_formatPathAsString,UIStrings,lookupLocale,getRendererFormattedStrings,createMessageInstanceIdFn,getFormatted,replaceIcuMessageInstanceIds,isIcuMessage};}).call(this,"/../lighthouse-core/lib/i18n/i18n.js","/../lighthouse-core/lib/i18n");},{"./locales.js":37,"intl":107,"intl-messageformat":168,"intl-messageformat-parser":166,"lighthouse-logger":147,"lodash.isequal":178,"lookup-closest-locale":179,"path":124}],37:[function(require,module,exports){'use strict';const locales={'en-US':require('./en-US.json'),'en':require('./en-US.json'),'en-AU':require('./locales/en-GB.json'),'en-GB':require('./locales/en-GB.json'),'en-IE':require('./locales/en-GB.json'),'en-SG':require('./locales/en-GB.json'),'en-ZA':require('./locales/en-GB.json'),'en-IN':require('./locales/en-GB.json'),'ar-XB':require('./locales/ar-XB.json'),'ar':require('./locales/ar.json'),'bg':require('./locales/bg.json'),'bs':require('./locales/hr.json'),'ca':require('./locales/ca.json'),'cs':require('./locales/cs.json'),'da':require('./locales/da.json'),'de':require('./locales/de.json'),'el':require('./locales/el.json'),'en-XA':require('./locales/en-XA.json'),'es':require('./locales/es.json'),'fi':require('./locales/fi.json'),'fil':require('./locales/fil.json'),'fr':require('./locales/fr.json'),'he':require('./locales/he.json'),'hi':require('./locales/hi.json'),'hr':require('./locales/hr.json'),'hu':require('./locales/hu.json'),'gsw':require('./locales/de.json'),'id':require('./locales/id.json'),'in':require('./locales/id.json'),'it':require('./locales/it.json'),'iw':require('./locales/he.json'),'ja':require('./locales/ja.json'),'ko':require('./locales/ko.json'),'ln':require('./locales/fr.json'),'lt':require('./locales/lt.json'),'lv':require('./locales/lv.json'),'mo':require('./locales/ro.json'),'nl':require('./locales/nl.json'),'nb':require('./locales/no.json'),'no':require('./locales/no.json'),'pl':require('./locales/pl.json'),'pt':require('./locales/pt.json'),'pt-PT':require('./locales/pt-PT.json'),'ro':require('./locales/ro.json'),'ru':require('./locales/ru.json'),'sk':require('./locales/sk.json'),'sl':require('./locales/sl.json'),'sr':require('./locales/sr.json'),'sr-Latn':require('./locales/sr-Latn.json'),'sv':require('./locales/sv.json'),'ta':require('./locales/ta.json'),'te':require('./locales/te.json'),'th':require('./locales/th.json'),'tl':require('./locales/fil.json'),'tr':require('./locales/tr.json'),'uk':require('./locales/uk.json'),'vi':require('./locales/vi.json'),'zh':require('./locales/zh.json'),'zh-HK':require('./locales/zh-HK.json'),'zh-TW':require('./locales/zh-TW.json')};module.exports=locales;},{"./en-US.json":35,"./locales/ar-XB.json":38,"./locales/ar.json":39,"./locales/bg.json":40,"./locales/ca.json":41,"./locales/cs.json":42,"./locales/da.json":43,"./locales/de.json":44,"./locales/el.json":45,"./locales/en-GB.json":46,"./locales/en-XA.json":47,"./locales/es.json":48,"./locales/fi.json":49,"./locales/fil.json":50,"./locales/fr.json":51,"./locales/he.json":52,"./locales/hi.json":53,"./locales/hr.json":54,"./locales/hu.json":55,"./locales/id.json":56,"./locales/it.json":57,"./locales/ja.json":58,"./locales/ko.json":59,"./locales/lt.json":60,"./locales/lv.json":61,"./locales/nl.json":62,"./locales/no.json":63,"./locales/pl.json":64,"./locales/pt-PT.json":65,"./locales/pt.json":66,"./locales/ro.json":67,"./locales/ru.json":68,"./locales/sk.json":69,"./locales/sl.json":70,"./locales/sr-Latn.json":71,"./locales/sr.json":72,"./locales/sv.json":73,"./locales/ta.json":74,"./locales/te.json":75,"./locales/th.json":76,"./locales/tr.json":77,"./locales/uk.json":78,"./locales/vi.json":79,"./locales/zh-HK.json":80,"./locales/zh-TW.json":81,"./locales/zh.json":82}],38:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"‏‮Chrome‬‏ ‏‮extensions‬‏ ‏‮negatively‬‏ ‏‮affected‬‏ ‏‮this‬‏ ‏‮page‬‏'‏‮s‬‏ ‏‮load‬‏ ‏‮performance‬‏. ‏‮Try‬‏ ‏‮auditing‬‏ ‏‮the‬‏ ‏‮page‬‏ ‏‮in‬‏ ‏‮incognito‬‏ ‏‮mode‬‏ ‏‮or‬‏ ‏‮from‬‏ ‏‮a‬‏ ‏‮Chrome‬‏ ‏‮profile‬‏ ‏‮without‬‏ ‏‮extensions‬‏."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"‏‮Script‬‏ ‏‮Evaluation‬‏"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"‏‮Script‬‏ ‏‮Parse‬‏"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"‏‮Total‬‏"},"lighthouse-core/audits/bootup-time.js | description":{"message":"‏‮Consider‬‏ ‏‮reducing‬‏ ‏‮the‬‏ ‏‮time‬‏ ‏‮spent‬‏ ‏‮parsing‬‏, ‏‮compiling‬‏, ‏‮and‬‏ ‏‮executing‬‏ ‏‮JS‬‏. ‏‮You‬‏ ‏‮may‬‏ ‏‮find‬‏ ‏‮delivering‬‏ ‏‮smaller‬‏ ‏‮JS‬‏ ‏‮payloads‬‏ ‏‮helps‬‏ ‏‮with‬‏ ‏‮this‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮bootup‬‏)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"‏‮Reduce‬‏ ‏‮JavaScript‬‏ ‏‮execution‬‏ ‏‮time‬‏"},"lighthouse-core/audits/bootup-time.js | title":{"message":"‏‮JavaScript‬‏ ‏‮execution‬‏ ‏‮time‬‏"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"‏‮Large‬‏ ‏‮GIFs‬‏ ‏‮are‬‏ ‏‮inefficient‬‏ ‏‮for‬‏ ‏‮delivering‬‏ ‏‮animated‬‏ ‏‮content‬‏. ‏‮Consider‬‏ ‏‮using‬‏ ‏‮MPEG‬‏4/‏‮WebM‬‏ ‏‮videos‬‏ ‏‮for‬‏ ‏‮animations‬‏ ‏‮and‬‏ ‏‮PNG‬‏/‏‮WebP‬‏ ‏‮for‬‏ ‏‮static‬‏ ‏‮images‬‏ ‏‮instead‬‏ ‏‮of‬‏ ‏‮GIF‬‏ ‏‮to‬‏ ‏‮save‬‏ ‏‮network‬‏ ‏‮bytes‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮fundamentals‬‏/‏‮performance‬‏/‏‮optimizing‬‏-‏‮content‬‏-‏‮efficiency‬‏/‏‮replace‬‏-‏‮animated‬‏-‏‮gifs‬‏-‏‮with‬‏-‏‮video‬‏/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"‏‮Use‬‏ ‏‮video‬‏ ‏‮formats‬‏ ‏‮for‬‏ ‏‮animated‬‏ ‏‮content‬‏"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"‏‮Consider‬‏ ‏‮lazy‬‏-‏‮loading‬‏ ‏‮offscreen‬‏ ‏‮and‬‏ ‏‮hidden‬‏ ‏‮images‬‏ ‏‮after‬‏ ‏‮all‬‏ ‏‮critical‬‏ ‏‮resources‬‏ ‏‮have‬‏ ‏‮finished‬‏ ‏‮loading‬‏ ‏‮to‬‏ ‏‮lower‬‏ ‏‮time‬‏ ‏‮to‬‏ ‏‮interactive‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮offscreen‬‏-‏‮images‬‏)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"‏‮Defer‬‏ ‏‮offscreen‬‏ ‏‮images‬‏"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"‏‮Resources‬‏ ‏‮are‬‏ ‏‮blocking‬‏ ‏‮the‬‏ ‏‮first‬‏ ‏‮paint‬‏ ‏‮of‬‏ ‏‮your‬‏ ‏‮page‬‏. ‏‮Consider‬‏ ‏‮delivering‬‏ ‏‮critical‬‏ ‏‮JS‬‏/‏‮CSS‬‏ ‏‮inline‬‏ ‏‮and‬‏ ‏‮deferring‬‏ ‏‮all‬‏ ‏‮non‬‏-‏‮critical‬‏ ‏‮JS‬‏/‏‮styles‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮blocking‬‏-‏‮resources‬‏)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"‏‮Eliminate‬‏ ‏‮render‬‏-‏‮blocking‬‏ ‏‮resources‬‏"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"‏‮Large‬‏ ‏‮network‬‏ ‏‮payloads‬‏ ‏‮cost‬‏ ‏‮users‬‏ ‏‮real‬‏ ‏‮money‬‏ ‏‮and‬‏ ‏‮are‬‏ ‏‮highly‬‏ ‏‮correlated‬‏ ‏‮with‬‏ ‏‮long‬‏ ‏‮load‬‏ ‏‮times‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮network‬‏-‏‮payloads‬‏)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"‏‮Total‬‏ ‏‮size‬‏ ‏‮was‬‏ {‏‮totalBytes‬‏} ‏‮KB‬‏"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"‏‮Avoid‬‏ ‏‮enormous‬‏ ‏‮network‬‏ ‏‮payloads‬‏"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"‏‮Avoids‬‏ ‏‮enormous‬‏ ‏‮network‬‏ ‏‮payloads‬‏"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"‏‮Minifying‬‏ ‏‮CSS‬‏ ‏‮files‬‏ ‏‮can‬‏ ‏‮reduce‬‏ ‏‮network‬‏ ‏‮payload‬‏ ‏‮sizes‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮minify‬‏-‏‮css‬‏)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"‏‮Minify‬‏ ‏‮CSS‬‏"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"‏‮Minifying‬‏ ‏‮JavaScript‬‏ ‏‮files‬‏ ‏‮can‬‏ ‏‮reduce‬‏ ‏‮payload‬‏ ‏‮sizes‬‏ ‏‮and‬‏ ‏‮script‬‏ ‏‮parse‬‏ ‏‮time‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮speed‬‏/‏‮docs‬‏/‏‮insights‬‏/‏‮MinifyResources‬‏)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"‏‮Minify‬‏ ‏‮JavaScript‬‏"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"‏‮Remove‬‏ ‏‮unused‬‏ ‏‮rules‬‏ ‏‮from‬‏ ‏‮stylesheets‬‏ ‏‮to‬‏ ‏‮reduce‬‏ ‏‮unnecessary‬‏ ‏‮bytes‬‏ ‏‮consumed‬‏ ‏‮by‬‏ ‏‮network‬‏ ‏‮activity‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮unused‬‏-‏‮css‬‏)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"‏‮Defer‬‏ ‏‮unused‬‏ ‏‮CSS‬‏"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"‏‮Remove‬‏ ‏‮unused‬‏ ‏‮JavaScript‬‏ ‏‮to‬‏ ‏‮reduce‬‏ ‏‮bytes‬‏ ‏‮consumed‬‏ ‏‮by‬‏ ‏‮network‬‏ ‏‮activity‬‏."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"‏‮Remove‬‏ ‏‮unused‬‏ ‏‮JavaScript‬‏"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"‏‮A‬‏ ‏‮long‬‏ ‏‮cache‬‏ ‏‮lifetime‬‏ ‏‮can‬‏ ‏‮speed‬‏ ‏‮up‬‏ ‏‮repeat‬‏ ‏‮visits‬‏ ‏‮to‬‏ ‏‮your‬‏ ‏‮page‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮cache‬‏-‏‮policy‬‏)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{1 ‏‮resource‬‏ ‏‮found‬‏}zero{# ‏‮resources‬‏ ‏‮found‬‏}two{# ‏‮resources‬‏ ‏‮found‬‏}few{# ‏‮resources‬‏ ‏‮found‬‏}many{# ‏‮resources‬‏ ‏‮found‬‏}other{# ‏‮resources‬‏ ‏‮found‬‏}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"‏‮Serve‬‏ ‏‮static‬‏ ‏‮assets‬‏ ‏‮with‬‏ ‏‮an‬‏ ‏‮efficient‬‏ ‏‮cache‬‏ ‏‮policy‬‏"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"‏‮Uses‬‏ ‏‮efficient‬‏ ‏‮cache‬‏ ‏‮policy‬‏ ‏‮on‬‏ ‏‮static‬‏ ‏‮assets‬‏"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"‏‮Optimized‬‏ ‏‮images‬‏ ‏‮load‬‏ ‏‮faster‬‏ ‏‮and‬‏ ‏‮consume‬‏ ‏‮less‬‏ ‏‮cellular‬‏ ‏‮data‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮optimize‬‏-‏‮images‬‏)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"‏‮Efficiently‬‏ ‏‮encode‬‏ ‏‮images‬‏"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"‏‮Serve‬‏ ‏‮images‬‏ ‏‮that‬‏ ‏‮are‬‏ ‏‮appropriately‬‏-‏‮sized‬‏ ‏‮to‬‏ ‏‮save‬‏ ‏‮cellular‬‏ ‏‮data‬‏ ‏‮and‬‏ ‏‮improve‬‏ ‏‮load‬‏ ‏‮time‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮oversized‬‏-‏‮images‬‏)."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"‏‮Properly‬‏ ‏‮size‬‏ ‏‮images‬‏"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"‏‮Text‬‏-‏‮based‬‏ ‏‮resources‬‏ ‏‮should‬‏ ‏‮be‬‏ ‏‮served‬‏ ‏‮with‬‏ ‏‮compression‬‏ (‏‮gzip‬‏, ‏‮deflate‬‏ ‏‮or‬‏ ‏‮brotli‬‏) ‏‮to‬‏ ‏‮minimize‬‏ ‏‮total‬‏ ‏‮network‬‏ ‏‮bytes‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮text‬‏-‏‮compression‬‏)."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"‏‮Enable‬‏ ‏‮text‬‏ ‏‮compression‬‏"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"‏‮Image‬‏ ‏‮formats‬‏ ‏‮like‬‏ ‏‮JPEG‬‏ 2000, ‏‮JPEG‬‏ ‏‮XR‬‏, ‏‮and‬‏ ‏‮WebP‬‏ ‏‮often‬‏ ‏‮provide‬‏ ‏‮better‬‏ ‏‮compression‬‏ ‏‮than‬‏ ‏‮PNG‬‏ ‏‮or‬‏ ‏‮JPEG‬‏, ‏‮which‬‏ ‏‮means‬‏ ‏‮faster‬‏ ‏‮downloads‬‏ ‏‮and‬‏ ‏‮less‬‏ ‏‮data‬‏ ‏‮consumption‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮webp‬‏)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"‏‮Serve‬‏ ‏‮images‬‏ ‏‮in‬‏ ‏‮next‬‏-‏‮gen‬‏ ‏‮formats‬‏"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"‏‮The‬‏ ‏‮Critical‬‏ ‏‮Request‬‏ ‏‮Chains‬‏ ‏‮below‬‏ ‏‮show‬‏ ‏‮you‬‏ ‏‮what‬‏ ‏‮resources‬‏ ‏‮are‬‏ ‏‮loaded‬‏ ‏‮with‬‏ ‏‮a‬‏ ‏‮high‬‏ ‏‮priority‬‏. ‏‮Consider‬‏ ‏‮reducing‬‏ ‏‮the‬‏ ‏‮length‬‏ ‏‮of‬‏ ‏‮chains‬‏, ‏‮reducing‬‏ ‏‮the‬‏ ‏‮download‬‏ ‏‮size‬‏ ‏‮of‬‏ ‏‮resources‬‏, ‏‮or‬‏ ‏‮deferring‬‏ ‏‮the‬‏ ‏‮download‬‏ ‏‮of‬‏ ‏‮unnecessary‬‏ ‏‮resources‬‏ ‏‮to‬‏ ‏‮improve‬‏ ‏‮page‬‏ ‏‮load‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮critical‬‏-‏‮request‬‏-‏‮chains‬‏)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{1 ‏‮chain‬‏ ‏‮found‬‏}zero{# ‏‮chains‬‏ ‏‮found‬‏}two{# ‏‮chains‬‏ ‏‮found‬‏}few{# ‏‮chains‬‏ ‏‮found‬‏}many{# ‏‮chains‬‏ ‏‮found‬‏}other{# ‏‮chains‬‏ ‏‮found‬‏}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"‏‮Minimize‬‏ ‏‮Critical‬‏ ‏‮Requests‬‏ ‏‮Depth‬‏"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"‏‮Element‬‏"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"‏‮Statistic‬‏"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"‏‮Value‬‏"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"‏‮Browser‬‏ ‏‮engineers‬‏ ‏‮recommend‬‏ ‏‮pages‬‏ ‏‮contain‬‏ ‏‮fewer‬‏ ‏‮than‬‏ ~1,500 ‏‮DOM‬‏ ‏‮nodes‬‏. ‏‮The‬‏ ‏‮sweet‬‏ ‏‮spot‬‏ ‏‮is‬‏ ‏‮a‬‏ ‏‮tree‬‏ ‏‮depth‬‏ < 32 ‏‮elements‬‏ ‏‮and‬‏ ‏‮fewer‬‏ ‏‮than‬‏ 60 ‏‮children‬‏/‏‮parent‬‏ ‏‮element‬‏. ‏‮A‬‏ ‏‮large‬‏ ‏‮DOM‬‏ ‏‮can‬‏ ‏‮increase‬‏ ‏‮memory‬‏ ‏‮usage‬‏, ‏‮cause‬‏ ‏‮longer‬‏ [‏‮style‬‏ ‏‮calculations‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮fundamentals‬‏/‏‮performance‬‏/‏‮rendering‬‏/‏‮reduce‬‏-‏‮the‬‏-‏‮scope‬‏-‏‮and‬‏-‏‮complexity‬‏-‏‮of‬‏-‏‮style‬‏-‏‮calculations‬‏), ‏‮and‬‏ ‏‮produce‬‏ ‏‮costly‬‏ [‏‮layout‬‏ ‏‮reflows‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮speed‬‏/‏‮articles‬‏/‏‮reflow‬‏). [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮dom‬‏-‏‮size‬‏)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 ‏‮node‬‏}zero{# ‏‮nodes‬‏}two{# ‏‮nodes‬‏}few{# ‏‮nodes‬‏}many{# ‏‮nodes‬‏}other{# ‏‮nodes‬‏}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"‏‮Avoid‬‏ ‏‮an‬‏ ‏‮excessive‬‏ ‏‮DOM‬‏ ‏‮size‬‏"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"‏‮Maximum‬‏ ‏‮DOM‬‏ ‏‮Depth‬‏"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"‏‮Total‬‏ ‏‮DOM‬‏ ‏‮Nodes‬‏"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"‏‮Maximum‬‏ ‏‮Child‬‏ ‏‮Elements‬‏"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"‏‮Avoids‬‏ ‏‮an‬‏ ‏‮excessive‬‏ ‏‮DOM‬‏ ‏‮size‬‏"},"lighthouse-core/audits/font-display.js | description":{"message":"‏‮Leverage‬‏ ‏‮the‬‏ ‏‮font‬‏-‏‮display‬‏ ‏‮CSS‬‏ ‏‮feature‬‏ ‏‮to‬‏ ‏‮ensure‬‏ ‏‮text‬‏ ‏‮is‬‏ ‏‮user‬‏-‏‮visible‬‏ ‏‮while‬‏ ‏‮webfonts‬‏ ‏‮are‬‏ ‏‮loading‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮updates‬‏/2016/02/‏‮font‬‏-‏‮display‬‏)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"‏‮Ensure‬‏ ‏‮text‬‏ ‏‮remains‬‏ ‏‮visible‬‏ ‏‮during‬‏ ‏‮webfont‬‏ ‏‮load‬‏"},"lighthouse-core/audits/font-display.js | title":{"message":"‏‮All‬‏ ‏‮text‬‏ ‏‮remains‬‏ ‏‮visible‬‏ ‏‮during‬‏ ‏‮webfont‬‏ ‏‮loads‬‏"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"‏‮Category‬‏"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"‏‮Consider‬‏ ‏‮reducing‬‏ ‏‮the‬‏ ‏‮time‬‏ ‏‮spent‬‏ ‏‮parsing‬‏, ‏‮compiling‬‏ ‏‮and‬‏ ‏‮executing‬‏ ‏‮JS‬‏. ‏‮You‬‏ ‏‮may‬‏ ‏‮find‬‏ ‏‮delivering‬‏ ‏‮smaller‬‏ ‏‮JS‬‏ ‏‮payloads‬‏ ‏‮helps‬‏ ‏‮with‬‏ ‏‮this‬‏."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"‏‮Minimize‬‏ ‏‮main‬‏-‏‮thread‬‏ ‏‮work‬‏"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"‏‮Minimizes‬‏ ‏‮main‬‏-‏‮thread‬‏ ‏‮work‬‏"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"‏‮The‬‏ ‏‮score‬‏ ‏‮above‬‏ ‏‮is‬‏ ‏‮an‬‏ ‏‮estimate‬‏ ‏‮of‬‏ ‏‮how‬‏ ‏‮long‬‏ ‏‮your‬‏ ‏‮app‬‏ ‏‮takes‬‏ ‏‮to‬‏ ‏‮respond‬‏ ‏‮to‬‏ ‏‮user‬‏ ‏‮input‬‏, ‏‮in‬‏ ‏‮milliseconds‬‏, ‏‮during‬‏ ‏‮the‬‏ ‏‮busiest‬‏ 5‏‮s‬‏ ‏‮window‬‏ ‏‮of‬‏ ‏‮page‬‏ ‏‮load‬‏. ‏‮If‬‏ ‏‮your‬‏ ‏‮latency‬‏ ‏‮is‬‏ ‏‮higher‬‏ ‏‮than‬‏ 50 ‏‮ms‬‏, ‏‮users‬‏ ‏‮may‬‏ ‏‮perceive‬‏ ‏‮your‬‏ ‏‮app‬‏ ‏‮as‬‏ ‏‮laggy‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮estimated‬‏-‏‮input‬‏-‏‮latency‬‏)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"‏‮Estimated‬‏ ‏‮Input‬‏ ‏‮Latency‬‏"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"‏‮First‬‏ ‏‮Contentful‬‏ ‏‮Paint‬‏ ‏‮marks‬‏ ‏‮the‬‏ ‏‮time‬‏ ‏‮at‬‏ ‏‮which‬‏ ‏‮the‬‏ ‏‮first‬‏ ‏‮text‬‏ ‏‮or‬‏ ‏‮image‬‏ ‏‮is‬‏ ‏‮painted‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮first‬‏-‏‮contentful‬‏-‏‮paint‬‏)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"‏‮First‬‏ ‏‮Contentful‬‏ ‏‮Paint‬‏"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"‏‮First‬‏ ‏‮CPU‬‏ ‏‮Idle‬‏ ‏‮marks‬‏ ‏‮the‬‏ ‏‮first‬‏ ‏‮time‬‏ ‏‮at‬‏ ‏‮which‬‏ ‏‮the‬‏ ‏‮page‬‏'‏‮s‬‏ ‏‮main‬‏ ‏‮thread‬‏ ‏‮is‬‏ ‏‮quiet‬‏ ‏‮enough‬‏ ‏‮to‬‏ ‏‮handle‬‏ ‏‮input‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮first‬‏-‏‮interactive‬‏)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"‏‮First‬‏ ‏‮CPU‬‏ ‏‮Idle‬‏"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"‏‮First‬‏ ‏‮Meaningful‬‏ ‏‮Paint‬‏ ‏‮measures‬‏ ‏‮when‬‏ ‏‮the‬‏ ‏‮primary‬‏ ‏‮content‬‏ ‏‮of‬‏ ‏‮a‬‏ ‏‮page‬‏ ‏‮is‬‏ ‏‮visible‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮first‬‏-‏‮meaningful‬‏-‏‮paint‬‏)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"‏‮First‬‏ ‏‮Meaningful‬‏ ‏‮Paint‬‏"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"‏‮Interactive‬‏ ‏‮marks‬‏ ‏‮the‬‏ ‏‮time‬‏ ‏‮at‬‏ ‏‮which‬‏ ‏‮the‬‏ ‏‮page‬‏ ‏‮is‬‏ ‏‮fully‬‏ ‏‮interactive‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮consistently‬‏-‏‮interactive‬‏)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"‏‮Time‬‏ ‏‮to‬‏ ‏‮Interactive‬‏"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"‏‮Speed‬‏ ‏‮Index‬‏ ‏‮shows‬‏ ‏‮how‬‏ ‏‮quickly‬‏ ‏‮the‬‏ ‏‮contents‬‏ ‏‮of‬‏ ‏‮a‬‏ ‏‮page‬‏ ‏‮are‬‏ ‏‮visibly‬‏ ‏‮populated‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮speed‬‏-‏‮index‬‏)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"‏‮Speed‬‏ ‏‮Index‬‏"},"lighthouse-core/audits/redirects.js | description":{"message":"‏‮Redirects‬‏ ‏‮introduce‬‏ ‏‮additional‬‏ ‏‮delays‬‏ ‏‮before‬‏ ‏‮the‬‏ ‏‮page‬‏ ‏‮can‬‏ ‏‮be‬‏ ‏‮loaded‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮redirects‬‏)."},"lighthouse-core/audits/redirects.js | title":{"message":"‏‮Avoid‬‏ ‏‮multiple‬‏ ‏‮page‬‏ ‏‮redirects‬‏"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"‏‮Time‬‏ ‏‮To‬‏ ‏‮First‬‏ ‏‮Byte‬‏ ‏‮identifies‬‏ ‏‮the‬‏ ‏‮time‬‏ ‏‮at‬‏ ‏‮which‬‏ ‏‮your‬‏ ‏‮server‬‏ ‏‮sends‬‏ ‏‮a‬‏ ‏‮response‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮ttfb‬‏)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"‏‮Root‬‏ ‏‮document‬‏ ‏‮took‬‏ {‏‮timeInMs‬‏} ‏‮ms‬‏"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"‏‮Reduce‬‏ ‏‮server‬‏ ‏‮response‬‏ ‏‮times‬‏ (‏‮TTFB‬‏)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"‏‮Server‬‏ ‏‮response‬‏ ‏‮times‬‏ ‏‮are‬‏ ‏‮low‬‏ (‏‮TTFB‬‏)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"‏‮Duration‬‏"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"‏‮Name‬‏"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"‏‮Start‬‏ ‏‮Time‬‏"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"‏‮Type‬‏"},"lighthouse-core/audits/user-timings.js | description":{"message":"‏‮Consider‬‏ ‏‮instrumenting‬‏ ‏‮your‬‏ ‏‮app‬‏ ‏‮with‬‏ ‏‮the‬‏ ‏‮User‬‏ ‏‮Timing‬‏ ‏‮API‬‏ ‏‮to‬‏ ‏‮measure‬‏ ‏‮your‬‏ ‏‮app‬‏'‏‮s‬‏ ‏‮real‬‏-‏‮world‬‏ ‏‮performance‬‏ ‏‮during‬‏ ‏‮key‬‏ ‏‮user‬‏ ‏‮experiences‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮user‬‏-‏‮timing‬‏)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 ‏‮user‬‏ ‏‮timing‬‏}zero{# ‏‮user‬‏ ‏‮timings‬‏}two{# ‏‮user‬‏ ‏‮timings‬‏}few{# ‏‮user‬‏ ‏‮timings‬‏}many{# ‏‮user‬‏ ‏‮timings‬‏}other{# ‏‮user‬‏ ‏‮timings‬‏}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"‏‮User‬‏ ‏‮Timing‬‏ ‏‮marks‬‏ ‏‮and‬‏ ‏‮measures‬‏"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"‏‮Consider‬‏ ‏‮adding‬‏ ‏‮preconnect‬‏ ‏‮or‬‏ ‏‮dns‬‏-‏‮prefetch‬‏ ‏‮resource‬‏ ‏‮hints‬‏ ‏‮to‬‏ ‏‮establish‬‏ ‏‮early‬‏ ‏‮connections‬‏ ‏‮to‬‏ ‏‮important‬‏ ‏‮third‬‏-‏‮party‬‏ ‏‮origins‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮fundamentals‬‏/‏‮performance‬‏/‏‮resource‬‏-‏‮prioritization‬‏#‏‮preconnect‬‏)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"‏‮Preconnect‬‏ ‏‮to‬‏ ‏‮required‬‏ ‏‮origins‬‏"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"‏‮Consider‬‏ ‏‮using‬‏ <link rel=preload> ‏‮to‬‏ ‏‮prioritize‬‏ ‏‮fetching‬‏ ‏‮resources‬‏ ‏‮that‬‏ ‏‮are‬‏ ‏‮currently‬‏ ‏‮requested‬‏ ‏‮later‬‏ ‏‮in‬‏ ‏‮page‬‏ ‏‮load‬‏. [‏‮Learn‬‏ ‏‮more‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/‏‮audits‬‏/‏‮preload‬‏)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"‏‮Preload‬‏ ‏‮key‬‏ ‏‮requests‬‏"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"‏‮More‬‏ ‏‮information‬‏ ‏‮about‬‏ ‏‮the‬‏ ‏‮performance‬‏ ‏‮of‬‏ ‏‮your‬‏ ‏‮application‬‏."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"‏‮Diagnostics‬‏"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"‏‮The‬‏ ‏‮most‬‏ ‏‮critical‬‏ ‏‮aspect‬‏ ‏‮of‬‏ ‏‮performance‬‏ ‏‮is‬‏ ‏‮how‬‏ ‏‮quickly‬‏ ‏‮pixels‬‏ ‏‮are‬‏ ‏‮rendered‬‏ ‏‮onscreen‬‏. ‏‮Key‬‏ ‏‮metrics‬‏: ‏‮First‬‏ ‏‮Contentful‬‏ ‏‮Paint‬‏, ‏‮First‬‏ ‏‮Meaningful‬‏ ‏‮Paint‬‏"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"‏‮First‬‏ ‏‮Paint‬‏ ‏‮Improvements‬‏"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"‏‮These‬‏ ‏‮optimizations‬‏ ‏‮can‬‏ ‏‮speed‬‏ ‏‮up‬‏ ‏‮your‬‏ ‏‮page‬‏ ‏‮load‬‏."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"‏‮Opportunities‬‏"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"‏‮Metrics‬‏"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"‏‮Enhance‬‏ ‏‮the‬‏ ‏‮overall‬‏ ‏‮loading‬‏ ‏‮experience‬‏, ‏‮so‬‏ ‏‮the‬‏ ‏‮page‬‏ ‏‮is‬‏ ‏‮responsive‬‏ ‏‮and‬‏ ‏‮ready‬‏ ‏‮to‬‏ ‏‮use‬‏ ‏‮as‬‏ ‏‮soon‬‏ ‏‮as‬‏ ‏‮possible‬‏. ‏‮Key‬‏ ‏‮metrics‬‏: ‏‮Time‬‏ ‏‮to‬‏ ‏‮Interactive‬‏, ‏‮Speed‬‏ ‏‮Index‬‏"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"‏‮Overall‬‏ ‏‮Improvements‬‏"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"‏‮Performance‬‏"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"‏‮Cache‬‏ ‏‮TTL‬‏"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"‏‮Size‬‏ (‏‮KB‬‏)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"‏‮Time‬‏ ‏‮Spent‬‏"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"‏‮URL‬‏"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"‏‮Potential‬‏ ‏‮Savings‬‏ (‏‮KB‬‏)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"‏‮Potential‬‏ ‏‮Savings‬‏ (‏‮ms‬‏)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"‏‮Potential‬‏ ‏‮savings‬‏ ‏‮of‬‏ {‏‮wastedBytes‬‏} ‏‮KB‬‏"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"‏‮Potential‬‏ ‏‮savings‬‏ ‏‮of‬‏ {‏‮wastedMs‬‏} ‏‮ms‬‏"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{‏‮timeInMs‬‏} ‏‮ms‬‏"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{‏‮timeInMsSec‬‏} ‏‮s‬‏"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"‏‮Show‬‏ ‏‮audits‬‏"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"‏‮Initial‬‏ ‏‮Navigation‬‏"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"‏‮Maximum‬‏ ‏‮critical‬‏ ‏‮path‬‏ ‏‮latency‬‏:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"‏‮Error‬‏!"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"‏‮Report‬‏ ‏‮error‬‏: ‏‮no‬‏ ‏‮audit‬‏ ‏‮information‬‏"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"‏‮Lab‬‏ ‏‮Data‬‏"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[‏‮Lighthouse‬‏](‏‮https‬‏://‏‮developers‬‏.‏‮google‬‏.‏‮com‬‏/‏‮web‬‏/‏‮tools‬‏/‏‮lighthouse‬‏/) ‏‮analysis‬‏ ‏‮of‬‏ ‏‮the‬‏ ‏‮current‬‏ ‏‮page‬‏ ‏‮on‬‏ ‏‮emulated‬‏ 3‏‮G‬‏. ‏‮Values‬‏ ‏‮are‬‏ ‏‮estimated‬‏ ‏‮and‬‏ ‏‮may‬‏ ‏‮vary‬‏."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"‏‮Additional‬‏ ‏‮items‬‏ ‏‮to‬‏ ‏‮manually‬‏ ‏‮check‬‏"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"‏‮Not‬‏ ‏‮applicable‬‏"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"‏‮Opportunity‬‏"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"‏‮Estimated‬‏ ‏‮Savings‬‏"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"‏‮Passed‬‏ ‏‮audits‬‏"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"‏‮Score‬‏ ‏‮scale‬‏:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"‏‮There‬‏ ‏‮were‬‏ ‏‮issues‬‏ ‏‮affecting‬‏ ‏‮this‬‏ ‏‮run‬‏ ‏‮of‬‏ ‏‮Lighthouse‬‏:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"‏‮Values‬‏ ‏‮are‬‏ ‏‮estimated‬‏ ‏‮and‬‏ ‏‮may‬‏ ‏‮vary‬‏."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"‏‮Warnings‬‏: "}};},{}],39:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"أثّرت \"إضافات Chrome\" بشكلٍ سلبي في أداء التحميل لهذه الصفحة. ويمكنك تجربة تدقيق الصفحة في وضع التصفُّح المُتخفّي أو من ملف شخصي على Chrome بدون الإضافات."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"تقييم النص البرمجي"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"تحليل النص البرمجي"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"الإجمالي"},"lighthouse-core/audits/bootup-time.js | description":{"message":"يمكنك تقليل الوقت المستغرق في تحليل جافا سكريبت وإنشائه وتنفيذه. قد يتبين لك أن تسليم أحمال جافا سكريبت بحجم أصغر يساعد في ذلك. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"تقليل وقت تنفيذ جافا سكريبت"},"lighthouse-core/audits/bootup-time.js | title":{"message":"وقت تنفيذ جافا سكريبت"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"لا تكفي ملفات GIF الكبيرة لتسليم محتوى صور متحركة. لذا يمكنك استخدام فيديوهات MPEG4 / WebM للصور المتحركة وملفات PNG / WebP للصور الثابتة بدلاً من ملفات GIF لحفظ وحدات البايت للشبكة. [مزيد من المعلومات](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"استخدام تنسيقات الفيديو لمحتوى الصور المتحركة"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"خُذ بعين الاعتبار التحميل البطئ خارج الشاشة والصور المخفية بعد الانتهاء من تحميل جميع الموارد المهمة في وقت أقل تفاعلية. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"تأجيل الصور خارج الشاشة"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"تحظر الموارد العرض الأول لصفحتك. ويمكنك تسليم تضمين JS / CSS المهم وتأجيل كل الأنماط/جافا سكريبت غير المهمة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"استبعاد موارد حظر العرض"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"تُكلِّف أحمال الشبكة الكبيرة المستخدمين الكثير من الأموال وترتبط مباشرةً بأوقات التحميل الطويلة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/network-payloads)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"كان إجمالي الحجم {totalBytes, number, bytes} كيلوبايت"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"تجنُّب الأحمال الضخمة للشبكة"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"تجنُّب الأحمال الضخمة للشبكة"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"يمكن أن يؤدي تصغير ملفات CSS إلى تقليل أحجام حمولة الشبكة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/minify-css)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"تصغير CSS"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"يمكن أن يؤدي تصغير ملفات جافا سكريبت إلى تقليل أحجام الأحمال ووقت تحليل النص البرمجي. [مزيد من المعلومات](https://developers.google.com/speed/docs/insights/MinifyResources)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"تصغير جافا سكريبت"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"يمكنك إزالة القواعد غير المُستخدَمة من ورق الأنماط لتقليل وحدات البايت غير الضرورية التي يستهلكها نشاط الشبكة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/unused-css)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"تأجيل CSS غير المُستخدَم"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"يمكنك إزالة جافا سكريبت غير المُستخدَم لتقليل وحدات البايت التي يستهلكها نشاط الشبكة."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"إزالة جافا سكريبت غير المستخدم"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"يمكن لفترة التخزين المؤقت الطويلة تسريع عملية تكرار الزيارات إلى صفحتك. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/cache-policy)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{تم العثور على مورد واحد}zero{تم العثور على # مورد}two{تم العثور على مورديْنِ (#)}few{تم العثور على # موارد}many{تم العثور على # موردًا}other{تم العثور على # مورد}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"عرض الأصول الثابتة من خلال سياسة ذاكرة التخزين المؤقت الفعالة"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"استخدام سياسة ذاكرة التخزين المؤقت الفعالة على الأصول الثابتة"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"يتم تحميل الصور المحسَّنة بشكلٍ أسرع وتستهلك بيانات أقل لشبكة الجوّال. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/optimize-images)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"تشفير الصور بكفاءة"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"يمكنك عرض صور بحجم مناسب لحفظ بيانات شبكة الجوّال وتحسين وقت التحميل. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/oversized-images)."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"الصور ذات الحجم المناسب"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"يجب عرض الموارد المستندة إلى النص باستخدام الضغط (gzip أو الانكماش أو brotli) لتقليل إجمالي وحدات البايت للشبكة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/text-compression)."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"تفعيل ضغط النص"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"غالبًا ما توفِّر تنسيقات الصور، مثل JPEG 2000 وJPEG XR وWebP، ضغطًا أفضل من تنسيق PNG أو JPEG، وهذا بدوره يعني تنزيلاً أسرع واستهلاكًا أقل للبيانات. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/webp)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"عرض الصور بتنسيقات الجيل القادم"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"توضح لك \"سلاسل الطلبات المهمة\" أدناه الموارد التي تم تحميلها بأولوية عالية. ويمكنك تقليل طول السلاسل أو تقليل حجم تنزيل الموارد أو تأجيل تنزيل الموارد غير الضرورية لتحسين تحميل الصفحة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{تم العثور على سلسلة واحدة}zero{تم العثور على # سلسلة}two{تم العثور على سلسلتيْنِ (#)}few{تم العثور على # سلاسل}many{تم العثور على # سلسلةً}other{تم العثور على # سلسلة}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"تقليل عمق الطلبات المهمة"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"يوصي مهندسو المتصفّح بالصفحات التي تحتوي على أقل من ~1500 عُقدة DOM. وتمثل sweet spot شبكة عمقها < 32 عنصرًا ولا تزيد عن 60 عنصرًا فرعيًا/رئيسيًا. ويمكن أن تزيد عُقدة DOM الكبيرة من استخدام الذاكرة، وتسبب [عمليات حسابية نمطية] أطول (https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations)، وتنتج [عمليات إعادة عرض للتنسيق] مُكلفة (https://developers.google.com/speed/articles/reflow). [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/dom-size)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{عقدة واحدة}zero{# عقدة}two{عقدتان (#)}few{# عُقَد}many{# عقدةً}other{# عقدة}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"تجنُب حجم DOM الزائد"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"الحد الأقصى لعمق DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"إجمالى عُقَدْ DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"تجنُب حجم DOM الزائد"},"lighthouse-core/audits/font-display.js | description":{"message":"يمكنك الاستفادة من ميزة CSS لعرض الخطوط لضمان أن يكون النص مرئيًا للمستخدم أثناء تحميل خطوط موقع ويب. [مزيد من المعلومات](https://developers.google.com/web/updates/2016/02/font-display)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"التأكد من بقاء النص مرئيًا أثناء تحميل خط موقع ويب"},"lighthouse-core/audits/font-display.js | title":{"message":"تظل جميع النصوص مرئية أثناء تحميل خط موقع ويب"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"الفئة"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"يمكنك تقليل الوقت المستغرق في تحليل جافا سكريبت وإنشائه وتنفيذه. قد يتبين لك أن تسليم أحمال جافا سكريبت بحجم أصغر يساعد في ذلك."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"تقليل سلسلة العمل الرئيسية"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"تقليل سلسلة العمل الرئيسية"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"إن النتيجة الواردة أعلاه تمثل تقديرًا لطول المدة التي يستغرقها تطبيقك في الاستجابة لإدخال المستخدم، بالمللي ثانية، أثناء فترة تحميل الصفحة الأكثر انشغالاً خلال 5 ثوانٍ. إذا كان وقت الاستجابة أكثر من 50 مللي ثانية، يمكن للمستخدمين اعتبار تطبيقك بأنه \"بطيء في التفاعل\". [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"وقت الاستجابة المُقدّر للإدخال"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"تحدد \"سرعة عرض المحتوى على الصفحة\" الوقت الذي يُعرَض فيه أول صورة أو نص. [مزيد من المعلومات](https://developers.google.com/web/fundamentals/performance/user-centric-performance-metrics#first_paint_and_first_contentful_paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"First Contentful Paint"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"تشير \"وحدة المعالجة المركزية الأولى الخاملة\" إلى المرة الأولى التي تكون فيها السلسلة الرئيسية للصفحة كافية للتعامل مع الإدخال. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/first-interactive)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"وحدة المعالجة المركزية الأولى الخاملة"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"يقيس First Meaningful Paint الوقت الذي يكون فيه المحتوى الأساسي لصفحة مرئيًا. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"First Meaningful Paint"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"يميّز \"الوضع التفاعلي\" الوقت الذي تكون فيه الصفحة تفاعلية بالكامل. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"وقت التفاعل"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"يوضح مؤشر السرعة مدى سرعة تعبئة محتوى الصفحة بشكلٍ واضح. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/speed-index)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"مؤشر السرعة"},"lighthouse-core/audits/redirects.js | description":{"message":"تؤدي عمليات إعادة التوجيه إلى حدوث تأخيرات إضافية قبل أن يتم تحميل الصفحة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/redirects)."},"lighthouse-core/audits/redirects.js | title":{"message":"تجنُب عمليات إعادة توجيه الصفحات المتعددة"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"يحدد \"وقت وصول أول بايت\" الوقت الذي يُرسل فيه الخادم استجابة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/ttfb)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"استغرق مستند الجذر {timeInMs, number, milliseconds} مللي ثانية."},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"تقليل أوقات استجابة الخادم (TTFB)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"أوقات استجابة الخادم منخفضة (TTFB)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"المدة"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"الاسم"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"وقت البدء"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"النوع"},"lighthouse-core/audits/user-timings.js | description":{"message":"يمكنك توجيه تطبيقك باستخدام \"واجهة برمجة التطبيقات لأوقات المستخدم\" لقياس الأداء الفعلي لتطبيقك أثناء التجارب الأساسية للمستخدمين. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{وقت واحد للمستخدم}zero{# وقت للمستخدم}two{وقتا (#) المستخدم}few{# أوقات للمستخدم}many{# وقتًا للمستخدم}other{# وقت للمستخدم}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"علامات أوقات المستخدم وقياساتها"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"يمكنك إضافة الاتصال المسبق أو تعديلات موارد الجلب المسبق لنظام أسماء النطاقات لإنشاء اتصالات مبكرة بأصول مهمة تابعة لجهة خارجية. [مزيد من المعلومات](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"الاتصال المسبق للأصول المطلوبة"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"يمكنك استخدام <link rel = preload> لتحديد أولويات جلب الموارد المطلوبة حاليًا في وقتٍ لاحق في تحميل الصفحة. [مزيد من المعلومات](https://developers.google.com/web/tools/lighthouse/audits/preload)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"التحميل المسبق للطلبات الأساسية"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"مزيد من المعلومات حول أداء تطبيقك."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"بيانات التشخيص"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"يمثل الجانب الأكثر أهمية للأداء مدى السرعة التي يتم بها عرض وحدات البكسل على الشاشة. المقاييس الرئيسية: First Contentful Paint وFirst Meaningful Paint"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"تحسينات العرض الأول"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"يمكن لهذه التحسينات تسريع عملية تحميل الصفحة."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"فرص تحسين الأداء"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"المقاييس"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"يمكنك تحسين تجربة التحميل العامة لتصبح هذه الصفحة سريعة الاستجابة وجاهزة للاستخدام في أقرب وقت ممكن. المقاييس الأساسية: وقت التفاعل ومؤشر السرعة."},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"التحسينات العامة"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"الأداء"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"ذاكرة التخزين المؤقت TTL"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"الحجم (كيلوبايت)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"الوقت المستغرَق"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"عنوان URL"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"التوفيرات المحتملة (كيلوبايت)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"التوفيرات المحتملة (مللي ثانية)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"التوفيرات المحتملة من {wastedBytes, number, bytes} كيلوبايت"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"التوفيرات المحتملة لـ {wastedMs, number, milliseconds} مللي ثانية"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} مللي ثانية"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} ثانية"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"عرض عمليات التدقيق"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"التنقل الأوّلي"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"الحد الأقصى لوقت استجابة المسار المهم:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"خطأ!"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"الإبلاغ عن خطأ: لا تتوفَّر معلومات تدقيق"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"بيانات المختبَر"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[Lighthouse](https://developers.google.com/web/tools/lighthouse/) تحليل الصفحة الحالية على شبكة الجيل الثالث في وضع المحاكاة. القيم تقديرية وقابلة للتغيير."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"عناصر إضافية للتحقُّق يدويًا"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"غير سارٍ"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"فرصة تحسين الأداء"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"التوفيرات المُقدرة"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"اجتياز عمليات التدقيق بنجاح"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"مقياس النتيجة:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"حدثت مشاكل تؤثر في تشغيل Lighthouse:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"القيم تقديرية وقابلة للتغير"},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"التحذيرات: "}};},{}],40:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Зареждането на тази страница се забавя от разширения за Chrome. Опитайте да я проверите в режим „инкогнито“ или от потребителски профил в Chrome без инсталирани разширения."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Проверка на скрипта"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Синтактичен анализ на скрипта"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Общо"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Препоръчваме да намалите времето, прекарвано в синтактичен анализ, компилиране и изпълнение на JS. Използването на JS ресурси с по-малък размер може да помогне за това. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Намалете времето за изпълнение на JavaScript"},"lighthouse-core/audits/bootup-time.js | title":{"message":"Време за изпълнение на JavaScript"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Големите GIF файлове не са ефективни за показване на анимирано съдържание. Вместо това препоръчваме да използвате видеоклипове във формат MPEG4/WebM за анимации и PNG/WebP за статични изображения, за да намалите преноса на данни. [Научете повече](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Използвайте видеоформати за анимираното съдържание"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"За да намалите времето до интерактивност, препоръчваме скритите изображения и тези извън видимата част на екрана да се зареждат след всички критични ресурси. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Отложете зареждането на изображенията извън видимата част на екрана"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Ресурси блокират първото изобразяване на страницата ви. Препоръчваме да вградите критичните JS/CSS елементи и да отложите зареждането на всички некритични JS/стилове. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Елиминирайте ресурсите, които блокират изобразяването"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Мрежовите ресурси с голям размер струват пари на потребителите и са тясно свързани с бавното зареждане. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/network-payloads)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Общият размер бе {totalBytes, number, bytes} КБ"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Не използвайте мрежови ресурси с голям размер"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Не се използват мрежови ресурси с голям размер"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Минимизирането на файловете със CSS може да намали размера на мрежовите ресурси. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/minify-css)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"Минимизирайте CSS"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Минимизирането на файловете с JavaScript може да намали размера на ресурсите и времето за синтактичен анализ на скрипта. [Научете повече](https://developers.google.com/speed/docs/insights/MinifyResources)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"Минимизирайте JavaScript"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Премахнете неизползваните правила от стиловите листове, за да намалите ненужния пренос на данни при мрежовата активност. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/unused-css)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Отложете зареждането на неизползваните CSS стилове"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Премахнете неизползвания JavaScript, за да намалите преноса на данни при мрежовата активност."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Премахнете неизползвания JavaScript"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"Продължителното съхраняване на кеша може да ускори повторните посещения на страницата ви. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/cache-policy)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{Намерен е 1 ресурс}other{Намерени са # ресурса}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Използвайте ефективни правила за кеша, за да улесните показването на статичните активи"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Използват се ефективни правила за кеширане на статичните активи"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Оптимизираните изображения се зареждат по-бързо и използват по-малко мобилни данни. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/optimize-images)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Кодирайте изображенията ефективно"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Показвайте правилно оразмерени изображения, за да пестите мобилни данни и да ускорите зареждането. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/oversized-images)."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Оразмерете изображенията правилно"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"При показването на текстови ресурси трябва да се използва компресиране (gzip, deflate или brotli), за да се намали общият пренос на данни. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/text-compression)."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Активирайте компресирането на текста"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Графичните формати, като JPEG 2000, JPEG XR и WebP, често осигуряват по-ефективно компресиране от PNG или JPEG. Това означава по-бързо изтегляне и използване на по-малко данни. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/webp)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Използвайте съвременни формати за показване на изображения"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"Веригите от критични заявки по-долу ви показват кои ресурси се зареждат с висок приоритет. За да ускорите зареждането на страницата, препоръчваме да скъсите веригите, да намалите размера за изтегляне на ресурсите или да отложите изтеглянето на ненужните от тях. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{Намерена е 1 верига}other{Намерени са # вериги}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Намалете дълбочината на критичните заявки"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Браузърните инженери препоръчват страниците да съдържат под ~ 1500 възела на DOM. Най-добре е йерархичната структура да е с дълбочина под 32 елемента и всеки родителски елемент да има по-малко от 60 дъщерни. Големият размер на DOM може да доведе до използване на повече памет, удължаване на [стиловите изчисления](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations) и забавяне поради [преоформяне](https://developers.google.com/speed/articles/reflow). [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/dom-size)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 възел}other{# възела}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Не използвайте DOM с твърде голям размер"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Максимална дълбочина на DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Общ брой възли на DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Не се използва DOM с твърде голям размер"},"lighthouse-core/audits/font-display.js | description":{"message":"Използвайте функцията font-display на CSS, така че текстът да е видим за потребителите при зареждането на уеб шрифтовете. [Научете повече](https://developers.google.com/web/updates/2016/02/font-display)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Уверете се, че текстът остава видим при зареждането на уеб шрифтовете"},"lighthouse-core/audits/font-display.js | title":{"message":"Целият текст остава видим при зареждането на уеб шрифтовете"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Категория"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Препоръчваме да намалите времето, прекарвано в синтактичен анализ, компилиране и изпълнение на JS. Използването на JS ресурси с по-малък размер може да помогне за това."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Сведете до минимум работата по основната нишка"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Работата по основната нишка е сведена до минимум"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"Резултатът по-горе показва приблизително колко време (в милисекунди) е необходимо на приложението ви, за да реагира на входящо потребителско действие по време на най-натоварения 5-секунден период от зареждането на страницата. Ако забавянето е над 50 мсек, приложението ви може да се стори бавно на потребителите. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Прогнозно забавяне при входящо действие"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"Показателят „Първо изобразяване на съдържание (FCP)“ указва след колко време се изобразява първият текстов или графичен елемент. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"Първо изобразяване на съдържание"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"Показателят „Първи момент на неактивност на процесора“ указва първия момент, в който основната нишка на страницата е достатъчно свободна, за да обработва входящи действия. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/first-interactive)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"Първи момент на неактивност на процесора"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"Показателят „Първо значимо изобразяване“ измерва времето, за което основното съдържание на страницата става видимо. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"Първо значимо изобразяване"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"Показателят „Време до интерактивност“ указва колко време отнема постигането на пълна интерактивност за страницата. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Време до интерактивност"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"Индексът на скоростта показва колко бързо се постига визуална завършеност на страницата. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/speed-index)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Индекс на скоростта"},"lighthouse-core/audits/redirects.js | description":{"message":"Пренасочванията водят до допълнително забавяне на зареждането на страницата. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/redirects)."},"lighthouse-core/audits/redirects.js | title":{"message":"Не използвайте пренасочвания през няколко страници"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"Показателят „Време до първия байт“ указва след колко време сървърът изпраща отговор. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/ttfb)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"Основният документ отне {timeInMs, number, milliseconds} мсек"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Намалете времето за отговор от сървъра (време до първия байт)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Сървърът отговаря бързо (време до първия байт)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Продължителност"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Име"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Начален час"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Тип"},"lighthouse-core/audits/user-timings.js | description":{"message":"Препоръчваме да използвате API за разбивка на потребителските времена за приложението си, за да измервате действителната му ефективност по време на ключови аспекти от практическата работа на потребителите. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 потребителско време}other{# потребителски времена}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"Точки и измервания в разбивката на потребителските времена"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Препоръчваме да добавите подсказки за предварително свързване или предварително извличане на DNS за ресурсите с цел ранно установяване на връзка с важни източници на трети страни. [Научете повече](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"Осигурете предварително свързване с необходимите източници"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Препоръчваме да използвате <link rel=preload>, за да укажете най-напред да се извличат ресурсите, които понастоящем се заявяват на по-късен етап от зареждането на страницата. [Научете повече](https://developers.google.com/web/tools/lighthouse/audits/preload)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Задайте ключовите заявки да се зареждат предварително"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"Повече информация за ефективността на приложението ви."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Диагностика"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"Най-критичният аспект на ефективността е времето, за което пикселите се изобразяват на екрана. Ключови показатели: първо изобразяване на съдържание, първо значимо изобразяване"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"Подобрения, свързани с първото изобразяване"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"Тези оптимизации могат да ускорят зареждането на страницата."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Възможности"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Показатели"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Подобрете зареждането като цяло, така че страницата да реагира бързо и да е готова за използване възможно най-скоро. Ключови показатели: време до интерактивност, индекс на скоростта"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Цялостни подобрения"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Ефективност"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"Време на валидност на кеша"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Размер (КБ)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Прекарано време"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"URL адрес"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Потенциална икономия (КБ)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Потенциална икономия (мсек)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Потенциално спестяване на {wastedBytes, number, bytes} КБ"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Потенциално спестяване на {wastedMs, number, milliseconds} мсек"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} мсек"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} сек"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Показване на проверките"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Първоначална навигация"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Максимално забавяне в критичния път:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Грешка!"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Грешка в отчета: няма информация за проверката"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Данни от контролиран тест"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"Анализът с [Lighthouse](https://developers.google.com/web/tools/lighthouse/) на текущата страница бе извършен през емулирана 3G връзка. Стойностите са прогнозни и може да варират."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Допълнителни елементи, които да проверите ръчно"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"Не е приложимо"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Възможност"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Прогнозна икономия"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Успешно преминати проверки"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Скала на резултата:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"Възникнаха проблеми при изготвянето на този отчет от Lighthouse:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Стойностите са прогнозни и може да варират."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Предупреждения: "}};},{}],41:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Les extensions de Chrome han afectat negativament el rendiment de càrrega de la pàgina. Audita la pàgina en mode d'incògnit o des d'un perfil de Chrome sense extensions."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Avaluació de scripts"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Anàlisi de scripts"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Total"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Et recomanem que redueixis el temps dedicat a analitzar, compilar i executar JavaScript. Et pot ajudar utilitzar càrregues útils de JavaScript més petites. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Redueix el temps d'execució de JavaScript"},"lighthouse-core/audits/bootup-time.js | title":{"message":"Temps d'execució de JavaScript"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Els GIF grans no són eficients a l'hora de publicar contingut animat. Per estalviar bytes de la xarxa, pots substituir-los per vídeos MPEG4/WebM en el cas d'animacions i per PNG/WebP en el cas d'imatges estàtiques. [Més informació] (https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Utilitza formats de vídeo per al contingut animat"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Et recomanem que utilitzis la càrrega diferida de les imatges ocultes i que no es mostren a la pantalla un cop s'acabin de carregar tots els recursos crítics a fi de reduir el temps necessari perquè la pàgina sigui interactiva. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Ajorna les imatges fora de pantalla"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Els recursos estan bloquejant la primera renderització de la pàgina. Et recomanem que publiquis els fitxers JavaScript o CSS inserits i ajornis tots els estils i els fitxers JavaScript que no siguin crítics. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Elimina els recursos que bloquegen la renderització"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Si la càrrega útil de la xarxa és molt gran, els usuaris consumeixen més dades mòbils i els temps de càrrega són més llargs. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/network-payloads)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Mida total: {totalBytes, number, bytes} kB"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Evita càrregues útils de xarxa enormes"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Evita càrregues útils de xarxa enormes"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Reduir els fitxers CSS pot disminuir les mides de càrrega útil a la xarxa. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/minify-css)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"Redueix els CSS"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Reduir els fitxers JavaScript pot disminuir les mides de càrrega i els temps d'anàlisi de scripts. [Més informació] (https://developers.google.com/speed/docs/insights/MinifyResources)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"Redueix els fitxers JavaScript"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Suprimeix dels fulls d'estil les regles que no s'utilitzen per reduir els bytes que es consumeixen de manera innecessària durant l'activitat de la xarxa. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/unused-css)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Ajorna els CSS no utilitzats"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Suprimeix els fitxers JavaScript que no s'utilitzen per reduir els bytes que es consumeixen durant l'activitat de la xarxa."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Suprimeix els fitxers JavaScript no utilitzats"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"Si la memòria cau té una vida llarga, es poden accelerar les visites repetides a la teva pàgina. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/cache-policy)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{S'ha trobat 1 recurs}other{S'han trobat # recursos}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Publica recursos estàtics amb una política de memòria cau eficient"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Utilitza una política de memòria cau eficient per als recursos estàtics"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Les imatges optimitzades es carreguen més ràpidament i utilitzen menys dades mòbils. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/optimize-images)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Codifica les imatges amb eficiència"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Publica imatges amb la mida correcta per estalviar dades mòbils i millorar el temps de càrrega. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/oversized-images)."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Adapta la mida de les imatges"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"Els recursos basats en text s'han de publicar comprimits (gzip, deflate o brotli) per minimitzar el total de bytes a la xarxa. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/text-compression)."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Activa la compressió de text"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Els formats d'imatge com JPEG 2000, JPEG XR i WebP solen oferir millors resultats de compressió que PNG o JPEG. Això implica baixades més ràpides i menys consum de dades. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/webp)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Publica imatges en format d'última generació"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"Les cadenes de sol·licituds crítiques de sota et mostren quins recursos es carreguen amb prioritat alta. Et recomanem que escurcis les cadenes, redueixis la mida de baixada dels recursos o ajornis la baixada de recursos innecessaris per millorar la càrrega de pàgines. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{S'ha trobat 1 cadena}other{S'han trobat # cadenes}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Minimitza la profunditat de les sol·licituds crítiques"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Els enginyers de navegadors recomanen que les pàgines continguin menys d'uns 1.500 nodes de DOM. La situació ideal és una profunditat d'arbre inferior a 32 elements i menys de 60 elements superiors o secundaris. Un DOM gran pot augmentar l'ús de la memòria, provocar [càlculs d'estil] més llargs (https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations) i produir costosos [reinicis de reflux del disseny] (https://developers.google.com/speed/articles/reflow). [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/dom-size)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 node}other{# nodes}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Evita una mida de DOM excessiva"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Profunditat màxima de DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Total de nodes de DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Evita una mida excessiva de DOM"},"lighthouse-core/audits/font-display.js | description":{"message":"Aprofita la funció CSS que permet mostrar els tipus de lletra per assegurar-te que els usuaris puguin veure el text mentre es carreguen els tipus de lletra per a llocs web. [Més informació] (https://developers.google.com/web/updates/2016/02/font-display)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Assegura't que el text continuï visible durant la càrrega dels tipus de lletra per a llocs web"},"lighthouse-core/audits/font-display.js | title":{"message":"Tot el text continua visible durant les càrregues dels tipus de lletra per a llocs web"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Categoria"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Et recomanem que redueixis el temps dedicat a analitzar, compilar i executar JavaScript. Et pot ajudar utilitzar càrregues útils de JavaScript més petites."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Minimitza el treball al fil principal"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Minimitza el treball al fil principal"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"La puntuació de més amunt és una estimació de quant tarda en mil·lisegons la teva aplicació a respondre a una acció de l'usuari durant el període de 5 segons amb més càrregues de pàgines. Si la latència és superior a 50 ms, és possible que els usuaris considerin que l'aplicació és lenta. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Latència estimada de les accions"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"La primera renderització de contingut marca el moment en què es renderitza el primer text o la primera imatge. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"Primera renderització de contingut"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"La mètrica Primera inactivitat de la CPU marca el primer moment en què el fil principal de la pàgina està suficientment inactiu per gestionar accions. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/first-interactive)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"Primera inactivitat de la CPU"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"La mètrica Primera renderització significativa mesura el moment en què el contingut principal d'una pàgina està visible. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"Primera renderització significativa"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"La mètrica Temps fins que és interactiva marca el moment en què la pàgina és completament interactiva. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Temps fins que és interactiva"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"L'índex de velocitat mostra la rapidesa amb què s'emplena el contingut d'una pàgina. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/speed-index)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Índex de velocitat"},"lighthouse-core/audits/redirects.js | description":{"message":"La mètrica Redireccions introdueix retards addicionals abans de poder carregar la pàgina. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/redirects)."},"lighthouse-core/audits/redirects.js | title":{"message":"Evita les redireccions múltiples a pàgines"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"La mètrica Temps fins al primer byte identifica el moment en què el teu servidor envia una resposta. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/ttfb)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"El document arrel ha tardat {timeInMs, number, milliseconds} ms"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Redueix els temps de resposta del servidor (TTFB)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Els temps de resposta del servidor són baixos (TTFB)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Durada"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Nom"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Hora d'inici"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Tipus"},"lighthouse-core/audits/user-timings.js | description":{"message":"Et recomanem que utilitzis l'API Temps d'usuari amb la teva aplicació per mesurar-ne el rendiment al món real durant experiències clau dels usuaris. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 temps d'usuari}other{# temps d'usuari}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"Marques i mesures de Temps d'usuari"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Et recomanem que afegeixis suggeriments de recursos per connectar-se prèviament o per obtenir el DNS prèviament a fi d'establir connexions anticipades a orígens importants de tercers. [Més informació] (https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"Connecta't prèviament als orígens necessaris"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Et recomanem que utilitzis <link rel=preload> per prioritzar l'obtenció de recursos que en aquests moments se sol·liciten en un moment posterior de la càrrega de pàgines. [Més informació] (https://developers.google.com/web/tools/lighthouse/audits/preload)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Carrega prèviament les sol·licituds de clau"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"Més informació sobre el rendiment de la teva aplicació."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Diagnòstic"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"L'aspecte més crític del rendiment és la velocitat amb què es renderitzen els píxels en pantalla. Mètriques clau: Primera renderització de contigut, Primera renderització significativa"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"Millores de la primera renderització"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"Aquestes optimitzacions poden accelerar la càrrega de la pàgina."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Oportunitats"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Mètriques"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Millora l'experiència general de càrrega, de manera que la pàgina respongui i estigui preparada per utilitzar-se al més aviat possible. Mètriques clau: Temps fins que és interactiva, Índex de velocitat"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Millores generals"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Rendiment"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"TTL de la memòria cau"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Mida (kB)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Temps invertit"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"URL"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Possible estalvi (kB)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Possible estalvi (ms)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Possible estalvi de {wastedBytes, number, bytes} kB"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Possible estalvi de {wastedMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} s"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Mostra les auditories"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Navegació inicial"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Latència de camí crítica màxima:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Error"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Error de l'informe: no hi ha informació d'auditoria"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Dades de laboratori"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"Anàlisi amb [Lighthouse] (https://developers.google.com/web/tools/lighthouse/) de la pàgina actual mitjançant una connexió 3G emulada. Els valors són estimacions i poden variar."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Elements addicionals per comprovar manualment"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"No aplicable"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Oportunitat"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Estalvi estimat"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Auditories aprovades"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Escala de puntuació:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"Hi ha hagut problemes que afecten aquesta execució de Lighthouse:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Els valors són estimacions i poden variar."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Advertiments: "}};},{}],42:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Rychlost načítání této stránky byla negativně ovlivněna rozšířeními pro Chrome. Zkuste stránku zkontrolovat v anonymním režimu nebo profilu Chromu bez rozšíření."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Vyhodnocování skriptů"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Analýza skriptů"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Celkem"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Pokuste se zkrátit dobu analyzování, kompilování a spouštění JavaScriptu. Mohlo by pomoci odesílat menší soubory JavaScript. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Zkraťte dobu provádění JavaScriptu"},"lighthouse-core/audits/bootup-time.js | title":{"message":"Doba provádění JavaScriptu"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Velké soubory GIF nejsou efektivní k zobrazování animovaného obsahu. Zvažte, zda byste namísto souborů GIF nemohli pro animace použít videa MPEG4/WebM a pro statické obrázky soubory PNG/WebP. Snížíte tak množství přenášených dat. [Další informace](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Pro animovaný obsah používejte formáty videa"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Zvažte možnost načítat obrázky mimo obrazovku a skryté obrázky „líně“ až po načtení všech kritických zdrojů, abyste zkrátili dobu k dosažení interaktivnosti. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Odložte načítání obrázků mimo obrazovku"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"První vykreslení stránky blokují zdroje. Zvažte, zda byste kriticky důležité zdroje JavaScript a CSS nemohli poskytovat přímo v kódu a stahování veškerého nekritického JavaScriptu a stylů odložit. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Eliminujte zdroje, které blokují vykreslení"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Přenášení velkého množství dat po síti je pro uživatele finančně nákladné a obvykle vede k pomalému načítání. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/network-payloads)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Celková velikost byla {totalBytes, number, bytes} kB"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Předejděte přenášení enormního množství dat"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Nepřenáší enormní množství dat"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Minifikací souborů CSS lze snížit množství přenášených dat. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/minify-css)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"Minifikujte kód CSS"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Minifikací souborů JavaScript lze snížit množství přenášených dat a zrychlit analýzu skriptů. [Další informace](https://developers.google.com/speed/docs/insights/MinifyResources)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"Minifikujte JavaScript"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Odstraňte z tabulek stylů nepoužívaná pravidla, abyste snížili množství přenášených nepotřebných dat. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/unused-css)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Odložte načítání nevyužitých stylů CSS"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Odstraněním nepoužívaného JavaScriptu zmenšíte množství přenášených dat."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Odstraňte nepoužívaný JavaScript"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"Dlouhá platnost mezipaměti může zrychlit opakované návštěvy stránky. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/cache-policy)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{Byl nalezen 1 zdroj}few{Byly nalezeny # zdroje}many{Bylo nalezeno # zdroje}other{Bylo nalezeno # zdrojů}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Statické podklady zobrazujte s efektivními zásadami pro mezipaměť"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Používá u statických podkladů efektivní zásady pro mezipaměť"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Optimalizované obrázky se načítají rychle a spotřebovávají méně mobilních dat. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/optimize-images)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Používejte efektivní kódování obrázků"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Zobrazujte obrázky s vhodnou velikostí, abyste ušetřili mobilní data a zrychlili načítání. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/oversized-images)."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Používejte správnou velikost obrázků"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"Textové zdroje by se měly odesílat komprimované (gzip, deflate nebo brotli), aby se minimalizovalo množství přenášených dat. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/text-compression)."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Zapněte kompresi textu"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Formáty obrázků JPEG 2000, JPEG XR a WebP často poskytují lepší kompresi než formáty PNG a JPEG, což znamená rychlejší stahování a menší spotřebu dat. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/webp)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Zobrazujte obrázky ve formátech nové generace"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"Řetězce kritických požadavků níže ukazují, které zdroje se načítají s vysokou prioritou. Zvažte, zda byste načítání stránky nemohli vylepšit tím, že řetězce zkrátíte, zmenšíte zdroje nebo odložíte stahování zdrojů, které nejsou nezbytné. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{Byl nalezen 1 řetězec}few{Byly nalezeny # řetězce}many{Bylo nalezeno # řetězce}other{Bylo nalezeno # řetězců}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Minimalizujte hloubku kritických požadavků"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Vývojáři prohlížečů doporučují, aby stránky obsahovaly méně než cca. 1 500 uzlů modelu DOM. Ideálně by hloubka stromu měla být menší než 32 prvků a každý nadřazený prvek by měl mít méně než 60 podřízených prvků. Velký model DOM může vést k většímu využití paměti, delším [výpočtům stylů](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations) a náročným [přeformátováváním rozvržení](https://developers.google.com/speed/articles/reflow). [Další informace](https://developers.google.com/web/tools/lighthouse/audits/dom-size)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 uzel}few{# uzly}many{# uzlu}other{# uzlů}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Nepoužívejte příliš velký model DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Maximální hloubka modelu DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Celkový počet uzlů v modelu DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Nepoužívá příliš velký model DOM"},"lighthouse-core/audits/font-display.js | description":{"message":"Pomocí funkce font-display stylů CSS zajistěte, aby byl text při načítání webfontů viditelný uživatelům. [Další informace](https://developers.google.com/web/updates/2016/02/font-display)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Zajistěte, aby text při načítání webfontů zůstal viditelný"},"lighthouse-core/audits/font-display.js | title":{"message":"Při načítání webfontů zůstává veškerý text viditelný"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Kategorie"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Pokuste se zkrátit dobu analyzování, kompilování a spouštění JavaScriptu. Mohlo by pomoci odesílat menší soubory JavaScript."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Minimalizujte práci v hlavním podprocesu"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Minimalizuje práci v hlavním podprocesu"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"Výše uvedené skóre je odhad (v milisekundách), jak rychle bude aplikace během nejvytíženějších pěti sekund načítání stránky reagovat na vstup uživatele. Pokud je latence větší než 50 ms, mohou uživatelé chování aplikace vnímat jako přerušované. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Odhadovaná latence vstupu"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"První vykreslení obsahu je okamžik vykreslení prvního textu nebo obrázku. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"První vykreslení obsahu"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"První nečinnost procesoru udává čas, kdy je hlavní podproces stránky dostatečně nečinný na to, aby bylo možné zpracovat vstup. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/first-interactive)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"První nečinnost procesoru"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"První smysluplné vykreslení udává, kdy začne být viditelný primární obsah stránky. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"První smysluplné vykreslení"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"Interaktivitou se označuje čas, kdy je stránka plně interaktivní. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Doba do interaktivity"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"Index rychlosti ukazuje, jak rychle se viditelně vyplní obsah stránky. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/speed-index)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Index rychlosti"},"lighthouse-core/audits/redirects.js | description":{"message":"Přesměrování způsobují další prodlevy před načtením stránky. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/redirects)."},"lighthouse-core/audits/redirects.js | title":{"message":"Nepoužívejte několik přesměrování stránky"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"Doba do načtení prvního bajtu udává, jak dlouho vašemu serveru trvá, než odešle odpověď. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/ttfb)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"Hlavní dokument trval {timeInMs, number, milliseconds} ms"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Zkraťte doby odezvy serverů (TTFB)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Doby odezvy serveru jsou krátké (TTFB)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Trvání"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Název"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Čas zahájení"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Typ"},"lighthouse-core/audits/user-timings.js | description":{"message":"Zkuste v aplikaci pomocí rozhraní User Timing API implementovat měření reálného výkonu při událostech zásadních pro uživatelský dojem. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 časování uživatelů}few{# časování uživatelů}many{# časování uživatelů}other{# časování uživatelů}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"Hodnoty časování uživatelů"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Zvažte přidání signálů pro předběžné připojení nebo načtení, aby bylo možné včas se připojit k důležitým zdrojům třetích stran. [Další informace](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"K potřebným zdrojům se připojujte předem"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Zvažte použití značky <link rel=preload> k prioritnímu načtení zdrojů, o které se nyní žádá později během načítání stránky. [Další informace](https://developers.google.com/web/tools/lighthouse/audits/preload)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Klíčové požadavky načítejte předběžně"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"Další informace o výkonu vaší aplikace."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Diagnostika"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"Nejkritičtějším aspektem výkonu je rychlost vykreslení pixelů na obrazovce. Klíčové metriky: První vykreslení obsahu, První smysluplné vykreslení"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"Vylepšení prvního vykreslení"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"Tyto optimalizace mohou zrychlit načítání vaší stránky."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Příležitosti"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Metriky"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Vylepšete celkové chování při načítání, aby byla stránka co nejdříve responzivní a připravena k používání. Klíčové metriky: Doba dosažení interaktivity, Index rychlosti"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Celková vylepšení"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Výkon"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"Hodnota TTL (Time to Live) mezipaměti"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Velikost (kB)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Strávený čas"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"URL"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Možná úspora (kB)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Možná úspora (ms)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Lze uspořit {wastedBytes, number, bytes} kB"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Lze uspořit {wastedMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} s"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Zobrazit audity"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Počáteční navigace"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Maximální latence kritické trasy:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Chyba!"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Chyba přehledu: žádné informace o auditu"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Laboratorní data"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"Analýza aktuální stránky nástrojem [Lighthouse](https://developers.google.com/web/tools/lighthouse/) při emulovaném připojení 3G. Hodnoty jsou odhady a mohou být proměnlivé."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Další položky k ruční kontrole"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"Není relevantní"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Příležitost"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Odhadovaná úspora"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Úspěšné audity"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Škála skóre:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"Při tomto spuštění nástroje Lighthouse se vyskytly problémy:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Hodnoty jsou odhady a mohou se lišit."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Upozornění: "}};},{}],43:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Chrome-udvidelser påvirkede denne sides indlæsning negativt. Prøv at revidere siden i inkognitotilstand eller fra en Chrome-profil uden udvidelser."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Scriptevaluering"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Scriptparsing"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"I alt"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Overvej at reducere den tid, der bruges på at parse, kompilere og udføre JavaScript. Levering af mindre JavaScript-datapakker kan hjælpe med dette. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Reducer udførelsestiden for JavaScript"},"lighthouse-core/audits/bootup-time.js | title":{"message":"Udførelsestid for JavaScript"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Store giffer er ikke tilstrækkelige til at levere animeret indhold. Overvej at bruge MPEG4-/WebM-videoer til animationer og PNG/WebP til statiske billeder i stedet for giffer for at spare netværksbytes. [Få flere oplysninger](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Brug videoformater til animeret indhold"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Overvej at udskyde indlæsningen af skjulte billeder og billeder, der ikke er på skærmen, til efter alle kritiske ressourcer er blevet indlæst for at reducere den tid, der går, inden siden er interaktiv. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Udskyd billeder, der ikke er på skærmen"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Ressourcer blokerer første udfyldning af din side. Overvej at levere kritisk JavaScript/CSS indlejret og udskyde alle ikke-kritiske JavaScript-elementer/typografier. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Fjern ressourcer til blokering af gengivelse"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Store datapakker på netværk koster brugerne mange penge og er forbundet med lang indlæsningstid. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/network-payloads)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Den samlede størrelse var {totalBytes, number, bytes} kB"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Undgå kæmpe datapakker på netværk"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Undgår kæmpe datapakker på netværk"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Formindskelse af CSS-filer kan reducere størrelsen på datapakker på netværk. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/minify-css)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"Formindsk CSS"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Formindskelse af JavaScript-filer kan reducere størrelsen på datapakker og varigheden af scriptparsing. [Få flere oplysninger](https://developers.google.com/speed/docs/insights/MinifyResources)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"Formindsk JavaScript"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Fjern regler, som ikke bruges, fra typografiark for at skære ned på antallet af unødvendige bytes, der anvendes ved netværksaktivitet. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/unused-css)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Udskyd CSS, som ikke bruges"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Fjern JavaScript, der ikke bruges, for at skære ned på antallet af bytes, der anvendes ved netværksaktivitet."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Fjern JavaScript, som ikke bruges"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"En lang cachelevetid kan gøre indlæsningen hurtigere for tilbagevendende besøgende på din side. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/cache-policy)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{Der blev fundet 1 ressource}one{Der blev fundet # ressource}other{Der blev fundet # ressourcer}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Vis statiske aktiver med en effektiv cachepolitik"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Anvender effektiv cachepolitik på statiske aktiver"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Optimerede billeder indlæses hurtigere og bruger mindre mobildata. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/optimize-images)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Kryptér billeder effektivt"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Vis billeder i korrekte størrelser for at spare mobildata og forbedre indlæsningstiden. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/oversized-images)."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Brug korrekte billedstørrelser"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"Tekstbaserede ressourcer bør vises i komprimeret format (gzip, Deflate eller Brotli), så netværkets samlede antal bytes formindskes. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/text-compression)."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Aktivér tekstkomprimering"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Billedformater såsom JPEG 2000, JPEG XR og WebP giver ofte en bedre komprimering end PNG og JPEG, hvilket betyder hurtigere downloads og mindre dataforbrug. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/webp)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Vis billeder i formater af næste generation"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"Kæderne med kritiske anmodninger nedenfor viser dig, hvilke ressourcer der indlæses med høj prioritet. Du kan også vælge at reducere kædernes længde, så ressourcernes downloadstørrelse bliver mindre, eller at udskyde download af unødvendige ressourcer, så sideindlæsningen forbedres. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{Der blev fundet 1 kæde}one{Der blev fundet # kæde}other{Der blev fundet # kæder}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Minimer dybden for kritiske anmodninger"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Browserudviklere anbefaler, at sider højst indeholder 1.500 DOM-noder. Det bedste er en træstrukturdybde med under 32 elementer og mindre end 60 underordnede/overordnede elementer. En stor DOM kan øge hukommelsesforbruget, medføre længere [beregninger af typografi](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations) og producere dyre [omformateringer af layout](https://developers.google.com/speed/articles/reflow). [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/dom-size)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 node}one{# node}other{# noder}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Undgå en overdreven DOM-størrelse"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Maksimal DOM-dybde"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Samlet antal DOM-noder"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Undgår en overdreven DOM-størrelse"},"lighthouse-core/audits/font-display.js | description":{"message":"Udnyt CSS-funktionen til skrifttypevisning for at sikre dig, at teksten kan ses af brugerne, mens webfonts indlæses. [Få flere oplysninger](https://developers.google.com/web/updates/2016/02/font-display)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Sørg for, at tekst forbliver synlig under indlæsning af webfont"},"lighthouse-core/audits/font-display.js | title":{"message":"Al tekst forbliver synlig under indlæsning af webfont"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Kategori"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Overvej at reducere den tid, der bruges på at parse, kompilere og udføre JavaScript. Levering af mindre JavaScript-datapakker kan hjælpe med dette."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Formindsk primært trådarbejde"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Formindsker primært trådarbejde"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"Resultatet ovenfor er et estimat af, hvor længe din app er om at svare på brugerinput (i millisekunder) i de første 5 travleste sekunder med vindue under en sideindlæsning. Hvis din forsinkelse er større end 50 ms, kan brugerne opfatte din app som langsom. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Estimeret inputforsinkelse"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"Første udfyldning af indhold markerer tidspunktet, hvor den første tekst eller det første billede udfyldes. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"Første udfyldning af indhold"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"Første stillestående CPU markerer det tidspunkt, hvor sidens primære tråd er stabil nok til at behandle input. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/first-interactive)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"Første stillestående CPU"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"Første betydningsfulde udfyldning måler, hvornår det primære indhold på en side kan ses. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"Første betydningsfulde udfyldning"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"Interaktiv tilstand markerer det tidspunkt, hvor siden er helt interaktiv. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Tid inden interaktiv tilstand"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"Hastighedsindekset viser, hvor hurtigt indholdet på en side udfyldes, så det kan ses. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/speed-index)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Hastighedsindeks"},"lighthouse-core/audits/redirects.js | description":{"message":"Omdirigeringer medfører yderligere forsinkelser, inden siden kan indlæses. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/redirects)."},"lighthouse-core/audits/redirects.js | title":{"message":"Undgå mange sideomdirigeringer"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"TTFB (Time To First Byte) identificerer tidspunktet for, hvornår din server sender et svar. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/ttfb)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"Roddokumentet tog {timeInMs, number, milliseconds} ms"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Reducer serversvartider (TTFB, Time To First Byte)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Serversvartiderne er korte (TTFB, Time To First Byte)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Varighed"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Navn"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Starttidspunkt"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Type"},"lighthouse-core/audits/user-timings.js | description":{"message":"Du kan også vælge at bruge User Timing API som værktøj til din app for at måle appens effektivitet i den virkelige verden i forbindelse med vigtige brugeroplevelser. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 brugstid}one{# brugstid}other{# brugstider}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"Brugstider markerer og måler"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Overvej at tilføje ressourcehints til forbindelse på forhånd eller DNS-forudhentning for at oprette tidlige forbindelser til vigtige tredjepartswebsites. [Få flere oplysninger](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"Opret forbindelse på forhånd til påkrævede websites"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Overvej at bruge <link rel=preload> til at prioritere hentning af ressourcer, som der i øjeblikket anmodes om senere i sideindlæsningen. [Få flere oplysninger](https://developers.google.com/web/tools/lighthouse/audits/preload)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Forudindlæs vigtige anmodninger"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"Få flere oplysninger om din apps effektivitet."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Diagnostik"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"Det vigtigste aspekt af effektivitet er, hvor hurtigt pixels gengives på skærmen. Vigtige metrics: Første udfyldning af indhold, Første betydningsfulde udfyldning"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"Forbedringer af første udfyldning"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"Disse optimeringer kan gøre din sideindlæsning hurtigere."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Muligheder"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Metrics"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Gør den overordnede indlæsning bedre, så siden hurtigst muligt bliver responsiv og klar til brug. Vigtige metrics: Tid inden interaktiv tilstand, Hastighedsindeks"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Overordnede forbedringer"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Effektivitet"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"Cache-TTL"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Størrelse (kB)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Tidsforbrug"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"Webadresse"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Potentiel databesparelse (kB)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Potentiel tidsbesparelse (ms)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Potentiel databesparelse på {wastedBytes, number, bytes} kB"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Potentiel tidsbesparelse på {wastedMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} sek."},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Se revisioner"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Indledende navigation"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Maksimal forsinkelse for kritisk sti:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Der opstod en fejl"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Rapportfejl: Der er ingen revisionsoplysninger"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Laboratoriedata"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[Lighthouse](https://developers.google.com/web/tools/lighthouse/)-analyse af den aktuelle side på et emuleret 3G-netværk. Værdierne er estimerede og kan variere."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Yderligere elementer, der skal tjekkes manuelt"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"Ikke relevant"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Mulighed"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Estimeret tidsbesparelse"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Beståede revisioner"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Resultatskala:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"Der blev registreret problemer, som påvirkede denne kørsel af Lighthouse:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Værdierne er estimater og kan variere."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Advarsler! "}};},{}],44:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Chrome-Erweiterungen haben die Ladegeschwindigkeit dieser Seite beeinträchtigt. Versuchen Sie, die Seite im Inkognito-Modus oder mit einem Chrome-Profil ohne Erweiterungen zu überprüfen."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Skriptauswertung"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Parsen von Skripten"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Gesamt"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Versuchen Sie, die Zeit für das Parsen, Kompilieren und Ausführen von JS zu reduzieren. Die Bereitstellung kleinerer JS-Nutzlasten kann dabei helfen. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Ausführungszeit von JavaScript reduzieren"},"lighthouse-core/audits/bootup-time.js | title":{"message":"JavaScript-Ausführungszeit"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Große GIF-Dateien sind nur bedingt für die Bereitstellung animierter Inhalte geeignet. Sie können statt GIF MPEG4- oder WebM-Videos für Animationen und PNG oder WebP für statische Bilder verwenden und so die Netzwerk-Datenmenge reduzieren. [Weitere Informationen](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Videoformate für animierte Inhalte verwenden"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Versuchen Sie, nicht sichtbare und versteckte Bilder erst laden zu lassen, nachdem wichtige Ressourcen geladen wurden, um die Zeit bis zur Interaktivität zu reduzieren. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Nicht sichtbare Bilder aufschieben"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Ressourcen blockieren das erste Zeichnen Ihrer Seite. Versuchen Sie, wichtiges JS und wichtige CSS inline bereitzustellen und alle nicht kritischen JS und Stile aufzuschieben. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Ressourcen beseitigen, die das Rendering blockieren"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Große Netzwerknutzlasten kosten Nutzer bares Geld und hängen eng mit langen Ladezeiten zusammen. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/network-payloads)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Die Gesamtgröße war {totalBytes, number, bytes} KB"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Sehr große Netzwerknutzlasten vermeiden"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Vermeidet sehr große Netzwerknutzlasten"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Durch die Komprimierung von CSS-Dateien kann die Größe von Netzwerknutzlasten reduziert werden. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/minify-css)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"CSS komprimieren"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Durch die Komprimierung von JavaScript-Dateien können Nutzlastgrößen und die Zeit zum Parsen von Skripts reduziert werden. [Weitere Informationen](https://developers.google.com/speed/docs/insights/MinifyResources)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"JavaScript komprimieren"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Entfernen Sie nicht verwendete Regeln aus Stylesheets, um unnötige Daten bei Netzwerkaktivitäten zu reduzieren. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/unused-css)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Nicht verwendete CSS aufschieben"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Entfernen Sie nicht verwendetes JavaScript, um die Datenmenge bei Netzwerkaktivitäten zu reduzieren."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Nicht genutztes JavaScript entfernen"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"Eine lange Lebensdauer des Cache kann wiederholte Besuche Ihrer Seite beschleunigen. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/cache-policy)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{1 Ressource gefunden}other{# Ressourcen gefunden}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Statische Inhalte mit einer effizienten Cache-Richtlinie bereitstellen"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Verwendet eine effiziente Cache-Richtlinie für statische Inhalte"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Optimierte Bilder werden schneller geladen und verbrauchen weniger mobile Daten. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/optimize-images)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Bilder effizient codieren"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Stellen Sie Bilder bereit, die eine angemessene Größe haben, um mobile Daten zu sparen und die Ladezeit zu verbessern. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/oversized-images)"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Bilder richtig dimensionieren"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"Textbasierte Ressourcen sollten mit Komprimierung (gzip, Deflate oder Brotli) bereitgestellt werden, um die Datenmenge im Netzwerk insgesamt zu minimieren. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/text-compression)"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Textkomprimierung aktivieren"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Bildformate wie JPEG 2000, JPEG XR und WebP bieten oft eine bessere Komprimierung als PNG oder JPEG, was schnellere Downloads und einen geringeren Datenverbrauch ermöglicht. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/webp)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Bilder in modernen Formaten bereitstellen"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"In den unten aufgeführten Ketten kritischer Anfragen können Sie sehen, welche Ressourcen mit einer hohen Priorität geladen werden. Versuchen Sie, die Ketten zu verkürzen, die Downloadgröße von Ressourcen zu reduzieren oder das Herunterladen unnötiger Ressourcen aufzuschieben, um den Seitenaufbau zu beschleunigen. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{1 Kette gefunden}other{# Ketten gefunden}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Tiefe kritischer Anforderungen minimieren"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Laut der Empfehlung von Browserentwicklern sollten Seiten nicht mehr als ungefähr 1.500 DOM-Knoten enthalten. Die ideale Strukturtiefe liegt bei unter 32 Elementen und weniger als 60 unter- und übergeordneten Elementen. Ein großes DOM kann zu hohem Speicherverbrauch, langwierigen [Stilberechnungen](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations) und kostspieligen [dynamischen Umbrüchen im Layout](https://developers.google.com/speed/articles/reflow) führen. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/dom-size)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 Knoten}other{# Knoten}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Übermäßige DOM-Größe vermeiden"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Maximale DOM-Tiefe"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Gesamtzahl der DOM-Knoten"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Vermeidet eine übermäßige DOM-Größe"},"lighthouse-core/audits/font-display.js | description":{"message":"Sie können Gebrauch von der CSS-Funktion \"font-display\" machen, um sicherzugehen, dass der Text für Nutzer sichtbar ist, während Webfonts geladen werden. [Weitere Informationen](https://developers.google.com/web/updates/2016/02/font-display)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Darauf achten, dass der Text während der Webfont-Ladevorgänge sichtbar bleibt"},"lighthouse-core/audits/font-display.js | title":{"message":"Der gesamte Text bleibt während der Webfont-Ladevorgänge sichtbar"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Kategorie"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Versuchen Sie, die Zeit für das Parsen, Kompilieren und Ausführen von JS zu reduzieren. Die Bereitstellung kleinerer JS-Nutzlasten kann dabei helfen."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Aufwand für Hauptthread minimieren"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Minimiert den Aufwand für den Hauptthread"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"Beim Ergebnis oben handelt es sich um eine Schätzung dessen, wie viele Millisekunden Ihre App benötigt, um während des 5-s-Fensters mit der stärksten Auslastung beim Seitenaufbau auf Nutzereingaben zu reagieren. Wenn die Latenz bei Ihnen über 50 ms liegt, empfinden Nutzer Ihre App möglicherweise als langsam. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Geschätzte Eingabelatenz"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"\"Erste Inhalte gezeichnet\" gibt an, wann der erste Text oder das erste Bild gezeichnet wird. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"Erste Inhalte gezeichnet"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"\"Erster CPU-Leerlauf\" gibt den Zeitpunkt an, an dem die Aktivität des Hauptthreads der Seite das erste Mal gering genug ist, um Eingaben zu verarbeiten. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/first-interactive)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"Erster CPU-Leerlauf"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"\"Inhalte weitgehend gezeichnet\" gibt an, wann die Hauptinhalte einer Seite sichtbar sind. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"Inhalte weitgehend gezeichnet"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"\"Zeit bis Interaktivität\" gibt den Zeitpunkt an, an dem die Seite voll interaktionsfähig ist. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Zeit bis Interaktivität"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"Der Geschwindigkeitsindex zeigt an, wie schnell die Inhalte einer Seite sichtbar dargestellt werden. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/speed-index)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Geschwindigkeitsindex"},"lighthouse-core/audits/redirects.js | description":{"message":"Weiterleitungen führen zu zusätzlichen Verzögerungen, bevor die Seite geladen werden kann. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/redirects)."},"lighthouse-core/audits/redirects.js | title":{"message":"Mehrere Weiterleitungen auf die Seite vermeiden"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"TTFB (Time To First Byte) erkennt den Zeitpunkt, an dem Ihr Server eine Antwort sendet. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/ttfb)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"Stammdokument brauchte {timeInMs, number, milliseconds} ms"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Serverantwortzeiten reduzieren (TTFB)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Serverantwortzeiten sind niedrig (TTFB)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Dauer"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Name"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Beginn"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Typ"},"lighthouse-core/audits/user-timings.js | description":{"message":"Sie können die User Timing API in Ihre App integrieren. Damit lässt sich die Leistung Ihrer App in der Praxis messen, beispielsweise während Seitenladevorgängen oder wichtigen Nutzerinteraktionen. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 Nutzertiming}other{# Nutzertimings}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"Markierungen und Messungen für das Nutzertiming"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Versuchen Sie, Hinweise auf Ressourcen für eine Vorverbindung oder einen DNS-Vorabruf hinzuzufügen, damit möglichst frühzeitig eine Verbindung zu wichtigen Drittanbieterursprüngen hergestellt wird. [Weitere Informationen](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"Vorverbindung zu erforderlichen Ursprüngen aufbauen"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Mit <link rel=preload> können Sie das Abrufen von Ressourcen priorisieren, die aktuell später beim Seitenaufbau angefordert werden. [Weitere Informationen](https://developers.google.com/web/tools/lighthouse/audits/preload)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Wichtige Anforderungen vorab laden"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"Weitere Informationen zur Leistung Ihrer App."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Diagnose"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"Der wichtigste Faktor bei der Leistung ist, wie schnell Pixel auf dem Bildschirm gerendert werden. Wichtige Messwerte: \"Erste Inhalte gezeichnet\", \"Inhalte weitgehend gezeichnet\""},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"Verbesserungen beim Zeichnen der ersten Inhalte"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"Diese Optimierungen können den Seitenaufbau beschleunigen."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Empfehlungen"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Messwerte"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Hier können Sie die Ladezeiten verkürzen, damit die Seite so schnell wie möglich reagiert und Einsatzbereit ist. Wichtige Messwerte: \"Zeit bis Interaktivität\", \"Geschwindigkeitsindex\""},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Allgemeine Verbesserungen"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Leistung"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"Cache-TTL"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Größe (KB)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Zeitaufwand"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"URL"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Mögliche Einsparung (KB)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Mögliche Einsparung (ms)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Mögliche Einsparung von {wastedBytes, number, bytes} ms"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Mögliche Einsparung von {wastedMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} s"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Überprüfungen ansehen"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Anfangsnavigation"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Maximale Latenz für kritischen Pfad:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Fehler."},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Fehler gemeldet: keine Informationen zur Überprüfung"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Labdaten"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[Lighthouse](https://developers.google.com/web/tools/lighthouse/)-Analyse der aktuellen Seite in einem emulierten 3G-Netz. Die Werte sind geschätzt und können variieren."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Zusätzliche Elemente zur manuellen Überprüfung"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"Nicht zutreffend"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Empfehlung"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Geschätzte Einsparung"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Bestandene Prüfungen"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Ergebnisskala:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"Einige Probleme haben diese Ausführung von Lighthouse beeinträchtigt:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Die Werte sind geschätzt und können variieren."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Warnungen: "}};},{}],45:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Οι επεκτάσεις του Chrome επηρέασαν αρνητικά την απόδοση φόρτωσης αυτής της σελίδας. Δοκιμάστε να ελέγξετε τη σελίδα σε κατάσταση ανώνυμης περιήγησης ή από ένα προφίλ του Chrome χωρίς επεκτάσεις."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Αξιολόγηση σεναρίου"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Ανάλυση σεναρίου"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Σύνολο"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Εξετάστε το ενδεχόμενο μείωσης του χρόνου ανάλυσης, σύνθεσης και εκτέλεσης JS. Μπορεί να διαπιστώσετε ότι η προβολή μικρότερων φορτίων δεδομένων JS συμβάλλει προς αυτήν την κατεύθυνση. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Μείωση χρόνου εκτέλεσης JavaScript"},"lighthouse-core/audits/bootup-time.js | title":{"message":"Χρόνος εκτέλεσης JavaScript"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Οι μεγάλες εικόνες GIF δεν είναι αποδοτικές για την προβολή περιεχομένου κινούμενων εικόνων. Εξετάστε το ενδεχόμενο χρήσης βίντεο MPEG4/WebM για κινούμενες εικόνες και PNG/WebP για στατικές εικόνες αντί για τη χρήση εικόνων GIF, με στόχο την εξοικονόμηση byte δικτύου. [Μάθετε περισσότερα](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Χρήση μορφών βίντεο για περιεχόμενο κινούμενων εικόνων"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Εξετάστε τη φόρτωση εικόνων εκτός οθόνης και κρυφών εικόνων με καθυστέρηση μετά την ολοκλήρωση της φόρτωσης όλων των σημαντικών πόρων, προκειμένου να ελαττωθεί ο χρόνος μετάβασης σε κατάσταση αλληλεπίδρασης. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Καθυστέρηση φόρτωσης εικόνων εκτός οθόνης"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Υπάρχουν πόροι οι οποίοι αποκλείουν την πρώτη μορφή της σελίδας σας. Εξετάστε το ενδεχόμενο προβολής σημαντικών ενσωματωμένων JS/CSS και καθυστέρησης όλων των μη σημαντικών JS/στυλ. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Εξάλειψη πόρων που αποκλείουν την απόδοση"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Τα μεγάλα φορτία δεδομένων δικτύου συνεπάγονται υψηλό χρηματικό κόστος για τους χρήστες και συσχετίζονται σε μεγάλο βαθμό με εκτενείς χρόνους φόρτωσης. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/network-payloads)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Το συνολικό μέγεθος ήταν {totalBytes, number, bytes} KB"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Αποφύγετε τα πολύ μεγάλα φορτία δεδομένων δικτύου"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Αποφεύγει τα πολύ μεγάλα φορτία δεδομένων δικτύου"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Με την ελαχιστοποίηση των αρχείων CSS, μπορεί να ελαττωθούν τα μεγέθη φορτίου δεδομένων δικτύου. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/minify-css)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"Ελαχιστοποίηση CSS"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Με την ελαχιστοποίηση των αρχείων JavaScript, μπορεί να μειωθούν τα μεγέθη φορτίου δεδομένων και να ελαττωθεί ο χρόνος ανάλυσης σεναρίου. [Μάθετε περισσότερα](https://developers.google.com/speed/docs/insights/MinifyResources)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"Ελαχιστοποίηση JavaScript"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Καταργήστε κανόνες που δεν χρησιμοποιούνται από τα φύλλα στυλ, για να μειώσετε τον αριθμό των μη απαραίτητων byte που καταναλώνονται από τη δραστηριότητα δικτύου. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/unused-css)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Καθυστέρηση μη χρησιμοποιούμενων CSS"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Καταργήστε τυχόν JavaScript που δεν χρησιμοποιείται, για να ελαττώσετε τα byte που καταναλώνονται από τη δραστηριότητα δικτύου."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Κατάργηση JavaScript που δεν χρησιμοποιείται"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"Η μεγάλη διάρκεια ζωής της κρυφής μνήμης μπορεί να επιταχύνει τις επαναλαμβανόμενες επισκέψεις στη σελίδα σας. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/cache-policy)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{Βρέθηκε 1 πόρος}other{Βρέθηκαν # πόροι}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Προβολή στατικών στοιχείων με επαρκή πολιτική κρυφής μνήμης"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Χρησιμοποιεί αποδοτική πολιτική κρυφής μνήμης σε στατικά στοιχεία"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Οι βελτιστοποιημένες εικόνες φορτώνονται πιο γρήγορα και καταναλώνουν λιγότερα δεδομένα κινητής τηλεφωνίας. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/optimize-images)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Αποδοτική κωδικοποίηση εικόνων"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Προβάλετε εικόνες κατάλληλου μεγέθους, για την εξοικονόμηση δεδομένων κινητής τηλεφωνίας και τη βελτίωση του χρόνου φόρτωσης. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/oversized-images)."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Κατάλληλη προσαρμογή μεγέθους εικόνων"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"Οι πόροι που βασίζονται σε κείμενο θα πρέπει να προβάλλονται με συμπίεση (gzip, deflate ή brotli), προκειμένου να ελαχιστοποιούνται τα byte δικτύου. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/text-compression)."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Ενεργοποίηση συμπίεσης κειμένου"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Οι μορφές εικόνας όπως JPEG 2000, JPEG XR και WebP συχνά παρέχουν καλύτερη συμπίεση από ό,τι οι μορφές PNG και JPEG. Αυτό σημαίνει γρηγορότερες λήψεις και μικρότερη κατανάλωση δεδομένων. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/webp)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Προβολή εικόνων σε μορφές επόμενης γενιάς"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"Οι Αλυσίδες κρίσιμων αιτημάτων που ακολουθούν δείχνουν τους πόρους που φορτώνονται με υψηλή προτεραιότητα. Εξετάστε το ενδεχόμενο μείωσης του μεγέθους των αλυσίδων, μείωσης του μεγέθους λήψης πόρων ή καθυστέρησης της λήψης μη απαραίτητων πόρων, για τη βελτίωση της φόρτωσης σελίδας. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{Βρέθηκε 1 αλυσίδα}other{Βρέθηκαν # αλυσίδες}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Ελαχιστοποίηση βάθους κρίσιμων αιτημάτων"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Οι μηχανικοί προγραμμάτων περιήγησης συνιστούν να περιέχουν οι σελίδες λιγότερους από ~1.500 κόμβους DOM. Το ιδανικό είναι ένα βάθος δέντρου με < 32 στοιχεία και λιγότερα από 60 θυγατρικά/γονικά στοιχεία. Ένα μεγάλο DOM μπορεί να αυξήσει τη χρήση της μνήμης, να προκαλέσει [υπολογισμούς στυλ] μεγαλύτερης διάρκειας (https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations) και να δημιουργήσει [επαναληπτικές ροές διάταξης] υψηλού κόστους (https://developers.google.com/speed/articles/reflow). [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/dom-size)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 κόμβος}other{# κόμβοι}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Αποφύγετε τα υπερβολικά μεγάλα μεγέθη DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Μέγιστο βάθος DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Σύνολο κόμβων DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Αποφεύγει τα υπερβολικά μεγάλα μεγέθη DOM"},"lighthouse-core/audits/font-display.js | description":{"message":"Χρησιμοποιήστε τη λειτουργία CSS προβολής γραμματοσειράς, για να διασφαλίσετε ότι το κείμενο είναι ορατό στους χρήστες κατά τη φόρτωση των γραμματοσειρών ιστοτόπου. [Μάθετε περισσότερα](https://developers.google.com/web/updates/2016/02/font-display)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Βεβαιωθείτε ότι το κείμενο παραμένει ορατό κατά τη διάρκεια της φόρτωσης γραμματοσειράς ιστοτόπου"},"lighthouse-core/audits/font-display.js | title":{"message":"Όλο το κείμενο παραμένει ορατό κατά τη διάρκεια φορτώσεων γραμματοσειράς ιστοτόπου"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Κατηγορία"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Εξετάστε το ενδεχόμενο ελάττωσης του χρόνου ανάλυσης, σύνθεσης και εκτέλεσης JS. Μπορεί να διαπιστώσετε ότι η προβολή μικρότερων φορτίων δεδομένων JS συμβάλλει προς αυτήν την κατεύθυνση."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Ελαχιστοποίηση εργασίας κύριου νήματος"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Ελαχιστοποιεί την εργασία κύριου νήματος"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"Η παραπάνω βαθμολογία αποτελεί εκτίμηση του χρόνου που απαιτείται προκειμένου η εφαρμογή σας να ανταποκριθεί στα στοιχεία εισόδου χρήστη, σε χιλιοστά του δευτερολέπτου, κατά τη διάρκεια εκτέλεσης του παραθύρου φόρτωσης σελίδας 5 δευτ. με τη μεγαλύτερη κινητικότητα. Εάν ο λανθάνων χρόνος είναι μεγαλύτερος από 50 ms, οι χρήστες μπορεί να θεωρήσουν ότι η εφαρμογή σας είναι αργή. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Εκτιμώμενος λανθάνων χρόνος στοιχείων εισόδου"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"Η Πρώτη σχεδίαση περιεχομένου (FCP) υποδεικνύει πότε μορφοποιείται το πρώτο κείμενο ή η πρώτη εικόνα. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"Πρώτη μορφή με περιεχόμενο"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"Η Πρώτη αδράνεια CPU υποδεικνύει την πρώτη φορά που το κύριο νήμα μιας σελίδας παρουσιάζει αρκετά χαμηλή κινητικότητα έτσι ώστε να διαχειριστεί στοιχεία εισόδου. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/first-interactive)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"Πρώτη αδράνεια CPU"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"Η Πρώτη χρήσιμη μορφή υπολογίζει πότε είναι ορατό το κύριο περιεχόμενο μιας σελίδας. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"Πρώτη χρήσιμη μορφή"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"Η Αλληλεπίδραση υποδεικνύει πότε η σελίδα είναι πλήρως διαδραστική. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Χρόνος για Αλληλεπίδραση"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"Το Ευρετήριο ταχύτητας δείχνει πόσο γρήγορα γίνονται ορατά τα περιεχόμενα μιας σελίδας. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/speed-index)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Ευρετήριο ταχύτητας"},"lighthouse-core/audits/redirects.js | description":{"message":"Οι ανακατευθύνσεις δημιουργούν επιπλέον καθυστερήσεις προτού να είναι δυνατή η φόρτωση της σελίδας. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/redirects)."},"lighthouse-core/audits/redirects.js | title":{"message":"Αποφυγή ανακατευθύνσεων πολλών σελίδων"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"Ο Χρόνος μέχρι το πρώτο byte προσδιορίζει πότε ο διακομιστής σας στέλνει μια απόκριση. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/ttfb)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"Το αρχείο ρίζας χρειάστηκε {timeInMs, number, milliseconds} ms"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Μείωση χρόνων απόκρισης διακομιστή (TTFB)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Οι χρόνοι απόκρισης διακομιστή είναι χαμηλοί (TTFB)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Διάρκεια"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Όνομα"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Ώρα έναρξης"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Τύπος"},"lighthouse-core/audits/user-timings.js | description":{"message":"Εξετάστε το ενδεχόμενο ενίσχυσης της εφαρμογής σας με το User Timing API, για να καταμετράτε την πραγματική απόδοση της εφαρμογής σας κατά τη διάρκεια σημαντικών εμπειριών χρήστη. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 χρόνος χρήστη}other{# χρόνοι χρήστη}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"Ενδείξεις και μετρήσεις Χρόνων χρήστη"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Εξετάστε το ενδεχόμενο προσθήκης υποδείξεων πόρου προσύνδεσης ή προανάλυσης dns, για τη δημιουργία πρώιμων συνδέσεων σε σημαντικές προελεύσεις τρίτου μέρους. [Μάθετε περισσότερα](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"Προσύνδεση σε απαιτούμενες προελεύσεις"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Εξετάστε το ενδεχόμενο χρήσης <link rel=φορτίου δεδομένων>, για να δώσετε προτεραιότητα στην ανάλυση πόρων των οποίων το αίτημα εμφανίζεται αργότερα στη σελίδα. [Μάθετε περισσότερα](https://developers.google.com/web/tools/lighthouse/audits/preload)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Σημαντικά αιτήματα προφόρτωσης"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"Περισσότερες πληροφορίες σχετικά με την απόδοση της εφαρμογής σας"},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Διαγνωστικά στοιχεία"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"Η πιο σημαντική πτυχή της απόδοσης είναι η ταχύτητα με την οποία αποδίδονται τα pixel στην οθόνη. Σημαντικές μετρήσεις: Πρώτη μορφή με περιεχόμενο, Πρώτη χρήσιμη μορφή"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"Βελτιώσεις πρώτης μορφής"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"Αυτοί οι οργανισμοί μπορούν να επιταχύνουν τη φόρτωση της σελίδας σας."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Ευκαιρίες"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Μετρήσεις"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Βελτιώστε τη συνολική εμπειρία φόρτωσης, για να μπορεί η σελίδα να ανταποκρίνεται και να είναι έτοιμη για χρήση το συντομότερο δυνατό. Σημαντικές μετρήσεις: Χρόνος για Αλληλεπίδραση, Ευρετήριο ταχύτητας"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Συνολικές βελτιώσεις"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Απόδοση"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"TTL κρυφής μνήμης"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Μέγεθος (KB)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Χρόνος χρήσης"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"URL"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Δυνητικές εξοικονομήσεις (KB)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Δυνητικές εξοικονομήσεις (ms)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Δυνητικές εξοικονομήσεις {wastedBytes, number, bytes} KB"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Δυνητικές εξοικονομήσεις {wastedMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} δ."},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Εμφάνιση ελέγχων"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Αρχική πλοήγηση"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Μέγιστος λανθάνων χρόνος κρίσιμης διαδρομής:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Σφάλμα!"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Σφάλμα αναφοράς: Δεν υπάρχουν πληροφορίες ελέγχου"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Εργαστηριακά δεδομένα"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[Φάρος](https://developers.google.com/web/tools/lighthouse/) ανάλυση της τρέχουσας σελίδας σε προσομοιωμένο 3G. Οι τιμές αποτελούν εκτιμήσεις και μπορεί να ποικίλουν."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Επιπλέον στοιχεία για μη αυτόματο έλεγχο"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"Δεν ισχύει"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Ευκαιρία"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Εκτιμώμενες εξοικονομήσεις"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Έλεγχοι που ολοκληρώθηκαν επιτυχώς"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Κλίμακα βαθμολογίας:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"Παρουσιάστηκαν ορισμένα ζητήματα τα οποία επηρεάζουν αυτήν την εκτέλεση του Lighthouse:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Οι τιμές εκτιμώνται και μπορεί να ποικίλουν."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Προειδοποιήσεις: "}};},{}],46:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Chrome extensions negatively affected this page's load performance. Try auditing the page in incognito mode or from a Chrome profile without extensions."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Script Evaluation"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Script Parse"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Total"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Consider reducing the time spent parsing, compiling and executing JS. You may find delivering smaller JS payloads helps with this. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Reduce JavaScript execution time"},"lighthouse-core/audits/bootup-time.js | title":{"message":"JavaScript execution time"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Large GIFs are inefficient for delivering animated content. Consider using MPEG4/WebM videos for animations and PNG/WebP for static images instead of GIF to save network bytes. [Learn more](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Use video formats for animated content"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Consider lazy-loading off-screen and hidden images after all critical resources have finished loading to lower time to interactive. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Defer off-screen images"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Resources are blocking the first paint of your page. Consider delivering critical JS/CSS inline and deferring all non-critical JS/styles. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Eliminate render-blocking resources"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Large network payloads cost users real money and are highly correlated with long load times. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/network-payloads)."},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Total size was {totalBytes, number, bytes} KB"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Avoid enormous network payloads"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Avoids enormous network payloads"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Minifying CSS files can reduce network payload sizes. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/minify-css)."},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"Minify CSS"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Minifying JavaScript files can reduce payload sizes and script parse time. [Learn more](https://developers.google.com/speed/docs/insights/MinifyResources)."},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"Minify JavaScript"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Remove unused rules from stylesheets to reduce unnecessary bytes consumed by network activity. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/unused-css)."},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Defer unused CSS"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Remove unused JavaScript to reduce bytes consumed by network activity."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Remove unused JavaScript"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"A long cache lifetime can speed up repeat visits to your page. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/cache-policy)."},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{1 resource found}other{# resources found}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Serve static assets with an efficient cache policy"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Uses efficient cache policy on static assets"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Optimised images load faster and consume less mobile data. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/optimize-images)."},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Efficiently encode images"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Serve images that are appropriately-sized to save mobile data and improve load time. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/oversized-images)."},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Properly size images"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"Text-based resources should be served with compression (gzip, deflate or brotli) to minimise total network bytes. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/text-compression)."},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Enable text compression"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Image formats like JPEG 2000, JPEG XR and WebP often provide better compression than PNG or JPEG, which means faster downloads and less data consumption. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/webp)."},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Serve images in next-gen formats"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"The Critical Request Chains below show you what resources are loaded with a high priority. Consider reducing the length of chains, reducing the download size of resources or deferring the download of unnecessary resources to improve page load. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{1 chain found}other{# chains found}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Minimise Critical Requests Depth"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Browser engineers recommend pages contain fewer than ~1,500 DOM nodes. The sweet spot is a tree depth < 32 elements and fewer than 60 children/parent element. A large DOM can increase memory usage, cause longer [style calculations](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations), and produce costly [layout reflows](https://developers.google.com/speed/articles/reflow). [Learn more](https://developers.google.com/web/tools/lighthouse/audits/dom-size)."},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 node}other{# nodes}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Avoid an excessive DOM size"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Maximum DOM Depth"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Total DOM Nodes"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Avoids an excessive DOM size"},"lighthouse-core/audits/font-display.js | description":{"message":"Leverage the font-display CSS feature to ensure text is user-visible while webfonts are loading. [Learn more](https://developers.google.com/web/updates/2016/02/font-display)."},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Ensure text remains visible during webfont load"},"lighthouse-core/audits/font-display.js | title":{"message":"All text remains visible during webfont loads"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Category"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Consider reducing the time spent parsing, compiling and executing JS. You may find delivering smaller JS payloads helps with this."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Minimise main-thread work"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Minimises main-thread work"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"The score above is an estimate of how long your app takes to respond to user input, in milliseconds, during the busiest 5-second window of page load. If your latency is higher than 50 ms, users may perceive your app as laggy. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)."},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Estimated Input Latency"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"First Contentful Paint marks the time at which the first text or image is painted. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"First Contentful Paint"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"First CPU Idle marks the first time at which the page's main thread is quiet enough to handle input. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-interactive)."},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"First CPU Idle"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"First Meaningful Paint measures when the primary content of a page is visible. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)."},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"First Meaningful Paint"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"Interactive marks the time at which the page is fully interactive. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)."},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Time to Interactive"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"Speed Index shows how quickly the contents of a page are visibly populated. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/speed-index)."},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Speed Index"},"lighthouse-core/audits/redirects.js | description":{"message":"Redirects introduce additional delays before the page can be loaded. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/redirects)."},"lighthouse-core/audits/redirects.js | title":{"message":"Avoid multiple page redirects"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"Time To First Byte identifies the time at which your server sends a response. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/ttfb)."},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"Root document took {timeInMs, number, milliseconds} ms"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Reduce server response times (TTFB)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Server response times are low (TTFB)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Duration"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Name"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Start Time"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Type"},"lighthouse-core/audits/user-timings.js | description":{"message":"Consider instrumenting your app with the User Timing API to measure your app's real-world performance during key user experiences. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 user timing}other{# user timings}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"User Timing marks and measures"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Consider adding pre-connect or DNS-prefetch resource hints to establish early connections to important third-party origins. [Learn more](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)."},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"Pre-connect to required origins"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Consider using <link rel=preload> to prioritise fetching resources that are currently requested later in page load. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/preload)."},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Pre-load key requests"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"More information about the performance of your application."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Diagnostics"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"First Paint Improvements"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"These optimisations can speed up your page load."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Opportunities"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Metrics"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Overall Improvements"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Performance"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"Cache TTL"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Size (KB)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Time Spent"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"URL"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Potential Savings (KB)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Potential Savings (ms)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Potential savings of {wastedBytes, number, bytes} KB"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Potential savings of {wastedMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} s"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Show audits"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Initial Navigation"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Maximum critical path latency:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Error!"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Report error: no audit information"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Lab Data"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[Lighthouse](https://developers.google.com/web/tools/lighthouse/) analysis of the current page on emulated 3G. Values are estimated and may vary."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Additional items to manually check"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"Not applicable"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Opportunity"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Estimated Savings"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Passed audits"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Score scale:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"There were issues affecting this run of Lighthouse:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Values are estimated and may vary."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Warnings: "}};},{}],47:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"[Çĥŕömé éxţéñšîöñš ñéĝåţîvéļý åƒƒéçţéð ţĥîš þåĝé'š ļöåð þéŕƒöŕmåñçé. Ţŕý åûðîţîñĝ ţĥé þåĝé îñ îñçöĝñîţö möðé öŕ ƒŕöm å Çĥŕömé þŕöƒîļé ŵîţĥöûţ éxţéñšîöñš. one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo]"},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"[Šçŕîþţ Évåļûåţîöñ one two three]"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"[Šçŕîþţ Þåŕšé one two]"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"[Ţöţåļ one]"},"lighthouse-core/audits/bootup-time.js | description":{"message":"[Çöñšîðéŕ ŕéðûçîñĝ ţĥé ţîmé šþéñţ þåŕšîñĝ, çömþîļîñĝ, åñð éxéçûţîñĝ ĴŠ. Ýöû måý ƒîñð ðéļîvéŕîñĝ šmåļļéŕ ĴŠ þåýļöåðš ĥéļþš ŵîţĥ ţĥîš. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/бööţûþ). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight]"},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"[Ŕéðûçé ĴåvåŠçŕîþţ éxéçûţîöñ ţîmé one two three four five six seven]"},"lighthouse-core/audits/bootup-time.js | title":{"message":"[ĴåvåŠçŕîþţ éxéçûţîöñ ţîmé one two three]"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"[Ļåŕĝé ĜÎFš åŕé îñéƒƒîçîéñţ ƒöŕ ðéļîvéŕîñĝ åñîmåţéð çöñţéñţ. Çöñšîðéŕ ûšîñĝ MÞÉĜ4/ŴéбM vîðéöš ƒöŕ åñîmåţîöñš åñð ÞÑĜ/ŴéбÞ ƒöŕ šţåţîç îmåĝéš îñšţéåð öƒ ĜÎF ţö šåvé ñéţŵöŕķ бýţéš. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ƒûñðåméñţåļš/þéŕƒöŕmåñçé/öþţîmîžîñĝ-çöñţéñţ-éƒƒîçîéñçý/ŕéþļåçé-åñîmåţéð-ĝîƒš-ŵîţĥ-vîðéö/) one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight twentynine thirty thirtyone thirtytwo thirtythree thirtyfour thirtyfive thirtysix thirtyseven]"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"[Ûšé vîðéö ƒöŕmåţš ƒöŕ åñîmåţéð çöñţéñţ one two three four five six seven eight]"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"[Çöñšîðéŕ ļåžý-ļöåðîñĝ öƒƒšçŕééñ åñð ĥîððéñ îmåĝéš åƒţéŕ åļļ çŕîţîçåļ ŕéšöûŕçéš ĥåvé ƒîñîšĥéð ļöåðîñĝ ţö ļöŵéŕ ţîmé ţö îñţéŕåçţîvé. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/öƒƒšçŕééñ-îmåĝéš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight]"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"[Ðéƒéŕ öƒƒšçŕééñ îmåĝéš one two three]"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"[Ŕéšöûŕçéš åŕé бļöçķîñĝ ţĥé ƒîŕšţ þåîñţ öƒ ýöûŕ þåĝé. Çöñšîðéŕ ðéļîvéŕîñĝ çŕîţîçåļ ĴŠ/ÇŠŠ îñļîñé åñð ðéƒéŕŕîñĝ åļļ ñöñ-çŕîţîçåļ ĴŠ/šţýļéš. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/бļöçķîñĝ-ŕéšöûŕçéš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight twentynine]"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"[Éļîmîñåţé ŕéñðéŕ-бļöçķîñĝ ŕéšöûŕçéš one two three four]"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"[Ļåŕĝé ñéţŵöŕķ þåýļöåðš çöšţ ûšéŕš ŕéåļ möñéý åñð åŕé ĥîĝĥļý çöŕŕéļåţéð ŵîţĥ ļöñĝ ļöåð ţîméš. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ñéţŵöŕķ-þåýļöåðš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive]"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"[Ţöţåļ šîžé ŵåš {ţöţåļБýţéš} ĶБ one two three four five six seven]"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"[Åvöîð éñöŕmöûš ñéţŵöŕķ þåýļöåðš one two three four five six seven]"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"[Åvöîðš éñöŕmöûš ñéţŵöŕķ þåýļöåðš one two three four five six seven]"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"[Mîñîƒýîñĝ ÇŠŠ ƒîļéš çåñ ŕéðûçé ñéţŵöŕķ þåýļöåð šîžéš. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/mîñîƒý-çšš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone]"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"[Mîñîƒý ÇŠŠ one two]"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"[Mîñîƒýîñĝ ĴåvåŠçŕîþţ ƒîļéš çåñ ŕéðûçé þåýļöåð šîžéš åñð šçŕîþţ þåŕšé ţîmé. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/šþééð/ðöçš/îñšîĝĥţš/MîñîƒýŔéšöûŕçéš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree]"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"[Mîñîƒý ĴåvåŠçŕîþţ one two three]"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"[Ŕémövé ûñûšéð ŕûļéš ƒŕöm šţýļéšĥééţš ţö ŕéðûçé ûññéçéššåŕý бýţéš çöñšûméð бý ñéţŵöŕķ åçţîvîţý. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ûñûšéð-çšš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive]"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"[Ðéƒéŕ ûñûšéð ÇŠŠ one two]"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"[Ŕémövé ûñûšéð ĴåvåŠçŕîþţ ţö ŕéðûçé бýţéš çöñšûméð бý ñéţŵöŕķ åçţîvîţý. one two three four five six seven eight nine ten eleven twelve thirteen]"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"[Ŕémövé ûñûšéð ĴåvåŠçŕîþţ one two three]"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"[Å ļöñĝ çåçĥé ļîƒéţîmé çåñ šþééð ûþ ŕéþéåţ vîšîţš ţö ýöûŕ þåĝé. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/çåçĥé-þöļîçý). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo]"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{[1 ŕéšöûŕçé ƒöûñð one two]}other{[# ŕéšöûŕçéš ƒöûñð one two three]}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"[Šéŕvé šţåţîç åššéţš ŵîţĥ åñ éƒƒîçîéñţ çåçĥé þöļîçý one two three four five six seven eight nine ten eleven]"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"[Ûšéš éƒƒîçîéñţ çåçĥé þöļîçý öñ šţåţîç åššéţš one two three four five six seven eight nine]"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"[Öþţîmîžéð îmåĝéš ļöåð ƒåšţéŕ åñð çöñšûmé ļéšš çéļļûļåŕ ðåţå. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/öþţîmîžé-îmåĝéš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo]"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"[Éƒƒîçîéñţļý éñçöðé îmåĝéš one two three]"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"[Šéŕvé îmåĝéš ţĥåţ åŕé åþþŕöþŕîåţéļý-šîžéð ţö šåvé çéļļûļåŕ ðåţå åñð îmþŕövé ļöåð ţîmé. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/övéŕšîžéð-îmåĝéš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive]"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"[Þŕöþéŕļý šîžé îmåĝéš one two three]"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"[Ţéxţ-бåšéð ŕéšöûŕçéš šĥöûļð бé šéŕvéð ŵîţĥ çömþŕéššîöñ (ĝžîþ, ðéƒļåţé öŕ бŕöţļî) ţö mîñîmîžé ţöţåļ ñéţŵöŕķ бýţéš. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ţéxţ-çömþŕéššîöñ). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven]"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"[Éñåбļé ţéxţ çömþŕéššîöñ one two three]"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"[Îmåĝé ƒöŕmåţš ļîķé ĴÞÉĜ 2000, ĴÞÉĜ XŔ, åñð ŴéбÞ öƒţéñ þŕövîðé бéţţéŕ çömþŕéššîöñ ţĥåñ ÞÑĜ öŕ ĴÞÉĜ, ŵĥîçĥ méåñš ƒåšţéŕ ðöŵñļöåðš åñð ļéšš ðåţå çöñšûmþţîöñ. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ŵéбþ). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight twentynine thirty]"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"[Šéŕvé îmåĝéš îñ ñéxţ-ĝéñ ƒöŕmåţš one two three four five six seven]"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"[Ţĥé Çŕîţîçåļ Ŕéqûéšţ Çĥåîñš бéļöŵ šĥöŵ ýöû ŵĥåţ ŕéšöûŕçéš åŕé ļöåðéð ŵîţĥ å ĥîĝĥ þŕîöŕîţý. Çöñšîðéŕ ŕéðûçîñĝ ţĥé ļéñĝţĥ öƒ çĥåîñš, ŕéðûçîñĝ ţĥé ðöŵñļöåð šîžé öƒ ŕéšöûŕçéš, öŕ ðéƒéŕŕîñĝ ţĥé ðöŵñļöåð öƒ ûññéçéššåŕý ŕéšöûŕçéš ţö îmþŕövé þåĝé ļöåð. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/çŕîţîçåļ-ŕéqûéšţ-çĥåîñš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight twentynine thirty thirtyone thirtytwo thirtythree thirtyfour thirtyfive thirtysix thirtyseven thirtyeight thirtynine forty]"},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{[1 çĥåîñ ƒöûñð one two]}other{[# çĥåîñš ƒöûñð one two]}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"[Mîñîmîžé Çŕîţîçåļ Ŕéqûéšţš Ðéþţĥ one two three four five six seven]"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"[Éļéméñţ one]"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"[Šţåţîšţîç one two]"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"[Våļûé one]"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"[Бŕöŵšéŕ éñĝîñééŕš ŕéçömméñð þåĝéš çöñţåîñ ƒéŵéŕ ţĥåñ ~1,500 ÐÖM ñöðéš. Ţĥé šŵééţ šþöţ îš å ţŕéé ðéþţĥ < 32 éļéméñţš åñð ƒéŵéŕ ţĥåñ 60 çĥîļðŕéñ/þåŕéñţ éļéméñţ. Å ļåŕĝé ÐÖM çåñ îñçŕéåšé mémöŕý ûšåĝé, çåûšé ļöñĝéŕ [šţýļé çåļçûļåţîöñš](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ƒûñðåméñţåļš/þéŕƒöŕmåñçé/ŕéñðéŕîñĝ/ŕéðûçé-ţĥé-šçöþé-åñð-çömþļéxîţý-öƒ-šţýļé-çåļçûļåţîöñš), åñð þŕöðûçé çöšţļý [ļåýöûţ ŕéƒļöŵš](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/šþééð/åŕţîçļéš/ŕéƒļöŵ). [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ðöm-šîžé). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight twentynine thirty thirtyone thirtytwo thirtythree thirtyfour thirtyfive thirtysix thirtyseven thirtyeight thirtynine forty one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive]"},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{[1 ñöðé one]}other{[# ñöðéš one]}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"[Åvöîð åñ éxçéššîvé ÐÖM šîžé one two three four five six]"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"[Måxîmûm ÐÖM Ðéþţĥ one two three]"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"[Ţöţåļ ÐÖM Ñöðéš one two]"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"[Måxîmûm Çĥîļð Éļéméñţš one two three]"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"[Åvöîðš åñ éxçéššîvé ÐÖM šîžé one two three four five six]"},"lighthouse-core/audits/font-display.js | description":{"message":"[Ļévéŕåĝé ţĥé ƒöñţ-ðîšþļåý ÇŠŠ ƒéåţûŕé ţö éñšûŕé ţéxţ îš ûšéŕ-vîšîбļé ŵĥîļé ŵéбƒöñţš åŕé ļöåðîñĝ. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ûþðåţéš/2016/02/ƒöñţ-ðîšþļåý). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour]"},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"[Éñšûŕé ţéxţ ŕémåîñš vîšîбļé ðûŕîñĝ ŵéбƒöñţ ļöåð one two three four five six seven eight nine ten]"},"lighthouse-core/audits/font-display.js | title":{"message":"[Åļļ ţéxţ ŕémåîñš vîšîбļé ðûŕîñĝ ŵéбƒöñţ ļöåðš one two three four five six seven eight nine]"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"[Çåţéĝöŕý one]"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"[Çöñšîðéŕ ŕéðûçîñĝ ţĥé ţîmé šþéñţ þåŕšîñĝ, çömþîļîñĝ åñð éxéçûţîñĝ ĴŠ. Ýöû måý ƒîñð ðéļîvéŕîñĝ šmåļļéŕ ĴŠ þåýļöåðš ĥéļþš ŵîţĥ ţĥîš. one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty]"},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"[Mîñîmîžé måîñ-ţĥŕéåð ŵöŕķ one two three]"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"[Mîñîmîžéš måîñ-ţĥŕéåð ŵöŕķ one two three]"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"[Ţĥé šçöŕé åбövé îš åñ éšţîmåţé öƒ ĥöŵ ļöñĝ ýöûŕ åþþ ţåķéš ţö ŕéšþöñð ţö ûšéŕ îñþûţ, îñ mîļļîšéçöñðš, ðûŕîñĝ ţĥé бûšîéšţ 5š ŵîñðöŵ öƒ þåĝé ļöåð. Îƒ ýöûŕ ļåţéñçý îš ĥîĝĥéŕ ţĥåñ 50 mš, ûšéŕš måý þéŕçéîvé ýöûŕ åþþ åš ļåĝĝý. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/éšţîmåţéð-îñþûţ-ļåţéñçý). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight twentynine thirty thirtyone thirtytwo thirtythree thirtyfour thirtyfive thirtysix thirtyseven thirtyeight]"},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"[Éšţîmåţéð Îñþûţ Ļåţéñçý one two three]"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"[Fîŕšţ Çöñţéñţƒûļ Þåîñţ måŕķš ţĥé ţîmé åţ ŵĥîçĥ ţĥé ƒîŕšţ ţéxţ öŕ îmåĝé îš þåîñţéð. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ƒîŕšţ-çöñţéñţƒûļ-þåîñţ). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive]"},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"[Fîŕšţ Çöñţéñţƒûļ Þåîñţ one two three]"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"[Fîŕšţ ÇÞÛ Îðļé måŕķš ţĥé ƒîŕšţ ţîmé åţ ŵĥîçĥ ţĥé þåĝé'š måîñ ţĥŕéåð îš qûîéţ éñöûĝĥ ţö ĥåñðļé îñþûţ. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ƒîŕšţ-îñţéŕåçţîvé). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix]"},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"[Fîŕšţ ÇÞÛ Îðļé one two]"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"[Fîŕšţ Méåñîñĝƒûļ Þåîñţ méåšûŕéš ŵĥéñ ţĥé þŕîmåŕý çöñţéñţ öƒ å þåĝé îš vîšîбļé. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ƒîŕšţ-méåñîñĝƒûļ-þåîñţ). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour]"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"[Fîŕšţ Méåñîñĝƒûļ Þåîñţ one two three]"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"[Îñţéŕåçţîvé måŕķš ţĥé ţîmé åţ ŵĥîçĥ ţĥé þåĝé îš ƒûļļý îñţéŕåçţîvé. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/çöñšîšţéñţļý-îñţéŕåçţîvé). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree]"},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"[Ţîmé ţö Îñţéŕåçţîvé one two three]"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"[Šþééð Îñðéx šĥöŵš ĥöŵ qûîçķļý ţĥé çöñţéñţš öƒ å þåĝé åŕé vîšîбļý þöþûļåţéð. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/šþééð-îñðéx). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree]"},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"[Šþééð Îñðéx one two]"},"lighthouse-core/audits/redirects.js | description":{"message":"[Ŕéðîŕéçţš îñţŕöðûçé åððîţîöñåļ ðéļåýš бéƒöŕé ţĥé þåĝé çåñ бé ļöåðéð. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ŕéðîŕéçţš). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo]"},"lighthouse-core/audits/redirects.js | title":{"message":"[Åvöîð mûļţîþļé þåĝé ŕéðîŕéçţš one two three four five six seven]"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"[Ţîmé Ţö Fîŕšţ Бýţé îðéñţîƒîéš ţĥé ţîmé åţ ŵĥîçĥ ýöûŕ šéŕvéŕ šéñðš å ŕéšþöñšé. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ţţƒб). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree]"},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"[Ŕööţ ðöçûméñţ ţööķ {ţîméÎñMš} mš one two three four five six seven]"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"[Ŕéðûçé šéŕvéŕ ŕéšþöñšé ţîméš (ŢŢFБ) one two three four five six seven eight]"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"[Šéŕvéŕ ŕéšþöñšé ţîméš åŕé ļöŵ (ŢŢFБ) one two three four five six seven eight]"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"[Ðûŕåţîöñ one]"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"[Ñåmé one]"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"[Šţåŕţ Ţîmé one two]"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"[Ţýþé one]"},"lighthouse-core/audits/user-timings.js | description":{"message":"[Çöñšîðéŕ îñšţŕûméñţîñĝ ýöûŕ åþþ ŵîţĥ ţĥé Ûšéŕ Ţîmîñĝ ÅÞÎ ţö méåšûŕé ýöûŕ åþþ'š ŕéåļ-ŵöŕļð þéŕƒöŕmåñçé ðûŕîñĝ ķéý ûšéŕ éxþéŕîéñçéš. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/ûšéŕ-ţîmîñĝ). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight]"},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{[1 ûšéŕ ţîmîñĝ one two]}other{[# ûšéŕ ţîmîñĝš one two]}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"[Ûšéŕ Ţîmîñĝ måŕķš åñð méåšûŕéš one two three four five six seven]"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"[Çöñšîðéŕ åððîñĝ þŕéçöññéçţ öŕ ðñš-þŕéƒéţçĥ ŕéšöûŕçé ĥîñţš ţö éšţåбļîšĥ éåŕļý çöññéçţîöñš ţö îmþöŕţåñţ ţĥîŕð-þåŕţý öŕîĝîñš. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ƒûñðåméñţåļš/þéŕƒöŕmåñçé/ŕéšöûŕçé-þŕîöŕîţîžåţîöñ#þŕéçöññéçţ). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive twentysix twentyseven twentyeight twentynine]"},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"[Þŕéçöññéçţ ţö ŕéqûîŕéð öŕîĝîñš one two three four five six seven]"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"[Çöñšîðéŕ ûšîñĝ <link rel=preload> ţö þŕîöŕîţîžé ƒéţçĥîñĝ ŕéšöûŕçéš ţĥåţ åŕé çûŕŕéñţļý ŕéqûéšţéð ļåţéŕ îñ þåĝé ļöåð. [Ļéåŕñ möŕé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/åûðîţš/þŕéļöåð). one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo twentythree twentyfour twentyfive]"},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"[Þŕéļöåð ķéý ŕéqûéšţš one two three]"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"[Möŕé îñƒöŕmåţîöñ åбöûţ ţĥé þéŕƒöŕmåñçé öƒ ýöûŕ åþþļîçåţîöñ. one two three four five six seven eight nine ten eleven twelve]"},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"[Ðîåĝñöšţîçš one two]"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"[Ţĥé möšţ çŕîţîçåļ åšþéçţ öƒ þéŕƒöŕmåñçé îš ĥöŵ qûîçķļý þîxéļš åŕé ŕéñðéŕéð öñšçŕééñ. Ķéý méţŕîçš: Fîŕšţ Çöñţéñţƒûļ Þåîñţ, Fîŕšţ Méåñîñĝƒûļ Þåîñţ one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo]"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"[Fîŕšţ Þåîñţ Îmþŕövéméñţš one two three]"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"[Ţĥéšé öþţîmîžåţîöñš çåñ šþééð ûþ ýöûŕ þåĝé ļöåð. one two three four five six seven eight nine ten]"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"[Öþþöŕţûñîţîéš one two]"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"[Méţŕîçš one]"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"[Éñĥåñçé ţĥé övéŕåļļ ļöåðîñĝ éxþéŕîéñçé, šö ţĥé þåĝé îš ŕéšþöñšîvé åñð ŕéåðý ţö ûšé åš šööñ åš þöššîбļé. Ķéý méţŕîçš: Ţîmé ţö Îñţéŕåçţîvé, Šþééð Îñðéx one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo]"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"[Övéŕåļļ Îmþŕövéméñţš one two three]"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"[Þéŕƒöŕmåñçé one two]"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"[Çåçĥé ŢŢĻ one two]"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"[Šîžé (ĶБ) one two]"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"[Ţîmé Šþéñţ one two]"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"[ÛŔĻ one]"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"[Þöţéñţîåļ Šåvîñĝš (ĶБ) one two three]"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"[Þöţéñţîåļ Šåvîñĝš (mš) one two three]"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"[Þöţéñţîåļ šåvîñĝš öƒ {ŵåšţéðБýţéš} ĶБ one two three four five six seven eight]"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"[Þöţéñţîåļ šåvîñĝš öƒ {ŵåšţéðMš} mš one two three four five six seven]"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"[{ţîméÎñMš} mš one two]"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"[{ţîméÎñMšŠéç} š one two]"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"[Šĥöŵ åûðîţš one two]"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"[Îñîţîåļ Ñåvîĝåţîöñ one two three]"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"[Måxîmûm çŕîţîçåļ þåţĥ ļåţéñçý: one two three four five six seven]"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"[Éŕŕöŕ¡ one]"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"[Ŕéþöŕţ éŕŕöŕ: ñö åûðîţ îñƒöŕmåţîöñ one two three four five six seven]"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"[Ļåб Ðåţå one]"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[[Ļîĝĥţĥöûšé](ĥţţþš://ðévéļöþéŕš.ĝööĝļé.çöm/ŵéб/ţööļš/ļîĝĥţĥöûšé/) åñåļýšîš öƒ ţĥé çûŕŕéñţ þåĝé öñ émûļåţéð 3Ĝ. Våļûéš åŕé éšţîmåţéð åñð måý våŕý. one two three four five six seven eight nine ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen twenty twentyone twentytwo]"},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"[Åððîţîöñåļ îţémš ţö måñûåļļý çĥéçķ one two three four five six seven]"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"[Ñöţ åþþļîçåбļé one two]"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"[Öþþöŕţûñîţý one two]"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"[Éšţîmåţéð Šåvîñĝš one two three]"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"[Þåššéð åûðîţš one two]"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"[Šçöŕé šçåļé: one two]"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"[Ţĥéŕé ŵéŕé îššûéš åƒƒéçţîñĝ ţĥîš ŕûñ öƒ Ļîĝĥţĥöûšé: one two three four five six seven eight nine ten eleven]"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"[Våļûéš åŕé éšţîmåţéð åñð måý våŕý. one two three four five six seven]"},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"[Ŵåŕñîñĝš:  one two]"}};},{}],48:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Las extensiones de Chrome han afectado de forma negativa al rendimiento de carga de esta página. Prueba a auditarla en modo incógnito o desde un perfil de Chrome sin extensiones."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Evaluación de la secuencia de comandos"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Análisis de la secuencia de comandos"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Total"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Te recomendamos que reduzcas el tiempo de análisis, compilación y ejecución de JavaScript. Para ello, puedes utilizar cargas útiles de JS más pequeñas. [Más información](https://developers.google.com/web/tools/lighthouse/audits/bootup)"},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Reduce el tiempo de ejecución de JavaScript"},"lighthouse-core/audits/bootup-time.js | title":{"message":"Tiempo de ejecución de JavaScript"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Los GIF de gran tamaño no son eficaces para mostrar contenido animado. Para usar menos bytes de la red, te recomendamos que utilices los formatos de vídeo PEG4/WebM para incluir animaciones y los formatos PNG/WebP para añadir imágenes estáticas en lugar de GIFs. [Más información](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Usa formatos de vídeo para incluir contenido animado"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Te recomendamos que uses la carga diferida con imágenes ocultas y que no aparecen en pantalla una vez que todos los recursos críticos hayan terminado de cargarse para reducir el tiempo hasta que la página es interactiva. [Más información](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Pospón la carga de imágenes que no aparecen en pantalla"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Hay recursos que bloquean el primer renderizado de la página. Te recomendamos que muestres los elementos JS/CSS críticos insertados y pospongas todos los JS/styles que no sean críticos. [Más información](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Elimina los recursos que bloqueen el renderizado"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Si la carga útil de la red es muy grande, los usuarios consumen más datos móviles y las páginas tardan más en cargarse. [Más información](https://developers.google.com/web/tools/lighthouse/audits/network-payloads)"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | displayValue":{"message":"Tamaño total: {totalBytes, number, bytes} kB"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | failureTitle":{"message":"Evita cargas útiles de red de gran tamaño"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | title":{"message":"Evita cargas útiles de red de gran tamaño"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | description":{"message":"Si minificas los archivos CSS, se puede reducir el tamaño de la carga útil de la red. [Más información](https://developers.google.com/web/tools/lighthouse/audits/minify-css)"},"lighthouse-core/audits/byte-efficiency/unminified-css.js | title":{"message":"Minifica los archivos CSS"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | description":{"message":"Si minificas los archivos JavaScript, se puede reducir el tamaño de la carga útil y el tiempo de análisis de la secuencia de comandos. [Más información](https://developers.google.com/speed/docs/insights/MinifyResources)"},"lighthouse-core/audits/byte-efficiency/unminified-javascript.js | title":{"message":"Minifica los recursos JavaScript"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | description":{"message":"Quita las reglas que no se usen de las hojas de estilo para reducir el número de bytes innecesarios que consume la actividad de red. [Más información](https://developers.google.com/web/tools/lighthouse/audits/unused-css)"},"lighthouse-core/audits/byte-efficiency/unused-css-rules.js | title":{"message":"Pospón la carga de archivos CSS"},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | description":{"message":"Quita el contenido JavaScript que no se use para reducir el número de bytes que consume la actividad de red."},"lighthouse-core/audits/byte-efficiency/unused-javascript.js | title":{"message":"Quita los recursos JavaScript que no se usen"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | description":{"message":"Una duración en caché más larga puede aumentar el número de visitas repetidas a tu página. [Más información](https://developers.google.com/web/tools/lighthouse/audits/cache-policy)"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | displayValue":{"message":"{itemCount,plural, =1{Se ha encontrado 1 recurso}other{Se han encontrado # recursos}}"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | failureTitle":{"message":"Publica recursos estáticos con una política de caché eficaz"},"lighthouse-core/audits/byte-efficiency/uses-long-cache-ttl.js | title":{"message":"Usa una política de caché eficaz en recursos estáticos"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | description":{"message":"Las imágenes optimizadas se cargan más rápido y consumen menos datos móviles. [Más información](https://developers.google.com/web/tools/lighthouse/audits/optimize-images)"},"lighthouse-core/audits/byte-efficiency/uses-optimized-images.js | title":{"message":"Codifica las imágenes de forma eficaz"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | description":{"message":"Muestra imágenes con un tamaño adecuado para ahorrar datos móviles y mejorar el tiempo de carga. [Más información](https://developers.google.com/web/tools/lighthouse/audits/oversized-images)"},"lighthouse-core/audits/byte-efficiency/uses-responsive-images.js | title":{"message":"Usa un tamaño adecuado para las imágenes"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | description":{"message":"Los recursos basados en texto se deberían publicar comprimidos (gzip, deflate o brotli) para minimizar el total de bytes de la red. [Más información](https://developers.google.com/web/tools/lighthouse/audits/text-compression)"},"lighthouse-core/audits/byte-efficiency/uses-text-compression.js | title":{"message":"Habilita la compresión de texto"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | description":{"message":"Los formatos como JPEG 2000, JPEG XR y WebP comprimen mejor las imágenes que los formatos PNG o JPEG, lo que hace que se descarguen más rápido y consuman menos datos. [Más información](https://developers.google.com/web/tools/lighthouse/audits/webp)"},"lighthouse-core/audits/byte-efficiency/uses-webp-images.js | title":{"message":"Publica imágenes con formatos de próxima generación"},"lighthouse-core/audits/critical-request-chains.js | description":{"message":"Las cadenas de solicitud crítica que se muestran a continuación indican qué recursos son de alta prioridad. Te recomendamos que reduzcas la longitud de las cadenas, disminuyas el tamaño de los recursos o pospongas la descarga de recursos innecesarios para mejorar la carga de la página. [Más información](https://developers.google.com/web/tools/lighthouse/audits/critical-request-chains)."},"lighthouse-core/audits/critical-request-chains.js | displayValue":{"message":"{itemCount,plural, =1{Se ha encontrado 1 cadena}other{Se han encontrado # cadenas}}"},"lighthouse-core/audits/critical-request-chains.js | title":{"message":"Minimiza la profundidad de las solicitudes críticas"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnElement":{"message":"Element"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnStatistic":{"message":"Statistic"},"lighthouse-core/audits/dobetterweb/dom-size.js | columnValue":{"message":"Value"},"lighthouse-core/audits/dobetterweb/dom-size.js | description":{"message":"Los ingenieros que desarrollan navegadores recomiendan que las páginas contengan menos de ~1500 nodos de DOM. Lo ideal es conseguir una profundidad de árbol de < 32 elementos y menos de 60 elementos secundarios por cada nodo principal. Los DOM de gran tamaño aumentan el uso de la memoria, hacen que los [cálculos de estilo](https://developers.google.com/web/fundamentals/performance/rendering/reduce-the-scope-and-complexity-of-style-calculations) sean más largos y producen [reinicios de flujo](https://developers.google.com/speed/articles/reflow) más caros. [Más información](https://developers.google.com/web/tools/lighthouse/audits/dom-size)"},"lighthouse-core/audits/dobetterweb/dom-size.js | displayValue":{"message":"{itemCount,plural, =1{1 nodo}other{# nodos}}"},"lighthouse-core/audits/dobetterweb/dom-size.js | failureTitle":{"message":"Evita un tamaño excesivo de DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMDepth":{"message":"Profundidad máxima de DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMNodes":{"message":"Nodos totales de DOM"},"lighthouse-core/audits/dobetterweb/dom-size.js | statisticDOMWidth":{"message":"Maximum Child Elements"},"lighthouse-core/audits/dobetterweb/dom-size.js | title":{"message":"Evita un tamaño excesivo de DOM"},"lighthouse-core/audits/font-display.js | description":{"message":"Utiliza la función de CSS font-display para que los usuarios vean el texto mientras se carga la fuente web. [Más información](https://developers.google.com/web/updates/2016/02/font-display)"},"lighthouse-core/audits/font-display.js | failureTitle":{"message":"Asegúrate de que el texto permanece visible mientras se carga la fuente web"},"lighthouse-core/audits/font-display.js | title":{"message":"Todo el texto permanece visible mientras se carga la fuente web"},"lighthouse-core/audits/mainthread-work-breakdown.js | columnCategory":{"message":"Categoría"},"lighthouse-core/audits/mainthread-work-breakdown.js | description":{"message":"Te recomendamos que reduzcas el tiempo de análisis, compilación y ejecución de JavaScript. Para ello, puedes utilizar cargas útiles de JS más pequeñas."},"lighthouse-core/audits/mainthread-work-breakdown.js | failureTitle":{"message":"Minimiza el trabajo del hilo principal"},"lighthouse-core/audits/mainthread-work-breakdown.js | title":{"message":"Minimiza el trabajo del hilo principal"},"lighthouse-core/audits/metrics/estimated-input-latency.js | description":{"message":"La puntuación anterior es una estimación de cuánto tarda tu aplicación en responder a las acciones de los usuarios (en milisegundos) durante el periodo de 5 s más activo de la carga de la página. Si la latencia es superior a 50 ms, es posible que los usuarios noten que la aplicación funciona con lentitud. [Más información](https://developers.google.com/web/tools/lighthouse/audits/estimated-input-latency)"},"lighthouse-core/audits/metrics/estimated-input-latency.js | title":{"message":"Latencia de entrada estimada"},"lighthouse-core/audits/metrics/first-contentful-paint.js | description":{"message":"El primer renderizado con contenido indica el momento en el que se renderiza el primer texto o la primera imagen. [Más información](https://developers.google.com/web/tools/lighthouse/audits/first-contentful-paint)."},"lighthouse-core/audits/metrics/first-contentful-paint.js | title":{"message":"Primer renderizado con contenido"},"lighthouse-core/audits/metrics/first-cpu-idle.js | description":{"message":"El primer tiempo inactivo de la CPU indica la primera vez que el hilo principal de la página está lo suficientemente inactivo para recibir acciones del usuario. [Más información](https://developers.google.com/web/tools/lighthouse/audits/first-interactive)"},"lighthouse-core/audits/metrics/first-cpu-idle.js | title":{"message":"Primer tiempo inactivo de la CPU"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | description":{"message":"El primer renderizado significativo mide el momento en que se muestra el contenido principal de la página. [Más información](https://developers.google.com/web/tools/lighthouse/audits/first-meaningful-paint)"},"lighthouse-core/audits/metrics/first-meaningful-paint.js | title":{"message":"Primer renderizado significativo"},"lighthouse-core/audits/metrics/interactive.js | description":{"message":"La métrica Tiempo hasta que está interactiva indica el momento en el que la página es totalmente interactiva. [Más información](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive)"},"lighthouse-core/audits/metrics/interactive.js | title":{"message":"Tiempo hasta que está interactiva"},"lighthouse-core/audits/metrics/speed-index.js | description":{"message":"El índice de velocidad indica la rapidez con la que se puede ver el contenido de una página. [Más información](https://developers.google.com/web/tools/lighthouse/audits/speed-index)"},"lighthouse-core/audits/metrics/speed-index.js | title":{"message":"Índice de velocidad"},"lighthouse-core/audits/redirects.js | description":{"message":"Las redirecciones provocan retrasos adicionales antes de que la página se pueda cargar. [Más información](https://developers.google.com/web/tools/lighthouse/audits/redirects)"},"lighthouse-core/audits/redirects.js | title":{"message":"Evita que haya varias redirecciones de página"},"lighthouse-core/audits/time-to-first-byte.js | description":{"message":"El tiempo hasta el primer byte indica el momento en el que el servidor envía una respuesta. [Más información](https://developers.google.com/web/tools/lighthouse/audits/ttfb)"},"lighthouse-core/audits/time-to-first-byte.js | displayValue":{"message":"El documento raíz ha tardado {timeInMs, number, milliseconds} ms"},"lighthouse-core/audits/time-to-first-byte.js | failureTitle":{"message":"Reduce los tiempos de respuesta del servidor (TTFB)"},"lighthouse-core/audits/time-to-first-byte.js | title":{"message":"Los tiempos de respuesta del servidor son rápidos (TTFB)"},"lighthouse-core/audits/user-timings.js | columnDuration":{"message":"Duración"},"lighthouse-core/audits/user-timings.js | columnName":{"message":"Nombre"},"lighthouse-core/audits/user-timings.js | columnStartTime":{"message":"Hora de inicio"},"lighthouse-core/audits/user-timings.js | columnType":{"message":"Tipo"},"lighthouse-core/audits/user-timings.js | description":{"message":"Te recomendamos que uses la API User Timing en tu aplicación para calcular su rendimiento real durante las principales experiencias de usuario. [Más información](https://developers.google.com/web/tools/lighthouse/audits/user-timing)."},"lighthouse-core/audits/user-timings.js | displayValue":{"message":"{itemCount,plural, =1{1 tiempo de usuario}other{# tiempos de usuario}}"},"lighthouse-core/audits/user-timings.js | title":{"message":"Medidas y marcas de User Timing"},"lighthouse-core/audits/uses-rel-preconnect.js | description":{"message":"Te recomendamos que añadas sugerencias de recursos preconnect o dns-prefetch para establecer conexiones previas con orígenes externos. [Más información](https://developers.google.com/web/fundamentals/performance/resource-prioritization#preconnect)"},"lighthouse-core/audits/uses-rel-preconnect.js | title":{"message":"Establece conexión previamente con los orígenes necesarios"},"lighthouse-core/audits/uses-rel-preload.js | description":{"message":"Te recomendamos que uses <link rel=preload> para dar prioridad a los recursos que se solicitan más tarde al cargar la página. [Más información](https://developers.google.com/web/tools/lighthouse/audits/preload)"},"lighthouse-core/audits/uses-rel-preload.js | title":{"message":"Carga previamente las solicitudes clave"},"lighthouse-core/config/default-config.js | diagnosticsGroupDescription":{"message":"Consulta más información sobre el rendimiento de tu aplicación."},"lighthouse-core/config/default-config.js | diagnosticsGroupTitle":{"message":"Diagnósticos"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupDescription":{"message":"El aspecto más importante del rendimiento es la rapidez con la que se renderizan los píxeles en la pantalla. Métricas clave: Primer renderizado con contenido y Primer renderizado significativo"},"lighthouse-core/config/default-config.js | firstPaintImprovementsGroupTitle":{"message":"Mejoras del primer renderizado"},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupDescription":{"message":"Estas optimizaciones pueden hacer que tus páginas se carguen más rápido."},"lighthouse-core/config/default-config.js | loadOpportunitiesGroupTitle":{"message":"Oportunidades"},"lighthouse-core/config/default-config.js | metricGroupTitle":{"message":"Métricas"},"lighthouse-core/config/default-config.js | overallImprovementsGroupDescription":{"message":"Mejora la experiencia de carga general para que la página responda bien y se pueda usar lo antes posible. Métricas clave: Tiempo hasta que está interactiva, Índice de velocidad"},"lighthouse-core/config/default-config.js | overallImprovementsGroupTitle":{"message":"Mejoras generales"},"lighthouse-core/config/default-config.js | performanceCategoryTitle":{"message":"Rendimiento"},"lighthouse-core/lib/i18n/i18n.js | columnCacheTTL":{"message":"Tiempo de vida en caché"},"lighthouse-core/lib/i18n/i18n.js | columnSize":{"message":"Tamaño (kB)"},"lighthouse-core/lib/i18n/i18n.js | columnTimeSpent":{"message":"Duración"},"lighthouse-core/lib/i18n/i18n.js | columnURL":{"message":"URL"},"lighthouse-core/lib/i18n/i18n.js | columnWastedBytes":{"message":"Ahorro potencial (kB)"},"lighthouse-core/lib/i18n/i18n.js | columnWastedMs":{"message":"Ahorro potencial (ms)"},"lighthouse-core/lib/i18n/i18n.js | displayValueByteSavings":{"message":"Ahorro potencial de {wastedBytes, number, bytes} kB"},"lighthouse-core/lib/i18n/i18n.js | displayValueMsSavings":{"message":"Ahorro potencial de {wastedMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | ms":{"message":"{timeInMs, number, milliseconds} ms"},"lighthouse-core/lib/i18n/i18n.js | seconds":{"message":"{timeInMs, number, seconds} s"},"lighthouse-core/report/html/renderer/util.js | auditGroupExpandTooltip":{"message":"Mostrar auditorías"},"lighthouse-core/report/html/renderer/util.js | crcInitialNavigation":{"message":"Navegación inicial"},"lighthouse-core/report/html/renderer/util.js | crcLongestDurationLabel":{"message":"Latencia de ruta crítica máxima:"},"lighthouse-core/report/html/renderer/util.js | errorLabel":{"message":"Error"},"lighthouse-core/report/html/renderer/util.js | errorMissingAuditInfo":{"message":"Error del informe: no hay información de la auditoría"},"lighthouse-core/report/html/renderer/util.js | labDataTitle":{"message":"Datos de prueba"},"lighthouse-core/report/html/renderer/util.js | lsPerformanceCategoryDescription":{"message":"[Lighthouse](https://developers.google.com/web/tools/lighthouse/) ha analizado la página actual mediante una emulación de 3G. Los valores son estimaciones y pueden variar."},"lighthouse-core/report/html/renderer/util.js | manualAuditsGroupTitle":{"message":"Elementos adicionales que se deben comprobar manualmente"},"lighthouse-core/report/html/renderer/util.js | notApplicableAuditsGroupTitle":{"message":"No aplicable"},"lighthouse-core/report/html/renderer/util.js | opportunityResourceColumnLabel":{"message":"Oportunidad"},"lighthouse-core/report/html/renderer/util.js | opportunitySavingsColumnLabel":{"message":"Ahorro estimado"},"lighthouse-core/report/html/renderer/util.js | passedAuditsGroupTitle":{"message":"Auditorías aprobadas"},"lighthouse-core/report/html/renderer/util.js | scorescaleLabel":{"message":"Escala de puntuación:"},"lighthouse-core/report/html/renderer/util.js | toplevelWarningsMessage":{"message":"Algunos problemas han afectado a la ejecución de Lighthouse:"},"lighthouse-core/report/html/renderer/util.js | varianceDisclaimer":{"message":"Los valores son estimados y pueden variar."},"lighthouse-core/report/html/renderer/util.js | warningHeader":{"message":"Advertencias: "}};},{}],49:[function(require,module,exports){module.exports={"lighthouse-core/audits/bootup-time.js | chromeExtensionsWarning":{"message":"Chromen laajennukset heikensivät tämän sivun latausnopeutta. Yritä tarkastaa sivu incognito-tilassa tai Chrome-profiililla, johon ei ole lisätty laajennuksia."},"lighthouse-core/audits/bootup-time.js | columnScriptEval":{"message":"Skriptin arviointi"},"lighthouse-core/audits/bootup-time.js | columnScriptParse":{"message":"Skriptin jäsennys"},"lighthouse-core/audits/bootup-time.js | columnTotal":{"message":"Yhteensä"},"lighthouse-core/audits/bootup-time.js | description":{"message":"Suosittelemme vähentämään JS:n jäsentämiseen, kääntämiseen ja suorittamiseen kuluvaa aikaa. Pienempien JS-resurssien jakeleminen voi helpottaa tätä. [Lue lisää](https://developers.google.com/web/tools/lighthouse/audits/bootup)."},"lighthouse-core/audits/bootup-time.js | failureTitle":{"message":"Vähennä JavaScriptin suorittamiseen kuluvaa aikaa"},"lighthouse-core/audits/bootup-time.js | title":{"message":"JavaScriptin suorittamiseen kuluva aika"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | description":{"message":"Suuret GIFit eivät ole tehokas tapa jaella animoitua sisältöä. Voit pienentää ladattavien tavujen määrää jakelemalla animaatioita MPEG4- tai WebM-muodossa ja staattisia kuvia PNG- tai WebP-muodossa. [Lue lisää](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/replace-animated-gifs-with-video/)"},"lighthouse-core/audits/byte-efficiency/efficient-animated-content.js | title":{"message":"Jakele animaatiosisältöä videomuodossa"},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | description":{"message":"Suosittelemme lykkäämään poissa näkyvistä olevien ja piilotettujen kuvien lataamista, kunnes kaikki kriittiset resurssit on ladattu. Tämä lyhentää interaktiivisuutta edeltävää aikaa. [Lue lisää](https://developers.google.com/web/tools/lighthouse/audits/offscreen-images)."},"lighthouse-core/audits/byte-efficiency/offscreen-images.js | title":{"message":"Lykkää kuvien lataamista, jos ne eivät ole näkyvissä"},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | description":{"message":"Resurssit estävät sivun ensimmäisen renderöinnin. Suosittelemme jakelemaan kriittiset JS- ja CSS-osat sivuun upotettuina ja lykkäämään kaikkien ei-kriittisten JS- tai tyyliosien lataamista. [Lue lisää](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources)."},"lighthouse-core/audits/byte-efficiency/render-blocking-resources.js | title":{"message":"Poista renderöinnin estävät resurssit"},"lighthouse-core/audits/byte-efficiency/total-byte-weight.js | description":{"message":"Suuret verkkoresurssit aiheuttavat kuluja käyttäjille ja liittyvät vahvasti