export default class PerformanceMetricsModel extends SDK.SDKModel{constructor(target){super(target);this._agent=target.performanceAgent();const mode=MetricMode;this._metricModes=new Map([['TaskDuration',mode.CumulativeTime],['ScriptDuration',mode.CumulativeTime],['LayoutDuration',mode.CumulativeTime],['RecalcStyleDuration',mode.CumulativeTime],['LayoutCount',mode.CumulativeCount],['RecalcStyleCount',mode.CumulativeCount]]);this._metricData=new Map();}
enable(){return this._agent.enable();}
disable(){return this._agent.disable();}
async requestMetrics(){const rawMetrics=await this._agent.getMetrics()||[];const metrics=new Map();const timestamp=performance.now();for(const metric of rawMetrics){let data=this._metricData.get(metric.name);if(!data){data={};this._metricData.set(metric.name,data);}
let value;switch(this._metricModes.get(metric.name)){case MetricMode.CumulativeTime:value=data.lastTimestamp?Number.constrain((metric.value-data.lastValue)*1000/(timestamp-data.lastTimestamp),0,1):0;data.lastValue=metric.value;data.lastTimestamp=timestamp;break;case MetricMode.CumulativeCount:value=data.lastTimestamp?Math.max(0,(metric.value-data.lastValue)*1000/(timestamp-data.lastTimestamp)):0;data.lastValue=metric.value;data.lastTimestamp=timestamp;break;default:value=metric.value;break;}
metrics.set(metric.name,value);}
return{metrics:metrics,timestamp:timestamp};}}
export const MetricMode={CumulativeTime:Symbol('CumulativeTime'),CumulativeCount:Symbol('CumulativeCount'),};self.SDK=self.SDK||{};SDK=SDK||{};SDK.PerformanceMetricsModel=PerformanceMetricsModel;SDK.PerformanceMetricsModel.MetricMode=MetricMode;SDK.SDKModel.register(SDK.PerformanceMetricsModel,SDK.Target.Capability.DOM,false);