export default class ShortcutsScreen{constructor(){this._sections={};}
static registerShortcuts(){const elementsSection=UI.shortcutsScreen.section(Common.UIString('Elements Panel'));const navigate=ElementsPanelShortcuts.NavigateUp.concat(ElementsPanelShortcuts.NavigateDown);elementsSection.addRelatedKeys(navigate,Common.UIString('Navigate elements'));const expandCollapse=ElementsPanelShortcuts.Expand.concat(ElementsPanelShortcuts.Collapse);elementsSection.addRelatedKeys(expandCollapse,Common.UIString('Expand/collapse'));elementsSection.addAlternateKeys(ElementsPanelShortcuts.EditAttribute,Common.UIString('Edit attribute'));elementsSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('elements.hide-element'),Common.UIString('Hide element'));elementsSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('elements.edit-as-html'),Common.UIString('Toggle edit as HTML'));const stylesPaneSection=UI.shortcutsScreen.section(Common.UIString('Styles Pane'));const nextPreviousProperty=ElementsPanelShortcuts.NextProperty.concat(ElementsPanelShortcuts.PreviousProperty);stylesPaneSection.addRelatedKeys(nextPreviousProperty,Common.UIString('Next/previous property'));stylesPaneSection.addRelatedKeys(ElementsPanelShortcuts.IncrementValue,Common.UIString('Increment value'));stylesPaneSection.addRelatedKeys(ElementsPanelShortcuts.DecrementValue,Common.UIString('Decrement value'));stylesPaneSection.addAlternateKeys(ElementsPanelShortcuts.IncrementBy10,Common.UIString('Increment by %f',10));stylesPaneSection.addAlternateKeys(ElementsPanelShortcuts.DecrementBy10,Common.UIString('Decrement by %f',10));stylesPaneSection.addAlternateKeys(ElementsPanelShortcuts.IncrementBy100,Common.UIString('Increment by %f',100));stylesPaneSection.addAlternateKeys(ElementsPanelShortcuts.DecrementBy100,Common.UIString('Decrement by %f',100));stylesPaneSection.addAlternateKeys(ElementsPanelShortcuts.IncrementBy01,Common.UIString('Increment by %f',0.1));stylesPaneSection.addAlternateKeys(ElementsPanelShortcuts.DecrementBy01,Common.UIString('Decrement by %f',0.1));const consoleSection=UI.shortcutsScreen.section(Common.UIString('Console'));consoleSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('console.clear'),Common.UIString('Clear console'));consoleSection.addRelatedKeys(ConsolePanelShortcuts.AcceptSuggestion,Common.UIString('Accept suggestion'));consoleSection.addAlternateKeys(ConsolePanelShortcuts.ClearConsolePrompt,Common.UIString('Clear console prompt'));consoleSection.addRelatedKeys(ConsolePanelShortcuts.NextPreviousLine,Common.UIString('Next/previous line'));if(Host.isMac()){consoleSection.addRelatedKeys(ConsolePanelShortcuts.NextPreviousCommand,Common.UIString('Next/previous command'));}
consoleSection.addKey(ConsolePanelShortcuts.ExecuteCommand,Common.UIString('Execute command'));const debuggerSection=UI.shortcutsScreen.section(Common.UIString('Debugger'));debuggerSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.toggle-pause'),Common.UIString('Pause/ Continue'));debuggerSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.step-over'),Common.UIString('Step over'));debuggerSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.step-into'),Common.UIString('Step into'));debuggerSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.step-out'),Common.UIString('Step out'));const nextAndPrevFrameKeys=UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.next-call-frame').concat(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.previous-call-frame'));debuggerSection.addRelatedKeys(nextAndPrevFrameKeys,Common.UIString('Next/previous call frame'));debuggerSection.addAlternateKeys(SourcesPanelShortcuts.EvaluateSelectionInConsole,Common.UIString('Evaluate selection in console'));debuggerSection.addAlternateKeys(SourcesPanelShortcuts.AddSelectionToWatch,Common.UIString('Add selection to watch'));debuggerSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.toggle-breakpoint'),Common.UIString('Toggle breakpoint'));debuggerSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.toggle-breakpoint-enabled'),Common.UIString('Toggle breakpoint enabled'));debuggerSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.toggle-breakpoints-active'),Common.UIString('Toggle all breakpoints'));debuggerSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('debugger.breakpoint-input-window'),ls`Open breakpoint editor`);const editingSection=UI.shortcutsScreen.section(Common.UIString('Text Editor'));editingSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('sources.go-to-member'),Common.UIString('Go to member'));editingSection.addAlternateKeys(SourcesPanelShortcuts.ToggleAutocompletion,Common.UIString('Autocompletion'));editingSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('sources.go-to-line'),Common.UIString('Go to line'));editingSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('sources.jump-to-previous-location'),Common.UIString('Jump to previous editing location'));editingSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('sources.jump-to-next-location'),Common.UIString('Jump to next editing location'));editingSection.addAlternateKeys(SourcesPanelShortcuts.ToggleComment,Common.UIString('Toggle comment'));editingSection.addAlternateKeys(SourcesPanelShortcuts.IncreaseCSSUnitByOne,Common.UIString('Increment CSS unit by 1'));editingSection.addAlternateKeys(SourcesPanelShortcuts.DecreaseCSSUnitByOne,Common.UIString('Decrement CSS unit by 1'));editingSection.addAlternateKeys(SourcesPanelShortcuts.IncreaseCSSUnitByTen,Common.UIString('Increment CSS unit by 10'));editingSection.addAlternateKeys(SourcesPanelShortcuts.DecreaseCSSUnitByTen,Common.UIString('Decrement CSS unit by 10'));editingSection.addAlternateKeys(SourcesPanelShortcuts.SelectNextOccurrence,Common.UIString('Select next occurrence'));editingSection.addAlternateKeys(SourcesPanelShortcuts.SoftUndo,Common.UIString('Soft undo'));editingSection.addAlternateKeys(SourcesPanelShortcuts.GotoMatchingBracket,Common.UIString('Go to matching bracket'));editingSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('sources.close-editor-tab'),Common.UIString('Close editor tab'));editingSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('sources.switch-file'),Common.UIString('Switch between files with the same name and different extensions.'));const performanceSection=UI.shortcutsScreen.section(Common.UIString('Performance Panel'));performanceSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.toggle-recording'),Common.UIString('Start/stop recording'));performanceSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.record-reload'),Common.UIString('Record page reload'));performanceSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.save-to-file'),Common.UIString('Save profile'));performanceSection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.load-from-file'),Common.UIString('Load profile'));performanceSection.addRelatedKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.jump-to-previous-frame').concat(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.jump-to-next-frame')),Common.UIString('Jump to previous/next frame'));performanceSection.addRelatedKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.show-history'),Common.UIString('Pick a recording from history'));performanceSection.addRelatedKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.previous-recording').concat(UI.shortcutRegistry.shortcutDescriptorsForAction('timeline.next-recording')),Common.UIString('Show previous/next recording'));const memorySection=UI.shortcutsScreen.section(Common.UIString('Memory Panel'));memorySection.addAlternateKeys(UI.shortcutRegistry.shortcutDescriptorsForAction('profiler.heap-toggle-recording'),Common.UIString('Start/stop recording'));const layersSection=UI.shortcutsScreen.section(Common.UIString('Layers Panel'));layersSection.addAlternateKeys(LayersPanelShortcuts.ResetView,Common.UIString('Reset view'));layersSection.addAlternateKeys(LayersPanelShortcuts.PanMode,Common.UIString('Switch to pan mode'));layersSection.addAlternateKeys(LayersPanelShortcuts.RotateMode,Common.UIString('Switch to rotate mode'));layersSection.addAlternateKeys(LayersPanelShortcuts.TogglePanRotate,Common.UIString('Temporarily toggle pan/rotate mode while held'));layersSection.addAlternateKeys(LayersPanelShortcuts.ZoomIn,Common.UIString('Zoom in'));layersSection.addAlternateKeys(LayersPanelShortcuts.ZoomOut,Common.UIString('Zoom out'));layersSection.addRelatedKeys(LayersPanelShortcuts.Up.concat(LayersPanelShortcuts.Down),Common.UIString('Pan or rotate up/down'));layersSection.addRelatedKeys(LayersPanelShortcuts.Left.concat(LayersPanelShortcuts.Right),Common.UIString('Pan or rotate left/right'));}
section(name){let section=this._sections[name];if(!section){this._sections[name]=section=new ShortcutsSection(name);}
return section;}
createShortcutsTabView(){const orderedSections=[];for(const section in this._sections){orderedSections.push(this._sections[section]);}
function compareSections(a,b){return a.order-b.order;}
orderedSections.sort(compareSections);const widget=new UI.Widget();widget.element.className='settings-tab-container';widget.element.createChild('header').createChild('h1').createTextChild(ls`Shortcuts`);const scrollPane=widget.element.createChild('div','settings-container-wrapper');const container=scrollPane.createChild('div');container.className='settings-content settings-container';for(let i=0;i<orderedSections.length;++i){orderedSections[i].renderSection(container);}
const note=scrollPane.createChild('p','settings-footnote');note.appendChild(UI.createDocumentationLink('iterate/inspect-styles/shortcuts',Common.UIString('Full list of DevTools keyboard shortcuts and gestures')));return widget;}}
UI.shortcutsScreen;export class ShortcutsSection{constructor(name){this.name=name;this._lines=([]);this.order=++ShortcutsSection._sequenceNumber;}
addKey(key,description){this._addLine(this._renderKey(key),description);}
addRelatedKeys(keys,description){this._addLine(this._renderSequence(keys,'/'),description);}
addAlternateKeys(keys,description){this._addLine(this._renderSequence(keys,Common.UIString('or')),description);}
_addLine(keyElement,description){this._lines.push({key:keyElement,text:description});}
renderSection(container){const parent=container.createChild('div','settings-block');const headLine=parent.createChild('div','settings-line');headLine.createChild('div','settings-key-cell');headLine.createChild('div','settings-section-title settings-cell').textContent=this.name;UI.ARIAUtils.markAsHeading(headLine,2);for(let i=0;i<this._lines.length;++i){const line=parent.createChild('div','settings-line');const keyCell=line.createChild('div','settings-key-cell');keyCell.appendChild(this._lines[i].key);keyCell.appendChild(this._createSpan('settings-key-delimiter',':'));line.createChild('div','settings-cell').textContent=this._lines[i].text;}}
_renderSequence(sequence,delimiter){const delimiterSpan=this._createSpan('settings-key-delimiter',delimiter);return this._joinNodes(sequence.map(this._renderKey.bind(this)),delimiterSpan);}
_renderKey(key){const keyName=key.name;const plus=this._createSpan('settings-combine-keys','+');return this._joinNodes(keyName.split(' + ').map(this._createSpan.bind(this,'settings-key')),plus);}
_createSpan(className,textContent){const node=createElement('span');node.className=className;node.textContent=textContent;return node;}
_joinNodes(nodes,delimiter){const result=createDocumentFragment();for(let i=0;i<nodes.length;++i){if(i>0){result.appendChild(delimiter.cloneNode(true));}
result.appendChild(nodes[i]);}
return result;}}
ShortcutsSection._sequenceNumber=0;export const ElementsPanelShortcuts={NavigateUp:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Up)],NavigateDown:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Down)],Expand:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Right)],Collapse:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Left)],EditAttribute:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Enter)],NextProperty:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Tab)],PreviousProperty:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Tab,UI.KeyboardShortcut.Modifiers.Shift)],IncrementValue:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Up)],DecrementValue:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Down)],IncrementBy10:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.PageUp),UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Up,UI.KeyboardShortcut.Modifiers.Shift)],DecrementBy10:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.PageDown),UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Down,UI.KeyboardShortcut.Modifiers.Shift)],IncrementBy100:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.PageUp,UI.KeyboardShortcut.Modifiers.Shift)],DecrementBy100:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.PageDown,UI.KeyboardShortcut.Modifiers.Shift)],IncrementBy01:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Up,UI.KeyboardShortcut.Modifiers.Alt)],DecrementBy01:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Down,UI.KeyboardShortcut.Modifiers.Alt)]};export const ConsolePanelShortcuts={AcceptSuggestion:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Tab),UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Right)],ClearConsolePrompt:[UI.KeyboardShortcut.makeDescriptor('u',UI.KeyboardShortcut.Modifiers.Ctrl)],ExecuteCommand:UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Enter),NextPreviousLine:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Down),UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Up)],NextPreviousCommand:[UI.KeyboardShortcut.makeDescriptor('N',UI.KeyboardShortcut.Modifiers.Alt),UI.KeyboardShortcut.makeDescriptor('P',UI.KeyboardShortcut.Modifiers.Alt)],};export const SourcesPanelShortcuts={SelectNextOccurrence:[UI.KeyboardShortcut.makeDescriptor('d',UI.KeyboardShortcut.Modifiers.CtrlOrMeta)],SoftUndo:[UI.KeyboardShortcut.makeDescriptor('u',UI.KeyboardShortcut.Modifiers.CtrlOrMeta)],GotoMatchingBracket:[UI.KeyboardShortcut.makeDescriptor('m',UI.KeyboardShortcut.Modifiers.Ctrl)],ToggleAutocompletion:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Space,UI.KeyboardShortcut.Modifiers.Ctrl)],IncreaseCSSUnitByOne:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Up,UI.KeyboardShortcut.Modifiers.Alt)],DecreaseCSSUnitByOne:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Down,UI.KeyboardShortcut.Modifiers.Alt)],IncreaseCSSUnitByTen:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.PageUp,UI.KeyboardShortcut.Modifiers.Alt)],DecreaseCSSUnitByTen:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.PageDown,UI.KeyboardShortcut.Modifiers.Alt)],EvaluateSelectionInConsole:[UI.KeyboardShortcut.makeDescriptor('e',UI.KeyboardShortcut.Modifiers.Shift|UI.KeyboardShortcut.Modifiers.Ctrl)],AddSelectionToWatch:[UI.KeyboardShortcut.makeDescriptor('a',UI.KeyboardShortcut.Modifiers.Shift|UI.KeyboardShortcut.Modifiers.Ctrl)],ToggleComment:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Slash,UI.KeyboardShortcut.Modifiers.CtrlOrMeta)],};export const LayersPanelShortcuts={ResetView:[UI.KeyboardShortcut.makeDescriptor('0')],PanMode:[UI.KeyboardShortcut.makeDescriptor('x')],RotateMode:[UI.KeyboardShortcut.makeDescriptor('v')],TogglePanRotate:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Shift)],ZoomIn:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Plus,UI.KeyboardShortcut.Modifiers.Shift),UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.NumpadPlus)],ZoomOut:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Minus,UI.KeyboardShortcut.Modifiers.Shift),UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.NumpadMinus)],Up:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Up),UI.KeyboardShortcut.makeDescriptor('w')],Down:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Down),UI.KeyboardShortcut.makeDescriptor('s')],Left:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Left),UI.KeyboardShortcut.makeDescriptor('a')],Right:[UI.KeyboardShortcut.makeDescriptor(UI.KeyboardShortcut.Keys.Right),UI.KeyboardShortcut.makeDescriptor('d')]};self.UI=self.UI||{};UI=UI||{};UI.ShortcutsScreen=ShortcutsScreen;UI.ShortcutsSection=ShortcutsSection;UI.ShortcutsScreen.ElementsPanelShortcuts=ElementsPanelShortcuts;UI.ShortcutsScreen.ConsolePanelShortcuts=ConsolePanelShortcuts;UI.ShortcutsScreen.SourcesPanelShortcuts=SourcesPanelShortcuts;UI.ShortcutsScreen.LayersPanelShortcuts=LayersPanelShortcuts;