// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_SHARED_INTERNAL_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_SHARED_INTERNAL_H_

#include <stdint.h>

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/cpp/bindings/lib/native_struct_data.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/bindings_export.h"

namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace mojo {
namespace interface_control {
namespace internal {
class RunMessageParams_Data;
class RunResponseMessageParams_Data;
class QueryVersion_Data;
class QueryVersionResult_Data;
class FlushForTesting_Data;
class RunOrClosePipeMessageParams_Data;
class RequireVersion_Data;
class RunInput_Data;
class RunOutput_Data;
class RunOrClosePipeInput_Data;

#pragma pack(push, 1)


class MOJO_CPP_BINDINGS_EXPORT RunInput_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  RunInput_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~RunInput_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RunInput_Data));
      new (data()) RunInput_Data();
    }

    void AllocateInline(mojo::internal::Buffer* buffer, void* ptr) {
      const char* start = static_cast<const char*>(buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      buffer_ = buffer;
      index_ = slot - start;
      new (data()) RunInput_Data();
    }

    bool is_null() const { return !buffer_; }
    RunInput_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RunInput_Data>(index_);
    }
    RunInput_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<RunInput_Tag>(0);
    data.unknown = 0U;
  }

  enum class RunInput_Tag : uint32_t {

    QUERY_VERSION,
    FLUSH_FOR_TESTING,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::QueryVersion_Data> f_query_version;
    mojo::internal::Pointer<internal::FlushForTesting_Data> f_flush_for_testing;
    uint64_t unknown;
  };

  uint32_t size;
  RunInput_Tag tag;
  Union_ data;
};
static_assert(sizeof(RunInput_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(RunInput_Data)");


class MOJO_CPP_BINDINGS_EXPORT RunOutput_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  RunOutput_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~RunOutput_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RunOutput_Data));
      new (data()) RunOutput_Data();
    }

    void AllocateInline(mojo::internal::Buffer* buffer, void* ptr) {
      const char* start = static_cast<const char*>(buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      buffer_ = buffer;
      index_ = slot - start;
      new (data()) RunOutput_Data();
    }

    bool is_null() const { return !buffer_; }
    RunOutput_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RunOutput_Data>(index_);
    }
    RunOutput_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<RunOutput_Tag>(0);
    data.unknown = 0U;
  }

  enum class RunOutput_Tag : uint32_t {

    QUERY_VERSION_RESULT,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::QueryVersionResult_Data> f_query_version_result;
    uint64_t unknown;
  };

  uint32_t size;
  RunOutput_Tag tag;
  Union_ data;
};
static_assert(sizeof(RunOutput_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(RunOutput_Data)");


class MOJO_CPP_BINDINGS_EXPORT RunOrClosePipeInput_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  RunOrClosePipeInput_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~RunOrClosePipeInput_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RunOrClosePipeInput_Data));
      new (data()) RunOrClosePipeInput_Data();
    }

    void AllocateInline(mojo::internal::Buffer* buffer, void* ptr) {
      const char* start = static_cast<const char*>(buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      buffer_ = buffer;
      index_ = slot - start;
      new (data()) RunOrClosePipeInput_Data();
    }

    bool is_null() const { return !buffer_; }
    RunOrClosePipeInput_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RunOrClosePipeInput_Data>(index_);
    }
    RunOrClosePipeInput_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<RunOrClosePipeInput_Tag>(0);
    data.unknown = 0U;
  }

  enum class RunOrClosePipeInput_Tag : uint32_t {

    REQUIRE_VERSION,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::RequireVersion_Data> f_require_version;
    uint64_t unknown;
  };

  uint32_t size;
  RunOrClosePipeInput_Tag tag;
  Union_ data;
};
static_assert(sizeof(RunOrClosePipeInput_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(RunOrClosePipeInput_Data)");
class MOJO_CPP_BINDINGS_EXPORT RunMessageParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RunMessageParams_Data));
      new (data()) RunMessageParams_Data();
    }

    bool is_null() const { return !buffer_; }
    RunMessageParams_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RunMessageParams_Data>(index_);
    }
    RunMessageParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::RunInput_Data input;

 private:
  RunMessageParams_Data();
  ~RunMessageParams_Data() = delete;
};
static_assert(sizeof(RunMessageParams_Data) == 24,
              "Bad sizeof(RunMessageParams_Data)");
class MOJO_CPP_BINDINGS_EXPORT RunResponseMessageParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RunResponseMessageParams_Data));
      new (data()) RunResponseMessageParams_Data();
    }

    bool is_null() const { return !buffer_; }
    RunResponseMessageParams_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RunResponseMessageParams_Data>(index_);
    }
    RunResponseMessageParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::RunOutput_Data output;

 private:
  RunResponseMessageParams_Data();
  ~RunResponseMessageParams_Data() = delete;
};
static_assert(sizeof(RunResponseMessageParams_Data) == 24,
              "Bad sizeof(RunResponseMessageParams_Data)");
class MOJO_CPP_BINDINGS_EXPORT QueryVersion_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(QueryVersion_Data));
      new (data()) QueryVersion_Data();
    }

    bool is_null() const { return !buffer_; }
    QueryVersion_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<QueryVersion_Data>(index_);
    }
    QueryVersion_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  QueryVersion_Data();
  ~QueryVersion_Data() = delete;
};
static_assert(sizeof(QueryVersion_Data) == 8,
              "Bad sizeof(QueryVersion_Data)");
class MOJO_CPP_BINDINGS_EXPORT QueryVersionResult_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(QueryVersionResult_Data));
      new (data()) QueryVersionResult_Data();
    }

    bool is_null() const { return !buffer_; }
    QueryVersionResult_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<QueryVersionResult_Data>(index_);
    }
    QueryVersionResult_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t version;
  uint8_t padfinal_[4];

 private:
  QueryVersionResult_Data();
  ~QueryVersionResult_Data() = delete;
};
static_assert(sizeof(QueryVersionResult_Data) == 16,
              "Bad sizeof(QueryVersionResult_Data)");
class MOJO_CPP_BINDINGS_EXPORT FlushForTesting_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(FlushForTesting_Data));
      new (data()) FlushForTesting_Data();
    }

    bool is_null() const { return !buffer_; }
    FlushForTesting_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<FlushForTesting_Data>(index_);
    }
    FlushForTesting_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  FlushForTesting_Data();
  ~FlushForTesting_Data() = delete;
};
static_assert(sizeof(FlushForTesting_Data) == 8,
              "Bad sizeof(FlushForTesting_Data)");
class MOJO_CPP_BINDINGS_EXPORT RunOrClosePipeMessageParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RunOrClosePipeMessageParams_Data));
      new (data()) RunOrClosePipeMessageParams_Data();
    }

    bool is_null() const { return !buffer_; }
    RunOrClosePipeMessageParams_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RunOrClosePipeMessageParams_Data>(index_);
    }
    RunOrClosePipeMessageParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::RunOrClosePipeInput_Data input;

 private:
  RunOrClosePipeMessageParams_Data();
  ~RunOrClosePipeMessageParams_Data() = delete;
};
static_assert(sizeof(RunOrClosePipeMessageParams_Data) == 24,
              "Bad sizeof(RunOrClosePipeMessageParams_Data)");
class MOJO_CPP_BINDINGS_EXPORT RequireVersion_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RequireVersion_Data));
      new (data()) RequireVersion_Data();
    }

    bool is_null() const { return !buffer_; }
    RequireVersion_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RequireVersion_Data>(index_);
    }
    RequireVersion_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t version;
  uint8_t padfinal_[4];

 private:
  RequireVersion_Data();
  ~RequireVersion_Data() = delete;
};
static_assert(sizeof(RequireVersion_Data) == 16,
              "Bad sizeof(RequireVersion_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace interface_control
}  // namespace mojo

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_INTERFACE_CONTROL_MESSAGES_MOJOM_SHARED_INTERNAL_H_