// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_COMMON_MEMORY_ALLOCATOR_DUMP_CROSS_PROCESS_UID_MOJOM_SHARED_H_
#define MOJO_COMMON_MEMORY_ALLOCATOR_DUMP_CROSS_PROCESS_UID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/native_struct_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/common/memory_allocator_dump_cross_process_uid.mojom-shared-internal.h"


namespace mojo {
namespace common {
namespace mojom {
class MemoryAllocatorDumpCrossProcessUidDataView;



}  // namespace mojom
}  // namespace common
}  // namespace mojo

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo::common::mojom::MemoryAllocatorDumpCrossProcessUidDataView> {
  using Data = ::mojo::common::mojom::internal::MemoryAllocatorDumpCrossProcessUid_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::STRUCT;
};

}  // namespace internal
}  // namespace mojo


namespace mojo {
namespace common {
namespace mojom {
class MemoryAllocatorDumpCrossProcessUidDataView {
 public:
  MemoryAllocatorDumpCrossProcessUidDataView() {}

  MemoryAllocatorDumpCrossProcessUidDataView(
      internal::MemoryAllocatorDumpCrossProcessUid_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t value() const {
    return data_->value;
  }
 private:
  internal::MemoryAllocatorDumpCrossProcessUid_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace common
}  // namespace mojo

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo::common::mojom::MemoryAllocatorDumpCrossProcessUidDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo::common::mojom::MemoryAllocatorDumpCrossProcessUidDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::mojo::common::mojom::internal::MemoryAllocatorDumpCrossProcessUid_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    void* custom_context = CustomContextHelper<Traits>::SetUp(input, context);
    (*output).Allocate(buffer);
    (*output)->value = CallWithContext(Traits::value, input, custom_context);
    CustomContextHelper<Traits>::TearDown(input, custom_context);
  }

  static bool Deserialize(::mojo::common::mojom::internal::MemoryAllocatorDumpCrossProcessUid_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo::common::mojom::MemoryAllocatorDumpCrossProcessUidDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo {
namespace common {
namespace mojom {




}  // namespace mojom
}  // namespace common
}  // namespace mojo

#endif  // MOJO_COMMON_MEMORY_ALLOCATOR_DUMP_CROSS_PROCESS_UID_MOJOM_SHARED_H_
