// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_COMMON_PROCESS_ID_MOJOM_SHARED_INTERNAL_H_
#define MOJO_COMMON_PROCESS_ID_MOJOM_SHARED_INTERNAL_H_

#include <stdint.h>

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/cpp/bindings/lib/native_struct_data.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace mojo {
namespace common {
namespace mojom {
namespace internal {
class ProcessId_Data;

#pragma pack(push, 1)
class  ProcessId_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(ProcessId_Data));
      new (data()) ProcessId_Data();
    }

    bool is_null() const { return !buffer_; }
    ProcessId_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<ProcessId_Data>(index_);
    }
    ProcessId_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t pid;
  uint8_t padfinal_[4];

 private:
  ProcessId_Data();
  ~ProcessId_Data() = delete;
};
static_assert(sizeof(ProcessId_Data) == 16,
              "Bad sizeof(ProcessId_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace common
}  // namespace mojo

#endif  // MOJO_COMMON_PROCESS_ID_MOJOM_SHARED_INTERNAL_H_