// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_COMMON_PROCESS_ID_MOJOM_H_
#define MOJO_COMMON_PROCESS_ID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/control_message_proxy.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/native_struct.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/common/process_id.mojom-shared.h"
#include <string>
#include <vector>
#include "base/process/process_handle.h"


namespace mojo {
namespace common {
namespace mojom {
class ProcessId;
using ProcessIdPtr = mojo::InlinedStructPtr<ProcessId>;



class  ProcessId {
 public:
  using DataView = ProcessIdDataView;
  using Data_ = internal::ProcessId_Data;

  template <typename... Args>
  static ProcessIdPtr New(Args&&... args) {
    return ProcessIdPtr(
        base::in_place,
        std::forward<Args>(args)...);
  }

  template <typename U>
  static ProcessIdPtr From(const U& u) {
    return mojo::TypeConverter<ProcessIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProcessId>::Convert(*this);
  }


  ProcessId();

  explicit ProcessId(
      uint32_t pid);

  ~ProcessId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProcessIdPtr>
  ProcessIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, ProcessId>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::StructSerializeImpl<
        ProcessId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::StructSerializeAsMessageImpl<
        ProcessId::DataView>(input);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::StructDeserializeImpl<ProcessId::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ProcessId::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::StructDeserializeImpl<ProcessId::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  uint32_t pid;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};




template <typename StructPtrType>
ProcessIdPtr ProcessId::Clone() const {
  return New(
      mojo::Clone(pid)
  );
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, ProcessId>::value>::type*>
bool ProcessId::Equals(const T& other) const {
  if (!mojo::Equals(this->pid, other.pid))
    return false;
  return true;
}


}  // namespace mojom
}  // namespace common
}  // namespace mojo

namespace mojo {


template <>
struct  StructTraits<::mojo::common::mojom::ProcessId::DataView,
                                         ::mojo::common::mojom::ProcessIdPtr> {
  static bool IsNull(const ::mojo::common::mojom::ProcessIdPtr& input) { return !input; }
  static void SetToNull(::mojo::common::mojom::ProcessIdPtr* output) { output->reset(); }

  static decltype(::mojo::common::mojom::ProcessId::pid) pid(
      const ::mojo::common::mojom::ProcessIdPtr& input) {
    return input->pid;
  }

  static bool Read(::mojo::common::mojom::ProcessId::DataView input, ::mojo::common::mojom::ProcessIdPtr* output);
};

}  // namespace mojo

#endif  // MOJO_COMMON_PROCESS_ID_MOJOM_H_