// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#elif defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable:4056)
#pragma warning(disable:4065)
#pragma warning(disable:4756)
#endif

#include "mojo/common/values.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/logging.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "ipc/ipc_message_utils.h"
#include "mojo/common/values_struct_traits.h"
namespace mojo {
namespace common {
namespace mojom {
ListValue::ListValue()
    : values() {}

ListValue::ListValue(
    std::vector<std::unique_ptr<base::Value>> values_in)
    : values(std::move(values_in)) {}

ListValue::~ListValue() = default;

bool ListValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DictionaryValue::DictionaryValue()
    : values() {}

DictionaryValue::DictionaryValue(
    std::unordered_map<std::string, std::unique_ptr<base::Value>> values_in)
    : values(std::move(values_in)) {}

DictionaryValue::~DictionaryValue() = default;

bool DictionaryValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NullValue::NullValue() {}

NullValue::~NullValue() = default;
size_t NullValue::Hash(size_t seed) const {
  return seed;
}

bool NullValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Value::Value() : tag_(Tag::NULL_VALUE) {
  data_.null_value = new NullValuePtr;
}

Value::~Value() {
  DestroyActive();
}


void Value::set_null_value(
    NullValuePtr null_value) {
  if (tag_ == Tag::NULL_VALUE) {
    *(data_.null_value) = std::move(null_value);
  } else {
    DestroyActive();
    tag_ = Tag::NULL_VALUE;
    data_.null_value = new NullValuePtr(
        std::move(null_value));
  }
}
void Value::set_bool_value(
    bool bool_value) {
  if (tag_ != Tag::BOOL_VALUE) {
    DestroyActive();
    tag_ = Tag::BOOL_VALUE;
  }
  data_.bool_value = bool_value;
}
void Value::set_int_value(
    int32_t int_value) {
  if (tag_ != Tag::INT_VALUE) {
    DestroyActive();
    tag_ = Tag::INT_VALUE;
  }
  data_.int_value = int_value;
}
void Value::set_double_value(
    double double_value) {
  if (tag_ != Tag::DOUBLE_VALUE) {
    DestroyActive();
    tag_ = Tag::DOUBLE_VALUE;
  }
  data_.double_value = double_value;
}
void Value::set_string_value(
    const std::string& string_value) {
  if (tag_ == Tag::STRING_VALUE) {
    *(data_.string_value) = std::move(string_value);
  } else {
    DestroyActive();
    tag_ = Tag::STRING_VALUE;
    data_.string_value = new std::string(
        std::move(string_value));
  }
}
void Value::set_binary_value(
    const std::vector<uint8_t>& binary_value) {
  if (tag_ == Tag::BINARY_VALUE) {
    *(data_.binary_value) = std::move(binary_value);
  } else {
    DestroyActive();
    tag_ = Tag::BINARY_VALUE;
    data_.binary_value = new std::vector<uint8_t>(
        std::move(binary_value));
  }
}
void Value::set_dictionary_value(
    std::unique_ptr<base::DictionaryValue> dictionary_value) {
  if (tag_ == Tag::DICTIONARY_VALUE) {
    *(data_.dictionary_value) = std::move(dictionary_value);
  } else {
    DestroyActive();
    tag_ = Tag::DICTIONARY_VALUE;
    data_.dictionary_value = new std::unique_ptr<base::DictionaryValue>(
        std::move(dictionary_value));
  }
}
void Value::set_list_value(
    std::unique_ptr<base::ListValue> list_value) {
  if (tag_ == Tag::LIST_VALUE) {
    *(data_.list_value) = std::move(list_value);
  } else {
    DestroyActive();
    tag_ = Tag::LIST_VALUE;
    data_.list_value = new std::unique_ptr<base::ListValue>(
        std::move(list_value));
  }
}

void Value::DestroyActive() {
  switch (tag_) {

    case Tag::NULL_VALUE:

      delete data_.null_value;
      break;
    case Tag::BOOL_VALUE:

      break;
    case Tag::INT_VALUE:

      break;
    case Tag::DOUBLE_VALUE:

      break;
    case Tag::STRING_VALUE:

      delete data_.string_value;
      break;
    case Tag::BINARY_VALUE:

      delete data_.binary_value;
      break;
    case Tag::DICTIONARY_VALUE:

      delete data_.dictionary_value;
      break;
    case Tag::LIST_VALUE:

      delete data_.list_value;
      break;
  }
}
}  // namespace mojom
}  // namespace common
}  // namespace mojo

namespace mojo {


// static
bool StructTraits<::mojo::common::mojom::ListValue::DataView, ::mojo::common::mojom::ListValuePtr>::Read(
    ::mojo::common::mojom::ListValue::DataView input,
    ::mojo::common::mojom::ListValuePtr* output) {
  bool success = true;
  ::mojo::common::mojom::ListValuePtr result(::mojo::common::mojom::ListValue::New());
  
      if (!input.ReadValues(&result->values))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojo::common::mojom::DictionaryValue::DataView, ::mojo::common::mojom::DictionaryValuePtr>::Read(
    ::mojo::common::mojom::DictionaryValue::DataView input,
    ::mojo::common::mojom::DictionaryValuePtr* output) {
  bool success = true;
  ::mojo::common::mojom::DictionaryValuePtr result(::mojo::common::mojom::DictionaryValue::New());
  
      if (!input.ReadValues(&result->values))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojo::common::mojom::NullValue::DataView, ::mojo::common::mojom::NullValuePtr>::Read(
    ::mojo::common::mojom::NullValue::DataView input,
    ::mojo::common::mojom::NullValuePtr* output) {
  bool success = true;
  ::mojo::common::mojom::NullValuePtr result(::mojo::common::mojom::NullValue::New());
  
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::mojo::common::mojom::Value::DataView, ::mojo::common::mojom::ValuePtr>::Read(
    ::mojo::common::mojom::Value::DataView input,
    ::mojo::common::mojom::ValuePtr* output) {
  using UnionType = ::mojo::common::mojom::Value;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::NULL_VALUE: {
      ::mojo::common::mojom::NullValuePtr result_null_value;
      if (!input.ReadNullValue(&result_null_value))
        return false;

      *output = UnionType::NewNullValue(
          std::move(result_null_value));
      break;
    }
    case Tag::BOOL_VALUE: {
      *output = UnionType::NewBoolValue(input.bool_value());
      break;
    }
    case Tag::INT_VALUE: {
      *output = UnionType::NewIntValue(input.int_value());
      break;
    }
    case Tag::DOUBLE_VALUE: {
      *output = UnionType::NewDoubleValue(input.double_value());
      break;
    }
    case Tag::STRING_VALUE: {
      std::string result_string_value;
      if (!input.ReadStringValue(&result_string_value))
        return false;

      *output = UnionType::NewStringValue(
          std::move(result_string_value));
      break;
    }
    case Tag::BINARY_VALUE: {
      std::vector<uint8_t> result_binary_value;
      if (!input.ReadBinaryValue(&result_binary_value))
        return false;

      *output = UnionType::NewBinaryValue(
          std::move(result_binary_value));
      break;
    }
    case Tag::DICTIONARY_VALUE: {
      std::unique_ptr<base::DictionaryValue> result_dictionary_value;
      if (!input.ReadDictionaryValue(&result_dictionary_value))
        return false;

      *output = UnionType::NewDictionaryValue(
          std::move(result_dictionary_value));
      break;
    }
    case Tag::LIST_VALUE: {
      std::unique_ptr<base::ListValue> result_list_value;
      if (!input.ReadListValue(&result_list_value))
        return false;

      *output = UnionType::NewListValue(
          std::move(result_list_value));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#elif defined(_MSC_VER)
#pragma warning(pop)
#endif