// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SHARED_INTERNAL_H_
#define MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SHARED_INTERNAL_H_

#include <stdint.h>

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/cpp/bindings/lib/native_struct_data.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/bindings_export.h"

namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace mojo {
namespace pipe_control {
namespace internal {
class RunOrClosePipeMessageParams_Data;
class DisconnectReason_Data;
class PeerAssociatedEndpointClosedEvent_Data;
class RunOrClosePipeInput_Data;

#pragma pack(push, 1)


class MOJO_CPP_BINDINGS_EXPORT RunOrClosePipeInput_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  RunOrClosePipeInput_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~RunOrClosePipeInput_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RunOrClosePipeInput_Data));
      new (data()) RunOrClosePipeInput_Data();
    }

    void AllocateInline(mojo::internal::Buffer* buffer, void* ptr) {
      const char* start = static_cast<const char*>(buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      buffer_ = buffer;
      index_ = slot - start;
      new (data()) RunOrClosePipeInput_Data();
    }

    bool is_null() const { return !buffer_; }
    RunOrClosePipeInput_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RunOrClosePipeInput_Data>(index_);
    }
    RunOrClosePipeInput_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<RunOrClosePipeInput_Tag>(0);
    data.unknown = 0U;
  }

  enum class RunOrClosePipeInput_Tag : uint32_t {

    PEER_ASSOCIATED_ENDPOINT_CLOSED_EVENT,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::PeerAssociatedEndpointClosedEvent_Data> f_peer_associated_endpoint_closed_event;
    uint64_t unknown;
  };

  uint32_t size;
  RunOrClosePipeInput_Tag tag;
  Union_ data;
};
static_assert(sizeof(RunOrClosePipeInput_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(RunOrClosePipeInput_Data)");
class MOJO_CPP_BINDINGS_EXPORT RunOrClosePipeMessageParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(RunOrClosePipeMessageParams_Data));
      new (data()) RunOrClosePipeMessageParams_Data();
    }

    bool is_null() const { return !buffer_; }
    RunOrClosePipeMessageParams_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<RunOrClosePipeMessageParams_Data>(index_);
    }
    RunOrClosePipeMessageParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::RunOrClosePipeInput_Data input;

 private:
  RunOrClosePipeMessageParams_Data();
  ~RunOrClosePipeMessageParams_Data() = delete;
};
static_assert(sizeof(RunOrClosePipeMessageParams_Data) == 24,
              "Bad sizeof(RunOrClosePipeMessageParams_Data)");
class MOJO_CPP_BINDINGS_EXPORT DisconnectReason_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(DisconnectReason_Data));
      new (data()) DisconnectReason_Data();
    }

    bool is_null() const { return !buffer_; }
    DisconnectReason_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<DisconnectReason_Data>(index_);
    }
    DisconnectReason_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t custom_reason;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> description;

 private:
  DisconnectReason_Data();
  ~DisconnectReason_Data() = delete;
};
static_assert(sizeof(DisconnectReason_Data) == 24,
              "Bad sizeof(DisconnectReason_Data)");
class MOJO_CPP_BINDINGS_EXPORT PeerAssociatedEndpointClosedEvent_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(PeerAssociatedEndpointClosedEvent_Data));
      new (data()) PeerAssociatedEndpointClosedEvent_Data();
    }

    bool is_null() const { return !buffer_; }
    PeerAssociatedEndpointClosedEvent_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<PeerAssociatedEndpointClosedEvent_Data>(index_);
    }
    PeerAssociatedEndpointClosedEvent_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::DisconnectReason_Data> disconnect_reason;

 private:
  PeerAssociatedEndpointClosedEvent_Data();
  ~PeerAssociatedEndpointClosedEvent_Data() = delete;
};
static_assert(sizeof(PeerAssociatedEndpointClosedEvent_Data) == 24,
              "Bad sizeof(PeerAssociatedEndpointClosedEvent_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace pipe_control
}  // namespace mojo

#endif  // MOJO_PUBLIC_INTERFACES_BINDINGS_PIPE_CONTROL_MESSAGES_MOJOM_SHARED_INTERNAL_H_