// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_CONSTANTS_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_CONSTANTS_MOJOM_SHARED_INTERNAL_H_

#include <stdint.h>

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/cpp/bindings/lib/native_struct_data.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "services/service_manager/public/interfaces/constants_shared_export.h"

namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace service_manager {
namespace mojom {
namespace internal {
class Constants_UnusedStruct_Internal_Data;

#pragma pack(push, 1)
class SERVICE_MANAGER_MOJOM_CONSTANTS_SHARED_EXPORT Constants_UnusedStruct_Internal_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* buffer) {
      buffer_ = buffer;
      index_ = buffer_->Allocate(sizeof(Constants_UnusedStruct_Internal_Data));
      new (data()) Constants_UnusedStruct_Internal_Data();
    }

    bool is_null() const { return !buffer_; }
    Constants_UnusedStruct_Internal_Data* data() {
      DCHECK(!is_null());
      return buffer_->Get<Constants_UnusedStruct_Internal_Data>(index_);
    }
    Constants_UnusedStruct_Internal_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  Constants_UnusedStruct_Internal_Data();
  ~Constants_UnusedStruct_Internal_Data() = delete;
};
static_assert(sizeof(Constants_UnusedStruct_Internal_Data) == 8,
              "Bad sizeof(Constants_UnusedStruct_Internal_Data)");

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace service_manager

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_INTERFACES_CONSTANTS_MOJOM_SHARED_INTERNAL_H_